/***************************************************************************
                          kasablanca.h  -  description
                             -------------------
    begin                : Die Aug 19 20:54:14 CEST 2003
    copyright            : (C) 2003 by mkulke
    email                : sikor_sxe@radicalapproach.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KASABLANCA_H
#define KASABLANCA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class KbDir;
class KbFile;
class TDEToggleAction;
class KSystemTray;
class TQWidget;
class TQCloseEvent;
class TQLabel;
class TQPixmap;
class FtpSession;
class KbStatusTip;

#include <tdeapplication.h>
#include <tdelistview.h>
#include <tdemainwindow.h>
#include <tdeprocess.h>

#include <tqdir.h>
#include <tqlistview.h>
#include <tqmenubar.h>
#include <tqregexp.h>

#include <list>

#include "kbsiteinfo.h"
#include "kbtransferitem.h"
#include "Q_mainwindow.h"

using namespace std;

/** Kasablanca is the base class of the project */

class Kasablanca : public TDEMainWindow
{
    TQ_OBJECT
public:
	enum RightClickMenu
	{
		Transfer = 1001,
		Queue,
		Delete,
		Rename,
		Mkdir,
		Start,
		Skip,
		Bookmark
	};

	Kasablanca();
	~Kasablanca();

	TQString m_tempdirname;
	TQString m_version;
	list<KbSiteInfo> m_bookmarks;
	KSystemTray* systemTray() const { return mp_systemtray; }
	KbStatusTip* statusTip() const { return mp_statustip; }
	void InitBookmarks();

public slots:
	void SLOT_EditBookmarks();
	void SLOT_ImportBookmarks();
	void SLOT_ItemRightClickedT(TQListViewItem * item, const TQPoint & point, int col );
	void SLOT_SelectionChanged();
	void SLOT_SkipTasks();
	void SLOT_ProcessQueue();
	void SLOT_QueueItems(KbDirInfo *dir, FtpSession* src, FtpSession* dst, bool startqueue);
	void SLOT_NextTransfer(TQListViewItem* item);
	void SLOT_ClearQueue(FtpSession* session);
	void SLOT_LocalProcessExited(TDEProcess* proc) { delete proc; };

private slots:
	void optionsShowToolbar();
	void optionsShowStatusbar();
	void optionsConfigureKeys();
	void optionsConfigureToolbars();
	void optionsPreferences();
	void newToolbarConfig();
	void applyConfig();

private:
	void QueueItemsRecurse(KbDirInfo *dir, FtpSession* src, FtpSession* dst, TQListViewItem* parent = NULL);
	void setupStatusBar();
	void setupMenu();
	void setupGUI();
	void setupActions();
	void saveSettings();
	void ProcessQueue(KbTransferItem* item);
	TQListViewItem* NextTransfer(TQListViewItem* item);
	void QueueFinished();

	KasablancaMainWindow *mp_view;
	TQPopupMenu m_bookmarksmenu_a, m_bookmarksmenu_b;
	TQRegExp m_skiplist;
	TQPopupMenu m_rclickmenu_a, m_rclickmenu_b, m_rclickmenu_t;
	TQLabel *mp_statusline_a, *mp_statusline_b, *mp_encryptionicon_a, *mp_encryptionicon_b;
	TQPixmap m_iconencrypted, m_iconunencrypted;
	TDEToggleAction *m_toolbarAction;
	TDEToggleAction *m_statusbarAction;
	FtpSession *mp_session_a, *mp_session_b;
	list<FtpSession*> *mp_sessionlist;
	bool m_skiplistenabled, m_onqueuefinishedenabled;
	TQString m_onqueuefinished;
	KSystemTray* mp_systemtray;
	KbStatusTip *mp_statustip;
};

#endif
