//
// C++ Implementation: k9cddrive
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9common.h"
#include "k9cddrive.h"
#include "k9config.h"
#include "k9tools.h"

#include <k3bdevice.h>
#include <k3bdevicemanager.h>

#include <tdeprocess.h>
k9CdDrive::k9CdDrive() { 
    canReadDVD=false;
    canWriteCDR=false;
    canWriteDVD=false;
    device="";
    name="";
}
k9CdDrive::~k9CdDrive() {}

k9CdDrives::k9CdDrives():TQObject( 0,0) {
    drives.setAutoDelete(true);
		m_devMgr=new K3bDevice::DeviceManager(this);
    scanDrives();
}
k9CdDrives::~k9CdDrives() {
    delete m_devMgr;
}

/** No descriptions */
void k9CdDrives::scanDrives() {
    drives.clear();

		m_devMgr->scanBus();
		int row=0;
		TQPtrList <K3bDevice::Device> lDev=m_devMgr->allDevices();
		for (K3bDevice::Device *dev=lDev.first();dev;dev=lDev.next()) {
			k9CdDrive *drive=new k9CdDrive;
			drive->device=dev->blockDeviceName();
			drive->name=dev->description();
			drive->canReadDVD=dev->readsDvd();
			drive->canWriteCDR=dev->writesCd();
			drive->canWriteDVD=dev->writesDvd();
			TQValueList <int> writeSpeeds;
			for (int i=2;i <=dev->determineMaximalWriteSpeed()/1385;i+=2)
				writeSpeeds.append( i);
			drive->setWriteSpeeds(writeSpeeds);

			drive->num=row;
			drives.append(drive);
			row++;
			emit deviceAdded(drive);      
		}
      
    readConfig();
}

void k9CdDrives::eject(const TQString & device) {
    TDEProcess *process =new TDEProcess();
    if (k9Tools::checkProgram("tdeeject"))
        *process <<"tdeeject" << device;
    else    
        *process <<"eject" << device;
    process->start();
    process->wait();
    delete process;
}


/** reads devices that was entered manually **/
void k9CdDrives::readConfig() {
    TQStringList ldev;
    TQStringList llabels;
    TQStringList lIO;
    k9Config config;
    ldev=config.getDevices();
    llabels=config.getDevicesLabels();
    lIO=config.getDevicesIO();
    int row=count();
    int i=0;
    for ( TQStringList::Iterator it = ldev.begin(); it != ldev.end(); ++it ) {
        k9CdDrive *drive=new k9CdDrive;
        drive->device=(*it);
        TQStringList::Iterator it2=llabels.at(i);
        TQStringList::Iterator it3=lIO.at(i);
        drive->name=(*it2);
        TQString c=(*it3);
        if (c.contains("I")) {
            drive->canReadDVD=true;
        }
        if (c.contains("O")) {
            drive->canWriteCDR=true;
            drive->canWriteDVD=true;
        }
        drive->num=row;
        drives.append(drive);
        row++;
        i++;
        emit deviceAdded(drive);
    }
}



/** No descriptions */
int k9CdDrives::count() {
    return drives.count();
}

/** No descriptions */
k9CdDrive * k9CdDrives::getDrive(int num) {
    return (k9CdDrive *)drives.at(num);
}


TQValueList< int > k9CdDrive::getWriteSpeeds() const {
    return writeSpeeds;
}


void k9CdDrive::setWriteSpeeds(const TQValueList< int >& _value) {
    writeSpeeds = _value;
}



#include "k9cddrive.moc"
