/*
Gwenview - A simple image viewer for TDE
Copyright 2005 Aurelien Gateau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
// Self
#include "dirviewcontroller.moc"

// TQt
#include <tqpopupmenu.h>

// KDE
#include <kdebug.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <tdelocale.h>
#include <kpropsdlg.h>

// Local
#include <treeview.h>
#include <gvcore/fileoperation.h>


namespace Gwenview {

#undef ENABLE_LOG
#undef LOG
//#define ENABLE_LOG
#ifdef ENABLE_LOG
#define LOG(x) kdDebug() << k_funcinfo << x << endl
#else
#define LOG(x) ;
#endif

struct DirViewController::Private {
	TreeView* mTreeView;
};


DirViewController::DirViewController(TQWidget* parent)
: TQObject(parent)
{
	d=new Private;

	d->mTreeView=new TreeView(parent);

	connect(d->mTreeView, TQ_SIGNAL(selectionChanged(TQListViewItem*)),
		this, TQ_SLOT(slotTreeViewSelectionChanged(TQListViewItem*)) );

	connect(d->mTreeView, TQ_SIGNAL(contextMenu(TDEListView*, TQListViewItem*, const TQPoint&)),
		this, TQ_SLOT(slotTreeViewContextMenu(TDEListView*, TQListViewItem*, const TQPoint&)) );
}


DirViewController::~DirViewController() {
	delete d;
}


TQWidget* DirViewController::widget() const {
	return d->mTreeView;
}


void DirViewController::setURL(const KURL& url) {
	d->mTreeView->setURL(url);
}


void DirViewController::slotTreeViewSelectionChanged(TQListViewItem* item) {
	if (!item) return;
	LOG(d->mTreeView->currentURL());
	emit urlChanged(d->mTreeView->currentURL());
}


void DirViewController::slotTreeViewContextMenu(TDEListView*, TQListViewItem*, const TQPoint& pos) {
	TQPopupMenu menu(d->mTreeView);
	menu.insertItem(SmallIcon("folder-new"),i18n("New Folder..."),this,TQ_SLOT(makeDir()));
	menu.insertSeparator();
	menu.insertItem(i18n("Rename..."),this,TQ_SLOT(renameDir()));
	menu.insertItem(SmallIcon("edit-delete"),i18n("Delete"),this,TQ_SLOT(removeDir()));
	menu.insertSeparator();
	menu.insertItem(i18n("Properties"),this,TQ_SLOT(showPropertiesDialog()));
	
	menu.exec(pos);
}


void DirViewController::makeDir() {
	if (!d->mTreeView->currentItem()) return;
	FileOperation::makeDir(d->mTreeView->currentURL(), d->mTreeView, this, TQ_SLOT(slotDirMade()) );
}


void DirViewController::slotDirMade() {
	if (!d->mTreeView->currentItem()) return;
	d->mTreeView->currentItem()->setOpen(true);
}


void DirViewController::renameDir() {
	if (!d->mTreeView->currentItem()) return;
	FileOperation::rename(d->mTreeView->currentURL(), d->mTreeView);
}


void DirViewController::removeDir() {
	if (!d->mTreeView->currentItem()) return;

	KURL::List list;
	list << d->mTreeView->currentURL();
	FileOperation::del(list, d->mTreeView);
	
	TQListViewItem* item=d->mTreeView->currentItem();
	if (!item) return;
	item=item->parent();
	if (!item) return;
	d->mTreeView->setCurrentItem(item);
}


void DirViewController::showPropertiesDialog() {
	(void)new KPropertiesDialog(d->mTreeView->currentURL(), d->mTreeView);
}

} // namespace
