/***************************************************************************
 *   Copyright (C) 2004, 2005 Andi Peredri                                 *
 *   andi@ukr.net                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <tdeapplication.h>
#include <tdemainwindow.h>

class Cell;
class TQAction;
class TQSound;
class TQLCDNumber;
class TDESelectAction;

class MainWindow : public TDEMainWindow
{
	TQ_OBJECT
  
	public:
		MainWindow(TQWidget *parent=0, const char* name=0, WFlags fl=0);
	protected:
		virtual void closeEvent(TQCloseEvent*);
	private:
		//enum Skill { Novice, Normal, Expert, Master };
		enum BoardSize
		{
			NoviceBoardSize = 5,
			NormalBoardSize = 7,
			ExpertBoardSize = 9,
			MasterBoardSize = 9
		};
		enum
		{
			NumHighscores   = 10,
			MinimumNumCells = 20
		};
		typedef TQValueList<Cell*> CellList;
	public slots:
		void  slotNewGame();
		void  newGame(int);
		
		void  lClicked(int index);
		void  rClicked(int index);
		void  mClicked(int index);
		
		void  showHighscores();
		void  configureHighscores();
		void  configureNotifications();
		
	private:
		Cell* uCell(Cell* cell) const;
		Cell* dCell(Cell* cell) const;
		Cell* lCell(Cell* cell) const;
		Cell* rCell(Cell* cell) const;
		bool  isGameOver();
		bool  startBrowser(const TQString& url);
		bool  updateConnections();
		void  blink(int index);
		void  rotate(int index, bool toleft);
		void  addRandomDir(CellList& list);
		void  dialog(const TQString& caption, const TQString& text);
	private:
		bool        wrapped;
		Cell*       root;
		Cell*       board[MasterBoardSize * MasterBoardSize];
		
		TQSound*     clicksound;
		TQSound*     connectsound;
		TQSound*     startsound;
		TQSound*     turnsound;
		TQSound*     winsound;
		
		TQString     username;
		TQString     soundpath;
		TQAction*    soundaction;
		TQStringList highscores;
		TQLCDNumber* lcd;
		TQPopupMenu* gamemenu;
		TQPopupMenu* skillmenu;

		int m_clickcount;
		TDESelectAction* m_levels;
};

#endif // MAINWINDOW_H
