
#include <kiconloader.h>
#include "listboxlink.h"
#include <tqpainter.h>
#include <tqbitmap.h>
#include "eject.xbm"
#include "lock.xbm"

static TQBitmap eject = TQBitmap( eject_width, eject_height, eject_bits, true );
static TQBitmap locked = TQBitmap( lock_width, lock_height, lock_bits, true );

ListBoxLink::ListBoxLink( const TQString & icon, uint size, const TQString & title, const TQString & url): TQListBoxPixmap(TDEGlobal::iconLoader()->loadIcon(icon, TDEIcon::Desktop, size), title),url_(url),icon_(icon)
{
}

ListBoxLink::ListBoxLink( const TQPixmap & pixmap, const TQString & title, const TQString & url) : TQListBoxPixmap(pixmap, title), url_(url), icon_(0)
{
}

ListBoxLink::ListBoxLink(ListBoxLink & link) : TQListBoxPixmap(*link.pixmap(), link.text()), url_(link.URL()), icon_(link.icon())
{
}

ListBoxLink::~ListBoxLink()
{
}

void ListBoxLink::setURL(const TQString & url)
{
   url_ = url;
}

void ListBoxLink::setIcon(const TQString & icon)
{
   icon_ = icon;
}

int ListBoxLink::height ( const TQListBox * lb ) const
{
   return (TQListBoxPixmap::height ( lb ) + 4);
}

ListBoxDevice::ListBoxDevice(const TQString & icon, uint size, const TQString & title, const TQString & url, const TQString & name, const TQString & mountPoint, bool mounted, bool ejectable, bool removable, int id) : ListBoxLink(icon, size, title, url), name_(name), mountPoint_(mountPoint), mounted_(mounted), ejectable_(ejectable), removable_(removable),id_(id)
{
   if (!eject.mask())
      eject.setMask(eject);
   if (!locked.mask())
      locked.setMask(locked);
}

ListBoxDevice::ListBoxDevice(const TQPixmap & pixmap, const TQString & title, const TQString & url, const TQString & name, const TQString & mountPoint, bool mounted, bool ejectable, bool removable, int id) : ListBoxLink(pixmap, title, url), name_(name), mountPoint_(mountPoint), mounted_(mounted), ejectable_(ejectable), removable_(removable),id_(id)
{
   if (!eject.mask())
      eject.setMask(eject);
   if (!locked.mask())
      locked.setMask(locked);
}

int ListBoxDevice::width ( const TQListBox * lb ) const
{
   if (ejectable_ && mounted_ && lb)
      return lb->width();
   return ListBoxLink::width(lb);
}

void ListBoxDevice::paint( TQPainter * p )
{
   if ((ejectable_ || removable_) && mounted_)
   {
      p->save();
      ListBoxLink::paint(p);
      p->setBrush(isSelected()?listBox()->colorGroup().highlightedText():listBox()->colorGroup().text());
      p->drawPixmap(listBox()->width()-22, 11, ejectable_?eject:locked);
      p->restore();
   }
   else
      ListBoxLink::paint(p);
}
