
#include <unistd.h>
#include <tqstring.h>
#include "core/polkit-tqt-subject.h"

#define TEST_PASSED 0
#define TEST_FAILED 1

using namespace PolkitTQt;

int main(void)
{
  int test_result = TEST_PASSED;

  // Create unix process for current process
  TQ_LONG pid = getpid();
  UnixProcessSubject *process = new UnixProcessSubject(pid);
  if (process->pid() != pid)
  {
    test_result = TEST_FAILED;
  }

  // Serialize and deserialize subject
  Subject subject = Subject::fromString(process->toString());
  if (((UnixProcessSubject*)&subject)->pid() != pid)
  {
    test_result = TEST_FAILED;
  }

  delete process;
  return test_result;
}
