###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### get the system's default path for libraries

tde_save_and_set( CMAKE_INSTALL_PREFIX "/usr" )
include( GNUInstallDirs OPTIONAL )
if( CMAKE_INSTALL_LIBDIR )
  set( SYSTEM_LIBDIR "${CMAKE_INSTALL_LIBDIR}" )
else( )
  set( SYSTEM_LIBDIR "lib${LIB_SUFFIX}" )
endif( )
tde_restore( CMAKE_INSTALL_PREFIX )


##### check for ldap

find_library( HAVE_LIBLDAP ldap )
if( NOT HAVE_LIBLDAP )
  tde_message_fatal( "ldap is required, but was not found on your system" )
endif( NOT HAVE_LIBLDAP )


##### check for krb5

pkg_search_module( KRB5 heimdal-krb5 krb5 )
if( NOT KRB5_FOUND)
  if( NOT DEFINED KRB5_CONFIG_EXECUTABLE )
    find_program( KRB5_CONFIG_EXECUTABLE NAMES krb5-config.heimdal krb5-config )
    if( NOT KRB5_CONFIG_EXECUTABLE )
      tde_message_fatal( "krb5 library is required but not found on your system" )
    endif( )
  endif( )

  execute_process(
    COMMAND ${KRB5_CONFIG_EXECUTABLE} --libs
    OUTPUT_VARIABLE KRB5_LIBRARIES
    ERROR_VARIABLE KRB5_LIBRARIES
    OUTPUT_STRIP_TRAILING_WHITESPACE
    ERROR_STRIP_TRAILING_WHITESPACE
  )
  execute_process(
    COMMAND ${KRB5_CONFIG_EXECUTABLE} --cflags
    OUTPUT_VARIABLE KRB5_INCLUDE_DIRS
    ERROR_VARIABLE KRB5_INCLUDE_DIRS
    OUTPUT_STRIP_TRAILING_WHITESPACE
    ERROR_STRIP_TRAILING_WHITESPACE
  )
  if( NOT "${KRB5_LIBRARIES}" STREQUAL "" )
    set( KRB5_FOUND 1 )
  endif( )
endif( )

find_path( HEIMDAL_INCLUDEDIR
    NAMES krb5_asn1.h
    HINTS ${KRB5_INCLUDE_DIRS} ${KRB5_INCLUDEDIR} /usr/include
    PATH_SUFFIXES "heimdal"
)
if( NOT "${HEIMDAL_INCLUDEDIR}" STREQUAL "${KRB5_INCLUDEDIR}" )
  # fix Heimdal include dirs
  set( KRB5_INCLUDE_DIRS "${HEIMDAL_INCLUDEDIR}" )
endif( )

find_path( HEIMDAL_LIBDIR
    NAMES libhdb.so
    HINTS
      ${KRB5_LIBRARY_DIRS} ${KRB5_LIBDIR}
      /usr/${SYSTEM_LIBDIR} /usr/local/${SYSTEM_LIBDIR}
    PATH_SUFFIXES "heimdal"
)
if( NOT "${HEIMDAL_LIBDIR}" STREQUAL "${KRB5_LIBDIR}" )
  # fix Heimdal library dirs
  set( KRB5_LIBRARY_DIRS "${HEIMDAL_LIBDIR}" )
endif( )

if( "${HEIMDAL_INCLUDEDIR}" STREQUAL "HEIMDAL_INCLUDEDIR-NOTFOUND" OR
    "${HEIMDAL_LIBDIR}" STREQUAL "HEIMDAL_LIBDIR-NOTFOUND" )
    tde_message_fatal( "Heimdal Kerberos is required, but was not found on our system" )
endif( )


# check compiler permissive flag
check_cxx_compiler_flag( -fpermissive HAVE_PERMISSIVE_SUPPORT )
if( HAVE_PERMISSIVE_SUPPORT )
  set( ENABLE_PERMISSIVE_FLAG "-fpermissive" )
endif( )


##### check for tdehwlib

tde_save_and_set( CMAKE_REQUIRED_INCLUDES "${TDE_INCLUDE_DIR}" )
check_cxx_source_compiles( "
  #include <tdemacros.h>
    #ifndef __TDE_HAVE_TDEHWLIB
    #error tdecore is not build with tdehwlib
    #endif
    int main() { return 0; } "
  HAVE_TDEHWLIB
)
tde_restore( CMAKE_REQUIRED_INCLUDES )
if( NOT HAVE_TDEHWLIB )
  tde_message_fatal( "tdehwlib is required, but not built in tdecore" )
endif( NOT HAVE_TDEHWLIB )
set( TDEHW_LIBRARIES "tdehw-shared" )
