/***************************************************************************
                          dlg_login.h  -  description
                             -------------------
    begin                : Sat Sep 29 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_LOGIN_H
#define DLG_LOGIN_H

#include <tqwidget.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqgroupbox.h>

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>

#include "resource.h"

/**
  *@author Troy Corbin Jr. / Alexander Wels
  */

class dlg_login : public KDialogBase
{
   TQ_OBJECT
  

  public:
                          dlg_login(TQWidget *parent, const char *name=0, resource *rsrc = NULL);
                          ~dlg_login();
		void									disableServerSelect();

  public slots:
    void                  slotOk( void );
    void                  slotGuestToggle( bool );
		void									slotUpdateUser(const TQString&);

  signals:
    void                  login(TQString userName, TQString passWord);

  private:
    TQVBox                 *BOX_Parent;
    TQVBox                 *BOX_TEXT;
    TQVBox                 *BOX_EDIT;
		TQHBox									*BOX_ALIGN;
    KLineEdit             *EDIT_Login;
    KLineEdit             *EDIT_Password;
    TQLabel                *TEXT_Login;
    TQLabel                *TEXT_Password;
    TQCheckBox             *CHECKBOX_GUEST;
		TQGroupBox							*GROUP_Select_Server;
		TQGroupBox							*GROUP_Username;
		KComboBox							*COMBO_Select_Server;

    resource 							*myResource;
		struct serverResource *server;
};

#endif
