//
// C++ Interface: kmfiptdoc
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFIPTDOC_H
#define KMFIPTDOC_H

#include "kmfdoc.h"
#include "kmfrulesetdoc.h"

// TQt includes
#include <tqdict.h>
#include <tqvaluelist.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqobject.h>

// kde includes
#include <kurl.h>
#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>

//project includes
#include "iptchain.h"
#include "iptrule.h"
#include "iptruleoption.h"
#include "iptable.h"
#include "netfilterobject.h"

/**
  *@author Christian Hubinger
  */
class KURL;
namespace KMF {
class KMFCompilerInterface;
class KMFErrorHandler;
class KMFError;

class KMFTarget;
/**
@author Christian Hubinger
*/

class TDE_EXPORT KMFIPTDoc : public KMFDoc, public KMFRulesetDoc {
public:
	/** Creates an empty document */
	KMFIPTDoc( NetfilterObject*, const char*, KMFTarget* );
// 	KMFIPTDoc( NetfiletObject*, const char* );
	~KMFIPTDoc();

	/** Compiles the document to an iptables script */
	const TQString& compile();
	
//	/** Writes the shellscrip that contains the iptables commands to settup
//		the firewall to file.
//		If file = TQString() a SaveAs dialog will popup. */
	// KMFError* createFirewallScript( const TQString& file = TQString() );

	/** loads the ruleset defined by the KURL object */
	virtual void parseDocument( const KURL&, TQStringList& errors );
	
	/** Get the File dialog filter string for the document type */	
	virtual const TQString& getFileDialogFilter();
	
	/** loads the ruleset defined by the TQDomDocument object */
	virtual void loadXML( const TQDomDocument&, TQStringList& errors );
	
	/** loads the ruleset defined by the TQDomNode object */
	virtual void loadXML( TQDomNode, TQStringList& errors );

/*	virtual void setDescription( const TQString& ); */
//	virtual void setName( const TQString& );
	
	virtual int type();

	/** Returns true if the document is in it's initial state.
		e.g. no rules, no user chains etc. */
	bool isEmpty();
	
	/** resets the document to the initial values */
	void clear();


	// document get/set options
	/** Set if we use the filter chain */
	void setUseFilter( bool on );
	
	/** Get if we use the filter chain */
	bool useFilter() const {
		return m_use_filter;
	};
	
	/** Set if we use the nat chain */
	void setUseNat( bool on );
	
	/** Get if we use the nat chain */
	bool useNat() const {
		return m_use_nat;
	};
	
	/** Set if we use the mangle chain */
	void setUseMangle( bool on );
	
	/** Get if we use the mangle chain */
	bool useMangle() const {
		return m_use_mangle;
	};
	
	/** Set if ip forwarding e.g. routing should be enabled */
	void setUseIPFwd( bool on );
	
	/** Get if ip forwarding e.g. routing should be enabled */
	bool useIPFwd() const {
		return m_use_ipfwd;
	};
	
	/** Set if the rp_filter should be activated */
	void setUseRPFilter( bool on );
	
	/** Get if the rp_filter should be activated */
	bool useRPFilter() const {
		return m_use_rp_filter;
	};
	
	/** Set if log_martians should be enabled */
	void setUseMartians( bool on );
	
	/** Get if log_martians should be enabled */
	bool useMartians() const {
		return m_use_martians;
	};
	
	/** Set if syn cookies should be enabled */
	void setUseSynCookies( bool on );
	
	/** Get if syn cookies should be enabled */
	bool useSynCookies() const {
		return m_use_syn_cookies;
	};
	
	/** Set if kernel modules need to be loaded */
	void setUseModules( bool on );

	/** Get if we use the filter chain */
	bool useModules() const {
		return m_use_modules;
	};

	/** Returns the IPTable with the given name if it exists */
	IPTable* table( const TQString& table );

	/** Return DomDocument of this Chain */
	const TQDomDocument& getDOMTree();

	
	/** Read the rule option definitions from the XML files in
		(data)/kmyfirewall/ruleoptions/kmfruleoption*.xml */
	void registerRuleOptions();

protected:   // data
	/** Initializes the document with all builtin chains and tables
		unused builtin chains and tables will be skipped when
		compiling the ruleset. */
	void initDoc();
	
	
private:
	IPTable* m_ipt_filter;
	IPTable* m_ipt_nat;
	IPTable* m_ipt_mangle;

	// document options
	bool m_use_filter;
	bool m_use_nat;
	bool m_use_mangle;
	bool m_use_ipfwd;
	bool m_use_rp_filter;
	bool m_use_martians;
	bool m_use_syn_cookies;
	bool m_use_modules;
};
}
#endif
