/******************************************************************************
 *
 * Copyright(c) 2016 - 2018 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#include "halmac_pwr_seq_8822b.h"

#if HALMAC_8822B_SUPPORT

struct halmac_wlan_pwr_cfg TRANS_CARDDIS_TO_CARDEMU_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x004A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4) | BIT(7), 0},
	{0x0300,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x0301,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_ACT_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0012,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0012,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0020,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0001,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 1, HALMAC_PWR_DELAY_MS},
	{0x0000,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, (BIT(4) | BIT(3) | BIT(2)), 0},
	{0x0075,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x0075,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0xFF1A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, (BIT(4) | BIT(3)), 0},
	{0x10C3,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(0), 0},
	{0x0020,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x10A8,
	 HALMAC_PWR_CUT_C_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x10A9,
	 HALMAC_PWR_CUT_C_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xef},
	{0x10AA,
	 HALMAC_PWR_CUT_C_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x0c},
	{0x0068,
	 HALMAC_PWR_CUT_C_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0029,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xF9},
	{0x0024,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), 0},
	{0x0074,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0x00AF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_ACT_TO_CARDEMU_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0003,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), 0},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), 0},
	{0x001F,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x00EF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0xFF1A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x30},
	{0x0049,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x10C3,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(1), 0},
	{0x0020,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), 0},
	{0x0000,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_CARDDIS_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0007,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0067,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), BIT(3)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x004A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0067,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), 0},
	{0x0067,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), 0},
	{0x004F,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0067,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0046,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(6), BIT(6)},
	{0x0067,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), 0},
	{0x0046,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0062,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0081,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_POLLING, BIT(1), 0},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0044,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x0040,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x90},
	{0x0041,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0042,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x04},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

/* Card Enable Array */
struct halmac_wlan_pwr_cfg *card_en_flow_8822b[] = {
	TRANS_CARDDIS_TO_CARDEMU_8822B,
	TRANS_CARDEMU_TO_ACT_8822B,
	NULL
};

/* Card Disable Array */
struct halmac_wlan_pwr_cfg *card_dis_flow_8822b[] = {
	TRANS_ACT_TO_CARDEMU_8822B,
	TRANS_CARDEMU_TO_CARDDIS_8822B,
	NULL
};

#if HALMAC_PLATFORM_TESTPROGRAM

struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_SUS_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4) | BIT(3), (BIT(4) | BIT(3))},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), BIT(3)},
	{0x0007,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), BIT(3) | BIT(4)},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_POLLING, BIT(1), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_SUS_TO_CARDEMU_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(7), 0},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0086,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_PDN_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0007,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK | HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_PDN_TO_CARDEMU_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_ACT_TO_LPS_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x0199,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x019B,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x1138,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0) | BIT(1), BIT(0) | BIT(1)},
	{0x0194,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x42},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0301,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0522,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x05F8,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05F9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FA,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FB,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_US},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0100,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x3F},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0553,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0x0008,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0109,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(7), BIT(7)},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_ACT_TO_DEEP_LPS_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x0199,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x019B,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x1138,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0) | BIT(1), BIT(0) | BIT(1)},
	{0x0194,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x40},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0301,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0522,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x05F8,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05F9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FA,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FB,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_US},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0100,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x3F},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0553,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0x0008,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0109,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(7), BIT(7)},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

struct halmac_wlan_pwr_cfg TRANS_LPS_TO_ACT_8822B[] = {
	/* { offset, cut_msk, interface_msk, base|cmd, msk, value } */
	{0x0080,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_MS},
	{0x0080,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0xFE58,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x84},
	{0xFE58,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x03D9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_MS},
	{0x03D9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_MS},
	{0x0008,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), 0},
	{0x0109,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(7), 0},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0100,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1) | BIT(0), BIT(1) | BIT(0)},
	{0x0522,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x113C,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x03},
	{0x0124,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0125,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0126,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0127,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

/* Suspend Array */
struct halmac_wlan_pwr_cfg *suspend_flow_8822b[] = {
	TRANS_ACT_TO_CARDEMU_8822B,
	TRANS_CARDEMU_TO_SUS_8822B,
	NULL
};

/* Resume Array */
struct halmac_wlan_pwr_cfg *resume_flow_8822b[] = {
	TRANS_SUS_TO_CARDEMU_8822B,
	TRANS_CARDEMU_TO_ACT_8822B,
	NULL
};

/* HWPDN Array - HW behavior */
struct halmac_wlan_pwr_cfg *hwpdn_flow_8822b[] = {
	NULL
};

/* Enter LPS - FW behavior */
struct halmac_wlan_pwr_cfg *enter_lps_flow_8822b[] = {
	TRANS_ACT_TO_LPS_8822B,
	NULL
};

/* Enter Deep LPS - FW behavior */
struct halmac_wlan_pwr_cfg *enter_dlps_flow_8822b[] = {
	TRANS_ACT_TO_DEEP_LPS_8822B,
	NULL
};

/* Leave LPS -FW behavior */
struct halmac_wlan_pwr_cfg *leave_lps_flow_8822b[] = {
	TRANS_LPS_TO_ACT_8822B,
	NULL
};

#endif

#endif /* HALMAC_8822B_SUPPORT*/
