#ifndef _HALMAC_8197F_CFG_H_
#define _HALMAC_8197F_CFG_H_

#include "halmac_8197f_pwr_seq.h"
#include "halmac_api_8197f.h"
#include "halmac_api_8197f_usb.h"
#include "halmac_api_8197f_sdio.h"
#include "halmac_api_8197f_pcie.h"

#if HALMAC_PLATFORM_TESTPROGRAM
#include "halmisc_api_8197f.h"
#include "halmisc_api_8197f_usb.h"
#include "halmisc_api_8197f_sdio.h"
#include "halmisc_api_8197f_pcie.h"
#endif

#define HALMAC_TX_FIFO_SIZE_8197F					262144 /* 64k */
#define HALMAC_RX_FIFO_SIZE_8197F					32768 /* 32k */
#define HALMAC_TX_PAGE_SIZE_8197F					128 /* PageSize 128Byte */
#define HALMAC_SECURITY_CAM_ENTRY_NUM_8197F			64 /* CAM Entry Size */
#define HALMAC_TX_DESC_SIZE_8197F					48
#define HALMAC_RX_DESC_SIZE_8197F					24

/* H2C/C2hH*/
#define HALMAC_H2C_CMD_SIZE_8197F					32

/* Efuse size */
#define HALMAC_EFUSE_SIZE_8197F						512/* 0x2000 */
#define HALMAC_EEPROM_SIZE_8197F					0x300
#define HALMAC_BT_EFUSE_SIZE_8197F					128

/* Rx aggregation parameters */
typedef enum _HALMAC_NORMAL_RXAGG_TH_TO_8197F {
	HALMAC_NORMAL_RXAGG_THRESHOLD_8197F	= 0xFF,
	HALMAC_NORMAL_RXAGG_TIMEOUT_8197F = 0x01,
} HALMAC_NORMAL_RXAGG_TH_TO_8197F;

typedef enum _HALMAC_LOOPBACK_RXAGG_TH_TO_8197F {
	HALMAC_LOOPBACK_RXAGG_THRESHOLD_8197F = 0xFF,
	HALMAC_LOOPBACK_RXAGG_TIMEOUT_8197F = 0x01,
} HALMAC_LOOPBACK_RXAGG_TH_TO_8197F;

/* FIFO size & packet size */
#define HALMAC_BASIC_RXFF_SIZE_8197F			24576 /* 24K */
#define HALMAC_WOWLAN_PATTERN_SIZE_8197F		256

/* Normal mode */
typedef enum _HALMAC_NORMAL_PAGE_NUM_8197F {
	HALMAC_NORMAL_PAGE_NUM_HPQ_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_NPQ_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_LPQ_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_EXPQ_8197F = 0x4A,
	HALMAC_NORMAL_PAGE_NUM_PUBQ_8197F = 0x6C0,
	HALMAC_NORMAL_TX_PAGE_BOUNDARY_8197F = 2032,
} HALMAC_NORMAL_PAGE_NUM_8197F;

/* Loop back mode */
typedef enum _HALMAC_LOOBACK_PAGE_NUM_8197F {
	HALMAC_LOOPBACK_PAGE_NUM_HPQ_8197F = 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_LPQ_8197F = 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_NPQ_8197F = 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_EXPQ_8197F = 0x4A,
	HALMAC_LOOPBACK_PAGE_NUM_PUBQ_8197F = 0x2C0,
	HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_8197F = 1008,
	HALMAC_LOOPBACK_LB_BUF_PAGE_NUM_8197F = 0x600,
} HALMAC_LOOBACK_PAGE_NUM_8197F;


/* Normal mode */
typedef enum _HALMAC_NORMAL_PAGE_NUM_2BULKOUT_8197F {
	HALMAC_NORMAL_PAGE_NUM_HPQ_2BULKOUT_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_NPQ_2BULKOUT_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_LPQ_2BULKOUT_8197F = 0x00,
	HALMAC_NORMAL_PAGE_NUM_EXPQ_2BULKOUT_8197F = 0x00,
	HALMAC_NORMAL_PAGE_NUM_PUBQ_2BULKOUT_8197F = 0x756,
	HALMAC_NORMAL_TX_PAGE_BOUNDARY_2BULKOUT_8197F = 2032,
} HALMAC_NORMAL_PAGE_NUM_2BULKOUT_8197F;

/* Loop back mode */
typedef enum _HALMAC_LOOBACK_PAGE_NUM_2BULKOUT_8197F {
	HALMAC_LOOPBACK_PAGE_NUM_HPQ_2BULKOUT_8197F	= 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_NPQ_2BULKOUT_8197F	= 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_LPQ_2BULKOUT_8197F	= 0x00,
	HALMAC_LOOPBACK_PAGE_NUM_EXPQ_2BULKOUT_8197F = 0x00,
	HALMAC_LOOPBACK_PAGE_NUM_PUBQ_2BULKOUT_8197F = 0x356,
	HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_2BULKOUT_8197F = 1008,
	HALMAC_LOOPBACK_LB_BUF_PAGE_NUM_2BULKOUT_8197F = 0x600,
} HALMAC_LOOBACK_PAGE_NUM_2BULKOUT_8197F;

/* Normal mode */
typedef enum _HALMAC_NORMAL_PAGE_NUM_3BULKOUT_8197F {
	HALMAC_NORMAL_PAGE_NUM_HPQ_3BULKOUT_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_NPQ_3BULKOUT_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_LPQ_3BULKOUT_8197F = 0x4C,
	HALMAC_NORMAL_PAGE_NUM_EXPQ_3BULKOUT_8197F = 0x00,
	HALMAC_NORMAL_PAGE_NUM_PUBQ_3BULKOUT_8197F = 0x70A,
	HALMAC_NORMAL_TX_PAGE_BOUNDARY_3BULKOUT_8197F = 2032,
} HALMAC_NORMAL_PAGE_NUM_3BULKOUT_8197F;

/* Loop back mode */
typedef enum _HALMAC_LOOBACK_PAGE_NUM_3BULKOUT_8197F {
	HALMAC_LOOPBACK_PAGE_NUM_HPQ_3BULKOUT_8197F = 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_NPQ_3BULKOUT_8197F = 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_LPQ_3BULKOUT_8197F = 0x4C,
	HALMAC_LOOPBACK_PAGE_NUM_EXPQ_3BULKOUT_8197F = 0x00,
	HALMAC_LOOPBACK_PAGE_NUM_PUBQ_3BULKOUT_8197F = 0x30A,
	HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_3BULKOUT_8197F = 1008,
	HALMAC_LOOPBACK_LB_BUF_PAGE_NUM_3BULKOUT_8197F = 0x600,
} HALMAC_LOOBACK_PAGE_NUM_3BULKOUT_8197F;


#endif
