/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCloseEvent.h"

#include "CloseEvent.h"
#include "JSDictionary.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCloseEventTableValues[] =
{
    { "wasClean", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCloseEventWasClean), (intptr_t)0, NoIntrinsic },
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCloseEventCode), (intptr_t)0, NoIntrinsic },
    { "reason", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCloseEventReason), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCloseEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCloseEventTable = { 9, 7, JSCloseEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCloseEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCloseEventConstructorTable = { 1, 0, JSCloseEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSCloseEventConstructor::constructJSCloseEvent(ExecState* exec)
{
    JSCloseEventConstructor* jsConstructor = jsCast<JSCloseEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    CloseEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillCloseEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<CloseEvent> event = CloseEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillCloseEventInit(CloseEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("wasClean", eventInit.wasClean))
        return false;
    if (!dictionary.tryGetProperty("code", eventInit.code))
        return false;
    if (!dictionary.tryGetProperty("reason", eventInit.reason))
        return false;
    return true;
}

static const HashTable* getJSCloseEventConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSCloseEventConstructorTable);
}

const ClassInfo JSCloseEventConstructor::s_info = { "CloseEventConstructor", &Base::s_info, 0, getJSCloseEventConstructorTable, CREATE_METHOD_TABLE(JSCloseEventConstructor) };

JSCloseEventConstructor::JSCloseEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCloseEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCloseEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSCloseEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCloseEventConstructor, JSDOMWrapper>(exec, getJSCloseEventConstructorTable(exec), jsCast<JSCloseEventConstructor*>(cell), propertyName, slot);
}

bool JSCloseEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCloseEventConstructor, JSDOMWrapper>(exec, getJSCloseEventConstructorTable(exec), jsCast<JSCloseEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSCloseEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSCloseEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSCloseEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCloseEventPrototypeTable = { 1, 0, JSCloseEventPrototypeTableValues, 0 };
static const HashTable* getJSCloseEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSCloseEventPrototypeTable);
}

const ClassInfo JSCloseEventPrototype::s_info = { "CloseEventPrototype", &Base::s_info, 0, getJSCloseEventPrototypeTable, CREATE_METHOD_TABLE(JSCloseEventPrototype) };

JSObject* JSCloseEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCloseEvent>(exec, globalObject);
}

static const HashTable* getJSCloseEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSCloseEventTable);
}

const ClassInfo JSCloseEvent::s_info = { "CloseEvent", &Base::s_info, 0, getJSCloseEventTable , CREATE_METHOD_TABLE(JSCloseEvent) };

JSCloseEvent::JSCloseEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CloseEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSCloseEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCloseEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCloseEventPrototype::create(exec->globalData(), globalObject, JSCloseEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSCloseEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCloseEvent* thisObject = jsCast<JSCloseEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCloseEvent, Base>(exec, getJSCloseEventTable(exec), thisObject, propertyName, slot);
}

bool JSCloseEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCloseEvent* thisObject = jsCast<JSCloseEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCloseEvent, Base>(exec, getJSCloseEventTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsCloseEventWasClean(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCloseEvent* castedThis = jsCast<JSCloseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CloseEvent* impl = static_cast<CloseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->wasClean());
    return result;
}


JSValue jsCloseEventCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCloseEvent* castedThis = jsCast<JSCloseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CloseEvent* impl = static_cast<CloseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsCloseEventReason(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCloseEvent* castedThis = jsCast<JSCloseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CloseEvent* impl = static_cast<CloseEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->reason());
    return result;
}


JSValue jsCloseEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCloseEvent* domObject = jsCast<JSCloseEvent*>(asObject(slotBase));
    return JSCloseEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSCloseEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCloseEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
