/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(SVG_FONTS)

#include "JSSVGVKernElement.h"

#include "SVGVKernElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGVKernElementTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGVKernElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGVKernElementTable = { 2, 1, JSSVGVKernElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGVKernElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGVKernElementConstructorTable = { 1, 0, JSSVGVKernElementConstructorTableValues, 0 };
const ClassInfo JSSVGVKernElementConstructor::s_info = { "SVGVKernElementConstructor", &Base::s_info, &JSSVGVKernElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGVKernElementConstructor) };

JSSVGVKernElementConstructor::JSSVGVKernElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGVKernElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGVKernElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGVKernElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGVKernElementConstructor, JSDOMWrapper>(exec, &JSSVGVKernElementConstructorTable, jsCast<JSSVGVKernElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGVKernElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGVKernElementConstructor, JSDOMWrapper>(exec, &JSSVGVKernElementConstructorTable, jsCast<JSSVGVKernElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGVKernElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGVKernElementPrototypeTable = { 1, 0, JSSVGVKernElementPrototypeTableValues, 0 };
const ClassInfo JSSVGVKernElementPrototype::s_info = { "SVGVKernElementPrototype", &Base::s_info, &JSSVGVKernElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGVKernElementPrototype) };

JSObject* JSSVGVKernElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGVKernElement>(exec, globalObject);
}

const ClassInfo JSSVGVKernElement::s_info = { "SVGVKernElement", &Base::s_info, &JSSVGVKernElementTable, 0 , CREATE_METHOD_TABLE(JSSVGVKernElement) };

JSSVGVKernElement::JSSVGVKernElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGVKernElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGVKernElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGVKernElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGVKernElementPrototype::create(exec->globalData(), globalObject, JSSVGVKernElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGVKernElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGVKernElement* thisObject = jsCast<JSSVGVKernElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGVKernElement, Base>(exec, &JSSVGVKernElementTable, thisObject, propertyName, slot);
}

bool JSSVGVKernElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGVKernElement* thisObject = jsCast<JSSVGVKernElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGVKernElement, Base>(exec, &JSSVGVKernElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGVKernElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGVKernElement* domObject = jsCast<JSSVGVKernElement*>(asObject(slotBase));
    return JSSVGVKernElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGVKernElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGVKernElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FONTS)
