/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTransform.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGMatrix.h"
#include "SVGMatrix.h"
#include "SVGStaticPropertyWithParentTearOff.h"
#include "SVGTransform.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTransformTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformType), (intptr_t)0, NoIntrinsic },
    { "matrix", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformMatrix), (intptr_t)0, NoIntrinsic },
    { "angle", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformAngle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformTable = { 9, 7, JSSVGTransformTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTransformConstructorTableValues[] =
{
    { "SVG_TRANSFORM_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_MATRIX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_MATRIX), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_TRANSLATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_TRANSLATE), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_SCALE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_SCALE), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_ROTATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_ROTATE), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_SKEWX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_SKEWX), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_SKEWY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_SKEWY), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformConstructorTable = { 18, 15, JSSVGTransformConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGTransform::SVG_TRANSFORM_UNKNOWN, SVGTransformEnumSVG_TRANSFORM_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGTransform::SVG_TRANSFORM_MATRIX, SVGTransformEnumSVG_TRANSFORM_MATRIXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGTransform::SVG_TRANSFORM_TRANSLATE, SVGTransformEnumSVG_TRANSFORM_TRANSLATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGTransform::SVG_TRANSFORM_SCALE, SVGTransformEnumSVG_TRANSFORM_SCALEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGTransform::SVG_TRANSFORM_ROTATE, SVGTransformEnumSVG_TRANSFORM_ROTATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGTransform::SVG_TRANSFORM_SKEWX, SVGTransformEnumSVG_TRANSFORM_SKEWXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == SVGTransform::SVG_TRANSFORM_SKEWY, SVGTransformEnumSVG_TRANSFORM_SKEWYIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGTransformConstructor::s_info = { "SVGTransformConstructor", &Base::s_info, &JSSVGTransformConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTransformConstructor) };

JSSVGTransformConstructor::JSSVGTransformConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTransformConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTransformPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTransformConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTransformConstructor, JSDOMWrapper>(exec, &JSSVGTransformConstructorTable, jsCast<JSSVGTransformConstructor*>(cell), propertyName, slot);
}

bool JSSVGTransformConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTransformConstructor, JSDOMWrapper>(exec, &JSSVGTransformConstructorTable, jsCast<JSSVGTransformConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTransformPrototypeTableValues[] =
{
    { "SVG_TRANSFORM_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_MATRIX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_MATRIX), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_TRANSLATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_TRANSLATE), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_SCALE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_SCALE), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_ROTATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_ROTATE), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_SKEWX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_SKEWX), (intptr_t)0, NoIntrinsic },
    { "SVG_TRANSFORM_SKEWY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformSVG_TRANSFORM_SKEWY), (intptr_t)0, NoIntrinsic },
    { "setMatrix", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetMatrix), (intptr_t)1, NoIntrinsic },
    { "setTranslate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetTranslate), (intptr_t)2, NoIntrinsic },
    { "setScale", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetScale), (intptr_t)2, NoIntrinsic },
    { "setRotate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetRotate), (intptr_t)3, NoIntrinsic },
    { "setSkewX", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetSkewX), (intptr_t)1, NoIntrinsic },
    { "setSkewY", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetSkewY), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformPrototypeTable = { 34, 31, JSSVGTransformPrototypeTableValues, 0 };
const ClassInfo JSSVGTransformPrototype::s_info = { "SVGTransformPrototype", &Base::s_info, &JSSVGTransformPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTransformPrototype) };

JSObject* JSSVGTransformPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTransform>(exec, globalObject);
}

bool JSSVGTransformPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTransformPrototype* thisObject = jsCast<JSSVGTransformPrototype*>(cell);
    return getStaticPropertySlot<JSSVGTransformPrototype, JSObject>(exec, &JSSVGTransformPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGTransformPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTransformPrototype* thisObject = jsCast<JSSVGTransformPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGTransformPrototype, JSObject>(exec, &JSSVGTransformPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGTransform::s_info = { "SVGTransform", &Base::s_info, &JSSVGTransformTable, 0 , CREATE_METHOD_TABLE(JSSVGTransform) };

JSSVGTransform::JSSVGTransform(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPropertyTearOff<SVGTransform> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGTransform::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTransform::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTransformPrototype::create(exec->globalData(), globalObject, JSSVGTransformPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGTransform::destroy(JSC::JSCell* cell)
{
    JSSVGTransform* thisObject = static_cast<JSSVGTransform*>(cell);
    thisObject->JSSVGTransform::~JSSVGTransform();
}

JSSVGTransform::~JSSVGTransform()
{
    releaseImplIfNotNull();
}

bool JSSVGTransform::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTransform* thisObject = jsCast<JSSVGTransform*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTransform, Base>(exec, &JSSVGTransformTable, thisObject, propertyName, slot);
}

bool JSSVGTransform::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTransform* thisObject = jsCast<JSSVGTransform*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTransform, Base>(exec, &JSSVGTransformTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTransformType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTransform& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.type());
    return result;
}


JSValue jsSVGTransformMatrix(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTransform& impl = castedThis->impl()->propertyReference();
    JSValue result =  toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticPropertyWithParentTearOff<SVGTransform, SVGMatrix>::create(castedThis->impl(), impl.svgMatrix(), &SVGTransform::updateMatrix)));
    return result;
}


JSValue jsSVGTransformAngle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTransform& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.angle());
    return result;
}


JSValue jsSVGTransformConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransform* domObject = jsCast<JSSVGTransform*>(asObject(slotBase));
    return JSSVGTransform::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTransform::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTransformConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetMatrix(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransform::s_info);
    SVGPropertyTearOff<SVGTransform> * impl = static_cast<SVGPropertyTearOff<SVGTransform> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGMatrix>* matrix(toSVGMatrix(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!matrix) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    podImpl.setMatrix(matrix->propertyReference());
    impl->commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetTranslate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransform::s_info);
    SVGPropertyTearOff<SVGTransform> * impl = static_cast<SVGPropertyTearOff<SVGTransform> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float tx(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float ty(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    podImpl.setTranslate(tx, ty);
    impl->commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransform::s_info);
    SVGPropertyTearOff<SVGTransform> * impl = static_cast<SVGPropertyTearOff<SVGTransform> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float sx(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    podImpl.setScale(sx, sy);
    impl->commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetRotate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransform::s_info);
    SVGPropertyTearOff<SVGTransform> * impl = static_cast<SVGPropertyTearOff<SVGTransform> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float angle(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cx(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cy(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    podImpl.setRotate(angle, cx, cy);
    impl->commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetSkewX(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransform::s_info);
    SVGPropertyTearOff<SVGTransform> * impl = static_cast<SVGPropertyTearOff<SVGTransform> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float angle(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    podImpl.setSkewX(angle);
    impl->commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetSkewY(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    JSSVGTransform* castedThis = jsCast<JSSVGTransform*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransform::s_info);
    SVGPropertyTearOff<SVGTransform> * impl = static_cast<SVGPropertyTearOff<SVGTransform> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float angle(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    podImpl.setSkewY(angle);
    impl->commitChange();
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsSVGTransformSVG_TRANSFORM_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGTransformSVG_TRANSFORM_MATRIX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGTransformSVG_TRANSFORM_TRANSLATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGTransformSVG_TRANSFORM_SCALE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGTransformSVG_TRANSFORM_ROTATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSVGTransformSVG_TRANSFORM_SKEWX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsSVGTransformSVG_TRANSFORM_SKEWY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

static inline bool isObservable(JSSVGTransform* jsSVGTransform)
{
    if (jsSVGTransform->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGTransformOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGTransform* jsSVGTransform = jsCast<JSSVGTransform*>(handle.get().asCell());
    if (!isObservable(jsSVGTransform))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGTransformOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGTransform* jsSVGTransform = jsCast<JSSVGTransform*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGTransform->impl(), jsSVGTransform);
    jsSVGTransform->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGTransform> * impl)
{
    return wrap<JSSVGTransform, SVGPropertyTearOff<SVGTransform> >(exec, globalObject, impl);
}

SVGPropertyTearOff<SVGTransform> * toSVGTransform(JSC::JSValue value)
{
    return value.inherits(&JSSVGTransform::s_info) ? jsCast<JSSVGTransform*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
