/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEMergeElement.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEMergeElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEMergeElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeElementResult), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEMergeElementTable = { 17, 15, JSSVGFEMergeElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEMergeElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEMergeElementConstructorTable = { 1, 0, JSSVGFEMergeElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEMergeElementConstructor::s_info = { "SVGFEMergeElementConstructor", &Base::s_info, &JSSVGFEMergeElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEMergeElementConstructor) };

JSSVGFEMergeElementConstructor::JSSVGFEMergeElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEMergeElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEMergeElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEMergeElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEMergeElementConstructor, JSDOMWrapper>(exec, &JSSVGFEMergeElementConstructorTable, jsCast<JSSVGFEMergeElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEMergeElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEMergeElementConstructor, JSDOMWrapper>(exec, &JSSVGFEMergeElementConstructorTable, jsCast<JSSVGFEMergeElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEMergeElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEMergeElementPrototypeTable = { 1, 0, JSSVGFEMergeElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEMergeElementPrototype::s_info = { "SVGFEMergeElementPrototype", &Base::s_info, &JSSVGFEMergeElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEMergeElementPrototype) };

JSObject* JSSVGFEMergeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEMergeElement>(exec, globalObject);
}

const ClassInfo JSSVGFEMergeElement::s_info = { "SVGFEMergeElement", &Base::s_info, &JSSVGFEMergeElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEMergeElement) };

JSSVGFEMergeElement::JSSVGFEMergeElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEMergeElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFEMergeElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEMergeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEMergeElementPrototype::create(exec->globalData(), globalObject, JSSVGFEMergeElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEMergeElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEMergeElement* thisObject = jsCast<JSSVGFEMergeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEMergeElement, Base>(exec, &JSSVGFEMergeElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEMergeElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEMergeElement* thisObject = jsCast<JSSVGFEMergeElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEMergeElement, Base>(exec, &JSSVGFEMergeElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEMergeElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeElement* castedThis = jsCast<JSSVGFEMergeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* impl = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEMergeElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeElement* castedThis = jsCast<JSSVGFEMergeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* impl = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEMergeElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeElement* castedThis = jsCast<JSSVGFEMergeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* impl = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEMergeElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeElement* castedThis = jsCast<JSSVGFEMergeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* impl = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEMergeElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeElement* castedThis = jsCast<JSSVGFEMergeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* impl = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEMergeElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeElement* domObject = jsCast<JSSVGFEMergeElement*>(asObject(slotBase));
    return JSSVGFEMergeElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEMergeElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEMergeElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
