/* i386-win32.pe.h
   created from i386-win32.pe.bin, 33516 (0x82ec) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2022 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2022 Laszlo Molnar
   Copyright (C) 2000-2022 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_WIN32_PE_SIZE    33516
#define STUB_I386_WIN32_PE_ADLER32 0xb8637caf
#define STUB_I386_WIN32_PE_CRC32   0x8c9fa994

unsigned char stub_i386_win32_pe[33516] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 188, 32,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,128,124, 36,  8,  1, 15,133,252,255,255,255, 96,
/* 0x0040 */ 190,  0,  0,  0,  0,232,  0,  0,  0,  0, 88,141,176,  3,  0,  0,
/* 0x0050 */   0,141,190,  0,  0,  0,  0,102,255,135,  0,  0,  0,  0,102,129,
/* 0x0060 */ 135,  0,  0,  0,  0,  0,  0,199,135,  0,  0,  0,  0,  0,  0,  0,
/* 0x0070 */   0, 87,131,205,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,
/* 0x0080 */   1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,
/* 0x0090 */ 114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,
/* 0x00a0 */  17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,
/* 0x00b0 */ 255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,219,115,255,
/* 0x00c0 */  49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,
/* 0x00d0 */ 116,255,137,197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x00e0 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,255,
/* 0x00f0 */  65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,
/* 0x0100 */ 117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,115, 48,117,
/* 0x0110 */   9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,193,  2,129,
/* 0x0120 */ 253,  0,243,255,255,131,209,  1,137,242,141, 52, 47,243,164,137,
/* 0x0130 */ 214,233,252,255,255,255,141, 20, 47,131,253,252,118,255,138,  2,
/* 0x0140 */  66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,
/* 0x0150 */   4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,
/* 0x0160 */ 255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,
/* 0x0170 */   7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,114,255,184,
/* 0x0180 */   1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0190 */ 192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 15,  1,219,
/* 0x01a0 */ 115, 11,117, 15,139, 30,131,238,252, 17,219,114, 15, 72,  1,219,
/* 0x01b0 */ 117,  7,139, 30,131,238,252, 17,219, 17,192,235,255, 49,201,131,
/* 0x01c0 */ 232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,
/* 0x01d0 */ 248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x01e0 */  17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,
/* 0x01f0 */ 255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,
/* 0x0200 */ 219,117,  7,139, 30,131,238,252, 17,219,115, 68,  1,219,115, 68,
/* 0x0210 */ 117,  9,139, 30,131,238,252, 17,219,115, 68, 65, 65,131,193,  2,
/* 0x0220 */ 129,253,  0,251,255,255,131,209,  1,137,242,141, 52, 47,243,164,
/* 0x0230 */ 137,214,233,252,255,255,255,141, 20, 47,131,253,252,118,255,138,
/* 0x0240 */   2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,
/* 0x0250 */ 194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,
/* 0x0260 */ 255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,
/* 0x0270 */ 117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,114,255,
/* 0x0280 */ 184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0290 */  17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 30,  1,
/* 0x02a0 */ 219,115, 11,117, 30,139, 30,131,238,252, 17,219,114, 30, 72,  1,
/* 0x02b0 */ 219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,255,  1,219,
/* 0x02c0 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,235,255, 49,201,131,
/* 0x02d0 */ 232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,
/* 0x02e0 */ 248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x02f0 */ 114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,114,190,
/* 0x0300 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,
/* 0x0310 */   7,139, 30,131,238,252, 17,219,115, 81,  1,219,115, 81,117,  9,
/* 0x0320 */ 139, 30,131,238,252, 17,219,115, 81, 65, 65,131,193,  2,129,253,
/* 0x0330 */   0,251,255,255,131,209,  2,137,242,141, 52, 47,243,164,137,214,
/* 0x0340 */ 233,252,255,255,255,141, 20, 47,131,253,252,118,255,138,  2, 66,
/* 0x0350 */ 136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,
/* 0x0360 */ 137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,
/* 0x0370 */ 255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,220,117,
/* 0x0380 */ 251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4, 83,104,  0,
/* 0x0390 */   0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,  0,  0,137,
/* 0x03a0 */ 229,139, 85,  0,172, 74,136,193, 36,  7,192,233,  3,187,  0,253,
/* 0x03b0 */ 255,255,211,227,141,164, 92,144,241,255,255,131,228,224,106,  0,
/* 0x03c0 */ 106,  0,137,227, 83,131,195,  4,139, 77,  0,255, 49, 87, 83,131,
/* 0x03d0 */ 195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,192,233,  4,
/* 0x03e0 */ 136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,131,236,124,139,148,
/* 0x03f0 */  36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,
/* 0x0400 */ 115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,
/* 0x0410 */ 184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,
/* 0x0420 */ 137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,
/* 0x0430 */ 132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,
/* 0x0440 */ 199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,
/* 0x0450 */   3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199,
/* 0x0460 */  68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199,
/* 0x0470 */  68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,
/* 0x0480 */ 136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,
/* 0x0490 */ 199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,  0,
/* 0x04a0 */  49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,152,
/* 0x04b0 */   0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,
/* 0x04c0 */   9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,
/* 0x04d0 */ 126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,
/* 0x04e0 */   9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,139,
/* 0x04f0 */  84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,
/* 0x0500 */ 255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,
/* 0x0510 */   9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x0520 */ 199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,
/* 0x0530 */ 175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,
/* 0x0540 */   8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,
/* 0x0550 */   0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,
/* 0x0560 */ 116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,  0,
/* 0x0570 */  43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,124,
/* 0x0580 */  36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,
/* 0x0590 */ 202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,
/* 0x05a0 */   0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139,
/* 0x05b0 */  76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,
/* 0x05c0 */ 129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,
/* 0x05d0 */ 141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,
/* 0x05e0 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,
/* 0x05f0 */  72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,
/* 0x0600 */ 198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,
/* 0x0610 */ 137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,
/* 0x0620 */   0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,
/* 0x0630 */ 141,114,  1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,102,
/* 0x0640 */ 137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142,
/* 0x0650 */  87,255,255,255,235,121,129,254,255,  0,  0,  0,127,113,141, 20,
/* 0x0660 */  54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,119,
/* 0x0670 */  24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8,
/* 0x0680 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,
/* 0x0690 */   0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137, 68,
/* 0x06a0 */  36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,
/* 0x06b0 */   1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,
/* 0x06c0 */ 114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,139,
/* 0x06d0 */  84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,
/* 0x06e0 */ 136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,199,
/* 0x06f0 */  68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,
/* 0x0700 */   9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36,
/* 0x0710 */  96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36,
/* 0x0720 */  96, 41,193,137,208,102,193,232,  5,102, 41,194,129,249,255,255,
/* 0x0730 */ 255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,116,
/* 0x0740 */  36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,
/* 0x0750 */   3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,200,
/* 0x0760 */ 193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,197,
/* 0x0770 */  57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,
/* 0x0780 */  88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137,
/* 0x0790 */  76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139, 68,
/* 0x07a0 */  36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,
/* 0x07b0 */   6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,
/* 0x07c0 */  96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,193,
/* 0x07d0 */ 232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,102,
/* 0x07e0 */ 137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,
/* 0x07f0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,108,
/* 0x0800 */  36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,183,
/* 0x0810 */ 193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,
/* 0x0820 */   0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,
/* 0x0830 */ 248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,
/* 0x0840 */ 139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,
/* 0x0850 */ 250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,
/* 0x0860 */ 219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x0870 */ 102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,
/* 0x0880 */ 175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,
/* 0x0890 */ 116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,
/* 0x08a0 */ 137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124,
/* 0x08b0 */  36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,
/* 0x08c0 */ 192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36,
/* 0x08d0 */  92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,
/* 0x08e0 */ 116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,  5,
/* 0x08f0 */ 102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,
/* 0x0900 */ 200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,215,
/* 0x0910 */ 129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22, 59,
/* 0x0920 */  92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x0930 */ 230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,139,
/* 0x0940 */ 145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,137,
/* 0x0950 */ 198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,
/* 0x0960 */   4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,
/* 0x0970 */   0,  0,137,241, 41,199, 41,193,137,208,102,193,232,  5,102, 41,
/* 0x0980 */ 194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,144,176,  1,
/* 0x0990 */   0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,
/* 0x09a0 */   3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,200,
/* 0x09b0 */ 193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,197,
/* 0x09c0 */  57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,
/* 0x09d0 */  56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139, 68,
/* 0x09e0 */  36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,193,232,  5,
/* 0x09f0 */ 102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84,
/* 0x0a00 */  36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76,
/* 0x0a10 */  36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,
/* 0x0a20 */ 131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104, 10,
/* 0x0a30 */   0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,
/* 0x0a40 */ 119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,
/* 0x0a50 */ 231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,193,232, 11,
/* 0x0a60 */  15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,
/* 0x0a70 */   8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,
/* 0x0a80 */  44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141,
/* 0x0a90 */  76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,102,
/* 0x0aa0 */ 193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 17,119,
/* 0x0ab0 */  22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,
/* 0x0ac0 */   8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232, 11,
/* 0x0ad0 */  15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,
/* 0x0ae0 */   8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,
/* 0x0af0 */  44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,
/* 0x0b00 */ 141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,
/* 0x0b10 */   0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,102,
/* 0x0b20 */ 193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68,
/* 0x0b30 */  36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,
/* 0x0b40 */ 137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36,
/* 0x0b50 */  40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,255,
/* 0x0b60 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100,
/* 0x0b70 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x0b80 */ 102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,
/* 0x0b90 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x0ba0 */   2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,
/* 0x0bb0 */ 102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116, 36,
/* 0x0bc0 */  40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,
/* 0x0bd0 */   0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84,
/* 0x0be0 */  36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,
/* 0x0bf0 */ 137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,
/* 0x0c00 */ 199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137,
/* 0x0c10 */  68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,
/* 0x0c20 */ 238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,
/* 0x0c30 */ 132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x0c40 */  67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202,
/* 0x0c50 */  15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0,
/* 0x0c60 */  41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21, 41,
/* 0x0c70 */  68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,141, 69,
/* 0x0c80 */   1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,141,
/* 0x0c90 */  80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,
/* 0x0ca0 */ 137,214,209,248,131,230,  1,141, 72,255,131,206,  2,131,250, 13,
/* 0x0cb0 */ 137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,210,137, 52,
/* 0x0cc0 */  36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,
/* 0x0cd0 */ 235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x0ce0 */  92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x0cf0 */   3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36,
/* 0x0d00 */  72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,
/* 0x0d10 */ 120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,
/* 0x0d20 */   4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,
/* 0x0d30 */ 184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,
/* 0x0d40 */ 197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,
/* 0x0d50 */ 132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x0d60 */  67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,
/* 0x0d70 */ 242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0d80 */   0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36,
/* 0x0d90 */  24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,
/* 0x0da0 */  41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9,
/* 0x0db0 */  20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,
/* 0x0dc0 */ 133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,139,
/* 0x0dd0 */  76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,
/* 0x0de0 */ 139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,
/* 0x0df0 */ 160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2,
/* 0x0e00 */  66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,
/* 0x0e10 */ 108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68,
/* 0x0e20 */  36,116, 15,130,187,246,255,255,129,124, 36, 72,255,255,255,  0,
/* 0x0e30 */ 119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,
/* 0x0e40 */   1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,
/* 0x0e50 */ 139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,
/* 0x0e60 */ 168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93, 85, 87, 86,
/* 0x0e70 */  83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,
/* 0x0e80 */   0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141,
/* 0x0e90 */  66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,
/* 0x0ea0 */ 195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224,
/* 0x0eb0 */  72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199,
/* 0x0ec0 */  69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,
/* 0x0ed0 */   0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36,
/* 0x0ee0 */  92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36,
/* 0x0ef0 */  84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,
/* 0x0f00 */   1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115,
/* 0x0f10 */  14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,
/* 0x0f20 */ 156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,
/* 0x0f30 */ 137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59,
/* 0x0f40 */  92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66,
/* 0x0f50 */  67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57,
/* 0x0f60 */  76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,
/* 0x0f70 */ 108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,
/* 0x0f80 */   1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59,
/* 0x0f90 */  92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x0fa0 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,
/* 0x0fb0 */ 232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,
/* 0x0fc0 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,
/* 0x0fd0 */ 248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,
/* 0x0fe0 */ 137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,
/* 0x0ff0 */ 224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,
/* 0x1000 */   0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,
/* 0x1010 */ 137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68,
/* 0x1020 */  36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36,
/* 0x1030 */  64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,
/* 0x1040 */ 129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68,
/* 0x1050 */  77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,
/* 0x1060 */ 132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x1070 */  67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232,
/* 0x1080 */  11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,
/* 0x1090 */   0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,
/* 0x10a0 */ 141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68,
/* 0x10b0 */  36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,
/* 0x10c0 */ 131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,
/* 0x10d0 */ 255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,
/* 0x10e0 */   0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36,
/* 0x10f0 */  72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,
/* 0x1100 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,
/* 0x1110 */  68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198,
/* 0x1120 */  57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,
/* 0x1130 */ 214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36,
/* 0x1140 */  72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,
/* 0x1150 */ 137, 77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,
/* 0x1160 */   0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137,
/* 0x1170 */  84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,
/* 0x1180 */   0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,
/* 0x1190 */   7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36,
/* 0x11a0 */  72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102,
/* 0x11b0 */  41,194,129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,
/* 0x11c0 */ 141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,
/* 0x11d0 */ 241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,
/* 0x11e0 */ 139,108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0,
/* 0x11f0 */  15,183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,
/* 0x1200 */   0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,
/* 0x1210 */   2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,
/* 0x1220 */ 128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88,
/* 0x1230 */  49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,
/* 0x1240 */ 141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199,
/* 0x1250 */  41,198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,
/* 0x1260 */ 254,255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92,
/* 0x1270 */  36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,
/* 0x1280 */   8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,
/* 0x1290 */ 152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,
/* 0x12a0 */   0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,
/* 0x12b0 */   8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,
/* 0x12c0 */ 137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,
/* 0x12d0 */   5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22,
/* 0x12e0 */  59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,
/* 0x12f0 */ 193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,
/* 0x1300 */ 232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,
/* 0x1310 */ 193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,
/* 0x1320 */ 116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,
/* 0x1330 */   0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,
/* 0x1340 */ 139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139,
/* 0x1350 */  68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,
/* 0x1360 */   4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,
/* 0x1370 */ 137,208,102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,
/* 0x1380 */ 233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36,
/* 0x1390 */  56,102, 41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,
/* 0x13a0 */   1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,
/* 0x13b0 */ 182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,
/* 0x13c0 */ 240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,
/* 0x13d0 */ 193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108,
/* 0x13e0 */  36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139,
/* 0x13f0 */  68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,
/* 0x1400 */ 102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,
/* 0x1410 */   0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,
/* 0x1420 */ 161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,
/* 0x1430 */ 139,116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0,
/* 0x1440 */  15,183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,
/* 0x1450 */   0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,
/* 0x1460 */ 200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,
/* 0x1470 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,
/* 0x1480 */ 200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,
/* 0x1490 */ 139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,
/* 0x14a0 */ 137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,
/* 0x14b0 */ 159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,
/* 0x14c0 */ 129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,
/* 0x14d0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,
/* 0x14e0 */  17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,
/* 0x14f0 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,
/* 0x1500 */ 193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,
/* 0x1510 */   1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,
/* 0x1520 */ 198, 41,199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,
/* 0x1530 */ 255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,
/* 0x1540 */   0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,
/* 0x1550 */   2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,
/* 0x1560 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,
/* 0x1570 */ 193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84,
/* 0x1580 */  36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36,
/* 0x1590 */  16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,
/* 0x15a0 */ 208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,
/* 0x15b0 */   0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,
/* 0x15c0 */ 129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,
/* 0x15d0 */   0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,
/* 0x15e0 */ 129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,
/* 0x15f0 */ 209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x1600 */   9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,
/* 0x1610 */ 175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x1620 */ 200,193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68,
/* 0x1630 */  36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,
/* 0x1640 */ 141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76,
/* 0x1650 */  36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,
/* 0x1660 */ 124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68,
/* 0x1670 */  36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,
/* 0x1680 */ 116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,
/* 0x1690 */   6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,
/* 0x16a0 */   0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119,
/* 0x16b0 */  24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8,
/* 0x16c0 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,
/* 0x16d0 */ 193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36,
/* 0x16e0 */  72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x16f0 */   6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,
/* 0x1700 */   5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,
/* 0x1710 */ 108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142,
/* 0x1720 */  39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,
/* 0x1730 */ 131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,
/* 0x1740 */ 211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,
/* 0x1750 */   0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,
/* 0x1760 */ 255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,
/* 0x1770 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36,
/* 0x1780 */  72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1,
/* 0x1790 */  74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,
/* 0x17a0 */   0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68,
/* 0x17b0 */  36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,
/* 0x17c0 */ 192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119,
/* 0x17d0 */  24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8,
/* 0x17e0 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,
/* 0x17f0 */   0,193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68,
/* 0x1800 */  36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,
/* 0x1810 */ 137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,
/* 0x1820 */ 208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,
/* 0x1830 */ 139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28,
/* 0x1840 */  73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,
/* 0x1850 */ 116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2,
/* 0x1860 */  57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43,
/* 0x1870 */  68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,
/* 0x1880 */ 136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172,
/* 0x1890 */  36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,
/* 0x18a0 */ 164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124,
/* 0x18b0 */  36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,
/* 0x18c0 */   0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,
/* 0x18d0 */ 148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,
/* 0x18e0 */ 116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91,
/* 0x18f0 */  94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140, 36,  0,255,
/* 0x1900 */ 255,255,137,236, 80, 57,204,117,251,137,236, 49,201, 94,141,190,
/* 0x1910 */   0,  0,  0,  0,137,247,185,  0,  0,  0,  0,138,  7, 71, 44,232,
/* 0x1920 */  60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,102,193,
/* 0x1930 */ 232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,  1,240,
/* 0x1940 */ 137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,
/* 0x1950 */ 176,233,242,174,117,  6,128, 63,  0,117,255,139,  7,102,193,232,
/* 0x1960 */   8,134,196,193,192, 16,134,196, 41,248,  1,240,171,235,  4,185,
/* 0x1970 */   0,  0,  0,  0,235, 31,138,  7, 71, 60,128,114, 10, 60,143,119,
/* 0x1980 */   6,128,127,254, 15,116,  5, 44,232, 60,  1,119,255,131,249,  4,
/* 0x1990 */ 114,  4,139,  7, 44,  0,117,255,134,196,193,192, 16,134,196, 41,
/* 0x19a0 */ 248,  1,240,131,233,  4,171,131,233,  1,114,  4,138,  7, 71,235,
/* 0x19b0 */  13,131,233,  1,115,  6,141,190,  0,  0,  0,  0,139,  7,  9,192,
/* 0x19c0 */ 116,255,139, 95,  4,141,132, 48,  0,  0,  0,  0,  1,243, 80,131,
/* 0x19d0 */ 199,  8,255,150,  0,  0,  0,  0,149,138,  7, 71,  8,192,116,220,
/* 0x19e0 */ 137,249,121,  6,122, 14,139,  7,131,199,  4,139,132, 48,  0,  0,
/* 0x19f0 */   0,  0,235, 14, 15,183,  7, 71, 80, 71,185, 87, 72,242,174, 85,
/* 0x1a00 */ 255,150,  0,  0,  0,  0,  9,192,116,  7,137,  3,131,195,  4,235,
/* 0x1a10 */  34, 97, 49,192,194, 12,  0,255,150,  0,  0,  0,  0,141,190,  0,
/* 0x1a20 */   0,  0,  0,131,199,  4,141, 94,252, 49,192,138,  7, 71,  9,192,
/* 0x1a30 */ 116,  1, 60,239,119, 17,  1,195,139,  3,134,196,193,192, 16,134,
/* 0x1a40 */ 196,  1,240,137,  3,235,226, 36, 15,193,224, 16,102,139,  7,131,
/* 0x1a50 */ 199,  2,  9,192,117, 12,139,  7,131,199,  4,235, 12,135,247,141,
/* 0x1a60 */ 143,  0,  0,  0,  0,169,102,  1, 12,  7,173,  9,192,117,247,193,
/* 0x1a70 */ 233, 16,169,102,  1, 12,  7,173,  9,192,117,247,139,174,  0,  0,
/* 0x1a80 */   0,  0,141,190,  0,  0,  0,  0,187,  0,  0,  0,  0, 80, 84,106,
/* 0x1a90 */   4, 83, 87,255,213,141,135,  0,  0,  0,  0,128, 32,127,128, 96,
/* 0x1aa0 */  40,127, 88, 80, 84, 80, 83, 87,255,213, 88,141,158,  0,  0,  0,
/* 0x1ab0 */   0,141,187,  1,  0,  0,  0, 87, 49,192,170, 89, 73, 80,106,  1,
/* 0x1ac0 */  83,255,209, 97,141, 68, 36,128,106,  0, 57,196,117,250,131,236,
/* 0x1ad0 */ 128, 49,192, 64,194, 12,  0,233,252,255,255,255,235, 26, 86,190,
/* 0x1ae0 */   0,  0,  0,  0,252,173,133,192,116, 13,106,  3, 89,255,116, 36,
/* 0x1af0 */  16,226,250,255,208,235,238, 94,194, 12,  0, 85, 80, 88, 33,161,
/* 0x1b00 */ 216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,108,101, 32,
/* 0x1b20 */ 102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56,
/* 0x1b30 */  54, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120,
/* 0x1b40 */  32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x1b50 */ 105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32,
/* 0x1b60 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,
/* 0x1b70 */ 101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,
/* 0x1b80 */ 103,115, 10, 32, 32, 48, 32, 80, 69, 73, 83, 68, 76, 76, 49, 32,
/* 0x1b90 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48,
/* 0x1ba0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bb0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1bc0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1bd0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49,
/* 0x1be0 */  32, 80, 69, 77, 65, 73, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x1bf0 */  48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c00 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1c10 */  48, 48, 48, 51,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1c20 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1c30 */  32, 32, 50, 32, 80, 69, 83, 79, 67, 82, 69, 76, 32, 32, 32, 32,
/* 0x1c40 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,
/* 0x1c50 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1c60 */  48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c70 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1c80 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 80, 69,
/* 0x1c90 */  83, 79, 67, 80, 73, 67, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1ca0 */  48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1cb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1cc0 */  52, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1cd0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1ce0 */  78, 76, 89, 10, 32, 32, 52, 32, 80, 69, 83, 79, 85, 78, 67, 48,
/* 0x1cf0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32,
/* 0x1d00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d10 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 49, 32, 32, 50, 42,
/* 0x1d20 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1d30 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1d40 */  53, 32, 80, 69, 73, 67, 79, 78, 83, 49, 32, 32, 32, 32, 32, 32,
/* 0x1d50 */  48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1d70 */  48, 48, 48, 48, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1d80 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1d90 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 80, 69, 73, 67,
/* 0x1da0 */  79, 78, 83, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1db0 */  48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1dc0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53,101,
/* 0x1dd0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1de0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1df0 */  89, 10, 32, 32, 55, 32, 80, 69, 84, 76, 83, 72, 65, 75, 32, 32,
/* 0x1e00 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48,
/* 0x1e10 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  32, 32, 48, 48, 48, 48, 48, 48, 54, 55, 32, 32, 50, 42, 42, 48,
/* 0x1e30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1e40 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32,
/* 0x1e50 */  80, 69, 77, 65, 73, 78, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1e60 */  48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1e80 */  48, 48, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1e90 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1ea0 */  32, 57, 32, 80, 69, 77, 65, 73, 78, 48, 51, 32, 32, 32, 32, 32,
/* 0x1eb0 */  32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ec0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1ed0 */  48, 48, 48, 48, 48, 55, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1ee0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1ef0 */  89, 10, 32, 49, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 32,
/* 0x1f00 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x1f10 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f20 */  32, 32, 48, 48, 48, 48, 48, 48, 55, 53, 32, 32, 50, 42, 42, 48,
/* 0x1f30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1f40 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32,
/* 0x1f50 */  78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1f60 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1f80 */  48, 48, 55, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1f90 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x1fa0 */  68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 50, 66, 70, 65, 83,
/* 0x1fb0 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x1fc0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1fd0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 97, 32, 32,
/* 0x1fe0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1ff0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 50, 66,
/* 0x2000 */  68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56,
/* 0x2030 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2040 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32,
/* 0x2050 */  78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2060 */  48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2070 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2080 */  48, 48, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2090 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x20a0 */  68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 78, 50, 66, 70, 65, 83,
/* 0x20b0 */  50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x20c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 48, 32, 32,
/* 0x20e0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x20f0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2100 */  32, 49, 54, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x2110 */  32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48,
/* 0x2120 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2140 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2150 */  76, 89, 10, 32, 49, 55, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32,
/* 0x2160 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48,
/* 0x2170 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2180 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 52, 32, 32, 50, 42, 42,
/* 0x2190 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x21a0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56,
/* 0x21b0 */  32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x21c0 */  48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x21d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x21e0 */  48, 48, 48, 98, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x21f0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2200 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 78, 50, 66, 68, 69,
/* 0x2210 */  67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,
/* 0x2220 */ 101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2230 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 48, 32,
/* 0x2240 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2250 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2260 */  10, 32, 50, 48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32,
/* 0x2270 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48,
/* 0x2280 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2290 */  32, 48, 48, 48, 48, 48, 48,102,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x22a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x22b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 49, 32, 78,
/* 0x22c0 */  50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x22d0 */  48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x22e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x22f0 */  49, 48, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2300 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2310 */  79, 78, 76, 89, 10, 32, 50, 50, 32, 78, 50, 66, 83, 77, 65, 53,
/* 0x2320 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x2330 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2340 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 97, 32, 32, 50,
/* 0x2350 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2360 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 78, 50, 66, 70,
/* 0x2370 */  65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2380 */  48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2390 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 99,
/* 0x23a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x23b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32, 78,
/* 0x23c0 */  50, 66, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x23d0 */  48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x23e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x23f0 */  49, 49,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2400 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,
/* 0x2410 */  53, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32,
/* 0x2420 */  48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2430 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2440 */  48, 48, 48, 49, 50, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2450 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2460 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 78, 50, 66, 70,
/* 0x2470 */  65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2480 */  49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2490 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 54,
/* 0x24a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x24b0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x24c0 */  89, 10, 32, 50, 55, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32,
/* 0x24d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48,
/* 0x24e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24f0 */  32, 32, 48, 48, 48, 48, 48, 49, 52, 99, 32, 32, 50, 42, 42, 48,
/* 0x2500 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2510 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32,
/* 0x2520 */  78, 50, 66, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2530 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2540 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2550 */  48, 49, 54, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2560 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2570 */  50, 57, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32,
/* 0x2580 */  32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x25a0 */  48, 48, 48, 48, 49, 54, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x25b0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x25c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 78, 50, 68,
/* 0x25d0 */  70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x25e0 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x25f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54,
/* 0x2600 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2610 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2620 */  76, 89, 10, 32, 51, 49, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32,
/* 0x2630 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,
/* 0x2640 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2650 */  48, 32, 32, 48, 48, 48, 48, 48, 49, 54, 55, 32, 32, 50, 42, 42,
/* 0x2660 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2670 */  68, 79, 78, 76, 89, 10, 32, 51, 50, 32, 78, 50, 68, 68, 69, 67,
/* 0x2680 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98,
/* 0x2690 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x26a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54,100, 32, 32,
/* 0x26b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x26c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 78, 50, 68,
/* 0x26d0 */  83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x26e0 */  48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x26f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55,
/* 0x2700 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2710 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2720 */  76, 89, 10, 32, 51, 52, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32,
/* 0x2730 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48,
/* 0x2740 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2750 */  48, 32, 32, 48, 48, 48, 48, 48, 49, 55,100, 32, 32, 50, 42, 42,
/* 0x2760 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2770 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 53,
/* 0x2780 */  32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2790 */  48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x27a0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x27b0 */  48, 48, 49, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x27c0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x27d0 */  32, 51, 54, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32,
/* 0x27e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48,
/* 0x27f0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2800 */  48, 48, 48, 48, 48, 49, 57, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2810 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x2820 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 78, 50,
/* 0x2830 */  68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2840 */  48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2850 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x2860 */  57,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2870 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2880 */  78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x2890 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 50, 32, 32,
/* 0x28a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x28b0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 97,100, 32, 32, 50, 42,
/* 0x28c0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x28d0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x28e0 */  57, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32,
/* 0x28f0 */  48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2900 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2910 */  48, 48, 48, 49,102,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2920 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2930 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 48, 32, 78, 50, 68, 70,
/* 0x2940 */  65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2950 */  48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2960 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 48, 99,
/* 0x2970 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2980 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2990 */  89, 10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32,
/* 0x29a0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x29b0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29c0 */  32, 32, 48, 48, 48, 48, 48, 50, 49, 98, 32, 32, 50, 42, 42, 48,
/* 0x29d0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x29e0 */  79, 78, 76, 89, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x29f0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x2a00 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2a10 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 49,100, 32, 32, 50,
/* 0x2a20 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2a30 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 68, 68,
/* 0x2a40 */  69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2a50 */  48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2a60 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 50, 48,
/* 0x2a70 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2a80 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32, 78,
/* 0x2a90 */  50, 68, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2aa0 */  48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2ab0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2ac0 */  50, 50, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2ad0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2ae0 */  79, 78, 76, 89, 10, 32, 52, 53, 32, 78, 50, 68, 70, 65, 83, 54,
/* 0x2af0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32,
/* 0x2b00 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b10 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 51, 55, 32, 32, 50,
/* 0x2b20 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2b30 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2b40 */  52, 54, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32,
/* 0x2b50 */  32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b60 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2b70 */  48, 48, 48, 48, 50, 52,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2b80 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2b90 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32, 78, 50, 68,
/* 0x2ba0 */  68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2bb0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2bc0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 54,
/* 0x2bd0 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2be0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 56, 32,
/* 0x2bf0 */  78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2c00 */  48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c10 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2c20 */  48, 50, 54, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2c30 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2c40 */  68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 78, 50, 69, 70, 65, 83,
/* 0x2c50 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x2c60 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2c70 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 54, 54, 32, 32,
/* 0x2c80 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2c90 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2ca0 */  32, 53, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32,
/* 0x2cb0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,
/* 0x2cc0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2cd0 */  48, 48, 48, 48, 48, 50, 54, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2ce0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2cf0 */  76, 89, 10, 32, 53, 49, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32,
/* 0x2d00 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48,
/* 0x2d10 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d20 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 54,101, 32, 32, 50, 42, 42,
/* 0x2d30 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2d40 */  68, 79, 78, 76, 89, 10, 32, 53, 50, 32, 78, 50, 69, 83, 77, 65,
/* 0x2d50 */  50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x2d60 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2d70 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 57, 32, 32,
/* 0x2d80 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2d90 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2da0 */  32, 53, 51, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32, 32,
/* 0x2db0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48,
/* 0x2dc0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2dd0 */  48, 48, 48, 48, 48, 50, 55,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2de0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x2df0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78, 50,
/* 0x2e00 */  69, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2e10 */  48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2e20 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,
/* 0x2e30 */  56, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2e40 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53,
/* 0x2e50 */  32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2e60 */  48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e70 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2e80 */  48, 48, 50, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2e90 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2ea0 */  65, 68, 79, 78, 76, 89, 10, 32, 53, 54, 32, 78, 50, 69, 70, 65,
/* 0x2eb0 */  83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ec0 */ 102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2ed0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57,102, 32,
/* 0x2ee0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2ef0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2f00 */  10, 32, 53, 55, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 32, 32,
/* 0x2f10 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 53,102, 32, 32, 48, 48, 48,
/* 0x2f20 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f30 */  32, 48, 48, 48, 48, 48, 50, 97,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x2f40 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2f50 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32, 78,
/* 0x2f60 */  50, 69, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2f70 */  48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f80 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f90 */  51, 48,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2fa0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2fb0 */  79, 78, 76, 89, 10, 32, 53, 57, 32, 78, 50, 69, 70, 65, 83, 52,
/* 0x2fc0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32,
/* 0x2fd0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2fe0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 97, 32, 32, 50,
/* 0x2ff0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3000 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3010 */  54, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32,
/* 0x3020 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x3030 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3040 */  48, 48, 48, 48, 51, 50, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3050 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3060 */  89, 10, 32, 54, 49, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32,
/* 0x3070 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x3080 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3090 */  32, 32, 48, 48, 48, 48, 48, 51, 50, 98, 32, 32, 50, 42, 42, 48,
/* 0x30a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x30b0 */  79, 78, 76, 89, 10, 32, 54, 50, 32, 78, 50, 69, 68, 69, 67, 53,
/* 0x30c0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32,
/* 0x30d0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x30e0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 50,101, 32, 32, 50,
/* 0x30f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3100 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 51, 32, 78, 50, 69, 83,
/* 0x3110 */  77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3120 */  48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x3130 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 51, 55,
/* 0x3140 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3150 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3160 */  89, 10, 32, 54, 52, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32,
/* 0x3170 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48,
/* 0x3180 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3190 */  32, 32, 48, 48, 48, 48, 48, 51, 52, 53, 32, 32, 50, 42, 42, 48,
/* 0x31a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x31b0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 53, 32,
/* 0x31c0 */  78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x31d0 */  48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x31f0 */  48, 51, 53, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3200 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3210 */  68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 78, 50, 69, 68, 69, 67,
/* 0x3220 */  54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3230 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 55, 49, 32, 32,
/* 0x3250 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3260 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 55, 32, 76, 90, 77,
/* 0x3270 */  65, 95, 68, 69, 67, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3280 */  48, 50,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3290 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 55,
/* 0x32a0 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x32b0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x32c0 */  76, 89, 10, 32, 54, 56, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x32d0 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48,
/* 0x32e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x32f0 */  48, 32, 32, 48, 48, 48, 48, 48, 51, 57,102, 32, 32, 50, 42, 42,
/* 0x3300 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3310 */  68, 79, 78, 76, 89, 10, 32, 54, 57, 32, 76, 90, 77, 65, 95, 68,
/* 0x3320 */  69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54,
/* 0x3330 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3340 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,101, 55, 32, 32,
/* 0x3350 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3360 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 48, 32, 76, 90, 77,
/* 0x3370 */  65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3380 */  97, 56, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3390 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 54,
/* 0x33a0 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x33b0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 49, 32,
/* 0x33c0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48,
/* 0x33d0 */  48, 48, 48, 48, 49, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x33f0 */  49, 56,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3400 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3410 */  55, 50, 32, 80, 69, 77, 65, 73, 78, 49, 48, 32, 32, 32, 32, 32,
/* 0x3420 */  32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48,
/* 0x3430 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3440 */  48, 48, 48, 49, 57, 48,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3450 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3460 */  89, 10, 32, 55, 51, 32, 80, 69, 67, 84, 84, 80, 79, 83, 32, 32,
/* 0x3470 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48,
/* 0x3480 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3490 */  32, 32, 48, 48, 48, 48, 49, 57, 48,101, 32, 32, 50, 42, 42, 48,
/* 0x34a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x34b0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32,
/* 0x34c0 */  80, 69, 67, 84, 84, 78, 85, 76, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x34d0 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x34f0 */  49, 57, 49, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3500 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3510 */  55, 53, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32, 32, 32, 32,
/* 0x3520 */  32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48,
/* 0x3530 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3540 */  48, 48, 48, 49, 57, 49, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3550 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x3560 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 54, 32, 67, 84, 67,
/* 0x3570 */  76, 69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3580 */  48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3590 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50,
/* 0x35a0 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x35b0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x35c0 */  76, 89, 10, 32, 55, 55, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32,
/* 0x35d0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,
/* 0x35e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x35f0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 50, 57, 32, 32, 50, 42, 42,
/* 0x3600 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3610 */  68, 79, 78, 76, 89, 10, 32, 55, 56, 32, 67, 84, 66, 83, 72, 82,
/* 0x3620 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x3630 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3640 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50,101, 32, 32,
/* 0x3650 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3660 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 57, 32, 67, 84, 66,
/* 0x3670 */  82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3680 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3690 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 51,
/* 0x36a0 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x36b0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32,
/* 0x36c0 */  67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x36d0 */  48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36e0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x36f0 */  49, 57, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3700 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3710 */  56, 49, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32,
/* 0x3720 */  32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3740 */  48, 48, 48, 49, 57, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3750 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x3760 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 50, 32, 67, 65, 76,
/* 0x3770 */  76, 84, 82, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3780 */  48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3790 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 52,
/* 0x37a0 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x37b0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x37c0 */  76, 89, 10, 32, 56, 51, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32,
/* 0x37d0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,
/* 0x37e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x37f0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 52,101, 32, 32, 50, 42, 42,
/* 0x3800 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3810 */  68, 79, 78, 76, 89, 10, 32, 56, 52, 32, 67, 65, 76, 76, 84, 82,
/* 0x3820 */  69, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3830 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3840 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 53, 48, 32, 32,
/* 0x3850 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3860 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 53, 32, 67, 65, 76,
/* 0x3870 */  76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3880 */  48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3890 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 53,
/* 0x38a0 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x38b0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x38c0 */  76, 89, 10, 32, 56, 54, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32,
/* 0x38d0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,
/* 0x38e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x38f0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 53, 54, 32, 32, 50, 42, 42,
/* 0x3900 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x3910 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 55,
/* 0x3920 */  32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x3930 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3940 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3950 */  48, 49, 57, 53, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3960 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3970 */  32, 56, 56, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32,
/* 0x3980 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48,
/* 0x3990 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x39a0 */  48, 48, 48, 48, 49, 57, 53,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x39b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x39c0 */  76, 89, 10, 32, 56, 57, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32,
/* 0x39d0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,
/* 0x39e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x39f0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 54, 49, 32, 32, 50, 42, 42,
/* 0x3a00 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3a10 */  68, 79, 78, 76, 89, 10, 32, 57, 48, 32, 67, 84, 66, 83, 87, 65,
/* 0x3a20 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x3a30 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3a40 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 54, 51, 32, 32,
/* 0x3a50 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3a60 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 49, 32, 67, 65, 76,
/* 0x3a70 */  76, 84, 82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3a80 */  48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3a90 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 54,
/* 0x3aa0 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3ab0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3ac0 */  76, 89, 10, 32, 57, 50, 32, 99,116,111,107, 51, 50, 46, 48, 48,
/* 0x3ad0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48,
/* 0x3ae0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3af0 */  48, 32, 32, 48, 48, 48, 48, 49, 57, 54,102, 32, 32, 50, 42, 42,
/* 0x3b00 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x3b10 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 51,
/* 0x3b20 */  32, 99,116,111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b40 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3b50 */  48, 49, 57, 55, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3b60 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x3b70 */  65, 68, 79, 78, 76, 89, 10, 32, 57, 52, 32, 99,116,111,107, 51,
/* 0x3b80 */  50, 46, 50, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,
/* 0x3b90 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3ba0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56, 55, 32,
/* 0x3bb0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x3bc0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x3bd0 */  10, 32, 57, 53, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32,
/* 0x3be0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48,
/* 0x3bf0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3c00 */  32, 48, 48, 48, 48, 49, 57, 97, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x3c10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x3c20 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 54, 32, 99,
/* 0x3c30 */ 116,111,107, 51, 50, 46, 52, 48, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3c40 */  48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3c50 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x3c60 */  57, 98, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3c70 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x3c80 */  79, 78, 76, 89, 10, 32, 57, 55, 32, 80, 69, 73, 77, 80, 79, 82,
/* 0x3c90 */  84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 99, 32,
/* 0x3ca0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3cb0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 98, 54, 32, 32, 50,
/* 0x3cc0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x3cd0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3ce0 */  57, 56, 32, 80, 69, 73, 66, 89, 79, 82, 68, 32, 32, 32, 32, 32,
/* 0x3cf0 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x3d00 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3d10 */  48, 48, 48, 49, 57,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3d20 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x3d30 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 57, 32, 80, 69, 75,
/* 0x3d40 */  51, 50, 79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3d50 */  48, 49, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3d60 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,101,
/* 0x3d70 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3d80 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3d90 */  76, 89, 10, 49, 48, 48, 32, 80, 69, 73, 77, 79, 82, 68, 49, 32,
/* 0x3da0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48,
/* 0x3db0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  48, 32, 32, 48, 48, 48, 48, 49, 57,102, 52, 32, 32, 50, 42, 42,
/* 0x3dd0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3de0 */  68, 79, 78, 76, 89, 10, 49, 48, 49, 32, 80, 69, 73, 77, 80, 79,
/* 0x3df0 */  82, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54,
/* 0x3e00 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3e10 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,102, 98, 32, 32,
/* 0x3e20 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3e30 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3e40 */  49, 48, 50, 32, 80, 69, 73, 69, 82, 68, 76, 76, 32, 32, 32, 32,
/* 0x3e50 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,
/* 0x3e60 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3e70 */  48, 48, 48, 48, 49, 97, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3e80 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3e90 */  76, 89, 10, 49, 48, 51, 32, 80, 69, 73, 69, 82, 69, 88, 69, 32,
/* 0x3ea0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,
/* 0x3eb0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ec0 */  48, 32, 32, 48, 48, 48, 48, 49, 97, 49, 55, 32, 32, 50, 42, 42,
/* 0x3ed0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x3ee0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 52,
/* 0x3ef0 */  32, 80, 69, 73, 77, 68, 79, 78, 69, 32, 32, 32, 32, 32, 32, 48,
/* 0x3f00 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f10 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3f20 */  48, 49, 97, 49,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3f30 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3f40 */  49, 48, 53, 32, 80, 69, 82, 69, 76, 79, 67, 49, 32, 32, 32, 32,
/* 0x3f50 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,
/* 0x3f60 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3f70 */  48, 48, 48, 48, 49, 97, 49,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3f80 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x3f90 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 54, 32, 80, 69,
/* 0x3fa0 */  82, 69, 76, 79, 67, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x3fb0 */  48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x3fd0 */  50, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3fe0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 55,
/* 0x3ff0 */  32, 80, 69, 82, 69, 76, 79, 67, 51, 32, 32, 32, 32, 32, 32, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4020 */  48, 49, 97, 50, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4030 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x4040 */  49, 48, 56, 32, 82, 69, 76, 79, 67, 51, 50, 48, 32, 32, 32, 32,
/* 0x4050 */  32, 32, 48, 48, 48, 48, 48, 48, 50, 57, 32, 32, 48, 48, 48, 48,
/* 0x4060 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4070 */  48, 48, 48, 48, 49, 97, 50, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x4080 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x4090 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 57, 32, 82, 69,
/* 0x40a0 */  76, 51, 50, 66, 73, 71, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x40b0 */  48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x40c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,
/* 0x40d0 */  53, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x40e0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x40f0 */  78, 76, 89, 10, 49, 49, 48, 32, 82, 69, 76, 79, 67, 51, 50, 74,
/* 0x4100 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x4110 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4120 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 53, 98, 32, 32, 50, 42,
/* 0x4130 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x4140 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49,
/* 0x4150 */  49, 32, 82, 69, 76, 51, 50, 69, 78, 68, 32, 32, 32, 32, 32, 32,
/* 0x4160 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4180 */  48, 48, 49, 97, 53,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4190 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x41a0 */  10, 49, 49, 50, 32, 80, 69, 82, 76, 79, 72, 73, 48, 32, 32, 32,
/* 0x41b0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48,
/* 0x41c0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x41d0 */  32, 48, 48, 48, 48, 49, 97, 53,100, 32, 32, 50, 42, 42, 48, 32,
/* 0x41e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x41f0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 51, 32, 80,
/* 0x4200 */  69, 82, 69, 76, 76, 79, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4210 */  48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4220 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4230 */  97, 54, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4240 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49,
/* 0x4250 */  52, 32, 80, 69, 82, 69, 76, 72, 73, 48, 32, 32, 32, 32, 32, 32,
/* 0x4260 */  48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4270 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4280 */  48, 48, 49, 97, 54,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4290 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x42a0 */  10, 49, 49, 53, 32, 80, 69, 68, 69, 80, 72, 65, 75, 32, 32, 32,
/* 0x42b0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 50,102, 32, 32, 48, 48, 48,
/* 0x42c0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x42d0 */  32, 48, 48, 48, 48, 49, 97, 55, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x42e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x42f0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 54, 32, 80,
/* 0x4300 */  69, 84, 76, 83, 67, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4310 */  48, 48, 48, 49, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4320 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4330 */  97, 97, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4340 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x4350 */  79, 78, 76, 89, 10, 49, 49, 55, 32, 80, 69, 77, 65, 73, 78, 50,
/* 0x4360 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x4370 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4380 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99, 51, 32, 32, 50,
/* 0x4390 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x43a0 */  69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 56, 32, 67, 76, 69, 65,
/* 0x43b0 */  82, 83, 84, 65, 67, 75, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x43c0 */  48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x43d0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 99, 52,
/* 0x43e0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x43f0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 57, 32, 80,
/* 0x4400 */  69, 77, 65, 73, 78, 50, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4410 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4420 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4430 */  97,100, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4440 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50,
/* 0x4450 */  48, 32, 80, 69, 82, 69, 84, 85, 82, 78, 32, 32, 32, 32, 32, 32,
/* 0x4460 */  48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x4470 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4480 */  48, 48, 49, 97,100, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4490 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x44a0 */  10, 49, 50, 49, 32, 80, 69, 68, 79, 74, 85, 77, 80, 32, 32, 32,
/* 0x44b0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48,
/* 0x44c0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x44d0 */  32, 48, 48, 48, 48, 49, 97,100, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x44e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x44f0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 50, 50, 32, 80,
/* 0x4500 */  69, 84, 76, 83, 67, 50, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4510 */  48, 48, 48, 49,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4520 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x4530 */  97,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4540 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x4550 */  79, 78, 76, 89, 10, 49, 50, 51, 32, 85, 80, 88, 49, 72, 69, 65,
/* 0x4560 */  68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 48, 32,
/* 0x4570 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x4580 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97,102, 98, 32, 32, 50,
/* 0x4590 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x45a0 */  69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84,
/* 0x45b0 */  65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x45c0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48,  9,
/* 0x45d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 49,
/* 0x45e0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x45f0 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48,
/* 0x4600 */  48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 48, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4620 */  50, 66, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4630 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,
/* 0x4650 */  67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x4660 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4670 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,  9,
/* 0x4680 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 51,
/* 0x4690 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x46a0 */ 100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48,
/* 0x46b0 */  48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x46d0 */  50, 66, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46e0 */  32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x46f0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,
/* 0x4700 */  67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66,
/* 0x4710 */  68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4720 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48,  9,
/* 0x4730 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 49,
/* 0x4740 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4750 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48,
/* 0x4760 */  48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48,
/* 0x4770 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4780 */  50, 68, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4790 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x47a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,
/* 0x47b0 */  67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x47c0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x47d0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,  9,
/* 0x47e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 51,
/* 0x47f0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4800 */ 100, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48,
/* 0x4810 */  48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48, 48,
/* 0x4820 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4830 */  50, 68, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4840 */  32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,
/* 0x4860 */  67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68,
/* 0x4870 */  68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4880 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48,  9,
/* 0x4890 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 49,
/* 0x48a0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x48b0 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48,
/* 0x48c0 */  48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 48, 48,
/* 0x48d0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x48e0 */  50, 69, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48f0 */  32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4900 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,
/* 0x4910 */  67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x4920 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4930 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,  9,
/* 0x4940 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x4950 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4960 */ 100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48,
/* 0x4970 */  48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48,
/* 0x4980 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4990 */  50, 69, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49a0 */  32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x49b0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,
/* 0x49c0 */  67, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69,
/* 0x49d0 */  68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x49e0 */  32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,  9,
/* 0x49f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x4a00 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4a10 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48, 48,
/* 0x4a20 */  48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48,
/* 0x4a30 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x4a40 */  65, 76, 76, 84, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a50 */  32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a60 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x4a70 */  82, 49, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,
/* 0x4a80 */  76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4a90 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48,
/* 0x4aa0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50,
/* 0x4ab0 */  46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4ac0 */  32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48,  9, 48,
/* 0x4ad0 */  48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x4ae0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4af0 */ 100, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,  9, 48, 48, 48,
/* 0x4b00 */  48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10,
/* 0x4b10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4b20 */  32, 99,116,111,107, 51, 50, 46, 52, 48,  9, 48, 48, 48, 48, 48,
/* 0x4b30 */  48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48,
/* 0x4b40 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x4b50 */  69, 73, 77, 80, 79, 82, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b60 */  32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 48, 48, 48, 48, 48, 48,
/* 0x4b70 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 79,
/* 0x4b80 */  82, 68, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73,
/* 0x4b90 */  77, 79, 82, 68, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4ba0 */  32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 80, 79, 82, 50,  9,
/* 0x4bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 80, 79, 82,
/* 0x4bc0 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4bd0 */ 100, 32, 32, 80, 69, 73, 77, 68, 79, 78, 69,  9, 48, 48, 48, 48,
/* 0x4be0 */  48, 48, 48, 48, 32, 80, 69, 73, 77, 68, 79, 78, 69, 10, 48, 48,
/* 0x4bf0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82,
/* 0x4c00 */  69, 76, 79, 67, 51, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c10 */  32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4c20 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79, 67,
/* 0x4c30 */  51, 50, 74,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 69, 76,
/* 0x4c40 */  79, 67, 51, 50, 74, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4c50 */  32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49,  9,
/* 0x4c60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 50,
/* 0x4c70 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4c80 */ 100, 32, 32, 80, 69, 84, 76, 83, 67, 50,  9, 48, 48, 48, 48, 48,
/* 0x4c90 */  48, 48, 48, 32, 80, 69, 84, 76, 83, 67, 50, 10, 48, 48, 48, 48,
/* 0x4ca0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73,
/* 0x4cb0 */  83, 68, 76, 76, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80,
/* 0x4cc0 */  69, 73, 83, 68, 76, 76, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4cd0 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48,
/* 0x4ce0 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73,
/* 0x4cf0 */  78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4d00 */  32, 32,100, 32, 32, 80, 69, 83, 79, 67, 82, 69, 76,  9, 48, 48,
/* 0x4d10 */  48, 48, 48, 48, 48, 48, 32, 80, 69, 83, 79, 67, 82, 69, 76, 10,
/* 0x4d20 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4d30 */  32, 80, 69, 83, 79, 67, 80, 73, 67,  9, 48, 48, 48, 48, 48, 48,
/* 0x4d40 */  48, 48, 32, 80, 69, 83, 79, 67, 80, 73, 67, 10, 48, 48, 48, 48,
/* 0x4d50 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 83,
/* 0x4d60 */  79, 85, 78, 67, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80,
/* 0x4d70 */  69, 83, 79, 85, 78, 67, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d80 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78, 83,
/* 0x4d90 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 67, 79,
/* 0x4da0 */  78, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4db0 */  32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78, 83, 50,  9, 48, 48,
/* 0x4dc0 */  48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 67, 79, 78, 83, 50, 10,
/* 0x4dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4de0 */  32, 80, 69, 84, 76, 83, 72, 65, 75,  9, 48, 48, 48, 48, 48, 48,
/* 0x4df0 */  48, 48, 32, 80, 69, 84, 76, 83, 72, 65, 75, 10, 48, 48, 48, 48,
/* 0x4e00 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77,
/* 0x4e10 */  65, 73, 78, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80,
/* 0x4e20 */  69, 77, 65, 73, 78, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e30 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48,
/* 0x4e40 */  51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73,
/* 0x4e50 */  78, 48, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4e60 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 48,  9, 48, 48,
/* 0x4e70 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48, 10,
/* 0x4e80 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4e90 */  32, 78, 50, 66, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x4ea0 */  48, 48, 32, 78, 50, 66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48,
/* 0x4eb0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x4ec0 */  70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x4ed0 */  50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ee0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 51,
/* 0x4ef0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77,
/* 0x4f00 */  65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4f10 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 51, 48,  9, 48, 48,
/* 0x4f20 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 10,
/* 0x4f30 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4f40 */  32, 78, 50, 66, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x4f50 */  48, 48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48,
/* 0x4f60 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x4f70 */  70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x4f80 */  50, 66, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f90 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 53,
/* 0x4fa0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77,
/* 0x4fb0 */  65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4fc0 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48,  9, 48, 48,
/* 0x4fd0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 53, 48, 10,
/* 0x4fe0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4ff0 */  32, 78, 50, 66, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5000 */  48, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48,
/* 0x5010 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x5020 */  70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5030 */  50, 66, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5040 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x5050 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65,
/* 0x5060 */  83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5070 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50, 48,  9, 48, 48,
/* 0x5080 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10,
/* 0x5090 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x50a0 */  32, 78, 50, 68, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x50b0 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48,
/* 0x50c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x50d0 */  83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x50e0 */  50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x50f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x5100 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65,
/* 0x5110 */  83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5120 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 52, 48,  9, 48, 48,
/* 0x5130 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48, 10,
/* 0x5140 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5150 */  32, 78, 50, 68, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5160 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48,
/* 0x5170 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x5180 */  83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5190 */  50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x51a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x51b0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65,
/* 0x51c0 */  83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x51d0 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 54, 48,  9, 48, 48,
/* 0x51e0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 54, 48, 10,
/* 0x51f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5200 */  32, 78, 50, 68, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5210 */  48, 48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48,
/* 0x5220 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x5230 */  70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x5240 */  50, 69, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5250 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 50,
/* 0x5260 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x5270 */  65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5280 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48,  9, 48, 48,
/* 0x5290 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 50, 48, 10,
/* 0x52a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x52b0 */  32, 78, 50, 69, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x52c0 */  48, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48,
/* 0x52d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x52e0 */  70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x52f0 */  50, 69, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5300 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52,
/* 0x5310 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x5320 */  65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5330 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52, 48,  9, 48, 48,
/* 0x5340 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10,
/* 0x5350 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5360 */  32, 78, 50, 69, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5370 */  48, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48,
/* 0x5380 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x5390 */  70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x53a0 */  50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x53b0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54,
/* 0x53c0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77,
/* 0x53d0 */  65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x53e0 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 48,  9, 48, 48,
/* 0x53f0 */  48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48, 10,
/* 0x5400 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5410 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,  9, 48, 48, 48, 48,
/* 0x5420 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10,
/* 0x5430 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5440 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,
/* 0x5450 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x5460 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5470 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x5480 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x5490 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x54a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,
/* 0x54b0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x54c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x54d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,
/* 0x54e0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10,
/* 0x54f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5500 */  32, 80, 69, 77, 65, 73, 78, 49, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x5510 */  48, 48, 32, 80, 69, 77, 65, 73, 78, 49, 48, 10, 48, 48, 48, 48,
/* 0x5520 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 67,
/* 0x5530 */  84, 84, 80, 79, 83,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80,
/* 0x5540 */  69, 67, 84, 84, 80, 79, 83, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5550 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 67, 84, 84, 78, 85,
/* 0x5560 */  76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 67, 84, 84,
/* 0x5570 */  78, 85, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5580 */  32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49,  9, 48, 48,
/* 0x5590 */  48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69, 49, 10,
/* 0x55a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x55b0 */  32, 67, 65, 76, 76, 84, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48,
/* 0x55c0 */  48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48, 48, 48, 48,
/* 0x55d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x55e0 */  83, 72, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x55f0 */  84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5600 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 48,
/* 0x5610 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 82, 79,
/* 0x5620 */  82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5630 */  32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49,  9, 48, 48,
/* 0x5640 */  48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 48, 49, 10,
/* 0x5650 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5660 */  32, 67, 65, 76, 76, 84, 82, 48, 50,  9, 48, 48, 48, 48, 48, 48,
/* 0x5670 */  48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48, 48, 48,
/* 0x5680 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76,
/* 0x5690 */  76, 84, 82, 69, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x56a0 */  65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x56b0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69,
/* 0x56c0 */  57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84,
/* 0x56d0 */  82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x56e0 */  32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50,  9, 48, 48,
/* 0x56f0 */  48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69, 50, 10,
/* 0x5700 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x5710 */  32, 67, 65, 76, 76, 84, 82, 49, 50,  9, 48, 48, 48, 48, 48, 48,
/* 0x5720 */  48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10, 48, 48, 48, 48,
/* 0x5730 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x5740 */  83, 72, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67,
/* 0x5750 */  84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5760 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 49,
/* 0x5770 */  49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 82, 79,
/* 0x5780 */  82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x5790 */  32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 49, 49,  9, 48, 48,
/* 0x57a0 */  48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49, 10,
/* 0x57b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x57c0 */  32, 99,116,111,107, 51, 50, 46, 51, 48,  9, 48, 48, 48, 48, 48,
/* 0x57d0 */  48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10, 48, 48,
/* 0x57e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x57f0 */  69, 73, 66, 89, 79, 82, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5800 */  32, 80, 69, 73, 66, 89, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x5810 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 75, 51, 50,
/* 0x5820 */  79, 82, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 75,
/* 0x5830 */  51, 50, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5840 */  32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 68, 76, 76,  9,
/* 0x5850 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 69, 82, 68, 76,
/* 0x5860 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x5870 */ 100, 32, 32, 80, 69, 73, 69, 82, 69, 88, 69,  9, 48, 48, 48, 48,
/* 0x5880 */  48, 48, 48, 48, 32, 80, 69, 73, 69, 82, 69, 88, 69, 10, 48, 48,
/* 0x5890 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x58a0 */  69, 82, 69, 76, 79, 67, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x58b0 */  32, 80, 69, 82, 69, 76, 79, 67, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x58c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76,
/* 0x58d0 */  79, 67, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82,
/* 0x58e0 */  69, 76, 79, 67, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x58f0 */  32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 51,  9,
/* 0x5900 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 79, 67,
/* 0x5910 */  51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x5920 */ 100, 32, 32, 82, 69, 76, 51, 50, 66, 73, 71,  9, 48, 48, 48, 48,
/* 0x5930 */  48, 48, 48, 48, 32, 82, 69, 76, 51, 50, 66, 73, 71, 10, 48, 48,
/* 0x5940 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82,
/* 0x5950 */  69, 76, 51, 50, 69, 78, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5960 */  32, 82, 69, 76, 51, 50, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x5970 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 76, 79,
/* 0x5980 */  72, 73, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82,
/* 0x5990 */  76, 79, 72, 73, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x59a0 */  32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 76, 79, 48,  9,
/* 0x59b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 76, 79,
/* 0x59c0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x59d0 */ 100, 32, 32, 80, 69, 82, 69, 76, 72, 73, 48,  9, 48, 48, 48, 48,
/* 0x59e0 */  48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 72, 73, 48, 10, 48, 48,
/* 0x59f0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x5a00 */  69, 68, 69, 80, 72, 65, 75,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5a10 */  32, 80, 69, 68, 69, 80, 72, 65, 75, 10, 48, 48, 48, 48, 48, 48,
/* 0x5a20 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83,
/* 0x5a30 */  67,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 84, 76, 83,
/* 0x5a40 */  67, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x5a50 */ 100, 32, 32, 80, 69, 77, 65, 73, 78, 50, 48,  9, 48, 48, 48, 48,
/* 0x5a60 */  48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 50, 48, 10, 48, 48,
/* 0x5a70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x5a80 */  76, 69, 65, 82, 83, 84, 65, 67, 75,  9, 48, 48, 48, 48, 48, 48,
/* 0x5a90 */  48, 48, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 10, 48, 48,
/* 0x5aa0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x5ab0 */  69, 82, 69, 84, 85, 82, 78,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5ac0 */  32, 80, 69, 82, 69, 84, 85, 82, 78, 10, 48, 48, 48, 48, 48, 48,
/* 0x5ad0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 68, 79, 74,
/* 0x5ae0 */  85, 77, 80,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 68,
/* 0x5af0 */  79, 74, 85, 77, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5b00 */  32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9,
/* 0x5b10 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65,
/* 0x5b20 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5b30 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5b40 */  48, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,
/* 0x5b50 */ 101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5b60 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5b70 */  48, 48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,102, 95,117,
/* 0x5b80 */ 110, 99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48,
/* 0x5b90 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5ba0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,105, 99,111,110,
/* 0x5bb0 */  95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5bc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x5bd0 */  48, 48, 48, 48, 48, 48, 48, 32,105, 99,111,110, 95,100,101,108,
/* 0x5be0 */ 116, 97, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5bf0 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x5c00 */  48, 48, 32,116,108,115, 95, 97,100,100,114,101,115,115, 10, 48,
/* 0x5c10 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c20 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,
/* 0x5c30 */ 108,115, 95,118, 97,108,117,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5c40 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5c50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116,
/* 0x5c60 */  97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48,
/* 0x5c70 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5c80 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,
/* 0x5c90 */ 117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5ca0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5cb0 */  48, 48, 48, 48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110,
/* 0x5cc0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5cd0 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5ce0 */  32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115,
/* 0x5cf0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d00 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5d10 */  32,102,105,108,116,101,114, 95, 98,117,102,102,101,114, 95,115,
/* 0x5d20 */ 116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x5d30 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x5d40 */  48, 48, 48, 48, 32,102,105,108,116,101,114, 95,108,101,110,103,
/* 0x5d50 */ 116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5d60 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x5d70 */  48, 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48,
/* 0x5d80 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5d90 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,
/* 0x5da0 */ 109,112,114,101,115,115,101,100, 95,105,109,112,111,114,116,115,
/* 0x5db0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5dc0 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5dd0 */  32,115,116, 97,114,116, 95,111,102, 95,105,109,112,111,114,116,
/* 0x5de0 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5df0 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5e00 */  48, 32, 76,111, 97,100, 76,105, 98,114, 97,114,121, 65, 10, 48,
/* 0x5e10 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e20 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,107,
/* 0x5e30 */ 101,114,110,101,108, 51, 50, 95,111,114,100,105,110, 97,108,115,
/* 0x5e40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e50 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5e60 */  32, 71,101,116, 80,114,111, 99, 65,100,100,114,101,115,115, 10,
/* 0x5e70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e80 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5e90 */  69,120,105,116, 80,114,111, 99,101,115,115, 10, 48, 48, 48, 48,
/* 0x5ea0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5eb0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,
/* 0x5ec0 */ 116, 95,111,102, 95,114,101,108,111, 99,115, 10, 48, 48, 48, 48,
/* 0x5ed0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5ee0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,108,111,
/* 0x5ef0 */  99, 95,100,101,108,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5f00 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x5f10 */  48, 48, 48, 48, 48, 48, 32, 86,105,114,116,117, 97,108, 80,114,
/* 0x5f20 */ 111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5f30 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5f40 */  48, 48, 48, 48, 48, 32,118,112, 95, 98, 97,115,101, 10, 48, 48,
/* 0x5f50 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x5f60 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,118,112,
/* 0x5f70 */  95,115,105,122,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5f80 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5f90 */  48, 48, 48, 48, 48, 32,115,119,114,105, 10, 48, 48, 48, 48, 48,
/* 0x5fa0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5fb0 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95,109,
/* 0x5fc0 */ 111,100,117,108,101, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48,
/* 0x5fd0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5fe0 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,105,
/* 0x5ff0 */ 110, 97,108, 95,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48,
/* 0x6000 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x6010 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95, 99, 97,
/* 0x6020 */ 108,108, 98, 97, 99,107,115, 95,112,116,114, 10, 10, 82, 69, 76,
/* 0x6030 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6040 */  70, 79, 82, 32, 91, 80, 69, 73, 83, 68, 76, 76, 49, 93, 58, 10,
/* 0x6050 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6060 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6070 */  10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95,
/* 0x6080 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 77, 65,
/* 0x6090 */  73, 78, 50, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x60a0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x60b0 */  83, 79, 67, 82, 69, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x60c0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x60d0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x60e0 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x60f0 */  32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,
/* 0x6100 */ 109,112,114,101,115,115,101,100, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6110 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6120 */  32, 91, 80, 69, 83, 79, 67, 80, 73, 67, 93, 58, 10, 79, 70, 70,
/* 0x6130 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6140 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6150 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x6160 */  50, 32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,
/* 0x6170 */ 102, 95, 99,111,109,112,114,101,115,115,101,100, 10, 10, 82, 69,
/* 0x6180 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6190 */  32, 70, 79, 82, 32, 91, 80, 69, 83, 79, 85, 78, 67, 48, 93, 58,
/* 0x61a0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x61b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x61c0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,
/* 0x61d0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,
/* 0x61e0 */ 114,116, 95,111,102, 95,117,110, 99,111,109,112,114,101,115,115,
/* 0x61f0 */ 101,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6200 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 67,
/* 0x6210 */  79, 78, 83, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6220 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6230 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x6240 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6250 */  32, 32, 32,105, 99,111,110, 95,111,102,102,115,101,116, 10, 10,
/* 0x6260 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6270 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 67, 79, 78, 83, 50,
/* 0x6280 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6290 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x62a0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x62b0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,105,
/* 0x62c0 */  99,111,110, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48,
/* 0x62d0 */  48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32,
/* 0x62e0 */  32, 32, 32, 32, 32, 32,105, 99,111,110, 95,100,101,108,116, 97,
/* 0x62f0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6300 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 72,
/* 0x6310 */  65, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6320 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6330 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x6340 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6350 */  32,116,108,115, 95, 97,100,100,114,101,115,115, 10, 48, 48, 48,
/* 0x6360 */  48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x6370 */  32, 32, 32, 32, 32, 32, 32, 32,116,108,115, 95,118, 97,108,117,
/* 0x6380 */ 101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6390 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77,
/* 0x63a0 */  65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x63b0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x63c0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x63d0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x63e0 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x63f0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6400 */  79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79,
/* 0x6410 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6420 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6430 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6440 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x6450 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x6460 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x6470 */  83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6480 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6490 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x64a0 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x64b0 */  32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69,
/* 0x64c0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x64d0 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58,
/* 0x64e0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x64f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6500 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6510 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x6520 */  70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6530 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x6540 */  50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6550 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6560 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6570 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6580 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10,
/* 0x6590 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x65a0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48,
/* 0x65b0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x65c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x65d0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x65e0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x65f0 */  50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x6600 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6610 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76,
/* 0x6620 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6630 */  70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10,
/* 0x6640 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6650 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6660 */  10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x6670 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x6680 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95,
/* 0x6690 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x66a0 */  78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x66b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x66c0 */  32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x66d0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x66e0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x66f0 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6700 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51,
/* 0x6710 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6720 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,
/* 0x6730 */  83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6740 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6750 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x6760 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6770 */  32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x6780 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6790 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10,
/* 0x67a0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x67b0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48,
/* 0x67c0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x67d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x67e0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51,
/* 0x67f0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6800 */  50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6810 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6820 */  91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6830 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6840 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6850 */  48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6860 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49,
/* 0x6870 */  10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6880 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x6890 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x68a0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x68b0 */  66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x68c0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x68d0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x68e0 */  49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x68f0 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x6900 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6910 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93,
/* 0x6920 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6930 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6940 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x6950 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6960 */  68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6970 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6980 */  78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6990 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x69a0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x69b0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x69c0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,
/* 0x69d0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x69e0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50,
/* 0x69f0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6a00 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6a10 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x6a20 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a30 */  78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6a40 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6a50 */  32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x6a60 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6a70 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6a80 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6a90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x6aa0 */  49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6ab0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,
/* 0x6ac0 */  65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6ad0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ae0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x6af0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b00 */  32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79,
/* 0x6b10 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6b20 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79,
/* 0x6b30 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6b40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6b50 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6b60 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x6b70 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51,
/* 0x6b80 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6b90 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6ba0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6bb0 */  91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6bc0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bd0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6be0 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6bf0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48,
/* 0x6c00 */  10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x6c10 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x6c20 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95,
/* 0x6c30 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c40 */  78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6c50 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6c60 */  32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x6c70 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6c80 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6c90 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x6ca0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51,
/* 0x6cb0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6cc0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65,
/* 0x6cd0 */  83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6ce0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6cf0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x6d00 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d10 */  32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x6d20 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6d30 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10,
/* 0x6d40 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6d50 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48,
/* 0x6d60 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6d70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6d80 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51,
/* 0x6d90 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6da0 */  50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6db0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6dc0 */  91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6dd0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6de0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6df0 */  48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6e00 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49,
/* 0x6e10 */  10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6e20 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x6e30 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6e40 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x6e50 */  68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6e60 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e70 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6e80 */  49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x6e90 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x6ea0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6eb0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93,
/* 0x6ec0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6ed0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6ee0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x6ef0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x6f00 */  69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6f10 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6f20 */  78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6f30 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f40 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6f50 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6f60 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,
/* 0x6f70 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6f80 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50,
/* 0x6f90 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6fa0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6fb0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x6fc0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6fd0 */  78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6fe0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6ff0 */  32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x7000 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7010 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7020 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x7030 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49,
/* 0x7040 */  49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7050 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,
/* 0x7060 */  65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7070 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7080 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x7090 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x70a0 */  32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79,
/* 0x70b0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x70c0 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79,
/* 0x70d0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x70e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x70f0 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7100 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x7110 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51,
/* 0x7120 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x7130 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7140 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7150 */  91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x7160 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7170 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7180 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x7190 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48,
/* 0x71a0 */  10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x71b0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x71c0 */  69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95,
/* 0x71d0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x71e0 */  78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x71f0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7200 */  32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x7210 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7220 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7230 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x7240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x7250 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7260 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65,
/* 0x7270 */  83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7280 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7290 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x72a0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x72b0 */  32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x72c0 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x72d0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10,
/* 0x72e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x72f0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48,
/* 0x7300 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x7310 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x7320 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51,
/* 0x7330 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x7340 */  50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7350 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7360 */  91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x7370 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7380 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7390 */  48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x73a0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49,
/* 0x73b0 */  10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x73c0 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x73d0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x73e0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x73f0 */  69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x7400 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7410 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x7420 */  49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x7430 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x7440 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x7450 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48,
/* 0x7460 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x7470 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x7480 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95,
/* 0x7490 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x74a0 */ 108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,
/* 0x74b0 */ 116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54,
/* 0x74c0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x74d0 */  97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,101,
/* 0x74e0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x74f0 */  32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,
/* 0x7500 */  48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x7510 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,
/* 0x7520 */ 111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7530 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7540 */  32, 91, 80, 69, 67, 84, 84, 80, 79, 83, 93, 58, 10, 79, 70, 70,
/* 0x7550 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7560 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7570 */  48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x7580 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x7590 */  98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 10, 82, 69,
/* 0x75a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x75b0 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58,
/* 0x75c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x75d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x75e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x75f0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x7600 */ 116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,
/* 0x7610 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x7620 */  79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79,
/* 0x7630 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x7640 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x7650 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56,
/* 0x7660 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,
/* 0x7670 */ 114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x7680 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7690 */  32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x76a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x76b0 */  82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70,
/* 0x76c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x76d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x76e0 */  48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x76f0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x7700 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x7710 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x7720 */  84, 82, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x7730 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7740 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x7750 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7760 */  32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104,
/* 0x7770 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7780 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82,
/* 0x7790 */  49, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x77a0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x77b0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x77c0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x77d0 */  32, 67, 65, 76, 76, 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67,
/* 0x77e0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x77f0 */  82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70,
/* 0x7800 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x7810 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x7820 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32,
/* 0x7830 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x7840 */  95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x7850 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7860 */  67, 65, 76, 76, 84, 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7870 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7880 */  32, 91, 67, 65, 76, 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70,
/* 0x7890 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x78a0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x78b0 */  48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x78c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x78d0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x78e0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x78f0 */  50, 46, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x7900 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7910 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x7920 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x7930 */  32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104,
/* 0x7940 */  10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95,
/* 0x7950 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107,
/* 0x7960 */  51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x7970 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,
/* 0x7980 */ 116,111,107, 51, 50, 46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7990 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x79a0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x79b0 */  48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x79c0 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,
/* 0x79d0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x79e0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x79f0 */  46, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7a00 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7a10 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x7a20 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7a30 */  32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48,
/* 0x7a40 */  48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x7a50 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x7a60 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x7a70 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x7a80 */ 101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,
/* 0x7a90 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7aa0 */  32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 10, 82, 69, 76,
/* 0x7ab0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7ac0 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 51, 48, 93, 58,
/* 0x7ad0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7ae0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7af0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x7b00 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x7b10 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 57, 32,
/* 0x7b20 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7b30 */  32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69, 76,
/* 0x7b40 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x7b50 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48, 93, 58,
/* 0x7b60 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7b70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7b80 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x7b90 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x7ba0 */ 107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x7bb0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x7bc0 */  80, 69, 73, 77, 80, 79, 82, 84, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x7bd0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7be0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7bf0 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x7c00 */  32, 32, 32, 32, 32, 32, 32, 99,111,109,112,114,101,115,115,101,
/* 0x7c10 */ 100, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x7c20 */  48, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x7c30 */  32, 32, 32, 32, 32, 80, 69, 73, 77, 68, 79, 78, 69, 10, 48, 48,
/* 0x7c40 */  48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x7c50 */  32, 32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,
/* 0x7c60 */ 102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x7c70 */  49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x7c80 */  32, 32, 32, 32, 32, 76,111, 97,100, 76,105, 98,114, 97,114,121,
/* 0x7c90 */  65, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7ca0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 66, 89,
/* 0x7cb0 */  79, 82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x7cc0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7cd0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x7ce0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x7cf0 */  32, 32, 80, 69, 73, 77, 79, 82, 68, 49, 10, 10, 82, 69, 76, 79,
/* 0x7d00 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x7d10 */  79, 82, 32, 91, 80, 69, 75, 51, 50, 79, 82, 68, 93, 58, 10, 79,
/* 0x7d20 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x7d30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x7d40 */  48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x7d50 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,107,101,114,110,101,
/* 0x7d60 */ 108, 51, 50, 95,111,114,100,105,110, 97,108,115, 10, 48, 48, 48,
/* 0x7d70 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x7d80 */  32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 80, 79, 82, 50,
/* 0x7d90 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7da0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79,
/* 0x7db0 */  82, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x7dc0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7dd0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82,
/* 0x7de0 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7df0 */  32, 71,101,116, 80,114,111, 99, 65,100,100,114,101,115,115, 10,
/* 0x7e00 */  48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x7e10 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 80,
/* 0x7e20 */  79, 82, 84, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x7e30 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73,
/* 0x7e40 */  69, 82, 69, 88, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7e50 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7e60 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7e70 */  50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x7e80 */  32, 32, 32, 32, 69,120,105,116, 80,114,111, 99,101,115,115, 10,
/* 0x7e90 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x7ea0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 82, 69, 76, 79, 67,
/* 0x7eb0 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x7ec0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x7ed0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x7ee0 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7ef0 */ 115,116, 97,114,116, 95,111,102, 95,114,101,108,111, 99,115, 10,
/* 0x7f00 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x7f10 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67, 51, 50,
/* 0x7f20 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x7f30 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x7f40 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95,
/* 0x7f50 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7f60 */  82, 69, 76, 79, 67, 51, 50, 74, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7f70 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7f80 */  32, 91, 82, 69, 76, 51, 50, 66, 73, 71, 93, 58, 10, 79, 70, 70,
/* 0x7f90 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7fb0 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x7fc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50,
/* 0x7fd0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7fe0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67,
/* 0x7ff0 */  51, 50, 74, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x8000 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8010 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x8020 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x8030 */  32, 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79,
/* 0x8040 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x8050 */  79, 82, 32, 91, 80, 69, 82, 76, 79, 72, 73, 48, 93, 58, 10, 79,
/* 0x8060 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x8070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x8080 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x8090 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,114,101,108,111, 99,
/* 0x80a0 */  95,100,101,108,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x80b0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x80c0 */  69, 68, 69, 80, 72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x80d0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x80e0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x80f0 */  48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x8100 */  32, 32, 32, 32, 32, 32, 86,105,114,116,117, 97,108, 80,114,111,
/* 0x8110 */ 116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95,
/* 0x8120 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x8130 */ 118,112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x8140 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x8150 */  32, 32, 32,118,112, 95,115,105,122,101, 10, 48, 48, 48, 48, 48,
/* 0x8160 */  48, 49, 98, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x8170 */  32, 32, 32, 32, 32, 32,115,119,114,105, 10, 10, 82, 69, 76, 79,
/* 0x8180 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x8190 */  79, 82, 32, 91, 80, 69, 84, 76, 83, 67, 93, 58, 10, 79, 70, 70,
/* 0x81a0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x81b0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x81c0 */  48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x81d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,116,108,115, 95,109,111,100,
/* 0x81e0 */ 117,108,101, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x81f0 */  56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x8200 */  32, 32, 32, 32, 80, 69, 84, 76, 83, 67, 50, 10, 10, 82, 69, 76,
/* 0x8210 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x8220 */  70, 79, 82, 32, 91, 80, 69, 68, 79, 74, 85, 77, 80, 93, 58, 10,
/* 0x8230 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x8240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x8250 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x8260 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,
/* 0x8270 */ 105,110, 97,108, 95,101,110,116,114,121, 10, 10, 82, 69, 76, 79,
/* 0x8280 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x8290 */  79, 82, 32, 91, 80, 69, 84, 76, 83, 67, 50, 93, 58, 10, 79, 70,
/* 0x82a0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x82b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x82c0 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x82d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,116,108,115, 95, 99, 97,
/* 0x82e0 */ 108,108, 98, 97, 99,107,115, 95,112,116,114, 10
};
