/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLObjectElement.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLObjectElement.h"
#include "JSDOMBinding.h"
#include "JSDocument.h"
#include "JSHTMLFormElement.h"
#include "JSSVGDocument.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "SVGDocument.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLObjectElementTableValues[] =
{
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementForm), (intptr_t)0, NoIntrinsic },
    { "code", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementCode), (intptr_t)setJSHTMLObjectElementCode, NoIntrinsic },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementAlign), (intptr_t)setJSHTMLObjectElementAlign, NoIntrinsic },
    { "archive", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementArchive), (intptr_t)setJSHTMLObjectElementArchive, NoIntrinsic },
    { "border", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementBorder), (intptr_t)setJSHTMLObjectElementBorder, NoIntrinsic },
    { "codeBase", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementCodeBase), (intptr_t)setJSHTMLObjectElementCodeBase, NoIntrinsic },
    { "codeType", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementCodeType), (intptr_t)setJSHTMLObjectElementCodeType, NoIntrinsic },
    { "data", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementData), (intptr_t)setJSHTMLObjectElementData, NoIntrinsic },
    { "declare", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementDeclare), (intptr_t)setJSHTMLObjectElementDeclare, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementHeight), (intptr_t)setJSHTMLObjectElementHeight, NoIntrinsic },
    { "hspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementHspace), (intptr_t)setJSHTMLObjectElementHspace, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementName), (intptr_t)setJSHTMLObjectElementName, NoIntrinsic },
    { "standby", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementStandby), (intptr_t)setJSHTMLObjectElementStandby, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementType), (intptr_t)setJSHTMLObjectElementType, NoIntrinsic },
    { "useMap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementUseMap), (intptr_t)setJSHTMLObjectElementUseMap, NoIntrinsic },
    { "vspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementVspace), (intptr_t)setJSHTMLObjectElementVspace, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementWidth), (intptr_t)setJSHTMLObjectElementWidth, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "contentDocument", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementContentDocument), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLObjectElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLObjectElementTable = { 68, 63, JSHTMLObjectElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLObjectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLObjectElementConstructorTable = { 1, 0, JSHTMLObjectElementConstructorTableValues, 0 };
const ClassInfo JSHTMLObjectElementConstructor::s_info = { "HTMLObjectElementConstructor", &Base::s_info, &JSHTMLObjectElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLObjectElementConstructor) };

JSHTMLObjectElementConstructor::JSHTMLObjectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLObjectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLObjectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLObjectElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLObjectElementConstructor, JSDOMWrapper>(exec, &JSHTMLObjectElementConstructorTable, jsCast<JSHTMLObjectElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLObjectElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLObjectElementConstructor, JSDOMWrapper>(exec, &JSHTMLObjectElementConstructorTable, jsCast<JSHTMLObjectElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLObjectElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLObjectElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLObjectElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { "getSVGDocument", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLObjectElementPrototypeFunctionGetSVGDocument), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLObjectElementPrototypeTable = { 9, 7, JSHTMLObjectElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLObjectElementPrototype::s_info = { "HTMLObjectElementPrototype", &Base::s_info, &JSHTMLObjectElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLObjectElementPrototype) };

JSObject* JSHTMLObjectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLObjectElement>(exec, globalObject);
}

bool JSHTMLObjectElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLObjectElementPrototype* thisObject = jsCast<JSHTMLObjectElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLObjectElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLObjectElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLObjectElementPrototype* thisObject = jsCast<JSHTMLObjectElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLObjectElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLObjectElement::s_info = { "HTMLObjectElement", &Base::s_info, &JSHTMLObjectElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLObjectElement) };

JSHTMLObjectElement::JSHTMLObjectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLObjectElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLObjectElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLObjectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLObjectElementPrototype::create(exec->vm(), globalObject, JSHTMLObjectElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLObjectElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLObjectElement* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLObjectElement, Base>(exec, &JSHTMLObjectElementTable, thisObject, propertyName, slot);
}

bool JSHTMLObjectElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLObjectElement* thisObject = jsCast<JSHTMLObjectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSHTMLObjectElement, Base>(exec, &JSHTMLObjectElementTable, thisObject, propertyName, descriptor);
}

bool JSHTMLObjectElement::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHTMLObjectElement* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHTMLObjectElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLObjectElementCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::codeAttr));
    return result;
}


JSValue jsHTMLObjectElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLObjectElementArchive(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::archiveAttr));
    return result;
}


JSValue jsHTMLObjectElementBorder(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return result;
}


JSValue jsHTMLObjectElementCodeBase(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::codebaseAttr));
    return result;
}


JSValue jsHTMLObjectElementCodeType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::codetypeAttr));
    return result;
}


JSValue jsHTMLObjectElementData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::dataAttr));
    return result;
}


JSValue jsHTMLObjectElementDeclare(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::declareAttr));
    return result;
}


JSValue jsHTMLObjectElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}


JSValue jsHTMLObjectElementHspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
    return result;
}


JSValue jsHTMLObjectElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLObjectElementStandby(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::standbyAttr));
    return result;
}


JSValue jsHTMLObjectElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLObjectElementUseMap(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return result;
}


JSValue jsHTMLObjectElementVspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
    return result;
}


JSValue jsHTMLObjectElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLObjectElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLObjectElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLObjectElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLObjectElementContentDocument(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    return shouldAllowAccessToNode(exec, impl->contentDocument()) ? toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->contentDocument())) : jsNull();
}


JSValue jsHTMLObjectElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLObjectElement* domObject = jsCast<JSHTMLObjectElement*>(asObject(slotBase));
    return JSHTMLObjectElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLObjectElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLObjectElement* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    lookupPut<JSHTMLObjectElement, Base>(exec, propertyName, value, &JSHTMLObjectElementTable, thisObject, slot);
}

void JSHTMLObjectElement::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSHTMLObjectElement* thisObject = jsCast<JSHTMLObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    PutPropertySlot slot(shouldThrow);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void setJSHTMLObjectElementCode(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::codeAttr, nativeValue);
}


void setJSHTMLObjectElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLObjectElementArchive(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::archiveAttr, nativeValue);
}


void setJSHTMLObjectElementBorder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::borderAttr, nativeValue);
}


void setJSHTMLObjectElementCodeBase(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::codebaseAttr, nativeValue);
}


void setJSHTMLObjectElementCodeType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::codetypeAttr, nativeValue);
}


void setJSHTMLObjectElementData(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::dataAttr, nativeValue);
}


void setJSHTMLObjectElementDeclare(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::declareAttr, nativeValue);
}


void setJSHTMLObjectElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLObjectElementHspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, nativeValue);
}


void setJSHTMLObjectElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::nameAttr, nativeValue);
}


void setJSHTMLObjectElementStandby(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::standbyAttr, nativeValue);
}


void setJSHTMLObjectElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::typeAttr, nativeValue);
}


void setJSHTMLObjectElementUseMap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::usemapAttr, nativeValue);
}


void setJSHTMLObjectElementVspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, nativeValue);
}


void setJSHTMLObjectElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(thisObject);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLObjectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLObjectElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLObjectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLObjectElement::s_info);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLObjectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLObjectElement::s_info);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLObjectElementPrototypeFunctionGetSVGDocument(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLObjectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLObjectElement* castedThis = jsCast<JSHTMLObjectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLObjectElement::s_info);
    HTMLObjectElement* impl = static_cast<HTMLObjectElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    if (!shouldAllowAccessToNode(exec, impl->getSVGDocument(ec)))
        return JSValue::encode(jsNull());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getSVGDocument(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
