/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAttr.h"

#include "Attr.h"
#include "Element.h"
#include "JSElement.h"
#include "KURL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAttrTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrName), (intptr_t)0, NoIntrinsic },
    { "specified", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrSpecified), (intptr_t)0, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrValue), (intptr_t)setJSAttrValue, NoIntrinsic },
    { "ownerElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrOwnerElement), (intptr_t)0, NoIntrinsic },
    { "isId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrIsId), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAttrTable = { 18, 15, JSAttrTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSAttrConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAttrConstructorTable = { 1, 0, JSAttrConstructorTableValues, 0 };
const ClassInfo JSAttrConstructor::s_info = { "AttrConstructor", &Base::s_info, &JSAttrConstructorTable, 0, CREATE_METHOD_TABLE(JSAttrConstructor) };

JSAttrConstructor::JSAttrConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAttrConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSAttrPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSAttrConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAttrConstructor, JSDOMWrapper>(exec, &JSAttrConstructorTable, jsCast<JSAttrConstructor*>(cell), propertyName, slot);
}

bool JSAttrConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAttrConstructor, JSDOMWrapper>(exec, &JSAttrConstructorTable, jsCast<JSAttrConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSAttrPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAttrPrototypeTable = { 1, 0, JSAttrPrototypeTableValues, 0 };
const ClassInfo JSAttrPrototype::s_info = { "AttrPrototype", &Base::s_info, &JSAttrPrototypeTable, 0, CREATE_METHOD_TABLE(JSAttrPrototype) };

JSObject* JSAttrPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAttr>(exec, globalObject);
}

const ClassInfo JSAttr::s_info = { "Attr", &Base::s_info, &JSAttrTable, 0 , CREATE_METHOD_TABLE(JSAttr) };

JSAttr::JSAttr(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Attr> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSAttr::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAttr::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAttrPrototype::create(exec->vm(), globalObject, JSAttrPrototype::createStructure(exec->vm(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSAttr::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAttr* thisObject = jsCast<JSAttr*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSAttr, Base>(exec, &JSAttrTable, thisObject, propertyName, slot);
}

bool JSAttr::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAttr* thisObject = jsCast<JSAttr*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSAttr, Base>(exec, &JSAttrTable, thisObject, propertyName, descriptor);
}

JSValue jsAttrName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAttr* castedThis = jsCast<JSAttr*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Attr* impl = static_cast<Attr*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->name());
    return result;
}


JSValue jsAttrSpecified(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAttr* castedThis = jsCast<JSAttr*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Attr* impl = static_cast<Attr*>(castedThis->impl());
    JSValue result = jsBoolean(impl->specified());
    return result;
}


JSValue jsAttrValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAttr* castedThis = jsCast<JSAttr*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Attr* impl = static_cast<Attr*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->value());
    return result;
}


JSValue jsAttrOwnerElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAttr* castedThis = jsCast<JSAttr*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Attr* impl = static_cast<Attr*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->ownerElement()));
    return result;
}


JSValue jsAttrIsId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAttr* castedThis = jsCast<JSAttr*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Attr* impl = static_cast<Attr*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isId());
    return result;
}


JSValue jsAttrConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAttr* domObject = jsCast<JSAttr*>(asObject(slotBase));
    return JSAttr::getConstructor(exec, domObject->globalObject());
}

void JSAttr::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSAttr* thisObject = jsCast<JSAttr*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSAttr, Base>(exec, propertyName, value, &JSAttrTable, thisObject, slot);
}

void setJSAttrValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAttr* castedThis = jsCast<JSAttr*>(thisObject);
    Attr* impl = static_cast<Attr*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setValue(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSAttr::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAttrConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

Attr* toAttr(JSC::JSValue value)
{
    return value.inherits(&JSAttr::s_info) ? jsCast<JSAttr*>(asObject(value))->impl() : 0;
}

}
