/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMemoryInfo.h"

#include "MemoryInfo.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMemoryInfoTableValues[] =
{
    { "totalJSHeapSize", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMemoryInfoTotalJSHeapSize), (intptr_t)0, NoIntrinsic },
    { "usedJSHeapSize", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMemoryInfoUsedJSHeapSize), (intptr_t)0, NoIntrinsic },
    { "jsHeapSizeLimit", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMemoryInfoJsHeapSizeLimit), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMemoryInfoTable = { 8, 7, JSMemoryInfoTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSMemoryInfoPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMemoryInfoPrototypeTable = { 1, 0, JSMemoryInfoPrototypeTableValues, 0 };
const ClassInfo JSMemoryInfoPrototype::s_info = { "MemoryInfoPrototype", &Base::s_info, &JSMemoryInfoPrototypeTable, 0, CREATE_METHOD_TABLE(JSMemoryInfoPrototype) };

JSObject* JSMemoryInfoPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMemoryInfo>(exec, globalObject);
}

const ClassInfo JSMemoryInfo::s_info = { "MemoryInfo", &Base::s_info, &JSMemoryInfoTable, 0 , CREATE_METHOD_TABLE(JSMemoryInfo) };

JSMemoryInfo::JSMemoryInfo(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MemoryInfo> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMemoryInfo::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMemoryInfo::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMemoryInfoPrototype::create(exec->globalData(), globalObject, JSMemoryInfoPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSMemoryInfo::destroy(JSC::JSCell* cell)
{
    JSMemoryInfo* thisObject = static_cast<JSMemoryInfo*>(cell);
    thisObject->JSMemoryInfo::~JSMemoryInfo();
}

JSMemoryInfo::~JSMemoryInfo()
{
    releaseImplIfNotNull();
}

bool JSMemoryInfo::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMemoryInfo* thisObject = jsCast<JSMemoryInfo*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMemoryInfo, Base>(exec, &JSMemoryInfoTable, thisObject, propertyName, slot);
}

bool JSMemoryInfo::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMemoryInfo* thisObject = jsCast<JSMemoryInfo*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMemoryInfo, Base>(exec, &JSMemoryInfoTable, thisObject, propertyName, descriptor);
}

JSValue jsMemoryInfoTotalJSHeapSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMemoryInfo* castedThis = jsCast<JSMemoryInfo*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MemoryInfo* impl = static_cast<MemoryInfo*>(castedThis->impl());
    JSValue result = jsNumber(impl->totalJSHeapSize());
    return result;
}


JSValue jsMemoryInfoUsedJSHeapSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMemoryInfo* castedThis = jsCast<JSMemoryInfo*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MemoryInfo* impl = static_cast<MemoryInfo*>(castedThis->impl());
    JSValue result = jsNumber(impl->usedJSHeapSize());
    return result;
}


JSValue jsMemoryInfoJsHeapSizeLimit(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMemoryInfo* castedThis = jsCast<JSMemoryInfo*>(asObject(slotBase));
    return castedThis->jsHeapSizeLimit(exec);
}


static inline bool isObservable(JSMemoryInfo* jsMemoryInfo)
{
    if (jsMemoryInfo->hasCustomProperties())
        return true;
    return false;
}

bool JSMemoryInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMemoryInfo* jsMemoryInfo = jsCast<JSMemoryInfo*>(handle.get().asCell());
    if (!isObservable(jsMemoryInfo))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMemoryInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMemoryInfo* jsMemoryInfo = jsCast<JSMemoryInfo*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMemoryInfo->impl(), jsMemoryInfo);
    jsMemoryInfo->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MemoryInfo* impl)
{
    return wrap<JSMemoryInfo>(exec, globalObject, impl);
}

MemoryInfo* toMemoryInfo(JSC::JSValue value)
{
    return value.inherits(&JSMemoryInfo::s_info) ? jsCast<JSMemoryInfo*>(asObject(value))->impl() : 0;
}

}
