/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableColElement.h"

#include "HTMLNames.h"
#include "HTMLTableColElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTableColElementTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementAlign), (intptr_t)setJSHTMLTableColElementAlign, NoIntrinsic },
    { "ch", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementCh), (intptr_t)setJSHTMLTableColElementCh, NoIntrinsic },
    { "chOff", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementChOff), (intptr_t)setJSHTMLTableColElementChOff, NoIntrinsic },
    { "span", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementSpan), (intptr_t)setJSHTMLTableColElementSpan, NoIntrinsic },
    { "vAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementVAlign), (intptr_t)setJSHTMLTableColElementVAlign, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementWidth), (intptr_t)setJSHTMLTableColElementWidth, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableColElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableColElementTable = { 17, 15, JSHTMLTableColElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTableColElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableColElementConstructorTable = { 1, 0, JSHTMLTableColElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTableColElementConstructor::s_info = { "HTMLTableColElementConstructor", &Base::s_info, &JSHTMLTableColElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTableColElementConstructor) };

JSHTMLTableColElementConstructor::JSHTMLTableColElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTableColElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLTableColElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLTableColElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableColElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableColElementConstructorTable, jsCast<JSHTMLTableColElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTableColElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableColElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableColElementConstructorTable, jsCast<JSHTMLTableColElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableColElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableColElementPrototypeTable = { 1, 0, JSHTMLTableColElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTableColElementPrototype::s_info = { "HTMLTableColElementPrototype", &Base::s_info, &JSHTMLTableColElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTableColElementPrototype) };

JSObject* JSHTMLTableColElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableColElement>(exec, globalObject);
}

const ClassInfo JSHTMLTableColElement::s_info = { "HTMLTableColElement", &Base::s_info, &JSHTMLTableColElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTableColElement) };

JSHTMLTableColElement::JSHTMLTableColElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTableColElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTableColElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTableColElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTableColElementPrototype::create(exec->globalData(), globalObject, JSHTMLTableColElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTableColElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableColElement* thisObject = jsCast<JSHTMLTableColElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTableColElement, Base>(exec, &JSHTMLTableColElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTableColElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableColElement* thisObject = jsCast<JSHTMLTableColElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTableColElement, Base>(exec, &JSHTMLTableColElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTableColElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLTableColElementCh(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::charAttr));
    return result;
}


JSValue jsHTMLTableColElementChOff(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}


JSValue jsHTMLTableColElementSpan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->span());
    return result;
}


JSValue jsHTMLTableColElementVAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}


JSValue jsHTMLTableColElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLTableColElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableColElement* domObject = jsCast<JSHTMLTableColElement*>(asObject(slotBase));
    return JSHTMLTableColElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTableColElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTableColElement* thisObject = jsCast<JSHTMLTableColElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTableColElement, Base>(exec, propertyName, value, &JSHTMLTableColElementTable, thisObject, slot);
}

void setJSHTMLTableColElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(thisObject);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableColElementCh(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(thisObject);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::charAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableColElementChOff(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(thisObject);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::charoffAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableColElementSpan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(thisObject);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    impl->setSpan(value.toInt32(exec));
}


void setJSHTMLTableColElementVAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(thisObject);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::valignAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableColElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableColElement* castedThis = jsCast<JSHTMLTableColElement*>(thisObject);
    HTMLTableColElement* impl = static_cast<HTMLTableColElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::widthAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLTableColElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableColElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
