/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_propgrid.h"

        #include <wx/propgrid/propgrid.h>



PyDoc_STRVAR(doc_wxPGValidationInfo_GetFailureBehavior, "GetFailureBehavior() -> PGVFBFlags");

extern "C" {static PyObject *meth_wxPGValidationInfo_GetFailureBehavior(PyObject *, PyObject *);}
static PyObject *meth_wxPGValidationInfo_GetFailureBehavior(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPGValidationInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGValidationInfo, &sipCpp))
        {
            unsigned char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFailureBehavior();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPBytes_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGValidationInfo, sipName_GetFailureBehavior, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPGValidationInfo_GetFailureMessage, "GetFailureMessage() -> String\n"
"\n"
"Returns current failure message.");

extern "C" {static PyObject *meth_wxPGValidationInfo_GetFailureMessage(PyObject *, PyObject *);}
static PyObject *meth_wxPGValidationInfo_GetFailureMessage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPGValidationInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGValidationInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFailureMessage());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGValidationInfo, sipName_GetFailureMessage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPGValidationInfo_GetValue, "GetValue() -> PGVariant\n"
"\n"
"Returns reference to pending value.");

extern "C" {static PyObject *meth_wxPGValidationInfo_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxPGValidationInfo_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPGValidationInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPGValidationInfo, &sipCpp))
        {
             ::wxPGVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetValue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPGVariant,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGValidationInfo, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPGValidationInfo_SetFailureBehavior, "SetFailureBehavior(failureBehavior)\n"
"\n"
"Set validation failure behaviour.");

extern "C" {static PyObject *meth_wxPGValidationInfo_SetFailureBehavior(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGValidationInfo_SetFailureBehavior(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char failureBehavior;
         ::wxPGValidationInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_failureBehavior,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bc", &sipSelf, sipType_wxPGValidationInfo, &sipCpp, &failureBehavior))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFailureBehavior(failureBehavior);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGValidationInfo, sipName_SetFailureBehavior, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPGValidationInfo_SetFailureMessage, "SetFailureMessage(message)\n"
"\n"
"Set current failure message.");

extern "C" {static PyObject *meth_wxPGValidationInfo_SetFailureMessage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPGValidationInfo_SetFailureMessage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* message;
        int messageState = 0;
         ::wxPGValidationInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_message,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPGValidationInfo, &sipCpp, sipType_wxString,&message, &messageState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFailureMessage(*message);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(message),sipType_wxString,messageState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_PGValidationInfo, sipName_SetFailureMessage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPGValidationInfo(void *, int);}
static void release_wxPGValidationInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPGValidationInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxPGValidationInfo(void *, SIP_SSIZE_T, void *);}
static void assign_wxPGValidationInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPGValidationInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPGValidationInfo *>(sipSrc);
}


extern "C" {static void *array_wxPGValidationInfo(SIP_SSIZE_T);}
static void *array_wxPGValidationInfo(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxPGValidationInfo[sipNrElem];
}


extern "C" {static void *copy_wxPGValidationInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxPGValidationInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxPGValidationInfo(reinterpret_cast<const  ::wxPGValidationInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPGValidationInfo(sipSimpleWrapper *);}
static void dealloc_wxPGValidationInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPGValidationInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPGValidationInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPGValidationInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPGValidationInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPGValidationInfo();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxPGValidationInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxPGValidationInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPGValidationInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxPGValidationInfo[] = {
    {SIP_MLNAME_CAST(sipName_GetFailureBehavior), meth_wxPGValidationInfo_GetFailureBehavior, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGValidationInfo_GetFailureBehavior)},
    {SIP_MLNAME_CAST(sipName_GetFailureMessage), meth_wxPGValidationInfo_GetFailureMessage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGValidationInfo_GetFailureMessage)},
    {SIP_MLNAME_CAST(sipName_GetValue), meth_wxPGValidationInfo_GetValue, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPGValidationInfo_GetValue)},
    {SIP_MLNAME_CAST(sipName_SetFailureBehavior), SIP_MLMETH_CAST(meth_wxPGValidationInfo_SetFailureBehavior), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGValidationInfo_SetFailureBehavior)},
    {SIP_MLNAME_CAST(sipName_SetFailureMessage), SIP_MLMETH_CAST(meth_wxPGValidationInfo_SetFailureMessage), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPGValidationInfo_SetFailureMessage)}
};

sipVariableDef variables_wxPGValidationInfo[] = {
    {PropertyVariable, sipName_Value, &methods_wxPGValidationInfo[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FailureMessage, &methods_wxPGValidationInfo[1], &methods_wxPGValidationInfo[4], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FailureBehavior, &methods_wxPGValidationInfo[0], &methods_wxPGValidationInfo[3], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPGValidationInfo, "Used to convey validation information to and from functions that\n"
"actually perform validation.");


sipClassTypeDef sipTypeDef__propgrid_wxPGValidationInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxPGValidationInfo,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_PGValidationInfo,
        {0, 0, 1},
        5, methods_wxPGValidationInfo,
        0, SIP_NULLPTR,
        3, variables_wxPGValidationInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPGValidationInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxPGValidationInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxPGValidationInfo,
    assign_wxPGValidationInfo,
    array_wxPGValidationInfo,
    copy_wxPGValidationInfo,
    release_wxPGValidationInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
