/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_aui.h"

        #include <wx/aui/framemanager.h>

        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/frame.h>
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/window.h>


PyDoc_STRVAR(doc_wxAuiPaneInfo_BestSize, "BestSize(size) -> AuiPaneInfo\n"
"BestSize(x, y) -> AuiPaneInfo\n"
"\n"
"BestSize() sets the ideal size for the pane.\n"
"");

extern "C" {static PyObject *meth_wxAuiPaneInfo_BestSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_BestSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->BestSize(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    {
        int x;
        int y;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &x, &y))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->BestSize(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_BestSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Centre, "Centre() -> AuiPaneInfo\n"
"\n"
"Center() sets the pane dock position to the left side of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Centre(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Centre(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Centre();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Centre, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Center, "Center() -> AuiPaneInfo\n"
"\n"
"Center() sets the pane dock position to the left side of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Center(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Center(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Center();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Center, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_CentrePane, "CentrePane() -> AuiPaneInfo\n"
"\n"
"CentrePane() specifies that the pane should adopt the default center\n"
"pane settings.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_CentrePane(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_CentrePane(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->CentrePane();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_CentrePane, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_CenterPane, "CenterPane() -> AuiPaneInfo\n"
"\n"
"CentrePane() specifies that the pane should adopt the default center\n"
"pane settings.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_CenterPane(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_CenterPane(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->CenterPane();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_CenterPane, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_FloatingPosition, "FloatingPosition(pos) -> AuiPaneInfo\n"
"FloatingPosition(x, y) -> AuiPaneInfo\n"
"\n"
"FloatingPosition() sets the position of the floating pane.\n"
"");

extern "C" {static PyObject *meth_wxAuiPaneInfo_FloatingPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_FloatingPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPoint* pos;
        int posState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxPoint, &pos, &posState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->FloatingPosition(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    {
        int x;
        int y;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &x, &y))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->FloatingPosition(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_FloatingPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_FloatingSize, "FloatingSize(size) -> AuiPaneInfo\n"
"FloatingSize(x, y) -> AuiPaneInfo\n"
"\n"
"FloatingSize() sets the size of the floating pane.\n"
"");

extern "C" {static PyObject *meth_wxAuiPaneInfo_FloatingSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_FloatingSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->FloatingSize(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    {
        int x;
        int y;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &x, &y))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->FloatingSize(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_FloatingSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_MaxSize, "MaxSize(size) -> AuiPaneInfo\n"
"MaxSize(x, y) -> AuiPaneInfo\n"
"\n"
"MaxSize() sets the maximum size of the pane.\n"
"");

extern "C" {static PyObject *meth_wxAuiPaneInfo_MaxSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_MaxSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MaxSize(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    {
        int x;
        int y;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &x, &y))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MaxSize(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_MaxSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_MinSize, "MinSize(size) -> AuiPaneInfo\n"
"MinSize(x, y) -> AuiPaneInfo\n"
"\n"
"MinSize() sets the minimum size of the pane.\n"
"");

extern "C" {static PyObject *meth_wxAuiPaneInfo_MinSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_MinSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MinSize(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    {
        int x;
        int y;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &x, &y))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MinSize(x,y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_MinSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Bottom, "Bottom() -> AuiPaneInfo\n"
"\n"
"Bottom() sets the pane dock position to the bottom side of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Bottom(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Bottom(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Bottom();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Bottom, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_BottomDockable, "BottomDockable(b=True) -> AuiPaneInfo\n"
"\n"
"BottomDockable() indicates whether a pane can be docked at the bottom\n"
"of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_BottomDockable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_BottomDockable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->BottomDockable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_BottomDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Caption, "Caption(c) -> AuiPaneInfo\n"
"\n"
"Caption() sets the caption of the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Caption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Caption(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* c;
        int cState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxString,&c, &cState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Caption(*c);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(c),sipType_wxString,cState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Caption, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_CaptionVisible, "CaptionVisible(visible=True) -> AuiPaneInfo\n"
"\n"
"CaptionVisible indicates that a pane caption should be visible.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_CaptionVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_CaptionVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->CaptionVisible(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_CaptionVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_CloseButton, "CloseButton(visible=True) -> AuiPaneInfo\n"
"\n"
"CloseButton() indicates that a close button should be drawn for the\n"
"pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_CloseButton(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_CloseButton(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->CloseButton(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_CloseButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_DefaultPane, "DefaultPane() -> AuiPaneInfo\n"
"\n"
"DefaultPane() specifies that the pane should adopt the default pane\n"
"settings.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_DefaultPane(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_DefaultPane(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->DefaultPane();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_DefaultPane, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_DestroyOnClose, "DestroyOnClose(b=True) -> AuiPaneInfo\n"
"\n"
"DestroyOnClose() indicates whether a pane should be destroyed when it\n"
"is closed.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_DestroyOnClose(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_DestroyOnClose(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->DestroyOnClose(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_DestroyOnClose, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Direction, "Direction(direction) -> AuiPaneInfo\n"
"\n"
"Direction() determines the direction of the docked pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Direction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Direction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int direction;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &direction))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Direction(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Direction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Dock, "Dock() -> AuiPaneInfo\n"
"\n"
"Dock() indicates that a pane should be docked.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Dock(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Dock(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Dock();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Dock, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_DockFixed, "DockFixed(b=True) -> AuiPaneInfo\n"
"\n"
"DockFixed() causes the containing dock to have no resize sash.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_DockFixed(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_DockFixed(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->DockFixed(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_DockFixed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Dockable, "Dockable(b=True) -> AuiPaneInfo\n"
"\n"
"Dockable() specifies whether a frame can be docked or not.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Dockable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Dockable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Dockable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Dockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Fixed, "Fixed() -> AuiPaneInfo\n"
"\n"
"Fixed() forces a pane to be fixed size so that it cannot be resized.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Fixed(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Fixed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Fixed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Fixed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Float, "Float() -> AuiPaneInfo\n"
"\n"
"Float() indicates that a pane should be floated.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Float(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Float(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Float();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Float, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Floatable, "Floatable(b=True) -> AuiPaneInfo\n"
"\n"
"Floatable() sets whether the user will be able to undock a pane and\n"
"turn it into a floating window.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Floatable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Floatable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Floatable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Floatable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Gripper, "Gripper(visible=True) -> AuiPaneInfo\n"
"\n"
"Gripper() indicates that a gripper should be drawn for the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Gripper(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Gripper(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Gripper(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Gripper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_GripperTop, "GripperTop(attop=True) -> AuiPaneInfo\n"
"\n"
"GripperTop() indicates that a gripper should be drawn at the top of\n"
"the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_GripperTop(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_GripperTop(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool attop = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attop,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &attop))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GripperTop(attop);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_GripperTop, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasBorder, "HasBorder() -> bool\n"
"\n"
"HasBorder() returns true if the pane displays a border.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasBorder(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasBorder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasBorder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasCaption, "HasCaption() -> bool\n"
"\n"
"HasCaption() returns true if the pane displays a caption.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasCaption(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasCaption(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCaption();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasCaption, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasCloseButton, "HasCloseButton() -> bool\n"
"\n"
"HasCloseButton() returns true if the pane displays a button to close\n"
"the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasCloseButton(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasCloseButton(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCloseButton();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasCloseButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasFlag, "HasFlag(flag) -> bool\n"
"\n"
"HasFlag() returns true if the property specified by flag is active for\n"
"the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flag;
        const  ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &flag))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasGripper, "HasGripper() -> bool\n"
"\n"
"HasGripper() returns true if the pane displays a gripper.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasGripper(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasGripper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasGripper();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasGripper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasGripperTop, "HasGripperTop() -> bool\n"
"\n"
"HasGripper() returns true if the pane displays a gripper at the top.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasGripperTop(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasGripperTop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasGripperTop();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasGripperTop, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasMaximizeButton, "HasMaximizeButton() -> bool\n"
"\n"
"HasMaximizeButton() returns true if the pane displays a button to\n"
"maximize the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasMaximizeButton(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasMaximizeButton(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasMaximizeButton();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasMaximizeButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasMinimizeButton, "HasMinimizeButton() -> bool\n"
"\n"
"HasMinimizeButton() returns true if the pane displays a button to\n"
"minimize the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasMinimizeButton(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasMinimizeButton(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasMinimizeButton();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasMinimizeButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_HasPinButton, "HasPinButton() -> bool\n"
"\n"
"HasPinButton() returns true if the pane displays a button to float the\n"
"pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_HasPinButton(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_HasPinButton(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasPinButton();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_HasPinButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Hide, "Hide() -> AuiPaneInfo\n"
"\n"
"Hide() indicates that a pane should be hidden.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Hide(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Hide(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Hide();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Hide, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Icon, "Icon(b) -> AuiPaneInfo\n"
"\n"
"Icon() sets the icon of the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Icon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Icon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap* b;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxBitmap, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Icon(*b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Icon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsBottomDockable, "IsBottomDockable() -> bool\n"
"\n"
"IsBottomDockable() returns true if the pane can be docked at the\n"
"bottom of the managed frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsBottomDockable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsBottomDockable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsBottomDockable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsBottomDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsDockable, "IsDockable() -> bool\n"
"\n"
"Returns true if the pane can be docked at any side.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsDockable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsDockable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDockable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsDocked, "IsDocked() -> bool\n"
"\n"
"IsDocked() returns true if the pane is currently docked.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsDocked(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsDocked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDocked();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsDocked, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsFixed, "IsFixed() -> bool\n"
"\n"
"IsFixed() returns true if the pane cannot be resized.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsFixed(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsFixed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFixed();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsFixed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsFloatable, "IsFloatable() -> bool\n"
"\n"
"IsFloatable() returns true if the pane can be undocked and displayed\n"
"as a floating window.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsFloatable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsFloatable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFloatable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsFloatable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsFloating, "IsFloating() -> bool\n"
"\n"
"IsFloating() returns true if the pane is floating.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsFloating(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsFloating(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFloating();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsFloating, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsLeftDockable, "IsLeftDockable() -> bool\n"
"\n"
"IsLeftDockable() returns true if the pane can be docked on the left of\n"
"the managed frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsLeftDockable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsLeftDockable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsLeftDockable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsLeftDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsMovable, "IsMovable() -> bool\n"
"\n"
"IsMoveable() returns true if the docked frame can be undocked or moved\n"
"to another dock position.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsMovable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsMovable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsMovable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsMovable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsOk, "IsOk() -> bool\n"
"\n"
"IsOk() returns true if the wxAuiPaneInfo structure is valid.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsResizable, "IsResizable() -> bool\n"
"\n"
"IsResizable() returns true if the pane can be resized.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsResizable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsResizable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsResizable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsResizable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsRightDockable, "IsRightDockable() -> bool\n"
"\n"
"IsRightDockable() returns true if the pane can be docked on the right\n"
"of the managed frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsRightDockable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsRightDockable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRightDockable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsRightDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsShown, "IsShown() -> bool\n"
"\n"
"IsShown() returns true if the pane is currently shown.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsShown(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsShown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsShown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsShown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsToolbar, "IsToolbar() -> bool\n"
"\n"
"IsToolbar() returns true if the pane contains a toolbar.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsToolbar(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsToolbar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsToolbar();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsToolbar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsTopDockable, "IsTopDockable() -> bool\n"
"\n"
"IsTopDockable() returns true if the pane can be docked at the top of\n"
"the managed frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsTopDockable(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsTopDockable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsTopDockable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsTopDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Layer, "Layer(layer) -> AuiPaneInfo\n"
"\n"
"Layer() determines the layer of the docked pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Layer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Layer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int layer;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &layer))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Layer(layer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Layer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Left, "Left() -> AuiPaneInfo\n"
"\n"
"Left() sets the pane dock position to the left side of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Left(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Left(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Left();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Left, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_LeftDockable, "LeftDockable(b=True) -> AuiPaneInfo\n"
"\n"
"LeftDockable() indicates whether a pane can be docked on the left of\n"
"the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_LeftDockable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_LeftDockable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->LeftDockable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_LeftDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_MaximizeButton, "MaximizeButton(visible=True) -> AuiPaneInfo\n"
"\n"
"MaximizeButton() indicates that a maximize button should be drawn for\n"
"the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_MaximizeButton(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_MaximizeButton(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MaximizeButton(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_MaximizeButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_MinimizeButton, "MinimizeButton(visible=True) -> AuiPaneInfo\n"
"\n"
"MinimizeButton() indicates that a minimize button should be drawn for\n"
"the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_MinimizeButton(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_MinimizeButton(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MinimizeButton(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_MinimizeButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Movable, "Movable(b=True) -> AuiPaneInfo\n"
"\n"
"Movable indicates whether a frame can be moved.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Movable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Movable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Movable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Movable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Name, "Name(n) -> AuiPaneInfo\n"
"\n"
"Name() sets the name of the pane so it can be referenced in lookup\n"
"functions.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Name(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Name(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* n;
        int nState = 0;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxString,&n, &nState))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Name(*n);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(n),sipType_wxString,nState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Name, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_PaneBorder, "PaneBorder(visible=True) -> AuiPaneInfo\n"
"\n"
"PaneBorder indicates that a border should be drawn for the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_PaneBorder(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_PaneBorder(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->PaneBorder(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_PaneBorder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_PinButton, "PinButton(visible=True) -> AuiPaneInfo\n"
"\n"
"PinButton() indicates that a pin button should be drawn for the pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_PinButton(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_PinButton(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool visible = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &visible))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->PinButton(visible);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_PinButton, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Position, "Position(pos) -> AuiPaneInfo\n"
"\n"
"Position() determines the position of the docked pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Position(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Position(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pos;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &pos))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Position(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Position, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Resizable, "Resizable(resizable=True) -> AuiPaneInfo\n"
"\n"
"Resizable() allows a pane to be resized if the parameter is true, and\n"
"forces it to be a fixed size if the parameter is false.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Resizable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Resizable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool resizable = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_resizable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &resizable))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Resizable(resizable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Resizable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Right, "Right() -> AuiPaneInfo\n"
"\n"
"Right() sets the pane dock position to the right side of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Right(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Right(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Right();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Right, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_RightDockable, "RightDockable(b=True) -> AuiPaneInfo\n"
"\n"
"RightDockable() indicates whether a pane can be docked on the right of\n"
"the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_RightDockable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_RightDockable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->RightDockable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_RightDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Row, "Row(row) -> AuiPaneInfo\n"
"\n"
"Row() determines the row of the docked pane.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Row(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Row(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int row;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &row))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Row(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Row, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_SafeSet, "SafeSet(source)\n"
"\n"
"Write the safe parts of a PaneInfo object \"source\" into \"this\".");

extern "C" {static PyObject *meth_wxAuiPaneInfo_SafeSet(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_SafeSet(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo* source;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_source,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxAuiPaneInfo, &source))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SafeSet(*source);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_SafeSet, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_SetFlag, "SetFlag(flag, option_state) -> AuiPaneInfo\n"
"\n"
"SetFlag() turns the property given by flag on or off with the\n"
"option_state parameter.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_SetFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_SetFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flag;
        bool option_state;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
            sipName_option_state,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bib", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &flag, &option_state))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SetFlag(flag,option_state);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_SetFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Show, "Show(show=True) -> AuiPaneInfo\n"
"\n"
"Show() indicates that a pane should be shown.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Show(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Show(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool show = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_show,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &show))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Show(show);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Show, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_ToolbarPane, "ToolbarPane() -> AuiPaneInfo\n"
"\n"
"ToolbarPane() specifies that the pane should adopt the default toolbar\n"
"pane settings.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_ToolbarPane(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_ToolbarPane(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->ToolbarPane();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_ToolbarPane, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Top, "Top() -> AuiPaneInfo\n"
"\n"
"Top() sets the pane dock position to the top of the frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Top(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Top(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Top();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Top, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_TopDockable, "TopDockable(b=True) -> AuiPaneInfo\n"
"\n"
"TopDockable() indicates whether a pane can be docked at the top of the\n"
"frame.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_TopDockable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_TopDockable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b = 1;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, &b))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->TopDockable(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_TopDockable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_Window, "Window(w) -> AuiPaneInfo\n"
"\n"
"Window() assigns the window pointer that the wxAuiPaneInfo should use.");

extern "C" {static PyObject *meth_wxAuiPaneInfo_Window(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_Window(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxWindow* w;
         ::wxAuiPaneInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_w,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp, sipType_wxWindow, &w))
        {
             ::wxAuiPaneInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Window(w);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAuiPaneInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_Window, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAuiPaneInfo_IsValid, "IsValid() -> bool");

extern "C" {static PyObject *meth_wxAuiPaneInfo_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxAuiPaneInfo_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAuiPaneInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAuiPaneInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AuiPaneInfo, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAuiPaneInfo(void *, int);}
static void release_wxAuiPaneInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAuiPaneInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxAuiPaneInfo(Py_ssize_t);}
static void *array_wxAuiPaneInfo(Py_ssize_t sipNrElem)
{
    return new  ::wxAuiPaneInfo[sipNrElem];
}


extern "C" {static void assign_wxAuiPaneInfo(void *, SIP_SSIZE_T, void *);}
static void assign_wxAuiPaneInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxAuiPaneInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxAuiPaneInfo *>(sipSrc);
}


extern "C" {static void *copy_wxAuiPaneInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxAuiPaneInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxAuiPaneInfo(reinterpret_cast<const  ::wxAuiPaneInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAuiPaneInfo(sipSimpleWrapper *);}
static void dealloc_wxAuiPaneInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAuiPaneInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAuiPaneInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAuiPaneInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxAuiPaneInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAuiPaneInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxAuiPaneInfo* c;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxAuiPaneInfo, &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAuiPaneInfo(*c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxAuiPaneInfo[] = {
    {SIP_MLNAME_CAST(sipName_BestSize), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_BestSize), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_BestSize)},
    {SIP_MLNAME_CAST(sipName_Bottom), meth_wxAuiPaneInfo_Bottom, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Bottom)},
    {SIP_MLNAME_CAST(sipName_BottomDockable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_BottomDockable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_BottomDockable)},
    {SIP_MLNAME_CAST(sipName_Caption), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Caption), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Caption)},
    {SIP_MLNAME_CAST(sipName_CaptionVisible), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_CaptionVisible), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_CaptionVisible)},
    {SIP_MLNAME_CAST(sipName_Center), meth_wxAuiPaneInfo_Center, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Center)},
    {SIP_MLNAME_CAST(sipName_CenterPane), meth_wxAuiPaneInfo_CenterPane, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_CenterPane)},
    {SIP_MLNAME_CAST(sipName_Centre), meth_wxAuiPaneInfo_Centre, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Centre)},
    {SIP_MLNAME_CAST(sipName_CentrePane), meth_wxAuiPaneInfo_CentrePane, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_CentrePane)},
    {SIP_MLNAME_CAST(sipName_CloseButton), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_CloseButton), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_CloseButton)},
    {SIP_MLNAME_CAST(sipName_DefaultPane), meth_wxAuiPaneInfo_DefaultPane, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_DefaultPane)},
    {SIP_MLNAME_CAST(sipName_DestroyOnClose), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_DestroyOnClose), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_DestroyOnClose)},
    {SIP_MLNAME_CAST(sipName_Direction), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Direction), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Direction)},
    {SIP_MLNAME_CAST(sipName_Dock), meth_wxAuiPaneInfo_Dock, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Dock)},
    {SIP_MLNAME_CAST(sipName_DockFixed), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_DockFixed), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_DockFixed)},
    {SIP_MLNAME_CAST(sipName_Dockable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Dockable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Dockable)},
    {SIP_MLNAME_CAST(sipName_Fixed), meth_wxAuiPaneInfo_Fixed, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Fixed)},
    {SIP_MLNAME_CAST(sipName_Float), meth_wxAuiPaneInfo_Float, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Float)},
    {SIP_MLNAME_CAST(sipName_Floatable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Floatable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Floatable)},
    {SIP_MLNAME_CAST(sipName_FloatingPosition), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_FloatingPosition), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_FloatingPosition)},
    {SIP_MLNAME_CAST(sipName_FloatingSize), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_FloatingSize), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_FloatingSize)},
    {SIP_MLNAME_CAST(sipName_Gripper), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Gripper), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Gripper)},
    {SIP_MLNAME_CAST(sipName_GripperTop), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_GripperTop), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_GripperTop)},
    {SIP_MLNAME_CAST(sipName_HasBorder), meth_wxAuiPaneInfo_HasBorder, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasBorder)},
    {SIP_MLNAME_CAST(sipName_HasCaption), meth_wxAuiPaneInfo_HasCaption, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasCaption)},
    {SIP_MLNAME_CAST(sipName_HasCloseButton), meth_wxAuiPaneInfo_HasCloseButton, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasCloseButton)},
    {SIP_MLNAME_CAST(sipName_HasFlag), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_HasFlag), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasFlag)},
    {SIP_MLNAME_CAST(sipName_HasGripper), meth_wxAuiPaneInfo_HasGripper, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasGripper)},
    {SIP_MLNAME_CAST(sipName_HasGripperTop), meth_wxAuiPaneInfo_HasGripperTop, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasGripperTop)},
    {SIP_MLNAME_CAST(sipName_HasMaximizeButton), meth_wxAuiPaneInfo_HasMaximizeButton, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasMaximizeButton)},
    {SIP_MLNAME_CAST(sipName_HasMinimizeButton), meth_wxAuiPaneInfo_HasMinimizeButton, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasMinimizeButton)},
    {SIP_MLNAME_CAST(sipName_HasPinButton), meth_wxAuiPaneInfo_HasPinButton, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_HasPinButton)},
    {SIP_MLNAME_CAST(sipName_Hide), meth_wxAuiPaneInfo_Hide, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Hide)},
    {SIP_MLNAME_CAST(sipName_Icon), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Icon), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Icon)},
    {SIP_MLNAME_CAST(sipName_IsBottomDockable), meth_wxAuiPaneInfo_IsBottomDockable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsBottomDockable)},
    {SIP_MLNAME_CAST(sipName_IsDockable), meth_wxAuiPaneInfo_IsDockable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsDockable)},
    {SIP_MLNAME_CAST(sipName_IsDocked), meth_wxAuiPaneInfo_IsDocked, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsDocked)},
    {SIP_MLNAME_CAST(sipName_IsFixed), meth_wxAuiPaneInfo_IsFixed, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsFixed)},
    {SIP_MLNAME_CAST(sipName_IsFloatable), meth_wxAuiPaneInfo_IsFloatable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsFloatable)},
    {SIP_MLNAME_CAST(sipName_IsFloating), meth_wxAuiPaneInfo_IsFloating, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsFloating)},
    {SIP_MLNAME_CAST(sipName_IsLeftDockable), meth_wxAuiPaneInfo_IsLeftDockable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsLeftDockable)},
    {SIP_MLNAME_CAST(sipName_IsMovable), meth_wxAuiPaneInfo_IsMovable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsMovable)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxAuiPaneInfo_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsOk)},
    {SIP_MLNAME_CAST(sipName_IsResizable), meth_wxAuiPaneInfo_IsResizable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsResizable)},
    {SIP_MLNAME_CAST(sipName_IsRightDockable), meth_wxAuiPaneInfo_IsRightDockable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsRightDockable)},
    {SIP_MLNAME_CAST(sipName_IsShown), meth_wxAuiPaneInfo_IsShown, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsShown)},
    {SIP_MLNAME_CAST(sipName_IsToolbar), meth_wxAuiPaneInfo_IsToolbar, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsToolbar)},
    {SIP_MLNAME_CAST(sipName_IsTopDockable), meth_wxAuiPaneInfo_IsTopDockable, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsTopDockable)},
    {SIP_MLNAME_CAST(sipName_IsValid), meth_wxAuiPaneInfo_IsValid, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_IsValid)},
    {SIP_MLNAME_CAST(sipName_Layer), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Layer), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Layer)},
    {SIP_MLNAME_CAST(sipName_Left), meth_wxAuiPaneInfo_Left, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Left)},
    {SIP_MLNAME_CAST(sipName_LeftDockable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_LeftDockable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_LeftDockable)},
    {SIP_MLNAME_CAST(sipName_MaxSize), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_MaxSize), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_MaxSize)},
    {SIP_MLNAME_CAST(sipName_MaximizeButton), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_MaximizeButton), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_MaximizeButton)},
    {SIP_MLNAME_CAST(sipName_MinSize), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_MinSize), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_MinSize)},
    {SIP_MLNAME_CAST(sipName_MinimizeButton), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_MinimizeButton), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_MinimizeButton)},
    {SIP_MLNAME_CAST(sipName_Movable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Movable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Movable)},
    {SIP_MLNAME_CAST(sipName_Name), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Name), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Name)},
    {SIP_MLNAME_CAST(sipName_PaneBorder), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_PaneBorder), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_PaneBorder)},
    {SIP_MLNAME_CAST(sipName_PinButton), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_PinButton), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_PinButton)},
    {SIP_MLNAME_CAST(sipName_Position), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Position), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Position)},
    {SIP_MLNAME_CAST(sipName_Resizable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Resizable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Resizable)},
    {SIP_MLNAME_CAST(sipName_Right), meth_wxAuiPaneInfo_Right, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Right)},
    {SIP_MLNAME_CAST(sipName_RightDockable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_RightDockable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_RightDockable)},
    {SIP_MLNAME_CAST(sipName_Row), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Row), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Row)},
    {SIP_MLNAME_CAST(sipName_SafeSet), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_SafeSet), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_SafeSet)},
    {SIP_MLNAME_CAST(sipName_SetFlag), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_SetFlag), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_SetFlag)},
    {SIP_MLNAME_CAST(sipName_Show), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Show), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Show)},
    {SIP_MLNAME_CAST(sipName_ToolbarPane), meth_wxAuiPaneInfo_ToolbarPane, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_ToolbarPane)},
    {SIP_MLNAME_CAST(sipName_Top), meth_wxAuiPaneInfo_Top, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Top)},
    {SIP_MLNAME_CAST(sipName_TopDockable), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_TopDockable), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_TopDockable)},
    {SIP_MLNAME_CAST(sipName_Window), SIP_MLMETH_CAST(meth_wxAuiPaneInfo_Window), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAuiPaneInfo_Window)}
};


extern "C" {static PyObject *varget_wxAuiPaneInfo_best_size(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_best_size(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -10);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->best_size;

    sipPy = sipConvertFromType(sipVal, sipType_wxSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -28, sipPySelf);
        sipKeepReference(sipPySelf, -10, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_best_size(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_best_size(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxSize *>(sipForceConvertToType(sipPy, sipType_wxSize, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->best_size = *sipVal;

    sipReleaseType(sipVal, sipType_wxSize, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_caption(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_caption(void *sipSelf, PyObject *, PyObject *)
{
     ::wxString*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = &sipCpp->caption;

    return sipConvertFromType(sipVal, sipType_wxString, SIP_NULLPTR);
}


extern "C" {static int varset_wxAuiPaneInfo_caption(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_caption(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxString*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxString *>(sipForceConvertToType(sipPy, sipType_wxString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->caption = *sipVal;

    sipReleaseType(sipVal, sipType_wxString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_dock_direction(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_dock_direction(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->dock_direction;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxAuiPaneInfo_dock_direction(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_dock_direction(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->dock_direction = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_dock_layer(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_dock_layer(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->dock_layer;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxAuiPaneInfo_dock_layer(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_dock_layer(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->dock_layer = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_dock_pos(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_dock_pos(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->dock_pos;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxAuiPaneInfo_dock_pos(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_dock_pos(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->dock_pos = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_dock_proportion(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_dock_proportion(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->dock_proportion;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxAuiPaneInfo_dock_proportion(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_dock_proportion(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->dock_proportion = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_dock_row(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_dock_row(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->dock_row;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxAuiPaneInfo_dock_row(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_dock_row(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->dock_row = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_floating_pos(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_floating_pos(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxPoint*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -11);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->floating_pos;

    sipPy = sipConvertFromType(sipVal, sipType_wxPoint, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -29, sipPySelf);
        sipKeepReference(sipPySelf, -11, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_floating_pos(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_floating_pos(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxPoint*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxPoint *>(sipForceConvertToType(sipPy, sipType_wxPoint, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->floating_pos = *sipVal;

    sipReleaseType(sipVal, sipType_wxPoint, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_floating_size(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_floating_size(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -12);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->floating_size;

    sipPy = sipConvertFromType(sipVal, sipType_wxSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -30, sipPySelf);
        sipKeepReference(sipPySelf, -12, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_floating_size(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_floating_size(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxSize *>(sipForceConvertToType(sipPy, sipType_wxSize, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->floating_size = *sipVal;

    sipReleaseType(sipVal, sipType_wxSize, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_frame(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_frame(void *sipSelf, PyObject *, PyObject *)
{
     ::wxFrame*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->frame;

    return sipConvertFromType(sipVal, sipType_wxFrame, SIP_NULLPTR);
}


extern "C" {static int varset_wxAuiPaneInfo_frame(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_frame(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxFrame*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxFrame *>(sipForceConvertToType(sipPy, sipType_wxFrame, SIP_NULLPTR, 0, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->frame = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_icon(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_icon(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxBitmap*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -13);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->icon;

    sipPy = sipConvertFromType(sipVal, sipType_wxBitmap, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -31, sipPySelf);
        sipKeepReference(sipPySelf, -13, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_icon(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_icon(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxBitmap*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxBitmap *>(sipForceConvertToType(sipPy, sipType_wxBitmap, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->icon = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_max_size(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_max_size(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -14);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->max_size;

    sipPy = sipConvertFromType(sipVal, sipType_wxSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -32, sipPySelf);
        sipKeepReference(sipPySelf, -14, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_max_size(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_max_size(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxSize *>(sipForceConvertToType(sipPy, sipType_wxSize, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->max_size = *sipVal;

    sipReleaseType(sipVal, sipType_wxSize, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_min_size(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_min_size(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -15);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->min_size;

    sipPy = sipConvertFromType(sipVal, sipType_wxSize, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -33, sipPySelf);
        sipKeepReference(sipPySelf, -15, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_min_size(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_min_size(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxSize*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxSize *>(sipForceConvertToType(sipPy, sipType_wxSize, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->min_size = *sipVal;

    sipReleaseType(sipVal, sipType_wxSize, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_name(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_name(void *sipSelf, PyObject *, PyObject *)
{
     ::wxString*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = &sipCpp->name;

    return sipConvertFromType(sipVal, sipType_wxString, SIP_NULLPTR);
}


extern "C" {static int varset_wxAuiPaneInfo_name(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_name(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxString*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxString *>(sipForceConvertToType(sipPy, sipType_wxString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->name = *sipVal;

    sipReleaseType(sipVal, sipType_wxString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_rect(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_rect(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
     ::wxRect*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -16);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->rect;

    sipPy = sipConvertFromType(sipVal, sipType_wxRect, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -34, sipPySelf);
        sipKeepReference(sipPySelf, -16, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_wxAuiPaneInfo_rect(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_rect(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxRect*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipValState;
    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxRect *>(sipForceConvertToType(sipPy, sipType_wxRect, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->rect = *sipVal;

    sipReleaseType(sipVal, sipType_wxRect, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_state(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_state(void *sipSelf, PyObject *, PyObject *)
{
    uint sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->state;

    return PyLong_FromUnsignedLong(sipVal);
}


extern "C" {static int varset_wxAuiPaneInfo_state(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_state(void *sipSelf, PyObject *sipPy, PyObject *)
{
    uint sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipLong_AsUnsignedInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->state = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxAuiPaneInfo_window(void *, PyObject *, PyObject *);}
static PyObject *varget_wxAuiPaneInfo_window(void *sipSelf, PyObject *, PyObject *)
{
     ::wxWindow*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    sipVal = sipCpp->window;

    return sipConvertFromType(sipVal, sipType_wxWindow, SIP_NULLPTR);
}


extern "C" {static int varset_wxAuiPaneInfo_window(void *, PyObject *, PyObject *);}
static int varset_wxAuiPaneInfo_window(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxWindow*sipVal;
     ::wxAuiPaneInfo *sipCpp = reinterpret_cast< ::wxAuiPaneInfo *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxWindow *>(sipForceConvertToType(sipPy, sipType_wxWindow, SIP_NULLPTR, 0, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->window = sipVal;

    return 0;
}

sipVariableDef variables_wxAuiPaneInfo[] = {
    {InstanceVariable, sipName_best_size, (PyMethodDef *)varget_wxAuiPaneInfo_best_size, (PyMethodDef *)varset_wxAuiPaneInfo_best_size, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_caption, (PyMethodDef *)varget_wxAuiPaneInfo_caption, (PyMethodDef *)varset_wxAuiPaneInfo_caption, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_dock_direction, (PyMethodDef *)varget_wxAuiPaneInfo_dock_direction, (PyMethodDef *)varset_wxAuiPaneInfo_dock_direction, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_dock_layer, (PyMethodDef *)varget_wxAuiPaneInfo_dock_layer, (PyMethodDef *)varset_wxAuiPaneInfo_dock_layer, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_dock_pos, (PyMethodDef *)varget_wxAuiPaneInfo_dock_pos, (PyMethodDef *)varset_wxAuiPaneInfo_dock_pos, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_dock_proportion, (PyMethodDef *)varget_wxAuiPaneInfo_dock_proportion, (PyMethodDef *)varset_wxAuiPaneInfo_dock_proportion, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_dock_row, (PyMethodDef *)varget_wxAuiPaneInfo_dock_row, (PyMethodDef *)varset_wxAuiPaneInfo_dock_row, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_floating_pos, (PyMethodDef *)varget_wxAuiPaneInfo_floating_pos, (PyMethodDef *)varset_wxAuiPaneInfo_floating_pos, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_floating_size, (PyMethodDef *)varget_wxAuiPaneInfo_floating_size, (PyMethodDef *)varset_wxAuiPaneInfo_floating_size, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_frame, (PyMethodDef *)varget_wxAuiPaneInfo_frame, (PyMethodDef *)varset_wxAuiPaneInfo_frame, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_icon, (PyMethodDef *)varget_wxAuiPaneInfo_icon, (PyMethodDef *)varset_wxAuiPaneInfo_icon, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_max_size, (PyMethodDef *)varget_wxAuiPaneInfo_max_size, (PyMethodDef *)varset_wxAuiPaneInfo_max_size, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_min_size, (PyMethodDef *)varget_wxAuiPaneInfo_min_size, (PyMethodDef *)varset_wxAuiPaneInfo_min_size, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_name, (PyMethodDef *)varget_wxAuiPaneInfo_name, (PyMethodDef *)varset_wxAuiPaneInfo_name, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_rect, (PyMethodDef *)varget_wxAuiPaneInfo_rect, (PyMethodDef *)varset_wxAuiPaneInfo_rect, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_state, (PyMethodDef *)varget_wxAuiPaneInfo_state, (PyMethodDef *)varset_wxAuiPaneInfo_state, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_window, (PyMethodDef *)varget_wxAuiPaneInfo_window, (PyMethodDef *)varset_wxAuiPaneInfo_window, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxAuiPaneInfo, "AuiPaneInfo()\n"
"AuiPaneInfo(c)\n"
"\n"
"wxAuiPaneInfo is part of the wxAUI class framework.");


sipClassTypeDef sipTypeDef__aui_wxAuiPaneInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxAuiPaneInfo,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_AuiPaneInfo,
        {0, 0, 1},
        72, methods_wxAuiPaneInfo,
        0, SIP_NULLPTR,
        17, variables_wxAuiPaneInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAuiPaneInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxAuiPaneInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxAuiPaneInfo,
    assign_wxAuiPaneInfo,
    array_wxAuiPaneInfo,
    copy_wxAuiPaneInfo,
    release_wxAuiPaneInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
