/**
Copyright (c) 2012-2015, Brice Videau <brice.videau@imag.fr>
Copyright (c) 2012-2015, Vincent Danjean <Vincent.Danjean@ens-lyon.org>
All rights reserved.
      
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
        
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Do not edit this file. It is automatically generated.

*/
#include <string.h>
#include "ocl_icd_loader.h"
#define DEBUG_OCL_ICD_PROVIDE_DUMP_FIELD
#include "ocl_icd_debug.h"
CL_API_ENTRY cl_int CL_API_CALL 
clGetPlatformInfo(cl_platform_id    platform , 
                  cl_platform_info  param_name ,
                  size_t            param_value_size , 
                  void *            param_value ,
                  size_t *          param_value_size_ret ){
  debug_trace();
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetPlatformInfo(platform, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetDeviceIDs(cl_platform_id    platform ,
               cl_device_type    device_type , 
               cl_uint           num_entries , 
               cl_device_id *    devices , 
               cl_uint *         num_devices ){
  debug_trace();
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetDeviceIDs(platform, device_type, num_entries, devices, num_devices));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetDeviceInfo(cl_device_id     device ,
                cl_device_info   param_name , 
                size_t           param_value_size , 
                void *           param_value ,
                size_t *         param_value_size_ret ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetDeviceInfo(device, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainContext(cl_context  context ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clRetainContext(context));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseContext(cl_context  context ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clReleaseContext(context));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetContextInfo(cl_context          context , 
                 cl_context_info     param_name , 
                 size_t              param_value_size , 
                 void *              param_value , 
                 size_t *            param_value_size_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clGetContextInfo(context, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_command_queue CL_API_CALL
clCreateCommandQueue(cl_context                      context , 
                     cl_device_id                    device , 
                     cl_command_queue_properties     properties ,
                     cl_int *                        errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateCommandQueue(context, device, properties, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainCommandQueue(cl_command_queue  command_queue ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clRetainCommandQueue(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseCommandQueue(cl_command_queue  command_queue ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clReleaseCommandQueue(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetCommandQueueInfo(cl_command_queue       command_queue ,
                      cl_command_queue_info  param_name ,
                      size_t                 param_value_size ,
                      void *                 param_value ,
                      size_t *               param_value_size_ret ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clGetCommandQueueInfo(command_queue, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetCommandQueueProperty(cl_command_queue               command_queue ,
                          cl_command_queue_properties    properties , 
                          cl_bool                         enable ,
                          cl_command_queue_properties *  old_properties ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clSetCommandQueueProperty(command_queue, properties, enable, old_properties));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateBuffer(cl_context    context ,
               cl_mem_flags  flags ,
               size_t        size ,
               void *        host_ptr ,
               cl_int *      errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateBuffer(context, flags, size, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImage2D(cl_context               context ,
                cl_mem_flags             flags ,
                const cl_image_format *  image_format ,
                size_t                   image_width ,
                size_t                   image_height ,
                size_t                   image_row_pitch , 
                void *                   host_ptr ,
                cl_int *                 errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage2D(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImage3D(cl_context               context ,
                cl_mem_flags             flags ,
                const cl_image_format *  image_format ,
                size_t                   image_width , 
                size_t                   image_height ,
                size_t                   image_depth , 
                size_t                   image_row_pitch , 
                size_t                   image_slice_pitch , 
                void *                   host_ptr ,
                cl_int *                 errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage3D(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainMemObject(cl_mem  memobj ){
  debug_trace();
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clRetainMemObject(memobj));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseMemObject(cl_mem  memobj ){
  debug_trace();
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clReleaseMemObject(memobj));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetSupportedImageFormats(cl_context            context ,
                           cl_mem_flags          flags ,
                           cl_mem_object_type    image_type ,
                           cl_uint               num_entries ,
                           cl_image_format *     image_formats ,
                           cl_uint *             num_image_formats ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clGetSupportedImageFormats(context, flags, image_type, num_entries, image_formats, num_image_formats));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetMemObjectInfo(cl_mem            memobj ,
                   cl_mem_info       param_name , 
                   size_t            param_value_size ,
                   void *            param_value ,
                   size_t *          param_value_size_ret ){
  debug_trace();
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetMemObjectInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetImageInfo(cl_mem            image ,
               cl_image_info     param_name , 
               size_t            param_value_size ,
               void *            param_value ,
               size_t *          param_value_size_ret ){
  debug_trace();
  if( (struct _cl_mem *)image == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)image)->dispatch->clGetImageInfo(image, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_sampler CL_API_CALL
clCreateSampler(cl_context           context ,
                cl_bool              normalized_coords , 
                cl_addressing_mode   addressing_mode , 
                cl_filter_mode       filter_mode ,
                cl_int *             errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateSampler(context, normalized_coords, addressing_mode, filter_mode, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainSampler(cl_sampler  sampler ){
  debug_trace();
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clRetainSampler(sampler));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseSampler(cl_sampler  sampler ){
  debug_trace();
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clReleaseSampler(sampler));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetSamplerInfo(cl_sampler          sampler ,
                 cl_sampler_info     param_name ,
                 size_t              param_value_size ,
                 void *              param_value ,
                 size_t *            param_value_size_ret ){
  debug_trace();
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clGetSamplerInfo(sampler, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithSource(cl_context         context ,
                          cl_uint            count ,
                          const char **      strings ,
                          const size_t *     lengths ,
                          cl_int *           errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithSource(context, count, strings, lengths, errcode_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithBinary(cl_context                      context ,
                          cl_uint                         num_devices ,
                          const cl_device_id *            device_list ,
                          const size_t *                  lengths ,
                          const unsigned char **          binaries ,
                          cl_int *                        binary_status ,
                          cl_int *                        errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithBinary(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainProgram(cl_program  program ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clRetainProgram(program));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseProgram(cl_program  program ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clReleaseProgram(program));
}

CL_API_ENTRY cl_int CL_API_CALL
clBuildProgram(cl_program            program ,
               cl_uint               num_devices ,
               const cl_device_id *  device_list ,
               const char *          options , 
               void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
               void *                user_data ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clBuildProgram(program, num_devices, device_list, options, pfn_notify, user_data));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetProgramInfo(cl_program          program ,
                 cl_program_info     param_name ,
                 size_t              param_value_size ,
                 void *              param_value ,
                 size_t *            param_value_size_ret ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clGetProgramInfo(program, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetProgramBuildInfo(cl_program             program ,
                      cl_device_id           device ,
                      cl_program_build_info  param_name ,
                      size_t                 param_value_size ,
                      void *                 param_value ,
                      size_t *               param_value_size_ret ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clGetProgramBuildInfo(program, device, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_kernel CL_API_CALL
clCreateKernel(cl_program       program ,
               const char *     kernel_name ,
               cl_int *         errcode_ret ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_PROGRAM;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCreateKernel(program, kernel_name, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clCreateKernelsInProgram(cl_program      program ,
                         cl_uint         num_kernels ,
                         cl_kernel *     kernels ,
                         cl_uint *       num_kernels_ret ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCreateKernelsInProgram(program, num_kernels, kernels, num_kernels_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainKernel(cl_kernel     kernel ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clRetainKernel(kernel));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseKernel(cl_kernel    kernel ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clReleaseKernel(kernel));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetKernelArg(cl_kernel     kernel ,
               cl_uint       arg_index ,
               size_t        arg_size ,
               const void *  arg_value ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelArg(kernel, arg_index, arg_size, arg_value));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelInfo(cl_kernel        kernel ,
                cl_kernel_info   param_name ,
                size_t           param_value_size ,
                void *           param_value ,
                size_t *         param_value_size_ret ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelInfo(kernel, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelWorkGroupInfo(cl_kernel                   kernel ,
                         cl_device_id                device ,
                         cl_kernel_work_group_info   param_name ,
                         size_t                      param_value_size ,
                         void *                      param_value ,
                         size_t *                    param_value_size_ret ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetEventInfo(cl_event          event ,
               cl_event_info     param_name ,
               size_t            param_value_size ,
               void *            param_value ,
               size_t *          param_value_size_ret ){
  debug_trace();
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clGetEventInfo(event, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainEvent(cl_event  event ){
  debug_trace();
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clRetainEvent(event));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseEvent(cl_event  event ){
  debug_trace();
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clReleaseEvent(event));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetEventProfilingInfo(cl_event             event ,
                        cl_profiling_info    param_name ,
                        size_t               param_value_size ,
                        void *               param_value ,
                        size_t *             param_value_size_ret ){
  debug_trace();
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clGetEventProfilingInfo(event, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clFlush(cl_command_queue  command_queue ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clFlush(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clFinish(cl_command_queue  command_queue ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clFinish(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReadBuffer(cl_command_queue     command_queue ,
                    cl_mem               buffer ,
                    cl_bool              blocking_read ,
                    size_t               offset ,
                    size_t               cb , 
                    void *               ptr ,
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWriteBuffer(cl_command_queue    command_queue , 
                     cl_mem              buffer , 
                     cl_bool             blocking_write , 
                     size_t              offset , 
                     size_t              cb , 
                     const void *        ptr , 
                     cl_uint             num_events_in_wait_list , 
                     const cl_event *    event_wait_list , 
                     cl_event *          event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyBuffer(cl_command_queue     command_queue , 
                    cl_mem               src_buffer ,
                    cl_mem               dst_buffer , 
                    size_t               src_offset ,
                    size_t               dst_offset ,
                    size_t               cb , 
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, cb, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReadImage(cl_command_queue      command_queue ,
                   cl_mem                image ,
                   cl_bool               blocking_read , 
                   const size_t *        origin ,
                   const size_t *        region ,
                   size_t                row_pitch ,
                   size_t                slice_pitch , 
                   void *                ptr ,
                   cl_uint               num_events_in_wait_list ,
                   const cl_event *      event_wait_list ,
                   cl_event *            event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadImage(command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWriteImage(cl_command_queue     command_queue ,
                    cl_mem               image ,
                    cl_bool              blocking_write , 
                    const size_t *       origin ,
                    const size_t *       region ,
                    size_t               input_row_pitch ,
                    size_t               input_slice_pitch , 
                    const void *         ptr ,
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteImage(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyImage(cl_command_queue      command_queue ,
                   cl_mem                src_image ,
                   cl_mem                dst_image , 
                   const size_t *        src_origin ,
                   const size_t *        dst_origin ,
                   const size_t *        region , 
                   cl_uint               num_events_in_wait_list ,
                   const cl_event *      event_wait_list ,
                   cl_event *            event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyImage(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyImageToBuffer(cl_command_queue  command_queue ,
                           cl_mem            src_image ,
                           cl_mem            dst_buffer , 
                           const size_t *    src_origin ,
                           const size_t *    region , 
                           size_t            dst_offset ,
                           cl_uint           num_events_in_wait_list ,
                           const cl_event *  event_wait_list ,
                           cl_event *        event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyBufferToImage(cl_command_queue  command_queue ,
                           cl_mem            src_buffer ,
                           cl_mem            dst_image , 
                           size_t            src_offset ,
                           const size_t *    dst_origin ,
                           const size_t *    region , 
                           cl_uint           num_events_in_wait_list ,
                           const cl_event *  event_wait_list ,
                           cl_event *        event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY void * CL_API_CALL
clEnqueueMapBuffer(cl_command_queue  command_queue ,
                   cl_mem            buffer ,
                   cl_bool           blocking_map , 
                   cl_map_flags      map_flags ,
                   size_t            offset ,
                   size_t            cb ,
                   cl_uint           num_events_in_wait_list ,
                   const cl_event *  event_wait_list ,
                   cl_event *        event ,
                   cl_int *          errcode_ret ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_COMMAND_QUEUE;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, cb, num_events_in_wait_list, event_wait_list, event, errcode_ret));
}

CL_API_ENTRY void * CL_API_CALL
clEnqueueMapImage(cl_command_queue   command_queue ,
                  cl_mem             image , 
                  cl_bool            blocking_map , 
                  cl_map_flags       map_flags , 
                  const size_t *     origin ,
                  const size_t *     region ,
                  size_t *           image_row_pitch ,
                  size_t *           image_slice_pitch ,
                  cl_uint            num_events_in_wait_list ,
                  const cl_event *   event_wait_list ,
                  cl_event *         event ,
                  cl_int *           errcode_ret ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_COMMAND_QUEUE;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMapImage(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueUnmapMemObject(cl_command_queue  command_queue ,
                        cl_mem            memobj ,
                        void *            mapped_ptr ,
                        cl_uint           num_events_in_wait_list ,
                        const cl_event *   event_wait_list ,
                        cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueUnmapMemObject(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueNDRangeKernel(cl_command_queue  command_queue ,
                       cl_kernel         kernel ,
                       cl_uint           work_dim ,
                       const size_t *    global_work_offset ,
                       const size_t *    global_work_size ,
                       const size_t *    local_work_size ,
                       cl_uint           num_events_in_wait_list ,
                       const cl_event *  event_wait_list ,
                       cl_event *        event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueNDRangeKernel(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueTask(cl_command_queue   command_queue ,
              cl_kernel          kernel ,
              cl_uint            num_events_in_wait_list ,
              const cl_event *   event_wait_list ,
              cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueTask(command_queue, kernel, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueNativeKernel(cl_command_queue   command_queue ,
					  void (*user_func)(void *), 
                      void *             args ,
                      size_t             cb_args , 
                      cl_uint            num_mem_objects ,
                      const cl_mem *     mem_list ,
                      const void **      args_mem_loc ,
                      cl_uint            num_events_in_wait_list ,
                      const cl_event *   event_wait_list ,
                      cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueNativeKernel(command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueMarker(cl_command_queue     command_queue ,
                cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMarker(command_queue, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWaitForEvents(cl_command_queue  command_queue ,
                       cl_uint           num_events ,
                       const cl_event *  event_list ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWaitForEvents(command_queue, num_events, event_list));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueBarrier(cl_command_queue  command_queue ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueBarrier(command_queue));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLBuffer(cl_context      context ,
                     cl_mem_flags    flags ,
                     cl_GLuint       bufobj ,
                     int *           errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLBuffer(context, flags, bufobj, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLTexture2D(cl_context       context ,
                        cl_mem_flags     flags ,
                        cl_GLenum        target ,
                        cl_GLint         miplevel ,
                        cl_GLuint        texture ,
                        cl_int *         errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture2D(context, flags, target, miplevel, texture, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLTexture3D(cl_context       context ,
                        cl_mem_flags     flags ,
                        cl_GLenum        target ,
                        cl_GLint         miplevel ,
                        cl_GLuint        texture ,
                        cl_int *         errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture3D(context, flags, target, miplevel, texture, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLRenderbuffer(cl_context    context ,
                           cl_mem_flags  flags ,
                           cl_GLuint     renderbuffer ,
                           cl_int *      errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLRenderbuffer(context, flags, renderbuffer, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetGLObjectInfo(cl_mem                 memobj ,
                  cl_gl_object_type *    gl_object_type ,
                  cl_GLuint *               gl_object_name ){
  debug_trace();
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetGLObjectInfo(memobj, gl_object_type, gl_object_name));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetGLTextureInfo(cl_mem                memobj ,
                   cl_gl_texture_info    param_name ,
                   size_t                param_value_size ,
                   void *                param_value ,
                   size_t *              param_value_size_ret ){
  debug_trace();
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetGLTextureInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueAcquireGLObjects(cl_command_queue       command_queue ,
                          cl_uint                num_objects ,
                          const cl_mem *         mem_objects ,
                          cl_uint                num_events_in_wait_list ,
                          const cl_event *       event_wait_list ,
                          cl_event *             event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueAcquireGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReleaseGLObjects(cl_command_queue       command_queue ,
                          cl_uint                num_objects ,
                          const cl_mem *         mem_objects ,
                          cl_uint                num_events_in_wait_list ,
                          const cl_event *       event_wait_list ,
                          cl_event *             event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReleaseGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetEventCallback(cl_event     event ,
                   cl_int       command_exec_callback_type ,
                   void (CL_CALLBACK *  pfn_notify )(cl_event, cl_int, void *),
                   void *       user_data ){
  debug_trace();
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clSetEventCallback(event, command_exec_callback_type, pfn_notify, user_data));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateSubBuffer(cl_mem                    buffer ,
                  cl_mem_flags              flags ,
                  cl_buffer_create_type     buffer_create_type ,
                  const void *              buffer_create_info ,
                  cl_int *                  errcode_ret ){
  debug_trace();
  if( (struct _cl_mem *)buffer == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_MEM_OBJECT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_mem *)buffer)->dispatch->clCreateSubBuffer(buffer, flags, buffer_create_type, buffer_create_info, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetMemObjectDestructorCallback(cl_mem  memobj ,
                                 void (CL_CALLBACK * pfn_notify)( cl_mem  memobj , void* user_data),
                                 void * user_data  ){
  debug_trace();
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clSetMemObjectDestructorCallback(memobj, pfn_notify, user_data));
}

CL_API_ENTRY cl_event CL_API_CALL
clCreateUserEvent(cl_context     context ,
                  cl_int *       errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateUserEvent(context, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetUserEventStatus(cl_event    event ,
                     cl_int      execution_status ){
  debug_trace();
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clSetUserEventStatus(event, execution_status));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReadBufferRect(cl_command_queue     command_queue ,
                        cl_mem               buffer ,
                        cl_bool              blocking_read ,
                        const size_t *       buffer_origin ,
                        const size_t *       host_origin , 
                        const size_t *       region ,
                        size_t               buffer_row_pitch ,
                        size_t               buffer_slice_pitch ,
                        size_t               host_row_pitch ,
                        size_t               host_slice_pitch ,                        
                        void *               ptr ,
                        cl_uint              num_events_in_wait_list ,
                        const cl_event *     event_wait_list ,
                        cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadBufferRect(command_queue, buffer, blocking_read, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWriteBufferRect(cl_command_queue     command_queue ,
                         cl_mem               buffer ,
                         cl_bool              blocking_write ,
                         const size_t *       buffer_origin ,
                         const size_t *       host_origin , 
                         const size_t *       region ,
                         size_t               buffer_row_pitch ,
                         size_t               buffer_slice_pitch ,
                         size_t               host_row_pitch ,
                         size_t               host_slice_pitch ,                        
                         const void *         ptr ,
                         cl_uint              num_events_in_wait_list ,
                         const cl_event *     event_wait_list ,
                         cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteBufferRect(command_queue, buffer, blocking_write, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyBufferRect(cl_command_queue     command_queue , 
                        cl_mem               src_buffer ,
                        cl_mem               dst_buffer , 
                        const size_t *       src_origin ,
                        const size_t *       dst_origin ,
                        const size_t *       region , 
                        size_t               src_row_pitch ,
                        size_t               src_slice_pitch ,
                        size_t               dst_row_pitch ,
                        size_t               dst_slice_pitch ,
                        cl_uint              num_events_in_wait_list ,
                        const cl_event *     event_wait_list ,
                        cl_event *           event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clCreateSubDevicesEXT(cl_device_id in_device,
                      const cl_device_partition_property_ext *  properties ,
                      cl_uint num_entries,
                      cl_device_id * out_devices,
                      cl_uint * num_devices ){
  debug_trace();
  if( (struct _cl_device_id *)in_device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)in_device)->dispatch->clCreateSubDevicesEXT(in_device, properties, num_entries, out_devices, num_devices));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainDeviceEXT( cl_device_id device ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clRetainDeviceEXT(device));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseDeviceEXT( cl_device_id device ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clReleaseDeviceEXT(device));
}

CL_API_ENTRY cl_event CL_API_CALL
clCreateEventFromGLsyncKHR(cl_context            context ,
                           cl_GLsync             cl_GLsync ,
                           cl_int *              errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateEventFromGLsyncKHR(context, cl_GLsync, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clCreateSubDevices(cl_device_id                          in_device ,
                   const cl_device_partition_property *  properties ,
                   cl_uint                               num_devices ,
                   cl_device_id *                        out_devices ,
                   cl_uint *                             num_devices_ret ){
  debug_trace();
  if( (struct _cl_device_id *)in_device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)in_device)->dispatch->clCreateSubDevices(in_device, properties, num_devices, out_devices, num_devices_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainDevice(cl_device_id  device ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clRetainDevice(device));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseDevice(cl_device_id  device ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clReleaseDevice(device));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImage(cl_context               context ,
              cl_mem_flags             flags ,
              const cl_image_format *  image_format ,
              const cl_image_desc *    image_desc , 
              void *                   host_ptr ,
              cl_int *                 errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage(context, flags, image_format, image_desc, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithBuiltInKernels(cl_context             context ,
                                  cl_uint                num_devices ,
                                  const cl_device_id *   device_list ,
                                  const char *           kernel_names ,
                                  cl_int *               errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithBuiltInKernels(context, num_devices, device_list, kernel_names, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clCompileProgram(cl_program            program ,
                 cl_uint               num_devices ,
                 const cl_device_id *  device_list ,
                 const char *          options , 
                 cl_uint               num_input_headers ,
                 const cl_program *    input_headers ,
                 const char **         header_include_names ,
                 void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
                 void *                user_data ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCompileProgram(program, num_devices, device_list, options, num_input_headers, input_headers, header_include_names, pfn_notify, user_data));
}

CL_API_ENTRY cl_program CL_API_CALL
clLinkProgram(cl_context            context ,
              cl_uint               num_devices ,
              const cl_device_id *  device_list ,
              const char *          options , 
              cl_uint               num_input_programs ,
              const cl_program *    input_programs ,
              void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
              void *                user_data ,
              cl_int *              errcode_ret  ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clLinkProgram(context, num_devices, device_list, options, num_input_programs, input_programs, pfn_notify, user_data, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clUnloadPlatformCompiler(cl_platform_id  platform ){
  debug_trace();
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clUnloadPlatformCompiler(platform));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelArgInfo(cl_kernel        kernel ,
                   cl_uint          arg_indx ,
                   cl_kernel_arg_info   param_name ,
                   size_t           param_value_size ,
                   void *           param_value ,
                   size_t *         param_value_size_ret ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueFillBuffer(cl_command_queue    command_queue ,
                    cl_mem              buffer , 
                    const void *        pattern , 
                    size_t              pattern_size , 
                    size_t              offset , 
                    size_t              size , 
                    cl_uint             num_events_in_wait_list , 
                    const cl_event *    event_wait_list , 
                    cl_event *          event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueFillBuffer(command_queue, buffer, pattern, pattern_size, offset, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueFillImage(cl_command_queue    command_queue ,
                   cl_mem              image , 
                   const void *        fill_color , 
                   const size_t *      origin , 
                   const size_t *      region , 
                   cl_uint             num_events_in_wait_list , 
                   const cl_event *    event_wait_list , 
                   cl_event *          event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueFillImage(command_queue, image, fill_color, origin, region, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueMigrateMemObjects(cl_command_queue        command_queue ,
                           cl_uint                 num_mem_objects ,
                           const cl_mem *          mem_objects ,
                           cl_mem_migration_flags  flags ,
                           cl_uint                 num_events_in_wait_list ,
                           const cl_event *        event_wait_list ,
                           cl_event *              event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMigrateMemObjects(command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueMarkerWithWaitList(cl_command_queue  command_queue ,
                            cl_uint            num_events_in_wait_list ,
                            const cl_event *   event_wait_list ,
                            cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMarkerWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueBarrierWithWaitList(cl_command_queue  command_queue ,
                             cl_uint            num_events_in_wait_list ,
                             const cl_event *   event_wait_list ,
                             cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueBarrierWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY void * CL_API_CALL 
clGetExtensionFunctionAddressForPlatform(cl_platform_id  platform ,
                                         const char *    func_name ){
  debug_trace();
  if( func_name == NULL )
    return NULL;
  struct func_desc const * fn=&function_description[0];
  int lenfn=strlen(func_name);
  if (lenfn > 3 &&
      (strcmp(func_name+lenfn-3, "KHR")==0 || strcmp(func_name+lenfn-3, "EXT")==0)) {
    while (fn->name != NULL) {
      if (strcmp(func_name, fn->name)==0)
        RETURN(fn->addr);
      fn++;
    }
  }
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(NULL);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetExtensionFunctionAddressForPlatform(platform, func_name));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLTexture(cl_context       context ,
                      cl_mem_flags     flags ,
                      cl_GLenum        target ,
                      cl_GLint         miplevel ,
                      cl_GLuint        texture ,
                      cl_int *         errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture(context, flags, target, miplevel, texture, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromEGLImageKHR(cl_context                   context ,
                        CLeglDisplayKHR              egldisplay ,
                        CLeglImageKHR                eglimage ,
                        cl_mem_flags                 flags ,
                        const cl_egl_image_properties_khr *  properties ,
                        cl_int *                     errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromEGLImageKHR(context, egldisplay, eglimage, flags, properties, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueAcquireEGLObjectsKHR(cl_command_queue  command_queue ,
                              cl_uint           num_objects ,
                              const cl_mem *    mem_objects ,
                              cl_uint           num_events_in_wait_list ,
                              const cl_event *  event_wait_list ,
                              cl_event *        event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueAcquireEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReleaseEGLObjectsKHR(cl_command_queue  command_queue ,
                              cl_uint           num_objects ,
                              const cl_mem *    mem_objects ,
                              cl_uint           num_events_in_wait_list ,
                              const cl_event *  event_wait_list ,
                              cl_event *        event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReleaseEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_event CL_API_CALL
clCreateEventFromEGLSyncKHR(cl_context       context ,
                            CLeglSyncKHR     sync ,
                            CLeglDisplayKHR  display ,
                            cl_int *         errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateEventFromEGLSyncKHR(context, sync, display, errcode_ret));
}

CL_API_ENTRY cl_command_queue CL_API_CALL
clCreateCommandQueueWithProperties(cl_context                context ,
                                   cl_device_id              device ,
                                   const cl_queue_properties *     properties ,
                                   cl_int *                  errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateCommandQueueWithProperties(context, device, properties, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreatePipe(cl_context                  context ,
             cl_mem_flags                flags ,
             cl_uint                     pipe_packet_size ,
             cl_uint                     pipe_max_packets ,
             const cl_pipe_properties *  properties ,
             cl_int *                    errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, properties, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetPipeInfo(cl_mem            pipe ,
              cl_pipe_info      param_name ,
              size_t            param_value_size ,
              void *            param_value ,
              size_t *          param_value_size_ret ){
  debug_trace();
  if( (struct _cl_mem *)pipe == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)pipe)->dispatch->clGetPipeInfo(pipe, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY void * CL_API_CALL
clSVMAlloc(cl_context        context ,
           cl_svm_mem_flags  flags ,
           size_t            size ,
           cl_uint           alignment ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSVMAlloc(context, flags, size, alignment));
}

CL_API_ENTRY void CL_API_CALL
clSVMFree(cl_context         context ,
          void *             svm_pointer ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    return;
  }
  return(((struct _cl_context *)context)->dispatch->clSVMFree(context, svm_pointer));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMFree(cl_command_queue   command_queue ,
                 cl_uint            num_svm_pointers ,
                 void *             svm_pointers[] ,
                 void (CL_CALLBACK * pfn_free_func)(cl_command_queue  queue ,
                                                        cl_uint           num_svm_pointers ,
                                                        void *            svm_pointers[] ,
                                                        void *            user_data ),
                 void *             user_data ,
                 cl_uint            num_events_in_wait_list ,
                 const cl_event *   event_wait_list ,
                 cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMFree(command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMemcpy(cl_command_queue   command_queue ,
                   cl_bool            blocking_copy ,
                   void *             dst_ptr ,
                   const void *       src_ptr ,
                   size_t             size ,
                   cl_uint            num_events_in_wait_list ,
                   const cl_event *   event_wait_list ,
                   cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMemcpy(command_queue, blocking_copy, dst_ptr, src_ptr, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMemFill(cl_command_queue   command_queue ,
                    void *             svm_ptr ,
                    const void *       pattern ,
                    size_t             pattern_size ,
                    size_t             size ,
                    cl_uint            num_events_in_wait_list ,
                    const cl_event *   event_wait_list ,
                    cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMemFill(command_queue, svm_ptr, pattern, pattern_size, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMap(cl_command_queue   command_queue ,
                cl_bool            blocking_map ,
                cl_map_flags       flags ,
                void *             svm_ptr ,
                size_t             size ,
                cl_uint            num_events_in_wait_list ,
                const cl_event *   event_wait_list ,
                cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMap(command_queue, blocking_map, flags, svm_ptr, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMUnmap(cl_command_queue   command_queue ,
                  void *             svm_ptr ,
                  cl_uint            num_events_in_wait_list ,
                  const cl_event *   event_wait_list ,
                  cl_event *         event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMUnmap(command_queue, svm_ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_sampler CL_API_CALL
clCreateSamplerWithProperties(cl_context                      context ,
                              const cl_sampler_properties *   normalized_coords ,
                              cl_int *                        errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateSamplerWithProperties(context, normalized_coords, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetKernelArgSVMPointer(cl_kernel     kernel ,
                         cl_uint       arg_index ,
                         const void *  arg_value ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelArgSVMPointer(kernel, arg_index, arg_value));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetKernelExecInfo(cl_kernel             kernel ,
                    cl_kernel_exec_info   param_name ,
                    size_t                param_value_size ,
                    const void *          param_value ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelExecInfo(kernel, param_name, param_value_size, param_value));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelSubGroupInfoKHR(cl_kernel  in_kernel ,
                           cl_device_id in_device,
                           cl_kernel_sub_group_info  param_name ,
                           size_t input_value_size,
                           const void * input_value,
                           size_t param_value_size,
                           void* param_value,
                           size_t* param_value_size_ret ){
  debug_trace();
  if( (struct _cl_kernel *)in_kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)in_kernel)->dispatch->clGetKernelSubGroupInfoKHR(in_kernel, in_device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_kernel CL_API_CALL
clCloneKernel(cl_kernel      source_kernel ,
              cl_int*        errcode_ret ){
  debug_trace();
  if( (struct _cl_kernel *)source_kernel == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_KERNEL;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_kernel *)source_kernel)->dispatch->clCloneKernel(source_kernel, errcode_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithIL(cl_context     context ,
                      const void*     il ,
                      size_t          length ,
                      cl_int*         errcode_ret ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithIL(context, il, length, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMigrateMem(cl_command_queue          command_queue ,
                       cl_uint                   num_svm_pointers ,
                       const void **             svm_pointers ,
                       const size_t *            sizes ,
                       cl_mem_migration_flags    flags ,
                       cl_uint                   num_events_in_wait_list ,
                       const cl_event *          event_wait_list ,
                       cl_event *                event ){
  debug_trace();
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMigrateMem(command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetDeviceAndHostTimer(cl_device_id     device ,
                        cl_ulong*        device_timestamp ,
                        cl_ulong*        host_timestamp ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetDeviceAndHostTimer(device, device_timestamp, host_timestamp));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetHostTimer(cl_device_id  device ,
               cl_ulong *    host_timestamp ){
  debug_trace();
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetHostTimer(device, host_timestamp));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelSubGroupInfo(cl_kernel                    kernel ,
                        cl_device_id                 device ,
                        cl_kernel_sub_group_info     param_name ,
                        size_t                       input_value_size ,
                        const void*                  input_value ,
                        size_t                       param_value_size ,
                        void*                        param_value ,
                        size_t*                      param_value_size_ret  ){
  debug_trace();
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetDefaultDeviceCommandQueue(cl_context            context ,
                               cl_device_id          device ,
                               cl_command_queue      command_queue ){
  debug_trace();
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSetDefaultDeviceCommandQueue(context, device, command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetProgramReleaseCallback(cl_program           program ,
                            void (CL_CALLBACK *  pfn_notify )(cl_program  program , void *  user_data ),
                            void *               user_data ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clSetProgramReleaseCallback(program, pfn_notify, user_data));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetProgramSpecializationConstant(cl_program   program ,
                                   cl_uint      spec_id ,
                                   size_t       spec_size ,
                                   const void*  spec_value ){
  debug_trace();
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clSetProgramSpecializationConstant(program, spec_id, spec_size, spec_value));
}

#pragma GCC visibility push(hidden)

extern typeof(clGetPlatformIDs) clGetPlatformIDs_hid;
typeof(clGetPlatformInfo) clGetPlatformInfo_hid __attribute__ ((alias ("clGetPlatformInfo"), visibility("hidden")));
typeof(clGetDeviceIDs) clGetDeviceIDs_hid __attribute__ ((alias ("clGetDeviceIDs"), visibility("hidden")));
typeof(clGetDeviceInfo) clGetDeviceInfo_hid __attribute__ ((alias ("clGetDeviceInfo"), visibility("hidden")));
extern typeof(clCreateContext) clCreateContext_hid;
extern typeof(clCreateContextFromType) clCreateContextFromType_hid;
typeof(clRetainContext) clRetainContext_hid __attribute__ ((alias ("clRetainContext"), visibility("hidden")));
typeof(clReleaseContext) clReleaseContext_hid __attribute__ ((alias ("clReleaseContext"), visibility("hidden")));
typeof(clGetContextInfo) clGetContextInfo_hid __attribute__ ((alias ("clGetContextInfo"), visibility("hidden")));
typeof(clCreateCommandQueue) clCreateCommandQueue_hid __attribute__ ((alias ("clCreateCommandQueue"), visibility("hidden")));
typeof(clRetainCommandQueue) clRetainCommandQueue_hid __attribute__ ((alias ("clRetainCommandQueue"), visibility("hidden")));
typeof(clReleaseCommandQueue) clReleaseCommandQueue_hid __attribute__ ((alias ("clReleaseCommandQueue"), visibility("hidden")));
typeof(clGetCommandQueueInfo) clGetCommandQueueInfo_hid __attribute__ ((alias ("clGetCommandQueueInfo"), visibility("hidden")));
typeof(clSetCommandQueueProperty) clSetCommandQueueProperty_hid __attribute__ ((alias ("clSetCommandQueueProperty"), visibility("hidden")));
typeof(clCreateBuffer) clCreateBuffer_hid __attribute__ ((alias ("clCreateBuffer"), visibility("hidden")));
typeof(clCreateImage2D) clCreateImage2D_hid __attribute__ ((alias ("clCreateImage2D"), visibility("hidden")));
typeof(clCreateImage3D) clCreateImage3D_hid __attribute__ ((alias ("clCreateImage3D"), visibility("hidden")));
typeof(clRetainMemObject) clRetainMemObject_hid __attribute__ ((alias ("clRetainMemObject"), visibility("hidden")));
typeof(clReleaseMemObject) clReleaseMemObject_hid __attribute__ ((alias ("clReleaseMemObject"), visibility("hidden")));
typeof(clGetSupportedImageFormats) clGetSupportedImageFormats_hid __attribute__ ((alias ("clGetSupportedImageFormats"), visibility("hidden")));
typeof(clGetMemObjectInfo) clGetMemObjectInfo_hid __attribute__ ((alias ("clGetMemObjectInfo"), visibility("hidden")));
typeof(clGetImageInfo) clGetImageInfo_hid __attribute__ ((alias ("clGetImageInfo"), visibility("hidden")));
typeof(clCreateSampler) clCreateSampler_hid __attribute__ ((alias ("clCreateSampler"), visibility("hidden")));
typeof(clRetainSampler) clRetainSampler_hid __attribute__ ((alias ("clRetainSampler"), visibility("hidden")));
typeof(clReleaseSampler) clReleaseSampler_hid __attribute__ ((alias ("clReleaseSampler"), visibility("hidden")));
typeof(clGetSamplerInfo) clGetSamplerInfo_hid __attribute__ ((alias ("clGetSamplerInfo"), visibility("hidden")));
typeof(clCreateProgramWithSource) clCreateProgramWithSource_hid __attribute__ ((alias ("clCreateProgramWithSource"), visibility("hidden")));
typeof(clCreateProgramWithBinary) clCreateProgramWithBinary_hid __attribute__ ((alias ("clCreateProgramWithBinary"), visibility("hidden")));
typeof(clRetainProgram) clRetainProgram_hid __attribute__ ((alias ("clRetainProgram"), visibility("hidden")));
typeof(clReleaseProgram) clReleaseProgram_hid __attribute__ ((alias ("clReleaseProgram"), visibility("hidden")));
typeof(clBuildProgram) clBuildProgram_hid __attribute__ ((alias ("clBuildProgram"), visibility("hidden")));
extern typeof(clUnloadCompiler) clUnloadCompiler_hid;
typeof(clGetProgramInfo) clGetProgramInfo_hid __attribute__ ((alias ("clGetProgramInfo"), visibility("hidden")));
typeof(clGetProgramBuildInfo) clGetProgramBuildInfo_hid __attribute__ ((alias ("clGetProgramBuildInfo"), visibility("hidden")));
typeof(clCreateKernel) clCreateKernel_hid __attribute__ ((alias ("clCreateKernel"), visibility("hidden")));
typeof(clCreateKernelsInProgram) clCreateKernelsInProgram_hid __attribute__ ((alias ("clCreateKernelsInProgram"), visibility("hidden")));
typeof(clRetainKernel) clRetainKernel_hid __attribute__ ((alias ("clRetainKernel"), visibility("hidden")));
typeof(clReleaseKernel) clReleaseKernel_hid __attribute__ ((alias ("clReleaseKernel"), visibility("hidden")));
typeof(clSetKernelArg) clSetKernelArg_hid __attribute__ ((alias ("clSetKernelArg"), visibility("hidden")));
typeof(clGetKernelInfo) clGetKernelInfo_hid __attribute__ ((alias ("clGetKernelInfo"), visibility("hidden")));
typeof(clGetKernelWorkGroupInfo) clGetKernelWorkGroupInfo_hid __attribute__ ((alias ("clGetKernelWorkGroupInfo"), visibility("hidden")));
extern typeof(clWaitForEvents) clWaitForEvents_hid;
typeof(clGetEventInfo) clGetEventInfo_hid __attribute__ ((alias ("clGetEventInfo"), visibility("hidden")));
typeof(clRetainEvent) clRetainEvent_hid __attribute__ ((alias ("clRetainEvent"), visibility("hidden")));
typeof(clReleaseEvent) clReleaseEvent_hid __attribute__ ((alias ("clReleaseEvent"), visibility("hidden")));
typeof(clGetEventProfilingInfo) clGetEventProfilingInfo_hid __attribute__ ((alias ("clGetEventProfilingInfo"), visibility("hidden")));
typeof(clFlush) clFlush_hid __attribute__ ((alias ("clFlush"), visibility("hidden")));
typeof(clFinish) clFinish_hid __attribute__ ((alias ("clFinish"), visibility("hidden")));
typeof(clEnqueueReadBuffer) clEnqueueReadBuffer_hid __attribute__ ((alias ("clEnqueueReadBuffer"), visibility("hidden")));
typeof(clEnqueueWriteBuffer) clEnqueueWriteBuffer_hid __attribute__ ((alias ("clEnqueueWriteBuffer"), visibility("hidden")));
typeof(clEnqueueCopyBuffer) clEnqueueCopyBuffer_hid __attribute__ ((alias ("clEnqueueCopyBuffer"), visibility("hidden")));
typeof(clEnqueueReadImage) clEnqueueReadImage_hid __attribute__ ((alias ("clEnqueueReadImage"), visibility("hidden")));
typeof(clEnqueueWriteImage) clEnqueueWriteImage_hid __attribute__ ((alias ("clEnqueueWriteImage"), visibility("hidden")));
typeof(clEnqueueCopyImage) clEnqueueCopyImage_hid __attribute__ ((alias ("clEnqueueCopyImage"), visibility("hidden")));
typeof(clEnqueueCopyImageToBuffer) clEnqueueCopyImageToBuffer_hid __attribute__ ((alias ("clEnqueueCopyImageToBuffer"), visibility("hidden")));
typeof(clEnqueueCopyBufferToImage) clEnqueueCopyBufferToImage_hid __attribute__ ((alias ("clEnqueueCopyBufferToImage"), visibility("hidden")));
typeof(clEnqueueMapBuffer) clEnqueueMapBuffer_hid __attribute__ ((alias ("clEnqueueMapBuffer"), visibility("hidden")));
typeof(clEnqueueMapImage) clEnqueueMapImage_hid __attribute__ ((alias ("clEnqueueMapImage"), visibility("hidden")));
typeof(clEnqueueUnmapMemObject) clEnqueueUnmapMemObject_hid __attribute__ ((alias ("clEnqueueUnmapMemObject"), visibility("hidden")));
typeof(clEnqueueNDRangeKernel) clEnqueueNDRangeKernel_hid __attribute__ ((alias ("clEnqueueNDRangeKernel"), visibility("hidden")));
typeof(clEnqueueTask) clEnqueueTask_hid __attribute__ ((alias ("clEnqueueTask"), visibility("hidden")));
typeof(clEnqueueNativeKernel) clEnqueueNativeKernel_hid __attribute__ ((alias ("clEnqueueNativeKernel"), visibility("hidden")));
typeof(clEnqueueMarker) clEnqueueMarker_hid __attribute__ ((alias ("clEnqueueMarker"), visibility("hidden")));
typeof(clEnqueueWaitForEvents) clEnqueueWaitForEvents_hid __attribute__ ((alias ("clEnqueueWaitForEvents"), visibility("hidden")));
typeof(clEnqueueBarrier) clEnqueueBarrier_hid __attribute__ ((alias ("clEnqueueBarrier"), visibility("hidden")));
extern typeof(clGetExtensionFunctionAddress) clGetExtensionFunctionAddress_hid;
typeof(clCreateFromGLBuffer) clCreateFromGLBuffer_hid __attribute__ ((alias ("clCreateFromGLBuffer"), visibility("hidden")));
typeof(clCreateFromGLTexture2D) clCreateFromGLTexture2D_hid __attribute__ ((alias ("clCreateFromGLTexture2D"), visibility("hidden")));
typeof(clCreateFromGLTexture3D) clCreateFromGLTexture3D_hid __attribute__ ((alias ("clCreateFromGLTexture3D"), visibility("hidden")));
typeof(clCreateFromGLRenderbuffer) clCreateFromGLRenderbuffer_hid __attribute__ ((alias ("clCreateFromGLRenderbuffer"), visibility("hidden")));
typeof(clGetGLObjectInfo) clGetGLObjectInfo_hid __attribute__ ((alias ("clGetGLObjectInfo"), visibility("hidden")));
typeof(clGetGLTextureInfo) clGetGLTextureInfo_hid __attribute__ ((alias ("clGetGLTextureInfo"), visibility("hidden")));
typeof(clEnqueueAcquireGLObjects) clEnqueueAcquireGLObjects_hid __attribute__ ((alias ("clEnqueueAcquireGLObjects"), visibility("hidden")));
typeof(clEnqueueReleaseGLObjects) clEnqueueReleaseGLObjects_hid __attribute__ ((alias ("clEnqueueReleaseGLObjects"), visibility("hidden")));
extern typeof(clGetGLContextInfoKHR) clGetGLContextInfoKHR_hid;
typeof(clSetEventCallback) clSetEventCallback_hid __attribute__ ((alias ("clSetEventCallback"), visibility("hidden")));
typeof(clCreateSubBuffer) clCreateSubBuffer_hid __attribute__ ((alias ("clCreateSubBuffer"), visibility("hidden")));
typeof(clSetMemObjectDestructorCallback) clSetMemObjectDestructorCallback_hid __attribute__ ((alias ("clSetMemObjectDestructorCallback"), visibility("hidden")));
typeof(clCreateUserEvent) clCreateUserEvent_hid __attribute__ ((alias ("clCreateUserEvent"), visibility("hidden")));
typeof(clSetUserEventStatus) clSetUserEventStatus_hid __attribute__ ((alias ("clSetUserEventStatus"), visibility("hidden")));
typeof(clEnqueueReadBufferRect) clEnqueueReadBufferRect_hid __attribute__ ((alias ("clEnqueueReadBufferRect"), visibility("hidden")));
typeof(clEnqueueWriteBufferRect) clEnqueueWriteBufferRect_hid __attribute__ ((alias ("clEnqueueWriteBufferRect"), visibility("hidden")));
typeof(clEnqueueCopyBufferRect) clEnqueueCopyBufferRect_hid __attribute__ ((alias ("clEnqueueCopyBufferRect"), visibility("hidden")));
typeof(clCreateSubDevicesEXT) clCreateSubDevicesEXT_hid __attribute__ ((alias ("clCreateSubDevicesEXT"), visibility("hidden")));
typeof(clRetainDeviceEXT) clRetainDeviceEXT_hid __attribute__ ((alias ("clRetainDeviceEXT"), visibility("hidden")));
typeof(clReleaseDeviceEXT) clReleaseDeviceEXT_hid __attribute__ ((alias ("clReleaseDeviceEXT"), visibility("hidden")));
typeof(clCreateEventFromGLsyncKHR) clCreateEventFromGLsyncKHR_hid __attribute__ ((alias ("clCreateEventFromGLsyncKHR"), visibility("hidden")));
typeof(clCreateSubDevices) clCreateSubDevices_hid __attribute__ ((alias ("clCreateSubDevices"), visibility("hidden")));
typeof(clRetainDevice) clRetainDevice_hid __attribute__ ((alias ("clRetainDevice"), visibility("hidden")));
typeof(clReleaseDevice) clReleaseDevice_hid __attribute__ ((alias ("clReleaseDevice"), visibility("hidden")));
typeof(clCreateImage) clCreateImage_hid __attribute__ ((alias ("clCreateImage"), visibility("hidden")));
typeof(clCreateProgramWithBuiltInKernels) clCreateProgramWithBuiltInKernels_hid __attribute__ ((alias ("clCreateProgramWithBuiltInKernels"), visibility("hidden")));
typeof(clCompileProgram) clCompileProgram_hid __attribute__ ((alias ("clCompileProgram"), visibility("hidden")));
typeof(clLinkProgram) clLinkProgram_hid __attribute__ ((alias ("clLinkProgram"), visibility("hidden")));
typeof(clUnloadPlatformCompiler) clUnloadPlatformCompiler_hid __attribute__ ((alias ("clUnloadPlatformCompiler"), visibility("hidden")));
typeof(clGetKernelArgInfo) clGetKernelArgInfo_hid __attribute__ ((alias ("clGetKernelArgInfo"), visibility("hidden")));
typeof(clEnqueueFillBuffer) clEnqueueFillBuffer_hid __attribute__ ((alias ("clEnqueueFillBuffer"), visibility("hidden")));
typeof(clEnqueueFillImage) clEnqueueFillImage_hid __attribute__ ((alias ("clEnqueueFillImage"), visibility("hidden")));
typeof(clEnqueueMigrateMemObjects) clEnqueueMigrateMemObjects_hid __attribute__ ((alias ("clEnqueueMigrateMemObjects"), visibility("hidden")));
typeof(clEnqueueMarkerWithWaitList) clEnqueueMarkerWithWaitList_hid __attribute__ ((alias ("clEnqueueMarkerWithWaitList"), visibility("hidden")));
typeof(clEnqueueBarrierWithWaitList) clEnqueueBarrierWithWaitList_hid __attribute__ ((alias ("clEnqueueBarrierWithWaitList"), visibility("hidden")));
typeof(clGetExtensionFunctionAddressForPlatform) clGetExtensionFunctionAddressForPlatform_hid __attribute__ ((alias ("clGetExtensionFunctionAddressForPlatform"), visibility("hidden")));
typeof(clCreateFromGLTexture) clCreateFromGLTexture_hid __attribute__ ((alias ("clCreateFromGLTexture"), visibility("hidden")));
typeof(clCreateFromEGLImageKHR) clCreateFromEGLImageKHR_hid __attribute__ ((alias ("clCreateFromEGLImageKHR"), visibility("hidden")));
typeof(clEnqueueAcquireEGLObjectsKHR) clEnqueueAcquireEGLObjectsKHR_hid __attribute__ ((alias ("clEnqueueAcquireEGLObjectsKHR"), visibility("hidden")));
typeof(clEnqueueReleaseEGLObjectsKHR) clEnqueueReleaseEGLObjectsKHR_hid __attribute__ ((alias ("clEnqueueReleaseEGLObjectsKHR"), visibility("hidden")));
typeof(clCreateEventFromEGLSyncKHR) clCreateEventFromEGLSyncKHR_hid __attribute__ ((alias ("clCreateEventFromEGLSyncKHR"), visibility("hidden")));
typeof(clCreateCommandQueueWithProperties) clCreateCommandQueueWithProperties_hid __attribute__ ((alias ("clCreateCommandQueueWithProperties"), visibility("hidden")));
typeof(clCreatePipe) clCreatePipe_hid __attribute__ ((alias ("clCreatePipe"), visibility("hidden")));
typeof(clGetPipeInfo) clGetPipeInfo_hid __attribute__ ((alias ("clGetPipeInfo"), visibility("hidden")));
typeof(clSVMAlloc) clSVMAlloc_hid __attribute__ ((alias ("clSVMAlloc"), visibility("hidden")));
typeof(clSVMFree) clSVMFree_hid __attribute__ ((alias ("clSVMFree"), visibility("hidden")));
typeof(clEnqueueSVMFree) clEnqueueSVMFree_hid __attribute__ ((alias ("clEnqueueSVMFree"), visibility("hidden")));
typeof(clEnqueueSVMMemcpy) clEnqueueSVMMemcpy_hid __attribute__ ((alias ("clEnqueueSVMMemcpy"), visibility("hidden")));
typeof(clEnqueueSVMMemFill) clEnqueueSVMMemFill_hid __attribute__ ((alias ("clEnqueueSVMMemFill"), visibility("hidden")));
typeof(clEnqueueSVMMap) clEnqueueSVMMap_hid __attribute__ ((alias ("clEnqueueSVMMap"), visibility("hidden")));
typeof(clEnqueueSVMUnmap) clEnqueueSVMUnmap_hid __attribute__ ((alias ("clEnqueueSVMUnmap"), visibility("hidden")));
typeof(clCreateSamplerWithProperties) clCreateSamplerWithProperties_hid __attribute__ ((alias ("clCreateSamplerWithProperties"), visibility("hidden")));
typeof(clSetKernelArgSVMPointer) clSetKernelArgSVMPointer_hid __attribute__ ((alias ("clSetKernelArgSVMPointer"), visibility("hidden")));
typeof(clSetKernelExecInfo) clSetKernelExecInfo_hid __attribute__ ((alias ("clSetKernelExecInfo"), visibility("hidden")));
typeof(clGetKernelSubGroupInfoKHR) clGetKernelSubGroupInfoKHR_hid __attribute__ ((alias ("clGetKernelSubGroupInfoKHR"), visibility("hidden")));
typeof(clCloneKernel) clCloneKernel_hid __attribute__ ((alias ("clCloneKernel"), visibility("hidden")));
typeof(clCreateProgramWithIL) clCreateProgramWithIL_hid __attribute__ ((alias ("clCreateProgramWithIL"), visibility("hidden")));
typeof(clEnqueueSVMMigrateMem) clEnqueueSVMMigrateMem_hid __attribute__ ((alias ("clEnqueueSVMMigrateMem"), visibility("hidden")));
typeof(clGetDeviceAndHostTimer) clGetDeviceAndHostTimer_hid __attribute__ ((alias ("clGetDeviceAndHostTimer"), visibility("hidden")));
typeof(clGetHostTimer) clGetHostTimer_hid __attribute__ ((alias ("clGetHostTimer"), visibility("hidden")));
typeof(clGetKernelSubGroupInfo) clGetKernelSubGroupInfo_hid __attribute__ ((alias ("clGetKernelSubGroupInfo"), visibility("hidden")));
typeof(clSetDefaultDeviceCommandQueue) clSetDefaultDeviceCommandQueue_hid __attribute__ ((alias ("clSetDefaultDeviceCommandQueue"), visibility("hidden")));
typeof(clSetProgramReleaseCallback) clSetProgramReleaseCallback_hid __attribute__ ((alias ("clSetProgramReleaseCallback"), visibility("hidden")));
typeof(clSetProgramSpecializationConstant) clSetProgramSpecializationConstant_hid __attribute__ ((alias ("clSetProgramSpecializationConstant"), visibility("hidden")));


struct func_desc const function_description[]= {
  {"clGetPlatformIDs", (void(* const)(void))&clGetPlatformIDs_hid },
  {"clGetPlatformInfo", (void(* const)(void))&clGetPlatformInfo_hid },
  {"clGetDeviceIDs", (void(* const)(void))&clGetDeviceIDs_hid },
  {"clGetDeviceInfo", (void(* const)(void))&clGetDeviceInfo_hid },
  {"clCreateContext", (void(* const)(void))&clCreateContext_hid },
  {"clCreateContextFromType", (void(* const)(void))&clCreateContextFromType_hid },
  {"clRetainContext", (void(* const)(void))&clRetainContext_hid },
  {"clReleaseContext", (void(* const)(void))&clReleaseContext_hid },
  {"clGetContextInfo", (void(* const)(void))&clGetContextInfo_hid },
  {"clCreateCommandQueue", (void(* const)(void))&clCreateCommandQueue_hid },
  {"clRetainCommandQueue", (void(* const)(void))&clRetainCommandQueue_hid },
  {"clReleaseCommandQueue", (void(* const)(void))&clReleaseCommandQueue_hid },
  {"clGetCommandQueueInfo", (void(* const)(void))&clGetCommandQueueInfo_hid },
  {"clSetCommandQueueProperty", (void(* const)(void))&clSetCommandQueueProperty_hid },
  {"clCreateBuffer", (void(* const)(void))&clCreateBuffer_hid },
  {"clCreateImage2D", (void(* const)(void))&clCreateImage2D_hid },
  {"clCreateImage3D", (void(* const)(void))&clCreateImage3D_hid },
  {"clRetainMemObject", (void(* const)(void))&clRetainMemObject_hid },
  {"clReleaseMemObject", (void(* const)(void))&clReleaseMemObject_hid },
  {"clGetSupportedImageFormats", (void(* const)(void))&clGetSupportedImageFormats_hid },
  {"clGetMemObjectInfo", (void(* const)(void))&clGetMemObjectInfo_hid },
  {"clGetImageInfo", (void(* const)(void))&clGetImageInfo_hid },
  {"clCreateSampler", (void(* const)(void))&clCreateSampler_hid },
  {"clRetainSampler", (void(* const)(void))&clRetainSampler_hid },
  {"clReleaseSampler", (void(* const)(void))&clReleaseSampler_hid },
  {"clGetSamplerInfo", (void(* const)(void))&clGetSamplerInfo_hid },
  {"clCreateProgramWithSource", (void(* const)(void))&clCreateProgramWithSource_hid },
  {"clCreateProgramWithBinary", (void(* const)(void))&clCreateProgramWithBinary_hid },
  {"clRetainProgram", (void(* const)(void))&clRetainProgram_hid },
  {"clReleaseProgram", (void(* const)(void))&clReleaseProgram_hid },
  {"clBuildProgram", (void(* const)(void))&clBuildProgram_hid },
  {"clUnloadCompiler", (void(* const)(void))&clUnloadCompiler_hid },
  {"clGetProgramInfo", (void(* const)(void))&clGetProgramInfo_hid },
  {"clGetProgramBuildInfo", (void(* const)(void))&clGetProgramBuildInfo_hid },
  {"clCreateKernel", (void(* const)(void))&clCreateKernel_hid },
  {"clCreateKernelsInProgram", (void(* const)(void))&clCreateKernelsInProgram_hid },
  {"clRetainKernel", (void(* const)(void))&clRetainKernel_hid },
  {"clReleaseKernel", (void(* const)(void))&clReleaseKernel_hid },
  {"clSetKernelArg", (void(* const)(void))&clSetKernelArg_hid },
  {"clGetKernelInfo", (void(* const)(void))&clGetKernelInfo_hid },
  {"clGetKernelWorkGroupInfo", (void(* const)(void))&clGetKernelWorkGroupInfo_hid },
  {"clWaitForEvents", (void(* const)(void))&clWaitForEvents_hid },
  {"clGetEventInfo", (void(* const)(void))&clGetEventInfo_hid },
  {"clRetainEvent", (void(* const)(void))&clRetainEvent_hid },
  {"clReleaseEvent", (void(* const)(void))&clReleaseEvent_hid },
  {"clGetEventProfilingInfo", (void(* const)(void))&clGetEventProfilingInfo_hid },
  {"clFlush", (void(* const)(void))&clFlush_hid },
  {"clFinish", (void(* const)(void))&clFinish_hid },
  {"clEnqueueReadBuffer", (void(* const)(void))&clEnqueueReadBuffer_hid },
  {"clEnqueueWriteBuffer", (void(* const)(void))&clEnqueueWriteBuffer_hid },
  {"clEnqueueCopyBuffer", (void(* const)(void))&clEnqueueCopyBuffer_hid },
  {"clEnqueueReadImage", (void(* const)(void))&clEnqueueReadImage_hid },
  {"clEnqueueWriteImage", (void(* const)(void))&clEnqueueWriteImage_hid },
  {"clEnqueueCopyImage", (void(* const)(void))&clEnqueueCopyImage_hid },
  {"clEnqueueCopyImageToBuffer", (void(* const)(void))&clEnqueueCopyImageToBuffer_hid },
  {"clEnqueueCopyBufferToImage", (void(* const)(void))&clEnqueueCopyBufferToImage_hid },
  {"clEnqueueMapBuffer", (void(* const)(void))&clEnqueueMapBuffer_hid },
  {"clEnqueueMapImage", (void(* const)(void))&clEnqueueMapImage_hid },
  {"clEnqueueUnmapMemObject", (void(* const)(void))&clEnqueueUnmapMemObject_hid },
  {"clEnqueueNDRangeKernel", (void(* const)(void))&clEnqueueNDRangeKernel_hid },
  {"clEnqueueTask", (void(* const)(void))&clEnqueueTask_hid },
  {"clEnqueueNativeKernel", (void(* const)(void))&clEnqueueNativeKernel_hid },
  {"clEnqueueMarker", (void(* const)(void))&clEnqueueMarker_hid },
  {"clEnqueueWaitForEvents", (void(* const)(void))&clEnqueueWaitForEvents_hid },
  {"clEnqueueBarrier", (void(* const)(void))&clEnqueueBarrier_hid },
  {"clGetExtensionFunctionAddress", (void(* const)(void))&clGetExtensionFunctionAddress_hid },
  {"clCreateFromGLBuffer", (void(* const)(void))&clCreateFromGLBuffer_hid },
  {"clCreateFromGLTexture2D", (void(* const)(void))&clCreateFromGLTexture2D_hid },
  {"clCreateFromGLTexture3D", (void(* const)(void))&clCreateFromGLTexture3D_hid },
  {"clCreateFromGLRenderbuffer", (void(* const)(void))&clCreateFromGLRenderbuffer_hid },
  {"clGetGLObjectInfo", (void(* const)(void))&clGetGLObjectInfo_hid },
  {"clGetGLTextureInfo", (void(* const)(void))&clGetGLTextureInfo_hid },
  {"clEnqueueAcquireGLObjects", (void(* const)(void))&clEnqueueAcquireGLObjects_hid },
  {"clEnqueueReleaseGLObjects", (void(* const)(void))&clEnqueueReleaseGLObjects_hid },
  {"clGetGLContextInfoKHR", (void(* const)(void))&clGetGLContextInfoKHR_hid },
  {"clSetEventCallback", (void(* const)(void))&clSetEventCallback_hid },
  {"clCreateSubBuffer", (void(* const)(void))&clCreateSubBuffer_hid },
  {"clSetMemObjectDestructorCallback", (void(* const)(void))&clSetMemObjectDestructorCallback_hid },
  {"clCreateUserEvent", (void(* const)(void))&clCreateUserEvent_hid },
  {"clSetUserEventStatus", (void(* const)(void))&clSetUserEventStatus_hid },
  {"clEnqueueReadBufferRect", (void(* const)(void))&clEnqueueReadBufferRect_hid },
  {"clEnqueueWriteBufferRect", (void(* const)(void))&clEnqueueWriteBufferRect_hid },
  {"clEnqueueCopyBufferRect", (void(* const)(void))&clEnqueueCopyBufferRect_hid },
  {"clCreateSubDevicesEXT", (void(* const)(void))&clCreateSubDevicesEXT_hid },
  {"clRetainDeviceEXT", (void(* const)(void))&clRetainDeviceEXT_hid },
  {"clReleaseDeviceEXT", (void(* const)(void))&clReleaseDeviceEXT_hid },
  {"clCreateEventFromGLsyncKHR", (void(* const)(void))&clCreateEventFromGLsyncKHR_hid },
  {"clCreateSubDevices", (void(* const)(void))&clCreateSubDevices_hid },
  {"clRetainDevice", (void(* const)(void))&clRetainDevice_hid },
  {"clReleaseDevice", (void(* const)(void))&clReleaseDevice_hid },
  {"clCreateImage", (void(* const)(void))&clCreateImage_hid },
  {"clCreateProgramWithBuiltInKernels", (void(* const)(void))&clCreateProgramWithBuiltInKernels_hid },
  {"clCompileProgram", (void(* const)(void))&clCompileProgram_hid },
  {"clLinkProgram", (void(* const)(void))&clLinkProgram_hid },
  {"clUnloadPlatformCompiler", (void(* const)(void))&clUnloadPlatformCompiler_hid },
  {"clGetKernelArgInfo", (void(* const)(void))&clGetKernelArgInfo_hid },
  {"clEnqueueFillBuffer", (void(* const)(void))&clEnqueueFillBuffer_hid },
  {"clEnqueueFillImage", (void(* const)(void))&clEnqueueFillImage_hid },
  {"clEnqueueMigrateMemObjects", (void(* const)(void))&clEnqueueMigrateMemObjects_hid },
  {"clEnqueueMarkerWithWaitList", (void(* const)(void))&clEnqueueMarkerWithWaitList_hid },
  {"clEnqueueBarrierWithWaitList", (void(* const)(void))&clEnqueueBarrierWithWaitList_hid },
  {"clGetExtensionFunctionAddressForPlatform", (void(* const)(void))&clGetExtensionFunctionAddressForPlatform_hid },
  {"clCreateFromGLTexture", (void(* const)(void))&clCreateFromGLTexture_hid },
  {"clCreateFromEGLImageKHR", (void(* const)(void))&clCreateFromEGLImageKHR_hid },
  {"clEnqueueAcquireEGLObjectsKHR", (void(* const)(void))&clEnqueueAcquireEGLObjectsKHR_hid },
  {"clEnqueueReleaseEGLObjectsKHR", (void(* const)(void))&clEnqueueReleaseEGLObjectsKHR_hid },
  {"clCreateEventFromEGLSyncKHR", (void(* const)(void))&clCreateEventFromEGLSyncKHR_hid },
  {"clCreateCommandQueueWithProperties", (void(* const)(void))&clCreateCommandQueueWithProperties_hid },
  {"clCreatePipe", (void(* const)(void))&clCreatePipe_hid },
  {"clGetPipeInfo", (void(* const)(void))&clGetPipeInfo_hid },
  {"clSVMAlloc", (void(* const)(void))&clSVMAlloc_hid },
  {"clSVMFree", (void(* const)(void))&clSVMFree_hid },
  {"clEnqueueSVMFree", (void(* const)(void))&clEnqueueSVMFree_hid },
  {"clEnqueueSVMMemcpy", (void(* const)(void))&clEnqueueSVMMemcpy_hid },
  {"clEnqueueSVMMemFill", (void(* const)(void))&clEnqueueSVMMemFill_hid },
  {"clEnqueueSVMMap", (void(* const)(void))&clEnqueueSVMMap_hid },
  {"clEnqueueSVMUnmap", (void(* const)(void))&clEnqueueSVMUnmap_hid },
  {"clCreateSamplerWithProperties", (void(* const)(void))&clCreateSamplerWithProperties_hid },
  {"clSetKernelArgSVMPointer", (void(* const)(void))&clSetKernelArgSVMPointer_hid },
  {"clSetKernelExecInfo", (void(* const)(void))&clSetKernelExecInfo_hid },
  {"clGetKernelSubGroupInfoKHR", (void(* const)(void))&clGetKernelSubGroupInfoKHR_hid },
  {"clCloneKernel", (void(* const)(void))&clCloneKernel_hid },
  {"clCreateProgramWithIL", (void(* const)(void))&clCreateProgramWithIL_hid },
  {"clEnqueueSVMMigrateMem", (void(* const)(void))&clEnqueueSVMMigrateMem_hid },
  {"clGetDeviceAndHostTimer", (void(* const)(void))&clGetDeviceAndHostTimer_hid },
  {"clGetHostTimer", (void(* const)(void))&clGetHostTimer_hid },
  {"clGetKernelSubGroupInfo", (void(* const)(void))&clGetKernelSubGroupInfo_hid },
  {"clSetDefaultDeviceCommandQueue", (void(* const)(void))&clSetDefaultDeviceCommandQueue_hid },
  {"clSetProgramReleaseCallback", (void(* const)(void))&clSetProgramReleaseCallback_hid },
  {"clSetProgramSpecializationConstant", (void(* const)(void))&clSetProgramSpecializationConstant_hid },
  {NULL, NULL}
};

#ifdef DEBUG_OCL_ICD
void dump_platform(clGEFA_t f, cl_platform_id pid) {
  debug(D_ALWAYS, "platform @%p:  name=field_in_struct [clGetExtensionFunctionAddress(name)/clGetExtensionFunctionAddressForPlatform(name)]", pid);
  dump_field(pid, f, clGetPlatformIDs);
  dump_field(pid, f, clGetPlatformInfo);
  dump_field(pid, f, clGetDeviceIDs);
  dump_field(pid, f, clGetDeviceInfo);
  dump_field(pid, f, clCreateContext);
  dump_field(pid, f, clCreateContextFromType);
  dump_field(pid, f, clRetainContext);
  dump_field(pid, f, clReleaseContext);
  dump_field(pid, f, clGetContextInfo);
  dump_field(pid, f, clCreateCommandQueue);
  dump_field(pid, f, clRetainCommandQueue);
  dump_field(pid, f, clReleaseCommandQueue);
  dump_field(pid, f, clGetCommandQueueInfo);
  dump_field(pid, f, clSetCommandQueueProperty);
  dump_field(pid, f, clCreateBuffer);
  dump_field(pid, f, clCreateImage2D);
  dump_field(pid, f, clCreateImage3D);
  dump_field(pid, f, clRetainMemObject);
  dump_field(pid, f, clReleaseMemObject);
  dump_field(pid, f, clGetSupportedImageFormats);
  dump_field(pid, f, clGetMemObjectInfo);
  dump_field(pid, f, clGetImageInfo);
  dump_field(pid, f, clCreateSampler);
  dump_field(pid, f, clRetainSampler);
  dump_field(pid, f, clReleaseSampler);
  dump_field(pid, f, clGetSamplerInfo);
  dump_field(pid, f, clCreateProgramWithSource);
  dump_field(pid, f, clCreateProgramWithBinary);
  dump_field(pid, f, clRetainProgram);
  dump_field(pid, f, clReleaseProgram);
  dump_field(pid, f, clBuildProgram);
  dump_field(pid, f, clUnloadCompiler);
  dump_field(pid, f, clGetProgramInfo);
  dump_field(pid, f, clGetProgramBuildInfo);
  dump_field(pid, f, clCreateKernel);
  dump_field(pid, f, clCreateKernelsInProgram);
  dump_field(pid, f, clRetainKernel);
  dump_field(pid, f, clReleaseKernel);
  dump_field(pid, f, clSetKernelArg);
  dump_field(pid, f, clGetKernelInfo);
  dump_field(pid, f, clGetKernelWorkGroupInfo);
  dump_field(pid, f, clWaitForEvents);
  dump_field(pid, f, clGetEventInfo);
  dump_field(pid, f, clRetainEvent);
  dump_field(pid, f, clReleaseEvent);
  dump_field(pid, f, clGetEventProfilingInfo);
  dump_field(pid, f, clFlush);
  dump_field(pid, f, clFinish);
  dump_field(pid, f, clEnqueueReadBuffer);
  dump_field(pid, f, clEnqueueWriteBuffer);
  dump_field(pid, f, clEnqueueCopyBuffer);
  dump_field(pid, f, clEnqueueReadImage);
  dump_field(pid, f, clEnqueueWriteImage);
  dump_field(pid, f, clEnqueueCopyImage);
  dump_field(pid, f, clEnqueueCopyImageToBuffer);
  dump_field(pid, f, clEnqueueCopyBufferToImage);
  dump_field(pid, f, clEnqueueMapBuffer);
  dump_field(pid, f, clEnqueueMapImage);
  dump_field(pid, f, clEnqueueUnmapMemObject);
  dump_field(pid, f, clEnqueueNDRangeKernel);
  dump_field(pid, f, clEnqueueTask);
  dump_field(pid, f, clEnqueueNativeKernel);
  dump_field(pid, f, clEnqueueMarker);
  dump_field(pid, f, clEnqueueWaitForEvents);
  dump_field(pid, f, clEnqueueBarrier);
  dump_field(pid, f, clGetExtensionFunctionAddress);
  dump_field(pid, f, clCreateFromGLBuffer);
  dump_field(pid, f, clCreateFromGLTexture2D);
  dump_field(pid, f, clCreateFromGLTexture3D);
  dump_field(pid, f, clCreateFromGLRenderbuffer);
  dump_field(pid, f, clGetGLObjectInfo);
  dump_field(pid, f, clGetGLTextureInfo);
  dump_field(pid, f, clEnqueueAcquireGLObjects);
  dump_field(pid, f, clEnqueueReleaseGLObjects);
  dump_field(pid, f, clGetGLContextInfoKHR);
  dump_field(pid, f, clUnknown75);
  dump_field(pid, f, clUnknown76);
  dump_field(pid, f, clUnknown77);
  dump_field(pid, f, clUnknown78);
  dump_field(pid, f, clUnknown79);
  dump_field(pid, f, clUnknown80);
  dump_field(pid, f, clSetEventCallback);
  dump_field(pid, f, clCreateSubBuffer);
  dump_field(pid, f, clSetMemObjectDestructorCallback);
  dump_field(pid, f, clCreateUserEvent);
  dump_field(pid, f, clSetUserEventStatus);
  dump_field(pid, f, clEnqueueReadBufferRect);
  dump_field(pid, f, clEnqueueWriteBufferRect);
  dump_field(pid, f, clEnqueueCopyBufferRect);
  dump_field(pid, f, clCreateSubDevicesEXT);
  dump_field(pid, f, clRetainDeviceEXT);
  dump_field(pid, f, clReleaseDeviceEXT);
  dump_field(pid, f, clCreateEventFromGLsyncKHR);
  dump_field(pid, f, clCreateSubDevices);
  dump_field(pid, f, clRetainDevice);
  dump_field(pid, f, clReleaseDevice);
  dump_field(pid, f, clCreateImage);
  dump_field(pid, f, clCreateProgramWithBuiltInKernels);
  dump_field(pid, f, clCompileProgram);
  dump_field(pid, f, clLinkProgram);
  dump_field(pid, f, clUnloadPlatformCompiler);
  dump_field(pid, f, clGetKernelArgInfo);
  dump_field(pid, f, clEnqueueFillBuffer);
  dump_field(pid, f, clEnqueueFillImage);
  dump_field(pid, f, clEnqueueMigrateMemObjects);
  dump_field(pid, f, clEnqueueMarkerWithWaitList);
  dump_field(pid, f, clEnqueueBarrierWithWaitList);
  dump_field(pid, f, clGetExtensionFunctionAddressForPlatform);
  dump_field(pid, f, clCreateFromGLTexture);
  dump_field(pid, f, clUnknown109);
  dump_field(pid, f, clUnknown110);
  dump_field(pid, f, clUnknown111);
  dump_field(pid, f, clUnknown112);
  dump_field(pid, f, clUnknown113);
  dump_field(pid, f, clUnknown114);
  dump_field(pid, f, clUnknown115);
  dump_field(pid, f, clUnknown116);
  dump_field(pid, f, clUnknown117);
  dump_field(pid, f, clUnknown118);
  dump_field(pid, f, clCreateFromEGLImageKHR);
  dump_field(pid, f, clEnqueueAcquireEGLObjectsKHR);
  dump_field(pid, f, clEnqueueReleaseEGLObjectsKHR);
  dump_field(pid, f, clCreateEventFromEGLSyncKHR);
  dump_field(pid, f, clCreateCommandQueueWithProperties);
  dump_field(pid, f, clCreatePipe);
  dump_field(pid, f, clGetPipeInfo);
  dump_field(pid, f, clSVMAlloc);
  dump_field(pid, f, clSVMFree);
  dump_field(pid, f, clEnqueueSVMFree);
  dump_field(pid, f, clEnqueueSVMMemcpy);
  dump_field(pid, f, clEnqueueSVMMemFill);
  dump_field(pid, f, clEnqueueSVMMap);
  dump_field(pid, f, clEnqueueSVMUnmap);
  dump_field(pid, f, clCreateSamplerWithProperties);
  dump_field(pid, f, clSetKernelArgSVMPointer);
  dump_field(pid, f, clSetKernelExecInfo);
  dump_field(pid, f, clGetKernelSubGroupInfoKHR);
  dump_field(pid, f, clCloneKernel);
  dump_field(pid, f, clCreateProgramWithIL);
  dump_field(pid, f, clEnqueueSVMMigrateMem);
  dump_field(pid, f, clGetDeviceAndHostTimer);
  dump_field(pid, f, clGetHostTimer);
  dump_field(pid, f, clGetKernelSubGroupInfo);
  dump_field(pid, f, clSetDefaultDeviceCommandQueue);
  dump_field(pid, f, clSetProgramReleaseCallback);
  dump_field(pid, f, clSetProgramSpecializationConstant);
  dump_field(pid, f, clUnknown146);
  dump_field(pid, f, clUnknown147);
  dump_field(pid, f, clUnknown148);
  dump_field(pid, f, clUnknown149);
  dump_field(pid, f, clUnknown150);
  dump_field(pid, f, clUnknown151);
  dump_field(pid, f, clUnknown152);
  dump_field(pid, f, clUnknown153);
  dump_field(pid, f, clUnknown154);
  dump_field(pid, f, clUnknown155);
  dump_field(pid, f, clUnknown156);
  dump_field(pid, f, clUnknown157);
  dump_field(pid, f, clUnknown158);
  dump_field(pid, f, clUnknown159);
  dump_field(pid, f, clUnknown160);
  dump_field(pid, f, clUnknown161);
  dump_field(pid, f, clUnknown162);
  dump_field(pid, f, clUnknown163);
  dump_field(pid, f, clUnknown164);
  dump_field(pid, f, clUnknown165);
  dump_field(pid, f, clUnknown166);
  dump_field(pid, f, clUnknown167);
  dump_field(pid, f, clUnknown168);
  dump_field(pid, f, clUnknown169);
  dump_field(pid, f, clUnknown170);
  dump_field(pid, f, clUnknown171);
  dump_field(pid, f, clUnknown172);
  dump_field(pid, f, clUnknown173);
  dump_field(pid, f, clUnknown174);
  dump_field(pid, f, clUnknown175);
  dump_field(pid, f, clUnknown176);
  dump_field(pid, f, clUnknown177);
  dump_field(pid, f, clUnknown178);
  dump_field(pid, f, clUnknown179);
}
#endif

#pragma GCC visibility pop

