#!/bin/sh
##############################################################################
# Copyright (c) 2019 Free Software Foundation, Inc.                          #
#                                                                            #
# Permission is hereby granted, free of charge, to any person obtaining a    #
# copy of this software and associated documentation files (the "Software"), #
# to deal in the Software without restriction, including without limitation  #
# the rights to use, copy, modify, merge, publish, distribute, distribute    #
# with modifications, sublicense, and/or sell copies of the Software, and to #
# permit persons to whom the Software is furnished to do so, subject to the  #
# following conditions:                                                      #
#                                                                            #
# The above copyright notice and this permission notice shall be included in #
# all copies or substantial portions of the Software.                        #
#                                                                            #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
# DEALINGS IN THE SOFTWARE.                                                  #
#                                                                            #
# Except as contained in this notice, the name(s) of the above copyright     #
# holders shall not be used in advertising or otherwise to promote the sale, #
# use or other dealings in this Software without prior written               #
# authorization.                                                             #
##############################################################################
# $Id: MKuserdefs.sh,v 1.8 2019/03/17 00:46:17 tom Exp $
AWK=${1-awk}; shift 1
OPT1=${1-0}; shift 1

cat <<EOF
/*
 * generated by $0
 */

EOF

cat <<'EOF'
/*
 *    comp_userdefs.c -- The names of widely used user-defined capabilities
 *                       indexed via a hash table for the compiler.
 *
 */

#include <curses.priv.h>
#include <tic.h>
#include <hashsize.h>

#if NCURSES_XNAMES
EOF

cat "$@" | ./make_hash 1 user $OPT1

cat <<EOF

#if $OPT1
static void
next_string(const char *strings, unsigned *offset)
{
    *offset += (unsigned) strlen(strings + *offset) + 1;
}

static const struct user_table_entry *
_nc_build_names(struct user_table_entry **actual,
		const user_table_data *source,
		const char *strings)
{
    if (*actual == 0) {
	*actual = typeCalloc(struct user_table_entry, CAPTABSIZE);
	if (*actual != 0) {
	    unsigned n;
	    unsigned len = 0;
	    for (n = 0; n < CAPTABSIZE; ++n) {
		(*actual)[n].ute_name = strings + len;
		(*actual)[n].ute_type = (int) source[n].ute_type;
		(*actual)[n].ute_argc = source[n].ute_argc;
		(*actual)[n].ute_args = source[n].ute_args;
		(*actual)[n].ute_index = source[n].ute_index;
		(*actual)[n].ute_link = source[n].ute_link;
		next_string(strings, &len);
	    }
	}
    }
    return *actual;
}

#define build_names(root) _nc_build_names(&_nc_##root##_table, \\
					  root##_names_data, \\
					  root##_names_text)
#else
#define build_names(root) _nc_ ## root ## _table
#endif

NCURSES_EXPORT(const struct user_table_entry *) _nc_get_userdefs_table (void)
{
    return build_names(user) ;
}

static HashValue
info_hash(const char *string)
{
    long sum = 0;

    DEBUG(9, ("hashing %s", string));
    while (*string) {
	sum += (long) (*string + (*(string + 1) << 8));
	string++;
    }

    DEBUG(9, ("sum is %ld", sum));
    return (HashValue) (sum % HASHTABSIZE);
}

static int
compare_info_names(const char *a, const char *b)
{
    return !strcmp(a, b);
}

static const HashData hash_data[] = {
    { HASHTABSIZE, _nc_user_hash_table, info_hash, compare_info_names }
};

NCURSES_EXPORT(const HashData *) _nc_get_hash_user (void)
{
    return hash_data;
}

#if NO_LEAKS
NCURSES_EXPORT(void) _nc_comp_userdefs_leaks(void)
{
#if $OPT1
    FreeIfNeeded(_nc_user_table);
#endif
}
#endif /* NO_LEAKS */

#else /*! NCURSES_XNAMES */
NCURSES_EXPORT(void) _nc_comp_userdefs(void);
NCURSES_EXPORT(void) _nc_comp_userdefs(void) { }
#endif /* NCURSES_XNAMES */
EOF
