/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  Feature64Bit = 2,
  FeatureADX = 3,
  FeatureAES = 4,
  FeatureAVX = 5,
  FeatureAVX2 = 6,
  FeatureAVX512 = 7,
  FeatureBITALG = 8,
  FeatureBMI = 9,
  FeatureBMI2 = 10,
  FeatureBWI = 11,
  FeatureCDI = 12,
  FeatureCLDEMOTE = 13,
  FeatureCLFLUSHOPT = 14,
  FeatureCLWB = 15,
  FeatureCLZERO = 16,
  FeatureCMOV = 17,
  FeatureCMPXCHG16B = 18,
  FeatureDQI = 19,
  FeatureERI = 20,
  FeatureERMSB = 21,
  FeatureF16C = 22,
  FeatureFMA = 23,
  FeatureFMA4 = 24,
  FeatureFSGSBase = 25,
  FeatureFXSR = 26,
  FeatureFast11ByteNOP = 27,
  FeatureFast15ByteNOP = 28,
  FeatureFastBEXTR = 29,
  FeatureFastHorizontalOps = 30,
  FeatureFastLZCNT = 31,
  FeatureFastPartialYMMorZMMWrite = 32,
  FeatureFastSHLDRotate = 33,
  FeatureFastScalarFSQRT = 34,
  FeatureFastVariableShuffle = 35,
  FeatureFastVectorFSQRT = 36,
  FeatureGFNI = 37,
  FeatureHasFastGather = 38,
  FeatureIFMA = 39,
  FeatureINVPCID = 40,
  FeatureLAHFSAHF = 41,
  FeatureLEAForSP = 42,
  FeatureLEAUsesAG = 43,
  FeatureLWP = 44,
  FeatureLZCNT = 45,
  FeatureLZCNTFalseDeps = 46,
  FeatureMMX = 47,
  FeatureMOVBE = 48,
  FeatureMOVDIR64B = 49,
  FeatureMOVDIRI = 50,
  FeatureMPX = 51,
  FeatureMWAITX = 52,
  FeatureMacroFusion = 53,
  FeatureMergeToThreeWayBranch = 54,
  FeatureNOPL = 55,
  FeaturePCLMUL = 56,
  FeaturePCONFIG = 57,
  FeaturePFI = 58,
  FeaturePKU = 59,
  FeaturePOPCNT = 60,
  FeaturePOPCNTFalseDeps = 61,
  FeaturePREFETCHWT1 = 62,
  FeaturePRFCHW = 63,
  FeaturePTWRITE = 64,
  FeaturePadShortFunctions = 65,
  FeaturePrefer256Bit = 66,
  FeatureRDPID = 67,
  FeatureRDRAND = 68,
  FeatureRDSEED = 69,
  FeatureRTM = 70,
  FeatureRetpoline = 71,
  FeatureRetpolineExternalThunk = 72,
  FeatureRetpolineIndirectBranches = 73,
  FeatureRetpolineIndirectCalls = 74,
  FeatureSGX = 75,
  FeatureSHA = 76,
  FeatureSHSTK = 77,
  FeatureSSE1 = 78,
  FeatureSSE2 = 79,
  FeatureSSE3 = 80,
  FeatureSSE4A = 81,
  FeatureSSE41 = 82,
  FeatureSSE42 = 83,
  FeatureSSEUnalignedMem = 84,
  FeatureSSSE3 = 85,
  FeatureSlow3OpsLEA = 86,
  FeatureSlowDivide32 = 87,
  FeatureSlowDivide64 = 88,
  FeatureSlowIncDec = 89,
  FeatureSlowLEA = 90,
  FeatureSlowPMADDWD = 91,
  FeatureSlowPMULLD = 92,
  FeatureSlowSHLD = 93,
  FeatureSlowTwoMemOps = 94,
  FeatureSlowUAMem16 = 95,
  FeatureSlowUAMem32 = 96,
  FeatureSoftFloat = 97,
  FeatureTBM = 98,
  FeatureVAES = 99,
  FeatureVBMI = 100,
  FeatureVBMI2 = 101,
  FeatureVLX = 102,
  FeatureVNNI = 103,
  FeatureVPCLMULQDQ = 104,
  FeatureVPOPCNTDQ = 105,
  FeatureWAITPKG = 106,
  FeatureWBNOINVD = 107,
  FeatureX87 = 108,
  FeatureXOP = 109,
  FeatureXSAVE = 110,
  FeatureXSAVEC = 111,
  FeatureXSAVEOPT = 112,
  FeatureXSAVES = 113,
  Mode16Bit = 114,
  Mode32Bit = 115,
  Mode64Bit = 116,
  ProcIntelAtom = 117,
  ProcIntelGLM = 118,
  ProcIntelGLP = 119,
  ProcIntelSLM = 120,
  ProcIntelTRM = 121,
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", { X86::Mode16Bit }, { } },
  { "32bit-mode", "32-bit mode (80386)", { X86::Mode32Bit }, { } },
  { "3dnow", "Enable 3DNow! instructions", { X86::Feature3DNow }, { X86::FeatureMMX } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", { X86::Feature3DNowA }, { X86::Feature3DNow } },
  { "64bit", "Support 64-bit instructions", { X86::Feature64Bit }, { } },
  { "64bit-mode", "64-bit mode (x86_64)", { X86::Mode64Bit }, { } },
  { "adx", "Support ADX instructions", { X86::FeatureADX }, { } },
  { "aes", "Enable AES instructions", { X86::FeatureAES }, { X86::FeatureSSE2 } },
  { "atom", "Intel Atom processors", { X86::ProcIntelAtom }, { } },
  { "avx", "Enable AVX instructions", { X86::FeatureAVX }, { X86::FeatureSSE42 } },
  { "avx2", "Enable AVX2 instructions", { X86::FeatureAVX2 }, { X86::FeatureAVX } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", { X86::FeatureBITALG }, { X86::FeatureBWI } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", { X86::FeatureBWI }, { X86::FeatureAVX512 } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", { X86::FeatureCDI }, { X86::FeatureAVX512 } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", { X86::FeatureDQI }, { X86::FeatureAVX512 } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", { X86::FeatureERI }, { X86::FeatureAVX512 } },
  { "avx512f", "Enable AVX-512 instructions", { X86::FeatureAVX512 }, { X86::FeatureAVX2, X86::FeatureFMA, X86::FeatureF16C } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", { X86::FeatureIFMA }, { X86::FeatureAVX512 } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", { X86::FeaturePFI }, { X86::FeatureAVX512 } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", { X86::FeatureVBMI }, { X86::FeatureBWI } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", { X86::FeatureVBMI2 }, { X86::FeatureBWI } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", { X86::FeatureVLX }, { X86::FeatureAVX512 } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", { X86::FeatureVNNI }, { X86::FeatureAVX512 } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", { X86::FeatureVPOPCNTDQ }, { X86::FeatureAVX512 } },
  { "bmi", "Support BMI instructions", { X86::FeatureBMI }, { } },
  { "bmi2", "Support BMI2 instructions", { X86::FeatureBMI2 }, { } },
  { "cldemote", "Enable Cache Demote", { X86::FeatureCLDEMOTE }, { } },
  { "clflushopt", "Flush A Cache Line Optimized", { X86::FeatureCLFLUSHOPT }, { } },
  { "clwb", "Cache Line Write Back", { X86::FeatureCLWB }, { } },
  { "clzero", "Enable Cache Line Zero", { X86::FeatureCLZERO }, { } },
  { "cmov", "Enable conditional move instructions", { X86::FeatureCMOV }, { } },
  { "cx16", "64-bit with cmpxchg16b", { X86::FeatureCMPXCHG16B }, { } },
  { "ermsb", "REP MOVS/STOS are fast", { X86::FeatureERMSB }, { } },
  { "f16c", "Support 16-bit floating point conversion instructions", { X86::FeatureF16C }, { X86::FeatureAVX } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", { X86::FeatureLZCNTFalseDeps }, { } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", { X86::FeaturePOPCNTFalseDeps }, { } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", { X86::FeatureFast11ByteNOP }, { } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", { X86::FeatureFast15ByteNOP }, { } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput.", { X86::FeatureFastBEXTR }, { } },
  { "fast-gather", "Indicates if gather is reasonably fast.", { X86::FeatureHasFastGather }, { } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", { X86::FeatureFastHorizontalOps }, { X86::FeatureSSE3 } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", { X86::FeatureFastLZCNT }, { } },
  { "fast-partial-ymm-or-zmm-write", "Partial writes to YMM/ZMM registers are fast", { X86::FeatureFastPartialYMMorZMMWrite }, { } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", { X86::FeatureFastScalarFSQRT }, { } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", { X86::FeatureFastSHLDRotate }, { } },
  { "fast-variable-shuffle", "Shuffles with variable masks are fast", { X86::FeatureFastVariableShuffle }, { } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", { X86::FeatureFastVectorFSQRT }, { } },
  { "fma", "Enable three-operand fused multiple-add", { X86::FeatureFMA }, { X86::FeatureAVX } },
  { "fma4", "Enable four-operand fused multiple-add", { X86::FeatureFMA4 }, { X86::FeatureAVX, X86::FeatureSSE4A } },
  { "fsgsbase", "Support FS/GS Base instructions", { X86::FeatureFSGSBase }, { } },
  { "fxsr", "Support fxsave/fxrestore instructions", { X86::FeatureFXSR }, { } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", { X86::FeatureGFNI }, { X86::FeatureSSE2 } },
  { "glm", "Intel Goldmont processors", { X86::ProcIntelGLM }, { } },
  { "glp", "Intel Goldmont Plus processors", { X86::ProcIntelGLP }, { } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", { X86::FeatureSlowDivide32 }, { } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", { X86::FeatureSlowDivide64 }, { } },
  { "invpcid", "Invalidate Process-Context Identifier", { X86::FeatureINVPCID }, { } },
  { "lea-sp", "Use LEA for adjusting the stack pointer", { X86::FeatureLEAForSP }, { } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", { X86::FeatureLEAUsesAG }, { } },
  { "lwp", "Enable LWP instructions", { X86::FeatureLWP }, { } },
  { "lzcnt", "Support LZCNT instruction", { X86::FeatureLZCNT }, { } },
  { "macrofusion", "Various instructions can be fused with conditional branches", { X86::FeatureMacroFusion }, { } },
  { "merge-to-threeway-branch", "Merge branches to a three-way conditional branch", { X86::FeatureMergeToThreeWayBranch }, { } },
  { "mmx", "Enable MMX instructions", { X86::FeatureMMX }, { } },
  { "movbe", "Support MOVBE instruction", { X86::FeatureMOVBE }, { } },
  { "movdir64b", "Support movdir64b instruction", { X86::FeatureMOVDIR64B }, { } },
  { "movdiri", "Support movdiri instruction", { X86::FeatureMOVDIRI }, { } },
  { "mpx", "Support MPX instructions", { X86::FeatureMPX }, { } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", { X86::FeatureMWAITX }, { } },
  { "nopl", "Enable NOPL instruction", { X86::FeatureNOPL }, { } },
  { "pad-short-functions", "Pad short functions", { X86::FeaturePadShortFunctions }, { } },
  { "pclmul", "Enable packed carry-less multiplication instructions", { X86::FeaturePCLMUL }, { X86::FeatureSSE2 } },
  { "pconfig", "platform configuration instruction", { X86::FeaturePCONFIG }, { } },
  { "pku", "Enable protection keys", { X86::FeaturePKU }, { } },
  { "popcnt", "Support POPCNT instruction", { X86::FeaturePOPCNT }, { } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", { X86::FeaturePrefer256Bit }, { } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", { X86::FeaturePREFETCHWT1 }, { } },
  { "prfchw", "Support PRFCHW instructions", { X86::FeaturePRFCHW }, { } },
  { "ptwrite", "Support ptwrite instruction", { X86::FeaturePTWRITE }, { } },
  { "rdpid", "Support RDPID instructions", { X86::FeatureRDPID }, { } },
  { "rdrnd", "Support RDRAND instruction", { X86::FeatureRDRAND }, { } },
  { "rdseed", "Support RDSEED instruction", { X86::FeatureRDSEED }, { } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct.", { X86::FeatureRetpoline }, { X86::FeatureRetpolineIndirectCalls, X86::FeatureRetpolineIndirectBranches } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature.", { X86::FeatureRetpolineExternalThunk }, { X86::FeatureRetpolineIndirectCalls } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code.", { X86::FeatureRetpolineIndirectBranches }, { } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code.", { X86::FeatureRetpolineIndirectCalls }, { } },
  { "rtm", "Support RTM instructions", { X86::FeatureRTM }, { } },
  { "sahf", "Support LAHF and SAHF instructions", { X86::FeatureLAHFSAHF }, { } },
  { "sgx", "Enable Software Guard Extensions", { X86::FeatureSGX }, { } },
  { "sha", "Enable SHA instructions", { X86::FeatureSHA }, { X86::FeatureSSE2 } },
  { "shstk", "Support CET Shadow-Stack instructions", { X86::FeatureSHSTK }, { } },
  { "slm", "Intel Silvermont processors", { X86::ProcIntelSLM }, { } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", { X86::FeatureSlow3OpsLEA }, { } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", { X86::FeatureSlowIncDec }, { } },
  { "slow-lea", "LEA instruction with certain arguments is slow", { X86::FeatureSlowLEA }, { } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", { X86::FeatureSlowPMADDWD }, { } },
  { "slow-pmulld", "PMULLD instruction is slow", { X86::FeatureSlowPMULLD }, { } },
  { "slow-shld", "SHLD instruction is slow", { X86::FeatureSlowSHLD }, { } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", { X86::FeatureSlowTwoMemOps }, { } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", { X86::FeatureSlowUAMem16 }, { } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", { X86::FeatureSlowUAMem32 }, { } },
  { "soft-float", "Use software floating point features.", { X86::FeatureSoftFloat }, { } },
  { "sse", "Enable SSE instructions", { X86::FeatureSSE1 }, { } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions", { X86::FeatureSSEUnalignedMem }, { } },
  { "sse2", "Enable SSE2 instructions", { X86::FeatureSSE2 }, { X86::FeatureSSE1 } },
  { "sse3", "Enable SSE3 instructions", { X86::FeatureSSE3 }, { X86::FeatureSSE2 } },
  { "sse4.1", "Enable SSE 4.1 instructions", { X86::FeatureSSE41 }, { X86::FeatureSSSE3 } },
  { "sse4.2", "Enable SSE 4.2 instructions", { X86::FeatureSSE42 }, { X86::FeatureSSE41 } },
  { "sse4a", "Support SSE 4a instructions", { X86::FeatureSSE4A }, { X86::FeatureSSE3 } },
  { "ssse3", "Enable SSSE3 instructions", { X86::FeatureSSSE3 }, { X86::FeatureSSE3 } },
  { "tbm", "Enable TBM instructions", { X86::FeatureTBM }, { } },
  { "tremont", "Intel Tremont processors", { X86::ProcIntelTRM }, { } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", { X86::FeatureVAES }, { X86::FeatureAVX, X86::FeatureAES } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", { X86::FeatureVPCLMULQDQ }, { X86::FeatureAVX, X86::FeaturePCLMUL } },
  { "waitpkg", "Wait and pause enhancements", { X86::FeatureWAITPKG }, { } },
  { "wbnoinvd", "Write Back No Invalidate", { X86::FeatureWBNOINVD }, { } },
  { "x87", "Enable X87 float instructions", { X86::FeatureX87 }, { } },
  { "xop", "Enable XOP instructions", { X86::FeatureXOP }, { X86::FeatureFMA4 } },
  { "xsave", "Support xsave instructions", { X86::FeatureXSAVE }, { } },
  { "xsavec", "Support xsavec instructions", { X86::FeatureXSAVEC }, { } },
  { "xsaveopt", "Support xsaveopt instructions", { X86::FeatureXSAVEOPT }, { } },
  { "xsaves", "Support xsaves instructions", { X86::FeatureXSAVES }, { } },
};

// Sorted (by key) array of values for CPU subtype.
extern const llvm::SubtargetFeatureKV X86SubTypeKV[] = {
  { "amdfam10", "Select the amdfam10 processor", { X86::FeatureX87, X86::FeatureSSE4A, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureCMOV, X86::Feature64Bit }, { } },
  { "athlon", "Select the athlon processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::Feature3DNowA, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-4", "Select the athlon-4 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureSSE1, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-fx", "Select the athlon-fx processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD, X86::FeatureCMOV }, { } },
  { "athlon-mp", "Select the athlon-mp processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureSSE1, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-tbird", "Select the athlon-tbird processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::Feature3DNowA, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon-xp", "Select the athlon-xp processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureSSE1, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSlowSHLD }, { } },
  { "athlon64", "Select the athlon64 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD, X86::FeatureCMOV }, { } },
  { "athlon64-sse3", "Select the athlon64-sse3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE3, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureSlowSHLD, X86::FeatureCMOV, X86::Feature64Bit }, { } },
  { "atom", "Select the atom processor", { X86::ProcIntelAtom, X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeatureLEAForSP, X86::FeatureSlowDivide32, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeatureLEAUsesAG, X86::FeaturePadShortFunctions, X86::FeatureLAHFSAHF }, { } },
  { "barcelona", "Select the barcelona processor", { X86::FeatureX87, X86::FeatureSSE4A, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureCMOV, X86::Feature64Bit }, { } },
  { "bdver1", "Select the bdver1 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureXOP, X86::FeatureFMA4, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureLWP, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureMacroFusion }, { } },
  { "bdver2", "Select the bdver2 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureXOP, X86::FeatureFMA4, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureF16C, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureBMI, X86::FeatureTBM, X86::FeatureLWP, X86::FeatureFMA, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureFastBEXTR, X86::FeatureMacroFusion }, { } },
  { "bdver3", "Select the bdver3 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureXOP, X86::FeatureFMA4, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::FeatureF16C, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureBMI, X86::FeatureTBM, X86::FeatureLWP, X86::FeatureFMA, X86::FeatureXSAVEOPT, X86::FeatureSlowSHLD, X86::FeatureFSGSBase, X86::FeatureLAHFSAHF, X86::FeatureFast11ByteNOP, X86::FeatureFastBEXTR, X86::FeatureMacroFusion }, { } },
  { "bdver4", "Select the bdver4 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX2, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureXOP, X86::FeatureFMA4, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeaturePCLMUL, X86::FeatureF16C, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureTBM, X86::FeatureLWP, X86::FeatureFMA, X86::FeatureXSAVEOPT, X86::FeatureSlowSHLD, X86::FeatureFSGSBase, X86::FeatureLAHFSAHF, X86::FeatureFastBEXTR, X86::FeatureFast11ByteNOP, X86::FeatureMWAITX, X86::FeatureMacroFusion }, { } },
  { "bonnell", "Select the bonnell processor", { X86::ProcIntelAtom, X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeatureLEAForSP, X86::FeatureSlowDivide32, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeatureLEAUsesAG, X86::FeaturePadShortFunctions, X86::FeatureLAHFSAHF }, { } },
  { "broadwell", "Select the broadwell processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeaturePOPCNTFalseDeps, X86::FeatureLZCNTFalseDeps }, { } },
  { "btver1", "Select the btver1 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureSSE4A, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePRFCHW, X86::FeatureLZCNT, X86::FeaturePOPCNT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast15ByteNOP }, { } },
  { "btver2", "Select the btver2 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureSSE4A, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeaturePCLMUL, X86::FeatureBMI, X86::FeatureF16C, X86::FeatureMOVBE, X86::FeatureLZCNT, X86::FeatureFastLZCNT, X86::FeaturePOPCNT, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureSlowSHLD, X86::FeatureLAHFSAHF, X86::FeatureFast15ByteNOP, X86::FeatureFastBEXTR, X86::FeatureFastPartialYMMorZMMWrite, X86::FeatureFastHorizontalOps }, { } },
  { "c3", "Select the c3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "c3-2", "Select the c3-2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE1, X86::FeatureFXSR, X86::FeatureCMOV }, { } },
  { "cannonlake", "Select the cannonlake processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureVBMI, X86::FeatureIFMA, X86::FeatureSHA, X86::FeatureSGX, X86::FeatureHasFastGather }, { } },
  { "cascadelake", "Select the cascadelake processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureCLWB, X86::FeatureVNNI, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps }, { } },
  { "core-avx-i", "Select the core-avx-i processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "core-avx2", "Select the core-avx2 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeaturePOPCNTFalseDeps, X86::FeatureLZCNTFalseDeps }, { } },
  { "core2", "Select the core2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "corei7", "Select the corei7 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "corei7-avx", "Select the corei7-avx processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "generic", "Select the generic processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "geode", "Select the geode processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNowA }, { } },
  { "goldmont", "Select the goldmont processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureLAHFSAHF, X86::FeatureMPX, X86::FeatureSHA, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFSGSBase, X86::ProcIntelGLM, X86::FeaturePOPCNTFalseDeps }, { } },
  { "goldmont-plus", "Select the goldmont-plus processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureLAHFSAHF, X86::FeatureMPX, X86::FeatureSHA, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFSGSBase, X86::FeaturePTWRITE, X86::FeatureRDPID, X86::FeatureSGX, X86::ProcIntelGLP }, { } },
  { "haswell", "Select the haswell processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeaturePOPCNTFalseDeps, X86::FeatureLZCNTFalseDeps }, { } },
  { "i386", "Select the i386 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "i486", "Select the i486 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "i586", "Select the i586 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "i686", "Select the i686 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV }, { } },
  { "icelake-client", "Select the icelake-client processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureVBMI, X86::FeatureIFMA, X86::FeatureSHA, X86::FeatureSGX, X86::FeatureBITALG, X86::FeatureVAES, X86::FeatureVBMI2, X86::FeatureVNNI, X86::FeatureVPCLMULQDQ, X86::FeatureVPOPCNTDQ, X86::FeatureGFNI, X86::FeatureCLWB, X86::FeatureRDPID, X86::FeatureHasFastGather }, { } },
  { "icelake-server", "Select the icelake-server processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureVBMI, X86::FeatureIFMA, X86::FeatureSHA, X86::FeatureSGX, X86::FeatureBITALG, X86::FeatureVAES, X86::FeatureVBMI2, X86::FeatureVNNI, X86::FeatureVPCLMULQDQ, X86::FeatureVPOPCNTDQ, X86::FeatureGFNI, X86::FeatureCLWB, X86::FeatureRDPID, X86::FeaturePCONFIG, X86::FeatureWBNOINVD, X86::FeatureHasFastGather }, { } },
  { "ivybridge", "Select the ivybridge processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "k6", "Select the k6 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX }, { } },
  { "k6-2", "Select the k6-2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "k6-3", "Select the k6-3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "k8", "Select the k8 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD, X86::FeatureCMOV }, { } },
  { "k8-sse3", "Select the k8-sse3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE3, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureSlowSHLD, X86::FeatureCMOV, X86::Feature64Bit }, { } },
  { "knl", "Select the knl processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureSlowIncDec, X86::FeatureAES, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX512, X86::FeatureERI, X86::FeatureCDI, X86::FeaturePFI, X86::FeaturePREFETCHWT1, X86::FeatureADX, X86::FeatureRDSEED, X86::FeatureMOVBE, X86::FeatureLZCNT, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureFMA, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureFastPartialYMMorZMMWrite, X86::FeatureHasFastGather, X86::FeatureSlowPMADDWD }, { } },
  { "knm", "Select the knm processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureSlowIncDec, X86::FeatureAES, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX512, X86::FeatureERI, X86::FeatureCDI, X86::FeaturePFI, X86::FeaturePREFETCHWT1, X86::FeatureADX, X86::FeatureRDSEED, X86::FeatureMOVBE, X86::FeatureLZCNT, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureFMA, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureFastPartialYMMorZMMWrite, X86::FeatureHasFastGather, X86::FeatureSlowPMADDWD, X86::FeatureVPOPCNTDQ }, { } },
  { "lakemont", "Select the lakemont processor", { }, { } },
  { "nehalem", "Select the nehalem processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "nocona", "Select the nocona processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B }, { } },
  { "opteron", "Select the opteron processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE2, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlowSHLD, X86::FeatureCMOV }, { } },
  { "opteron-sse3", "Select the opteron-sse3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureSSE3, X86::Feature3DNowA, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMPXCHG16B, X86::FeatureSlowSHLD, X86::FeatureCMOV, X86::Feature64Bit }, { } },
  { "penryn", "Select the penryn processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE41, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "pentium", "Select the pentium processor", { X86::FeatureX87, X86::FeatureSlowUAMem16 }, { } },
  { "pentium-m", "Select the pentium-m processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "pentium-mmx", "Select the pentium-mmx processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX }, { } },
  { "pentium2", "Select the pentium2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureCMOV, X86::FeatureFXSR, X86::FeatureNOPL }, { } },
  { "pentium3", "Select the pentium3 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE1, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "pentium3m", "Select the pentium3m processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE1, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "pentium4", "Select the pentium4 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "pentium4m", "Select the pentium4m processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "pentiumpro", "Select the pentiumpro processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureCMOV, X86::FeatureNOPL }, { } },
  { "prescott", "Select the prescott processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "sandybridge", "Select the sandybridge processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureSlowUAMem32, X86::FeaturePOPCNTFalseDeps }, { } },
  { "silvermont", "Select the silvermont processor", { X86::ProcIntelSLM, X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeaturePRFCHW, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureSlowPMULLD, X86::FeatureRDRAND, X86::FeatureLAHFSAHF, X86::FeaturePOPCNTFalseDeps }, { } },
  { "skx", "Select the skx processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureCLWB, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps }, { } },
  { "skylake", "Select the skylake processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps, X86::FeatureSGX }, { } },
  { "skylake-avx512", "Select the skylake-avx512 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureAVX, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeatureSlowDivide64, X86::FeaturePCLMUL, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureLAHFSAHF, X86::FeatureSlow3OpsLEA, X86::FeatureFastScalarFSQRT, X86::FeatureFastSHLDRotate, X86::FeatureSlowIncDec, X86::FeatureMergeToThreeWayBranch, X86::FeatureMacroFusion, X86::FeatureRDRAND, X86::FeatureF16C, X86::FeatureFSGSBase, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureERMSB, X86::FeatureFMA, X86::FeatureINVPCID, X86::FeatureLZCNT, X86::FeatureMOVBE, X86::FeatureFastVariableShuffle, X86::FeatureADX, X86::FeatureRDSEED, X86::FeaturePRFCHW, X86::FeatureAES, X86::FeatureMPX, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFastVectorFSQRT, X86::FeatureAVX512, X86::FeatureCDI, X86::FeatureDQI, X86::FeatureBWI, X86::FeatureVLX, X86::FeaturePKU, X86::FeatureCLWB, X86::FeatureHasFastGather, X86::FeaturePOPCNTFalseDeps }, { } },
  { "slm", "Select the slm processor", { X86::ProcIntelSLM, X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureSlowDivide64, X86::FeatureSlowTwoMemOps, X86::FeaturePRFCHW, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureSlowPMULLD, X86::FeatureRDRAND, X86::FeatureLAHFSAHF, X86::FeaturePOPCNTFalseDeps }, { } },
  { "tremont", "Select the tremont processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureMOVBE, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureAES, X86::FeaturePRFCHW, X86::FeatureSlowTwoMemOps, X86::FeatureSlowLEA, X86::FeatureSlowIncDec, X86::FeatureLAHFSAHF, X86::FeatureMPX, X86::FeatureSHA, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureXSAVE, X86::FeatureXSAVEOPT, X86::FeatureXSAVEC, X86::FeatureXSAVES, X86::FeatureCLFLUSHOPT, X86::FeatureFSGSBase, X86::FeaturePTWRITE, X86::FeatureRDPID, X86::FeatureSGX, X86::ProcIntelTRM, X86::FeatureCLDEMOTE, X86::FeatureGFNI, X86::FeatureMOVDIRI, X86::FeatureMOVDIR64B, X86::FeatureWAITPKG }, { } },
  { "westmere", "Select the westmere processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE42, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeaturePOPCNT, X86::FeaturePCLMUL, X86::FeatureLAHFSAHF, X86::FeatureMacroFusion }, { } },
  { "winchip-c6", "Select the winchip-c6 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX }, { } },
  { "winchip2", "Select the winchip2 processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::Feature3DNow }, { } },
  { "x86-64", "Select the x86-64 processor", { X86::FeatureX87, X86::FeatureCMOV, X86::FeatureMMX, X86::FeatureSSE2, X86::FeatureFXSR, X86::FeatureNOPL, X86::Feature64Bit, X86::FeatureSlow3OpsLEA, X86::FeatureSlowIncDec, X86::FeatureMacroFusion }, { } },
  { "yonah", "Select the yonah processor", { X86::FeatureX87, X86::FeatureSlowUAMem16, X86::FeatureMMX, X86::FeatureSSE3, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureCMOV }, { } },
  { "znver1", "Select the znver1 processor", { X86::FeatureADX, X86::FeatureAES, X86::FeatureAVX2, X86::FeatureBMI, X86::FeatureBMI2, X86::FeatureCLFLUSHOPT, X86::FeatureCLZERO, X86::FeatureCMOV, X86::Feature64Bit, X86::FeatureCMPXCHG16B, X86::FeatureF16C, X86::FeatureFMA, X86::FeatureFSGSBase, X86::FeatureFXSR, X86::FeatureNOPL, X86::FeatureFastLZCNT, X86::FeatureLAHFSAHF, X86::FeatureLZCNT, X86::FeatureFastBEXTR, X86::FeatureFast15ByteNOP, X86::FeatureMacroFusion, X86::FeatureMMX, X86::FeatureMOVBE, X86::FeatureMWAITX, X86::FeaturePCLMUL, X86::FeaturePOPCNT, X86::FeaturePRFCHW, X86::FeatureRDRAND, X86::FeatureRDSEED, X86::FeatureSHA, X86::FeatureSSE4A, X86::FeatureSlowSHLD, X86::FeatureX87, X86::FeatureXSAVE, X86::FeatureXSAVEC, X86::FeatureXSAVEOPT, X86::FeatureXSAVES }, { } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0}, // Invalid
  { 3,  1}, // #1
  { 1,  1}, // #2
  { 3,  2}, // #3
  { 2,  1}, // #4
  { 3,  1}, // #5
  { 1,  1}, // #6
  { 3,  1}, // #7
  { 3,  7}, // #8
  { 3,  6}, // #9
  { 1,  5}, // #10
  { 3,  5}, // #11
  { 3, 16}, // #12
  { 3,  9}, // #13
  { 3, 11}, // #14
  { 3, 15}, // #15
  { 3,  8}, // #16
  { 3, 50}, // #17
  { 3, 130}, // #18
  { 3, 68}, // #19
  { 3, 125}, // #20
  { 3, 70}, // #21
  { 3, 34}, // #22
  { 3, 62}, // #23
  { 3, 10}, // #24
  { 3, 12}, // #25
  { 3, 14}, // #26
  { 1,  3}, // #27
  { 3,  3}, // #28
  { 3,  4}, // #29
  { 1,  4}, // #30
  { 3,  4}, // #31
  { 1,  2}, // #32
  { 3,  2}, // #33
  { 3, 71}, // #34
  { 2,  5}, // #35
  { 3,  5}, // #36
  { 1,  1}, // #37
  { 2,  1}, // #38
  { 3,  2}, // #39
  { 1,  5}, // #40
  { 2,  5}, // #41
  { 3, 10}, // #42
  { 3, 13}, // #43
  { 3, 17}, // #44
  { 3, 18}, // #45
  { 3, 20}, // #46
  { 3, 21}, // #47
  { 3, 22}, // #48
  { 3, 23}, // #49
  { 3, 25}, // #50
  { 3, 26}, // #51
  { 3, 29}, // #52
  { 3, 30}, // #53
  { 3, 32}, // #54
  { 3, 45}, // #55
  { 3, 46}, // #56
  { 3, 48}, // #57
  { 3, 55}, // #58
  { 3, 59}, // #59
  { 3, 63}, // #60
  { 3, 72}, // #61
  { 3, 74}, // #62
  { 3, 77}, // #63
  { 3, 78}, // #64
  { 3, 79}, // #65
  { 3, 92}, // #66
  { 3, 94}, // #67
  { 3, 99}, // #68
  { 3, 121}, // #69
  { 3, 127}, // #70
  { 3, 140}, // #71
  { 3, 141}, // #72
  { 3, 146}, // #73
  { 3, 147}, // #74
  { 3, 168}, // #75
  { 3, 174}, // #76
  { 3, 183}, // #77
  { 3, 202}, // #78
  {11,  1}, // #79
  {14,  1}, // #80
  {19,  1}, // #81
  { 1,  2}, // #82
  { 5,  1}, // #83
  { 7,  1}, // #84
  { 8,  1}, // #85
  {22,  1}, // #86
  {24,  1}, // #87
  { 1,  1}, // #88
  { 2,  1}, // #89
  { 5,  1}, // #90
  { 7,  1}, // #91
  { 8,  1}, // #92
  {22,  1}, // #93
  { 5,  1}, // #94
  { 8,  1}, // #95
  { 1,  1}, // #96
  {13,  1}, // #97
  {14,  1}, // #98
  {16,  1}, // #99
  {19,  1}, // #100
  {24,  1}, // #101
  { 1,  1}, // #102
  {10,  1}, // #103
  {14,  1}, // #104
  {19,  1}, // #105
  {22,  1}, // #106
  {10,  1}, // #107
  {14,  1}, // #108
  {16,  1}, // #109
  {19,  1}, // #110
  { 5,  2}, // #111
  { 8,  2}, // #112
  { 1,  2}, // #113
  { 5,  2}, // #114
  { 8,  2}, // #115
  {22,  1}, // #116
  {24,  1}, // #117
  { 1,  1}, // #118
  { 5,  2}, // #119
  { 8,  2}, // #120
  {22,  1}, // #121
  { 1,  2}, // #122
  { 5,  1}, // #123
  { 8,  1}, // #124
  {22,  1}, // #125
  {24,  1}, // #126
  { 1,  1}, // #127
  { 5,  1}, // #128
  { 8,  1}, // #129
  {22,  1}, // #130
  { 1,  1}, // #131
  {10,  1}, // #132
  {14,  1}, // #133
  {15,  1}, // #134
  {19,  1}, // #135
  {22,  1}, // #136
  { 1,  1}, // #137
  {12,  1}, // #138
  {14,  1}, // #139
  {15,  1}, // #140
  {19,  1}, // #141
  {22,  1}, // #142
  { 1,  1}, // #143
  {10,  4}, // #144
  {14,  1}, // #145
  {19,  1}, // #146
  {22,  1}, // #147
  { 1,  1}, // #148
  { 5,  4}, // #149
  { 8,  4}, // #150
  {22,  1}, // #151
  { 1,  1}, // #152
  {22,  1}, // #153
  { 1,  1}, // #154
  { 5,  1}, // #155
  { 6,  1}, // #156
  { 8,  1}, // #157
  {10,  1}, // #158
  {14,  1}, // #159
  {15,  1}, // #160
  {19,  1}, // #161
  {22,  1}, // #162
  { 1,  1}, // #163
  {13,  1}, // #164
  {14,  1}, // #165
  {16,  1}, // #166
  {19,  1}, // #167
  {22,  1}, // #168
  { 1,  1}, // #169
  { 5,  1}, // #170
  { 6,  1}, // #171
  { 8,  1}, // #172
  {10,  1}, // #173
  {13,  1}, // #174
  {14,  1}, // #175
  {16,  1}, // #176
  {19,  1}, // #177
  {22,  1}, // #178
  { 1,  1}, // #179
  { 4, 15}, // #180
  { 5,  1}, // #181
  { 7,  1}, // #182
  { 8,  1}, // #183
  {22,  1}, // #184
  { 1,  1}, // #185
  { 4, 14}, // #186
  { 5,  1}, // #187
  { 7,  1}, // #188
  { 8,  1}, // #189
  {22,  1}, // #190
  { 1,  1}, // #191
  { 4, 12}, // #192
  { 5,  1}, // #193
  { 7,  1}, // #194
  { 8,  1}, // #195
  {22,  1}, // #196
  { 1,  1}, // #197
  {10, 19}, // #198
  {14,  1}, // #199
  {16,  1}, // #200
  {19,  1}, // #201
  {22,  1}, // #202
  { 1,  1}, // #203
  {10,  3}, // #204
  {14,  1}, // #205
  {16,  1}, // #206
  {19,  1}, // #207
  {22,  1}, // #208
  { 1,  1}, // #209
  {11,  1}, // #210
  {14,  1}, // #211
  {19,  1}, // #212
  {22,  1}, // #213
  { 1,  1}, // #214
  { 4, 17}, // #215
  { 5,  1}, // #216
  { 7,  1}, // #217
  { 8,  1}, // #218
  {22,  1}, // #219
  { 1,  1}, // #220
  { 4, 25}, // #221
  { 5,  1}, // #222
  { 7,  1}, // #223
  { 8,  1}, // #224
  {22,  1}, // #225
  { 1,  1}, // #226
  { 5,  1}, // #227
  { 7,  1}, // #228
  { 8,  1}, // #229
  {22,  1}, // #230
  {23,  1}, // #231
  { 5,  1}, // #232
  { 7,  1}, // #233
  { 8,  1}, // #234
  {23,  1}, // #235
  { 1,  1}, // #236
  { 5,  1}, // #237
  { 7,  1}, // #238
  { 8,  1}, // #239
  {22,  1}, // #240
  {23,  4}, // #241
  { 5,  1}, // #242
  { 7,  1}, // #243
  { 8,  1}, // #244
  {23,  4}, // #245
  { 1,  1}, // #246
  {24,  1}, // #247
  { 1,  1}, // #248
  {11,  4}, // #249
  {14,  1}, // #250
  {19,  1}, // #251
  {22,  1}, // #252
  { 1,  1}, // #253
  {12,  2}, // #254
  {14,  1}, // #255
  {15,  1}, // #256
  {19,  1}, // #257
  {22,  1}, // #258
  { 1,  1}, // #259
  {10,  1}, // #260
  {14,  1}, // #261
  {16,  1}, // #262
  {19,  1}, // #263
  {22,  1}, // #264
  { 1,  9}, // #265
  { 5,  1}, // #266
  { 6,  1}, // #267
  { 8,  1}, // #268
  {10,  1}, // #269
  {11,  4}, // #270
  {14,  1}, // #271
  {16,  1}, // #272
  {19,  1}, // #273
  {22,  7}, // #274
  {24,  2}, // #275
  { 1,  8}, // #276
  { 5,  1}, // #277
  { 6,  1}, // #278
  { 8,  1}, // #279
  {10,  1}, // #280
  {11,  4}, // #281
  {14,  1}, // #282
  {16,  1}, // #283
  {19,  1}, // #284
  {22,  6}, // #285
  {24,  2}, // #286
  { 1,  1}, // #287
  { 5,  1}, // #288
  { 6,  1}, // #289
  { 8,  1}, // #290
  {10,  2}, // #291
  {14,  1}, // #292
  {16,  1}, // #293
  {19,  1}, // #294
  {22,  1}, // #295
  { 1,  1}, // #296
  {11,  1}, // #297
  {14,  1}, // #298
  {15,  1}, // #299
  {19,  1}, // #300
  {22,  1}, // #301
  { 1,  1}, // #302
  {11,  1}, // #303
  {12,  2}, // #304
  {14,  3}, // #305
  {15,  2}, // #306
  {19,  3}, // #307
  {22,  1}, // #308
  { 1,  2}, // #309
  {22,  1}, // #310
  {24,  1}, // #311
  { 1,  1}, // #312
  { 5,  1}, // #313
  { 8,  1}, // #314
  {24,  1}, // #315
  { 1,  1}, // #316
  { 5, 22}, // #317
  { 8, 22}, // #318
  {22,  1}, // #319
  { 5,  8}, // #320
  { 8,  8}, // #321
  { 5,  6}, // #322
  { 8,  6}, // #323
  { 1,  1}, // #324
  {10, 27}, // #325
  {14,  1}, // #326
  {16,  1}, // #327
  {19,  1}, // #328
  {22,  1}, // #329
  { 1,  1}, // #330
  {10, 21}, // #331
  {14,  1}, // #332
  {16,  1}, // #333
  {19,  1}, // #334
  {22,  1}, // #335
  {10, 35}, // #336
  {14,  1}, // #337
  {16,  1}, // #338
  {19,  1}, // #339
  { 1,  1}, // #340
  {10,  1}, // #341
  {14,  1}, // #342
  {22,  1}, // #343
  { 1,  2}, // #344
  {10,  1}, // #345
  {14,  2}, // #346
  {15,  2}, // #347
  {19,  2}, // #348
  {22,  2}, // #349
  { 1,  2}, // #350
  {11,  1}, // #351
  {14,  1}, // #352
  {19,  1}, // #353
  {22,  2}, // #354
  { 1,  2}, // #355
  {10,  2}, // #356
  {14,  2}, // #357
  {19,  2}, // #358
  {22,  2}, // #359
  { 1,  2}, // #360
  {10,  6}, // #361
  {14,  2}, // #362
  {19,  2}, // #363
  {22,  2}, // #364
  { 1,  2}, // #365
  {13,  1}, // #366
  {14,  2}, // #367
  {16,  2}, // #368
  {19,  2}, // #369
  {22,  2}, // #370
  { 1,  2}, // #371
  {10,  1}, // #372
  {13,  1}, // #373
  {14,  2}, // #374
  {16,  2}, // #375
  {19,  2}, // #376
  {22,  2}, // #377
  { 1,  1}, // #378
  {10,  1}, // #379
  {13,  1}, // #380
  {14,  2}, // #381
  {16,  2}, // #382
  {19,  2}, // #383
  {24,  1}, // #384
  { 1,  2}, // #385
  {10, 38}, // #386
  {14,  2}, // #387
  {16,  2}, // #388
  {19,  2}, // #389
  {22,  2}, // #390
  { 1,  2}, // #391
  {10,  6}, // #392
  {14,  2}, // #393
  {16,  2}, // #394
  {19,  2}, // #395
  {22,  2}, // #396
  { 1,  2}, // #397
  {10,  1}, // #398
  {14,  1}, // #399
  {22,  2}, // #400
  { 1,  2}, // #401
  {10,  4}, // #402
  {14,  2}, // #403
  {19,  2}, // #404
  {24,  2}, // #405
  { 1,  2}, // #406
  {10,  4}, // #407
  {14,  2}, // #408
  {19,  2}, // #409
  {22,  2}, // #410
  { 1,  1}, // #411
  {10,  4}, // #412
  {14,  1}, // #413
  {19,  1}, // #414
  {24,  1}, // #415
  { 1,  1}, // #416
  {10,  2}, // #417
  {14,  1}, // #418
  {19,  1}, // #419
  {22,  1}, // #420
  {11,  2}, // #421
  {14,  2}, // #422
  {19,  2}, // #423
  { 1,  2}, // #424
  {13,  2}, // #425
  {14,  2}, // #426
  {16,  2}, // #427
  {19,  2}, // #428
  {24,  2}, // #429
  { 1,  2}, // #430
  {10,  1}, // #431
  {14,  2}, // #432
  {16,  2}, // #433
  {19,  2}, // #434
  {22,  2}, // #435
  { 1,  2}, // #436
  {11,  4}, // #437
  {14,  2}, // #438
  {19,  2}, // #439
  {24,  2}, // #440
  { 1,  2}, // #441
  {11,  4}, // #442
  {14,  2}, // #443
  {19,  2}, // #444
  {22,  2}, // #445
  { 1,  1}, // #446
  {11,  4}, // #447
  {14,  1}, // #448
  {19,  1}, // #449
  {24,  1}, // #450
  { 1,  1}, // #451
  {11,  2}, // #452
  {14,  1}, // #453
  {19,  1}, // #454
  {22,  1}, // #455
  { 1,  2}, // #456
  { 5,  1}, // #457
  { 6,  1}, // #458
  { 8,  1}, // #459
  {10,  2}, // #460
  {14,  2}, // #461
  {19,  2}, // #462
  {22,  2}, // #463
  { 1,  2}, // #464
  {10, 54}, // #465
  {14,  2}, // #466
  {16,  2}, // #467
  {19,  2}, // #468
  {22,  2}, // #469
  { 1,  2}, // #470
  {10, 42}, // #471
  {14,  2}, // #472
  {16,  2}, // #473
  {19,  2}, // #474
  {22,  2}, // #475
  { 1,  1}, // #476
  {10,  4}, // #477
  {14,  2}, // #478
  {19,  2}, // #479
  {22,  1}, // #480
  {15,  1}, // #481
  {19,  1}, // #482
  {22,  1}, // #483
  {23,  1}, // #484
  { 7,  1}, // #485
  {12,  1}, // #486
  {14,  2}, // #487
  {17,  1}, // #488
  {20,  2}, // #489
  {21,  2}, // #490
  {22,  3}, // #491
  {23,  6}, // #492
  {14,  1}, // #493
  {17,  1}, // #494
  {20,  1}, // #495
  {21,  1}, // #496
  {22,  1}, // #497
  {23,  2}, // #498
  {14,  1}, // #499
  {20,  1}, // #500
  {22,  1}, // #501
  {23,  1}, // #502
  { 7,  1}, // #503
  {12,  1}, // #504
  {21,  1}, // #505
  {23,  2}, // #506
  {17,  1}, // #507
  {21,  1}, // #508
  {23,  1}, // #509
  { 8,  1}, // #510
  {13,  1}, // #511
  {15,  1}, // #512
  {18,  1}, // #513
  {19,  1}, // #514
  {20,  1}, // #515
  {22,  1}, // #516
  {23,  1}, // #517
  { 7,  1}, // #518
  {12,  1}, // #519
  {17,  1}, // #520
  {21,  2}, // #521
  {22,  1}, // #522
  {23,  4}, // #523
  {17,  1}, // #524
  {21,  1}, // #525
  {22,  1}, // #526
  {23,  2}, // #527
  { 4,  1}, // #528
  {11,  1}, // #529
  {15,  1}, // #530
  {16,  1}, // #531
  {17,  1}, // #532
  {19,  1}, // #533
  {21,  1}, // #534
  {22,  1}, // #535
  {23,  2}, // #536
  { 4,  1}, // #537
  {11,  1}, // #538
  {15,  1}, // #539
  {16,  1}, // #540
  {19,  1}, // #541
  {22,  1}, // #542
  {23,  1}, // #543
  { 8,  1}, // #544
  {13,  1}, // #545
  {15,  1}, // #546
  {17,  1}, // #547
  {18,  1}, // #548
  {19,  1}, // #549
  {20,  1}, // #550
  {21,  1}, // #551
  {22,  1}, // #552
  {23,  2}, // #553
  { 8,  2}, // #554
  {13,  2}, // #555
  {15,  2}, // #556
  {17,  1}, // #557
  {18,  2}, // #558
  {19,  2}, // #559
  {20,  2}, // #560
  {21,  1}, // #561
  {22,  2}, // #562
  {23,  3}, // #563
  { 8,  2}, // #564
  {13,  2}, // #565
  {15,  2}, // #566
  {18,  2}, // #567
  {19,  2}, // #568
  {20,  2}, // #569
  {22,  2}, // #570
  {23,  2}, // #571
  { 3,  2}, // #572
  { 8,  7}, // #573
  {11,  2}, // #574
  {12,  2}, // #575
  {13,  9}, // #576
  {14,  2}, // #577
  {15,  7}, // #578
  {17,  1}, // #579
  {18,  7}, // #580
  {19, 10}, // #581
  {20,  9}, // #582
  {21,  1}, // #583
  {22, 10}, // #584
  {23, 11}, // #585
  { 3,  2}, // #586
  { 8,  7}, // #587
  {11,  2}, // #588
  {12,  2}, // #589
  {13,  9}, // #590
  {14,  2}, // #591
  {15,  7}, // #592
  {18,  7}, // #593
  {19, 11}, // #594
  {20,  9}, // #595
  {22, 11}, // #596
  {23, 11}, // #597
  {14,  1}, // #598
  {15,  1}, // #599
  {17,  1}, // #600
  {19,  1}, // #601
  {20,  1}, // #602
  {21,  1}, // #603
  {22,  2}, // #604
  {23,  3}, // #605
  {14,  1}, // #606
  {15,  1}, // #607
  {19,  1}, // #608
  {20,  1}, // #609
  {22,  2}, // #610
  {23,  2}, // #611
  {15,  1}, // #612
  {17,  1}, // #613
  {19,  1}, // #614
  {21,  1}, // #615
  {22,  1}, // #616
  {23,  2}, // #617
  { 7,  1}, // #618
  {12,  1}, // #619
  {14,  1}, // #620
  {17,  1}, // #621
  {20,  1}, // #622
  {21,  2}, // #623
  {22,  1}, // #624
  {23,  4}, // #625
  {14,  1}, // #626
  {17,  1}, // #627
  {20,  1}, // #628
  {21,  1}, // #629
  {22,  2}, // #630
  {23,  3}, // #631
  {14,  1}, // #632
  {20,  1}, // #633
  {22,  2}, // #634
  {23,  2}, // #635
  {14,  2}, // #636
  {20,  2}, // #637
  {22,  5}, // #638
  {23,  5}, // #639
  { 3,  2}, // #640
  { 4,  2}, // #641
  { 8,  2}, // #642
  {11,  4}, // #643
  {12,  2}, // #644
  {13,  4}, // #645
  {14,  2}, // #646
  {15,  4}, // #647
  {16,  2}, // #648
  {17,  1}, // #649
  {18,  2}, // #650
  {19,  6}, // #651
  {20,  4}, // #652
  {21,  1}, // #653
  {22,  7}, // #654
  {23,  8}, // #655
  { 3,  7}, // #656
  { 4,  7}, // #657
  { 8,  3}, // #658
  { 9,  3}, // #659
  {11, 15}, // #660
  {12,  7}, // #661
  {13, 10}, // #662
  {14, 10}, // #663
  {15, 10}, // #664
  {16, 10}, // #665
  {18,  6}, // #666
  {19, 18}, // #667
  {20, 13}, // #668
  {22, 32}, // #669
  {23, 32}, // #670
  { 1, 10}, // #671
  { 3,  1}, // #672
  {11,  1}, // #673
  {12,  1}, // #674
  {13,  1}, // #675
  {14,  1}, // #676
  {19,  1}, // #677
  {20,  1}, // #678
  {22,  1}, // #679
  {23,  1}, // #680
  { 2,  8}, // #681
  { 3,  1}, // #682
  {11,  1}, // #683
  {12,  1}, // #684
  {13,  1}, // #685
  {14,  1}, // #686
  {17,  1}, // #687
  {19,  1}, // #688
  {20,  1}, // #689
  {21,  1}, // #690
  {22,  1}, // #691
  {23,  2}, // #692
  { 2,  8}, // #693
  { 3,  1}, // #694
  {11,  1}, // #695
  {12,  1}, // #696
  {13,  1}, // #697
  {14,  1}, // #698
  {19,  1}, // #699
  {20,  1}, // #700
  {22,  1}, // #701
  {23,  1}, // #702
  { 2,  5}, // #703
  { 3,  1}, // #704
  {11,  1}, // #705
  {12,  1}, // #706
  {13,  1}, // #707
  {14,  1}, // #708
  {17,  1}, // #709
  {19,  1}, // #710
  {20,  1}, // #711
  {21,  1}, // #712
  {22,  1}, // #713
  {23,  2}, // #714
  { 2,  5}, // #715
  { 3,  1}, // #716
  {11,  1}, // #717
  {12,  1}, // #718
  {13,  1}, // #719
  {14,  1}, // #720
  {19,  1}, // #721
  {20,  1}, // #722
  {22,  1}, // #723
  {23,  1}, // #724
  { 2,  3}, // #725
  { 3,  1}, // #726
  {11,  1}, // #727
  {12,  1}, // #728
  {13,  1}, // #729
  {14,  1}, // #730
  {19,  1}, // #731
  {20,  1}, // #732
  {22,  1}, // #733
  {23,  1}, // #734
  { 2,  4}, // #735
  { 3,  1}, // #736
  {11,  1}, // #737
  {12,  1}, // #738
  {13,  1}, // #739
  {14,  1}, // #740
  {19,  1}, // #741
  {20,  1}, // #742
  {22,  1}, // #743
  {23,  1}, // #744
  { 3,  1}, // #745
  { 4,  1}, // #746
  { 8,  1}, // #747
  {11,  2}, // #748
  {12,  1}, // #749
  {13,  2}, // #750
  {14,  1}, // #751
  {15,  2}, // #752
  {16,  1}, // #753
  {17,  1}, // #754
  {18,  1}, // #755
  {19,  3}, // #756
  {20,  2}, // #757
  {21,  1}, // #758
  {22,  3}, // #759
  {23,  4}, // #760
  { 3,  1}, // #761
  { 4,  1}, // #762
  { 8,  1}, // #763
  {11,  2}, // #764
  {12,  1}, // #765
  {13,  2}, // #766
  {14,  1}, // #767
  {15,  2}, // #768
  {16,  1}, // #769
  {18,  1}, // #770
  {19,  3}, // #771
  {20,  2}, // #772
  {22,  3}, // #773
  {23,  3}, // #774
  { 3,  2}, // #775
  { 4,  1}, // #776
  { 8,  1}, // #777
  {11,  3}, // #778
  {12,  2}, // #779
  {13,  3}, // #780
  {14,  2}, // #781
  {15,  2}, // #782
  {16,  1}, // #783
  {17,  1}, // #784
  {18,  1}, // #785
  {19,  4}, // #786
  {20,  3}, // #787
  {21,  1}, // #788
  {22,  4}, // #789
  {23,  5}, // #790
  { 3,  2}, // #791
  { 4,  1}, // #792
  { 8,  1}, // #793
  {11,  3}, // #794
  {12,  2}, // #795
  {13,  3}, // #796
  {14,  2}, // #797
  {15,  2}, // #798
  {16,  1}, // #799
  {18,  1}, // #800
  {19,  4}, // #801
  {20,  3}, // #802
  {22,  4}, // #803
  {23,  4}, // #804
  { 7,  1}, // #805
  { 8,  1}, // #806
  {12,  1}, // #807
  {13,  1}, // #808
  {15,  1}, // #809
  {18,  1}, // #810
  {19,  1}, // #811
  {20,  1}, // #812
  {21,  1}, // #813
  {22,  1}, // #814
  {23,  3}, // #815
  { 3,  1}, // #816
  { 8,  1}, // #817
  {11,  1}, // #818
  {12,  1}, // #819
  {13,  2}, // #820
  {14,  1}, // #821
  {15,  1}, // #822
  {18,  1}, // #823
  {19,  2}, // #824
  {20,  2}, // #825
  {22,  2}, // #826
  {23,  2}, // #827
  {11,  8}, // #828
  {15,  1}, // #829
  {19, 30}, // #830
  {22, 31}, // #831
  {23, 31}, // #832
  {11,  2}, // #833
  {19,  2}, // #834
  {22,  2}, // #835
  {23,  2}, // #836
  { 4,  1}, // #837
  { 8,  2}, // #838
  {11,  1}, // #839
  {13,  2}, // #840
  {15,  3}, // #841
  {16,  1}, // #842
  {17,  1}, // #843
  {18,  2}, // #844
  {19,  3}, // #845
  {20,  2}, // #846
  {21,  1}, // #847
  {22,  3}, // #848
  {23,  4}, // #849
  { 4,  1}, // #850
  { 8,  2}, // #851
  {11,  1}, // #852
  {13,  2}, // #853
  {15,  3}, // #854
  {16,  1}, // #855
  {18,  2}, // #856
  {19,  3}, // #857
  {20,  2}, // #858
  {22,  3}, // #859
  {23,  3}, // #860
  { 4,  1}, // #861
  {11,  1}, // #862
  {14,  1}, // #863
  {15,  1}, // #864
  {16,  1}, // #865
  {17,  1}, // #866
  {19,  1}, // #867
  {20,  1}, // #868
  {21,  1}, // #869
  {22,  4}, // #870
  {23,  5}, // #871
  { 4,  1}, // #872
  {11,  1}, // #873
  {14,  1}, // #874
  {15,  1}, // #875
  {16,  1}, // #876
  {19,  1}, // #877
  {20,  1}, // #878
  {22,  4}, // #879
  {23,  4}, // #880
  { 4,  1}, // #881
  {11,  1}, // #882
  {15,  1}, // #883
  {16,  1}, // #884
  {17,  1}, // #885
  {19,  1}, // #886
  {21,  1}, // #887
  {22,  2}, // #888
  {23,  3}, // #889
  { 4,  1}, // #890
  {11,  1}, // #891
  {15,  1}, // #892
  {16,  1}, // #893
  {19,  1}, // #894
  {22,  2}, // #895
  {23,  2}, // #896
  { 4,  1}, // #897
  {11,  1}, // #898
  {14,  1}, // #899
  {15,  1}, // #900
  {16,  1}, // #901
  {17,  1}, // #902
  {19,  1}, // #903
  {20,  1}, // #904
  {21,  1}, // #905
  {22,  3}, // #906
  {23,  4}, // #907
  { 4,  1}, // #908
  {11,  1}, // #909
  {14,  1}, // #910
  {15,  1}, // #911
  {16,  1}, // #912
  {19,  1}, // #913
  {20,  1}, // #914
  {22,  3}, // #915
  {23,  3}, // #916
  { 4,  1}, // #917
  { 8,  1}, // #918
  {11,  1}, // #919
  {13,  1}, // #920
  {15,  2}, // #921
  {16,  1}, // #922
  {17,  1}, // #923
  {18,  1}, // #924
  {19,  2}, // #925
  {20,  1}, // #926
  {21,  1}, // #927
  {22,  2}, // #928
  {23,  3}, // #929
  { 4,  1}, // #930
  { 8,  1}, // #931
  {11,  1}, // #932
  {13,  1}, // #933
  {15,  2}, // #934
  {16,  1}, // #935
  {18,  1}, // #936
  {19,  2}, // #937
  {20,  1}, // #938
  {22,  2}, // #939
  {23,  2}, // #940
  { 3,  1}, // #941
  {11,  1}, // #942
  {12,  1}, // #943
  {13,  1}, // #944
  {14,  1}, // #945
  {17,  1}, // #946
  {19,  1}, // #947
  {20,  1}, // #948
  {21,  1}, // #949
  {22,  2}, // #950
  {23,  3}, // #951
  {11,  1}, // #952
  {19,  1}, // #953
  {22,  1}, // #954
  {23,  1}, // #955
  { 7,  1}, // #956
  {12,  1}, // #957
  {17,  1}, // #958
  {21,  1}, // #959
  {23,  2}, // #960
  { 8,  2}, // #961
  {13,  2}, // #962
  {15,  3}, // #963
  {17,  1}, // #964
  {18,  2}, // #965
  {19,  3}, // #966
  {20,  2}, // #967
  {21,  1}, // #968
  {22,  3}, // #969
  {23,  4}, // #970
  { 8,  2}, // #971
  {13,  2}, // #972
  {15,  3}, // #973
  {18,  2}, // #974
  {19,  3}, // #975
  {20,  2}, // #976
  {22,  3}, // #977
  {23,  3}, // #978
  { 3,  1}, // #979
  { 8,  2}, // #980
  {11,  1}, // #981
  {12,  1}, // #982
  {13,  3}, // #983
  {14,  1}, // #984
  {15,  2}, // #985
  {17,  1}, // #986
  {18,  2}, // #987
  {19,  3}, // #988
  {20,  3}, // #989
  {21,  1}, // #990
  {22,  3}, // #991
  {23,  4}, // #992
  { 3,  1}, // #993
  { 8,  2}, // #994
  {11,  1}, // #995
  {12,  1}, // #996
  {13,  3}, // #997
  {14,  1}, // #998
  {15,  2}, // #999
  {18,  2}, // #1000
  {19,  3}, // #1001
  {20,  3}, // #1002
  {22,  3}, // #1003
  {23,  3}, // #1004
  {11,  1}, // #1005
  {17,  1}, // #1006
  {19,  1}, // #1007
  {21,  1}, // #1008
  {22,  1}, // #1009
  {23,  2}, // #1010
  { 3,  4}, // #1011
  { 8,  3}, // #1012
  {11,  4}, // #1013
  {12,  4}, // #1014
  {13,  7}, // #1015
  {14,  4}, // #1016
  {15,  3}, // #1017
  {17,  1}, // #1018
  {18,  3}, // #1019
  {19,  7}, // #1020
  {20,  7}, // #1021
  {21,  1}, // #1022
  {22,  8}, // #1023
  {23,  9}, // #1024
  { 3,  4}, // #1025
  { 8,  3}, // #1026
  {11,  4}, // #1027
  {12,  4}, // #1028
  {13,  7}, // #1029
  {14,  4}, // #1030
  {15,  3}, // #1031
  {18,  3}, // #1032
  {19,  7}, // #1033
  {20,  7}, // #1034
  {22,  8}, // #1035
  {23,  8}, // #1036
  { 3,  4}, // #1037
  { 8,  3}, // #1038
  {11,  4}, // #1039
  {12,  4}, // #1040
  {13,  7}, // #1041
  {14,  4}, // #1042
  {15,  3}, // #1043
  {17,  1}, // #1044
  {18,  3}, // #1045
  {19,  8}, // #1046
  {20,  7}, // #1047
  {21,  1}, // #1048
  {22,  9}, // #1049
  {23, 10}, // #1050
  { 3,  4}, // #1051
  { 8,  3}, // #1052
  {11,  4}, // #1053
  {12,  4}, // #1054
  {13,  7}, // #1055
  {14,  4}, // #1056
  {15,  3}, // #1057
  {18,  3}, // #1058
  {19,  8}, // #1059
  {20,  7}, // #1060
  {22,  9}, // #1061
  {23,  9}, // #1062
  { 3,  3}, // #1063
  {11,  3}, // #1064
  {12,  3}, // #1065
  {13,  3}, // #1066
  {14,  3}, // #1067
  {17,  1}, // #1068
  {19,  3}, // #1069
  {20,  3}, // #1070
  {21,  1}, // #1071
  {22,  3}, // #1072
  {23,  4}, // #1073
  { 3,  3}, // #1074
  {11,  3}, // #1075
  {12,  3}, // #1076
  {13,  3}, // #1077
  {14,  3}, // #1078
  {19,  3}, // #1079
  {20,  3}, // #1080
  {22,  3}, // #1081
  {23,  3}, // #1082
  { 3,  2}, // #1083
  {11,  2}, // #1084
  {12,  2}, // #1085
  {13,  2}, // #1086
  {14,  2}, // #1087
  {17,  1}, // #1088
  {19,  2}, // #1089
  {20,  2}, // #1090
  {21,  1}, // #1091
  {22,  2}, // #1092
  {23,  3}, // #1093
  { 3,  2}, // #1094
  {11,  2}, // #1095
  {12,  2}, // #1096
  {13,  2}, // #1097
  {14,  2}, // #1098
  {19,  2}, // #1099
  {20,  2}, // #1100
  {22,  2}, // #1101
  {23,  2}, // #1102
  { 7,  1}, // #1103
  {12,  1}, // #1104
  {17,  1}, // #1105
  {21,  2}, // #1106
  {23,  3}, // #1107
  { 3,  1}, // #1108
  { 8,  1}, // #1109
  {11,  1}, // #1110
  {12,  1}, // #1111
  {13,  2}, // #1112
  {14,  1}, // #1113
  {15,  1}, // #1114
  {17,  1}, // #1115
  {18,  1}, // #1116
  {19,  2}, // #1117
  {20,  2}, // #1118
  {21,  1}, // #1119
  {22,  2}, // #1120
  {23,  3}, // #1121
  { 7,  1}, // #1122
  {12,  1}, // #1123
  {14,  2}, // #1124
  {17,  1}, // #1125
  {20,  2}, // #1126
  {21,  2}, // #1127
  {22,  2}, // #1128
  {23,  5}, // #1129
  {14,  2}, // #1130
  {20,  2}, // #1131
  {22,  2}, // #1132
  {23,  2}, // #1133
  {14,  2}, // #1134
  {20,  2}, // #1135
  {22,  3}, // #1136
  {23,  3}, // #1137
  { 4,  2}, // #1138
  {11,  2}, // #1139
  {15,  2}, // #1140
  {16,  2}, // #1141
  {17,  1}, // #1142
  {19,  2}, // #1143
  {21,  1}, // #1144
  {22,  2}, // #1145
  {23,  3}, // #1146
  { 7,  1}, // #1147
  {12,  1}, // #1148
  {14,  1}, // #1149
  {20,  1}, // #1150
  {21,  1}, // #1151
  {22,  1}, // #1152
  {23,  3}, // #1153
  { 4,  1}, // #1154
  {11,  1}, // #1155
  {14,  1}, // #1156
  {15,  1}, // #1157
  {16,  1}, // #1158
  {17,  1}, // #1159
  {19,  1}, // #1160
  {20,  1}, // #1161
  {21,  2}, // #1162
  {22,  4}, // #1163
  {23,  6}, // #1164
  { 4,  1}, // #1165
  {11,  1}, // #1166
  {15,  1}, // #1167
  {16,  1}, // #1168
  {17,  1}, // #1169
  {19,  1}, // #1170
  {21,  2}, // #1171
  {22,  2}, // #1172
  {23,  4}, // #1173
  { 2, 14}, // #1174
  { 3,  1}, // #1175
  {11,  1}, // #1176
  {12,  1}, // #1177
  {13,  1}, // #1178
  {14,  1}, // #1179
  {17,  1}, // #1180
  {19,  1}, // #1181
  {20,  1}, // #1182
  {21,  1}, // #1183
  {22,  1}, // #1184
  {23,  2}, // #1185
  { 2, 14}, // #1186
  { 3,  1}, // #1187
  {11,  1}, // #1188
  {12,  1}, // #1189
  {13,  1}, // #1190
  {14,  1}, // #1191
  {19,  1}, // #1192
  {20,  1}, // #1193
  {22,  1}, // #1194
  {23,  1}, // #1195
  { 2,  7}, // #1196
  { 3,  1}, // #1197
  {11,  1}, // #1198
  {12,  1}, // #1199
  {13,  1}, // #1200
  {14,  1}, // #1201
  {17,  1}, // #1202
  {19,  1}, // #1203
  {20,  1}, // #1204
  {21,  1}, // #1205
  {22,  1}, // #1206
  {23,  2}, // #1207
  { 2,  7}, // #1208
  { 3,  1}, // #1209
  {11,  1}, // #1210
  {12,  1}, // #1211
  {13,  1}, // #1212
  {14,  1}, // #1213
  {19,  1}, // #1214
  {20,  1}, // #1215
  {22,  1}, // #1216
  {23,  1}, // #1217
  { 2,  9}, // #1218
  { 3,  1}, // #1219
  {11,  1}, // #1220
  {12,  1}, // #1221
  {13,  1}, // #1222
  {14,  1}, // #1223
  {19,  1}, // #1224
  {20,  1}, // #1225
  {22,  1}, // #1226
  {23,  1}, // #1227
  { 4,  1}, // #1228
  { 7,  1}, // #1229
  {11,  1}, // #1230
  {12,  1}, // #1231
  {15,  1}, // #1232
  {16,  1}, // #1233
  {19,  1}, // #1234
  {21,  1}, // #1235
  {22,  1}, // #1236
  {23,  3}, // #1237
  { 2, 16}, // #1238
  { 3,  2}, // #1239
  {11,  2}, // #1240
  {12,  2}, // #1241
  {13,  2}, // #1242
  {14,  2}, // #1243
  {17,  1}, // #1244
  {19,  3}, // #1245
  {20,  2}, // #1246
  {21,  1}, // #1247
  {22,  3}, // #1248
  {23,  4}, // #1249
  { 2, 16}, // #1250
  { 3,  2}, // #1251
  {11,  2}, // #1252
  {12,  2}, // #1253
  {13,  2}, // #1254
  {14,  2}, // #1255
  {19,  3}, // #1256
  {20,  2}, // #1257
  {22,  3}, // #1258
  {23,  3}, // #1259
  { 2, 10}, // #1260
  { 3,  2}, // #1261
  {11,  2}, // #1262
  {12,  2}, // #1263
  {13,  2}, // #1264
  {14,  2}, // #1265
  {17,  1}, // #1266
  {19,  3}, // #1267
  {20,  2}, // #1268
  {21,  1}, // #1269
  {22,  3}, // #1270
  {23,  4}, // #1271
  { 2, 10}, // #1272
  { 3,  2}, // #1273
  {11,  2}, // #1274
  {12,  2}, // #1275
  {13,  2}, // #1276
  {14,  2}, // #1277
  {19,  3}, // #1278
  {20,  2}, // #1279
  {22,  3}, // #1280
  {23,  3}, // #1281
  { 3,  1}, // #1282
  { 7,  1}, // #1283
  {11,  1}, // #1284
  {12,  2}, // #1285
  {13,  1}, // #1286
  {14,  1}, // #1287
  {15,  1}, // #1288
  {19,  2}, // #1289
  {20,  1}, // #1290
  {21,  1}, // #1291
  {22,  2}, // #1292
  {23,  4}, // #1293
  { 3,  2}, // #1294
  { 8,  1}, // #1295
  {11,  2}, // #1296
  {12,  2}, // #1297
  {13,  3}, // #1298
  {14,  2}, // #1299
  {15,  1}, // #1300
  {17,  1}, // #1301
  {18,  1}, // #1302
  {19,  3}, // #1303
  {20,  3}, // #1304
  {21,  1}, // #1305
  {22,  3}, // #1306
  {23,  4}, // #1307
  { 3,  2}, // #1308
  { 8,  1}, // #1309
  {11,  2}, // #1310
  {12,  2}, // #1311
  {13,  3}, // #1312
  {14,  2}, // #1313
  {15,  1}, // #1314
  {18,  1}, // #1315
  {19,  3}, // #1316
  {20,  3}, // #1317
  {22,  3}, // #1318
  {23,  3}, // #1319
  { 2, 28}, // #1320
  { 3,  2}, // #1321
  {11,  2}, // #1322
  {12,  2}, // #1323
  {13,  2}, // #1324
  {14,  2}, // #1325
  {17,  1}, // #1326
  {19,  3}, // #1327
  {20,  2}, // #1328
  {21,  1}, // #1329
  {22,  3}, // #1330
  {23,  4}, // #1331
  { 2, 28}, // #1332
  { 3,  2}, // #1333
  {11,  2}, // #1334
  {12,  2}, // #1335
  {13,  2}, // #1336
  {14,  2}, // #1337
  {19,  3}, // #1338
  {20,  2}, // #1339
  {22,  3}, // #1340
  {23,  3}, // #1341
  { 2, 14}, // #1342
  { 3,  2}, // #1343
  {11,  2}, // #1344
  {12,  2}, // #1345
  {13,  2}, // #1346
  {14,  2}, // #1347
  {17,  1}, // #1348
  {19,  3}, // #1349
  {20,  2}, // #1350
  {21,  1}, // #1351
  {22,  3}, // #1352
  {23,  4}, // #1353
  { 2, 14}, // #1354
  { 3,  2}, // #1355
  {11,  2}, // #1356
  {12,  2}, // #1357
  {13,  2}, // #1358
  {14,  2}, // #1359
  {19,  3}, // #1360
  {20,  2}, // #1361
  {22,  3}, // #1362
  {23,  3}, // #1363
  {14,  1}, // #1364
  {17,  1}, // #1365
  {20,  1}, // #1366
  {21,  2}, // #1367
  {22,  3}, // #1368
  {23,  5}, // #1369
  { 4,  2}, // #1370
  {11,  2}, // #1371
  {14,  3}, // #1372
  {15,  3}, // #1373
  {16,  2}, // #1374
  {17,  1}, // #1375
  {19,  3}, // #1376
  {20,  3}, // #1377
  {21,  2}, // #1378
  {22,  9}, // #1379
  {23, 11}, // #1380
  { 3,  2}, // #1381
  { 4,  1}, // #1382
  { 9,  4}, // #1383
  {11,  3}, // #1384
  {12,  2}, // #1385
  {13,  2}, // #1386
  {14,  6}, // #1387
  {15,  1}, // #1388
  {16,  5}, // #1389
  {18,  4}, // #1390
  {19,  3}, // #1391
  {20,  6}, // #1392
  {22, 12}, // #1393
  {23, 12}, // #1394
  {17,  1}, // #1395
  {21,  1}, // #1396
  {22,  2}, // #1397
  {23,  3}, // #1398
  { 9,  1}, // #1399
  {14,  1}, // #1400
  {16,  1}, // #1401
  {18,  1}, // #1402
  {20,  1}, // #1403
  {22,  3}, // #1404
  {23,  3}, // #1405
  { 7,  1}, // #1406
  {12,  1}, // #1407
  {17,  1}, // #1408
  {21,  2}, // #1409
  {22,  3}, // #1410
  {23,  6}, // #1411
  { 3,  1}, // #1412
  {11,  2}, // #1413
  {12,  1}, // #1414
  {13,  1}, // #1415
  {14,  1}, // #1416
  {17,  1}, // #1417
  {19,  2}, // #1418
  {20,  1}, // #1419
  {21,  1}, // #1420
  {22,  2}, // #1421
  {23,  3}, // #1422
  {14,  2}, // #1423
  {20,  2}, // #1424
  {22, 11}, // #1425
  {23, 11}, // #1426
  { 7,  1}, // #1427
  { 9,  1}, // #1428
  {12,  1}, // #1429
  {14,  1}, // #1430
  {16,  1}, // #1431
  {18,  1}, // #1432
  {20,  1}, // #1433
  {21,  1}, // #1434
  {22,  1}, // #1435
  {23,  3}, // #1436
  { 3,  1}, // #1437
  { 4,  1}, // #1438
  {11,  2}, // #1439
  {12,  1}, // #1440
  {13,  1}, // #1441
  {14,  1}, // #1442
  {15,  1}, // #1443
  {16,  1}, // #1444
  {19,  2}, // #1445
  {20,  1}, // #1446
  {22,  2}, // #1447
  {23,  2}, // #1448
  { 9,  1}, // #1449
  {14,  1}, // #1450
  {16,  1}, // #1451
  {18,  1}, // #1452
  {20,  1}, // #1453
  {22,  5}, // #1454
  {23,  5}, // #1455
  { 7,  1}, // #1456
  {12,  1}, // #1457
  {14,  4}, // #1458
  {15,  2}, // #1459
  {17,  1}, // #1460
  {19,  2}, // #1461
  {20,  4}, // #1462
  {21,  2}, // #1463
  {22, 11}, // #1464
  {23, 14}, // #1465
  { 9,  2}, // #1466
  {14,  4}, // #1467
  {15,  1}, // #1468
  {16,  2}, // #1469
  {18,  2}, // #1470
  {19,  1}, // #1471
  {20,  4}, // #1472
  {22,  7}, // #1473
  {23,  7}, // #1474
  { 9,  1}, // #1475
  {14,  1}, // #1476
  {16,  1}, // #1477
  {18,  1}, // #1478
  {20,  1}, // #1479
  {22,  6}, // #1480
  {23,  6}, // #1481
  { 3,  2}, // #1482
  { 7,  1}, // #1483
  { 8,  4}, // #1484
  {11,  2}, // #1485
  {12,  3}, // #1486
  {13,  6}, // #1487
  {14,  6}, // #1488
  {15,  4}, // #1489
  {17,  1}, // #1490
  {18,  4}, // #1491
  {19,  6}, // #1492
  {20, 10}, // #1493
  {21,  2}, // #1494
  {22, 16}, // #1495
  {23, 19}, // #1496
  { 8,  2}, // #1497
  {13,  2}, // #1498
  {15,  2}, // #1499
  {18,  2}, // #1500
  {19,  2}, // #1501
  {20,  2}, // #1502
  {22, 22}, // #1503
  {23, 22}, // #1504
  { 7,  1}, // #1505
  { 8,  1}, // #1506
  { 9,  1}, // #1507
  {12,  1}, // #1508
  {13,  1}, // #1509
  {14,  2}, // #1510
  {15,  1}, // #1511
  {16,  1}, // #1512
  {17,  1}, // #1513
  {18,  2}, // #1514
  {19,  1}, // #1515
  {20,  3}, // #1516
  {21,  2}, // #1517
  {22,  5}, // #1518
  {23,  8}, // #1519
  { 8,  6}, // #1520
  {11,  3}, // #1521
  {13,  6}, // #1522
  {15,  6}, // #1523
  {18,  6}, // #1524
  {19,  9}, // #1525
  {20,  6}, // #1526
  {22, 15}, // #1527
  {23, 15}, // #1528
  { 8,  1}, // #1529
  { 9,  5}, // #1530
  {13,  1}, // #1531
  {14,  9}, // #1532
  {15,  1}, // #1533
  {16,  5}, // #1534
  {17,  2}, // #1535
  {18,  6}, // #1536
  {19,  1}, // #1537
  {20, 10}, // #1538
  {21,  3}, // #1539
  {22, 20}, // #1540
  {23, 23}, // #1541
  { 8,  1}, // #1542
  { 9,  5}, // #1543
  {13,  1}, // #1544
  {14,  9}, // #1545
  {15,  1}, // #1546
  {16,  5}, // #1547
  {17,  3}, // #1548
  {18,  6}, // #1549
  {19,  1}, // #1550
  {20, 10}, // #1551
  {21,  3}, // #1552
  {22, 20}, // #1553
  {23, 23}, // #1554
  { 8,  1}, // #1555
  { 9,  1}, // #1556
  {13,  1}, // #1557
  {14,  2}, // #1558
  {15,  1}, // #1559
  {16,  1}, // #1560
  {18,  2}, // #1561
  {19,  1}, // #1562
  {20,  3}, // #1563
  {22,  8}, // #1564
  {23,  8}, // #1565
  { 3,  4}, // #1566
  { 9,  2}, // #1567
  {11,  4}, // #1568
  {12,  4}, // #1569
  {13,  5}, // #1570
  {14,  8}, // #1571
  {15,  1}, // #1572
  {16,  2}, // #1573
  {17, 33}, // #1574
  {18,  2}, // #1575
  {19,  6}, // #1576
  {20,  9}, // #1577
  {21, 33}, // #1578
  {22, 57}, // #1579
  {23, 90}, // #1580
  { 9,  1}, // #1581
  {14,  1}, // #1582
  {16,  1}, // #1583
  {17,  1}, // #1584
  {18,  1}, // #1585
  {20,  1}, // #1586
  {21,  1}, // #1587
  {22,  2}, // #1588
  {23,  3}, // #1589
  { 3,  1}, // #1590
  {11,  1}, // #1591
  {12,  1}, // #1592
  {13,  1}, // #1593
  {14,  1}, // #1594
  {19,  1}, // #1595
  {20,  1}, // #1596
  {22,  2}, // #1597
  {23,  2}, // #1598
  {11,  1}, // #1599
  {19,  2}, // #1600
  {22,  2}, // #1601
  {23,  2}, // #1602
  {14,  1}, // #1603
  {20,  1}, // #1604
  {22,  3}, // #1605
  {23,  3}, // #1606
  { 4,  2}, // #1607
  {11,  2}, // #1608
  {14,  3}, // #1609
  {15,  3}, // #1610
  {16,  2}, // #1611
  {19,  3}, // #1612
  {20,  3}, // #1613
  {22, 10}, // #1614
  {23, 10}, // #1615
  { 7,  1}, // #1616
  {12,  1}, // #1617
  {21,  1}, // #1618
  {22,  1}, // #1619
  {23,  3}, // #1620
  { 7,  1}, // #1621
  {12,  1}, // #1622
  {14,  1}, // #1623
  {20,  1}, // #1624
  {21,  1}, // #1625
  {22,  2}, // #1626
  {23,  4}, // #1627
  { 7,  1}, // #1628
  { 9,  1}, // #1629
  {12,  1}, // #1630
  {14,  1}, // #1631
  {16,  1}, // #1632
  {18,  1}, // #1633
  {20,  1}, // #1634
  {21,  1}, // #1635
  {22,  2}, // #1636
  {23,  4}, // #1637
  { 7,  1}, // #1638
  {12,  1}, // #1639
  {21,  1}, // #1640
  {22,  4}, // #1641
  {23,  6}, // #1642
  { 9,  1}, // #1643
  {14,  1}, // #1644
  {16,  1}, // #1645
  {18,  1}, // #1646
  {20,  1}, // #1647
  {22,  2}, // #1648
  {23,  2}, // #1649
  { 9,  1}, // #1650
  {14,  1}, // #1651
  {16,  1}, // #1652
  {17,  1}, // #1653
  {18,  1}, // #1654
  {20,  1}, // #1655
  {21,  1}, // #1656
  {22,  1}, // #1657
  {23,  2}, // #1658
  { 3,  1}, // #1659
  { 7,  1}, // #1660
  {11,  1}, // #1661
  {12,  2}, // #1662
  {13,  1}, // #1663
  {14,  1}, // #1664
  {19,  1}, // #1665
  {20,  1}, // #1666
  {21,  1}, // #1667
  {22,  1}, // #1668
  {23,  3}, // #1669
  { 4,  1}, // #1670
  { 9,  1}, // #1671
  {11,  1}, // #1672
  {14,  2}, // #1673
  {15,  1}, // #1674
  {16,  2}, // #1675
  {18,  1}, // #1676
  {19,  1}, // #1677
  {20,  2}, // #1678
  {22,  4}, // #1679
  {23,  4}, // #1680
  { 7,  1}, // #1681
  { 9,  1}, // #1682
  {12,  1}, // #1683
  {14,  1}, // #1684
  {16,  1}, // #1685
  {17,  1}, // #1686
  {18,  1}, // #1687
  {20,  1}, // #1688
  {21,  2}, // #1689
  {22,  2}, // #1690
  {23,  5}, // #1691
  { 7,  1}, // #1692
  {12,  1}, // #1693
  {17,  1}, // #1694
  {21,  2}, // #1695
  {22,  2}, // #1696
  {23,  5}, // #1697
  { 3,  1}, // #1698
  { 4,  1}, // #1699
  {11,  2}, // #1700
  {12,  1}, // #1701
  {13,  1}, // #1702
  {14,  1}, // #1703
  {15,  1}, // #1704
  {16,  1}, // #1705
  {17,  1}, // #1706
  {19,  2}, // #1707
  {20,  1}, // #1708
  {21,  1}, // #1709
  {22,  2}, // #1710
  {23,  3}, // #1711
  { 8,  1}, // #1712
  { 9,  1}, // #1713
  {13,  1}, // #1714
  {14,  1}, // #1715
  {15,  1}, // #1716
  {16,  1}, // #1717
  {18,  2}, // #1718
  {19,  1}, // #1719
  {20,  2}, // #1720
  {22,  2}, // #1721
  {23,  2}, // #1722
  {14,  1}, // #1723
  {17,  1}, // #1724
  {20,  1}, // #1725
  {21,  1}, // #1726
  {22,  4}, // #1727
  {23,  5}, // #1728
  { 9,  1}, // #1729
  {14,  1}, // #1730
  {16,  1}, // #1731
  {18,  1}, // #1732
  {20,  1}, // #1733
  {22,  1}, // #1734
  {23,  1}, // #1735
  { 7,  1}, // #1736
  {12,  1}, // #1737
  {15,  1}, // #1738
  {19,  1}, // #1739
  {21,  1}, // #1740
  {22,  1}, // #1741
  {23,  3}, // #1742
  { 8,  2}, // #1743
  {13,  2}, // #1744
  {15,  2}, // #1745
  {18,  2}, // #1746
  {19,  2}, // #1747
  {20,  2}, // #1748
  {22,  3}, // #1749
  {23,  3}, // #1750
  { 8,  1}, // #1751
  {13,  1}, // #1752
  {15,  1}, // #1753
  {17,  1}, // #1754
  {18,  1}, // #1755
  {19,  2}, // #1756
  {20,  1}, // #1757
  {21,  1}, // #1758
  {22,  2}, // #1759
  {23,  3}, // #1760
  { 4,  2}, // #1761
  { 9,  2}, // #1762
  {11,  2}, // #1763
  {14,  2}, // #1764
  {15,  2}, // #1765
  {16,  4}, // #1766
  {17,  1}, // #1767
  {18,  2}, // #1768
  {19,  2}, // #1769
  {20,  2}, // #1770
  {21,  1}, // #1771
  {22,  7}, // #1772
  {23,  8}, // #1773
  { 4,  1}, // #1774
  { 9,  2}, // #1775
  {11,  1}, // #1776
  {14,  2}, // #1777
  {15,  1}, // #1778
  {16,  3}, // #1779
  {17,  1}, // #1780
  {18,  2}, // #1781
  {19,  1}, // #1782
  {20,  2}, // #1783
  {21,  1}, // #1784
  {22,  4}, // #1785
  {23,  5}, // #1786
  { 4,  1}, // #1787
  { 9,  1}, // #1788
  {11,  1}, // #1789
  {14,  2}, // #1790
  {15,  1}, // #1791
  {16,  2}, // #1792
  {18,  1}, // #1793
  {19,  1}, // #1794
  {20,  2}, // #1795
  {22,  3}, // #1796
  {23,  3}, // #1797
  {14,  1}, // #1798
  {20,  1}, // #1799
  {22,  5}, // #1800
  {23,  5}, // #1801
  { 4,  1}, // #1802
  {11,  1}, // #1803
  {14,  4}, // #1804
  {15,  2}, // #1805
  {16,  1}, // #1806
  {17,  1}, // #1807
  {19,  2}, // #1808
  {20,  4}, // #1809
  {21,  2}, // #1810
  {22,  8}, // #1811
  {23, 10}, // #1812
  { 4,  2}, // #1813
  {11,  2}, // #1814
  {14,  2}, // #1815
  {15,  2}, // #1816
  {16,  2}, // #1817
  {19,  2}, // #1818
  {20,  2}, // #1819
  {22,  7}, // #1820
  {23,  7}, // #1821
  { 4,  1}, // #1822
  {11,  1}, // #1823
  {14,  4}, // #1824
  {15,  2}, // #1825
  {16,  1}, // #1826
  {19,  2}, // #1827
  {20,  4}, // #1828
  {22,  9}, // #1829
  {23,  9}, // #1830
  { 9,  3}, // #1831
  {14,  3}, // #1832
  {16,  3}, // #1833
  {17,  1}, // #1834
  {18,  3}, // #1835
  {20,  3}, // #1836
  {21,  1}, // #1837
  {22, 18}, // #1838
  {23, 19}, // #1839
  { 7,  1}, // #1840
  { 9,  5}, // #1841
  {12,  1}, // #1842
  {14,  5}, // #1843
  {16,  5}, // #1844
  {17,  1}, // #1845
  {18,  5}, // #1846
  {20,  5}, // #1847
  {21,  2}, // #1848
  {22, 24}, // #1849
  {23, 27}, // #1850
  { 7,  1}, // #1851
  { 9,  6}, // #1852
  {12,  1}, // #1853
  {14,  6}, // #1854
  {16,  6}, // #1855
  {17,  1}, // #1856
  {18,  6}, // #1857
  {20,  6}, // #1858
  {21,  2}, // #1859
  {22, 25}, // #1860
  {23, 28}, // #1861
  { 3,  2}, // #1862
  {11,  4}, // #1863
  {12,  2}, // #1864
  {13,  3}, // #1865
  {14, 12}, // #1866
  {17,  8}, // #1867
  {19,  7}, // #1868
  {20, 13}, // #1869
  {21,  8}, // #1870
  {22, 56}, // #1871
  {23, 64}, // #1872
  { 3,  4}, // #1873
  { 9,  4}, // #1874
  {11,  4}, // #1875
  {12,  4}, // #1876
  {13,  5}, // #1877
  {14, 10}, // #1878
  {15,  1}, // #1879
  {16,  4}, // #1880
  {17, 31}, // #1881
  {18,  4}, // #1882
  {19,  6}, // #1883
  {20, 11}, // #1884
  {21, 31}, // #1885
  {22, 57}, // #1886
  {23, 88}, // #1887
  { 3,  9}, // #1888
  { 4,  9}, // #1889
  { 7, 11}, // #1890
  { 8,  8}, // #1891
  { 9,  1}, // #1892
  {11, 18}, // #1893
  {12, 20}, // #1894
  {13, 17}, // #1895
  {14, 31}, // #1896
  {15, 17}, // #1897
  {16, 10}, // #1898
  {18,  9}, // #1899
  {19, 26}, // #1900
  {20, 39}, // #1901
  {21, 11}, // #1902
  {22, 78}, // #1903
  {23, 100}, // #1904
  { 7,  1}, // #1905
  { 8,  5}, // #1906
  {12,  1}, // #1907
  {13,  5}, // #1908
  {15,  5}, // #1909
  {17,  2}, // #1910
  {18,  5}, // #1911
  {19,  5}, // #1912
  {20,  5}, // #1913
  {21,  2}, // #1914
  {22,  6}, // #1915
  {23,  9}, // #1916
  { 9,  1}, // #1917
  {14,  1}, // #1918
  {16,  1}, // #1919
  {17,  1}, // #1920
  {18,  1}, // #1921
  {20,  1}, // #1922
  {21,  1}, // #1923
  {22, 17}, // #1924
  {23, 18}, // #1925
  { 7,  1}, // #1926
  { 8,  3}, // #1927
  {12,  1}, // #1928
  {13,  3}, // #1929
  {15,  3}, // #1930
  {17,  2}, // #1931
  {18,  3}, // #1932
  {19,  3}, // #1933
  {20,  3}, // #1934
  {21,  2}, // #1935
  {22,  4}, // #1936
  {23,  7}, // #1937
  { 7,  1}, // #1938
  { 8,  3}, // #1939
  {12,  1}, // #1940
  {13,  3}, // #1941
  {15,  3}, // #1942
  {17,  4}, // #1943
  {18,  3}, // #1944
  {19,  3}, // #1945
  {20,  3}, // #1946
  {21,  4}, // #1947
  {22,  4}, // #1948
  {23,  9}, // #1949
  { 7,  1}, // #1950
  { 8,  4}, // #1951
  {12,  1}, // #1952
  {13,  4}, // #1953
  {15,  4}, // #1954
  {17,  8}, // #1955
  {18,  4}, // #1956
  {19,  4}, // #1957
  {20,  4}, // #1958
  {21,  8}, // #1959
  {22,  5}, // #1960
  {23, 14}, // #1961
  { 9,  1}, // #1962
  {16,  1}, // #1963
  { 3,  1}, // #1964
  {11,  1}, // #1965
  {12,  2}, // #1966
  {14,  1}, // #1967
  { 8,  1}, // #1968
  { 9,  1}, // #1969
  {12,  1}, // #1970
  {14,  1}, // #1971
  {15,  1}, // #1972
  { 9,  1}, // #1973
  {10,  1}, // #1974
  {11,  1}, // #1975
  {12,  1}, // #1976
  { 6,  1}, // #1977
  { 8,  1}, // #1978
  { 9,  1}, // #1979
  {10,  1}, // #1980
  { 3,  2}, // #1981
  {11,  1}, // #1982
  {12,  2}, // #1983
  {14,  1}, // #1984
  { 3,  2}, // #1985
  {11,  1}, // #1986
  {12,  1}, // #1987
  { 5,  1}, // #1988
  { 7,  1}, // #1989
  { 9,  1}, // #1990
  {10,  1}, // #1991
  {11,  1}, // #1992
  {12,  1}, // #1993
  { 7,  1}, // #1994
  { 9,  2}, // #1995
  {11,  1}, // #1996
  {12,  1}, // #1997
  {16,  1}, // #1998
  {19,  1}, // #1999
  { 7,  1}, // #2000
  { 9,  2}, // #2001
  {16,  1}, // #2002
  {19,  1}, // #2003
  { 7,  1}, // #2004
  { 9,  1}, // #2005
  {11,  1}, // #2006
  {12,  1}, // #2007
  {19,  1}, // #2008
  { 7,  1}, // #2009
  { 9,  1}, // #2010
  {19,  1}, // #2011
  { 9,  4}, // #2012
  {10,  4}, // #2013
  {11,  1}, // #2014
  {12,  1}, // #2015
  { 3,  8}, // #2016
  {11,  1}, // #2017
  {12,  1}, // #2018
  { 1,  1}, // #2019
  { 3,  1}, // #2020
  { 5,  1}, // #2021
  { 7,  1}, // #2022
  { 9,  1}, // #2023
  {10,  1}, // #2024
  {11,  1}, // #2025
  {12,  1}, // #2026
  { 3,  4}, // #2027
  {11,  1}, // #2028
  {12,  1}, // #2029
  { 8,  1}, // #2030
  { 9,  1}, // #2031
  {11,  1}, // #2032
  {12,  1}, // #2033
  {15,  1}, // #2034
  { 8,  1}, // #2035
  { 9,  1}, // #2036
  {15,  1}, // #2037
  { 1,  1}, // #2038
  { 3,  1}, // #2039
  { 5,  1}, // #2040
  { 7,  1}, // #2041
  { 8,  1}, // #2042
  { 9,  2}, // #2043
  {10,  1}, // #2044
  {11,  1}, // #2045
  {12,  1}, // #2046
  {15,  1}, // #2047
  { 1,  1}, // #2048
  { 3,  1}, // #2049
  { 5,  1}, // #2050
  { 7,  1}, // #2051
  { 8,  1}, // #2052
  { 9,  2}, // #2053
  {10,  1}, // #2054
  {15,  1}, // #2055
  { 8,  1}, // #2056
  { 9,  1}, // #2057
  {11,  1}, // #2058
  {12,  1}, // #2059
  {15,  2}, // #2060
  { 8,  1}, // #2061
  { 9,  1}, // #2062
  {15,  2}, // #2063
  { 2,  1}, // #2064
  { 3,  1}, // #2065
  { 4, 17}, // #2066
  {11,  1}, // #2067
  {12,  1}, // #2068
  { 2,  1}, // #2069
  { 3,  1}, // #2070
  { 4, 25}, // #2071
  {11,  1}, // #2072
  {12,  1}, // #2073
  { 2,  1}, // #2074
  { 3,  1}, // #2075
  { 4, 41}, // #2076
  {11,  1}, // #2077
  {12,  1}, // #2078
  { 2,  1}, // #2079
  { 3,  1}, // #2080
  { 4, 12}, // #2081
  {11,  1}, // #2082
  {12,  1}, // #2083
  { 6, 19}, // #2084
  { 8,  1}, // #2085
  { 9,  1}, // #2086
  {10, 19}, // #2087
  {11,  1}, // #2088
  {12,  1}, // #2089
  { 5,  3}, // #2090
  { 6,  3}, // #2091
  { 8,  1}, // #2092
  { 9,  1}, // #2093
  {10,  6}, // #2094
  {11,  1}, // #2095
  {12,  1}, // #2096
  { 9,  1}, // #2097
  {11,  1}, // #2098
  {12,  1}, // #2099
  {16,  1}, // #2100
  { 2,  1}, // #2101
  { 3,  1}, // #2102
  {11,  1}, // #2103
  {12,  1}, // #2104
  {13,  1}, // #2105
  { 2,  1}, // #2106
  { 3,  1}, // #2107
  {13,  1}, // #2108
  { 2,  1}, // #2109
  { 3,  1}, // #2110
  {11,  1}, // #2111
  {12,  1}, // #2112
  {13,  4}, // #2113
  { 2,  1}, // #2114
  { 3,  1}, // #2115
  {13,  4}, // #2116
  { 7,  1}, // #2117
  { 9,  1}, // #2118
  {11,  1}, // #2119
  {12,  1}, // #2120
  {19,  2}, // #2121
  { 7,  1}, // #2122
  { 9,  1}, // #2123
  {19,  2}, // #2124
  { 6,  2}, // #2125
  { 8,  1}, // #2126
  { 9,  1}, // #2127
  {10,  2}, // #2128
  {11,  1}, // #2129
  {12,  1}, // #2130
  { 6,  1}, // #2131
  { 8,  1}, // #2132
  { 9,  1}, // #2133
  {10,  1}, // #2134
  {11,  1}, // #2135
  {12,  1}, // #2136
  { 2,  5}, // #2137
  { 3,  5}, // #2138
  {11,  1}, // #2139
  {12,  1}, // #2140
  {13,  1}, // #2141
  { 2,  5}, // #2142
  { 3,  5}, // #2143
  {13,  1}, // #2144
  { 2,  5}, // #2145
  { 3,  5}, // #2146
  {11,  1}, // #2147
  {12,  1}, // #2148
  {13,  4}, // #2149
  { 2,  5}, // #2150
  { 3,  5}, // #2151
  {13,  4}, // #2152
  { 9,  4}, // #2153
  {11,  1}, // #2154
  {12,  1}, // #2155
  {16,  4}, // #2156
  { 9,  4}, // #2157
  {16,  4}, // #2158
  { 1,  1}, // #2159
  { 3,  1}, // #2160
  { 5,  1}, // #2161
  { 8,  1}, // #2162
  { 9,  1}, // #2163
  {10,  1}, // #2164
  {11,  3}, // #2165
  {12,  5}, // #2166
  {14,  2}, // #2167
  {16, 10}, // #2168
  {18,  4}, // #2169
  { 1,  1}, // #2170
  { 3,  1}, // #2171
  { 5,  1}, // #2172
  { 8,  1}, // #2173
  { 9,  1}, // #2174
  {10,  1}, // #2175
  {11,  2}, // #2176
  {12,  4}, // #2177
  {14,  2}, // #2178
  {16, 10}, // #2179
  {18,  4}, // #2180
  { 1,  1}, // #2181
  { 3,  1}, // #2182
  { 5,  1}, // #2183
  { 7,  1}, // #2184
  { 8,  2}, // #2185
  { 9,  3}, // #2186
  {10,  1}, // #2187
  {11,  1}, // #2188
  {12,  1}, // #2189
  {16,  2}, // #2190
  {18,  2}, // #2191
  { 1,  1}, // #2192
  { 3,  1}, // #2193
  { 5,  1}, // #2194
  { 7,  1}, // #2195
  { 8,  2}, // #2196
  { 9,  3}, // #2197
  {10,  1}, // #2198
  {16,  2}, // #2199
  {18,  2}, // #2200
  { 7,  2}, // #2201
  { 9,  3}, // #2202
  {11,  1}, // #2203
  {12,  1}, // #2204
  {16,  1}, // #2205
  {19,  2}, // #2206
  { 7,  2}, // #2207
  { 9,  3}, // #2208
  {16,  1}, // #2209
  {19,  2}, // #2210
  { 9,  1}, // #2211
  {11,  1}, // #2212
  {12,  1}, // #2213
  {16,  4}, // #2214
  { 9,  1}, // #2215
  {16,  4}, // #2216
  { 3,  1}, // #2217
  {12,  1}, // #2218
  {14,  1}, // #2219
  { 3, 22}, // #2220
  {11,  1}, // #2221
  {12,  1}, // #2222
  { 6, 27}, // #2223
  { 8,  1}, // #2224
  { 9,  1}, // #2225
  {10, 27}, // #2226
  {11,  1}, // #2227
  {12,  1}, // #2228
  { 6, 21}, // #2229
  { 8,  1}, // #2230
  { 9,  1}, // #2231
  {10, 21}, // #2232
  {11,  1}, // #2233
  {12,  1}, // #2234
  { 6, 35}, // #2235
  { 8,  1}, // #2236
  { 9,  1}, // #2237
  {10, 35}, // #2238
  { 5,  2}, // #2239
  { 7,  2}, // #2240
  { 9,  2}, // #2241
  {10,  2}, // #2242
  {11,  2}, // #2243
  {12,  2}, // #2244
  { 9,  6}, // #2245
  {10,  6}, // #2246
  {11,  2}, // #2247
  {12,  2}, // #2248
  { 9,  2}, // #2249
  {10,  2}, // #2250
  {11,  1}, // #2251
  {12,  1}, // #2252
  { 8,  2}, // #2253
  { 9,  2}, // #2254
  {11,  2}, // #2255
  {12,  2}, // #2256
  {15,  2}, // #2257
  { 8,  2}, // #2258
  { 9,  2}, // #2259
  {15,  2}, // #2260
  { 8,  2}, // #2261
  { 9,  2}, // #2262
  {10,  4}, // #2263
  {11,  2}, // #2264
  {12,  2}, // #2265
  {15,  2}, // #2266
  { 8,  2}, // #2267
  { 9,  2}, // #2268
  {10,  4}, // #2269
  {15,  2}, // #2270
  { 8,  2}, // #2271
  { 9,  2}, // #2272
  {10,  2}, // #2273
  {12,  1}, // #2274
  {14,  1}, // #2275
  {15,  2}, // #2276
  { 8,  2}, // #2277
  { 9,  2}, // #2278
  {10,  2}, // #2279
  {15,  2}, // #2280
  { 6, 38}, // #2281
  { 8,  2}, // #2282
  { 9,  2}, // #2283
  {10, 38}, // #2284
  {11,  2}, // #2285
  {12,  2}, // #2286
  { 5,  6}, // #2287
  { 6,  6}, // #2288
  { 8,  2}, // #2289
  { 9,  2}, // #2290
  {10, 12}, // #2291
  {11,  2}, // #2292
  {12,  2}, // #2293
  { 9,  2}, // #2294
  {10,  4}, // #2295
  {12,  2}, // #2296
  {14,  2}, // #2297
  { 9,  4}, // #2298
  {10,  4}, // #2299
  {11,  2}, // #2300
  {12,  2}, // #2301
  { 9,  1}, // #2302
  {10,  4}, // #2303
  {12,  1}, // #2304
  {14,  1}, // #2305
  { 9,  2}, // #2306
  {16,  2}, // #2307
  { 8,  2}, // #2308
  { 9,  2}, // #2309
  {12,  2}, // #2310
  {14,  2}, // #2311
  {15,  2}, // #2312
  { 6,  4}, // #2313
  { 8,  2}, // #2314
  { 9,  2}, // #2315
  {10,  4}, // #2316
  {11,  2}, // #2317
  {12,  2}, // #2318
  { 6,  2}, // #2319
  { 8,  2}, // #2320
  { 9,  2}, // #2321
  {10,  2}, // #2322
  {11,  2}, // #2323
  {12,  2}, // #2324
  { 9,  2}, // #2325
  {10,  6}, // #2326
  {11,  2}, // #2327
  {12,  2}, // #2328
  { 9,  1}, // #2329
  {10,  4}, // #2330
  {11,  1}, // #2331
  {12,  1}, // #2332
  { 9,  2}, // #2333
  {12,  2}, // #2334
  {14,  2}, // #2335
  {16,  4}, // #2336
  { 9,  4}, // #2337
  {11,  2}, // #2338
  {12,  2}, // #2339
  {16,  4}, // #2340
  { 9,  1}, // #2341
  {12,  1}, // #2342
  {14,  1}, // #2343
  {16,  4}, // #2344
  { 9,  2}, // #2345
  {11,  1}, // #2346
  {12,  1}, // #2347
  {16,  2}, // #2348
  { 1,  1}, // #2349
  { 3,  1}, // #2350
  { 5,  2}, // #2351
  { 9,  2}, // #2352
  {10,  4}, // #2353
  {11,  2}, // #2354
  {12,  2}, // #2355
  { 6, 54}, // #2356
  { 8,  2}, // #2357
  { 9,  2}, // #2358
  {10, 54}, // #2359
  {11,  2}, // #2360
  {12,  2}, // #2361
  { 6, 42}, // #2362
  { 8,  2}, // #2363
  { 9,  2}, // #2364
  {10, 42}, // #2365
  {11,  2}, // #2366
  {12,  2}, // #2367
  { 9,  2}, // #2368
  {10,  4}, // #2369
  {11,  1}, // #2370
  {12,  1}, // #2371
  { 2,  1}, // #2372
  { 3,  1}, // #2373
  {12,  1}, // #2374
  {14,  1}, // #2375
  {13,  1}, // #2376
  {19,  1}, // #2377
  {20,  1}, // #2378
  {22,  1}, // #2379
  {23,  1}, // #2380
  { 3,  3}, // #2381
  { 8,  6}, // #2382
  {11,  3}, // #2383
  {12,  3}, // #2384
  {13,  9}, // #2385
  {14,  3}, // #2386
  {15,  6}, // #2387
  {17,  1}, // #2388
  {18,  6}, // #2389
  {19, 10}, // #2390
  {20,  9}, // #2391
  {21,  1}, // #2392
  {22, 10}, // #2393
  {23, 11}, // #2394
  { 3,  3}, // #2395
  { 8,  6}, // #2396
  {11,  3}, // #2397
  {12,  3}, // #2398
  {13,  9}, // #2399
  {14,  3}, // #2400
  {15,  6}, // #2401
  {18,  6}, // #2402
  {19, 11}, // #2403
  {20,  9}, // #2404
  {22, 11}, // #2405
  {23, 11}, // #2406
  {14,  2}, // #2407
  {17,  1}, // #2408
  {20,  2}, // #2409
  {21,  1}, // #2410
  {22,  2}, // #2411
  {23,  3}, // #2412
  {11,  2}, // #2413
  {17,  1}, // #2414
  {19,  2}, // #2415
  {21,  1}, // #2416
  {22,  2}, // #2417
  {23,  3}, // #2418
  { 1, 10}, // #2419
  { 3,  1}, // #2420
  {11,  1}, // #2421
  {12,  1}, // #2422
  {13,  1}, // #2423
  {14,  1}, // #2424
  {17,  1}, // #2425
  {19,  1}, // #2426
  {20,  1}, // #2427
  {21,  1}, // #2428
  {22,  1}, // #2429
  {23,  2}, // #2430
  { 3,  7}, // #2431
  { 4,  2}, // #2432
  { 8,  8}, // #2433
  { 9,  3}, // #2434
  {11,  9}, // #2435
  {12,  7}, // #2436
  {13, 16}, // #2437
  {14, 10}, // #2438
  {15, 10}, // #2439
  {16,  5}, // #2440
  {18, 11}, // #2441
  {19, 18}, // #2442
  {20, 19}, // #2443
  {22, 32}, // #2444
  {23, 32}, // #2445
  { 2,  4}, // #2446
  { 3,  1}, // #2447
  {11,  1}, // #2448
  {12,  1}, // #2449
  {13,  1}, // #2450
  {14,  1}, // #2451
  {17,  1}, // #2452
  {19,  1}, // #2453
  {20,  1}, // #2454
  {21,  1}, // #2455
  {22,  1}, // #2456
  {23,  2}, // #2457
  { 2,  3}, // #2458
  { 3,  1}, // #2459
  {11,  1}, // #2460
  {12,  1}, // #2461
  {13,  1}, // #2462
  {14,  1}, // #2463
  {17,  1}, // #2464
  {19,  1}, // #2465
  {20,  1}, // #2466
  {21,  1}, // #2467
  {22,  1}, // #2468
  {23,  2}, // #2469
  { 8,  1}, // #2470
  {13,  1}, // #2471
  {15,  1}, // #2472
  {17,  1}, // #2473
  {18,  1}, // #2474
  {19,  3}, // #2475
  {20,  1}, // #2476
  {21,  1}, // #2477
  {22,  3}, // #2478
  {23,  4}, // #2479
  { 8,  1}, // #2480
  {13,  1}, // #2481
  {15,  1}, // #2482
  {18,  1}, // #2483
  {19,  3}, // #2484
  {20,  1}, // #2485
  {22,  3}, // #2486
  {23,  3}, // #2487
  { 8,  1}, // #2488
  {13,  1}, // #2489
  {15,  1}, // #2490
  {17,  1}, // #2491
  {18,  1}, // #2492
  {19,  4}, // #2493
  {20,  1}, // #2494
  {21,  1}, // #2495
  {22,  4}, // #2496
  {23,  5}, // #2497
  { 8,  1}, // #2498
  {13,  1}, // #2499
  {15,  1}, // #2500
  {18,  1}, // #2501
  {19,  4}, // #2502
  {20,  1}, // #2503
  {22,  4}, // #2504
  {23,  4}, // #2505
  {13,  9}, // #2506
  {19,  9}, // #2507
  {20,  9}, // #2508
  {22, 10}, // #2509
  {23, 10}, // #2510
  {13,  2}, // #2511
  {19,  2}, // #2512
  {20,  2}, // #2513
  {22,  2}, // #2514
  {23,  2}, // #2515
  { 8,  2}, // #2516
  {13,  2}, // #2517
  {15,  2}, // #2518
  {17,  1}, // #2519
  {18,  2}, // #2520
  {19,  3}, // #2521
  {20,  2}, // #2522
  {21,  1}, // #2523
  {22,  3}, // #2524
  {23,  4}, // #2525
  { 8,  2}, // #2526
  {13,  2}, // #2527
  {15,  2}, // #2528
  {18,  2}, // #2529
  {19,  3}, // #2530
  {20,  2}, // #2531
  {22,  3}, // #2532
  {23,  3}, // #2533
  { 3,  2}, // #2534
  { 8,  4}, // #2535
  {11,  2}, // #2536
  {12,  2}, // #2537
  {13,  6}, // #2538
  {14,  2}, // #2539
  {15,  4}, // #2540
  {17,  1}, // #2541
  {18,  4}, // #2542
  {19,  6}, // #2543
  {20,  6}, // #2544
  {21,  1}, // #2545
  {22,  7}, // #2546
  {23,  8}, // #2547
  { 3,  4}, // #2548
  { 4,  2}, // #2549
  { 8,  4}, // #2550
  { 9,  8}, // #2551
  {11,  6}, // #2552
  {12,  4}, // #2553
  {13,  8}, // #2554
  {14, 26}, // #2555
  {15,  6}, // #2556
  {16, 10}, // #2557
  {18, 12}, // #2558
  {19, 10}, // #2559
  {20, 30}, // #2560
  {22, 66}, // #2561
  {23, 66}, // #2562
  {13,  1}, // #2563
  {17,  1}, // #2564
  {19,  1}, // #2565
  {20,  1}, // #2566
  {21,  1}, // #2567
  {22,  1}, // #2568
  {23,  2}, // #2569
  { 8,  2}, // #2570
  {13,  3}, // #2571
  {15,  2}, // #2572
  {17,  1}, // #2573
  {18,  2}, // #2574
  {19,  3}, // #2575
  {20,  3}, // #2576
  {21,  1}, // #2577
  {22,  3}, // #2578
  {23,  4}, // #2579
  { 8,  2}, // #2580
  {13,  3}, // #2581
  {15,  2}, // #2582
  {18,  2}, // #2583
  {19,  3}, // #2584
  {20,  3}, // #2585
  {22,  3}, // #2586
  {23,  3}, // #2587
  { 8,  1}, // #2588
  {11,  1}, // #2589
  {13,  1}, // #2590
  {15,  1}, // #2591
  {18,  1}, // #2592
  {19,  2}, // #2593
  {20,  1}, // #2594
  {22,  2}, // #2595
  {23,  2}, // #2596
  { 7,  1}, // #2597
  {12,  1}, // #2598
  {14,  3}, // #2599
  {17,  1}, // #2600
  {20,  3}, // #2601
  {21,  2}, // #2602
  {22,  3}, // #2603
  {23,  6}, // #2604
  {14,  3}, // #2605
  {20,  3}, // #2606
  {22,  3}, // #2607
  {23,  3}, // #2608
  { 4,  1}, // #2609
  {11,  1}, // #2610
  {14,  2}, // #2611
  {15,  1}, // #2612
  {16,  1}, // #2613
  {17,  1}, // #2614
  {19,  1}, // #2615
  {20,  2}, // #2616
  {21,  2}, // #2617
  {22,  4}, // #2618
  {23,  6}, // #2619
  { 4,  1}, // #2620
  {11,  1}, // #2621
  {14,  2}, // #2622
  {15,  1}, // #2623
  {16,  1}, // #2624
  {19,  1}, // #2625
  {20,  2}, // #2626
  {22,  4}, // #2627
  {23,  4}, // #2628
  { 2,  6}, // #2629
  { 3,  1}, // #2630
  {11,  1}, // #2631
  {12,  1}, // #2632
  {13,  1}, // #2633
  {14,  1}, // #2634
  {17,  1}, // #2635
  {19,  1}, // #2636
  {20,  1}, // #2637
  {21,  1}, // #2638
  {22,  1}, // #2639
  {23,  2}, // #2640
  { 2,  6}, // #2641
  { 3,  1}, // #2642
  {11,  1}, // #2643
  {12,  1}, // #2644
  {13,  1}, // #2645
  {14,  1}, // #2646
  {19,  1}, // #2647
  {20,  1}, // #2648
  {22,  1}, // #2649
  {23,  1}, // #2650
  { 8,  1}, // #2651
  {11,  1}, // #2652
  {13,  1}, // #2653
  {15,  1}, // #2654
  {17,  1}, // #2655
  {18,  1}, // #2656
  {19,  2}, // #2657
  {20,  1}, // #2658
  {21,  1}, // #2659
  {22,  2}, // #2660
  {23,  3}, // #2661
  {13,  2}, // #2662
  {17,  1}, // #2663
  {19,  2}, // #2664
  {20,  2}, // #2665
  {21,  1}, // #2666
  {22,  2}, // #2667
  {23,  3}, // #2668
  { 7,  1}, // #2669
  { 8,  1}, // #2670
  {11,  1}, // #2671
  {12,  1}, // #2672
  {13,  1}, // #2673
  {15,  1}, // #2674
  {18,  1}, // #2675
  {19,  2}, // #2676
  {20,  1}, // #2677
  {21,  1}, // #2678
  {22,  2}, // #2679
  {23,  4}, // #2680
  { 7,  1}, // #2681
  { 8,  1}, // #2682
  {12,  1}, // #2683
  {13,  2}, // #2684
  {15,  1}, // #2685
  {18,  1}, // #2686
  {19,  2}, // #2687
  {20,  2}, // #2688
  {21,  1}, // #2689
  {22,  2}, // #2690
  {23,  4}, // #2691
  { 8,  1}, // #2692
  {13,  2}, // #2693
  {15,  1}, // #2694
  {18,  1}, // #2695
  {19,  2}, // #2696
  {20,  2}, // #2697
  {22,  2}, // #2698
  {23,  2}, // #2699
  { 2, 16}, // #2700
  { 3,  2}, // #2701
  { 8,  1}, // #2702
  {11,  2}, // #2703
  {12,  2}, // #2704
  {13,  3}, // #2705
  {14,  2}, // #2706
  {15,  1}, // #2707
  {17,  1}, // #2708
  {18,  1}, // #2709
  {19,  3}, // #2710
  {20,  3}, // #2711
  {21,  1}, // #2712
  {22,  3}, // #2713
  {23,  4}, // #2714
  { 2, 16}, // #2715
  { 3,  2}, // #2716
  { 8,  1}, // #2717
  {11,  2}, // #2718
  {12,  2}, // #2719
  {13,  3}, // #2720
  {14,  2}, // #2721
  {15,  1}, // #2722
  {18,  1}, // #2723
  {19,  3}, // #2724
  {20,  3}, // #2725
  {22,  3}, // #2726
  {23,  3}, // #2727
  { 2, 10}, // #2728
  { 3,  2}, // #2729
  { 8,  1}, // #2730
  {11,  2}, // #2731
  {12,  2}, // #2732
  {13,  3}, // #2733
  {14,  2}, // #2734
  {15,  1}, // #2735
  {17,  1}, // #2736
  {18,  1}, // #2737
  {19,  3}, // #2738
  {20,  3}, // #2739
  {21,  1}, // #2740
  {22,  3}, // #2741
  {23,  4}, // #2742
  { 2, 10}, // #2743
  { 3,  2}, // #2744
  { 8,  1}, // #2745
  {11,  2}, // #2746
  {12,  2}, // #2747
  {13,  3}, // #2748
  {14,  2}, // #2749
  {15,  1}, // #2750
  {18,  1}, // #2751
  {19,  3}, // #2752
  {20,  3}, // #2753
  {22,  3}, // #2754
  {23,  3}, // #2755
  { 3,  1}, // #2756
  {11,  1}, // #2757
  {12,  1}, // #2758
  {13,  1}, // #2759
  {14,  1}, // #2760
  {19,  1}, // #2761
  {20,  1}, // #2762
  {21,  1}, // #2763
  {22,  1}, // #2764
  {23,  2}, // #2765
  { 2, 12}, // #2766
  { 3,  1}, // #2767
  {11,  1}, // #2768
  {12,  1}, // #2769
  {13,  1}, // #2770
  {14,  1}, // #2771
  {17,  1}, // #2772
  {19,  1}, // #2773
  {20,  1}, // #2774
  {21,  1}, // #2775
  {22,  1}, // #2776
  {23,  2}, // #2777
  { 2, 12}, // #2778
  { 3,  1}, // #2779
  {11,  1}, // #2780
  {12,  1}, // #2781
  {13,  1}, // #2782
  {14,  1}, // #2783
  {19,  1}, // #2784
  {20,  1}, // #2785
  {22,  1}, // #2786
  {23,  1}, // #2787
  { 2, 24}, // #2788
  { 3,  2}, // #2789
  { 8,  1}, // #2790
  {11,  2}, // #2791
  {12,  2}, // #2792
  {13,  3}, // #2793
  {14,  2}, // #2794
  {15,  1}, // #2795
  {17,  1}, // #2796
  {18,  1}, // #2797
  {19,  3}, // #2798
  {20,  3}, // #2799
  {21,  1}, // #2800
  {22,  3}, // #2801
  {23,  4}, // #2802
  { 2, 24}, // #2803
  { 3,  2}, // #2804
  { 8,  1}, // #2805
  {11,  2}, // #2806
  {12,  2}, // #2807
  {13,  3}, // #2808
  {14,  2}, // #2809
  {15,  1}, // #2810
  {18,  1}, // #2811
  {19,  3}, // #2812
  {20,  3}, // #2813
  {22,  3}, // #2814
  {23,  3}, // #2815
  { 2, 12}, // #2816
  { 3,  2}, // #2817
  { 8,  1}, // #2818
  {11,  2}, // #2819
  {12,  2}, // #2820
  {13,  3}, // #2821
  {14,  2}, // #2822
  {15,  1}, // #2823
  {17,  1}, // #2824
  {18,  1}, // #2825
  {19,  3}, // #2826
  {20,  3}, // #2827
  {21,  1}, // #2828
  {22,  3}, // #2829
  {23,  4}, // #2830
  { 2, 12}, // #2831
  { 3,  2}, // #2832
  { 8,  1}, // #2833
  {11,  2}, // #2834
  {12,  2}, // #2835
  {13,  3}, // #2836
  {14,  2}, // #2837
  {15,  1}, // #2838
  {18,  1}, // #2839
  {19,  3}, // #2840
  {20,  3}, // #2841
  {22,  3}, // #2842
  {23,  3}, // #2843
  { 4,  2}, // #2844
  {11,  2}, // #2845
  {14,  4}, // #2846
  {15,  3}, // #2847
  {16,  2}, // #2848
  {17,  1}, // #2849
  {19,  3}, // #2850
  {20,  4}, // #2851
  {21,  2}, // #2852
  {22,  9}, // #2853
  {23, 11}, // #2854
  { 8,  1}, // #2855
  {13,  1}, // #2856
  {15,  1}, // #2857
  {18,  1}, // #2858
  {19,  2}, // #2859
  {20,  1}, // #2860
  {22,  2}, // #2861
  {23,  2}, // #2862
  { 3,  2}, // #2863
  { 4,  1}, // #2864
  { 8,  2}, // #2865
  { 9,  4}, // #2866
  {11,  3}, // #2867
  {12,  2}, // #2868
  {13,  6}, // #2869
  {14,  6}, // #2870
  {15,  3}, // #2871
  {16,  5}, // #2872
  {18,  6}, // #2873
  {19,  7}, // #2874
  {20, 10}, // #2875
  {22, 15}, // #2876
  {23, 15}, // #2877
  { 7,  1}, // #2878
  { 9,  1}, // #2879
  {12,  1}, // #2880
  {14,  2}, // #2881
  {16,  1}, // #2882
  {17,  1}, // #2883
  {18,  1}, // #2884
  {20,  2}, // #2885
  {21,  2}, // #2886
  {22,  5}, // #2887
  {23,  8}, // #2888
  { 3,  1}, // #2889
  {11,  1}, // #2890
  {12,  1}, // #2891
  {13,  2}, // #2892
  {14,  1}, // #2893
  {17,  1}, // #2894
  {19,  2}, // #2895
  {20,  2}, // #2896
  {21,  1}, // #2897
  {22,  2}, // #2898
  {23,  3}, // #2899
  { 3,  1}, // #2900
  { 8,  1}, // #2901
  {11,  1}, // #2902
  {12,  1}, // #2903
  {13,  2}, // #2904
  {14,  1}, // #2905
  {15,  1}, // #2906
  {18,  1}, // #2907
  {19,  3}, // #2908
  {20,  2}, // #2909
  {22,  3}, // #2910
  {23,  3}, // #2911
  { 3,  1}, // #2912
  { 8,  1}, // #2913
  {11,  1}, // #2914
  {12,  1}, // #2915
  {13,  2}, // #2916
  {14,  1}, // #2917
  {15,  1}, // #2918
  {17,  1}, // #2919
  {18,  1}, // #2920
  {19,  3}, // #2921
  {20,  2}, // #2922
  {21,  1}, // #2923
  {22,  3}, // #2924
  {23,  4}, // #2925
  { 9,  1}, // #2926
  {14,  1}, // #2927
  {16,  1}, // #2928
  {18,  1}, // #2929
  {20,  1}, // #2930
  {22,  4}, // #2931
  {23,  4}, // #2932
  { 9,  1}, // #2933
  {14,  4}, // #2934
  {15,  1}, // #2935
  {16,  1}, // #2936
  {18,  1}, // #2937
  {19,  1}, // #2938
  {20,  4}, // #2939
  {22,  7}, // #2940
  {23,  7}, // #2941
  { 8,  1}, // #2942
  { 9,  2}, // #2943
  {13,  1}, // #2944
  {14,  2}, // #2945
  {15,  1}, // #2946
  {16,  2}, // #2947
  {18,  3}, // #2948
  {19,  1}, // #2949
  {20,  3}, // #2950
  {22, 10}, // #2951
  {23, 10}, // #2952
  { 8,  6}, // #2953
  {13,  9}, // #2954
  {15,  6}, // #2955
  {18,  6}, // #2956
  {19,  9}, // #2957
  {20,  9}, // #2958
  {22, 15}, // #2959
  {23, 15}, // #2960
  { 4,  2}, // #2961
  {11,  2}, // #2962
  {14,  4}, // #2963
  {15,  3}, // #2964
  {16,  2}, // #2965
  {19,  3}, // #2966
  {20,  4}, // #2967
  {22, 10}, // #2968
  {23, 10}, // #2969
  { 7,  1}, // #2970
  {12,  1}, // #2971
  {14,  2}, // #2972
  {20,  2}, // #2973
  {21,  1}, // #2974
  {22,  2}, // #2975
  {23,  4}, // #2976
  { 4,  1}, // #2977
  { 9,  5}, // #2978
  {11,  1}, // #2979
  {13,  4}, // #2980
  {14,  5}, // #2981
  {15,  1}, // #2982
  {16,  6}, // #2983
  {18,  5}, // #2984
  {19,  5}, // #2985
  {20,  9}, // #2986
  {22, 10}, // #2987
  {23, 10}, // #2988
  { 4,  1}, // #2989
  { 9,  1}, // #2990
  {11,  1}, // #2991
  {14,  1}, // #2992
  {15,  1}, // #2993
  {16,  2}, // #2994
  {18,  1}, // #2995
  {19,  1}, // #2996
  {20,  1}, // #2997
  {22,  4}, // #2998
  {23,  4}, // #2999
  { 4,  1}, // #3000
  {11,  1}, // #3001
  {14,  5}, // #3002
  {15,  2}, // #3003
  {16,  1}, // #3004
  {17,  1}, // #3005
  {19,  2}, // #3006
  {20,  5}, // #3007
  {21,  2}, // #3008
  {22,  8}, // #3009
  {23, 10}, // #3010
  { 4,  2}, // #3011
  {11,  2}, // #3012
  {14,  3}, // #3013
  {15,  2}, // #3014
  {16,  2}, // #3015
  {19,  2}, // #3016
  {20,  3}, // #3017
  {22,  7}, // #3018
  {23,  7}, // #3019
  { 4,  1}, // #3020
  {11,  1}, // #3021
  {14,  5}, // #3022
  {15,  2}, // #3023
  {16,  1}, // #3024
  {19,  2}, // #3025
  {20,  5}, // #3026
  {22,  9}, // #3027
  {23,  9}, // #3028
  { 4,  1}, // #3029
  { 9,  8}, // #3030
  {11,  1}, // #3031
  {14,  8}, // #3032
  {15,  1}, // #3033
  {16,  9}, // #3034
  {17,  1}, // #3035
  {18,  8}, // #3036
  {19,  1}, // #3037
  {20,  8}, // #3038
  {21,  1}, // #3039
  {22, 30}, // #3040
  {23, 31}, // #3041
  { 7,  1}, // #3042
  { 9, 10}, // #3043
  {12,  1}, // #3044
  {14, 10}, // #3045
  {16, 10}, // #3046
  {17,  1}, // #3047
  {18, 10}, // #3048
  {20, 10}, // #3049
  {21,  2}, // #3050
  {22, 36}, // #3051
  {23, 39}, // #3052
  { 7,  1}, // #3053
  { 9, 11}, // #3054
  {12,  1}, // #3055
  {14, 11}, // #3056
  {16, 11}, // #3057
  {17,  1}, // #3058
  {18, 11}, // #3059
  {20, 11}, // #3060
  {21,  2}, // #3061
  {22, 37}, // #3062
  {23, 40}, // #3063
  { 4,  1}, // #3064
  { 7,  1}, // #3065
  { 8,  2}, // #3066
  { 9,  3}, // #3067
  {11,  1}, // #3068
  {12,  1}, // #3069
  {13,  2}, // #3070
  {14,  3}, // #3071
  {15,  4}, // #3072
  {16,  4}, // #3073
  {17,  1}, // #3074
  {18,  5}, // #3075
  {19,  4}, // #3076
  {20,  5}, // #3077
  {21,  2}, // #3078
  {22, 15}, // #3079
  {23, 18}, // #3080
  { 3,  2}, // #3081
  {11,  2}, // #3082
  {12,  2}, // #3083
  {13,  7}, // #3084
  {14, 12}, // #3085
  {17,  8}, // #3086
  {19,  7}, // #3087
  {20, 17}, // #3088
  {21,  8}, // #3089
  {22, 56}, // #3090
  {23, 64}, // #3091
  { 3,  9}, // #3092
  { 4,  1}, // #3093
  { 7, 11}, // #3094
  { 8, 16}, // #3095
  { 9,  1}, // #3096
  {11, 10}, // #3097
  {12, 20}, // #3098
  {13, 25}, // #3099
  {14, 31}, // #3100
  {15, 17}, // #3101
  {16,  2}, // #3102
  {18, 17}, // #3103
  {19, 26}, // #3104
  {20, 47}, // #3105
  {21, 11}, // #3106
  {22, 78}, // #3107
  {23, 100}, // #3108
  { 3,  1}, // #3109
  { 8,  1}, // #3110
  {11,  1}, // #3111
  {12,  1}, // #3112
  {13,  2}, // #3113
  {14,  1}, // #3114
  {15,  1}, // #3115
  {17,  2}, // #3116
  {18,  1}, // #3117
  {19,  3}, // #3118
  {20,  2}, // #3119
  {21,  2}, // #3120
  {22,  3}, // #3121
  {23,  5}, // #3122
  { 8,  2}, // #3123
  {11,  1}, // #3124
  {13,  2}, // #3125
  {15,  2}, // #3126
  {18,  2}, // #3127
  {19,  3}, // #3128
  {20,  2}, // #3129
  {22,  3}, // #3130
  {23,  3}, // #3131
  { 8,  2}, // #3132
  {11,  1}, // #3133
  {13,  2}, // #3134
  {15,  2}, // #3135
  {17,  1}, // #3136
  {18,  2}, // #3137
  {19,  3}, // #3138
  {20,  2}, // #3139
  {21,  1}, // #3140
  {22,  3}, // #3141
  {23,  4}, // #3142
  { 7,  2}, // #3143
  {12,  2}, // #3144
  {15,  1}, // #3145
  {19,  1}, // #3146
  {21,  2}, // #3147
  {22,  1}, // #3148
  {23,  5}, // #3149
  { 7,  1}, // #3150
  {12,  1}, // #3151
  {19,  1}, // #3152
  {21,  1}, // #3153
  {22,  1}, // #3154
  {23,  3}, // #3155
  { 7,  1}, // #3156
  { 8,  2}, // #3157
  {12,  1}, // #3158
  {13,  2}, // #3159
  {15,  2}, // #3160
  {18,  2}, // #3161
  {19,  2}, // #3162
  {20,  2}, // #3163
  {21,  1}, // #3164
  {22,  2}, // #3165
  {23,  4}, // #3166
  { 8,  1}, // #3167
  {13,  1}, // #3168
  {15,  1}, // #3169
  {17,  1}, // #3170
  {18,  1}, // #3171
  {19,  1}, // #3172
  {20,  1}, // #3173
  {21,  1}, // #3174
  {22,  2}, // #3175
  {23,  3}, // #3176
  { 3,  1}, // #3177
  { 7,  2}, // #3178
  {11,  1}, // #3179
  {12,  3}, // #3180
  {13,  1}, // #3181
  {14,  1}, // #3182
  {19,  1}, // #3183
  {20,  1}, // #3184
  {21,  2}, // #3185
  {22,  3}, // #3186
  {23,  7}, // #3187
  { 3,  1}, // #3188
  { 7,  4}, // #3189
  {11,  1}, // #3190
  {12,  5}, // #3191
  {13,  1}, // #3192
  {14,  1}, // #3193
  {19,  1}, // #3194
  {20,  1}, // #3195
  {21,  4}, // #3196
  {22,  3}, // #3197
  {23, 11}, // #3198
  { 3,  1}, // #3199
  { 7,  8}, // #3200
  {11,  1}, // #3201
  {12,  9}, // #3202
  {13,  1}, // #3203
  {14,  1}, // #3204
  {19,  1}, // #3205
  {20,  1}, // #3206
  {21,  8}, // #3207
  {22,  3}, // #3208
  {23, 19}, // #3209
  { 3,  1}, // #3210
  { 7, 16}, // #3211
  { 8,  1}, // #3212
  {11,  1}, // #3213
  {12, 17}, // #3214
  {13,  2}, // #3215
  {14,  1}, // #3216
  {15,  1}, // #3217
  {18,  1}, // #3218
  {19,  2}, // #3219
  {20,  2}, // #3220
  {21, 16}, // #3221
  {22,  4}, // #3222
  {23, 36}, // #3223
  { 3,  1}, // #3224
  { 7,  2}, // #3225
  { 8,  1}, // #3226
  {11,  1}, // #3227
  {12,  3}, // #3228
  {13,  2}, // #3229
  {14,  1}, // #3230
  {15,  1}, // #3231
  {18,  1}, // #3232
  {19,  2}, // #3233
  {20,  2}, // #3234
  {21,  2}, // #3235
  {22,  4}, // #3236
  {23,  8}, // #3237
  { 3,  1}, // #3238
  { 7,  4}, // #3239
  { 8,  1}, // #3240
  {11,  1}, // #3241
  {12,  5}, // #3242
  {13,  2}, // #3243
  {14,  1}, // #3244
  {15,  1}, // #3245
  {18,  1}, // #3246
  {19,  2}, // #3247
  {20,  2}, // #3248
  {21,  4}, // #3249
  {22,  4}, // #3250
  {23, 12}, // #3251
  { 3,  1}, // #3252
  { 7,  8}, // #3253
  { 8,  1}, // #3254
  {11,  1}, // #3255
  {12,  9}, // #3256
  {13,  2}, // #3257
  {14,  1}, // #3258
  {15,  1}, // #3259
  {18,  1}, // #3260
  {19,  2}, // #3261
  {20,  2}, // #3262
  {21,  8}, // #3263
  {22,  4}, // #3264
  {23, 20}, // #3265
  {11,  3}, // #3266
  {19,  3}, // #3267
  {22,  3}, // #3268
  {23,  3}, // #3269
  {13,  3}, // #3270
  {19,  3}, // #3271
  {20,  3}, // #3272
  {22,  3}, // #3273
  {23,  3}, // #3274
  { 3,  1}, // #3275
  {11,  1}, // #3276
  {12,  1}, // #3277
  {13,  1}, // #3278
  {14,  1}, // #3279
  {17,  1}, // #3280
  {19,  2}, // #3281
  {20,  1}, // #3282
  {21,  1}, // #3283
  {22,  2}, // #3284
  {23,  3}, // #3285
  { 4,  1}, // #3286
  { 8,  2}, // #3287
  {11,  3}, // #3288
  {13,  2}, // #3289
  {15,  3}, // #3290
  {16,  1}, // #3291
  {17,  1}, // #3292
  {18,  2}, // #3293
  {19,  7}, // #3294
  {20,  2}, // #3295
  {21,  1}, // #3296
  {22,  7}, // #3297
  {23,  8}, // #3298
  {17,  1}, // #3299
  {19,  3}, // #3300
  {21,  1}, // #3301
  {22,  3}, // #3302
  {23,  4}, // #3303
  { 3,  1}, // #3304
  {11,  1}, // #3305
  {12,  1}, // #3306
  {13,  1}, // #3307
  {14,  1}, // #3308
  {17,  2}, // #3309
  {19,  2}, // #3310
  {20,  1}, // #3311
  {21,  2}, // #3312
  {22,  3}, // #3313
  {23,  5}, // #3314
  { 8,  5}, // #3315
  {11,  5}, // #3316
  {13,  5}, // #3317
  {15,  5}, // #3318
  {18,  5}, // #3319
  {19, 14}, // #3320
  {20,  5}, // #3321
  {22, 14}, // #3322
  {23, 14}, // #3323
  { 8,  5}, // #3324
  {11,  5}, // #3325
  {13,  5}, // #3326
  {15,  5}, // #3327
  {17,  1}, // #3328
  {18,  5}, // #3329
  {19, 14}, // #3330
  {20,  5}, // #3331
  {21,  1}, // #3332
  {22, 14}, // #3333
  {23, 15}, // #3334
  { 8,  9}, // #3335
  {11,  7}, // #3336
  {13,  9}, // #3337
  {15,  9}, // #3338
  {18,  9}, // #3339
  {19, 21}, // #3340
  {20,  9}, // #3341
  {22, 21}, // #3342
  {23, 21}, // #3343
  { 8,  9}, // #3344
  {11,  7}, // #3345
  {13,  9}, // #3346
  {15,  9}, // #3347
  {17,  1}, // #3348
  {18,  9}, // #3349
  {19, 21}, // #3350
  {20,  9}, // #3351
  {21,  1}, // #3352
  {22, 21}, // #3353
  {23, 22}, // #3354
  { 8, 17}, // #3355
  {11, 11}, // #3356
  {13, 17}, // #3357
  {15, 17}, // #3358
  {18, 17}, // #3359
  {19, 35}, // #3360
  {20, 17}, // #3361
  {22, 35}, // #3362
  {23, 35}, // #3363
  { 8, 17}, // #3364
  {11, 11}, // #3365
  {13, 17}, // #3366
  {15, 17}, // #3367
  {17,  1}, // #3368
  {18, 17}, // #3369
  {19, 35}, // #3370
  {20, 17}, // #3371
  {21,  1}, // #3372
  {22, 35}, // #3373
  {23, 36}, // #3374
  { 4,  1}, // #3375
  { 7,  1}, // #3376
  { 9,  1}, // #3377
  {11,  1}, // #3378
  {12,  1}, // #3379
  { 5,  1}, // #3380
  { 6,  2}, // #3381
  { 8,  2}, // #3382
  { 9,  2}, // #3383
  {10,  2}, // #3384
  {11,  3}, // #3385
  {12,  6}, // #3386
  { 6,  1}, // #3387
  { 8,  1}, // #3388
  { 9,  1}, // #3389
  {10,  1}, // #3390
  {11,  1}, // #3391
  {12,  2}, // #3392
  { 6,  1}, // #3393
  { 8,  1}, // #3394
  { 9,  1}, // #3395
  {11,  1}, // #3396
  {12,  1}, // #3397
  { 5,  1}, // #3398
  {10,  1}, // #3399
  {12,  2}, // #3400
  {10,  1}, // #3401
  {12,  1}, // #3402
  { 5,  1}, // #3403
  {10,  2}, // #3404
  {11,  3}, // #3405
  {12,  6}, // #3406
  { 8,  1}, // #3407
  {10,  1}, // #3408
  {11,  2}, // #3409
  {12,  3}, // #3410
  { 5,  1}, // #3411
  {10,  2}, // #3412
  {11,  1}, // #3413
  {12,  4}, // #3414
  { 4,  1}, // #3415
  { 7,  1}, // #3416
  { 9,  1}, // #3417
  {10,  1}, // #3418
  {11,  1}, // #3419
  {12,  2}, // #3420
  { 6,  1}, // #3421
  { 8,  1}, // #3422
  { 9,  1}, // #3423
  {10,  1}, // #3424
  {11,  2}, // #3425
  {12,  3}, // #3426
  { 6,  1}, // #3427
  { 8,  1}, // #3428
  { 9,  1}, // #3429
  {11,  2}, // #3430
  {12,  2}, // #3431
  { 6,  2}, // #3432
  { 8,  2}, // #3433
  { 9,  2}, // #3434
  {10,  1}, // #3435
  {11,  2}, // #3436
  {12,  3}, // #3437
  { 6,  2}, // #3438
  { 8,  2}, // #3439
  { 9,  2}, // #3440
  {11,  2}, // #3441
  {12,  2}, // #3442
  {10,  1}, // #3443
  {11, 10}, // #3444
  {12, 11}, // #3445
  {11, 11}, // #3446
  {12, 11}, // #3447
  { 4,  1}, // #3448
  { 7,  1}, // #3449
  { 8,  1}, // #3450
  { 9,  1}, // #3451
  {10,  1}, // #3452
  {11,  2}, // #3453
  {12,  3}, // #3454
  { 4,  1}, // #3455
  { 7,  1}, // #3456
  { 8,  1}, // #3457
  { 9,  1}, // #3458
  {11,  2}, // #3459
  {12,  2}, // #3460
  { 8,  1}, // #3461
  {10,  1}, // #3462
  {11,  1}, // #3463
  {12,  2}, // #3464
  { 8,  2}, // #3465
  {10,  1}, // #3466
  {11,  2}, // #3467
  {12,  3}, // #3468
  { 8,  2}, // #3469
  {11,  2}, // #3470
  {12,  2}, // #3471
  { 5,  1}, // #3472
  { 6,  1}, // #3473
  { 8,  2}, // #3474
  { 9,  1}, // #3475
  {10,  2}, // #3476
  {11,  3}, // #3477
  {12,  6}, // #3478
  { 5,  1}, // #3479
  { 8,  1}, // #3480
  {10,  2}, // #3481
  {11,  1}, // #3482
  {12,  4}, // #3483
  { 8,  2}, // #3484
  {10,  1}, // #3485
  {11,  3}, // #3486
  {12,  4}, // #3487
  { 8,  2}, // #3488
  {11,  3}, // #3489
  {12,  3}, // #3490
  { 6,  2}, // #3491
  { 8,  3}, // #3492
  { 9,  2}, // #3493
  {11,  3}, // #3494
  {12,  3}, // #3495
  { 8,  1}, // #3496
  {11,  4}, // #3497
  {12,  4}, // #3498
  { 4,  1}, // #3499
  { 6,  1}, // #3500
  { 7,  1}, // #3501
  { 8,  1}, // #3502
  { 9,  2}, // #3503
  {10,  1}, // #3504
  {11,  2}, // #3505
  {12,  3}, // #3506
  { 4,  1}, // #3507
  { 6,  1}, // #3508
  { 7,  1}, // #3509
  { 8,  1}, // #3510
  { 9,  2}, // #3511
  {11,  2}, // #3512
  {12,  2}, // #3513
  { 3,  1}, // #3514
  { 7,  1}, // #3515
  { 8,  1}, // #3516
  {10,  1}, // #3517
  {11,  1}, // #3518
  {12,  2}, // #3519
  { 3,  1}, // #3520
  { 6,  1}, // #3521
  { 7,  1}, // #3522
  { 8,  2}, // #3523
  { 9,  1}, // #3524
  {11,  2}, // #3525
  {12,  2}, // #3526
  { 3,  1}, // #3527
  { 4,  1}, // #3528
  { 7,  2}, // #3529
  { 8,  1}, // #3530
  { 9,  1}, // #3531
  {10,  1}, // #3532
  {11,  2}, // #3533
  {12,  3}, // #3534
  { 3,  1}, // #3535
  { 4,  1}, // #3536
  { 7,  2}, // #3537
  { 8,  1}, // #3538
  { 9,  1}, // #3539
  {11,  2}, // #3540
  {12,  2}, // #3541
  { 4,  1}, // #3542
  { 6,  2}, // #3543
  { 7,  1}, // #3544
  { 8,  2}, // #3545
  { 9,  3}, // #3546
  {11,  3}, // #3547
  {12,  3}, // #3548
  { 3,  1}, // #3549
  { 7,  1}, // #3550
  { 8,  1}, // #3551
  {11,  1}, // #3552
  {12,  1}, // #3553
  { 1, 10}, // #3554
  { 3,  1}, // #3555
  { 7,  1}, // #3556
  { 8,  1}, // #3557
  {10,  1}, // #3558
  {11,  1}, // #3559
  {12,  2}, // #3560
  { 1, 10}, // #3561
  { 3,  1}, // #3562
  { 7,  1}, // #3563
  { 8,  1}, // #3564
  {11,  1}, // #3565
  {12,  1}, // #3566
  { 2, 22}, // #3567
  { 3,  1}, // #3568
  { 7,  1}, // #3569
  { 8,  1}, // #3570
  {10,  1}, // #3571
  {11,  1}, // #3572
  {12,  2}, // #3573
  { 2, 22}, // #3574
  { 3,  1}, // #3575
  { 7,  1}, // #3576
  { 8,  1}, // #3577
  {11,  1}, // #3578
  {12,  1}, // #3579
  { 2, 14}, // #3580
  { 3,  1}, // #3581
  { 7,  1}, // #3582
  { 8,  1}, // #3583
  {10,  1}, // #3584
  {11,  1}, // #3585
  {12,  2}, // #3586
  { 2, 14}, // #3587
  { 3,  1}, // #3588
  { 7,  1}, // #3589
  { 8,  1}, // #3590
  {11,  1}, // #3591
  {12,  1}, // #3592
  { 3,  1}, // #3593
  { 4,  1}, // #3594
  { 6,  1}, // #3595
  { 7,  2}, // #3596
  { 8,  2}, // #3597
  { 9,  2}, // #3598
  {10,  1}, // #3599
  {11,  3}, // #3600
  {12,  4}, // #3601
  { 3,  1}, // #3602
  { 4,  1}, // #3603
  { 6,  1}, // #3604
  { 7,  2}, // #3605
  { 8,  2}, // #3606
  { 9,  2}, // #3607
  {11,  3}, // #3608
  {12,  3}, // #3609
  { 3,  1}, // #3610
  { 4,  2}, // #3611
  { 6,  1}, // #3612
  { 7,  3}, // #3613
  { 8,  2}, // #3614
  { 9,  3}, // #3615
  {10,  1}, // #3616
  {11,  4}, // #3617
  {12,  5}, // #3618
  { 3,  1}, // #3619
  { 4,  2}, // #3620
  { 6,  1}, // #3621
  { 7,  3}, // #3622
  { 8,  2}, // #3623
  { 9,  3}, // #3624
  {11,  4}, // #3625
  {12,  4}, // #3626
  { 5,  1}, // #3627
  { 9,  1}, // #3628
  {10,  1}, // #3629
  {11,  1}, // #3630
  {12,  3}, // #3631
  { 3,  1}, // #3632
  { 7,  1}, // #3633
  { 8,  1}, // #3634
  { 9,  1}, // #3635
  {11,  2}, // #3636
  {12,  2}, // #3637
  {11, 31}, // #3638
  {12, 31}, // #3639
  { 4,  1}, // #3640
  { 6,  2}, // #3641
  { 7,  1}, // #3642
  { 8,  2}, // #3643
  { 9,  3}, // #3644
  {10,  1}, // #3645
  {11,  3}, // #3646
  {12,  4}, // #3647
  { 4,  1}, // #3648
  { 7,  1}, // #3649
  { 8,  1}, // #3650
  { 9,  1}, // #3651
  {10,  1}, // #3652
  {11,  4}, // #3653
  {12,  5}, // #3654
  { 4,  1}, // #3655
  { 7,  1}, // #3656
  { 8,  1}, // #3657
  { 9,  1}, // #3658
  {11,  4}, // #3659
  {12,  4}, // #3660
  { 4,  1}, // #3661
  { 7,  1}, // #3662
  { 9,  1}, // #3663
  {10,  1}, // #3664
  {11,  2}, // #3665
  {12,  3}, // #3666
  { 4,  1}, // #3667
  { 7,  1}, // #3668
  { 9,  1}, // #3669
  {11,  2}, // #3670
  {12,  2}, // #3671
  { 4,  1}, // #3672
  { 7,  1}, // #3673
  { 8,  1}, // #3674
  { 9,  1}, // #3675
  {10,  1}, // #3676
  {11,  3}, // #3677
  {12,  4}, // #3678
  { 4,  1}, // #3679
  { 7,  1}, // #3680
  { 8,  1}, // #3681
  { 9,  1}, // #3682
  {11,  3}, // #3683
  {12,  3}, // #3684
  { 3,  1}, // #3685
  { 5,  1}, // #3686
  { 6,  1}, // #3687
  { 7,  1}, // #3688
  { 8,  2}, // #3689
  { 9,  1}, // #3690
  {10,  1}, // #3691
  {11,  2}, // #3692
  {12,  4}, // #3693
  { 6,  1}, // #3694
  { 8,  1}, // #3695
  { 9,  2}, // #3696
  {11,  2}, // #3697
  {12,  2}, // #3698
  { 3,  1}, // #3699
  { 7,  1}, // #3700
  { 8,  1}, // #3701
  { 9,  2}, // #3702
  {10,  1}, // #3703
  {11,  3}, // #3704
  {12,  4}, // #3705
  { 3,  1}, // #3706
  { 7,  1}, // #3707
  { 8,  1}, // #3708
  { 9,  2}, // #3709
  {11,  3}, // #3710
  {12,  3}, // #3711
  {10,  1}, // #3712
  {11, 17}, // #3713
  {12, 18}, // #3714
  {11, 18}, // #3715
  {12, 18}, // #3716
  {10,  1}, // #3717
  {11,  7}, // #3718
  {12,  8}, // #3719
  {11,  8}, // #3720
  {12,  8}, // #3721
  { 3,  3}, // #3722
  { 7,  3}, // #3723
  { 8,  3}, // #3724
  {10,  1}, // #3725
  {11,  3}, // #3726
  {12,  4}, // #3727
  { 3,  3}, // #3728
  { 7,  3}, // #3729
  { 8,  3}, // #3730
  {11,  3}, // #3731
  {12,  3}, // #3732
  { 5,  1}, // #3733
  {10,  2}, // #3734
  {12,  3}, // #3735
  { 3,  1}, // #3736
  { 7,  1}, // #3737
  { 8,  1}, // #3738
  { 9,  1}, // #3739
  {10,  1}, // #3740
  {11,  2}, // #3741
  {12,  3}, // #3742
  { 3,  1}, // #3743
  { 6,  1}, // #3744
  { 7,  1}, // #3745
  { 8,  2}, // #3746
  { 9,  1}, // #3747
  {10,  1}, // #3748
  {11,  2}, // #3749
  {12,  3}, // #3750
  { 5,  1}, // #3751
  { 8,  2}, // #3752
  {10,  2}, // #3753
  {11,  2}, // #3754
  {12,  5}, // #3755
  { 5,  1}, // #3756
  { 8,  3}, // #3757
  {10,  2}, // #3758
  {11,  3}, // #3759
  {12,  6}, // #3760
  { 5,  1}, // #3761
  { 8,  1}, // #3762
  {10,  1}, // #3763
  {11,  1}, // #3764
  {12,  3}, // #3765
  { 5,  1}, // #3766
  { 8,  3}, // #3767
  {10,  2}, // #3768
  {11,  4}, // #3769
  {12,  7}, // #3770
  { 5,  1}, // #3771
  { 8,  1}, // #3772
  {10,  2}, // #3773
  {11,  2}, // #3774
  {12,  5}, // #3775
  { 2, 21}, // #3776
  { 3,  1}, // #3777
  { 7,  1}, // #3778
  { 8,  1}, // #3779
  {10,  1}, // #3780
  {11,  1}, // #3781
  {12,  2}, // #3782
  { 2, 21}, // #3783
  { 3,  1}, // #3784
  { 7,  1}, // #3785
  { 8,  1}, // #3786
  {11,  1}, // #3787
  {12,  1}, // #3788
  { 2, 24}, // #3789
  { 3,  1}, // #3790
  { 7,  1}, // #3791
  { 8,  1}, // #3792
  {11,  1}, // #3793
  {12,  1}, // #3794
  { 7,  1}, // #3795
  {10,  1}, // #3796
  {11,  1}, // #3797
  {12,  2}, // #3798
  { 4,  1}, // #3799
  { 5,  1}, // #3800
  { 7,  1}, // #3801
  { 9,  1}, // #3802
  {10,  1}, // #3803
  {11,  1}, // #3804
  {12,  3}, // #3805
  { 2, 44}, // #3806
  { 3,  2}, // #3807
  { 7,  2}, // #3808
  { 8,  3}, // #3809
  {10,  1}, // #3810
  {11,  3}, // #3811
  {12,  4}, // #3812
  { 2, 44}, // #3813
  { 3,  2}, // #3814
  { 7,  2}, // #3815
  { 8,  3}, // #3816
  {11,  3}, // #3817
  {12,  3}, // #3818
  { 2, 28}, // #3819
  { 3,  2}, // #3820
  { 7,  2}, // #3821
  { 8,  3}, // #3822
  {10,  1}, // #3823
  {11,  3}, // #3824
  {12,  4}, // #3825
  { 2, 28}, // #3826
  { 3,  2}, // #3827
  { 7,  2}, // #3828
  { 8,  3}, // #3829
  {11,  3}, // #3830
  {12,  3}, // #3831
  { 5,  1}, // #3832
  { 7,  1}, // #3833
  {10,  1}, // #3834
  {11,  1}, // #3835
  {12,  3}, // #3836
  { 8,  7}, // #3837
  {10,  4}, // #3838
  {11,  7}, // #3839
  {12, 11}, // #3840
  { 5,  1}, // #3841
  {10,  2}, // #3842
  {11,  2}, // #3843
  {12,  5}, // #3844
  { 6,  1}, // #3845
  { 7,  1}, // #3846
  { 8,  1}, // #3847
  { 9,  1}, // #3848
  {10,  1}, // #3849
  {11,  2}, // #3850
  {12,  3}, // #3851
  { 5,  1}, // #3852
  { 6,  2}, // #3853
  { 8,  2}, // #3854
  { 9,  2}, // #3855
  {10,  2}, // #3856
  {11,  2}, // #3857
  {12,  5}, // #3858
  { 4,  1}, // #3859
  { 5,  1}, // #3860
  { 7,  1}, // #3861
  { 9,  1}, // #3862
  {10,  2}, // #3863
  {11,  1}, // #3864
  {12,  4}, // #3865
  { 5,  1}, // #3866
  { 6,  1}, // #3867
  { 8,  1}, // #3868
  { 9,  1}, // #3869
  {10,  2}, // #3870
  {11,  1}, // #3871
  {12,  4}, // #3872
  { 6,  1}, // #3873
  { 8,  1}, // #3874
  { 9,  1}, // #3875
  {11,  4}, // #3876
  {12,  4}, // #3877
  { 5,  1}, // #3878
  { 6,  2}, // #3879
  { 7,  1}, // #3880
  { 8,  2}, // #3881
  { 9,  2}, // #3882
  {10,  1}, // #3883
  {11,  3}, // #3884
  {12,  5}, // #3885
  { 3,  1}, // #3886
  { 7,  1}, // #3887
  { 8,  1}, // #3888
  {11,  2}, // #3889
  {12,  2}, // #3890
  { 8,  8}, // #3891
  {11,  8}, // #3892
  {12,  8}, // #3893
  { 5,  1}, // #3894
  { 6,  1}, // #3895
  { 8,  1}, // #3896
  { 9,  1}, // #3897
  {10,  1}, // #3898
  {11,  1}, // #3899
  {12,  3}, // #3900
  { 5,  1}, // #3901
  {10,  1}, // #3902
  {11,  1}, // #3903
  {12,  3}, // #3904
  { 5,  1}, // #3905
  { 8,  2}, // #3906
  {10,  1}, // #3907
  {11,  2}, // #3908
  {12,  4}, // #3909
  { 3,  1}, // #3910
  { 5,  1}, // #3911
  { 7,  1}, // #3912
  { 8,  1}, // #3913
  { 9,  1}, // #3914
  {10,  1}, // #3915
  {11,  2}, // #3916
  {12,  4}, // #3917
  { 5,  1}, // #3918
  { 6,  1}, // #3919
  { 7,  1}, // #3920
  { 8,  1}, // #3921
  { 9,  1}, // #3922
  {10,  1}, // #3923
  {11,  2}, // #3924
  {12,  4}, // #3925
  { 3,  1}, // #3926
  { 5,  1}, // #3927
  { 7,  1}, // #3928
  { 8,  1}, // #3929
  {10,  2}, // #3930
  {11,  1}, // #3931
  {12,  4}, // #3932
  { 4,  1}, // #3933
  { 6,  2}, // #3934
  { 7,  1}, // #3935
  { 8,  2}, // #3936
  { 9,  3}, // #3937
  {11,  4}, // #3938
  {12,  4}, // #3939
  {10,  2}, // #3940
  {11,  3}, // #3941
  {12,  5}, // #3942
  { 5,  1}, // #3943
  { 6,  1}, // #3944
  { 7,  1}, // #3945
  { 8,  1}, // #3946
  { 9,  1}, // #3947
  {10,  2}, // #3948
  {11,  2}, // #3949
  {12,  5}, // #3950
  { 5,  1}, // #3951
  { 8,  2}, // #3952
  {10,  2}, // #3953
  {11,  3}, // #3954
  {12,  6}, // #3955
  { 4,  2}, // #3956
  { 7,  2}, // #3957
  { 9,  2}, // #3958
  {10,  1}, // #3959
  {11,  2}, // #3960
  {12,  3}, // #3961
  {14,  1}, // #3962
  {17,  1}, // #3963
  {20,  1}, // #3964
  {21,  1}, // #3965
  {22,  3}, // #3966
  {23,  4}, // #3967
  { 3,  1}, // #3968
  { 4,  1}, // #3969
  { 8,  1}, // #3970
  { 9,  1}, // #3971
  {11,  2}, // #3972
  {12,  1}, // #3973
  {13,  2}, // #3974
  {14,  2}, // #3975
  {15,  2}, // #3976
  {16,  2}, // #3977
  {18,  2}, // #3978
  {19,  3}, // #3979
  {20,  3}, // #3980
  {22,  4}, // #3981
  {23,  4}, // #3982
  { 4,  1}, // #3983
  { 9,  1}, // #3984
  {11,  1}, // #3985
  {14,  1}, // #3986
  {15,  1}, // #3987
  {16,  2}, // #3988
  {17,  1}, // #3989
  {18,  1}, // #3990
  {19,  1}, // #3991
  {20,  1}, // #3992
  {21,  1}, // #3993
  {22,  2}, // #3994
  {23,  3}, // #3995
  { 4,  1}, // #3996
  { 9,  1}, // #3997
  {11,  1}, // #3998
  {14,  1}, // #3999
  {15,  1}, // #4000
  {16,  2}, // #4001
  {18,  1}, // #4002
  {19,  1}, // #4003
  {20,  1}, // #4004
  {22,  2}, // #4005
  {23,  2}, // #4006
  { 2, 17}, // #4007
  { 3,  1}, // #4008
  {11,  1}, // #4009
  {12,  1}, // #4010
  {13,  1}, // #4011
  {14,  1}, // #4012
  {19,  1}, // #4013
  {20,  1}, // #4014
  {22,  1}, // #4015
  {23,  1}, // #4016
  { 4,  1}, // #4017
  { 7,  1}, // #4018
  { 8,  1}, // #4019
  {11,  1}, // #4020
  {12,  1}, // #4021
  {13,  1}, // #4022
  {15,  2}, // #4023
  {16,  1}, // #4024
  {18,  1}, // #4025
  {19,  2}, // #4026
  {20,  1}, // #4027
  {21,  1}, // #4028
  {22,  2}, // #4029
  {23,  4}, // #4030
  { 2, 28}, // #4031
  { 3,  2}, // #4032
  {11,  2}, // #4033
  {12,  2}, // #4034
  {13,  2}, // #4035
  {14,  2}, // #4036
  {15,  1}, // #4037
  {17,  1}, // #4038
  {19,  3}, // #4039
  {20,  2}, // #4040
  {21,  1}, // #4041
  {22,  3}, // #4042
  {23,  4}, // #4043
  { 2, 28}, // #4044
  { 3,  2}, // #4045
  {11,  2}, // #4046
  {12,  2}, // #4047
  {13,  2}, // #4048
  {14,  2}, // #4049
  {15,  1}, // #4050
  {19,  3}, // #4051
  {20,  2}, // #4052
  {22,  3}, // #4053
  {23,  3}, // #4054
  { 2, 14}, // #4055
  { 3,  2}, // #4056
  {11,  2}, // #4057
  {12,  2}, // #4058
  {13,  2}, // #4059
  {14,  2}, // #4060
  {15,  1}, // #4061
  {17,  1}, // #4062
  {19,  3}, // #4063
  {20,  2}, // #4064
  {21,  1}, // #4065
  {22,  3}, // #4066
  {23,  4}, // #4067
  { 2, 14}, // #4068
  { 3,  2}, // #4069
  {11,  2}, // #4070
  {12,  2}, // #4071
  {13,  2}, // #4072
  {14,  2}, // #4073
  {15,  1}, // #4074
  {19,  3}, // #4075
  {20,  2}, // #4076
  {22,  3}, // #4077
  {23,  3}, // #4078
  { 4,  2}, // #4079
  {11,  2}, // #4080
  {15,  2}, // #4081
  {16,  2}, // #4082
  {19,  2}, // #4083
  {22,  2}, // #4084
  {23,  2}, // #4085
  { 3,  2}, // #4086
  { 4,  1}, // #4087
  { 8,  2}, // #4088
  { 9,  4}, // #4089
  {11,  5}, // #4090
  {12,  2}, // #4091
  {13,  4}, // #4092
  {14,  6}, // #4093
  {15,  3}, // #4094
  {16,  5}, // #4095
  {18,  6}, // #4096
  {19,  7}, // #4097
  {20,  8}, // #4098
  {22, 15}, // #4099
  {23, 15}, // #4100
  { 7,  1}, // #4101
  {12,  1}, // #4102
  {17,  2}, // #4103
  {21,  2}, // #4104
  {22,  2}, // #4105
  {23,  5}, // #4106
  {17,  1}, // #4107
  {21,  1}, // #4108
  {22, 14}, // #4109
  {23, 15}, // #4110
  {17,  2}, // #4111
  {21,  2}, // #4112
  {22,  3}, // #4113
  {23,  5}, // #4114
  { 9,  2}, // #4115
  {14,  2}, // #4116
  {16,  2}, // #4117
  {17,  1}, // #4118
  {18,  2}, // #4119
  {19,  1}, // #4120
  {20,  2}, // #4121
  {21,  1}, // #4122
  {22,  3}, // #4123
  {23,  4}, // #4124
  {17,  1}, // #4125
  {19, 16}, // #4126
  {21,  1}, // #4127
  {22, 16}, // #4128
  {23, 17}, // #4129
  { 3,  2}, // #4130
  { 8,  2}, // #4131
  {11,  2}, // #4132
  {12,  2}, // #4133
  {13,  4}, // #4134
  {14,  4}, // #4135
  {15,  3}, // #4136
  {17,  2}, // #4137
  {18,  2}, // #4138
  {19,  8}, // #4139
  {20,  6}, // #4140
  {21,  2}, // #4141
  {22, 10}, // #4142
  {23, 12}, // #4143
  { 3,  5}, // #4144
  { 8,  3}, // #4145
  {11,  5}, // #4146
  {12,  5}, // #4147
  {13,  8}, // #4148
  {14,  9}, // #4149
  {15,  4}, // #4150
  {17,  4}, // #4151
  {18,  3}, // #4152
  {19, 14}, // #4153
  {20, 12}, // #4154
  {21,  4}, // #4155
  {22, 18}, // #4156
  {23, 22}, // #4157
  { 3,  3}, // #4158
  { 8,  3}, // #4159
  {11,  3}, // #4160
  {12,  3}, // #4161
  {13,  6}, // #4162
  {14,  7}, // #4163
  {15,  4}, // #4164
  {17,  4}, // #4165
  {18,  3}, // #4166
  {19, 12}, // #4167
  {20, 10}, // #4168
  {21,  4}, // #4169
  {22, 16}, // #4170
  {23, 20}, // #4171
  { 3,  5}, // #4172
  { 8,  3}, // #4173
  {11,  5}, // #4174
  {12,  5}, // #4175
  {13,  8}, // #4176
  {14, 13}, // #4177
  {15,  4}, // #4178
  {17,  8}, // #4179
  {18,  3}, // #4180
  {19, 18}, // #4181
  {20, 16}, // #4182
  {21,  8}, // #4183
  {22, 26}, // #4184
  {23, 34}, // #4185
  { 3,  3}, // #4186
  { 8,  3}, // #4187
  {11,  3}, // #4188
  {12,  3}, // #4189
  {13,  6}, // #4190
  {14,  5}, // #4191
  {15,  4}, // #4192
  {17,  2}, // #4193
  {18,  3}, // #4194
  {19, 10}, // #4195
  {20,  8}, // #4196
  {21,  2}, // #4197
  {22, 12}, // #4198
  {23, 14}, // #4199
  { 3,  3}, // #4200
  { 8,  3}, // #4201
  {11,  3}, // #4202
  {12,  3}, // #4203
  {13,  6}, // #4204
  {14,  5}, // #4205
  {15,  4}, // #4206
  {17,  2}, // #4207
  {18,  3}, // #4208
  {19, 11}, // #4209
  {20,  8}, // #4210
  {21,  2}, // #4211
  {22, 13}, // #4212
  {23, 15}, // #4213
  { 5,  1}, // #4214
  { 6,  1}, // #4215
  {10,  1}, // #4216
  { 4,  5}, // #4217
  { 6,  5}, // #4218
  {10,  1}, // #4219
  { 4,  1}, // #4220
  { 6,  1}, // #4221
  {10,  1}, // #4222
  { 9, 20}, // #4223
  {10,  1}, // #4224
  { 1, 25}, // #4225
  { 9,  1}, // #4226
  {10,  1}, // #4227
  { 2, 69}, // #4228
  { 4,  1}, // #4229
  { 6,  1}, // #4230
  {10,  1}, // #4231
  { 2, 39}, // #4232
  { 4,  1}, // #4233
  { 6,  1}, // #4234
  {10,  1}, // #4235
  { 2, 17}, // #4236
  { 4,  1}, // #4237
  { 6,  1}, // #4238
  {10,  1}, // #4239
  { 2, 32}, // #4240
  { 4,  1}, // #4241
  { 6,  1}, // #4242
  {10,  1}, // #4243
  { 4,  1}, // #4244
  { 6,  1}, // #4245
  {10,  2}, // #4246
  { 6, 10}, // #4247
  { 6,  2}, // #4248
  {10,  1}, // #4249
  { 3,  2}, // #4250
  { 4,  1}, // #4251
  { 6,  1}, // #4252
  {10,  1}, // #4253
  { 4,  1}, // #4254
  { 6,  1}, // #4255
  { 8,  1}, // #4256
  { 9,  1}, // #4257
  {10,  1}, // #4258
  { 4, 10}, // #4259
  { 6, 10}, // #4260
  {10,  1}, // #4261
  { 4, 21}, // #4262
  { 6, 21}, // #4263
  {10,  1}, // #4264
  { 4, 17}, // #4265
  { 6, 17}, // #4266
  {10,  1}, // #4267
  { 4, 13}, // #4268
  { 6, 13}, // #4269
  {10,  1}, // #4270
  { 2, 70}, // #4271
  { 4,  1}, // #4272
  { 6,  1}, // #4273
  {10,  1}, // #4274
  { 2, 40}, // #4275
  { 4,  1}, // #4276
  { 6,  1}, // #4277
  {10,  1}, // #4278
  { 2, 35}, // #4279
  { 4,  1}, // #4280
  { 6,  1}, // #4281
  {10,  1}, // #4282
  { 2, 20}, // #4283
  { 4,  1}, // #4284
  { 6,  1}, // #4285
  {10,  1}, // #4286
  { 8,  1}, // #4287
  {11,  2}, // #4288
  {13,  1}, // #4289
  {15,  1}, // #4290
  {17,  1}, // #4291
  {18,  1}, // #4292
  {19,  3}, // #4293
  {20,  1}, // #4294
  {21,  1}, // #4295
  {22,  3}, // #4296
  {23,  4}, // #4297
  { 8,  1}, // #4298
  {11,  2}, // #4299
  {13,  1}, // #4300
  {15,  1}, // #4301
  {18,  1}, // #4302
  {19,  3}, // #4303
  {20,  1}, // #4304
  {22,  3}, // #4305
  {23,  3}, // #4306
  { 8,  1}, // #4307
  {11,  3}, // #4308
  {13,  1}, // #4309
  {15,  1}, // #4310
  {17,  1}, // #4311
  {18,  1}, // #4312
  {19,  4}, // #4313
  {20,  1}, // #4314
  {21,  1}, // #4315
  {22,  4}, // #4316
  {23,  5}, // #4317
  { 8,  1}, // #4318
  {11,  3}, // #4319
  {13,  1}, // #4320
  {15,  1}, // #4321
  {18,  1}, // #4322
  {19,  4}, // #4323
  {20,  1}, // #4324
  {22,  4}, // #4325
  {23,  4}, // #4326
  { 3,  1}, // #4327
  { 8,  1}, // #4328
  {11,  2}, // #4329
  {12,  1}, // #4330
  {13,  2}, // #4331
  {14,  1}, // #4332
  {15,  1}, // #4333
  {18,  1}, // #4334
  {19,  3}, // #4335
  {20,  2}, // #4336
  {22,  3}, // #4337
  {23,  3}, // #4338
  { 3,  1}, // #4339
  { 8,  1}, // #4340
  {11,  2}, // #4341
  {12,  1}, // #4342
  {13,  2}, // #4343
  {14,  1}, // #4344
  {15,  1}, // #4345
  {17,  1}, // #4346
  {18,  1}, // #4347
  {19,  3}, // #4348
  {20,  2}, // #4349
  {21,  1}, // #4350
  {22,  3}, // #4351
  {23,  4}, // #4352
  {22, 16}, // #4353
  {23, 16}, // #4354
  { 3,  1}, // #4355
  {11,  2}, // #4356
  {12,  1}, // #4357
  {13,  1}, // #4358
  {14,  1}, // #4359
  {19,  2}, // #4360
  {20,  1}, // #4361
  {22,  2}, // #4362
  {23,  2}, // #4363
  { 7,  1}, // #4364
  { 9, 11}, // #4365
  {12,  1}, // #4366
  {14, 11}, // #4367
  {16, 11}, // #4368
  {17,  1}, // #4369
  {18, 11}, // #4370
  {20, 11}, // #4371
  {21,  2}, // #4372
  {22, 41}, // #4373
  {23, 44}, // #4374
  { 1,  1}, // #4375
  { 4,  1}, // #4376
  {11,  1}, // #4377
  {15,  1}, // #4378
  {18,  1}, // #4379
  {20,  1}, // #4380
  {21,  1}, // #4381
  {22,  1}, // #4382
  { 1,  2}, // #4383
  { 4,  1}, // #4384
  { 1,  1}, // #4385
  {11,  1}, // #4386
  {12,  1}, // #4387
  {16,  1}, // #4388
  {17,  1}, // #4389
  {18,  1}, // #4390
  {22,  1}, // #4391
  { 1,  1}, // #4392
  {11,  1}, // #4393
  {16,  1}, // #4394
  {22,  1}, // #4395
  { 4,  4}, // #4396
  { 1,  1}, // #4397
  {11,  1}, // #4398
  {15,  1}, // #4399
  {18,  1}, // #4400
  {20,  1}, // #4401
  {21,  1}, // #4402
  {22,  1}, // #4403
  { 1,  1}, // #4404
  {11,  2}, // #4405
  {18,  2}, // #4406
  {22,  2}, // #4407
  { 1,  1}, // #4408
  {11,  2}, // #4409
  {15,  2}, // #4410
  {18,  2}, // #4411
  {20,  2}, // #4412
  {21,  2}, // #4413
  {22,  2}, // #4414
  { 1,  1}, // #4415
  { 4,  1}, // #4416
  { 7,  1}, // #4417
  {10, 17}, // #4418
  { 1,  1}, // #4419
  { 4,  1}, // #4420
  { 7,  1}, // #4421
  {10, 25}, // #4422
  { 1,  1}, // #4423
  { 4,  1}, // #4424
  { 7,  1}, // #4425
  {10, 41}, // #4426
  { 1,  1}, // #4427
  { 4,  1}, // #4428
  { 7,  1}, // #4429
  {10, 15}, // #4430
  { 1,  1}, // #4431
  {11,  5}, // #4432
  {14,  3}, // #4433
  {17,  3}, // #4434
  {19,  5}, // #4435
  {21,  3}, // #4436
  {11,  3}, // #4437
  {14,  2}, // #4438
  {17,  2}, // #4439
  {19,  3}, // #4440
  {21,  2}, // #4441
  { 1,  1}, // #4442
  { 4,  1}, // #4443
  { 6,  1}, // #4444
  {23,  1}, // #4445
  { 1,  1}, // #4446
  {11,  1}, // #4447
  {19,  1}, // #4448
  { 1,  1}, // #4449
  {11,  1}, // #4450
  {20,  1}, // #4451
  {22,  1}, // #4452
  {11,  1}, // #4453
  {14,  1}, // #4454
  {17,  1}, // #4455
  {19,  1}, // #4456
  {21,  1}, // #4457
  { 1,  1}, // #4458
  {11,  1}, // #4459
  {14,  1}, // #4460
  {17,  1}, // #4461
  {19,  1}, // #4462
  {21,  1}, // #4463
  { 1,  1}, // #4464
  { 4,  2}, // #4465
  { 6,  2}, // #4466
  {23,  2}, // #4467
  { 1,  1}, // #4468
  {11,  2}, // #4469
  {19,  2}, // #4470
  { 1,  1}, // #4471
  {11,  2}, // #4472
  {17,  2}, // #4473
  { 1,  1}, // #4474
  {11, 20}, // #4475
  {15, 20}, // #4476
  {18, 20}, // #4477
  {20, 20}, // #4478
  {21, 20}, // #4479
  {22, 20}, // #4480
  { 1,  1}, // #4481
  {11,  1}, // #4482
  {18,  1}, // #4483
  {22,  1}, // #4484
  { 1,  1}, // #4485
  {11, 22}, // #4486
  {15, 22}, // #4487
  {18, 22}, // #4488
  {20, 22}, // #4489
  {21, 22}, // #4490
  {22, 22}, // #4491
  {11, 15}, // #4492
  {15, 15}, // #4493
  {18, 15}, // #4494
  {20, 15}, // #4495
  {21, 15}, // #4496
  {22, 15}, // #4497
  { 1,  1}, // #4498
  {11, 19}, // #4499
  {15, 19}, // #4500
  {18, 19}, // #4501
  {20, 19}, // #4502
  {21, 19}, // #4503
  {22, 19}, // #4504
  {11, 12}, // #4505
  {15, 12}, // #4506
  {18, 12}, // #4507
  {20, 12}, // #4508
  {21, 12}, // #4509
  {22, 12}, // #4510
  { 1,  1}, // #4511
  {11,  2}, // #4512
  {16,  2}, // #4513
  {22,  2}, // #4514
  { 1,  1}, // #4515
  {11,  3}, // #4516
  {16,  3}, // #4517
  {22,  3}, // #4518
  {11,  2}, // #4519
  {14,  2}, // #4520
  {17,  2}, // #4521
  {19,  2}, // #4522
  {21,  2}, // #4523
  { 1,  1}, // #4524
  {11,  2}, // #4525
  {12,  2}, // #4526
  {16,  2}, // #4527
  {17,  2}, // #4528
  {18,  2}, // #4529
  {22,  2}, // #4530
  { 1,  1}, // #4531
  {11, 40}, // #4532
  {15, 40}, // #4533
  {18, 40}, // #4534
  {20, 40}, // #4535
  {21, 40}, // #4536
  {22, 40}, // #4537
  { 1,  1}, // #4538
  {11, 28}, // #4539
  {15, 28}, // #4540
  {18, 28}, // #4541
  {20, 28}, // #4542
  {21, 28}, // #4543
  {22, 28}, // #4544
  {11,  1}, // #4545
  {21,  1}, // #4546
  { 1,  1}, // #4547
  {11,  1}, // #4548
  {21,  1}, // #4549
  {11,  2}, // #4550
  {15,  1}, // #4551
  {18,  1}, // #4552
  {19,  1}, // #4553
  {20,  1}, // #4554
  {21,  1}, // #4555
  {22,  1}, // #4556
  { 1,  1}, // #4557
  {11,  2}, // #4558
  {15,  1}, // #4559
  {18,  1}, // #4560
  {19,  1}, // #4561
  {20,  1}, // #4562
  {21,  1}, // #4563
  {22,  1}, // #4564
  { 1,  1}, // #4565
  {11,  1}, // #4566
  {17,  1}, // #4567
  { 1,  5}, // #4568
  {11,  3}, // #4569
  {14,  2}, // #4570
  {17,  2}, // #4571
  {19,  3}, // #4572
  {21,  2}, // #4573
  { 1,  1}, // #4574
  {11,  2}, // #4575
  {22,  2}, // #4576
  { 1,  1}, // #4577
  {11,  2}, // #4578
  {14,  1}, // #4579
  {15,  1}, // #4580
  {17,  1}, // #4581
  {18,  1}, // #4582
  {19,  1}, // #4583
  {20,  1}, // #4584
  {21,  2}, // #4585
  {22,  1}, // #4586
  { 1,  1}, // #4587
  {11,  3}, // #4588
  {18,  3}, // #4589
  {22,  3}, // #4590
  {11,  2}, // #4591
  {15,  1}, // #4592
  {18,  1}, // #4593
  {20,  1}, // #4594
  {21,  1}, // #4595
  {22,  2}, // #4596
  { 1,  1}, // #4597
  {11,  2}, // #4598
  {13,  2}, // #4599
  {16,  2}, // #4600
  {19,  2}, // #4601
  {20,  2}, // #4602
  {22,  2}, // #4603
  { 4,  1}, // #4604
  { 6,  1}, // #4605
  {23,  2}, // #4606
  { 1,  1}, // #4607
  { 4,  1}, // #4608
  { 9,  1}, // #4609
  {11,  1}, // #4610
  {22,  1}, // #4611
  { 1,  1}, // #4612
  {11,  1}, // #4613
  {22,  1}, // #4614
  {11,  2}, // #4615
  {14,  1}, // #4616
  {17,  1}, // #4617
  {19,  2}, // #4618
  {21,  1}, // #4619
  {11,  2}, // #4620
  {13,  1}, // #4621
  {16,  1}, // #4622
  {18,  1}, // #4623
  {19,  1}, // #4624
  {20,  1}, // #4625
  {22,  2}, // #4626
  {11,  1}, // #4627
  {13,  1}, // #4628
  {16,  1}, // #4629
  {19,  1}, // #4630
  {20,  1}, // #4631
  {22,  1}, // #4632
  { 1,  1}, // #4633
  {11,  1}, // #4634
  {13,  1}, // #4635
  {16,  1}, // #4636
  {19,  1}, // #4637
  {20,  1}, // #4638
  {22,  1} // #4639
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteZero_WriteVecALU_WriteCMPXCHGRMW_WriteJumpLd_WriteALU_WriteMove_WriteFStoreX_WriteFLoadX_WriteFSign_WriteADC_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP32_WriteBSWAP64_WriteBitTestImmLd_WriteBitTestSet_WriteLoad_WriteCMOV2Ld_WriteCMOVLd_WriteNop_WriteVecExtractSt_WriteVecALUX_WriteVecALUXLd_WriteFShuffleLd_WriteStore_WriteVecLogicX_WriteShuffle_WriteVecLoadX_WriteFLD0_WriteLEA_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecMoveX_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftImm_WriteFMoveX_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteVecShiftImmX_WriteVecTestLd_WriteRotate_WriteRotateCL_WriteRMW_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecMaskedStore_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteFCom_WriteSETCCStore_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVecTestY_WriteFTestY_WriteXCHG_PdWriteTST_F_UCOM_FPPr_PdWriteSETGEmSETGmSETLEmSETLm_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_WriteFBlend_WriteBLS_WriteFLDC_WriteLAHFSAHF_WriteFLD1_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteBlend_WriteVarShuffleX_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_WriteFStoreNTY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarShuffleY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePHAddX_WritePOPCNT_WriteVecShiftX_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFShuffleZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShift_WriteVarVecShiftY_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup10_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup10_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_WriteFVarBlend_WriteVarBlend_WriteSHDrrcl_WriteSHDrri_WriteFMaskedStoreY_WritePHAddY_WriteVecMaskedStoreY_WriteVecShiftY_SKLWriteResGroup9_SKLWriteResGroup10_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendY_WriteVarBlendY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWritePShift_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteFPU12m_ZnWriteCALLr_ZnXADD_ZnWriteFPU12Y_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr
  {100,  0}, // #2 WriteSystem_WriteMicrocoded_ZnWriteMicrocoded_WriteFShuffle256_WriteFVarShuffle256
  { 7,  0}, // #3 WriteFAdd64XLd_WriteFCmp64XLd_WriteCvtI2PD_WriteCvtI2PSLd_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2ILd_WriteCvtPS2PD_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_WritePHAddY_AtomWrite01_7_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteRMW_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCRC32Ld_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteVBROADCASTF128_PdWriteVEXTRACTF128mr_PdWriteRCL32rCLRCL64rCL_PdWriteRCR64rCL_PdWriteRCR32rCL_PdWriteRCR32riRCR64ri_WriteAESDecEnc_WriteBEXTRLd_WriteCMOV2Ld_WriteLDMXCSR_WriteMPSAD_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecInsert_WriteVecIMulLd_WritePSADBWLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFVarShuffleLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComLd_WriteCvtPH2PSY_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteVarVecShiftLd_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup100_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup93_SKXWriteResGroup90_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_WriteADCLd_WriteCMOVLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WritePMULLDLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtPS2IYLd_WritePSADBWYLd_WriteVecIMulYLd_WritePMULLDYLd_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup95_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteResGroup89_SKLWriteResGroup86_WriteBSRLd
  { 6,  0}, // #4 WriteFAdd64X_WriteFCmp64X_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteFComLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteLZCNTLd_WriteVecInsertLd_WritePCmpIStrM_WriteStore_WriteVecTestLd_WriteTZCNTLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStoreY_WriteFMaskedLoadY_WriteVecMaskedStoreY_WriteVecMaskedLoadY_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteVBROADCASTYLd_PdWriteXADDm_WriteMMX_CVTPD2PIirrMMX_CVTPI2PDirr_PdWriteFCOMPm_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIirr_WriteJumpLd_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteFRnd_WriteSHDrrcl_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_BWWriteResGroup60_WriteCRC32Ld_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WritePHAddLd_WritePHAddXLd_WriteVecShiftXLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteCvtPD2IY_WriteCvtPD2PSY_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup82_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup11_HWWriteResGroup13_HWWriteResGroup16_HWWriteResGroup102_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteDPPDLd_WriteDPPSLd_WriteFHAddLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WritePOPCNTLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteDPPSYLd_WriteFRndYLd_WriteFHAddYLd_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup70_SKLWriteResGroup78_SKLWriteResGroup69_ZnWriteALULat2Ld_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r
  { 5,  0}, // #5 WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteEMMS_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteLoad_WriteCMOV2Ld_WriteCMOVLd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAY_WriteFMAX_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteCRC32r32r16_WriteCMPXCHG_WriteFHAdd_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteVecIMulY_WriteFHAddY_WriteFMaskedStoreY_WriteVecMaskedStoreY_BWWriteResGroup49_BWWriteResGroup54_BWWriteResGroup57_BWWriteResGroup47_BWWriteResGroup50_BWWriteResGroup51_BWWriteResGroup55_WriteRMW_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_SKXWriteResGroup61_SKXWriteResGroup58_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteCvtSD2I_WriteCvtI2SS_WriteCvtSS2I_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteVecIMulZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup31_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWriteResGroup30_HWWriteResGroup0_2_HWWriteResGroup99_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup93_HWWriteResGroup94_HWWriteResGroup100_SKLWriteResGroup60_SKLWriteResGroup58_SKLWriteResGroup65_SKLWriteResGroup59_SKLWriteResGroup61_SKLWriteResGroup63_WriteBEXTRLd_WriteCvtI2PD_WriteCvtI2PS_WriteCvtPD2I_WriteCvtPS2I_WriteCvtI2SD_WritePOPCNTLd_ZnWriteRSQRTSSr_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPD2IY_ZnWriteCVTPD2PSYr_WriteCvtPS2IY_ZnWriteRSQRTPSYr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteCVTPD2DQr_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWriteCVSTSI2SIr_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWritePop16r
  {16,  0}, // #6 WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_SKLWriteResGroup177_SKLWriteResGroup178
  { 9,  0}, // #7 WriteBitTestRegLd_WriteFCMOV_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_WriteFHAddYLd_AtomWrite01_9_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteIMul16ImmLd_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteRCR16rCL_WriteCvtI2PDLd_WriteDPPD_WriteIMul16Ld_WriteIMul32Ld_WriteIMul64Ld_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtI2PDYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVarVecShiftYLd_BWWriteResGroup101_BWWriteResGroup105_BWWriteResGroup112_BWWriteResGroup106_BWWriteResGroup107_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WritePHAddXLd_WriteVecTestLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVarBlendZLd_WriteVecMaskedLoadY_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup93_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup76_HWWriteResGroup52_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_ZnWriteMul64Ld_WriteStore_WriteVecShiftYLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteFPU013LdY_ZnWriteSHA1MSG1Ld
  { 2,  0}, // #8 AtomWrite01_2_WriteLAHFSAHF_WriteVecShift_WriteStore_WriteVecShiftX_WriteSETCCStore_WriteSHDrrcl_WriteSHDrri_WriteXCHG_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBLS_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecMoveX_WriteVecStoreNT_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WritePHAddX_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteXADD_PdWriteVEXTRACTF128rr_PdWriteBMI1_PdWriteXCHG16rr_WriteSAHF_PdWriteMOVHPm_WriteBSWAP64_WriteCMOV2_WriteVecExtractSt_WriteVecTest_WriteRotate_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup15_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteCvtPS2PD_WriteVecIMul_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WriteVecIMulX_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFVarShuffle_WriteFRcpY_WriteFRsqrtY_JWriteINSERTQ_JWrite3OpsLEA_WriteFCom_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStoreY_WriteVarBlendZ_WriteVecMaskedStoreY_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup15_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup29_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup9_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup31_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup15_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_ZnWriteALULat2_WriteShuffle256_WriteVarShuffle256_WriteVecShiftY_ZnWriteEXTRACTPSr_ZnWriteFPU013Y_ZnWritePShiftY_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r
  {11,  0}, // #9 AtomWrite01_11_WriteFHAdd_WritePCmpIStrMLd_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_WriteFDivX_BWWriteResGroup122_1_WritePCmpIStrI_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WritePSADBWYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup128_BWWriteResGroup131_BWWriteResGroup132_WriteDPPS_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtSD2ILd_WriteCvtSS2ILd_SKXWriteResGroup159_WriteFMAZLd_WriteFAdd64YLd_WriteFAdd64ZLd_WriteFAddYLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFDivY_WriteVecIMulZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup161_SKXWriteResGroup166_SKXWriteResGroup164_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup163_SKXWriteResGroup167_WriteFHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrMLd_WritePHMINPOSLd_WriteVecIMulXLd_WritePMULLDLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPD2IZLd_WriteCvtPD2PSZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFMAXLd_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_SKLWriteResGroup145_SKLWriteResGroup156_SKLWriteResGroup151_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup147_SKLWriteResGroup152_SKLWriteResGroup150_SKLWriteResGroup154_SKLWriteResGroup155_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld
  {15,  0}, // #10 WriteCMPXCHG_WriteSTMXCSR_WriteDiv16_WriteDPPD_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteDPPDLd_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64X_WriteFDivX_ZnWriteVDIVPDY
  { 8,  0}, // #11 WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_WriteFHAddY_WritePHAddYLd_AtomWrite01_8_WriteBSRLd_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WriteVarShuffleLd_WriteVecShiftLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPD2PSY_WriteCvtPH2PSY_WriteCvtPS2PDY_WriteCvtPS2PHY_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteVarVecShiftLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteBSFLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteCRC32Ld_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WriteIMul16ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteLZCNTLd_WritePHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WriteTZCNTLd_WriteFVarBlendYLd_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup91_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup92_WriteAESDecEncLd_WriteCvtI2PSLd_WriteFHAddLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_WriteFHAddYLd_WriteFTestLd_SKXWriteResGroup130_WriteAESIMC_WriteFVarBlendLd_WritePSADBWLd_WriteVarBlendLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2IZLd_WriteCvtPD2PSZLd_WriteCvtPS2IZLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteAESKeyGenLd_WriteCMOV2Ld_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_WriteAESIMCLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteFLoadX_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteLoad_WriteVecALUXLd_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteFShuffleLd_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVecLoadNT_WriteFStoreNT_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVecLoadY_WriteVecLoadNTY_WriteVecShiftImmXLd_WriteVecTestYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU12Ym_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteMulX32Ld_ZnWriteMulX64Ld_ZnWriteFPU013Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd
  {50,  0}, // #12 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #13 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #14 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #15 WriteFDiv64XLd_WriteFSqrt64XLd
  {70,  0}, // #16 WriteFDivXLd_WriteFSqrtXLd
  {34,  0}, // #17 WriteFDivLd_WriteFSqrtLd_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166_WriteFDiv64
  {62,  0}, // #18 WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SKLWriteResGroup217
  {10,  0}, // #19 AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAddLd_WriteMMXMOVMSK_WriteFMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAYLd_WriteFMAXLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZ_PdWriteVFRCZY_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteCLMulLd_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WritePMULLDY_WriteVecTestYLd_BWWriteResGroup120_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteEMMS_WriteMPSADLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WritePHAddYLd_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup149_SKXWriteResGroup153_SKXWriteResGroup154_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_HWWriteResGroup97_HWWriteResGroup77_HWWriteResGroup78_WriteBSF_WriteBSR_WriteMPSADYLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup134_SKLWriteResGroup138_SKLWriteResGroup139_SKLWriteResGroup140_WriteFCmp64Ld_WriteFCmpLd_WriteFComLd_WriteCRC32Ld_ZnWriteCVTPS2PDLd
  {12,  0}, // #20 WriteIMul64Ld_WriteIMul64RegLd_WriteDiv8_WriteIDiv8_WriteCLMul_PdWriteRCL8rCL_PdWriteRCR8ri_WriteAESDecEncLd_WriteMPSADLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WritePCmpIStrILd_WriteDPPSY_WriteFHAddLd_WriteCLMulLd_WriteFSqrtX_WriteFSqrtY_SKXWriteResGroup179_SKXWriteResGroup200_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteVecIMulYLd_WriteVecIMulZLd_WriteFHAddYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteSHDmrcl_WriteFMAZLd_WriteFMAYLd_HWWriteResGroup91_3_HWWriteResGroup104_SKLWriteResGroup160_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPD2ILd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_ZnWriteRSQRTSSLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_ZnWriteVDIVPSYr_WriteFMAXLd_WriteFRcpYLd_ZnWriteRSQRTPSYLd_ZnWriteFIST_ZnWriteCVTPD2DQLd_ZnWriteCVSTSI2SILd_ZnWriteFPU03
  {14,  0}, // #21 WriteIMul64ImmLd_AtomWrite01_14_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpIStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_WriteDPPS_WriteDPPSY_BWWriteResGroup146_BWWriteResGroup145_BWWriteResGroup141_BWWriteResGroup144_WriteCvtI2SDLd_WriteCvtI2SSLd_WritePCmpEStrI_WritePCmpEStrM_WriteAESIMCLd_SKXWriteResGroup184_WriteFRndLd_SKXWriteResGroup184_1_SKXWriteResGroup190_SKXWriteResGroup187_SKXWriteResGroup188_SKXWriteResGroup189_WriteCLMulLd_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_SKLWriteResGroup166_SKLWriteResGroup166_1_SKLWriteResGroup170_SKLWriteResGroup169
  { 3,  0}, // #22 WriteVecMoveToGpr_WritePHAdd_WriteMMXMOVMSK_WriteVecShiftLd_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftXLd_AtomWrite01_3_WriteCMPXCHGRMW_WriteBSF_WriteCRC32_WriteFLDC_WriteFLD0_WriteFLD1_WriteVarShuffle_WriteFStoreNTX_WriteVarShuffleX_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteEXTRQ_PdWriteINSERTQ_PdWriteSHLD32rri8SHRD16rri8_WriteFAdd64X_WriteFAddX_WriteBSR_WriteFCMOV_WriteFCmp64X_WriteFCmpX_WriteFCom_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteCvtSS2I_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLZCNT_WriteFMul64X_WriteFMulX_WritePHAddX_WritePOPCNT_WriteRotateCL_WriteShiftCL_WriteSHDrri_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteShuffle256_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteVarShuffle256_WriteCvtPD2IY_WriteCvtPD2PSY_WriteCvtPS2IY_WriteCvtPS2PDY_WriteFMul64Y_WriteFMulY_WriteFVarShuffle256_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup27_BWWriteResGroup34_BWWriteResGroup35_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup28_BWWriteResGroup33_WriteAESDecEnc_WriteCvtI2PD_WriteCvtI2PS_WriteVecExtractSt_WriteFHAdd_WriteIMul16Imm_WriteMPSAD_WriteVecTest_WriteFRnd_WriteFVarBlendY_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPH2PSY_WriteCvtPS2PH_WriteFRndY_WriteFHAddY_WriteFTest_JSlowLEA16r_WritePSADBW_WritePSADBWX_WriteCvtPD2IZ_WriteCvtPD2PSZ_WriteCvtPS2IZ_WriteCvtPS2PDZ_WritePSADBWY_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup44_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup46_SKXWriteResGroup45_SKXWriteResGroup32_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup41_SKXWriteResGroup37_SKXWriteResGroup38_SKXWriteResGroup30_WriteVecALU_WriteCMOV2_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup26_2_SBWriteResGroup43_WriteVarVecShiftZ_HWWriteResGroup50_HWWriteResGroup58_HWWriteResGroup59_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup51_HWWriteResGroup57_WriteFLoadX_WriteFLoadY_WriteLoad_WriteDPPD_WriteDPPS_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteDPPSY_WriteVecLoadY_WriteFMaskedLoadY_WriteVecLoadNTY_WriteVecMaskedLoadY_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup42_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup44_SKLWriteResGroup43_SKLWriteResGroup30_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_WriteVecMoveFromGpr_ZnWriteVCVTPS2PDY_ZnWriteMulX32_ZnWriteMulX64
  { 4,  0}, // #23 WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteBSR_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16_WriteIMul16Reg_WriteIMul32_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePHMINPOS_WriteVecIMulX_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteSHDrrcl_WriteSHDrri_WriteCvtI2PSY_WriteCvtPS2IY_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_WriteMMX_CVTPI2PSirr_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_PdWriteVPERM2F128rr_JWriteVPMACS_WriteCvtI2PD_WriteIMul16Imm_WriteIMul64_WriteCvtI2PDY_WriteVecShiftY_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup39_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_BWWriteResGroup40_WriteCMPXCHGRMW_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBSF_WriteBitTestImmLd_WriteBitTestRegLd_WriteCMOV2Ld_WriteCMOVLd_WriteLZCNTLd_WriteVecMoveToGpr_WriteVecInsertLd_WriteFMul64X_WritePMULLD_WritePOPCNTLd_WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteFMul64Y_WriteFTestY_WriteFAdd64X_WriteFAddX_WriteAESDecEnc_WriteFCmp64X_WriteFCmpX_WriteMPSAD_WriteFMulX_WriteFRcpX_WriteFRsqrtX_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmp64Y_WriteFCmpY_WriteFCmpZ_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAY_WriteFMAX_WriteFMAZ_WriteVecIMulY_WriteVecIMulZ_WriteFCmp64Z_WriteMPSADY_WriteFMul64Z_WriteFMulY_WriteFMulZ_WriteVecShiftZ_WriteFRcpY_WriteFRcpZ_WriteFRsqrtY_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup50_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50z_SKXWriteResGroup51_WriteCvtPD2I_WriteCvtPD2PS_WritePCmpEStrILd_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPS2PHZSt_SBWriteResGroup29_2_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup70_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup71_HWWriteResGroup83_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteRMW_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteVecShiftLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePHAddXLd_WriteVecMOVMSK_WriteStore_WriteVarShuffleXLd_WriteVecShiftXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteCvtPS2PDY_WritePSADBWY_WriteVecALUYLd_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WritePHAddYLd_WriteVecMOVMSKY_WritePMULLDY_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarVecShiftLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup48_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteIMulH_WriteFMaskedStore_WriteVecMaskedStore_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r
  { 1,  0}, // #24 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd_WriteRMW
  { 1,  0}, // #25 WriteRMW
  {71,  0}, // #26 WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_WriteFSqrt64Y
  {13,  0}, // #27 AtomWrite01_13_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteVecMOVMSK_WriteCvtI2PDYLd_WriteCvtPD2IYLd_WriteCvtPD2PSYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PDYLd_PdWriteRCL8ri_WriteCVTSI642SDrr_PdWriteVPCLMULQDQrr_WriteMPSADYLd_WritePCmpIStrMLd_WriteDPPS_WriteDPPSY_WriteFHAddYLd_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteBSFLd_WriteBSRLd_SKLWriteResGroup162_SKLWriteResGroup163_ZnWriteSHA1RNDS4Ld
  {17,  0}, // #28 AtomWrite01_17_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_WriteDiv16_WriteIDiv16_WriteDPPSYLd_SKXWriteResGroup201_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_WritePCmpEStrMLd_SKLWriteResGroup179_SKLWriteResGroup180
  {18,  0}, // #29 AtomWrite01_18_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_WriteFSqrt64X_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_WriteFSqrt64Y_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroup205_WriteAESIMCLd_WriteDPPSLd_WriteFDivLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_SKLWriteResGroup185_SKLWriteResGroup184
  {20,  0}, // #30 AtomWrite01_20_WriteDPPDLd_WritePCmpEStrILd_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteDiv16Ld_WriteIDiv16Ld_WriteAESKeyGen_SKXWriteResGroup216_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroup214_SKXWriteResGroup218_WriteFDivXLd_WriteFDivLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteFDiv64X_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_SKLWriteResGroup190_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_WriteFSqrt64X_WriteFSqrt80
  {21,  0}, // #31 AtomWrite01_21_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_WriteFSqrtX_WriteFSqrt80_SKXWriteResGroup222_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WritePCmpEStrILd_SKLWriteResGroup195_WriteDiv16Ld_WriteIDiv16Ld
  {22,  0}, // #32 AtomWrite01_22_BWWriteResGroup172_BWWriteResGroup183_1_SKXWriteResGroup223_SKXWriteResGroup224_2_SKXWriteResGroup225_WriteFDiv64X_WriteDiv8_WriteFSqrt64XLd_HWWriteResGroup146_WriteFDivLd_SKLWriteResGroup196_SKLWriteResGroup196_1_WriteFDiv64XLd_WriteFDivXLd_WriteFDiv64Ld_ZnWriteVDIVPDYLd
  {23,  0}, // #33 AtomWrite01_23_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_BWWriteResGroup183_2_WriteFSqrt64Ld_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_HWWriteResGroup190_WriteFSqrtLd_SKLWriteResGroup198
  {25,  0}, // #34 AtomWrite01_25_WriteDPPS_PdWriteVDPPSrri_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_BWWriteResGroup183_4_WriteDiv32_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_WriteFSqrt64YLd_SKXWriteResGroup233_SKXWriteResGroup224_3_SKXWriteResGroup234_WriteDiv16_WriteDiv64_WriteFDiv64Ld_HWWriteResGroup187_HWWriteResGroup192_SKLWriteResGroup202_SKLWriteResGroup196_2
  {26,  0}, // #35 AtomWrite01_26_BWWriteResGroup180_BWWriteResGroup183_5_BWWriteResGroup183_6_WriteFSqrtXLd_WriteFSqrtLd_SKXWriteResGroup238_WriteFDiv64XLd_HWWriteResGroup184
  {29,  0}, // #36 AtomWrite01_29_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld
  {30,  0}, // #37 AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_SKXWriteResGroup245_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SKLWriteResGroup208
  {32,  0}, // #38 AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64Z
  {45,  0}, // #39 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_WriteDiv64Ld_WriteIDiv64Ld
  {46,  0}, // #40 AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {48,  0}, // #41 AtomWrite01_48
  {55,  0}, // #42 AtomWrite01_55
  {59,  0}, // #43 AtomWrite01_59_WriteFSqrt64YLd
  {63,  0}, // #44 AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {72,  0}, // #45 AtomWrite01_72_WriteFDiv64XLd_WriteFDiv64YLd
  {74,  0}, // #46 AtomWrite01_74_SKXWriteResGroup262_WriteFSqrt64XLd_WriteFSqrt64YLd
  {77,  0}, // #47 AtomWrite01_77
  {78,  0}, // #48 AtomWrite01_78
  {79,  0}, // #49 AtomWrite01_79
  {92,  0}, // #50 AtomWrite01_92
  {94,  0}, // #51 AtomWrite01_94
  {99,  0}, // #52 AtomWrite01_99
  {121,  0}, // #53 AtomWrite01_121
  {127,  0}, // #54 AtomWrite01_127
  {140,  0}, // #55 AtomWrite01_140_SKXWriteResGroup267
  {141,  0}, // #56 AtomWrite01_141
  {146,  0}, // #57 AtomWrite01_146
  {147,  0}, // #58 AtomWrite01_147
  {168,  0}, // #59 AtomWrite01_168
  {174,  0}, // #60 AtomWrite01_174
  {183,  0}, // #61 AtomWrite01_183
  {202,  0}, // #62 AtomWrite01_202
  {19,  0}, // #63 WriteDiv16Ld_WriteIDiv16Ld_WritePCmpIStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_WriteFDivX_WritePCmpEStrILd_WritePCmpEStrMLd_SKXWriteResGroup209_WriteFSqrtYLd_SKXWriteResGroup211_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SKLWriteResGroup186_WriteDiv8Ld_WriteIDiv8Ld_ZnWriteVDIVPSYLd
  { 5,  0}, // #64 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #65 WriteRMW
  {27,  0}, // #66 WriteDPPSY_WriteFSqrtYLd_BWWriteResGroup183_7_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_SKXWriteResGroup240_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_HWWriteResGroup188_HWWriteResGroup189_SKLWriteResGroup206_WriteFSqrtXLd_WriteFSqrtLd
  {90,  0}, // #67 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #68 PdWriteLARrr
  {33,  0}, // #69 WriteAESKeyGenLd
  {80,  0}, // #70 WriteDiv16_WriteDiv32_WriteDiv64
  {31,  0}, // #71 WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165
  {35,  0}, // #72 WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SKLWriteResGroup210_SKLWriteResGroup209_WriteFSqrtYLd
  { 9,  0}, // #73 WriteIMul32Ld_WriteIMul64Ld
  { 3,  0}, // #74 WriteIMulH
  { 4,  0}, // #75 WriteIMul32_WriteIMul64
  { 3,  0}, // #76 WriteIMulH
  {24,  0}, // #77 WritePCmpEStrMLd_BWWriteResGroup177_BWWriteResGroup183_3_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WritePCmpEStrILd_WriteFSqrt64XLd_WriteFSqrt80_HWWriteResGroup162_HWWriteResGroup185
  { 7,  0}, // #78 WriteRotateLd
  { 1,  0}, // #79 WriteRMW
  { 8,  0}, // #80 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #81 WriteRMW
  { 6,  0}, // #82 WriteShiftLd_WriteALULd_WriteIMul32Ld_WriteIMul64Ld
  { 1,  0}, // #83 WriteRMW_WriteIMulH
  {42,  0}, // #84 BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_WriteFDivXLd_WriteFDivYLd_SKLWriteResGroup214_SKLWriteResGroup215
  {75,  0}, // #85 BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SKLWriteResGroup220
  {60,  0}, // #86 BWWriteResGroup197
  {115,  0}, // #87 BWWriteResGroup202_HWWriteResGroup183
  {28,  0}, // #88 WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup186_HWWriteResGroup191
  {44,  0}, // #89 WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_WriteFSqrtXLd_WriteFSqrtYLd
  {41,  0}, // #90 WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_WriteFSqrtX_WriteFSqrtY_SKLWriteResGroup213
  { 6,  0}, // #91 WriteIMul32Ld_WriteIMul64
  { 6,  0}, // #92 WriteIMulH
  { 3,  0}, // #93 WriteIMul32
  { 6,  0}, // #94 WriteIMulH
  { 9,  0}, // #95 WriteIMul64Ld
  { 6,  0}, // #96 WriteIMulH
  {43,  0}, // #97 WriteFDiv64YLd_WriteFDivYLd
  {38,  0}, // #98 WriteFDiv64Y_WriteFDivY_WriteFSqrt64Ld
  {54,  0}, // #99 WriteFSqrt64Y
  {47,  0}, // #100 WriteFSqrtYLd_HWWriteFBLD_WriteFSqrt64YLd
  {76,  0}, // #101 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #102 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {39,  0}, // #103 WriteFSqrt64ZLd_WriteFDivX_WriteFDivY
  {37,  0}, // #104 SKXWriteResGroup250_SKXWriteResGroup249_WriteFDiv64Ld_SKLWriteResGroup211
  {40,  0}, // #105 SKXWriteResGroup252_WriteFSqrt80_SKLWriteResGroup212_WriteFSqrt64Y
  {106,  0}, // #106 SKXWriteResGroup266_SKLWriteResGroup223
  {67,  0}, // #107 SKXWriteResGroup261
  {52,  0}, // #108 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #109 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171
  {98,  0}, // #110 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #111 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #112 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #113 HWWriteResGroup177
  {69,  0}, // #114 WriteFDiv64X_WriteFDiv64Y
  { 3,  0}, // #115 WriteIMul32_WriteIMul64
  { 1,  0}, // #116 WriteIMulH
  { 8,  0}, // #117 ZnWriteMul32Ld
  { 4,  0}, // #118 WriteIMulH
  { 9,  0}, // #119 ZnWriteMul64Ld
  { 4,  0}, // #120 WriteIMulH
  { 4,  0}, // #121 ZnWriteMul64
  { 4,  0}, // #122 WriteIMulH
  {107,  0} // #123 WriteFShuffle256Ld_WriteFVarShuffle256Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  3}, // #1
  {5,  0,  3}, // #2
  {5,  0,  3}, // #3
  {6,  0,  3}, // #4
  {0,  0,  3}, // #5
  {6,  0,  3}, // #6
  {0,  0,  3}, // #7
  {1,  0,  3}, // #8
  {0,  0,  4}, // #9
  {0,  0,  5}, // #10
  {5,  0,  4}, // #11
  {5,  0,  4}, // #12
  {6,  0,  4}, // #13
  {0,  0,  5}, // #14
  {6,  0,  5}, // #15
  {0,  0,  5}, // #16
  {1,  0,  5}, // #17
  {5,  0,  5}, // #18
  {5,  0,  5}, // #19
  {6,  0,  5}, // #20
  {0,  0,  6}, // #21
  {0,  0,  6}, // #22
  {6,  0,  6}, // #23
  {0,  0,  6}, // #24
  {1,  0,  6}, // #25
  {0,  0,  7}, // #26
  {0,  0,  7}, // #27
  {6,  0,  7}, // #28
  {0,  0,  7}, // #29
  {1,  0,  7}, // #30
  {0,  0,  8}, // #31
  {0,  0,  8}, // #32
  {6,  0,  8}, // #33
  {0,  0,  8}, // #34
  {1,  0,  8} // #35
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false,  1, 1,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false,  2, 2,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        1, false, false,  4, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false,  1, 1,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false,  4, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false,  1, 1,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false,  6, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false,  6, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false,  1, 1,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false,  4, 2,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false,  1, 1,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        1, false, false,  6, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #17
  {DBGFIELD("WriteALURMW")        1, false, false,  6, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false,  9, 1,  4, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 10, 2,  5, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 10, 2,  5, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 10, 2,  5, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        1, false, false, 10, 2,  5, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #29
  {DBGFIELD("WriteAESDecEnc")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false,  1, 1,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteBEXTR")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         1, false, false,  6, 2,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteFBlend")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteFVarBlend")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD("WriteBLSLd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteBLS")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteBSFLd")         1, false, false, 12, 1,  6, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSF")           1, false, false, 12, 1,  6, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSRLd")         1, false, false, 12, 1,  6, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSR")           1, false, false, 12, 1,  6, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSWAP32")       1, false, false,  6, 2,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP64")       1, false, false,  6, 2,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBitTestImmLd")  1, false, false,  6, 2,  1, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, 13, 1,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTest")       1, false, false,  4, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false,  3, 1,  8, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, 14, 1,  9, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSet")    1, false, false,  4, 2,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #59
  {DBGFIELD("WriteBZHI")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #60
  {DBGFIELD("WriteLoad")          1, false, false,  6, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #62
  {DBGFIELD("WriteCMOV2")         1, false, false,  1, 1,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #64
  {DBGFIELD("WriteCMOV")          1, false, false,  1, 1,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteFCMOV")         1, false, false, 13, 1,  7, 1,  0, 0}, // #66
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  2, 1}, // #67
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #68
  {DBGFIELD("WriteFCmp64X")       1, false, false,  9, 1,  4, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #70
  {DBGFIELD("WriteFCmpX")         1, false, false, 10, 2,  5, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #72
  {DBGFIELD("WriteFCmp64")        1, false, false, 10, 2,  5, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #74
  {DBGFIELD("WriteFCmp")          1, false, false, 10, 2,  5, 1,  0, 0}, // #75
  {DBGFIELD("WriteCMPXCHG")       1, false, false, 15, 1, 10, 1,  0, 0}, // #76
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #77
  {DBGFIELD("WriteFCom")          1, false, false, 10, 2,  5, 1,  0, 0}, // #78
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #79
  {DBGFIELD("WriteCRC32")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #80
  {DBGFIELD("WriteNop")           1, false, false,  1, 1,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PDLd")     1, false, false, 16, 1, 11, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PD")       1, false, false,  8, 1,  3, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false,  8, 1,  3, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PS")       1, false, false,  9, 1,  4, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2ILd")     1, false, false, 16, 1, 11, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2I")       1, false, false,  8, 1,  3, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PSLd")    1, false, false, 16, 1, 11, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2PS")      1, false, false,  8, 1,  3, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false,  8, 1,  3, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2I")       1, false, false,  9, 1,  4, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PDLd")    1, false, false, 16, 1, 11, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2PD")      1, false, false,  8, 1,  3, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2ILd")     1, false, false, 13, 1,  7, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 16, 1, 11, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false,  8, 1,  3, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #97
  {DBGFIELD("WriteCvtSD2SS")      1, false, false,  9, 1,  4, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd")     1, false, false,  8, 1,  3, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #100
  {DBGFIELD("WriteCvtI2SD")       1, false, false,  9, 1,  4, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false,  8, 1,  3, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #103
  {DBGFIELD("WriteCvtI2SS")       1, false, false,  9, 1,  4, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false,  8, 1,  3, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #106
  {DBGFIELD("WriteCvtSS2SD")      1, false, false,  9, 1,  4, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtSS2ILd")     1, false, false, 13, 1,  7, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 16, 1, 11, 1,  0, 0}, // #109
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 17, 1, 12, 1,  3, 2}, // #110
  {DBGFIELD("WriteDiv16")         1, false, false, 17, 1, 12, 1,  0, 0}, // #111
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 17, 1, 12, 1,  3, 2}, // #112
  {DBGFIELD("WriteDiv32")         1, false, false, 17, 1, 12, 1,  0, 0}, // #113
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 18, 1, 13, 1,  3, 2}, // #114
  {DBGFIELD("WriteDiv64")         1, false, false, 18, 1, 13, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 19, 1, 14, 1,  3, 2}, // #116
  {DBGFIELD("WriteDiv8")          1, false, false, 17, 1, 12, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, 20, 1, 15, 1,  1, 1}, // #118
  {DBGFIELD("WriteFDiv64X")       1, false, false, 20, 1, 15, 1,  0, 0}, // #119
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, 21, 1, 16, 1,  1, 1}, // #120
  {DBGFIELD("WriteFDivX")         1, false, false, 21, 1, 16, 1,  0, 0}, // #121
  {DBGFIELD("WriteFDivLd")        1, false, false, 22, 1, 17, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv")          1, false, false, 22, 1, 17, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, 23, 1, 18, 1,  1, 1}, // #124
  {DBGFIELD("WriteFDiv64")        1, false, false, 23, 1, 18, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, 22, 1, 17, 1,  1, 1}, // #126
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #127
  {DBGFIELD("WriteDPPD")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #128
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #129
  {DBGFIELD("WriteDPPS")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #130
  {DBGFIELD("WriteVecExtractSt")  1, false, false,  6, 2,  1, 1,  0, 0}, // #131
  {DBGFIELD("WriteVecExtract")    1, false, false,  6, 2,  1, 1,  0, 0}, // #132
  {DBGFIELD("WriteVecALUX")       1, false, false,  1, 1,  1, 1,  0, 0}, // #133
  {DBGFIELD("WriteFComLd")        1, false, false, 10, 2,  5, 1,  0, 0}, // #134
  {DBGFIELD("WriteEMMS")          1, false, false, 11, 1,  5, 1,  0, 0}, // #135
  {DBGFIELD("WriteFLDC")          1, false, false, 24, 1, 19, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #137
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 1, false, false, 13, 1,  7, 1,  1, 1}, // #138
  {DBGFIELD("WriteFHAdd")         1, false, false, 16, 1, 11, 1,  0, 0}, // #139
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 18, 1,  3, 2}, // #140
  {DBGFIELD("WriteIDiv16")        1, false, false, 23, 1, 18, 1,  0, 0}, // #141
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 18, 1,  3, 2}, // #142
  {DBGFIELD("WriteIDiv32")        1, false, false, 23, 1, 18, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 18, 1, 13, 1,  3, 2}, // #144
  {DBGFIELD("WriteIDiv64")        1, false, false, 18, 1, 13, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 23, 1, 18, 1,  3, 2}, // #146
  {DBGFIELD("WriteIDiv8")         1, false, false, 23, 1, 18, 1,  0, 0}, // #147
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 16, 1, 11, 1,  3, 2}, // #148
  {DBGFIELD("WriteIMul16")        1, false, false,  8, 1,  3, 1,  0, 0}, // #149
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #150
  {DBGFIELD("WriteIMul16ImmLd")   1, false, false,  8, 1,  3, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Reg")     1, false, false,  9, 1,  4, 1,  0, 0}, // #152
  {DBGFIELD("WriteIMul16Imm")     1, false, false,  9, 1,  4, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false,  8, 1,  3, 1,  3, 2}, // #154
  {DBGFIELD("WriteIMul32")        1, false, false,  9, 1,  4, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #156
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, 10, 2,  5, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 10, 2,  5, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 10, 2,  5, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 25, 1, 20, 1,  3, 2}, // #160
  {DBGFIELD("WriteIMul64")        1, false, false, 25, 1, 20, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, 25, 1, 20, 1,  1, 1}, // #162
  {DBGFIELD("WriteIMul64ImmLd")   1, false, false, 26, 1, 21, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 25, 1, 20, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 26, 1, 21, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false,  8, 1,  3, 1,  3, 2}, // #166
  {DBGFIELD("WriteIMul8")         1, false, false,  8, 1,  3, 1,  0, 0}, // #167
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #168
  {DBGFIELD("WriteFShuffle")      1, false, false,  6, 2,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteStore")         1, false, false,  6, 2,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteVecLogicX")     1, false, false,  1, 1,  1, 1,  0, 0}, // #171
  {DBGFIELD("WriteShuffle")       1, false, false,  6, 2,  1, 1,  0, 0}, // #172
  {DBGFIELD("WriteLAHFSAHF")      1, false, false,  3, 1,  8, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLoadX")      1, false, false,  6, 2,  1, 1,  0, 0}, // #174
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 11, 1,  5, 1,  0, 0}, // #175
  {DBGFIELD("WriteFLD0")          1, false, false,  1, 1,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteFLD1")          1, false, false,  9, 1,  4, 1,  0, 0}, // #177
  {DBGFIELD("WriteLEA")           1, false, false,  4, 2,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteFence")         1, false, false,  6, 2,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLZCNTLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #180
  {DBGFIELD("WriteLZCNT")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #181
  {DBGFIELD("WriteVecStoreX")     1, false, false,  6, 2,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecStore")      1, false, false,  6, 2,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 27, 2, 22, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoad")       1, false, false,  6, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveX")      1, false, false,  1, 1,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreNT")    1, false, false,  6, 2,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMove")       1, false, false,  6, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecALULd")      1, false, false,  6, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #191
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #192
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #193
  {DBGFIELD("WriteVecLogic")      1, false, false,  1, 1,  1, 1,  0, 0}, // #194
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 1, false, false, 29, 1, 23, 1,  1, 1}, // #195
  {DBGFIELD("WritePHAdd")         1, false, false, 28, 1, 22, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #197
  {DBGFIELD("WriteVecInsert")     1, false, false,  6, 2,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #199
  {DBGFIELD("WriteVecIMul")       1, false, false, 30, 2, 23, 1,  0, 0}, // #200
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 27, 2, 22, 1,  0, 0}, // #201
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, 29, 1, 23, 1,  1, 1}, // #202
  {DBGFIELD("WritePSADBW")        1, false, false, 29, 1, 23, 1,  0, 0}, // #203
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #204
  {DBGFIELD("WriteVarShuffle")    1, false, false,  6, 2,  1, 1,  0, 0}, // #205
  {DBGFIELD("WriteShuffleLd")     1, false, false,  6, 2,  1, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecShiftImm")   1, false, false,  1, 1,  1, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, 28, 1, 22, 1,  1, 1}, // #208
  {DBGFIELD("WriteVecShift")      1, false, false,  3, 1,  8, 1,  0, 0}, // #209
  {DBGFIELD("WriteFMoveX")        1, false, false,  1, 1,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteFShuffleLd")    1, false, false,  6, 2,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteFStore")        1, false, false,  6, 2,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 27, 2, 22, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecLoadNT")     1, false, false,  6, 2,  1, 1,  0, 0}, // #214
  {DBGFIELD("WriteStoreNT")       1, false, false,  6, 2,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFStoreNTX")     1, false, false,  6, 2,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFStoreNT")      1, false, false,  6, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFLoad")         1, false, false,  6, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #219
  {DBGFIELD("WriteMPSAD")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #220
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, 24, 1, 19, 1,  1, 1}, // #221
  {DBGFIELD("WriteFMul64X")       1, false, false, 13, 1,  7, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #223
  {DBGFIELD("WriteFMulX")         1, false, false, 10, 2,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #225
  {DBGFIELD("WriteFMul64")        1, false, false, 10, 2,  5, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #227
  {DBGFIELD("WriteFMul")          1, false, false, 30, 2, 23, 1,  0, 0}, // #228
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #229
  {DBGFIELD("WriteIMul32_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #231
  {DBGFIELD("WriteIMul64_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd")        1, false, false, 30, 2, 23, 1,  0, 0}, // #233
  {DBGFIELD("WriteVecALUXLd")     1, false, false,  6, 2,  1, 1,  0, 0}, // #234
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #235
  {DBGFIELD("WriteShuffleX")      1, false, false,  6, 2,  1, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #237
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteVarBlend")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteBlend")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteCLMul")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("WritePCmpEStrI")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("WritePCmpEStrM")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #247
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #248
  {DBGFIELD("WritePCmpIStrI")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #249
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("WritePCmpIStrM")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #252
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, 16, 1, 11, 1,  1, 1}, // #253
  {DBGFIELD("WritePHAddX")        1, false, false,  8, 1,  3, 1,  0, 0}, // #254
  {DBGFIELD("WritePHMINPOSLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WritePHMINPOS")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false,  8, 1,  3, 1,  1, 1}, // #257
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #258
  {DBGFIELD("WriteVecIMulX")      1, false, false, 10, 2,  5, 1,  0, 0}, // #259
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 27, 2, 22, 1,  0, 0}, // #260
  {DBGFIELD("WriteShuffleXLd")    1, false, false,  6, 2,  1, 1,  0, 0}, // #261
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("WritePMULLD")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #263
  {DBGFIELD("WriteCopy")          2, false, false, 32, 2,  8, 1,  0, 0}, // #264
  {DBGFIELD("WritePOPCNTLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WritePOPCNT")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #267
  {DBGFIELD("WritePSADBWX")       1, false, false, 10, 2,  5, 1,  0, 0}, // #268
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, 11, 1,  5, 1,  1, 1}, // #269
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 29, 1, 23, 1,  0, 0}, // #270
  {DBGFIELD("WriteVecShiftImmX")  1, false, false,  1, 1,  1, 1,  0, 0}, // #271
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, 28, 1, 22, 1,  1, 1}, // #272
  {DBGFIELD("WriteVecShiftX")     1, false, false,  3, 1,  8, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #274
  {DBGFIELD("WriteVecTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #275
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #276
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #277
  {DBGFIELD("WriteRotate")        1, false, false,  6, 2,  1, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateCL")      1, false, false,  6, 2,  1, 1,  0, 0}, // #279
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 24, 1, 19, 1,  0, 0}, // #280
  {DBGFIELD("WriteFRcpX")         1, false, false, 13, 1,  7, 1,  0, 0}, // #281
  {DBGFIELD("WriteFRcpLd")        1, false, false, 30, 2, 23, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #283
  {DBGFIELD("WriteFRcp")          1, false, false, 30, 2, 23, 1,  0, 0}, // #284
  {DBGFIELD("WriteRMW")           1, false, false,  6, 2,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteShiftLd")       1, false, false,  6, 2,  1, 1,  0, 0}, // #286
  {DBGFIELD("WriteShift")         1, false, false,  6, 2,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteFRndLd")        1, false, false, 10, 2,  5, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRnd")          1, false, false, 10, 2,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, 10, 2,  5, 1,  1, 1}, // #290
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 24, 1, 19, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 13, 1,  7, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, 30, 2, 23, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, 30, 2, 23, 1,  1, 1}, // #294
  {DBGFIELD("WriteFRsqrt")        1, false, false, 30, 2, 23, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #296
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #297
  {DBGFIELD("WriteShiftCL")       1, false, false,  6, 2,  1, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false,  6, 2,  1, 1,  2, 1}, // #299
  {DBGFIELD("WriteSETCCStore")    1, false, false,  3, 1,  8, 1,  0, 0}, // #300
  {DBGFIELD("WriteSETCC")         1, false, false,  1, 1,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteSHDmrcl")       1, false, false, 29, 1, 23, 1,  0, 0}, // #302
  {DBGFIELD("WriteSHDmri")        1, false, false, 29, 1, 23, 1,  0, 0}, // #303
  {DBGFIELD("WriteSHDrrcl")       1, false, false,  3, 1,  8, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDrri")        1, false, false,  3, 1,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 20, 1, 15, 1,  0, 0}, // #306
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 20, 1, 15, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 21, 1, 16, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrtX")        1, false, false, 21, 1, 16, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, 23, 1, 18, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, 23, 1, 18, 1,  1, 1}, // #311
  {DBGFIELD("WriteFSqrt64")       1, false, false, 23, 1, 18, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrtLd")       1, false, false, 22, 1, 17, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, 22, 1, 17, 1,  1, 1}, // #314
  {DBGFIELD("WriteFSqrt")         1, false, false, 22, 1, 17, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt80")       1, false, false, 34, 1, 26, 1,  0, 0}, // #316
  {DBGFIELD("WriteSTMXCSR")       1, false, false, 15, 1, 10, 1,  0, 0}, // #317
  {DBGFIELD("WriteTZCNTLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #318
  {DBGFIELD("WriteTZCNT")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #319
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("WriteFMALd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #321
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("WriteFAdd64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteFAddY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteShuffleY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFLogicY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFVarBlendY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFBlendY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteShuffle256Ld")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteShuffle256")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffleYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFShuffle256")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFCmp64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFCmpY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteVarShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteCvtI2PDYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteCvtI2PDY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PSYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PSY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteCvtPD2IYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtPD2IY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtPD2PSYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtPH2PSYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPH2PSY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPH2PSLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtPH2PS")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPS2IYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPS2IY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPS2PDYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2PDY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2PHYSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PHY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PHSt")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PH")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 1, false, false, 13, 1,  7, 1,  1, 1}, // #395
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 1, false, false, 13, 1,  7, 1,  1, 1}, // #396
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteFDiv64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteFDivY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteDPPSY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFMAY")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFMAX")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMA")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFRndY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 1, false, false, 13, 1,  7, 1,  1, 1}, // #438
  {DBGFIELD("WriteFHAddY")        1, false, false, 16, 1, 11, 1,  0, 0}, // #439
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecLoadY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFMaskedStoreY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteFMaskedLoadY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteFMaskedStore")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteFMaskedLoad")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteFMoveY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFShuffleYLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFShuffleY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecStoreY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecMoveY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteVecLoadNTY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteVecStoreNTY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFStoreNTY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFMul64Y")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFMulY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  5, 2}, // #485
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  7, 2}, // #486
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteFVarShuffleY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteFVarShuffle")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 1, false, false, 16, 1, 11, 1,  1, 1}, // #499
  {DBGFIELD("WritePHAddY")        1, false, false,  8, 1,  3, 1,  0, 0}, // #500
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 10, 2,  5, 1,  0, 0}, // #501
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecMaskedStoreY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteVecMaskedLoadY") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteVecMaskedStore") 1, false, false,  6, 2,  1, 1,  0, 0}, // #506
  {DBGFIELD("WriteVecMaskedLoad") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 11, 1,  5, 1,  5, 2}, // #513
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 11, 1,  5, 1,  7, 2}, // #514
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false,  1, 1,  1, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVarVecShift")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false,  1, 1,  1, 1,  1, 1}, // #526
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVecTestY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, 24, 1, 19, 1,  1, 1}, // #538
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteFRcpY")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteFRcpYLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteFRndYLd")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, 24, 1, 19, 1,  1, 1}, // #545
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteFRsqrtY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRsqrtYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteFSqrt64YLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteFSqrt64Y")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, 20, 1, 15, 1,  1, 1}, // #555
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteFSqrtYLd")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteFSqrtY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, 21, 1, 16, 1,  1, 1}, // #561
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFTestY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false,  6, 2,  1, 1,  1, 1}, // #567
  {DBGFIELD("WriteFTest")         1, false, false,  1, 1,  1, 1,  0, 0}, // #568
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, 32, 2, 24, 2,  0, 0}, // #569
  {DBGFIELD("WriteXCHG")          1, false, false,  3, 1,  8, 1,  0, 0}, // #570
  {DBGFIELD("COPY")               1, false, false,  1, 1,  1, 1,  0, 0}, // #571
  {DBGFIELD("FXAM")               1, false, false,  6, 2,  1, 1,  0, 0}, // #572
  {DBGFIELD("LD_Frr")             1, false, false,  6, 2,  1, 1,  0, 0}, // #573
  {DBGFIELD("MOVSX64rr32")        1, false, false,  6, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #575
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #576
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #577
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #578
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #579
  {DBGFIELD("FCOMPP")             1, false, false,  4, 2,  1, 1,  0, 0}, // #580
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false,  4, 2,  1, 1,  0, 0}, // #581
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 35, 2,  5, 1,  0, 0}, // #582
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 35, 2,  5, 1,  0, 0}, // #583
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 35, 2,  5, 1,  0, 0}, // #584
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 37, 3,  1, 1,  0, 0}, // #585
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 37, 3,  1, 1,  0, 0}, // #586
  {DBGFIELD("XCH_F")              1, false, false, 37, 3,  1, 1,  0, 0}, // #587
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 37, 3,  1, 1,  0, 0}, // #588
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 40, 3,  5, 1,  0, 0}, // #589
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 40, 3,  5, 1,  0, 0}, // #590
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  1, 1,  0, 0}, // #591
  {DBGFIELD("LFENCE")             1, false, false,  1, 1,  1, 1,  0, 0}, // #592
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false,  1, 1,  1, 1,  0, 0}, // #593
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false,  1, 1,  1, 1,  0, 0}, // #594
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #595
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false,  3, 1,  8, 1,  0, 0}, // #596
  {DBGFIELD("POP16r")             1, false, false,  3, 1,  8, 1,  0, 0}, // #597
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false,  3, 1,  8, 1,  0, 0}, // #598
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false,  3, 1,  8, 1,  0, 0}, // #599
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false,  3, 1,  8, 1,  0, 0}, // #600
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false,  3, 1,  8, 1,  0, 0}, // #601
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false,  3, 1,  8, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false,  3, 1,  8, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false,  3, 1,  8, 1,  0, 0}, // #604
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false,  3, 1,  8, 1,  0, 0}, // #605
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false,  3, 1,  8, 1,  0, 0}, // #606
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false,  3, 1,  8, 1,  0, 0}, // #607
  {DBGFIELD("CLD")                1, false, false, 28, 1, 22, 1,  0, 0}, // #608
  {DBGFIELD("LDDQUrm")            1, false, false, 28, 1, 22, 1,  0, 0}, // #609
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 28, 1, 22, 1,  0, 0}, // #610
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #611
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #612
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, 28, 1, 22, 1,  0, 0}, // #613
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 28, 1, 22, 1,  0, 0}, // #614
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #615
  {DBGFIELD("MOVDQUrm")           1, false, false, 28, 1, 22, 1,  0, 0}, // #616
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 28, 1, 22, 1,  0, 0}, // #617
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 28, 1, 22, 1,  0, 0}, // #618
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 29, 1, 23, 1,  0, 0}, // #619
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, 29, 1, 23, 1,  0, 0}, // #620
  {DBGFIELD("LD_F80m")            1, false, false, 29, 1, 23, 1,  0, 0}, // #621
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, 29, 1, 23, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, 29, 1, 23, 1,  0, 0}, // #623
  {DBGFIELD("FLDCW16m")           1, false, false, 11, 1,  5, 1,  0, 0}, // #624
  {DBGFIELD("ST_FP80m")           1, false, false, 11, 1,  5, 1,  0, 0}, // #625
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, 11, 1,  5, 1,  0, 0}, // #626
  {DBGFIELD("CMPXCHG8rm")         1, false, false,  9, 1,  4, 1,  0, 0}, // #627
  {DBGFIELD("INTO")               1, false, false,  9, 1,  4, 1,  0, 0}, // #628
  {DBGFIELD("XLAT")               1, false, false,  9, 1,  4, 1,  0, 0}, // #629
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false,  9, 1,  4, 1,  0, 0}, // #630
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false,  9, 1,  4, 1,  0, 0}, // #631
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false,  9, 1,  4, 1,  0, 0}, // #632
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false,  9, 1,  4, 1,  0, 0}, // #633
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false,  9, 1,  4, 1,  0, 0}, // #634
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false,  9, 1,  4, 1,  0, 0}, // #635
  {DBGFIELD("AAD8i8")             1, false, false,  8, 1,  3, 1,  0, 0}, // #636
  {DBGFIELD("LOOPE")              1, false, false, 16, 1, 11, 1,  0, 0}, // #637
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 16, 1, 11, 1,  0, 0}, // #638
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, 16, 1, 11, 1,  0, 0}, // #639
  {DBGFIELD("FNSTCW16m")          1, false, false, 16, 1, 11, 1,  0, 0}, // #640
  {DBGFIELD("POPA16_POPA32")      1, false, false, 13, 1,  7, 1,  0, 0}, // #641
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 13, 1,  7, 1,  0, 0}, // #642
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, 13, 1,  7, 1,  0, 0}, // #643
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, 13, 1,  7, 1,  0, 0}, // #644
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 13, 1,  7, 1,  0, 0}, // #645
  {DBGFIELD("CMPXCHG8rr")         1, false, false, 13, 1,  7, 1,  0, 0}, // #646
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #647
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #648
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 1, false, false, 24, 1, 19, 1,  0, 0}, // #649
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 1, false, false, 24, 1, 19, 1,  0, 0}, // #650
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 14, 1,  9, 1,  0, 0}, // #651
  {DBGFIELD("AAA_AAS")            1, false, false, 43, 1, 27, 1,  0, 0}, // #652
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, 26, 1, 21, 1,  0, 0}, // #653
  {DBGFIELD("LOOPNE")             1, false, false, 44, 1, 28, 1,  0, 0}, // #654
  {DBGFIELD("PAUSE")              1, false, false, 44, 1, 28, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8B")          1, false, false, 45, 1, 29, 1,  0, 0}, // #656
  {DBGFIELD("DAA")                1, false, false, 45, 1, 29, 1,  0, 0}, // #657
  {DBGFIELD("LOOP")               1, false, false, 45, 1, 29, 1,  0, 0}, // #658
  {DBGFIELD("DAS")                1, false, false, 46, 1, 30, 1,  0, 0}, // #659
  {DBGFIELD("AAM8i8")             1, false, false, 47, 1, 31, 1,  0, 0}, // #660
  {DBGFIELD("STD")                1, false, false, 47, 1, 31, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16B")         1, false, false, 48, 1, 32, 1,  0, 0}, // #662
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 49, 1, 33, 1,  0, 0}, // #663
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, 50, 1, 34, 1,  0, 0}, // #664
  {DBGFIELD("POPF32_POPF64")      1, false, false, 51, 1, 35, 1,  0, 0}, // #665
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 52, 1, 36, 1,  0, 0}, // #666
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, 53, 1, 37, 1,  0, 0}, // #667
  {DBGFIELD("ENTER")              1, false, false, 54, 1, 38, 1,  0, 0}, // #668
  {DBGFIELD("POPF16")             1, false, false, 54, 1, 38, 1,  0, 0}, // #669
  {DBGFIELD("MONITORrrr")         1, false, false, 55, 1, 39, 1,  0, 0}, // #670
  {DBGFIELD("FRNDINT")            1, false, false, 56, 1, 40, 1,  0, 0}, // #671
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 56, 1, 40, 1,  0, 0}, // #672
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 57, 1, 41, 1,  0, 0}, // #673
  {DBGFIELD("FPREM")              1, false, false, 58, 1, 42, 1,  0, 0}, // #674
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, 59, 1, 43, 1,  0, 0}, // #675
  {DBGFIELD("FNINIT")             1, false, false, 60, 1, 44, 1,  0, 0}, // #676
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, 19, 1, 14, 1,  0, 0}, // #677
  {DBGFIELD("FPREM1")             1, false, false, 34, 1, 26, 1,  0, 0}, // #678
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 34, 1, 26, 1,  0, 0}, // #679
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, 61, 1, 45, 1,  0, 0}, // #680
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 62, 1, 46, 1,  0, 0}, // #681
  {DBGFIELD("FSCALE")             1, false, false, 63, 1, 47, 1,  0, 0}, // #682
  {DBGFIELD("RDMSR")              1, false, false, 64, 1, 48, 1,  0, 0}, // #683
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 65, 1, 49, 1,  0, 0}, // #684
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, 66, 1, 50, 1,  0, 0}, // #685
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, 67, 1, 51, 1,  0, 0}, // #686
  {DBGFIELD("F2XM1")              1, false, false, 68, 1, 52, 1,  0, 0}, // #687
  {DBGFIELD("CPUID")              1, false, false, 69, 1, 53, 1,  0, 0}, // #688
  {DBGFIELD("INT")                1, false, false, 70, 1, 54, 1,  0, 0}, // #689
  {DBGFIELD("INT3")               1, false, false, 18, 1, 13, 1,  0, 0}, // #690
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 71, 1, 55, 1,  0, 0}, // #691
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, 72, 1, 56, 1,  0, 0}, // #692
  {DBGFIELD("FYL2X")              1, false, false, 73, 1, 57, 1,  0, 0}, // #693
  {DBGFIELD("FYL2XP1")            1, false, false, 74, 1, 58, 1,  0, 0}, // #694
  {DBGFIELD("FPTAN")              1, false, false, 75, 1, 59, 1,  0, 0}, // #695
  {DBGFIELD("FSINCOS")            1, false, false, 76, 1, 60, 1,  0, 0}, // #696
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 76, 1, 60, 1,  0, 0}, // #697
  {DBGFIELD("FPATAN")             1, false, false, 77, 1, 61, 1,  0, 0}, // #698
  {DBGFIELD("WRMSR")              1, false, false, 78, 1, 62, 1,  0, 0}, // #699
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 10, 2,  5, 1,  0, 0}, // #700
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false,  4, 2,  1, 1,  0, 0}, // #701
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false,  1, 1,  1, 1,  0, 0}, // #702
  {DBGFIELD("FNOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #703
  {DBGFIELD("RETQ")               1, false, false, 65, 1, 49, 1,  0, 0}, // #704
  {DBGFIELD("CDQ_CQO")            1, false, false, 29, 1, 23, 1,  0, 0}, // #705
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #706
  {DBGFIELD("MMX_PADDQirr")       1, false, false,  3, 1,  8, 1,  0, 0}, // #707
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false,  6, 2,  1, 1,  0, 0}, // #708
  {DBGFIELD("SETAr_SETBEr")       1, false, false,  1, 1,  1, 1,  0, 0}, // #709
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false,  3, 1,  8, 1,  0, 0}, // #710
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #711
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 10, 2,  5, 1,  0, 0}, // #712
  {DBGFIELD("CWD")                1, false, false, 29, 1, 23, 1,  0, 0}, // #713
  {DBGFIELD("FNSTSW16r")          1, false, false,  1, 1,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false,  1, 1,  1, 1,  0, 0}, // #715
  {DBGFIELD("PUSHFS64")           1, false, false,  3, 1,  8, 1,  0, 0}, // #716
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #717
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false,  6, 2,  1, 1,  0, 0}, // #718
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 13, 1,  7, 1,  0, 0}, // #719
  {DBGFIELD("MOV64sr")            1, false, false,  1, 1,  1, 1,  0, 0}, // #720
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #721
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #722
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #723
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 37, 3,  1, 1,  0, 0}, // #724
  {DBGFIELD("CLI")                1, false, false,  1, 1,  2, 1,  0, 0}, // #725
  {DBGFIELD("PUSHGS64")           1, false, false,  3, 1,  8, 1,  0, 0}, // #726
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false,  3, 1,  8, 1,  0, 0}, // #727
  {DBGFIELD("CALL64pcrel32")      1, false, false,  4, 2,  1, 1,  0, 0}, // #728
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #729
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #730
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  1, 1,  0, 0}, // #731
  {DBGFIELD("SETAm_SETBEm")       1, false, false,  3, 1,  8, 1,  0, 0}, // #732
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #733
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 13, 1,  7, 1,  0, 0}, // #734
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false,  6, 2,  1, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #736
  {DBGFIELD("VBROADCASTSSrm")     1, false, false,  6, 2,  1, 1,  0, 0}, // #737
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #738
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #739
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("MOV16sm")            1, false, false,  1, 1,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false,  6, 2,  1, 1,  1, 1}, // #743
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #744
  {DBGFIELD("LODSL_LODSQ")        1, false, false,  3, 1,  8, 1,  0, 0}, // #745
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #746
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #747
  {DBGFIELD("VINSERTF128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #748
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 28, 1, 22, 1,  0, 0}, // #749
  {DBGFIELD("VERRm_VERWm")        1, false, false,  1, 1,  2, 1,  0, 0}, // #750
  {DBGFIELD("FARJMP64")           1, false, false,  4, 2,  1, 1,  0, 0}, // #751
  {DBGFIELD("FNSTSWm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #752
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #753
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #755
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 1, false, false, 10, 2,  5, 1,  1, 1}, // #756
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 28, 1, 22, 1,  0, 0}, // #757
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false,  6, 2,  1, 1,  0, 0}, // #758
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, 28, 1, 22, 1,  0, 0}, // #759
  {DBGFIELD("FARCALL64")          1, false, false,  4, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #761
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #762
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false,  6, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #765
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 10, 2,  5, 1,  0, 0}, // #766
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #767
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, 10, 2,  5, 1,  0, 0}, // #768
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 30, 2, 23, 1,  0, 0}, // #769
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 10, 2,  5, 1,  0, 0}, // #770
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 30, 2, 23, 1,  0, 0}, // #771
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #772
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #773
  {DBGFIELD("VZEROALL")           1, false, false,  1, 1,  2, 1,  0, 0}, // #774
  {DBGFIELD("VZEROUPPER")         1, false, false,  1, 1,  2, 1,  0, 0}, // #775
  {DBGFIELD("CLC")                1, false, false,  1, 1,  1, 1,  0, 0}, // #776
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #777
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #778
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false,  1, 1,  1, 1,  0, 0}, // #779
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #780
  {DBGFIELD("PSUBQrr")            1, false, false,  3, 1,  8, 1,  0, 0}, // #781
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #782
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #783
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 37, 3,  1, 1,  0, 0}, // #784
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 65, 1, 49, 1,  0, 0}, // #785
  {DBGFIELD("RDPMC")              1, false, false, 56, 1, 40, 1,  0, 0}, // #786
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #787
  {DBGFIELD("FBLDm")              1, false, false,  1, 1,  2, 1,  0, 0}, // #788
  {DBGFIELD("FFREE_FFREEP")       1, false, false,  1, 1,  1, 1,  0, 0}, // #789
  {DBGFIELD("FSAVEm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #790
  {DBGFIELD("FRSTORm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #791
  {DBGFIELD("FXTRACT")            1, false, false, 50, 1, 34, 1,  0, 0}, // #792
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #793
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #794
  {DBGFIELD("VBROADCASTF128")     1, false, false,  6, 2,  1, 1,  0, 0}, // #795
  {DBGFIELD("VBROADCASTI128")     1, false, false,  6, 2,  1, 1,  0, 0}, // #796
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #797
  {DBGFIELD("FBSTPm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #798
  {DBGFIELD("VMPTRSTm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #799
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false,  3, 1,  8, 1,  0, 0}, // #800
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false,  1, 1,  1, 1,  0, 0}, // #803
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #804
  {DBGFIELD("FINCSTP")            1, false, false,  1, 1,  1, 1,  0, 0}, // #805
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false,  1, 1,  1, 1,  0, 0}, // #806
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("VPBLENDDrri")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #808
  {DBGFIELD("CMC_STC")            1, false, false,  1, 1,  1, 1,  0, 0}, // #809
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false,  1, 1,  2, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #812
  {DBGFIELD("CVTSS2SDrm")         1, false, false,  8, 1,  3, 1,  0, 0}, // #813
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false,  8, 1,  3, 1,  1, 1}, // #814
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #815
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #816
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #818
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #819
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false,  6, 2,  1, 1,  1, 1}, // #820
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("VINSERTI128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #822
  {DBGFIELD("VPBLENDDrmi")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #823
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #824
  {DBGFIELD("POP32r_POP64r")      1, false, false, 37, 3,  1, 1,  0, 0}, // #825
  {DBGFIELD("SFENCE")             1, false, false,  6, 2,  1, 1,  0, 0}, // #826
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("MOVBE16mr")          1, false, false,  6, 2,  1, 1,  0, 0}, // #828
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, 37, 3,  1, 1,  0, 0}, // #829
  {DBGFIELD("MFENCE")             1, false, false,  6, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("XGETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #831
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #832
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #833
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #834
  {DBGFIELD("LRETQ_RETL")         1, false, false, 65, 1, 49, 1,  0, 0}, // #835
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #836
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false,  9, 1,  4, 1,  0, 0}, // #837
  {DBGFIELD("VCVTDQ2PSYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #838
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false,  8, 1,  3, 1,  0, 0}, // #840
  {DBGFIELD("VCVTDQ2PSYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #841
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #843
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #844
  {DBGFIELD("CLDEMOTE")           1, false, false,  6, 2,  1, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 1, false, false, 16, 1, 11, 1,  0, 0}, // #846
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #847
  {DBGFIELD("VCVTPS2PDYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #848
  {DBGFIELD("MMX_CVTPI2PDirr")    1, false, false,  8, 1,  3, 1,  0, 0}, // #849
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #850
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #851
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #852
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #853
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #854
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #855
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #856
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 1, false, false, 13, 1,  7, 1,  0, 0}, // #857
  {DBGFIELD("CVTSS2SI64rm_Int")   1, false, false, 24, 1, 19, 1,  0, 0}, // #858
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #859
  {DBGFIELD("VCVTPS2PDYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #860
  {DBGFIELD("CVTPD2PSrm")         1, false, false, 16, 1, 11, 1,  0, 0}, // #861
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #862
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPI2PDirm")    1, false, false, 16, 1, 11, 1,  0, 0}, // #864
  {DBGFIELD("CVTSD2SSrm")         1, false, false,  8, 1,  3, 1,  0, 0}, // #865
  {DBGFIELD("VCVTSD2SSrm")        1, false, false,  8, 1,  3, 1,  1, 1}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false,  1, 1,  2, 1,  0, 0}, // #869
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #870
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 30, 2, 23, 1,  0, 0}, // #871
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #872
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #873
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #874
  {DBGFIELD("XSETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #875
  {DBGFIELD("VCVTDQ2PDYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #876
  {DBGFIELD("VCVTPD2PSYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #877
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #878
  {DBGFIELD("VCVTDQ2PDYrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #880
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false,  6, 2,  1, 1,  0, 0}, // #881
  {DBGFIELD("RCL8rCL")            1, false, false,  6, 2,  1, 1,  0, 0}, // #882
  {DBGFIELD("RDTSC")              1, false, false, 53, 1, 37, 1,  0, 0}, // #883
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #884
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 22, 1, 17, 1,  0, 0}, // #885
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #886
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 22, 1, 17, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 22, 1, 17, 1,  0, 0}, // #888
  {DBGFIELD("XSAVE64")            1, false, false,  1, 1,  2, 1,  0, 0}, // #889
  {DBGFIELD("XSAVE")              1, false, false,  1, 1,  2, 1,  0, 0}, // #890
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #891
  {DBGFIELD("VMCLEARm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #892
  {DBGFIELD("FLDENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #893
  {DBGFIELD("FXRSTOR64")          1, false, false, 72, 1, 56, 1,  0, 0}, // #894
  {DBGFIELD("FSTENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #897
  {DBGFIELD("VPGATHERQDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #898
  {DBGFIELD("VPGATHERQDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPSYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #904
  {DBGFIELD("ADC8i8_SBB8i8")      1, false, false,  1, 1,  1, 1,  0, 0}, // #905
  {DBGFIELD("ADC8ri_ADC8ri8_SBB8ri_SBB8ri8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #906
  {DBGFIELD("VCVTSS2SDrm")        1, false, false,  8, 1,  3, 1,  1, 1}, // #907
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 10, 2,  5, 1,  0, 0}, // #908
  {DBGFIELD("LRETQ")              1, false, false, 65, 1, 49, 1,  0, 0}, // #909
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false,  8, 1,  3, 1,  0, 0}, // #910
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #911
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_Int") 1, false, false,  8, 1,  3, 1,  1, 1}, // #912
  {DBGFIELD("POPF64")             1, false, false, 51, 1, 35, 1,  0, 0}, // #913
  {DBGFIELD("VGATHERQPDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSrm")       1, false, false,  6, 2,  1, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERDPDYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERDPSYrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #919
  {DBGFIELD("MOV16rm")            1, false, false,  6, 2,  1, 1,  0, 0}, // #920
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false,  6, 2,  1, 1,  0, 0}, // #921
  {DBGFIELD("POP16rmm")           1, false, false, 28, 1, 22, 1,  0, 0}, // #922
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false,  3, 1,  8, 1,  0, 0}, // #923
  {DBGFIELD("PUSHF16")            1, false, false, 13, 1,  7, 1,  0, 0}, // #924
  {DBGFIELD("LAHF")               1, false, false,  3, 1,  8, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false,  6, 2,  1, 1,  0, 0}, // #927
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false,  6, 2,  1, 1,  0, 0}, // #928
  {DBGFIELD("MULX32rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("MULX32rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("MULX64rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("MULX64rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false,  4, 2,  1, 1,  0, 0}, // #933
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 65, 1, 49, 1,  0, 0}, // #934
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 37, 3,  1, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #936
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, 29, 1, 23, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false,  3, 1,  8, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, 29, 1, 23, 1,  0, 0}, // #939
  {DBGFIELD("MOVSLDUPrm")         1, false, false,  6, 2,  1, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrr")         1, false, false,  6, 2,  1, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false,  3, 1,  8, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false,  4, 2,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #948
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false,  3, 1,  8, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false,  6, 2,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #961
  {DBGFIELD("VEXTRACTF128rr")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #964
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 1, false, false, 16, 1, 11, 1,  0, 0}, // #965
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #966
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #967
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 1, false, false, 13, 1,  7, 1,  0, 0}, // #968
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false,  1, 1,  1, 1,  0, 0}, // #969
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false,  1, 1,  1, 1,  0, 0}, // #970
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 10, 2,  5, 1,  1, 1}, // #971
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 10, 2,  5, 1,  0, 0}, // #972
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 10, 2,  5, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 10, 2,  5, 1,  1, 1}, // #974
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 10, 2,  5, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 10, 2,  5, 1,  1, 1}, // #976
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 10, 2,  5, 1,  0, 0}, // #977
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 10, 2,  5, 1,  1, 1}, // #978
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 10, 2,  5, 1,  0, 0}, // #979
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 10, 2,  5, 1,  1, 1}, // #980
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 10, 2,  5, 1,  0, 0}, // #981
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 10, 2,  5, 1,  1, 1}, // #982
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #983
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false,  6, 2,  1, 1,  0, 0}, // #984
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #985
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #986
  {DBGFIELD("XCHG16rr")           1, false, false,  3, 1,  8, 1,  0, 0}, // #987
  {DBGFIELD("CRC32r32r16")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #988
  {DBGFIELD("CRC32r32r32")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #989
  {DBGFIELD("CRC32r64r64")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #990
  {DBGFIELD("CMOVG16rm_CMOVG32rm_CMOVG64rm_CMOVGE16rm_CMOVGE32rm_CMOVGE64rm_CMOVL16rm_CMOVL32rm_CMOVL64rm_CMOVLE16rm_CMOVLE32rm_CMOVLE64rm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #991
  {DBGFIELD("SETGEm_SETGm_SETLEm_SETLm") 1, false, false,  3, 1,  8, 1,  0, 0}, // #992
  {DBGFIELD("SAHF")               1, false, false,  3, 1,  8, 1,  0, 0}, // #993
  {DBGFIELD("RCR8ri")             1, false, false,  6, 2,  1, 1,  0, 0}, // #994
  {DBGFIELD("RCL16rCL")           1, false, false,  6, 2,  1, 1,  0, 0}, // #995
  {DBGFIELD("RCR16ri")            1, false, false,  6, 2,  1, 1,  0, 0}, // #996
  {DBGFIELD("RCL32rCL_RCL64rCL")  1, false, false,  6, 2,  1, 1,  0, 0}, // #997
  {DBGFIELD("RCR64rCL")           1, false, false,  6, 2,  1, 1,  0, 0}, // #998
  {DBGFIELD("RCR32rCL")           1, false, false,  6, 2,  1, 1,  0, 0}, // #999
  {DBGFIELD("RCR32ri_RCR64ri")    1, false, false,  6, 2,  1, 1,  0, 0}, // #1000
  {DBGFIELD("RCL16ri")            1, false, false,  6, 2,  1, 1,  0, 0}, // #1001
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false,  6, 2,  1, 1,  0, 0}, // #1002
  {DBGFIELD("SHLD32rri8")         1, false, false,  3, 1,  8, 1,  0, 0}, // #1003
  {DBGFIELD("SHRD16rri8")         1, false, false,  9, 1,  4, 1,  0, 0}, // #1004
  {DBGFIELD("SHLD16rrCL")         1, false, false,  9, 1,  4, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1006
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1007
  {DBGFIELD("TST_F")              1, false, false, 13, 1,  7, 1,  0, 0}, // #1008
  {DBGFIELD("VDPPSrri")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #1009
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr_VFRCZSDrr_VFRCZSSrr") 1, false, false, 10, 2,  5, 1,  0, 0}, // #1010
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, 10, 2,  5, 1,  1, 1}, // #1011
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1012
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1013
  {DBGFIELD("MMX_CVTTPD2PIirr")   1, false, false,  8, 1,  3, 1,  0, 0}, // #1014
  {DBGFIELD("CVTSI642SDrr")       1, false, false,  9, 1,  4, 1,  0, 0}, // #1015
  {DBGFIELD("CVTSI642SSrr")       1, false, false,  9, 1,  4, 1,  0, 0}, // #1016
  {DBGFIELD("VMOVDQUYmr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1017
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1018
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1019
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 1, false, false, 16, 1, 11, 1,  1, 1}, // #1020
  {DBGFIELD("VPCLMULQDQrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1021
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1022
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("PANDNrr_VPANDNrr")   1, false, false,  1, 1,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1025
  {DBGFIELD("VXORPSYrr_VXORPDYrr_VANDNPSYrr_VANDNPDYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1026
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1027
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false,  4, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("LEA16r")             1, false, false,  4, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1031
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1032
  {DBGFIELD("CLAC_STAC")          1, false, false,  1, 1,  2, 1,  0, 0}, // #1033
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1034
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1035
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1036
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 10, 2,  5, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, 11, 1,  5, 1,  0, 0}, // #1038
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1039
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1040
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1041
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1042
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1043
  {DBGFIELD("CVTSS2SI64rr_Int")   1, false, false, 13, 1,  7, 1,  0, 0}, // #1044
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1045
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1046
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1048
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 1, false, false, 16, 1, 11, 1,  1, 1}, // #1049
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 1, false, false, 16, 1, 11, 1,  1, 1}, // #1050
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #1051
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1052
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1053
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1054
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1061
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1067
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 10, 2,  5, 1,  0, 0}, // #1072
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1073
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 10, 2,  5, 1,  0, 0}, // #1075
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1077
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1083
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1085
  {DBGFIELD("VCVTPS2DQYrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1086
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1096
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1097
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1098
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1099
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1103
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1104
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1105
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1106
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1107
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1114
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false,  6, 2,  1, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false,  9, 1,  4, 1,  0, 0}, // #1116
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1118
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1119
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false,  6, 2,  1, 1,  0, 0}, // #1130
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1131
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1132
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1133
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1134
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1135
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1136
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1137
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1138
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1140
  {DBGFIELD("VCVTSS2SI64rr_Int")  1, false, false, 16, 1, 11, 1,  0, 0}, // #1141
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1142
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1143
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1144
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1145
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 10, 2,  5, 1,  1, 1}, // #1149
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("VMOVNTDQAZ256rm")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1160
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false,  6, 2,  1, 1,  0, 0}, // #1170
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1171
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 1, false, false, 10, 2,  5, 1,  1, 1}, // #1172
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 10, 2,  5, 1,  1, 1}, // #1173
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1174
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false,  6, 2,  1, 1,  1, 1}, // #1178
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1187
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1188
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1189
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false,  8, 1,  3, 1,  0, 0}, // #1191
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 1, false, false, 16, 1, 11, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false,  8, 1,  3, 1,  1, 1}, // #1193
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1197
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1199
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1201
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1203
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false,  8, 1,  3, 1,  1, 1}, // #1208
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1209
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 10, 2,  5, 1,  0, 0}, // #1210
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1211
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 1, false, false, 13, 1,  7, 1,  1, 1}, // #1214
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 1, false, false, 13, 1,  7, 1,  1, 1}, // #1215
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1223
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 10, 2,  5, 1,  1, 1}, // #1224
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1227
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1228
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1229
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1230
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1231
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1232
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1233
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1234
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false,  6, 2,  1, 1,  0, 0}, // #1236
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1237
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1238
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1239
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1240
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1244
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("SBWriteResGroup30")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("WriteFLogicY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1257
}; // AtomModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BdVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 79, 3,  8, 1,  0, 0}, // #2
  {DBGFIELD("WriteCMPXCHGRMW")    2, false, false, 82, 6, 22, 1,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        1, false, false, 88, 6,  5, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 94, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 94, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 89, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 94, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false, 96, 6,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 102, 5,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       4, false, false, 96, 6,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        2, false, false, 102, 5,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 94, 2,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 107, 4,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false, 111, 2,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        2, false, false, 113, 5,  4, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, 118, 4,  5, 1,  9, 1}, // #17
  {DBGFIELD("WriteALURMW")        2, false, false, 122, 5,  4, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, 127, 4,  5, 1,  9, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, 131, 6, 19, 1, 10, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 132, 4,  5, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, 131, 6, 19, 1, 10, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 132, 4,  5, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, 131, 6, 19, 1, 10, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 132, 4,  5, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, 131, 6, 19, 1, 10, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 132, 4,  5, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        1, false, false, 131, 6, 19, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 137, 6, 21, 1, 10, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 138, 4,  7, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      1, false, false, 137, 6, 19, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        1, false, false, 138, 4,  5, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 137, 6, 19, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 138, 4,  5, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, 102, 5,  3, 1, 10, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 103, 3,  8, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 127, 4,  4, 1, 11, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 94, 2,  8, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       2, false, false, 127, 4,  4, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         1, false, false, 127, 4,  5, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, 102, 5,  3, 1, 10, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 103, 3,  8, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 1, false, false, 143, 5,  3, 1, 10, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     1, false, false, 144, 3,  8, 1,  0, 0}, // #44
  {DBGFIELD("WriteBLSLd")         2, false, false, 127, 4,  4, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLS")           2, false, false, 94, 2,  8, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSFLd")         8, false, false, 148, 4,  3, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSF")           6, false, false, 149, 2, 22, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSRLd")         9, false, false, 148, 4, 11, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSR")           7, false, false, 149, 2, 23, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSWAP32")       1, false, false, 83, 3,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP64")       1, false, false, 83, 3,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, 127, 4,  5, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestRegLd")  7, false, false, 127, 4,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTest")       1, false, false, 94, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTestSetImmRMW") 5, false, false, 122, 5,  3, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetRegRMW") 11, false, false, 122, 5,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSet")    2, false, false, 94, 2,  8, 1,  0, 0}, // #58
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 127, 4,  5, 1, 11, 1}, // #59
  {DBGFIELD("WriteBZHI")          1, false, false, 94, 2,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteLoad")          1, false, false, 152, 2,  5, 1,  0, 0}, // #61
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 2, false, false, 127, 4,  5, 1,  9, 1}, // #62
  {DBGFIELD("WriteCMOV2")         1, false, false, 94, 2,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, 127, 4,  5, 1,  9, 1}, // #64
  {DBGFIELD("WriteCMOV")          1, false, false, 94, 2,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteFCMOV")         1, false, false, 132, 4,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 127, 4,  5, 1, 11, 1}, // #67
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, 131, 6,  3, 1, 10, 1}, // #68
  {DBGFIELD("WriteFCmp64X")       1, false, false, 132, 4,  8, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, 131, 6,  3, 1, 10, 1}, // #70
  {DBGFIELD("WriteFCmpX")         1, false, false, 132, 4,  8, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, 131, 6,  3, 1, 10, 1}, // #72
  {DBGFIELD("WriteFCmp64")        1, false, false, 132, 4,  8, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, 131, 6,  3, 1, 10, 1}, // #74
  {DBGFIELD("WriteFCmp")          1, false, false, 132, 4,  8, 1,  0, 0}, // #75
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 83, 3, 22, 1,  0, 0}, // #76
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 154, 9,  4, 1, 10, 1}, // #77
  {DBGFIELD("WriteFCom")          2, false, false, 155, 7,  1, 1,  0, 0}, // #78
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, 148, 4,  3, 1,  9, 1}, // #79
  {DBGFIELD("WriteCRC32")         3, false, false, 149, 2, 22, 1,  0, 0}, // #80
  {DBGFIELD("WriteNop")           1, false, false, 94, 2,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 163, 6, 27, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PD")       2, false, false, 97, 4, 11, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, 163, 6,  7, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 97, 4, 23, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 163, 6, 27, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2I")       2, false, false, 97, 4, 11, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 163, 6, 27, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, 97, 4, 11, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, 163, 6,  7, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 97, 4, 23, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 163, 6, 27, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, 97, 4, 11, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 169, 10, 29, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 170, 8, 27, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false, 163, 6,  7, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false, 163, 6,  7, 1, 10, 1}, // #97
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 97, 4, 23, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 163, 6,  7, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 163, 6,  7, 1, 10, 1}, // #100
  {DBGFIELD("WriteCvtI2SD")       2, false, false, 97, 4, 23, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 163, 6,  7, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 163, 6,  7, 1, 10, 1}, // #103
  {DBGFIELD("WriteCvtI2SS")       2, false, false, 97, 4, 23, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false, 163, 6,  7, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false, 163, 6,  7, 1, 10, 1}, // #106
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 97, 4, 23, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 169, 10, 29, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 170, 8, 27, 1,  0, 0}, // #109
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 179, 6, 63, 1, 12, 2}, // #110
  {DBGFIELD("WriteDiv16")         2, false, false, 180, 4, 10, 1,  0, 0}, // #111
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 185, 6, 29, 1, 12, 2}, // #112
  {DBGFIELD("WriteDiv32")         2, false, false, 186, 4, 21, 1,  0, 0}, // #113
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 185, 6, 29, 1, 12, 2}, // #114
  {DBGFIELD("WriteDiv64")         2, false, false, 186, 4, 21, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 191, 6,  6, 1, 12, 2}, // #116
  {DBGFIELD("WriteDiv8")          1, false, false, 192, 4, 20, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, 197, 6, 21, 1, 10, 1}, // #118
  {DBGFIELD("WriteFDiv64X")       1, false, false, 198, 4,  7, 1,  0, 0}, // #119
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, 197, 6, 21, 1, 10, 1}, // #120
  {DBGFIELD("WriteFDivX")         1, false, false, 198, 4,  7, 1,  0, 0}, // #121
  {DBGFIELD("WriteFDivLd")        1, false, false, 197, 6, 21, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv")          1, false, false, 198, 4,  7, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, 197, 6, 21, 1, 10, 1}, // #124
  {DBGFIELD("WriteFDiv64")        1, false, false, 198, 4,  7, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, 197, 6, 21, 1, 10, 1}, // #126
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 17, false, false, 203, 6, 30, 1, 10, 1}, // #127
  {DBGFIELD("WriteDPPD")          15, false, false, 204, 4, 10, 1,  0, 0}, // #128
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 18, false, false, 203, 6, 37, 1, 10, 1}, // #129
  {DBGFIELD("WriteDPPS")          16, false, false, 204, 4, 34, 1,  0, 0}, // #130
  {DBGFIELD("WriteVecExtractSt")  2, false, false, 96, 6, 27, 1,  0, 0}, // #131
  {DBGFIELD("WriteVecExtract")    2, false, false, 155, 7, 27, 1,  0, 0}, // #132
  {DBGFIELD("WriteVecALUX")       1, false, false, 79, 3,  8, 1,  0, 0}, // #133
  {DBGFIELD("WriteFComLd")        2, false, false, 154, 9,  4, 1,  0, 0}, // #134
  {DBGFIELD("WriteEMMS")          1, false, false, 103, 3,  8, 1,  0, 0}, // #135
  {DBGFIELD("WriteFLDC")          1, false, false, 97, 4, 22, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #137
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 131, 6,  6, 1, 10, 1}, // #138
  {DBGFIELD("WriteFHAdd")         3, false, false, 132, 4,  9, 1,  0, 0}, // #139
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 214, 6, 63, 1, 12, 2}, // #140
  {DBGFIELD("WriteIDiv16")        2, false, false, 215, 4, 10, 1,  0, 0}, // #141
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 220, 6, 29, 1, 12, 2}, // #142
  {DBGFIELD("WriteIDiv32")        2, false, false, 221, 4, 21, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 185, 6, 29, 1, 12, 2}, // #144
  {DBGFIELD("WriteIDiv64")        2, false, false, 186, 4, 21, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 191, 6,  6, 1, 12, 2}, // #146
  {DBGFIELD("WriteIDiv8")         1, false, false, 192, 4, 20, 1,  0, 0}, // #147
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 226, 6, 11, 1, 12, 2}, // #148
  {DBGFIELD("WriteIMul16")        2, false, false, 232, 4, 23, 1,  0, 0}, // #149
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false, 226, 6, 11, 1,  9, 1}, // #150
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, 226, 6,  7, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 232, 4, 23, 1,  0, 0}, // #152
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 232, 4,  5, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 226, 6, 11, 1, 12, 2}, // #154
  {DBGFIELD("WriteIMul32")        1, false, false, 232, 4, 23, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, 226, 6, 11, 1,  9, 1}, // #156
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 226, 6, 11, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 232, 4, 23, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 232, 4, 23, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 236, 6, 19, 1, 12, 2}, // #160
  {DBGFIELD("WriteIMul64")        1, false, false, 242, 4,  4, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, 236, 6, 19, 1,  9, 1}, // #162
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 236, 6, 19, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 242, 4,  4, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 242, 4,  4, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 226, 6, 11, 1, 12, 2}, // #166
  {DBGFIELD("WriteIMul8")         1, false, false, 232, 4, 23, 1,  0, 0}, // #167
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, 102, 5,  3, 1, 10, 1}, // #168
  {DBGFIELD("WriteFShuffle")      1, false, false, 103, 3,  8, 1,  0, 0}, // #169
  {DBGFIELD("WriteStore")         1, false, false, 246, 2,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteVecLogicX")     1, false, false, 79, 3,  8, 1,  0, 0}, // #171
  {DBGFIELD("WriteShuffle")       1, false, false, 79, 3,  8, 1,  0, 0}, // #172
  {DBGFIELD("WriteLAHFSAHF")      2, false, false, 94, 2,  8, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLoadX")      1, false, false, 209, 5,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 152, 2,  5, 1,  0, 0}, // #175
  {DBGFIELD("WriteFLD0")          1, false, false, 97, 4, 22, 1,  0, 0}, // #176
  {DBGFIELD("WriteFLD1")          1, false, false, 97, 4, 22, 1,  0, 0}, // #177
  {DBGFIELD("WriteLEA")           2, false, false, 94, 2,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteFence")         1, false, false, 246, 2,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 127, 4,  4, 1,  0, 0}, // #180
  {DBGFIELD("WriteLZCNT")         2, false, false, 94, 2,  8, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecStoreX")     1, false, false, 96, 6,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecStore")      1, false, false, 96, 6,  8, 1,  0, 0}, // #183
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 155, 7, 19, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoad")       1, false, false, 209, 5,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, 103, 3, 19, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveX")      1, false, false, 79, 3,  8, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 96, 6,  8, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMove")       1, false, false, 79, 3,  8, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecALULd")      1, false, false, 209, 5,  3, 1,  0, 0}, // #190
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #191
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #192
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #193
  {DBGFIELD("WriteVecLogic")      1, false, false, 79, 3,  8, 1,  0, 0}, // #194
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 209, 5, 19, 1, 10, 1}, // #195
  {DBGFIELD("WritePHAdd")         3, false, false, 79, 3,  5, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 209, 5,  4, 1,  9, 1}, // #197
  {DBGFIELD("WriteVecInsert")     2, false, false, 79, 3,  8, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, 137, 6,  7, 1, 10, 1}, // #199
  {DBGFIELD("WriteVecIMul")       1, false, false, 138, 4, 23, 1,  0, 0}, // #200
  {DBGFIELD("WriteMMXMOVMSK")     2, false, false, 155, 7, 19, 1,  0, 0}, // #201
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 209, 5,  7, 1, 10, 1}, // #202
  {DBGFIELD("WritePSADBW")        2, false, false, 79, 3, 23, 1,  0, 0}, // #203
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, 248, 5, 11, 1, 10, 1}, // #204
  {DBGFIELD("WriteVarShuffle")    1, false, false, 249, 3, 22, 1,  0, 0}, // #205
  {DBGFIELD("WriteShuffleLd")     1, false, false, 209, 5,  3, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 79, 3,  8, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, 209, 5, 11, 1, 10, 1}, // #208
  {DBGFIELD("WriteVecShift")      1, false, false, 79, 3, 22, 1,  0, 0}, // #209
  {DBGFIELD("WriteFMoveX")        1, false, false, 103, 3,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteFShuffleLd")    1, false, false, 102, 5,  3, 1,  0, 0}, // #211
  {DBGFIELD("WriteFStore")        1, false, false, 96, 6,  8, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMOVMSK")       2, false, false, 155, 7, 19, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 209, 5,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteStoreNT")       1, false, false, 246, 2,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 96, 6, 22, 1,  0, 0}, // #216
  {DBGFIELD("WriteFStoreNT")      1, false, false, 96, 6, 22, 1,  0, 0}, // #217
  {DBGFIELD("WriteFLoad")         1, false, false, 102, 5,  5, 1,  0, 0}, // #218
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 9, false, false, 253, 6, 21, 1, 10, 1}, // #219
  {DBGFIELD("WriteMPSAD")         9, false, false, 254, 4,  7, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #221
  {DBGFIELD("WriteFMul64X")       1, false, false, 107, 4,  5, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #223
  {DBGFIELD("WriteFMulX")         1, false, false, 107, 4,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #225
  {DBGFIELD("WriteFMul64")        1, false, false, 107, 4,  5, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #227
  {DBGFIELD("WriteFMul")          1, false, false, 107, 4,  5, 1,  0, 0}, // #228
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #229
  {DBGFIELD("WriteIMul32_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #231
  {DBGFIELD("WriteIMul64_WriteIMulH") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd")        1, false, false, 259, 6, 19, 1,  0, 0}, // #233
  {DBGFIELD("WriteVecALUXLd")     1, false, false, 209, 5,  3, 1,  0, 0}, // #234
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #235
  {DBGFIELD("WriteShuffleX")      1, false, false, 79, 3,  8, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #237
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 1, false, false, 248, 5,  3, 1, 10, 1}, // #238
  {DBGFIELD("WriteVarBlend")      1, false, false, 249, 3,  8, 1,  0, 0}, // #239
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #240
  {DBGFIELD("WriteBlend")         1, false, false, 79, 3,  8, 1,  0, 0}, // #241
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 6, false, false, 137, 6, 28, 1, 10, 1}, // #242
  {DBGFIELD("WriteCLMul")         5, false, false, 138, 4, 20, 1,  0, 0}, // #243
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 28, false, false, 265, 11, 30, 1, 10, 1}, // #244
  {DBGFIELD("WritePCmpEStrI")     27, false, false, 276, 11, 10, 1,  0, 0}, // #245
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 28, false, false, 265, 11, 10, 1, 10, 1}, // #246
  {DBGFIELD("WritePCmpEStrM")     27, false, false, 276, 11, 19, 1,  0, 0}, // #247
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8, false, false, 287, 9, 63, 1, 10, 1}, // #248
  {DBGFIELD("WritePCmpIStrI")     7, false, false, 288, 7, 21, 1,  0, 0}, // #249
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 9, false, false, 287, 9,  9, 1, 10, 1}, // #250
  {DBGFIELD("WritePCmpIStrM")     7, false, false, 288, 7,  4, 1,  0, 0}, // #251
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, 163, 6,  7, 1, 10, 1}, // #252
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #253
  {DBGFIELD("WritePHAddX")        1, false, false, 79, 3,  8, 1,  0, 0}, // #254
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 296, 6,  7, 1,  0, 0}, // #255
  {DBGFIELD("WritePHMINPOS")      2, false, false, 297, 4, 23, 1,  0, 0}, // #256
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, 163, 6,  7, 1, 10, 1}, // #257
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, 137, 6,  7, 1, 10, 1}, // #258
  {DBGFIELD("WriteVecIMulX")      1, false, false, 138, 4, 23, 1,  0, 0}, // #259
  {DBGFIELD("WriteVecMOVMSK")     2, false, false, 155, 7, 27, 1,  0, 0}, // #260
  {DBGFIELD("WriteShuffleXLd")    1, false, false, 209, 5,  3, 1,  0, 0}, // #261
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 1, false, false, 302, 7, 19, 1, 10, 1}, // #262
  {DBGFIELD("WritePMULLD")        1, false, false, 303, 5,  5, 1,  0, 0}, // #263
  {DBGFIELD("WriteCopy")          2, false, false, 309, 3,  4, 1,  0, 0}, // #264
  {DBGFIELD("WritePOPCNTLd")      1, false, false, 127, 4, 11, 1,  0, 0}, // #265
  {DBGFIELD("WritePOPCNT")        1, false, false, 94, 2, 23, 1,  0, 0}, // #266
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, 209, 5,  7, 1, 10, 1}, // #267
  {DBGFIELD("WritePSADBWX")       2, false, false, 79, 3, 23, 1,  0, 0}, // #268
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, 248, 5, 11, 1, 10, 1}, // #269
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 249, 3, 22, 1,  0, 0}, // #270
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 79, 3,  8, 1,  0, 0}, // #271
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, 209, 5, 11, 1, 10, 1}, // #272
  {DBGFIELD("WriteVecShiftX")     1, false, false, 79, 3, 22, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 2, false, false, 154, 9,  4, 1, 10, 1}, // #274
  {DBGFIELD("WriteVecTest")       2, false, false, 155, 7,  1, 1,  0, 0}, // #275
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, 122, 5, 64, 2,  0, 0}, // #276
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, 122, 5, 64, 2,  0, 0}, // #277
  {DBGFIELD("WriteRotate")        1, false, false, 94, 2,  1, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateCL")      1, false, false, 94, 2,  1, 1,  0, 0}, // #279
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 259, 6, 19, 1,  0, 0}, // #280
  {DBGFIELD("WriteFRcpX")         1, false, false, 107, 4,  5, 1,  0, 0}, // #281
  {DBGFIELD("WriteFRcpLd")        1, false, false, 259, 6, 19, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #283
  {DBGFIELD("WriteFRcp")          1, false, false, 107, 4,  5, 1,  0, 0}, // #284
  {DBGFIELD("WriteRMW")           1, false, false, 246, 2,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteShiftLd")       1, false, false, 127, 4,  5, 1,  0, 0}, // #286
  {DBGFIELD("WriteShift")         1, false, false, 94, 2,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteFRndLd")        1, false, false, 163, 6,  7, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRnd")          1, false, false, 97, 4, 23, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, 163, 6,  7, 1, 10, 1}, // #290
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 259, 6, 19, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 107, 4,  5, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, 259, 6, 19, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #294
  {DBGFIELD("WriteFRsqrt")        1, false, false, 107, 4,  5, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, 122, 5, 64, 2,  0, 0}, // #296
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, 122, 5, 64, 2,  0, 0}, // #297
  {DBGFIELD("WriteShiftCL")       1, false, false, 94, 2,  1, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 127, 4,  5, 1, 11, 1}, // #299
  {DBGFIELD("WriteSETCCStore")    1, false, false, 312, 4,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteSETCC")         1, false, false, 94, 2,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteSHDmrcl")       8, false, false, 316, 4, 23, 1,  0, 0}, // #302
  {DBGFIELD("WriteSHDmri")        8, false, false, 316, 4, 23, 1,  0, 0}, // #303
  {DBGFIELD("WriteSHDrrcl")       7, false, false, 320, 2, 23, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDrri")        6, false, false, 322, 2, 23, 1,  0, 0}, // #305
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 324, 6, 21, 1,  0, 0}, // #306
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 325, 4,  7, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 330, 6, 21, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrtX")        1, false, false, 331, 4,  7, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, 324, 6, 21, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, 324, 6, 21, 1, 10, 1}, // #311
  {DBGFIELD("WriteFSqrt64")       1, false, false, 325, 4,  7, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrtLd")       1, false, false, 330, 6, 21, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, 330, 6, 21, 1, 10, 1}, // #314
  {DBGFIELD("WriteFSqrt")         1, false, false, 331, 4,  7, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt80")       1, false, false, 336, 4,  1, 1,  0, 0}, // #316
  {DBGFIELD("WriteSTMXCSR")       2, false, false, 246, 2,  1, 1,  0, 0}, // #317
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 118, 4,  4, 1,  0, 0}, // #318
  {DBGFIELD("WriteTZCNT")         2, false, false, 111, 2,  8, 1,  0, 0}, // #319
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("WriteFMALd")         1, false, false, 340, 4, 19, 1,  0, 0}, // #321
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 344, 6, 19, 1, 10, 1}, // #322
  {DBGFIELD("WriteFAdd64Y")       2, false, false, 345, 4,  5, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 344, 6, 19, 1, 10, 1}, // #326
  {DBGFIELD("WriteFAddY")         2, false, false, 345, 4,  5, 1,  0, 0}, // #327
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, 350, 5,  3, 1, 10, 1}, // #330
  {DBGFIELD("WriteShuffleY")      2, false, false, 79, 3,  8, 1,  0, 0}, // #331
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 355, 5,  3, 1, 10, 1}, // #334
  {DBGFIELD("WriteFLogicY")       2, false, false, 356, 3,  8, 1,  0, 0}, // #335
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 2, false, false, 360, 5,  3, 1, 10, 1}, // #338
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 361, 3,  8, 1,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 355, 5,  3, 1, 10, 1}, // #342
  {DBGFIELD("WriteFBlendY")       2, false, false, 356, 3,  8, 1,  0, 0}, // #343
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 360, 5,  3, 1, 14, 2}, // #344
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 143, 5,  3, 1, 14, 2}, // #345
  {DBGFIELD("WriteShuffle256Ld")  1, false, false, 209, 5,  4, 1,  0, 0}, // #346
  {DBGFIELD("WriteShuffle256")    1, false, false, 79, 3,  1, 1,  0, 0}, // #347
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 350, 5,  3, 1,  0, 0}, // #348
  {DBGFIELD("WriteFShuffle256")   2, false, false, 103, 3,  8, 1,  0, 0}, // #349
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 102, 5,  3, 1,  0, 0}, // #350
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 344, 6,  3, 1, 10, 1}, // #351
  {DBGFIELD("WriteFCmp64Y")       2, false, false, 345, 4,  8, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 344, 6,  3, 1, 10, 1}, // #353
  {DBGFIELD("WriteFCmpY")         2, false, false, 345, 4,  8, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteVarShuffle256Ld") 1, false, false, 209, 5,  4, 1,  0, 0}, // #357
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 79, 3,  1, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtI2PDYLd")    5, false, false, 365, 6, 27, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtI2PDY")      4, false, false, 366, 4, 11, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 365, 6,  7, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, 366, 4, 23, 1,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteCvtPD2IYLd")    4, false, false, 371, 7, 27, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtPD2IY")      4, false, false, 372, 5, 11, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtPD2PSYLd")   4, false, false, 371, 7, 27, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSY")     4, false, false, 372, 5, 11, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtPH2PSYLd")   7, false, false, 365, 6, 27, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtPH2PSY")     4, false, false, 366, 4, 11, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPH2PSLd")    3, false, false, 163, 6, 27, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 97, 4, 11, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 365, 6,  7, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, 366, 4, 23, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPS2PDYLd")   5, false, false, 365, 6, 27, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2PDY")     4, false, false, 366, 4, 11, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, 378, 7, 23, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PHY")     4, false, false, 372, 5, 11, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, 96, 6, 23, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 97, 4, 11, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, 169, 10, 29, 1, 10, 1}, // #395
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, 169, 10, 29, 1, 10, 1}, // #396
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, 385, 6, 21, 1, 10, 1}, // #401
  {DBGFIELD("WriteFDiv64Y")       2, false, false, 386, 4,  7, 1,  0, 0}, // #402
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, 385, 6, 21, 1, 10, 1}, // #405
  {DBGFIELD("WriteFDivY")         2, false, false, 386, 4,  7, 1,  0, 0}, // #406
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 29, false, false, 391, 6, 38, 1, 10, 1}, // #409
  {DBGFIELD("WriteDPPSY")         25, false, false, 392, 4, 66, 1,  0, 0}, // #410
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 1, false, false, 209, 5,  4, 1, 10, 1}, // #411
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 397, 4, 19, 1, 16, 2}, // #412
  {DBGFIELD("WriteFMAY")          2, false, false, 103, 2,  5, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 1, false, false, 340, 4, 19, 1, 10, 1}, // #414
  {DBGFIELD("WriteFMAX")          1, false, false, 103, 2,  5, 1,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, 397, 4, 19, 1, 10, 1}, // #416
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 340, 4, 19, 1, 16, 2}, // #419
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 1, false, false, 340, 4, 19, 1, 10, 1}, // #420
  {DBGFIELD("WriteFMA")           1, false, false, 103, 2,  5, 1,  0, 0}, // #421
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 1, false, false, 340, 4, 19, 1, 16, 2}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 397, 4, 19, 1, 14, 2}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 340, 4, 19, 1, 14, 2}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 1, false, false, 340, 4, 19, 1, 14, 2}, // #425
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, 365, 6,  7, 1, 10, 1}, // #426
  {DBGFIELD("WriteFRndY")         2, false, false, 366, 4, 23, 1,  0, 0}, // #427
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 10, false, false, 344, 6,  6, 1, 10, 1}, // #438
  {DBGFIELD("WriteFHAddY")        8, false, false, 345, 4,  9, 1,  0, 0}, // #439
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 102, 5,  3, 1, 10, 1}, // #440
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 1, false, false, 209, 5,  4, 1, 10, 1}, // #441
  {DBGFIELD("WriteVecLoadY")      2, false, false, 209, 5,  5, 1,  0, 0}, // #442
  {DBGFIELD("WriteFMaskedStoreY") 34, false, false, 401, 5,  4, 1,  0, 0}, // #443
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 406, 5,  4, 1,  0, 0}, // #444
  {DBGFIELD("WriteFMaskedStore")  18, false, false, 411, 5,  4, 1,  0, 0}, // #445
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, 416, 5,  4, 1,  0, 0}, // #446
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteFMoveY")        2, false, false, 356, 3,  8, 1,  0, 0}, // #449
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 355, 5,  3, 1,  0, 0}, // #450
  {DBGFIELD("WriteFShuffleY")     2, false, false, 356, 3,  8, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecStoreY")     4, false, false, 96, 6,  1, 1,  0, 0}, // #454
  {DBGFIELD("WriteVecMoveY")      2, false, false, 421, 3,  8, 1,  0, 0}, // #455
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 209, 5,  5, 1,  0, 0}, // #456
  {DBGFIELD("WriteVecStoreNTY")   4, false, false, 424, 6,  8, 1,  0, 0}, // #457
  {DBGFIELD("WriteFStoreNTY")     4, false, false, 424, 6, 22, 1,  0, 0}, // #458
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 430, 6, 19, 1, 10, 1}, // #461
  {DBGFIELD("WriteFMul64Y")       2, false, false, 431, 4,  5, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 430, 6, 19, 1, 10, 1}, // #465
  {DBGFIELD("WriteFMulY")         2, false, false, 431, 4,  5, 1,  0, 0}, // #466
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 248, 5,  3, 1, 14, 2}, // #482
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 350, 5,  3, 1, 14, 2}, // #483
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 350, 5,  3, 1, 16, 2}, // #484
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 14, 2}, // #485
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 16, 2}, // #486
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 360, 5, 11, 1, 14, 2}, // #489
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 360, 5, 11, 1, 16, 2}, // #490
  {DBGFIELD("WriteFVarShuffleY")  2, false, false, 361, 3, 22, 1,  0, 0}, // #491
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 143, 5, 11, 1, 14, 2}, // #492
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 143, 5, 11, 1, 16, 2}, // #493
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 144, 3, 22, 1,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 360, 5, 11, 1, 10, 1}, // #495
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 1, false, false, 143, 5, 11, 1, 10, 1}, // #496
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WritePHAddY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 137, 6,  7, 1,  0, 0}, // #501
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 436, 5,  4, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 441, 5,  4, 1,  0, 0}, // #505
  {DBGFIELD("WriteVecMaskedStore") 1, false, false, 446, 5,  4, 1,  0, 0}, // #506
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, 451, 5,  4, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 248, 5, 11, 1, 14, 2}, // #513
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 248, 5, 11, 1, 16, 2}, // #514
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, 209, 5,  3, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 1, false, false, 209, 5, 11, 1, 10, 1}, // #520
  {DBGFIELD("WriteVarVecShift")   1, false, false, 79, 3, 22, 1,  0, 0}, // #521
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, 209, 5,  3, 1, 10, 1}, // #526
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 6, false, false, 456, 8,  4, 1, 10, 1}, // #536
  {DBGFIELD("WriteVecTestY")      4, false, false, 457, 6,  1, 1,  0, 0}, // #537
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #538
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, 430, 6, 19, 1, 10, 1}, // #539
  {DBGFIELD("WriteFRcpY")         2, false, false, 431, 4,  5, 1,  0, 0}, // #540
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 430, 6, 19, 1,  0, 0}, // #543
  {DBGFIELD("WriteFRndYLd")       2, false, false, 365, 6,  7, 1,  0, 0}, // #544
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, 259, 6, 19, 1, 10, 1}, // #545
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, 430, 6, 19, 1, 10, 1}, // #546
  {DBGFIELD("WriteFRsqrtY")       2, false, false, 431, 4,  5, 1,  0, 0}, // #547
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 430, 6, 19, 1,  0, 0}, // #550
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 355, 5,  3, 1, 10, 1}, // #551
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 464, 6, 21, 1,  0, 0}, // #553
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, 465, 4,  7, 1,  0, 0}, // #554
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, 324, 6, 21, 1, 10, 1}, // #555
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, 464, 6, 21, 1, 10, 1}, // #556
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 470, 6, 21, 1,  0, 0}, // #559
  {DBGFIELD("WriteFSqrtY")        2, false, false, 471, 4,  7, 1,  0, 0}, // #560
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, 330, 6, 21, 1, 10, 1}, // #561
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, 470, 6, 21, 1, 10, 1}, // #562
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 6, false, false, 456, 8,  4, 1, 10, 1}, // #565
  {DBGFIELD("WriteFTestY")        4, false, false, 457, 6,  1, 1,  0, 0}, // #566
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, 154, 9,  4, 1, 10, 1}, // #567
  {DBGFIELD("WriteFTest")         2, false, false, 155, 7,  1, 1,  0, 0}, // #568
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, 122, 5, 64, 2,  0, 0}, // #569
  {DBGFIELD("WriteXCHG")          2, false, false, 83, 3,  1, 1,  0, 0}, // #570
  {DBGFIELD("COPY")               1, false, false, 94, 2,  1, 1,  0, 0}, // #571
  {DBGFIELD("FXAM")               1, false, false, 94, 2,  2, 1,  0, 0}, // #572
  {DBGFIELD("LD_Frr")             1, false, false, 94, 2,  1, 1,  0, 0}, // #573
  {DBGFIELD("MOVSX64rr32")        1, false, false, 94, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, 122, 5, 64, 2,  0, 0}, // #575
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, 122, 5, 64, 2,  0, 0}, // #576
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 2, false, false, 122, 5, 64, 2,  0, 0}, // #577
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 2, false, false, 122, 5, 64, 2,  0, 0}, // #578
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 94, 2,  1, 1,  0, 0}, // #579
  {DBGFIELD("FCOMPP")             1, false, false, 94, 2,  2, 1,  0, 0}, // #580
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 107, 4,  1, 1,  0, 0}, // #581
  {DBGFIELD("MMX_CVTPI2PSirr")    2, false, false, 97, 4, 23, 1,  0, 0}, // #582
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 163, 6,  7, 1,  0, 0}, // #583
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 97, 4, 23, 1,  0, 0}, // #584
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 152, 2,  5, 1,  0, 0}, // #585
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 246, 2,  1, 1,  0, 0}, // #586
  {DBGFIELD("XCH_F")              1, false, false, 94, 2,  1, 1,  0, 0}, // #587
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 88, 6,  5, 1,  0, 0}, // #588
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 163, 6,  7, 1,  0, 0}, // #589
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 152, 2,  5, 1,  0, 0}, // #590
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, 94, 2,  2, 1,  0, 0}, // #591
  {DBGFIELD("LFENCE")             1, false, false, 246, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 103, 3,  8, 1,  0, 0}, // #593
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 79, 3,  8, 1,  0, 0}, // #594
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #595
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, 94, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("POP16r")             1, false, false, 152, 2,  5, 1,  0, 0}, // #597
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, 309, 3,  4, 1,  0, 0}, // #598
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 94, 2,  2, 1,  0, 0}, // #599
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 94, 2,  2, 1,  0, 0}, // #600
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 246, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 94, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #603
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, 94, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, 96, 6,  1, 1,  0, 0}, // #605
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, 96, 6,  1, 1,  0, 0}, // #606
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 79, 3,  8, 1,  0, 0}, // #607
  {DBGFIELD("CLD")                1, false, false, 94, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("LDDQUrm")            1, false, false, 209, 5,  5, 1,  0, 0}, // #609
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 94, 2,  2, 1,  0, 0}, // #610
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, 309, 3,  4, 1,  0, 0}, // #611
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 2, false, false, 122, 5, 64, 2,  0, 0}, // #612
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 79, 3,  5, 1,  0, 0}, // #613
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 127, 4,  5, 1,  0, 0}, // #614
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 209, 5,  3, 1, 10, 1}, // #615
  {DBGFIELD("MOVDQUrm")           1, false, false, 209, 5,  5, 1,  0, 0}, // #616
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 102, 5,  5, 1,  0, 0}, // #617
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 209, 5,  3, 1, 10, 1}, // #618
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 94, 2,  1, 1,  0, 0}, // #619
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, 89, 4,  1, 1,  0, 0}, // #620
  {DBGFIELD("LD_F80m")            1, false, false, 152, 2,  5, 1,  0, 0}, // #621
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 209, 5, 19, 1,  0, 0}, // #622
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 155, 7, 27, 1,  0, 0}, // #623
  {DBGFIELD("FLDCW16m")           1, false, false, 152, 2,  5, 1,  0, 0}, // #624
  {DBGFIELD("ST_FP80m")           1, false, false, 246, 2,  1, 1,  0, 0}, // #625
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 79, 3,  5, 1,  0, 0}, // #626
  {DBGFIELD("CMPXCHG8rm")         5, false, false, 83, 3, 22, 1,  0, 0}, // #627
  {DBGFIELD("INTO")               1, false, false, 94, 2,  2, 1,  0, 0}, // #628
  {DBGFIELD("XLAT")               1, false, false, 94, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, 320, 2, 23, 1,  0, 0}, // #630
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false, 322, 2, 23, 1,  0, 0}, // #631
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, 316, 4, 23, 1,  0, 0}, // #632
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, 316, 4, 23, 1,  0, 0}, // #633
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, 246, 2,  1, 1,  0, 0}, // #634
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 209, 5, 19, 1, 10, 1}, // #635
  {DBGFIELD("AAD8i8")             1, false, false, 94, 2,  2, 1,  0, 0}, // #636
  {DBGFIELD("LOOPE")              1, false, false, 89, 4,  1, 1,  0, 0}, // #637
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 246, 2,  1, 1,  0, 0}, // #638
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, 320, 2, 23, 1,  0, 0}, // #639
  {DBGFIELD("FNSTCW16m")          1, false, false, 94, 2,  1, 1,  0, 0}, // #640
  {DBGFIELD("POPA16_POPA32")      1, false, false, 152, 2,  5, 1,  0, 0}, // #641
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 246, 2,  1, 1,  0, 0}, // #642
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, 316, 4, 23, 1,  0, 0}, // #643
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, 316, 4, 23, 1,  0, 0}, // #644
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false, 322, 2, 23, 1,  0, 0}, // #645
  {DBGFIELD("CMPXCHG8rr")         3, false, false, 83, 3, 22, 1,  0, 0}, // #646
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 2, false, false, 155, 7,  1, 1,  0, 0}, // #647
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 170, 8, 27, 1,  0, 0}, // #648
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 154, 9,  4, 1, 10, 1}, // #649
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, 169, 10, 29, 1,  0, 0}, // #650
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 94, 2,  2, 1,  0, 0}, // #651
  {DBGFIELD("AAA_AAS")            1, false, false, 94, 2,  2, 1,  0, 0}, // #652
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 83, 3, 22, 1,  0, 0}, // #653
  {DBGFIELD("LOOPNE")             1, false, false, 89, 4,  1, 1,  0, 0}, // #654
  {DBGFIELD("PAUSE")              1, false, false, 94, 2,  1, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8B")          18, false, false, 83, 3, 22, 1,  0, 0}, // #656
  {DBGFIELD("DAA")                1, false, false, 94, 2,  2, 1,  0, 0}, // #657
  {DBGFIELD("LOOP")               1, false, false, 89, 4,  1, 1,  0, 0}, // #658
  {DBGFIELD("DAS")                1, false, false, 94, 2,  2, 1,  0, 0}, // #659
  {DBGFIELD("AAM8i8")             1, false, false, 94, 2,  2, 1,  0, 0}, // #660
  {DBGFIELD("STD")                1, false, false, 94, 2,  1, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16B")         22, false, false, 83, 3, 22, 1,  0, 0}, // #662
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 94, 2,  2, 1,  0, 0}, // #663
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, 94, 2,  2, 1,  0, 0}, // #664
  {DBGFIELD("POPF32_POPF64")      1, false, false, 152, 2,  5, 1,  0, 0}, // #665
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 94, 2,  2, 1,  0, 0}, // #666
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, 94, 2,  2, 1,  0, 0}, // #667
  {DBGFIELD("ENTER")              1, false, false, 94, 2,  2, 1,  0, 0}, // #668
  {DBGFIELD("POPF16")             1, false, false, 152, 2,  5, 1,  0, 0}, // #669
  {DBGFIELD("MONITORrrr")         1, false, false, 94, 2,  2, 1,  0, 0}, // #670
  {DBGFIELD("FRNDINT")            1, false, false, 94, 2,  2, 1,  0, 0}, // #671
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 94, 2,  2, 1,  0, 0}, // #672
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 94, 2,  2, 1,  0, 0}, // #673
  {DBGFIELD("FPREM")              1, false, false, 94, 2,  2, 1,  0, 0}, // #674
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, 94, 2,  2, 1,  0, 0}, // #675
  {DBGFIELD("FNINIT")             1, false, false, 94, 2,  2, 1,  0, 0}, // #676
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, 94, 2,  2, 1,  0, 0}, // #677
  {DBGFIELD("FPREM1")             1, false, false, 94, 2,  2, 1,  0, 0}, // #678
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 94, 2,  2, 1,  0, 0}, // #679
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, 94, 2,  2, 1,  0, 0}, // #680
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 94, 2,  2, 1,  0, 0}, // #681
  {DBGFIELD("FSCALE")             1, false, false, 94, 2,  2, 1,  0, 0}, // #682
  {DBGFIELD("RDMSR")              1, false, false, 94, 2,  2, 1,  0, 0}, // #683
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 88, 6,  5, 1,  0, 0}, // #684
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, 94, 2,  2, 1,  0, 0}, // #685
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, 94, 2,  2, 1,  0, 0}, // #686
  {DBGFIELD("F2XM1")              1, false, false, 94, 2,  2, 1,  0, 0}, // #687
  {DBGFIELD("CPUID")              1, false, false, 94, 2,  2, 1,  0, 0}, // #688
  {DBGFIELD("INT")                1, false, false, 94, 2,  2, 1,  0, 0}, // #689
  {DBGFIELD("INT3")               1, false, false, 94, 2,  2, 1,  0, 0}, // #690
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 94, 2,  2, 1,  0, 0}, // #691
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, 94, 2,  2, 1,  0, 0}, // #692
  {DBGFIELD("FYL2X")              1, false, false, 94, 2,  2, 1,  0, 0}, // #693
  {DBGFIELD("FYL2XP1")            1, false, false, 94, 2,  2, 1,  0, 0}, // #694
  {DBGFIELD("FPTAN")              1, false, false, 94, 2,  2, 1,  0, 0}, // #695
  {DBGFIELD("FSINCOS")            1, false, false, 94, 2,  2, 1,  0, 0}, // #696
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 94, 2,  2, 1,  0, 0}, // #697
  {DBGFIELD("FPATAN")             1, false, false, 94, 2,  2, 1,  0, 0}, // #698
  {DBGFIELD("WRMSR")              1, false, false, 94, 2,  2, 1,  0, 0}, // #699
  {DBGFIELD("COMP_FST0r_COM_FST0r") 2, false, false, 155, 7,  1, 1,  0, 0}, // #700
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   2, false, false, 155, 7,  1, 1,  0, 0}, // #701
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, 94, 2,  2, 1,  0, 0}, // #702
  {DBGFIELD("FNOP")               1, false, false, 94, 2,  1, 1,  0, 0}, // #703
  {DBGFIELD("RETQ")               1, false, false, 88, 6,  5, 1,  0, 0}, // #704
  {DBGFIELD("CDQ_CQO")            1, false, false, 94, 2,  1, 1,  0, 0}, // #705
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #706
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 79, 3,  8, 1,  0, 0}, // #707
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 79, 3,  8, 1,  0, 0}, // #708
  {DBGFIELD("SETAr_SETBEr")       1, false, false, 94, 2,  1, 1,  0, 0}, // #709
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, 94, 2,  2, 1,  0, 0}, // #710
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 2, false, false, 155, 7,  1, 1,  0, 0}, // #711
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 2, false, false, 155, 7,  1, 1,  0, 0}, // #712
  {DBGFIELD("CWD")                1, false, false, 94, 2,  1, 1,  0, 0}, // #713
  {DBGFIELD("FNSTSW16r")          1, false, false, 94, 2,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, 79, 3,  8, 1,  0, 0}, // #715
  {DBGFIELD("PUSHFS64")           1, false, false, 94, 2,  2, 1,  0, 0}, // #716
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 155, 7, 27, 1,  0, 0}, // #717
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false, 94, 2,  1, 1,  0, 0}, // #718
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 2, false, false, 155, 7,  1, 1,  0, 0}, // #719
  {DBGFIELD("MOV64sr")            1, false, false, 94, 2,  1, 1,  0, 0}, // #720
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 127, 4,  5, 1,  0, 0}, // #721
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 24, false, false, 94, 2,  9, 1,  0, 0}, // #722
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 25, false, false, 94, 2, 27, 1,  0, 0}, // #723
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #724
  {DBGFIELD("CLI")                1, false, false, 94, 2,  2, 1,  0, 0}, // #725
  {DBGFIELD("PUSHGS64")           1, false, false, 94, 2,  2, 1,  0, 0}, // #726
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, 246, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("CALL64pcrel32")      1, false, false, 89, 4,  1, 1,  0, 0}, // #728
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, 89, 4,  1, 1,  0, 0}, // #729
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 2, false, false, 96, 6, 27, 1,  0, 0}, // #730
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, 94, 2,  2, 1,  0, 0}, // #731
  {DBGFIELD("SETAm_SETBEm")       1, false, false, 312, 4,  1, 1,  0, 0}, // #732
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 2, false, false, 96, 6, 27, 1,  0, 0}, // #733
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 246, 2,  1, 1,  0, 0}, // #734
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, 152, 2,  5, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, 96, 6,  8, 1,  0, 0}, // #736
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 102, 5,  3, 1,  0, 0}, // #737
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 209, 5,  5, 1,  0, 0}, // #738
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 102, 5,  3, 1,  0, 0}, // #739
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 102, 5,  5, 1,  0, 0}, // #740
  {DBGFIELD("MOV16sm")            1, false, false, 94, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, 209, 5,  3, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, 209, 5,  3, 1, 10, 1}, // #743
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, 209, 5,  3, 1, 10, 1}, // #744
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 94, 2,  2, 1,  0, 0}, // #745
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, 476, 5,  4, 1,  9, 1}, // #746
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, 355, 5,  3, 1,  0, 0}, // #747
  {DBGFIELD("VINSERTF128rm")      2, false, false, 102, 5,  3, 1, 10, 1}, // #748
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 209, 5,  3, 1, 10, 1}, // #749
  {DBGFIELD("VERRm_VERWm")        1, false, false, 94, 2,  2, 1,  0, 0}, // #750
  {DBGFIELD("FARJMP64")           1, false, false, 89, 4,  1, 1,  0, 0}, // #751
  {DBGFIELD("FNSTSWm")            1, false, false, 94, 2,  2, 1,  0, 0}, // #752
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, 94, 2,  2, 1,  0, 0}, // #753
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, 88, 6,  5, 1,  0, 0}, // #754
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false, 89, 4,  1, 1,  0, 0}, // #755
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 154, 9,  4, 1, 10, 1}, // #756
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 94, 2,  2, 1,  0, 0}, // #757
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, 122, 5, 64, 2,  0, 0}, // #758
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 4, false, false, 83, 3,  4, 1,  0, 0}, // #759
  {DBGFIELD("FARCALL64")          1, false, false, 89, 4,  1, 1,  0, 0}, // #760
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, 169, 10, 29, 1,  0, 0}, // #761
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, 169, 10, 29, 1,  0, 0}, // #762
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 152, 2,  5, 1,  0, 0}, // #763
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, 122, 5, 64, 2,  0, 0}, // #764
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 2, false, false, 113, 5,  4, 1,  0, 0}, // #765
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 131, 6, 19, 1,  0, 0}, // #766
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, 209, 5,  3, 1, 10, 1}, // #767
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 2, false, false, 154, 9,  4, 1,  0, 0}, // #768
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 259, 6, 19, 1,  0, 0}, // #769
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 131, 6, 19, 1,  0, 0}, // #770
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 259, 6, 19, 1,  0, 0}, // #771
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 197, 6, 21, 1,  0, 0}, // #772
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 197, 6, 21, 1,  0, 0}, // #773
  {DBGFIELD("VZEROALL")           32, false, false,  0, 0, 67, 1,  0, 0}, // #774
  {DBGFIELD("VZEROUPPER")         16, false, false,  0, 0, 40, 1,  0, 0}, // #775
  {DBGFIELD("CLC")                1, false, false, 94, 2,  1, 1,  0, 0}, // #776
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #777
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #778
  {DBGFIELD("PXORrr_VPXORrr")     16382, false, false,  0, 0,  0, 0,  0, 0}, // #779
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #780
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #781
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #782
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, 102, 5,  3, 1, 10, 1}, // #783
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 88, 6,  5, 1,  0, 0}, // #784
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 88, 6,  5, 1,  0, 0}, // #785
  {DBGFIELD("RDPMC")              1, false, false, 94, 2,  2, 1,  0, 0}, // #786
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, 94, 2,  2, 1,  0, 0}, // #787
  {DBGFIELD("FBLDm")              1, false, false, 94, 2,  2, 1,  0, 0}, // #788
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 94, 2,  2, 1,  0, 0}, // #789
  {DBGFIELD("FSAVEm")             1, false, false, 94, 2,  2, 1,  0, 0}, // #790
  {DBGFIELD("FRSTORm")            1, false, false, 94, 2,  2, 1,  0, 0}, // #791
  {DBGFIELD("FXTRACT")            1, false, false, 94, 2,  2, 1,  0, 0}, // #792
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 102, 5,  3, 1,  0, 0}, // #793
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 209, 5,  3, 1,  0, 0}, // #794
  {DBGFIELD("VBROADCASTF128")     2, false, false, 103, 3,  3, 1,  0, 0}, // #795
  {DBGFIELD("VBROADCASTI128")     1, false, false, 209, 5,  3, 1,  0, 0}, // #796
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 209, 5,  3, 1,  0, 0}, // #797
  {DBGFIELD("FBSTPm")             1, false, false, 94, 2,  2, 1,  0, 0}, // #798
  {DBGFIELD("VMPTRSTm")           1, false, false, 94, 2,  2, 1,  0, 0}, // #799
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, 246, 2,  1, 1,  0, 0}, // #800
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 79, 3, 22, 1,  0, 0}, // #802
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 79, 3,  8, 1,  0, 0}, // #803
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false, 89, 4,  1, 1,  0, 0}, // #804
  {DBGFIELD("FINCSTP")            1, false, false, 94, 2,  2, 1,  0, 0}, // #805
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, 94, 2,  1, 1,  0, 0}, // #806
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("VPBLENDDrri")        1, false, false, 79, 3,  8, 1,  0, 0}, // #808
  {DBGFIELD("CMC_STC")            1, false, false, 94, 2,  1, 1,  0, 0}, // #809
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 94, 2,  2, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 163, 6, 27, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 1, false, false, 209, 5, 11, 1, 10, 1}, // #812
  {DBGFIELD("CVTSS2SDrm")         1, false, false, 163, 6,  7, 1,  0, 0}, // #813
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false, 163, 6,  7, 1, 10, 1}, // #814
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #815
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, 127, 4,  5, 1,  9, 1}, // #816
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, 209, 5,  3, 1,  0, 0}, // #817
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 1, false, false, 209, 5,  4, 1,  0, 0}, // #818
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 1, false, false, 88, 6,  5, 1,  0, 0}, // #819
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, 127, 4,  5, 1,  9, 1}, // #820
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, 127, 4,  5, 1,  0, 0}, // #821
  {DBGFIELD("VINSERTI128rm")      1, false, false, 209, 5,  4, 1, 10, 1}, // #822
  {DBGFIELD("VPBLENDDrmi")        1, false, false, 209, 5,  3, 1, 10, 1}, // #823
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #824
  {DBGFIELD("POP32r_POP64r")      1, false, false, 152, 2,  5, 1,  0, 0}, // #825
  {DBGFIELD("SFENCE")             1, false, false, 246, 2,  1, 1,  0, 0}, // #826
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("MOVBE16mr")          1, false, false, 246, 2,  1, 1,  0, 0}, // #828
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, 246, 2,  1, 1,  0, 0}, // #829
  {DBGFIELD("MFENCE")             1, false, false, 246, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("XGETBV")             1, false, false, 94, 2,  2, 1,  0, 0}, // #831
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 97, 4, 11, 1,  0, 0}, // #832
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false, 97, 4, 23, 1,  0, 0}, // #833
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false, 209, 5,  3, 1, 10, 1}, // #834
  {DBGFIELD("LRETQ_RETL")         1, false, false, 88, 6,  5, 1,  0, 0}, // #835
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 94, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 97, 4, 23, 1,  0, 0}, // #837
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, 366, 4, 23, 1,  0, 0}, // #838
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #839
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, 163, 6,  7, 1,  0, 0}, // #840
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 365, 6,  7, 1,  0, 0}, // #841
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 365, 6,  7, 1,  0, 0}, // #842
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 1, false, false, 209, 5,  4, 1,  0, 0}, // #843
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #844
  {DBGFIELD("CLDEMOTE")           1, false, false, 152, 2,  5, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 170, 8, 27, 1,  0, 0}, // #846
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 170, 8, 27, 1,  0, 0}, // #847
  {DBGFIELD("VCVTPS2PDYrr")       4, false, false, 366, 4, 11, 1,  0, 0}, // #848
  {DBGFIELD("MMX_CVTPI2PDirr")    2, false, false, 97, 4,  4, 1,  0, 0}, // #849
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 2, false, false, 97, 4,  4, 1,  0, 0}, // #850
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 97, 4, 11, 1,  0, 0}, // #851
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 97, 4, 11, 1,  0, 0}, // #852
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false, 97, 4, 23, 1,  0, 0}, // #853
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 97, 4, 23, 1,  0, 0}, // #854
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 97, 4, 23, 1,  0, 0}, // #855
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 97, 4, 11, 1,  0, 0}, // #856
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, 169, 10, 29, 1,  0, 0}, // #857
  {DBGFIELD("CVTSS2SI64rm_Int")   2, false, false, 169, 10, 29, 1,  0, 0}, // #858
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 169, 10, 29, 1,  0, 0}, // #859
  {DBGFIELD("VCVTPS2PDYrm")       5, false, false, 365, 6, 27, 1,  0, 0}, // #860
  {DBGFIELD("CVTPD2PSrm")         2, false, false, 163, 6, 27, 1,  0, 0}, // #861
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 2, false, false, 163, 6, 27, 1,  0, 0}, // #862
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, 163, 6, 27, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPI2PDirm")    2, false, false, 163, 6, 27, 1,  0, 0}, // #864
  {DBGFIELD("CVTSD2SSrm")         1, false, false, 163, 6,  7, 1,  0, 0}, // #865
  {DBGFIELD("VCVTSD2SSrm")        1, false, false, 163, 6,  7, 1, 10, 1}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, 209, 5,  3, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 45, false, false, 94, 2, 68, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, 94, 2,  2, 1,  0, 0}, // #869
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #870
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 107, 4,  5, 1,  0, 0}, // #871
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #872
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, 97, 4, 23, 1,  0, 0}, // #873
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, 94, 2,  2, 1,  0, 0}, // #874
  {DBGFIELD("XSETBV")             1, false, false, 94, 2,  2, 1,  0, 0}, // #875
  {DBGFIELD("VCVTDQ2PDYrr")       4, false, false, 366, 4, 11, 1,  0, 0}, // #876
  {DBGFIELD("VCVTPD2PSYrr")       4, false, false, 372, 5, 11, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 4, false, false, 372, 5, 11, 1,  0, 0}, // #878
  {DBGFIELD("VCVTDQ2PDYrm")       5, false, false, 365, 6, 27, 1,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 2, false, false, 122, 5, 64, 2,  0, 0}, // #880
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 20, false, false, 94, 2,  7, 1,  0, 0}, // #881
  {DBGFIELD("RCL8rCL")            26, false, false, 94, 2, 20, 1,  0, 0}, // #882
  {DBGFIELD("RDTSC")              1, false, false, 94, 2,  2, 1,  0, 0}, // #883
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, 94, 2,  2, 1,  0, 0}, // #884
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 198, 4,  7, 1,  0, 0}, // #885
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 197, 6, 21, 1,  0, 0}, // #886
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 197, 6, 21, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 198, 4,  7, 1,  0, 0}, // #888
  {DBGFIELD("XSAVE64")            1, false, false, 94, 2,  2, 1,  0, 0}, // #889
  {DBGFIELD("XSAVE")              1, false, false, 94, 2,  2, 1,  0, 0}, // #890
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, 94, 2,  2, 1,  0, 0}, // #891
  {DBGFIELD("VMCLEARm")           1, false, false, 94, 2,  2, 1,  0, 0}, // #892
  {DBGFIELD("FLDENVm")            1, false, false, 94, 2,  2, 1,  0, 0}, // #893
  {DBGFIELD("FXRSTOR64")          1, false, false, 94, 2,  2, 1,  0, 0}, // #894
  {DBGFIELD("FSTENVm")            1, false, false, 94, 2,  2, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #897
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 152, 2,  5, 1,  0, 0}, // #898
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 152, 2,  5, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPSYrm")      1, false, false, 152, 2,  5, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #904
  {DBGFIELD("ADC8i8_SBB8i8")      1, false, false, 111, 2,  1, 1,  0, 0}, // #905
  {DBGFIELD("ADC8ri_ADC8ri8_SBB8ri_SBB8ri8") 1, false, false, 111, 2,  1, 1,  0, 0}, // #906
  {DBGFIELD("VCVTSS2SDrm")        1, false, false, 163, 6,  7, 1, 10, 1}, // #907
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 107, 4,  4, 1,  0, 0}, // #908
  {DBGFIELD("LRETQ")              1, false, false, 88, 6,  5, 1,  0, 0}, // #909
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, 163, 6,  7, 1,  0, 0}, // #910
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 2, false, false, 163, 6, 27, 1,  0, 0}, // #911
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_Int") 1, false, false, 163, 6,  7, 1, 10, 1}, // #912
  {DBGFIELD("POPF64")             1, false, false, 152, 2,  5, 1,  0, 0}, // #913
  {DBGFIELD("VGATHERQPDrm")       1, false, false, 152, 2,  5, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm")      1, false, false, 152, 2,  5, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDrm")       1, false, false, 152, 2,  5, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSrm")       1, false, false, 152, 2,  5, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERDPDYrm")      1, false, false, 152, 2,  5, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERDPSYrm")      1, false, false, 152, 2,  5, 1,  0, 0}, // #919
  {DBGFIELD("MOV16rm")            1, false, false, 152, 2,  5, 1,  0, 0}, // #920
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 127, 4,  5, 1,  0, 0}, // #921
  {DBGFIELD("POP16rmm")           2, false, false, 309, 3,  4, 1,  0, 0}, // #922
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, 309, 3,  4, 1,  0, 0}, // #923
  {DBGFIELD("PUSHF16")            1, false, false, 246, 2,  1, 1,  0, 0}, // #924
  {DBGFIELD("LAHF")               4, false, false, 94, 2,  8, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 2, false, false, 122, 5,  4, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 2, false, false, 113, 5,  4, 1,  0, 0}, // #927
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 2, false, false, 122, 5,  4, 1,  0, 0}, // #928
  {DBGFIELD("MULX32rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("MULX32rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("MULX64rr")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("MULX64rm")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, 89, 4,  1, 1,  0, 0}, // #933
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 88, 6,  5, 1,  0, 0}, // #934
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 88, 6,  5, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 2, false, false, 122, 5,  4, 1,  0, 0}, // #936
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, 316, 4, 23, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, 320, 2, 23, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, 316, 4, 23, 1,  0, 0}, // #939
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 102, 5,  3, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 103, 3,  8, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 4, false, false, 83, 3,  8, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 107, 4,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 79, 3,  1, 1,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 1, false, false, 209, 5,  4, 1,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 79, 3,  8, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, 209, 5,  3, 1, 10, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 79, 3,  8, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, 96, 6,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, 96, 6,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 441, 5,  4, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, 451, 5,  4, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 436, 5,  4, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false, 446, 5,  4, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, 209, 5,  3, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 79, 3,  8, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 2, false, false, 79, 3,  8, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       8, false, false, 103, 3, 23, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       10, false, false, 103, 3, 11, 1,  0, 0}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 103, 3,  8, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 103, 3,  3, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      2, false, false, 103, 3,  8, 1,  0, 0}, // #964
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 163, 6, 27, 1,  0, 0}, // #965
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 4, false, false, 371, 7, 27, 1,  0, 0}, // #966
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 170, 8, 27, 1,  0, 0}, // #967
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 169, 10, 29, 1,  0, 0}, // #968
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 79, 3, 22, 1,  0, 0}, // #969
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 249, 3, 22, 1,  0, 0}, // #970
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 137, 6,  7, 1, 10, 1}, // #971
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 138, 4, 23, 1,  0, 0}, // #972
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 138, 4, 23, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 137, 6,  7, 1, 10, 1}, // #974
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 138, 4, 23, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 137, 6,  7, 1, 10, 1}, // #976
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 138, 4, 23, 1,  0, 0}, // #977
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 137, 6,  7, 1, 10, 1}, // #978
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 138, 4, 23, 1,  0, 0}, // #979
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 137, 6,  7, 1, 10, 1}, // #980
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 138, 4, 23, 1,  0, 0}, // #981
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 137, 6,  7, 1, 10, 1}, // #982
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 45, false, false, 94, 2, 68, 1,  0, 0}, // #983
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, 94, 2,  4, 1,  0, 0}, // #984
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 2, false, false, 94, 2,  8, 1,  0, 0}, // #985
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, 94, 2,  4, 1,  0, 0}, // #986
  {DBGFIELD("XCHG16rr")           2, false, false, 83, 3,  8, 1,  0, 0}, // #987
  {DBGFIELD("CRC32r32r16")        5, false, false, 149, 2,  5, 1,  0, 0}, // #988
  {DBGFIELD("CRC32r32r32")        7, false, false, 149, 2,  4, 1,  0, 0}, // #989
  {DBGFIELD("CRC32r64r64")        11, false, false, 149, 2, 19, 1,  0, 0}, // #990
  {DBGFIELD("CMOVG16rm_CMOVG32rm_CMOVG64rm_CMOVGE16rm_CMOVGE32rm_CMOVGE64rm_CMOVL16rm_CMOVL32rm_CMOVL64rm_CMOVLE16rm_CMOVLE32rm_CMOVLE64rm") 2, false, false, 127, 4,  5, 1,  0, 0}, // #991
  {DBGFIELD("SETGEm_SETGm_SETLEm_SETLm") 2, false, false, 111, 2,  1, 1,  0, 0}, // #992
  {DBGFIELD("SAHF")               2, false, false, 94, 2,  8, 1,  0, 0}, // #993
  {DBGFIELD("RCR8ri")             23, false, false, 94, 2, 20, 1,  0, 0}, // #994
  {DBGFIELD("RCL16rCL")           22, false, false, 94, 2, 19, 1,  0, 0}, // #995
  {DBGFIELD("RCR16ri")            19, false, false, 94, 2, 19, 1,  0, 0}, // #996
  {DBGFIELD("RCL32rCL_RCL64rCL")  17, false, false, 94, 2,  3, 1,  0, 0}, // #997
  {DBGFIELD("RCR64rCL")           16, false, false, 94, 2,  3, 1,  0, 0}, // #998
  {DBGFIELD("RCR32rCL")           16, false, false, 94, 2,  3, 1,  0, 0}, // #999
  {DBGFIELD("RCR32ri_RCR64ri")    15, false, false, 94, 2,  3, 1,  0, 0}, // #1000
  {DBGFIELD("RCL16ri")            21, false, false, 94, 2,  9, 1,  0, 0}, // #1001
  {DBGFIELD("RCL32ri_RCL64ri")    16, false, false, 94, 2, 11, 1,  0, 0}, // #1002
  {DBGFIELD("SHLD32rri8")         6, false, false, 322, 2, 22, 1,  0, 0}, // #1003
  {DBGFIELD("SHRD16rri8")         6, false, false, 322, 2, 22, 1,  0, 0}, // #1004
  {DBGFIELD("SHLD16rrCL")         7, false, false, 320, 2, 23, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, 96, 6,  8, 1,  0, 0}, // #1006
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8, false, false, 96, 6,  1, 1,  0, 0}, // #1007
  {DBGFIELD("TST_F")              1, false, false, 107, 4,  1, 1,  0, 0}, // #1008
  {DBGFIELD("VDPPSrri")           17, false, false, 204, 4, 34, 1,  0, 0}, // #1009
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr_VFRCZSDrr_VFRCZSSrr") 2, false, false, 97, 4, 19, 1,  0, 0}, // #1010
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 2, false, false, 97, 4, 10, 1,  0, 0}, // #1011
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 4, false, false, 366, 4, 19, 1,  0, 0}, // #1012
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8, false, false, 366, 4, 10, 1,  0, 0}, // #1013
  {DBGFIELD("MMX_CVTTPD2PIirr")   2, false, false, 97, 4,  4, 1,  0, 0}, // #1014
  {DBGFIELD("CVTSI642SDrr")       2, false, false, 97, 4, 27, 1,  0, 0}, // #1015
  {DBGFIELD("CVTSI642SSrr")       2, false, false, 97, 4, 27, 1,  0, 0}, // #1016
  {DBGFIELD("VMOVDQUYmr")         8, false, false, 96, 6,  1, 1,  0, 0}, // #1017
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 1, false, false, 303, 5, 23, 1,  0, 0}, // #1018
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, 79, 3,  5, 1,  0, 0}, // #1019
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, 209, 5, 19, 1,  0, 0}, // #1020
  {DBGFIELD("VPCLMULQDQrr")       6, false, false, 138, 4, 27, 1,  0, 0}, // #1021
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1022
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1023
  {DBGFIELD("PANDNrr_VPANDNrr")   16382, false, false,  0, 0,  0, 0,  0, 0}, // #1024
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1025
  {DBGFIELD("VXORPSYrr_VXORPDYrr_VANDNPSYrr_VANDNPDYrr") 2, false, false, 356, 3,  8, 1,  0, 0}, // #1026
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1027
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1028
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 2, false, false, 94, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("LEA16r")             2, false, false, 94, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1031
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1032
  {DBGFIELD("CLAC_STAC")          1, false, false, 94, 2,  2, 1,  0, 0}, // #1033
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1034
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1035
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1036
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 132, 4,  5, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 79, 3,  5, 1,  0, 0}, // #1038
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 79, 3,  5, 1,  0, 0}, // #1039
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1040
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1041
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, 366, 4, 23, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false, 209, 5,  3, 1, 10, 1}, // #1043
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 170, 8, 27, 1,  0, 0}, // #1044
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 170, 8, 27, 1,  0, 0}, // #1045
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, 209, 5,  3, 1, 10, 1}, // #1046
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 209, 5, 19, 1, 10, 1}, // #1048
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 209, 5, 19, 1,  0, 0}, // #1049
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, 94, 2,  2, 1,  0, 0}, // #1051
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1052
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 94, 2,  1, 1,  0, 0}, // #1053
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 94, 2,  1, 1,  0, 0}, // #1054
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, 144, 3,  8, 1,  0, 0}, // #1055
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, 361, 3,  8, 1,  0, 0}, // #1056
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1057
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, 249, 3,  8, 1,  0, 0}, // #1060
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1061
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 4, false, false, 96, 6,  1, 1,  0, 0}, // #1063
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 94, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1065
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1067
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 2, false, false, 79, 3,  8, 1,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 132, 4,  8, 1,  0, 0}, // #1072
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, 345, 4,  8, 1,  0, 0}, // #1073
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 132, 4,  8, 1,  0, 0}, // #1075
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1077
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, 366, 4, 23, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, 97, 4, 11, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 4, false, false, 372, 5, 11, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, 366, 4, 23, 1,  0, 0}, // #1086
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, 366, 4, 23, 1,  0, 0}, // #1088
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, 97, 4, 11, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 4, false, false, 366, 4, 11, 1,  0, 0}, // #1090
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, 79, 3,  1, 1,  0, 0}, // #1095
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, 79, 3,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 1, false, false, 209, 5,  4, 1,  0, 0}, // #1097
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, 97, 4, 11, 1,  0, 0}, // #1098
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, 97, 4, 11, 1,  0, 0}, // #1099
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, 97, 4, 11, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, 97, 4, 11, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1103
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1104
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 97, 4, 23, 1,  0, 0}, // #1105
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 97, 4, 23, 1,  0, 0}, // #1106
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, 97, 4, 23, 1,  0, 0}, // #1107
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1108
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 96, 6, 23, 1,  0, 0}, // #1109
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, 378, 7, 23, 1,  0, 0}, // #1110
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 1, false, false, 209, 5,  4, 1,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, 79, 3,  1, 1,  0, 0}, // #1113
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, 209, 5,  5, 1,  0, 0}, // #1114
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, 209, 5,  5, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, 97, 4, 23, 1,  0, 0}, // #1116
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 102, 5,  5, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 4, false, false, 366, 4, 11, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 4, false, false, 372, 5, 11, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 4, false, false, 372, 5, 11, 1,  0, 0}, // #1120
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 4, false, false, 366, 4, 11, 1,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 366, 4, 23, 1,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 366, 4, 23, 1,  0, 0}, // #1123
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, 209, 5,  5, 1,  0, 0}, // #1130
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 1, false, false, 143, 5,  3, 1, 10, 1}, // #1131
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false, 209, 5,  3, 1,  0, 0}, // #1132
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 102, 5,  3, 1,  0, 0}, // #1133
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 102, 5,  5, 1,  0, 0}, // #1134
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, 102, 5,  3, 1,  0, 0}, // #1135
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, 209, 5,  5, 1,  0, 0}, // #1136
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, 209, 5,  3, 1, 10, 1}, // #1137
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 1, false, false, 248, 5,  3, 1, 10, 1}, // #1138
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, 79, 3,  1, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, 170, 8, 27, 1,  0, 0}, // #1140
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 170, 8, 27, 1,  0, 0}, // #1141
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 2, false, false, 170, 8, 27, 1,  0, 0}, // #1142
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1143
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 1, false, false, 209, 5,  4, 1,  0, 0}, // #1144
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1145
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 246, 2,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 131, 6,  3, 1, 10, 1}, // #1149
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 1, false, false, 209, 5,  4, 1,  0, 0}, // #1150
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, 209, 5,  5, 1,  0, 0}, // #1151
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, 360, 5,  3, 1, 10, 1}, // #1152
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 1, false, false, 209, 5,  4, 1,  0, 0}, // #1154
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 350, 5,  3, 1,  0, 0}, // #1155
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 102, 5,  3, 1,  0, 0}, // #1156
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 102, 5,  3, 1, 10, 1}, // #1157
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1158
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, 102, 5,  5, 1,  0, 0}, // #1159
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 355, 5,  3, 1,  0, 0}, // #1160
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, 209, 5,  5, 1,  0, 0}, // #1162
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 246, 2,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 246, 2,  1, 1,  0, 0}, // #1170
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, 209, 5,  3, 1, 10, 1}, // #1171
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 1, false, false, 131, 6,  3, 1, 10, 1}, // #1172
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 131, 6,  3, 1, 10, 1}, // #1173
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, 209, 5,  3, 1, 10, 1}, // #1174
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1175
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 1, false, false, 209, 5,  4, 1,  0, 0}, // #1177
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, 209, 5,  3, 1, 10, 1}, // #1178
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 350, 5,  3, 1, 10, 1}, // #1179
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 344, 6,  3, 1, 10, 1}, // #1181
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 163, 6, 27, 1,  0, 0}, // #1187
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, 163, 6,  7, 1,  0, 0}, // #1188
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 163, 6, 27, 1,  0, 0}, // #1189
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 3, false, false, 163, 6, 27, 1,  0, 0}, // #1190
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, 163, 6,  7, 1,  0, 0}, // #1191
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 163, 6, 27, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false, 163, 6,  7, 1, 10, 1}, // #1193
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1194
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 5, false, false, 365, 6, 27, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 365, 6,  7, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 7, false, false, 365, 6, 27, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 5, false, false, 365, 6, 27, 1,  0, 0}, // #1201
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 4, false, false, 371, 7, 27, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 365, 6,  7, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1207
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false, 163, 6,  7, 1, 10, 1}, // #1208
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, 209, 5,  3, 1,  0, 0}, // #1209
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 138, 4, 23, 1,  0, 0}, // #1210
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1211
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1213
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 169, 10, 29, 1, 10, 1}, // #1214
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 169, 10, 29, 1, 10, 1}, // #1215
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1217
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1218
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 1, false, false, 209, 5,  4, 1, 10, 1}, // #1222
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, 209, 5,  3, 1,  0, 0}, // #1223
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 137, 6,  7, 1, 10, 1}, // #1224
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1227
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1228
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1229
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 79, 3,  8, 1,  0, 0}, // #1230
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1231
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1232
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1233
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1234
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 152, 2,  5, 1,  0, 0}, // #1236
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1237
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1238
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1239
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1240
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("PdWriteZeroLatency") 1, false, false,  0, 0,  0, 1,  0, 0}, // #1243
  {DBGFIELD("WriteVecALU")        1, false, false, 79, 3,  8, 1,  0, 0}, // #1244
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("WriteALU")           1, false, false, 94, 2,  1, 1,  0, 0}, // #1247
  {DBGFIELD("WriteFLogic")        1, false, false, 103, 3,  8, 1,  0, 0}, // #1248
  {DBGFIELD("WriteVecLogicX")     1, false, false, 79, 3,  8, 1,  0, 0}, // #1249
  {DBGFIELD("WriteVecALUX")       1, false, false, 79, 3,  8, 1,  0, 0}, // #1250
  {DBGFIELD("SBWriteResGroup30")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("WriteVecLogic")      1, false, false, 79, 3,  8, 1,  0, 0}, // #1254
  {DBGFIELD("WriteFLogicY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1257
}; // BdVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BroadwellModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 481, 4,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 485, 8, 11, 1,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 493, 6,  4, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 230, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 230, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 499, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 230, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       2, false, false, 503, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 507, 3,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       2, false, false, 503, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 507, 3,  4, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 230, 2,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 510, 8,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false, 499, 4,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 485, 8, 11, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, 493, 6,  4, 1, 10, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 518, 6,  3, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 524, 4,  4, 1, 10, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 537, 7, 22, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 537, 7, 22, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 537, 7, 22, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 537, 7, 22, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 528, 9, 11, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 544, 10, 20, 1, 10, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 510, 8,  3, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 554, 10, 63, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 564, 8, 21, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 572, 14, 69, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 586, 12, 36, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 510, 8,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 598, 8,  3, 1, 18, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 606, 6,  8, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 598, 8,  3, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 524, 4,  4, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, 532, 5,  4, 1, 10, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 482, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 554, 10,  3, 1, 10, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 564, 8,  8, 1,  0, 0}, // #44
  {DBGFIELD("WriteBLSLd")         2, false, false, 612, 6,  4, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLS")           1, false, false, 481, 4,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSFLd")         2, false, false, 528, 9, 11, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSF")           1, false, false, 537, 7, 22, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSRLd")         2, false, false, 528, 9, 11, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSR")           1, false, false, 537, 7, 22, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSWAP32")       1, false, false, 481, 4,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP64")       2, false, false, 606, 6,  8, 1,  0, 0}, // #52
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, 493, 6,  4, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, 524, 4,  4, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTest")       1, false, false, 499, 4,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 618, 8,  4, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, 518, 6,  4, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSet")    1, false, false, 499, 4,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 612, 6,  4, 1, 18, 1}, // #59
  {DBGFIELD("WriteBZHI")          1, false, false, 481, 4,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteLoad")          1, false, false, 507, 3,  5, 1,  0, 0}, // #61
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 3, false, false, 626, 6,  3, 1, 10, 1}, // #62
  {DBGFIELD("WriteCMOV2")         2, false, false, 632, 4,  8, 1,  0, 0}, // #63
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, 493, 6,  4, 1, 10, 1}, // #64
  {DBGFIELD("WriteCMOV")          1, false, false, 499, 4,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteFCMOV")         1, false, false, 537, 7, 22, 1,  0, 0}, // #66
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 524, 4,  4, 1, 18, 1}, // #67
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #68
  {DBGFIELD("WriteFCmp64X")       1, false, false, 537, 7, 22, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #70
  {DBGFIELD("WriteFCmpX")         1, false, false, 537, 7, 22, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #72
  {DBGFIELD("WriteFCmp64")        1, false, false, 537, 7, 22, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #74
  {DBGFIELD("WriteFCmp")          1, false, false, 537, 7, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 636, 4,  5, 1,  0, 0}, // #76
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #77
  {DBGFIELD("WriteFCom")          1, false, false, 537, 7, 22, 1,  0, 0}, // #78
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #79
  {DBGFIELD("WriteCRC32")         1, false, false, 537, 7, 22, 1,  0, 0}, // #80
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 528, 9,  7, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 537, 7, 23, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 528, 9,  7, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 537, 7, 23, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 528, 9, 11, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 537, 7, 22, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 537, 7, 22, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 528, 9, 11, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 537, 7, 22, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 537, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 528, 9, 11, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2I")       1, false, false, 537, 7, 22, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #97
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 537, 7, 22, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 528, 9,  7, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 528, 9,  7, 1, 10, 1}, // #100
  {DBGFIELD("WriteCvtI2SD")       1, false, false, 537, 7, 23, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 528, 9,  7, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 528, 9,  7, 1, 10, 1}, // #103
  {DBGFIELD("WriteCvtI2SS")       1, false, false, 537, 7, 23, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #106
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 537, 7, 22, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 528, 9, 11, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2I")       1, false, false, 537, 7, 22, 1,  0, 0}, // #109
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 17, 1, 19, 2}, // #110
  {DBGFIELD("WriteDiv16")         32, false, false, 656, 15, 70, 1,  0, 0}, // #111
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 17, 1, 19, 2}, // #112
  {DBGFIELD("WriteDiv32")         32, false, false, 656, 15, 70, 1,  0, 0}, // #113
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 17, 1, 19, 2}, // #114
  {DBGFIELD("WriteDiv64")         32, false, false, 656, 15, 70, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 17, 1, 19, 2}, // #116
  {DBGFIELD("WriteDiv8")          1, false, false, 671, 10, 34, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, 681, 12, 63, 1, 10, 1}, // #118
  {DBGFIELD("WriteFDiv64X")       1, false, false, 693, 10, 21, 1,  0, 0}, // #119
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, 703, 12,  6, 1, 10, 1}, // #120
  {DBGFIELD("WriteFDivX")         1, false, false, 715, 10,  9, 1,  0, 0}, // #121
  {DBGFIELD("WriteFDivLd")        2, false, false, 703, 12,  6, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv")          1, false, false, 725, 10,  9, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, 681, 12, 63, 1, 10, 1}, // #124
  {DBGFIELD("WriteFDiv64")        1, false, false, 735, 10, 21, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, 703, 12,  6, 1, 10, 1}, // #126
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, 745, 16, 21, 1, 10, 1}, // #127
  {DBGFIELD("WriteDPPD")          3, false, false, 761, 14,  7, 1,  0, 0}, // #128
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 775, 16, 63, 1, 10, 1}, // #129
  {DBGFIELD("WriteDPPS")          4, false, false, 791, 14, 21, 1,  0, 0}, // #130
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 805, 11,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteVecExtract")    2, false, false, 816, 12,  8, 1,  0, 0}, // #132
  {DBGFIELD("WriteVecALUX")       1, false, false, 481, 4,  1, 1,  0, 0}, // #133
  {DBGFIELD("WriteFComLd")        2, false, false, 528, 9, 11, 1,  0, 0}, // #134
  {DBGFIELD("WriteEMMS")          31, false, false, 828, 5, 71, 1,  0, 0}, // #135
  {DBGFIELD("WriteFLDC")          2, false, false, 833, 4,  1, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, 612, 6,  4, 1, 10, 1}, // #137
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 837, 13, 19, 1, 10, 1}, // #138
  {DBGFIELD("WriteFHAdd")         3, false, false, 850, 11,  5, 1,  0, 0}, // #139
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 72, 1, 19, 2}, // #140
  {DBGFIELD("WriteIDiv16")        1, false, false, 671, 10, 34, 1,  0, 0}, // #141
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 72, 1, 19, 2}, // #142
  {DBGFIELD("WriteIDiv32")        1, false, false, 671, 10, 34, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 72, 1, 19, 2}, // #144
  {DBGFIELD("WriteIDiv64")        1, false, false, 671, 10, 34, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 640, 16, 72, 1, 19, 2}, // #146
  {DBGFIELD("WriteIDiv8")         1, false, false, 671, 10, 34, 1,  0, 0}, // #147
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 861, 11,  7, 1, 19, 2}, // #148
  {DBGFIELD("WriteIMul16")        4, false, false, 872, 9, 23, 1,  0, 0}, // #149
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #150
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, 881, 9, 11, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 537, 7, 22, 1,  0, 0}, // #152
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 890, 7, 23, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, 897, 11,  7, 1, 19, 2}, // #154
  {DBGFIELD("WriteIMul32")        3, false, false, 908, 9, 23, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #156
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 528, 9, 11, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 537, 7, 22, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 537, 7, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 917, 13,  7, 1, 19, 2}, // #160
  {DBGFIELD("WriteIMul64")        2, false, false, 930, 11, 23, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #162
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 528, 9, 11, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 537, 7, 22, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 537, 7, 22, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 19, 2}, // #166
  {DBGFIELD("WriteIMul8")         1, false, false, 537, 7, 22, 1,  0, 0}, // #167
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #168
  {DBGFIELD("WriteFShuffle")      1, false, false, 510, 8,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteStore")         1, false, false, 503, 4,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteVecLogicX")     1, false, false, 482, 3,  1, 1,  0, 0}, // #171
  {DBGFIELD("WriteShuffle")       1, false, false, 510, 8,  1, 1,  0, 0}, // #172
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 499, 4,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLoadX")      1, false, false, 507, 3,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 941, 11,  3, 1,  0, 0}, // #175
  {DBGFIELD("WriteFLD0")          1, false, false, 952, 4,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteFLD1")          2, false, false, 833, 4,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteLEA")           1, false, false, 481, 4,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteFence")         1, false, false, 956, 5,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 528, 9, 11, 1,  0, 0}, // #180
  {DBGFIELD("WriteLZCNT")         1, false, false, 537, 7, 22, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecStoreX")     2, false, false, 503, 4,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecStore")      2, false, false, 503, 4,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 672, 9,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoad")       1, false, false, 507, 3,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveX")      1, false, false, 482, 3,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 503, 4,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMove")       1, false, false, 482, 3,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecALULd")      2, false, false, 612, 6,  4, 1,  0, 0}, // #190
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #191
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, 612, 6,  4, 1, 10, 1}, // #192
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, 532, 5,  4, 1, 10, 1}, // #193
  {DBGFIELD("WriteVecLogic")      1, false, false, 482, 3,  1, 1,  0, 0}, // #194
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 961, 10, 11, 1, 10, 1}, // #195
  {DBGFIELD("WritePHAdd")         3, false, false, 971, 8, 22, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #197
  {DBGFIELD("WriteVecInsert")     2, false, false, 564, 8,  8, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #199
  {DBGFIELD("WriteVecIMul")       1, false, false, 672, 9,  5, 1,  0, 0}, // #200
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 672, 9,  1, 1,  0, 0}, // #201
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #202
  {DBGFIELD("WritePSADBW")        1, false, false, 672, 9,  5, 1,  0, 0}, // #203
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #204
  {DBGFIELD("WriteVarShuffle")    1, false, false, 510, 8,  1, 1,  0, 0}, // #205
  {DBGFIELD("WriteShuffleLd")     2, false, false, 544, 10,  4, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 672, 9,  1, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, 682, 11,  4, 1, 10, 1}, // #208
  {DBGFIELD("WriteVecShift")      1, false, false, 672, 9,  1, 1,  0, 0}, // #209
  {DBGFIELD("WriteFMoveX")        1, false, false, 510, 8,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 544, 10,  4, 1,  0, 0}, // #211
  {DBGFIELD("WriteFStore")        2, false, false, 503, 4,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 672, 9, 22, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 507, 3,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteStoreNT")       2, false, false, 503, 4,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 503, 4,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFStoreNT")      2, false, false, 503, 4,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFLoad")         1, false, false, 507, 3,  5, 1,  0, 0}, // #218
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 4, false, false, 979, 14, 20, 1, 10, 1}, // #219
  {DBGFIELD("WriteMPSAD")         3, false, false, 993, 12,  3, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 11, 1, 10, 1}, // #221
  {DBGFIELD("WriteFMul64X")       1, false, false, 952, 4, 22, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 11, 1, 10, 1}, // #223
  {DBGFIELD("WriteFMulX")         1, false, false, 952, 4, 22, 1,  0, 0}, // #224
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, 1005, 6, 11, 1, 10, 1}, // #225
  {DBGFIELD("WriteFMul64")        1, false, false, 952, 4, 22, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, 1005, 6, 11, 1, 10, 1}, // #227
  {DBGFIELD("WriteFMul")          1, false, false, 952, 4, 22, 1,  0, 0}, // #228
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 5, false, false, 897, 11, 73, 2,  0, 0}, // #229
  {DBGFIELD("WriteIMul32_WriteIMulH") 4, false, false, 908, 9, 75, 2,  0, 0}, // #230
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 4, false, false, 917, 13, 73, 2,  0, 0}, // #231
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 930, 11, 75, 2,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd")        2, false, false, 1005, 6, 11, 1,  0, 0}, // #233
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 612, 6,  4, 1,  0, 0}, // #234
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #235
  {DBGFIELD("WriteShuffleX")      1, false, false, 510, 8,  1, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, 532, 5,  4, 1, 10, 1}, // #237
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 554, 10,  3, 1, 10, 1}, // #238
  {DBGFIELD("WriteVarBlend")      2, false, false, 564, 8,  8, 1,  0, 0}, // #239
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #240
  {DBGFIELD("WriteBlend")         1, false, false, 510, 8,  1, 1,  0, 0}, // #241
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #242
  {DBGFIELD("WriteCLMul")         1, false, false, 672, 9,  5, 1,  0, 0}, // #243
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, 1011, 14, 33, 1, 10, 1}, // #244
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 1025, 12, 29, 1,  0, 0}, // #245
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, 1037, 14, 77, 1, 10, 1}, // #246
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 1051, 12, 63, 1,  0, 0}, // #247
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, 1063, 11,  6, 1, 10, 1}, // #248
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 1074, 9,  9, 1,  0, 0}, // #249
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, 1063, 11,  6, 1, 10, 1}, // #250
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 1074, 9,  9, 1,  0, 0}, // #251
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #252
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, 961, 10, 11, 1, 10, 1}, // #253
  {DBGFIELD("WritePHAddX")        3, false, false, 971, 8, 22, 1,  0, 0}, // #254
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 682, 11, 19, 1,  0, 0}, // #255
  {DBGFIELD("WritePHMINPOS")      1, false, false, 672, 9,  5, 1,  0, 0}, // #256
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, 528, 9,  7, 1, 10, 1}, // #257
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #258
  {DBGFIELD("WriteVecIMulX")      1, false, false, 672, 9,  5, 1,  0, 0}, // #259
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 672, 9, 22, 1,  0, 0}, // #260
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 544, 10,  4, 1,  0, 0}, // #261
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, 1083, 11, 10, 1, 10, 1}, // #262
  {DBGFIELD("WritePMULLD")        2, false, false, 1094, 9, 19, 1,  0, 0}, // #263
  {DBGFIELD("WriteCopy")          2, false, false, 1103, 5,  4, 1,  0, 0}, // #264
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 528, 9, 11, 1,  0, 0}, // #265
  {DBGFIELD("WritePOPCNT")        1, false, false, 537, 7, 22, 1,  0, 0}, // #266
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #267
  {DBGFIELD("WritePSADBWX")       1, false, false, 672, 9,  5, 1,  0, 0}, // #268
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #269
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 510, 8,  1, 1,  0, 0}, // #270
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 672, 9,  1, 1,  0, 0}, // #271
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, 1108, 14,  3, 1, 10, 1}, // #272
  {DBGFIELD("WriteVecShiftX")     2, false, false, 816, 12,  8, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, 1108, 14,  3, 1, 10, 1}, // #274
  {DBGFIELD("WriteVecTest")       2, false, false, 816, 12,  8, 1,  0, 0}, // #275
  {DBGFIELD("WriteRotateLd_WriteRMW") 4, false, false, 1122, 8, 78, 2,  0, 0}, // #276
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, 485, 8, 80, 2,  0, 0}, // #277
  {DBGFIELD("WriteRotate")        2, false, false, 1130, 4,  8, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateCL")      3, false, false, 1134, 4, 22, 1,  0, 0}, // #279
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 682, 11, 19, 1,  0, 0}, // #280
  {DBGFIELD("WriteFRcpX")         1, false, false, 672, 9,  5, 1,  0, 0}, // #281
  {DBGFIELD("WriteFRcpLd")        2, false, false, 682, 11, 19, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #283
  {DBGFIELD("WriteFRcp")          1, false, false, 672, 9,  5, 1,  0, 0}, // #284
  {DBGFIELD("WriteRMW")           1, false, false, 503, 4,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteShiftLd")       2, false, false, 493, 6,  4, 1,  0, 0}, // #286
  {DBGFIELD("WriteShift")         1, false, false, 499, 4,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteFRndLd")        3, false, false, 1138, 9,  9, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRnd")          1, false, false, 507, 3,  4, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, 1138, 9,  9, 1, 10, 1}, // #290
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 682, 11, 19, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 672, 9,  5, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, 682, 11, 19, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #294
  {DBGFIELD("WriteFRsqrt")        1, false, false, 672, 9,  5, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 618, 8, 82, 2,  0, 0}, // #296
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, 485, 8, 80, 2,  0, 0}, // #297
  {DBGFIELD("WriteShiftCL")       3, false, false, 1134, 4, 22, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 493, 6,  4, 1, 18, 1}, // #299
  {DBGFIELD("WriteSETCCStore")    3, false, false, 1147, 7,  8, 1,  0, 0}, // #300
  {DBGFIELD("WriteSETCC")         1, false, false, 499, 4,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 1154, 11,  9, 1,  0, 0}, // #302
  {DBGFIELD("WriteSHDmri")        4, false, false, 1165, 9,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 872, 9,  4, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDrri")        1, false, false, 537, 7, 22, 1,  0, 0}, // #305
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 1174, 12, 31, 1,  0, 0}, // #306
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 1186, 10,  6, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 1196, 12,  6, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrtX")        1, false, false, 1208, 10,  9, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, 1174, 12, 31, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, 1174, 12, 31, 1, 10, 1}, // #311
  {DBGFIELD("WriteFSqrt64")       1, false, false, 693, 10,  6, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrtLd")       2, false, false, 1196, 12,  6, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, 1196, 12,  6, 1, 10, 1}, // #314
  {DBGFIELD("WriteFSqrt")         1, false, false, 735, 10,  9, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt80")       1, false, false, 1218, 10, 33, 1,  0, 0}, // #316
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 805, 11,  8, 1,  0, 0}, // #317
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 528, 9, 11, 1,  0, 0}, // #318
  {DBGFIELD("WriteTZCNT")         1, false, false, 537, 7, 22, 1,  0, 0}, // #319
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("WriteFMALd")         2, false, false, 1005, 6, 19, 1,  0, 0}, // #321
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 528, 9,  7, 1, 21, 1}, // #322
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 537, 7, 22, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 528, 9,  7, 1, 21, 1}, // #326
  {DBGFIELD("WriteFAddY")         1, false, false, 537, 7, 22, 1,  0, 0}, // #327
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #330
  {DBGFIELD("WriteShuffleY")      1, false, false, 510, 8,  1, 1,  0, 0}, // #331
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #334
  {DBGFIELD("WriteFLogicY")       1, false, false, 510, 8,  1, 1,  0, 0}, // #335
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, 554, 10, 11, 1, 21, 1}, // #338
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 564, 8,  8, 1,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 532, 5,  3, 1, 21, 1}, // #342
  {DBGFIELD("WriteFBlendY")       1, false, false, 482, 3,  1, 1,  0, 0}, // #343
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 554, 10, 11, 1, 22, 2}, // #344
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 554, 10,  3, 1, 14, 2}, // #345
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 544, 10,  7, 1,  0, 0}, // #346
  {DBGFIELD("WriteShuffle256")    1, false, false, 510, 8, 22, 1,  0, 0}, // #347
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 544, 10,  3, 1,  0, 0}, // #348
  {DBGFIELD("WriteFShuffle256")   1, false, false, 510, 8, 22, 1,  0, 0}, // #349
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 544, 10,  7, 1,  0, 0}, // #350
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 528, 9,  7, 1, 21, 1}, // #351
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 537, 7, 22, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 528, 9,  7, 1, 21, 1}, // #353
  {DBGFIELD("WriteFCmpY")         1, false, false, 537, 7, 22, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 544, 10,  7, 1,  0, 0}, // #357
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 510, 8, 22, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 528, 9,  7, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 537, 7, 23, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 528, 9,  7, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 537, 7, 23, 1,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 537, 7, 22, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, 528, 9, 11, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, 537, 7, 22, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 682, 11,  4, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 816, 12,  8, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 682, 11,  4, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 816, 12,  8, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 537, 7, 22, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 528, 9, 11, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, 537, 7, 22, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, 1228, 10,  3, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 930, 11,  4, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, 1228, 10,  5, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 930, 11, 23, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #395
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #396
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  9, 1, 21, 1}, // #397
  {DBGFIELD("WritePSADBWY")       1, false, false, 672, 9,  5, 1,  0, 0}, // #398
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 4, false, false, 1238, 12, 36, 1, 21, 1}, // #401
  {DBGFIELD("WriteFDiv64Y")       3, false, false, 1250, 10, 33, 1,  0, 0}, // #402
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 4, false, false, 1260, 12, 33, 1, 21, 1}, // #405
  {DBGFIELD("WriteFDivY")         3, false, false, 1272, 10, 28, 1,  0, 0}, // #406
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, 775, 16, 30, 1, 21, 1}, // #409
  {DBGFIELD("WriteDPPSY")         4, false, false, 791, 14, 21, 1,  0, 0}, // #410
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10,  7, 1, 21, 1}, // #411
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 24, 2}, // #412
  {DBGFIELD("WriteFMAY")          1, false, false, 952, 4,  5, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 10, 1}, // #414
  {DBGFIELD("WriteFMAX")          1, false, false, 952, 4,  5, 1,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 21, 1}, // #416
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 16, 2}, // #419
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, 1005, 6, 19, 1, 10, 1}, // #420
  {DBGFIELD("WriteFMA")           1, false, false, 952, 4,  5, 1,  0, 0}, // #421
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, 1005, 6, 19, 1, 16, 2}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 22, 2}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 14, 2}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, 1005, 6, 19, 1, 14, 2}, // #425
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, 1138, 9, 20, 1, 21, 1}, // #426
  {DBGFIELD("WriteFRndY")         1, false, false, 507, 3,  4, 1,  0, 0}, // #427
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  9, 1, 21, 1}, // #430
  {DBGFIELD("WriteVecIMulY")      1, false, false, 672, 9,  5, 1,  0, 0}, // #431
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, 612, 6,  3, 1, 21, 1}, // #434
  {DBGFIELD("WriteVecALUY")       1, false, false, 481, 4,  1, 1,  0, 0}, // #435
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, 837, 13,  9, 1, 21, 1}, // #438
  {DBGFIELD("WriteFHAddY")        3, false, false, 850, 11,  5, 1,  0, 0}, // #439
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10,  7, 1, 21, 1}, // #440
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10,  7, 1, 21, 1}, // #441
  {DBGFIELD("WriteVecLoadY")      1, false, false, 507, 3,  4, 1,  0, 0}, // #442
  {DBGFIELD("WriteFMaskedStoreY") 4, false, false, 1282, 12,  5, 1,  0, 0}, // #443
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, 554, 10, 11, 1,  0, 0}, // #444
  {DBGFIELD("WriteFMaskedStore")  4, false, false, 1282, 12,  5, 1,  0, 0}, // #445
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, 554, 10,  3, 1,  0, 0}, // #446
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteFMoveY")        1, false, false, 510, 8,  1, 1,  0, 0}, // #449
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 544, 10,  3, 1,  0, 0}, // #450
  {DBGFIELD("WriteFShuffleY")     1, false, false, 510, 8,  1, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecStoreY")     2, false, false, 503, 4,  1, 1,  0, 0}, // #454
  {DBGFIELD("WriteVecMoveY")      1, false, false, 482, 3,  1, 1,  0, 0}, // #455
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 507, 3,  4, 1,  0, 0}, // #456
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 503, 4,  1, 1,  0, 0}, // #457
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 503, 4,  1, 1,  0, 0}, // #458
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 4, false, false, 979, 14, 27, 1, 21, 1}, // #459
  {DBGFIELD("WriteMPSADY")        3, false, false, 993, 12,  3, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  7, 1, 21, 1}, // #461
  {DBGFIELD("WriteFMul64Y")       1, false, false, 952, 4, 22, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  7, 1, 21, 1}, // #465
  {DBGFIELD("WriteFMulY")         1, false, false, 952, 4, 22, 1,  0, 0}, // #466
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 612, 6,  3, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, 532, 5,  3, 1, 21, 1}, // #471
  {DBGFIELD("WriteVecLogicY")     1, false, false, 482, 3,  1, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #475
  {DBGFIELD("WriteBlendY")        1, false, false, 510, 8,  1, 1,  0, 0}, // #476
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, 554, 10, 11, 1, 21, 1}, // #477
  {DBGFIELD("WriteVarBlendY")     2, false, false, 564, 8,  8, 1,  0, 0}, // #478
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 554, 10, 11, 1, 22, 2}, // #481
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 554, 10,  3, 1, 14, 2}, // #482
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 22, 2}, // #483
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 24, 2}, // #484
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 14, 2}, // #485
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 16, 2}, // #486
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10,  7, 1, 21, 1}, // #487
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 510, 8, 22, 1,  0, 0}, // #488
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 22, 2}, // #489
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 24, 2}, // #490
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 510, 8,  1, 1,  0, 0}, // #491
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 14, 2}, // #492
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 16, 2}, // #493
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 510, 8,  1, 1,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #495
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #496
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, 961, 10,  7, 1, 21, 1}, // #499
  {DBGFIELD("WritePHAddY")        3, false, false, 971, 8, 22, 1,  0, 0}, // #500
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 682, 11, 19, 1,  0, 0}, // #501
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 682, 11,  9, 1,  0, 0}, // #502
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecMaskedStoreY") 4, false, false, 1282, 12,  5, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, 554, 10, 11, 1,  0, 0}, // #505
  {DBGFIELD("WriteVecMaskedStore") 4, false, false, 1282, 12,  5, 1,  0, 0}, // #506
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, 554, 10,  3, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 672, 9, 22, 1,  0, 0}, // #508
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, 1083, 11,  6, 1, 21, 1}, // #509
  {DBGFIELD("WritePMULLDY")       2, false, false, 1094, 9, 19, 1,  0, 0}, // #510
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 14, 2}, // #513
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  4, 1, 16, 2}, // #514
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 682, 11,  4, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 682, 11,  3, 1,  0, 0}, // #516
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 672, 9,  1, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 4, false, false, 1294, 14, 11, 1, 10, 1}, // #520
  {DBGFIELD("WriteVarVecShift")   3, false, false, 1308, 12, 22, 1,  0, 0}, // #521
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 4, false, false, 1294, 14,  7, 1, 21, 1}, // #522
  {DBGFIELD("WriteVarVecShiftY")  3, false, false, 1308, 12, 22, 1,  0, 0}, // #523
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, 682, 11,  4, 1, 10, 1}, // #526
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #527
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 510, 8,  1, 1,  0, 0}, // #528
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  3, 1, 21, 1}, // #532
  {DBGFIELD("WriteVecShiftY")     2, false, false, 816, 12, 23, 1,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, 1108, 14, 19, 1, 21, 1}, // #536
  {DBGFIELD("WriteVecTestY")      2, false, false, 816, 12, 23, 1,  0, 0}, // #537
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #538
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 4, false, false, 1239, 11, 28, 1, 21, 1}, // #539
  {DBGFIELD("WriteFRcpY")         3, false, false, 1251, 9,  9, 1,  0, 0}, // #540
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteFRcpYLd")       4, false, false, 1239, 11, 28, 1,  0, 0}, // #543
  {DBGFIELD("WriteFRndYLd")       3, false, false, 1138, 9, 20, 1,  0, 0}, // #544
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 10, 1}, // #545
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 4, false, false, 1239, 11, 28, 1, 21, 1}, // #546
  {DBGFIELD("WriteFRsqrtY")       3, false, false, 1251, 9,  9, 1,  0, 0}, // #547
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, 1239, 11, 28, 1,  0, 0}, // #550
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #551
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, 1320, 12, 72, 1,  0, 0}, // #553
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, 1332, 10, 36, 1,  0, 0}, // #554
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, 1174, 12, 31, 1, 10, 1}, // #555
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 4, false, false, 1320, 12, 72, 1, 21, 1}, // #556
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, 1342, 12, 66, 1,  0, 0}, // #559
  {DBGFIELD("WriteFSqrtY")        3, false, false, 1354, 10, 31, 1,  0, 0}, // #560
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, 1196, 12,  6, 1, 10, 1}, // #561
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 4, false, false, 1342, 12, 66, 1, 21, 1}, // #562
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  3, 1, 21, 1}, // #565
  {DBGFIELD("WriteFTestY")        1, false, false, 672, 9,  1, 1,  0, 0}, // #566
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, 682, 11,  4, 1, 10, 1}, // #567
  {DBGFIELD("WriteFTest")         1, false, false, 672, 9,  1, 1,  0, 0}, // #568
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 518, 6, 82, 2,  0, 0}, // #569
  {DBGFIELD("WriteXCHG")          3, false, false, 773, 2,  8, 1,  0, 0}, // #570
  {DBGFIELD("COPY")               1, false, false, 230, 2,  1, 1,  0, 0}, // #571
  {DBGFIELD("FXAM")               1, false, false, 230, 2,  2, 1,  0, 0}, // #572
  {DBGFIELD("LD_Frr")             1, false, false, 230, 2,  1, 1,  0, 0}, // #573
  {DBGFIELD("MOVSX64rr32")        1, false, false, 230, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1364, 6, 11, 1,  0, 0}, // #575
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, 1370, 11, 29, 1,  0, 0}, // #576
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, 618, 8,  4, 1,  0, 0}, // #577
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 485, 8, 11, 1,  0, 0}, // #578
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 230, 2,  1, 1,  0, 0}, // #579
  {DBGFIELD("FCOMPP")             1, false, false, 230, 2,  2, 1,  0, 0}, // #580
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #581
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 537, 7, 22, 1,  0, 0}, // #582
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 528, 9, 11, 1,  0, 0}, // #583
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 930, 11, 23, 1,  0, 0}, // #584
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 524, 4,  4, 1,  0, 0}, // #585
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 503, 4,  1, 1,  0, 0}, // #586
  {DBGFIELD("XCH_F")              12, false, false, 1381, 14, 21, 1,  0, 0}, // #587
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 493, 6,  4, 1,  0, 0}, // #588
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #589
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 528, 9,  7, 1,  0, 0}, // #590
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 570, 2,  8, 1,  0, 0}, // #591
  {DBGFIELD("LFENCE")             2, false, false, 570, 2,  8, 1,  0, 0}, // #592
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 510, 8,  1, 1,  0, 0}, // #593
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 510, 8,  1, 1,  0, 0}, // #594
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #595
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 1395, 4,  3, 1,  0, 0}, // #596
  {DBGFIELD("POP16r")             2, false, false, 524, 4,  4, 1,  0, 0}, // #597
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 518, 6,  4, 1,  0, 0}, // #598
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 230, 2,  2, 1,  0, 0}, // #599
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 230, 2,  2, 1,  0, 0}, // #600
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 503, 4,  1, 1,  0, 0}, // #601
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 230, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, 230, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 503, 4,  1, 1,  0, 0}, // #605
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 503, 4,  1, 1,  0, 0}, // #606
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 481, 4,  1, 1,  0, 0}, // #607
  {DBGFIELD("CLD")                3, false, false, 1399, 7, 22, 1,  0, 0}, // #608
  {DBGFIELD("LDDQUrm")            1, false, false, 507, 3,  5, 1,  0, 0}, // #609
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 230, 2,  2, 1,  0, 0}, // #610
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 518, 6,  4, 1,  0, 0}, // #611
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 6, false, false, 1406, 6, 11, 1,  0, 0}, // #612
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 971, 8, 22, 1,  0, 0}, // #613
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 507, 3,  5, 1,  0, 0}, // #614
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 612, 6,  4, 1, 10, 1}, // #615
  {DBGFIELD("MOVDQUrm")           1, false, false, 507, 3,  5, 1,  0, 0}, // #616
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 507, 3,  5, 1,  0, 0}, // #617
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 612, 6,  4, 1, 10, 1}, // #618
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 230, 2,  1, 1,  0, 0}, // #619
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 632, 4,  8, 1,  0, 0}, // #620
  {DBGFIELD("LD_F80m")            1, false, false, 507, 3,  4, 1,  0, 0}, // #621
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 961, 10, 11, 1, 10, 1}, // #622
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 816, 12,  8, 1,  0, 0}, // #623
  {DBGFIELD("FLDCW16m")           3, false, false, 1412, 11,  3, 1,  0, 0}, // #624
  {DBGFIELD("ST_FP80m")           2, false, false, 503, 4,  1, 1,  0, 0}, // #625
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 971, 8, 22, 1,  0, 0}, // #626
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 485, 8, 11, 1,  0, 0}, // #627
  {DBGFIELD("INTO")               1, false, false, 230, 2,  2, 1,  0, 0}, // #628
  {DBGFIELD("XLAT")               1, false, false, 507, 3,  5, 1,  0, 0}, // #629
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 872, 9,  4, 1,  0, 0}, // #630
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 537, 7, 22, 1,  0, 0}, // #631
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 1154, 11,  9, 1,  0, 0}, // #632
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 1165, 9,  7, 1,  0, 0}, // #633
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 1228, 10, 23, 1,  0, 0}, // #634
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 961, 10, 11, 1, 10, 1}, // #635
  {DBGFIELD("AAD8i8")             1, false, false, 230, 2,  2, 1,  0, 0}, // #636
  {DBGFIELD("LOOPE")              11, false, false, 1423, 4,  9, 1,  0, 0}, // #637
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 503, 4,  1, 1,  0, 0}, // #638
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 872, 9,  4, 1,  0, 0}, // #639
  {DBGFIELD("FNSTCW16m")          3, false, false, 1427, 10,  8, 1,  0, 0}, // #640
  {DBGFIELD("POPA16_POPA32")      1, false, false, 507, 3,  5, 1,  0, 0}, // #641
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 503, 4,  1, 1,  0, 0}, // #642
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 1154, 11,  9, 1,  0, 0}, // #643
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 1165, 9,  7, 1,  0, 0}, // #644
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 537, 7, 22, 1,  0, 0}, // #645
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 636, 4,  5, 1,  0, 0}, // #646
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 537, 7, 22, 1,  0, 0}, // #647
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 1437, 12, 23, 1,  0, 0}, // #648
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 528, 9, 11, 1, 10, 1}, // #649
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 745, 16, 19, 1,  0, 0}, // #650
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 230, 2,  2, 1,  0, 0}, // #651
  {DBGFIELD("AAA_AAS")            1, false, false, 230, 2,  2, 1,  0, 0}, // #652
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 485, 8, 11, 1,  0, 0}, // #653
  {DBGFIELD("LOOPNE")             11, false, false, 1423, 4,  9, 1,  0, 0}, // #654
  {DBGFIELD("PAUSE")              5, false, false, 1449, 7,  5, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8B")          14, false, false, 1456, 10,  6, 1,  0, 0}, // #656
  {DBGFIELD("DAA")                1, false, false, 230, 2,  2, 1,  0, 0}, // #657
  {DBGFIELD("LOOP")               7, false, false, 1466, 9,  3, 1,  0, 0}, // #658
  {DBGFIELD("DAS")                1, false, false, 230, 2,  2, 1,  0, 0}, // #659
  {DBGFIELD("AAM8i8")             1, false, false, 230, 2,  2, 1,  0, 0}, // #660
  {DBGFIELD("STD")                6, false, false, 1475, 7,  4, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16B")         19, false, false, 1482, 15, 31, 1,  0, 0}, // #662
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 230, 2,  2, 1,  0, 0}, // #663
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 803, 2, 23, 1,  0, 0}, // #664
  {DBGFIELD("POPF32_POPF64")      1, false, false, 507, 3,  5, 1,  0, 0}, // #665
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 230, 2,  2, 1,  0, 0}, // #666
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, 1497, 8, 84, 1,  0, 0}, // #667
  {DBGFIELD("ENTER")              1, false, false, 230, 2,  2, 1,  0, 0}, // #668
  {DBGFIELD("POPF16")             1, false, false, 507, 3,  5, 1,  0, 0}, // #669
  {DBGFIELD("MONITORrrr")         1, false, false, 230, 2,  2, 1,  0, 0}, // #670
  {DBGFIELD("FRNDINT")            1, false, false, 230, 2,  2, 1,  0, 0}, // #671
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, 230, 2,  2, 1,  0, 0}, // #672
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 230, 2,  2, 1,  0, 0}, // #673
  {DBGFIELD("FPREM")              1, false, false, 230, 2,  2, 1,  0, 0}, // #674
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, 1505, 15, 30, 1,  0, 0}, // #675
  {DBGFIELD("FNINIT")             15, false, false, 1520, 9, 85, 1,  0, 0}, // #676
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, 1529, 13, 72, 1,  0, 0}, // #677
  {DBGFIELD("FPREM1")             1, false, false, 230, 2,  2, 1,  0, 0}, // #678
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 230, 2,  2, 1,  0, 0}, // #679
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, 1529, 13, 72, 1,  0, 0}, // #680
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 230, 2,  2, 1,  0, 0}, // #681
  {DBGFIELD("FSCALE")             1, false, false, 230, 2,  2, 1,  0, 0}, // #682
  {DBGFIELD("RDMSR")              1, false, false, 230, 2,  2, 1,  0, 0}, // #683
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 493, 6,  4, 1,  0, 0}, // #684
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, 1542, 13, 17, 1,  0, 0}, // #685
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, 1542, 13, 17, 1,  0, 0}, // #686
  {DBGFIELD("F2XM1")              1, false, false, 230, 2,  2, 1,  0, 0}, // #687
  {DBGFIELD("CPUID")              8, false, false, 1555, 11, 29, 1,  0, 0}, // #688
  {DBGFIELD("INT")                1, false, false, 230, 2,  2, 1,  0, 0}, // #689
  {DBGFIELD("INT3")               1, false, false, 230, 2,  2, 1,  0, 0}, // #690
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 230, 2,  2, 1,  0, 0}, // #691
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, 1566, 15, 44, 1,  0, 0}, // #692
  {DBGFIELD("FYL2X")              1, false, false, 230, 2,  2, 1,  0, 0}, // #693
  {DBGFIELD("FYL2XP1")            1, false, false, 230, 2,  2, 1,  0, 0}, // #694
  {DBGFIELD("FPTAN")              1, false, false, 230, 2,  2, 1,  0, 0}, // #695
  {DBGFIELD("FSINCOS")            1, false, false, 230, 2,  2, 1,  0, 0}, // #696
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 230, 2,  2, 1,  0, 0}, // #697
  {DBGFIELD("FPATAN")             1, false, false, 230, 2,  2, 1,  0, 0}, // #698
  {DBGFIELD("WRMSR")              1, false, false, 230, 2,  2, 1,  0, 0}, // #699
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 537, 7,  1, 1,  0, 0}, // #700
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 537, 7,  1, 1,  0, 0}, // #701
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, 833, 4,  8, 1,  0, 0}, // #702
  {DBGFIELD("FNOP")               1, false, false, 952, 4,  1, 1,  0, 0}, // #703
  {DBGFIELD("RETQ")               3, false, false, 1581, 9,  3, 1,  0, 0}, // #704
  {DBGFIELD("CDQ_CQO")            1, false, false, 499, 4,  1, 1,  0, 0}, // #705
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #706
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 481, 4,  1, 1,  0, 0}, // #707
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 510, 8,  1, 1,  0, 0}, // #708
  {DBGFIELD("SETAr_SETBEr")       2, false, false, 632, 4,  8, 1,  0, 0}, // #709
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, 1395, 4,  3, 1,  0, 0}, // #710
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 537, 7, 22, 1,  0, 0}, // #711
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 537, 7, 22, 1,  0, 0}, // #712
  {DBGFIELD("CWD")                2, false, false, 632, 4,  8, 1,  0, 0}, // #713
  {DBGFIELD("FNSTSW16r")          2, false, false, 1590, 9, 23, 1,  0, 0}, // #714
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 1599, 4,  8, 1,  0, 0}, // #715
  {DBGFIELD("PUSHFS64")           1, false, false, 230, 2,  2, 1,  0, 0}, // #716
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 816, 12,  8, 1,  0, 0}, // #717
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 3, false, false, 1603, 4, 22, 1,  0, 0}, // #718
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #719
  {DBGFIELD("MOV64sr")            1, false, false, 230, 2,  1, 1,  0, 0}, // #720
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 507, 3,  5, 1,  0, 0}, // #721
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, 1607, 9, 21, 1,  0, 0}, // #722
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, 1603, 4, 22, 1,  0, 0}, // #723
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, 1616, 5,  8, 1,  0, 0}, // #724
  {DBGFIELD("CLI")                1, false, false, 230, 2,  2, 1,  0, 0}, // #725
  {DBGFIELD("PUSHGS64")           1, false, false, 230, 2,  2, 1,  0, 0}, // #726
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 1228, 10, 23, 1,  0, 0}, // #727
  {DBGFIELD("CALL64pcrel32")      4, false, false, 1621, 7, 22, 1,  0, 0}, // #728
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, 1628, 10, 22, 1,  0, 0}, // #729
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 805, 11,  8, 1,  0, 0}, // #730
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 1616, 5,  8, 1,  0, 0}, // #731
  {DBGFIELD("SETAm_SETBEm")       4, false, false, 1621, 7, 22, 1,  0, 0}, // #732
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, 805, 11,  8, 1,  0, 0}, // #733
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, 1638, 5,  5, 1,  0, 0}, // #734
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, 1643, 7,  8, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, 503, 4,  1, 1,  0, 0}, // #736
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 507, 3,  5, 1,  0, 0}, // #737
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #738
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #739
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #740
  {DBGFIELD("MOV16sm")            1, false, false, 230, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 612, 6,  4, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 544, 10,  4, 1, 10, 1}, // #743
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 612, 6,  4, 1, 10, 1}, // #744
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 230, 2,  2, 1,  0, 0}, // #745
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 507, 3,  4, 1,  0, 0}, // #746
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 507, 3,  4, 1,  0, 0}, // #747
  {DBGFIELD("VINSERTF128rm")      2, false, false, 532, 5,  4, 1,  0, 0}, // #748
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 612, 6,  4, 1, 10, 1}, // #749
  {DBGFIELD("VERRm_VERWm")        1, false, false, 230, 2,  2, 1,  0, 0}, // #750
  {DBGFIELD("FARJMP64")           2, false, false, 1650, 9,  4, 1,  0, 0}, // #751
  {DBGFIELD("FNSTSWm")            3, false, false, 1659, 11, 23, 1,  0, 0}, // #752
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 1670, 11,  4, 1,  0, 0}, // #753
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, 1681, 11,  3, 1,  0, 0}, // #754
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, 1681, 11,  3, 1,  0, 0}, // #755
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 528, 9, 11, 1, 10, 1}, // #756
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 230, 2,  2, 1,  0, 0}, // #757
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1122, 8,  3, 1,  0, 0}, // #758
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 1692, 6,  3, 1,  0, 0}, // #759
  {DBGFIELD("FARCALL64")          5, false, false, 1681, 11,  3, 1,  0, 0}, // #760
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 1698, 14,  7, 1,  0, 0}, // #761
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 1698, 14,  7, 1,  0, 0}, // #762
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 507, 3,  4, 1,  0, 0}, // #763
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, 485, 8, 11, 1,  0, 0}, // #764
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 485, 8, 11, 1,  0, 0}, // #765
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 528, 9,  7, 1,  0, 0}, // #766
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 682, 11, 19, 1,  0, 0}, // #767
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 1138, 9, 19, 1,  0, 0}, // #768
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 682, 11,  9, 1,  0, 0}, // #769
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 1138, 9, 20, 1,  0, 0}, // #770
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 1698, 14, 21, 1,  0, 0}, // #771
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 682, 11, 31, 1,  0, 0}, // #772
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 1698, 14, 77, 1,  0, 0}, // #773
  {DBGFIELD("VZEROALL")           20, false, false, 1712, 11, 11, 1,  0, 0}, // #774
  {DBGFIELD("VZEROUPPER")         4, false, false,  0, 0,  0, 1,  0, 0}, // #775
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #776
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, 230, 2,  1, 1,  0, 0}, // #777
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #778
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, 482, 3,  1, 1,  0, 0}, // #779
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #780
  {DBGFIELD("PSUBQrr")            1, false, false, 481, 4,  1, 1,  0, 0}, // #781
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 672, 9,  5, 1,  0, 0}, // #782
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 544, 10,  4, 1, 10, 1}, // #783
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 493, 6,  4, 1,  0, 0}, // #784
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 493, 6,  4, 1,  0, 0}, // #785
  {DBGFIELD("RDPMC")              1, false, false, 230, 2,  2, 1,  0, 0}, // #786
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 5, false, false, 1723, 6,  7, 1,  0, 0}, // #787
  {DBGFIELD("FBLDm")              1, false, false, 230, 2,  2, 1,  0, 0}, // #788
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 230, 2,  2, 1,  0, 0}, // #789
  {DBGFIELD("FSAVEm")             1, false, false, 230, 2,  2, 1,  0, 0}, // #790
  {DBGFIELD("FRSTORm")            1, false, false, 230, 2,  2, 1,  0, 0}, // #791
  {DBGFIELD("FXTRACT")            1, false, false, 230, 2,  2, 1,  0, 0}, // #792
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #793
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #794
  {DBGFIELD("VBROADCASTF128")     1, false, false, 507, 3,  4, 1,  0, 0}, // #795
  {DBGFIELD("VBROADCASTI128")     1, false, false, 507, 3,  4, 1,  0, 0}, // #796
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 507, 3,  4, 1,  0, 0}, // #797
  {DBGFIELD("FBSTPm")             2, false, false, 503, 4,  1, 1,  0, 0}, // #798
  {DBGFIELD("VMPTRSTm")           1, false, false, 230, 2,  2, 1,  0, 0}, // #799
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, 503, 4,  1, 1,  0, 0}, // #800
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #801
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #802
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 510, 8,  1, 1,  0, 0}, // #803
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false, 1729, 7,  1, 1,  0, 0}, // #804
  {DBGFIELD("FINCSTP")            1, false, false, 952, 4,  1, 1,  0, 0}, // #805
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, 481, 4,  1, 1,  0, 0}, // #806
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 482, 3,  1, 1,  0, 0}, // #807
  {DBGFIELD("VPBLENDDrri")        1, false, false, 482, 3,  1, 1,  0, 0}, // #808
  {DBGFIELD("CMC_STC")            1, false, false, 230, 2,  1, 1,  0, 0}, // #809
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 230, 2,  1, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 682, 11,  4, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 682, 11,  4, 1,  0, 0}, // #812
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 682, 11,  4, 1,  0, 0}, // #813
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 528, 9, 11, 1, 10, 1}, // #814
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 682, 11,  3, 1,  0, 0}, // #815
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #816
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 544, 10,  4, 1,  0, 0}, // #817
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 544, 10, 11, 1,  0, 0}, // #818
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, 1650, 9,  4, 1,  0, 0}, // #819
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 612, 6,  4, 1,  0, 0}, // #820
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 612, 6,  4, 1,  0, 0}, // #821
  {DBGFIELD("VINSERTI128rm")      2, false, false, 532, 5,  4, 1,  0, 0}, // #822
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 532, 5,  4, 1,  0, 0}, // #823
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 532, 5,  3, 1,  0, 0}, // #824
  {DBGFIELD("POP32r_POP64r")      2, false, false, 524, 4,  4, 1,  0, 0}, // #825
  {DBGFIELD("SFENCE")             2, false, false, 496, 3,  8, 1,  0, 0}, // #826
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, 1736, 7,  8, 1,  0, 0}, // #827
  {DBGFIELD("MOVBE16mr")          3, false, false, 1736, 7,  8, 1,  0, 0}, // #828
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, 1616, 5,  8, 1,  0, 0}, // #829
  {DBGFIELD("MFENCE")             2, false, false, 570, 2,  8, 1,  0, 0}, // #830
  {DBGFIELD("XGETBV")             2, false, false, 570, 2,  8, 1,  0, 0}, // #831
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 816, 12,  8, 1,  0, 0}, // #832
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 816, 12,  8, 1,  0, 0}, // #833
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 3, false, false, 554, 10,  3, 1,  0, 0}, // #834
  {DBGFIELD("LRETQ_RETL")         2, false, false, 493, 6,  4, 1,  0, 0}, // #835
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #836
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #837
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 537, 7, 22, 1,  0, 0}, // #838
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 510, 8, 22, 1,  0, 0}, // #839
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #840
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 528, 9,  7, 1,  0, 0}, // #841
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 528, 9,  7, 1,  0, 0}, // #842
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 544, 10, 11, 1,  0, 0}, // #843
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 3, false, false, 1743, 8, 22, 1,  0, 0}, // #844
  {DBGFIELD("CLDEMOTE")           3, false, false, 1399, 7, 22, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 1437, 12, 23, 1,  0, 0}, // #846
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 1437, 12, 23, 1,  0, 0}, // #847
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 816, 12, 23, 1,  0, 0}, // #848
  {DBGFIELD("MMX_CVTPI2PDirr")    2, false, false, 930, 11, 23, 1,  0, 0}, // #849
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 2, false, false, 930, 11, 23, 1,  0, 0}, // #850
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, 930, 11, 23, 1,  0, 0}, // #851
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 930, 11, 23, 1,  0, 0}, // #852
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 930, 11, 23, 1,  0, 0}, // #853
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 930, 11, 23, 1,  0, 0}, // #854
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 930, 11, 23, 1,  0, 0}, // #855
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 930, 11, 23, 1,  0, 0}, // #856
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 1698, 14,  7, 1,  0, 0}, // #857
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 1698, 14,  7, 1,  0, 0}, // #858
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1698, 14,  7, 1,  0, 0}, // #859
  {DBGFIELD("VCVTPS2PDYrm")       3, false, false, 1108, 14,  7, 1,  0, 0}, // #860
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 917, 13,  7, 1,  0, 0}, // #861
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 917, 13,  7, 1,  0, 0}, // #862
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 917, 13,  7, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPI2PDirm")    3, false, false, 917, 13,  7, 1,  0, 0}, // #864
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 917, 13,  7, 1,  0, 0}, // #865
  {DBGFIELD("VCVTSD2SSrm")        3, false, false, 917, 13,  7, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 3, false, false, 1751, 10,  7, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 8, false, false, 1761, 13, 21, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, 1774, 13,  7, 1,  0, 0}, // #869
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, 672, 9,  5, 1,  0, 0}, // #870
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 672, 9,  5, 1,  0, 0}, // #871
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 682, 11,  9, 1,  0, 0}, // #872
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 850, 11,  5, 1,  0, 0}, // #873
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, 1787, 11,  5, 1,  0, 0}, // #874
  {DBGFIELD("XSETBV")             5, false, false, 1798, 4,  5, 1,  0, 0}, // #875
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 930, 11,  4, 1,  0, 0}, // #876
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 930, 11,  4, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 930, 11,  4, 1,  0, 0}, // #878
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 917, 13,  9, 1,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, 1802, 11, 10, 1,  0, 0}, // #880
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, 1813, 9,  9, 1,  0, 0}, // #881
  {DBGFIELD("RCL8rCL")            9, false, false, 1822, 9,  9, 1,  0, 0}, // #882
  {DBGFIELD("RDTSC")              8, false, false, 1555, 11, 29, 1,  0, 0}, // #883
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 19, false, false, 1831, 9, 33, 1,  0, 0}, // #884
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 672, 9, 30, 1,  0, 0}, // #885
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 682, 11, 35, 1,  0, 0}, // #886
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 1698, 14, 36, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 672, 9, 10, 1,  0, 0}, // #888
  {DBGFIELD("XSAVE64")            27, false, false, 1840, 11, 36, 1,  0, 0}, // #889
  {DBGFIELD("XSAVE")              28, false, false, 1851, 11, 37, 1,  0, 0}, // #890
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 28, false, false, 1851, 11, 37, 1,  0, 0}, // #891
  {DBGFIELD("VMCLEARm")           1, false, false, 230, 2,  2, 1,  0, 0}, // #892
  {DBGFIELD("FLDENVm")            64, false, false, 1862, 11, 86, 1,  0, 0}, // #893
  {DBGFIELD("FXRSTOR64")          88, false, false, 1873, 15, 44, 1,  0, 0}, // #894
  {DBGFIELD("FSTENVm")            100, false, false, 1888, 17, 87, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #897
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 507, 3,  5, 1,  0, 0}, // #898
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 507, 3,  5, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPSYrm")      9, false, false, 1905, 12, 77, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 9, false, false, 1905, 12, 66, 1,  0, 0}, // #904
  {DBGFIELD("ADC8i8_SBB8i8")      2, false, false, 632, 4,  8, 1,  0, 0}, // #905
  {DBGFIELD("ADC8ri_ADC8ri8_SBB8ri_SBB8ri8") 2, false, false, 632, 4,  8, 1,  0, 0}, // #906
  {DBGFIELD("VCVTSS2SDrm")        2, false, false, 682, 11,  4, 1,  0, 0}, // #907
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 528, 9,  3, 1,  0, 0}, // #908
  {DBGFIELD("LRETQ")              3, false, false, 1581, 9,  3, 1,  0, 0}, // #909
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #910
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 917, 13,  7, 1,  0, 0}, // #911
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_Int") 3, false, false, 917, 13,  7, 1,  0, 0}, // #912
  {DBGFIELD("POPF64")             18, false, false, 1917, 9, 32, 1,  0, 0}, // #913
  {DBGFIELD("VGATHERQPDrm")       7, false, false, 1926, 12, 32, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm")      9, false, false, 1938, 12, 33, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDrm")       7, false, false, 1926, 12, 34, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSrm")       7, false, false, 1926, 12, 34, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERDPDYrm")      9, false, false, 1905, 12, 35, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERDPSYrm")      14, false, false, 1950, 12, 35, 1,  0, 0}, // #919
  {DBGFIELD("MOV16rm")            1, false, false, 507, 3,  5, 1,  0, 0}, // #920
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 507, 3,  5, 1,  0, 0}, // #921
  {DBGFIELD("POP16rmm")           4, false, false, 518, 6,  4, 1,  0, 0}, // #922
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, 518, 6,  4, 1,  0, 0}, // #923
  {DBGFIELD("PUSHF16")            6, false, false, 1638, 5,  5, 1,  0, 0}, // #924
  {DBGFIELD("LAHF")               1, false, false, 499, 4,  1, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 518, 6,  3, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 485, 8, 11, 1,  0, 0}, // #927
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 518, 6,  3, 1,  0, 0}, // #928
  {DBGFIELD("MULX32rr")           4, false, false, 908, 9, 75, 2,  0, 0}, // #929
  {DBGFIELD("MULX32rm")           5, false, false, 897, 11, 73, 2,  0, 0}, // #930
  {DBGFIELD("MULX64rr")           3, false, false, 930, 11, 75, 2,  0, 0}, // #931
  {DBGFIELD("MULX64rm")           4, false, false, 917, 13, 73, 2,  0, 0}, // #932
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, 1628, 10, 22, 1,  0, 0}, // #933
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 493, 6,  4, 1,  0, 0}, // #934
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 493, 6,  4, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 518, 6,  3, 1,  0, 0}, // #936
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, 1165, 9,  7, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 872, 9,  4, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, 1154, 11,  9, 1,  0, 0}, // #939
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 507, 3,  5, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 510, 8,  1, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, 773, 2,  8, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 510, 8,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 510, 8, 22, 1,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 544, 10,  7, 1,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 510, 8,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 510, 8,  1, 1,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 544, 10,  4, 1, 10, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 544, 10,  3, 1, 21, 1}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 510, 8,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, 503, 4,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, 503, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      3, false, false, 554, 10, 11, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       3, false, false, 554, 10,  3, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 4, false, false, 1282, 12,  5, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 4, false, false, 1282, 12,  5, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 3, false, false, 1751, 10,  7, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 510, 8,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 510, 8,  1, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       1, false, false, 510, 8, 22, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       2, false, false, 544, 10,  7, 1, 21, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 510, 8, 22, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 503, 4,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      1, false, false, 510, 8, 22, 1,  0, 0}, // #964
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #965
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #966
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 1437, 12, 23, 1,  0, 0}, // #967
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 1698, 14,  7, 1,  0, 0}, // #968
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 481, 4,  1, 1,  0, 0}, // #969
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 481, 4,  1, 1,  0, 0}, // #970
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 682, 11, 19, 1, 10, 1}, // #971
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 672, 9,  5, 1,  0, 0}, // #972
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 672, 9,  5, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 682, 11, 19, 1, 10, 1}, // #974
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 672, 9,  5, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 682, 11, 19, 1, 10, 1}, // #976
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 672, 9,  5, 1,  0, 0}, // #977
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 682, 11, 19, 1, 10, 1}, // #978
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 672, 9,  5, 1,  0, 0}, // #979
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 682, 11, 19, 1, 10, 1}, // #980
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 672, 9,  5, 1,  0, 0}, // #981
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 682, 11, 19, 1, 10, 1}, // #982
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, 230, 2,  2, 1,  0, 0}, // #983
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, 518, 6,  3, 1,  0, 0}, // #984
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, 230, 2,  1, 1,  0, 0}, // #985
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, 524, 4,  4, 1,  0, 0}, // #986
  {DBGFIELD("XCHG16rr")           3, false, false, 773, 2,  8, 1,  0, 0}, // #987
  {DBGFIELD("CRC32r32r16")        1, false, false, 537, 7, 22, 1,  0, 0}, // #988
  {DBGFIELD("CRC32r32r32")        1, false, false, 537, 7, 22, 1,  0, 0}, // #989
  {DBGFIELD("CRC32r64r64")        1, false, false, 537, 7, 22, 1,  0, 0}, // #990
  {DBGFIELD("CMOVG16rm_CMOVG32rm_CMOVG64rm_CMOVGE16rm_CMOVGE32rm_CMOVGE64rm_CMOVL16rm_CMOVL32rm_CMOVL64rm_CMOVLE16rm_CMOVLE32rm_CMOVLE64rm") 2, false, false, 493, 6,  4, 1, 10, 1}, // #991
  {DBGFIELD("SETGEm_SETGm_SETLEm_SETLm") 3, false, false, 1147, 7,  8, 1,  0, 0}, // #992
  {DBGFIELD("SAHF")               1, false, false, 499, 4,  1, 1,  0, 0}, // #993
  {DBGFIELD("RCR8ri")             3, false, false, 1603, 4, 22, 1,  0, 0}, // #994
  {DBGFIELD("RCL16rCL")           7, false, false, 1813, 9,  9, 1,  0, 0}, // #995
  {DBGFIELD("RCR16ri")            3, false, false, 1603, 4, 22, 1,  0, 0}, // #996
  {DBGFIELD("RCL32rCL_RCL64rCL")  7, false, false, 1813, 9,  9, 1,  0, 0}, // #997
  {DBGFIELD("RCR64rCL")           7, false, false, 1813, 9,  9, 1,  0, 0}, // #998
  {DBGFIELD("RCR32rCL")           7, false, false, 1813, 9,  9, 1,  0, 0}, // #999
  {DBGFIELD("RCR32ri_RCR64ri")    3, false, false, 1603, 4, 22, 1,  0, 0}, // #1000
  {DBGFIELD("RCL16ri")            3, false, false, 1603, 4, 22, 1,  0, 0}, // #1001
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, 1603, 4, 22, 1,  0, 0}, // #1002
  {DBGFIELD("SHLD32rri8")         1, false, false, 537, 7, 22, 1,  0, 0}, // #1003
  {DBGFIELD("SHRD16rri8")         1, false, false, 537, 7, 22, 1,  0, 0}, // #1004
  {DBGFIELD("SHLD16rrCL")         4, false, false, 872, 9,  4, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, 503, 4,  1, 1,  0, 0}, // #1006
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, 503, 4,  1, 1,  0, 0}, // #1007
  {DBGFIELD("TST_F")              1, false, false, 537, 7, 22, 1,  0, 0}, // #1008
  {DBGFIELD("VDPPSrri")           4, false, false, 791, 14, 21, 1,  0, 0}, // #1009
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr_VFRCZSDrr_VFRCZSSrr") 1, false, false, 507, 3,  4, 1,  0, 0}, // #1010
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, 1138, 9,  9, 1, 10, 1}, // #1011
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 1, false, false, 507, 3,  4, 1,  0, 0}, // #1012
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, 1138, 9, 20, 1, 21, 1}, // #1013
  {DBGFIELD("MMX_CVTTPD2PIirr")   2, false, false, 930, 11, 23, 1,  0, 0}, // #1014
  {DBGFIELD("CVTSI642SDrr")       2, false, false, 930, 11, 23, 1,  0, 0}, // #1015
  {DBGFIELD("CVTSI642SSrr")       3, false, false, 850, 11,  5, 1,  0, 0}, // #1016
  {DBGFIELD("VMOVDQUYmr")         2, false, false, 503, 4,  1, 1,  0, 0}, // #1017
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, 1094, 9, 19, 1,  0, 0}, // #1018
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, 971, 8, 22, 1,  0, 0}, // #1019
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, 961, 10, 11, 1, 10, 1}, // #1020
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, 672, 9,  5, 1,  0, 0}, // #1021
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #1022
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1023
  {DBGFIELD("PANDNrr_VPANDNrr")   1, false, false, 482, 3,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1025
  {DBGFIELD("VXORPSYrr_VXORPDYrr_VANDNPSYrr_VANDNPDYrr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #1026
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1029
  {DBGFIELD("LEA16r")             1, false, false, 481, 4,  1, 1,  0, 0}, // #1030
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1031
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1032
  {DBGFIELD("CLAC_STAC")          1, false, false, 230, 2,  2, 1,  0, 0}, // #1033
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1034
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1035
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1036
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 971, 8, 22, 1,  0, 0}, // #1038
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 971, 8, 22, 1,  0, 0}, // #1039
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 971, 8, 22, 1,  0, 0}, // #1040
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1041
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 612, 6,  4, 1, 10, 1}, // #1043
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 1437, 12, 23, 1,  0, 0}, // #1044
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 1437, 12, 23, 1,  0, 0}, // #1045
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 612, 6,  4, 1, 10, 1}, // #1046
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 612, 6,  3, 1, 21, 1}, // #1047
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 961, 10, 11, 1, 10, 1}, // #1048
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 961, 10, 11, 1, 10, 1}, // #1049
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 961, 10,  7, 1, 21, 1}, // #1050
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 28, false, false, 1851, 11, 37, 1,  0, 0}, // #1051
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1052
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 230, 2,  1, 1,  0, 0}, // #1053
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 230, 2,  1, 1,  0, 0}, // #1054
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, 564, 8,  8, 1,  0, 0}, // #1055
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, 564, 8,  8, 1,  0, 0}, // #1056
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, 564, 8,  8, 1,  0, 0}, // #1060
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, 564, 8,  8, 1,  0, 0}, // #1061
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, 503, 4,  1, 1,  0, 0}, // #1063
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 230, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1067
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 510, 8,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 510, 8,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1072
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1073
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1075
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1077
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1078
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1080
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 537, 7, 22, 1,  0, 0}, // #1086
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1088
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1090
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1095
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1096
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1097
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1098
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1099
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1103
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1104
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1105
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1106
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1107
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 1228, 10,  5, 1,  0, 0}, // #1109
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 1228, 10,  3, 1,  0, 0}, // #1110
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1113
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1114
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, 507, 3,  5, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1116
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1120
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, 537, 7, 23, 1,  0, 0}, // #1123
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, 507, 3,  5, 1,  0, 0}, // #1130
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 554, 10,  3, 1, 10, 1}, // #1131
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 544, 10,  4, 1,  0, 0}, // #1132
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1133
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1134
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 544, 10,  4, 1,  0, 0}, // #1135
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1136
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 612, 6,  4, 1, 10, 1}, // #1137
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 554, 10,  3, 1, 10, 1}, // #1138
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, 537, 7, 22, 1,  0, 0}, // #1140
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 1437, 12, 23, 1,  0, 0}, // #1141
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 2, false, false, 1437, 12, 23, 1,  0, 0}, // #1142
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1143
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1144
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1145
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 503, 4,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1149
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1150
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, 507, 3,  4, 1,  0, 0}, // #1151
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, 554, 10, 11, 1, 21, 1}, // #1152
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1154
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 544, 10,  3, 1,  0, 0}, // #1155
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1156
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1157
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1158
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, 507, 3,  4, 1,  0, 0}, // #1159
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 544, 10,  3, 1,  0, 0}, // #1160
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, 507, 3,  4, 1,  0, 0}, // #1162
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 612, 6,  3, 1, 21, 1}, // #1163
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, 554, 10, 11, 1, 21, 1}, // #1165
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 503, 4,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 503, 4,  1, 1,  0, 0}, // #1170
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 544, 10,  4, 1, 10, 1}, // #1171
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1172
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1173
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 612, 6,  4, 1, 10, 1}, // #1174
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1175
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1176
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1177
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 532, 5,  4, 1, 10, 1}, // #1178
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 544, 10,  3, 1, 21, 1}, // #1179
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 528, 9,  7, 1, 21, 1}, // #1181
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 612, 6,  3, 1, 21, 1}, // #1183
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1185
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 528, 9,  7, 1,  0, 0}, // #1187
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 528, 9,  7, 1,  0, 0}, // #1188
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 528, 9, 11, 1,  0, 0}, // #1189
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 682, 11,  4, 1,  0, 0}, // #1190
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 528, 9, 11, 1,  0, 0}, // #1191
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 528, 9, 11, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1193
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1194
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 528, 9,  7, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 528, 9,  7, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 682, 11,  4, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 528, 9, 11, 1,  0, 0}, // #1201
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, 528, 9, 11, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 528, 9, 11, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1207
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1208
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, 612, 6,  4, 1,  0, 0}, // #1209
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 672, 9,  5, 1,  0, 0}, // #1210
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, 672, 9,  5, 1,  0, 0}, // #1211
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1213
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1214
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 528, 9, 11, 1, 10, 1}, // #1215
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1217
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1218
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, 544, 10,  7, 1, 21, 1}, // #1222
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, 612, 6,  4, 1,  0, 0}, // #1223
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, 682, 11, 19, 1, 10, 1}, // #1224
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, 682, 11,  9, 1, 21, 1}, // #1225
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1227
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1228
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1229
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1230
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1231
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1232
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1233
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1234
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, 612, 6,  3, 1,  0, 0}, // #1235
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #1236
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1237
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1238
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, 612, 6,  3, 1,  0, 0}, // #1239
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1240
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1244
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("SBWriteResGroup30")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("WriteFLogicY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1257
}; // BroadwellModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BtVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 1962, 2,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteCMPXCHGRMW")    2, false, false, 1964, 4, 23, 1,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        1, false, false, 672, 3, 23, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false,  1, 1,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false,  1, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false,  1, 1,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false, 1968, 5,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 1973, 4,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       1, false, false, 1968, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 1973, 4,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false,  1, 1,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 1977, 4,  8, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false,  3, 1,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        1, false, false, 1981, 4,  5, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, 1985, 3, 23, 1,  1, 1}, // #17
  {DBGFIELD("WriteALURMW")        1, false, false, 1964, 4,  5, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, 672, 3, 23, 1,  1, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, 1988, 6, 11, 1, 10, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 1988, 4, 22, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, 1988, 6, 11, 1, 10, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 1988, 4, 22, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, 1988, 6, 11, 1, 10, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 1988, 4, 22, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, 1988, 6, 11, 1, 10, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 1988, 4, 22, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        1, false, false, 1988, 6, 11, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 1994, 6, 11, 1, 10, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 2000, 4, 22, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      1, false, false, 2004, 5,  3, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        1, false, false, 2009, 3,  8, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 2004, 5,  3, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 2009, 3,  8, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, 1973, 4,  4, 1, 10, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 1973, 2,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 672, 3, 23, 1,  2, 1}, // #37
  {DBGFIELD("WriteBEXTR")         1, false, false,  1, 1,  1, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       1, false, false, 672, 3, 23, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         1, false, false, 672, 3, 23, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, 1973, 4,  4, 1, 10, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 1973, 2,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 2012, 4,  3, 1, 10, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     3, false, false, 2012, 2,  8, 1,  0, 0}, // #44
  {DBGFIELD("WriteBLSLd")         2, false, false, 1985, 3,  5, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLS")           2, false, false,  3, 1,  8, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSFLd")         7, false, false, 2016, 3,  3, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSF")           7, false, false, 16, 1, 23, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSRLd")         8, false, false, 2016, 3, 11, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSR")           8, false, false, 16, 1,  5, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSWAP32")       1, false, false,  1, 1,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP64")       1, false, false,  1, 1,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, 672, 3, 23, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestRegLd")  5, false, false, 672, 3, 23, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTest")       1, false, false,  1, 1,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 1964, 4,  5, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetRegRMW") 8, false, false, 1964, 4,  5, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSet")    2, false, false,  1, 1,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #59
  {DBGFIELD("WriteBZHI")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #60
  {DBGFIELD("WriteLoad")          1, false, false, 673, 2,  5, 1,  0, 0}, // #61
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 1, false, false, 672, 3, 23, 1,  1, 1}, // #62
  {DBGFIELD("WriteCMOV2")         1, false, false,  1, 1,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, 672, 3, 23, 1,  1, 1}, // #64
  {DBGFIELD("WriteCMOV")          1, false, false,  1, 1,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteFCMOV")         1, false, false, 1988, 4, 22, 1,  0, 0}, // #66
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 672, 3, 23, 1,  2, 1}, // #67
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #68
  {DBGFIELD("WriteFCmp64X")       1, false, false, 1988, 4,  8, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #70
  {DBGFIELD("WriteFCmpX")         1, false, false, 1988, 4,  8, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #72
  {DBGFIELD("WriteFCmp64")        1, false, false, 1988, 4,  8, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #74
  {DBGFIELD("WriteFCmp")          1, false, false, 1988, 4,  8, 1,  0, 0}, // #75
  {DBGFIELD("WriteCMPXCHG")       1, false, false,  1, 1,  1, 1,  0, 0}, // #76
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 1, false, false, 2019, 8, 11, 1, 10, 1}, // #77
  {DBGFIELD("WriteFCom")          1, false, false, 2019, 6, 22, 1,  0, 0}, // #78
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, 2027, 3,  4, 1,  1, 1}, // #79
  {DBGFIELD("WriteCRC32")         3, false, false, 29, 1, 22, 1,  0, 0}, // #80
  {DBGFIELD("WriteNop")           1, false, false,  1, 1,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PDLd")     1, false, false, 2030, 5, 11, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 2035, 3, 22, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, 2030, 5, 11, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 2035, 3, 22, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2ILd")     1, false, false, 2030, 5, 11, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 2035, 3, 22, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PSLd")    1, false, false, 2030, 5, 11, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 2035, 3, 22, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, 2030, 5, 11, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 2035, 3, 22, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PDLd")    1, false, false, 2030, 5,  3, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 2035, 3,  8, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, 2038, 10, 20, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 2048, 8,  3, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 2056, 5, 20, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, 2056, 5, 20, 1, 10, 1}, // #97
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, 2061, 3,  3, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 2030, 5, 21, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 2030, 5, 21, 1, 10, 1}, // #100
  {DBGFIELD("WriteCvtI2SD")       2, false, false, 2035, 3,  7, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 2030, 5, 21, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 2030, 5, 21, 1, 10, 1}, // #103
  {DBGFIELD("WriteCvtI2SS")       2, false, false, 2035, 3,  7, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 2056, 5, 20, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 2056, 5, 20, 1, 10, 1}, // #106
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, 2061, 3,  3, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, 2038, 10, 20, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 2048, 8,  3, 1,  0, 0}, // #109
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2064, 5, 30, 1,  3, 2}, // #110
  {DBGFIELD("WriteDiv16")         2, false, false, 2064, 3, 28, 1,  0, 0}, // #111
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2069, 5, 88, 1,  3, 2}, // #112
  {DBGFIELD("WriteDiv32")         2, false, false, 2069, 3, 34, 1,  0, 0}, // #113
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2074, 5, 89, 1,  3, 2}, // #114
  {DBGFIELD("WriteDiv64")         2, false, false, 2074, 3, 90, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 2079, 5, 10, 1,  3, 2}, // #116
  {DBGFIELD("WriteDiv8")          1, false, false, 2079, 3, 20, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, 2084, 6, 77, 1, 10, 1}, // #118
  {DBGFIELD("WriteFDiv64X")       1, false, false, 2084, 4, 63, 1,  0, 0}, // #119
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, 2084, 6, 77, 1, 10, 1}, // #120
  {DBGFIELD("WriteFDivX")         1, false, false, 2084, 4, 63, 1,  0, 0}, // #121
  {DBGFIELD("WriteFDivLd")        1, false, false, 2084, 6, 77, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv")          1, false, false, 2084, 4, 63, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, 2084, 6, 77, 1, 10, 1}, // #124
  {DBGFIELD("WriteFDiv64")        1, false, false, 2084, 4, 63, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, 2084, 6, 77, 1, 10, 1}, // #126
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 3, false, false, 2090, 7, 21, 1, 10, 1}, // #127
  {DBGFIELD("WriteDPPD")          3, false, false, 2090, 5,  7, 1,  0, 0}, // #128
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 2090, 7,  6, 1, 10, 1}, // #129
  {DBGFIELD("WriteDPPS")          5, false, false, 2090, 5,  9, 1,  0, 0}, // #130
  {DBGFIELD("WriteVecExtractSt")  1, false, false, 1968, 5, 22, 1,  0, 0}, // #131
  {DBGFIELD("WriteVecExtract")    1, false, false, 2019, 6, 22, 1,  0, 0}, // #132
  {DBGFIELD("WriteVecALUX")       1, false, false, 1962, 2,  1, 1,  0, 0}, // #133
  {DBGFIELD("WriteFComLd")        1, false, false, 2019, 8, 11, 1,  0, 0}, // #134
  {DBGFIELD("WriteEMMS")          1, false, false, 1973, 2,  8, 1,  0, 0}, // #135
  {DBGFIELD("WriteFLDC")          1, false, false, 2035, 3, 22, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #137
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 1, false, false, 1988, 6, 11, 1, 10, 1}, // #138
  {DBGFIELD("WriteFHAdd")         1, false, false, 1988, 4, 22, 1,  0, 0}, // #139
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2064, 5, 30, 1,  3, 2}, // #140
  {DBGFIELD("WriteIDiv16")        2, false, false, 2064, 3, 28, 1,  0, 0}, // #141
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2069, 5, 88, 1,  3, 2}, // #142
  {DBGFIELD("WriteIDiv32")        2, false, false, 2069, 3, 34, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2074, 5, 89, 1,  3, 2}, // #144
  {DBGFIELD("WriteIDiv64")        2, false, false, 2074, 3, 90, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, 2079, 5, 10, 1,  3, 2}, // #146
  {DBGFIELD("WriteIDiv8")         1, false, false, 2079, 3, 20, 1,  0, 0}, // #147
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2101, 5,  4, 1,  3, 2}, // #148
  {DBGFIELD("WriteIMul16")        2, false, false, 2106, 3, 22, 1,  0, 0}, // #149
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, 2101, 5,  4, 1,  1, 1}, // #150
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, 2101, 5,  4, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Reg")     2, false, false, 2106, 3, 22, 1,  0, 0}, // #152
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 2106, 3, 22, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2101, 5,  4, 1,  3, 2}, // #154
  {DBGFIELD("WriteIMul32")        2, false, false, 2106, 3, 22, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, 2101, 5,  4, 1,  1, 1}, // #156
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 2101, 5,  4, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Reg")     2, false, false, 2106, 3, 22, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul32Imm")     2, false, false, 2106, 3, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2109, 5,  7, 1,  3, 2}, // #160
  {DBGFIELD("WriteIMul64")        2, false, false, 2114, 3,  4, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, 2109, 5,  7, 1,  1, 1}, // #162
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 2109, 5,  7, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Reg")     2, false, false, 2114, 3,  4, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul64Imm")     2, false, false, 2114, 3,  4, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2101, 5,  4, 1,  3, 2}, // #166
  {DBGFIELD("WriteIMul8")         2, false, false, 2106, 3, 22, 1,  0, 0}, // #167
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, 1973, 4,  4, 1, 10, 1}, // #168
  {DBGFIELD("WriteFShuffle")      1, false, false, 1973, 2,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteStore")         1, false, false, 138, 2,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteVecLogicX")     1, false, false, 1962, 2,  1, 1,  0, 0}, // #171
  {DBGFIELD("WriteShuffle")       1, false, false, 1962, 2,  1, 1,  0, 0}, // #172
  {DBGFIELD("WriteLAHFSAHF")      1, false, false,  1, 1,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLoadX")      1, false, false, 2097, 4,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteLDMXCSR")       1, false, false, 673, 2,  5, 1,  0, 0}, // #175
  {DBGFIELD("WriteFLD0")          1, false, false, 2035, 3, 22, 1,  0, 0}, // #176
  {DBGFIELD("WriteFLD1")          1, false, false, 2035, 3, 22, 1,  0, 0}, // #177
  {DBGFIELD("WriteLEA")           1, false, false,  1, 1,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteFence")         1, false, false, 138, 2,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLZCNTLd")       1, false, false, 672, 3, 23, 1,  0, 0}, // #180
  {DBGFIELD("WriteLZCNT")         1, false, false,  1, 1,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecStoreX")     1, false, false, 1968, 5,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecStore")      1, false, false, 1968, 5,  8, 1,  0, 0}, // #183
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 2019, 6, 23, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoad")       1, false, false, 2097, 4,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, 1973, 2, 11, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveX")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 1968, 5,  8, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMove")       1, false, false, 1962, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecALULd")      1, false, false, 2097, 4,  4, 1,  0, 0}, // #190
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #191
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #192
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #193
  {DBGFIELD("WriteVecLogic")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #195
  {DBGFIELD("WritePHAdd")         1, false, false, 1962, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, 2097, 4, 23, 1,  1, 1}, // #197
  {DBGFIELD("WriteVecInsert")     2, false, false, 1962, 2,  3, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, 2004, 5,  3, 1, 10, 1}, // #199
  {DBGFIELD("WriteVecIMul")       1, false, false, 2009, 3,  8, 1,  0, 0}, // #200
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 2019, 6, 22, 1,  0, 0}, // #201
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, 2097, 4,  3, 1, 10, 1}, // #202
  {DBGFIELD("WritePSADBW")        1, false, false, 1962, 2,  8, 1,  0, 0}, // #203
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, 2097, 4,  3, 1, 10, 1}, // #204
  {DBGFIELD("WriteVarShuffle")    1, false, false, 1962, 2,  8, 1,  0, 0}, // #205
  {DBGFIELD("WriteShuffleLd")     1, false, false, 2097, 4,  4, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 1962, 2,  1, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #208
  {DBGFIELD("WriteVecShift")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #209
  {DBGFIELD("WriteFMoveX")        1, false, false, 1973, 2,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteFShuffleLd")    1, false, false, 1973, 4,  4, 1,  0, 0}, // #211
  {DBGFIELD("WriteFStore")        1, false, false, 1968, 5,  8, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 2019, 6, 22, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 2097, 4,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteStoreNT")       1, false, false, 138, 2,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 1968, 5, 22, 1,  0, 0}, // #216
  {DBGFIELD("WriteFStoreNT")      1, false, false, 1968, 5, 22, 1,  0, 0}, // #217
  {DBGFIELD("WriteFLoad")         1, false, false, 1973, 4,  5, 1,  0, 0}, // #218
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, 2117, 5, 11, 1, 10, 1}, // #219
  {DBGFIELD("WriteMPSAD")         3, false, false, 2122, 3, 22, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, 2125, 6,  7, 1, 10, 1}, // #221
  {DBGFIELD("WriteFMul64X")       1, false, false, 2125, 4, 23, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, 2131, 6,  3, 1, 10, 1}, // #223
  {DBGFIELD("WriteFMulX")         1, false, false, 1977, 4,  8, 1,  0, 0}, // #224
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, 2125, 6,  7, 1, 10, 1}, // #225
  {DBGFIELD("WriteFMul64")        1, false, false, 2125, 4, 23, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, 2131, 6,  3, 1, 10, 1}, // #227
  {DBGFIELD("WriteFMul")          1, false, false, 1977, 4,  8, 1,  0, 0}, // #228
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 3, false, false, 2137, 5, 91, 2,  0, 0}, // #229
  {DBGFIELD("WriteIMul32_WriteIMulH") 3, false, false, 2142, 3, 93, 2,  0, 0}, // #230
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 3, false, false, 2145, 5, 95, 2,  0, 0}, // #231
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 2150, 3, 91, 2,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd")        1, false, false, 2131, 6,  3, 1,  0, 0}, // #233
  {DBGFIELD("WriteVecALUXLd")     1, false, false, 2097, 4,  4, 1,  0, 0}, // #234
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #235
  {DBGFIELD("WriteShuffleX")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #237
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 2153, 4,  3, 1, 10, 1}, // #238
  {DBGFIELD("WriteVarBlend")      3, false, false, 2157, 2,  8, 1,  0, 0}, // #239
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #240
  {DBGFIELD("WriteBlend")         1, false, false, 1962, 2,  1, 1,  0, 0}, // #241
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 1, false, false, 2004, 5,  3, 1, 10, 1}, // #242
  {DBGFIELD("WriteCLMul")         1, false, false, 2009, 3,  8, 1,  0, 0}, // #243
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, 2159, 11, 63, 1, 10, 1}, // #244
  {DBGFIELD("WritePCmpEStrI")     9, false, false, 2170, 11, 21, 1,  0, 0}, // #245
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, 2159, 11, 63, 1, 10, 1}, // #246
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 2170, 11, 21, 1,  0, 0}, // #247
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 3, false, false, 2181, 11, 20, 1, 10, 1}, // #248
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 2192, 9,  3, 1,  0, 0}, // #249
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 3, false, false, 2181, 11, 27, 1, 10, 1}, // #250
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 2192, 9, 11, 1,  0, 0}, // #251
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, 2030, 5, 11, 1, 10, 1}, // #252
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #253
  {DBGFIELD("WritePHAddX")        1, false, false, 1962, 2,  1, 1,  0, 0}, // #254
  {DBGFIELD("WritePHMINPOSLd")    1, false, false, 2097, 4,  3, 1,  0, 0}, // #255
  {DBGFIELD("WritePHMINPOS")      1, false, false, 1962, 2,  8, 1,  0, 0}, // #256
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, 2030, 5, 11, 1, 10, 1}, // #257
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, 2004, 5,  3, 1, 10, 1}, // #258
  {DBGFIELD("WriteVecIMulX")      1, false, false, 2009, 3,  8, 1,  0, 0}, // #259
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 2019, 6, 22, 1,  0, 0}, // #260
  {DBGFIELD("WriteShuffleXLd")    1, false, false, 2097, 4,  4, 1,  0, 0}, // #261
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, 2201, 6,  7, 1, 10, 1}, // #262
  {DBGFIELD("WritePMULLD")        3, false, false, 2207, 4, 23, 1,  0, 0}, // #263
  {DBGFIELD("WriteCopy")          2, false, false, 1965, 3,  4, 1,  0, 0}, // #264
  {DBGFIELD("WritePOPCNTLd")      1, false, false, 672, 3, 23, 1,  0, 0}, // #265
  {DBGFIELD("WritePOPCNT")        1, false, false,  1, 1,  1, 1,  0, 0}, // #266
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  3, 1, 10, 1}, // #267
  {DBGFIELD("WritePSADBWX")       1, false, false, 1962, 2,  8, 1,  0, 0}, // #268
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 3, false, false, 2211, 4,  3, 1, 10, 1}, // #269
  {DBGFIELD("WriteVarShuffleX")   3, false, false, 2215, 2,  8, 1,  0, 0}, // #270
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 1962, 2,  1, 1,  0, 0}, // #271
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #272
  {DBGFIELD("WriteVecShiftX")     1, false, false, 1962, 2,  1, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 1, false, false, 2019, 8, 11, 1, 10, 1}, // #274
  {DBGFIELD("WriteVecTest")       1, false, false, 2019, 6, 22, 1,  0, 0}, // #275
  {DBGFIELD("WriteRotateLd_WriteRMW") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #276
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #277
  {DBGFIELD("WriteRotate")        1, false, false,  1, 1,  1, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateCL")      1, false, false,  1, 1,  1, 1,  0, 0}, // #279
  {DBGFIELD("WriteFRcpXLd")       1, false, false, 2131, 6,  3, 1,  0, 0}, // #280
  {DBGFIELD("WriteFRcpX")         1, false, false, 1977, 4,  8, 1,  0, 0}, // #281
  {DBGFIELD("WriteFRcpLd")        1, false, false, 2131, 6,  3, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, 2131, 6,  3, 1, 10, 1}, // #283
  {DBGFIELD("WriteFRcp")          1, false, false, 1977, 4,  8, 1,  0, 0}, // #284
  {DBGFIELD("WriteRMW")           0, false, false, 138, 2,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteShiftLd")       1, false, false, 672, 3, 23, 1,  0, 0}, // #286
  {DBGFIELD("WriteShift")         1, false, false,  1, 1,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteFRndLd")        1, false, false, 2030, 5, 11, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRnd")          1, false, false, 2035, 3, 22, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, 2030, 5, 11, 1, 10, 1}, // #290
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, 2131, 6,  3, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 1977, 4,  8, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, 2131, 6,  3, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, 2131, 6,  3, 1, 10, 1}, // #294
  {DBGFIELD("WriteFRsqrt")        1, false, false, 1977, 4,  8, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd_WriteRMW") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #296
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #297
  {DBGFIELD("WriteShiftCL")       1, false, false,  1, 1,  1, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, 672, 3, 23, 1,  2, 1}, // #299
  {DBGFIELD("WriteSETCCStore")    1, false, false, 2217, 3,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteSETCC")         1, false, false,  1, 1,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteSHDmrcl")       8, false, false, 2220, 3,  7, 1,  0, 0}, // #302
  {DBGFIELD("WriteSHDmri")        8, false, false, 2220, 3,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteSHDrrcl")       7, false, false, 16, 1, 23, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDrri")        6, false, false,  9, 1, 22, 1,  0, 0}, // #305
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, 2223, 6, 38, 1,  0, 0}, // #306
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 2223, 4, 66, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, 2229, 6, 35, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrtX")        1, false, false, 2229, 4, 31, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, 2223, 6, 38, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, 2223, 6, 38, 1, 10, 1}, // #311
  {DBGFIELD("WriteFSqrt64")       1, false, false, 2223, 4, 66, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrtLd")       1, false, false, 2229, 6, 35, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, 2229, 6, 35, 1, 10, 1}, // #314
  {DBGFIELD("WriteFSqrt")         1, false, false, 2229, 4, 31, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt80")       1, false, false, 2235, 4, 72, 1,  0, 0}, // #316
  {DBGFIELD("WriteSTMXCSR")       1, false, false, 138, 2,  1, 1,  0, 0}, // #317
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 1985, 3,  5, 1,  0, 0}, // #318
  {DBGFIELD("WriteTZCNT")         2, false, false,  3, 1,  8, 1,  0, 0}, // #319
  {DBGFIELD("WriteFMAZLd")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("WriteFMALd")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #321
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 2239, 6, 11, 1, 10, 1}, // #322
  {DBGFIELD("WriteFAdd64Y")       2, false, false, 2239, 4, 22, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("WriteFAdd64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 2239, 6, 11, 1, 10, 1}, // #326
  {DBGFIELD("WriteFAddY")         2, false, false, 2239, 4, 22, 1,  0, 0}, // #327
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFAddZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteShuffleY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteShuffleZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 2241, 4,  4, 1, 10, 1}, // #334
  {DBGFIELD("WriteFLogicY")       2, false, false, 2241, 2,  1, 1,  0, 0}, // #335
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFLogicZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 6, false, false, 2245, 4, 11, 1, 10, 1}, // #338
  {DBGFIELD("WriteFVarBlendY")    6, false, false, 2245, 2, 22, 1,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFVarBlendZ")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 2241, 4,  4, 1, 10, 1}, // #342
  {DBGFIELD("WriteFBlendY")       2, false, false, 2241, 2,  1, 1,  0, 0}, // #343
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 6, false, false, 2245, 4, 11, 1, 14, 2}, // #344
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2012, 4,  3, 1, 14, 2}, // #345
  {DBGFIELD("WriteShuffle256Ld")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteShuffle256")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffleYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFShuffle256")   2, false, false, 2241, 2,  1, 1,  0, 0}, // #349
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 2249, 4,  4, 1,  0, 0}, // #350
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 2239, 6,  3, 1, 10, 1}, // #351
  {DBGFIELD("WriteFCmp64Y")       2, false, false, 2239, 4,  8, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 2239, 6,  3, 1, 10, 1}, // #353
  {DBGFIELD("WriteFCmpY")         2, false, false, 2239, 4,  8, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFCmpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteVarShuffle256Ld") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 2253, 5, 11, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, 2258, 3, 22, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 2253, 5, 11, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, 2258, 3, 22, 1,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, 2261, 6,  9, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtPD2IY")      3, false, false, 2267, 4,  4, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtPD2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 2261, 6,  9, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSY")     3, false, false, 2267, 4,  4, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 2253, 5, 11, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 2258, 3, 22, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPH2PSLd")    1, false, false, 2030, 5, 11, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPH2PS")      1, false, false, 2035, 3, 22, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPH2PSZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 2253, 5, 11, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, 2258, 3, 22, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPS2IZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPS2IZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, 2253, 5,  3, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 2258, 3,  8, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2PDZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2PDZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, 2271, 6,  3, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PHY")     3, false, false, 2277, 4,  4, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PHSt")    1, false, false, 1968, 5, 23, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PH")      1, false, false, 2035, 3, 22, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PHZSt")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, 2038, 10, 20, 1, 10, 1}, // #395
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, 2038, 10, 20, 1, 10, 1}, // #396
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WritePSADBWY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WritePSADBWZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, 2281, 6, 97, 1, 10, 1}, // #401
  {DBGFIELD("WriteFDiv64Y")       2, false, false, 2281, 4, 98, 1,  0, 0}, // #402
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteFDiv64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, 2281, 6, 97, 1, 10, 1}, // #405
  {DBGFIELD("WriteFDivY")         2, false, false, 2281, 4, 98, 1,  0, 0}, // #406
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteFDivZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 10, false, false, 2287, 7, 28, 1, 10, 1}, // #409
  {DBGFIELD("WriteDPPSY")         10, false, false, 2287, 5, 20, 1,  0, 0}, // #410
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFMAY")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFMAX")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFMAZ")          16383, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMA")           16383, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, 2253, 5, 11, 1, 10, 1}, // #426
  {DBGFIELD("WriteFRndY")         2, false, false, 2258, 3, 22, 1,  0, 0}, // #427
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFRndZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteVecIMulY")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteVecIMulZ")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVecALUY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteVecALUZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 2, false, false, 2239, 6, 11, 1, 10, 1}, // #438
  {DBGFIELD("WriteFHAddY")        2, false, false, 2239, 4, 22, 1,  0, 0}, // #439
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 2249, 4,  4, 1, 10, 1}, // #440
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecLoadY")      1, false, false, 2097, 4,  5, 1,  0, 0}, // #442
  {DBGFIELD("WriteFMaskedStoreY") 2, false, false, 2294, 4,  4, 1,  0, 0}, // #443
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 2298, 4,  4, 1,  0, 0}, // #444
  {DBGFIELD("WriteFMaskedStore")  1, false, false, 2302, 4,  4, 1,  0, 0}, // #445
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, 2249, 4,  4, 1,  0, 0}, // #446
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFCmp64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteFMoveY")        2, false, false, 2241, 2,  1, 1,  0, 0}, // #449
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 2241, 4,  4, 1,  0, 0}, // #450
  {DBGFIELD("WriteFShuffleY")     2, false, false, 2241, 2,  1, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffleZLd")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFShuffleZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecStoreY")     1, false, false, 1968, 5,  1, 1,  0, 0}, // #454
  {DBGFIELD("WriteVecMoveY")      2, false, false, 2306, 2,  1, 1,  0, 0}, // #455
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 2097, 4,  5, 1,  0, 0}, // #456
  {DBGFIELD("WriteVecStoreNTY")   1, false, false, 2308, 5,  8, 1,  0, 0}, // #457
  {DBGFIELD("WriteFStoreNTY")     1, false, false, 2308, 5, 22, 1,  0, 0}, // #458
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteMPSADY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 2313, 6,  7, 1, 10, 1}, // #461
  {DBGFIELD("WriteFMul64Y")       2, false, false, 2313, 4, 23, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMul64Z")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 2319, 6,  3, 1, 10, 1}, // #465
  {DBGFIELD("WriteFMulY")         2, false, false, 2319, 4,  8, 1,  0, 0}, // #466
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFMulZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecALUYLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecALUZLd")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLogicY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecLogicZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteBlendY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVarBlendY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVarBlendZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2153, 4,  3, 1, 14, 2}, // #482
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 14, 2}, // #485
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 16, 2}, // #486
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFVarShuffle256") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 6, false, false, 2325, 4, 11, 1, 14, 2}, // #489
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 6, false, false, 2325, 4, 11, 1, 16, 2}, // #490
  {DBGFIELD("WriteFVarShuffleY")  6, false, false, 2325, 2, 22, 1,  0, 0}, // #491
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2329, 4,  3, 1, 14, 2}, // #492
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 3, false, false, 2329, 4,  3, 1, 16, 2}, // #493
  {DBGFIELD("WriteFVarShuffle")   3, false, false, 2302, 2,  8, 1,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 6, false, false, 2325, 4, 11, 1, 10, 1}, // #495
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 3, false, false, 2329, 4,  3, 1, 10, 1}, // #496
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteFVarShuffleZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WritePHAddY")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, 2004, 5,  3, 1,  0, 0}, // #501
  {DBGFIELD("WriteVecIMulYLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVecIMulZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 2333, 4,  4, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 2337, 4,  4, 1,  0, 0}, // #505
  {DBGFIELD("WriteVecMaskedStore") 1, false, false, 2341, 4,  4, 1,  0, 0}, // #506
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, 2345, 4,  4, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecMOVMSKY")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WritePMULLDY")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WritePMULLDZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 2211, 4,  3, 1, 14, 2}, // #513
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 3, false, false, 2211, 4,  3, 1, 16, 2}, // #514
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecShiftImmYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteVecShiftImmY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecShiftImmZLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteVecShiftImmZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVarVecShift")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVarVecShiftY")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVarVecShiftZ")  16383, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #526
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVarShuffleY")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVarShuffleZ")   16383, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteShuffleZLd")    16383, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVecShiftY")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecShiftZ")     16383, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, 2349, 7,  7, 1, 10, 1}, // #536
  {DBGFIELD("WriteVecTestY")      3, false, false, 2349, 5, 23, 1,  0, 0}, // #537
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, 2131, 6,  3, 1, 10, 1}, // #538
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, 2319, 6,  3, 1, 10, 1}, // #539
  {DBGFIELD("WriteFRcpY")         2, false, false, 2319, 4,  8, 1,  0, 0}, // #540
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteFRcpZ")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 2319, 6,  3, 1,  0, 0}, // #543
  {DBGFIELD("WriteFRndYLd")       2, false, false, 2253, 5, 11, 1,  0, 0}, // #544
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, 2131, 6,  3, 1, 10, 1}, // #545
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, 2319, 6,  3, 1, 10, 1}, // #546
  {DBGFIELD("WriteFRsqrtY")       2, false, false, 2319, 4,  8, 1,  0, 0}, // #547
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteFRsqrtZ")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 2319, 6,  3, 1,  0, 0}, // #550
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 2241, 4,  4, 1, 10, 1}, // #551
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 2356, 6, 43, 1,  0, 0}, // #553
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, 2356, 4, 99, 1,  0, 0}, // #554
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, 2223, 6, 38, 1, 10, 1}, // #555
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, 2356, 6, 43, 1, 10, 1}, // #556
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteFSqrt64Z")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 2362, 6, 100, 1,  0, 0}, // #559
  {DBGFIELD("WriteFSqrtY")        2, false, false, 2362, 4, 84, 1,  0, 0}, // #560
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, 2229, 6, 35, 1, 10, 1}, // #561
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, 2362, 6, 100, 1, 10, 1}, // #562
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFSqrtZ")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 3, false, false, 2349, 7,  7, 1, 10, 1}, // #565
  {DBGFIELD("WriteFTestY")        3, false, false, 2349, 5, 23, 1,  0, 0}, // #566
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, 2019, 8, 11, 1, 10, 1}, // #567
  {DBGFIELD("WriteFTest")         1, false, false, 2019, 6, 22, 1,  0, 0}, // #568
  {DBGFIELD("WriteALULd_WriteRMW") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #569
  {DBGFIELD("WriteXCHG")          1, false, false,  1, 1,  1, 1,  0, 0}, // #570
  {DBGFIELD("COPY")               1, false, false,  1, 1,  1, 1,  0, 0}, // #571
  {DBGFIELD("FXAM")               1, false, false,  1, 1,  2, 1,  0, 0}, // #572
  {DBGFIELD("LD_Frr")             1, false, false,  1, 1,  1, 1,  0, 0}, // #573
  {DBGFIELD("MOVSX64rr32")        1, false, false,  1, 1,  1, 1,  0, 0}, // #574
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #575
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #576
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #577
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #578
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #579
  {DBGFIELD("FCOMPP")             1, false, false,  1, 1,  2, 1,  0, 0}, // #580
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #581
  {DBGFIELD("MMX_CVTPI2PSirr")    1, false, false, 2035, 3, 22, 1,  0, 0}, // #582
  {DBGFIELD("MMX_CVTPI2PSirm")    1, false, false, 2030, 5, 11, 1,  0, 0}, // #583
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #584
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, 673, 2,  5, 1,  0, 0}, // #585
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 138, 2,  1, 1,  0, 0}, // #586
  {DBGFIELD("XCH_F")              1, false, false,  1, 1,  1, 1,  0, 0}, // #587
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 1, false, false, 672, 3, 23, 1,  0, 0}, // #588
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #589
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, 673, 2,  5, 1,  0, 0}, // #590
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #591
  {DBGFIELD("LFENCE")             1, false, false, 138, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 1973, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 1962, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false,  1, 1,  1, 1,  0, 0}, // #596
  {DBGFIELD("POP16r")             1, false, false, 673, 2,  5, 1,  0, 0}, // #597
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, 1965, 3,  4, 1,  0, 0}, // #598
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #599
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false,  1, 1,  2, 1,  0, 0}, // #600
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 138, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false,  1, 1,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #603
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false,  1, 1,  1, 1,  0, 0}, // #604
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, 1968, 5,  1, 1,  0, 0}, // #605
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, 1968, 5,  1, 1,  0, 0}, // #606
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 1962, 2,  1, 1,  0, 0}, // #607
  {DBGFIELD("CLD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #608
  {DBGFIELD("LDDQUrm")            1, false, false, 2097, 4,  5, 1,  0, 0}, // #609
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #610
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, 1965, 3,  4, 1,  0, 0}, // #611
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #612
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, 1962, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 672, 3, 23, 1,  0, 0}, // #614
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #615
  {DBGFIELD("MOVDQUrm")           1, false, false, 2097, 4,  5, 1,  0, 0}, // #616
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 1973, 4,  5, 1,  0, 0}, // #617
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, 2097, 4,  4, 1, 10, 1}, // #618
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false,  1, 1,  1, 1,  0, 0}, // #619
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false,  1, 1,  1, 1,  0, 0}, // #620
  {DBGFIELD("LD_F80m")            1, false, false, 673, 2,  5, 1,  0, 0}, // #621
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, 2097, 4,  4, 1, 10, 1}, // #622
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #623
  {DBGFIELD("FLDCW16m")           1, false, false, 673, 2,  5, 1,  0, 0}, // #624
  {DBGFIELD("ST_FP80m")           1, false, false, 138, 2,  1, 1,  0, 0}, // #625
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #626
  {DBGFIELD("CMPXCHG8rm")         2, false, false, 1964, 4, 23, 1,  0, 0}, // #627
  {DBGFIELD("INTO")               1, false, false,  1, 1,  2, 1,  0, 0}, // #628
  {DBGFIELD("XLAT")               1, false, false, 673, 2,  5, 1,  0, 0}, // #629
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, 16, 1, 23, 1,  0, 0}, // #630
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false,  9, 1, 22, 1,  0, 0}, // #631
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, 2220, 3,  7, 1,  0, 0}, // #632
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, 2220, 3,  7, 1,  0, 0}, // #633
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, 138, 2,  1, 1,  0, 0}, // #634
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #635
  {DBGFIELD("AAD8i8")             1, false, false,  1, 1,  2, 1,  0, 0}, // #636
  {DBGFIELD("LOOPE")              1, false, false,  1, 1,  1, 1,  0, 0}, // #637
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 138, 2,  1, 1,  0, 0}, // #638
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, 16, 1, 23, 1,  0, 0}, // #639
  {DBGFIELD("FNSTCW16m")          1, false, false,  1, 1,  1, 1,  0, 0}, // #640
  {DBGFIELD("POPA16_POPA32")      1, false, false, 673, 2,  5, 1,  0, 0}, // #641
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 138, 2,  1, 1,  0, 0}, // #642
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, 2220, 3,  7, 1,  0, 0}, // #643
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, 2220, 3,  7, 1,  0, 0}, // #644
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false,  9, 1, 22, 1,  0, 0}, // #645
  {DBGFIELD("CMPXCHG8rr")         1, false, false,  1, 1,  1, 1,  0, 0}, // #646
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #647
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #648
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 1, false, false, 2019, 8, 11, 1, 10, 1}, // #649
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, 2038, 10, 20, 1,  0, 0}, // #650
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false,  1, 1,  2, 1,  0, 0}, // #651
  {DBGFIELD("AAA_AAS")            1, false, false,  1, 1,  2, 1,  0, 0}, // #652
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 2, false, false, 1964, 4, 23, 1,  0, 0}, // #653
  {DBGFIELD("LOOPNE")             1, false, false,  1, 1,  1, 1,  0, 0}, // #654
  {DBGFIELD("PAUSE")              1, false, false,  1, 1,  1, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8B")          2, false, false, 1964, 4, 23, 1,  0, 0}, // #656
  {DBGFIELD("DAA")                1, false, false,  1, 1,  2, 1,  0, 0}, // #657
  {DBGFIELD("LOOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #658
  {DBGFIELD("DAS")                1, false, false,  1, 1,  2, 1,  0, 0}, // #659
  {DBGFIELD("AAM8i8")             1, false, false,  1, 1,  2, 1,  0, 0}, // #660
  {DBGFIELD("STD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16B")         2, false, false, 1964, 4, 23, 1,  0, 0}, // #662
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false,  1, 1,  2, 1,  0, 0}, // #663
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false,  1, 1,  2, 1,  0, 0}, // #664
  {DBGFIELD("POPF32_POPF64")      1, false, false, 673, 2,  5, 1,  0, 0}, // #665
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #666
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false,  1, 1,  2, 1,  0, 0}, // #667
  {DBGFIELD("ENTER")              1, false, false,  1, 1,  2, 1,  0, 0}, // #668
  {DBGFIELD("POPF16")             1, false, false, 673, 2,  5, 1,  0, 0}, // #669
  {DBGFIELD("MONITORrrr")         1, false, false,  1, 1,  2, 1,  0, 0}, // #670
  {DBGFIELD("FRNDINT")            1, false, false,  1, 1,  2, 1,  0, 0}, // #671
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false,  1, 1,  2, 1,  0, 0}, // #672
  {DBGFIELD("POPSS16_POPSS32")    1, false, false,  1, 1,  2, 1,  0, 0}, // #673
  {DBGFIELD("FPREM")              1, false, false,  1, 1,  2, 1,  0, 0}, // #674
  {DBGFIELD("INSB_INSL_INSW")     1, false, false,  1, 1,  2, 1,  0, 0}, // #675
  {DBGFIELD("FNINIT")             1, false, false,  1, 1,  2, 1,  0, 0}, // #676
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #677
  {DBGFIELD("FPREM1")             1, false, false,  1, 1,  2, 1,  0, 0}, // #678
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #679
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false,  1, 1,  2, 1,  0, 0}, // #680
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false,  1, 1,  2, 1,  0, 0}, // #681
  {DBGFIELD("FSCALE")             1, false, false,  1, 1,  2, 1,  0, 0}, // #682
  {DBGFIELD("RDMSR")              1, false, false,  1, 1,  2, 1,  0, 0}, // #683
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 1, false, false, 672, 3, 23, 1,  0, 0}, // #684
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false,  1, 1,  2, 1,  0, 0}, // #685
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #686
  {DBGFIELD("F2XM1")              1, false, false,  1, 1,  2, 1,  0, 0}, // #687
  {DBGFIELD("CPUID")              1, false, false,  1, 1,  2, 1,  0, 0}, // #688
  {DBGFIELD("INT")                1, false, false,  1, 1,  2, 1,  0, 0}, // #689
  {DBGFIELD("INT3")               1, false, false,  1, 1,  2, 1,  0, 0}, // #690
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false,  1, 1,  2, 1,  0, 0}, // #691
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false,  1, 1,  2, 1,  0, 0}, // #692
  {DBGFIELD("FYL2X")              1, false, false,  1, 1,  2, 1,  0, 0}, // #693
  {DBGFIELD("FYL2XP1")            1, false, false,  1, 1,  2, 1,  0, 0}, // #694
  {DBGFIELD("FPTAN")              1, false, false,  1, 1,  2, 1,  0, 0}, // #695
  {DBGFIELD("FSINCOS")            1, false, false,  1, 1,  2, 1,  0, 0}, // #696
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false,  1, 1,  2, 1,  0, 0}, // #697
  {DBGFIELD("FPATAN")             1, false, false,  1, 1,  2, 1,  0, 0}, // #698
  {DBGFIELD("WRMSR")              1, false, false,  1, 1,  2, 1,  0, 0}, // #699
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #700
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 2019, 6, 22, 1,  0, 0}, // #701
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false,  1, 1,  2, 1,  0, 0}, // #702
  {DBGFIELD("FNOP")               1, false, false,  1, 1,  1, 1,  0, 0}, // #703
  {DBGFIELD("RETQ")               1, false, false, 672, 3, 23, 1,  0, 0}, // #704
  {DBGFIELD("CDQ_CQO")            1, false, false,  1, 1,  1, 1,  0, 0}, // #705
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #706
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 1962, 2,  1, 1,  0, 0}, // #707
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 1962, 2,  1, 1,  0, 0}, // #708
  {DBGFIELD("SETAr_SETBEr")       1, false, false,  1, 1,  1, 1,  0, 0}, // #709
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #710
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #711
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #712
  {DBGFIELD("CWD")                1, false, false,  1, 1,  1, 1,  0, 0}, // #713
  {DBGFIELD("FNSTSW16r")          1, false, false,  1, 1,  1, 1,  0, 0}, // #714
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #715
  {DBGFIELD("PUSHFS64")           1, false, false,  1, 1,  2, 1,  0, 0}, // #716
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #717
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false,  1, 1,  1, 1,  0, 0}, // #718
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 2019, 6, 22, 1,  0, 0}, // #719
  {DBGFIELD("MOV64sr")            1, false, false,  1, 1,  1, 1,  0, 0}, // #720
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 672, 3, 23, 1,  0, 0}, // #721
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false,  1, 1,  1, 1,  0, 0}, // #722
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false,  1, 1,  1, 1,  0, 0}, // #723
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #724
  {DBGFIELD("CLI")                1, false, false,  1, 1,  2, 1,  0, 0}, // #725
  {DBGFIELD("PUSHGS64")           1, false, false,  1, 1,  2, 1,  0, 0}, // #726
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, 138, 2,  1, 1,  0, 0}, // #727
  {DBGFIELD("CALL64pcrel32")      1, false, false,  1, 1,  1, 1,  0, 0}, // #728
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #729
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, 1968, 5, 22, 1,  0, 0}, // #730
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #731
  {DBGFIELD("SETAm_SETBEm")       1, false, false, 2217, 3,  1, 1,  0, 0}, // #732
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, 1968, 5, 22, 1,  0, 0}, // #733
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, 138, 2,  1, 1,  0, 0}, // #734
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, 673, 2,  5, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, 1968, 5,  8, 1,  0, 0}, // #736
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 1973, 4,  4, 1,  0, 0}, // #737
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 2097, 4,  5, 1,  0, 0}, // #738
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 1973, 4,  4, 1,  0, 0}, // #739
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 1973, 4,  5, 1,  0, 0}, // #740
  {DBGFIELD("MOV16sm")            1, false, false,  1, 1,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, 2097, 4,  4, 1, 10, 1}, // #743
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #744
  {DBGFIELD("LODSL_LODSQ")        1, false, false,  1, 1,  2, 1,  0, 0}, // #745
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, 2368, 4,  4, 1,  0, 0}, // #746
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, 2241, 4,  4, 1,  0, 0}, // #747
  {DBGFIELD("VINSERTF128rm")      2, false, false, 2249, 4,  4, 1, 10, 1}, // #748
  {DBGFIELD("MMX_PADDQirm")       1, false, false, 2097, 4,  4, 1, 10, 1}, // #749
  {DBGFIELD("VERRm_VERWm")        1, false, false,  1, 1,  2, 1,  0, 0}, // #750
  {DBGFIELD("FARJMP64")           1, false, false,  1, 1,  1, 1,  0, 0}, // #751
  {DBGFIELD("FNSTSWm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #752
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #753
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, 672, 3, 23, 1,  0, 0}, // #754
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #755
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 1, false, false, 2019, 8, 11, 1, 10, 1}, // #756
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false,  1, 1,  2, 1,  0, 0}, // #757
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #758
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #759
  {DBGFIELD("FARCALL64")          1, false, false,  1, 1,  1, 1,  0, 0}, // #760
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, 2038, 10, 20, 1,  0, 0}, // #761
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, 2038, 10, 20, 1,  0, 0}, // #762
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 673, 2,  5, 1,  0, 0}, // #763
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #764
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, 1981, 4,  5, 1,  0, 0}, // #765
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, 1988, 6, 11, 1,  0, 0}, // #766
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #767
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, 2019, 8, 11, 1,  0, 0}, // #768
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, 2131, 6,  3, 1,  0, 0}, // #769
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, 1988, 6, 11, 1,  0, 0}, // #770
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, 2131, 6,  3, 1,  0, 0}, // #771
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, 2084, 6, 77, 1,  0, 0}, // #772
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, 2084, 6, 77, 1,  0, 0}, // #773
  {DBGFIELD("VZEROALL")           73, false, false,  0, 0, 67, 1,  0, 0}, // #774
  {DBGFIELD("VZEROUPPER")         37, false, false,  0, 0, 40, 1,  0, 0}, // #775
  {DBGFIELD("CLC")                1, false, false,  1, 1,  1, 1,  0, 0}, // #776
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #777
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #778
  {DBGFIELD("PXORrr_VPXORrr")     16382, false, false,  0, 0,  0, 0,  0, 0}, // #779
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #780
  {DBGFIELD("PSUBQrr")            16382, false, false,  0, 0,  0, 0,  0, 0}, // #781
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #782
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, 1973, 4,  4, 1, 10, 1}, // #783
  {DBGFIELD("RETIL_RETIQ_RETIW")  1, false, false, 672, 3, 23, 1,  0, 0}, // #784
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 1, false, false, 672, 3, 23, 1,  0, 0}, // #785
  {DBGFIELD("RDPMC")              1, false, false,  1, 1,  2, 1,  0, 0}, // #786
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #787
  {DBGFIELD("FBLDm")              1, false, false,  1, 1,  2, 1,  0, 0}, // #788
  {DBGFIELD("FFREE_FFREEP")       1, false, false,  1, 1,  2, 1,  0, 0}, // #789
  {DBGFIELD("FSAVEm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #790
  {DBGFIELD("FRSTORm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #791
  {DBGFIELD("FXTRACT")            1, false, false,  1, 1,  2, 1,  0, 0}, // #792
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 1973, 4,  4, 1,  0, 0}, // #793
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #794
  {DBGFIELD("VBROADCASTF128")     2, false, false, 2368, 4,  4, 1,  0, 0}, // #795
  {DBGFIELD("VBROADCASTI128")     1, false, false, 2097, 4,  4, 1,  0, 0}, // #796
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #797
  {DBGFIELD("FBSTPm")             1, false, false,  1, 1,  2, 1,  0, 0}, // #798
  {DBGFIELD("VMPTRSTm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #799
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, 138, 2,  1, 1,  0, 0}, // #800
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #803
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #804
  {DBGFIELD("FINCSTP")            1, false, false,  1, 1,  2, 1,  0, 0}, // #805
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false,  1, 1,  1, 1,  0, 0}, // #806
  {DBGFIELD("VPBLENDDYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("VPBLENDDrri")        1, false, false, 1962, 2,  1, 1,  0, 0}, // #808
  {DBGFIELD("CMC_STC")            1, false, false,  1, 1,  1, 1,  0, 0}, // #809
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false,  1, 1,  2, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 1, false, false, 2030, 5,  3, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #812
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 2056, 5, 20, 1,  0, 0}, // #813
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 2056, 5, 20, 1, 10, 1}, // #814
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #815
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, 672, 3, 23, 1,  1, 1}, // #816
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #817
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #818
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 1, false, false, 672, 3, 23, 1,  0, 0}, // #819
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, 672, 3, 23, 1,  1, 1}, // #820
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, 672, 3, 23, 1,  0, 0}, // #821
  {DBGFIELD("VINSERTI128rm")      16383, false, false,  0, 0,  0, 0,  0, 0}, // #822
  {DBGFIELD("VPBLENDDrmi")        1, false, false, 2097, 4,  4, 1, 10, 1}, // #823
  {DBGFIELD("VPBLENDDYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #824
  {DBGFIELD("POP32r_POP64r")      1, false, false, 673, 2,  5, 1,  0, 0}, // #825
  {DBGFIELD("SFENCE")             1, false, false, 138, 2,  1, 1,  0, 0}, // #826
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("MOVBE16mr")          1, false, false, 138, 2,  1, 1,  0, 0}, // #828
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, 138, 2,  1, 1,  0, 0}, // #829
  {DBGFIELD("MFENCE")             1, false, false, 138, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("XGETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #831
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 1, false, false, 2035, 3,  8, 1,  0, 0}, // #832
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 2061, 3,  3, 1,  0, 0}, // #833
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #834
  {DBGFIELD("LRETQ_RETL")         1, false, false, 672, 3, 23, 1,  0, 0}, // #835
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #836
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #837
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, 2258, 3, 22, 1,  0, 0}, // #838
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #840
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 2253, 5, 11, 1,  0, 0}, // #841
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 2253, 5, 11, 1,  0, 0}, // #842
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #843
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #844
  {DBGFIELD("CLDEMOTE")           1, false, false, 673, 2,  5, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #846
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #847
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 2258, 3,  8, 1,  0, 0}, // #848
  {DBGFIELD("MMX_CVTPI2PDirr")    1, false, false, 2035, 3, 22, 1,  0, 0}, // #849
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #850
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #851
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #852
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 2061, 3,  3, 1,  0, 0}, // #853
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 2035, 3,  7, 1,  0, 0}, // #854
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 2035, 3,  7, 1,  0, 0}, // #855
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #856
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, 2038, 10, 20, 1,  0, 0}, // #857
  {DBGFIELD("CVTSS2SI64rm_Int")   2, false, false, 2038, 10, 20, 1,  0, 0}, // #858
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 2038, 10, 20, 1,  0, 0}, // #859
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 2253, 5,  3, 1,  0, 0}, // #860
  {DBGFIELD("CVTPD2PSrm")         1, false, false, 2030, 5, 11, 1,  0, 0}, // #861
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #862
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPI2PDirm")    1, false, false, 2030, 5, 11, 1,  0, 0}, // #864
  {DBGFIELD("CVTSD2SSrm")         2, false, false, 2056, 5, 20, 1,  0, 0}, // #865
  {DBGFIELD("VCVTSD2SSrm")        2, false, false, 2056, 5, 20, 1, 10, 1}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false,  1, 1,  2, 1,  0, 0}, // #869
  {DBGFIELD("VPCMPGTQYrr")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #870
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 1977, 4,  8, 1,  0, 0}, // #871
  {DBGFIELD("VPCMPGTQYrm")        16383, false, false,  0, 0,  0, 0,  0, 0}, // #872
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, 2035, 3,  7, 1,  0, 0}, // #873
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false,  1, 1,  2, 1,  0, 0}, // #874
  {DBGFIELD("XSETBV")             1, false, false,  1, 1,  2, 1,  0, 0}, // #875
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 2258, 3, 22, 1,  0, 0}, // #876
  {DBGFIELD("VCVTPD2PSYrr")       3, false, false, 2267, 4,  4, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 3, false, false, 2267, 4,  4, 1,  0, 0}, // #878
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, 2253, 5, 11, 1,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false, 1964, 4, 23, 2,  0, 0}, // #880
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false,  1, 1,  1, 1,  0, 0}, // #881
  {DBGFIELD("RCL8rCL")            1, false, false,  1, 1,  1, 1,  0, 0}, // #882
  {DBGFIELD("RDTSC")              1, false, false,  1, 1,  2, 1,  0, 0}, // #883
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #884
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 2084, 4, 63, 1,  0, 0}, // #885
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, 2084, 6, 77, 1,  0, 0}, // #886
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, 2084, 6, 77, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 2084, 4, 63, 1,  0, 0}, // #888
  {DBGFIELD("XSAVE64")            1, false, false,  1, 1,  2, 1,  0, 0}, // #889
  {DBGFIELD("XSAVE")              1, false, false,  1, 1,  2, 1,  0, 0}, // #890
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #891
  {DBGFIELD("VMCLEARm")           1, false, false,  1, 1,  2, 1,  0, 0}, // #892
  {DBGFIELD("FLDENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #893
  {DBGFIELD("FXRSTOR64")          1, false, false,  1, 1,  2, 1,  0, 0}, // #894
  {DBGFIELD("FSTENVm")            1, false, false,  1, 1,  2, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #897
  {DBGFIELD("VPGATHERQDYrm")      1, false, false, 673, 2,  5, 1,  0, 0}, // #898
  {DBGFIELD("VPGATHERQDrm")       1, false, false, 673, 2,  5, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPSYrm")      1, false, false, 673, 2,  5, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #904
  {DBGFIELD("ADC8i8_SBB8i8")      1, false, false,  3, 1,  1, 1,  0, 0}, // #905
  {DBGFIELD("ADC8ri_ADC8ri8_SBB8ri_SBB8ri8") 1, false, false,  3, 1,  1, 1,  0, 0}, // #906
  {DBGFIELD("VCVTSS2SDrm")        2, false, false, 2056, 5, 20, 1, 10, 1}, // #907
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, 2019, 8, 11, 1,  0, 0}, // #908
  {DBGFIELD("LRETQ")              1, false, false, 672, 3, 23, 1,  0, 0}, // #909
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #910
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #911
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_Int") 2, false, false, 2056, 5, 20, 1, 10, 1}, // #912
  {DBGFIELD("POPF64")             1, false, false, 673, 2,  5, 1,  0, 0}, // #913
  {DBGFIELD("VGATHERQPDrm")       1, false, false, 673, 2,  5, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm")      1, false, false, 673, 2,  5, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDrm")       1, false, false, 673, 2,  5, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSrm")       1, false, false, 673, 2,  5, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERDPDYrm")      1, false, false, 673, 2,  5, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERDPSYrm")      1, false, false, 673, 2,  5, 1,  0, 0}, // #919
  {DBGFIELD("MOV16rm")            1, false, false, 673, 2,  5, 1,  0, 0}, // #920
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 672, 3, 23, 1,  0, 0}, // #921
  {DBGFIELD("POP16rmm")           2, false, false, 1965, 3,  4, 1,  0, 0}, // #922
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, 1965, 3,  4, 1,  0, 0}, // #923
  {DBGFIELD("PUSHF16")            1, false, false, 138, 2,  1, 1,  0, 0}, // #924
  {DBGFIELD("LAHF")               1, false, false,  1, 1,  1, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 1, false, false, 1964, 4,  5, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false, 1981, 4,  5, 1,  0, 0}, // #927
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, 1964, 4,  5, 1,  0, 0}, // #928
  {DBGFIELD("MULX32rr")           3, false, false, 2142, 3, 93, 2,  0, 0}, // #929
  {DBGFIELD("MULX32rm")           3, false, false, 2137, 5, 91, 2,  0, 0}, // #930
  {DBGFIELD("MULX64rr")           3, false, false, 2150, 3, 91, 2,  0, 0}, // #931
  {DBGFIELD("MULX64rm")           3, false, false, 2145, 5, 95, 2,  0, 0}, // #932
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false,  1, 1,  1, 1,  0, 0}, // #933
  {DBGFIELD("RETW_LRETL_LRETW")   1, false, false, 672, 3, 23, 1,  0, 0}, // #934
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, 672, 3, 23, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 1, false, false, 1964, 4,  5, 1,  0, 0}, // #936
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, 2220, 3,  7, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, 16, 1, 23, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, 2220, 3,  7, 1,  0, 0}, // #939
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 1973, 4,  4, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 1973, 2,  1, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 1977, 4,  8, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, 1968, 5,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, 1968, 5,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 2337, 4,  4, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, 2345, 4,  4, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 2333, 4,  4, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 1, false, false, 2341, 4,  4, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       16382, false, false,  0, 0,  0, 0,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       2, false, false, 2249, 4,  4, 1, 10, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 1973, 2,  1, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, 1968, 5,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      2, false, false, 2241, 2,  1, 1,  0, 0}, // #964
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #965
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, 2261, 6,  9, 1,  0, 0}, // #966
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #967
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, 2038, 10, 20, 1,  0, 0}, // #968
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 1962, 2,  1, 1,  0, 0}, // #969
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 2215, 2,  8, 1,  0, 0}, // #970
  {DBGFIELD("SHA256MSG2rm")       1, false, false, 2004, 5,  3, 1, 10, 1}, // #971
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 2009, 3,  8, 1,  0, 0}, // #972
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 2009, 3,  8, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, 2004, 5,  3, 1, 10, 1}, // #974
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 2009, 3,  8, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG2rm")         1, false, false, 2004, 5,  3, 1, 10, 1}, // #976
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 2009, 3,  8, 1,  0, 0}, // #977
  {DBGFIELD("SHA1NEXTErm")        1, false, false, 2004, 5,  3, 1, 10, 1}, // #978
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 2009, 3,  8, 1,  0, 0}, // #979
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, 2004, 5,  3, 1, 10, 1}, // #980
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 2009, 3,  8, 1,  0, 0}, // #981
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, 2004, 5,  3, 1, 10, 1}, // #982
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false,  1, 1,  2, 1,  0, 0}, // #983
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false, 1964, 4,  5, 1,  0, 0}, // #984
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #985
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, 672, 3, 23, 1,  0, 0}, // #986
  {DBGFIELD("XCHG16rr")           1, false, false,  1, 1,  1, 1,  0, 0}, // #987
  {DBGFIELD("CRC32r32r16")        3, false, false, 29, 1, 22, 1,  0, 0}, // #988
  {DBGFIELD("CRC32r32r32")        3, false, false, 29, 1, 22, 1,  0, 0}, // #989
  {DBGFIELD("CRC32r64r64")        3, false, false, 29, 1, 22, 1,  0, 0}, // #990
  {DBGFIELD("CMOVG16rm_CMOVG32rm_CMOVG64rm_CMOVGE16rm_CMOVGE32rm_CMOVGE64rm_CMOVL16rm_CMOVL32rm_CMOVL64rm_CMOVLE16rm_CMOVLE32rm_CMOVLE64rm") 1, false, false, 672, 3, 23, 1,  1, 1}, // #991
  {DBGFIELD("SETGEm_SETGm_SETLEm_SETLm") 1, false, false, 2217, 3,  1, 1,  0, 0}, // #992
  {DBGFIELD("SAHF")               1, false, false,  1, 1,  1, 1,  0, 0}, // #993
  {DBGFIELD("RCR8ri")             1, false, false,  1, 1,  1, 1,  0, 0}, // #994
  {DBGFIELD("RCL16rCL")           1, false, false,  1, 1,  1, 1,  0, 0}, // #995
  {DBGFIELD("RCR16ri")            1, false, false,  1, 1,  1, 1,  0, 0}, // #996
  {DBGFIELD("RCL32rCL_RCL64rCL")  1, false, false,  1, 1,  1, 1,  0, 0}, // #997
  {DBGFIELD("RCR64rCL")           1, false, false,  1, 1,  1, 1,  0, 0}, // #998
  {DBGFIELD("RCR32rCL")           1, false, false,  1, 1,  1, 1,  0, 0}, // #999
  {DBGFIELD("RCR32ri_RCR64ri")    1, false, false,  1, 1,  1, 1,  0, 0}, // #1000
  {DBGFIELD("RCL16ri")            1, false, false,  1, 1,  1, 1,  0, 0}, // #1001
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false,  1, 1,  1, 1,  0, 0}, // #1002
  {DBGFIELD("SHLD32rri8")         6, false, false,  9, 1, 22, 1,  0, 0}, // #1003
  {DBGFIELD("SHRD16rri8")         6, false, false,  9, 1, 22, 1,  0, 0}, // #1004
  {DBGFIELD("SHLD16rrCL")         7, false, false, 16, 1, 23, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, 1968, 5,  8, 1,  0, 0}, // #1006
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 1, false, false, 1968, 5,  1, 1,  0, 0}, // #1007
  {DBGFIELD("TST_F")              1, false, false, 2019, 6, 22, 1,  0, 0}, // #1008
  {DBGFIELD("VDPPSrri")           5, false, false, 2090, 5,  9, 1,  0, 0}, // #1009
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr_VFRCZSDrr_VFRCZSSrr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1010
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, 2030, 5, 11, 1, 10, 1}, // #1011
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1012
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 2, false, false, 2253, 5, 11, 1, 10, 1}, // #1013
  {DBGFIELD("MMX_CVTTPD2PIirr")   1, false, false, 2035, 3, 22, 1,  0, 0}, // #1014
  {DBGFIELD("CVTSI642SDrr")       2, false, false, 2035, 3,  7, 1,  0, 0}, // #1015
  {DBGFIELD("CVTSI642SSrr")       2, false, false, 2035, 3,  7, 1,  0, 0}, // #1016
  {DBGFIELD("VMOVDQUYmr")         1, false, false, 1968, 5,  1, 1,  0, 0}, // #1017
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 3, false, false, 2207, 4, 23, 1,  0, 0}, // #1018
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1019
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1020
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, 2009, 3,  8, 1,  0, 0}, // #1021
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1022
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1023
  {DBGFIELD("PANDNrr_VPANDNrr")   16382, false, false,  0, 0,  0, 0,  0, 0}, // #1024
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1025
  {DBGFIELD("VXORPSYrr_VXORPDYrr_VANDNPSYrr_VANDNPDYrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1026
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1027
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1028
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1029
  {DBGFIELD("LEA16r")             1, false, false, 29, 1, 22, 1,  0, 0}, // #1030
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1031
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1032
  {DBGFIELD("CLAC_STAC")          1, false, false,  1, 1,  2, 1,  0, 0}, // #1033
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1034
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1035
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 16382, false, false,  0, 0,  0, 0,  0, 0}, // #1036
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 1988, 4, 22, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1038
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1039
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1040
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1041
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1043
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, 2048, 8,  3, 1,  0, 0}, // #1044
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #1045
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1046
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1048
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1049
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false,  1, 1,  2, 1,  0, 0}, // #1051
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1052
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1053
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1054
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 3, false, false, 2012, 2,  8, 1,  0, 0}, // #1055
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 6, false, false, 2245, 2, 22, 1,  0, 0}, // #1056
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 3, false, false, 2157, 2,  8, 1,  0, 0}, // #1060
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1061
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 1, false, false, 1968, 5,  1, 1,  0, 0}, // #1063
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false,  1, 1,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VPSADBWZrr")         16383, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1067
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 1988, 4,  8, 1,  0, 0}, // #1072
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, 2239, 4,  8, 1,  0, 0}, // #1073
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 1988, 4,  8, 1,  0, 0}, // #1075
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1077
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 3, false, false, 2267, 4,  4, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, 2258, 3, 22, 1,  0, 0}, // #1086
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1088
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1090
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1096
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1097
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1098
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1099
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, 2035, 3,  8, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, 2035, 3, 22, 1,  0, 0}, // #1103
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 2061, 3,  3, 1,  0, 0}, // #1104
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 2035, 3,  7, 1,  0, 0}, // #1105
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 2035, 3,  7, 1,  0, 0}, // #1106
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 2, false, false, 2061, 3,  3, 1,  0, 0}, // #1107
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 1, false, false, 1968, 5, 23, 1,  0, 0}, // #1109
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 2271, 6,  3, 1,  0, 0}, // #1110
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, 2097, 4,  5, 1,  0, 0}, // #1114
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, 2097, 4,  5, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, 2035, 3,  7, 1,  0, 0}, // #1116
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, 1973, 4,  5, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 3, false, false, 2267, 4,  4, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 3, false, false, 2267, 4,  4, 1,  0, 0}, // #1120
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 2258, 3,  8, 1,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 2258, 3, 22, 1,  0, 0}, // #1123
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VCVTPD2PSZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("VCVTPS2PDZrr")       16383, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, 2097, 4,  5, 1,  0, 0}, // #1130
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, 2012, 4,  3, 1, 10, 1}, // #1131
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #1132
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 2249, 4,  4, 1,  0, 0}, // #1133
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, 1973, 4,  5, 1,  0, 0}, // #1134
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, 1973, 4,  4, 1,  0, 0}, // #1135
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, 2097, 4,  5, 1,  0, 0}, // #1136
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1137
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, 2153, 4,  3, 1, 10, 1}, // #1138
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #1140
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, 2048, 8,  3, 1,  0, 0}, // #1141
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 2, false, false, 2048, 8,  3, 1,  0, 0}, // #1142
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1143
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1144
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1145
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, 138, 2,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #1149
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, 2097, 4,  5, 1,  0, 0}, // #1151
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 6, false, false, 2245, 4, 11, 1, 10, 1}, // #1152
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 2249, 4,  4, 1,  0, 0}, // #1156
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 2249, 4,  4, 1, 10, 1}, // #1157
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, 1973, 4,  5, 1,  0, 0}, // #1159
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 2241, 4,  4, 1,  0, 0}, // #1160
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, 2097, 4,  5, 1,  0, 0}, // #1162
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, 138, 2,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, 138, 2,  1, 1,  0, 0}, // #1170
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1171
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #1172
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, 1988, 6,  3, 1, 10, 1}, // #1173
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1174
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, 2097, 4,  4, 1, 10, 1}, // #1178
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 2239, 6,  3, 1, 10, 1}, // #1181
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #1187
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #1188
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #1189
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #1190
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, 2030, 5, 11, 1,  0, 0}, // #1191
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 1, false, false, 2030, 5,  3, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 2056, 5, 20, 1, 10, 1}, // #1193
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 2253, 5, 11, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 2253, 5, 11, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 2253, 5, 11, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1200
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 2253, 5,  3, 1,  0, 0}, // #1201
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, 2261, 6,  9, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 2253, 5, 11, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, 2056, 5, 20, 1, 10, 1}, // #1208
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #1209
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, 2009, 3,  8, 1,  0, 0}, // #1210
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1211
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, 2038, 10, 20, 1, 10, 1}, // #1214
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, 2038, 10, 20, 1, 10, 1}, // #1215
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, 2097, 4,  4, 1,  0, 0}, // #1223
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, 2004, 5,  3, 1, 10, 1}, // #1224
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1227
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1228
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1229
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, 1962, 2,  1, 1,  0, 0}, // #1230
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1231
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1232
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1233
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1234
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, 673, 2,  5, 1,  0, 0}, // #1236
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1237
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1238
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1239
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1240
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 16383, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("WriteVecALU")        1, false, false, 1962, 2,  1, 1,  0, 0}, // #1244
  {DBGFIELD("JWriteZeroLatency")  1, false, false,  0, 0,  0, 1,  0, 0}, // #1245
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("WriteALU")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1247
  {DBGFIELD("WriteFLogic")        1, false, false, 1973, 2,  1, 1,  0, 0}, // #1248
  {DBGFIELD("WriteVecLogicX")     1, false, false, 1962, 2,  1, 1,  0, 0}, // #1249
  {DBGFIELD("WriteVecALUX")       1, false, false, 1962, 2,  1, 1,  0, 0}, // #1250
  {DBGFIELD("SBWriteResGroup30")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("JWriteZeroIdiomYmm") 2, false, false, 1973, 2,  1, 1,  0, 0}, // #1252
  {DBGFIELD("WriteFShuffle256")   2, false, false, 2241, 2,  1, 1,  0, 0}, // #1253
  {DBGFIELD("WriteVecLogic")      1, false, false, 1962, 2,  1, 1,  0, 0}, // #1254
  {DBGFIELD("WriteFLogicY")       2, false, false, 2241, 2,  1, 1,  0, 0}, // #1255
  {DBGFIELD("JWrite3OpsLEA")      1, false, false, 2372, 4,  8, 1,  0, 0}, // #1256
  {DBGFIELD("WriteLEA")           1, false, false,  1, 1,  1, 1,  0, 0}, // #1257
}; // BtVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SkylakeServerModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 2376, 5,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 485, 8, 11, 1,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 493, 6,  4, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 230, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 230, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 499, 4,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 230, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       2, false, false, 503, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 507, 3,  4, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       2, false, false, 503, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 507, 3,  3, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 230, 2,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 672, 9,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           1, false, false, 499, 4,  1, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 485, 8, 11, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, 493, 6,  4, 1, 10, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 518, 6,  3, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 524, 4,  4, 1, 10, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 952, 4, 23, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 952, 4, 23, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 952, 4, 23, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 952, 4, 23, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 1005, 6,  7, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 21, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     1, false, false, 672, 9, 23, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 1083, 11, 21, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 1094, 9, 11, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, 2381, 14, 34, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     11, false, false, 2395, 12, 30, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, 532, 5,  3, 1, 21, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 482, 3,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 598, 8,  3, 1, 18, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 606, 6,  8, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 598, 8,  3, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 524, 4,  4, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, 532, 5,  3, 1, 21, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 482, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 1142, 5, 11, 1, 21, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 834, 3,  8, 1,  0, 0}, // #44
  {DBGFIELD("WriteBLSLd")         2, false, false, 612, 6,  4, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLS")           1, false, false, 481, 4,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSFLd")         2, false, false, 528, 9, 11, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSF")           1, false, false, 537, 7, 22, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSRLd")         2, false, false, 528, 9, 11, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSR")           1, false, false, 537, 7, 22, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSWAP32")       1, false, false, 481, 4,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP64")       2, false, false, 606, 6,  8, 1,  0, 0}, // #52
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, 493, 6,  4, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, 524, 4,  4, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTest")       1, false, false, 499, 4,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 618, 8,  4, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, 518, 6,  4, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSet")    1, false, false, 499, 4,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 612, 6,  4, 1, 18, 1}, // #59
  {DBGFIELD("WriteBZHI")          1, false, false, 481, 4,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteLoad")          1, false, false, 507, 3,  5, 1,  0, 0}, // #61
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 3, false, false, 2407, 6,  3, 1, 10, 1}, // #62
  {DBGFIELD("WriteCMOV2")         2, false, false, 1130, 4,  8, 1,  0, 0}, // #63
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, 493, 6,  4, 1, 10, 1}, // #64
  {DBGFIELD("WriteCMOV")          1, false, false, 499, 4,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteFCMOV")         1, false, false, 537, 7, 22, 1,  0, 0}, // #66
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 524, 4,  4, 1, 18, 1}, // #67
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #68
  {DBGFIELD("WriteFCmp64X")       1, false, false, 952, 4, 23, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #70
  {DBGFIELD("WriteFCmpX")         1, false, false, 952, 4, 23, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #72
  {DBGFIELD("WriteFCmp64")        1, false, false, 952, 4, 23, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #74
  {DBGFIELD("WriteFCmp")          1, false, false, 952, 4, 23, 1,  0, 0}, // #75
  {DBGFIELD("WriteCMPXCHG")       5, false, false, 636, 4,  5, 1,  0, 0}, // #76
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 682, 11,  3, 1, 10, 1}, // #77
  {DBGFIELD("WriteFCom")          1, false, false, 672, 9,  8, 1,  0, 0}, // #78
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #79
  {DBGFIELD("WriteCRC32")         1, false, false, 537, 7, 22, 1,  0, 0}, // #80
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, 1005, 6,  7, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PD")       1, false, false, 952, 4, 23, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 1005, 6,  7, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 952, 4, 23, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, 1005, 6, 11, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2I")       1, false, false, 952, 4, 22, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, 537, 7, 22, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 1005, 6, 11, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 952, 4, 22, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, 537, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, 2413, 6,  9, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 833, 4,  4, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #97
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, 537, 7, 22, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 528, 9,  7, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 528, 9,  7, 1, 10, 1}, // #100
  {DBGFIELD("WriteCvtI2SD")       1, false, false, 537, 7, 23, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, 528, 9,  7, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, 528, 9,  7, 1, 10, 1}, // #103
  {DBGFIELD("WriteCvtI2SS")       1, false, false, 537, 7, 23, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 528, 9, 11, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #106
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 537, 7, 22, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, 2413, 6,  9, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 833, 4,  4, 1,  0, 0}, // #109
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2419, 12, 36, 1, 19, 2}, // #110
  {DBGFIELD("WriteDiv16")         32, false, false, 2431, 15, 101, 1,  0, 0}, // #111
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2419, 12, 36, 1, 19, 2}, // #112
  {DBGFIELD("WriteDiv32")         32, false, false, 2431, 15, 101, 1,  0, 0}, // #113
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2419, 12, 36, 1, 19, 2}, // #114
  {DBGFIELD("WriteDiv64")         32, false, false, 2431, 15, 101, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 2419, 12, 36, 1, 19, 2}, // #116
  {DBGFIELD("WriteDiv8")          1, false, false, 671, 10, 34, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, 2446, 12, 30, 1, 21, 1}, // #118
  {DBGFIELD("WriteFDiv64X")       1, false, false, 725, 10, 21, 1,  0, 0}, // #119
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, 703, 12, 28, 1, 21, 1}, // #120
  {DBGFIELD("WriteFDivX")         1, false, false, 725, 10,  9, 1,  0, 0}, // #121
  {DBGFIELD("WriteFDivLd")        2, false, false, 2458, 12,  6, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv")          1, false, false, 725, 10,  9, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, 2446, 12, 63, 1, 10, 1}, // #124
  {DBGFIELD("WriteFDiv64")        1, false, false, 725, 10, 21, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, 2458, 12,  6, 1, 10, 1}, // #126
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, 2470, 10, 10, 1, 21, 1}, // #127
  {DBGFIELD("WriteDPPD")          3, false, false, 2480, 8,  7, 1,  0, 0}, // #128
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 2488, 10, 63, 1, 21, 1}, // #129
  {DBGFIELD("WriteDPPS")          4, false, false, 2498, 8, 27, 1,  0, 0}, // #130
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 805, 11,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteVecExtract")    2, false, false, 816, 12, 22, 1,  0, 0}, // #132
  {DBGFIELD("WriteVecALUX")       1, false, false, 952, 4,  1, 1,  0, 0}, // #133
  {DBGFIELD("WriteFComLd")        2, false, false, 682, 11,  3, 1,  0, 0}, // #134
  {DBGFIELD("WriteEMMS")          10, false, false, 2506, 5, 19, 1,  0, 0}, // #135
  {DBGFIELD("WriteFLDC")          2, false, false, 2511, 5,  1, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, 1005, 6,  3, 1, 21, 1}, // #137
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 2516, 10, 20, 1, 21, 1}, // #138
  {DBGFIELD("WriteFHAdd")         3, false, false, 2526, 8,  4, 1,  0, 0}, // #139
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2534, 14, 88, 1, 19, 2}, // #140
  {DBGFIELD("WriteIDiv16")        66, false, false, 2548, 15, 102, 1,  0, 0}, // #141
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2534, 14, 88, 1, 19, 2}, // #142
  {DBGFIELD("WriteIDiv32")        66, false, false, 2548, 15, 102, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2534, 14, 88, 1, 19, 2}, // #144
  {DBGFIELD("WriteIDiv64")        66, false, false, 2548, 15, 102, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, 2534, 14, 88, 1, 19, 2}, // #146
  {DBGFIELD("WriteIDiv8")         1, false, false, 671, 10, 34, 1,  0, 0}, // #147
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 861, 11,  7, 1, 19, 2}, // #148
  {DBGFIELD("WriteIMul16")        4, false, false, 872, 9, 23, 1,  0, 0}, // #149
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, 881, 9, 11, 1, 10, 1}, // #150
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, 881, 9, 11, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 537, 7, 22, 1,  0, 0}, // #152
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 890, 7, 23, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, 897, 11,  7, 1, 19, 2}, // #154
  {DBGFIELD("WriteIMul32")        3, false, false, 908, 9, 23, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #156
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 528, 9, 11, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 537, 7, 22, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 537, 7, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 917, 13,  7, 1, 19, 2}, // #160
  {DBGFIELD("WriteIMul64")        2, false, false, 930, 11, 23, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 10, 1}, // #162
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 528, 9, 11, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 537, 7, 22, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 537, 7, 22, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 528, 9, 11, 1, 19, 2}, // #166
  {DBGFIELD("WriteIMul8")         1, false, false, 537, 7, 22, 1,  0, 0}, // #167
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #168
  {DBGFIELD("WriteFShuffle")      1, false, false, 510, 8,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteStore")         1, false, false, 503, 4,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteVecLogicX")     1, false, false, 482, 3,  1, 1,  0, 0}, // #171
  {DBGFIELD("WriteShuffle")       1, false, false, 510, 8,  1, 1,  0, 0}, // #172
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 499, 4,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLoadX")      1, false, false, 507, 3,  4, 1,  0, 0}, // #174
  {DBGFIELD("WriteLDMXCSR")       3, false, false, 941, 11,  3, 1,  0, 0}, // #175
  {DBGFIELD("WriteFLD0")          1, false, false, 2376, 5,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteFLD1")          2, false, false, 2511, 5,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteLEA")           1, false, false, 481, 4,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteFence")         1, false, false, 956, 5,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 528, 9, 11, 1,  0, 0}, // #180
  {DBGFIELD("WriteLZCNT")         1, false, false, 537, 7, 22, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecStoreX")     2, false, false, 503, 4,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecStore")      2, false, false, 503, 4,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 672, 9,  8, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoad")       1, false, false, 507, 3,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveX")      1, false, false, 482, 3,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreNT")    2, false, false, 503, 4,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMove")       1, false, false, 2376, 5,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecALULd")      2, false, false, 2563, 7,  4, 1,  0, 0}, // #190
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #191
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, 2563, 7,  4, 1, 10, 1}, // #192
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, 2563, 7,  4, 1, 10, 1}, // #193
  {DBGFIELD("WriteVecLogic")      1, false, false, 2376, 5,  1, 1,  0, 0}, // #194
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 2570, 10, 11, 1, 10, 1}, // #195
  {DBGFIELD("WritePHAdd")         3, false, false, 2580, 8, 22, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #197
  {DBGFIELD("WriteVecInsert")     2, false, false, 564, 8,  8, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, 682, 11,  7, 1, 10, 1}, // #199
  {DBGFIELD("WriteVecIMul")       1, false, false, 672, 9, 23, 1,  0, 0}, // #200
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 672, 9,  8, 1,  0, 0}, // #201
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 544, 10, 11, 1, 10, 1}, // #202
  {DBGFIELD("WritePSADBW")        1, false, false, 510, 8, 22, 1,  0, 0}, // #203
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, 544, 10,  4, 1, 10, 1}, // #204
  {DBGFIELD("WriteVarShuffle")    1, false, false, 510, 8,  1, 1,  0, 0}, // #205
  {DBGFIELD("WriteShuffleLd")     2, false, false, 544, 10,  4, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 672, 9,  1, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, 682, 11,  4, 1, 10, 1}, // #208
  {DBGFIELD("WriteVecShift")      1, false, false, 672, 9,  1, 1,  0, 0}, // #209
  {DBGFIELD("WriteFMoveX")        1, false, false, 482, 3,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 544, 10,  3, 1,  0, 0}, // #211
  {DBGFIELD("WriteFStore")        2, false, false, 503, 4,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 672, 9,  8, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 507, 3,  4, 1,  0, 0}, // #214
  {DBGFIELD("WriteStoreNT")       2, false, false, 503, 4,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFStoreNTX")     2, false, false, 503, 4,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFStoreNT")      2, false, false, 503, 4,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFLoad")         1, false, false, 507, 3,  5, 1,  0, 0}, // #218
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, 554, 10, 19, 1, 21, 1}, // #219
  {DBGFIELD("WriteMPSAD")         2, false, false, 564, 8, 23, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #221
  {DBGFIELD("WriteFMul64X")       1, false, false, 952, 4, 23, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #223
  {DBGFIELD("WriteFMulX")         1, false, false, 952, 4, 23, 1,  0, 0}, // #224
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #225
  {DBGFIELD("WriteFMul64")        1, false, false, 952, 4, 23, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #227
  {DBGFIELD("WriteFMul")          1, false, false, 952, 4, 23, 1,  0, 0}, // #228
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 5, false, false, 897, 11, 73, 2,  0, 0}, // #229
  {DBGFIELD("WriteIMul32_WriteIMulH") 4, false, false, 908, 9, 75, 2,  0, 0}, // #230
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 4, false, false, 917, 13, 73, 2,  0, 0}, // #231
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 930, 11, 75, 2,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd")        2, false, false, 1005, 6,  7, 1,  0, 0}, // #233
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 1005, 6,  3, 1,  0, 0}, // #234
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #235
  {DBGFIELD("WriteShuffleX")      1, false, false, 510, 8,  1, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, 532, 5,  3, 1, 21, 1}, // #237
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 1142, 5, 11, 1, 21, 1}, // #238
  {DBGFIELD("WriteVarBlend")      2, false, false, 834, 3,  8, 1,  0, 0}, // #239
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #240
  {DBGFIELD("WriteBlend")         1, false, false, 510, 8,  1, 1,  0, 0}, // #241
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, 544, 10, 20, 1, 21, 1}, // #242
  {DBGFIELD("WriteCLMul")         1, false, false, 510, 8,  4, 1,  0, 0}, // #243
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, 1011, 14, 77, 1, 21, 1}, // #244
  {DBGFIELD("WritePCmpEStrI")     8, false, false, 1025, 12, 29, 1,  0, 0}, // #245
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, 1037, 14, 34, 1, 21, 1}, // #246
  {DBGFIELD("WritePCmpEStrM")     9, false, false, 1051, 12, 63, 1,  0, 0}, // #247
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, 1063, 11,  6, 1, 21, 1}, // #248
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 1074, 9, 19, 1,  0, 0}, // #249
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, 1063, 11,  6, 1, 21, 1}, // #250
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 1074, 9, 19, 1,  0, 0}, // #251
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, 1005, 6, 11, 1, 21, 1}, // #252
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, 2516, 10,  7, 1, 21, 1}, // #253
  {DBGFIELD("WritePHAddX")        3, false, false, 2526, 8, 22, 1,  0, 0}, // #254
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 682, 11, 19, 1,  0, 0}, // #255
  {DBGFIELD("WritePHMINPOS")      1, false, false, 672, 9, 23, 1,  0, 0}, // #256
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, 1005, 6,  7, 1, 21, 1}, // #257
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #258
  {DBGFIELD("WriteVecIMulX")      1, false, false, 952, 4, 23, 1,  0, 0}, // #259
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, 672, 9,  8, 1,  0, 0}, // #260
  {DBGFIELD("WriteShuffleXLd")    2, false, false, 544, 10,  3, 1,  0, 0}, // #261
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, 2413, 6,  6, 1, 21, 1}, // #262
  {DBGFIELD("WritePMULLD")        2, false, false, 833, 4, 19, 1,  0, 0}, // #263
  {DBGFIELD("WriteCopy")          2, false, false, 1103, 5,  4, 1,  0, 0}, // #264
  {DBGFIELD("WritePOPCNTLd")      2, false, false, 528, 9, 11, 1,  0, 0}, // #265
  {DBGFIELD("WritePOPCNT")        1, false, false, 537, 7, 22, 1,  0, 0}, // #266
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  7, 1, 21, 1}, // #267
  {DBGFIELD("WritePSADBWX")       1, false, false, 510, 8, 22, 1,  0, 0}, // #268
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #269
  {DBGFIELD("WriteVarShuffleX")   1, false, false, 510, 8,  1, 1,  0, 0}, // #270
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, 952, 4,  1, 1,  0, 0}, // #271
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, 1005, 6,  3, 1, 21, 1}, // #272
  {DBGFIELD("WriteVecShiftX")     2, false, false, 2588, 9,  8, 1,  0, 0}, // #273
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, 1108, 14,  7, 1, 21, 1}, // #274
  {DBGFIELD("WriteVecTest")       2, false, false, 816, 12, 22, 1,  0, 0}, // #275
  {DBGFIELD("WriteRotateLd_WriteRMW") 4, false, false, 1122, 8, 78, 2,  0, 0}, // #276
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, 2597, 8, 80, 2,  0, 0}, // #277
  {DBGFIELD("WriteRotate")        2, false, false, 1130, 4,  8, 1,  0, 0}, // #278
  {DBGFIELD("WriteRotateCL")      3, false, false, 2605, 4, 22, 1,  0, 0}, // #279
  {DBGFIELD("WriteFRcpXLd")       2, false, false, 682, 11, 19, 1,  0, 0}, // #280
  {DBGFIELD("WriteFRcpX")         1, false, false, 672, 9, 23, 1,  0, 0}, // #281
  {DBGFIELD("WriteFRcpLd")        2, false, false, 682, 11,  7, 1,  0, 0}, // #282
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, 682, 11,  7, 1, 10, 1}, // #283
  {DBGFIELD("WriteFRcp")          1, false, false, 672, 9, 23, 1,  0, 0}, // #284
  {DBGFIELD("WriteRMW")           1, false, false, 503, 4,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteShiftLd")       2, false, false, 493, 6,  4, 1,  0, 0}, // #286
  {DBGFIELD("WriteShift")         1, false, false, 499, 4,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteFRndLd")        3, false, false, 2413, 6, 21, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRnd")          2, false, false, 833, 4, 11, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, 2413, 6, 21, 1, 21, 1}, // #290
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, 682, 11, 19, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRsqrtX")       1, false, false, 672, 9, 23, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, 682, 11,  7, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, 682, 11,  7, 1, 10, 1}, // #294
  {DBGFIELD("WriteFRsqrt")        1, false, false, 672, 9, 23, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, 618, 8, 82, 2,  0, 0}, // #296
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, 2597, 8, 80, 2,  0, 0}, // #297
  {DBGFIELD("WriteShiftCL")       3, false, false, 2605, 4, 22, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 493, 6,  4, 1, 18, 1}, // #299
  {DBGFIELD("WriteSETCCStore")    3, false, false, 1147, 7,  8, 1,  0, 0}, // #300
  {DBGFIELD("WriteSETCC")         1, false, false, 499, 4,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteSHDmrcl")       6, false, false, 2609, 11,  9, 1,  0, 0}, // #302
  {DBGFIELD("WriteSHDmri")        4, false, false, 1165, 9,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteSHDrrcl")       4, false, false, 2620, 9,  4, 1,  0, 0}, // #304
  {DBGFIELD("WriteSHDrri")        1, false, false, 537, 7, 22, 1,  0, 0}, // #305
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, 2629, 12, 77, 1,  0, 0}, // #306
  {DBGFIELD("WriteFSqrt64X")      1, false, false, 2641, 10, 29, 1,  0, 0}, // #307
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, 2458, 12, 29, 1,  0, 0}, // #308
  {DBGFIELD("WriteFSqrtX")        1, false, false, 725, 10, 20, 1,  0, 0}, // #309
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, 2629, 12, 33, 1,  0, 0}, // #310
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, 2629, 12, 33, 1, 10, 1}, // #311
  {DBGFIELD("WriteFSqrt64")       1, false, false, 2641, 10, 29, 1,  0, 0}, // #312
  {DBGFIELD("WriteFSqrtLd")       2, false, false, 2458, 12, 28, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, 2458, 12, 28, 1, 10, 1}, // #314
  {DBGFIELD("WriteFSqrt")         1, false, false, 725, 10, 20, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt80")       1, false, false, 1208, 10, 31, 1,  0, 0}, // #316
  {DBGFIELD("WriteSTMXCSR")       3, false, false, 805, 11,  8, 1,  0, 0}, // #317
  {DBGFIELD("WriteTZCNTLd")       2, false, false, 528, 9, 11, 1,  0, 0}, // #318
  {DBGFIELD("WriteTZCNT")         1, false, false, 537, 7, 22, 1,  0, 0}, // #319
  {DBGFIELD("WriteFMAZLd")        2, false, false, 2563, 7,  9, 1,  0, 0}, // #320
  {DBGFIELD("WriteFMALd")         2, false, false, 1005, 6,  7, 1,  0, 0}, // #321
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #322
  {DBGFIELD("WriteFAdd64Y")       1, false, false, 952, 4, 23, 1,  0, 0}, // #323
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #324
  {DBGFIELD("WriteFAdd64Z")       1, false, false, 2376, 5, 23, 1,  0, 0}, // #325
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #326
  {DBGFIELD("WriteFAddY")         1, false, false, 952, 4, 23, 1,  0, 0}, // #327
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #328
  {DBGFIELD("WriteFAddZ")         1, false, false, 2376, 5, 23, 1,  0, 0}, // #329
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #330
  {DBGFIELD("WriteShuffleY")      1, false, false, 510, 8,  1, 1,  0, 0}, // #331
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #332
  {DBGFIELD("WriteShuffleZ")      1, false, false, 510, 8,  1, 1,  0, 0}, // #333
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, 532, 5, 11, 1, 26, 1}, // #334
  {DBGFIELD("WriteFLogicY")       1, false, false, 482, 3,  1, 1,  0, 0}, // #335
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 2, false, false, 2563, 7, 11, 1, 26, 1}, // #336
  {DBGFIELD("WriteFLogicZ")       1, false, false, 2376, 5,  1, 1,  0, 0}, // #337
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, 1142, 5,  7, 1, 26, 1}, // #338
  {DBGFIELD("WriteFVarBlendY")    2, false, false, 834, 3,  8, 1,  0, 0}, // #339
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 3, false, false, 1142, 5,  7, 1, 26, 1}, // #340
  {DBGFIELD("WriteFVarBlendZ")    2, false, false, 834, 3,  8, 1,  0, 0}, // #341
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, 532, 5, 11, 1, 26, 1}, // #342
  {DBGFIELD("WriteFBlendY")       1, false, false, 482, 3,  1, 1,  0, 0}, // #343
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 1142, 5,  7, 1, 27, 2}, // #344
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 1142, 5, 11, 1, 22, 2}, // #345
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, 544, 10, 19, 1,  0, 0}, // #346
  {DBGFIELD("WriteShuffle256")    1, false, false, 510, 8, 22, 1,  0, 0}, // #347
  {DBGFIELD("WriteShuffleYLd")    2, false, false, 544, 10, 11, 1,  0, 0}, // #348
  {DBGFIELD("WriteFShuffle256")   1, false, false, 510, 8, 22, 1,  0, 0}, // #349
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, 544, 10, 19, 1,  0, 0}, // #350
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #351
  {DBGFIELD("WriteFCmp64Y")       1, false, false, 952, 4, 23, 1,  0, 0}, // #352
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #353
  {DBGFIELD("WriteFCmpY")         1, false, false, 952, 4, 23, 1,  0, 0}, // #354
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #355
  {DBGFIELD("WriteFCmpZ")         1, false, false, 2376, 5, 23, 1,  0, 0}, // #356
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, 544, 10, 19, 1,  0, 0}, // #357
  {DBGFIELD("WriteVarShuffle256") 1, false, false, 510, 8, 22, 1,  0, 0}, // #358
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, 1005, 6,  7, 1,  0, 0}, // #359
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, 952, 4, 23, 1,  0, 0}, // #360
  {DBGFIELD("WriteCvtI2PDZLd")    2, false, false, 2563, 7,  7, 1,  0, 0}, // #361
  {DBGFIELD("WriteCvtI2PDZ")      1, false, false, 2376, 5, 23, 1,  0, 0}, // #362
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, 1005, 6,  7, 1,  0, 0}, // #363
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, 952, 4, 23, 1,  0, 0}, // #364
  {DBGFIELD("WriteCvtI2PSZLd")    2, false, false, 2563, 7,  7, 1,  0, 0}, // #365
  {DBGFIELD("WriteCvtI2PSZ")      1, false, false, 2376, 5, 23, 1,  0, 0}, // #366
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, 1005, 6, 11, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, 952, 4, 22, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtPD2IZLd")    2, false, false, 2563, 7, 11, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtPD2IZ")      1, false, false, 2376, 5, 22, 1,  0, 0}, // #370
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, 2651, 11, 11, 1,  0, 0}, // #371
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, 2588, 9, 22, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtPD2PSZLd")   3, false, false, 2662, 7, 11, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtPD2PSZ")     2, false, false, 2511, 5, 22, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, 1005, 6, 19, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, 2588, 9,  3, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, 1005, 6,  7, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, 2588, 9,  5, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPH2PSZLd")   2, false, false, 2563, 7, 19, 1,  0, 0}, // #379
  {DBGFIELD("WriteCvtPH2PSZ")     2, false, false, 816, 12,  3, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, 1005, 6, 11, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, 952, 4, 22, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPS2IZLd")    2, false, false, 2563, 7, 11, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPS2IZ")      1, false, false, 2376, 5, 22, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPS2PDYLd")   3, false, false, 2651, 11, 11, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, 2588, 9, 22, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2PDZLd")   3, false, false, 2662, 7, 11, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2PDZ")     2, false, false, 2511, 5, 22, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, 2669, 12, 11, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, 2588, 9,  3, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PHSt")    4, false, false, 2669, 12,  4, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, 2588, 9,  5, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PHZSt")   4, false, false, 2681, 11, 11, 1,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PHZ")     2, false, false, 2692, 8,  3, 1,  0, 0}, // #394
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, 2413, 6,  9, 1, 10, 1}, // #395
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, 2413, 6,  9, 1, 10, 1}, // #396
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 19, 1, 26, 1}, // #397
  {DBGFIELD("WritePSADBWY")       1, false, false, 510, 8, 22, 1,  0, 0}, // #398
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 2, false, false, 544, 10, 19, 1, 26, 1}, // #399
  {DBGFIELD("WritePSADBWZ")       1, false, false, 510, 8, 22, 1,  0, 0}, // #400
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, 681, 12, 31, 1, 26, 1}, // #401
  {DBGFIELD("WriteFDiv64Y")       1, false, false, 715, 10, 21, 1,  0, 0}, // #402
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 4, false, false, 2700, 15, 37, 1, 26, 1}, // #403
  {DBGFIELD("WriteFDiv64Z")       3, false, false, 2715, 13, 33, 1,  0, 0}, // #404
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, 703, 12, 29, 1, 26, 1}, // #405
  {DBGFIELD("WriteFDivY")         1, false, false, 715, 10,  9, 1,  0, 0}, // #406
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 4, false, false, 2728, 15, 34, 1, 26, 1}, // #407
  {DBGFIELD("WriteFDivZ")         3, false, false, 2743, 13, 29, 1,  0, 0}, // #408
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, 2488, 10, 30, 1, 26, 1}, // #409
  {DBGFIELD("WriteDPPSY")         4, false, false, 2498, 8, 27, 1,  0, 0}, // #410
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10, 19, 1, 26, 1}, // #411
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 29, 2}, // #412
  {DBGFIELD("WriteFMAY")          1, false, false, 952, 4, 23, 1,  0, 0}, // #413
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #414
  {DBGFIELD("WriteFMAX")          1, false, false, 952, 4, 23, 1,  0, 0}, // #415
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #416
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #417
  {DBGFIELD("WriteFMAZ")          1, false, false, 2376, 5, 23, 1,  0, 0}, // #418
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 24, 2}, // #419
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 10, 1}, // #420
  {DBGFIELD("WriteFMA")           1, false, false, 952, 4, 23, 1,  0, 0}, // #421
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 16, 2}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 27, 2}, // #423
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 1005, 6, 19, 1, 22, 2}, // #424
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, 1005, 6,  7, 1, 14, 2}, // #425
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, 2413, 6, 10, 1, 26, 1}, // #426
  {DBGFIELD("WriteFRndY")         2, false, false, 833, 4, 11, 1,  0, 0}, // #427
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 3, false, false, 2662, 7, 10, 1, 26, 1}, // #428
  {DBGFIELD("WriteFRndZ")         2, false, false, 2511, 5, 11, 1,  0, 0}, // #429
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #430
  {DBGFIELD("WriteVecIMulY")      1, false, false, 952, 4, 23, 1,  0, 0}, // #431
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #432
  {DBGFIELD("WriteVecIMulZ")      1, false, false, 2376, 5, 23, 1,  0, 0}, // #433
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, 1005, 6, 11, 1, 26, 1}, // #434
  {DBGFIELD("WriteVecALUY")       1, false, false, 952, 4,  1, 1,  0, 0}, // #435
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 2, false, false, 682, 11, 11, 1, 26, 1}, // #436
  {DBGFIELD("WriteVecALUZ")       1, false, false, 672, 9,  1, 1,  0, 0}, // #437
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, 2516, 10, 27, 1, 26, 1}, // #438
  {DBGFIELD("WriteFHAddY")        3, false, false, 2526, 8,  4, 1,  0, 0}, // #439
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10, 19, 1, 26, 1}, // #440
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10, 19, 1, 26, 1}, // #441
  {DBGFIELD("WriteVecLoadY")      1, false, false, 507, 3,  3, 1,  0, 0}, // #442
  {DBGFIELD("WriteFMaskedStoreY") 2, false, false, 2756, 10,  8, 1,  0, 0}, // #443
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, 532, 5, 11, 1,  0, 0}, // #444
  {DBGFIELD("WriteFMaskedStore")  2, false, false, 2756, 10,  8, 1,  0, 0}, // #445
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, 532, 5,  3, 1,  0, 0}, // #446
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #447
  {DBGFIELD("WriteFCmp64Z")       1, false, false, 2376, 5, 23, 1,  0, 0}, // #448
  {DBGFIELD("WriteFMoveY")        1, false, false, 482, 3,  1, 1,  0, 0}, // #449
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, 544, 10, 11, 1,  0, 0}, // #450
  {DBGFIELD("WriteFShuffleY")     1, false, false, 510, 8,  1, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffleZLd")   2, false, false, 544, 10, 11, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffleZ")     1, false, false, 510, 8,  1, 1,  0, 0}, // #453
  {DBGFIELD("WriteVecStoreY")     2, false, false, 503, 4,  1, 1,  0, 0}, // #454
  {DBGFIELD("WriteVecMoveY")      1, false, false, 482, 3,  1, 1,  0, 0}, // #455
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, 507, 3,  3, 1,  0, 0}, // #456
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, 503, 4,  1, 1,  0, 0}, // #457
  {DBGFIELD("WriteFStoreNTY")     2, false, false, 503, 4,  1, 1,  0, 0}, // #458
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, 554, 10,  9, 1, 26, 1}, // #459
  {DBGFIELD("WriteMPSADY")        2, false, false, 564, 8, 23, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #461
  {DBGFIELD("WriteFMul64Y")       1, false, false, 952, 4, 23, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #463
  {DBGFIELD("WriteFMul64Z")       1, false, false, 2376, 5, 23, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, 1005, 6,  9, 1, 26, 1}, // #465
  {DBGFIELD("WriteFMulY")         1, false, false, 952, 4, 23, 1,  0, 0}, // #466
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 2, false, false, 2563, 7,  9, 1, 26, 1}, // #467
  {DBGFIELD("WriteFMulZ")         1, false, false, 2376, 5, 23, 1,  0, 0}, // #468
  {DBGFIELD("WriteVecALUYLd")     2, false, false, 1005, 6, 11, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecALUZLd")     2, false, false, 682, 11, 11, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, 532, 5, 11, 1, 26, 1}, // #471
  {DBGFIELD("WriteVecLogicY")     1, false, false, 482, 3,  1, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 2, false, false, 2563, 7, 11, 1, 26, 1}, // #473
  {DBGFIELD("WriteVecLogicZ")     1, false, false, 2376, 5,  1, 1,  0, 0}, // #474
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #475
  {DBGFIELD("WriteBlendY")        1, false, false, 510, 8,  1, 1,  0, 0}, // #476
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, 1142, 5, 11, 1, 26, 1}, // #477
  {DBGFIELD("WriteVarBlendY")     2, false, false, 834, 3,  8, 1,  0, 0}, // #478
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 2, false, false, 2563, 7, 11, 1, 26, 1}, // #479
  {DBGFIELD("WriteVarBlendZ")     1, false, false, 2376, 5,  8, 1,  0, 0}, // #480
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, 1142, 5, 11, 1, 27, 2}, // #481
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, 1142, 5, 11, 1, 22, 2}, // #482
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 27, 2}, // #483
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 29, 2}, // #484
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 22, 2}, // #485
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 24, 2}, // #486
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, 544, 10, 19, 1, 26, 1}, // #487
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, 510, 8, 22, 1,  0, 0}, // #488
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 27, 2}, // #489
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 29, 2}, // #490
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, 510, 8,  1, 1,  0, 0}, // #491
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 22, 2}, // #492
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 24, 2}, // #493
  {DBGFIELD("WriteFVarShuffle")   1, false, false, 510, 8,  1, 1,  0, 0}, // #494
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #495
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 21, 1}, // #496
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #497
  {DBGFIELD("WriteFVarShuffleZ")  1, false, false, 510, 8,  1, 1,  0, 0}, // #498
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, 2516, 10, 19, 1, 26, 1}, // #499
  {DBGFIELD("WritePHAddY")        3, false, false, 2526, 8, 22, 1,  0, 0}, // #500
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, 1005, 6, 19, 1,  0, 0}, // #501
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, 1005, 6,  9, 1,  0, 0}, // #502
  {DBGFIELD("WriteVecIMulZLd")    2, false, false, 2563, 7,  9, 1,  0, 0}, // #503
  {DBGFIELD("WriteVecMaskedStoreY") 2, false, false, 2756, 10,  8, 1,  0, 0}, // #504
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, 532, 5, 11, 1,  0, 0}, // #505
  {DBGFIELD("WriteVecMaskedStore") 2, false, false, 2756, 10,  8, 1,  0, 0}, // #506
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, 532, 5,  3, 1,  0, 0}, // #507
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, 672, 9,  8, 1,  0, 0}, // #508
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, 2413, 6, 28, 1, 26, 1}, // #509
  {DBGFIELD("WritePMULLDY")       2, false, false, 833, 4, 19, 1,  0, 0}, // #510
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 3, false, false, 2662, 7, 28, 1, 26, 1}, // #511
  {DBGFIELD("WritePMULLDZ")       2, false, false, 2511, 5, 19, 1,  0, 0}, // #512
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 22, 2}, // #513
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, 544, 10,  3, 1, 24, 2}, // #514
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, 1005, 6,  3, 1,  0, 0}, // #515
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, 1005, 6, 11, 1,  0, 0}, // #516
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, 952, 4,  1, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecShiftImmZLd") 2, false, false, 682, 11, 11, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecShiftImmZ")  1, false, false, 672, 9,  1, 1,  0, 0}, // #519
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, 1005, 6,  3, 1, 21, 1}, // #520
  {DBGFIELD("WriteVarVecShift")   1, false, false, 952, 4,  1, 1,  0, 0}, // #521
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, 1005, 6, 11, 1, 26, 1}, // #522
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, 952, 4,  1, 1,  0, 0}, // #523
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 2, false, false, 682, 11, 11, 1, 26, 1}, // #524
  {DBGFIELD("WriteVarVecShiftZ")  1, false, false, 672, 9,  1, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, 1005, 6,  3, 1, 21, 1}, // #526
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #527
  {DBGFIELD("WriteVarShuffleY")   1, false, false, 510, 8,  1, 1,  0, 0}, // #528
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #529
  {DBGFIELD("WriteVarShuffleZ")   1, false, false, 510, 8,  1, 1,  0, 0}, // #530
  {DBGFIELD("WriteShuffleZLd")    2, false, false, 544, 10, 11, 1,  0, 0}, // #531
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, 1005, 6, 11, 1, 26, 1}, // #532
  {DBGFIELD("WriteVecShiftY")     2, false, false, 2588, 9, 23, 1,  0, 0}, // #533
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 2, false, false, 682, 11, 11, 1, 26, 1}, // #534
  {DBGFIELD("WriteVecShiftZ")     2, false, false, 816, 12, 23, 1,  0, 0}, // #535
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, 1108, 14, 19, 1, 26, 1}, // #536
  {DBGFIELD("WriteVecTestY")      2, false, false, 816, 12, 22, 1,  0, 0}, // #537
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 21, 1}, // #538
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  9, 1, 26, 1}, // #539
  {DBGFIELD("WriteFRcpY")         1, false, false, 672, 9, 23, 1,  0, 0}, // #540
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 4, false, false, 1294, 14,  9, 1, 26, 1}, // #541
  {DBGFIELD("WriteFRcpZ")         3, false, false, 1308, 12, 23, 1,  0, 0}, // #542
  {DBGFIELD("WriteFRcpYLd")       2, false, false, 682, 11,  9, 1,  0, 0}, // #543
  {DBGFIELD("WriteFRndYLd")       3, false, false, 2413, 6, 10, 1,  0, 0}, // #544
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, 682, 11, 19, 1, 21, 1}, // #545
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  9, 1, 26, 1}, // #546
  {DBGFIELD("WriteFRsqrtY")       1, false, false, 672, 9, 23, 1,  0, 0}, // #547
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 4, false, false, 1294, 14,  6, 1, 26, 1}, // #548
  {DBGFIELD("WriteFRsqrtZ")       3, false, false, 1308, 12,  7, 1,  0, 0}, // #549
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, 682, 11,  9, 1,  0, 0}, // #550
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #551
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 2, false, false, 544, 10, 11, 1, 26, 1}, // #552
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, 2766, 12, 34, 1,  0, 0}, // #553
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, 2778, 10, 29, 1,  0, 0}, // #554
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, 2629, 12, 77, 1, 21, 1}, // #555
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, 2766, 12, 34, 1, 26, 1}, // #556
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 4, false, false, 2788, 15, 103, 1, 26, 1}, // #557
  {DBGFIELD("WriteFSqrt64Z")      3, false, false, 2803, 13, 38, 1,  0, 0}, // #558
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, 2629, 12, 63, 1,  0, 0}, // #559
  {DBGFIELD("WriteFSqrtY")        1, false, false, 2641, 10, 20, 1,  0, 0}, // #560
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, 2458, 12, 29, 1, 21, 1}, // #561
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, 2629, 12, 63, 1, 26, 1}, // #562
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 4, false, false, 2816, 15, 66, 1, 26, 1}, // #563
  {DBGFIELD("WriteFSqrtZ")        3, false, false, 2831, 13, 30, 1,  0, 0}, // #564
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, 682, 11,  7, 1, 26, 1}, // #565
  {DBGFIELD("WriteFTestY")        1, false, false, 672, 9,  8, 1,  0, 0}, // #566
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, 682, 11, 11, 1, 21, 1}, // #567
  {DBGFIELD("WriteFTest")         1, false, false, 672, 9,  8, 1,  0, 0}, // #568
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, 518, 6, 82, 2,  0, 0}, // #569
  {DBGFIELD("WriteXCHG")          3, false, false, 773, 2,  8, 1,  0, 0}, // #570
  {DBGFIELD("COPY")               0, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("FXAM")               1, false, false, 230, 2,  2, 1,  0, 0}, // #572
  {DBGFIELD("LD_Frr")             1, false, false, 230, 2,  1, 1,  0, 0}, // #573
  {DBGFIELD("MOVSX64rr32")        1, false, false, 230, 2,  1, 1,  0, 0}, // #574
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1364, 6, 11, 1,  0, 0}, // #575
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, 2844, 11, 29, 1,  0, 0}, // #576
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, 618, 8,  4, 1,  0, 0}, // #577
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, 2597, 8, 11, 1,  0, 0}, // #578
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, 230, 2,  1, 1,  0, 0}, // #579
  {DBGFIELD("FCOMPP")             1, false, false, 230, 2,  2, 1,  0, 0}, // #580
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, 672, 9,  8, 1,  0, 0}, // #581
  {DBGFIELD("MMX_CVTPI2PSirr")    2, false, false, 564, 8,  4, 1,  0, 0}, // #582
  {DBGFIELD("MMX_CVTPI2PSirm")    2, false, false, 682, 11,  7, 1,  0, 0}, // #583
  {DBGFIELD("MMX_CVTPS2PIirr_MMX_CVTTPS2PIirr") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #584
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, 524, 4,  4, 1,  0, 0}, // #585
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, 503, 4,  1, 1,  0, 0}, // #586
  {DBGFIELD("XCH_F")              15, false, false, 2863, 15, 28, 1,  0, 0}, // #587
  {DBGFIELD("RETIL_RETIQ_RETIW_IRET_IRET16_IRET32_IRET64") 2, false, false, 493, 6,  4, 1,  0, 0}, // #588
  {DBGFIELD("MMX_CVTPS2PIirm_MMX_CVTTPS2PIirm") 2, false, false, 532, 5,  7, 1,  0, 0}, // #589
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, 544, 10, 19, 1,  0, 0}, // #590
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, 570, 2,  8, 1,  0, 0}, // #591
  {DBGFIELD("LFENCE")             2, false, false, 570, 2,  8, 1,  0, 0}, // #592
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, 510, 8,  1, 1,  0, 0}, // #593
  {DBGFIELD("PSLLDQri_PSRLDQri")  1, false, false, 510, 8,  1, 1,  0, 0}, // #594
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr_MMX_PUNPCKHBWirr_MMX_PUNPCKHDQirr_MMX_PUNPCKHWDirr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #595
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, 1395, 4,  3, 1,  0, 0}, // #596
  {DBGFIELD("POP16r")             2, false, false, 524, 4,  4, 1,  0, 0}, // #597
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, 518, 6,  4, 1,  0, 0}, // #598
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, 230, 2,  2, 1,  0, 0}, // #599
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, 230, 2,  2, 1,  0, 0}, // #600
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, 503, 4,  1, 1,  0, 0}, // #601
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, 230, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("MMX_PADDQirr_MMX_PSUBQirr") 1, false, false, 2376, 5,  1, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, 230, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, 503, 4,  1, 1,  0, 0}, // #605
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, 503, 4,  1, 1,  0, 0}, // #606
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, 482, 3,  1, 1,  0, 0}, // #607
  {DBGFIELD("CLD")                3, false, false, 1399, 7, 22, 1,  0, 0}, // #608
  {DBGFIELD("LDDQUrm")            1, false, false, 507, 3,  4, 1,  0, 0}, // #609
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, 230, 2,  2, 1,  0, 0}, // #610
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, 518, 6,  4, 1,  0, 0}, // #611
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 8, false, false, 2878, 11, 19, 1,  0, 0}, // #612
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, 2526, 8, 22, 1,  0, 0}, // #613
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, 507, 3,  5, 1,  0, 0}, // #614
  {DBGFIELD("MMX_PADDQirm_MMX_PSUBQirm") 2, false, false, 2563, 7,  4, 1, 10, 1}, // #615
  {DBGFIELD("MOVDQUrm")           1, false, false, 507, 3,  4, 1,  0, 0}, // #616
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, 507, 3,  4, 1,  0, 0}, // #617
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, 532, 5,  3, 1, 21, 1}, // #618
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, 230, 2,  1, 1,  0, 0}, // #619
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, 632, 4,  8, 1,  0, 0}, // #620
  {DBGFIELD("LD_F80m")            1, false, false, 507, 3,  3, 1,  0, 0}, // #621
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, 2516, 10,  7, 1, 21, 1}, // #622
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, 816, 12, 22, 1,  0, 0}, // #623
  {DBGFIELD("FLDCW16m")           3, false, false, 2889, 11,  3, 1,  0, 0}, // #624
  {DBGFIELD("ST_FP80m")           2, false, false, 503, 4,  1, 1,  0, 0}, // #625
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, 2580, 8, 22, 1,  0, 0}, // #626
  {DBGFIELD("CMPXCHG8rm")         6, false, false, 485, 8, 11, 1,  0, 0}, // #627
  {DBGFIELD("INTO")               1, false, false, 230, 2,  2, 1,  0, 0}, // #628
  {DBGFIELD("XLAT")               1, false, false, 507, 3,  5, 1,  0, 0}, // #629
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, 2620, 9,  4, 1,  0, 0}, // #630
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, 537, 7, 22, 1,  0, 0}, // #631
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, 2609, 11,  9, 1,  0, 0}, // #632
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, 1165, 9,  7, 1,  0, 0}, // #633
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, 805, 11, 23, 1,  0, 0}, // #634
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, 2570, 10, 11, 1, 10, 1}, // #635
  {DBGFIELD("AAD8i8")             1, false, false, 230, 2,  2, 1,  0, 0}, // #636
  {DBGFIELD("LOOPE")              11, false, false, 1423, 4,  9, 1,  0, 0}, // #637
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, 503, 4,  1, 1,  0, 0}, // #638
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, 2620, 9,  4, 1,  0, 0}, // #639
  {DBGFIELD("FNSTCW16m")          3, false, false, 1427, 10,  8, 1,  0, 0}, // #640
  {DBGFIELD("POPA16_POPA32")      1, false, false, 507, 3,  5, 1,  0, 0}, // #641
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, 503, 4,  1, 1,  0, 0}, // #642
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, 2609, 11,  9, 1,  0, 0}, // #643
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, 1165, 9,  7, 1,  0, 0}, // #644
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, 537, 7, 22, 1,  0, 0}, // #645
  {DBGFIELD("CMPXCHG8rr")         5, false, false, 636, 4,  5, 1,  0, 0}, // #646
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80_COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 672, 9,  8, 1,  0, 0}, // #647
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_CVTTSS2SI64rr_Int") 3, false, false, 2900, 12,  3, 1,  0, 0}, // #648
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int") 2, false, false, 682, 11,  3, 1, 10, 1}, // #649
  {DBGFIELD("CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, 2912, 14, 20, 1,  0, 0}, // #650
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, 230, 2,  2, 1,  0, 0}, // #651
  {DBGFIELD("AAA_AAS")            1, false, false, 230, 2,  2, 1,  0, 0}, // #652
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, 485, 8, 11, 1,  0, 0}, // #653
  {DBGFIELD("LOOPNE")             11, false, false, 1423, 4,  9, 1,  0, 0}, // #654
  {DBGFIELD("PAUSE")              4, false, false, 2926, 7, 55, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8B")          14, false, false, 1456, 10,  6, 1,  0, 0}, // #656
  {DBGFIELD("DAA")                1, false, false, 230, 2,  2, 1,  0, 0}, // #657
  {DBGFIELD("LOOP")               7, false, false, 2933, 9,  3, 1,  0, 0}, // #658
  {DBGFIELD("DAS")                1, false, false, 230, 2,  2, 1,  0, 0}, // #659
  {DBGFIELD("AAM8i8")             1, false, false, 230, 2,  2, 1,  0, 0}, // #660
  {DBGFIELD("STD")                6, false, false, 1475, 7,  4, 1,  0, 0}, // #661
  {DBGFIELD("CMPXCHG16B")         19, false, false, 1482, 15, 33, 1,  0, 0}, // #662
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, 230, 2,  2, 1,  0, 0}, // #663
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, 803, 2, 23, 1,  0, 0}, // #664
  {DBGFIELD("POPF32_POPF64")      1, false, false, 507, 3,  5, 1,  0, 0}, // #665
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, 230, 2,  2, 1,  0, 0}, // #666
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, 1497, 8, 84, 1,  0, 0}, // #667
  {DBGFIELD("ENTER")              1, false, false, 230, 2,  2, 1,  0, 0}, // #668
  {DBGFIELD("POPF16")             1, false, false, 507, 3,  5, 1,  0, 0}, // #669
  {DBGFIELD("MONITORrrr")         1, false, false, 230, 2,  2, 1,  0, 0}, // #670
  {DBGFIELD("FRNDINT")            1, false, false, 230, 2,  2, 1,  0, 0}, // #671
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, 2942, 11, 30, 1,  0, 0}, // #672
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, 230, 2,  2, 1,  0, 0}, // #673
  {DBGFIELD("FPREM")              1, false, false, 230, 2,  2, 1,  0, 0}, // #674
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, 1505, 15, 30, 1,  0, 0}, // #675
  {DBGFIELD("FNINIT")             15, false, false, 2953, 8, 85, 1,  0, 0}, // #676
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, 1529, 13, 72, 1,  0, 0}, // #677
  {DBGFIELD("FPREM1")             1, false, false, 230, 2,  2, 1,  0, 0}, // #678
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, 230, 2,  2, 1,  0, 0}, // #679
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, 1529, 13, 72, 1,  0, 0}, // #680
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, 230, 2,  2, 1,  0, 0}, // #681
  {DBGFIELD("FSCALE")             1, false, false, 230, 2,  2, 1,  0, 0}, // #682
  {DBGFIELD("RDMSR")              1, false, false, 230, 2,  2, 1,  0, 0}, // #683
  {DBGFIELD("RET_RETL_RETQ_RETW_LRETIL_LRETIQ_LRETIW_LRETL_LRETQ_LRETW") 2, false, false, 493, 6,  4, 1,  0, 0}, // #684
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, 1542, 13, 72, 1,  0, 0}, // #685
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, 1542, 13, 72, 1,  0, 0}, // #686
  {DBGFIELD("F2XM1")              1, false, false, 230, 2,  2, 1,  0, 0}, // #687
  {DBGFIELD("CPUID")              8, false, false, 1555, 11, 29, 1,  0, 0}, // #688
  {DBGFIELD("INT")                1, false, false, 230, 2,  2, 1,  0, 0}, // #689
  {DBGFIELD("INT3")               1, false, false, 230, 2,  2, 1,  0, 0}, // #690
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, 230, 2,  2, 1,  0, 0}, // #691
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, 1566, 15, 44, 1,  0, 0}, // #692
  {DBGFIELD("FYL2X")              1, false, false, 230, 2,  2, 1,  0, 0}, // #693
  {DBGFIELD("FYL2XP1")            1, false, false, 230, 2,  2, 1,  0, 0}, // #694
  {DBGFIELD("FPTAN")              1, false, false, 230, 2,  2, 1,  0, 0}, // #695
  {DBGFIELD("FSINCOS")            1, false, false, 230, 2,  2, 1,  0, 0}, // #696
  {DBGFIELD("COS_F_COS_Fp32_COS_Fp64_COS_Fp80_SIN_F_SIN_Fp32_SIN_Fp64_SIN_Fp80") 1, false, false, 230, 2,  2, 1,  0, 0}, // #697
  {DBGFIELD("FPATAN")             1, false, false, 230, 2,  2, 1,  0, 0}, // #698
  {DBGFIELD("WRMSR")              1, false, false, 230, 2,  2, 1,  0, 0}, // #699
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, 510, 8,  1, 1,  0, 0}, // #700
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, 510, 8,  1, 1,  0, 0}, // #701
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, 2511, 5,  8, 1,  0, 0}, // #702
  {DBGFIELD("FNOP")               1, false, false, 2376, 5,  1, 1,  0, 0}, // #703
  {DBGFIELD("RETQ")               3, false, false, 1581, 9,  3, 1,  0, 0}, // #704
  {DBGFIELD("CDQ_CQO")            1, false, false, 499, 4,  1, 1,  0, 0}, // #705
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, 2376, 5,  1, 1,  0, 0}, // #706
  {DBGFIELD("MMX_PADDQirr")       1, false, false, 2376, 5,  1, 1,  0, 0}, // #707
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, 510, 8,  1, 1,  0, 0}, // #708
  {DBGFIELD("SETAr_SETBEr")       2, false, false, 1130, 4,  8, 1,  0, 0}, // #709
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, 1395, 4,  3, 1,  0, 0}, // #710
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int") 1, false, false, 672, 9,  8, 1,  0, 0}, // #711
  {DBGFIELD("VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, 672, 9,  8, 1,  0, 0}, // #712
  {DBGFIELD("CWD")                2, false, false, 632, 4,  8, 1,  0, 0}, // #713
  {DBGFIELD("FNSTSW16r")          2, false, false, 1590, 9, 22, 1,  0, 0}, // #714
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, 2511, 5,  8, 1,  0, 0}, // #715
  {DBGFIELD("PUSHFS64")           1, false, false, 230, 2,  2, 1,  0, 0}, // #716
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, 816, 12, 22, 1,  0, 0}, // #717
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 3, false, false, 1603, 4, 22, 1,  0, 0}, // #718
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, 672, 9,  8, 1,  0, 0}, // #719
  {DBGFIELD("MOV64sr")            1, false, false, 230, 2,  1, 1,  0, 0}, // #720
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, 507, 3,  5, 1,  0, 0}, // #721
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, 2961, 9, 21, 1,  0, 0}, // #722
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, 1603, 4, 22, 1,  0, 0}, // #723
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, 1616, 5,  8, 1,  0, 0}, // #724
  {DBGFIELD("CLI")                1, false, false, 230, 2,  2, 1,  0, 0}, // #725
  {DBGFIELD("PUSHGS64")           1, false, false, 230, 2,  2, 1,  0, 0}, // #726
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, 805, 11, 23, 1,  0, 0}, // #727
  {DBGFIELD("CALL64pcrel32")      4, false, false, 1621, 7, 22, 1,  0, 0}, // #728
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, 1628, 10, 22, 1,  0, 0}, // #729
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, 805, 11,  8, 1,  0, 0}, // #730
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, 1616, 5,  8, 1,  0, 0}, // #731
  {DBGFIELD("SETAm_SETBEm")       4, false, false, 2970, 7, 22, 1,  0, 0}, // #732
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, 805, 11,  8, 1,  0, 0}, // #733
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, 1638, 5,  5, 1,  0, 0}, // #734
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, 1643, 7,  8, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, 503, 4,  1, 1,  0, 0}, // #736
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, 507, 3,  4, 1,  0, 0}, // #737
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #738
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #739
  {DBGFIELD("MOVSDrm_VMOVSDrm_MOVSSrm_VMOVSSrm") 1, false, false, 507, 3,  5, 1,  0, 0}, // #740
  {DBGFIELD("MOV16sm")            1, false, false, 230, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, 2563, 7,  4, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, 544, 10,  4, 1, 10, 1}, // #743
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, 2563, 7,  4, 1, 10, 1}, // #744
  {DBGFIELD("LODSL_LODSQ")        1, false, false, 230, 2,  2, 1,  0, 0}, // #745
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, 507, 3,  3, 1,  0, 0}, // #746
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, 507, 3,  3, 1,  0, 0}, // #747
  {DBGFIELD("VINSERTF128rm")      2, false, false, 532, 5,  3, 1, 21, 1}, // #748
  {DBGFIELD("MMX_PADDQirm")       2, false, false, 2563, 7,  4, 1, 10, 1}, // #749
  {DBGFIELD("VERRm_VERWm")        1, false, false, 230, 2,  2, 1,  0, 0}, // #750
  {DBGFIELD("FARJMP64")           2, false, false, 1650, 9,  4, 1,  0, 0}, // #751
  {DBGFIELD("FNSTSWm")            3, false, false, 1659, 11, 22, 1,  0, 0}, // #752
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, 1670, 11,  4, 1,  0, 0}, // #753
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, 1681, 11,  3, 1,  0, 0}, // #754
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, 1681, 11,  3, 1,  0, 0}, // #755
  {DBGFIELD("VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, 682, 11,  3, 1, 10, 1}, // #756
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, 230, 2,  2, 1,  0, 0}, // #757
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, 1122, 8,  3, 1,  0, 0}, // #758
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, 1692, 6,  3, 1,  0, 0}, // #759
  {DBGFIELD("FARCALL64")          5, false, false, 1681, 11,  3, 1,  0, 0}, // #760
  {DBGFIELD("CVTSD2SI64rm_Int_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, 2413, 6,  9, 1,  0, 0}, // #761
  {DBGFIELD("CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, 2413, 6,  9, 1,  0, 0}, // #762
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, 507, 3,  3, 1,  0, 0}, // #763
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, 2597, 8, 11, 1,  0, 0}, // #764
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, 485, 8, 11, 1,  0, 0}, // #765
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, 544, 10, 19, 1,  0, 0}, // #766
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, 544, 10,  7, 1,  0, 0}, // #767
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, 554, 10,  9, 1,  0, 0}, // #768
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, 682, 11,  9, 1,  0, 0}, // #769
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, 554, 10, 27, 1,  0, 0}, // #770
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, 1108, 14, 21, 1,  0, 0}, // #771
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, 682, 11, 32, 1,  0, 0}, // #772
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, 1108, 14, 34, 1,  0, 0}, // #773
  {DBGFIELD("VZEROALL")           34, false, false, 2977, 12, 20, 1,  0, 0}, // #774
  {DBGFIELD("VZEROUPPER")         4, false, false,  0, 0,  0, 1,  0, 0}, // #775
  {DBGFIELD("CLC")                1, false, false,  0, 0,  1, 1,  0, 0}, // #776
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, 230, 2,  1, 1,  0, 0}, // #777
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #778
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, 482, 3,  1, 1,  0, 0}, // #779
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, 952, 4,  1, 1,  0, 0}, // #780
  {DBGFIELD("PSUBQrr")            1, false, false, 482, 3,  1, 1,  0, 0}, // #781
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, 510, 8, 22, 1,  0, 0}, // #782
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, 544, 10,  4, 1,  0, 0}, // #783
  {DBGFIELD("RETIL_RETIQ_RETIW")  2, false, false, 493, 6,  4, 1,  0, 0}, // #784
  {DBGFIELD("LRETIL_LRETIQ_LRETIW") 2, false, false, 493, 6,  4, 1,  0, 0}, // #785
  {DBGFIELD("RDPMC")              1, false, false, 230, 2,  2, 1,  0, 0}, // #786
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, 230, 2,  2, 1,  0, 0}, // #787
  {DBGFIELD("FBLDm")              1, false, false, 230, 2,  2, 1,  0, 0}, // #788
  {DBGFIELD("FFREE_FFREEP")       1, false, false, 230, 2,  2, 1,  0, 0}, // #789
  {DBGFIELD("FSAVEm")             1, false, false, 230, 2,  2, 1,  0, 0}, // #790
  {DBGFIELD("FRSTORm")            1, false, false, 230, 2,  2, 1,  0, 0}, // #791
  {DBGFIELD("FXTRACT")            1, false, false, 230, 2,  2, 1,  0, 0}, // #792
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, 507, 3,  4, 1,  0, 0}, // #793
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, 507, 3,  4, 1,  0, 0}, // #794
  {DBGFIELD("VBROADCASTF128")     1, false, false, 507, 3,  3, 1,  0, 0}, // #795
  {DBGFIELD("VBROADCASTI128")     1, false, false, 507, 3,  3, 1,  0, 0}, // #796
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, 507, 3,  3, 1,  0, 0}, // #797
  {DBGFIELD("FBSTPm")             2, false, false, 503, 4,  1, 1,  0, 0}, // #798
  {DBGFIELD("VMPTRSTm")           2, false, false, 503, 4,  1, 1,  0, 0}, // #799
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, 503, 4,  1, 1,  0, 0}, // #800
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, 952, 4,  1, 1,  0, 0}, // #801
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, 952, 4,  1, 1,  0, 0}, // #802
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, 564, 8,  8, 1,  0, 0}, // #803
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT") 1, false, false, 1729, 7,  1, 1,  0, 0}, // #804
  {DBGFIELD("FINCSTP")            1, false, false, 2376, 5,  1, 1,  0, 0}, // #805
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, 481, 4,  1, 1,  0, 0}, // #806
  {DBGFIELD("VPBLENDDYrri")       1, false, false, 482, 3,  1, 1,  0, 0}, // #807
  {DBGFIELD("VPBLENDDrri")        1, false, false, 482, 3,  1, 1,  0, 0}, // #808
  {DBGFIELD("CMC_STC")            1, false, false, 230, 2,  1, 1,  0, 0}, // #809
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, 230, 2,  1, 1,  0, 0}, // #810
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, 532, 5,  7, 1,  0, 0}, // #811
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, 1005, 6,  3, 1, 21, 1}, // #812
  {DBGFIELD("CVTSS2SDrm")         2, false, false, 532, 5, 19, 1,  0, 0}, // #813
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, 532, 5, 19, 1,  0, 0}, // #814
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, 1005, 6, 11, 1, 26, 1}, // #815
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, 528, 9, 11, 1,  0, 0}, // #816
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, 544, 10,  4, 1,  0, 0}, // #817
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, 544, 10, 11, 1,  0, 0}, // #818
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, 1650, 9,  4, 1,  0, 0}, // #819
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, 612, 6,  4, 1,  0, 0}, // #820
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, 612, 6,  4, 1,  0, 0}, // #821
  {DBGFIELD("VINSERTI128rm")      2, false, false, 532, 5,  3, 1, 21, 1}, // #822
  {DBGFIELD("VPBLENDDrmi")        2, false, false, 532, 5,  3, 1,  0, 0}, // #823
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, 532, 5, 11, 1,  0, 0}, // #824
  {DBGFIELD("POP32r_POP64r")      2, false, false, 524, 4,  4, 1,  0, 0}, // #825
  {DBGFIELD("SFENCE")             2, false, false, 496, 3,  8, 1,  0, 0}, // #826
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, 1736, 7,  8, 1,  0, 0}, // #827
  {DBGFIELD("MOVBE16mr")          3, false, false, 1736, 7,  8, 1,  0, 0}, // #828
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, 1616, 5,  8, 1,  0, 0}, // #829
  {DBGFIELD("MFENCE")             3, false, false, 561, 3, 22, 1,  0, 0}, // #830
  {DBGFIELD("XGETBV")             2, false, false, 570, 2,  8, 1,  0, 0}, // #831
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #832
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #833
  {DBGFIELD("MMX_PACKSSDWirm_MMX_PACKSSWBirm_MMX_PACKUSWBirm") 3, false, false, 554, 10,  3, 1,  0, 0}, // #834
  {DBGFIELD("LRETQ_RETL")         2, false, false, 493, 6,  4, 1,  0, 0}, // #835
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, 537, 7, 22, 1,  0, 0}, // #836
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, 952, 4, 23, 1,  0, 0}, // #837
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, 952, 4, 23, 1,  0, 0}, // #838
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, 510, 8, 22, 1,  0, 0}, // #839
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, 532, 5, 19, 1,  0, 0}, // #840
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, 532, 5,  9, 1,  0, 0}, // #841
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, 532, 5,  9, 1,  0, 0}, // #842
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, 544, 10,  7, 1,  0, 0}, // #843
  {DBGFIELD("MMX_PACKSSDWirr_MMX_PACKSSWBirr_MMX_PACKUSWBirr") 3, false, false, 1743, 8, 22, 1,  0, 0}, // #844
  {DBGFIELD("CLDEMOTE")           3, false, false, 1399, 7, 22, 1,  0, 0}, // #845
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_CVTTSD2SI64rr_Int_CVTTSD2SIrr_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, 833, 4,  4, 1,  0, 0}, // #846
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 833, 4,  4, 1,  0, 0}, // #847
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, 2855, 8,  3, 1,  0, 0}, // #848
  {DBGFIELD("MMX_CVTPI2PDirr")    1, false, false, 952, 4, 23, 1,  0, 0}, // #849
  {DBGFIELD("MMX_CVTPD2PIirr_MMX_CVTTPD2PIirr") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #850
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 1, false, false, 952, 4, 23, 1,  0, 0}, // #851
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #852
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #853
  {DBGFIELD("CVTSI2SDrr_CVTSI2SDrr_Int_CVTSI642SDrr_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #854
  {DBGFIELD("CVTSI2SSrr_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #855
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #856
  {DBGFIELD("VCVTSD2SI64rm_Int_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, 2413, 6,  9, 1,  0, 0}, // #857
  {DBGFIELD("CVTSS2SI64rm_Int")   3, false, false, 2413, 6,  9, 1,  0, 0}, // #858
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 2413, 6,  9, 1,  0, 0}, // #859
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, 532, 5,  9, 1,  0, 0}, // #860
  {DBGFIELD("CVTPD2PSrm")         3, false, false, 1751, 10,  9, 1,  0, 0}, // #861
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIirm_MMX_CVTTPD2PIirm") 3, false, false, 1751, 10,  9, 1,  0, 0}, // #862
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, 1108, 14,  9, 1,  0, 0}, // #863
  {DBGFIELD("MMX_CVTPI2PDirm")    2, false, false, 1005, 6,  7, 1,  0, 0}, // #864
  {DBGFIELD("CVTSD2SSrm")         3, false, false, 1751, 10, 19, 1,  0, 0}, // #865
  {DBGFIELD("VCVTSD2SSrm")        3, false, false, 1751, 10, 19, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, 544, 10, 11, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 4, false, false, 2989, 11, 23, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, 1774, 13,  7, 1,  0, 0}, // #869
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, 510, 8, 22, 1,  0, 0}, // #870
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, 672, 9, 23, 1,  0, 0}, // #871
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, 544, 10, 19, 1,  0, 0}, // #872
  {DBGFIELD("CVTSI642SSrr_CVTSI642SSrr_Int_VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, 2526, 8,  4, 1,  0, 0}, // #873
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, 1787, 11,  5, 1,  0, 0}, // #874
  {DBGFIELD("XSETBV")             5, false, false, 1798, 4,  5, 1,  0, 0}, // #875
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, 2588, 9,  3, 1,  0, 0}, // #876
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, 2855, 8,  3, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #878
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, 1108, 14, 27, 1,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, 3000, 11, 10, 1,  0, 0}, // #880
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, 3011, 9,  9, 1,  0, 0}, // #881
  {DBGFIELD("RCL8rCL")            9, false, false, 3020, 9,  9, 1,  0, 0}, // #882
  {DBGFIELD("RDTSC")              8, false, false, 1555, 11, 29, 1,  0, 0}, // #883
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, 3029, 13, 104, 1,  0, 0}, // #884
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, 672, 9, 30, 1,  0, 0}, // #885
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, 682, 11, 66, 1,  0, 0}, // #886
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, 1108, 14, 37, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, 672, 9, 10, 1,  0, 0}, // #888
  {DBGFIELD("XSAVE64")            39, false, false, 3042, 11, 90, 1,  0, 0}, // #889
  {DBGFIELD("XSAVE")              40, false, false, 3053, 11, 84, 1,  0, 0}, // #890
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 40, false, false, 3053, 11, 84, 1,  0, 0}, // #891
  {DBGFIELD("VMCLEARm")           18, false, false, 3064, 17, 105, 1,  0, 0}, // #892
  {DBGFIELD("FLDENVm")            64, false, false, 3081, 11, 18, 1,  0, 0}, // #893
  {DBGFIELD("FXRSTOR64")          88, false, false, 1873, 15, 44, 1,  0, 0}, // #894
  {DBGFIELD("FSTENVm")            100, false, false, 3092, 17, 106, 1,  0, 0}, // #895
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm_VPGATHERDDrm") 5, false, false, 3109, 14, 32, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 5, false, false, 3109, 14, 34, 1,  0, 0}, // #897
  {DBGFIELD("VPGATHERQDYrm")      5, false, false, 3109, 14, 34, 1,  0, 0}, // #898
  {DBGFIELD("VPGATHERQDrm")       5, false, false, 3109, 14, 32, 1,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 5, false, false, 3109, 14, 34, 1,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 5, false, false, 3109, 14, 34, 1,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, 3109, 14, 32, 1,  0, 0}, // #902
  {DBGFIELD("VGATHERQPSYrm")      5, false, false, 3109, 14, 34, 1,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VGATHERDPSrm") 5, false, false, 3109, 14, 32, 1,  0, 0}, // #904
  {DBGFIELD("ADC8i8_SBB8i8")      2, false, false, 632, 4,  8, 1,  0, 0}, // #905
  {DBGFIELD("ADC8ri_ADC8ri8_SBB8ri_SBB8ri8") 2, false, false, 632, 4,  8, 1,  0, 0}, // #906
  {DBGFIELD("VCVTSS2SDrm")        2, false, false, 532, 5, 19, 1,  0, 0}, // #907
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, 544, 10, 11, 1,  0, 0}, // #908
  {DBGFIELD("LRETQ")              3, false, false, 1581, 9,  3, 1,  0, 0}, // #909
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, 532, 5, 19, 1,  0, 0}, // #910
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, 1751, 10,  9, 1,  0, 0}, // #911
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_Int") 3, false, false, 1751, 10, 19, 1,  0, 0}, // #912
  {DBGFIELD("POPF64")             1, false, false, 507, 3,  5, 1,  0, 0}, // #913
  {DBGFIELD("VGATHERQPDrm")       5, false, false, 3109, 14, 32, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm")      5, false, false, 3109, 14, 34, 1,  0, 0}, // #915
  {DBGFIELD("VGATHERDPDrm")       5, false, false, 3109, 14, 32, 1,  0, 0}, // #916
  {DBGFIELD("VGATHERDPSrm")       5, false, false, 3109, 14, 32, 1,  0, 0}, // #917
  {DBGFIELD("VGATHERDPDYrm")      5, false, false, 3109, 14, 34, 1,  0, 0}, // #918
  {DBGFIELD("VGATHERDPSYrm")      5, false, false, 3109, 14, 34, 1,  0, 0}, // #919
  {DBGFIELD("MOV16rm")            1, false, false, 507, 3,  5, 1,  0, 0}, // #920
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, 507, 3,  5, 1,  0, 0}, // #921
  {DBGFIELD("POP16rmm")           4, false, false, 518, 6,  4, 1,  0, 0}, // #922
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, 518, 6,  4, 1,  0, 0}, // #923
  {DBGFIELD("PUSHF16")            6, false, false, 1638, 5,  5, 1,  0, 0}, // #924
  {DBGFIELD("LAHF")               1, false, false, 499, 4,  1, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mr_ADD32mi_ADD32mi8_ADD32mr_ADD64mi32_ADD64mi8_ADD64mr_ADD8mi_ADD8mi8_ADD8mr_SUB16mi_SUB16mi8_SUB16mr_SUB32mi_SUB32mi8_SUB32mr_SUB64mi32_SUB64mi8_SUB64mr_SUB8mi_SUB8mi8_SUB8mr") 3, false, false, 518, 6,  3, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, 485, 8, 11, 1,  0, 0}, // #927
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, 518, 6,  3, 1,  0, 0}, // #928
  {DBGFIELD("MULX32rr")           4, false, false, 908, 9, 75, 2,  0, 0}, // #929
  {DBGFIELD("MULX32rm")           5, false, false, 897, 11, 73, 2,  0, 0}, // #930
  {DBGFIELD("MULX64rr")           3, false, false, 930, 11, 75, 2,  0, 0}, // #931
  {DBGFIELD("MULX64rm")           4, false, false, 917, 13, 73, 2,  0, 0}, // #932
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, 1628, 10, 22, 1,  0, 0}, // #933
  {DBGFIELD("RETW_LRETL_LRETW")   2, false, false, 493, 6,  4, 1,  0, 0}, // #934
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, 493, 6,  4, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi_AND16mi8_AND16mr_AND32mi_AND32mi8_AND32mr_AND64mi32_AND64mi8_AND64mr_AND8mi_AND8mi8_AND8mr_OR16mi_OR16mi8_OR16mr_OR32mi_OR32mi8_OR32mi8Locked_OR32mr_OR64mi32_OR64mi8_OR64mr_OR8mi_OR8mi8_OR8mr_XOR16mi_XOR16mi8_XOR16mr_XOR32mi_XOR32mi8_XOR32mr_XOR64mi32_XOR64mi8_XOR64mr_XOR8mi_XOR8mi8_XOR8mr") 3, false, false, 518, 6,  3, 1,  0, 0}, // #936
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, 1165, 9,  7, 1,  0, 0}, // #937
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, 2620, 9,  4, 1,  0, 0}, // #938
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, 2609, 11,  9, 1,  0, 0}, // #939
  {DBGFIELD("MOVSLDUPrm")         1, false, false, 507, 3,  4, 1,  0, 0}, // #940
  {DBGFIELD("MOVSLDUPrr")         1, false, false, 510, 8,  1, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, 773, 2,  8, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, 672, 9,  1, 1,  0, 0}, // #943
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr") 1, false, false, 510, 8, 22, 1,  0, 0}, // #944
  {DBGFIELD("VPMOVZXBDYrm_VPMOVZXBQYrm_VPMOVZXBWYrm_VPMOVZXDQYrm_VPMOVZXWQYrm") 2, false, false, 544, 10, 19, 1,  0, 0}, // #945
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, 510, 8,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPBLENDWYrri")       1, false, false, 510, 8,  1, 1,  0, 0}, // #947
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, 544, 10,  3, 1, 21, 1}, // #948
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, 544, 10, 11, 1, 26, 1}, // #949
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, 510, 8,  1, 1,  0, 0}, // #950
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, 503, 4,  1, 1,  0, 0}, // #951
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, 503, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, 532, 5, 11, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, 532, 5,  3, 1,  0, 0}, // #954
  {DBGFIELD("VPMASKMOVDYmr_VPMASKMOVQYmr") 2, false, false, 2756, 10,  8, 1,  0, 0}, // #955
  {DBGFIELD("VPMASKMOVDmr_VPMASKMOVQmr") 2, false, false, 2756, 10,  8, 1,  0, 0}, // #956
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, 544, 10,  3, 1,  0, 0}, // #957
  {DBGFIELD("VPSLLDQri_VPSRLDQri") 1, false, false, 510, 8,  1, 1,  0, 0}, // #958
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, 510, 8,  1, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rr")       1, false, false, 510, 8, 22, 1,  0, 0}, // #960
  {DBGFIELD("VPERM2F128rm")       2, false, false, 544, 10, 19, 1, 26, 1}, // #961
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, 510, 8, 22, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, 503, 4,  1, 1,  0, 0}, // #963
  {DBGFIELD("VINSERTF128rr")      1, false, false, 510, 8, 22, 1,  0, 0}, // #964
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, 1005, 6, 11, 1,  0, 0}, // #965
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, 1005, 6, 11, 1,  0, 0}, // #966
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_VCVTTSS2SIrr_Int") 2, false, false, 833, 4,  4, 1,  0, 0}, // #967
  {DBGFIELD("VCVTSS2SI64rm_Int_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, 2413, 6,  9, 1,  0, 0}, // #968
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, 952, 4,  1, 1,  0, 0}, // #969
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, 952, 4,  1, 1,  0, 0}, // #970
  {DBGFIELD("SHA256MSG2rm")       2, false, false, 1005, 6, 19, 1, 21, 1}, // #971
  {DBGFIELD("SHA256MSG2rr")       1, false, false, 952, 4, 23, 1,  0, 0}, // #972
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, 952, 4, 23, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, 1005, 6, 19, 1, 21, 1}, // #974
  {DBGFIELD("SHA1MSG2rr")         1, false, false, 952, 4, 23, 1,  0, 0}, // #975
  {DBGFIELD("SHA1MSG2rm")         2, false, false, 1005, 6, 19, 1, 21, 1}, // #976
  {DBGFIELD("SHA1NEXTErr")        1, false, false, 952, 4, 23, 1,  0, 0}, // #977
  {DBGFIELD("SHA1NEXTErm")        2, false, false, 1005, 6, 19, 1, 21, 1}, // #978
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, 952, 4, 23, 1,  0, 0}, // #979
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, 1005, 6, 19, 1, 21, 1}, // #980
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, 952, 4, 23, 1,  0, 0}, // #981
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, 1005, 6, 19, 1, 21, 1}, // #982
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, 230, 2,  2, 1,  0, 0}, // #983
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, 518, 6,  3, 1,  0, 0}, // #984
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, 230, 2,  1, 1,  0, 0}, // #985
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, 524, 4,  4, 1,  0, 0}, // #986
  {DBGFIELD("XCHG16rr")           3, false, false, 773, 2,  8, 1,  0, 0}, // #987
  {DBGFIELD("CRC32r32r16")        1, false, false, 537, 7, 22, 1,  0, 0}, // #988
  {DBGFIELD("CRC32r32r32")        1, false, false, 537, 7, 22, 1,  0, 0}, // #989
  {DBGFIELD("CRC32r64r64")        1, false, false, 537, 7, 22, 1,  0, 0}, // #990
  {DBGFIELD("CMOVG16rm_CMOVG32rm_CMOVG64rm_CMOVGE16rm_CMOVGE32rm_CMOVGE64rm_CMOVL16rm_CMOVL32rm_CMOVL64rm_CMOVLE16rm_CMOVLE32rm_CMOVLE64rm") 2, false, false, 493, 6,  4, 1, 10, 1}, // #991
  {DBGFIELD("SETGEm_SETGm_SETLEm_SETLm") 3, false, false, 1147, 7,  8, 1,  0, 0}, // #992
  {DBGFIELD("SAHF")               1, false, false, 499, 4,  1, 1,  0, 0}, // #993
  {DBGFIELD("RCR8ri")             3, false, false, 1603, 4, 22, 1,  0, 0}, // #994
  {DBGFIELD("RCL16rCL")           7, false, false, 3011, 9,  9, 1,  0, 0}, // #995
  {DBGFIELD("RCR16ri")            3, false, false, 1603, 4, 22, 1,  0, 0}, // #996
  {DBGFIELD("RCL32rCL_RCL64rCL")  7, false, false, 3011, 9,  9, 1,  0, 0}, // #997
  {DBGFIELD("RCR64rCL")           7, false, false, 3011, 9,  9, 1,  0, 0}, // #998
  {DBGFIELD("RCR32rCL")           7, false, false, 3011, 9,  9, 1,  0, 0}, // #999
  {DBGFIELD("RCR32ri_RCR64ri")    3, false, false, 1603, 4, 22, 1,  0, 0}, // #1000
  {DBGFIELD("RCL16ri")            3, false, false, 1603, 4, 22, 1,  0, 0}, // #1001
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, 1603, 4, 22, 1,  0, 0}, // #1002
  {DBGFIELD("SHLD32rri8")         1, false, false, 537, 7, 22, 1,  0, 0}, // #1003
  {DBGFIELD("SHRD16rri8")         1, false, false, 537, 7, 22, 1,  0, 0}, // #1004
  {DBGFIELD("SHLD16rrCL")         4, false, false, 2620, 9,  4, 1,  0, 0}, // #1005
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, 503, 4,  1, 1,  0, 0}, // #1006
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, 503, 4,  1, 1,  0, 0}, // #1007
  {DBGFIELD("TST_F")              1, false, false, 672, 9,  8, 1,  0, 0}, // #1008
  {DBGFIELD("VDPPSrri")           4, false, false, 2498, 8, 27, 1,  0, 0}, // #1009
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr_VFRCZSDrr_VFRCZSSrr") 2, false, false, 833, 4, 11, 1,  0, 0}, // #1010
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, 2413, 6, 21, 1, 21, 1}, // #1011
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, 833, 4, 11, 1,  0, 0}, // #1012
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, 2413, 6, 10, 1, 26, 1}, // #1013
  {DBGFIELD("MMX_CVTTPD2PIirr")   2, false, false, 2855, 8,  5, 1,  0, 0}, // #1014
  {DBGFIELD("CVTSI642SDrr")       2, false, false, 2855, 8,  5, 1,  0, 0}, // #1015
  {DBGFIELD("CVTSI642SSrr")       3, false, false, 2526, 8,  4, 1,  0, 0}, // #1016
  {DBGFIELD("VMOVDQUYmr")         2, false, false, 503, 4,  1, 1,  0, 0}, // #1017
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, 833, 4, 19, 1,  0, 0}, // #1018
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, 2526, 8, 22, 1,  0, 0}, // #1019
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, 2516, 10,  7, 1, 21, 1}, // #1020
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, 510, 8,  4, 1,  0, 0}, // #1021
  {DBGFIELD("ANDNPSrr_VANDNPSrr_ANDNPDrr_VANDNPDrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1022
  {DBGFIELD("MMX_PXORirr_MMX_PANDNirr") 1, false, false, 2376, 5,  1, 1,  0, 0}, // #1023
  {DBGFIELD("PANDNrr_VPANDNrr")   1, false, false, 482, 3,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MMX_PSUBBirr_MMX_PSUBDirr_MMX_PSUBWirr_MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 2376, 5,  1, 1,  0, 0}, // #1025
  {DBGFIELD("VXORPSYrr_VXORPDYrr_VANDNPSYrr_VANDNPDYrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1026
  {DBGFIELD("MMX_PSUBSBirr_MMX_PSUBSWirr_MMX_PSUBUSBirr_MMX_PSUBUSWirr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #1027
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, 952, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, 481, 4,  1, 1,  0, 0}, // #1029
  {DBGFIELD("LEA16r")             1, false, false, 481, 4,  1, 1,  0, 0}, // #1030
  {DBGFIELD("MMX_PADDSBirr_MMX_PADDSWirr_MMX_PADDUSBirr_MMX_PADDUSWirr_MMX_PAVGBirr_MMX_PAVGWirr_MMX_PCMPEQBirr_MMX_PCMPEQDirr_MMX_PCMPEQWirr_MMX_PMAXSWirr_MMX_PMINSWirr_MMX_PMAXUBirr_MMX_PMINUBirr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #1031
  {DBGFIELD("MMX_PCMPGTBirr_MMX_PCMPGTDirr_MMX_PCMPGTWirr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #1032
  {DBGFIELD("CLAC_STAC")          1, false, false, 499, 4,  1, 1,  0, 0}, // #1033
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1034
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr_VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1035
  {DBGFIELD("PSUBBrr_PSUBDrr_PSUBWrr_VPSUBBrr_VPSUBDrr_VPSUBQrr_VPSUBWrr") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1036
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, 993, 12, 22, 1,  0, 0}, // #1038
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, 3123, 9, 22, 1,  0, 0}, // #1039
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, 3123, 9, 22, 1,  0, 0}, // #1040
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1041
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, 952, 4, 22, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_PADDSBirm_MMX_PADDSWirm_MMX_PADDUSBirm_MMX_PADDUSWirm_MMX_PAVGBirm_MMX_PAVGWirm_MMX_PCMPEQBirm_MMX_PCMPEQDirm_MMX_PCMPEQWirm_MMX_PCMPGTBirm_MMX_PCMPGTDirm_MMX_PCMPGTWirm_MMX_PMAXSWirm_MMX_PMAXUBirm_MMX_PMINSWirm_MMX_PMINUBirm_MMX_PSUBSBirm_MMX_PSUBSWirm_MMX_PSUBUSBirm_MMX_PSUBUSWirm") 2, false, false, 682, 11,  4, 1,  0, 0}, // #1043
  {DBGFIELD("CVTSS2SI64rr_Int")   3, false, false, 2900, 12,  3, 1,  0, 0}, // #1044
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, 833, 4,  4, 1,  0, 0}, // #1045
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1046
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1047
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, 979, 14, 11, 1,  0, 0}, // #1048
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, 3132, 11,  7, 1,  0, 0}, // #1049
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, 3132, 11, 19, 1,  0, 0}, // #1050
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 40, false, false, 3053, 11, 84, 1,  0, 0}, // #1051
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #1052
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, 672, 9,  1, 1,  0, 0}, // #1053
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, 510, 8,  1, 1,  0, 0}, // #1054
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1055
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1056
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rr_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rr_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rr_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rr_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rr_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rr_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rr_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rr_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrr_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrr_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrr_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrr_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1059
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1060
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 1, false, false, 482, 3,  1, 1,  0, 0}, // #1061
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, 503, 4,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 5, false, false, 3143, 7,  8, 1,  0, 0}, // #1063
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, 672, 9, 22, 1,  0, 0}, // #1064
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, 672, 9, 22, 1,  0, 0}, // #1065
  {DBGFIELD("VPSADBWZrr")         1, false, false, 510, 8, 22, 1,  0, 0}, // #1066
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1067
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1071
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rri_alt_VCMPPDZ128rri_altk_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rri_alt_VCMPPSZ128rri_altk_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1072
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rri_alt_VCMPPDZ256rri_altk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rri_alt_VCMPPSZ256rri_altk_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1073
  {DBGFIELD("VCMPPDZrri_VCMPPDZrri_alt_VCMPPDZrri_altk_VCMPPDZrrib_VCMPPDZrrib_alt_VCMPPDZrrib_altk_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrri_alt_VCMPPSZrri_altk_VCMPPSZrrib_VCMPPSZrrib_alt_VCMPPSZrrib_altk_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1074
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSDZrrb_alt_VCMPSDZrrb_altk_VCMPSDZrri_alt_VCMPSDZrri_altk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VCMPSSZrrb_alt_VCMPSSZrrb_altk_VCMPSSZrri_alt_VCMPSSZrri_altk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1075
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1076
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rri_alt_VPCMPBZ128rrik_VPCMPBZ128rrik_alt_VPCMPDZ128rri_VPCMPDZ128rri_alt_VPCMPDZ128rrik_VPCMPDZ128rrik_alt_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rri_alt_VPCMPQZ128rrik_VPCMPQZ128rrik_alt_VPCMPUBZ128rri_VPCMPUBZ128rri_alt_VPCMPUBZ128rrik_VPCMPUBZ128rrik_alt_VPCMPUDZ128rri_VPCMPUDZ128rri_alt_VPCMPUDZ128rrik_VPCMPUDZ128rrik_alt_VPCMPUQZ128rri_VPCMPUQZ128rri_alt_VPCMPUQZ128rrik_VPCMPUQZ128rrik_alt_VPCMPUWZ128rri_VPCMPUWZ128rri_alt_VPCMPUWZ128rrik_VPCMPUWZ128rrik_alt_VPCMPWZ128rri_VPCMPWZ128rri_alt_VPCMPWZ128rrik_VPCMPWZ128rrik_alt_VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1077
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rri_alt_VPCMPBZ256rrik_VPCMPBZ256rrik_alt_VPCMPDZ256rri_VPCMPDZ256rri_alt_VPCMPDZ256rrik_VPCMPDZ256rrik_alt_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rri_alt_VPCMPQZ256rrik_VPCMPQZ256rrik_alt_VPCMPUBZ256rri_VPCMPUBZ256rri_alt_VPCMPUBZ256rrik_VPCMPUBZ256rrik_alt_VPCMPUDZ256rri_VPCMPUDZ256rri_alt_VPCMPUDZ256rrik_VPCMPUDZ256rrik_alt_VPCMPUQZ256rri_VPCMPUQZ256rri_alt_VPCMPUQZ256rrik_VPCMPUQZ256rrik_alt_VPCMPUWZ256rri_VPCMPUWZ256rri_alt_VPCMPUWZ256rrik_VPCMPUWZ256rrik_alt_VPCMPWZ256rri_VPCMPWZ256rri_alt_VPCMPWZ256rrik_VPCMPWZ256rrik_alt_VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1078
  {DBGFIELD("VPCMPBZrri_VPCMPBZrri_alt_VPCMPBZrrik_VPCMPBZrrik_alt_VPCMPDZrri_VPCMPDZrri_alt_VPCMPDZrrik_VPCMPDZrrik_alt_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrri_alt_VPCMPQZrrik_VPCMPQZrrik_alt_VPCMPUBZrri_VPCMPUBZrri_alt_VPCMPUBZrrik_VPCMPUBZrrik_alt_VPCMPUDZrri_VPCMPUDZrri_alt_VPCMPUDZrrik_VPCMPUDZrrik_alt_VPCMPUQZrri_VPCMPUQZrri_alt_VPCMPUQZrrik_VPCMPUQZrrik_alt_VPCMPUWZrri_VPCMPUWZrri_alt_VPCMPUWZrrik_VPCMPUWZrrik_alt_VPCMPWZrri_VPCMPWZrri_alt_VPCMPWZrrik_VPCMPWZrrik_alt_VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1079
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1080
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 1, false, false, 510, 8, 22, 1,  0, 0}, // #1081
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1082
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1083
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1084
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1085
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, 952, 4, 23, 1,  0, 0}, // #1086
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1087
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1088
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1089
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, 952, 4, 23, 1,  0, 0}, // #1090
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 1, false, false, 2376, 5, 23, 1,  0, 0}, // #1091
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 1, false, false, 2376, 5, 23, 1,  0, 0}, // #1092
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 1, false, false, 2376, 5, 23, 1,  0, 0}, // #1093
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 1, false, false, 2376, 5, 23, 1,  0, 0}, // #1094
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 2, false, false, 564, 8, 23, 1,  0, 0}, // #1095
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 2, false, false, 564, 8, 23, 1,  0, 0}, // #1096
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 3, false, false, 805, 11, 23, 1,  0, 0}, // #1097
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1098
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1099
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1100
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1101
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1102
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1103
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1104
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1105
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI2SDZrrb_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1106
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 2, false, false, 2855, 8,  5, 1,  0, 0}, // #1107
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 3, false, false, 2526, 8,  5, 1,  0, 0}, // #1108
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, 3150, 6,  5, 1,  0, 0}, // #1109
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, 3150, 6,  5, 1,  0, 0}, // #1110
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 3, false, false, 3150, 6,  5, 1,  0, 0}, // #1111
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 4, false, false, 3156, 11,  5, 1,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 2, false, false, 564, 8,  4, 1,  0, 0}, // #1113
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 2, false, false, 532, 5,  4, 1,  0, 0}, // #1114
  {DBGFIELD("VMOVDI2PDIZrm")      2, false, false, 532, 5,  4, 1,  0, 0}, // #1115
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, 2526, 8,  4, 1,  0, 0}, // #1116
  {DBGFIELD("VMOVSDZrm_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrmk_VMOVSSZrmkz") 2, false, false, 544, 10,  3, 1,  0, 0}, // #1117
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #1118
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #1119
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #1120
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #1121
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #1122
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, 2855, 8,  3, 1,  0, 0}, // #1123
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 2, false, false, 2692, 8,  3, 1,  0, 0}, // #1124
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 2, false, false, 2692, 8,  3, 1,  0, 0}, // #1125
  {DBGFIELD("VCVTPD2PSZrr")       2, false, false, 2692, 8,  3, 1,  0, 0}, // #1126
  {DBGFIELD("VCVTPS2PDZrr")       2, false, false, 2692, 8,  3, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 2, false, false, 2692, 8,  3, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 2, false, false, 2692, 8,  3, 1,  0, 0}, // #1129
  {DBGFIELD("VMOVNTDQAZ128rm")    2, false, false, 532, 5,  3, 1,  0, 0}, // #1130
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1131
  {DBGFIELD("VBROADCASTI32X2Z128m_VBROADCASTI32X2Z128mk_VBROADCASTI32X2Z128mkz_VPBROADCASTDZ128m_VPBROADCASTDZ128mk_VPBROADCASTDZ128mkz_VPBROADCASTQZ128m_VPBROADCASTQZ128mk_VPBROADCASTQZ128mkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1132
  {DBGFIELD("VBROADCASTSSZ128m_VBROADCASTSSZ128mk_VBROADCASTSSZ128mkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1133
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1134
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1135
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1136
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1137
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, 532, 5,  3, 1, 21, 1}, // #1138
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 3, false, false, 2526, 8,  3, 1,  0, 0}, // #1139
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 3, false, false, 2900, 12,  3, 1,  0, 0}, // #1140
  {DBGFIELD("VCVTSS2SI64rr_Int")  3, false, false, 2900, 12,  3, 1,  0, 0}, // #1141
  {DBGFIELD("VCVTTSS2SI64rr_VCVTTSS2SI64rr_Int") 3, false, false, 2900, 12,  3, 1,  0, 0}, // #1142
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 3, false, false, 3167, 10,  3, 1,  0, 0}, // #1143
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 4, false, false, 3156, 11,  3, 1,  0, 0}, // #1144
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 7, false, false, 3177, 11,  3, 1,  0, 0}, // #1145
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 11, false, false, 3188, 11,  3, 1,  0, 0}, // #1146
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 19, false, false, 3199, 11,  3, 1,  0, 0}, // #1147
  {DBGFIELD("VSCATTERDPSZmr")     36, false, false, 3210, 14,  3, 1,  0, 0}, // #1148
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk") 2, false, false, 544, 10, 11, 1,  0, 0}, // #1149
  {DBGFIELD("VPBROADCASTBZ256m_VPBROADCASTBZ256mk_VPBROADCASTBZ256mkz_VPBROADCASTBZm_VPBROADCASTBZmk_VPBROADCASTBZmkz_VPBROADCASTWZ256m_VPBROADCASTWZ256mk_VPBROADCASTWZ256mkz_VPBROADCASTWZm_VPBROADCASTWZmk_VPBROADCASTWZmkz") 2, false, false, 544, 10, 11, 1,  0, 0}, // #1150
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, 532, 5, 11, 1,  0, 0}, // #1151
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1152
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1153
  {DBGFIELD("VBROADCASTF32X2Z256m_VBROADCASTF32X2Z256mk_VBROADCASTF32X2Z256mkz_VBROADCASTF32X2Zm_VBROADCASTF32X2Zmk_VBROADCASTF32X2Zmkz_VBROADCASTI32X2Z256m_VBROADCASTI32X2Z256mk_VBROADCASTI32X2Z256mkz_VBROADCASTI32X2Zm_VBROADCASTI32X2Zmk_VBROADCASTI32X2Zmkz_VPBROADCASTDZ256m_VPBROADCASTDZ256mk_VPBROADCASTDZ256mkz_VPBROADCASTDZm_VPBROADCASTDZmk_VPBROADCASTDZmkz_VPBROADCASTQZ256m_VPBROADCASTQZ256mk_VPBROADCASTQZ256mkz_VPBROADCASTQZm_VPBROADCASTQZmk_VPBROADCASTQZmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1154
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1155
  {DBGFIELD("VBROADCASTSDZ256m_VBROADCASTSDZ256mk_VBROADCASTSDZ256mkz_VBROADCASTSDZm_VBROADCASTSDZmk_VBROADCASTSDZmkz_VBROADCASTSSZ256m_VBROADCASTSSZ256mk_VBROADCASTSSZ256mkz_VBROADCASTSSZm_VBROADCASTSSZmk_VBROADCASTSSZmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1156
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1157
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1158
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1159
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1160
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1161
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1162
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1163
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1164
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1165
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 2, false, false, 532, 5, 11, 1, 26, 1}, // #1166
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 8, false, false, 3224, 14, 11, 1,  0, 0}, // #1167
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 12, false, false, 3238, 14, 11, 1,  0, 0}, // #1168
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 20, false, false, 3252, 14, 11, 1,  0, 0}, // #1169
  {DBGFIELD("VPSCATTERDDZmr")     36, false, false, 3210, 14, 11, 1,  0, 0}, // #1170
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1171
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbi_alt_VCMPPDZ128rmbi_altk_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmi_alt_VCMPPDZ128rmi_altk_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbi_alt_VCMPPSZ128rmbi_altk_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmi_alt_VCMPPSZ128rmi_altk_VCMPPSZ128rmik") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1172
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSDZrmi_alt_VCMPSDZrmi_altk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk_VCMPSSZrmi_alt_VCMPSSZrmi_altk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmi_alt_VPCMPBZ128rmik_VPCMPBZ128rmik_alt_VPCMPDZ128rmi_VPCMPDZ128rmi_alt_VPCMPDZ128rmib_VPCMPDZ128rmib_alt_VPCMPDZ128rmibk_VPCMPDZ128rmibk_alt_VPCMPDZ128rmik_VPCMPDZ128rmik_alt_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmi_alt_VPCMPQZ128rmib_VPCMPQZ128rmib_alt_VPCMPQZ128rmibk_VPCMPQZ128rmibk_alt_VPCMPQZ128rmik_VPCMPQZ128rmik_alt_VPCMPUBZ128rmi_VPCMPUBZ128rmi_alt_VPCMPUBZ128rmik_VPCMPUBZ128rmik_alt_VPCMPUDZ128rmi_VPCMPUDZ128rmi_alt_VPCMPUDZ128rmib_VPCMPUDZ128rmib_alt_VPCMPUDZ128rmibk_VPCMPUDZ128rmibk_alt_VPCMPUDZ128rmik_VPCMPUDZ128rmik_alt_VPCMPUQZ128rmi_VPCMPUQZ128rmi_alt_VPCMPUQZ128rmib_VPCMPUQZ128rmib_alt_VPCMPUQZ128rmibk_VPCMPUQZ128rmibk_alt_VPCMPUQZ128rmik_VPCMPUQZ128rmik_alt_VPCMPUWZ128rmi_VPCMPUWZ128rmi_alt_VPCMPUWZ128rmik_VPCMPUWZ128rmik_alt_VPCMPWZ128rmi_VPCMPWZ128rmi_alt_VPCMPWZ128rmik_VPCMPWZ128rmik_alt_VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1174
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1175
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1176
  {DBGFIELD("VPMOVSXBDZ128rm_VPMOVSXBDZ128rmk_VPMOVSXBDZ128rmkz_VPMOVSXBQZ128rm_VPMOVSXBQZ128rmk_VPMOVSXBQZ128rmkz_VPMOVSXBWZ128rm_VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVSXDQZ128rm_VPMOVSXDQZ128rmk_VPMOVSXDQZ128rmkz_VPMOVSXWDZ128rm_VPMOVSXWDZ128rmk_VPMOVSXWDZ128rmkz_VPMOVSXWQZ128rm_VPMOVSXWQZ128rmk_VPMOVSXWQZ128rmkz_VPMOVZXBDZ128rm_VPMOVZXBDZ128rmk_VPMOVZXBDZ128rmkz_VPMOVZXBQZ128rm_VPMOVZXBQZ128rmk_VPMOVZXBQZ128rmkz_VPMOVZXBWZ128rm_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPMOVZXDQZ128rm_VPMOVZXDQZ128rmk_VPMOVZXDQZ128rmkz_VPMOVZXWDZ128rm_VPMOVZXWDZ128rmk_VPMOVZXWDZ128rmkz_VPMOVZXWQZ128rm_VPMOVZXWQZ128rmk_VPMOVZXWQZ128rmkz") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1177
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, 544, 10,  7, 1,  0, 0}, // #1178
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1179
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1180
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbi_alt_VCMPPDZ256rmbi_altk_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmi_alt_VCMPPDZ256rmi_altk_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbi_alt_VCMPPSZ256rmbi_altk_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmi_alt_VCMPPSZ256rmi_altk_VCMPPSZ256rmik") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1181
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbi_alt_VCMPPDZrmbi_altk_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmi_alt_VCMPPDZrmi_altk_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbi_alt_VCMPPSZrmbi_altk_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmi_alt_VCMPPSZrmi_altk_VCMPPSZrmik") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1182
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmi_alt_VPCMPBZ256rmik_VPCMPBZ256rmik_alt_VPCMPDZ256rmi_VPCMPDZ256rmi_alt_VPCMPDZ256rmib_VPCMPDZ256rmib_alt_VPCMPDZ256rmibk_VPCMPDZ256rmibk_alt_VPCMPDZ256rmik_VPCMPDZ256rmik_alt_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmi_alt_VPCMPQZ256rmib_VPCMPQZ256rmib_alt_VPCMPQZ256rmibk_VPCMPQZ256rmibk_alt_VPCMPQZ256rmik_VPCMPQZ256rmik_alt_VPCMPUBZ256rmi_VPCMPUBZ256rmi_alt_VPCMPUBZ256rmik_VPCMPUBZ256rmik_alt_VPCMPUDZ256rmi_VPCMPUDZ256rmi_alt_VPCMPUDZ256rmib_VPCMPUDZ256rmib_alt_VPCMPUDZ256rmibk_VPCMPUDZ256rmibk_alt_VPCMPUDZ256rmik_VPCMPUDZ256rmik_alt_VPCMPUQZ256rmi_VPCMPUQZ256rmi_alt_VPCMPUQZ256rmib_VPCMPUQZ256rmib_alt_VPCMPUQZ256rmibk_VPCMPUQZ256rmibk_alt_VPCMPUQZ256rmik_VPCMPUQZ256rmik_alt_VPCMPUWZ256rmi_VPCMPUWZ256rmi_alt_VPCMPUWZ256rmik_VPCMPUWZ256rmik_alt_VPCMPWZ256rmi_VPCMPWZ256rmi_alt_VPCMPWZ256rmik_VPCMPWZ256rmik_alt_VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1183
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmi_alt_VPCMPBZrmik_VPCMPBZrmik_alt_VPCMPDZrmi_VPCMPDZrmi_alt_VPCMPDZrmib_VPCMPDZrmib_alt_VPCMPDZrmibk_VPCMPDZrmibk_alt_VPCMPDZrmik_VPCMPDZrmik_alt_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmi_alt_VPCMPQZrmib_VPCMPQZrmib_alt_VPCMPQZrmibk_VPCMPQZrmibk_alt_VPCMPQZrmik_VPCMPQZrmik_alt_VPCMPUBZrmi_VPCMPUBZrmi_alt_VPCMPUBZrmik_VPCMPUBZrmik_alt_VPCMPUDZrmi_VPCMPUDZrmi_alt_VPCMPUDZrmib_VPCMPUDZrmib_alt_VPCMPUDZrmibk_VPCMPUDZrmibk_alt_VPCMPUDZrmik_VPCMPUDZrmik_alt_VPCMPUQZrmi_VPCMPUQZrmi_alt_VPCMPUQZrmib_VPCMPUQZrmib_alt_VPCMPUQZrmibk_VPCMPUQZrmibk_alt_VPCMPUQZrmik_VPCMPUQZrmik_alt_VPCMPUWZrmi_VPCMPUWZrmi_alt_VPCMPUWZrmik_VPCMPUWZrmik_alt_VPCMPWZrmi_VPCMPWZrmi_alt_VPCMPWZrmik_VPCMPWZrmik_alt_VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1184
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1185
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 2, false, false, 544, 10, 19, 1,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1187
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1188
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1189
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1190
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1191
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, 532, 5, 19, 1,  0, 0}, // #1193
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 3, false, false, 554, 10, 19, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1200
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1201
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1202
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 2, false, false, 532, 5,  9, 1,  0, 0}, // #1206
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 3, false, false, 554, 10,  9, 1,  0, 0}, // #1207
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 3, false, false, 1142, 5,  9, 1,  0, 0}, // #1208
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 4, false, false, 2516, 10,  9, 1,  0, 0}, // #1209
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 3, false, false, 3266, 4, 20, 1,  0, 0}, // #1210
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 3, false, false, 3266, 4, 20, 1,  0, 0}, // #1211
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 3, false, false, 3270, 5, 20, 1,  0, 0}, // #1212
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 3, false, false, 554, 10, 20, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, 3275, 11, 20, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, 3275, 11, 20, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 3, false, false, 1751, 10, 20, 1,  0, 0}, // #1216
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 3, false, false, 554, 10, 27, 1,  0, 0}, // #1217
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 4, false, false, 2516, 10, 27, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 3, false, false, 1751, 10, 21, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 3, false, false, 1751, 10, 21, 1,  0, 0}, // #1220
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 3, false, false, 1751, 10, 21, 1,  0, 0}, // #1221
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 4, false, false, 2516, 10, 21, 1,  0, 0}, // #1222
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 8, false, false, 3286, 13, 10, 1,  0, 0}, // #1223
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 4, false, false, 3299, 5, 29, 1,  0, 0}, // #1224
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 4, false, false, 3299, 5, 63, 1,  0, 0}, // #1225
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 4, false, false, 3299, 5, 63, 1,  0, 0}, // #1226
  {DBGFIELD("VGATHERDPSZ128rm_VGATHERQPSZrm_VPGATHERDDZ128rm") 0, false, false,  0, 0, 30, 1,  0, 0}, // #1227
  {DBGFIELD("VGATHERQPSZ128rm_VGATHERQPSZ256rm_VPGATHERQDZ128rm_VPGATHERQDZ256rm") 5, false, false, 3304, 11, 30, 1,  0, 0}, // #1228
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 5, false, false, 3304, 11, 32, 1,  0, 0}, // #1229
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 14, false, false, 3315, 9, 32, 1,  0, 0}, // #1230
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 14, false, false, 3315, 9, 32, 1,  0, 0}, // #1231
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQDZrm_VPGATHERQQZ256rm") 5, false, false, 3304, 11, 34, 1,  0, 0}, // #1232
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 5, false, false, 3304, 11, 35, 1,  0, 0}, // #1233
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm") 5, false, false, 3304, 11, 66, 1,  0, 0}, // #1234
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 15, false, false, 3324, 11, 36, 1,  0, 0}, // #1235
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 5, false, false, 3304, 11, 37, 1,  0, 0}, // #1236
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 21, false, false, 3335, 9, 104, 1,  0, 0}, // #1237
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 21, false, false, 3335, 9, 104, 1,  0, 0}, // #1238
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 22, false, false, 3344, 11, 89, 1,  0, 0}, // #1239
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 22, false, false, 3344, 11, 89, 1,  0, 0}, // #1240
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 35, false, false, 3355, 9, 107, 1,  0, 0}, // #1241
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 36, false, false, 3364, 11, 46, 1,  0, 0}, // #1242
  {DBGFIELD("PdWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("WriteVecALU")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1244
  {DBGFIELD("JWriteZeroLatency")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD("SBWriteZeroLatency") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("WriteALU")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("WriteFLogic")        0, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("WriteVecLogicX")     0, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("WriteVecALUX")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("SBWriteResGroup30")  0, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("WriteFShuffle256")   0, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("WriteVecLogic")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("WriteFLogicY")       0, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("JWrite3OpsLEA")      0, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("WriteLEA")           0, false, false,  0, 0,  0, 0,  0, 0}, // #1257
}; // SkylakeServerModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SandyBridgeModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  16383, false, false,  0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteZero")          1, false, false,  0, 0,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteVecALU")        1, false, false, 3375, 5, 22, 1,  0, 0}, // #2
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, 3380, 7, 11, 1,  0, 0}, // #3
  {DBGFIELD("WriteJumpLd")        2, false, false, 3387, 6,  4, 1,  0, 0}, // #4
  {DBGFIELD("WriteALU")           1, false, false, 673, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteMove")          1, false, false, 673, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteJump")          1, false, false, 3393, 5,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, 673, 2,  2, 1,  0, 0}, // #8
  {DBGFIELD("WriteFStoreX")       1, false, false, 3398, 3,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteFLoadX")        1, false, false, 3401, 2,  4, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreY")       1, false, false, 3398, 3,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadY")        1, false, false, 3401, 2,  3, 1,  0, 0}, // #12
  {DBGFIELD("WriteMicrocoded")    1, false, false, 673, 2,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFSign")         1, false, false, 3393, 5,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteADC")           2, false, false, 1295, 3,  8, 1,  0, 0}, // #15
  {DBGFIELD("WriteADCRMW")        6, false, false, 3403, 4,  7, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCLd_ReadAfterLd") 3, false, false, 3407, 4,  3, 1, 10, 1}, // #17
  {DBGFIELD("WriteALURMW")        3, false, false, 3411, 4,  3, 1,  0, 0}, // #18
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, 3390, 3,  4, 1, 10, 1}, // #19
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, 3415, 6,  7, 1, 21, 1}, // #20
  {DBGFIELD("WriteFAdd64X")       1, false, false, 3375, 5, 22, 1,  0, 0}, // #21
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, 3415, 6,  7, 1, 21, 1}, // #22
  {DBGFIELD("WriteFAddX")         1, false, false, 3375, 5, 22, 1,  0, 0}, // #23
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, 3415, 6,  7, 1, 10, 1}, // #24
  {DBGFIELD("WriteFAdd64")        1, false, false, 3375, 5, 22, 1,  0, 0}, // #25
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, 3415, 6,  7, 1, 10, 1}, // #26
  {DBGFIELD("WriteFAdd")          1, false, false, 3375, 5, 22, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAddLd")        2, false, false, 3415, 6,  7, 1,  0, 0}, // #28
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 3, false, false, 3421, 6, 27, 1, 21, 1}, // #29
  {DBGFIELD("WriteAESDecEnc")     2, false, false, 3427, 5,  3, 1,  0, 0}, // #30
  {DBGFIELD("WriteAESIMCLd")      3, false, false, 3432, 6, 29, 1,  0, 0}, // #31
  {DBGFIELD("WriteAESIMC")        2, false, false, 3438, 5, 20, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, 3443, 3, 11, 1,  0, 0}, // #33
  {DBGFIELD("WriteAESKeyGen")     1, false, false, 3446, 2, 11, 1,  0, 0}, // #34
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, 3387, 6,  3, 1, 21, 1}, // #35
  {DBGFIELD("WriteFLogic")        1, false, false, 3393, 5,  1, 1,  0, 0}, // #36
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, 3448, 7,  3, 1, 18, 1}, // #37
  {DBGFIELD("WriteBEXTR")         2, false, false, 3455, 6,  8, 1,  0, 0}, // #38
  {DBGFIELD("WriteBEXTRLd")       3, false, false, 3448, 7,  3, 1,  0, 0}, // #39
  {DBGFIELD("WriteALULd")         2, false, false, 3390, 3,  4, 1,  0, 0}, // #40
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, 3461, 4,  3, 1, 21, 1}, // #41
  {DBGFIELD("WriteFBlend")        1, false, false, 817, 3,  1, 1,  0, 0}, // #42
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, 3465, 4, 11, 1, 21, 1}, // #43
  {DBGFIELD("WriteFVarBlend")     2, false, false, 3469, 3,  8, 1,  0, 0}, // #44
  {DBGFIELD("WriteBLSLd")         2, false, false, 3390, 3,  4, 1,  0, 0}, // #45
  {DBGFIELD("WriteBLS")           1, false, false, 673, 2,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteBSFLd")         2, false, false, 3415, 6, 11, 1,  0, 0}, // #47
  {DBGFIELD("WriteBSF")           1, false, false, 3375, 5, 22, 1,  0, 0}, // #48
  {DBGFIELD("WriteBSRLd")         2, false, false, 3415, 6, 11, 1,  0, 0}, // #49
  {DBGFIELD("WriteBSR")           1, false, false, 3375, 5, 22, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSWAP32")       1, false, false, 3375, 5,  1, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSWAP64")       2, false, false, 3455, 6,  8, 1,  0, 0}, // #52
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, 3461, 4,  4, 1,  0, 0}, // #53
  {DBGFIELD("WriteBitTestRegLd")  6, false, false, 3472, 7,  7, 1,  0, 0}, // #54
  {DBGFIELD("WriteBitTest")       1, false, false, 817, 3,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, 3479, 5,  3, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestSetRegRMW") 6, false, false, 3472, 7,  7, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestSet")    1, false, false, 817, 3,  1, 1,  0, 0}, // #58
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 3415, 6,  4, 1, 18, 1}, // #59
  {DBGFIELD("WriteBZHI")          1, false, false, 3375, 5,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteLoad")          1, false, false, 3401, 2,  5, 1,  0, 0}, // #61
  {DBGFIELD("WriteCMOV2Ld_ReadAfterLd") 4, false, false, 3484, 4, 11, 1, 10, 1}, // #62
  {DBGFIELD("WriteCMOV2")         3, false, false, 3488, 3, 22, 1,  0, 0}, // #63
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 3, false, false, 3407, 4,  3, 1, 10, 1}, // #64
  {DBGFIELD("WriteCMOV")          2, false, false, 1295, 3,  8, 1,  0, 0}, // #65
  {DBGFIELD("WriteFCMOV")         3, false, false, 3491, 5, 22, 1,  0, 0}, // #66
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, 3390, 3,  4, 1, 18, 1}, // #67
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, 3415, 6,  7, 1, 21, 1}, // #68
  {DBGFIELD("WriteFCmp64X")       1, false, false, 3375, 5, 22, 1,  0, 0}, // #69
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, 3415, 6,  7, 1, 21, 1}, // #70
  {DBGFIELD("WriteFCmpX")         1, false, false, 3375, 5, 22, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, 3415, 6,  7, 1, 10, 1}, // #72
  {DBGFIELD("WriteFCmp64")        1, false, false, 3375, 5, 22, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, 3415, 6,  7, 1, 10, 1}, // #74
  {DBGFIELD("WriteFCmp")          1, false, false, 3375, 5, 22, 1,  0, 0}, // #75
  {DBGFIELD("WriteCMPXCHG")       4, false, false, 3496, 3,  5, 1,  0, 0}, // #76
  {DBGFIELD("WriteFComLd_ReadAfterVecLd") 2, false, false, 3415, 6, 11, 1, 10, 1}, // #77
  {DBGFIELD("WriteFCom")          1, false, false, 3375, 5, 22, 1,  0, 0}, // #78
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, 3415, 6, 11, 1, 10, 1}, // #79
  {DBGFIELD("WriteCRC32")         1, false, false, 3375, 5, 22, 1,  0, 0}, // #80
  {DBGFIELD("WriteNop")           1, false, false,  0, 0,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCvtI2PDLd")     3, false, false, 3499, 8, 19, 1,  0, 0}, // #82
  {DBGFIELD("WriteCvtI2PD")       2, false, false, 3507, 7, 23, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, 3415, 6,  7, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PS")       1, false, false, 3375, 5, 22, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, 3499, 8, 19, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtPD2I")       2, false, false, 3507, 7, 23, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, 3499, 8, 19, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, 3507, 7, 23, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, 3415, 6,  7, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPS2I")       1, false, false, 3375, 5, 22, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, 3514, 6,  3, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, 3520, 7,  8, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, 3527, 8, 19, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtSD2I")       2, false, false, 3535, 7,  5, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2SSLd")    3, false, false, 3499, 8, 19, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 3, false, false, 3499, 8, 19, 1, 10, 1}, // #97
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, 3507, 7, 23, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, 3415, 6,  7, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, 3415, 6,  7, 1, 10, 1}, // #100
  {DBGFIELD("WriteCvtI2SD")       2, false, false, 3507, 7, 23, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SSLd")     3, false, false, 3499, 8, 19, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 3, false, false, 3499, 8, 19, 1, 10, 1}, // #103
  {DBGFIELD("WriteCvtI2SS")       3, false, false, 3542, 7,  5, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, 3514, 6,  3, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, 3514, 6,  3, 1, 10, 1}, // #106
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, 3549, 5,  1, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, 3527, 8, 19, 1,  0, 0}, // #108
  {DBGFIELD("WriteCvtSS2I")       2, false, false, 3535, 7,  5, 1,  0, 0}, // #109
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #110
  {DBGFIELD("WriteDiv16")         1, false, false, 3561, 6, 34, 1,  0, 0}, // #111
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #112
  {DBGFIELD("WriteDiv32")         1, false, false, 3561, 6, 34, 1,  0, 0}, // #113
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #114
  {DBGFIELD("WriteDiv64")         1, false, false, 3561, 6, 34, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #116
  {DBGFIELD("WriteDiv8")          1, false, false, 3561, 6, 34, 1,  0, 0}, // #117
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, 3567, 7, 88, 1, 21, 1}, // #118
  {DBGFIELD("WriteFDiv64X")       1, false, false, 3574, 6, 32, 1,  0, 0}, // #119
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, 3580, 7, 30, 1, 21, 1}, // #120
  {DBGFIELD("WriteFDivX")         1, false, false, 3587, 6, 21, 1,  0, 0}, // #121
  {DBGFIELD("WriteFDivLd")        2, false, false, 3580, 7, 30, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv")          1, false, false, 3587, 6, 21, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, 3567, 7, 88, 1, 10, 1}, // #124
  {DBGFIELD("WriteFDiv64")        1, false, false, 3574, 6, 32, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, 3580, 7, 30, 1, 10, 1}, // #126
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, 3593, 9, 10, 1, 21, 1}, // #127
  {DBGFIELD("WriteDPPD")          3, false, false, 3602, 8,  7, 1,  0, 0}, // #128
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, 3610, 9, 29, 1, 21, 1}, // #129
  {DBGFIELD("WriteDPPS")          4, false, false, 3619, 8, 20, 1,  0, 0}, // #130
  {DBGFIELD("WriteVecExtractSt")  3, false, false, 3627, 5,  5, 1,  0, 0}, // #131
  {DBGFIELD("WriteVecExtract")    2, false, false, 3632, 6, 22, 1,  0, 0}, // #132
  {DBGFIELD("WriteVecALUX")       1, false, false, 2005, 3,  1, 1,  0, 0}, // #133
  {DBGFIELD("WriteFComLd")        2, false, false, 3415, 6, 11, 1,  0, 0}, // #134
  {DBGFIELD("WriteEMMS")          31, false, false, 3638, 2, 71, 1,  0, 0}, // #135
  {DBGFIELD("WriteFLDC")          2, false, false, 3535, 7,  1, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, 3389, 4,  3, 1, 21, 1}, // #137
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, 3640, 8,  9, 1, 21, 1}, // #138
  {DBGFIELD("WriteFHAdd")         3, false, false, 3542, 7,  5, 1,  0, 0}, // #139
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #140
  {DBGFIELD("WriteIDiv16")        1, false, false, 3561, 6, 34, 1,  0, 0}, // #141
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #142
  {DBGFIELD("WriteIDiv32")        1, false, false, 3561, 6, 34, 1,  0, 0}, // #143
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #144
  {DBGFIELD("WriteIDiv64")        1, false, false, 3561, 6, 34, 1,  0, 0}, // #145
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3554, 7, 37, 1, 19, 2}, // #146
  {DBGFIELD("WriteIDiv8")         1, false, false, 3561, 6, 34, 1,  0, 0}, // #147
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, 3648, 7,  7, 1, 19, 2}, // #148
  {DBGFIELD("WriteIMul16")        4, false, false, 3655, 6, 23, 1,  0, 0}, // #149
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, 3415, 6, 11, 1, 10, 1}, // #150
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, 3661, 6, 11, 1,  0, 0}, // #151
  {DBGFIELD("WriteIMul16Reg")     1, false, false, 3375, 5, 22, 1,  0, 0}, // #152
  {DBGFIELD("WriteIMul16Imm")     2, false, false, 3667, 5, 23, 1,  0, 0}, // #153
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, 3672, 7,  7, 1, 19, 2}, // #154
  {DBGFIELD("WriteIMul32")        3, false, false, 3679, 6, 23, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, 3415, 6, 11, 1, 10, 1}, // #156
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, 3415, 6, 11, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul32Reg")     1, false, false, 3375, 5, 22, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul32Imm")     1, false, false, 3375, 5, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, 3527, 8,  7, 1, 19, 2}, // #160
  {DBGFIELD("WriteIMul64")        2, false, false, 3535, 7, 23, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, 3415, 6, 11, 1, 10, 1}, // #162
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, 3415, 6, 11, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul64Reg")     1, false, false, 3375, 5, 22, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul64Imm")     1, false, false, 3375, 5, 22, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, 3415, 6, 11, 1, 19, 2}, // #166
  {DBGFIELD("WriteIMul8")         1, false, false, 3375, 5, 22, 1,  0, 0}, // #167
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, 3387, 6,  3, 1, 21, 1}, // #168
  {DBGFIELD("WriteFShuffle")      1, false, false, 3393, 5,  1, 1,  0, 0}, // #169
  {DBGFIELD("WriteStore")         1, false, false, 3398, 3,  1, 1,  0, 0}, // #170
  {DBGFIELD("WriteVecLogicX")     1, false, false, 673, 2,  1, 1,  0, 0}, // #171
  {DBGFIELD("WriteShuffle")       1, false, false, 3393, 5,  1, 1,  0, 0}, // #172
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, 817, 3,  1, 1,  0, 0}, // #173
  {DBGFIELD("WriteVecLoadX")      1, false, false, 3401, 2,  4, 1,  0, 0}, // #174
  {DBGFIELD("WriteLDMXCSR")       4, false, false, 3685, 9,  5, 1,  0, 0}, // #175
  {DBGFIELD("WriteFLD0")          1, false, false, 3393, 5,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteFLD1")          2, false, false, 3520, 7,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteLEA")           1, false, false, 1229, 3,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteFence")         1, false, false, 3398, 3,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLZCNTLd")       2, false, false, 3415, 6, 11, 1,  0, 0}, // #180
  {DBGFIELD("WriteLZCNT")         1, false, false, 3375, 5, 22, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecStoreX")     1, false, false, 3398, 3,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecStore")      1, false, false, 3398, 3,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, 3549, 5,  8, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoad")       1, false, false, 3401, 2,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, 3393, 5,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteVecMoveX")      1, false, false, 673, 2,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreNT")    1, false, false, 3398, 3,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecMove")       1, false, false, 817, 3,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecALULd")      2, false, false, 3415, 6, 11, 1,  0, 0}, // #190
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, 3387, 6,  4, 1, 10, 1}, // #191
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, 3415, 6, 11, 1, 10, 1}, // #192
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, 3390, 3,  4, 1, 10, 1}, // #193
  {DBGFIELD("WriteVecLogic")      1, false, false, 673, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, 3644, 4, 11, 1, 10, 1}, // #195
  {DBGFIELD("WritePHAdd")         3, false, false, 3546, 3, 22, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, 3389, 4,  3, 1, 10, 1}, // #197
  {DBGFIELD("WriteVecInsert")     2, false, false, 3694, 5,  8, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, 3514, 6, 19, 1, 10, 1}, // #199
  {DBGFIELD("WriteVecIMul")       1, false, false, 3549, 5,  5, 1,  0, 0}, // #200
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, 3549, 5,  1, 1,  0, 0}, // #201
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, 3514, 6, 19, 1, 10, 1}, // #202
  {DBGFIELD("WritePSADBW")        1, false, false, 3549, 5,  5, 1,  0, 0}, // #203
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, 3389, 4,  4, 1, 10, 1}, // #204
  {DBGFIELD("WriteVarShuffle")    1, false, false, 2005, 3,  1, 1,  0, 0}, // #205
  {DBGFIELD("WriteShuffleLd")     2, false, false, 3387, 6,  4, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecShiftImm")   1, false, false, 3393, 5,  1, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, 3387, 6,  4, 1, 10, 1}, // #208
  {DBGFIELD("WriteVecShift")      1, false, false, 3393, 5,  1, 1,  0, 0}, // #209
  {DBGFIELD("WriteFMoveX")        1, false, false, 3393, 5,  1, 1,  0, 0}, // #210
  {DBGFIELD("WriteFShuffleLd")    2, false, false, 3387, 6,  3, 1,  0, 0}, // #211
  {DBGFIELD("WriteFStore")        1, false, false, 3398, 3,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteFMOVMSK")       1, false, false, 3549, 5,  8, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecLoadNT")     1, false, false, 3401, 2,  4, 1,  0, 0}, // #214
  {DBGFIELD("WriteStoreNT")       1, false, false, 3398, 3,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFStoreNTX")     1, false, false, 3398, 3,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFStoreNT")      1, false, false, 3398, 3,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFLoad")         1, false, false, 3401, 2,  5, 1,  0, 0}, // #218
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 4, false, false, 3699, 7, 27, 1, 21, 1}, // #219
  {DBGFIELD("WriteMPSAD")         3, false, false, 3706, 6,  3, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, 3514, 6,  9, 1, 21, 1}, // #221
  {DBGFIELD("WriteFMul64X")       1, false, false, 3549, 5,  5, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, 3514, 6,  9, 1, 21, 1}, // #223
  {DBGFIELD("WriteFMulX")         1, false, false, 3549, 5,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, 3514, 6,  9, 1, 10, 1}, // #225
  {DBGFIELD("WriteFMul64")        1, false, false, 3549, 5,  5, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, 3514, 6,  9, 1, 10, 1}, // #227
  {DBGFIELD("WriteFMul")          1, false, false, 3549, 5,  5, 1,  0, 0}, // #228
  {DBGFIELD("WriteIMul32Ld_WriteIMulH") 5, false, false, 3672, 7, 73, 2,  0, 0}, // #229
  {DBGFIELD("WriteIMul32_WriteIMulH") 4, false, false, 3679, 6, 75, 2,  0, 0}, // #230
  {DBGFIELD("WriteIMul64Ld_WriteIMulH") 4, false, false, 3527, 8, 73, 2,  0, 0}, // #231
  {DBGFIELD("WriteIMul64_WriteIMulH") 3, false, false, 3535, 7, 75, 2,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd")        2, false, false, 3514, 6,  9, 1,  0, 0}, // #233
  {DBGFIELD("WriteVecALUXLd")     2, false, false, 3389, 4,  3, 1,  0, 0}, // #234
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, 3389, 4,  3, 1, 21, 1}, // #235
  {DBGFIELD("WriteShuffleX")      1, false, false, 2005, 3,  1, 1,  0, 0}, // #236
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, 3390, 3,  3, 1, 21, 1}, // #237
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, 3434, 4, 11, 1, 21, 1}, // #238
  {DBGFIELD("WriteVarBlend")      2, false, false, 2254, 3,  8, 1,  0, 0}, // #239
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, 3389, 4,  3, 1, 21, 1}, // #240
  {DBGFIELD("WriteBlend")         1, false, false, 2005, 3,  1, 1,  0, 0}, // #241
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 1, false, false, 3712, 3, 21, 1, 21, 1}, // #242
  {DBGFIELD("WriteCLMul")         1, false, false, 3715, 2, 21, 1,  0, 0}, // #243
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 1, false, false, 3717, 3, 23, 1, 21, 1}, // #244
  {DBGFIELD("WritePCmpEStrI")     1, false, false, 3720, 2, 23, 1,  0, 0}, // #245
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 1, false, false, 3717, 3,  9, 1, 21, 1}, // #246
  {DBGFIELD("WritePCmpEStrM")     1, false, false, 3720, 2,  9, 1,  0, 0}, // #247
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, 3722, 6, 28, 1, 21, 1}, // #248
  {DBGFIELD("WritePCmpIStrI")     3, false, false, 3728, 5,  9, 1,  0, 0}, // #249
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, 3722, 6, 28, 1, 21, 1}, // #250
  {DBGFIELD("WritePCmpIStrM")     3, false, false, 3728, 5,  9, 1,  0, 0}, // #251
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, 3415, 6,  7, 1, 21, 1}, // #252
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, 3644, 4,  7, 1, 21, 1}, // #253
  {DBGFIELD("WritePHAddX")        3, false, false, 3546, 3, 22, 1,  0, 0}, // #254
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, 3514, 6,  9, 1,  0, 0}, // #255
  {DBGFIELD("WritePHMINPOS")      1, false, false, 3549, 5,  5, 1,  0, 0}, // #256
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, 3415, 6,  