/* fep.c generated by valac 0.40.8, the Vala compiler
 * generated from fep.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <libfep-glib/libfep-glib.h>
#include <gio/gio.h>


#define TYPE_PREEDIT_STYLE (preedit_style_get_type ())
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_OPTIONS (options_get_type ())
typedef struct _Options Options;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_CLIENT (client_get_type ())
#define CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLIENT, Client))
#define CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLIENT, ClientClass))
#define IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLIENT))
#define IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLIENT))
#define CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLIENT, ClientClass))

typedef struct _Client Client;
typedef struct _ClientClass ClientClass;
typedef struct _ClientPrivate ClientPrivate;
enum  {
	CLIENT_0_PROPERTY,
	CLIENT_NUM_PROPERTIES
};
static GParamSpec* client_properties[CLIENT_NUM_PROPERTIES];

#define CLIENT_TYPE_ENTRY (client_entry_get_type ())
typedef struct _ClientEntry ClientEntry;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

typedef enum  {
	PREEDIT_STYLE_OVER_THE_SPOT,
	PREEDIT_STYLE_ROOT,
	PREEDIT_STYLE_DEFAULT = PREEDIT_STYLE_OVER_THE_SPOT
} PreeditStyle;

struct _Options {
	PreeditStyle preedit_style;
};

struct _Block1Data {
	int _ref_count_;
	GPid pid;
};

struct _Client {
	FepGClient parent_instance;
	ClientPrivate * priv;
};

struct _ClientClass {
	FepGClientClass parent_class;
};

struct _ClientPrivate {
	SkkContext* context;
	Options opts;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
	gboolean lookup_table_visible;
	gchar* preedit;
	gchar* status;
	FepGAttribute* status_attr;
	SkkInputMode input_mode;
};

struct _ClientEntry {
	gpointer key;
	gpointer value;
};


extern gchar* opt_file_dict;
gchar* opt_file_dict = NULL;
extern gchar* opt_user_dict;
gchar* opt_user_dict = NULL;
extern gchar* opt_skkserv;
gchar* opt_skkserv = NULL;
extern gchar* opt_typing_rule;
gchar* opt_typing_rule = NULL;
extern gboolean opt_list_typing_rules;
gboolean opt_list_typing_rules = FALSE;
extern gchar* opt_preedit_style;
gchar* opt_preedit_style = NULL;
static gpointer client_parent_class = NULL;

GType preedit_style_get_type (void) G_GNUC_CONST;
gint _vala_main (gchar** args,
                 int args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata * array,
                                       gint array_length);
GType options_get_type (void) G_GNUC_CONST;
Options* options_dup (const Options* self);
void options_free (Options* self);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda4_ (Block1Data* _data1_,
                   GPid p,
                   gint s);
static void _____lambda4__gchild_watch_func (GPid pid,
                                      gint status,
                                      gpointer self);
GType client_get_type (void) G_GNUC_CONST;
Client* client_new (SkkContext* context,
                    Options* opts,
                    GError** error);
Client* client_construct (GType object_type,
                          SkkContext* context,
                          Options* opts,
                          GError** error);
gboolean client_run (Client* self);
#define CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLIENT, ClientPrivate))
static GType client_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ClientEntry* client_entry_dup (const ClientEntry* self);
static void client_entry_free (ClientEntry* self);
static void client_entry_copy (const ClientEntry* self,
                        ClientEntry* dest);
static void client_entry_destroy (ClientEntry* self);
static gboolean client_process_lookup_table_key_event (Client* self,
                                                guint keyval,
                                                guint state);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      gchar* needle);
static void client_set_lookup_table_cursor_pos (Client* self);
static void client_update_preedit (Client* self);
static gboolean client_real_filter_key_event (FepGClient* base,
                                       guint keyval,
                                       guint modifiers);
static void client_update_status (Client* self);
static FepGAttribute* _fep_g_attribute_dup (FepGAttribute* self);
static gboolean _fep_g_attribute_equal (const FepGAttribute * s1,
                                 const FepGAttribute * s2);
static void client_populate_lookup_table (Client* self);
static gboolean client_watch_func (Client* self,
                            GIOChannel* source,
                            GIOCondition condition);
static void __lambda5_ (Client* self);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda6_ (Client* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (Client* self);
static void ___lambda7__skk_candidate_list_populated (SkkCandidateList* _sender,
                                               gpointer self);
static void __lambda8_ (Client* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda9_ (Client* self);
static void ___lambda9__skk_candidate_list_selected (SkkCandidateList* _sender,
                                              SkkCandidate* candidate,
                                              gpointer self);
static gboolean _client_watch_func_gio_func (GIOChannel* source,
                                      GIOCondition condition,
                                      gpointer self);
static void client_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const GOptionEntry options[7] = {{"file-dict", 'f', 0, G_OPTION_ARG_STRING, &opt_file_dict, N_ ("Path to a file dictionary"), NULL}, {"user-dict", 'u', 0, G_OPTION_ARG_STRING, &opt_user_dict, N_ ("Path to a user dictionary"), NULL}, {"skkserv", 's', 0, G_OPTION_ARG_STRING, &opt_skkserv, N_ ("Host and port running skkserv (HOST:PORT)"), NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &opt_typing_rule, N_ ("Typing rule (default: \"default\")"), NULL}, {"list-rules", 'l', 0, G_OPTION_ARG_NONE, &opt_list_typing_rules, N_ ("List typing rules"), NULL}, {"preedit-style", 'p', 0, G_OPTION_ARG_STRING, &opt_preedit_style, N_ ("Preedit style"), NULL}, {NULL}};
static const ClientEntry CLIENT_input_mode_labels[5] = {{SKK_INPUT_MODE_HIRAGANA, "あ"}, {SKK_INPUT_MODE_KATAKANA, "ア"}, {SKK_INPUT_MODE_HANKAKU_KATAKANA, "_ｱ"}, {SKK_INPUT_MODE_LATIN, "_A"}, {SKK_INPUT_MODE_WIDE_LATIN, "Ａ"}};

GType
preedit_style_get_type (void)
{
	static volatile gsize preedit_style_type_id__volatile = 0;
	if (g_once_init_enter (&preedit_style_type_id__volatile)) {
		static const GEnumValue values[] = {{PREEDIT_STYLE_OVER_THE_SPOT, "PREEDIT_STYLE_OVER_THE_SPOT", "over-the-spot"}, {PREEDIT_STYLE_ROOT, "PREEDIT_STYLE_ROOT", "root"}, {PREEDIT_STYLE_DEFAULT, "PREEDIT_STYLE_DEFAULT", "default"}, {0, NULL, NULL}};
		GType preedit_style_type_id;
		preedit_style_type_id = g_enum_register_static ("PreeditStyle", values);
		g_once_init_leave (&preedit_style_type_id__volatile, preedit_style_type_id);
	}
	return preedit_style_type_id__volatile;
}


static void
_vala_SkkRuleMetadata_array_free (SkkRuleMetadata * array,
                                  gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static GEnumValue*
_g_enum_value_dup (GEnumValue* self)
{
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}


static gpointer
__g_enum_value_dup0 (gpointer self)
{
	return self ? _g_enum_value_dup (self) : NULL;
}


static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}


static void
____lambda4_ (Block1Data* _data1_,
              GPid p,
              gint s)
{
	GPid _tmp0_;
	_tmp0_ = _data1_->pid;
	g_spawn_close_pid (_tmp0_);
	exit (s);
}


static void
_____lambda4__gchild_watch_func (GPid pid,
                                 gint status,
                                 gpointer self)
{
	____lambda4_ (self, pid, status);
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	GOptionContext* option_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	gboolean _tmp8_;
	GeeArrayList* dictionaries = NULL;
	GeeArrayList* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp31_;
	const gchar* _tmp33_;
	const gchar* _tmp52_;
	SkkContext* context = NULL;
	GeeArrayList* _tmp78_;
	gint _tmp79_;
	gpointer* _tmp80_;
	SkkDict** _tmp81_;
	gint _tmp81__length1;
	SkkContext* _tmp82_;
	SkkContext* _tmp83_;
	const gchar* _tmp84_;
	Options opts = {0};
	Options _tmp95_ = {0};
	const gchar* _tmp96_;
	gchar** argv = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	Client* client = NULL;
	Client* _tmp129_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (_ ("- emulate SKK input method on the command line"));
	option_context = _tmp0_;
	_tmp1_ = option_context;
	g_option_context_add_main_entries (_tmp1_, options, "libskk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option_context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	skk_init ();
	_tmp8_ = opt_list_typing_rules;
	if (_tmp8_) {
		SkkRuleMetadata* rules = NULL;
		gint _tmp9_;
		SkkRuleMetadata* _tmp10_;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = skk_rule_list (&_tmp9_);
		rules = _tmp10_;
		rules_length1 = _tmp9_;
		_rules_size_ = rules_length1;
		_tmp11_ = rules;
		_tmp11__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp11_;
			rule_collection_length1 = _tmp11__length1;
			for (rule_it = 0; rule_it < _tmp11__length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp12_ = {0};
				SkkRuleMetadata rule = {0};
				skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp12_);
				rule = _tmp12_;
				{
					FILE* _tmp13_;
					SkkRuleMetadata _tmp14_;
					const gchar* _tmp15_;
					SkkRuleMetadata _tmp16_;
					const gchar* _tmp17_;
					SkkRuleMetadata _tmp18_;
					const gchar* _tmp19_;
					_tmp13_ = stdout;
					_tmp14_ = rule;
					_tmp15_ = _tmp14_.name;
					_tmp16_ = rule;
					_tmp17_ = _tmp16_.label;
					_tmp18_ = rule;
					_tmp19_ = _tmp18_.description;
					fprintf (_tmp13_, "%s - %s: %s\n", _tmp15_, _tmp17_, _tmp19_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp20_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dictionaries = _tmp20_;
	_tmp21_ = opt_user_dict;
	if (_tmp21_ != NULL) {
		{
			SkkUserDict* _tmp22_ = NULL;
			const gchar* _tmp23_;
			SkkUserDict* _tmp24_;
			GeeArrayList* _tmp25_;
			_tmp23_ = opt_user_dict;
			_tmp24_ = skk_user_dict_new (_tmp23_, "UTF-8", &_inner_error_);
			_tmp22_ = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp25_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (SkkDict*) _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = opt_user_dict;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			fprintf (_tmp26_, "can't open user dict %s: %s", _tmp27_, _tmp29_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp30_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp30_;
		}
	}
	_tmp31_ = opt_file_dict;
	if (_tmp31_ == NULL) {
		gchar* _tmp32_;
		_tmp32_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_file_dict);
		opt_file_dict = _tmp32_;
	}
	_tmp33_ = opt_file_dict;
	if (g_str_has_suffix (_tmp33_, ".cdb")) {
		{
			SkkCdbDict* _tmp34_ = NULL;
			const gchar* _tmp35_;
			SkkCdbDict* _tmp36_;
			GeeArrayList* _tmp37_;
			_tmp35_ = opt_file_dict;
			_tmp36_ = skk_cdb_dict_new (_tmp35_, "EUC-JP", &_inner_error_);
			_tmp34_ = _tmp36_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp37_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (SkkDict*) _tmp34_);
			_g_object_unref0 (_tmp34_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp38_;
			const gchar* _tmp39_;
			GError* _tmp40_;
			const gchar* _tmp41_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp38_ = stderr;
			_tmp39_ = opt_file_dict;
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			fprintf (_tmp38_, "can't open CDB dict %s: %s", _tmp39_, _tmp41_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp42_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp42_;
		}
	} else {
		{
			SkkFileDict* _tmp43_ = NULL;
			const gchar* _tmp44_;
			SkkFileDict* _tmp45_;
			GeeArrayList* _tmp46_;
			_tmp44_ = opt_file_dict;
			_tmp45_ = skk_file_dict_new (_tmp44_, "EUC-JP", &_inner_error_);
			_tmp43_ = _tmp45_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp46_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, (SkkDict*) _tmp43_);
			_g_object_unref0 (_tmp43_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			FILE* _tmp47_;
			const gchar* _tmp48_;
			GError* _tmp49_;
			const gchar* _tmp50_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp47_ = stderr;
			_tmp48_ = opt_file_dict;
			_tmp49_ = e;
			_tmp50_ = _tmp49_->message;
			fprintf (_tmp47_, "can't open file dict %s: %s", _tmp48_, _tmp50_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp51_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp51_;
		}
	}
	_tmp52_ = opt_skkserv;
	if (_tmp52_ != NULL) {
		gint index = 0;
		const gchar* _tmp53_;
		gchar* host = NULL;
		guint16 port = 0U;
		gint _tmp54_;
		_tmp53_ = opt_skkserv;
		index = string_last_index_of (_tmp53_, ":", 0);
		_tmp54_ = index;
		if (_tmp54_ < 0) {
			const gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp55_ = opt_skkserv;
			_tmp56_ = g_strdup (_tmp55_);
			_g_free0 (host);
			host = _tmp56_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp57_;
			gint _tmp58_;
			gchar* _tmp59_;
			const gchar* _tmp60_;
			gint _tmp61_;
			const gchar* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp57_ = opt_skkserv;
			_tmp58_ = index;
			_tmp59_ = string_slice (_tmp57_, (glong) 0, (glong) _tmp58_);
			_g_free0 (host);
			host = _tmp59_;
			_tmp60_ = opt_skkserv;
			_tmp61_ = index;
			_tmp62_ = opt_skkserv;
			_tmp63_ = strlen (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = string_slice (_tmp60_, (glong) (_tmp61_ + 1), (glong) _tmp64_);
			_tmp66_ = _tmp65_;
			port = (guint16) atoi (_tmp66_);
			_g_free0 (_tmp66_);
		}
		{
			SkkSkkServ* _tmp67_ = NULL;
			const gchar* _tmp68_;
			guint16 _tmp69_;
			SkkSkkServ* _tmp70_;
			GeeArrayList* _tmp71_;
			_tmp68_ = host;
			_tmp69_ = port;
			_tmp70_ = skk_skk_serv_new (_tmp68_, _tmp69_, "EUC-JP", &_inner_error_);
			_tmp67_ = _tmp70_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch4_g_error;
			}
			_tmp71_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, (SkkDict*) _tmp67_);
			_g_object_unref0 (_tmp67_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp72_;
			const gchar* _tmp73_;
			guint16 _tmp74_;
			GError* _tmp75_;
			const gchar* _tmp76_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp72_ = stderr;
			_tmp73_ = host;
			_tmp74_ = port;
			_tmp75_ = e;
			_tmp76_ = _tmp75_->message;
			fprintf (_tmp72_, "can't connect to skkserv at %s:%d: %s", _tmp73_, (gint) _tmp74_, _tmp76_);
			result = 1;
			_g_error_free0 (e);
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp77_ = -1;
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp77_;
		}
		_g_free0 (host);
	}
	_tmp78_ = dictionaries;
	_tmp80_ = gee_collection_to_array ((GeeCollection*) _tmp78_, &_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp81__length1 = _tmp79_;
	_tmp82_ = skk_context_new (_tmp81_, _tmp79_);
	_tmp83_ = _tmp82_;
	_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp83_;
	_tmp84_ = opt_typing_rule;
	if (_tmp84_ != NULL) {
		{
			SkkRule* _tmp85_ = NULL;
			const gchar* _tmp86_;
			SkkRule* _tmp87_;
			SkkContext* _tmp89_;
			_tmp86_ = opt_typing_rule;
			_tmp87_ = skk_rule_new (_tmp86_, &_inner_error_);
			_tmp85_ = _tmp87_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp88_ = -1;
				if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch5_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp88_;
			}
			_tmp89_ = context;
			skk_context_set_typing_rule (_tmp89_, _tmp85_);
			_g_object_unref0 (_tmp85_);
		}
		goto __finally5;
		__catch5_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp90_;
			const gchar* _tmp91_;
			GError* _tmp92_;
			const gchar* _tmp93_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp90_ = stderr;
			_tmp91_ = opt_typing_rule;
			_tmp92_ = e;
			_tmp93_ = _tmp92_->message;
			fprintf (_tmp90_, "can't load rule \"%s\": %s\n", _tmp91_, _tmp93_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp94_ = -1;
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp94_;
		}
	}
	memset (&_tmp95_, 0, sizeof (Options));
	_tmp95_.preedit_style = PREEDIT_STYLE_DEFAULT;
	opts = _tmp95_;
	_tmp96_ = opt_preedit_style;
	if (_tmp96_ != NULL) {
		GEnumClass* eclass = NULL;
		GTypeClass* _tmp97_;
		GEnumValue* evalue = NULL;
		GEnumClass* _tmp98_;
		const gchar* _tmp99_;
		GEnumValue* _tmp100_;
		GEnumValue* _tmp101_;
		GEnumValue* _tmp104_;
		gint _tmp105_;
		_tmp97_ = g_type_class_ref (TYPE_PREEDIT_STYLE);
		eclass = (GEnumClass*) _tmp97_;
		_tmp98_ = eclass;
		_tmp99_ = opt_preedit_style;
		_tmp100_ = __g_enum_value_dup0 (g_enum_get_value_by_nick (_tmp98_, _tmp99_));
		evalue = _tmp100_;
		_tmp101_ = evalue;
		if (_tmp101_ == NULL) {
			FILE* _tmp102_;
			const gchar* _tmp103_;
			_tmp102_ = stderr;
			_tmp103_ = opt_preedit_style;
			fprintf (_tmp102_, _ ("unknown preedit style %s"), _tmp103_);
			result = 1;
			_g_free0 (evalue);
			_g_type_class_unref0 (eclass);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		_tmp104_ = evalue;
		_tmp105_ = (*_tmp104_).value;
		opts.preedit_style = (PreeditStyle) _tmp105_;
		_g_free0 (evalue);
		_g_type_class_unref0 (eclass);
	}
	if (args_length1 > 1) {
		gchar** _tmp106_;
		gint _tmp106__length1;
		_tmp106_ = ((args + 1) != NULL) ? _vala_array_dup1 (args + 1, args_length1 - 1) : ((gpointer) (args + 1));
		_tmp106__length1 = args_length1 - 1;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp106_;
		argv_length1 = _tmp106__length1;
		_argv_size_ = argv_length1;
	} else {
		const gchar* _tmp107_;
		gchar* _tmp108_;
		gchar** _tmp109_;
		_tmp107_ = g_getenv ("SHELL");
		_tmp108_ = g_strdup (_tmp107_);
		_tmp109_ = g_new0 (gchar*, 1 + 1);
		_tmp109_[0] = _tmp108_;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp109_;
		argv_length1 = 1;
		_argv_size_ = argv_length1;
	}
	{
		Block1Data* _data1_;
		gboolean _tmp110_ = FALSE;
		gchar** _tmp111_;
		gint _tmp111__length1;
		GPid _tmp112_ = 0;
		gboolean _tmp113_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp111_ = argv;
		_tmp111__length1 = argv_length1;
		_tmp113_ = g_spawn_async (NULL, _tmp111_, NULL, (G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_CHILD_INHERITS_STDIN) | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp112_, &_inner_error_);
		_data1_->pid = _tmp112_;
		_tmp110_ = _tmp113_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp114_ = -1;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp114_;
		}
		if (_tmp110_) {
			GPid _tmp115_;
			_tmp115_ = _data1_->pid;
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp115_, _____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		}
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp116_;
		GError* _tmp117_;
		const gchar* _tmp118_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp116_ = stderr;
		_tmp117_ = e;
		_tmp118_ = _tmp117_->message;
		fprintf (_tmp116_, "%s\n", _tmp118_);
		result = 1;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp119_ = -1;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp119_;
	}
	{
		Client* _tmp120_ = NULL;
		SkkContext* _tmp121_;
		Options _tmp122_;
		Client* _tmp123_;
		Client* _tmp124_;
		_tmp121_ = context;
		_tmp122_ = opts;
		_tmp123_ = client_new (_tmp121_, &_tmp122_, &_inner_error_);
		_tmp120_ = _tmp123_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp124_ = _tmp120_;
		_tmp120_ = NULL;
		_g_object_unref0 (client);
		client = _tmp124_;
		_g_object_unref0 (_tmp120_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp125_;
		GError* _tmp126_;
		const gchar* _tmp127_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp125_ = stderr;
		_tmp126_ = e;
		_tmp127_ = _tmp126_->message;
		fprintf (_tmp125_, "can't create client: %s", _tmp127_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (client);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp128_ = -1;
		_g_object_unref0 (client);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp128_;
	}
	_tmp129_ = client;
	if (!client_run (_tmp129_)) {
		result = 1;
		_g_object_unref0 (client);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	result = 0;
	_g_object_unref0 (client);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}


Options*
options_dup (const Options* self)
{
	Options* dup;
	dup = g_new0 (Options, 1);
	memcpy (dup, self, sizeof (Options));
	return dup;
}


void
options_free (Options* self)
{
	g_free (self);
}


GType
options_get_type (void)
{
	static volatile gsize options_type_id__volatile = 0;
	if (g_once_init_enter (&options_type_id__volatile)) {
		GType options_type_id;
		options_type_id = g_boxed_type_register_static ("Options", (GBoxedCopyFunc) options_dup, (GBoxedFreeFunc) options_free);
		g_once_init_leave (&options_type_id__volatile, options_type_id);
	}
	return options_type_id__volatile;
}


static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean
client_process_lookup_table_key_event (Client* self,
                                       guint keyval,
                                       guint state)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (state == ((guint) 0)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp1_ = g_unichar_to_string ((gunichar) keyval);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp3__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp0_ = _vala_string_array_contains (_tmp3_, _tmp3__length1, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* label = NULL;
		gchar* _tmp4_;
		gint end = 0;
		SkkContext* _tmp5_;
		SkkCandidateList* _tmp6_;
		SkkCandidateList* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp4_ = g_unichar_to_string (g_unichar_tolower ((gunichar) keyval));
		label = _tmp4_;
		_tmp5_ = self->priv->context;
		_tmp6_ = skk_context_get_candidates (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = skk_candidate_list_get_page_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp10__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		end = MIN ((gint) _tmp9_, _tmp10__length1);
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = index;
						index = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = index;
					_tmp14_ = end;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp15__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp16_ = index;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp18_ = label;
					if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
						SkkContext* _tmp19_;
						SkkCandidateList* _tmp20_;
						SkkCandidateList* _tmp21_;
						gint _tmp22_;
						_tmp19_ = self->priv->context;
						_tmp20_ = skk_context_get_candidates (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = index;
						result = skk_candidate_list_select_at (_tmp21_, (guint) _tmp22_);
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	if (state == ((guint) 0)) {
		gboolean retval = FALSE;
		gboolean _tmp35_;
		retval = FALSE;
		switch (keyval) {
			case SKK_KEYSYMS_Page_Up:
			case SKK_KEYSYMS_KP_Page_Up:
			{
				SkkContext* _tmp23_;
				SkkCandidateList* _tmp24_;
				SkkCandidateList* _tmp25_;
				_tmp23_ = self->priv->context;
				_tmp24_ = skk_context_get_candidates (_tmp23_);
				_tmp25_ = _tmp24_;
				retval = skk_candidate_list_page_up (_tmp25_);
				break;
			}
			case SKK_KEYSYMS_Page_Down:
			case SKK_KEYSYMS_KP_Page_Down:
			{
				SkkContext* _tmp26_;
				SkkCandidateList* _tmp27_;
				SkkCandidateList* _tmp28_;
				_tmp26_ = self->priv->context;
				_tmp27_ = skk_context_get_candidates (_tmp26_);
				_tmp28_ = _tmp27_;
				retval = skk_candidate_list_page_down (_tmp28_);
				break;
			}
			case SKK_KEYSYMS_Up:
			case SKK_KEYSYMS_Left:
			{
				SkkContext* _tmp29_;
				SkkCandidateList* _tmp30_;
				SkkCandidateList* _tmp31_;
				_tmp29_ = self->priv->context;
				_tmp30_ = skk_context_get_candidates (_tmp29_);
				_tmp31_ = _tmp30_;
				retval = skk_candidate_list_cursor_up (_tmp31_);
				break;
			}
			case SKK_KEYSYMS_Down:
			case SKK_KEYSYMS_Right:
			{
				SkkContext* _tmp32_;
				SkkCandidateList* _tmp33_;
				SkkCandidateList* _tmp34_;
				_tmp32_ = self->priv->context;
				_tmp33_ = skk_context_get_candidates (_tmp32_);
				_tmp34_ = _tmp33_;
				retval = skk_candidate_list_cursor_down (_tmp34_);
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp35_ = retval;
		if (_tmp35_) {
			client_set_lookup_table_cursor_pos (self);
			client_update_preedit (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean
client_real_filter_key_event (FepGClient* base,
                              guint keyval,
                              guint modifiers)
{
	Client * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	SkkKeyEvent* key = NULL;
	gboolean retval = FALSE;
	SkkContext* _tmp7_;
	SkkKeyEvent* _tmp8_;
	gchar* output = NULL;
	SkkContext* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GError * _inner_error_ = NULL;
	self = (Client*) base;
	_tmp1_ = self->priv->lookup_table_visible;
	if (_tmp1_) {
		_tmp0_ = client_process_lookup_table_key_event (self, keyval, modifiers);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		SkkKeyEvent* _tmp2_ = NULL;
		SkkKeyEvent* _tmp3_;
		SkkKeyEvent* _tmp5_;
		_tmp3_ = skk_key_event_new_from_x_keysym (keyval, (SkkModifierType) modifiers, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				goto __catch8_skk_key_event_format_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (key);
		key = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally8;
	__catch8_skk_key_event_format_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (key);
		return result;
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp6_;
	}
	_tmp7_ = self->priv->context;
	_tmp8_ = key;
	retval = skk_context_process_key_event (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->context;
	_tmp10_ = skk_context_poll_output (_tmp9_);
	output = _tmp10_;
	_tmp11_ = output;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > 0) {
		const gchar* _tmp14_;
		_tmp14_ = output;
		fep_g_client_send_text ((FepGClient*) self, _tmp14_);
	}
	result = retval;
	_g_free0 (output);
	_g_object_unref0 (key);
	return result;
}


static void
client_update_preedit (Client* self)
{
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	Options _tmp4_;
	PreeditStyle _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->preedit);
	self->priv->preedit = _tmp3_;
	_tmp4_ = self->priv->opts;
	_tmp5_ = _tmp4_.preedit_style;
	if (_tmp5_ == PREEDIT_STYLE_ROOT) {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->preedit;
		if (g_strcmp0 (_tmp6_, "") == 0) {
			client_update_status (self);
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = self->priv->preedit;
			fep_g_client_set_status_text ((FepGClient*) self, _tmp7_, NULL);
			_tmp8_ = self->priv->preedit;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (self->priv->status);
			self->priv->status = _tmp9_;
			_g_free0 (self->priv->status_attr);
			self->priv->status_attr = NULL;
		}
	} else {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->preedit;
		fep_g_client_set_cursor_text ((FepGClient*) self, _tmp10_, NULL);
	}
}


static FepGAttribute*
_fep_g_attribute_dup (FepGAttribute* self)
{
	FepGAttribute* dup;
	dup = g_new0 (FepGAttribute, 1);
	memcpy (dup, self, sizeof (FepGAttribute));
	return dup;
}


static gpointer
__fep_g_attribute_dup0 (gpointer self)
{
	return self ? _fep_g_attribute_dup (self) : NULL;
}


static gboolean
_fep_g_attribute_equal (const FepGAttribute * s1,
                        const FepGAttribute * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->value != s2->value) {
		return FALSE;
	}
	if (s1->start_index != s2->start_index) {
		return FALSE;
	}
	if (s1->end_index != s2->end_index) {
		return FALSE;
	}
	return TRUE;
}


static void
client_update_status (Client* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	FepGAttribute* attr = NULL;
	SkkContext* _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	gboolean _tmp14_;
	gboolean _tmp88_ = FALSE;
	const gchar* _tmp89_;
	GString* _tmp90_;
	const gchar* _tmp91_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	attr = NULL;
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_input_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->input_mode = _tmp3_;
	{
		ClientEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = CLIENT_input_mode_labels;
		entry_collection_length1 = G_N_ELEMENTS (CLIENT_input_mode_labels);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (CLIENT_input_mode_labels); entry_it = entry_it + 1) {
			ClientEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				ClientEntry _tmp4_;
				gconstpointer _tmp5_;
				SkkInputMode _tmp6_;
				_tmp4_ = entry;
				_tmp5_ = _tmp4_.key;
				_tmp6_ = self->priv->input_mode;
				if (((SkkInputMode) ((gintptr) _tmp5_)) == _tmp6_) {
					GString* _tmp7_;
					ClientEntry _tmp8_;
					gconstpointer _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp7_ = builder;
					_tmp8_ = entry;
					_tmp9_ = _tmp8_.value;
					_tmp10_ = g_strconcat ("[", (const gchar*) _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, "] ", NULL);
					_tmp13_ = _tmp12_;
					g_string_append (_tmp7_, _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					break;
				}
			}
		}
	}
	_tmp14_ = self->priv->lookup_table_visible;
	if (_tmp14_) {
		guint pages = 0U;
		SkkContext* _tmp15_;
		SkkCandidateList* _tmp16_;
		SkkCandidateList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		SkkContext* _tmp20_;
		SkkCandidateList* _tmp21_;
		SkkCandidateList* _tmp22_;
		guint _tmp23_;
		guint _tmp24_;
		SkkContext* _tmp25_;
		SkkCandidateList* _tmp26_;
		SkkCandidateList* _tmp27_;
		guint _tmp28_;
		guint _tmp29_;
		guint start = 0U;
		guint _tmp30_;
		SkkContext* _tmp31_;
		SkkCandidateList* _tmp32_;
		SkkCandidateList* _tmp33_;
		guint _tmp34_;
		guint _tmp35_;
		SkkContext* _tmp36_;
		SkkCandidateList* _tmp37_;
		SkkCandidateList* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		guint end = 0U;
		guint _tmp41_;
		SkkContext* _tmp42_;
		SkkCandidateList* _tmp43_;
		SkkCandidateList* _tmp44_;
		guint _tmp45_;
		guint _tmp46_;
		SkkContext* _tmp47_;
		SkkCandidateList* _tmp48_;
		SkkCandidateList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		_tmp15_ = self->priv->context;
		_tmp16_ = skk_context_get_candidates (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = skk_candidate_list_get_cursor_pos (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->context;
		_tmp21_ = skk_context_get_candidates (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = skk_candidate_list_get_page_start (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->context;
		_tmp26_ = skk_context_get_candidates (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = skk_candidate_list_get_page_size (_tmp27_);
		_tmp29_ = _tmp28_;
		pages = (_tmp19_ - _tmp24_) / _tmp29_;
		_tmp30_ = pages;
		_tmp31_ = self->priv->context;
		_tmp32_ = skk_context_get_candidates (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = skk_candidate_list_get_page_size (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->context;
		_tmp37_ = skk_context_get_candidates (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = skk_candidate_list_get_page_start (_tmp38_);
		_tmp40_ = _tmp39_;
		start = (_tmp30_ * _tmp35_) + _tmp40_;
		_tmp41_ = start;
		_tmp42_ = self->priv->context;
		_tmp43_ = skk_context_get_candidates (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = skk_candidate_list_get_page_size (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->context;
		_tmp48_ = skk_context_get_candidates (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = skk_candidate_list_get_size (_tmp49_);
		_tmp51_ = _tmp50_;
		end = MIN (_tmp41_ + _tmp46_, (guint) _tmp51_);
		{
			guint index = 0U;
			guint _tmp52_;
			_tmp52_ = start;
			index = _tmp52_;
			{
				gboolean _tmp53_ = FALSE;
				_tmp53_ = TRUE;
				while (TRUE) {
					guint _tmp55_;
					guint _tmp56_;
					SkkCandidate* candidate = NULL;
					SkkContext* _tmp57_;
					SkkCandidateList* _tmp58_;
					SkkCandidateList* _tmp59_;
					guint _tmp60_;
					SkkCandidate* _tmp61_;
					gchar* text = NULL;
					gchar** _tmp62_;
					gint _tmp62__length1;
					guint _tmp63_;
					guint _tmp64_;
					const gchar* _tmp65_;
					SkkCandidate* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					gchar* _tmp69_;
					guint _tmp70_;
					SkkContext* _tmp71_;
					SkkCandidateList* _tmp72_;
					SkkCandidateList* _tmp73_;
					gint _tmp74_;
					gint _tmp75_;
					GString* _tmp83_;
					const gchar* _tmp84_;
					guint _tmp85_;
					guint _tmp86_;
					if (!_tmp53_) {
						guint _tmp54_;
						_tmp54_ = index;
						index = _tmp54_ + 1;
					}
					_tmp53_ = FALSE;
					_tmp55_ = index;
					_tmp56_ = end;
					if (!(_tmp55_ < _tmp56_)) {
						break;
					}
					_tmp57_ = self->priv->context;
					_tmp58_ = skk_context_get_candidates (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = index;
					_tmp61_ = skk_candidate_list_get (_tmp59_, (gint) _tmp60_);
					candidate = _tmp61_;
					_tmp62_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp62__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp63_ = index;
					_tmp64_ = start;
					_tmp65_ = _tmp62_[_tmp63_ - _tmp64_];
					_tmp66_ = candidate;
					_tmp67_ = skk_candidate_get_text (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = g_strdup_printf ("%s: %s", _tmp65_, _tmp68_);
					text = _tmp69_;
					_tmp70_ = index;
					_tmp71_ = self->priv->context;
					_tmp72_ = skk_context_get_candidates (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = skk_candidate_list_get_cursor_pos (_tmp73_);
					_tmp75_ = _tmp74_;
					if (_tmp70_ == ((guint) _tmp75_)) {
						gint start_index = 0;
						GString* _tmp76_;
						const gchar* _tmp77_;
						gint _tmp78_;
						gint _tmp79_;
						const gchar* _tmp80_;
						FepGAttribute _tmp81_ = {0};
						FepGAttribute* _tmp82_;
						_tmp76_ = builder;
						_tmp77_ = _tmp76_->str;
						start_index = g_utf8_strlen (_tmp77_, (gssize) -1);
						_tmp78_ = start_index;
						_tmp79_ = start_index;
						_tmp80_ = text;
						memset (&_tmp81_, 0, sizeof (FepGAttribute));
						_tmp81_.type = FEP_G_ATTR_TYPE_STANDOUT;
						_tmp81_.value = (guint) 1;
						_tmp81_.start_index = (guint) _tmp78_;
						_tmp81_.end_index = (guint) (_tmp79_ + g_utf8_strlen (_tmp80_, (gssize) -1));
						_tmp82_ = __fep_g_attribute_dup0 (&_tmp81_);
						_g_free0 (attr);
						attr = _tmp82_;
					}
					_tmp83_ = builder;
					_tmp84_ = text;
					g_string_append (_tmp83_, _tmp84_);
					_tmp85_ = index;
					_tmp86_ = end;
					if (_tmp85_ < (_tmp86_ - 1)) {
						GString* _tmp87_;
						_tmp87_ = builder;
						g_string_append_c (_tmp87_, ' ');
					}
					_g_free0 (text);
					_g_object_unref0 (candidate);
				}
			}
		}
	}
	_tmp89_ = self->priv->status;
	_tmp90_ = builder;
	_tmp91_ = _tmp90_->str;
	if (g_strcmp0 (_tmp89_, _tmp91_) != 0) {
		_tmp88_ = TRUE;
	} else {
		FepGAttribute* _tmp92_;
		FepGAttribute* _tmp93_;
		_tmp92_ = self->priv->status_attr;
		_tmp93_ = attr;
		_tmp88_ = _fep_g_attribute_equal (_tmp92_, _tmp93_) != TRUE;
	}
	if (_tmp88_) {
		GString* _tmp94_;
		const gchar* _tmp95_;
		FepGAttribute* _tmp96_;
		GString* _tmp97_;
		const gchar* _tmp98_;
		gchar* _tmp99_;
		FepGAttribute* _tmp100_;
		FepGAttribute* _tmp101_;
		_tmp94_ = builder;
		_tmp95_ = _tmp94_->str;
		_tmp96_ = attr;
		fep_g_client_set_status_text ((FepGClient*) self, _tmp95_, _tmp96_);
		_tmp97_ = builder;
		_tmp98_ = _tmp97_->str;
		_tmp99_ = g_strdup (_tmp98_);
		_g_free0 (self->priv->status);
		self->priv->status = _tmp99_;
		_tmp100_ = attr;
		_tmp101_ = __fep_g_attribute_dup0 (_tmp100_);
		_g_free0 (self->priv->status_attr);
		self->priv->status_attr = _tmp101_;
	}
	_g_free0 (attr);
	_g_string_free0 (builder);
}


static void
client_populate_lookup_table (Client* self)
{
	g_return_if_fail (self != NULL);
}


static void
client_set_lookup_table_cursor_pos (Client* self)
{
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = skk_candidate_list_get_page_visible (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		self->priv->lookup_table_visible = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = self->priv->lookup_table_visible;
		if (_tmp5_) {
			self->priv->lookup_table_visible = FALSE;
		}
	}
	client_update_status (self);
	_tmp7_ = self->priv->lookup_table_visible;
	if (!_tmp7_) {
		Options _tmp8_;
		PreeditStyle _tmp9_;
		_tmp8_ = self->priv->opts;
		_tmp9_ = _tmp8_.preedit_style;
		_tmp6_ = _tmp9_ == PREEDIT_STYLE_ROOT;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		client_update_preedit (self);
	}
}


static gboolean
client_watch_func (Client* self,
                   GIOChannel* source,
                   GIOCondition condition)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	fep_g_client_dispatch ((FepGClient*) self);
	result = TRUE;
	return result;
}


static void
__lambda5_ (Client* self)
{
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->preedit;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		client_update_preedit (self);
	}
}


static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda5_ ((Client*) self);
}


static void
__lambda6_ (Client* self)
{
	SkkContext* _tmp0_;
	SkkInputMode _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_input_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->input_mode;
	if (_tmp2_ != _tmp3_) {
		client_update_status (self);
	}
}


static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((Client*) self);
}


static void
__lambda7_ (Client* self)
{
	client_populate_lookup_table (self);
}


static void
___lambda7__skk_candidate_list_populated (SkkCandidateList* _sender,
                                          gpointer self)
{
	__lambda7_ ((Client*) self);
}


static void
__lambda8_ (Client* self)
{
	client_set_lookup_table_cursor_pos (self);
}


static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((Client*) self);
}


static void
__lambda9_ (Client* self)
{
	gchar* output = NULL;
	SkkContext* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Options _tmp6_;
	PreeditStyle _tmp7_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		const gchar* _tmp5_;
		_tmp5_ = output;
		fep_g_client_send_text ((FepGClient*) self, _tmp5_);
	}
	self->priv->lookup_table_visible = FALSE;
	client_update_status (self);
	_tmp6_ = self->priv->opts;
	_tmp7_ = _tmp6_.preedit_style;
	if (_tmp7_ == PREEDIT_STYLE_ROOT) {
		client_update_preedit (self);
	}
	_g_free0 (output);
}


static void
___lambda9__skk_candidate_list_selected (SkkCandidateList* _sender,
                                         SkkCandidate* candidate,
                                         gpointer self)
{
	__lambda9_ ((Client*) self);
}


static gboolean
_client_watch_func_gio_func (GIOChannel* source,
                             GIOCondition condition,
                             gpointer self)
{
	gboolean result;
	result = client_watch_func ((Client*) self, source, condition);
	return result;
}


gboolean
client_run (Client* self)
{
	gboolean result = FALSE;
	SkkContext* _tmp0_;
	SkkContext* _tmp1_;
	SkkContext* _tmp2_;
	SkkCandidateList* _tmp3_;
	SkkCandidateList* _tmp4_;
	SkkContext* _tmp5_;
	SkkCandidateList* _tmp6_;
	SkkCandidateList* _tmp7_;
	SkkContext* _tmp8_;
	SkkCandidateList* _tmp9_;
	SkkCandidateList* _tmp10_;
	GIOChannel* channel = NULL;
	GIOChannel* _tmp11_;
	GMainLoop* loop = NULL;
	GMainLoop* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::preedit", (GCallback) ___lambda5__g_object_notify, self, 0);
	_tmp1_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::input-mode", (GCallback) ___lambda6__g_object_notify, self, 0);
	_tmp2_ = self->priv->context;
	_tmp3_ = skk_context_get_candidates (_tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_connect_object (_tmp4_, "populated", (GCallback) ___lambda7__skk_candidate_list_populated, self, 0);
	_tmp5_ = self->priv->context;
	_tmp6_ = skk_context_get_candidates (_tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::cursor-pos", (GCallback) ___lambda8__g_object_notify, self, 0);
	_tmp8_ = self->priv->context;
	_tmp9_ = skk_context_get_candidates (_tmp8_);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "selected", (GCallback) ___lambda9__skk_candidate_list_selected, self, 0);
	client_update_preedit (self);
	client_update_status (self);
	_tmp11_ = g_io_channel_unix_new (fep_g_client_get_poll_fd ((FepGClient*) self));
	channel = _tmp11_;
	g_io_add_watch (channel, G_IO_IN, _client_watch_func_gio_func, self);
	_tmp12_ = g_main_loop_new (NULL, TRUE);
	loop = _tmp12_;
	g_main_loop_run (loop);
	result = TRUE;
	_g_main_loop_unref0 (loop);
	_g_io_channel_unref0 (channel);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


Client*
client_construct (GType object_type,
                  SkkContext* context,
                  Options* opts,
                  GError** error)
{
	Client * self = NULL;
	SkkContext* _tmp0_;
	Options _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (opts != NULL, NULL);
	self = (Client*) g_object_new (object_type, "address", NULL, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = *opts;
	self->priv->opts = _tmp1_;
	return self;
}


Client*
client_new (SkkContext* context,
            Options* opts,
            GError** error)
{
	return client_construct (TYPE_CLIENT, context, opts, error);
}


static void
client_entry_copy (const ClientEntry* self,
                   ClientEntry* dest)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	(*dest).value = _tmp1_;
}


static void
client_entry_destroy (ClientEntry* self)
{
}


static ClientEntry*
client_entry_dup (const ClientEntry* self)
{
	ClientEntry* dup;
	dup = g_new0 (ClientEntry, 1);
	client_entry_copy (self, dup);
	return dup;
}


static void
client_entry_free (ClientEntry* self)
{
	client_entry_destroy (self);
	g_free (self);
}


static GType
client_entry_get_type (void)
{
	static volatile gsize client_entry_type_id__volatile = 0;
	if (g_once_init_enter (&client_entry_type_id__volatile)) {
		GType client_entry_type_id;
		client_entry_type_id = g_boxed_type_register_static ("ClientEntry", (GBoxedCopyFunc) client_entry_dup, (GBoxedFreeFunc) client_entry_free);
		g_once_init_leave (&client_entry_type_id__volatile, client_entry_type_id);
	}
	return client_entry_type_id__volatile;
}


static void
client_class_init (ClientClass * klass)
{
	client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClientPrivate));
	((FepGClientClass *) klass)->filter_key_event = (gboolean (*) (FepGClient *, guint, guint)) client_real_filter_key_event;
	G_OBJECT_CLASS (klass)->finalize = client_finalize;
}


static void
client_instance_init (Client * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	self->priv = CLIENT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("a");
	_tmp1_ = g_strdup ("s");
	_tmp2_ = g_strdup ("d");
	_tmp3_ = g_strdup ("f");
	_tmp4_ = g_strdup ("j");
	_tmp5_ = g_strdup ("k");
	_tmp6_ = g_strdup ("l");
	_tmp7_ = g_strdup ("q");
	_tmp8_ = g_strdup ("w");
	_tmp9_ = g_strdup ("e");
	_tmp10_ = g_strdup ("r");
	_tmp11_ = g_strdup ("u");
	_tmp12_ = g_strdup ("i");
	_tmp13_ = g_strdup ("o");
	_tmp14_ = g_new0 (gchar*, 14 + 1);
	_tmp14_[0] = _tmp0_;
	_tmp14_[1] = _tmp1_;
	_tmp14_[2] = _tmp2_;
	_tmp14_[3] = _tmp3_;
	_tmp14_[4] = _tmp4_;
	_tmp14_[5] = _tmp5_;
	_tmp14_[6] = _tmp6_;
	_tmp14_[7] = _tmp7_;
	_tmp14_[8] = _tmp8_;
	_tmp14_[9] = _tmp9_;
	_tmp14_[10] = _tmp10_;
	_tmp14_[11] = _tmp11_;
	_tmp14_[12] = _tmp12_;
	_tmp14_[13] = _tmp13_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp14_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 14;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
	self->priv->lookup_table_visible = FALSE;
	_tmp15_ = g_strdup ("");
	self->priv->preedit = _tmp15_;
	_tmp16_ = g_strdup ("");
	self->priv->status = _tmp16_;
	self->priv->status_attr = NULL;
	self->priv->input_mode = SKK_INPUT_MODE_HIRAGANA;
}


static void
client_finalize (GObject * obj)
{
	Client * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLIENT, Client);
	_g_object_unref0 (self->priv->context);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->preedit);
	_g_free0 (self->priv->status);
	_g_free0 (self->priv->status_attr);
	G_OBJECT_CLASS (client_parent_class)->finalize (obj);
}


GType
client_get_type (void)
{
	static volatile gsize client_type_id__volatile = 0;
	if (g_once_init_enter (&client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Client), 0, (GInstanceInitFunc) client_instance_init, NULL };
		GType client_type_id;
		client_type_id = g_type_register_static (fep_g_client_get_type (), "Client", &g_define_type_info, 0);
		g_once_init_leave (&client_type_id__volatile, client_type_id);
	}
	return client_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



