/* Copyright 2003,2006,2018
     Free Software Foundation, Inc.

   This file is part of Guile.

   Guile is free software: you can redistribute it and/or modify it
   under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Guile is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
   License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with Guile.  If not, see
   <https://www.gnu.org/licenses/>.  */
/* This file is automatically generated -- see configure.in for details */

#ifndef SCM_SCMCONFIG_H
#define SCM_SCMCONFIG_H

/* Important headers */
#include <stdint.h>
#include <stddef.h>
#include <limits.h>
#include <sys/time.h>
#include <time.h>

#define SCM_HAVE_STDC_HEADERS 1 /* 0 or 1 */
#include <stdlib.h>
#include <sys/types.h>
#include <stddef.h>

#define SCM_HAVE_SYS_SELECT_H 1 /* 0 or 1 */
#define SCM_HAVE_WINSOCK2_H 0 /* 0 or 1 */

/* Define to include various undocumented debugging functions. */
/* #undef GUILE_DEBUG */

/* Set to 1 if you want to enable deprecated features. */
/* (value will be 0 or 1). */
#define SCM_ENABLE_DEPRECATED 1

/* Set to 1 if the stack grows up, 0 otherwise. */
#define SCM_STACK_GROWS_UP 0 /* 0 or 1 */

/* C compiler's syntax for inline functions if any,
   otherwise undefined. */
#define SCM_C_INLINE inline

/* Standard types. */
#define SCM_SIZEOF_CHAR 1
#define SCM_SIZEOF_UNSIGNED_CHAR 1
#define SCM_SIZEOF_SHORT 2
#define SCM_SIZEOF_UNSIGNED_SHORT 2
#define SCM_SIZEOF_LONG 4
#define SCM_SIZEOF_UNSIGNED_LONG 4
#define SCM_SIZEOF_INT 4
#define SCM_SIZEOF_UNSIGNED_INT 4
#define SCM_SIZEOF_SIZE_T 4
#define SCM_SIZEOF_LONG_LONG 8
#define SCM_SIZEOF_UNSIGNED_LONG_LONG 8
#define SCM_SIZEOF_INTMAX 8
#define SCM_SIZEOF_SCM_T_PTRDIFF 4
#define SCM_SIZEOF_INTPTR_T 4
#define SCM_SIZEOF_UINTPTR_T 4

/* same as POSIX "struct timespec" -- always defined */
typedef struct timespec scm_t_timespec;

/*** Threading model (scmconfig.h support not finished) ***/
/* Define to 1 if using pthread multithreading. */
#define SCM_USE_PTHREAD_THREADS 1 /* 0 or 1 */
/* Define to 1 if using one-thread 'multi'threading. */
#define SCM_USE_NULL_THREADS 0 /* 0 or 1 */
/* Define to 1 if need braces around PTHREAD_ONCE_INIT (for Solaris). */
#define SCM_NEED_BRACES_ON_PTHREAD_ONCE_INIT 0 /* 0 or 1 */
/* Define to 1 if need braces around PTHREAD_MUTEX_INITIALIZER
   (for IRIX with GCC)  */
#define SCM_NEED_BRACES_ON_PTHREAD_MUTEX_INITIALIZER 0 /* 0 or 1 */
#define SCM_HAVE_PTHREAD_SIGMASK 1 /* 0 or 1 */
#define SCM_HAVE_GC_PTHREAD_CANCEL 0 /* 0 or 1 */
#define SCM_HAVE_GC_PTHREAD_EXIT 0 /* 0 or 1 */
#define SCM_HAVE_GC_PTHREAD_SIGMASK 1 /* 0 or 1 */


/*** File system access ***/
/* Define to 1 if `struct dirent64' is available.  */
#define SCM_HAVE_STRUCT_DIRENT64 0 /* 0 or 1 */
/* Define to 1 if `readdir64_r ()' is available.  */
#define SCM_HAVE_READDIR64_R 0 /* 0 or 1 */
typedef long int scm_t_off;
#define SCM_T_OFF_MAX LONG_MAX
#define SCM_T_OFF_MIN LONG_MIN
/* Define to 1 if the compiler supports the `__thread' storage class.  */
#define SCM_HAVE_THREAD_STORAGE_CLASS

/* Constants from uniconv.h.  */
#define SCM_ICONVEH_ERROR 0
#define SCM_ICONVEH_QUESTION_MARK 1
#define SCM_ICONVEH_ESCAPE_SEQUENCE 2

/* Define to 1 if there is an auxiliary stack, as in ia64.  */
#define SCM_HAVE_AUXILIARY_STACK 0

/* Define to 1 to use mini GMP.  */
#define SCM_ENABLE_MINI_GMP 0
#endif
