/* gmpc-nowplaying2.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-nowplaying2.vala, do not modify */

/* Gnome Music Player Client
 * Copyright (C) 2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <gdk/gdk.h>
#include <plugin.h>
#include <config1.h>
#include <libmpd/libmpd.h>
#include <glib/gi18n-lib.h>
#include <metadata.h>
#include <libmpd/libmpdclient.h>
#include <misc.h>
#include <gmpc-metaimage.h>
#include <pango/pango.h>
#include <mpdinteraction.h>
#include <libmpd/libmpd-internal.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <main.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define GMPC_META_DATA_WIDGETS_TYPE_BACKDROP (gmpc_meta_data_widgets_backdrop_get_type ())
#define GMPC_META_DATA_WIDGETS_BACKDROP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdrop))
#define GMPC_META_DATA_WIDGETS_BACKDROP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdropClass))
#define GMPC_META_DATA_WIDGETS_IS_BACKDROP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP))
#define GMPC_META_DATA_WIDGETS_IS_BACKDROP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP))
#define GMPC_META_DATA_WIDGETS_BACKDROP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GMPC_META_DATA_WIDGETS_TYPE_BACKDROP, GmpcMetaDataWidgetsBackdropClass))

typedef struct _GmpcMetaDataWidgetsBackdrop GmpcMetaDataWidgetsBackdrop;
typedef struct _GmpcMetaDataWidgetsBackdropClass GmpcMetaDataWidgetsBackdropClass;
typedef struct _Block27Data Block27Data;
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _Block30Data Block30Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;
typedef struct _Block34Data Block34Data;
#define _mpd_data_free0(var) ((var == NULL) ? NULL : (var = (mpd_data_free (var), NULL)))
typedef struct _Block35Data Block35Data;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

struct _GmpcBrowsersNowplayingPrivate {
	gboolean theme_colors;
	gchar* title_color;
	gchar* item_color;
	GdkColor background;
	GdkColor foreground;
	GtkLabel* bitrate_label;
	GtkTreeRowReference* np_ref;
	gboolean use_backdrop;
	GtkScrolledWindow* paned;
	GtkEventBox* container;
	gboolean selected;
	gchar* song_checksum;
};

struct _Block27Data {
	int _ref_count_;
	GmpcBrowsersNowplaying * self;
	mpd_Song* song;
	GtkNotebook* notebook;
};

struct _Block28Data {
	int _ref_count_;
	Block27Data * _data27_;
	gint j;
};

struct _Block29Data {
	int _ref_count_;
	Block27Data * _data27_;
	GtkAlignment* alib;
	gboolean text_view_queried;
	gint j;
};

struct _Block30Data {
	int _ref_count_;
	Block27Data * _data27_;
	gboolean similar_songs_queried;
	GtkAlignment* similar_songs_box;
	gint j;
};

struct _Block31Data {
	int _ref_count_;
	Block27Data * _data27_;
	GmpcMetaDataWidgetsSimilarArtists* similar_artist;
	gint j;
};

struct _Block32Data {
	int _ref_count_;
	Block27Data * _data27_;
	gint j;
};

struct _Block33Data {
	int _ref_count_;
	Block27Data * _data27_;
	GtkAlignment* alib;
	gboolean text_view_queried;
	gint j;
};

struct _Block34Data {
	int _ref_count_;
	Block27Data * _data27_;
	GtkAlignment* alib;
	gboolean text_view_queried;
	gint j;
	GmpcWidgetsSonglist* sl;
};

struct _Block35Data {
	int _ref_count_;
	Block27Data * _data27_;
	mpd_Song* but_song;
};


static gpointer gmpc_browsers_nowplaying_parent_class = NULL;
static GmpcPluginBrowserIfaceIface* gmpc_browsers_nowplaying_gmpc_plugin_browser_iface_parent_iface = NULL;

#define use_transition_mb2 TRUE
#define some_unique_name_mb2 VERSION
#define np2_LOG_DOMAIN "NowPlaying"
#define GMPC_BROWSERS_NOWPLAYING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_BROWSERS_TYPE_NOWPLAYING, GmpcBrowsersNowplayingPrivate))
enum  {
	GMPC_BROWSERS_NOWPLAYING_DUMMY_PROPERTY
};
static gint* gmpc_browsers_nowplaying_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_browsers_nowplaying_real_get_name (GmpcPluginBase* base);
static void gmpc_browsers_nowplaying_real_set_enabled (GmpcPluginBase* base, gboolean state);
static void gmpc_browsers_nowplaying_browser_init (GmpcBrowsersNowplaying* self);
static void gmpc_browsers_nowplaying_real_save_yourself (GmpcPluginBase* base);
static void gmpc_browsers_nowplaying_status_changed (GmpcBrowsersNowplaying* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what);
static void gmpc_browsers_nowplaying_update (GmpcBrowsersNowplaying* self);
static void gmpc_browsers_nowplaying_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree);
static void gmpc_browsers_nowplaying_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_browsers_nowplaying_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_browsers_nowplaying_browser_bg_style_changed (GmpcBrowsersNowplaying* self, GtkWidget* bg, GtkStyle* style);
static void gmpc_browsers_nowplaying_change_color_style (GmpcBrowsersNowplaying* self, GtkWidget* bg);
GmpcMetaDataWidgetsBackdrop* gmpc_meta_data_widgets_backdrop_new (MetaDataType type);
GmpcMetaDataWidgetsBackdrop* gmpc_meta_data_widgets_backdrop_construct (GType object_type, MetaDataType type);
GType gmpc_meta_data_widgets_backdrop_get_type (void) G_GNUC_CONST;
static void _gmpc_browsers_nowplaying_browser_bg_style_changed_gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self);
static void gmpc_browsers_nowplaying_clear (GmpcBrowsersNowplaying* self);
static gchar* gmpc_browsers_nowplaying_get_extension (GmpcBrowsersNowplaying* self, const gchar* path);
static void gmpc_browsers_nowplaying_update_playing (GmpcBrowsersNowplaying* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (Block27Data* _data27_);
void gmpc_meta_data_widgets_backdrop_set_song (GmpcMetaDataWidgetsBackdrop* self, const mpd_Song* song);
static void gmpc_browsers_nowplaying_update_not_playing (GmpcBrowsersNowplaying* self);
static gboolean _lambda79_ (GtkWidget* widget, GdkEventButton* event, GmpcBrowsersNowplaying* self);
static gboolean __lambda79__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda80_ (GtkWidget* widget, GdkEventButton* event, GmpcBrowsersNowplaying* self);
static gboolean __lambda80__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (Block28Data* _data28_);
static void _lambda81_ (GtkButton* source, Block28Data* _data28_);
static void __lambda81__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (Block29Data* _data29_);
static void _lambda82_ (GtkButton* source, Block29Data* _data29_);
static void __lambda82__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (Block30Data* _data30_);
static void _lambda83_ (GtkButton* source, Block30Data* _data30_);
static void __lambda83__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (Block31Data* _data31_);
static void _lambda84_ (GtkButton* source, Block31Data* _data31_);
static void __lambda84__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (Block32Data* _data32_);
static void _lambda85_ (GtkButton* source, Block32Data* _data32_);
static void __lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (Block33Data* _data33_);
static void _lambda86_ (GtkButton* source, Block33Data* _data33_);
static void __lambda86__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (Block34Data* _data34_);
static void _lambda87_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersNowplaying* self);
static void __lambda87__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda88_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersNowplaying* self);
static void __lambda88__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self);
static void _lambda89_ (GtkButton* source, Block34Data* _data34_);
static void __lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda90_ (GObject* source, GParamSpec* spec, Block27Data* _data27_);
static void __lambda90__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (Block35Data* _data35_);
static void _lambda91_ (GtkButton* source, Block35Data* _data35_);
static void __lambda91__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gint gmpc_browsers_nowplaying_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu);
static void _gmpc_browsers_nowplaying_select_now_playing_browser_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static GObject * gmpc_browsers_nowplaying_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gmpc_browsers_nowplaying_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self);
static void _lambda92_ (MpdObj* source, gint connect, GmpcBrowsersNowplaying* self);
static void __lambda92__gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self);
static void gmpc_browsers_nowplaying_finalize (GObject* obj);

static const gint GMPC_BROWSERS_NOWPLAYING_version[3] = {0, 0, 0};

static gint* gmpc_browsers_nowplaying_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcBrowsersNowplaying * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcBrowsersNowplaying*) base;
	_tmp0_ = GMPC_BROWSERS_NOWPLAYING_version;
	*result_length1 = G_N_ELEMENTS (GMPC_BROWSERS_NOWPLAYING_version);
	result = _tmp0_;
	return result;
}


static const gchar* gmpc_browsers_nowplaying_real_get_name (GmpcPluginBase* base) {
	GmpcBrowsersNowplaying * self;
	const gchar* result = NULL;
	self = (GmpcBrowsersNowplaying*) base;
	result = "Now Playing";
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gmpc_browsers_nowplaying_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcBrowsersNowplaying * self;
	const gchar* _tmp8_ = NULL;
	self = (GmpcBrowsersNowplaying*) base;
	if (state) {
		if (self->priv->paned == NULL) {
			GtkTreeView* _tmp0_ = NULL;
			_tmp0_ = playlist3_get_category_tree_view ();
			gmpc_plugin_browser_iface_browser_add ((GmpcPluginBrowserIface*) self, (GtkWidget*) _tmp0_);
			gmpc_browsers_nowplaying_browser_init (self);
		}
	} else {
		if (self->priv->np_ref != NULL) {
			GtkTreePath* _tmp1_ = NULL;
			GtkTreePath* path;
			_tmp1_ = gtk_tree_row_reference_get_path (self->priv->np_ref);
			path = _tmp1_;
			if (path != NULL) {
				gint* _tmp2_ = NULL;
				gint* indices;
				gint indices_length1;
				gint _indices_size_;
				const gchar* _tmp3_ = NULL;
				GtkTreeModel* _tmp4_ = NULL;
				GtkListStore* _tmp5_;
				GtkListStore* model;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp6_ = {0};
				gboolean _tmp7_;
				_tmp2_ = gtk_tree_path_get_indices (path);
				indices = _tmp2_;
				indices_length1 = -1;
				_indices_size_ = -1;
				_tmp3_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
				cfg_set_single_value_as_int (config, _tmp3_, "position", indices[0]);
				_tmp4_ = gtk_tree_row_reference_get_model (self->priv->np_ref);
				_tmp5_ = _g_object_ref0 (GTK_LIST_STORE (_tmp4_));
				model = _tmp5_;
				_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) model, &_tmp6_, path);
				iter = _tmp6_;
				if (_tmp7_) {
					gtk_list_store_remove (model, &iter);
				}
				_g_object_unref0 (model);
			}
			_gtk_tree_path_free0 (path);
		}
		if (self->priv->paned != NULL) {
			gtk_object_destroy ((GtkObject*) self->priv->paned);
			_g_object_unref0 (self->priv->paned);
			self->priv->paned = NULL;
			_g_free0 (self->priv->song_checksum);
			self->priv->song_checksum = NULL;
		}
	}
	_tmp8_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
		cfg_set_single_value_as_int (config, _tmp9_, "enabled", (gint) state);
	}
}


static void gmpc_browsers_nowplaying_real_save_yourself (GmpcPluginBase* base) {
	GmpcBrowsersNowplaying * self;
	self = (GmpcBrowsersNowplaying*) base;
	if (self->priv->np_ref != NULL) {
		GtkTreePath* _tmp0_ = NULL;
		GtkTreePath* path;
		_tmp0_ = gtk_tree_row_reference_get_path (self->priv->np_ref);
		path = _tmp0_;
		if (path != NULL) {
			gint* _tmp1_ = NULL;
			gint* indices;
			gint indices_length1;
			gint _indices_size_;
			const gchar* _tmp2_ = NULL;
			_tmp1_ = gtk_tree_path_get_indices (path);
			indices = _tmp1_;
			indices_length1 = -1;
			_indices_size_ = -1;
			_tmp2_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
			cfg_set_single_value_as_int (config, _tmp2_, "position", indices[0]);
		}
		_gtk_tree_path_free0 (path);
	}
}


static void gmpc_browsers_nowplaying_status_changed (GmpcBrowsersNowplaying* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (!_tmp0_) {
		return;
	}
	if (!self->priv->selected) {
		return;
	}
	if ((what & MPD_CST_STATE) == MPD_CST_STATE) {
		gmpc_browsers_nowplaying_update (self);
	} else {
		if ((what & (MPD_CST_SONGID | MPD_CST_PLAYLIST)) > 0) {
			gmpc_browsers_nowplaying_update (self);
		}
	}
	if ((what & (MPD_CST_BITRATE | MPD_CST_AUDIOFORMAT)) > 0) {
		if (self->priv->bitrate_label != NULL) {
			gint _tmp1_;
			gint channels;
			gint _tmp2_;
			gint bitrate;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gint _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp1_ = mpd_status_get_channels (connection);
			channels = _tmp1_;
			g_debug ("gmpc-nowplaying2.vala:151: bitrate changed");
			_tmp2_ = mpd_status_get_bitrate (connection);
			bitrate = _tmp2_;
			_tmp3_ = _ ("Format");
			_tmp4_ = ngettext ("Channel", "Channels", (gulong) channels);
			_tmp5_ = mpd_status_get_samplerate (connection);
			_tmp6_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %i %s, %.1f %s, %i %s", self->priv->item_color, _tmp3_, channels, _tmp4_, _tmp5_ / 1000.0, "kHz", bitrate, "kbps");
			_tmp7_ = _tmp6_;
			gtk_label_set_markup (self->priv->bitrate_label, _tmp7_);
			_g_free0 (_tmp7_);
		}
	}
}


/**
             * Browser Interface bindings
             */
static void gmpc_browsers_nowplaying_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree) {
	GmpcBrowsersNowplaying * self;
	GtkTreeView* _tmp0_;
	GtkTreeView* tree;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_;
	GtkListStore* store;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	const gchar* _tmp5_ = NULL;
	gint _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	GtkTreePath* _tmp9_ = NULL;
	GtkTreePath* _tmp10_;
	GtkTreeRowReference* _tmp11_ = NULL;
	self = (GmpcBrowsersNowplaying*) base;
	g_return_if_fail (category_tree != NULL);
	_tmp0_ = _g_object_ref0 (GTK_TREE_VIEW (category_tree));
	tree = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (tree);
	_tmp2_ = _g_object_ref0 (GTK_LIST_STORE (_tmp1_));
	store = _tmp2_;
	_tmp3_ = gtk_tree_view_get_model (tree);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	model = _tmp4_;
	_tmp5_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp6_ = cfg_get_single_value_as_int_with_default (config, _tmp5_, "position", 0);
	playlist3_insert_browser (&_tmp7_, _tmp6_);
	iter = _tmp7_;
	_tmp8_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	gtk_list_store_set (store, &iter, 0, ((GmpcPluginBase*) self)->id, 1, _tmp8_, 3, "media-audiofile", -1);
	_tmp9_ = gtk_tree_model_get_path (model, &iter);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_tree_row_reference_new (model, _tmp10_);
	_gtk_tree_row_reference_free0 (self->priv->np_ref);
	self->priv->np_ref = _tmp11_;
	_gtk_tree_path_free0 (_tmp10_);
	_g_object_unref0 (model);
	_g_object_unref0 (store);
	_g_object_unref0 (tree);
}


static void gmpc_browsers_nowplaying_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcBrowsersNowplaying * self;
	self = (GmpcBrowsersNowplaying*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = TRUE;
	gmpc_browsers_nowplaying_browser_init (self);
	gtk_container_add (container, (GtkWidget*) self->priv->paned);
	gtk_widget_show_all ((GtkWidget*) container);
	gtk_widget_ensure_style ((GtkWidget*) container);
	if (self->priv->theme_colors) {
		GtkStyle* _tmp0_ = NULL;
		GdkColor _tmp1_;
		gchar* _tmp2_ = NULL;
		GtkStyle* _tmp3_ = NULL;
		GdkColor _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
		_tmp1_ = _tmp0_->text[GTK_STATE_PRELIGHT];
		_tmp2_ = gdk_color_to_string (&_tmp1_);
		_g_free0 (self->priv->title_color);
		self->priv->title_color = _tmp2_;
		_tmp3_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
		_tmp4_ = _tmp3_->text[GTK_STATE_PRELIGHT];
		_tmp5_ = gdk_color_to_string (&_tmp4_);
		_g_free0 (self->priv->item_color);
		self->priv->item_color = _tmp5_;
	}
	if (self->priv->use_backdrop) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup ("#fff");
		_g_free0 (self->priv->title_color);
		self->priv->title_color = _tmp6_;
		_tmp7_ = g_strdup ("#fff");
		_g_free0 (self->priv->item_color);
		self->priv->item_color = _tmp7_;
		self->priv->theme_colors = FALSE;
	}
	gmpc_browsers_nowplaying_update (self);
}


static void gmpc_browsers_nowplaying_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcBrowsersNowplaying * self;
	self = (GmpcBrowsersNowplaying*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = FALSE;
	gtk_container_remove (container, (GtkWidget*) self->priv->paned);
}


/**
             * If the style changed because f.e. the user switched theme, make sure the correct colouring is kept preserved.
             */
static void gmpc_browsers_nowplaying_browser_bg_style_changed (GmpcBrowsersNowplaying* self, GtkWidget* bg, GtkStyle* style) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-nowplaying2.vala:220: Change style signal");
	if (self->priv->theme_colors) {
		GtkStyle* _tmp0_ = NULL;
		GdkColor _tmp1_;
		gchar* _tmp2_ = NULL;
		GtkStyle* _tmp3_ = NULL;
		GdkColor _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
		_tmp1_ = _tmp0_->text[GTK_STATE_PRELIGHT];
		_tmp2_ = gdk_color_to_string (&_tmp1_);
		_g_free0 (self->priv->title_color);
		self->priv->title_color = _tmp2_;
		_tmp3_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
		_tmp4_ = _tmp3_->text[GTK_STATE_PRELIGHT];
		_tmp5_ = gdk_color_to_string (&_tmp4_);
		_g_free0 (self->priv->item_color);
		self->priv->item_color = _tmp5_;
	}
	gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) self->priv->container);
}


/**
             * Recursively force  a style on widget bg and children.
             */
static void gmpc_browsers_nowplaying_change_color_style (GmpcBrowsersNowplaying* self, GtkWidget* bg) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-nowplaying2.vala:232: change style");
	if (GTK_IS_SEPARATOR (bg)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = GTK_IS_NOTEBOOK (bg);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = GTK_IS_CHECK_BUTTON (bg);
	}
	if (_tmp0_) {
	} else {
		if (self->priv->theme_colors) {
			GtkStyle* _tmp2_ = NULL;
			GdkColor _tmp3_;
			_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned);
			_tmp3_ = _tmp2_->base[GTK_STATE_NORMAL];
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, &_tmp3_);
		} else {
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_base (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_text (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_text (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
		}
	}
	if (GTK_IS_CONTAINER (bg)) {
		GList* _tmp4_ = NULL;
		_tmp4_ = gtk_container_get_children (GTK_CONTAINER (bg));
		{
			GList* child_collection;
			GList* child_it;
			child_collection = _tmp4_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp5_;
				GtkWidget* child;
				_tmp5_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp5_;
				{
					gmpc_browsers_nowplaying_change_color_style (self, child);
					_g_object_unref0 (child);
				}
			}
			_g_list_free0 (child_collection);
		}
	}
}


static void _gmpc_browsers_nowplaying_browser_bg_style_changed_gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self) {
	gmpc_browsers_nowplaying_browser_bg_style_changed (self, _sender, previous_style);
}


static void gmpc_browsers_nowplaying_browser_init (GmpcBrowsersNowplaying* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->paned == NULL) {
		GtkScrolledWindow* _tmp0_ = NULL;
		GtkAdjustment* _tmp3_ = NULL;
		_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		_g_object_unref0 (self->priv->paned);
		self->priv->paned = g_object_ref_sink (_tmp0_);
		gtk_scrolled_window_set_policy (self->priv->paned, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (self->priv->paned, GTK_SHADOW_NONE);
		if (self->priv->use_backdrop) {
			GmpcMetaDataWidgetsBackdrop* _tmp1_ = NULL;
			_tmp1_ = gmpc_meta_data_widgets_backdrop_new (META_ARTIST_ART);
			_g_object_unref0 (self->priv->container);
			self->priv->container = (GtkEventBox*) g_object_ref_sink (_tmp1_);
		} else {
			GtkEventBox* _tmp2_ = NULL;
			_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
			_g_object_unref0 (self->priv->container);
			self->priv->container = g_object_ref_sink (_tmp2_);
		}
		g_signal_connect_object ((GtkWidget*) self->priv->paned, "style-set", (GCallback) _gmpc_browsers_nowplaying_browser_bg_style_changed_gtk_widget_style_set, self, 0);
		gtk_scrolled_window_add_with_viewport (self->priv->paned, (GtkWidget*) self->priv->container);
		_tmp3_ = gtk_scrolled_window_get_vadjustment (self->priv->paned);
		g_object_set ((GObject*) _tmp3_, "step-increment", 20.0, NULL);
		gtk_widget_show_all ((GtkWidget*) self->priv->paned);
	}
}


static void gmpc_browsers_nowplaying_clear (GmpcBrowsersNowplaying* self) {
	GList* _tmp0_ = NULL;
	GList* list;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->container);
	list = _tmp0_;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = list;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				gtk_object_destroy ((GtkObject*) child);
				_g_object_unref0 (child);
			}
		}
	}
	_g_object_unref0 (self->priv->bitrate_label);
	self->priv->bitrate_label = NULL;
	_g_list_free0 (list);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* gmpc_browsers_nowplaying_get_extension (GmpcBrowsersNowplaying* self, const gchar* path) {
	gchar* result = NULL;
	gint _tmp0_;
	glong length;
	glong i;
	gchar* retv;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	length = (glong) _tmp0_;
	i = length;
	retv = NULL;
	{
		gboolean _tmp1_;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar _tmp3_;
			if (!_tmp1_) {
				i--;
			}
			_tmp1_ = FALSE;
			if (i > 0) {
				_tmp2_ = (length - i) < 8;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = string_get (path, i);
			if (_tmp3_ == '.') {
				gchar* _tmp4_ = NULL;
				_tmp4_ = string_substring (path, i + 1, (glong) (-1));
				_g_free0 (retv);
				retv = _tmp4_;
				result = retv;
				return result;
			}
		}
	}
	result = retv;
	return result;
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (Block27Data* _data27_) {
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		_g_object_unref0 (_data27_->self);
		_g_object_unref0 (_data27_->notebook);
		_mpd_freeSong0 (_data27_->song);
		g_slice_free (Block27Data, _data27_);
	}
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static gboolean _lambda79_ (GtkWidget* widget, GdkEventButton* event, GmpcBrowsersNowplaying* self) {
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* artist;
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = g_object_get_data ((GObject*) widget, "artist");
	_tmp1_ = g_strdup ((const gchar*) ((const gchar*) _tmp0_));
	artist = _tmp1_;
	info2_fill_artist_view (artist);
	result = FALSE;
	_g_free0 (artist);
	return result;
}


static gboolean __lambda79__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda79_ (_sender, event, self);
	return result;
}


static gboolean _lambda80_ (GtkWidget* widget, GdkEventButton* event, GmpcBrowsersNowplaying* self) {
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* artist;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* album;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = g_object_get_data ((GObject*) widget, "artist");
	_tmp1_ = g_strdup ((const gchar*) ((const gchar*) _tmp0_));
	artist = _tmp1_;
	_tmp2_ = g_object_get_data ((GObject*) widget, "album");
	_tmp3_ = g_strdup ((const gchar*) ((const gchar*) _tmp2_));
	album = _tmp3_;
	if (artist != NULL) {
		_tmp4_ = album != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		info2_fill_album_view (artist, album);
		result = TRUE;
		_g_free0 (album);
		_g_free0 (artist);
		return result;
	}
	result = FALSE;
	_g_free0 (album);
	_g_free0 (artist);
	return result;
}


static gboolean __lambda80__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda80_ (_sender, event, self);
	return result;
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (Block28Data* _data28_) {
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		block27_data_unref (_data28_->_data27_);
		_data28_->_data27_ = NULL;
		g_slice_free (Block28Data, _data28_);
	}
}


static void _lambda81_ (GtkButton* source, Block28Data* _data28_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data28_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:609: lyrics notebook page %i clicked", _data28_->j);
		gtk_notebook_set_current_page (_data27_->notebook, _data28_->j);
	}
}


static void __lambda81__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda81_ (_sender, self);
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (Block29Data* _data29_) {
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		block27_data_unref (_data29_->_data27_);
		_data29_->_data27_ = NULL;
		_g_object_unref0 (_data29_->alib);
		g_slice_free (Block29Data, _data29_);
	}
}


static void _lambda82_ (GtkButton* source, Block29Data* _data29_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data29_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:632: guitar tab notebook page %i clicked", _data29_->j);
		gtk_notebook_set_current_page (_data27_->notebook, _data29_->j);
		if (!_data29_->text_view_queried) {
			GmpcMetaDataWidgetsTextLabel* _tmp2_ = NULL;
			GmpcMetaDataWidgetsTextLabel* text_view;
			_tmp2_ = gmpc_meta_data_widgets_text_label_new (_data27_->song, META_SONG_GUITAR_TAB);
			text_view = g_object_ref_sink (_tmp2_);
			gtk_container_add ((GtkContainer*) _data29_->alib, (GtkWidget*) text_view);
			_data29_->text_view_queried = TRUE;
			gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) text_view);
			gtk_widget_show ((GtkWidget*) text_view);
			_g_object_unref0 (text_view);
		}
	}
}


static void __lambda82__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda82_ (_sender, self);
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (Block30Data* _data30_) {
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		block27_data_unref (_data30_->_data27_);
		_data30_->_data27_ = NULL;
		_g_object_unref0 (_data30_->similar_songs_box);
		g_slice_free (Block30Data, _data30_);
	}
}


static void _lambda83_ (GtkButton* source, Block30Data* _data30_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data30_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:670: similar song notebook page %i clicked", _data30_->j);
		gtk_notebook_set_current_page (_data27_->notebook, _data30_->j);
		if (!_data30_->similar_songs_queried) {
			GmpcMetaDataWidgetsSimilarSongs* _tmp2_ = NULL;
			GmpcMetaDataWidgetsSimilarSongs* similar_songs;
			_tmp2_ = gmpc_meta_data_widgets_similar_songs_new (_data27_->song);
			similar_songs = g_object_ref_sink (_tmp2_);
			gmpc_meta_data_widgets_similar_songs_update (similar_songs);
			_data30_->similar_songs_queried = TRUE;
			gtk_container_add ((GtkContainer*) _data30_->similar_songs_box, (GtkWidget*) similar_songs);
			gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) _data30_->similar_songs_box);
			gtk_widget_show_all ((GtkWidget*) _data30_->similar_songs_box);
			_g_object_unref0 (similar_songs);
		}
	}
}


static void __lambda83__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda83_ (_sender, self);
}


static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (Block31Data* _data31_) {
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		block27_data_unref (_data31_->_data27_);
		_data31_->_data27_ = NULL;
		_g_object_unref0 (_data31_->similar_artist);
		g_slice_free (Block31Data, _data31_);
	}
}


static void _lambda84_ (GtkButton* source, Block31Data* _data31_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data31_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:707: similar artist notebook page %i clicked", _data31_->j);
		gmpc_meta_data_widgets_similar_artists_first_show (_data31_->similar_artist);
		gtk_notebook_set_current_page (_data27_->notebook, _data31_->j);
	}
}


static void __lambda84__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda84_ (_sender, self);
}


static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (Block32Data* _data32_) {
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		block27_data_unref (_data32_->_data27_);
		_data32_->_data27_ = NULL;
		g_slice_free (Block32Data, _data32_);
	}
}


static void _lambda85_ (GtkButton* source, Block32Data* _data32_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data32_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:727: song link notebook page %i clicked", _data32_->j);
		gtk_notebook_set_current_page (_data27_->notebook, _data32_->j);
	}
}


static void __lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda85_ (_sender, self);
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (Block33Data* _data33_) {
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		block27_data_unref (_data33_->_data27_);
		_data33_->_data27_ = NULL;
		_g_object_unref0 (_data33_->alib);
		g_slice_free (Block33Data, _data33_);
	}
}


static void _lambda86_ (GtkButton* source, Block33Data* _data33_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data33_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:748: artist info notebook page %i clicked", _data33_->j);
		gtk_notebook_set_current_page (_data27_->notebook, _data33_->j);
		if (!_data33_->text_view_queried) {
			GmpcMetaDataWidgetsTextLabel* _tmp2_ = NULL;
			GmpcMetaDataWidgetsTextLabel* text_view;
			_tmp2_ = gmpc_meta_data_widgets_text_label_new (_data27_->song, META_ARTIST_TXT);
			text_view = g_object_ref_sink (_tmp2_);
			gtk_container_add ((GtkContainer*) _data33_->alib, (GtkWidget*) text_view);
			_data33_->text_view_queried = TRUE;
			gtk_widget_show ((GtkWidget*) text_view);
			gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) text_view);
			_g_object_unref0 (text_view);
		}
	}
}


static void __lambda86__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda86_ (_sender, self);
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (Block34Data* _data34_) {
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		block27_data_unref (_data34_->_data27_);
		_data34_->_data27_ = NULL;
		_g_object_unref0 (_data34_->sl);
		_g_object_unref0 (_data34_->alib);
		g_slice_free (Block34Data, _data34_);
	}
}


static void _lambda87_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersNowplaying* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->file != NULL) {
		play_path (song->file);
	}
}


static void __lambda87__gmpc_widgets_songlist_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda87_ (_sender, song, self);
}


static void _lambda88_ (GmpcWidgetsSonglist* source, const mpd_Song* song, GmpcBrowsersNowplaying* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (song != NULL);
	if (song->file != NULL) {
		play_path (song->file);
	}
}


static void __lambda88__gmpc_widgets_songlist_play_song_clicked (GmpcWidgetsSonglist* _sender, const mpd_Song* song, gpointer self) {
	_lambda88_ (_sender, song, self);
}


static void _lambda89_ (GtkButton* source, Block34Data* _data34_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	_data27_ = _data34_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) (GTK_IS_CHECK_BUTTON (_tmp0_) ? ((GtkCheckButton*) _tmp0_) : NULL));
	if (_tmp1_) {
		g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:792: artist info notebook page %i clicked", _data34_->j);
		gtk_notebook_set_current_page (_data27_->notebook, _data34_->j);
		if (!_data34_->text_view_queried) {
			gboolean _tmp2_ = FALSE;
			if (_data27_->song->artist != NULL) {
				_tmp2_ = _data27_->song->album != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				MpdData* _tmp3_ = NULL;
				MpdData* data;
				MpdData* _tmp4_;
				mpd_database_search_start (connection, TRUE);
				if (_data27_->song->albumartist != NULL) {
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM_ARTIST, _data27_->song->albumartist);
				} else {
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data27_->song->artist);
				}
				mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, _data27_->song->album);
				_tmp3_ = mpd_database_search_commit (connection);
				data = _tmp3_;
				data = misc_sort_mpddata_by_album_disc_track (data);
				_tmp4_ = data;
				data = NULL;
				gmpc_widgets_songlist_set_from_data (_data34_->sl, _tmp4_, TRUE, FALSE);
				gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) _data34_->sl);
				_mpd_data_free0 (data);
			} else {
				const gchar* _tmp5_ = NULL;
				GtkLabel* _tmp6_ = NULL;
				GtkLabel* _tmp7_;
				gtk_object_destroy ((GtkObject*) _data34_->sl);
				_tmp5_ = _ ("Not available");
				_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
				_tmp7_ = g_object_ref_sink (_tmp6_);
				gtk_container_add ((GtkContainer*) _data34_->alib, (GtkWidget*) _tmp7_);
				_g_object_unref0 (_tmp7_);
			}
			_data34_->text_view_queried = TRUE;
		}
	}
}


static void __lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda89_ (_sender, self);
}


static void _lambda90_ (GObject* source, GParamSpec* spec, Block27Data* _data27_) {
	GmpcBrowsersNowplaying * self;
	gint _tmp0_;
	gint page;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = gtk_notebook_get_current_page (_data27_->notebook);
	page = _tmp0_;
	cfg_set_single_value_as_int (config, "NowPlaying", "last-page", (gint) page);
}


static void __lambda90__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda90_ (_sender, pspec, self);
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (Block35Data* _data35_) {
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		block27_data_unref (_data35_->_data27_);
		_data35_->_data27_ = NULL;
		_mpd_freeSong0 (_data35_->but_song);
		g_slice_free (Block35Data, _data35_);
	}
}


static void _lambda91_ (GtkButton* source, Block35Data* _data35_) {
	Block27Data* _data27_;
	GmpcBrowsersNowplaying * self;
	_data27_ = _data35_->_data27_;
	self = _data27_->self;
	g_return_if_fail (source != NULL);
	info2_fill_album_view (_data27_->song->artist, _data35_->but_song->album);
}


static void __lambda91__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda91_ (_sender, self);
}


static void gmpc_browsers_nowplaying_update_playing (GmpcBrowsersNowplaying* self) {
	Block27Data* _data27_;
	const mpd_Song* _tmp0_ = NULL;
	mpd_Song* _tmp1_;
	gchar* _tmp3_ = NULL;
	gchar* checksum;
	GTimer* _tmp4_ = NULL;
	GTimer* t;
	gchar* _tmp6_;
	GtkVBox* _tmp7_ = NULL;
	GtkVBox* vbox;
	GtkHBox* _tmp8_ = NULL;
	GtkHBox* hbox;
	GtkAlignment* ali;
	gint meta_size;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	GtkVBox* _tmp18_ = NULL;
	GtkVBox* info_vbox;
	gdouble _tmp97_;
	GtkHSeparator* _tmp98_ = NULL;
	GtkHSeparator* sep;
	GtkHBox* _tmp99_ = NULL;
	GtkHBox* hboxje;
	GtkNotebook* _tmp100_ = NULL;
	gint i;
	GSList* group;
	gint _tmp101_;
	gdouble _tmp108_;
	gint _tmp109_;
	gdouble _tmp118_;
	gint _tmp119_;
	gdouble _tmp128_;
	gboolean _tmp129_ = FALSE;
	gint _tmp130_;
	gdouble _tmp138_;
	gint _tmp139_;
	gdouble _tmp147_;
	gint _tmp148_;
	gdouble _tmp171_;
	GtkAlignment* _tmp175_ = NULL;
	GtkHBox* _tmp176_ = NULL;
	GtkHBox* bottom_hbox;
	GtkVBox* _tmp177_ = NULL;
	GtkVBox* metadata_vbox;
	GtkHSeparator* _tmp178_ = NULL;
	gdouble _tmp179_;
	gboolean _tmp180_ = FALSE;
	gdouble _tmp212_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = mpd_playlist_get_current_song (connection);
	_tmp1_ = _mpd_songDup0 (_tmp0_);
	_data27_->song = _tmp1_;
	if (_data27_->song == NULL) {
		g_debug ("gmpc-nowplaying2.vala:319: GMPC Is playing, cannot get this");
		if (self->priv->use_backdrop) {
			GtkEventBox* _tmp2_;
			_tmp2_ = self->priv->container;
			gmpc_meta_data_widgets_backdrop_set_song (GMPC_META_DATA_WIDGETS_IS_BACKDROP (_tmp2_) ? ((GmpcMetaDataWidgetsBackdrop*) _tmp2_) : NULL, NULL);
		}
		gmpc_browsers_nowplaying_update_not_playing (self);
		block27_data_unref (_data27_);
		_data27_ = NULL;
		return;
	}
	_tmp3_ = mpd_song_checksum (_data27_->song);
	checksum = _tmp3_;
	if (g_strcmp0 (checksum, self->priv->song_checksum) == 0) {
		_g_free0 (checksum);
		block27_data_unref (_data27_);
		_data27_ = NULL;
		return;
	}
	_tmp4_ = g_timer_new ();
	t = _tmp4_;
	gmpc_browsers_nowplaying_clear (self);
	if (self->priv->use_backdrop) {
		GtkEventBox* _tmp5_;
		_tmp5_ = self->priv->container;
		gmpc_meta_data_widgets_backdrop_set_song (GMPC_META_DATA_WIDGETS_IS_BACKDROP (_tmp5_) ? ((GmpcMetaDataWidgetsBackdrop*) _tmp5_) : NULL, _data27_->song);
	}
	_tmp6_ = g_strdup (checksum);
	_g_free0 (self->priv->song_checksum);
	self->priv->song_checksum = _tmp6_;
	_tmp7_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp7_);
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	_tmp8_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp8_);
	ali = NULL;
	meta_size = (gint) (((GtkWidget*) self->priv->container)->allocation.width * 0.20);
	_tmp9_ = MAX (100, meta_size);
	_tmp10_ = MIN (_tmp9_, 250);
	meta_size = _tmp10_;
	_tmp11_ = cfg_get_single_value_as_int_with_default (config, "Interface", "hide-album-art", 0);
	if (_tmp11_ == 0) {
		GtkAlignment* _tmp12_ = NULL;
		GmpcMetaImage* _tmp13_ = NULL;
		GmpcMetaImage* album_image;
		_tmp12_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
		_g_object_unref0 (ali);
		ali = g_object_ref_sink (_tmp12_);
		_tmp13_ = gmpc_metaimage_new_size (META_ALBUM_ART, meta_size);
		album_image = g_object_ref_sink (_tmp13_);
		gmpc_metaimage_set_scale_up (album_image, TRUE);
		gmpc_metaimage_set_squared (album_image, FALSE);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_image);
		gmpc_metaimage_update_cover_from_song (album_image, _data27_->song);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (album_image);
	}
	_tmp15_ = cfg_get_single_value_as_int_with_default (config, "Interface", "hide-album-art", 0);
	if (_tmp15_ == 0) {
		_tmp14_ = !self->priv->use_backdrop;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GtkAlignment* _tmp16_ = NULL;
		GmpcMetaImage* _tmp17_ = NULL;
		GmpcMetaImage* artist_image;
		_tmp16_ = (GtkAlignment*) gtk_alignment_new (1.f, 0.f, 0.f, 0.f);
		_g_object_unref0 (ali);
		ali = g_object_ref_sink (_tmp16_);
		_tmp17_ = gmpc_metaimage_new_size (META_ARTIST_ART, meta_size);
		artist_image = g_object_ref_sink (_tmp17_);
		gmpc_metaimage_set_scale_up (artist_image, TRUE);
		gmpc_metaimage_set_squared (artist_image, FALSE);
		gmpc_metaimage_update_cover_from_song (artist_image, _data27_->song);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) artist_image);
		gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (artist_image);
	}
	_tmp18_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	info_vbox = g_object_ref_sink (_tmp18_);
	if (_data27_->song->title != NULL) {
		GtkHBox* _tmp19_ = NULL;
		GtkHBox* box;
		gint _tmp20_;
		GtkLabel* _tmp23_ = NULL;
		GtkLabel* label;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp19_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp19_);
		_tmp20_ = cfg_get_single_value_as_int_with_default (config, "Interface", "hide-favorites-icon", 0);
		if (_tmp20_ == 0) {
			GmpcFavoritesButton* _tmp21_ = NULL;
			GmpcFavoritesButton* fav_button;
			GtkAlignment* _tmp22_ = NULL;
			_tmp21_ = gmpc_favorites_button_new ();
			fav_button = g_object_ref_sink (_tmp21_);
			gmpc_favorites_button_set_song (fav_button, _data27_->song);
			_tmp22_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
			_g_object_unref0 (ali);
			ali = g_object_ref_sink (_tmp22_);
			gtk_container_add ((GtkContainer*) ali, (GtkWidget*) fav_button);
			gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (fav_button);
		}
		_tmp23_ = (GtkLabel*) gtk_label_new (_data27_->song->title);
		label = g_object_ref_sink (_tmp23_);
		gtk_label_set_selectable (label, TRUE);
		_tmp24_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data27_->song->title);
		_tmp25_ = _tmp24_;
		gtk_label_set_markup (label, _tmp25_);
		_g_free0 (_tmp25_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (label);
		_g_object_unref0 (box);
	} else {
		if (_data27_->song->name != NULL) {
			GtkLabel* _tmp26_ = NULL;
			GtkLabel* label;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			_tmp26_ = (GtkLabel*) gtk_label_new (_data27_->song->name);
			label = g_object_ref_sink (_tmp26_);
			gtk_label_set_selectable (label, TRUE);
			_tmp27_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data27_->song->name);
			_tmp28_ = _tmp27_;
			gtk_label_set_markup (label, _tmp28_);
			_g_free0 (_tmp28_);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (label);
		} else {
			if (_data27_->song->file != NULL) {
				gchar* _tmp29_ = NULL;
				gchar* filename;
				GtkLabel* _tmp30_ = NULL;
				GtkLabel* label;
				GRegex* _tmp31_ = NULL;
				GRegex* regex_a;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_;
				GRegex* _tmp34_ = NULL;
				GRegex* regex_b;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
				_tmp29_ = g_path_get_basename (_data27_->song->file);
				filename = _tmp29_;
				_tmp30_ = (GtkLabel*) gtk_label_new (_data27_->song->name);
				label = g_object_ref_sink (_tmp30_);
				gtk_label_set_selectable (label, TRUE);
				_tmp31_ = g_regex_new ("\\.[0-9a-zA-Z]*$", 0, 0, &_inner_error_);
				regex_a = _tmp31_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch12_g_regex_error;
					}
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_vbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_timer_destroy0 (t);
					_g_free0 (checksum);
					block27_data_unref (_data27_);
					_data27_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp32_ = g_regex_replace_literal (regex_a, filename, (gssize) (-1), 0, "", 0, &_inner_error_);
				_tmp33_ = _tmp32_;
				if (_inner_error_ != NULL) {
					_g_regex_unref0 (regex_a);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch12_g_regex_error;
					}
					_g_regex_unref0 (regex_a);
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_vbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_timer_destroy0 (t);
					_g_free0 (checksum);
					block27_data_unref (_data27_);
					_data27_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (filename);
				filename = _tmp33_;
				_g_regex_unref0 (regex_a);
				goto __finally12;
				__catch12_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_error ("gmpc-nowplaying2.vala:413: %s", e->message);
					_g_error_free0 (e);
				}
				__finally12:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_vbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_timer_destroy0 (t);
					_g_free0 (checksum);
					block27_data_unref (_data27_);
					_data27_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp34_ = g_regex_new ("_", 0, 0, &_inner_error_);
				regex_b = _tmp34_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch13_g_regex_error;
					}
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_vbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_timer_destroy0 (t);
					_g_free0 (checksum);
					block27_data_unref (_data27_);
					_data27_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp35_ = g_regex_replace_literal (regex_b, filename, (gssize) (-1), 0, " ", 0, &_inner_error_);
				_tmp36_ = _tmp35_;
				if (_inner_error_ != NULL) {
					_g_regex_unref0 (regex_b);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch13_g_regex_error;
					}
					_g_regex_unref0 (regex_b);
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_vbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_timer_destroy0 (t);
					_g_free0 (checksum);
					block27_data_unref (_data27_);
					_data27_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (filename);
				filename = _tmp36_;
				_g_regex_unref0 (regex_b);
				goto __finally13;
				__catch13_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_error ("gmpc-nowplaying2.vala:419: %s", e->message);
					_g_error_free0 (e);
				}
				__finally13:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (label);
					_g_free0 (filename);
					_g_object_unref0 (info_vbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (hbox);
					_g_object_unref0 (vbox);
					_g_timer_destroy0 (t);
					_g_free0 (checksum);
					block27_data_unref (_data27_);
					_data27_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp37_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, filename);
				_tmp38_ = _tmp37_;
				gtk_label_set_markup (label, _tmp38_);
				_g_free0 (_tmp38_);
				gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
				gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
				gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
				_g_object_unref0 (label);
				_g_free0 (filename);
			}
		}
	}
	if (_data27_->song->artist != NULL) {
		GtkEventBox* _tmp39_ = NULL;
		GtkEventBox* event;
		GtkHBox* _tmp40_ = NULL;
		GtkHBox* box;
		GtkLabel* _tmp41_ = NULL;
		GtkLabel* label;
		GtkImage* _tmp42_ = NULL;
		GtkImage* image;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		_tmp39_ = (GtkEventBox*) gtk_event_box_new ();
		event = g_object_ref_sink (_tmp39_);
		_tmp40_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp40_);
		_tmp41_ = (GtkLabel*) gtk_label_new (_data27_->song->artist);
		label = g_object_ref_sink (_tmp41_);
		gtk_event_box_set_visible_window (event, FALSE);
		gtk_label_set_selectable (label, TRUE);
		_tmp42_ = (GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp42_);
		gtk_container_add ((GtkContainer*) event, (GtkWidget*) image);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) event, FALSE, FALSE, (guint) 0);
		_tmp43_ = g_markup_printf_escaped ("<span size='xx-large' weight='bold'>%s</span>", _data27_->song->artist);
		_tmp44_ = _tmp43_;
		gtk_label_set_markup (label, _tmp44_);
		_g_free0 (_tmp44_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_tmp45_ = g_strdup_printf ("%s", _data27_->song->artist);
		g_object_set_data_full ((GObject*) event, "artist", (void*) _tmp45_, (GDestroyNotify) g_free);
		g_signal_connect_object ((GtkWidget*) event, "button-press-event", (GCallback) __lambda79__gtk_widget_button_press_event, self, 0);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_object_unref0 (box);
		_g_object_unref0 (event);
	}
	if (_data27_->song->album != NULL) {
		GtkEventBox* _tmp46_ = NULL;
		GtkEventBox* event;
		GtkHBox* _tmp47_ = NULL;
		GtkHBox* box;
		GtkLabel* _tmp48_ = NULL;
		GtkLabel* label;
		GtkImage* _tmp49_ = NULL;
		GtkImage* image;
		gchar* _tmp50_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		_tmp46_ = (GtkEventBox*) gtk_event_box_new ();
		event = g_object_ref_sink (_tmp46_);
		_tmp47_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp47_);
		_tmp48_ = (GtkLabel*) gtk_label_new (_data27_->song->album);
		label = g_object_ref_sink (_tmp48_);
		gtk_event_box_set_visible_window (event, FALSE);
		gtk_label_set_selectable (label, TRUE);
		_tmp49_ = (GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp49_);
		gtk_container_add ((GtkContainer*) event, (GtkWidget*) image);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) event, FALSE, FALSE, (guint) 0);
		if (_data27_->song->date != NULL) {
			gchar* _tmp51_ = NULL;
			_tmp51_ = g_strdup_printf ("(%s)", _data27_->song->date);
			_g_free0 (_tmp50_);
			_tmp50_ = _tmp51_;
		} else {
			gchar* _tmp52_;
			_tmp52_ = g_strdup ("");
			_g_free0 (_tmp50_);
			_tmp50_ = _tmp52_;
		}
		_tmp53_ = g_markup_printf_escaped ("<span size='x-large' weight='bold'>%s %s</span>", _data27_->song->album, _tmp50_);
		_tmp54_ = _tmp53_;
		gtk_label_set_markup (label, _tmp54_);
		_g_free0 (_tmp54_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_tmp55_ = g_strdup_printf ("%s", _data27_->song->artist);
		g_object_set_data_full ((GObject*) event, "artist", (void*) _tmp55_, (GDestroyNotify) g_free);
		_tmp56_ = g_strdup_printf ("%s", _data27_->song->album);
		g_object_set_data_full ((GObject*) event, "album", (void*) _tmp56_, (GDestroyNotify) g_free);
		g_signal_connect_object ((GtkWidget*) event, "button-press-event", (GCallback) __lambda80__gtk_widget_button_press_event, self, 0);
		_g_free0 (_tmp50_);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_object_unref0 (box);
		_g_object_unref0 (event);
	}
	if (_data27_->song->genre != NULL) {
		GtkHBox* _tmp57_ = NULL;
		GtkHBox* box;
		GtkLabel* _tmp58_ = NULL;
		GtkLabel* label;
		GtkImage* _tmp59_ = NULL;
		GtkImage* image;
		const gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_;
		_tmp57_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp57_);
		_tmp58_ = (GtkLabel*) gtk_label_new (_data27_->song->title);
		label = g_object_ref_sink (_tmp58_);
		gtk_label_set_selectable (label, TRUE);
		_tmp59_ = (GtkImage*) gtk_image_new_from_icon_name ("media-genre", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp59_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		_tmp60_ = _ ("Genre");
		_tmp61_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _tmp60_, _data27_->song->genre);
		_tmp62_ = _tmp61_;
		gtk_label_set_markup (label, _tmp62_);
		_g_free0 (_tmp62_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_object_unref0 (box);
	}
	{
		GtkHBox* _tmp63_ = NULL;
		GtkHBox* box;
		GtkImage* _tmp64_ = NULL;
		GtkImage* image;
		GtkLabel* _tmp65_ = NULL;
		gint _tmp66_;
		gint bitrate;
		gint _tmp67_;
		gint channels;
		const gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		gint _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		_tmp63_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp63_);
		_tmp64_ = (GtkImage*) gtk_image_new_from_icon_name ("media-format", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp64_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		_tmp65_ = (GtkLabel*) gtk_label_new (_data27_->song->title);
		_g_object_unref0 (self->priv->bitrate_label);
		self->priv->bitrate_label = g_object_ref_sink (_tmp65_);
		gtk_label_set_selectable (self->priv->bitrate_label, TRUE);
		gtk_label_set_ellipsize (self->priv->bitrate_label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) self->priv->bitrate_label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->bitrate_label, TRUE, TRUE, (guint) 0);
		_tmp66_ = mpd_status_get_bitrate (connection);
		bitrate = _tmp66_;
		_tmp67_ = mpd_status_get_channels (connection);
		channels = _tmp67_;
		_tmp68_ = _ ("Format");
		_tmp69_ = ngettext ("Channel", "Channels", (gulong) channels);
		_tmp70_ = mpd_status_get_samplerate (connection);
		_tmp71_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %i %s, %.1f %s, %i %s", self->priv->item_color, _tmp68_, channels, _tmp69_, _tmp70_ / 1000.0, "kHz", bitrate, "kbps");
		_tmp72_ = _tmp71_;
		gtk_label_set_markup (self->priv->bitrate_label, _tmp72_);
		_g_free0 (_tmp72_);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (image);
		_g_object_unref0 (box);
	}
	if (_data27_->song->file != NULL) {
		gchar* extension;
		gchar* _tmp73_ = NULL;
		extension = NULL;
		_tmp73_ = gmpc_browsers_nowplaying_get_extension (self, _data27_->song->file);
		_g_free0 (extension);
		extension = _tmp73_;
		if (extension != NULL) {
			GtkHBox* _tmp74_ = NULL;
			GtkHBox* box;
			GtkImage* _tmp75_ = NULL;
			GtkImage* image;
			GtkLabel* _tmp76_ = NULL;
			GtkLabel* label;
			const gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_;
			_tmp74_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
			box = g_object_ref_sink (_tmp74_);
			_tmp75_ = (GtkImage*) gtk_image_new_from_icon_name ("media-codec", GTK_ICON_SIZE_MENU);
			image = g_object_ref_sink (_tmp75_);
			gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
			_tmp76_ = (GtkLabel*) gtk_label_new (_data27_->song->title);
			label = g_object_ref_sink (_tmp76_);
			gtk_label_set_selectable (label, TRUE);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
			_tmp77_ = _ ("Codec");
			_tmp78_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _tmp77_, extension);
			_tmp79_ = _tmp78_;
			gtk_label_set_markup (label, _tmp79_);
			_g_free0 (_tmp79_);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (label);
			_g_object_unref0 (image);
			_g_object_unref0 (box);
		}
		_g_free0 (extension);
	}
	if (_data27_->song->time > 0) {
		GtkHBox* _tmp80_ = NULL;
		GtkHBox* box;
		GtkImage* _tmp81_ = NULL;
		GtkImage* image;
		GtkLabel* _tmp82_ = NULL;
		GtkLabel* label;
		const gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_;
		gchar* _tmp86_ = NULL;
		gchar* _tmp87_;
		_tmp80_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp80_);
		_tmp81_ = (GtkImage*) gtk_image_new_from_icon_name ("media-track-length", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp81_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		_tmp82_ = (GtkLabel*) gtk_label_new ("");
		label = g_object_ref_sink (_tmp82_);
		gtk_label_set_selectable (label, TRUE);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		_tmp83_ = _ ("Length");
		_tmp84_ = format_time_real ((gulong) _data27_->song->time, "");
		_tmp85_ = _tmp84_;
		_tmp86_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _tmp83_, _tmp85_);
		_tmp87_ = _tmp86_;
		gtk_label_set_markup (label, _tmp87_);
		_g_free0 (_tmp87_);
		_g_free0 (_tmp85_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
		_g_object_unref0 (box);
	}
	if (_data27_->song->track != NULL) {
		GtkHBox* _tmp88_ = NULL;
		GtkHBox* box;
		GtkImage* _tmp89_ = NULL;
		GtkImage* image;
		GtkLabel* _tmp90_ = NULL;
		GtkLabel* label;
		gchar* _tmp91_ = NULL;
		const gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		gchar* _tmp96_;
		_tmp88_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
		box = g_object_ref_sink (_tmp88_);
		_tmp89_ = (GtkImage*) gtk_image_new_from_icon_name ("media-num-tracks", GTK_ICON_SIZE_MENU);
		image = g_object_ref_sink (_tmp89_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		_tmp90_ = (GtkLabel*) gtk_label_new ("");
		label = g_object_ref_sink (_tmp90_);
		gtk_label_set_selectable (label, TRUE);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		if (_data27_->song->disc != NULL) {
			gchar* _tmp92_ = NULL;
			_tmp92_ = g_strdup_printf ("[%s]", _data27_->song->disc);
			_g_free0 (_tmp91_);
			_tmp91_ = _tmp92_;
		} else {
			gchar* _tmp93_;
			_tmp93_ = g_strdup ("");
			_g_free0 (_tmp91_);
			_tmp91_ = _tmp93_;
		}
		_tmp94_ = _ ("Track number");
		_tmp95_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s %s", self->priv->item_color, _tmp94_, _data27_->song->track, _tmp91_);
		_tmp96_ = _tmp95_;
		gtk_label_set_markup (label, _tmp96_);
		_g_free0 (_tmp96_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_free0 (_tmp91_);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
		_g_object_unref0 (box);
	}
	_tmp97_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:578: heading took: %.6f seconds.", _tmp97_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) info_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp98_ = (GtkHSeparator*) gtk_hseparator_new ();
	sep = g_object_ref_sink (_tmp98_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	_tmp99_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hboxje = g_object_ref_sink (_tmp99_);
	_tmp100_ = (GtkNotebook*) gtk_notebook_new ();
	_data27_->notebook = g_object_ref_sink (_tmp100_);
	gtk_notebook_set_show_border (_data27_->notebook, FALSE);
	gtk_notebook_set_show_tabs (_data27_->notebook, FALSE);
	i = 0;
	group = NULL;
	_tmp101_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-lyrics", 1);
	if (_tmp101_ == 1) {
		Block28Data* _data28_;
		GtkAlignment* _tmp102_ = NULL;
		GtkAlignment* alib;
		GmpcMetaDataWidgetsTextLabel* _tmp103_ = NULL;
		GmpcMetaDataWidgetsTextLabel* text_view;
		GtkLabel* _tmp104_ = NULL;
		GtkLabel* _tmp105_;
		GtkRadioButton* _tmp106_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp107_ = NULL;
		_data28_ = g_slice_new0 (Block28Data);
		_data28_->_ref_count_ = 1;
		_data28_->_data27_ = block27_data_ref (_data27_);
		_tmp102_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		alib = g_object_ref_sink (_tmp102_);
		_tmp103_ = gmpc_meta_data_widgets_text_label_new (_data27_->song, META_SONG_TXT);
		text_view = g_object_ref_sink (_tmp103_);
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) text_view);
		_tmp104_ = (GtkLabel*) gtk_label_new ("Lyrics");
		_tmp105_ = g_object_ref_sink (_tmp104_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) alib, (GtkWidget*) _tmp105_);
		_g_object_unref0 (_tmp105_);
		_tmp106_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, "Lyrics");
		button = g_object_ref_sink (_tmp106_);
		_tmp107_ = gtk_radio_button_get_group (button);
		group = _tmp107_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data28_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda81__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
		i++;
		gtk_widget_show ((GtkWidget*) alib);
		_g_object_unref0 (button);
		_g_object_unref0 (text_view);
		_g_object_unref0 (alib);
		block28_data_unref (_data28_);
		_data28_ = NULL;
	}
	_tmp108_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:617: lyrics took: %.6f seconds.", _tmp108_);
	_tmp109_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-guitar-tabs", 1);
	if (_tmp109_ == 1) {
		Block29Data* _data29_;
		GtkAlignment* _tmp110_ = NULL;
		const gchar* _tmp111_ = NULL;
		GtkLabel* _tmp112_ = NULL;
		GtkLabel* _tmp113_;
		const gchar* _tmp114_ = NULL;
		GtkRadioButton* _tmp115_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp116_ = NULL;
		_data29_ = g_slice_new0 (Block29Data);
		_data29_->_ref_count_ = 1;
		_data29_->_data27_ = block27_data_ref (_data27_);
		_tmp110_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		_data29_->alib = g_object_ref_sink (_tmp110_);
		_data29_->text_view_queried = FALSE;
		_tmp111_ = _ ("Guitar Tabs");
		_tmp112_ = (GtkLabel*) gtk_label_new (_tmp111_);
		_tmp113_ = g_object_ref_sink (_tmp112_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) _data29_->alib, (GtkWidget*) _tmp113_);
		_g_object_unref0 (_tmp113_);
		_tmp114_ = _ ("Guitar Tabs");
		_tmp115_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp114_);
		button = g_object_ref_sink (_tmp115_);
		_tmp116_ = gtk_radio_button_get_group (button);
		group = _tmp116_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data29_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda82__gtk_button_clicked, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
		if (i == 0) {
			GmpcMetaDataWidgetsTextLabel* _tmp117_ = NULL;
			GmpcMetaDataWidgetsTextLabel* text_view;
			_tmp117_ = gmpc_meta_data_widgets_text_label_new (_data27_->song, META_SONG_GUITAR_TAB);
			text_view = g_object_ref_sink (_tmp117_);
			gtk_container_add ((GtkContainer*) _data29_->alib, (GtkWidget*) text_view);
			_data29_->text_view_queried = TRUE;
			_g_object_unref0 (text_view);
		}
		gtk_widget_show_all ((GtkWidget*) _data29_->alib);
		i++;
		_g_object_unref0 (button);
		block29_data_unref (_data29_);
		_data29_ = NULL;
	}
	_tmp118_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:651: guitar tabs took: %.6f seconds.", _tmp118_);
	_tmp119_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-songs", 1);
	if (_tmp119_ == 1) {
		Block30Data* _data30_;
		GtkAlignment* _tmp120_ = NULL;
		const gchar* _tmp121_ = NULL;
		GtkLabel* _tmp122_ = NULL;
		GtkLabel* _tmp123_;
		const gchar* _tmp124_ = NULL;
		GtkRadioButton* _tmp125_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp126_ = NULL;
		_data30_ = g_slice_new0 (Block30Data);
		_data30_->_ref_count_ = 1;
		_data30_->_data27_ = block27_data_ref (_data27_);
		_data30_->similar_songs_queried = FALSE;
		_tmp120_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
		_data30_->similar_songs_box = g_object_ref_sink (_tmp120_);
		_tmp121_ = _ ("Similar Songs");
		_tmp122_ = (GtkLabel*) gtk_label_new (_tmp121_);
		_tmp123_ = g_object_ref_sink (_tmp122_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) _data30_->similar_songs_box, (GtkWidget*) _tmp123_);
		_g_object_unref0 (_tmp123_);
		_tmp124_ = _ ("Similar Songs");
		_tmp125_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp124_);
		button = g_object_ref_sink (_tmp125_);
		_tmp126_ = gtk_radio_button_get_group (button);
		group = _tmp126_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data30_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda83__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
		if (i == 0) {
			GmpcMetaDataWidgetsSimilarSongs* _tmp127_ = NULL;
			GmpcMetaDataWidgetsSimilarSongs* similar_songs;
			_tmp127_ = gmpc_meta_data_widgets_similar_songs_new (_data27_->song);
			similar_songs = g_object_ref_sink (_tmp127_);
			gmpc_meta_data_widgets_similar_songs_update (similar_songs);
			_data30_->similar_songs_queried = TRUE;
			gtk_container_add ((GtkContainer*) _data30_->similar_songs_box, (GtkWidget*) similar_songs);
			gtk_widget_show_all ((GtkWidget*) _data30_->similar_songs_box);
			_g_object_unref0 (similar_songs);
		}
		gtk_widget_show ((GtkWidget*) _data30_->similar_songs_box);
		i++;
		_g_object_unref0 (button);
		block30_data_unref (_data30_);
		_data30_ = NULL;
	}
	_tmp128_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:693: similar songs took: %.6f seconds.", _tmp128_);
	_tmp130_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-artist", 1);
	if (_tmp130_ == 1) {
		_tmp129_ = _data27_->song->artist != NULL;
	} else {
		_tmp129_ = FALSE;
	}
	if (_tmp129_) {
		Block31Data* _data31_;
		GmpcMetaDataWidgetsSimilarArtists* _tmp131_ = NULL;
		const gchar* _tmp132_ = NULL;
		GtkLabel* _tmp133_ = NULL;
		GtkLabel* _tmp134_;
		const gchar* _tmp135_ = NULL;
		GtkRadioButton* _tmp136_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp137_ = NULL;
		_data31_ = g_slice_new0 (Block31Data);
		_data31_->_ref_count_ = 1;
		_data31_->_data27_ = block27_data_ref (_data27_);
		_tmp131_ = gmpc_meta_data_widgets_similar_artists_new (connection, _data27_->song);
		_data31_->similar_artist = g_object_ref_sink (_tmp131_);
		_tmp132_ = _ ("Similar Artist");
		_tmp133_ = (GtkLabel*) gtk_label_new (_tmp132_);
		_tmp134_ = g_object_ref_sink (_tmp133_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) _data31_->similar_artist, (GtkWidget*) _tmp134_);
		_g_object_unref0 (_tmp134_);
		_tmp135_ = _ ("Similar Artist");
		_tmp136_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp135_);
		button = g_object_ref_sink (_tmp136_);
		_tmp137_ = gtk_radio_button_get_group (button);
		group = _tmp137_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data31_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda84__gtk_button_clicked, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
		gtk_widget_show ((GtkWidget*) _data31_->similar_artist);
		i++;
		_g_object_unref0 (button);
		block31_data_unref (_data31_);
		_data31_ = NULL;
	}
	_tmp138_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:715: similar Artist took: %.6f seconds.", _tmp138_);
	_tmp139_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-web-links", 1);
	if (_tmp139_ == 1) {
		Block32Data* _data32_;
		GmpcMetaDataWidgetsSongLinks* _tmp140_ = NULL;
		GmpcMetaDataWidgetsSongLinks* song_links;
		const gchar* _tmp141_ = NULL;
		GtkLabel* _tmp142_ = NULL;
		GtkLabel* _tmp143_;
		const gchar* _tmp144_ = NULL;
		GtkRadioButton* _tmp145_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp146_ = NULL;
		_data32_ = g_slice_new0 (Block32Data);
		_data32_->_ref_count_ = 1;
		_data32_->_data27_ = block27_data_ref (_data27_);
		_tmp140_ = gmpc_meta_data_widgets_song_links_new (GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_SONG, _data27_->song);
		song_links = g_object_ref_sink (_tmp140_);
		_tmp141_ = _ ("Web Links");
		_tmp142_ = (GtkLabel*) gtk_label_new (_tmp141_);
		_tmp143_ = g_object_ref_sink (_tmp142_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) song_links, (GtkWidget*) _tmp143_);
		_g_object_unref0 (_tmp143_);
		_tmp144_ = _ ("Web Links");
		_tmp145_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp144_);
		button = g_object_ref_sink (_tmp145_);
		_tmp146_ = gtk_radio_button_get_group (button);
		group = _tmp146_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data32_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda85__gtk_button_clicked, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
		gtk_widget_show ((GtkWidget*) song_links);
		i++;
		_g_object_unref0 (button);
		_g_object_unref0 (song_links);
		block32_data_unref (_data32_);
		_data32_ = NULL;
	}
	_tmp147_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:734: Web links took: %.6f seconds.", _tmp147_);
	_tmp148_ = cfg_get_single_value_as_int_with_default (config, "MetaData", "show-artist-information", 1);
	if (_tmp148_ == 1) {
		Block33Data* _data33_;
		GtkAlignment* _tmp149_ = NULL;
		const gchar* _tmp150_ = NULL;
		GtkLabel* _tmp151_ = NULL;
		GtkLabel* _tmp152_;
		const gchar* _tmp153_ = NULL;
		GtkRadioButton* _tmp154_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp155_ = NULL;
		_data33_ = g_slice_new0 (Block33Data);
		_data33_->_ref_count_ = 1;
		_data33_->_data27_ = block27_data_ref (_data27_);
		_tmp149_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		_data33_->alib = g_object_ref_sink (_tmp149_);
		_data33_->text_view_queried = FALSE;
		_tmp150_ = _ ("Artist information");
		_tmp151_ = (GtkLabel*) gtk_label_new (_tmp150_);
		_tmp152_ = g_object_ref_sink (_tmp151_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) _data33_->alib, (GtkWidget*) _tmp152_);
		_g_object_unref0 (_tmp152_);
		_tmp153_ = _ ("Artist information");
		_tmp154_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp153_);
		button = g_object_ref_sink (_tmp154_);
		_tmp155_ = gtk_radio_button_get_group (button);
		group = _tmp155_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data33_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda86__gtk_button_clicked, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
		if (i == 0) {
			GmpcMetaDataWidgetsTextLabel* _tmp156_ = NULL;
			GmpcMetaDataWidgetsTextLabel* text_view;
			_tmp156_ = gmpc_meta_data_widgets_text_label_new (_data27_->song, META_ARTIST_TXT);
			text_view = g_object_ref_sink (_tmp156_);
			gtk_container_add ((GtkContainer*) _data33_->alib, (GtkWidget*) text_view);
			_data33_->text_view_queried = TRUE;
			_g_object_unref0 (text_view);
		}
		gtk_widget_show_all ((GtkWidget*) _data33_->alib);
		i++;
		_g_object_unref0 (button);
		block33_data_unref (_data33_);
		_data33_ = NULL;
	}
	{
		Block34Data* _data34_;
		GtkAlignment* _tmp157_ = NULL;
		const gchar* _tmp158_ = NULL;
		GtkLabel* _tmp159_ = NULL;
		GtkLabel* _tmp160_;
		const gchar* _tmp161_ = NULL;
		GtkRadioButton* _tmp162_ = NULL;
		GtkRadioButton* button;
		GSList* _tmp163_ = NULL;
		GmpcWidgetsSonglist* _tmp164_ = NULL;
		_data34_ = g_slice_new0 (Block34Data);
		_data34_->_ref_count_ = 1;
		_data34_->_data27_ = block27_data_ref (_data27_);
		_tmp157_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f);
		_data34_->alib = g_object_ref_sink (_tmp157_);
		_data34_->text_view_queried = FALSE;
		_tmp158_ = _ ("Songs from album");
		_tmp159_ = (GtkLabel*) gtk_label_new (_tmp158_);
		_tmp160_ = g_object_ref_sink (_tmp159_);
		gtk_notebook_append_page (_data27_->notebook, (GtkWidget*) _data34_->alib, (GtkWidget*) _tmp160_);
		_g_object_unref0 (_tmp160_);
		_tmp161_ = _ ("Songs from album");
		_tmp162_ = (GtkRadioButton*) gtk_radio_button_new_with_label (group, _tmp161_);
		button = g_object_ref_sink (_tmp162_);
		_tmp163_ = gtk_radio_button_get_group (button);
		group = _tmp163_;
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data34_->j = i;
		_tmp164_ = gmpc_widgets_songlist_new ();
		_data34_->sl = g_object_ref_sink (_tmp164_);
		g_signal_connect_object (_data34_->sl, "song-clicked", (GCallback) __lambda87__gmpc_widgets_songlist_song_clicked, self, 0);
		g_signal_connect_object (_data34_->sl, "play-song-clicked", (GCallback) __lambda88__gmpc_widgets_songlist_play_song_clicked, self, 0);
		gtk_container_add ((GtkContainer*) _data34_->alib, (GtkWidget*) _data34_->sl);
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda89__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
		if (i == 0) {
			gboolean _tmp165_ = FALSE;
			if (_data27_->song->artist != NULL) {
				_tmp165_ = _data27_->song->album != NULL;
			} else {
				_tmp165_ = FALSE;
			}
			if (_tmp165_) {
				MpdData* _tmp166_ = NULL;
				MpdData* data;
				MpdData* _tmp167_;
				mpd_database_search_start (connection, TRUE);
				mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data27_->song->artist);
				mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, _data27_->song->album);
				_tmp166_ = mpd_database_search_commit (connection);
				data = _tmp166_;
				data = misc_sort_mpddata_by_album_disc_track (data);
				_tmp167_ = data;
				data = NULL;
				gmpc_widgets_songlist_set_from_data (_data34_->sl, _tmp167_, TRUE, FALSE);
				_mpd_data_free0 (data);
			} else {
				const gchar* _tmp168_ = NULL;
				GtkLabel* _tmp169_ = NULL;
				GtkLabel* _tmp170_;
				gtk_object_destroy ((GtkObject*) _data34_->sl);
				_tmp168_ = _ ("Not available");
				_tmp169_ = (GtkLabel*) gtk_label_new (_tmp168_);
				_tmp170_ = g_object_ref_sink (_tmp169_);
				gtk_container_add ((GtkContainer*) _data34_->alib, (GtkWidget*) _tmp170_);
				_g_object_unref0 (_tmp170_);
			}
			_data34_->text_view_queried = TRUE;
		}
		gtk_widget_show_all ((GtkWidget*) _data34_->alib);
		i++;
		_g_object_unref0 (button);
		block34_data_unref (_data34_);
		_data34_ = NULL;
	}
	_tmp171_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:837: Artist info took: %.6f seconds.", _tmp171_);
	g_signal_connect_data ((GObject*) _data27_->notebook, "notify::page", (GCallback) __lambda90__g_object_notify, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	if (i > 0) {
		gint _tmp172_;
		gint page;
		_tmp172_ = cfg_get_single_value_as_int_with_default (config, "NowPlaying", "last-page", 0);
		page = _tmp172_;
		if (page > i) {
			gtk_notebook_set_current_page (_data27_->notebook, 0);
		} else {
			gconstpointer _tmp173_ = NULL;
			GtkRadioButton* _tmp174_;
			GtkRadioButton* w;
			_tmp173_ = g_slist_nth_data (group, (guint) ((i - page) - 1));
			_tmp174_ = _g_object_ref0 ((GtkRadioButton*) _tmp173_);
			w = _tmp174_;
			gtk_toggle_button_set_active ((GtkToggleButton*) w, TRUE);
			gtk_notebook_set_current_page (_data27_->notebook, page);
			_g_object_unref0 (w);
		}
	}
	_tmp175_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f);
	_g_object_unref0 (ali);
	ali = g_object_ref_sink (_tmp175_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hboxje);
	_tmp176_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	bottom_hbox = g_object_ref_sink (_tmp176_);
	_tmp177_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	metadata_vbox = g_object_ref_sink (_tmp177_);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	_tmp178_ = (GtkHSeparator*) gtk_hseparator_new ();
	_g_object_unref0 (sep);
	sep = g_object_ref_sink (_tmp178_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) _data27_->notebook, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) metadata_vbox, TRUE, TRUE, (guint) 0);
	_tmp179_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:873: Building now playing took: %.6f seconds.", _tmp179_);
	if (_data27_->song->album != NULL) {
		_tmp180_ = _data27_->song->artist != NULL;
	} else {
		_tmp180_ = FALSE;
	}
	if (_tmp180_) {
		GtkVSeparator* _tmp181_ = NULL;
		GtkVSeparator* sep2;
		gint albums;
		GtkAlignment* _tmp182_ = NULL;
		GtkVBox* _tmp183_ = NULL;
		GtkVBox* album_hbox;
		GtkLabel* _tmp184_ = NULL;
		GtkLabel* label;
		const gchar* _tmp185_ = NULL;
		gchar* _tmp186_ = NULL;
		gchar* _tmp187_;
		MpdData* list;
		MpdData* _tmp188_ = NULL;
		MpdData* data;
		_tmp181_ = (GtkVSeparator*) gtk_vseparator_new ();
		sep2 = g_object_ref_sink (_tmp181_);
		gtk_widget_set_size_request ((GtkWidget*) sep2, -1, 4);
		gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) sep2, FALSE, FALSE, (guint) 0);
		albums = 0;
		_tmp182_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 0.0f, 0.0f);
		_g_object_unref0 (ali);
		ali = g_object_ref_sink (_tmp182_);
		_tmp183_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
		album_hbox = g_object_ref_sink (_tmp183_);
		gtk_widget_set_size_request ((GtkWidget*) album_hbox, 250, -1);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_hbox);
		gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		_tmp184_ = (GtkLabel*) gtk_label_new (_data27_->song->artist);
		label = g_object_ref_sink (_tmp184_);
		gtk_label_set_selectable (label, TRUE);
		gtk_widget_set_size_request ((GtkWidget*) label, 240, -1);
		_tmp185_ = _ ("Other albums by");
		_tmp186_ = g_markup_printf_escaped ("<span size='x-large' weight='bold' color='%s'>%s</span><span size='x-l" \
"arge' weight='bold'> %s</span>", self->priv->item_color, _tmp185_, _data27_->song->artist);
		_tmp187_ = _tmp186_;
		gtk_label_set_markup (label, _tmp187_);
		_g_free0 (_tmp187_);
		gtk_label_set_line_wrap_mode (label, PANGO_WRAP_WORD_CHAR);
		gtk_label_set_line_wrap (label, TRUE);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM);
		mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data27_->song->artist);
		list = NULL;
		_tmp188_ = mpd_database_search_commit (connection);
		data = _tmp188_;
		if (data != NULL) {
			MpdData* _tmp189_ = NULL;
			MpdData* iter;
			_tmp189_ = mpd_data_get_first (data);
			iter = _tmp189_;
			{
				gboolean _tmp190_;
				_tmp190_ = TRUE;
				while (TRUE) {
					mpd_Song* _tmp191_ = NULL;
					gchar* _tmp192_;
					gchar* _tmp193_;
					if (!_tmp190_) {
						if (!(iter != NULL)) {
							break;
						}
					}
					_tmp190_ = FALSE;
					if (g_strcmp0 (iter->tag, _data27_->song->album) == 0) {
						iter = mpd_data_get_next_real (iter, FALSE);
						continue;
					}
					list = mpd_new_data_struct_append (list);
					list->type = MPD_DATA_TYPE_SONG;
					_tmp191_ = mpd_newSong ();
					_mpd_freeSong0 (list->song);
					list->song = _tmp191_;
					_tmp192_ = g_strdup (_data27_->song->artist);
					_g_free0 (list->song->artist);
					list->song->artist = _tmp192_;
					_tmp193_ = g_strdup (iter->tag);
					_g_free0 (list->song->album);
					list->song->album = _tmp193_;
					iter = mpd_data_get_next_real (iter, FALSE);
				}
			}
		}
		list = misc_sort_mpddata_by_album_disc_track (list);
		if (list != NULL) {
			MpdData* _tmp194_ = NULL;
			MpdData* iter;
			_tmp194_ = mpd_data_get_first (list);
			iter = _tmp194_;
			{
				gboolean _tmp195_;
				_tmp195_ = TRUE;
				while (TRUE) {
					Block35Data* _data35_;
					GtkButton* _tmp196_ = NULL;
					GtkButton* button;
					GtkHBox* _tmp197_ = NULL;
					GtkHBox* but_hbox;
					GmpcMetaImage* _tmp198_ = NULL;
					GmpcMetaImage* image;
					mpd_Song* _tmp199_;
					GtkLabel* _tmp200_ = NULL;
					GtkLabel* but_label;
					gchar* _tmp201_;
					gchar* strlabel;
					gboolean _tmp202_ = FALSE;
					gchar* _tmp210_ = NULL;
					gchar* _tmp211_;
					_data35_ = g_slice_new0 (Block35Data);
					_data35_->_ref_count_ = 1;
					_data35_->_data27_ = block27_data_ref (_data27_);
					if (!_tmp195_) {
						if (!(iter != NULL)) {
							block35_data_unref (_data35_);
							_data35_ = NULL;
							break;
						}
					}
					_tmp195_ = FALSE;
					_tmp196_ = (GtkButton*) gtk_button_new ();
					button = g_object_ref_sink (_tmp196_);
					gtk_button_set_relief (button, GTK_RELIEF_NONE);
					_tmp197_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
					but_hbox = g_object_ref_sink (_tmp197_);
					gtk_container_add ((GtkContainer*) button, (GtkWidget*) but_hbox);
					_tmp198_ = gmpc_metaimage_new_size (META_ALBUM_ART, 48);
					image = g_object_ref_sink (_tmp198_);
					_tmp199_ = _mpd_songDup0 (iter->song);
					_data35_->but_song = _tmp199_;
					gmpc_metaimage_set_squared (image, TRUE);
					gmpc_metaimage_update_cover_from_song_delayed (image, _data35_->but_song);
					gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
					_tmp200_ = (GtkLabel*) gtk_label_new (iter->song->album);
					but_label = g_object_ref_sink (_tmp200_);
					gtk_label_set_selectable (but_label, TRUE);
					gtk_misc_set_alignment ((GtkMisc*) but_label, 0.0f, 0.5f);
					_tmp201_ = g_strdup ("");
					strlabel = _tmp201_;
					if (iter->song->date != NULL) {
						gint _tmp203_;
						_tmp203_ = strlen (iter->song->date);
						_tmp202_ = _tmp203_ > 0;
					} else {
						_tmp202_ = FALSE;
					}
					if (_tmp202_) {
						gchar* _tmp204_ = NULL;
						gchar* _tmp205_;
						gchar* _tmp206_;
						_tmp204_ = g_strdup_printf ("%s\n", iter->song->date);
						_tmp205_ = _tmp204_;
						_tmp206_ = g_strconcat (strlabel, _tmp205_, NULL);
						_g_free0 (strlabel);
						strlabel = _tmp206_;
						_g_free0 (_tmp205_);
					}
					if (iter->song->album != NULL) {
						gchar* _tmp207_;
						_tmp207_ = g_strconcat (strlabel, iter->song->album, NULL);
						_g_free0 (strlabel);
						strlabel = _tmp207_;
					} else {
						const gchar* _tmp208_ = NULL;
						gchar* _tmp209_;
						_tmp208_ = _ ("No Album");
						_tmp209_ = g_strconcat (strlabel, _tmp208_, NULL);
						_g_free0 (strlabel);
						strlabel = _tmp209_;
					}
					_tmp210_ = g_markup_printf_escaped ("<b>%s</b>", strlabel);
					_tmp211_ = _tmp210_;
					gtk_label_set_markup (but_label, _tmp211_);
					_g_free0 (_tmp211_);
					gtk_label_set_ellipsize (but_label, PANGO_ELLIPSIZE_END);
					gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) but_label, TRUE, TRUE, (guint) 0);
					gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
					g_signal_connect_data (button, "clicked", (GCallback) __lambda91__gtk_button_clicked, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
					albums++;
					iter = mpd_data_get_next_real (iter, FALSE);
					_g_free0 (strlabel);
					_g_object_unref0 (but_label);
					_g_object_unref0 (image);
					_g_object_unref0 (but_hbox);
					_g_object_unref0 (button);
					block35_data_unref (_data35_);
					_data35_ = NULL;
				}
			}
		}
		if (albums == 0) {
			gtk_object_destroy ((GtkObject*) album_hbox);
			gtk_object_destroy ((GtkObject*) sep2);
		}
		_mpd_data_free0 (data);
		_mpd_data_free0 (list);
		_g_object_unref0 (label);
		_g_object_unref0 (album_hbox);
		_g_object_unref0 (sep2);
	}
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) bottom_hbox, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self->priv->container, (GtkWidget*) vbox);
	gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) self->priv->container);
	gtk_widget_show_all ((GtkWidget*) self->priv->container);
	g_timer_stop (t);
	_tmp212_ = g_timer_elapsed (t, NULL);
	g_log (np2_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, "gmpc-nowplaying2.vala:976: Building now playing took: %.6f seconds.", _tmp212_);
	_g_object_unref0 (metadata_vbox);
	_g_object_unref0 (bottom_hbox);
	_g_object_unref0 (hboxje);
	_g_object_unref0 (sep);
	_g_object_unref0 (info_vbox);
	_g_object_unref0 (ali);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	_g_timer_destroy0 (t);
	_g_free0 (checksum);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


/**
             * This shows the page when mpd is not playing, for now it is the gmpc logo + Gnome Music Player Client
             */
static void gmpc_browsers_nowplaying_update_not_playing (GmpcBrowsersNowplaying* self) {
	GtkIconTheme* _tmp1_ = NULL;
	GtkIconTheme* _tmp2_;
	GtkIconTheme* it;
	GtkIconInfo* _tmp3_ = NULL;
	GtkIconInfo* info;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* path;
	GtkImage* image;
	GtkHBox* _tmp9_ = NULL;
	GtkHBox* hbox;
	const gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* label;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GtkAlignment* _tmp15_ = NULL;
	GtkAlignment* ali;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gmpc_browsers_nowplaying_clear (self);
	_g_free0 (self->priv->song_checksum);
	self->priv->song_checksum = NULL;
	if (self->priv->use_backdrop) {
		GtkEventBox* _tmp0_;
		_tmp0_ = self->priv->container;
		gmpc_meta_data_widgets_backdrop_set_song (GMPC_META_DATA_WIDGETS_IS_BACKDROP (_tmp0_) ? ((GmpcMetaDataWidgetsBackdrop*) _tmp0_) : NULL, NULL);
	}
	_tmp1_ = gtk_icon_theme_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	it = _tmp2_;
	_tmp3_ = gtk_icon_theme_lookup_icon (it, "gmpc", 150, 0);
	info = _tmp3_;
	_tmp4_ = gtk_icon_info_get_filename (info);
	_tmp5_ = g_strdup (_tmp4_);
	path = _tmp5_;
	image = NULL;
	if (path != NULL) {
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* pb;
		GtkImage* _tmp7_ = NULL;
		_tmp6_ = gdk_pixbuf_new_from_file_at_scale (path, 150, 150, TRUE, &_inner_error_);
		pb = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_tmp7_ = (GtkImage*) gtk_image_new_from_pixbuf (pb);
		_g_object_unref0 (image);
		image = g_object_ref_sink (_tmp7_);
		_g_object_unref0 (pb);
		goto __finally14;
		__catch14_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("gmpc-nowplaying2.vala:999: Failed to load the gmpc logo: %s", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (image);
			_g_free0 (path);
			_gtk_icon_info_free0 (info);
			_g_object_unref0 (it);
			return;
		}
		__finally14:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (image);
			_g_free0 (path);
			_gtk_icon_info_free0 (info);
			_g_object_unref0 (it);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (image == NULL) {
		GtkImage* _tmp8_ = NULL;
		_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("gmpc", GTK_ICON_SIZE_DIALOG);
		_g_object_unref0 (image);
		image = g_object_ref_sink (_tmp8_);
	}
	_tmp9_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp9_);
	_tmp10_ = _ ("Gnome Music Player Client");
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	label = g_object_ref_sink (_tmp11_);
	gtk_label_set_selectable (label, TRUE);
	_tmp12_ = _ ("Gnome Music Player Client");
	_tmp13_ = g_strdup_printf ("<span size='%i' weight='bold'>%s</span>", 28 * PANGO_SCALE, _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_label_set_markup (label, _tmp14_);
	_g_free0 (_tmp14_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	ali = g_object_ref_sink (_tmp15_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hbox);
	gtk_container_add ((GtkContainer*) self->priv->container, (GtkWidget*) ali);
	gmpc_browsers_nowplaying_change_color_style (self, (GtkWidget*) self->priv->container);
	gtk_widget_show_all ((GtkWidget*) self->priv->container);
	_g_object_unref0 (ali);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (image);
	_g_free0 (path);
	_gtk_icon_info_free0 (info);
	_g_object_unref0 (it);
}


/**
             * Update the view according to state. If playing/paused show song info, other wise the not playing page
             */
static void gmpc_browsers_nowplaying_update (GmpcBrowsersNowplaying* self) {
	int _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mpd_player_get_state (connection);
	switch (_tmp0_) {
		case MPD_STATUS_STATE_PLAY:
		case MPD_STATUS_STATE_PAUSE:
		{
			g_debug ("gmpc-nowplaying2.vala:1031: Update playing");
			gmpc_browsers_nowplaying_update_playing (self);
			break;
		}
		default:
		{
			g_debug ("gmpc-nowplaying2.vala:1035: update not playing");
			gmpc_browsers_nowplaying_update_not_playing (self);
			break;
		}
	}
}


/**
             * Makes gmpc jump to the now playing browser
             */
void gmpc_browsers_nowplaying_select_now_playing_browser (GmpcBrowsersNowplaying* self) {
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* tree;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* sel;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	_tmp0_ = playlist3_get_category_tree_view ();
	tree = _tmp0_;
	_tmp1_ = gtk_tree_view_get_selection (tree);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	sel = _tmp2_;
	_tmp3_ = gtk_tree_row_reference_get_path (self->priv->np_ref);
	path = _tmp3_;
	if (path != NULL) {
		gtk_tree_selection_select_path (sel, path);
	}
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (sel);
}


/**
             * Gmpc.Plugin.BrowserIface.add_go_menu
             */
static void _gmpc_browsers_nowplaying_select_now_playing_browser_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_browsers_nowplaying_select_now_playing_browser (self);
}


static gint gmpc_browsers_nowplaying_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu) {
	GmpcBrowsersNowplaying * self;
	gint result = 0;
	gboolean _tmp0_;
	self = (GmpcBrowsersNowplaying*) base;
	g_return_val_if_fail (menu != NULL, 0);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GtkImageMenuItem* _tmp2_ = NULL;
		GtkImageMenuItem* item;
		GtkImage* _tmp3_ = NULL;
		GtkImage* _tmp4_;
		GtkAccelGroup* _tmp5_ = NULL;
		_tmp1_ = _ ("Now Playing");
		_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp1_);
		item = g_object_ref_sink (_tmp2_);
		_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("media-audiofile", GTK_ICON_SIZE_MENU);
		_tmp4_ = g_object_ref_sink (_tmp3_);
		gtk_image_menu_item_set_image (item, (GtkWidget*) _tmp4_);
		_g_object_unref0 (_tmp4_);
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_browsers_nowplaying_select_now_playing_browser_gtk_menu_item_activate, self, 0);
		_tmp5_ = gtk_menu_get_accel_group (menu);
		gtk_widget_add_accelerator ((GtkWidget*) item, "activate", _tmp5_, (guint) 0x069, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		result = 1;
		_g_object_unref0 (item);
		return result;
	}
	result = 0;
	return result;
}


GmpcBrowsersNowplaying* gmpc_browsers_nowplaying_construct (GType object_type) {
	GmpcBrowsersNowplaying * self = NULL;
	self = (GmpcBrowsersNowplaying*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcBrowsersNowplaying* gmpc_browsers_nowplaying_new (void) {
	return gmpc_browsers_nowplaying_construct (GMPC_BROWSERS_TYPE_NOWPLAYING);
}


static void _gmpc_browsers_nowplaying_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self) {
	gmpc_browsers_nowplaying_status_changed (self, _sender, mi, what);
}


static void _lambda92_ (MpdObj* source, gint connect, GmpcBrowsersNowplaying* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (source != NULL);
	if (connect == 0) {
		_tmp0_ = self->priv->paned != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_browsers_nowplaying_update_not_playing (self);
	}
}


static void __lambda92__gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self) {
	_lambda92_ (mi, connect, self);
}


static GObject * gmpc_browsers_nowplaying_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcBrowsersNowplaying * self;
	gchar* _tmp0_ = NULL;
	gchar* background;
	gchar* _tmp1_ = NULL;
	gchar* foreground;
	GdkColor _tmp2_ = {0};
	GdkColor _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (gmpc_browsers_nowplaying_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_BROWSERS_NOWPLAYING (obj);
	((GmpcPluginBase*) self)->plugin_type = 2 | 8;
	g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_browsers_nowplaying_status_changed_gmpc_connection_status_changed, self, 0);
	g_signal_connect_object (gmpcconn, "connection-changed", (GCallback) __lambda92__gmpc_connection_connection_changed, self, 0);
	_tmp0_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "background-color", "#000");
	background = _tmp0_;
	_tmp1_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "foreground-color", "#FFF");
	foreground = _tmp1_;
	gdk_color_parse (background, &_tmp2_);
	self->priv->background = _tmp2_;
	gdk_color_parse (foreground, &_tmp3_);
	self->priv->foreground = _tmp3_;
	_tmp4_ = _ ("switch now playing");
	_tmp5_ = _ ("Switch to Now Playing");
	gmpc_easy_command_add_entry (gmpc_easy_command, _tmp4_, "", _tmp5_, (GmpcEasyCommandCallback*) gmpc_browsers_nowplaying_select_now_playing_browser, self);
	_g_free0 (foreground);
	_g_free0 (background);
	return obj;
}


static void gmpc_browsers_nowplaying_class_init (GmpcBrowsersNowplayingClass * klass) {
	gmpc_browsers_nowplaying_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcBrowsersNowplayingPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_browsers_nowplaying_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_browsers_nowplaying_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_browsers_nowplaying_real_set_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->save_yourself = gmpc_browsers_nowplaying_real_save_yourself;
	G_OBJECT_CLASS (klass)->constructor = gmpc_browsers_nowplaying_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_browsers_nowplaying_finalize;
}


static void gmpc_browsers_nowplaying_gmpc_plugin_browser_iface_interface_init (GmpcPluginBrowserIfaceIface * iface) {
	gmpc_browsers_nowplaying_gmpc_plugin_browser_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->browser_add = (void (*)(GmpcPluginBrowserIface* ,GtkWidget*)) gmpc_browsers_nowplaying_real_browser_add;
	iface->browser_selected = (void (*)(GmpcPluginBrowserIface* ,GtkContainer*)) gmpc_browsers_nowplaying_real_browser_selected;
	iface->browser_unselected = (void (*)(GmpcPluginBrowserIface* ,GtkContainer*)) gmpc_browsers_nowplaying_real_browser_unselected;
	iface->browser_add_go_menu = (gint (*)(GmpcPluginBrowserIface* ,GtkMenu*)) gmpc_browsers_nowplaying_real_browser_add_go_menu;
}


static void gmpc_browsers_nowplaying_instance_init (GmpcBrowsersNowplaying * self) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_;
	self->priv = GMPC_BROWSERS_NOWPLAYING_GET_PRIVATE (self);
	_tmp0_ = cfg_get_single_value_as_int_with_default (config, "Now Playing", "use-theme-color", 1);
	self->priv->theme_colors = (gboolean) _tmp0_;
	_tmp1_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "title-color", "#4d90dd");
	self->priv->title_color = _tmp1_;
	_tmp2_ = cfg_get_single_value_as_string_with_default (config, "Now Playing", "item-color", "#304ab8");
	self->priv->item_color = _tmp2_;
	self->priv->bitrate_label = NULL;
	self->priv->np_ref = NULL;
	_tmp3_ = cfg_get_single_value_as_int_with_default (config, "Now Playing", "use-backdrop", 0);
	self->priv->use_backdrop = (gboolean) _tmp3_;
	self->priv->paned = NULL;
	self->priv->container = NULL;
	self->priv->selected = FALSE;
	self->priv->song_checksum = NULL;
}


static void gmpc_browsers_nowplaying_finalize (GObject* obj) {
	GmpcBrowsersNowplaying * self;
	self = GMPC_BROWSERS_NOWPLAYING (obj);
	_g_free0 (self->priv->title_color);
	_g_free0 (self->priv->item_color);
	_g_object_unref0 (self->priv->bitrate_label);
	_gtk_tree_row_reference_free0 (self->priv->np_ref);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->container);
	_g_free0 (self->priv->song_checksum);
	G_OBJECT_CLASS (gmpc_browsers_nowplaying_parent_class)->finalize (obj);
}


GType gmpc_browsers_nowplaying_get_type (void) {
	static volatile gsize gmpc_browsers_nowplaying_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_browsers_nowplaying_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcBrowsersNowplayingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_browsers_nowplaying_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcBrowsersNowplaying), 0, (GInstanceInitFunc) gmpc_browsers_nowplaying_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_browser_iface_info = { (GInterfaceInitFunc) gmpc_browsers_nowplaying_gmpc_plugin_browser_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_browsers_nowplaying_type_id;
		gmpc_browsers_nowplaying_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcBrowsersNowplaying", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_browsers_nowplaying_type_id, GMPC_PLUGIN_TYPE_BROWSER_IFACE, &gmpc_plugin_browser_iface_info);
		g_once_init_leave (&gmpc_browsers_nowplaying_type_id__volatile, gmpc_browsers_nowplaying_type_id);
	}
	return gmpc_browsers_nowplaying_type_id__volatile;
}



