
#line 2 "wa.lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define wafsaconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define wafsanoreturn __attribute__((__noreturn__))
#else
#define wafsanoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (wafsa_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((wafsa_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE wafsarestart( wafsain  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(wafsa_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct wafsa_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t wafsa_size_t;
#endif

extern int wafsaleng;

extern FILE *wafsain, *wafsaout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define wafsaless(n) \
	do \
		{ \
		/* Undo effects of setting up wafsatext. */ \
        int wafsaless_macro_arg = (n); \
        YY_LESS_LINENO(wafsaless_macro_arg);\
		*wafsa_cp = (wafsa_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(wafsa_c_buf_p) = wafsa_cp = wafsa_bp + wafsaless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up wafsatext again */ \
		} \
	while ( 0 )
#define unput(c) wafsaunput( c, (wafsatext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct wafsa_buffer_state
	{
	FILE *wafsa_input_file;

	char *wafsa_ch_buf;		/* input buffer */
	char *wafsa_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int wafsa_buf_size;

	/* Number of characters read into wafsa_ch_buf, not including EOB
	 * characters.
	 */
	int wafsa_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int wafsa_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int wafsa_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int wafsa_at_bol;

    int wafsa_bs_lineno; /**< The line count. */
    int wafsa_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int wafsa_fill_buffer;

	int wafsa_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via wafsarestart()), so that the user can continue scanning by
	 * just pointing wafsain at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t wafsa_buffer_stack_top = 0; /**< index of top of stack. */
static size_t wafsa_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * wafsa_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (wafsa_buffer_stack) \
                          ? (wafsa_buffer_stack)[(wafsa_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (wafsa_buffer_stack)[(wafsa_buffer_stack_top)]

/* wafsa_hold_char holds the character lost when wafsatext is formed. */
static char wafsa_hold_char;
static int wafsa_n_chars;		/* number of characters read into wafsa_ch_buf */
int wafsaleng;

/* Points to current character in buffer. */
static char *wafsa_c_buf_p = NULL;
static int wafsa_init = 0;		/* whether we need to initialize */
static int wafsa_start = 0;	/* start state number */

/* Flag which is used to allow wafsawrap()'s to do buffer switches
 * instead of setting up a fresh wafsain.  A bit of a hack ...
 */
static int wafsa_did_buffer_switch_on_eof;

void wafsarestart ( FILE *input_file  );
void wafsa_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE wafsa_create_buffer ( FILE *file, int size  );
void wafsa_delete_buffer ( YY_BUFFER_STATE b  );
void wafsa_flush_buffer ( YY_BUFFER_STATE b  );
void wafsapush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void wafsapop_buffer_state ( void );

static void wafsaensure_buffer_stack ( void );
static void wafsa_load_buffer_state ( void );
static void wafsa_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER wafsa_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE wafsa_scan_buffer ( char *base, wafsa_size_t size  );
YY_BUFFER_STATE wafsa_scan_string ( const char *wafsa_str  );
YY_BUFFER_STATE wafsa_scan_bytes ( const char *bytes, int len  );

void *wafsaalloc ( wafsa_size_t  );
void *wafsarealloc ( void *, wafsa_size_t  );
void wafsafree ( void *  );

#define wafsa_new_buffer wafsa_create_buffer
#define wafsa_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        wafsaensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            wafsa_create_buffer( wafsain, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->wafsa_is_interactive = is_interactive; \
	}
#define wafsa_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        wafsaensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            wafsa_create_buffer( wafsain, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->wafsa_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->wafsa_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *wafsain = NULL, *wafsaout = NULL;

typedef int wafsa_state_type;

extern int wafsalineno;
int wafsalineno = 1;

extern char *wafsatext;
#ifdef wafsatext_ptr
#undef wafsatext_ptr
#endif
#define wafsatext_ptr wafsatext

static wafsa_state_type wafsa_get_previous_state ( void );
static wafsa_state_type wafsa_try_NUL_trans ( wafsa_state_type current_state  );
static int wafsa_get_next_buffer ( void );
static void wafsanoreturn wafsa_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up wafsatext.
 */
#define YY_DO_BEFORE_ACTION \
	(wafsatext_ptr) = wafsa_bp; \
	wafsaleng = (int) (wafsa_cp - wafsa_bp); \
	(wafsa_hold_char) = *wafsa_cp; \
	*wafsa_cp = '\0'; \
	(wafsa_c_buf_p) = wafsa_cp;
#define YY_NUM_RULES 26
#define YY_END_OF_BUFFER 27
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct wafsa_trans_info
	{
	flex_int32_t wafsa_verify;
	flex_int32_t wafsa_nxt;
	};
static const flex_int16_t wafsa_accept[91] =
    {   0,
        0,    0,   27,   25,    1,   20,   17,   18,   25,    1,
       23,   22,   19,   21,   25,   25,   25,   25,   25,   25,
       25,   25,   15,   16,   25,    1,   23,   22,    1,   23,
       23,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   23,   25,   25,   25,    7,   25,    4,   14,
        8,   25,   25,   25,   24,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   11,
       25,   25,   25,    2,   25,   12,    3,   25,    5,   25,
       25,   25,   25,    6,   25,   10,   13,   25,    9,    0
    } ;

static const YY_CHAR wafsa_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    3,    1,    1,    4,
        5,    1,    6,    7,    6,    8,    1,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    1,   10,    1,
       11,    1,    1,    1,    1,    1,    1,    1,    1,   12,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,   13,   14,    1,    1,

       15,   16,    1,   17,   18,    1,    1,   19,   20,   21,
       22,   23,    1,   24,   25,   26,    1,   27,    1,    1,
       28,    1,   29,    1,   30,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR wafsa_meta[31] =
    {   0,
        1,    2,    2,    2,    2,    1,    1,    1,    1,    2,
        2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    2
    } ;

static const flex_int16_t wafsa_base[92] =
    {   0,
        0,    0,  107,    0,   29,  108,  108,  108,   24,   32,
       97,   29,  108,  108,   83,   16,   88,   18,   82,   84,
       18,   88,  108,  108,    0,   43,   91,   39,   47,    0,
       90,   74,   74,   83,   70,   70,   80,   65,   70,   77,
       69,   64,   78,   66,   68,   70,    0,   63,    0,   67,
        0,   27,   67,   62,   70,   65,   64,   57,   62,   50,
       47,   57,   49,   57,   43,   54,   52,   40,   40,    0,
       39,   44,   48,    0,   46,    0,    0,   45,    0,   34,
       39,   31,   31,    0,   40,    0,    0,   27,    0,  108,
       40

    } ;

static const flex_int16_t wafsa_def[92] =
    {   0,
       90,    1,   90,   91,   90,   90,   90,   90,   91,   91,
       91,   91,   90,   90,   91,   91,   91,   91,   91,   91,
       91,   91,   90,   90,   91,   90,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,    0,
       90

    } ;

static const flex_int16_t wafsa_nxt[139] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,    4,   18,    4,   19,    4,   20,
        4,    4,    4,    4,   21,    4,   22,    4,   23,   24,
       26,   27,   28,   26,   33,   26,   31,   28,   29,   36,
       25,   34,   37,   40,   26,   41,   31,   28,   26,   26,
       61,   89,   62,   29,   88,   87,   86,   85,   84,   83,
       82,   81,   80,   79,   78,   77,   76,   75,   74,   73,
       72,   71,   70,   69,   68,   67,   66,   65,   55,   64,
       63,   60,   59,   58,   57,   56,   55,   54,   53,   52,
       51,   50,   49,   48,   47,   46,   45,   44,   43,   30,

       42,   39,   38,   35,   32,   30,   90,    3,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90
    } ;

static const flex_int16_t wafsa_chk[139] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        5,    9,    9,   10,   16,    5,   12,   12,   10,   18,
       91,   16,   18,   21,   26,   21,   28,   28,   29,   26,
       52,   88,   52,   29,   85,   83,   82,   81,   80,   78,
       75,   73,   72,   71,   69,   68,   67,   66,   65,   64,
       63,   62,   61,   60,   59,   58,   57,   56,   55,   54,
       53,   50,   48,   46,   45,   44,   43,   42,   41,   40,
       39,   38,   37,   36,   35,   34,   33,   32,   31,   27,

       22,   20,   19,   17,   15,   11,    3,   90,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90
    } ;

static wafsa_state_type wafsa_last_accepting_state;
static char *wafsa_last_accepting_cpos;

extern int wafsa_flex_debug;
int wafsa_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define wafsamore() wafsamore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *wafsatext;
#line 1 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
#line 2 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"

/*
 * fsaparse.l (wa.lex.c)
 *
 * Lex definitions for lexical scanner for parsing word-acceptor
 * automata.  See fsaparse.y for more info.
 *
 * mbp Sat Mar 23 21:58:12 1991
 * mbp@thales.urich.edu
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h> /* for atof() */
#include <math.h>
#include <string.h>
#include "wa.yystype.h"
#include "wa.yacc.h"

extern YYSTYPE wafsalval;

/* disable output of unmatched input */
#undef output
#define output(c) 

#line 527 "wa.lex.c"
#line 528 "wa.lex.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int wafsa_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int wafsalex_destroy ( void );

int wafsaget_debug ( void );

void wafsaset_debug ( int debug_flag  );

YY_EXTRA_TYPE wafsaget_extra ( void );

void wafsaset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *wafsaget_in ( void );

void wafsaset_in  ( FILE * _in_str  );

FILE *wafsaget_out ( void );

void wafsaset_out  ( FILE * _out_str  );

			int wafsaget_leng ( void );

char *wafsaget_text ( void );

int wafsaget_lineno ( void );

void wafsaset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int wafsawrap ( void );
#else
extern int wafsawrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void wafsaunput ( int c, char *buf_ptr  );
    
#endif

#ifndef wafsatext_ptr
static void wafsa_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int wafsa_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int wafsainput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( wafsatext, (size_t) wafsaleng, 1, wafsaout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->wafsa_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( wafsain )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( wafsain ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (wafsa_size_t) max_size, wafsain)) == 0 && ferror(wafsain)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(wafsain); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "wafsaterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef wafsaterminate
#define wafsaterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) wafsa_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int wafsalex (void);

#define YY_DECL int wafsalex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after wafsatext and wafsaleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	wafsa_state_type wafsa_current_state;
	char *wafsa_cp, *wafsa_bp;
	int wafsa_act;
    
	if ( !(wafsa_init) )
		{
		(wafsa_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (wafsa_start) )
			(wafsa_start) = 1;	/* first start state */

		if ( ! wafsain )
			wafsain = stdin;

		if ( ! wafsaout )
			wafsaout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			wafsaensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				wafsa_create_buffer( wafsain, YY_BUF_SIZE );
		}

		wafsa_load_buffer_state(  );
		}

	{
#line 37 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"


#line 748 "wa.lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		wafsa_cp = (wafsa_c_buf_p);

		/* Support of wafsatext. */
		*wafsa_cp = (wafsa_hold_char);

		/* wafsa_bp points to the position in wafsa_ch_buf of the start of
		 * the current run.
		 */
		wafsa_bp = wafsa_cp;

		wafsa_current_state = (wafsa_start);
wafsa_match:
		do
			{
			YY_CHAR wafsa_c = wafsa_ec[YY_SC_TO_UI(*wafsa_cp)] ;
			if ( wafsa_accept[wafsa_current_state] )
				{
				(wafsa_last_accepting_state) = wafsa_current_state;
				(wafsa_last_accepting_cpos) = wafsa_cp;
				}
			while ( wafsa_chk[wafsa_base[wafsa_current_state] + wafsa_c] != wafsa_current_state )
				{
				wafsa_current_state = (int) wafsa_def[wafsa_current_state];
				if ( wafsa_current_state >= 91 )
					wafsa_c = wafsa_meta[wafsa_c];
				}
			wafsa_current_state = wafsa_nxt[wafsa_base[wafsa_current_state] + wafsa_c];
			++wafsa_cp;
			}
		while ( wafsa_base[wafsa_current_state] != 108 );

wafsa_find_action:
		wafsa_act = wafsa_accept[wafsa_current_state];
		if ( wafsa_act == 0 )
			{ /* have to back up */
			wafsa_cp = (wafsa_last_accepting_cpos);
			wafsa_current_state = (wafsa_last_accepting_state);
			wafsa_act = wafsa_accept[wafsa_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( wafsa_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*wafsa_cp = (wafsa_hold_char);
			wafsa_cp = (wafsa_last_accepting_cpos);
			wafsa_current_state = (wafsa_last_accepting_state);
			goto wafsa_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 39 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 41 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(FORMAT);	}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 42 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(FORMAT);	}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 43 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(FSA);		}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 44 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(STATES);	}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 45 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(SYMBOLS);	}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 46 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(BFS);		}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 47 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(MIN);		}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 48 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(VARIABLES);	}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 49 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(ALPHABET);	}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 50 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(START);	}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 51 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(ATABLE);	}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 52 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(INVERSES);	}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 53 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(INV);		}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 55 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(LEFT_BRACE);	}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 56 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(RIGHT_BRACE);	}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 57 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(LEFT_PAREN);	}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 58 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(RIGHT_PAREN);	}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 59 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(SEMICOLON);	}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 60 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(PERCENT);	}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 61 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ return(EQUAL);	}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 63 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ wafsalval.i = atoi(wafsatext); return(INT);  }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 64 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ wafsalval.d = atof(wafsatext); return(REAL); }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 65 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ wafsalval.d = atof(wafsatext); return(REAL); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 67 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
{ strcpy(wafsalval.s, wafsatext); return(STRING); }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 69 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"
ECHO;
	YY_BREAK
#line 936 "wa.lex.c"
case YY_STATE_EOF(INITIAL):
	wafsaterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int wafsa_amount_of_matched_text = (int) (wafsa_cp - (wafsatext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*wafsa_cp = (wafsa_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->wafsa_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed wafsain at a new source and called
			 * wafsalex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(wafsa_n_chars) = YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars;
			YY_CURRENT_BUFFER_LVALUE->wafsa_input_file = wafsain;
			YY_CURRENT_BUFFER_LVALUE->wafsa_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for wafsa_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since wafsa_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (wafsa_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[(wafsa_n_chars)] )
			{ /* This was really a NUL. */
			wafsa_state_type wafsa_next_state;

			(wafsa_c_buf_p) = (wafsatext_ptr) + wafsa_amount_of_matched_text;

			wafsa_current_state = wafsa_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * wafsa_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			wafsa_next_state = wafsa_try_NUL_trans( wafsa_current_state );

			wafsa_bp = (wafsatext_ptr) + YY_MORE_ADJ;

			if ( wafsa_next_state )
				{
				/* Consume the NUL. */
				wafsa_cp = ++(wafsa_c_buf_p);
				wafsa_current_state = wafsa_next_state;
				goto wafsa_match;
				}

			else
				{
				wafsa_cp = (wafsa_c_buf_p);
				goto wafsa_find_action;
				}
			}

		else switch ( wafsa_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(wafsa_did_buffer_switch_on_eof) = 0;

				if ( wafsawrap(  ) )
					{
					/* Note: because we've taken care in
					 * wafsa_get_next_buffer() to have set up
					 * wafsatext, we can now set up
					 * wafsa_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(wafsa_c_buf_p) = (wafsatext_ptr) + YY_MORE_ADJ;

					wafsa_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (wafsa_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(wafsa_c_buf_p) =
					(wafsatext_ptr) + wafsa_amount_of_matched_text;

				wafsa_current_state = wafsa_get_previous_state(  );

				wafsa_cp = (wafsa_c_buf_p);
				wafsa_bp = (wafsatext_ptr) + YY_MORE_ADJ;
				goto wafsa_match;

			case EOB_ACT_LAST_MATCH:
				(wafsa_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[(wafsa_n_chars)];

				wafsa_current_state = wafsa_get_previous_state(  );

				wafsa_cp = (wafsa_c_buf_p);
				wafsa_bp = (wafsatext_ptr) + YY_MORE_ADJ;
				goto wafsa_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of wafsalex */

/* wafsa_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int wafsa_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf;
	char *source = (wafsatext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (wafsa_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[(wafsa_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->wafsa_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (wafsa_c_buf_p) - (wafsatext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((wafsa_c_buf_p) - (wafsatext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->wafsa_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars = (wafsa_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->wafsa_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int wafsa_c_buf_p_offset =
				(int) ((wafsa_c_buf_p) - b->wafsa_ch_buf);

			if ( b->wafsa_is_our_buffer )
				{
				int new_size = b->wafsa_buf_size * 2;

				if ( new_size <= 0 )
					b->wafsa_buf_size += b->wafsa_buf_size / 8;
				else
					b->wafsa_buf_size *= 2;

				b->wafsa_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					wafsarealloc( (void *) b->wafsa_ch_buf,
							 (wafsa_size_t) (b->wafsa_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->wafsa_ch_buf = NULL;

			if ( ! b->wafsa_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(wafsa_c_buf_p) = &b->wafsa_ch_buf[wafsa_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->wafsa_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[number_to_move]),
			(wafsa_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars = (wafsa_n_chars);
		}

	if ( (wafsa_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			wafsarestart( wafsain  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->wafsa_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((wafsa_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->wafsa_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (wafsa_n_chars) + number_to_move + ((wafsa_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf = (char *) wafsarealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf, (wafsa_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in wafsa_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->wafsa_buf_size = (int) (new_size - 2);
	}

	(wafsa_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[(wafsa_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[(wafsa_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(wafsatext_ptr) = &YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[0];

	return ret_val;
}

/* wafsa_get_previous_state - get the state just before the EOB char was reached */

    static wafsa_state_type wafsa_get_previous_state (void)
{
	wafsa_state_type wafsa_current_state;
	char *wafsa_cp;
    
	wafsa_current_state = (wafsa_start);

	for ( wafsa_cp = (wafsatext_ptr) + YY_MORE_ADJ; wafsa_cp < (wafsa_c_buf_p); ++wafsa_cp )
		{
		YY_CHAR wafsa_c = (*wafsa_cp ? wafsa_ec[YY_SC_TO_UI(*wafsa_cp)] : 1);
		if ( wafsa_accept[wafsa_current_state] )
			{
			(wafsa_last_accepting_state) = wafsa_current_state;
			(wafsa_last_accepting_cpos) = wafsa_cp;
			}
		while ( wafsa_chk[wafsa_base[wafsa_current_state] + wafsa_c] != wafsa_current_state )
			{
			wafsa_current_state = (int) wafsa_def[wafsa_current_state];
			if ( wafsa_current_state >= 91 )
				wafsa_c = wafsa_meta[wafsa_c];
			}
		wafsa_current_state = wafsa_nxt[wafsa_base[wafsa_current_state] + wafsa_c];
		}

	return wafsa_current_state;
}

/* wafsa_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = wafsa_try_NUL_trans( current_state );
 */
    static wafsa_state_type wafsa_try_NUL_trans  (wafsa_state_type wafsa_current_state )
{
	int wafsa_is_jam;
    	char *wafsa_cp = (wafsa_c_buf_p);

	YY_CHAR wafsa_c = 1;
	if ( wafsa_accept[wafsa_current_state] )
		{
		(wafsa_last_accepting_state) = wafsa_current_state;
		(wafsa_last_accepting_cpos) = wafsa_cp;
		}
	while ( wafsa_chk[wafsa_base[wafsa_current_state] + wafsa_c] != wafsa_current_state )
		{
		wafsa_current_state = (int) wafsa_def[wafsa_current_state];
		if ( wafsa_current_state >= 91 )
			wafsa_c = wafsa_meta[wafsa_c];
		}
	wafsa_current_state = wafsa_nxt[wafsa_base[wafsa_current_state] + wafsa_c];
	wafsa_is_jam = (wafsa_current_state == 90);

		return wafsa_is_jam ? 0 : wafsa_current_state;
}

#ifndef YY_NO_UNPUT

    static void wafsaunput (int c, char * wafsa_bp )
{
	char *wafsa_cp;
    
    wafsa_cp = (wafsa_c_buf_p);

	/* undo effects of setting up wafsatext */
	*wafsa_cp = (wafsa_hold_char);

	if ( wafsa_cp < YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (wafsa_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->wafsa_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf )
			*--dest = *--source;

		wafsa_cp += (int) (dest - source);
		wafsa_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars =
			(wafsa_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->wafsa_buf_size;

		if ( wafsa_cp < YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--wafsa_cp = (char) c;

	(wafsatext_ptr) = wafsa_bp;
	(wafsa_hold_char) = *wafsa_cp;
	(wafsa_c_buf_p) = wafsa_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int wafsainput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(wafsa_c_buf_p) = (wafsa_hold_char);

	if ( *(wafsa_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* wafsa_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (wafsa_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->wafsa_ch_buf[(wafsa_n_chars)] )
			/* This was really a NUL. */
			*(wafsa_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((wafsa_c_buf_p) - (wafsatext_ptr));
			++(wafsa_c_buf_p);

			switch ( wafsa_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because wafsa_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					wafsarestart( wafsain );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( wafsawrap(  ) )
						return 0;

					if ( ! (wafsa_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return wafsainput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(wafsa_c_buf_p) = (wafsatext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (wafsa_c_buf_p);	/* cast for 8-bit char's */
	*(wafsa_c_buf_p) = '\0';	/* preserve wafsatext */
	(wafsa_hold_char) = *++(wafsa_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void wafsarestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        wafsaensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            wafsa_create_buffer( wafsain, YY_BUF_SIZE );
	}

	wafsa_init_buffer( YY_CURRENT_BUFFER, input_file );
	wafsa_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void wafsa_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		wafsapop_buffer_state();
	 *		wafsapush_buffer_state(new_buffer);
     */
	wafsaensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(wafsa_c_buf_p) = (wafsa_hold_char);
		YY_CURRENT_BUFFER_LVALUE->wafsa_buf_pos = (wafsa_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars = (wafsa_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	wafsa_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (wafsawrap()) processing, but the only time this flag
	 * is looked at is after wafsawrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(wafsa_did_buffer_switch_on_eof) = 1;
}

static void wafsa_load_buffer_state  (void)
{
    	(wafsa_n_chars) = YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars;
	(wafsatext_ptr) = (wafsa_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->wafsa_buf_pos;
	wafsain = YY_CURRENT_BUFFER_LVALUE->wafsa_input_file;
	(wafsa_hold_char) = *(wafsa_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE wafsa_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) wafsaalloc( sizeof( struct wafsa_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in wafsa_create_buffer()" );

	b->wafsa_buf_size = size;

	/* wafsa_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->wafsa_ch_buf = (char *) wafsaalloc( (wafsa_size_t) (b->wafsa_buf_size + 2)  );
	if ( ! b->wafsa_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in wafsa_create_buffer()" );

	b->wafsa_is_our_buffer = 1;

	wafsa_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with wafsa_create_buffer()
 * 
 */
    void wafsa_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->wafsa_is_our_buffer )
		wafsafree( (void *) b->wafsa_ch_buf  );

	wafsafree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a wafsarestart() or at EOF.
 */
    static void wafsa_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	wafsa_flush_buffer( b );

	b->wafsa_input_file = file;
	b->wafsa_fill_buffer = 1;

    /* If b is the current buffer, then wafsa_init_buffer was _probably_
     * called from wafsarestart() or through wafsa_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->wafsa_bs_lineno = 1;
        b->wafsa_bs_column = 0;
    }

        b->wafsa_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void wafsa_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->wafsa_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->wafsa_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->wafsa_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->wafsa_buf_pos = &b->wafsa_ch_buf[0];

	b->wafsa_at_bol = 1;
	b->wafsa_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		wafsa_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void wafsapush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	wafsaensure_buffer_stack();

	/* This block is copied from wafsa_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(wafsa_c_buf_p) = (wafsa_hold_char);
		YY_CURRENT_BUFFER_LVALUE->wafsa_buf_pos = (wafsa_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->wafsa_n_chars = (wafsa_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(wafsa_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from wafsa_switch_to_buffer. */
	wafsa_load_buffer_state(  );
	(wafsa_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void wafsapop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	wafsa_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((wafsa_buffer_stack_top) > 0)
		--(wafsa_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		wafsa_load_buffer_state(  );
		(wafsa_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void wafsaensure_buffer_stack (void)
{
	wafsa_size_t num_to_alloc;
    
	if (!(wafsa_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(wafsa_buffer_stack) = (struct wafsa_buffer_state**)wafsaalloc
								(num_to_alloc * sizeof(struct wafsa_buffer_state*)
								);
		if ( ! (wafsa_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in wafsaensure_buffer_stack()" );

		memset((wafsa_buffer_stack), 0, num_to_alloc * sizeof(struct wafsa_buffer_state*));

		(wafsa_buffer_stack_max) = num_to_alloc;
		(wafsa_buffer_stack_top) = 0;
		return;
	}

	if ((wafsa_buffer_stack_top) >= ((wafsa_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		wafsa_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (wafsa_buffer_stack_max) + grow_size;
		(wafsa_buffer_stack) = (struct wafsa_buffer_state**)wafsarealloc
								((wafsa_buffer_stack),
								num_to_alloc * sizeof(struct wafsa_buffer_state*)
								);
		if ( ! (wafsa_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in wafsaensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((wafsa_buffer_stack) + (wafsa_buffer_stack_max), 0, grow_size * sizeof(struct wafsa_buffer_state*));
		(wafsa_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE wafsa_scan_buffer  (char * base, wafsa_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) wafsaalloc( sizeof( struct wafsa_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in wafsa_scan_buffer()" );

	b->wafsa_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->wafsa_buf_pos = b->wafsa_ch_buf = base;
	b->wafsa_is_our_buffer = 0;
	b->wafsa_input_file = NULL;
	b->wafsa_n_chars = b->wafsa_buf_size;
	b->wafsa_is_interactive = 0;
	b->wafsa_at_bol = 1;
	b->wafsa_fill_buffer = 0;
	b->wafsa_buffer_status = YY_BUFFER_NEW;

	wafsa_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to wafsalex() will
 * scan from a @e copy of @a str.
 * @param wafsastr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       wafsa_scan_bytes() instead.
 */
YY_BUFFER_STATE wafsa_scan_string (const char * wafsastr )
{
    
	return wafsa_scan_bytes( wafsastr, (int) strlen(wafsastr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to wafsalex() will
 * scan from a @e copy of @a bytes.
 * @param wafsabytes the byte buffer to scan
 * @param _wafsabytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE wafsa_scan_bytes  (const char * wafsabytes, int  _wafsabytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	wafsa_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (wafsa_size_t) (_wafsabytes_len + 2);
	buf = (char *) wafsaalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in wafsa_scan_bytes()" );

	for ( i = 0; i < _wafsabytes_len; ++i )
		buf[i] = wafsabytes[i];

	buf[_wafsabytes_len] = buf[_wafsabytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = wafsa_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in wafsa_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->wafsa_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void wafsanoreturn wafsa_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine wafsaless() so it works in section 3 code. */

#undef wafsaless
#define wafsaless(n) \
	do \
		{ \
		/* Undo effects of setting up wafsatext. */ \
        int wafsaless_macro_arg = (n); \
        YY_LESS_LINENO(wafsaless_macro_arg);\
		wafsatext[wafsaleng] = (wafsa_hold_char); \
		(wafsa_c_buf_p) = wafsatext + wafsaless_macro_arg; \
		(wafsa_hold_char) = *(wafsa_c_buf_p); \
		*(wafsa_c_buf_p) = '\0'; \
		wafsaleng = wafsaless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int wafsaget_lineno  (void)
{
    
    return wafsalineno;
}

/** Get the input stream.
 * 
 */
FILE *wafsaget_in  (void)
{
        return wafsain;
}

/** Get the output stream.
 * 
 */
FILE *wafsaget_out  (void)
{
        return wafsaout;
}

/** Get the length of the current token.
 * 
 */
int wafsaget_leng  (void)
{
        return wafsaleng;
}

/** Get the current token.
 * 
 */

char *wafsaget_text  (void)
{
        return wafsatext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void wafsaset_lineno (int  _line_number )
{
    
    wafsalineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see wafsa_switch_to_buffer
 */
void wafsaset_in (FILE *  _in_str )
{
        wafsain = _in_str ;
}

void wafsaset_out (FILE *  _out_str )
{
        wafsaout = _out_str ;
}

int wafsaget_debug  (void)
{
        return wafsa_flex_debug;
}

void wafsaset_debug (int  _bdebug )
{
        wafsa_flex_debug = _bdebug ;
}

static int wafsa_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from wafsalex_destroy(), so don't allocate here.
     */

    (wafsa_buffer_stack) = NULL;
    (wafsa_buffer_stack_top) = 0;
    (wafsa_buffer_stack_max) = 0;
    (wafsa_c_buf_p) = NULL;
    (wafsa_init) = 0;
    (wafsa_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    wafsain = stdin;
    wafsaout = stdout;
#else
    wafsain = NULL;
    wafsaout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * wafsalex_init()
     */
    return 0;
}

/* wafsalex_destroy is for both reentrant and non-reentrant scanners. */
int wafsalex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		wafsa_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		wafsapop_buffer_state();
	}

	/* Destroy the stack itself. */
	wafsafree((wafsa_buffer_stack) );
	(wafsa_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * wafsalex() is called, initialization will occur. */
    wafsa_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef wafsatext_ptr
static void wafsa_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int wafsa_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *wafsaalloc (wafsa_size_t  size )
{
			return malloc(size);
}

void *wafsarealloc  (void * ptr, wafsa_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void wafsafree (void * ptr )
{
			free( (char *) ptr );	/* see wafsarealloc() for (char *) cast */
}

#define YYTABLES_NAME "wafsatables"

#line 69 "/home/kbrown/src/cyggeomview/geomview-1.9.5-1.i686/src/geomview-1.9.5/src/lib/oogl/wa/fsaparse.l"


int wafsawrap()
{
  return(1);
}

