/*****************************************************************************
 * grib1tab.c
 *
 * DESCRIPTION
 *    This file contains the tables used to lookup the variables in GRIB1.
 *
 * HISTORY
 *   4/2003 Arthur Taylor (MDL / RSIS): Created.
 *
 * NOTES
 *****************************************************************************
 */

#include "degrib1.h"

/*****************************************************************************
 * NMC Parameter Tables (GRIB1 Section 1 Table 3)
 * Surface tables
 * based on :http://www.nco.ncep.noaa.gov/pmb/docs/on388/table3.html
 * updated last on 3/14/2006
 *****************************************************************************
 */
/* *INDENT-OFF* */
const GRIB1SurfTable GRIB1Surface[256] = {
   /* 0 */ {"var0", "reserved", "-", 0},
   /* 1 */ {"SFC", "Ground or water surface", "-", 0},
   /* 2 */ {"CBL", "Cloud base level", "-", 0},
   /* 3 */ {"CTL", "Cloud top level", "-", 0},
   /* 4 */ {"0DEG", "Level of 0 deg (C) isotherm", "-", 0},
   /* 5 */ {"ADCL", "Level of adiabatic condensation lifted from the surface",
            "-", 0},
   /* 6 */ {"MWSL", "Maximum wind level", "-", 0},
   /* 7 */ {"TRO", "Tropopause", "-", 0},
   /* 8 */ {"NTAT", "Nominal top of atmosphere", "-", 0},
   /* 9 */ {"SEAB", "Sea bottom", "-", 0},
   /* 10 */ {"var10", "reserved", "-", 0},
   /* 11 */ {"var11", "reserved", "-", 0},
   /* 12 */ {"var12", "reserved", "-", 0},
   /* 13 */ {"var13", "reserved", "-", 0},
   /* 14 */ {"var14", "reserved", "-", 0},
   /* 15 */ {"var15", "reserved", "-", 0},
   /* 16 */ {"var16", "reserved", "-", 0},
   /* 17 */ {"var17", "reserved", "-", 0},
   /* 18 */ {"var18", "reserved", "-", 0},
   /* 19 */ {"var19", "reserved", "-", 0},
   /* 20 */ {"TMPL", "Isothermal level", "1/100 K", 0},
   /* 21 */ {"var21", "reserved", "-", 0},
   /* 22 */ {"var22", "reserved", "-", 0},
   /* 23 */ {"var23", "reserved", "-", 0},
   /* 24 */ {"var24", "reserved", "-", 0},
   /* 25 */ {"var25", "reserved", "-", 0},
   /* 26 */ {"var26", "reserved", "-", 0},
   /* 27 */ {"var27", "reserved", "-", 0},
   /* 28 */ {"var28", "reserved", "-", 0},
   /* 29 */ {"var29", "reserved", "-", 0},
   /* 30 */ {"var30", "reserved", "-", 0},
   /* 31 */ {"var31", "reserved", "-", 0},
   /* 32 */ {"var32", "reserved", "-", 0},
   /* 33 */ {"var33", "reserved", "-", 0},
   /* 34 */ {"var34", "reserved", "-", 0},
   /* 35 */ {"var35", "reserved", "-", 0},
   /* 36 */ {"var36", "reserved", "-", 0},
   /* 37 */ {"var37", "reserved", "-", 0},
   /* 38 */ {"var38", "reserved", "-", 0},
   /* 39 */ {"var39", "reserved", "-", 0},
   /* 40 */ {"var40", "reserved", "-", 0},
   /* 41 */ {"var41", "reserved", "-", 0},
   /* 42 */ {"var42", "reserved", "-", 0},
   /* 43 */ {"var43", "reserved", "-", 0},
   /* 44 */ {"var44", "reserved", "-", 0},
   /* 45 */ {"var45", "reserved", "-", 0},
   /* 46 */ {"var46", "reserved", "-", 0},
   /* 47 */ {"var47", "reserved", "-", 0},
   /* 48 */ {"var48", "reserved", "-", 0},
   /* 49 */ {"var49", "reserved", "-", 0},
   /* 50 */ {"var50", "reserved", "-", 0},
   /* 51 */ {"var51", "reserved", "-", 0},
   /* 52 */ {"var52", "reserved", "-", 0},
   /* 53 */ {"var53", "reserved", "-", 0},
   /* 54 */ {"var54", "reserved", "-", 0},
   /* 55 */ {"var55", "reserved", "-", 0},
   /* 56 */ {"var56", "reserved", "-", 0},
   /* 57 */ {"var57", "reserved", "-", 0},
   /* 58 */ {"var58", "reserved", "-", 0},
   /* 59 */ {"var59", "reserved", "-", 0},
   /* 60 */ {"var60", "reserved", "-", 0},
   /* 61 */ {"var61", "reserved", "-", 0},
   /* 62 */ {"var62", "reserved", "-", 0},
   /* 63 */ {"var63", "reserved", "-", 0},
   /* 64 */ {"var64", "reserved", "-", 0},
   /* 65 */ {"var65", "reserved", "-", 0},
   /* 66 */ {"var66", "reserved", "-", 0},
   /* 67 */ {"var67", "reserved", "-", 0},
   /* 68 */ {"var68", "reserved", "-", 0},
   /* 69 */ {"var69", "reserved", "-", 0},
   /* 70 */ {"var70", "reserved", "-", 0},
   /* 71 */ {"var71", "reserved", "-", 0},
   /* 72 */ {"var72", "reserved", "-", 0},
   /* 73 */ {"var73", "reserved", "-", 0},
   /* 74 */ {"var74", "reserved", "-", 0},
   /* 75 */ {"var75", "reserved", "-", 0},
   /* 76 */ {"var76", "reserved", "-", 0},
   /* 77 */ {"var77", "reserved", "-", 0},
   /* 78 */ {"var78", "reserved", "-", 0},
   /* 79 */ {"var79", "reserved", "-", 0},
   /* 80 */ {"var80", "reserved", "-", 0},
   /* 81 */ {"var81", "reserved", "-", 0},
   /* 82 */ {"var82", "reserved", "-", 0},
   /* 83 */ {"var83", "reserved", "-", 0},
   /* 84 */ {"var84", "reserved", "-", 0},
   /* 85 */ {"var85", "reserved", "-", 0},
   /* 86 */ {"var86", "reserved", "-", 0},
   /* 87 */ {"var87", "reserved", "-", 0},
   /* 88 */ {"var88", "reserved", "-", 0},
   /* 89 */ {"var89", "reserved", "-", 0},
   /* 90 */ {"var90", "reserved", "-", 0},
   /* 91 */ {"var91", "reserved", "-", 0},
   /* 92 */ {"var92", "reserved", "-", 0},
   /* 93 */ {"var93", "reserved", "-", 0},
   /* 94 */ {"var94", "reserved", "-", 0},
   /* 95 */ {"var95", "reserved", "-", 0},
   /* 96 */ {"var96", "reserved", "-", 0},
   /* 97 */ {"var97", "reserved", "-", 0},
   /* 98 */ {"var98", "reserved", "-", 0},
   /* 99 */ {"var99", "reserved", "-", 0},
   /* 100 */ {"ISBL", "Isobaric surface", "hPa", 0},
   /* 101 */ {"ISBY", "layer between 2 isobaric levels", "kPa", 1},
   /* 102 */ {"MSL", "Mean sea level", "-", 0},
   /* 103 */ {"GPML", "Specified altitude above MSL", "m", 0},
   /* 104 */ {"GPMY", "layer between 2 specified altitudes above MSL",
              "hm", 1},
   /* 105 */ {"HTGL", "Specified height level above ground", "m", 0},
   /* 106 */ {"HTGY", "layer between 2 specified height levels above ground",
              "hm", 1},
   /* 107 */ {"SIGL", "Sigma level", "1/10000", 0},
   /* 108 */ {"SIGY", "layer between 2 sigma levels", "1/100", 1},
   /* 109 */ {"HYBL", "Hybrid level", "-", 0},
   /* 110 */ {"HYBY", "layer between 2 hybrid levels", "-", 1},
   /* 111 */ {"DBLL", "Depth below land surface", "cm", 0},
   /* 112 */ {"DBLY", "layer between 2 depths below land surface", "cm", 1},
   /* 113 */ {"THEL", "Isentropic (theta) level", "K", 0},
   /* 114 */ {"THEY", "layer between 2 isentropic levels", "K", 1},
   /* 115 */ {"SPDL", "Level at specified pressure difference from ground to"
              " level", "hPa", 0},
   /* 116 */ {"SPDY", "Level between 2 levels at specified pressure "
              "difference from ground to level", "hPa", 1},
   /* 117 */ {"PVL", "Potential vorticity surface", "(10^-6 K M^2)/(kg s)",
              0},
   /* 118 */ {"var118", "reserved", "-", 0},
   /* 119 */ {"EtaL", "Eta level", "1/10000", 0},
   /* 120 */ {"EtaY", "layer between 2 Eta levels", "1/100", 0},
   /* 121 */ {"IBYH", "layer between 2 isobaric surfaces", "1100 hPa", 1},
   /* 122 */ {"var122", "reserved", "-", 0},
   /* 123 */ {"var123", "reserved", "-", 0},
   /* 124 */ {"var124", "reserved", "-", 0},
   /* 125 */ {"HGLH", "Specified height level above ground", "cm", 0},
   /* 126 */ {"ISBP", "Isobaric level", "Pa", 0},
   /* 127 */ {"var127", "reserved", "-", 0},
   /* 128 */ {"SGYH", "layer between 2 sigma levels", "1/1000", 1},
   /* 129 */ {"var129", "reserved", "-", 0},
   /* 130 */ {"var130", "reserved", "-", 0},
   /* 131 */ {"var131", "reserved", "-", 0},
   /* 132 */ {"var132", "reserved", "-", 0},
   /* 133 */ {"var133", "reserved", "-", 0},
   /* 134 */ {"var134", "reserved", "-", 0},
   /* 135 */ {"var135", "reserved", "-", 0},
   /* 136 */ {"var136", "reserved", "-", 0},
   /* 137 */ {"var137", "reserved", "-", 0},
   /* 138 */ {"var138", "reserved", "-", 0},
   /* 139 */ {"var139", "reserved", "-", 0},
   /* 140 */ {"var140", "reserved", "-", 0},
   /* 141 */ {"IBYM", "layer between 2 isobaric surfaces", "1100 hPa", 1},
   /* 142 */ {"var142", "reserved", "-", 0},
   /* 143 */ {"var143", "reserved", "-", 0},
   /* 144 */ {"var144", "reserved", "-", 0},
   /* 145 */ {"var145", "reserved", "-", 0},
   /* 146 */ {"var146", "reserved", "-", 0},
   /* 147 */ {"var147", "reserved", "-", 0},
   /* 148 */ {"var148", "reserved", "-", 0},
   /* 149 */ {"var149", "reserved", "-", 0},
   /* 150 */ {"var150", "reserved", "-", 0},
   /* 151 */ {"var151", "reserved", "-", 0},
   /* 152 */ {"var152", "reserved", "-", 0},
   /* 153 */ {"var153", "reserved", "-", 0},
   /* 154 */ {"var154", "reserved", "-", 0},
   /* 155 */ {"var155", "reserved", "-", 0},
   /* 156 */ {"var156", "reserved", "-", 0},
   /* 157 */ {"var157", "reserved", "-", 0},
   /* 158 */ {"var158", "reserved", "-", 0},
   /* 159 */ {"var159", "reserved", "-", 0},
   /* 160 */ {"DBSL", "Depth below sea level", "m", 0},
   /* 161 */ {"var161", "reserved", "-", 0},
   /* 162 */ {"var162", "reserved", "-", 0},
   /* 163 */ {"var163", "reserved", "-", 0},
   /* 164 */ {"var164", "reserved", "-", 0},
   /* 165 */ {"var165", "reserved", "-", 0},
   /* 166 */ {"var166", "reserved", "-", 0},
   /* 167 */ {"var167", "reserved", "-", 0},
   /* 168 */ {"var168", "reserved", "-", 0},
   /* 169 */ {"var169", "reserved", "-", 0},
   /* 170 */ {"var170", "reserved", "-", 0},
   /* 171 */ {"var171", "reserved", "-", 0},
   /* 172 */ {"var172", "reserved", "-", 0},
   /* 173 */ {"var173", "reserved", "-", 0},
   /* 174 */ {"var174", "reserved", "-", 0},
   /* 175 */ {"var175", "reserved", "-", 0},
   /* 176 */ {"var176", "reserved", "-", 0},
   /* 177 */ {"var177", "reserved", "-", 0},
   /* 178 */ {"var178", "reserved", "-", 0},
   /* 179 */ {"var179", "reserved", "-", 0},
   /* 180 */ {"var180", "reserved", "-", 0},
   /* 181 */ {"var181", "reserved", "-", 0},
   /* 182 */ {"var182", "reserved", "-", 0},
   /* 183 */ {"var183", "reserved", "-", 0},
   /* 184 */ {"var184", "reserved", "-", 0},
   /* 185 */ {"var185", "reserved", "-", 0},
   /* 186 */ {"var186", "reserved", "-", 0},
   /* 187 */ {"var187", "reserved", "-", 0},
   /* 188 */ {"var188", "reserved", "-", 0},
   /* 189 */ {"var189", "reserved", "-", 0},
   /* 190 */ {"var190", "reserved", "-", 0},
   /* 191 */ {"var191", "reserved", "-", 0},
   /* 192 */ {"var192", "reserved", "-", 0},
   /* 193 */ {"var193", "reserved", "-", 0},
   /* 194 */ {"var194", "reserved", "-", 0},
   /* 195 */ {"var195", "reserved", "-", 0},
   /* 196 */ {"var196", "reserved", "-", 0},
   /* 197 */ {"var197", "reserved", "-", 0},
   /* 198 */ {"var198", "reserved", "-", 0},
   /* 199 */ {"var199", "reserved", "-", 0},
   /* 200 */ {"EATM", "entire atmosphere (considered as a single layer)", "-",
              0},
   /* 201 */ {"EOCN", "entire ocean (considered as a single layer)", "-", 0},
   /* 202 */ {"var202", "reserved", "-", 0},
   /* 203 */ {"var203", "reserved", "-", 0},
   /* 204 */ {"HTFL", "Highest troposphereic freezing level", "-", 0},
   /* 205 */ {"var205", "reserved", "-", 0},
   /* 206 */ {"GCBL", "Grid scale cloud bottom level", "-", 0},
   /* 207 */ {"GCTL", "Grid scale cloud top level", "-", 0},
   /* 208 */ {"var208", "reserved", "-", 0},
   /* 209 */ {"BCBL", "Boundary layer cloud bottom level", "-", 0},
   /* 210 */ {"BCTL", "Boundary layer cloud top level", "-", 0},
   /* 211 */ {"BCY", "Boundary layer cloud level", "-", 0},
   /* 212 */ {"LCBL", "Low cloud bottom level", "-", 0},
   /* 213 */ {"LCTL", "Low cloud top level", "-", 0},
   /* 214 */ {"LCY", "Low cloud level", "-", 0},
   /* 215 */ {"CEIL", "Cloud ceiling", "-", 0},
   /* 216 */ {"var216", "reserved", "-", 0},
   /* 217 */ {"var217", "reserved", "-", 0},
   /* 218 */ {"var218", "reserved", "-", 0},
   /* 219 */ {"var219", "reserved", "-", 0},
   /* 220 */ {"var220", "reserved", "-", 0},
   /* 221 */ {"var221", "reserved", "-", 0},
   /* 222 */ {"MCBL", "Middle cloud bottom level", "-", 0},
   /* 223 */ {"MCTL", "Middle cloud top level", "-", 0},
   /* 224 */ {"MCY", "Middle cloud level", "-", 0},
   /* 225 */ {"var225", "reserved", "-", 0},
   /* 226 */ {"var226", "reserved", "-", 0},
   /* 227 */ {"var227", "reserved", "-", 0},
   /* 228 */ {"var228", "reserved", "-", 0},
   /* 229 */ {"var229", "reserved", "-", 0},
   /* 230 */ {"var230", "reserved", "-", 0},
   /* 231 */ {"var231", "reserved", "-", 0},
   /* 232 */ {"HCBL", "High cloud bottom level", "-", 0},
   /* 233 */ {"HCTL", "High cloud top level", "-", 0},
   /* 234 */ {"HCY", "High cloud level", "-", 0},
   /* 235 */ {"OITL", "Ocean Isotherm Level (1/10 deg C)", "-", 0},
   /* 236 */ {"OLYR", "Layer between two depths below ocean surface", "-", 0},
   /* 237 */ {"OBML", "Bottom of Ocean Mixed Layer (m)", "-", 0},
   /* 238 */ {"OBIL", "Bottom of Ocean Isothermal Layer (m)", "-", 0},
   /* 239 */ {"var239", "reserved", "-", 0},
   /* 240 */ {"var240", "reserved", "-", 0},
   /* 241 */ {"var241", "reserved", "-", 0},
   /* 242 */ {"CCBL", "Convective cloud bottom level", "-", 0},
   /* 243 */ {"CCTL", "Convective cloud top level", "-", 0},
   /* 244 */ {"CCY", "Convective cloud level", "-", 0},
   /* 245 */ {"LLTW", "Lowest level of the wet bulb zero", "-", 0},
   /* 246 */ {"MTHE", "Maximum equivalent potential temperature level", "-",
              0},
   /* 247 */ {"EHLT", "Equilibrium level", "-", 0},
   /* 248 */ {"SCBL", "Shallow convective cloud bottom level", "-", 0},
   /* 249 */ {"SCTL", "Shallow convective cloud top level", "-", 0},
   /* 250 */ {"var250", "reserved", "-", 0},
   /* 251 */ {"DCBL", "Deep convective cloud bottom level", "-", 0},
   /* 252 */ {"DCTL", "Deep convective cloud top level", "-", 0},
   /* 253 */ {"LBLSW", "Lowest bottom level of supercooled liquid water layer", "-", 0},
   /* 254 */ {"HTLSW", "Highest top level of supercooled liquid water layer", "-", 0},
   /* 255 */ {"var255", "undefined", "-", 0},
};
/* *INDENT-ON* */

/*****************************************************************************
 * NMC Parameter Tables (GRIB1 Section 1 Table 2)
 * Table versions opn, reanal, omb, 129
 *****************************************************************************
 */

/*
 * parameter table for NCEP (operations)
 * center = 7, subcenter != 2 parameter table = 1, 2, 3 etc
 * note: see reanalysis parameter table for problems
 * updated 11/26/2002
 */

/* http://www.nco.ncep.noaa.gov/pmb/docs/on388/table2.html */
/* Updated last on 5/24/2003 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_ncep_opn[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "K m^2 kg^-1 s^-1", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m", UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature or equivalent potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression (or deficit)", "K", UC_NONE}, /* delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE}, /* delta temp */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction (from which blowing)", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater}, /* Water */
   /* 62 */ {"NCPCP", "Large scale precipitation (non-conv.)", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE}, /* delta temp */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1; sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1; no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell", "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short-wave radiation flux (surface)", "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)", "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short-wave radiation flux (top of atmosphere)", "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)", "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr", UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr", UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat net flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux; u component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux; v component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"MSLSA", "Mean Sea Level Pressure (Standard Atmosphere Reduction)", "Pa", UC_NONE},
   /* 129 */ {"MSLMA", "Mean Sea Level Pressure (MAPS System Reduction)", "Pa", UC_NONE},
   /* 130 */ {"MSLET", "Mean Sea Level Pressure (NAM Model Reduction)", "Pa", UC_NONE},
   /* 131 */ {"LFTX", "Surface lifted index", "K", UC_NONE}, /* delta temp */
   /* 132 */ {"4LFTX", "Best (4-layer) lifted index", "K", UC_NONE}, /* delta temp */
   /* 133 */ {"KX", "K index", "K", UC_NONE}, /* delta temp */
   /* 134 */ {"SX", "Sweat index", "K", UC_NONE}, /* delta temp */
   /* 135 */ {"MCONV", "Horizontal moisture divergence", "kg/kg/s", UC_NONE},
   /* 136 */ {"VWSH", "Vertical speed shear", "1/s", UC_NONE},
   /* 137 */ {"TSLSA", "3-hr pressure tendency Std. Atmos. Reduction", "Pa/s", UC_NONE},
   /* 138 */ {"BVF2", "Brunt-Vaisala frequency (squared)", "1/s^2", UC_NONE},
   /* 139 */ {"PVMW", "Potential vorticity (density weighted)", "1/s/m", UC_NONE},
   /* 140 */ {"CRAIN", "Categorical rain", "yes=1;no=0", UC_NONE},
   /* 141 */ {"CFRZR", "Categorical freezing rain", "yes=1;no=0", UC_NONE},
   /* 142 */ {"CICEP", "Categorical ice pellets", "yes=1;no=0", UC_NONE},
   /* 143 */ {"CSNOW", "Categorical snow", "yes=1;no=0", UC_NONE},
   /* 144 */ {"SOILW", "Volumetric soil moisture content", "fraction", UC_NONE},
   /* 145 */ {"PEVPR", "Potential evaporation rate", "W/m^2", UC_NONE},
   /* 146 */ {"CWORK", "Cloud work function", "J/kg", UC_NONE},
   /* 147 */ {"U-GWD", "Zonal flux of gravity wave stress", "N/m^2", UC_NONE},
   /* 148 */ {"V-GWD", "Meridional flux of gravity wave stress", "N/m^2", UC_NONE},
   /* 149 */ {"PVORT", "Potential vorticity", "m^2/s/kg", UC_NONE},
   /* 150 */ {"COVMZ", "Covariance between u and v", "m^2/s^2", UC_NONE},
   /* 151 */ {"COVTZ", "Covariance between u and T", "K*m/s", UC_NONE},
   /* 152 */ {"COVTM", "Covariance between v and T", "K*m/s", UC_NONE},
   /* 153 */ {"CLWMR", "Cloud water", "kg/kg", UC_NONE},
   /* 154 */ {"O3MR", "Ozone mixing ratio", "kg/kg", UC_NONE},
   /* 155 */ {"GFLUX", "Ground Heat Flux", "W/m^2", UC_NONE},
   /* 156 */ {"CIN", "Convective inhibition", "J/kg", UC_NONE},
   /* 157 */ {"CAPE", "Convective Available Potential Energy", "J/kg", UC_NONE},
   /* 158 */ {"TKE", "Turbulent Kinetic Energy", "J/kg", UC_NONE},
   /* 159 */ {"CONDP", "Condensation pressure of parcel lifted from indicated surface", "Pa", UC_NONE},
   /* 160 */ {"CSUSF", "Clear Sky Upward Solar Flux", "W/m^2", UC_NONE},
   /* 161 */ {"CSDSF", "Clear Sky Downward Solar Flux", "W/m^2", UC_NONE},
   /* 162 */ {"CSULF", "Clear Sky upward long wave flux", "W/m^2", UC_NONE},
   /* 163 */ {"CSDLF", "Clear Sky downward long wave flux", "W/m^2", UC_NONE},
   /* 164 */ {"CFNSF", "Cloud forcing net solar flux", "W/m^2", UC_NONE},
   /* 165 */ {"CFNLF", "Cloud forcing net long wave flux", "W/m^2", UC_NONE},
   /* 166 */ {"VBDSF", "Visible beam downward solar flux", "W/m^2", UC_NONE},
   /* 167 */ {"VDDSF", "Visible diffuse downward solar flux", "W/m^2", UC_NONE},
   /* 168 */ {"NBDSF", "Near IR beam downward solar flux", "W/m^2", UC_NONE},
   /* 169 */ {"NDDSF", "Near IR diffuse downward solar flux", "W/m^2", UC_NONE},
   /* 170 */ {"RWMR", "Rain water mixing ratio", "kg/kg", UC_NONE},
   /* 171 */ {"SNMR", "Snow mixing ratio", "kg/kg", UC_NONE},
   /* 172 */ {"MFLX", "Momentum flux", "N/m^2", UC_NONE},
   /* 173 */ {"LMH", "Mass point model surface", "-", UC_NONE},
   /* 174 */ {"LMV", "Velocity point model surface", "-", UC_NONE},
   /* 175 */ {"MLYNO", "Model layer number (from bottom up)", "-", UC_NONE},
   /* 176 */ {"NLAT", "Latitude (-90 to +90)", "deg", UC_NONE},
   /* 177 */ {"ELON", "East longitude (0-360)", "deg", UC_NONE},
   /* 178 */ {"ICMR", "Ice mixing ratio", "kg/kg", UC_NONE},
   /* 179 */ {"GRMR", "Graupel mixing ratio", "kg/kg", UC_NONE},
   /* 180 */ {"GUST", "Surface wind gust", "m/s", UC_NONE},
   /* 181 */ {"LPSX", "x-gradient of log pressure", "1/m", UC_NONE},
   /* 182 */ {"LPSY", "y-gradient of log pressure", "1/m", UC_NONE},
   /* 183 */ {"HGTX", "x-gradient of height", "m/m", UC_NONE},
   /* 184 */ {"HGTY", "y-gradient of height", "m/m", UC_NONE},
   /* 185 */ {"TPFI", "Turbulence Potential Forecast Index", "-", UC_NONE},
   /* 186 */ {"TIPD", "Total Icing Potential Diagnostic", "-", UC_NONE},
   /* 187 */ {"LTNG", "Lightning", "-", UC_NONE},
   /* 188 */ {"RDRIP", "Rate of water dropping from canopy to ground", "-", UC_NONE},
   /* 189 */ {"VPTMP", "Virtual potential temperature", "K", UC_K2F},
   /* 190 */ {"HLCY", "Storm relative helicity", "m^2/s^2", UC_NONE},
   /* 191 */ {"PROB", "Probability from ensemble", "-", UC_NONE},
   /* 192 */ {"PROBN", "Probability from ensemble normalized with respect to climate expectancy", "-", UC_NONE},
   /* 193 */ {"POP", "Probability of precipitation", "%", UC_NONE},
   /* 194 */ {"CPOFP", "Probability of frozen precipitation", "%", UC_NONE},
   /* 195 */ {"CPOZP", "Probability of freezing precipitation", "%", UC_NONE},
   /* 196 */ {"USTM", "u-component of storm motion", "m/s", UC_NONE},
   /* 197 */ {"VSTM", "v-component of storm motion", "m/s", UC_NONE},
   /* 198 */ {"NCIP", "Number concentration for ice particles", "-", UC_NONE},
   /* 199 */ {"EVBS", "Direct evaporation from bare soil", "W/m^2", UC_NONE},
   /* 200 */ {"EVCW", "Canopy water evaporation", "W/m^2", UC_NONE},
   /* 201 */ {"ICWAT", "Ice-free water surface", "%", UC_NONE},
   /* 202 */ {"CWDI", "Convective weather detection index", "-", UC_NONE},
   /* 203 */ {"VAFTD", "VAFTAD", "log10(kg/m^3)", UC_NONE},
   /* 204 */ {"DSWRF", "Downward short wave rad. flux", "W/m^2", UC_NONE},
   /* 205 */ {"DLWRF", "Downward long wave rad. flux", "W/m^2", UC_NONE},
   /* 206 */ {"UVI", "Ultra violet index (1 hour integration centered at solar noon)", "W/m^2", UC_UVIndex},
   /* 207 */ {"MSTAV", "Moisture availability", "%", UC_NONE},
   /* 208 */ {"SFEXC", "Exchange coefficient", "(kg/m^3)(m/s)", UC_NONE},
   /* 209 */ {"MIXLY", "No. of mixed layers next to surface", "integer", UC_NONE},
   /* 210 */ {"TRANS", "Transpiration", "W/m^2", UC_NONE},
   /* 211 */ {"USWRF", "Upward short wave flux", "W/m^2", UC_NONE},
   /* 212 */ {"ULWRF", "Upward long wave flux", "W/m^2", UC_NONE},
   /* 213 */ {"CDLYR", "Amount of non-convective cloud", "%", UC_NONE},
   /* 214 */ {"CPRAT", "Convective Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 215 */ {"TTDIA", "Temperature tendency by all physics", "K/s", UC_NONE},
   /* 216 */ {"TTRAD", "Temperature tendency by all radiation", "K/s", UC_NONE},
   /* 217 */ {"TTPHY", "Temperature tendency by non-radiation physics", "K/s", UC_NONE},
   /* 218 */ {"PREIX", "Precip. index (0.0-1.00)", "fraction", UC_NONE},
   /* 219 */ {"TSD1D", "Std. dev. of IR T over 1x1 deg area", "K", UC_NONE}, /* delta temp */
   /* 220 */ {"NLGSP", "Natural log of surface pressure", "ln(kPa)", UC_NONE},
   /* 221 */ {"HPBL", "Planetary boundary layer height", "m", UC_NONE},
   /* 222 */ {"5WAVH", "5-wave geopotential height", "gpm", UC_NONE},
   /* 223 */ {"CNWAT", "Plant canopy surface water", "kg/m^2", UC_NONE},
   /* 224 */ {"SOTYP", "Soil type (as in Zobler)", "0-9", UC_NONE},
   /* 225 */ {"VGTYP", "Vegetation type (as in SiB)", "0-13", UC_NONE},
   /* 226 */ {"BMIXL", "Blackadar's mixing length scale", "m", UC_NONE},
   /* 227 */ {"AMIXL", "Asymptotic mixing length scale", "m", UC_NONE},
   /* 228 */ {"PEVAP", "Potential evaporation", "kg/m^2", UC_NONE},
   /* 229 */ {"SNOHF", "Snow phase-change heat flux", "W/m^2", UC_NONE},
   /* 230 */ {"5WAVA", "5-wave geopotential height anomaly", "gpm", UC_NONE},
   /* 231 */ {"MFLUX", "Convective cloud mass flux", "Pa/s", UC_NONE},
   /* 232 */ {"DTRF", "Downward total radiation flux", "W/m^2", UC_NONE},
   /* 233 */ {"UTRF", "Upward total radiation flux", "W/m^2", UC_NONE},
   /* 234 */ {"BGRUN", "Baseflow-groundwater runoff", "kg/m^2", UC_NONE},
   /* 235 */ {"SSRUN", "Storm surface runoff", "kg/m^2", UC_NONE},
   /* 236 */ {"SIPD", "Supercooled Large Droplet (SLD) Icing Potential Diagnostic", "-", UC_NONE},
   /* 237 */ {"O3TOT", "Total ozone", "kg/m^2", UC_NONE},
   /* 238 */ {"SNOWC", "Snow cover", "%", UC_NONE},
   /* 239 */ {"SNOT", "Snow temperature", "K", UC_K2F},
   /* 240 */ {"COVTW", "Covariance between T and w", "K*m/s", UC_NONE},
   /* 241 */ {"LRGHR", "Large scale condensation heat rate", "K/s", UC_NONE},
   /* 242 */ {"CNVHR", "Deep convective heating rate", "K/s", UC_NONE},
   /* 243 */ {"CNVMR", "Deep convective moistening rate", "kg/kg/s", UC_NONE},
   /* 244 */ {"SHAHR", "Shallow convective heating rate", "K/s", UC_NONE},
   /* 245 */ {"SHAMR", "Shallow convective moistening rate", "kg/kg/s", UC_NONE},
   /* 246 */ {"VDFHR", "Vertical diffusion heating rate", "K/s", UC_NONE},
   /* 247 */ {"VDFUA", "Vertical diffusion zonal acceleration", "m/s^2", UC_NONE},
   /* 248 */ {"VDFVA", "Vertical diffusion meridional acceleration", "m/s^2", UC_NONE},
   /* 249 */ {"VDFMR", "Vertical diffusion moistening rate", "kg/kg/s", UC_NONE},
   /* 250 */ {"SWHR", "Solar radiative heating rate", "K/s", UC_NONE},
   /* 251 */ {"LWHR", "Long wave radiative heating rate", "K/s", UC_NONE},
   /* 252 */ {"CD", "Drag coefficient", "-", UC_NONE},
   /* 253 */ {"FRICV", "Friction velocity", "m/s", UC_NONE},
   /* 254 */ {"RI", "Richardson number", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
   /* 185 */ /* {"TURB", "Turbulence SIGMET/AIRMET", "-", UC_NONE}, */
   /* 186 */ /* {"ICNG", "Icing SIGMET/AIRMET", "-", UC_NONE}, */

/*
 * parameter table for ocean modeling branch (OMB) of NCEP
 * center = 7, subcenter = EMC, parameter table = 128
 * 12/31/2001 added REV
 */

const GRIB1ParmTable parm_table_omb[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"GHz6", "6.6 GHz", "K", UC_NONE},
   /* 3 */ {"GHz10", "10.7 GHz", "K", UC_NONE},
   /* 4 */ {"GHz18", "18.0 GHz", "K", UC_NONE},
   /* 5 */ {"GHz19V", "SSMI 19 GHz, Vertical Polarization", "K", UC_NONE},
   /* 6 */ {"GHz19H", "SSMI 19 GHz, Horizontal Polarization", "K", UC_NONE},
   /* 7 */ {"GHz21", "21.0 GHz", "K", UC_NONE},
   /* 8 */ {"GHz22V", "SSMI 22 GHz, Vertical Polarization", "K", UC_NONE},
   /* 9 */ {"GHz37V", "SSMI 37 GHz, Vertical Polarization", "K", UC_NONE},
   /* 10 */ {"GHz37H", "SSMI 37 GHz, Horizontal Polarization", "K", UC_NONE},
   /* 11 */ {"MSU1", "MSU Ch 1 - 50.30 GHz", "K", UC_NONE},
   /* 12 */ {"MSU2", "MSU Ch 2 - 53.74 GHz", "K", UC_NONE},
   /* 13 */ {"MSU3", "MSU Ch 3 - 54.96 GHz", "K", UC_NONE},
   /* 14 */ {"MSU4", "MSU Ch 4 - 57.95 GHz", "K", UC_NONE},
   /* 15 */ {"GHz85V", "SSMI 85 GHz, Vertical Polarization", "K", UC_NONE},
   /* 16 */ {"GHz85H", "SSMI 85 GHz, Horizontal Polarization", "K", UC_NONE},
   /* 17 */ {"GHz91", "91.65 GHz", "K", UC_NONE},
   /* 18 */ {"GHz150", "150 GHz", "K", UC_NONE},
   /* 19 */ {"GHz183pm7", "183 +- 7 GHz", "K", UC_NONE},
   /* 20 */ {"GHz183pm3", "183 +- 3 GHz", "K", UC_NONE},
   /* 21 */ {"GHz183pm1", "183 +- 1 GHz", "K", UC_NONE},
   /* 22 */ {"SSMT1C1", "SSM/T1 - ch 1", "K", UC_NONE},
   /* 23 */ {"SSMT1C2", "SSM/T1 - ch 2", "K", UC_NONE},
   /* 24 */ {"SSMT1C3", "SSM/T1 - ch 3", "K", UC_NONE},
   /* 25 */ {"SSMT1C4", "SSM/T1 - ch 4", "K", UC_NONE},
   /* 26 */ {"SSMT1C5", "SSM/T1 - ch 5", "K", UC_NONE},
   /* 27 */ {"SSMT1C6", "SSM/T1 - ch 6", "K", UC_NONE},
   /* 28 */ {"SSMT1C7", "SSM/T1 - ch 7", "K", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"MI14_95", "HIRS/2 ch 1 - 14.95 micron", "K", UC_NONE},
   /* 61 */ {"MI14_71", "HIRS/2, GOES 14.71 micron", "K", UC_NONE},
   /* 62 */ {"MI14_49", "HIRS/2 ch 3 - 14.49 micron", "K", UC_NONE},
   /* 63 */ {"MI14_37", "GOES I-M - 14.37 micron", "K", UC_NONE},
   /* 64 */ {"MI14_22", "HIRS/2 ch 4 - 14.22 micron", "K", UC_NONE},
   /* 65 */ {"MI14_06", "GOES I-M - 14.06 micron", "K", UC_NONE},
   /* 66 */ {"MI13_97", "HIRS/2 ch 5 - 13.97 micron", "K", UC_NONE},
   /* 67 */ {"MI13_64", "HIRS/2, GOES 13.64 micron", "K", UC_NONE},
   /* 68 */ {"MI13_37", "GOES I-M - 13.37 micron", "K", UC_NONE},
   /* 69 */ {"MI13_35", "HIRS/2 ch 7 - 13.35 micron", "K", UC_NONE},
   /* 70 */ {"MI12_66", "GOES I-M - 12.66 micron", "K", UC_NONE},
   /* 71 */ {"MI12_02", "GOES I-M - 12.02 micron", "K", UC_NONE},
   /* 72 */ {"MI12_00", "AVHRR ch 5 - 12.0 micron", "K", UC_NONE},
   /* 73 */ {"MI11_11", "HIRS/2 ch 8 - 11.11 micron", "K", UC_NONE},
   /* 74 */ {"MI11_03", "GOES I-M - 11.03 micron", "K", UC_NONE},
   /* 75 */ {"MI10_80", "AVHRR ch 4 - 10.8 micron", "K", UC_NONE},
   /* 76 */ {"MI9_71", "HIRS/2, GOES - 9.71 micron", "K", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"MI8_16", "HIRS/2 ch 10 - 8.16 micron", "K", UC_NONE},
   /* 81 */ {"MI7_43", "GOES I-M - 7.43 micron", "K", UC_NONE},
   /* 82 */ {"MI7_33", "HIRS/2 ch 11 - 7.33 micron", "K", UC_NONE},
   /* 83 */ {"MI7_02", "GOES I-M - 7.02 micron", "K", UC_NONE},
   /* 84 */ {"MI6_72", "HIRS/2 ch 12 - 6.72 micron", "K", UC_NONE},
   /* 85 */ {"MI6_51", "GOES I-M - 6.51 micron", "K", UC_NONE},
   /* 86 */ {"MI4_57", "HIRS/2, GOES - 4.57 micron", "K", UC_NONE},
   /* 87 */ {"MI4_52", "HIRS/2, GOES - 4.52 micron", "K", UC_NONE},
   /* 88 */ {"MI4_46", "HIRS/2 ch 15 - 4.46 micron", "K", UC_NONE},
   /* 89 */ {"MI4_45", "GOES I-M - 4.45 micron", "K", UC_NONE},
   /* 90 */ {"MI4_40", "HIRS/2 ch 16 - 4.40 micron", "K", UC_NONE},
   /* 91 */ {"MI4_24", "HIRS/2 ch 17 - 4.24 micron", "K", UC_NONE},
   /* 92 */ {"MI4_13", "GOES I-M - 4.13 micron", "K", UC_NONE},
   /* 93 */ {"MI4_00", "HIRS/2 ch 18 - 4.00 micron", "K", UC_NONE},
   /* 94 */ {"MI8_16", "GOES I-M - 3.98 micron", "K", UC_NONE},
   /* 95 */ {"MI8_16", "HIRS/2 Window - 3.76 micron", "K", UC_NONE},
   /* 96 */ {"MI8_16", "AVHRR, GOES - 3.74 micron", "K", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"MI0_91", "AVHRR ch 2 - 0.91 micron", "K", UC_NONE},
   /* 101 */ {"MI0_696", "GOES I-M - 0.696 micron", "K", UC_NONE},
   /* 102 */ {"MI0_69", "HIRS/2 Vis - 0.69 micron", "K", UC_NONE},
   /* 103 */ {"MI0_63", "AVHRR ch 1 - 0.63 micron", "K", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},

   /* 128 */ {"AVDEPTH", "Ocean depth - mean", "m", UC_NONE},
   /* 129 */ {"DEPTH", "Ocean depth - instantaneous", "m", UC_NONE},
   /* 130 */ {"ELEV", "Ocean surface elevation relative to geoid", "m", UC_NONE},
   /* 131 */ {"MXEL24", "Max ocean surface elevation in last 24 hours", "m", UC_NONE},
   /* 132 */ {"MNEL24", "Min ocean surface elevation in last 24 hours", "m", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"O2", "Oxygen (O2 (aq))", "Mol/kg", UC_NONE},
   /* 136 */ {"PO4", "PO4", "Mol/kg", UC_NONE},
   /* 137 */ {"NO3", "NO3", "Mol/kg", UC_NONE},
   /* 138 */ {"SIO4", "SiO4", "Mol/kg", UC_NONE},
   /* 139 */ {"CO2AQ", "CO2 (aq)", "Mol/kg", UC_NONE},
   /* 140 */ {"HCO3", "HCO3", "Mol/kg", UC_NONE},
   /* 141 */ {"CO3", "CO3", "Mol/kg", UC_NONE},
   /* 142 */ {"TCO2", "TCO2", "Mol/kg", UC_NONE},
   /* 143 */ {"TALK", "TALK", "Mol/kg", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"S11", "S11 - 1;1 component of ice stress tensor", "-", UC_NONE},
   /* 147 */ {"S12", "S12 - 1;2 component of ice stress tensor", "-", UC_NONE},
   /* 148 */ {"S22", "S22 - 2;2 component of ice stress tensor", "-", UC_NONE},
   /* 149 */ {"INV1", "T1 - First invariant of stress tensor", "-", UC_NONE},
   /* 150 */ {"INV2", "T2 - Second invariant of stress tensor", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"WVRGH", "Wave roughness", "-", UC_NONE},
   /* 156 */ {"WVSTRS", "Wave stresses", "-", UC_NONE},
   /* 157 */ {"WHITE", "Whitecap coverage", "-", UC_NONE},
   /* 158 */ {"SWDIRWID", "Swell direction width", "-", UC_NONE},
   /* 159 */ {"SWFREWID", "Swell frequency width", "-", UC_NONE},
   /* 160 */ {"WVAGE", "Wave age", "-", UC_NONE},
   /* 161 */ {"PWVAGE", "Physical Wave age", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"LTURB", "Master length scale (turbulence)", "m", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"AIHFLX", "Net air-ice heat flux", "W/m^2", UC_NONE},
   /* 171 */ {"AOHFLX", "Net air-ocean heat flux", "W/m^2", UC_NONE},
   /* 172 */ {"IOHFLX", "Net ice-ocean heat flux", "W/m^2", UC_NONE},
   /* 173 */ {"IOSFLX", "Net ice-ocean salt flux", "kg/s", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"OMLT", "Ocean mixed layer temperature", "K", UC_NONE},
   /* 176 */ {"OMLS", "Ocean mixed layer salinity", "kg/kg", UC_NONE},
   /* 177 */ {"P2OMLT", "Ocean mixed layer potential density (Referenced to 2000m)", "kg/m^3", UC_NONE},
   /* 178 */ {"OMLU", "Ocean mixed layer u velocity", "m/s", UC_NONE},
   /* 179 */ {"OMLV", "Ocean mixed layer v velocity", "m/s", UC_NONE},
   /* 180 */ {"ASHFL", "Assimilative heat flux", "W/m^2", UC_NONE},
   /* 181 */ {"ASSFL", "Assimilative salt flux", "mm/day", UC_NONE},
   /* 182 */ {"BOTLD", "Bottom layer depth", "m", UC_NONE},
   /* 183 */ {"UBARO", "Barotropic U velocity", "m/s", UC_NONE},
   /* 184 */ {"VBARO", "Barotropic V velocity", "m/s", UC_NONE},
   /* 185 */ {"INTFD", "Interface depths", "m", UC_NONE},
   /* 186 */ {"WTMPC", "3-D temperature", "deg c", UC_NONE},
   /* 187 */ {"SALIN", "3-D Salinity", "psu", UC_NONE},
   /* 188 */ {"EMNP", "Evaporation - precipitation", "cm/day", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"KENG", "Kinetic energy", "J/kg", UC_NONE},
   /* 191 */ {"BKENG", "Barotropic Kinetic energy", "J/kg", UC_NONE},
   /* 192 */ {"LAYTH", "Layer Thickness", "m", UC_NONE},
   /* 193 */ {"SSTT", "Surface temperature trend", "deg/day", UC_NONE},
   /* 194 */ {"SSST", "Surface salinity trend", "psu/day", UC_NONE},
   /* 195 */ {"OVHD", "Ocean Vertical Heat Diffusivity", "m2 s^-1", UC_NONE},
   /* 196 */ {"OVSHD", "Ocean Vertical Salt Diffusivity", "m2 s^-1", UC_NONE},
   /* 197 */ {"OVMD", "Ocean Vertical Momentum Diffusivity", "m2 s^-1", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"REV", "Relative error variance", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE}
};

/* http://www.nco.ncep.noaa.gov/pmb/docs/on388/table2.html */
/* Updated last on 5/24/2003 */
const GRIB1ParmTable parm_table_nceptab_129[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"PAOT", "Probability anomaly of temperature", "%", UC_NONE},
   /* 129 */ {"PAOP", "Probability anomaly of precipitation", "%", UC_NONE},
   /* 130 */ {"CWR", "Probability of Wetting Rain; exceeding 0.10 inch in a given time period", "%", UC_NONE},
   /* 131 */ {"FRAIN", "Rain fraction of total liquid water", "-", UC_NONE},
   /* 132 */ {"FICE", "Ice fraction of total condensate", "-", UC_NONE},
   /* 133 */ {"FRIME", "Rime Factor", "-", UC_NONE},
   /* 134 */ {"CUEFI", "Convective cloud efficiency", "-", UC_NONE},
   /* 135 */ {"TCOND", "Total condensate", "kg/kg", UC_NONE},
   /* 136 */ {"TCOLW", "Total column-integrated cloud water", "kg/m2", UC_NONE},
   /* 137 */ {"TCOLI", "Total column-integrated cloud ice", "kg/m2", UC_NONE},
   /* 138 */ {"TCOLR", "Total column-integrated rain", "kg/m2", UC_NONE},
   /* 139 */ {"TCOLS", "Total column-integrated snow", "kg/m2", UC_NONE},
   /* 140 */ {"TCOLC", "Total column-integrated condensate", "kg/m2", UC_NONE},
   /* 141 */ {"PLPL", "Pressure of level from which parcel was lifted", "Pa", UC_NONE},
   /* 142 */ {"HLPL", "Height of level from which parcel was lifted", "m", UC_NONE},
   /* 143 */ {"CEMS", "Cloud Emissivity", "Fraction 0-1", UC_NONE},
   /* 144 */ {"COPD", "Cloud Optical Depth", "-", UC_NONE},
   /* 145 */ {"PSIZ", "Effective Particle size", "Microns", UC_NONE},
   /* 146 */ {"TCWAT", "Total Water Cloud", "%", UC_NONE},
   /* 147 */ {"TCICE", "Total Ice Cloud", "%", UC_NONE},
   /* 148 */ {"WDIF", "Wind difference", "m/s", UC_NONE},
   /* 149 */ {"WSTP", "Wave Steepness", "-", UC_NONE},
   /* 150 */ {"PTAN", "Probability of Temperature being above normal", "%", UC_NONE},
   /* 151 */ {"PTNN", "Probability of Temperature being near normal", "%", UC_NONE},
   /* 152 */ {"PTBN", "Probability of Temperature being below normal", "%", UC_NONE},
   /* 153 */ {"PPAN", "Probability of Precipitation being above normal", "%", UC_NONE},
   /* 154 */ {"PPNN", "Probability of Precipitation being near normal", "%", UC_NONE},
   /* 155 */ {"PPBN", "Probability of Precipitation being below normal", "%", UC_NONE},
   /* 156 */ {"PMTC", "Particulate matter (coarse)", "µg/m^3", UC_NONE},
   /* 157 */ {"PMTF", "Particulate matter (fine)", "µg/m^3", UC_NONE},
   /* 158 */ {"AETMP", "Analysis error of temperature", "K", UC_K2F},
   /* 159 */ {"AEDPT", "Analysis error of dew point", "%", UC_NONE},
   /* 160 */ {"AESPH", "Analysis error of specific humidity", "kg/kg", UC_NONE},
   /* 161 */ {"AEUWD", "Analysis error of u-wind", "m/s", UC_NONE},
   /* 162 */ {"AEVWD", "Analysis error of v-wind", "m/s", UC_NONE},
   /* 163 */ {"LPMTF", "Particulate matter (fine)", "log10(µg/m^3)", UC_NONE},
   /* 164 */ {"LIPMF", "Integrated column particulate matter (fine)", "log10(µg/m^3)", UC_NONE},
   /* 165 */ {"REFZR", "Derived radar reflectivity backscatter from rain", "mm^6/m^3", UC_NONE},
   /* 166 */ {"REFZI", "Derived radar reflectivity backscatter from ice", "mm^6/m^3", UC_NONE},
   /* 167 */ {"REFZC", "Derived radar reflectivity backscatter from parameterized convection", "mm^6/m^3", UC_NONE},
   /* 168 */ {"TCLSW", "Total column-integrated supercooled liquid water", "kg/m^2", UC_NONE},
   /* 169 */ {"TCOLM", "Total column-integrated melting ice", "kg/m^2", UC_NONE},
   /* 170 */ {"ELRDI", "Ellrod Index", "-", UC_NONE},
   /* 171 */ {"TSEC", "Seconds prior to initial reference time (defined in octects 18-20)", "sec", UC_NONE},
   /* 172 */ {"TSECA", "Seconds after initial reference time (defined in octets 18-20)", "sec", UC_NONE},
   /* 173 */ {"NUM", "Number of samples/observations", "-", UC_NONE},
   /* 174 */ {"AEPRS", "Analysis error of pressure", "Pa", UC_NONE},
   /* 175 */ {"ICSEV", "Icing severity", "-", UC_NONE},
   /* 176 */ {"ICPRB", "Icing probability", "%", UC_NONE},
   /* 177 */ {"LAVNI", "Low-level aviation interest", "-", UC_NONE},
   /* 178 */ {"HAVNI", "High-level aviation interest", "-", UC_NONE},
   /* 179 */ {"FLGHT", "Flight Category", "-", UC_NONE},
   /* 180 */ {"OZCON", "Ozone concentration", "PPB", UC_NONE},
   /* 181 */ {"OZCAT", "Categorical ozone concentration", "-", UC_NONE},
   /* 182 */ {"VEDH", "Vertical eddy diffusivity heat exchange (Kh)", "m^2/s", UC_NONE},
   /* 183 */ {"SIGV", "Sigma level value", "-", UC_NONE},
   /* 184 */ {"EWGT", "Ensemble Weight", "-", UC_NONE},
   /* 185 */ {"CICEL", "Confidence indicator - Ceiling", "-", UC_NONE},
   /* 186 */ {"CIVIS", "Confidence indicator - Visibility", "-", UC_NONE},
   /* 187 */ {"CIFLT", "Confidence indicator - Flight Category", "-", UC_NONE},
   /* 188 */ {"LAVV", "Latitude of V wind component of velocity", "deg", UC_NONE},
   /* 189 */ {"LOVV", "Longitude of V wind component of velocity", "deg", UC_NONE},
   /* 190 */ {"USCT", "Scatterometer estimated U wind component", "m/s", UC_NONE},
   /* 191 */ {"VSCT", "Scatterometer estimated V wind component", "m/s", UC_NONE},
   /* 192 */ {"LAUV", "Latitude of U wind component of velocity", "deg", UC_NONE},
   /* 193 */ {"LOUV", "Longitude of U wind component of velocity", "deg", UC_NONE},
   /* 194 */ {"TCHP", "Tropical Cyclone Heat Potential", "J/m^2", UC_NONE},
   /* 195 */ {"DBSS", "Geometric Depth Below Sea Surface", "m", UC_NONE},
   /* 196 */ {"ODHA", "Ocean Dynamic Height Anomaly", "dynamic m", UC_NONE},
   /* 197 */ {"OHC", "Ocean Heat Content", "J/m^2", UC_NONE},
   /* 198 */ {"SSHG", "Sea Surface Height Relative to Geoid", "m", UC_NONE},
   /* 199 */ {"SLTFL", "Salt Flux", "kg/m^2s", UC_NONE},
   /* 200 */ {"DUVB", "UV-B downward solar flux", "W/m^2", UC_NONE},
   /* 201 */ {"CDUVB", "Clear sky UV-B downward solar flux", "W/m^2", UC_NONE},
   /* 202 */ {"THFLX", "Total downward heat flux at surface (downward is positive)", "W/m^2", UC_NONE},
   /* 203 */ {"UVAR", "U velocity variance", "m^2/s^2", UC_NONE},
   /* 204 */ {"VVAR", "V velocity variance", "m^2/s^2", UC_NONE},
   /* 205 */ {"UVVCC", "UV Velocity Cross Correlation", "m^2/s^2", UC_NONE},
   /* 206 */ {"MCLS", "Meteorological Correlation Length Scale", "m", UC_NONE},
   /* 207 */ {"LAPP", "Latitude of pressure point", "deg", UC_NONE},
   /* 208 */ {"LOPP", "Longitude of pressure point", "deg", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"REFO", "Observed radar reflectivity", "dbZ", UC_NONE},
   /* 211 */ {"REFD", "Derived radar reflectivity", "dbZ", UC_NONE},
   /* 212 */ {"REFC", "Maximum/Composite radar reflectivity", "dbZ", UC_NONE},
   /* 213 */ {"SBT122", "Simulated Brightness Temperature for GOES12; Channel 2", "K", UC_K2F},
   /* 214 */ {"SBT123", "Simulated Brightness Temperature for GOES12; Channel 3", "K", UC_K2F},
   /* 215 */ {"SBT124", "Simulated Brightness Temperature for GOES12; Channel 4", "K", UC_K2F},
   /* 216 */ {"SBT125", "Simulated Brightness Temperature for GOES12; Channel 5", "K", UC_K2F},
   /* 217 */ {"MINRH", "Minimum Relative Humidity", "%", UC_NONE},
   /* 218 */ {"MAXRH", "Maximum Relative Humidity", "%", UC_NONE},
   /* 219 */ {"CEIL", "Ceiling", "m", UC_NONE},
   /* 220 */ {"PBLREG", "Planetary boundary layer Regime", "", UC_NONE},
   /* 221 */ {"SBC123", "Simulated Brightness Counts for GOES12; Channel 3", "Byte", UC_NONE},
   /* 222 */ {"SBC124", "Simulated Brightness Counts for GOES12; Channel 4", "Byte", UC_NONE},
   /* 223 */ {"RPRATE", "Rain Precipitation Rate", "kg/m^2/s", UC_NONE},
   /* 224 */ {"SPRATE", "Snow Precipitation Rate", "kg/m^2/s", UC_NONE},
   /* 225 */ {"FPRATE", "Freezing Rain Precipitation Rate", "kg/m^2/s", UC_NONE},
   /* 226 */ {"IPRATE", "Ice Pellets Precipitation Rate", "kg/m^2/s", UC_NONE},
   /* 227 */ {"UPHL", "Updraft Helicity", "m^2/s^2", UC_NONE},
   /* 228 */ {"SURGE", "Storm Surge", "m", UC_NONE},
   /* 229 */ {"ETSRG", "Extra Tropical Storm Surge", "m", UC_NONE},
   /* 230 */ {"RHPW", "Relative Humidity with Respect to Precipitable Water", "%", UC_NONE},
   /* 231 */ {"OZMAX1", "Ozone Daily Max from 1-hour Average", "ppbV", UC_NONE},
   /* 232 */ {"OZMAX8", "Ozone Daily Max from 8-hour Average", "ppbV", UC_NONE},
   /* 233 */ {"PDMAX1", "PM 2.5 Daily Max from 1-hour Average", "µg/m^3", UC_NONE},
   /* 234 */ {"PDMAX24", "PM 2.5 Daily Max from 24-hour Average", "µg/m^3", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"RETOP", "Radar Echo Top (18.3 DBZ)", "m", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"TCSRG20", "20% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 243 */ {"TCSRG30", "30% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 244 */ {"TCSRG40", "40% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 245 */ {"TCSRG50", "50% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 246 */ {"TCSRG60", "60% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 247 */ {"TCSRG70", "70% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 248 */ {"TCSRG80", "80% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 249 */ {"TCSRG90", "90% Tropical Cyclone Storm Surge Exceedance", "m", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"DIFTEN", "Difference Between 2 States In Total Energy Norm", "J/kg", UC_NONE},
   /* 252 */ {"PSPCP", "Pseudo-Precipitation", "kg/m^2", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/* http://www.nco.ncep.noaa.gov/pmb/docs/on388/table2.html */
/* Updated last on 5/24/2003 */
const GRIB1ParmTable parm_table_nceptab_130[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"SOILW", "Volumetric soil moisture (frozen + liquid)", "fraction", UC_NONE},
   /* 145 */ {"PEVPR", "Potential latent heat flux (potential evaporation)", "W/m^2", UC_NONE},
   /* 146 */ {"VEGT", "Vegetation canopy temperature", "K", UC_K2F},
   /* 147 */ {"BARET", "Bare soil surface skin temperature", "K", UC_K2F},
   /* 148 */ {"AVSFT", "Average surface skin temperature", "K", UC_K2F},
   /* 149 */ {"RADT", "Effective radiative skin temperature", "K", UC_K2F},
   /* 150 */ {"SSTOR", "Surface water storage", "kg/m^2", UC_NONE},
   /* 151 */ {"LSOIL", "Liquid soil moisture content (non-frozen)", "kg/m^2", UC_NONE},
   /* 152 */ {"EWATR", "Open water evaporation (standing water)", "W/m^2", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"LSPA", "Land Surface Precipitation Accumulation (LSPA)", "kg/m^2", UC_NONE},
   /* 155 */ {"GFLUX", "Ground Heat Flux", "W/m^2", UC_NONE},
   /* 156 */ {"CIN", "Convective inhibition", "J/kg", UC_NONE},
   /* 157 */ {"CAPE", "Convective available potential energy", "J/kg", UC_NONE},
   /* 158 */ {"TKE", "Turbulent Kinetic Energy", "J/kg", UC_NONE},
   /* 159 */ {"MXSALB", "Maximum snow albedo", "%", UC_NONE},
   /* 160 */ {"SOILL", "Liquid volumetric soil moisture (non-frozen)", "kg/m^2", UC_NONE},
   /* 161 */ {"ASNOW", "Frozen precipitation (e.g. snowfall)", "kg/m^2", UC_NONE},
   /* 162 */ {"ARAIN", "Liquid precipitation (rainfall)", "kg/m^2", UC_NONE},
   /* 163 */ {"GWREC", "Groundwater recharge", "kg/m^2", UC_NONE},
   /* 164 */ {"QREC", "Flood plain recharge", "kg/m^2", UC_NONE},
   /* 165 */ {"SNOWT", "Snow temperature; depth-avg", "K", UC_K2F},
   /* 166 */ {"VBDSF", "Visible beam downward solar flux", "W/m^2", UC_NONE},
   /* 167 */ {"VDDSF", "Visible diffuse downward solar flux", "W/m^2", UC_NONE},
   /* 168 */ {"NBDSF", "Near IR beam downward solar flux", "W/m^2", UC_NONE},
   /* 169 */ {"NDDSF", "Near IR diffuse downward solar flux", "W/m^2", UC_NONE},
   /* 170 */ {"SNFALB", "Snow-free albedo", "%", UC_NONE},
   /* 171 */ {"RLYRS", "Number of soil layers in root zone", "-", UC_NONE},
   /* 172 */ {"MFLX", "Momentum flux", "N/m^2", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"NLAT", "Latitude (-90 to +90)", "deg", UC_NONE},
   /* 177 */ {"ELON", "East longitude (0-360)", "deg", UC_NONE},
   /* 178 */ {"FLDCAP", "Field Capacity (soil moisture)", "fraction", UC_NONE},
   /* 179 */ {"ACOND", "Aerodynamic conductance", "m/s", UC_NONE},
   /* 180 */ {"SNOAG", "Snow age", "s", UC_NONE},
   /* 181 */ {"CCOND", "Canopy conductance", "m/s", UC_NONE},
   /* 182 */ {"LAI", "Leaf area index (0-9)", "-", UC_NONE},
   /* 183 */ {"SFCRH", "Roughness length for heat", "m", UC_NONE},
   /* 184 */ {"SALBD", "Snow albedo (over snow cover area only)", "%", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"NDVI", "Normalized Difference Vegetation Index (NDVI)", "-", UC_NONE},
   /* 188 */ {"DRIP", "Canopy drip", "kg/m^2", UC_NONE},
   /* 189 */ {"VBSALB", "Visible; Black Sky Albedo", "%", UC_NONE},
   /* 190 */ {"VWSALB", "Visible; White Sky Albedo", "%", UC_NONE},
   /* 191 */ {"NBSALB", "Near IR; Black Sky Albedo", "%", UC_NONE},
   /* 192 */ {"NWSALB", "Near IR; White Sky Albedo", "%", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"SBSNO", "Sublimation (evaporation from snow)", "W/m^2", UC_NONE},
   /* 199 */ {"EVBS", "Direct evaporation from bare soil", "W/m^2", UC_NONE},
   /* 200 */ {"EVCW", "Canopy water evaporation", "W/m^2", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"RSMIN", "Minimal stomatal resistance", "s/m", UC_NONE},
   /* 204 */ {"DSWRF", "Downward shortwave radiation flux", "W/m^2", UC_NONE},
   /* 205 */ {"DLWRF", "Downward longwave radiation flux", "W/m^2", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"MSTAV", "Moisture availability", "%", UC_NONE},
   /* 208 */ {"SFEXC", "Exchange coefficient", "(kg/m^3)(m/s)", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"TRANS", "Transpiration", "W/m^2", UC_NONE},
   /* 211 */ {"USWRF", "Upward short wave radiation flux", "W/m^2", UC_NONE},
   /* 212 */ {"ULWRF", "Upward long wave radiation flux", "W/m^2", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"WILT", "Wilting point", "fraction", UC_NONE},
   /* 220 */ {"FLDCP", "Field Capacity", "fraction", UC_NONE},
   /* 221 */ {"HPBL", "Planetary boundary layer height", "m", UC_NONE},
   /* 222 */ {"SLTYP", "Surface slope type", "Index", UC_NONE},
   /* 223 */ {"CNWAT", "Plant canopy surface water", "kg/m^2", UC_NONE},
   /* 224 */ {"SOTYP", "Soil type", "Index (0-9)", UC_NONE},
   /* 225 */ {"VGTYP", "Vegetation type", "Index (0-13)", UC_NONE},
   /* 226 */ {"BMIXL", "Blackadar's mixing length scale", "m", UC_NONE},
   /* 227 */ {"AMIXL", "Asymptotic mixing length scale", "m", UC_NONE},
   /* 228 */ {"PEVAP", "Potential evaporation", "kg/m^2", UC_NONE},
   /* 229 */ {"SNOHF", "Snow phase-change heat flux", "W/m^2", UC_NONE},
   /* 230 */ {"SMREF", "Transpiration stress-onset (soil moisture)", "fraction", UC_NONE},
   /* 231 */ {"SMDRY", "Direct evaporation cease (soil moisture)", "fraction", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"BGRUN", "Subsurface runoff (baseflow)", "kg/m^2", UC_NONE},
   /* 235 */ {"SSRUN", "Surface runoff (non-infiltrating)", "kg/m^2", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"SNOWC", "Snow cover", "%", UC_NONE},
   /* 239 */ {"SNOT", "Snow temperature", "K", UC_K2F},
   /* 240 */ {"POROS", "Soil porosity", "fraction", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"RCS", "Solar parameter in canopy conductance", "fraction", UC_NONE},
   /* 247 */ {"RCT", "Temperature parameter in canopy conductance", "fraction", UC_NONE},
   /* 248 */ {"RCQ", "Humidity parameter in canopy conductance", "fraction", UC_NONE},
   /* 249 */ {"RCSOL", "Soil moisture parameter in canopy conductance", "fraction", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"CD", "Surface drag coefficient", "-", UC_NONE},
   /* 253 */ {"FRICV", "Surface friction velocity", "m/s", UC_NONE},
   /* 254 */ {"RI", "Richardson number", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/* Updated last on 9/8/2005 */
const GRIB1ParmTable parm_table_nceptab_131[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"MSLSA", "Mean sea level pressure (Std Atm)", "Pa", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"MSLET", "Mean sea level pressure (ETA model)", "Pa", UC_NONE},
   /* 131 */ {"LFTX", "Surface lifted index", "K", UC_NONE}, /* Delta temp. */
   /* 132 */ {"4LFTX", "Best (4-layer) lifted index", "K", UC_NONE}, /* Delta temp. */
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"PRESN", "Pressure (nearest grid point)", "Pa", UC_NONE},
   /* 135 */ {"MCONV", "Horizontal moisture divergence", "kg/kg/s", UC_NONE},
   /* 136 */ {"VWSH", "Vertical speed shear", "1/s", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"PVMW", "Potential vorticity (mass-weighted)", "1/s/m", UC_NONE},
   /* 140 */ {"CRAIN", "Categorical rain", "yes=1;no=0", UC_NONE},
   /* 141 */ {"CFRZR", "Categorical freezing rain", "yes=1;no=0", UC_NONE},
   /* 142 */ {"CICEP", "Categorical ice pellets", "yes=1;no=0", UC_NONE},
   /* 143 */ {"CSNOW", "Categorical snow", "yes=1;no=0", UC_NONE},
   /* 144 */ {"SOILW", "Volumetric soil moisture (frozen + liquid)", "fraction", UC_NONE},
   /* 145 */ {"PEVPR", "Potential evaporation rate", "W/m^2", UC_NONE},
   /* 146 */ {"VEGT", "Vegetation canopy temperature", "K", UC_K2F},
   /* 147 */ {"BARET", "Bare soil surface skin temperature", "K", UC_K2F},
   /* 148 */ {"AVSFT", "Average surface skin temperature", "K", UC_K2F},
   /* 149 */ {"RADT", "Effective radiative skin temperature", "K", UC_K2F},
   /* 150 */ {"SSTOR", "Surface water storage", "kg/m^2", UC_NONE},
   /* 151 */ {"LSOIL", "Liquid soil moisture content (non-frozen)", "kg/m^2", UC_NONE},
   /* 152 */ {"EWATR", "Open water evaporation (standing water)", "W/m^2", UC_NONE},
   /* 153 */ {"CLWMR", "Cloud water", "kg/kg", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"GFLUX", "Ground Heat Flux", "W/m^2", UC_NONE},
   /* 156 */ {"CIN", "Convective inhibition", "J/kg", UC_NONE},
   /* 157 */ {"CAPE", "Convective available potential energy", "J/kg", UC_NONE},
   /* 158 */ {"TKE", "Turbulent Kinetic Energy", "J/kg", UC_NONE},
   /* 159 */ {"MXSALB", "Maximum snow albedo", "%", UC_NONE},
   /* 160 */ {"SOILL", "Liquid volumetric soil moisture (non-frozen)", "fraction", UC_NONE},
   /* 161 */ {"ASNOW", "Frozen precipitation (e.g. snowfall)", "kg/m^2", UC_NONE},
   /* 162 */ {"ARAIN", "Liquid precipitation (rainfall)", "kg/m^2", UC_NONE},
   /* 163 */ {"GWREC", "Groundwater recharge", "kg/m^2", UC_NONE},
   /* 164 */ {"QREC", "Flood plain recharge", "kg/m^2", UC_NONE},
   /* 165 */ {"SNOWT", "Snow temperature; depth-avg", "K", UC_K2F},
   /* 166 */ {"VBDSF", "Visible beam downward solar flux", "W/m^2", UC_NONE},
   /* 167 */ {"VDDSF", "Visible diffuse downward solar flux", "W/m^2", UC_NONE},
   /* 168 */ {"NBDSF", "Near IR beam downward solar flux", "W/m^2", UC_NONE},
   /* 169 */ {"NDDSF", "Near IR diffuse downward solar flux", "W/m^2", UC_NONE},
   /* 170 */ {"SNFALB", "Snow-free albedo", "%", UC_NONE},
   /* 171 */ {"RLYRS", "Number of soil layers in root zone", "-", UC_NONE},
   /* 172 */ {"MFLX", "Momentum flux", "N/m^2", UC_NONE},
   /* 173 */ {"LMH", "Mass point model surface", "-", UC_NONE},
   /* 174 */ {"LMV", "Velocity point model surface", "-", UC_NONE},
   /* 175 */ {"MLYNO", "Model layer number (from bottom up)", "-", UC_NONE},
   /* 176 */ {"NLAT", "Latitude (-90 to +90)", "deg", UC_NONE},
   /* 177 */ {"ELON", "East longitude (0-360)", "deg", UC_NONE},
   /* 178 */ {"ICMR", "Ice mixing ratio", "kg/kg", UC_NONE},
   /* 179 */ {"ACOND", "Aerodynamic conductance", "m/s", UC_NONE},
   /* 180 */ {"SNOAG", "Snow age", "s", UC_NONE},
   /* 181 */ {"CCOND", "Canopy conductance", "m/s", UC_NONE},
   /* 182 */ {"LAI", "Leaf area index (0-9)", "-", UC_NONE},
   /* 183 */ {"SFCRH", "Roughness length for heat", "m", UC_NONE},
   /* 184 */ {"SALBD", "Snow albedo (over snow cover area only)", "%", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"NDVI", "Normalized Difference Vegetation Index", "-", UC_NONE},
   /* 188 */ {"DRIP", "Rate of water dropping from canopy to gnd", "kg/m^2", UC_NONE},
   /* 189 */ {"LANDN", "Land-sea coverage (nearest neighbor)", "land=1,sea=0", UC_NONE},
   /* 190 */ {"HLCY", "Storm relative helicity", "m^2/s^2", UC_NONE},
   /* 191 */ {"NLATN", "Latitude (nearest neighbor) (-90 to +90)", "deg", UC_NONE},
   /* 192 */ {"ELONN", "East longitude (nearest neighbor) (0-360)", "deg", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"CPOFP", "Prob. of frozen precipitation", "%", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"USTM", "u-component of storm motion", "m/s", UC_NONE},
   /* 197 */ {"VSTM", "v-component of storm motion", "m/s", UC_NONE},
   /* 198 */ {"SBSNO", "Sublimation (evaporation from snow)", "W/m^2", UC_NONE},
   /* 199 */ {"EVBS", "Direct evaporation from bare soil", "W/m^2", UC_NONE},
   /* 200 */ {"EVCW", "Canopy water evaporation", "W/m^2", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"APCPN", "Total precipitation (nearest grid point)", "kg/m^2", UC_NONE},
   /* 203 */ {"RSMIN", "Minimal stomatal resistance", "s/m", UC_NONE},
   /* 204 */ {"DSWRF", "Downward shortwave radiation flux", "W/m^2", UC_NONE},
   /* 205 */ {"DLWRF", "Downward longwave radiation flux", "W/m^2", UC_NONE},
   /* 206 */ {"ACPCPN", "Convective precipitation (nearest grid point)", "kg/m^2", UC_NONE},
   /* 207 */ {"MSTAV", "Moisture availability", "%", UC_NONE},
   /* 208 */ {"SFEXC", "Exchange coefficient", "(kg/m^3)(m/s)", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"TRANS", "Transpiration", "W/m^2", UC_NONE},
   /* 211 */ {"USWRF", "Upward short wave radiation flux", "W/m^2", UC_NONE},
   /* 212 */ {"ULWRF", "Upward long wave radiation flux", "W/m^2", UC_NONE},
   /* 213 */ {"CDLYR", "Non -convective cloud", "%", UC_NONE},
   /* 214 */ {"CPRAT", "Convective precip. rate", "kg/m^2/s", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"TTRAD", "Temperature tendency by all radiation", "K/s", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"HGTN", "Geopotential Height (nearest grid point)", "gpm", UC_NONE},
   /* 219 */ {"WILT", "Wilting point", "fraction", UC_NONE},
   /* 220 */ {"FLDCP", "Field Capacity", "fraction", UC_NONE},
   /* 221 */ {"HPBL", "Planetary boundary layer height", "m", UC_NONE},
   /* 222 */ {"SLTYP", "Surface slope type", "index", UC_NONE},
   /* 223 */ {"CNWAT", "Plant canopy surface water", "kg/m^2", UC_NONE},
   /* 224 */ {"SOTYP", "Soil type", "index", UC_NONE},
   /* 225 */ {"VGTYP", "Vegetation type", "index", UC_NONE},
   /* 226 */ {"BMIXL", "Blackadars mixing length scale", "m", UC_NONE},
   /* 227 */ {"AMIXL", "Asymptotic mixing length scale", "m", UC_NONE},
   /* 228 */ {"PEVAP", "Potential evaporation", "kg/m^2", UC_NONE},
   /* 229 */ {"SNOHF", "Snow phase-change heat flux", "W/m^2", UC_NONE},
   /* 230 */ {"SMREF", "Transpiration stress-onset (soil moisture)", "fraction", UC_NONE},
   /* 231 */ {"SMDRY", "Direct evaporation cease (soil moisture)", "fraction", UC_NONE},
   /* 232 */ {"WVINC", "water vapor added by precip assimilation", "kg/m^2", UC_NONE},
   /* 233 */ {"WCINC", "water condensate added by precip assimilation", "kg/m^2", UC_NONE},
   /* 234 */ {"BGRUN", "Subsurface runoff (baseflow)", "kg/m^2", UC_NONE},
   /* 235 */ {"SSRUN", "Surface runoff (non-infiltrating)", "kg/m^2", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"WVCONV", "Water vapor flux convergence (vertical int)", "kg/m^2", UC_NONE},
   /* 238 */ {"SNOWC", "Snow cover", "%", UC_NONE},
   /* 239 */ {"SNOT", "Snow temperature", "K", UC_K2F},
   /* 240 */ {"POROS", "Soil porosity", "fraction", UC_NONE},
   /* 241 */ {"WCCONV", "Water condensate flux convergence (vertical int)", "kg/m^2", UC_NONE},
   /* 242 */ {"WVUFLX", "Water vapor zonal flux (vertical int)", "kg/m", UC_NONE},
   /* 243 */ {"WVVFLX", "Water vapor meridional flux (vertical int)", "kg/m", UC_NONE},
   /* 244 */ {"WCUFLX", "Water condensate zonal flux (vertical int)", "kg/m", UC_NONE},
   /* 245 */ {"WCVFLX", "Water condensate meridional flux (vertical int)", "kg/m", UC_NONE},
   /* 246 */ {"RCS", "Solar parameter in canopy conductance", "fraction", UC_NONE},
   /* 247 */ {"RCT", "Temperature parameter in canopy conductance", "fraction", UC_NONE},
   /* 248 */ {"RCQ", "Humidity parameter in canopy conductance", "fraction", UC_NONE},
   /* 249 */ {"RCSOL", "Soil moisture parameter in canopy conductance", "fraction", UC_NONE},
   /* 250 */ {"SWHR", "Solar radiative heating rate", "K/s", UC_NONE},
   /* 251 */ {"LWHR", "Longwave radiative heating rate", "K/s", UC_NONE},
   /* 252 */ {"CD", "Surface drag coefficient", "-", UC_NONE},
   /* 253 */ {"FRICV", "Surface friction velocity", "m/s", UC_NONE},
   /* 254 */ {"RI", "Richardson number", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/* Updated last on 8/25/2008 */
const GRIB1ParmTable parm_table_nceptab_133[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"POZT", "Ozone production from temperature term", "kg/kg/s", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"OMGALF", "Omega (Dp/Dt) divide by density", "K", UC_NONE},  /* delta temp? */
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"COVZZ", "Covariance between zonal and zonal components of the wind.", "m^2/s^2", UC_NONE},
   /* 165 */ {"COVMM", "Covariance between meridional and meridional components of the wind.", "m^2/s^2", UC_NONE},
   /* 166 */ {"COVQZ", "Covariance between specific humidity and zonal components of the wind.", "kg/kg*m/s", UC_NONE},
   /* 167 */ {"COVQM", "Covariance between specific humidity and meridional components of the wind.", "kg/kg*m/s", UC_NONE},
   /* 168 */ {"COVTVV", "Covariance between temperature and vertical components of the wind.", "K*Pa/s", UC_NONE},
   /* 169 */ {"COVQVV", "Covariance between specific humidity and vertical components of the wind.", "kg/kg*Pa/s", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"LRGMR", "Large scale moistening rate", "kg/kg/s", UC_NONE},
   /* 174 */ {"VDFOZ", "Ozone vertical diffusion", "kg/kg/s", UC_NONE},
   /* 175 */ {"POZ", "Ozone production", "kg/kg/s", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"GWDU", "Gravity wave drag zonal acceleration", "m/s^2", UC_NONE},
   /* 182 */ {"GWDV", "Gravity wave drag meridional acceleration", "m/s^2", UC_NONE},
   /* 183 */ {"CNVU", "Convective zonal momentum mixing acceleration", "m/s^2", UC_NONE},
   /* 184 */ {"CNVV", "Convective meridional momentum mixing acceleration", "m/s^2", UC_NONE},
   /* 185 */ {"AKHS", "Surface exchange coefficients for T and Q divided by delta z", "m/s", UC_NONE},
   /* 186 */ {"AKMS", "Surface exchange coefficients for U and V divided by delta z", "m/s", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"TOZ", "Ozone tendency", "kg/kg/s", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"SUNSD", "Sunshine Duration", "s", UC_NONE},
   /* 192 */ {"MOSF", "Meridional Overturning Stream Function", "10^6m^3s^-1", UC_NONE},
   /* 193 */ {"EPSR", "Radiative emissivity", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"QZ0", "Specific humidity at top of viscous sublayer", "kg/kg", UC_NONE},
   /* 196 */ {"CNGWDU", "Convective Gravity wave drag zonal acceleration", "m/s^2", UC_NONE},
   /* 197 */ {"CNGWDV", "Convective Gravity wave drag meridional acceleration", "m/s^2", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"THZ0", "Potential temperature at top of viscous sublayer", "K", UC_NONE}, /* delta temp. */
   /* 202 */ {"CNVUMF", "Convective updraft mass flux", "kg/m^2/s", UC_NONE},
   /* 203 */ {"COVPSPS", "Covariance between surface pressure and surface pressure.", "Pa*Pa", UC_NONE},
   /* 204 */ {"QMAX", "Maximum specific humidity at 2m", "kg/kg", UC_NONE},
   /* 205 */ {"QMIN", "Minimum specific humidity at 2m", "kg/kg", UC_NONE},
   /* 206 */ {"COVQQ", "Covariance between specific humidity and specific humidity", "kg/kg*kg/kg", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"CNVDMF", "Convective downdraft mass flux", "kg/m^2/s", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"CNVDEMF", "Convective detrainment mass flux", "kg/m^2/s", UC_NONE},
   /* 220 */ {"COVVVVV", "Convariance between vertical and vertical components of the wind", "Pa^2/s^2", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"COVTT", "Covariance between temperature and temperature", "K*K", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"WTEND", "Tendency of vertical velocity", "m/s^2", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"POZO", "Ozone production from col ozone term", "kg/kg/s", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/* Updated last on 8/25/2008 */
const GRIB1ParmTable parm_table_nceptab_140[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"MEIP", "Mean Icing Potential", "-", UC_NONE},
   /* 169 */ {"MAIP", "Maximum Icing Potential", "-", UC_NONE},
   /* 170 */ {"MECTP", "Mean in-Cloud Turbulence Potential", "-", UC_NONE},
   /* 171 */ {"MACTP", "Max in-Cloud Turbulence Potential", "-", UC_NONE},
   /* 172 */ {"MECAT", "Mean Cloud Air Turbulence Potential", "-", UC_NONE},
   /* 173 */ {"MACAT", "Maximum Cloud Air Turbulence Potential", "-", UC_NONE},
   /* 174 */ {"CBHE", "Cumulonimbus Horizontal Extent", "%", UC_NONE},
   /* 175 */ {"PCBB", "Pressure at Cumulonimbus Base", "Pa", UC_NONE},
   /* 176 */ {"PCBT", "Pressure at Cumulonimbus Top", "Pa", UC_NONE},
   /* 177 */ {"PECBB", "Pressure at Embedded Cumulonimbus Base", "Pa", UC_NONE},
   /* 178 */ {"PECBT", "Pressure at Embedded Cumulonimbus Top", "Pa", UC_NONE},
   /* 179 */ {"HCBB", "ICAO Height at Cumulonimbus Base", "m", UC_NONE},
   /* 180 */ {"HCBT", "ICAO Height at Cumulonimbus Top", "m", UC_NONE},
   /* 181 */ {"HECBB", "ICAO Height at Embedded Cumulonimbus Base", "m", UC_NONE},
   /* 182 */ {"HECBT", "ICAO Height at Embedded Cumulonimbus Top", "m", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/* Updated last on 8/25/2008 */
const GRIB1ParmTable parm_table_nceptab_141[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"EXTNC", "Aerosol Extinction Coefficient", "1/km", UC_NONE},
   /* 129 */ {"AOD", "Aerosol Optical Depth", "-", UC_NONE},
   /* 130 */ {"ASFTR", "Aerosol Asymmetry Factor", "-", UC_NONE},
   /* 131 */ {"SSALBD", "Aerosol Single Scatter Albedo", "-", UC_NONE},
   /* 132 */ {"BSCTRS", "Aerosol Back Scattering", "1/km*sr", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"NOy", "Total Inorganic and Organic Nitrates", "ppbV", UC_NONE},
   /* 141 */ {"NO", "Nitrogen Oxide", "ppbV", UC_NONE},
   /* 142 */ {"NO2", "Nitrogen Dioxide", "ppbV", UC_NONE},
   /* 143 */ {"N2O5", "Nitrogen Pentoxide", "ppbV", UC_NONE},
   /* 144 */ {"HNO3", "Nitric Acid", "ppbV", UC_NONE},
   /* 145 */ {"NO3", "Nitrogen Trioxide", "ppbV", UC_NONE},
   /* 146 */ {"PNA", "Peroxynitric Acid", "ppbV", UC_NONE},
   /* 147 */ {"HONO", "Nitrous Acid", "ppbV", UC_NONE},
   /* 148 */ {"CO", "Carbon Monoxide", "ppbV", UC_NONE},
   /* 149 */ {"NH3", "Ammonia", "ppbV", UC_NONE},
   /* 150 */ {"HCL", "Hydrogen Chloride", "ppbV", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"PAR", "Lumped Single-Bond Carbon Specie", "ppbV", UC_NONE},
   /* 160 */ {"ETHE", "Ethene", "ppbV", UC_NONE},
   /* 161 */ {"OLE", "Lumped Double-Bond Carbon Specied Less Ethene", "ppbV", UC_NONE},
   /* 162 */ {"TOL", "Toluene", "ppbV", UC_NONE},
   /* 163 */ {"XYL", "Xylene", "ppbV", UC_NONE},
   /* 164 */ {"ISOP", "Isoprene", "ppbV", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"FORM", "Formaldehyde", "ppbV", UC_NONE},
   /* 167 */ {"ALD2", "Acetaldehyde and Higher Aldehydes", "ppbV", UC_NONE},
   /* 168 */ {"MGLY", "Methyl Glyoxal", "ppbV", UC_NONE},
   /* 169 */ {"CRES", "Cresol and Higher Molecular Weight Phenols", "ppbV", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"PAN", "Peroxyacyl Nitrate", "ppbV", UC_NONE},
   /* 173 */ {"NTR", "Lumped Gaseous Organic Nitrate", "ppbV", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"ROOH", "Esters", "ppbV", UC_NONE},
   /* 178 */ {"ETHOH", "Ethanol", "ppbV", UC_NONE},
   /* 179 */ {"METHOH", "Methanol", "ppbV", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"H2O2", "Hydrogen Peroxide", "ppbV", UC_NONE},
   /* 187 */ {"OH", "Hydroxyl Radical", "ppbV", UC_NONE},
   /* 188 */ {"HO2", "Hydroperoxyl Radical", "ppbV", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"ASO4", "Sulfate (SO4) Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 201 */ {"ANH4", "Ammonia (NH4) Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 202 */ {"ANO3", "Nitrate (NO3) Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 203 */ {"AORGA", "Organic Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 204 */ {"AORGPA", "Primarily Organic Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 205 */ {"AORGB", "Biogenically Originated Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 206 */ {"AEC", "Elemental Carbon Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 207 */ {"A25", "Unspecified Anthropogenic Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 208 */ {"AH2O", "Water Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 209 */ {"ANA", "Sodium Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 210 */ {"ACL", "Chloride Particulates <= 2.5 µm Diameter", "µg/m^3", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"ASO4K", "Sulfate (SO4) Particulates between 2.5 and 10 µm Diameter", "µg/m^3", UC_NONE},
   /* 217 */ {"ANAK", "Sodium (NA) Particulates between 2.5 and 10 µm Diameter", "µg/m^3", UC_NONE},
   /* 218 */ {"ACLK", "Chloride (CL) Particulates between 2.5 and 10 µm Diameter", "µg/m^3", UC_NONE},
   /* 219 */ {"ASEAS", "Sea Salt Originated Particulates between 2.5 and 10 µm Diameter", "µg/m^3", UC_NONE},
   /* 220 */ {"ASOIL", "Crustal Material Originated Particulates between 2.5 and 10 µm Diameter", "µg/m^3", UC_NONE},
   /* 221 */ {"ACORS", "Particulates between 2.5 and 10 µm Diameter", "µg/m^3", UC_NONE},
   /* 222 */ {"NUMATKN", "Number Concentration Particulates between 2.5 and 0.1 µm Diameter", "number/m^3", UC_NONE},
   /* 223 */ {"NUMACC", "Number Concentration Particulates between 2.5 and 2.5 µm Diameter", "number/m^3", UC_NONE},
   /* 224 */ {"NUMCOR", "Number Concentration Particulates between 2.5 and 10 µm Diameter", "number/m^3", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"SRFATKN", "Surface Area Contributed by Particulates <= 0.1 µm Diameter", "m^2/m^3", UC_NONE},
   /* 229 */ {"SRFACC", "Surface Area Contributed by Particulates between 0.1 and 2.5 µm Diameter", "m^2/m^3", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"SO2", "Sulfur Dioxide", "ppbV", UC_NONE},
   /* 233 */ {"MSA", "Methanesulfonic Acid", "kg/kg", UC_NONE},
   /* 234 */ {"TSO4", "Total Sulfate Particulates (Fine and Coarse)", "µg/m^3", UC_NONE},
   /* 235 */ {"DMS", "Dimethylsulfide", "kg/kg", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"DU1", "Dust Particulates between 0.2 - 2.0 µm Diameter", "kg/kg", UC_NONE},
   /* 241 */ {"DU2", "Dust Particulates between 2.0 - 3.6 µm Diameter", "kg/kg", UC_NONE},
   /* 242 */ {"DU3", "Dust Particulates between 3.6 - 6.0 µm Diameter", "kg/kg", UC_NONE},
   /* 243 */ {"DU4", "Dust Particulates between 6.0 - 12.0 µm Diameter", "kg/kg", UC_NONE},
   /* 244 */ {"DU5", "Dust Particulates between 12.0 - 20.0 µm Diameter", "kg/kg", UC_NONE},
   /* 245 */ {"SS1", "Sea Salt Particulates between 0.2 - 1.0 µm Diameter", "kg/kg", UC_NONE},
   /* 246 */ {"SS2", "Sea Salt Particulates between 1.0 - 3.0 µm Diameter", "kg/kg", UC_NONE},
   /* 247 */ {"SS3", "Sea Salt Particulates between 3.0 - 10.0 µm Diameter", "kg/kg", UC_NONE},
   /* 248 */ {"SS4", "Sea Salt Particulates between 10.0 - 20.0 µm Diameter", "kg/kg", UC_NONE},
   /* 249 */ {"OCDRY", "Hydrophobic Organic Carbon", "kg/kg", UC_NONE},
   /* 250 */ {"OCWET", "Hydrophilic Organic Carbon", "kg/kg", UC_NONE},
   /* 251 */ {"BCDRY", "Hydrophobic Black Carbon", "kg/kg", UC_NONE},
   /* 252 */ {"BCWET", "Hydrophilic Black Carbon", "kg/kg", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/* *INDENT-ON*  */

/* NOHSRC */
/* See: http://www.nohrsc.noaa.gov/technology/pdf/nohrsc_product_identifier.pdf */
/* Updated last on 10/17/2005 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_nohrsc[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"SC", "Snow cover", "50=no-snow/no-clouds,100=clouds,250=snow",
              UC_NONE},
   /* 208 */ {"SCE", "Snow cover by elevation",
              "0-252=Elevation in 100s of m,253=no-snow/no-cloud,254=no-cloud",
              UC_NONE},
   /* 209 */ {"SWE", "Snow water equivalent", "2cm", UC_NONE},
   /* 210 */ {"SWEPN", "Snow water equivalent percent of normal", "%", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*
 * parameter table for the NCEP/NCAR Reanalysis Project
 * center = 7, subcenter = 0/2, parameter table = 1/2
 * in a SNAFU the operational and reanalysis tables diverged
 * and both retained the same parameter table numbers (1,2)
 *
 * some of the Reanalysis files have subcenter=2 while others
 * use subcenter=0  (subcenter field is not standard (7/97))
 *
 * Some ways to tell Reanalysis files from OPN files
 * Reanalysis: always generated by process 80 - T62 28 level model
 * Original subcenter=0 Reanalysis files had
 * 2.5x2.5 (144x73) lat-long grid or 192x94 Gaussian grid (PDS grid=255?)
 */
const GRIB1ParmTable parm_table_ncep_reanal[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Std dev of height", "m", UC_NONE},
   /* 10 */ {"HVAR", "Variance of height", "m^2", UC_NONE},
   /* 11 */ {"TMP", "Temp.", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temp.", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temp.", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic pot. temp.", "K", UC_K2F},
   /* 15 */ {"TMAX", "Max. temp.", "K", UC_K2F},
   /* 16 */ {"TMIN", "Min. temp.", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temp.", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar spectra (3)", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"TMPA", "Temp. anomaly", "K", UC_NONE}, /* Delta temp?? */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coord. vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Pressure vertical velocity", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Geometric vertical velocity", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/kg", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equiv.", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Accum. snow", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low level cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Mid level cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High level cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water temp.", "K", UC_K2F},
   /* 81 */ {"LAND", "Land-sea mask", "1=land; 0=sea", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temp.", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"RUNOF", "Runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration", "ice=1;no ice=0", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Sig height of wind waves and swell", "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Sig height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Sig height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave (surface)", "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave (surface)", "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave (top)", "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave (top)", "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation", "W/m^2", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Zonal momentum flux", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Meridional momentum flux", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "integer", UC_NONE},
   /* 128 */ {"MSLSA", "Mean sea level pressure (Std Atm)", "Pa", UC_NONE},
   /* 129 */ {"MSLMA", "Mean sea level pressure (MAPS)", "Pa", UC_NONE},
   /* 130 */ {"MSLET", "Mean sea level pressure (ETA model)", "Pa", UC_NONE},
   /* 131 */ {"LFTX", "Surface lifted index", "K", UC_NONE}, /* Delta temp. */
   /* 132 */ {"4LFTX", "Best (4-layer) lifted index", "K", UC_NONE},
              /* Delta temp. */
   /* 133 */ {"KX", "K index", "K", UC_NONE}, /* Delta temp. */
   /* 134 */ {"SX", "Sweat index", "K", UC_NONE}, /* Delta temp. */
   /* 135 */ {"MCONV", "Horizontal moisture divergence", "kg/kg/s", UC_NONE},
   /* 136 */ {"VSSH", "Vertical speed shear", "1/s", UC_NONE},
   /* 137 */ {"TSLSA", "3-hr pressure tendency", "Pa/s", UC_NONE},
   /* 138 */ {"BVF2", "Brunt-Vaisala frequency^2", "1/s^2", UC_NONE},
   /* 139 */ {"PVMW", "Potential vorticity (mass-weighted)", "1/s/m",
              UC_NONE},
   /* 140 */ {"CRAIN", "Categorical rain", "yes=1;no=0", UC_NONE},
   /* 141 */ {"CFRZR", "Categorical freezing rain", "yes=1;no=0", UC_NONE},
   /* 142 */ {"CICEP", "Categorical ice pellets", "yes=1;no=0", UC_NONE},
   /* 143 */ {"CSNOW", "Categorical snow", "yes=1;no=0", UC_NONE},
   /* 144 */ {"SOILW", "Volumetric soil moisture", "fraction", UC_NONE},
   /* 145 */ {"PEVPR", "Potential evaporation rate", "W/m^2", UC_NONE},
   /* 146 */ {"CWORK", "Cloud work function", "J/kg", UC_NONE},
   /* 147 */ {"U-GWD", "Zonal gravity wave stress", "N/m^2", UC_NONE},
   /* 148 */ {"V-GWD", "Meridional gravity wave stress", "N/m^2", UC_NONE},
   /* 149 */ {"PV", "Potential vorticity", "m^2/s/kg", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"MFXDV", "Moisture flux divergence", "gr/gr*m/s/m", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"GFLUX", "Ground heat flux", "W/m^2", UC_NONE},
   /* 156 */ {"CIN", "Convective inhibition", "J/kg", UC_NONE},
   /* 157 */ {"CAPE", "Convective Avail. Pot. Energy", "J/kg", UC_NONE},
   /* 158 */ {"TKE", "Turbulent kinetic energy", "J/kg", UC_NONE},
   /* 159 */ {"CONDP", "Lifted parcel condensation pressure", "Pa", UC_NONE},
   /* 160 */ {"CSUSF", "Clear sky upward solar flux", "W/m^2", UC_NONE},
   /* 161 */ {"CSDSF", "Clear sky downward solar flux", "W/m^2", UC_NONE},
   /* 162 */ {"CSULF", "Clear sky upward long wave flux", "W/m^2", UC_NONE},
   /* 163 */ {"CSDLF", "Clear sky downward long wave flux", "W/m^2", UC_NONE},
   /* 164 */ {"CFNSF", "Cloud forcing net solar flux", "W/m^2", UC_NONE},
   /* 165 */ {"CFNLF", "Cloud forcing net long wave flux", "W/m^2", UC_NONE},
   /* 166 */ {"VBDSF", "Visible beam downward solar flux", "W/m^2", UC_NONE},
   /* 167 */ {"VDDSF", "Visible diffuse downward solar flux", "W/m^2",
              UC_NONE},
   /* 168 */ {"NBDSF", "Near IR beam downward solar flux", "W/m^2", UC_NONE},
   /* 169 */ {"NDDSF", "Near IR diffuse downward solar flux", "W/m^2",
              UC_NONE},
   /* 170 */ {"USTR", "U wind stress", "N/m^2", UC_NONE},
   /* 171 */ {"VSTR", "V wind stress", "N/m^2", UC_NONE},
   /* 172 */ {"MFLX", "Momentum flux", "N/m^2", UC_NONE},
   /* 173 */ {"LMH", "Mass point model surface", "integer", UC_NONE},
   /* 174 */ {"LMV", "Velocity point model surface", "integer", UC_NONE},
   /* 175 */ {"SGLYR", "Nearby model level", "integer", UC_NONE},
   /* 176 */ {"NLAT", "Latitude", "deg", UC_NONE},
   /* 177 */ {"NLON", "Longitude", "deg", UC_NONE},
   /* 178 */ {"UMAS", "Mass weighted u", "gm/m*K*s", UC_NONE},
   /* 179 */ {"VMAS", "Mass weighted v", "gm/m*K*s", UC_NONE},
   /* 180 */ {"XPRATE", "corrected precip", "kg/m^2/s", UC_NONE},
   /* 181 */ {"LPSX", "x-gradient of log pressure", "1/m", UC_NONE},
   /* 182 */ {"LPSY", "y-gradient of log pressure", "1/m", UC_NONE},
   /* 183 */ {"HGTX", "x-gradient of height", "m/m", UC_NONE},
   /* 184 */ {"HGTY", "y-gradient of height", "m/m", UC_NONE},
   /* 185 */ {"STDZ", "Std dev of Geop. hgt.", "m", UC_NONE},
   /* 186 */ {"STDU", "Std dev of zonal wind", "m/s", UC_NONE},
   /* 187 */ {"STDV", "Std dev of meridional wind", "m/s", UC_NONE},
   /* 188 */ {"STDQ", "Std dev of spec. hum.", "gm/gm", UC_NONE},
   /* 189 */ {"STDT", "Std dev of temp.", "K", UC_NONE},
   /* 190 */ {"CBUW", "Covar. u and omega", "m/s*Pa/s", UC_NONE},
   /* 191 */ {"CBVW", "Covar. v and omega", "m/s*Pa/s", UC_NONE},
   /* 192 */ {"CBUQ", "Covar. u and specific hum", "m/s*gm/gm", UC_NONE},
   /* 193 */ {"CBVQ", "Covar. v and specific hum", "m/s*gm/gm", UC_NONE},
   /* 194 */ {"CBTW", "Covar. T and omega", "K*Pa/s", UC_NONE},
   /* 195 */ {"CBQW", "Covar. spec. hum and omega", "gm/gm*Pa/s", UC_NONE},
   /* 196 */ {"CBMZW", "Covar. v and u", "m^2/s^2", UC_NONE},
   /* 197 */ {"CBTZW", "Covar. u and T", "K*m/s", UC_NONE},
   /* 198 */ {"CBTMW", "Covar. v and T", "K*m/s", UC_NONE},
   /* 199 */ {"STDRH", "Std dev of Rel. Hum.", "%", UC_NONE},
   /* 200 */ {"SDTZ", "Std dev of time tend of geop. hgt", "m", UC_NONE},
   /* 201 */ {"ICWAT", "Ice-free water surface", "%", UC_NONE},
   /* 202 */ {"SDTU", "Std dev of time tend of zonal wind", "m/s", UC_NONE},
   /* 203 */ {"SDTV", "Std dev of time tend of merid wind", "m/s", UC_NONE},
   /* 204 */ {"DSWRF", "Downward solar radiation flux", "W/m^2", UC_NONE},
   /* 205 */ {"DLWRF", "Downward long wave flux", "W/m^2", UC_NONE},
   /* 206 */ {"SDTQ", "Std dev of time tend of spec. hum", "gm/gm", UC_NONE},
   /* 207 */ {"MSTAV", "Moisture availability", "%", UC_NONE},
   /* 208 */ {"SFEXC", "Exchange coefficient", "kg*m/m^3/s", UC_NONE},
   /* 209 */ {"MIXLY", "No. of mixed layers next to sfc", "integer", UC_NONE},
   /* 210 */ {"SDTT", "Std dev of time tend of temp.", "K", UC_NONE},
   /* 211 */ {"USWRF", "Upward solar radiation flux", "W/m^2", UC_NONE},
   /* 212 */ {"ULWRF", "Upward long wave flux", "W/m^2", UC_NONE},
   /* 213 */ {"CDLYR", "Non-convective cloud", "%", UC_NONE},
   /* 214 */ {"CPRAT", "Convective precip. rate", "kg/m^2/s", UC_NONE},
   /* 215 */ {"TTDIA", "Temp. tendency by all physics", "K/s", UC_NONE},
   /* 216 */ {"TTRAD", "Temp. tendency by all radiation", "K/s", UC_NONE},
   /* 217 */ {"TTPHY", "Temp. tendency by nonrad physics", "K/s", UC_NONE},
   /* 218 */ {"PREIX", "Precipitation index", "fraction", UC_NONE},
   /* 219 */ {"TSD1D", "Std dev of IR T over 1x1 deg area", "K", UC_NONE},
   /* 220 */ {"NLSGP", "Natural log of surface pressure", "ln(kPa)", UC_NONE},
   /* 221 */ {"SDTRH", "Std dev of time tend of rel hum", "%", UC_NONE},
   /* 222 */ {"5WAVH", "5-wave geopotential height", "gpm", UC_NONE},
   /* 223 */ {"CNWAT", "Plant canopy surface water", "kg/m^2", UC_NONE},
   /* 224 */ {"PLTRS", "Max. stomato plant resistance", "s/m", UC_NONE},
   /* 225 */ {"RHCLD", "RH-type cloud cover", "%", UC_NONE},
   /* 226 */ {"BMIXL", "Blackadar's mixing length scale", "m", UC_NONE},
   /* 227 */ {"AMIXL", "Asymptotic mixing length scale", "m", UC_NONE},
   /* 228 */ {"PEVAP", "Pot. evaporation", "kg/m^2", UC_NONE},
   /* 229 */ {"SNOHF", "Snow melt heat flux", "W/m^2", UC_NONE},
   /* 230 */ {"SNOEV", "Snow sublimation heat flux", "W/m^2", UC_NONE},
   /* 231 */ {"MFLUX", "Convective cloud mass flux", "Pa/s", UC_NONE},
   /* 232 */ {"DTRF", "Downward total radiation flux", "W/m^2", UC_NONE},
   /* 233 */ {"UTRF", "Upward total radiation flux", "W/m^2", UC_NONE},
   /* 234 */ {"BGRUN", "Baseflow-groundwater runoff", "kg/m^2", UC_NONE},
   /* 235 */ {"SSRUN", "Storm surface runoff", "kg/m^2", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"OZONE", "Total column ozone", "Dobson", UC_NONE},
   /* 238 */ {"SNOWC", "Snow cover", "%", UC_NONE},
   /* 239 */ {"SNOT", "Snow temp.", "K", UC_K2F},
   /* 240 */ {"GLCR", "Permanent snow points", "mask", UC_NONE},
   /* 241 */ {"LRGHR", "Large scale condensation heating", "K/s", UC_NONE},
   /* 242 */ {"CNVHR", "Deep convective heating", "K/s", UC_NONE},
   /* 243 */ {"CNVMR", "Deep convective moistening", "kg/kg/s", UC_NONE},
   /* 244 */ {"SHAHR", "Shallow convective heating", "K/s", UC_NONE},
   /* 245 */ {"SHAMR", "Shallow convective moistening", "kg/kg/s", UC_NONE},
   /* 246 */ {"VDFHR", "Vertical diffusion heating", "K/s", UC_NONE},
   /* 247 */ {"VDFUA", "Vertical diffusion zonal accel", "m/s^2", UC_NONE},
   /* 248 */ {"VDFVA", "Vertical diffusion meridional accel", "m/s^2",
              UC_NONE},
   /* 249 */ {"VDFMR", "Vertical diffusion moistening", "kg/kg/s", UC_NONE},
   /* 250 */ {"SWHR", "Solar radiative heating", "K/s", UC_NONE},
   /* 251 */ {"LWHR", "Longwave radiative heating", "K/s", UC_NONE},
   /* 252 */ {"CD", "Drag coefficient", "-", UC_NONE},
   /* 253 */ {"FRICV", "Friction velocity", "m/s", UC_NONE},
   /* 254 */ {"RI", "Richardson number", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ncep_tdl[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Pot. vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "M",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Std dev of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temp.", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temp.", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temp.", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic pot. temp.", "K", UC_K2F},
   /* 15 */ {"TMAX", "Max. temp.", "K", UC_K2F},
   /* 16 */ {"TMIN", "Min. temp.", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temp.", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta temp */
   /* 25 */ {"TMPA", "Temp. anomaly", "K", UC_NONE}, /* Delta temp?? */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coord. vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Pressure vertical velocity", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Geometric vertical velocity", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/kg", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equiv.", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Accum. snow", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low level cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Mid level cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High level cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta temp?? */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water temp.", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1;sea=0)", "fraction", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temp.", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "fraction",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Sig height of wind waves and swell", "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Sig height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Sig height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave (surface)", "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave (surface)", "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave (top)", "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave (top)", "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance with respect to wave no.", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance with respect to wave len.", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Zonal momentum flux", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Meridional momentum flux", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"MINF", "Nighttime Min Temp", "F", UC_NONE},
   /* 132 */ {"MAXF", "Daytime Max Temp", "F", UC_NONE},
   /* 133 */ {"POP", "Prob of 0.01 In. of Precip (PoP)", "%", UC_NONE},
   /* 134 */ {"NMINF", "Normal Min Temperature", "F", UC_NONE},
   /* 135 */ {"NMAXF", "Normal Max Temperature", "F", UC_NONE},
   /* 136 */ {"NPOP", "Normal Rel. Freq. of 0.01 In of Pcp.", "%", UC_NONE},
   /* 137 */ {"DMINF", "Departure from Normal Min", "F", UC_NONE},
   /* 138 */ {"DMAXF", "Departure from Normal Max", "F", UC_NONE},
   /* 139 */ {"DPOP", "Departure from Normal PoP", "%", UC_NONE},
   /* 140 */ {"P--I", "Expected Value of Precip", "in", UC_NONE},
   /* 141 */ {"PQPF1", "Prob. of QPF >= 0.01 Inches", "%", UC_NONE},
   /* 142 */ {"PQPF2", "Prob. of QPF >= 0.10 Inches", "%", UC_NONE},
   /* 143 */ {"PQPF3", "Prob. of QPF >= 0.25 Inches", "%", UC_NONE},
   /* 144 */ {"PQPF4", "Prob. of QPF >= 0.50 Inches", "%", UC_NONE},
   /* 145 */ {"PQPF5", "Prob. of QPF >= 1.00 Inches", "%", UC_NONE},
   /* 146 */ {"PQPF6", "Prob. of QPF >= 2.00 Inches", "%", UC_NONE},
   /* 147 */ {"PTSTM", "Prob. of Tstms (Radar)", "%", UC_NONE},
   /* 148 */ {"TMPK", "Temperature", "K", UC_K2F},
   /* 149 */ {"PTSTL", "Prob. of Tstms (Ltng)", "%", UC_NONE},
   /* 150 */ {"CPSVR", "Cond Prob. of Severe Weather", "%", UC_NONE},
   /* 151 */ {"CPSVG", "Cond Prob. of Severe Wx (GRID)", "%", UC_NONE},
   /* 152 */ {"DWPK", "Dewpoint", "K", UC_K2F},
   /* 153 */ {"CATMH", "Index of LGT-MDT Clr Air Turb(HI)", "num", UC_NONE},
   /* 154 */ {"CATSH", "Index of MDT-SVR Clr Air Turb(HI)", "num", UC_NONE},
   /* 155 */ {"ICEH", "Index of Icing (HIGH)", "num", UC_NONE},
   /* 156 */ {"CATML", "Index of LGT-MDT Clr Air Turb(LO)", "num", UC_NONE},
   /* 157 */ {"CATSL", "Index of MDT-SVR Clr Air Turb(HI)", "num", UC_NONE},
   /* 158 */ {"ICEL", "Index of Icing (Low)", "num", UC_NONE},
   /* 159 */ {"TMPF", "Temperature", "F", UC_NONE},
   /* 160 */ {"DWPF", "Dewpoint", "F", UC_NONE},
   /* 161 */ {"IWSPK", "Inflated Wind Speed", "kts", UC_NONE},
   /* 162 */ {"PSKCL", "Prob of OPQ Sky:Clear", "%", UC_NONE},
   /* 163 */ {"PSKSC", "Prob of OPQ Sky:Scattered", "%", UC_NONE},
   /* 164 */ {"PSKBK", "Prob of OPQ Sky:Broken", "%", UC_NONE},
   /* 165 */ {"PSKOV", "Prob of OPQ Sky:Overcast", "%", UC_NONE},
   /* 166 */ {"PCIG1", "Prob of CIG HGT < 200 Ft", "%", UC_NONE},
   /* 167 */ {"PCIG2", "Prob of CIG HGT 200-400 Ft", "%", UC_NONE},
   /* 168 */ {"PCIG3", "Prob of CIG HGT 500-900 Ft", "%", UC_NONE},
   /* 169 */ {"PCIG4", "Prob of CIG HGT 1000-3000 Ft", "%", UC_NONE},
   /* 170 */ {"PCIG5", "Prob of CIG HGT 3100-6500 Ft", "%", UC_NONE},
   /* 171 */ {"PCIG6", "Prob of CIG HGT 6600-12000 Ft", "%", UC_NONE},
   /* 172 */ {"PCIG7", "Prob of CIG HGT > 12000 Ft", "%", UC_NONE},
   /* 173 */ {"PVIS1", "Prob of VIS < 1/2 Mile", "%", UC_NONE},
   /* 174 */ {"PVIS2", "Prob of VIS 1/2-7/8 Mile", "%", UC_NONE},
   /* 175 */ {"PVIS3", "Prob of VIS 1 - 2 3/4 Mile", "%", UC_NONE},
   /* 176 */ {"PVIS4", "Prob of VIS 3-5 Mile", "%", UC_NONE},
   /* 177 */ {"PVIS5", "Prob of VIS > 5 Mile", "%", UC_NONE},
   /* 178 */ {"NMINK", "Normal Min Temperature", "K", UC_K2F},
   /* 179 */ {"NMAXK", "Normal Max Temperature", "K", UC_K2F},
   /* 180 */ {"DMINK", "Departure From Normal Min", "K", UC_NONE},
              /* Delta Temp. */
   /* 181 */ {"DMAXK", "Departure From Normal Max", "K", UC_NONE},
              /* Delta Temp. */
   /* 182 */ {"KINDX", "K Index", "num", UC_NONE},
   /* 183 */ {"NVD", "Net Vertical Displacement", "Pa", UC_NONE},
   /* 184 */ {"SOLEN", "Solar Energy", "J/m^2", UC_NONE},
   /* 185 */ {"POVBL", "Prob. of Blowing Obvis", "%", UC_NONE},
   /* 186 */ {"POVHZ", "Prob. of Haze Obvis", "%", UC_NONE},
   /* 187 */ {"POVFG", "Prob. of Fog Obvis", "%", UC_NONE},
   /* 188 */ {"POVNO", "Prob. of No Obvis", "%", UC_NONE},
   /* 189 */ {"BCIG", "Best Category of Ceiling Height", "num", UC_NONE},
   /* 190 */ {"BVIS", "Best Category of Visibility", "num", UC_NONE},
   /* 191 */ {"BOBV", "Best Category of Obvis", "num", UC_NONE},
   /* 192 */ {"CPOS", "Cond. Prob. of Snow (CPoS)", "%", UC_NONE},
   /* 193 */ {"NCPOS", "Normal CPoS", "%", UC_NONE},
   /* 194 */ {"WINDM", "Mean Wind Speed (Wind)", "m/s", UC_NONE},
   /* 195 */ {"NWNDM", "Normal Mean Wind Speed", "m/s", UC_NONE},
   /* 196 */ {"CLDS", "Mean Opaque Cloudiness (Clds)", "tnths", UC_NONE},
   /* 197 */ {"NCLDS", "Normal Mean Opaque Cloudiness", "tnths", UC_NONE},
   /* 198 */ {"SUNSH", "Percent of possible sunshine", "%", UC_NONE},
   /* 199 */ {"HRSUN", "Hours of sunshine", "hrs", UC_NONE},
   /* 200 */ {"CPOSN", "Cond. Prob. of Snow", "%", UC_NONE},
   /* 201 */ {"CPOZP", "Cond. Prob. of Freezing Precip", "%", UC_NONE},
   /* 202 */ {"CPORA", "Cond. Prob. of Rain", "%", UC_NONE},
   /* 203 */ {"DPDK", "Dewpoint Depression", "K", UC_NONE}, /* Delta Temp. */
   /* 204 */ {"RELH", "Relative Humidity", "%", UC_NONE},
   /* 205 */ {"DPDF", "Dew Point Depression", "F", UC_NONE},
   /* 206 */ {"PSNA1", "Prob. of Snow Amount >= Trace", "%", UC_NONE},
   /* 207 */ {"PSNA2", "Prob. of Snow Amount >= 2 Inches", "%", UC_NONE},
   /* 208 */ {"PSNA3", "Prob. of Snow Amount >= 4 Inches", "%", UC_NONE},
   /* 209 */ {"PSNA4", "Prob. of Snow Amount >= 6 Inches", "%", UC_NONE},
   /* 210 */ {"BSNA", "Best Category for Snow Amount", "num", UC_NONE},
   /* 211 */ {"CPDRZ", "Cond. Prob. of Drizzle", "%", UC_NONE},
   /* 212 */ {"CPSTY", "Cond. Prob. of Cont (Steady) Precip", "%", UC_NONE},
   /* 213 */ {"CPSHW", "Cond. Prob. of Showers", "%", UC_NONE},
   /* 214 */ {"BPCPT", "Best Category of Precip Type", "num", UC_NONE},
   /* 215 */ {"BQPF", "Best Category of QPF", "num", UC_NONE},
   /* 216 */ {"BPCHR", "Best Cat of Precip Char Type", "num", UC_NONE},
   /* 217 */ {"BSKY", "Best Cat of Opaque Sky Cover", "num", UC_NONE},
   /* 218 */ {"DRCT", "Wind Direction", "deg true", UC_NONE},
   /* 219 */ {"HTINF", "Heat Index", "F", UC_NONE},
   /* 220 */ {"WNCHF", "Wind Chill Temperature", "F", UC_NONE},
   /* 221 */ {"HDGDY", "Heating/Cooling Degree Days", "num", UC_NONE},
   /* 222 */ {"MINK", "Nighttime Min Temp", "K", UC_K2F},
   /* 223 */ {"MAXK", "Daytime Max Temp", "K", UC_K2F},
   /* 224 */ {"P--M", "Expected Value of Precipitation", "kg/m^2", UC_NONE},
   /* 225 */ {"IWSPM", "Inflated Wind Speed", "m/s", UC_NONE},
   /* 226 */ {"HTINK", "Heat Index", "K", UC_K2F},
   /* 227 */ {"WNCHK", "Wind Chill Temperature", "K", UC_K2F},
   /* 228 */ {"DINDM", "Departure from Normal Wind", "m/s", UC_NONE},
   /* 229 */ {"WINDK", "Mean Wind Speed (Wind)", "kts", UC_NONE},
   /* 230 */ {"NWNDK", "Normal Mean Wind Speed", "kts", UC_NONE},
   /* 231 */ {"DINDK", "Departure from Normal Wind", "kts", UC_NONE},
   /* 232 */ {"WSPK", "Wind Speed", "kts", UC_NONE},
   /* 233 */ {"WSPM", "Wind Speed", "m/s", UC_NONE},
   /* 234 */ {"DCLDS", "Departure from Normal Clds", "tnths", UC_NONE},
   /* 235 */ {"DCPOS", "Departure from Normal CPoS", "%", UC_NONE},
   /* 236 */ {"TOTOT", "Total Totals Index", "num", UC_NONE},
   /* 237 */ {"CINST", "Convective Instability(SFC-700mb)", "K", UC_NONE},
              /* Delta Temp. */
   /* 238 */ {"KSOLN", "Solar Energy", "KWH/m^2", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"BTSTM", "Categorical T-Storm (Ltng)", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"BSVR", "Categorical Severe Weather", "num", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE}
};

const GRIB1ParmTable parm_table_ncep_mdl[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Pot. vorticity", "km^2/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "M",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Std dev of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temp.", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temp.", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temp.", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic pot. temp.", "K", UC_K2F},
   /* 15 */ {"TMAX", "Max. temp.", "K", UC_K2F},
   /* 16 */ {"TMIN", "Min. temp.", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temp.", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta Temp. */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temp. anomaly", "K", UC_NONE}, /* delta temp. */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coord. vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Pressure vertical velocity", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Geometric vertical velocity", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/kg", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equiv.", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Accum. snow", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low level cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Mid level cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High level cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water temp.", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1;sea=0)", "fraction", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temp.", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0)", "fraction",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Sig height of wind waves and swell", "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Sig height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Sig height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave (surface)", "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave (surface)", "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave (top)", "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave (top)", "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance with respect to wave no.", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance with respect to wave len.", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Zonal momentum flux", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Meridional momentum flux", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "", UC_NONE},
   /* 128 */ {"TMPF", "Temperature", "F", UC_NONE},
   /* 129 */ {"MAXK", "Daytime Max Temp", "K", UC_K2F},
   /* 130 */ {"MAXF", "Daytime Max Temp", "F", UC_NONE},
   /* 131 */ {"NMAXK", "Normal Max Temperature", "K", UC_K2F},
   /* 132 */ {"NMAXF", "Normal Max Temperature", "F", UC_NONE},
   /* 133 */ {"DMAXK", "Departure From Normal Max", "K", UC_K2F},
   /* 134 */ {"DMAXF", "Departure From Normal Max", "F", UC_NONE},
   /* 135 */ {"MINK", "Nighttime Min Temp", "K", UC_K2F},
   /* 136 */ {"MINF", "Nighttime Min Temp", "F", UC_NONE},
   /* 137 */ {"NMINK", "Normal Min Temperature", "K", UC_K2F},
   /* 138 */ {"NMINF", "Normal Nighttime Min Temp", "F", UC_NONE},
   /* 139 */ {"DMINK", "Departure From Normal Min", "K", UC_K2F},
   /* 140 */ {"DMINF", "Departure From Normal Min", "F", UC_NONE},
   /* 141 */ {"DWPF", "Dew Point Temperature", "F", UC_NONE},
   /* 142 */ {"DPDF", "Dew Point Depression", "F", UC_NONE},
   /* 143 */ {"HTINF", "Heat Index", "F", UC_NONE},
   /* 144 */ {"WNCHF", "Wind Chill", "F", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"POP", "Prob of 0.01 In. of Precip (PoP)", "%", UC_NONE},
   /* 147 */ {"PQPF2", "Prob of QPF >= 0.10 Inches", "%", UC_NONE},
   /* 148 */ {"PQPF3", "Prob of QPF >= 0.25 Inches", "%", UC_NONE},
   /* 149 */ {"PQPF4", "Prob of QPF >= 0.50 Inches", "%", UC_NONE},
   /* 150 */ {"PQPF5", "Prob of QPF >= 1.00 Inches", "%", UC_NONE},
   /* 151 */ {"PQPF6", "Prob of QPF >= 2.00 Inches", "%", UC_NONE},
   /* 152 */ {"PQPF7", "Prob of QPF >= 3.00 Inches Future", "%", UC_NONE},
   /* 153 */ {"BQPF", "Best Category of QPF", "-", UC_NONE},
   /* 154 */ {"NPOP", "Nml Rel. Freq. of 0.01 In of Pcp", "%", UC_NONE},
   /* 155 */ {"DPOP", "Departure From Nml of 0.01 PoP", "%", UC_NONE},
   /* 156 */ {"PCPM", "Expected Value of Precipitation", "mm", UC_NONE},
   /* 157 */ {"PCPI", "Expected Value of Precipitation", "in", UC_NONE},
   /* 158 */ {"CPCPM", "Conditional Expected Precip Amt", "mm", UC_NONE},
   /* 159 */ {"CPCPI", "Conditional Expected Precip Amt", "in", UC_NONE},
   /* 160 */ {"PSNA1", "Prob of Snow Amount >= 0.10", "%", UC_NONE},
   /* 161 */ {"PSNA2", "Prob of Snow Amount >= 2 Inches", "%", UC_NONE},
   /* 162 */ {"PSNA3", "Prob of Snow Amount >= 4 Inches", "%", UC_NONE},
   /* 163 */ {"PSNA4", "Prob of Snow Amount >= 6 Inches", "%", UC_NONE},
   /* 164 */ {"PSNA5", "Prob of Snow Amount >= 8 Inches", "%", UC_NONE},
   /* 165 */ {"BSNA", "Best Category For Snow Amount", "-", UC_NONE},
   /* 166 */ {"SNWM", "Expected Value of Snow Amount", "mm", UC_NONE},
   /* 167 */ {"SNWI", "Expected Value of Snow Amount", "in", UC_NONE},
   /* 168 */ {"MWSPK", "Inflated Max Wind Speed", "kts", UC_NONE},
   /* 169 */ {"IWSPM", "Inflated Wind Speed", "m/s", UC_NONE},
   /* 170 */ {"SKNT", "Inflated Wind Speed", "kts", UC_NONE},
   /* 171 */ {"PWSP1", "Prob of Max Wind Speed 0-12 kts", "%", UC_NONE},
   /* 172 */ {"PWSP2", "Prob of Max Wind Speed 13-21 kts", "%", UC_NONE},
   /* 173 */ {"PWSP3", "Prob of Max Wind Speed 22-31 kts", "%", UC_NONE},
   /* 174 */ {"PWSP4", "Prob of Max Wind Speed >= 32 kts", "%", UC_NONE},
   /* 175 */ {"WSPDC", "Categorical Max Wind Speed", "-", UC_NONE},
   /* 176 */ {"XSPDM", "Expected Value of Max Wind Speed", "m/s", UC_NONE},
   /* 177 */ {"XSPDK", "Expected Value of Max Wind Speed", "kts", UC_NONE},
   /* 178 */ {"PWDRN", "Prob of Wind Direction North", "%", UC_NONE},
   /* 179 */ {"PWDRNE", "Prob of Wind Direction NorthEast", "%", UC_NONE},
   /* 180 */ {"PWDRE", "Prob of Wind Direction East", "%", UC_NONE},
   /* 181 */ {"PWDRSE", "Prob of Wind Direction SouthEast", "%", UC_NONE},
   /* 182 */ {"PWDRS", "Prob of Wind Direction South", "%", UC_NONE},
   /* 183 */ {"PWDRSW", "Prob of Wind Direction SouthWest", "%", UC_NONE},
   /* 184 */ {"PWDRW", "Prob of Wind Direction West", "%", UC_NONE},
   /* 185 */ {"PWDRNW", "Prob of Wind Direction NorthWest", "%", UC_NONE},
   /* 186 */ {"WDIRC", "Categorical Wind Direction", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"PSKCL", "Prob of Total Sky:Clear", "%", UC_NONE},
   /* 189 */ {"PSKFW", "Prob of Total Sky:Few (Future)", "%", UC_NONE},
   /* 190 */ {"PSKSC", "Prob of Total Sky:Scattered", "%", UC_NONE},
   /* 191 */ {"PSKBK", "Prob of Total Sky:Broken", "%", UC_NONE},
   /* 192 */ {"PSKOV", "Prob of Total Sky:Overcast", "%", UC_NONE},
   /* 193 */ {"SKYC", "Categorical Total Sky Cover", "-", UC_NONE},
   /* 194 */ {"MSKCL", "Prob Mean Sky Cvr:Clear (Future)", "%", UC_NONE},
   /* 195 */ {"MSKOV", "Prob Mean Sky Cvr:Overcast (Future)", "%", UC_NONE},
   /* 196 */ {"MSKMC", "Prob Mean Sky Cvr:Mostly Clr", "%", UC_NONE},
   /* 197 */ {"MSKPC", "Prob Mean Sky Cvr:Partly Cldy", "%", UC_NONE},
   /* 198 */ {"MSKMO", "Prob Mean Sky Cvr:Mostly Cldy", "%", UC_NONE},
   /* 199 */ {"MSKYC", "Categorical Mean Sky Cover", "-", UC_NONE},
   /* 200 */ {"PCIG1", "Prob of CIG Hgt < 200 Ft", "%", UC_NONE},
   /* 201 */ {"PCIG2", "Prob of CIG Hgt 200-400 Ft", "%", UC_NONE},
   /* 202 */ {"PCIG3", "Prob of CIG Hgt 500-900 Ft", "%", UC_NONE},
   /* 203 */ {"PCIG4", "Prob of CIG Hgt 1000-3000 Ft", "%", UC_NONE},
   /* 204 */ {"PCIG5", "Prob of CIG Hgt 3100-6500 Ft", "%", UC_NONE},
   /* 205 */ {"PCIG6", "Prob of CIG Hgt 6600-12000 Ft", "%", UC_NONE},
   /* 206 */ {"PCIG7", "Prob of CIG Hgt > 12000 Ft", "%", UC_NONE},
   /* 207 */ {"BCIG", "Best Category of Ceiling Height", "-", UC_NONE},
   /* 208 */ {"PVIS1", "Prob of Vis <=1/4 Mile", "%", UC_NONE},
   /* 209 */ {"PVIS2", "Prob of Vis <=1/2 Mile", "%", UC_NONE},
   /* 210 */ {"PVIS3", "Prob of Vis <=7/8 Mile", "%", UC_NONE},
   /* 211 */ {"PVIS4", "Prob of Vis <=2 3/4 Miles", "%", UC_NONE},
   /* 212 */ {"PVIS5", "Prob of Vis <=5 Miles", "%", UC_NONE},
   /* 213 */ {"PVIS6", "Prob of Vis <=6 Miles", "%", UC_NONE},
   /* 214 */ {"VISC", "Categorical Visibility", "-", UC_NONE},
   /* 215 */ {"POBVN", "Prob of Obstruction to Vis: None", "%", UC_NONE},
   /* 216 */ {"POBVH", "Prob of Obstruction to Vis: Haze", "%", UC_NONE},
   /* 217 */ {"POBVM", "Prob of Obstruction to Vis: Mist", "%", UC_NONE},
   /* 218 */ {"POBVF", "Prob of Obstruction to Vis: Fog", "%", UC_NONE},
   /* 219 */ {"POVBL", "Prob of Blowing Ob-Vis", "%", UC_NONE},
   /* 220 */ {"OBVC", "Best Category of Ob-Vis", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"NTSM", "Normal Prob of Thunderstorms", "%", UC_NONE},
   /* 223 */ {"CSVR", "Cond Prob of Severe Weather", "%", UC_NONE},
   /* 224 */ {"USVR", "Uncond Prob of Severe Wx", "%", UC_NONE},
   /* 225 */ {"NSVR", "Normal Prob of Severe Wx", "%", UC_NONE},
   /* 226 */ {"UHAI", "Unconditional Prob of Hail", "%", UC_NONE},
   /* 227 */ {"UTOR", "Unconditional Prob of Tornado", "%", UC_NONE},
   /* 228 */ {"UTSW", "Uncond Prob of Damaging Wind", "%", UC_NONE},
   /* 229 */ {"CFZI", "Cond Prob Frzing Precip (Instant)", "%", UC_NONE},
   /* 230 */ {"UFZI", "Uncnd Prob Frzing Precip (Instnt)", "%", UC_NONE},
   /* 231 */ {"CZNI", "Cond Prob Frozen Precip (Instant)", "%", UC_NONE},
   /* 232 */ {"UZNI", "Uncnd Prob Frozen Precip (Instnt)", "%", UC_NONE},
   /* 233 */ {"CLQI", "Cond Prob Liquid Precip (Instant)", "%", UC_NONE},
   /* 234 */ {"ULQI", "Uncnd Prob Liquid Precip (Instnt)", "%", UC_NONE},
   /* 235 */ {"PTYPI", "Categorical Precip Type (Instant)", "-", UC_NONE},
   /* 236 */ {"CPOZP", "Cond Prob of Frzing Precip", "%", UC_NONE},
   /* 237 */ {"UPOZP", "Uncond Prob of Frzing Precip", "%", UC_NONE},
   /* 238 */ {"CPOS", "Cond Prob of Snow (CPoS)", "%", UC_NONE},
   /* 239 */ {"UPOS", "Uncond Prob of Snow (UPoS)", "%", UC_NONE},
   /* 240 */ {"CPORS", "Cond Prob of Rain/Snow Mixed", "%", UC_NONE},
   /* 241 */ {"UPORS", "Uncond Prob of Rain/Snow Mixed", "%", UC_NONE},
   /* 242 */ {"CPORA", "Cond Prob of Rain", "%", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"BPCPT", "Best Category of Precip Type", "-", UC_NONE},
   /* 245 */ {"POPOH", "POPO Precip Occurring at an Hour", "%", UC_NONE},
   /* 246 */ {"POPOP", "POPO Precip During a Period", "%", UC_NONE},
   /* 247 */ {"CPDRZ", "Cond Prob of Drizzle", "%", UC_NONE},
   /* 248 */ {"CPSTY", "Cond Prob of Cont (Steady) Precip", "%", UC_NONE},
   /* 249 */ {"CPSHW", "Cond Prob of Showers", "%", UC_NONE},
   /* 250 */ {"BPCHR", "Best Cat Precip Characteristic", "-", UC_NONE},
   /* 251 */ {"SUNSH", "Percent of Possible Sunshine", "%", UC_NONE},
   /* 252 */ {"HRSUN", "Hours of Sunshine", "hrs", UC_NONE},
   /* 253 */ {"SCQP", "Scan 0-3H Categorical QPF", "-", UC_NONE},
   /* 254 */ {"SCTS", "Scan 0-3H C-G Lightning Prob", "%", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*****************************************************************************
 * ECMWF Parameter Tables (GRIB1 Section 1 Table 2)
 * Table versions 128, 129, 130, 131, 140, 150, 160, 170, 180
 *****************************************************************************
 */

const GRIB1ParmTable parm_table_ecmwf_128[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 2 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 3 */ {"POT", "Potential Temperature", "K", UC_K2F},
   /* 4 */ {"var4", "Equivalent Potential Temperature", "K", UC_K2F},
   /* 5 */ {"var5", "Saturated Equivalent Potential Temperature", "K",
            UC_K2F},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "u-component of Divergent Wind", "m/s", UC_NONE},
   /* 12 */ {"var12", "v-component of Divergent Wind", "m/s", UC_NONE},
   /* 13 */ {"var13", "u-component of Rotational Wind", "m/s", UC_NONE},
   /* 14 */ {"var14", "v-component of Rotational Wind", "m/s", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"UCTP", "Unbalanced component of temperature", "K", UC_NONE},
   /* 22 */ {"UCLN", "Unbalanced component of lnsp", "-", UC_NONE},
   /* 23 */ {"UCDV", "Unbalanced component of divergence", "1/s", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"CL", "Lake cover (0-1)", "-", UC_NONE},
   /* 27 */ {"CVL", "Low vegetation cover (0-1)", "-", UC_NONE},
   /* 28 */ {"CVH", "High vegetation cover (0-1)", "-", UC_NONE},
   /* 29 */ {"TVL", "Type of low vegetation", "-", UC_NONE},
   /* 30 */ {"TVH", "Type of high vegetation", "-", UC_NONE},
   /* 31 */ {"CI", "Sea ice cover (0-1)", "-", UC_NONE},
   /* 32 */ {"ASN", "Snow albedo (0-1)", "-", UC_NONE},
   /* 33 */ {"RSN", "Snow density", "1/kg^3", UC_NONE},
   /* 34 */ {"SSTK", "Sea surface temperature (absolute)", "K", UC_NONE},
   /* 35 */ {"ISTL1", "Ice surface temperature layer 1", "K", UC_NONE},
   /* 36 */ {"ISTL2", "Ice surface temperature layer 2", "K", UC_NONE},
   /* 37 */ {"ISTL3", "Ice surface temperature layer 3", "K", UC_NONE},
   /* 38 */ {"ISTL4", "Ice surface temperature layer 4", "K", UC_NONE},
   /* 39 */ {"SWVL1", "Volumetric soil water layer 1", "m^3/m^3", UC_NONE},
   /* 40 */ {"SWVL2", "Volumetric soil water layer 2", "m^3/m^3", UC_NONE},
   /* 41 */ {"SWVL3", "Volumetric soil water layer 3", "m^3/m^3", UC_NONE},
   /* 42 */ {"SWVL4", "Volumetric soil water layer 4", "m^3/m^3", UC_NONE},
   /* 43 */ {"SLT", "Soil Type", "K", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"AT", "Atmospheric tide", "-", UC_NONE},
   /* 128 */ {"BV", "Budget values", "-", UC_NONE},
   /* 129 */ {"Z", "Geopotential (at the surface = orography)", "m^2/s^2",
              UC_NONE},
   /* 130 */ {"T", "Temperature", "K", UC_K2F},
   /* 131 */ {"U", "U-velocity", "m/s", UC_NONE},
   /* 132 */ {"V", "V-velocity", "m/s", UC_NONE},
   /* 133 */ {"Q", "Specific humidity", "kg/kg", UC_NONE},
   /* 134 */ {"SP", "Surface pressure", "Pa", UC_NONE},
   /* 135 */ {"W", "Vertical velocity", "Pa/s", UC_NONE},
   /* 136 */ {"TWC", "Total column water", "kg/m^2", UC_NONE},
   /* 137 */ {"PWC", "Precipitable water content", "kg/m^2", UC_NONE},
   /* 138 */ {"VO", "Vorticity (relative)", "1/s", UC_NONE},
   /* 139 */ {"ST", "Surf.temp/soil temp lev 1 (from 930804)", "K", UC_NONE},
   /* 140 */ {"SSW", "Surf soil wet/soil wet lev1(from 930803) (of water)",
              "m", UC_NONE},
   /* 141 */ {"SD", "Snow depth (water equivalent)", "m", UC_NONE},
   /* 142 */ {"LSP", "Large scale precipitation", "m", UC_NONE},
   /* 143 */ {"CP", "Convective precipitation", "m", UC_NONE},
   /* 144 */ {"SF", "Snow fall (of water equivalent)", "m", UC_NONE},
   /* 145 */ {"BLD", "Boundary layer dissipation", "W*s/m^2", UC_NONE},
   /* 146 */ {"SSHF", "Surface sensible heat flux", "W*s/m^2", UC_NONE},
   /* 147 */ {"SLHF", "Surface latent heat flux", "W*s/m^2", UC_NONE},
   /* 148 */ {"SS-CHNK", "Surface stress/Charnock (from 980519)", "-",
              UC_NONE},
   /* 149 */ {"SNR", "Surface net radiation", "-", UC_NONE},
   /* 150 */ {"AIW", "Top net radiation", "-", UC_NONE},
   /* 151 */ {"MSL", "Mean sea level pressure", "Pa", UC_NONE},
   /* 152 */ {"LNSP", "Log surface pressure", "-", UC_NONE},
   /* 153 */ {"SWHR", "Short wave heating rate", "K", UC_NONE},
   /* 154 */ {"LWH", "Long wave heating rate", "K", UC_NONE},
   /* 155 */ {"D", "Divergence", "1/s", UC_NONE},
   /* 156 */ {"GH", "Height (geopotential)", "m", UC_NONE},
   /* 157 */ {"R", "Relative humidity", "%", UC_NONE},
   /* 158 */ {"TSP", "Tendency of surface pressure", "Pa/s", UC_NONE},
   /* 159 */ {"BLH", "Boundary layer height", "m", UC_NONE},
   /* 160 */ {"SDOR", "Standard deviation of orography", "-", UC_NONE},
   /* 161 */ {"ISOR", "Anisotropy of subgrid scale orography", "-", UC_NONE},
   /* 162 */ {"ANOR", "Angle of subgrid scale orography", "-", UC_NONE},
   /* 163 */ {"SLOR", "Slope of subgrid scale orography", "-", UC_NONE},
   /* 164 */ {"TCC", "Total cloud cover (0 - 1)", "-", UC_NONE},
   /* 165 */ {"10U", "10 metre u wind component", "m/s", UC_NONE},
   /* 166 */ {"10V", "10 metre v wind component", "m/s", UC_NONE},
   /* 167 */ {"2T", "2 metre temperature", "K", UC_NONE},
   /* 168 */ {"2D", "2 metre dewpoint temperature", "K", UC_NONE},
   /* 169 */ {"SSRD", "Surface solar radiation downwards", "W*s/m^2",
              UC_NONE},
   /* 170 */ {"DST", "Deep soil tmp/soil temp lev2(from 930804)", "K",
              UC_NONE},
   /* 171 */ {"DSW", "Deep soil wet/soil wet lev2(from 930803) (of water)",
              "m", UC_NONE},
   /* 172 */ {"LSM", "Land/sea mask", "-", UC_NONE},
   /* 173 */ {"SR", "Surface roughness", "m", UC_NONE},
   /* 174 */ {"AL", "Albedo", "-", UC_NONE},
   /* 175 */ {"STRD", "Surface thermal radiation downwards", "W*s/m^2",
              UC_NONE},
   /* 176 */ {"SSR", "Surface solar radiation", "W*s/m^2", UC_NONE},
   /* 177 */ {"STR", "Surface thermal radiation", "W*s/m^2", UC_NONE},
   /* 178 */ {"TSR", "Top solar radiation", "W*s/m^2", UC_NONE},
   /* 179 */ {"TTR", "Top thermal radiation", "W*s/m^2", UC_NONE},
   /* 180 */ {"EWSS", "East/West surface stress", "N*s/m^2", UC_NONE},
   /* 181 */ {"NSSS", "North/South surface stress", "N*s/m^2", UC_NONE},
   /* 182 */ {"E", "Evaporation (of water)", "m", UC_NONE},
   /* 183 */ {"CDST", "Clim deep soil tmp/soil tmp lev3(930804)", "K",
              UC_NONE},
   /* 184 */ {"CDSW", "Clim deep soil wet/soil wet lev3(930803) (of water)",
              "m", UC_NONE},
   /* 185 */ {"CCC", "Convective cloud cover (0 - 1)", "-", UC_NONE},
   /* 186 */ {"LCC", "Low cloud cover (0 - 1)", "-", UC_NONE},
   /* 187 */ {"MCC", "Medium cloud cover (0 - 1)", "-", UC_NONE},
   /* 188 */ {"HCC", "High cloud cover (0 - 1)", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"EWOV", "EW component subgrid orographic variance", "m^2",
              UC_NONE},
   /* 191 */ {"NSOV", "NS component subgrid orographic variance", "m^2",
              UC_NONE},
   /* 192 */ {"NWOV", "NWSE component subgrid orographic variance", "m^2",
              UC_NONE},
   /* 193 */ {"NEOV", "NESW component subgrid orographic variance", "m^2",
              UC_NONE},
   /* 194 */ {"BTMP", "Brightness temperature", "K", UC_NONE},
   /* 195 */ {"LGWS", "Lat. component of gravity wave stress", "N*s/m^2",
              UC_NONE},
   /* 196 */ {"MGWS", "Meridional component gravity wave stress", "N*s/m^2",
              UC_NONE},
   /* 197 */ {"GWD", "Gravity wave dissipation", "W*s/m^2", UC_NONE},
   /* 198 */ {"SRC", "Skin reservoir content (of water)", "m", UC_NONE},
   /* 199 */ {"VEG", "Percentage of vegetation", "%", UC_NONE},
   /* 200 */ {"VSO", "Variance of sub-grid scale orography", "m^2", UC_NONE},
   /* 201 */ {"MX2T", "Max 2m temp since previous post-processing", "K",
              UC_NONE},
   /* 202 */ {"MN2T", "Min 2m temp since previous post-processing", "K",
              UC_NONE},
   /* 203 */ {"O3", "Ozone mass mixing ratio", "kg/kg", UC_NONE},
   /* 204 */ {"PAW", "Precip. analysis weights", "-", UC_NONE},
   /* 205 */ {"RO", "Runoff", "m", UC_NONE},
   /* 206 */ {"TCO3", "Total column ozone Dobson", "kg/m^2", UC_NONE},
   /* 207 */ {"10SI", "10m. Windspeed (irresp of dir.)", "m/s", UC_NONE},
   /* 208 */ {"TSRC", "Top net solar radiation clear sky", "W/m^2", UC_NONE},
   /* 209 */ {"TTRC", "Top upward thermal radiation clear sky", "W/m^2",
              UC_NONE},
   /* 210 */ {"SSRC", "Surface net solar radiation clear sky", "W/m^2",
              UC_NONE},
   /* 211 */ {"STRC", "Surface net thermal radiation clear sky", "W/m^2",
              UC_NONE},
   /* 212 */ {"SI", "Solar insulation", "W/m^2", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"DHR", "Diabatic heating by radiation", "K", UC_NONE},
   /* 215 */ {"DHVD", "Diabatic heating by vertical diffusion", "K", UC_NONE},
   /* 216 */ {"DHCC", "Diabatic heating by cumulus convection", "K", UC_NONE},
   /* 217 */ {"DHLC", "Diabatic heating large-scale condensation", "K",
              UC_NONE},
   /* 218 */ {"VDZW", "Vertical diffusion of zonal wind", "m/s", UC_NONE},
   /* 219 */ {"VDMW", "Vertical diffusion of meridional wind", "m/s",
              UC_NONE},
   /* 220 */ {"EWGD", "EW gravity wave drag", "m/s", UC_NONE},
   /* 221 */ {"NSGD", "NS gravity wave drag", "m/s", UC_NONE},
   /* 222 */ {"CTZW", "Convective tendency of zonal wind", "m/s", UC_NONE},
   /* 223 */ {"CTMW", "Convective tendency of meridional wind", "m/s",
              UC_NONE},
   /* 224 */ {"VDH", "Vertical diffusion of humidity", "kg/kg", UC_NONE},
   /* 225 */ {"HTCC", "Humidity tendency by cumulus convection", "kg/kg",
              UC_NONE},
   /* 226 */ {"HTLC", "Humidity tendency large-scale condensation", "kg/kg",
              UC_NONE},
   /* 227 */ {"CRNH", "Change from removing negative humidity", "kg/kg s-1",
              UC_NONE},
   /* 228 */ {"TP", "Total precipitation", "m", UC_NONE},
   /* 229 */ {"IEWS", "Instantaneous X surface stress", "N/m^2", UC_NONE},
   /* 230 */ {"INSS", "Instantaneous Y surface stress", "N/m^2", UC_NONE},
   /* 231 */ {"ISHF", "Instantaneous surface Heat Flux", "W/m^2", UC_NONE},
   /* 232 */ {"IE", "Instantaneous Moisture Flux (evaporation)", "kg*s/m^2",
              UC_NONE},
   /* 233 */ {"ASQ", "Apparent Surface Humidity", "kg/kg", UC_NONE},
   /* 234 */ {"LSRH", "Log of surface roughness length for heat", "-",
              UC_NONE},
   /* 235 */ {"SKT", "Skin Temperature", "K", UC_NONE},
   /* 236 */ {"STL4", "Soil temperature level 4", "K", UC_NONE},
   /* 237 */ {"SWL4", "Soil wetness level 4", "m", UC_NONE},
   /* 238 */ {"TSN", "Temperature of snow layer", "K", UC_NONE},
   /* 239 */ {"CSF", "Convective snow-fall (of water equivalent)", "m",
              UC_NONE},
   /* 240 */ {"LSF", "Large scale snow-fall (of water equivalent)", "m",
              UC_NONE},
   /* 241 */ {"ACF", "Accumulated cloud fraction tendency (-1 to 1)", "-",
              UC_NONE},
   /* 242 */ {"ALW", "Accumulated liquid water tendency (-1 to 1)", "-",
              UC_NONE},
   /* 243 */ {"FAL", "Forecast albedo", "-", UC_NONE},
   /* 244 */ {"FSR", "Forecast surface roughness", "m", UC_NONE},
   /* 245 */ {"FLSR", "Forecast log of surface roughness for heat", "-",
              UC_NONE},
   /* 246 */ {"CLWC", "Cloud liquid water content", "kg/kg", UC_NONE},
   /* 247 */ {"CIWC", "Cloud ice water content", "kg/kg", UC_NONE},
   /* 248 */ {"CC", "Cloud cover (0 - 1)", "-", UC_NONE},
   /* 249 */ {"AIW", "Accumulated ice water tendency (-1 to 1)", "-",
              UC_NONE},
   /* 250 */ {"ICE", "Ice Age (0 first-year 1 multi-year)", "-", UC_NONE},
   /* 251 */ {"ATTE", "Adiabatic tendency of temperature", "K", UC_NONE},
   /* 252 */ {"ATHE", "Adiabatic tendency of humidity", "kg/kg", UC_NONE},
   /* 253 */ {"ATZE", "Adiabatic tendency of zonal wind", "m/s", UC_NONE},
   /* 254 */ {"ATMW", "Adiabatic tendency of meridional wind", "m/s",
              UC_NONE},
   /* 255 */ {"-", "Indicates a missing value", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_129[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"AT", "Atmospheric tide+", "-", UC_NONE},
   /* 128 */ {"BV", "Budget values+", "-", UC_NONE},
   /* 129 */ {"Z", "Geopotential (at the surface=orography)", "m^2/s^2",
              UC_NONE},
   /* 130 */ {"T", "Temperature", "K", UC_NONE},
   /* 131 */ {"U", "U-velocity", "m/s", UC_NONE},
   /* 132 */ {"V", "V-velocity", "m/s", UC_NONE},
   /* 133 */ {"Q", "Specific humidity", "kg/kg", UC_NONE},
   /* 134 */ {"SP", "Surface pressure", "Pa", UC_NONE},
   /* 135 */ {"W", "Vertical velocity", "Pa/s", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"PWC", "Precipitable water content", "kg/m^2", UC_NONE},
   /* 138 */ {"VO", "Vorticity (relative)", "1/s", UC_NONE},
   /* 139 */ {"ST", "Surf.temp/soil temp lev 1 (from 930804)", "K", UC_NONE},
   /* 140 */ {"SSW", "Surf soil wet/soil wet lev1(from 930803) (of water)",
              "m", UC_NONE},
   /* 141 */ {"SD", "Snow depth (of water equivalent)", "m", UC_NONE},
   /* 142 */ {"LSP", "Large scale precipitation*", "m", UC_NONE},
   /* 143 */ {"CP", "Convective precipitation*", "m", UC_NONE},
   /* 144 */ {"SF", "Snow fall* (of water equivalent)", "m", UC_NONE},
   /* 145 */ {"BLD", "Boundary layer dissipation*", "W*s/m^2", UC_NONE},
   /* 146 */ {"SSHF", "Surface sensible heat flux*", "W*s/m^2", UC_NONE},
   /* 147 */ {"SLHF", "Surface latent heat flux*", "W*s/m^2", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"MSL", "Mean sea level pressure", "Pa", UC_NONE},
   /* 152 */ {"LNSP", "Log surface pressure", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"D", "Divergence", "1/s", UC_NONE},
   /* 156 */ {"GH", "Height (geopotential)", "m", UC_NONE},
   /* 157 */ {"R", "Relative humidity", "%", UC_NONE},
   /* 158 */ {"TSP", "Tendency of surface pressure", "Pa/s", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"SDOR", "Standard deviation of orography", "-", UC_NONE},
   /* 161 */ {"ISOR", "Anisotropy of subgrid scale orography", "-", UC_NONE},
   /* 162 */ {"ANOR", "Angle of subgrid scale orography", "-", UC_NONE},
   /* 163 */ {"SLOR", "Slope of subgrid scale orography", "-", UC_NONE},
   /* 164 */ {"TCC", "Total cloud cover (0 - 1)", "-", UC_NONE},
   /* 165 */ {"10U", "10 metre u wind component", "m/s", UC_NONE},
   /* 166 */ {"10V", "10 metre v wind component", "m/s", UC_NONE},
   /* 167 */ {"2T", "2 metre temperature", "K", UC_NONE},
   /* 168 */ {"2D", "2 metre dewpoint temperature", "K", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"DST", "Deep soil tmp/soil temp lev2(frm 930804)", "K",
              UC_NONE},
   /* 171 */ {"DSW", "Deep soil wet/soil wet lev2(from 930803) (of water)",
              "m", UC_NONE},
   /* 172 */ {"LSM", "Land/sea mask (0", "-", UC_NONE},
   /* 173 */ {"SR", "Surface roughness", "m", UC_NONE},
   /* 174 */ {"AL", "Albedo", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"SSR", "Surface solar radiation", "W*s/m^2", UC_NONE},
   /* 177 */ {"STR", "Surface thermal radiation", "W*s/m^2", UC_NONE},
   /* 178 */ {"TSR", "Top solar radiation", "W*s/m^2", UC_NONE},
   /* 179 */ {"TTR", "Top thermal radiation", "W*s/m^2", UC_NONE},
   /* 180 */ {"EWSS", "East/West surface stress", "N*s/m^2", UC_NONE},
   /* 181 */ {"NSSS", "North/South surface stress", "N*s/m^2", UC_NONE},
   /* 182 */ {"E", "Evaporation (of water)", "m", UC_NONE},
   /* 183 */ {"CDST", "Clim deep soil tmp/soil tmp lev3(930804)", "K",
              UC_NONE},
   /* 184 */ {"CDSW", "Clim deep soil wet/soil wet lev3(930803) (of water)",
              "m", UC_NONE},
   /* 185 */ {"CCC", "Convective cloud cover (0 - 1)", "-", UC_NONE},
   /* 186 */ {"LCC", "Low cloud cover (0 - 1)", "-", UC_NONE},
   /* 187 */ {"MCC", "Medium cloud cover (0 - 1)", "-", UC_NONE},
   /* 188 */ {"HCC", "High cloud cover (0 - 1)", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"EWOV", "EW component subgrid scale orographic variance", "m^2",
              UC_NONE},
   /* 191 */ {"NSOV", "NS component subgrid scale orographic variance", "m^2",
              UC_NONE},
   /* 192 */ {"NWOV", "NWSE component subgrid scale orographic variance",
              "m^2", UC_NONE},
   /* 193 */ {"NEOV", "NESW component subgrid scale orographic variance",
              "m^2", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"LGWS", "Lat. component of gravity wave stress", "N*s/m^2",
              UC_NONE},
   /* 196 */ {"MGWS", "Meridional component gravity wave stress", "N*s/m^2",
              UC_NONE},
   /* 197 */ {"GWD", "Gravity wave dissipation", "W*s/m^2", UC_NONE},
   /* 198 */ {"SRC", "Skin reservoir content (of water)", "m", UC_NONE},
   /* 199 */ {"VEG", "Percentage of vegetation", "%", UC_NONE},
   /* 200 */ {"VSO", "Variance of sub-grid scale orography", "m^2", UC_NONE},
   /* 201 */ {"MX2T", "Max 2m temp since previous post-processing", "K",
              UC_NONE},
   /* 202 */ {"MN2T", "Min 2m temp since previous post-processing", "K",
              UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"PAW", "Precip. analysis weights", "-", UC_NONE},
   /* 205 */ {"RO", "Runoff", "m", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"TP", "Total precipitation", "m", UC_NONE},
   /* 229 */ {"IEWS", "Instantaneous X surface stress", "N/m^2", UC_NONE},
   /* 230 */ {"INSS", "Instantaneous Y surface stress", "N/m^2", UC_NONE},
   /* 231 */ {"ISHF", "Instantaneous surface Heat Flux", "W/m^2", UC_NONE},
   /* 232 */ {"IE", "Instantaneous Moisture Flux (evaporation)", "kg*s/m^2",
              UC_NONE},
   /* 233 */ {"ASQ", "Apparent Surface Humidity", "kg/kg", UC_NONE},
   /* 234 */ {"LSRH", "Log of surface roughness length for heat", "-",
              UC_NONE},
   /* 235 */ {"SKT", "Skin Temperature", "K", UC_NONE},
   /* 236 */ {"STL4", "Soil temperature level 4", "K", UC_NONE},
   /* 237 */ {"SWL4", "Soil wetness level 4", "m", UC_NONE},
   /* 238 */ {"TSN", "Temperature of snow layer", "K", UC_NONE},
   /* 239 */ {"CSF", "Convective snow-fall (of water equivalent)", "m",
              UC_NONE},
   /* 240 */ {"LSF", "Large scale snow-fall (of water equivalent)", "m",
              UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"FAL", "Forecast albedo", "-", UC_NONE},
   /* 244 */ {"FSR", "Forecast surface roughness", "m", UC_NONE},
   /* 245 */ {"FLSR", "Forecast log of surface roughness for heat", "-",
              UC_NONE},
   /* 246 */ {"CLWC", "Cloud liquid water content", "kg/kg", UC_NONE},
   /* 247 */ {"CIWC", "Cloud ice water content", "kg/kg", UC_NONE},
   /* 248 */ {"CC", "Cloud cover (0 - 1)", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"ICE", "Ice Age (0 first-year 1 multi-year)", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_130[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"TSRU", "Top solar radiation upward", "W/m^2", UC_NONE},
   /* 209 */ {"TTRU", "Top thermal radiation upward", "W/m^2", UC_NONE},
   /* 210 */ {"TSUC", "Top solar radiation upward clear sky", "W/m^2",
              UC_NONE},
   /* 211 */ {"TTUC", "Top thermal radiation upward clear sky", "W/m^2",
              UC_NONE},
   /* 212 */ {"CLW", "Cloud liquid water", "kg/kg", UC_NONE},
   /* 213 */ {"CF", "Cloud fraction 0-1", "-", UC_NONE},
   /* 214 */ {"DHR", "Diabatic heating by radiation", "K/s", UC_NONE},
   /* 215 */ {"DHVD", "Diabatic heating by vertical diffusion", "K/s",
              UC_NONE},
   /* 216 */ {"DHCC", "Diabatic heating by cumulus convection", "K/s",
              UC_NONE},
   /* 217 */ {"DHLC", "Diabatic heating by large-scale condensation", "K/s",
              UC_NONE},
   /* 218 */ {"VDZW", "Vertical diffusion of zonal wind", "m^2/s^3", UC_NONE},
   /* 219 */ {"VDMW", "Vertical diffusion of meridional wind", "m^2/s^3",
              UC_NONE},
   /* 220 */ {"EWGD", "EW gravity wave drag", "m^2/s^3", UC_NONE},
   /* 221 */ {"NSGD", "NS gravity wave drag", "m^2/s^3", UC_NONE},
   /* 222 */ {"CTZW", "Convective tendency of zonal wind", "m^2/s^3",
              UC_NONE},
   /* 223 */ {"CTMW", "Convective tendency of meridional wind", "m^2/s^3",
              UC_NONE},
   /* 224 */ {"VDH", "Vertical diffusion of humidity", "kg/(kg*s)", UC_NONE},
   /* 225 */ {"HTCC", "Humidity tendency by cumulus convection", "kg/(kg*s)",
              UC_NONE},
   /* 226 */ {"HTLC", "Humidity tendency by large-scale condensation",
              "kg/(kg*s)", UC_NONE},
   /* 227 */ {"CRNH", "Change from removing negative humidity", "kg/(kg*s)",
              UC_NONE},
   /* 228 */ {"ATT", "Adiabatic tendency of temperature", "K/s", UC_NONE},
   /* 229 */ {"ATH", "Adiabatic tendency of humidity", "kg/(kg/s)", UC_NONE},
   /* 230 */ {"ATZW", "Adiabatic tendency of zonal wind", "m^2/s^3", UC_NONE},
   /* 231 */ {"ATMW", "Adiabatic tendency of meridional wind", "m^2/s^3",
              UC_NONE},
   /* 232 */ {"MVV", "Mean vertical velocity", "Pa/s", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_131[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"TAP", "Temperature anomaly probability", "% K", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"10SP", "10 metre speed probability", "% m/s", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"2TP", "2 metre temperature probability", "%", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"TTP", "Total precipitation probability", "% m", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_140[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"SWH", "Significant wave height", "m", UC_NONE},
   /* 230 */ {"MWD", "Mean wave direction", "degrees", UC_NONE},
   /* 231 */ {"PP1D", "Peak period of 1d spectra", "s", UC_NONE},
   /* 232 */ {"MWP", "Mean wave period", "s", UC_NONE},
   /* 233 */ {"CDWW", "Coefficient of drag with waves", "-", UC_NONE},
   /* 234 */ {"SHWW", "Significant height of wind waves", "m", UC_NONE},
   /* 235 */ {"MDWW", "Mean direction of wind waves", "degrees", UC_NONE},
   /* 236 */ {"MPWW", "Mean period of wind waves", "s", UC_NONE},
   /* 237 */ {"SHPS", "Significant height of primary swell", "m", UC_NONE},
   /* 238 */ {"MDPS", "Mean direction of primary swell", "degrees", UC_NONE},
   /* 239 */ {"MPPS", "Mean period of primary swell", "s", UC_NONE},
   /* 240 */ {"SDHS", "Standard deviation wave height", "m", UC_NONE},
   /* 241 */ {"MU10", "Mean of 10m windspeed", "m/s", UC_NONE},
   /* 242 */ {"MDWI", "Mean wind direction", "degrees", UC_NONE},
   /* 243 */ {"SDU", "Standard deviation 10m wind speed", "m/s", UC_NONE},
   /* 244 */ {"MSQS", "Mean square slope of waves", "-", UC_NONE},
   /* 245 */ {"10MS", "Ten metre windspeed", "m/s", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"2DSP", "2D wave spectra", "m^2*s/radiance", UC_NONE},
   /* 251 */ {"var251", "2D wave spectra(single direction/single frequency)",
              "m^2*s/radiance", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_150[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "Ocean potential temperature", "C", UC_NONE},
   /* 130 */ {"var130", "Ocean salinity", "psu", UC_NONE},
   /* 131 */ {"var131", "Ocean potential density(reference = surface)",
              "kg/m^3 -1000", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "Ocean u velocity", "m/s", UC_NONE},
   /* 134 */ {"var134", "Ocean v velocity", "m/s", UC_NONE},
   /* 135 */ {"var135", "Ocean w velocity", "m/s", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "Richardson number", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "u*v product", "m/s^2", UC_NONE},
   /* 140 */ {"var140", "u*T product", "(m*C)/s", UC_NONE},
   /* 141 */ {"var141", "v*T product", "(m*C)/s", UC_NONE},
   /* 142 */ {"var142", "u*u product", "m/s^2", UC_NONE},
   /* 143 */ {"var143", "v*v product", "m/s^2", UC_NONE},
   /* 144 */ {"var144", "uv - u~v~ (u~ is time-mean of u)", "m/s^2", UC_NONE},
   /* 145 */ {"var145", "uT - u~T~", "(m*C)/s", UC_NONE},
   /* 146 */ {"var146", "vT - v~T~", "(m*C)/s", UC_NONE},
   /* 147 */ {"var147", "uu - u~u~", "m/s^2", UC_NONE},
   /* 148 */ {"var148", "vv - v~v~", "m/s^2", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "Sea level (departure from geoid tides removed)", "-",
              UC_NONE},
   /* 153 */ {"var153", "Barotropic stream function", "-", UC_NONE},
   /* 154 */ {"var154", "Mixed layer depth (Tcr=0.5 C for HOPE model)", "m",
              UC_NONE},
   /* 155 */ {"var155", "Depth (eg of isothermal surface)", "m", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "U-stress", "Pa", UC_NONE},
   /* 169 */ {"var169", "V-stress", "Pa", UC_NONE},
   /* 170 */ {"var170", "Turbulent Kinetic Energy input", "-", UC_NONE},
   /* 171 */ {"var171", "Net surface heat flux (+ve = down)", "-", UC_NONE},
   /* 172 */ {"var172", "Surface solar radiation", "-", UC_NONE},
   /* 173 */ {"var173", "P-E", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "Diagnosed SST error", "C", UC_NONE},
   /* 181 */ {"var181", "Heat flux correction", "W/m^2", UC_NONE},
   /* 182 */ {"var182", "Observed SST", "C", UC_NONE},
   /* 183 */ {"var183", "Observed heat flux", "W/m^2", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_160[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"AT", "Atmospheric tide+", "-", UC_NONE},
   /* 128 */ {"BV", "Budget values+", "-", UC_NONE},
   /* 129 */ {"Z", "Geopotential / orography", "m^2/s^2", UC_NONE},
   /* 130 */ {"T", "Temperature", "K", UC_NONE},
   /* 131 */ {"U", "U-velocity", "m/s", UC_NONE},
   /* 132 */ {"V", "V-velocity", "m/s", UC_NONE},
   /* 133 */ {"Q", "Specific humidity", "kg/kg", UC_NONE},
   /* 134 */ {"SP", "Surface pressure", "Pa", UC_NONE},
   /* 135 */ {"W", "Vertical velocity", "Pa/s", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"PWC", "Precipitable water content", "kg/m^2", UC_NONE},
   /* 138 */ {"VO", "Vorticity (relative)", "1/s", UC_NONE},
   /* 139 */ {"STL1", "Soil temperature level 1", "K", UC_NONE},
   /* 140 */ {"SWL1", "Soil wetness level 1", "m", UC_NONE},
   /* 141 */ {"SD", "Snow depth (of water)", "m", UC_NONE},
   /* 142 */ {"LSP", "Large scale precipitation", "kg/(m^2*s)", UC_NONE},
   /* 143 */ {"CP", "Convective precipitation", "kg/(m^2*s)", UC_NONE},
   /* 144 */ {"SF", "Snow fall", "kg/(m^2*s)", UC_NONE},
   /* 145 */ {"BLD", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 146 */ {"SSHF", "Surface sensible heat flux", "W/m^2", UC_NONE},
   /* 147 */ {"SLHF", "Surface latent heat flux", "W/m^2", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"MSL", "Mean sea level pressure", "Pa", UC_NONE},
   /* 152 */ {"LNSP", "Ln surface pressure", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"D", "Divergence", "1/s", UC_NONE},
   /* 156 */ {"GH", "Height (geopotential)", "m", UC_NONE},
   /* 157 */ {"R", "Relative humidity (0 - 1)", "-", UC_NONE},
   /* 158 */ {"TSP", "Tendency of surface pressure", "Pa/s", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"TCC", "Total cloud cover (0 - 1)", "-", UC_NONE},
   /* 165 */ {"10U", "10 metre u wind component", "m/s", UC_NONE},
   /* 166 */ {"10V", "10 metre v wind component", "m/s", UC_NONE},
   /* 167 */ {"2T", "2 metre temperature", "K", UC_NONE},
   /* 168 */ {"2D", "2 metre dewpoint temperature", "K", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"STL2", "Soil temperature level 2", "K", UC_NONE},
   /* 171 */ {"SWL2", "Soil wetness level 2", "m", UC_NONE},
   /* 172 */ {"LSM", "Land/sea mask (0 - 1)", "-", UC_NONE},
   /* 173 */ {"SR", "Surface roughness", "m", UC_NONE},
   /* 174 */ {"AL", "Albedo (0 - 1)", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"SSR", "Surface solar radiation", "W/m^2", UC_NONE},
   /* 177 */ {"STR", "Surface thermal radiation", "W/m^2", UC_NONE},
   /* 178 */ {"TSR", "Top solar radiation", "W/m^2", UC_NONE},
   /* 179 */ {"TTR", "Top thermal radiation", "W/m^2", UC_NONE},
   /* 180 */ {"EWSS", "East/west surface stress", "N/(m^2*s)", UC_NONE},
   /* 181 */ {"NSSS", "North/south surface stress", "N/(m^2*s)", UC_NONE},
   /* 182 */ {"E", "Evaporation", "kg/(m^2*s)", UC_NONE},
   /* 183 */ {"STL3", "Soil temperature level 3", "K", UC_NONE},
   /* 184 */ {"SWL3", "Soil wetness level 3", "m", UC_NONE},
   /* 185 */ {"CCC", "Convective cloud cover (0 - 1)", "-", UC_NONE},
   /* 186 */ {"LCC", "Low cloud cover (0 - 1)", "-", UC_NONE},
   /* 187 */ {"MCC", "Medium cloud cover (0 - 1)", "-", UC_NONE},
   /* 188 */ {"HCC", "High cloud cover (0 - 1)", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"EWOV", "EW component of sub-grid scale orographic variance",
              "m^2", UC_NONE},
   /* 191 */ {"NSOV", "NS component of sub-grid scale orographic variance",
              "m^2", UC_NONE},
   /* 192 */ {"NWOV", "NWSE component sub-grid scale orographic variance",
              "m^2", UC_NONE},
   /* 193 */ {"NEOV", "NESW component sub-grid scale orographic variance",
              "m^2", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"LGWS", "Latitudinal component of gravity wave stress",
              "(N*s)/m^2", UC_NONE},
   /* 196 */ {"MGWS", "Meridional component of gravity wave stress",
              "(N*s)/m^2", UC_NONE},
   /* 197 */ {"GWD", "Gravity wave dissipation", "(W*s)/m^2", UC_NONE},
   /* 198 */ {"SRC", "Skin reservoir content (of water)", "m", UC_NONE},
   /* 199 */ {"VEG", "Percentage of vegetation", "%", UC_NONE},
   /* 200 */ {"VSO", "Variance of sub-grid scale orography", "m^2", UC_NONE},
   /* 201 */ {"MX2T", "Max temp.2m during averaging time", "K", UC_NONE},
   /* 202 */ {"MN2T", "Min temp.2m during averaging time", "K", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"PAW", "Precip. analysis weights", "-", UC_NONE},
   /* 205 */ {"RO", "Runoff", "kg/(m^2*s)", UC_NONE},
   /* 206 */ {"ZZ", "St.Dev. of Geopotential", "m^2/s^2", UC_NONE},
   /* 207 */ {"TZ", "Covar Temp & Geopotential", "(K*m^2)/s^2", UC_NONE},
   /* 208 */ {"TT", "St.Dev. of Temperature", "K", UC_NONE},
   /* 209 */ {"QZ", "Covar Sp.Hum. & Geopotential", "m^2/s^2", UC_NONE},
   /* 210 */ {"QT", "Covar Sp.Hum & Temp.", "K", UC_NONE},
   /* 211 */ {"QQ", "St.Dev. of Specific humidity (0 - 1)", "-", UC_NONE},
   /* 212 */ {"UZ", "Covar U-comp. & Geopotential", "m^3/s^3", UC_NONE},
   /* 213 */ {"UT", "Covar U-comp. & Temp.", "(K*m)/s", UC_NONE},
   /* 214 */ {"UQ", "Covar U-comp. & Sp.Hum.", "m/s", UC_NONE},
   /* 215 */ {"UU", "St.Dev. of U-velocity", "m/s", UC_NONE},
   /* 216 */ {"VZ", "Covar V-comp. & Geopotential", "m^3/s^3", UC_NONE},
   /* 217 */ {"VT", "Covar V-comp. & Temp.", "(K*m)/s", UC_NONE},
   /* 218 */ {"VQ", "Covar V-comp. & Sp.Hum.", "m/s", UC_NONE},
   /* 219 */ {"VU", "Covar V-comp. & U-comp", "m^2/s^2", UC_NONE},
   /* 220 */ {"VV", "St.Dev. of V-comp", "m/s", UC_NONE},
   /* 221 */ {"WZ", "Covar W-comp. & Geopotential", "(Pa*m^2)/s^3", UC_NONE},
   /* 222 */ {"WT", "Covar W-comp. & Temp.", "(K*Pa)/s", UC_NONE},
   /* 223 */ {"WQ", "Covar W-comp. & Sp.Hum.", "Pa/s", UC_NONE},
   /* 224 */ {"WU", "Covar W-comp. & U-comp.", "(Pa*m)/s^2", UC_NONE},
   /* 225 */ {"WV", "Covar W-comp. & V-comp.", "(Pa*m)/s^2", UC_NONE},
   /* 226 */ {"WW", "St.Dev. of Vertical velocity", "Pa/s", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"TP", "Total precipitation", "m", UC_NONE},
   /* 229 */ {"IEWS", "Instantaneous X surface stress", "N/m^2", UC_NONE},
   /* 230 */ {"INSS", "Instantaneous Y surface stress", "N/m^2", UC_NONE},
   /* 231 */ {"ISHF", "Instantaneous surface Heat Flux", "W/m^2", UC_NONE},
   /* 232 */ {"IE", "Instantaneous Moisture Flux (evaporation)", "kg/(m^2*s)",
              UC_NONE},
   /* 233 */ {"ASQ", "Apparent Surface Humidity", "kg/kg", UC_NONE},
   /* 234 */ {"LSRH", "Logarithm of surface roughness length for heat.", "-",
              UC_NONE},
   /* 235 */ {"SKT", "Skin Temperature", "K", UC_NONE},
   /* 236 */ {"STL4", "Soil temperature level 4", "K", UC_NONE},
   /* 237 */ {"SWL4", "Soil wetness level 4", "m", UC_NONE},
   /* 238 */ {"TSN", "Temperature of snow layer", "K", UC_NONE},
   /* 239 */ {"CSF", "Convective snow-fall", "kg/(m^2*s)", UC_NONE},
   /* 240 */ {"LSF", "Large scale snow-fall", "kg/(m^2*s)", UC_NONE},
   /* 241 */ {"CLWC", "Cloud liquid water content", "kg/kg", UC_NONE},
   /* 242 */ {"CC", "Cloud cover (at given level) (0 - 1)", "-", UC_NONE},
   /* 243 */ {"FAL", "Forecast albedo", "-", UC_NONE},
   /* 244 */ {"FSR", "Forecast surface roughness", "m", UC_NONE},
   /* 245 */ {"FLSR", "Forecast logarithm of surface roughness for heat.",
              "-", UC_NONE},
   /* 246 */ {"10WS", "10m. Windspeed (irresp of dir.)", "m/s", UC_NONE},
   /* 247 */ {"MOFL", "Momentum flux (irresp of dir.)", "N/m^2", UC_NONE},
   /* 248 */ {"HSD", "Heaviside (beta) function (0 - 1)", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_170[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"Z", "Geopotential", "m^2/s^2", UC_NONE},
   /* 130 */ {"T", "Temperature", "K", UC_NONE},
   /* 131 */ {"U", "U-velocity", "m/s", UC_NONE},
   /* 132 */ {"V", "V-velocity", "m/s", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"VO", "Vorticity (relative)", "1/s", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"SWL1", "Soil wetness level 1", "m", UC_NONE},
   /* 141 */ {"SD", "Snow depth (of water equivalent)", "m", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"TSW", "Total soil moisture", "m", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"MSL", "Mean sea level pressure", "Pa", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"D", "Divergence", "1/s", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"SWL2", "Soil wetness level 2", "m", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"TTR", "Top thermal radiation", "W m-2", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"SWL3", "Soil wetness level 3", "m", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"MX2T", "Max temp at 2m since previous postprocess", "K",
              UC_NONE},
   /* 202 */ {"MN2T", "Min temp at 2m since previous postprocess", "K",
              UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"TP", "Total precipitation", "m", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

const GRIB1ParmTable parm_table_ecmwf_180[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"var1", "undefined", "-", UC_NONE},
   /* 2 */ {"var2", "undefined", "-", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"var6", "undefined", "-", UC_NONE},
   /* 7 */ {"var7", "undefined", "-", UC_NONE},
   /* 8 */ {"var8", "undefined", "-", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"var42", "undefined", "-", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"var55", "undefined", "-", UC_NONE},
   /* 56 */ {"var56", "undefined", "-", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"var60", "undefined", "-", UC_NONE},
   /* 61 */ {"var61", "undefined", "-", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"var101", "undefined", "-", UC_NONE},
   /* 102 */ {"var102", "undefined", "-", UC_NONE},
   /* 103 */ {"var103", "undefined", "-", UC_NONE},
   /* 104 */ {"var104", "undefined", "-", UC_NONE},
   /* 105 */ {"var105", "undefined", "-", UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"var107", "undefined", "-", UC_NONE},
   /* 108 */ {"var108", "undefined", "-", UC_NONE},
   /* 109 */ {"var109", "undefined", "-", UC_NONE},
   /* 110 */ {"var110", "undefined", "-", UC_NONE},
   /* 111 */ {"var111", "undefined", "-", UC_NONE},
   /* 112 */ {"var112", "undefined", "-", UC_NONE},
   /* 113 */ {"var113", "undefined", "-", UC_NONE},
   /* 114 */ {"var114", "undefined", "-", UC_NONE},
   /* 115 */ {"var115", "undefined", "-", UC_NONE},
   /* 116 */ {"var116", "undefined", "-", UC_NONE},
   /* 117 */ {"var117", "undefined", "-", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"Z", "Geopotential (at the surface=orography)", "m^2/s^2",
              UC_NONE},
   /* 130 */ {"T", "Temperature", "K", UC_NONE},
   /* 131 */ {"U", "U-velocity", "m/s", UC_NONE},
   /* 132 */ {"V", "V-velocity", "m/s", UC_NONE},
   /* 133 */ {"Q", "Specific humidity", "kg/kg", UC_NONE},
   /* 134 */ {"SP", "Surface pressure", "Pa", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"TCWV", "Total column water vapour", "kg/m^2", UC_NONE},
   /* 138 */ {"VO", "Vorticity (relative)", "1/s", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"SD", "Snow depth (of water equivalent)", "m", UC_NONE},
   /* 142 */ {"LSP", "Large scale precipitation*", "m", UC_NONE},
   /* 143 */ {"CP", "Convective precipitation*", "m", UC_NONE},
   /* 144 */ {"SF", "Snow fall (of water equivalent)", "m", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"SSHF", "Surface sensible heat flux", "(W*s)/m^2", UC_NONE},
   /* 147 */ {"SLHF", "Surface latent heat flux", "(W*s)/m^2", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"TSW", "Total soil wetness", "m", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"MSL", "Mean sea level pressure", "Pa", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"D", "Divergence", "1/s", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"TCC", "Total cloud cover (0 - 1)", "-", UC_NONE},
   /* 165 */ {"10U", "10 metre u wind component", "m/s", UC_NONE},
   /* 166 */ {"10V", "10 metre v wind component", "m/s", UC_NONE},
   /* 167 */ {"2T", "2 metre temperature", "K", UC_NONE},
   /* 168 */ {"2D", "2 metre dewpoint temperature", "K", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"LSM", "Land/sea mask (0", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"SSR", "Surface solar radiation (net)", "(J*s)/m^2", UC_NONE},
   /* 177 */ {"STR", "Surface thermal radiation (net)", "(J*s)/m^2", UC_NONE},
   /* 178 */ {"TSR", "Top solar radiation (net)", "(J*s)/m^2", UC_NONE},
   /* 179 */ {"TTR", "Top thermal radiation (net)", "(J*s)/m^2", UC_NONE},
   /* 180 */ {"EWSS", "East/West surface stress", "(N*s)/m^2", UC_NONE},
   /* 181 */ {"NSSS", "North/South surface stress", "(N*s)/m^2", UC_NONE},
   /* 182 */ {"E", "Evaporation (surface) (of water)", "m", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"RO", "Runoff (total)", "m", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*****************************************************************************
 * DWD Parameter Tables (GRIB1 Section 1 Table 2)
 * Table versions 002, 201, 202, 203
 *****************************************************************************
 */

/*
 * GRIB table 2 at DWD
 * Helmut P. Frank, 30.08.2001
 */

const GRIB1ParmTable parm_table_dwd_002[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PS", "pressure", "Pa", UC_NONE},
   /* 2 */ {"PS_msl", "pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"p-tendency", "pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"FI", "geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Std dev of height", "m", UC_NONE},
   /* 10 */ {"TO3", "total ozone", "Dobson Units", UC_NONE},
   /* 11 */ {"T", "temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temp.", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temp.", "K", UC_K2F},
   /* 14 */ {"pseudo-pot", "pseudo-adiabatic potential temperature", "K",
             UC_K2F},
   /* 15 */ {"TMAX", "maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "minimum temperature", "K", UC_K2F},
   /* 17 */ {"TD", "dew-point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"visibility", "visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta temp */
   /* 25 */ {"TMPA", "Temp. anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "degree true", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"U", "u-component (zonal) of wind", "m/s", UC_NONE},
   /* 34 */ {"V", "v-component (meridional) of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coord. vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"OMEGA", "Pressure vertical velocity", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Geometric vertical velocity", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v of current", "m/s", UC_NONE},
   /* 51 */ {"QV", "specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RELHUM", "relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"TQV", "total precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"TQI", "total cloud ice content", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/(m^2*s)", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"TOT_PREC", "total precipitation", "kg/m^2", UC_NONE},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equiv.", "kg/(m^2*s)", UC_NONE},
   /* 65 */ {"W_SNOW", "water equivalent of accumulated snow depth", "kg/m^2",
             UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"CLCT", "total cloud cover", "%", UC_NONE},
   /* 72 */ {"CLC_CON", "convective cloud cover", "%", UC_NONE},
   /* 73 */ {"CLCL", "low cloud cover", "%", UC_NONE},
   /* 74 */ {"CLCM", "medium cloud cover", "%", UC_NONE},
   /* 75 */ {"CLCH", "high cloud cover", "%", UC_NONE},
   /* 76 */ {"TQC", "total cloud water content", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta temp */
   /* 78 */ {"SNOW_CON", "convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOW_GSP", "large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water temp.", "K", UC_K2F},
   /* 81 */ {"FR_LAND", "land cover (1=land, 0=sea)", "1", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"Z0", "surface roughness", "m", UC_NONE},
   /* 84 */ {"ALB_RAD", "albedo", "%", UC_NONE},
   /* 85 */ {"T_soil", "soil temperature", "K", UC_K2F},
   /* 86 */ {"W_soil", "soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"PLCOV", "vegetation (plant cover)", "%", UC_NONE},
   /* 88 */ {"salinity", "salinity", "kg/kg", UC_NONE},
   /* 89 */ {"density", "density", "kg/m^3", UC_NONE},
   /* 90 */ {"RUNOFF", "water run-off", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "ice cover (1=ice, 0=no ice)", "proportion",
             UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Sig height of wind waves and swell", "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Sig height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Sig height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"ASOB_S", "net short-wave radiation (surface)", "W/m^2",
              UC_NONE},
   /* 112 */ {"ATHB_S", "net long-wave radiation (surface)", "W/m^2",
              UC_NONE},
   /* 113 */ {"ASOB_T", "net short-wave radiation (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"ATHB_T", "net long-wave radiation (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation", "W/m^2", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"ALHFL_S", "latent heat flux", "W/m^2", UC_NONE},
   /* 122 */ {"ASHFL_S", "sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"AUMFL_S", "momentum flux, u component", "N/m^2", UC_NONE},
   /* 125 */ {"AVMFL_S", "momentum flux, v component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"HGT_ECMF", "Geopotential height (ECMF)", "gpm", UC_NONE},
   /* 130 */ {"TMP_ECMF", "Temp. (ECMF)", "K", UC_K2F},
   /* 131 */ {"UGRD_ECMF", "u wind (ECMF)", "m/s", UC_NONE},
   /* 132 */ {"VGRD_ECMF", "v wind (ECMF)", "m/s", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"TSOIL_ECMF", "Soil temp. (ECMF)", "K", UC_K2F},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"NCPCP_ECMF", "Large scale precipitation (ECMF)", "kg/m^2",
              UC_NONE},
   /* 143 */ {"ACPCP_ECMF", "Convective precipitation (ECMF)", "kg/m^2",
              UC_NONE},
   /* 144 */ {"snowfall", "snowfall (ECMF)", "m of water equivalent",
              UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"pressure", "pressure reduced to MSL (ECMF)", "Pa", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"HGT_ECMF", "Geopotential height (ECMF)", "gpm", UC_NONE},
   /* 157 */ {"RH_ECMF", "Relative humidity (ECMF)", "%", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"TCDC_ECMF", "Total cloud cover (ECMF)", "%", UC_NONE},
   /* 165 */ {"UGRD_10mECMF", "u of 10m-wind (ECMF)", "m/s", UC_NONE},
   /* 166 */ {"VGRD_10mECMF", "v of 10m-wind (ECMF)", "m/s", UC_NONE},
   /* 167 */ {"TMP_2mECMF", "2m temperature (ECMF)", "K", UC_K2F},
   /* 168 */ {"DPT_2mECMF", "2m due-point temperature (ECMF)", "K", UC_K2F},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"APCP_ECMF", "Total precipitation (ECMF)", "m", UC_NONE},
   /* 229 */ {"seaway_01", "seaway 01 (ECMF)", "", UC_NONE},
   /* 230 */ {"seaway_02", "seaway 02 (ECMF)", "", UC_NONE},
   /* 231 */ {"seaway_03", "seaway 03 (ECMF)", "", UC_NONE},
   /* 232 */ {"seaway_04", "seaway 04 (ECMF)", "", UC_NONE},
   /* 233 */ {"seaway_05", "seaway 05 (ECMF)", "", UC_NONE},
   /* 234 */ {"seaway_06", "seaway 06 (ECMF)", "", UC_NONE},
   /* 235 */ {"seaway_07", "seaway 07 (ECMF)", "", UC_NONE},
   /* 236 */ {"seaway_08", "seaway 08 (ECMF)", "", UC_NONE},
   /* 237 */ {"seaway_09", "seaway 09 (ECMF)", "", UC_NONE},
   /* 238 */ {"seaway_10", "seaway 10 (ECMF)", "", UC_NONE},
   /* 239 */ {"seaway_11", "seaway 11 (ECMF)", "", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*
 * GRIB table 201 at DWD
 * Helmut P. Frank, 30.08.2001
 */

const GRIB1ParmTable parm_table_dwd_201[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"DSWRF", "Downward shortwave radiation flux", "W/m^2", UC_NONE},
   /* 2 */ {"USWRF", "Upward short wave radiation flux", "W/m^2", UC_NONE},
   /* 3 */ {"DLWRF", "Downward longwave radiation flux", "W/m^2", UC_NONE},
   /* 4 */ {"ULWRF", "Upward long wave radiation flux", "W/m^2", UC_NONE},
   /* 5 */ {"APAB_S", "downwd photosynthetic active radiant flux density",
            "W/m^2", UC_NONE},
   /* 6 */ {"NSWRF", "net shortwave flux", "W/m^2", UC_NONE},
   /* 7 */ {"NLWRF", "net longwave flux", "W/m^2", UC_NONE},
   /* 8 */ {"TNRF", "total net radiative flux density", "W/m^2", UC_NONE},
   /* 9 */ {"DSWRF_CLFR", "downw shortw radiant flux density, cloudfree part",
            "W/m^2", UC_NONE},
   /* 10 */ {"USWRF_CLDY", "upw shortw radiant flux density, cloudy part",
             "W/m^2", UC_NONE},
   /* 11 */ {"DLWRF_CLFR", "downw longw radiant flux density, cloudfree part",
             "W/m^2", UC_NONE},
   /* 12 */ {"ULWRF_CLDY", "upw longw radiant flux density, cloudy part",
             "W/m^2", UC_NONE},
   /* 13 */ {"SOHR_RAD", "shortwave radiative heating rate", "K/s", UC_NONE},
   /* 14 */ {"THHR_RAD", "longwave radiative heating rate", "K/s", UC_NONE},
   /* 15 */ {"TOT_RAD", "total radiative heating rate", "K/s", UC_NONE},
   /* 16 */ {"soilheat_SFC", "soil heat flux, surface", "W/m^2", UC_NONE},
   /* 17 */ {"soilheat_LAY", "soil heat flux, bottom of layer", "W/m^2",
             UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"var21", "undefined", "-", UC_NONE},
   /* 22 */ {"var22", "undefined", "-", UC_NONE},
   /* 23 */ {"var23", "undefined", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"var25", "undefined", "-", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"var27", "undefined", "-", UC_NONE},
   /* 28 */ {"var28", "undefined", "-", UC_NONE},
   /* 29 */ {"CLC", "cloud cover, grid scale + convective", "1", UC_NONE},
   /* 30 */ {"CLC_GS", "cloud cover, grid scale (0...1)", "1", UC_NONE},
   /* 31 */ {"QC", "specific cloud water content, grid scale", "kg/kg",
             UC_NONE},
   /* 32 */ {"CLW_GS_VI", "cloud water content, grid scale, vert integrated",
             "kg/m^2", UC_NONE},
   /* 33 */ {"QI", "specific cloud ice content, grid scale", "kg/kg",
             UC_NONE},
   /* 34 */ {"CLI_GS_VI", "cloud ice content, grid scale, vert integrated",
             "kg/m^2", UC_NONE},
   /* 35 */ {"SRC_GS", "specific rainwater content, grid scale", "kg/kg",
             UC_NONE},
   /* 36 */ {"SSC_GS", "specific snow content, grid scale", "kg/kg", UC_NONE},
   /* 37 */ {"SRC_GS_VI", "specific rainwater content, gs, vert. integrated",
             "kg/m^2", UC_NONE},
   /* 38 */ {"SSC_GS_VI", "specific snow content, gs, vert. integrated",
             "kg/m^2", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"TOT_WATER", "vert. integral of humidity, cloud water (and ice)",
             "kg/m^2", UC_NONE},
   /* 42 */ {"HUM_DIV", "vert. integral of divergence of tot. water content",
             "kg/m^2", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"CH_CM_CL", "cloud covers CH_CM_CL (000...888)", "1", UC_NONE},
   /* 51 */ {"CL_COV_CH", "cloud cover CH (0..8)", "1", UC_NONE},
   /* 52 */ {"CL_COV_CM", "cloud cover CM (0..8)", "1", UC_NONE},
   /* 53 */ {"CL_COV_CL", "cloud cover CL (0..8)", "1", UC_NONE},
   /* 54 */ {"TOT_CL_COV", "total cloud cover (0..8)", "1", UC_NONE},
   /* 55 */ {"fog", "fog (0..8)", "1", UC_NONE},
   /* 56 */ {"fog", "fog", "1", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"var59", "undefined", "-", UC_NONE},
   /* 60 */ {"CLC_CON_CI", "cloud cover, convective cirrus  (0...1)", "1",
             UC_NONE},
   /* 61 */ {"CLW_CON", "specific cloud water content, convective clouds",
             "kg/kg", UC_NONE},
   /* 62 */ {"CLW_CON_VI",
             "cloud water content, conv clouds, vert integrated", "kg/m^2",
             UC_NONE},
   /* 63 */ {"CLI_CON", "specific cloud ice content, convective clouds",
             "kg/kg", UC_NONE},
   /* 64 */ {"CLI_CON_VI", "cloud ice content, conv clouds, vert integrated",
             "kg/m^2", UC_NONE},
   /* 65 */ {"MASS_FL_CO", "convective mass flux", "kg/(s*m^2)", UC_NONE},
   /* 66 */ {"UPD_VEL_CO", "updraft velocity, convection", "m/s", UC_NONE},
   /* 67 */ {"ENTR_P_CO", "entrainment parameter, convection", "1/m",
             UC_NONE},
   /* 68 */ {"HBAS_CON", "cloud base, convective clouds (above msl)", "m",
             UC_NONE},
   /* 69 */ {"HTOP_CON", "cloud top, convective clouds (above msl)", "m",
             UC_NONE},
   /* 70 */ {"CON_LAYERS", "convective layers (00...77)  (BKE)", "1",
             UC_NONE},
   /* 71 */ {"KO-index", "KO-index", "1", UC_NONE},
   /* 72 */ {"BAS_CON", "convection base index", "1", UC_NONE},
   /* 73 */ {"TOP_CON", "convection top index", "1", UC_NONE},
   /* 74 */ {"DT_CON", "convective temperature tendency", "K/s", UC_NONE},
   /* 75 */ {"DQV_CON", "convective tendency of specific humidity", "1/s",
             UC_NONE},
   /* 76 */ {"H_TEN_CO", "convective tendency of total heat", "J/(kg*s)",
             UC_NONE},
   /* 77 */ {"QDW_TEN_CO", "convective tendency of total water", "1/s",
             UC_NONE},
   /* 78 */ {"DU_CON", "convective momentum tendency (X-component)", "m/s^2",
             UC_NONE},
   /* 79 */ {"DV_CON", "convective momentum tendency (Y-component)", "m/s^2",
             UC_NONE},
   /* 80 */ {"VOR_TEN_CO", "convective vorticity tendency", "1/s^2", UC_NONE},
   /* 81 */ {"DIV_TEN_CO", "convective divergence tendency", "1/s^2",
             UC_NONE},
   /* 82 */ {"HTOP_DC", "top of dry convection (above msl)", "m", UC_NONE},
   /* 83 */ {"TOP_IND_DC", "dry convection top index", "1", UC_NONE},
   /* 84 */ {"HZEROCL", "height of 0 degree Celsius isotherm above msl", "m",
             UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"QRS_GSP", "undefined", "-", UC_NONE},
   /* 100 */ {"PRR_GSP", "surface precipitation rate, rain, grid scale",
              "kg/(s*m^2)", UC_NONE},
   /* 101 */ {"PRS_GSP", "surface precipitation rate, snow, grid scale",
              "kg/(s*m^2)", UC_NONE},
   /* 102 */ {"RAIN_GSP", "surface precipitation amount, rain, grid scale",
              "kg/m^2", UC_NONE},
   /* 103 */ {"CONDENS_GS", "condensation rate, grid scale", "kg/(kg*s)",
              UC_NONE},
   /* 104 */ {"AUTOCON_GS", "autoconversion rate, grid scale (C+C --> R)",
              "kg/(kg*s)", UC_NONE},
   /* 105 */ {"ACCRET_GS", "accretion rate, grid scale (R+C --> R)",
              "kg/(kg*s)", UC_NONE},
   /* 106 */ {"NUCLEAT_GS", "nucleation rate, grid scale (C+C --> S)",
              "kg/(kg*s)", UC_NONE},
   /* 107 */ {"RIMING_GS", "riming rate, grid scale (S+C --> S)", "kg/(kg*s)",
              UC_NONE},
   /* 108 */ {"DEPOSIT_GS", "deposition rate, grid scale (S+V <--> S)",
              "kg/(kg*s)", UC_NONE},
   /* 109 */ {"MELTING_GS", "melting rate, grid scale (S --> R)", "kg/(kg*s)",
              UC_NONE},
   /* 110 */ {"EVAPOR_GS", "evaporation rate, grid scale (R+V <-- R)",
              "kg/(kg*s)", UC_NONE},
   /* 111 */ {"PRR_CON", "surface precipitation rate, rain, convective",
              "kg/(s*m^2)", UC_NONE},
   /* 112 */ {"PRS_CON", "surface precipitation rate, snow, convective",
              "kg/(s*m^2)", UC_NONE},
   /* 113 */ {"RAIN_CON", "surface precipitation amount, rain, convective",
              "kg/m^2", UC_NONE},
   /* 114 */ {"CONDENS_CO", "condensation rate, convective", "kg/(kg*s)",
              UC_NONE},
   /* 115 */ {"AUTOCON_CO", "autoconversion rate, convective", "kg/(kg*s)",
              UC_NONE},
   /* 116 */ {"ACCRET_CO", "accretion rate, convective", "kg/(kg*s)",
              UC_NONE},
   /* 117 */ {"NUCLEAT_CO", "nucleation rate, convective", "kg/(kg*s)",
              UC_NONE},
   /* 118 */ {"RIMING_CO", "riming rate, convective", "kg/(kg*s)", UC_NONE},
   /* 119 */ {"SUBLIM_CO", "sublimation rate, convective", "kg/(kg*s)",
              UC_NONE},
   /* 120 */ {"MELTING_CO", "melting rate, convective", "kg/(kg*s)", UC_NONE},
   /* 121 */ {"EVAPOR_CO", "evaporation rate, convective", "kg/(kg*s)",
              UC_NONE},
   /* 122 */ {"RAIN_AM", "rain amount, grid-scale plus convective", "kg/m^2",
              UC_NONE},
   /* 123 */ {"SNOW_AM", "snow amount, grid-scale plus convective", "kg/m^2",
              UC_NONE},
   /* 124 */ {"DT_GSP", "temperature tendency, grid-scale condensation",
              "K/s", UC_NONE},
   /* 125 */ {"DQV_GSP", "tendency of specific humidity, grid-scale condens",
              "1/s", UC_NONE},
   /* 126 */ {"H_TEN_GS", "tendency of total heat, grid-scale condensation",
              "J/(kg*s)", UC_NONE},
   /* 127 */ {"DQL_GSP", "tendency of total water, grid-scale condensation",
              "1/s", UC_NONE},
   /* 128 */ {"snowfall", "snowfall  (dimension", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"pprime", "deviation of pressure from reference value", "Pa",
              UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"HDI_COEFF", "coefficient of horizontal diffusion", "m^2/s",
              UC_NONE},
   /* 151 */ {"DISSP_RATE", "dissipation rate", "W/(Pa*m^2)", UC_NONE},
   /* 152 */ {"TKE", "turbulent kinetic energy", "(m/s)^2", UC_NONE},
   /* 153 */ {"TKVM", "coefficient of vertical diffusion, momentum", "m^2/s",
              UC_NONE},
   /* 154 */ {"TKVH", "coefficient of vertical diffusion, heat", "m^2/s",
              UC_NONE},
   /* 155 */ {"VDI_COE_CW", "coefficient of vertical diffusion, cloud water",
              "m^2/s", UC_NONE},
   /* 156 */ {"VDI_COE_CI", "coefficient of vertical diffusion, cloud ice",
              "m^2/s", UC_NONE},
   /* 157 */ {"VDI_COE_VP", "coefficient of vertical diffusion, water vapour",
              "m^2/s", UC_NONE},
   /* 158 */ {"DIS_LEN_M", "turbulent dissipation length for momentum", "m",
              UC_NONE},
   /* 159 */ {"DIS_LEN_H", "turbulent dissipation length for heat", "m",
              UC_NONE},
   /* 160 */ {"VAR_U_MOM", "variance of u-component of momentum", "(m/s)^2",
              UC_NONE},
   /* 161 */ {"VAR_V_MOM", "variance of v-component of momentum", "(m/s)^2",
              UC_NONE},
   /* 162 */ {"VAR_W_MOM", "variance of w-component of momentum", "(m/s)^2",
              UC_NONE},
   /* 163 */ {"VAR_TEMP", "variance of temperature", "K^2", UC_NONE},
   /* 164 */ {"VAR_CL_WAT", "variance of specific cloud water content",
              "(kg/kg)^2", UC_NONE},
   /* 165 */ {"VAR_CL_ICE", "variance of specific cloud ice content",
              "(kg/kg)^2", UC_NONE},
   /* 166 */ {"VAR_VAP_MR", "variance of water vapour mixing ratio",
              "(kg/kg)^2", UC_NONE},
   /* 167 */ {"C_WAT_FLUX", "turbulent vertical flux of spec cloud water",
              "m/s", UC_NONE},
   /* 168 */ {"C_ICE_FLUX", "turbulent vertical flux of spec cloud ice",
              "m/s", UC_NONE},
   /* 169 */ {"W_VAP_FLUX",
              "turbulent vertical flux of water vapour mix ratio", "m/s",
              UC_NONE},
   /* 170 */ {"TCM", "drag coefficient CD", "1", UC_NONE},
   /* 171 */ {"TCH", "transfer coefficient CH (sensible heat)", "1", UC_NONE},
   /* 172 */ {"TR_COEF_CQ", "transfer coefficient CQ (latent heat)", "1",
              UC_NONE},
   /* 173 */ {"PBL_TOP_H", "PBL-top h", "m", UC_NONE},
   /* 174 */ {"T_JUMP_H", "temperature jump at PBL-top", "K", UC_NONE},
              /* Delta temp */
   /* 175 */ {"Q_JUMP_H", "specific humidity jump at PBL-top", "kg/kg",
              UC_NONE},
   /* 176 */ {"ENTR_AT_H", "entrainment at PBL-top", "kg/(s*m^2)", UC_NONE},
   /* 177 */ {"MASS_FL_H", "upward mass flux at PBL-top", "kg/(s*m^2)",
              UC_NONE},
   /* 178 */ {"CL_COV_PBL", "cloud cover of PBL-clouds (0...1)", "1",
              UC_NONE},
   /* 179 */ {"CL_WAT_PBL", "specific cloud water content of PBL-clouds",
              "kg/kg", UC_NONE},
   /* 180 */ {"CL_TOP_PBL", "cloud top of PBL-clouds", "m", UC_NONE},
   /* 181 */ {"CL_BAS_PBL", "cloud base of PBL-clouds", "m", UC_NONE},
   /* 182 */ {"MOUN_WAV_X",
              "vertical mountain wave momentum flux (X component)",
              "kg/(m*s^2)", UC_NONE},
   /* 183 */ {"MOUN_WAV_Y",
              "vertical mountain wave momentum flux (Y component)",
              "kg/(m*s^2)", UC_NONE},
   /* 184 */ {"WAVE_RI", "wave Richardson number", "1", UC_NONE},
   /* 185 */ {"WAV_DIV_X", "mountain wave momentum flux divergence (X comp)",
              "m/s^2", UC_NONE},
   /* 186 */ {"WAV_DIV_Y", "mountain wave momentum flux divergence (Y comp)",
              "m/s^2", UC_NONE},
   /* 187 */ {"VMAX_10M", "maximum wind velocity", "m/s", UC_NONE},
   /* 188 */ {"WAV_DIS_VI", "mountain wave dissipation, vert integrated",
              "W/m^2", UC_NONE},
   /* 189 */ {"WV_EN_FLUX", "vertical wave energy flux", "kg*m/s^4", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"so_temp", "temperature of soil layers", "K", UC_K2F},
   /* 198 */ {"so_wa_ice", "water + ice content of soil layers", "kg/m^2",
              UC_NONE},
   /* 199 */ {"so_ice", "ice content of soil layers", "kg/m^2", UC_NONE},
   /* 200 */ {"W_I", "water content of interception store", "kg/m^2",
              UC_NONE},
   /* 201 */ {"INTERC_ICE", "icebit for interception store", "1", UC_NONE},
   /* 202 */ {"SNOW_FRACT", "snow fraction", "1", UC_NONE},
   /* 203 */ {"T_SNOW", "snow temperature", "K", UC_K2F},
   /* 204 */ {"FOLIAG_TMP", "foliage temperature", "K", UC_K2F},
   /* 205 */ {"infiltrat", "infiltration", "m/s", UC_NONE},
   /* 206 */ {"runoff", "runoff", "m/s", UC_NONE},
   /* 207 */ {"SOIL_EVAP", "bare soil evaporation", "m/s", UC_NONE},
   /* 208 */ {"PLANT_TRANS", "plant transpiration", "m/s", UC_NONE},
   /* 209 */ {"INTER_EVAP", "interception store evaporation", "m/s", UC_NONE},
   /* 210 */ {"WATER_EVAP", "evaporation from water surfaces", "m/s",
              UC_NONE},
   /* 211 */ {"AERO_RESIS", "aerodynamic resistance", "s/m", UC_NONE},
   /* 212 */ {"PLANT_RES", "plant resistance", "s/m", UC_NONE},
   /* 213 */ {"SOIL_RES", "soil resistance", "s/m", UC_NONE},
   /* 214 */ {"TOT_EVAP", "total evaporation (water, soil, plants)", "m/s",
              UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"XYZ", "S1", "1", UC_NONE},
   /* 231 */ {"S2", "S2", "1", UC_NONE},
   /* 232 */ {"S3", "S3", "1", UC_NONE},
   /* 233 */ {"S4", "S4", "1", UC_NONE},
   /* 234 */ {"S5", "S5", "1", UC_NONE},
   /* 235 */ {"S6", "S6", "1", UC_NONE},
   /* 236 */ {"S7", "S7", "1", UC_NONE},
   /* 237 */ {"S8", "S8", "1", UC_NONE},
   /* 238 */ {"S9", "S9", "1", UC_NONE},
   /* 239 */ {"S10", "S10", "1", UC_NONE},
   /* 240 */ {"S11", "S11", "1", UC_NONE},
   /* 241 */ {"OBS_TS_OC", "OBS Gewitter (occasional)", "1", UC_NONE},
   /* 242 */ {"OBS_TS_FQ", "OBS Gewitter (frequent)", "1", UC_NONE},
   /* 243 */ {"MOS_PTS_OC", "MOS Gewitter-Wahrscheinlichkeit (occasional)",
              "1", UC_NONE},
   /* 244 */ {"MOS_PTS_FQ", "MOS Gewitter-Wahrscheinlichkeit (frequent)", "1",
              UC_NONE},
   /* 245 */ {"MOS_TS_COV",
              "MOS Gewitteranteil (occasional - frequent (1 - 2))", "1",
              UC_NONE},
   /* 246 */ {"S17", "S17", "1", UC_NONE},
   /* 247 */ {"S18", "S18", "1", UC_NONE},
   /* 248 */ {"S19", "S19", "1", UC_NONE},
   /* 249 */ {"S20", "S20", "1", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*
 * GRIB table 202 at DWD
 * Helmut P. Frank, 30.08.2001
 */

const GRIB1ParmTable parm_table_dwd_202[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"Seeg_peak", "jonswap parameter fm", "1/s", UC_NONE},
   /* 2 */ {"Seeg_alpha", "jonswap parameter alpha", "1", UC_NONE},
   /* 3 */ {"Seeg_gamma", "jonswap parameter gamma", "1", UC_NONE},
   /* 4 */ {"Seeg_dir", "Seegang direction", "degree true", UC_NONE},
   /* 5 */ {"Seeg_energ", "Seegang energy density", "(m^2)(s^2)", UC_NONE},
   /* 6 */ {"Seeg_icemk", "Seegang ice mask", "1", UC_NONE},
   /* 7 */ {"peak_p_sw", "peak period of swell", "s", UC_NONE},
   /* 8 */ {"peak_p_ww", "peak period of wind waves", "s", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"var11", "undefined", "-", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"var13", "undefined", "-", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"var15", "undefined", "-", UC_NONE},
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"var19", "undefined", "-", UC_NONE},
   /* 20 */ {"Var_Geop", "Varianz Geopotential", "(m/s)^4", UC_NONE},
   /* 21 */ {"Var_T", "Varianz Temperatur", "K^2", UC_NONE},
   /* 22 */ {"Var_u", "Varianz Zonalwind", "(m/s)^2", UC_NONE},
   /* 23 */ {"Var_v", "Varianz Meridionalwind", "(m/s)^2", UC_NONE},
   /* 24 */ {"Var_q", "Varianz spezifische Feuchte", "(kg/kg)^2", UC_NONE},
   /* 25 */ {"Mer_Imptr", "Meridionaler Impulstransport", "(m/s)^2", UC_NONE},
   /* 26 */ {"Mer_TrEpt", "Meridionaler Transport potentieller Energie",
             "(m/s)^3", UC_NONE},
   /* 27 */ {"Mer_TrsW", "Meridionaler Transport sensibler Waerme", "K*(m/s)",
             UC_NONE},
   /* 28 */ {"Mer_TrlW", "Meridionaler Transport latenter Waerme",
             "(kg/kg)*(m/s)", UC_NONE},
   /* 29 */ {"Ver_TrEpt", "Vertikaler Transport potentieller Energie",
             "(m/s)^2*(Pa/s)", UC_NONE},
   /* 30 */ {"Ver_TrsW", "Vertikaler Transport sensibler Waerme", "K*(Pa/s)",
             UC_NONE},
   /* 31 */ {"Ver_TrlW", "Vertikaler Transport latenter Waerme",
             "(kg/kg)*(Pa/s)", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"var33", "undefined", "-", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"VarAF_Geop", "Varianz des Analyse-Fehlers Geopotential",
             "(m/s)^4", UC_NONE},
   /* 41 */ {"VarAF_u", "Varianz des Analyse-Fehlers Zonalwind", "(m/s)^2",
             UC_NONE},
   /* 42 */ {"VarAF_v", "Varianz des Analyse-Fehlers Meridionalwind",
             "(m/s)^2", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"DU_SSO", "undefined", "-", UC_NONE},
   /* 45 */ {"DV_SSO", "undefined", "-", UC_NONE},
   /* 46 */ {"SSO_STDH", "standard deviation of subgrid scale orogr. height",
             "m", UC_NONE},
   /* 47 */ {"SSO_GAMMA", "anisotropy of topography", "1", UC_NONE},
   /* 48 */ {"SSO_THETA", "angle betw. principal axis of orogr. and global E",
             "1", UC_NONE},
   /* 49 */ {"SSO_SIGMA", "mean slope of subgrid scale orography", "1",
             UC_NONE},
   /* 50 */ {"oro_varian", "subgrid-scale variance of orography", "m^2",
             UC_NONE},
   /* 51 */ {"E-W_oro_va", "E-W component of subgrid-scale variance of orogr",
             "m^2", UC_NONE},
   /* 52 */ {"N-S_oro_va", "N-S component of subgrid-scale variance of orogr",
             "m^2", UC_NONE},
   /* 53 */ {"NW-SE_o_va",
             "NW-SE component of subgrid-scale variance of orogr", "m^2",
             UC_NONE},
   /* 54 */ {"NE-SW_o_va",
             "NE-SW component of subgrid-scale variance of orogr", "m^2",
             UC_NONE},
   /* 55 */ {"inl_w_frac", "fraction of inland water", "1", UC_NONE},
   /* 56 */ {"surf_emiss", "surface emissivity", "1", UC_NONE},
   /* 57 */ {"SOILTYP", "soil texture", "1", UC_NONE},
   /* 58 */ {"soil_color", "soil color", "1", UC_NONE},
   /* 59 */ {"soil_drain", "soil drainage", "1", UC_NONE},
   /* 60 */ {"ground_wat", "ground water table", "m", UC_NONE},
   /* 61 */ {"LAI", "leaf area index", "1", UC_NONE},
   /* 62 */ {"ROOT", "root depth", "m", UC_NONE},
   /* 63 */ {"root_dens", "root density", "1", UC_NONE},
   /* 64 */ {"HMO3", "height of maximum of ozone concentration", "Pa",
             UC_NONE},
   /* 65 */ {"VIO3", "total vertically integrated ozone content", "Pa",
             UC_NONE},
   /* 66 */ {"ld-sea_msk", "land-sea mask", "1", UC_NONE},
   /* 67 */ {"PLCOV_MX", "ground fraction covered by plants (vegetation p.)",
             "1", UC_NONE},
   /* 68 */ {"PLCOV_MN", "ground fraction covered by plants (time of rest)",
             "1", UC_NONE},
   /* 69 */ {"LAI_MX", "leaf area index (vegetation period)", "1", UC_NONE},
   /* 70 */ {"LAI_MN", "leaf area index (time of rest)", "1", UC_NONE},
   /* 71 */ {"Orographie", "Orographie + Land-Meer-Verteilung", "m", UC_NONE},
   /* 72 */ {"r_length_m", "roughness length momentum", "m", UC_NONE},
   /* 73 */ {"r_length_h", "roughness length heat", "m", UC_NONE},
   /* 74 */ {"var_smc", "variance of soil moisture content", "kg^2/m^4",
             UC_NONE},
   /* 75 */ {"FOR_E", "fractional coverage with evergreen forest", "1",
             UC_NONE},
   /* 76 */ {"FOR_D", "fractional coverage with deciduous forest", "1",
             UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"var86", "undefined", "-", UC_NONE},
   /* 87 */ {"var87", "undefined", "-", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"var89", "undefined", "-", UC_NONE},
   /* 90 */ {"var90", "undefined", "-", UC_NONE},
   /* 91 */ {"var91", "undefined", "-", UC_NONE},
   /* 92 */ {"var92", "undefined", "-", UC_NONE},
   /* 93 */ {"var93", "undefined", "-", UC_NONE},
   /* 94 */ {"var94", "undefined", "-", UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"AER_DES", "undefined", "-", UC_NONE},
   /* 100 */ {"var100", "undefined", "-", UC_NONE},
   /* 101 */ {"tidal_tend", "tidal tendencies", "(m/s)^2", UC_NONE},
   /* 102 */ {"diab_heatg", "sum of diabatic heating terms", "K/s", UC_NONE},
   /* 103 */ {"adiab_heat", "total adiabatic heating", "K/s", UC_NONE},
   /* 104 */ {"adv_q_tend", "advective tendency of specific humidity", "1/s",
              UC_NONE},
   /* 105 */ {"nadv_q_ten", "non-advective tendency of specific humidity",
              "1/s", UC_NONE},
   /* 106 */ {"adv_m_te_X", "advective momentum tendency (X component)",
              "m/s^2", UC_NONE},
   /* 107 */ {"adv_m_te_Y", "advective momentum tendency (Y component)",
              "m/s^2", UC_NONE},
   /* 108 */ {"nad_m_te_X", "non-advective momentum tendency (X component)",
              "m/s^2", UC_NONE},
   /* 109 */ {"nad_m_te_Y", "non-advective momentum tendency (Y component)",
              "m/s^2", UC_NONE},
   /* 110 */ {"torque", "sum of mountain and frictional torque", "kg*(m/s)^2",
              UC_NONE},
   /* 111 */ {"budget_val", "budget values", "1", UC_NONE},
   /* 112 */ {"scale_fact", "scale factor", "1", UC_NONE},
   /* 113 */ {"Coriol_par", "Coriolis parameter", "1/s", UC_NONE},
   /* 114 */ {"PHI", "latitude", "degr N", UC_NONE},
   /* 115 */ {"RLA", "longitude", "degr E", UC_NONE},
   /* 116 */ {"relax_fact", "relaxation factor (lateral boundary, LAM)", "1",
              UC_NONE},
   /* 117 */ {"climsstint", "climatic sea surface temp interpolated in time",
              "degr C", UC_NONE},
   /* 118 */ {"pot_vortic", "potential vorticity", "K*m^2/(s*kg)", UC_NONE},
   /* 119 */ {"ln_ps", "log surface pressure", "1", UC_NONE},
   /* 120 */ {"EXP_SI", "undefined", "-", UC_NONE},
   /* 121 */ {"RHS_SI", "undefined", "-", UC_NONE},
   /* 122 */ {"DTTDIV", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"var127", "undefined", "-", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"SO2-conc", "SO2-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 151 */ {"SO2-dryd", "SO2-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 152 */ {"SO2-wetd", "SO2-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 153 */ {"SO4-conc", "SO4-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 154 */ {"SO4-dryd", "SO4-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 155 */ {"SO4-wetd", "SO4-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 156 */ {"NO-conc", "NO-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 157 */ {"NO-dryd", "NO-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 158 */ {"NO-wetd", "NO-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 159 */ {"NO2-conc", "NO2-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 160 */ {"NO2-dryd", "NO2-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 161 */ {"NO2-wetd", "NO2-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 162 */ {"NO3-conc", "NO3-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 163 */ {"NO3-dryd", "NO3-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 164 */ {"NO3-wetd", "NO3-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 165 */ {"HNO3-conc", "HNO3-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 166 */ {"HNO3-dryd", "HNO3-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 167 */ {"HNO3-wetd", "HNO3-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 168 */ {"NH3-conc", "NH3-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 169 */ {"NH3-dryd", "NH3-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 170 */ {"NH3-wetd", "NH3-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 171 */ {"NH4-conc", "NH4-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 172 */ {"NH4-dryd", "NH4-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 173 */ {"NH4-wetd", "NH4-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 174 */ {"O3-conc", "O3-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 175 */ {"PAN-conc", "PAN-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 176 */ {"PAN-dryd", "PAN-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 177 */ {"OH-conc", "OH-concentration", "10^(-6)*g/m^3", UC_NONE},
   /* 178 */ {"O3-dryd", "O3-dry deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 179 */ {"O3-wetd", "O3-wet deposition", "10^(-3)*g/m^2", UC_NONE},
   /* 180 */ {"O3", "specific ozone content", "kg/kg", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"I131-conc", "I131-concentration", "Bq/m^3", UC_NONE},
   /* 201 */ {"I131-dryd", "I131-dry deposition", "Bq/m^2", UC_NONE},
   /* 202 */ {"I131-wetd", "I131-wet deposition", "Bq/m^2", UC_NONE},
   /* 203 */ {"Cs137-conc", "Cs137-concentration", "Bq/m^3", UC_NONE},
   /* 204 */ {"Cs137-dryd", "Cs1370dry deposition", "Bq/m^2", UC_NONE},
   /* 205 */ {"Cs137-wetd", "Cs137-wet deposition", "Bq/m^2", UC_NONE},
   /* 206 */ {"Te132-conc", "Te132-concentration", "Bq/m^3", UC_NONE},
   /* 207 */ {"Te132-dryd", "Te132-dry deposition", "Bq/m^2", UC_NONE},
   /* 208 */ {"Te132-wetd", "Te132-wet deposition", "Bq/m^2", UC_NONE},
   /* 209 */ {"Zr95-conc", "Zr95-concentration", "Bq/m^3", UC_NONE},
   /* 210 */ {"Zr95-dryd", "Zr95-dry deposition", "Bq/m^2", UC_NONE},
   /* 211 */ {"Zr95-wetd", "Zr95-wet deposition", "Bq/m^2", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"UV-IndmaxF", "UV-Index, cloudless (wolkenlos=F) Maximum", "1",
              UC_NONE},
   /* 244 */ {"SB-Index", "Sonnenbrand-Index", "(W*10^(-3))/m^2", UC_NONE},
   /* 245 */ {"SB-Index_W",
              "Sonnenbrand-Index bei mittl. Bewoelkung (08z-12z)",
              "(W*10^(-3))/m^2", UC_NONE},
   /* 246 */ {"Kan_UVB-WI", "Kanadischer UVB-Warnindex (bew|lkungsreduziert)",
              "(W*10^(-3))/m^2", UC_NONE},
   /* 247 */ {"gesamt_O3", "total column ozone (Gesamtozon)", "Dobson",
              UC_NONE},
   /* 248 */ {"UV-IndmaxW", "UV-Index, clouded (bewoelkt=W) Maximum", "1",
              UC_NONE},
   /* 249 */ {"h_UV-IndMx", "time (Zeit) of UV-Index-Maximum", "h UTC",
              UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*
 * GRIB table 203 at DWD
 * Helmut P. Frank, 30.08.2001
 */

const GRIB1ParmTable parm_table_dwd_203[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"pressure", "pressure", "hPa", UC_NONE},
   /* 2 */ {"geopot_h", "geopotential height", "10 * gpm", UC_NONE},
   /* 3 */ {"var3", "undefined", "-", UC_NONE},
   /* 4 */ {"temperatur", "temperature", "C", UC_NONE},
   /* 5 */ {"dew-pnt_te", "dew-point temperature", "C", UC_NONE},
   /* 6 */ {"windcompXY", "wind components X/Y (X*100000 + ((Y*10)+5000))",
            "m/s", UC_NONE},
   /* 7 */ {"geomet_h", "geometrical height", "kft", UC_NONE},
   /* 8 */ {"geomet_h", "geometrical height", "hft", UC_NONE},
   /* 9 */ {"wind_di_sp", "wind direction and speed (dd*1000 + ff)",
            "1*degree, 1*kt", UC_NONE},
   /* 10 */ {"3_h_pr_cha", "3 hour pressure change", "Pa/(3*h)", UC_NONE},
   /* 11 */ {"Schnee-Mge", "Schneemenge", "mm", UC_NONE},
   /* 12 */ {"var12", "undefined", "-", UC_NONE},
   /* 13 */ {"Bod-Wass-G", "Bodenwassergehalt", "mm", UC_NONE},
   /* 14 */ {"var14", "undefined", "-", UC_NONE},
   /* 15 */ {"stab_ind", "stability index", "K", UC_NONE}, /* Delta temp */
   /* 16 */ {"var16", "undefined", "-", UC_NONE},
   /* 17 */ {"var17", "undefined", "-", UC_NONE},
   /* 18 */ {"var18", "undefined", "-", UC_NONE},
   /* 19 */ {"max_wind", "maximum wind velocity", "kt", UC_NONE},
   /* 20 */ {"wind_di_sp", "wind direction and speed (dd*1000 + ff)",
             "5*degrees, 1*(m/s)", UC_NONE},
   /* 21 */ {"wind_di_sp", "wind direction and speed (dd*1000 + ff)",
             "5*degrees, 1*kt", UC_NONE},
   /* 22 */ {"wave_di_he", "direction and height of wind waves (dd*1000 + h)",
             "1*degree, 1*cm", UC_NONE},
   /* 23 */ {"swe_di_he", "direction and height of swell (dd*1000 + h)",
             "1*degree, 1*cm", UC_NONE},
   /* 24 */ {"wave_m_d_h", "mean direction and height of waves (dd*1000 + h)",
             "1*degree, 1*cm", UC_NONE},
   /* 25 */ {"wind_speed", "wind speed", "kt", UC_NONE},
   /* 26 */ {"var26", "undefined", "-", UC_NONE},
   /* 27 */ {"wind_compX", "wind component X-direction", "kt", UC_NONE},
   /* 28 */ {"wind_compY", "wind component Y-direction", "kt", UC_NONE},
   /* 29 */ {"var29", "undefined", "-", UC_NONE},
   /* 30 */ {"var30", "undefined", "-", UC_NONE},
   /* 31 */ {"var31", "undefined", "-", UC_NONE},
   /* 32 */ {"var32", "undefined", "-", UC_NONE},
   /* 33 */ {"abs_voradv", "absolute vorticity advection", "1/s^2", UC_NONE},
   /* 34 */ {"var34", "undefined", "-", UC_NONE},
   /* 35 */ {"var35", "undefined", "-", UC_NONE},
   /* 36 */ {"var36", "undefined", "-", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"var38", "undefined", "-", UC_NONE},
   /* 39 */ {"var39", "undefined", "-", UC_NONE},
   /* 40 */ {"var40", "undefined", "-", UC_NONE},
   /* 41 */ {"var41", "undefined", "-", UC_NONE},
   /* 42 */ {"vert_vel", "vertical velocity", "hPa/h", UC_NONE},
   /* 43 */ {"var43", "undefined", "-", UC_NONE},
   /* 44 */ {"var44", "undefined", "-", UC_NONE},
   /* 45 */ {"var45", "undefined", "-", UC_NONE},
   /* 46 */ {"var46", "undefined", "-", UC_NONE},
   /* 47 */ {"var47", "undefined", "-", UC_NONE},
   /* 48 */ {"var48", "undefined", "-", UC_NONE},
   /* 49 */ {"var49", "undefined", "-", UC_NONE},
   /* 50 */ {"var50", "undefined", "-", UC_NONE},
   /* 51 */ {"var51", "undefined", "-", UC_NONE},
   /* 52 */ {"var52", "undefined", "-", UC_NONE},
   /* 53 */ {"var53", "undefined", "-", UC_NONE},
   /* 54 */ {"var54", "undefined", "-", UC_NONE},
   /* 55 */ {"max_temp", "maximum temperature", "C", UC_NONE},
   /* 56 */ {"min_temp", "minimum temperature", "C", UC_NONE},
   /* 57 */ {"var57", "undefined", "-", UC_NONE},
   /* 58 */ {"clo", "value of isolation of clothes", "1", UC_NONE},
   /* 59 */ {"pmva", "predicted mean vote (angepasst)", "1", UC_NONE},
   /* 60 */ {"feeled_t", "feeled temperature", "C", UC_NONE},
   /* 61 */ {"sea_temper", "sea temperature", "C", UC_NONE},
   /* 62 */ {"var62", "undefined", "-", UC_NONE},
   /* 63 */ {"var63", "undefined", "-", UC_NONE},
   /* 64 */ {"var64", "undefined", "-", UC_NONE},
   /* 65 */ {"var65", "undefined", "-", UC_NONE},
   /* 66 */ {"var66", "undefined", "-", UC_NONE},
   /* 67 */ {"var67", "undefined", "-", UC_NONE},
   /* 68 */ {"var68", "undefined", "-", UC_NONE},
   /* 69 */ {"var69", "undefined", "-", UC_NONE},
   /* 70 */ {"var70", "undefined", "-", UC_NONE},
   /* 71 */ {"var71", "undefined", "-", UC_NONE},
   /* 72 */ {"var72", "undefined", "-", UC_NONE},
   /* 73 */ {"var73", "undefined", "-", UC_NONE},
   /* 74 */ {"var74", "undefined", "-", UC_NONE},
   /* 75 */ {"var75", "undefined", "-", UC_NONE},
   /* 76 */ {"var76", "undefined", "-", UC_NONE},
   /* 77 */ {"var77", "undefined", "-", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"var81", "undefined", "-", UC_NONE},
   /* 82 */ {"var82", "undefined", "-", UC_NONE},
   /* 83 */ {"var83", "undefined", "-", UC_NONE},
   /* 84 */ {"var84", "undefined", "-", UC_NONE},
   /* 85 */ {"var85", "undefined", "-", UC_NONE},
   /* 86 */ {"Globalstr", "Summe der Globalstrahlung ueber einen Zeitraum",
             "kWh/m^2", UC_NONE},
   /* 87 */ {"Nied-GW-GE",
             "Niederschlagsart+Gewitter+Glatteis (T23-i) (0..99)", "1",
             UC_NONE},
   /* 88 */ {"NiedGW-Art", "Niederschlagsart+Gewitter (T23-intern) (0..99)",
             "1", UC_NONE},
   /* 89 */ {"NiedGE-Art", "Niederschlagsart+Glatteis (T23-intern) (0..99)",
             "1", UC_NONE},
   /* 90 */ {"NiedBewArt",
             "Kombination Niederschl.-Bew.-Blautherm. (283..407)", "1",
             UC_NONE},
   /* 91 */ {"Konv_U-Gr", "Hoehe der Konvektionsuntergrenze ueber Grund",
             "m", UC_NONE},
   /* 92 */ {"Nied-Art", "Niederschlagsart -ww- (T23-intern) (0..99)", "1",
             UC_NONE},
   /* 93 */ {"Konv-Art", "Konvektionsart (0..4)", "1", UC_NONE},
   /* 94 */ {"KonvUG-nn", "Hoehe der Konvektionsuntergrenze ueber nn", "m",
             UC_NONE},
   /* 95 */ {"var95", "undefined", "-", UC_NONE},
   /* 96 */ {"var96", "undefined", "-", UC_NONE},
   /* 97 */ {"var97", "undefined", "-", UC_NONE},
   /* 98 */ {"var98", "undefined", "-", UC_NONE},
   /* 99 */ {"Wetter_ww", "Wetter (verschluesselt nach ww-Tabelle", "-", UC_NONE},
   /* 100 */ {"geostr_Vor", "geostrophische Vorticity", "1/s", UC_NONE},
   /* 101 */ {"Geo_VorAdv", "geostrophische  Vorticityadvektion", "1/s^2",
              UC_NONE},
   /* 102 */ {"VerGraVoAd", "vert. Gradient der geostr. Vorticityadvektion",
              "m/(kg*s)", UC_NONE},
   /* 103 */ {"Geo_TemAdv", "geostrophische Schichtdickenadvektion",
              "m^3/(kg*s)", UC_NONE},
   /* 104 */ {"Lap_TemAdv", "Kruemmung der geostr. Schichtdickenadvektion",
              "m/(kg*s)", UC_NONE},
   /* 105 */ {"Omega_Forc", "Forcing rechte Seite Omegagleichung", "m/(kg*s)",
              UC_NONE},
   /* 106 */ {"var106", "undefined", "-", UC_NONE},
   /* 107 */ {"Schichtd_A", "Schichtdicken-Advektion", "m^3/(kg*s)", UC_NONE},
   /* 108 */ {"AdGeVoThWi",
              "Advektion von geostr. Vorticity mit dem therm Wind",
              "m/(kg*s)", UC_NONE},
   /* 109 */ {"Wind-Div", "Winddivergenz", "1/s", UC_NONE},
   /* 110 */ {"Q", "Q-vector direction and speed (dd*1000 + fff*1E13)",
              "5*deg,1E13*m^2/kg/s", UC_NONE},
   /* 111 */ {"Qx", "Q-Vektor X-Komponente", "m^2/(kg*s)", UC_NONE},
   /* 112 */ {"Qy", "Q-Vektor Y-Komponente", "m^2/(kg*s)", UC_NONE},
   /* 113 */ {"Div_Q", "Divergenz Q", "m/(kg*s)", UC_NONE},
   /* 114 */ {"FrontoGeQn",
              "Frontogenesefunktion, Q isother-senkrecht-Kompon.",
              "m^2/(kg*s)", UC_NONE},
   /* 115 */ {"Qs_geo", "Qs (geo),Komp. Q-Vektor parallel zu den Isothermen",
              "m^2/(kg*s)", UC_NONE},
   /* 116 */ {"DivQn_geo", "Divergenz Qn  geostrophisch", "m/(kg*s)",
              UC_NONE},
   /* 117 */ {"DivQs_geo", "Divergenz Qs  geostrophisch", "m/(kg*s)",
              UC_NONE},
   /* 118 */ {"Fronto_Gen", "Frontogenesefunktion", "K^2/(m^2*s)", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"var121", "undefined", "-", UC_NONE},
   /* 122 */ {"var122", "undefined", "-", UC_NONE},
   /* 123 */ {"var123", "undefined", "-", UC_NONE},
   /* 124 */ {"FrontoGenP", "Frontogenese-Parameter", "1", UC_NONE},
   /* 125 */ {"Qs-Vektor", "Qs, Komp. Q-Vektor parallel zu den Isothermen",
              "m^2/(kg*s)", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"Div_Qs", "Divergenz Qs", "m/(kg*s)", UC_NONE},
   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"IPV", "Isentrope potentielle Vorticity", "K*m^2/(s*kg)",
              UC_NONE},
   /* 131 */ {"Wind_KompX", "Wind X-Komponente auf isentropen Flaechen",
              "m/s", UC_NONE},
   /* 132 */ {"Wind_KompY", "Wind Y-Komponente auf isentropen Flaechen",
              "m/s", UC_NONE},
   /* 133 */ {"Druck-Ise", "Druck einer isentropen Flaeche", "hPa", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"KO-Index", "KO-Index", "K", UC_NONE}, /* Delta temp */
   /* 141 */ {"TT-Index", "Totals-Totals-Index", "K", UC_NONE},
              /* Delta temp */
   /* 142 */ {"S-Index", "S-Index", "K", UC_NONE}, /* Delta temp */
   /* 143 */ {"Stein-Ind", "Steinbeck-Index", "1", UC_NONE},
   /* 144 */ {"Baily-Ind", "Baily-Index", "1", UC_NONE},
   /* 145 */ {"Microburst", "Microburst-Index", "1", UC_NONE},
   /* 146 */ {"Cat-Index", "Clear Air Turbulence Index", "1/s", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"Lab-Energ", "Labilit{tsenergie", "J/g", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"VTMP", "Virtual temp", "K", UC_NONE},
   /* 151 */ {"Pseudo_T", "Pseudo-Temperatur", "K", UC_NONE},
   /* 152 */ {"Pseudo_Pot", "Pseudopotentielle Temperatur", "K", UC_NONE},
   /* 153 */ {"Aequi_T", "Aequivalent-Temperatur", "K", UC_NONE},
   /* 154 */ {"Aequi_Pot", "Aequivalentpotentielle Temperatur", "K", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"Bas_St_Wol", "Untergrenze strat. Bew|lkung", "hft", UC_NONE},
   /* 161 */ {"Bas_St_Wol", "Untergrenze strat. Bew|lkung", "hPa", UC_NONE},
   /* 162 */ {"Bas_Cu_Wol", "Untergrenze cumul. Bew|lkung", "hft", UC_NONE},
   /* 163 */ {"Bas_Cu_Wol", "Untergrenze cumul. Bew|lkung", "hPa", UC_NONE},
   /* 164 */ {"Top_St_Wol", "Obergrenze strat. Bew|lkung", "hft", UC_NONE},
   /* 165 */ {"Top_St_Wol", "Obergrenze strat. Bew|lkung", "hPa", UC_NONE},
   /* 166 */ {"Top_Cu_Wol", "Obergrenze cumul. Bew|lkung", "hft", UC_NONE},
   /* 167 */ {"Top_Cu_Wol", "Obergrenze cumul. Bew|lkung", "hPa", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"Bas_Tur_Wo", "Untergrenze Wolkenturbulenz", "hft", UC_NONE},
   /* 171 */ {"Bas_Tur_Wo", "Untergrenze Wolkenturbulenz", "hPa", UC_NONE},
   /* 172 */ {"Top_Tur_Wo", "Obergrenze Wolkenturbulenz", "hft", UC_NONE},
   /* 173 */ {"Top_Tur_Wo", "Obergrenze Wolkenturbulenz", "hPa", UC_NONE},
   /* 174 */ {"Bas_Eis_Wo", "Untergrenze Vereisung in Wolken", "hft",
              UC_NONE},
   /* 175 */ {"Bas_Eis_Wo", "Untergrenze Vereisung in Wolken", "hPa",
              UC_NONE},
   /* 176 */ {"Top_Eis_Wo", "Obergrenze Vereisung in Wolken", "hft", UC_NONE},
   /* 177 */ {"Top_Eis_Wo", "Obergrenze Vereisung in Wolken", "hPa", UC_NONE},
   /* 178 */ {"Int_Tur_Wo", "Intensitaet der Turbulenz in Wolken  (0..4)",
              "1", UC_NONE},
   /* 179 */ {"Int_Eis_Wo", "Intensitaet der Vereisung  (0..4)", "1",
              UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"Sichtweite", "Sichtweite", "m", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"IcingGuess",
              "Icing Regime 1.Guess(1=gen,2=conv,3=strat,4=freez)", "1",
              UC_NONE},
   /* 196 */ {"IcingGrade", "Icing Grade (1=LGT,2=MOD,3=SEV)", "1", UC_NONE},
   /* 197 */ {"IcingRegim",
              "Icing Regime(1=general,2=convect,3=strat,4=freez)", "1",
              UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"Gru_Wetter", "Wetter - Grundzustand (ww", "-", UC_NONE},
   /* 201 */ {"Lok_Wetter", "Wetter - 1. lokale Abweichung (ww", "-",
              UC_NONE},
   /* 202 */ {"Lok_Wetter", "Wetter - 2. lokale Abweichung (ww", "-",
              UC_NONE},
   /* 203 */ {"CLDEPTH", "cloud depth (grey scale", "-", UC_NONE},
   /* 204 */ {"CLCT_MOD", "modified total cloud cover  (0..1)", "1", UC_NONE},
   /* 205 */ {"curr_weath", "current weather (symbol number", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"Cu", "Cumulus  (0..1)", "1", UC_NONE},
   /* 212 */ {"Cb", "Cumulimbus  (0..1)", "1", UC_NONE},
   /* 213 */ {"Sc", "Stratocumulus  (0..1)", "1", UC_NONE},
   /* 214 */ {"Ac", "Altocumulus  (0..1)", "1", UC_NONE},
   /* 215 */ {"Ci", "Cirrus  (0..1)", "1", UC_NONE},
   /* 216 */ {"St", "Stratus  (0..1)", "1", UC_NONE},
   /* 217 */ {"As", "Altostratus  (0..1)", "1", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"Bedeckung", "Bedeckung in Stufen", "1", UC_NONE},
   /* 222 */ {"Konvektion", "Konvektion  ja/nein", "1", UC_NONE},
   /* 223 */ {"MN_GT_90", "Gesamtbedeckung > 90%  ja/nein", "1", UC_NONE},
   /* 224 */ {"RF700_GT_89", "relative Feuchte 700 hPa >= 90% ja/nein", "1",
              UC_NONE},
   /* 225 */ {"RR12_zentr", "Niederschlag 12 std. zentriert", "mm", UC_NONE},
   /* 226 */ {"RR12_LE_half",
              "Niederschlag 12 std. zentriert, Werte <= 0.5mm", "mm",
              UC_NONE},
   /* 227 */ {"RR12_SA_GT_60", "RR12 zentriert, Schneeanteil > 60% ja/nein",
              "1", UC_NONE},
   /* 228 */ {"RR12_Kv_GT_60",
              "RR12 zentriert, konvektiver Anteil > 60% ja/nein", "1",
              UC_NONE},
   /* 229 */ {"SRR12ff", "Starkniederschlag in Stufen (12 std. Folgezeitr)",
              "1", UC_NONE},
   /* 230 */ {"RRMAX_STD", "Maximaler Starkniederschlag / std", "mm/h",
              UC_NONE},
   /* 231 */ {"RRMAX_MIN", "Maximaler Starkniederschlag / min", "mm/min",
              UC_NONE},
   /* 232 */ {"SN12ff_GT_15",
              "Schneefall (12std. Folgezeitraum) > 15 mm ja/nein", "1",
              UC_NONE},
   /* 233 */ {"RRgefr12ff",
              "gefrierender Regen (12std. Folgezeitraum) ja/nein", "1",
              UC_NONE},
   /* 234 */ {"FFboe", "Boeenstaerke in Stufen", "1", UC_NONE},
   /* 235 */ {"Gewitter", "Gewitter in Stufen", "1", UC_NONE},
   /* 236 */ {"Tx2m12h_ze", "2m Maximumtemperatur 12h zentriert",
              "Grad Celsius", UC_NONE},
   /* 237 */ {"Tn2m12h_ze", "2m Minimumtemperatur 12h zentriert",
              "Grad Celsius", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"SCHWUELIND", "Schwuele-Index", "1", UC_NONE},
   /* 252 */ {"SMOGSTUFEN", "Smog-Intensitaetsstufen", "1", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"SMOGHOEHE", "Obergrenze Smog  ( Inversionshoehe )", "m",
              UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};

/*****************************************************************************
 * CPTEC Parameter Tables (GRIB1 Section 1 Table 2)
 * Table versions 254
 *****************************************************************************
 */

const GRIB1ParmTable parm_table_cptec_254[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "hPa", UC_NONE},
   /* 2 */ {"psnm", "Pressure reduced to MSL", "hPa", UC_NONE},
   /* 3 */ {"tsps", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"var4", "undefined", "-", UC_NONE},
   /* 5 */ {"var5", "undefined", "-", UC_NONE},
   /* 6 */ {"geop", "Geopotential", "dam", UC_NONE},
   /* 7 */ {"zgeo", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"gzge", "Geometric height", "m", UC_NONE},
   /* 9 */ {"var9", "undefined", "-", UC_NONE},
   /* 10 */ {"var10", "undefined", "-", UC_NONE},
   /* 11 */ {"temp", "ABSOLUTE TEMPERATURE", "K", UC_K2F},
   /* 12 */ {"vtmp", "VIRTUAL TEMPERATURE", "K", UC_K2F},
   /* 13 */ {"ptmp", "POTENTIAL TEMPERATURE", "K", UC_K2F},
   /* 14 */ {"psat", "PSEUDO-ADIABATIC POTENTIAL TEMPERATURE", "K", UC_K2F},
   /* 15 */ {"mxtp", "MAXIMUM TEMPERATURE", "K", UC_K2F},
   /* 16 */ {"mntp", "MINIMUM TEMPERATURE", "K", UC_K2F},
   /* 17 */ {"tpor", "DEW POINT TEMPERATURE", "K", UC_K2F},
   /* 18 */ {"dptd", "DEW POINT DEPRESSION", "K", UC_NONE},
   /* 19 */ {"lpsr", "LAPSE RATE", "K/m", UC_NONE},
   /* 20 */ {"var20", "undefined", "-", UC_NONE},
   /* 21 */ {"rds1", "RADAR SPECTRA(1)", "-", UC_NONE},
   /* 22 */ {"rds2", "RADAR SPECTRA(2)", "-", UC_NONE},
   /* 23 */ {"rds3", "RADAR SPECTRA(3)", "-", UC_NONE},
   /* 24 */ {"var24", "undefined", "-", UC_NONE},
   /* 25 */ {"tpan", "TEMPERATURE ANOMALY", "K", UC_NONE},
   /* 26 */ {"psan", "PRESSURE ANOMALY", "Pa hPa", UC_NONE},
   /* 27 */ {"zgan", "GEOPOT HEIGHT ANOMALY", "m", UC_NONE},
   /* 28 */ {"wvs1", "WAVE SPECTRA(1)", "-", UC_NONE},
   /* 29 */ {"wvs2", "WAVE SPECTRA(2)", "-", UC_NONE},
   /* 30 */ {"wvs3", "WAVE SPECTRA(3)", "-", UC_NONE},
   /* 31 */ {"wind", "WIND DIRECTION", "deg", UC_NONE},
   /* 32 */ {"wins", "WIND SPEED", "m/s", UC_NONE},
   /* 33 */ {"uvel", "ZONAL WIND (U)", "m/s", UC_NONE},
   /* 34 */ {"vvel", "MERIDIONAL WIND (V)", "m/s", UC_NONE},
   /* 35 */ {"fcor", "STREAM FUNCTION", "m2/s", UC_NONE},
   /* 36 */ {"potv", "VELOCITY POTENTIAL", "m2/s", UC_NONE},
   /* 37 */ {"var37", "undefined", "-", UC_NONE},
   /* 38 */ {"sgvv", "SIGMA COORD VERT VEL", "sec/sec", UC_NONE},
   /* 39 */ {"omeg", "OMEGA", "Pa/s", UC_NONE},
   /* 40 */ {"omg2", "VERTICAL VELOCITY", "m/s", UC_NONE},
   /* 41 */ {"abvo", "ABSOLUTE VORTICITY", "10^5/sec", UC_NONE},
   /* 42 */ {"abdv", "ABSOLUTE DIVERGENCE", "10^5/sec", UC_NONE},
   /* 43 */ {"vort", "VORTICITY", "1/s", UC_NONE},
   /* 44 */ {"divg", "DIVERGENCE", "1/s", UC_NONE},
   /* 45 */ {"vucs", "VERTICAL U-COMP SHEAR", "1/sec", UC_NONE},
   /* 46 */ {"vvcs", "VERT V-COMP SHEAR", "1/sec", UC_NONE},
   /* 47 */ {"dirc", "DIRECTION OF CURRENT", "deg", UC_NONE},
   /* 48 */ {"spdc", "SPEED OF CURRENT", "m/s", UC_NONE},
   /* 49 */ {"ucpc", "U-COMPONENT OF CURRENT", "m/s", UC_NONE},
   /* 50 */ {"vcpc", "V-COMPONENT OF CURRENT", "m/s", UC_NONE},
   /* 51 */ {"umes", "SPECIFIC HUMIDITY", "kg/kg", UC_NONE},
   /* 52 */ {"umrl", "RELATIVE HUMIDITY", "no Dim", UC_NONE},
   /* 53 */ {"hmxr", "HUMIDITY MIXING RATIO", "kg/kg", UC_NONE},
   /* 54 */ {"agpl", "INST. PRECIPITABLE WATER", "Kg/m2", UC_NONE},
   /* 55 */ {"vapp", "VAPOUR PRESSURE", "Pa hpa", UC_NONE},
   /* 56 */ {"sadf", "SATURATION DEFICIT", "Pa hPa", UC_NONE},
   /* 57 */ {"evap", "EVAPORATION", "Kg/m2/day", UC_NONE},
   /* 58 */ {"var58", "undefined", "-", UC_NONE},
   /* 59 */ {"prcr", "PRECIPITATION RATE", "kg/m2/day", UC_NONE},
   /* 60 */ {"thpb", "THUNDER PROBABILITY", "%", UC_NONE},
   /* 61 */ {"prec", "TOTAL PRECIPITATION", "Kg/m2/day", UC_NONE},
   /* 62 */ {"prge", "LARGE SCALE PRECIPITATION", "Kg/m2/day", UC_NONE},
   /* 63 */ {"prcv", "CONVECTIVE PRECIPITATION", "Kg/m2/day", UC_NONE},
   /* 64 */ {"neve", "SNOWFALL", "Kg/m2/day", UC_NONE},
   /* 65 */ {"wenv", "WAT EQUIV ACC SNOW DEPTH", "kg/m2", UC_NONE},
   /* 66 */ {"nvde", "SNOW DEPTH", "cm", UC_NONE},
   /* 67 */ {"mxld", "MIXED LAYER DEPTH", "m cm", UC_NONE},
   /* 68 */ {"tthd", "TRANS THERMOCLINE DEPTH", "m cm", UC_NONE},
   /* 69 */ {"mthd", "MAIN THERMOCLINE DEPTH", "m cm", UC_NONE},
   /* 70 */ {"mtha", "MAIN THERMOCLINE ANOM", "m cm", UC_NONE},
   /* 71 */ {"cbnv", "CLOUD COVER", "0-1", UC_NONE},
   /* 72 */ {"cvnv", "CONVECTIVE CLOUD COVER", "0-1", UC_NONE},
   /* 73 */ {"lwnv", "LOW CLOUD COVER", "0-1", UC_NONE},
   /* 74 */ {"mdnv", "MEDIUM CLOUD COVER", "0-1", UC_NONE},
   /* 75 */ {"hinv", "HIGH CLOUD COVER", "0-1", UC_NONE},
   /* 76 */ {"wtnv", "CLOUD WATER", "kg/m2", UC_NONE},
   /* 77 */ {"bli", "BEST LIFTED INDEX (TO 500 HPA)", "K", UC_NONE},
   /* 78 */ {"var78", "undefined", "-", UC_NONE},
   /* 79 */ {"var79", "undefined", "-", UC_NONE},
   /* 80 */ {"var80", "undefined", "-", UC_NONE},
   /* 81 */ {"lsmk", "LAND SEA MASK", "0,1", UC_NONE},
   /* 82 */ {"dslm", "DEV SEA_LEV FROM MEAN", "m", UC_NONE},
   /* 83 */ {"zorl", "ROUGHNESS LENGTH", "m", UC_NONE},
   /* 84 */ {"albe", "ALBEDO", "%", UC_NONE},
   /* 85 */ {"dstp", "DEEP SOIL TEMPERATURE", "K", UC_K2F},
   /* 86 */ {"soic", "SOIL MOISTURE CONTENT", "Kg/m2", UC_NONE},
   /* 87 */ {"vege", "VEGETATION", "%", UC_NONE},
   /* 88 */ {"var88", "undefined", "-", UC_NONE},
   /* 89 */ {"dens", "DENSITY", "kg/m3", UC_NONE},
   /* 90 */ {"var90", "Undefined", "-", UC_NONE},
   /* 91 */ {"icec", "ICE CONCENTRATION", "fraction", UC_NONE},
   /* 92 */ {"icet", "ICE THICKNESS", "m", UC_NONE},
   /* 93 */ {"iced", "DIRECTION OF ICE DRIFT", "deg", UC_NONE},
   /* 94 */ {"ices", "SPEED OF ICE DRIFT", "m/s", UC_NONE},
   /* 95 */ {"iceu", "U-COMP OF ICE DRIFT", "m/s", UC_NONE},
   /* 96 */ {"icev", "V-COMP OF ICE DRIFT", "m/s", UC_NONE},
   /* 97 */ {"iceg", "ICE GROWTH", "m", UC_NONE},
   /* 98 */ {"icdv", "ICE DIVERGENCE", "sec/sec", UC_NONE},
   /* 99 */ {"var99", "undefined", "-", UC_NONE},
   /* 100 */ {"shcw", "SIG HGT COM WAVE/SWELL", "m", UC_NONE},
   /* 101 */ {"wwdi", "DIRECTION OF WIND WAVE", "deg", UC_NONE},
   /* 102 */ {"wwsh", "SIG HGHT OF WIND WAVES", "m", UC_NONE},
   /* 103 */ {"wwmp", "MEAN PERIOD WIND WAVES", "sec", UC_NONE},
   /* 104 */ {"swdi", "DIRECTION OF SWELL WAVE", "deg", UC_NONE},
   /* 105 */ {"swsh", "SIG HEIGHT SWELL WAVES", "m", UC_NONE},
   /* 106 */ {"swmp", "MEAN PERIOD SWELL WAVES", "sec", UC_NONE},
   /* 107 */ {"prwd", "PRIMARY WAVE DIRECTION", "deg", UC_NONE},
   /* 108 */ {"prmp", "PRIM WAVE MEAN PERIOD", "s", UC_NONE},
   /* 109 */ {"swdi", "SECOND WAVE DIRECTION", "deg", UC_NONE},
   /* 110 */ {"swmp", "SECOND WAVE MEAN PERIOD", "s", UC_NONE},
   /* 111 */ {"ocas", "SHORT WAVE ABSORBED AT GROUND", "W/m2", UC_NONE},
   /* 112 */ {"slds", "NET LONG WAVE AT BOTTOM", "W/m2", UC_NONE},
   /* 113 */ {"nswr", "NET SHORT-WAV RAD(TOP)", "W/m2", UC_NONE},
   /* 114 */ {"role", "OUTGOING LONG WAVE AT TOP", "W/m2", UC_NONE},
   /* 115 */ {"lwrd", "LONG-WAV RAD", "W/m2", UC_NONE},
   /* 116 */ {"swea", "SHORT WAVE ABSORBED BY EARTH/ATMOSPHERE", "W/m2",
              UC_NONE},
   /* 117 */ {"glbr", "GLOBAL RADIATION", "W/m2 ", UC_NONE},
   /* 118 */ {"var118", "undefined", "-", UC_NONE},
   /* 119 */ {"var119", "undefined", "-", UC_NONE},
   /* 120 */ {"var120", "undefined", "-", UC_NONE},
   /* 121 */ {"clsf", "LATENT HEAT FLUX FROM SURFACE", "W/m2", UC_NONE},
   /* 122 */ {"cssf", "SENSIBLE HEAT FLUX FROM SURFACE", "W/m2", UC_NONE},
   /* 123 */ {"blds", "BOUND LAYER DISSIPATION", "W/m2", UC_NONE},
   /* 124 */ {"var124", "undefined", "-", UC_NONE},
   /* 125 */ {"var125", "undefined", "-", UC_NONE},
   /* 126 */ {"var126", "undefined", "-", UC_NONE},
   /* 127 */ {"imag", "IMAGE", "image^data", UC_NONE},
   /* 128 */ {"tp2m", "2 METRE TEMPERATURE", "K", UC_K2F},
   /* 129 */ {"dp2m", "2 METRE DEWPOINT TEMPERATURE", "K", UC_K2F},
   /* 130 */ {"u10m", "10 METRE U-WIND COMPONENT", "m/s", UC_NONE},
   /* 131 */ {"v10m", "10 METRE V-WIND COMPONENT", "m/s", UC_NONE},
   /* 132 */ {"topo", "TOPOGRAPHY", "m", UC_NONE},
   /* 133 */ {"gsfp", "GEOMETRIC MEAN SURFACE PRESSURE", "hPa", UC_NONE},
   /* 134 */ {"lnsp", "LN SURFACE PRESSURE", "hPa", UC_NONE},
   /* 135 */ {"pslc", "SURFACE PRESSURE", "hPa", UC_NONE},
   /* 136 */ {"pslm", "M S L PRESSURE (MESINGER METHOD)", "hPa", UC_NONE},
   /* 137 */ {"mask", "MASK", "-/+", UC_NONE},
   /* 138 */ {"mxwu", "MAXIMUM U-WIND", "m/s", UC_NONE},
   /* 139 */ {"mxwv", "MAXIMUM V-WIND", "m/s", UC_NONE},
   /* 140 */ {"cape", "CONVECTIVE AVAIL. POT.ENERGY", "m2/s2", UC_NONE},
   /* 141 */ {"cine", "CONVECTIVE INHIB. ENERGY", "m2/s2", UC_NONE},
   /* 142 */ {"lhcv", "CONVECTIVE LATENT HEATING", "K/s", UC_NONE},
   /* 143 */ {"mscv", "CONVECTIVE MOISTURE SOURCE", "1/s", UC_NONE},
   /* 144 */ {"scvm", "SHALLOW CONV. MOISTURE SOURCE", "1/s", UC_NONE},
   /* 145 */ {"scvh", "SHALLOW CONVECTIVE HEATING", "K/s", UC_NONE},
   /* 146 */ {"mxwp", "MAXIMUM WIND PRESS. LVL", "hPa", UC_NONE},
   /* 147 */ {"ustr", "STORM MOTION U-COMPONENT", "m/s", UC_NONE},
   /* 148 */ {"vstr", "STORM MOTION V-COMPONENT", "m/s", UC_NONE},
   /* 149 */ {"cbnt", "MEAN CLOUD COVER", "0-1", UC_NONE},
   /* 150 */ {"pcbs", "PRESSURE AT CLOUD BASE", "hPa", UC_NONE},
   /* 151 */ {"pctp", "PRESSURE AT CLOUD TOP", "hPa", UC_NONE},
   /* 152 */ {"fzht", "FREEZING LEVEL HEIGHT", "m", UC_NONE},
   /* 153 */ {"fzrh", "FREEZING LEVEL RELATIVE HUMIDITY", "%", UC_NONE},
   /* 154 */ {"fdlt", "FLIGHT LEVELS TEMPERATURE", "K", UC_K2F},
   /* 155 */ {"fdlu", "FLIGHT LEVELS U-WIND", "m/s", UC_NONE},
   /* 156 */ {"fdlv", "FLIGHT LEVELS V-WIND", "m/s", UC_NONE},
   /* 157 */ {"tppp", "TROPOPAUSE PRESSURE", "hPa", UC_NONE},
   /* 158 */ {"tppt", "TROPOPAUSE TEMPERATURE", "K", UC_K2F},
   /* 159 */ {"tppu", "TROPOPAUSE U-WIND COMPONENT", "m/s", UC_NONE},
   /* 160 */ {"tppv", "TROPOPAUSE v-WIND COMPONENT", "m/s", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"gvdu", "GRAVITY WAVE DRAG DU/DT", "m/s2", UC_NONE},
   /* 163 */ {"gvdv", "GRAVITY WAVE DRAG DV/DT", "m/s2", UC_NONE},
   /* 164 */ {"gvus", "GRAVITY WAVE DRAG SFC ZONAL STRESS", "Pa", UC_NONE},
   /* 165 */ {"gvvs", "GRAVITY WAVE DRAG SFC MERIDIONAL STRESS", "Pa",
              UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"dvsh", "DIVERGENCE OF SPECIFIC HUMIDITY", "1/s", UC_NONE},
   /* 168 */ {"hmfc", "HORIZ. MOISTURE FLUX CONV.", "1/s", UC_NONE},
   /* 169 */ {"vmfl", "VERT. INTEGRATED MOISTURE FLUX CONV.", "kg/(m2*s)",
              UC_NONE},
   /* 170 */ {"vadv", "VERTICAL MOISTURE ADVECTION", "kg/(kg*s)", UC_NONE},
   /* 171 */ {"nhcm", "NEG. HUM. CORR. MOISTURE SOURCE", "kg/(kg*s)",
              UC_NONE},
   /* 172 */ {"lglh", "LARGE SCALE LATENT HEATING", "K/s", UC_NONE},
   /* 173 */ {"lgms", "LARGE SCALE MOISTURE SOURCE", "1/s", UC_NONE},
   /* 174 */ {"smav", "SOIL MOISTURE AVAILABILITY", "0-1", UC_NONE},
   /* 175 */ {"tgrz", "SOIL TEMPERATURE OF ROOT ZONE", "K", UC_K2F},
   /* 176 */ {"bslh", "BARE SOIL LATENT HEAT", "Ws/m2", UC_NONE},
   /* 177 */ {"evpp", "POTENTIAL SFC EVAPORATION", "m", UC_NONE},
   /* 178 */ {"rnof", "RUNOFF", "kg/m2/s)", UC_NONE},
   /* 179 */ {"pitp", "INTERCEPTION LOSS", "W/m2", UC_NONE},
   /* 180 */ {"vpca", "VAPOR PRESSURE OF CANOPY AIR SPACE", "mb", UC_NONE},
   /* 181 */ {"qsfc", "SURFACE SPEC HUMIDITY", "kg/kg", UC_NONE},
   /* 182 */ {"ussl", "SOIL WETNESS OF SURFACE", "0-1", UC_NONE},
   /* 183 */ {"uzrs", "SOIL WETNESS OF ROOT ZONE", "0-1", UC_NONE},
   /* 184 */ {"uzds", "SOIL WETNESS OF DRAINAGE ZONE", "0-1", UC_NONE},
   /* 185 */ {"amdl", "STORAGE ON CANOPY", "m", UC_NONE},
   /* 186 */ {"amsl", "STORAGE ON GROUND", "m", UC_NONE},
   /* 187 */ {"tsfc", "SURFACE TEMPERATURE", "K", UC_K2F},
   /* 188 */ {"tems", "SURFACE ABSOLUTE TEMPERATURE", "K", UC_K2F},
   /* 189 */ {"tcas", "TEMPERATURE OF CANOPY AIR SPACE", "K", UC_K2F},
   /* 190 */ {"ctmp", "TEMPERATURE AT CANOPY", "K", UC_K2F},
   /* 191 */ {"tgsc", "GROUND/SURFACE COVER TEMPERATURE", "K", UC_K2F},
   /* 192 */ {"uves", "SURFACE ZONAL WIND (U)", "m/s", UC_NONE},
   /* 193 */ {"usst", "SURFACE ZONAL WIND STRESS", "Pa", UC_NONE},
   /* 194 */ {"vves", "SURFACE MERIDIONAL WIND (V)", "m/s", UC_NONE},
   /* 195 */ {"vsst", "SURFACE MERIDIONAL WIND STRESS", "Pa", UC_NONE},
   /* 196 */ {"suvf", "SURFACE MOMENTUM FLUX", "W/m2", UC_NONE},
   /* 197 */ {"iswf", "INCIDENT SHORT WAVE FLUX", "W/m2", UC_NONE},
   /* 198 */ {"ghfl", "TIME AVE GROUND HT FLX", "W/m2", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"lwbc", "NET LONG WAVE AT BOTTOM (CLEAR)", "W/m2", UC_NONE},
   /* 201 */ {"lwtc", "OUTGOING LONG WAVE AT TOP (CLEAR)", "W/m2", UC_NONE},
   /* 202 */ {"swec", "SHORT WV ABSRBD BY EARTH/ATMOS (CLEAR)", "W/m2",
              UC_NONE},
   /* 203 */ {"ocac", "SHORT WAVE ABSORBED AT GROUND (CLEAR)", "W/m2",
              UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"lwrh", "LONG WAVE RADIATIVE HEATING", "K/s", UC_NONE},
   /* 206 */ {"swrh", "SHORT WAVE RADIATIVE HEATING", "K/s", UC_NONE},
   /* 207 */ {"olis", "DOWNWARD LONG WAVE AT BOTTOM", "W/m2", UC_NONE},
   /* 208 */ {"olic", "DOWNWARD LONG WAVE AT BOTTOM (CLEAR)", "W/m2",
              UC_NONE},
   /* 209 */ {"ocis", "DOWNWARD SHORT WAVE AT GROUND", "W/m2", UC_NONE},
   /* 210 */ {"ocic", "DOWNWARD SHORT WAVE AT GROUND (CLEAR)", "W/m2",
              UC_NONE},
   /* 211 */ {"oles", "UPWARD LONG WAVE AT BOTTOM", "W/m2", UC_NONE},
   /* 212 */ {"oces", "UPWARD SHORT WAVE AT GROUND", "W/m2", UC_NONE},
   /* 213 */ {"swgc", "UPWARD SHORT WAVE AT GROUND (CLEAR)", "W/m2", UC_NONE},
   /* 214 */ {"roce", "UPWARD SHORT WAVE AT TOP", "W/m2", UC_NONE},
   /* 215 */ {"swtc", "UPWARD SHORT WAVE AT TOP (CLEAR)", "W/m2", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"hhdf", "HORIZONTAL HEATING DIFFUSION", "K/s", UC_NONE},
   /* 219 */ {"hmdf", "HORIZONTAL MOISTURE DIFFUSION", "1/s", UC_NONE},
   /* 220 */ {"hddf", "HORIZONTAL DIVERGENCE DIFFUSION", "1/s2", UC_NONE},
   /* 221 */ {"hvdf", "HORIZONTAL VORTICITY DIFFUSION", "1/s2", UC_NONE},
   /* 222 */ {"vdms", "VERTICAL DIFF. MOISTURE SOURCE", "1/s", UC_NONE},
   /* 223 */ {"vdfu", "VERTICAL DIFFUSION DU/DT", "m/s2", UC_NONE},
   /* 224 */ {"vdfv", "VERTICAL DIFFUSION DV/DT", "m/s2", UC_NONE},
   /* 225 */ {"vdfh", "VERTICAL DIFFUSION HEATING", "K/s", UC_NONE},
   /* 226 */ {"umrs", "SURFACE RELATIVE HUMIDITY", "no Dim", UC_NONE},
   /* 227 */ {"vdcc", "VERTICAL DIST TOTAL CLOUD COVER", "no Dim", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"usmt", "TIME MEAN SURFACE ZONAL WIND (U)", "m/s", UC_NONE},
   /* 231 */ {"vsmt", "TIME MEAN SURFACE MERIDIONAL WIND (V)", "m/s",
              UC_NONE},
   /* 232 */ {"tsmt", "TIME MEAN SURFACE ABSOLUTE TEMPERATURE", "K", UC_K2F},
   /* 233 */ {"rsmt", "TIME MEAN SURFACE RELATIVE HUMIDITY", "no Dim",
              UC_NONE},
   /* 234 */ {"atmt", "TIME MEAN ABSOLUTE TEMPERATURE", "K", UC_K2F},
   /* 235 */ {"stmt", "TIME MEAN DEEP SOIL TEMPERATURE", "K", UC_K2F},
   /* 236 */ {"ommt", "TIME MEAN DERIVED OMEGA", "Pa/s", UC_NONE},
   /* 237 */ {"dvmt", "TIME MEAN DIVERGENCE", "1/s", UC_NONE},
   /* 238 */ {"zhmt", "TIME MEAN GEOPOTENTIAL HEIGHT", "m", UC_NONE},
   /* 239 */ {"lnmt", "TIME MEAN LOG SURFACE PRESSURE", "ln(cbar)", UC_NONE},
   /* 240 */ {"mkmt", "TIME MEAN MASK", "-/+", UC_NONE},
   /* 241 */ {"vvmt", "TIME MEAN MERIDIONAL WIND (V)", "m/s", UC_NONE},
   /* 242 */ {"omtm", "TIME MEAN OMEGA", "cbar/s", UC_NONE},
   /* 243 */ {"ptmt", "TIME MEAN POTENTIAL TEMPERATURE", "K", UC_K2F},
   /* 244 */ {"pcmt", "TIME MEAN PRECIP. WATER", "kg/m2", UC_NONE},
   /* 245 */ {"rhmt", "TIME MEAN RELATIVE HUMIDITY", "%", UC_NONE},
   /* 246 */ {"mpmt", "TIME MEAN SEA LEVEL PRESSURE", "hPa", UC_NONE},
   /* 247 */ {"simt", "TIME MEAN SIGMADOT", "1/s", UC_NONE},
   /* 248 */ {"uemt", "TIME MEAN SPECIFIC HUMIDITY", "kg/kg", UC_NONE},
   /* 249 */ {"fcmt", "TIME MEAN STREAM FUNCTION", "m2/s", UC_NONE},
   /* 250 */ {"psmt", "TIME MEAN SURFACE PRESSURE", "hPa", UC_NONE},
   /* 251 */ {"tmmt", "TIME MEAN SURFACE TEMPERATURE", "K", UC_K2F},
   /* 252 */ {"pvmt", "TIME MEAN VELOCITY POTENTIAL", "m2/s", UC_NONE},
   /* 253 */ {"tvmt", "TIME MEAN VIRTUAL TEMPERATURE", "K", UC_K2F},
   /* 254 */ {"vtmt", "TIME MEAN VORTICITY", "1/s", UC_NONE},
   /* 255 */ {"uvmt", "TIME MEAN ZONAL WIND (U)", "m/s", UC_NONE},
};

/* *INDENT-ON*  */

/*
 * parameter table for AFWA (Air force)
 */

/* AFWA center = 57, subcenter = 0 */
/* Updated last on 7/22/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_afwa_000[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"3HRPCP", "Average 3hr Precip.", "mm/hr", UC_NONE},
   /* 129 */ {"AERTP", "Aerosol type", "(0=none, 1=present)", UC_NONE},
   /* 130 */ {"HSL", "Hours since land", "hours", UC_NONE},
   /* 131 */ {"PRESS", "Pressure", "hPa", UC_NONE},
   /* 132 */ {"MSLPRS", "Pressure reduced to MSL", "hPa", UC_NONE},
   /* 133 */ {"VERVEL", "Pressure Vertical Velocity", "hPa/s", UC_NONE},
   /* 134 */ {"DENALT", "Density Altitude", "m", UC_NONE},
   /* 135 */ {"WBZHGT", "Wet Bulb Zero Height", "m", UC_NONE},
   /* 136 */ {"HAIL", "Hail", "cm", UC_NONE},
   /* 137 */ {"PBLHGT", "Planetary Boundary Layer (PBL) Height", "m", UC_NONE},
   /* 138 */ {"TSMAX", "Thunderstorm Max Tops", "m", UC_NONE},
   /* 139 */ {"TSCOV", "Thunderstorm coverage",
              "(0=none,1=isolated1-2%,2=few3-5%,3=scattered16-45%,4=numerous)",
              UC_NONE},
   /* 140 */ {"CLDCIG", "Ceiling", "m", UC_NONE},
   /* 141 */ {"WGST", "Wind speed of gusts", "m", UC_NONE},
   /* 142 */ {"UGST", "u wind of gusts", "m/s", UC_NONE},
   /* 143 */ {"VGST", "v wind of gusts", "m/s", UC_NONE},
   /* 144 */ {"PCPCAT", "Precip Category", "code?", UC_NONE},
   /* 145 */ {"CT1TOP", "Contrail Engine Type 1 Top", "m", UC_NONE},
   /* 146 */ {"CT1BAS", "Contrail Engine Type 1 Base", "m", UC_NONE},
   /* 147 */ {"CT1INT", "Contrail Engine Type 1 Intensity", "0=none,1=present",
              UC_NONE},
   /* 148 */ {"CT2TOP", "Contrail Engine Type 2 Top", "m", UC_NONE},
   /* 149 */ {"CT2BAS", "Contrail Engine Type 2 Base", "m", UC_NONE},
   /* 150 */ {"CT2INT", "Contrail Engine Type 2 Intensity", "0=none,1=present",
              UC_NONE},
   /* 151 */ {"CT3TOP", "Contrail Engine Type 3 Top", "m", UC_NONE},
   /* 152 */ {"CT3BAS", "Contrail Engine Type 3 Base", "m", UC_NONE},
   /* 153 */ {"CT3INT", "Contrail Engine Type 3 Intensity", "0=none,1=present",
              UC_NONE},
   /* 154 */ {"IRTSM", "IR Transmissivity (IWA vs TDA's)", "%", UC_NONE},
   /* 155 */ {"ABSHUM", "Absolute Humidity", "g/m^3", UC_NONE},
   /* 156 */ {"IRVIS", "IR Visibility", "m", UC_NONE},
   /* 157 */ {"XTRAJ", "X-component of trajectory", "16th mesh grid pts/hr", UC_NONE},
   /* 158 */ {"YTRAJ", "Y-component of trajectory", "16th mesh grid pts/hr", UC_NONE},
   /* 159 */ {"PTRAJ", "J-component of trajectory", "millibars/hr", UC_NONE},
   /* 160 */ {"TERID", "Terrain identifier",
              "0-free atmosphere,2-gradient level trajectory,3-off hemisphere",
              UC_NONE},
   /* 161 */ {"POVORT", "Potential Vorticity", "10^-6xm^2/sK K/g", UC_NONE},
   /* 162 */ {"SEATP", "Sea Surface Temp", ".1Deg C", UC_NONE},
   /* 163 */ {"CLDA", "Cloud Amount (layer)", "%", UC_NONE},
   /* 164 */ {"CLDTYP", "Cloud Type (layer)",
              "1=CB,2=ST,3=SC,4=CU,5=AS,6=NS,7=AC,8=CS,9=CI,0=none", UC_NONE},
   /* 165 */ {"TPI", "Thunderstorm Potential Indicator", "-", UC_NONE},
   /* 166 */ {"SVTFG", "Severe Turbulence Flag (series with 250-254)",
              "0=off,1=on", UC_NONE},
   /* 167 */ {"RAFG", "Precipitation Rain Flag", "0=off,1=on", UC_NONE},
   /* 168 */ {"TSFG", "Precipitation Thunderstorm Flag", "0=off,1=on", UC_NONE},
   /* 169 */ {"SVTSFG", "Precipitation Severe TS Flag", "0=off,1=on", UC_NONE},
   /* 170 */ {"SNFG", "Precipitation Snow Flag", "0=off,1=on", UC_NONE},
   /* 171 */ {"MXDFG", "Precipitation Mixed Flag", "0=off,1=on", UC_NONE},
   /* 172 */ {"IPFG", "Precipitation Ice Pellets Flag", "0=off,1=on", UC_NONE},
   /* 173 */ {"ZRAFG", "Precipitation Freezing Rain Flag", "0=off,1=on", UC_NONE},
   /* 174 */ {"DUSCO", "Dust Concentration", "mg/m^3", UC_NONE},
   /* 175 */ {"DUSFX", "Dust Flux", "mg/(m^2s)", UC_NONE},
   /* 176 */ {"VERDIF", "Vertical Diffusion Coefficient Kz term", "cm^2/s", UC_NONE},
   /* 177 */ {"VISBY", "Visibility", "code_2E", UC_NONE},
   /* 178 */ {"PNSTWX", "Weather", "code_2F", UC_NONE},
   /* 179 */ {"CLDAM", "Layer Cloud Amount", "%_2G", UC_NONE},
   /* 180 */ {"CLDBAS", "Layer Cloud Base", "code_2H", UC_NONE},
   /* 181 */ {"CLDTOP", "Layer Cloud Top", "code_2H", UC_NONE},
   /* 182 */ {"CLDTP", "Layer Cloud Type", "code_2I", UC_NONE},
   /* 183 */ {"UPDTTM", "Time of last update from base time", "minutes", UC_NONE},
   /* 184 */ {"SORDAT", "Source Data", "-", UC_NONE},
   /* 185 */ {"ICTOP", "Icing Top", "m", UC_NONE},
   /* 186 */ {"ICBAS", "Icing Base", "m", UC_NONE},
   /* 187 */ {"ICINT", "Icing", "0=none,1=light,2=moderate,3=severe", UC_NONE},
   /* 188 */ {"TBTOP", "Turbulence Top", "m", UC_NONE},
   /* 189 */ {"TBBAS", "Turbulence Base", "m", UC_NONE},
   /* 190 */ {"TBINT", "Turbulence",
              "0=none,1=light,2=moderate,3=severe,4=extreme", UC_NONE},
   /* 191 */ {"PSTAR", "Pstar (sfc perssure - model top pressure)", "cbar",
              UC_NONE},
   /* 192 */ {"PRSPRT", "Pressure perturbation", "Pa", UC_NONE},
   /* 193 */ {"PBLREG", "PBL Regime",
              "1=stable,2=mechanicallydriven,3=forced,4=free", UC_NONE},
   /* 194 */ {"FRIVEL", "Friction velocity", "m/s", UC_NONE},
   /* 195 */ {"GRAPL", "Graupel", "kg/kg", UC_NONE},
   /* 196 */ {"ICCON", "Number concentration of ice", "number/m^3", UC_NONE},
   /* 197 */ {"ATRAD", "Atmospheric radiative tendency", "K/day", UC_NONE},
   /* 198 */ {"TKE", "Turbulent Kenetic Energy", "J/kg", UC_NONE},
   /* 199 */ {"MAPSCL", "Map scale factor", "-", UC_NONE},
   /* 200 */ {"UPSLTP", "Upper Layer Soil Temp", "K", UC_NONE},
   /* 201 */ {"UPSLMS", "Upper Layer Soil Moisture", "g/m^3(noDim*10^3)",
              UC_NONE},
   /* 202 */ {"LOSLMS", "Lower Layer Soil Moisture", "g/m^3(noDim*10^3)",
              UC_NONE},
   /* 203 */ {"MRGPRP", "Merged Precipitation", "mm/24hrs", UC_NONE},
   /* 204 */ {"EVAPTN", "Evapotranspiration", "mm/24hrs(mm*10^2)", UC_NONE},
   /* 205 */ {"SOILTP", "Soil Type", "code_2K", UC_NONE},
   /* 206 */ {"VOLASH", "Volcanic Ash", "1=present,0=absent", UC_NONE},
   /* 207 */ {"KETI", "Knapp-Ellrod Turbulence Index",
              "0=smooth,1=light,2=moderate,3=severe", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"ALSTG", "Altimeter Setting", "inches Hg", UC_NONE},
   /* 210 */ {"KX", "K index", "K", UC_NONE},
   /* 211 */ {"KOX", "KO index", "K", UC_NONE},
   /* 212 */ {"TTX", "Total totals index", "K", UC_NONE},
   /* 213 */ {"SX", "Sweat index", "-", UC_NONE},
   /* 214 */ {"CAPE", "Convective available potential eng.", "J/kg", UC_NONE},
   /* 215 */ {"CIN", "Convective inhibition", "J/kg", UC_NONE},
   /* 216 */ {"SRHEL", "Storm relative helicity", "J/kg", UC_NONE},
   /* 217 */ {"EHI", "Energy helicity index", "-", UC_NONE},
   /* 218 */ {"ILW", "Integrated liquid water", "g/m^2", UC_NONE},
   /* 219 */ {"COND", "Condensate", "kg/kg", UC_NONE},
   /* 220 */ {"CWMR", "Cloud water mixing ratio", "kg/kg", UC_NONE},
   /* 221 */ {"IWMR", "Ice water mixing ratio", "kg/kg", UC_NONE},
   /* 222 */ {"RWMR", "Rain water mixing ratio", "kg/kg", UC_NONE},
   /* 223 */ {"SWMR", "Snow mixing ratio", "kg/kg", UC_NONE},
   /* 224 */ {"HEATX", "Heat index", "K", UC_NONE},
   /* 225 */ {"MCONV", "Horizontal moisture convergence", "kg/kg/s", UC_NONE},
   /* 226 */ {"TB", "Turbulence (Intensity)",
              "0=smooth,1=light,2=moderate,3=severe", UC_NONE},
   /* 227 */ {"CLDB", "Cloud base", "m", UC_NONE},
   /* 228 */ {"CLDT", "Cloud top", "m", UC_NONE},
   /* 229 */ {"TCLDCV", "Total cloud cover", "%", UC_NONE},
   /* 230 */ {"LAT", "Latitude", "deg", UC_NONE},
   /* 231 */ {"LON", "Longitude", "deg", UC_NONE},
   /* 232 */ {"THKNS", "Thickness", "m", UC_NONE},
   /* 233 */ {"TERHT", "Model terrain height", "m", UC_NONE},
   /* 234 */ {"WCHILL", "Wind Chill", "F", UC_NONE},
   /* 235 */ {"DVAL", "Height D-values", "feet", UC_NONE},
   /* 236 */ {"MXRH", "Maximum relative humidity", "%", UC_NONE},
   /* 237 */ {"MXABSH", "Maximum absolute humidity", "g/m^3", UC_NONE},
   /* 238 */ {"MXWIND", "Maximum wind speed", "m/s", UC_NONE},
   /* 239 */ {"MNDEPR", "Minimum dewpoint depression", "K", UC_K2F},
   /* 240 */ {"TOTACP", "Total accumulated precipitation", "kg/m^2", UC_NONE},
   /* 241 */ {"LNDUSE", "Land-use",
              "1=urban,2=dryland,3=irrigated,4=mixed,5=crop/grassland,"
              "6=crop/woodland,7=grassland,8=shrubland,9=grass/shrubland,"
              "10=savanna,11=deciduous/broad,12=deciduous/needle,"
              "13=evergreen/broad,14=evergreen/needle,15=forest,16=water,"
              "17=HerbaceousWetland,18=WoodedWetland,19=Baren,"
              "20=HerbaceousTundra,21=WoodedTundra,22=MixedTundra,"
              "23=BareTundra,24=Snow", UC_NONE},
   /* 242 */ {"INCSNOF", "Snowfall", "in", UC_NONE},
   /* 243 */ {"TOTSNO", "Total snowfall", "in", UC_NONE},
   /* 244 */ {"PCPTYPE", "Precipitation type",
              "0=none,1=rain,2=TRW,3=ZR,4=mixedIce,5=snow,6=SvrTRW", UC_NONE},
   /* 245 */ {"ICING", "Icing (Intensity)",
              "0=none,1=light,2=moderate,3=severe", UC_NONE},
   /* 246 */ {"RDREF", "Radio Refractivity", "-", UC_NONE},
   /* 247 */ {"VRPOTP", "Virtual Potential Temperature", "K", UC_NONE},
   /* 248 */ {"LSI", "Lid Strength Index", "K", UC_NONE},
   /* 249 */ {"RADRF", "Radar Reflectivity", "db", UC_NONE},
   /* 250 */ {"LGIFG", "Light Icing Flag", "0=off,1=on", UC_NONE},
   /* 251 */ {"MDIFG", "Moderate Icing Flag", "0=off,1=on", UC_NONE},
   /* 252 */ {"SVIFG", "Severe Icing Flag", "0=off,1=on", UC_NONE},
   /* 253 */ {"LGTFG", "Light Turbulence Flag", "0=off,1=on", UC_NONE},
   /* 254 */ {"MDTFG", "Moderate Turbulence Flag", "0=off,1=on", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* AFWA center = 57, subcenter = 1 */
/* Updated last on 7/22/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_afwa_001[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"3HRPCP", "Average 3hr Precip.", "mm/hr", UC_NONE},
   /* 129 */ {"AERTP", "Aerosol type", "(0=none, 1=present)", UC_NONE},
   /* 130 */ {"HSL", "Hours since land", "hours", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"VERVEL", "Pressure Vertical Velocity", "hPa/s", UC_NONE},
   /* 134 */ {"DENALT", "Density Altitude", "m", UC_NONE},
   /* 135 */ {"WBZHGT", "Wet Bulb Zero Height", "m", UC_NONE},
   /* 136 */ {"HAIL", "Hail", "cm", UC_NONE},
   /* 137 */ {"PBLHGT", "Planetary Boundary Layer (PBL) Height", "m", UC_NONE},
   /* 138 */ {"TSMAX", "Thunderstorm Max Tops", "m", UC_NONE},
   /* 139 */ {"TSCOV", "Thunderstorm coverage",
              "(0=none,1=isolated1-2%,2=few3-5%,3=scattered16-45%,4=numerous)",
              UC_NONE},
   /* 140 */ {"CLDCIG", "Ceiling", "m", UC_NONE},
   /* 141 */ {"WGST", "Wind speed of gusts", "m", UC_NONE},
   /* 142 */ {"UGST", "u wind of gusts", "m/s", UC_NONE},
   /* 143 */ {"VGST", "v wind of gusts", "m/s", UC_NONE},
   /* 144 */ {"PRECAT", "Precip Category", "code?", UC_NONE},
   /* 145 */ {"CT1TOP", "Contrail Engine Type 1 Top", "m", UC_NONE},
   /* 146 */ {"CT1BAS", "Contrail Engine Type 1 Base", "m", UC_NONE},
   /* 147 */ {"CT1INT", "Contrail Engine Type 1 Intensity", "0=none,1=present",
              UC_NONE},
   /* 148 */ {"CT2TOP", "Contrail Engine Type 2 Top", "m", UC_NONE},
   /* 149 */ {"CT2BAS", "Contrail Engine Type 2 Base", "m", UC_NONE},
   /* 150 */ {"CT2INT", "Contrail Engine Type 2 Intensity", "0=none,1=present",
              UC_NONE},
   /* 151 */ {"CT3TOP", "Contrail Engine Type 3 Top", "m", UC_NONE},
   /* 152 */ {"CT3BAS", "Contrail Engine Type 3 Base", "m", UC_NONE},
   /* 153 */ {"CT3INT", "Contrail Engine Type 3 Intensity", "0=none,1=present",
              UC_NONE},
   /* 154 */ {"IRTRAN", "IR Transmissivity (IWA vs TDA's)", "%", UC_NONE},
   /* 155 */ {"ABSHUM", "Absolute Humidity", "g/m^3", UC_NONE},
   /* 156 */ {"IRVIS", "IR Visibility", "m", UC_NONE},
   /* 157 */ {"SNCVR", "Snow Cover", "0=noSnow,1=snow", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"POVORT", "Potential Vorticity", "10^-6xm^2/sK K/g", UC_NONE},
   /* 162 */ {"SEATP", "Sea Surface Temp", ".1Deg C", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"TPI", "Thunderstorm Potential Indicator", "-", UC_NONE},
   /* 166 */ {"SVTFG", "Severe Turbulence Flag (series with 250-254)",
              "0=off,1=on", UC_NONE},
   /* 167 */ {"RAFG", "Precipitation Rain Flag", "0=off,1=on", UC_NONE},
   /* 168 */ {"TSFG", "Precipitation Thunderstorm Flag", "0=off,1=on", UC_NONE},
   /* 169 */ {"SVTSFG", "Precipitation Severe TS Flag", "0=off,1=on", UC_NONE},
   /* 170 */ {"SNFG", "Precipitation Snow Flag", "0=off,1=on", UC_NONE},
   /* 171 */ {"MXDFG", "Precipitation Mixed Flag", "0=off,1=on", UC_NONE},
   /* 172 */ {"IPFG", "Precipitation Ice Pellets Flag", "0=off,1=on", UC_NONE},
   /* 173 */ {"ZRAFG", "Precipitation Freezing Rain Flag", "0=off,1=on", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"VISBY", "Visibility", "code_2E", UC_NONE},
   /* 178 */ {"PWX", "Weather", "code_2F", UC_NONE},
   /* 179 */ {"CLDAMT", "Layer Cloud Amount", "%", UC_NONE},
   /* 180 */ {"CLDBAS", "Layer Cloud Base", "m", UC_NONE},
   /* 181 */ {"CLDTOP", "Layer Cloud Top", "m", UC_NONE},
   /* 182 */ {"CLDTP", "Layer Cloud Type", "code_2I", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"ICTOP", "Icing Top", "m", UC_NONE},
   /* 186 */ {"ICBAS", "Icing Base", "m", UC_NONE},
   /* 187 */ {"ICINT", "Icing", "0=none,1=light,2=moderate,3=severe", UC_NONE},
   /* 188 */ {"TBTOP", "Turbulence Top", "m", UC_NONE},
   /* 189 */ {"TBBAS", "Turbulence Base", "m", UC_NONE},
   /* 190 */ {"TBINT", "Turbulence",
              "0=none,1=light,2=moderate,3=severe,4=extreme", UC_NONE},
   /* 191 */ {"PSTAR", "Pstar (sfc perssure - model top pressure)", "cbar",
              UC_NONE},
   /* 192 */ {"PRESPB", "Pressure perturbation", "Pa", UC_NONE},
   /* 193 */ {"PBLREG", "PBL Regime",
              "1=stable,2=mechanicallyDriven,3=forced,4=free", UC_NONE},
   /* 194 */ {"FRIVEL", "Friction velocity", "m/s", UC_NONE},
   /* 195 */ {"GRAPL", "Graupel", "kg/kg", UC_NONE},
   /* 196 */ {"ICCON", "Number concentration of ice", "number/m^3", UC_NONE},
   /* 197 */ {"ATRAD", "Atmospheric radiative tendency", "K/day", UC_NONE},
   /* 198 */ {"TKE", "Turbulent Kenetic Energy", "J/kg", UC_NONE},
   /* 199 */ {"MAPSCL", "Map scale factor", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"KETI", "Knapp-Ellrod Turbulence Index",
              "0=smooth,1=light,2=moderate,3=severe", UC_NONE},
   /* 208 */ {"PANIND", "Panofsky Turbulence Index", "-200-500", UC_NONE},
   /* 209 */ {"ALSTG", "Altimeter Setting", "inches Hg", UC_NONE},
   /* 210 */ {"KX", "K index", "K", UC_NONE},
   /* 211 */ {"KOX", "KO index", "K", UC_NONE},
   /* 212 */ {"TTX", "Total totals index", "K", UC_NONE},
   /* 213 */ {"SX", "Sweat index", "-", UC_NONE},
   /* 214 */ {"CAPE", "Convective available potential eng.", "J/kg", UC_NONE},
   /* 215 */ {"CIN", "Convective inhibition", "J/kg", UC_NONE},
   /* 216 */ {"SRHEL", "Storm relative helicity", "J/kg", UC_NONE},
   /* 217 */ {"EHI", "Energy helicity index", "-", UC_NONE},
   /* 218 */ {"ILW", "Integrated liquid water", "g/m^2", UC_NONE},
   /* 219 */ {"COND", "Condensate", "kg/kg", UC_NONE},
   /* 220 */ {"CWMR", "Cloud water mixing ratio", "kg/kg", UC_NONE},
   /* 221 */ {"IWMR", "Ice water mixing ratio", "kg/kg", UC_NONE},
   /* 222 */ {"RWMR", "Rain water mixing ratio", "kg/kg", UC_NONE},
   /* 223 */ {"SWMR", "Snow mixing ratio", "kg/kg", UC_NONE},
   /* 224 */ {"HEATX", "Heat index", "K", UC_NONE},
   /* 225 */ {"MCONV", "Horizontal moisture convergence", "kg/kg/s", UC_NONE},
   /* 226 */ {"TB", "Turbulence (Intensity)",
              "0=smooth,1=light,2=moderate,3=severe", UC_NONE},
   /* 227 */ {"CLDB", "Cloud base", "m", UC_NONE},
   /* 228 */ {"CLDT", "Cloud top", "m", UC_NONE},
   /* 229 */ {"TCLDCV", "Total cloud cover", "%", UC_NONE},
   /* 230 */ {"LAT", "Latitude", "deg", UC_NONE},
   /* 231 */ {"LON", "Longitude", "deg", UC_NONE},
   /* 232 */ {"THKNS", "Thickness", "m", UC_NONE},
   /* 233 */ {"TERHT", "Model terrain height", "m", UC_NONE},
   /* 234 */ {"WCHILL", "Wind Chill", "F", UC_NONE},
   /* 235 */ {"DVAL", "Height D-values", "feet", UC_NONE},
   /* 236 */ {"MXRH", "Maximum relative humidity", "%", UC_NONE},
   /* 237 */ {"MXABSH", "Maximum absolute humidity", "g/m^3", UC_NONE},
   /* 238 */ {"MXWIND", "Maximum wind speed", "m/s", UC_NONE},
   /* 239 */ {"MNDEPR", "Minimum dewpoint depression", "K", UC_K2F},
   /* 240 */ {"TOTACP", "Total accumulated precipitation", "kg/m^2", UC_NONE},
   /* 241 */ {"LNDUSE", "Land-use",
              "1=urban,2=dryland3=irrigated,4=mixed,5=crop/grassland,"
              "6=crop/woodland,7=grassland,8=shrubland,9=grass/shrubland,"
              "10=savanna,11=deciduous/broad,12=deciduous/needle,"
              "13=evergreen/broad,14=evergreen/needle,15=forest,16=water,"
              "17=HerbaceousWetland,18=WoodedWetland,19=Baren,"
              "20=HerbaceousTundra,21=WoodedTundra,22=MixedTundra,"
              "23=BareTundra,24=Snow", UC_NONE},
   /* 242 */ {"INCSNOF", "Snowfall", "in", UC_NONE},
   /* 243 */ {"TOTSNO", "Total snowfall", "in", UC_NONE},
   /* 244 */ {"PCPTYPE", "Precipitation type",
              "0=none,1=rain,2=TRW,3=ZR,4=mixedIce,5=snow,6=SvrTRW", UC_NONE},
   /* 245 */ {"ICING", "Icing (Intensity)",
              "0=none,1=light,2=moderate,3=severe", UC_NONE},
   /* 246 */ {"RDREF", "Radio Refractivity", "-", UC_NONE},
   /* 247 */ {"VRPOTP", "Virtual Potential Temperature", "K", UC_NONE},
   /* 248 */ {"LSI", "Lid Strength Index", "K", UC_NONE},
   /* 249 */ {"RADRF", "Radar Reflectivity", "db", UC_NONE},
   /* 250 */ {"LGIFG", "Light Icing Flag", "0=off,1=on", UC_NONE},
   /* 251 */ {"MDIFG", "Moderate Icing Flag", "0=off,1=on", UC_NONE},
   /* 252 */ {"SVIFG", "Severe Icing Flag", "0=off,1=on", UC_NONE},
   /* 253 */ {"LGTFG", "Light Turbulence Flag", "0=off,1=on", UC_NONE},
   /* 254 */ {"MDTFG", "Moderate Turbulence Flag", "0=off,1=on", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* AFWA center = 57, subcenter = 2 */
/* Updated last on 7/22/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_afwa_002[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"DUST", "Dust Concentration", "log(Micrograms/m^3)", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"DNLWF", "Downward longwave radiation flux", "W*m^2", UC_NONE},
   /* 145 */ {"DNSWF", "Downward shortwave radiation flux", "W*m^2", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"GFLUX", "Ground Heat Flux", "W*m^2", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"TRAJX", "X-component of trajectory",
              "16th_mesh_gridPts/hr", UC_NONE},
   /* 158 */ {"TRAJY", "Y-component of trajectory",
              "16th_mesh_gridPts/hr", UC_NONE},
   /* 159 */ {"TRAJP", "P-component of trajectory", "millibars/hr", UC_NONE},
   /* 160 */ {"TERRID", "Terrain identifier",
              "0=freeAtmospher,2=gradiantTrajectory,3=hemisphere", UC_NONE},
   /* 161 */ {"TERR", "Terrain height", "m", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"CLAMT", "Cloud amount (layer)", "%", UC_NONE},
   /* 164 */ {"CLTYP", "Cloud type (layer)",
              "1=CB,2=ST,3=SC,4=CU,5=AS,6=Ns,7=AC,8=CS,9=CI,0=noCld", UC_NONE},
   /* 165 */ {"CLIRB", "Cloud Brightness IR", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"SNODEP", "Snow Depth", "inches", UC_NONE},
   /* 175 */ {"SNOAGE", "Snow Age", "days", UC_NONE},
   /* 176 */ {"SNOCLM", "Snow Depth Climo", "inches", UC_NONE},
   /* 177 */ {"VISBY", "Visibility", "code_2E", UC_NONE},
   /* 178 */ {"PWX", "Weather", "code_2F", UC_NONE},
   /* 179 */ {"CLDAMT", "Layer Cloud Amount", "%", UC_NONE},
   /* 180 */ {"CLDBAS", "Layer Cloud Base", "m", UC_NONE},
   /* 181 */ {"CLDTOP", "Layer Cloud Top", "m", UC_NONE},
   /* 182 */ {"CLDTYP", "Layer Cloud Type", "code_2I", UC_NONE},
   /* 183 */ {"LASUPD", "Time of last update from base time", "minutes",
              UC_NONE},
   /* 184 */ {"SORDAT", "Source data", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"PREQF", "Precipitation Quality Factor (Goodness)", "[1-19]",
              UC_NONE},
   /* 194 */ {"SATID", "Satellite Identifier (CDFS II uses 200)",
              "0=noDate,1-15=F13-F27,16-19=F29-F31,20-39=N14-N33,"
              "41-57=SOI-SOZ,58-62=ME5-ME9,63-67=GM5-GM9,68-76=MS1-MS9"
              "77-85=MT1-MT9,86=UND", UC_NONE},
   /* 195 */ {"SATMRG", "Satellite Merged - CDFS II",
              "0=none,1=conventional,2=GOES,3=GOES+conventional,4=DMSP,"
              "5=DMSP+conventional,6=DMSP+GOES,7=DMSP+GOES+conventional"
              "8=Tiros,9=Tiros+Conventional,10=Tiros+Goes,"
              "11=Tiros+Goes+conventional,12=Tiros+DMSP,"
              "13=Tiros+DMSP+Conventional,14=Tiros+DMSP+GOES,"
              "15=Tiros+DMSP+GOES+Conventional", UC_NONE},
   /* 196 */ {"RTPREC", "Estimated precipitation - CDFS II based", "mm/24hrs",
              UC_NONE},
   /* 197 */ {"ALPREC", "Estimated precipitation - all source", "mm/24hrs",
              UC_NONE},
   /* 198 */ {"SATPRE",
              "Estimated precipitation - geostationary satellite based", "mm",
              UC_NONE},
   /* 199 */ {"SATPRK", "Geostationary Satellite estimated",
              "1=betterThanPresentWx,2=betterThanSSMI,3=betterThanCDFSII,"
              "4=betterThanClimo,5=worseThanClimo", UC_NONE},
   /* 200 */ {"RELSOL", "Relative soil moisture", "0-1", UC_NONE},
   /* 201 */ {"SOLMST", "Volumetric Soil Moisture (liquid & frozen)",
              "m^3/m^3", UC_NONE},
   /* 202 */ {"PRECIP", "Precipitation - real amounts", "mm", UC_NONE},
   /* 203 */ {"MRGPRP", "Precipitation - merged analysis", "mm/24hrs", UC_NONE},
   /* 204 */ {"EVAPTS", "Evapotranspiration - actual", "mm/24hrs", UC_NONE},
   /* 205 */ {"SOLTYP", "Soil Type",
              "1=sand,2=loamySand,3=sandyLoam,4=siltLoam,5=silt,6=loam"
              "7=sandyClayLoam,8=siltyClayLoam,9=clayLoam,10=sandyClay"
              "11=siltyClay,12=clay,13=organic,14=water,15=bedrock,16=other",
              UC_NONE},
   /* 206 */ {"VOLASH", "Volcanic Ash", "1=present,0=notPresent", UC_NONE},
   /* 207 */ {"CANOPY", "Plant Canopy moisture content", "mm", UC_NONE},
   /* 208 */ {"EVAPTP", "Evapotranspiration - potential", "mm/hr", UC_NONE},
   /* 209 */ {"WDRUN", "Wind run", "km/24hr", UC_NONE},
   /* 210 */ {"MINRH", "Relative Humidity at minimum temperature", "%", UC_NONE},
   /* 211 */ {"SOLLIQ", "Volumetric Soil Moisture (liquid only)",
              "m^3/m^3", UC_NONE},
   /* 212 */ {"VEGTYP", "Vegetation Type Category",
              "1=urban,2=dryland,3=irrigated,4=mixed,5=crop/grassland,"
              "6=crop/woodland,7=grassland,8=shrubland,9=grass/shrubland,"
              "10=savanna,11=deciduous/broad,12=deciduous/needle,"
              "13=evergreen/broad,14=evergreen/needle,15=forest,16=water,"
              "17=HerbaceousWetland,18=WoodedWetland,19=Baren,"
              "20=HerbaceousTundra,21=WoodedTundra,22=MixedTundra,"
              "23=BareTundra,24=Snow", UC_NONE},
   /* 213 */ {"VGREEN", "Vegetation Greenness", "%", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"CLDB", "Cloud base", "m", UC_NONE},
   /* 228 */ {"CLDT", "Cloud top", "m", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"BGRUN", "Baseflow - groundwater runoff", "mm", UC_NONE},
   /* 235 */ {"SSRUN", "Storm surface runoff", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* AFWA center = 57, subcenter = 3 */
/* Updated last on 7/22/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_afwa_003[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"EDEN", "Electron Density", "1/cm^3", UC_NONE},
   /* 129 */ {"OPLUSDEN", "Oxygen Ion Density", "1/cm^3", UC_NONE},
   /* 130 */ {"HPLUSDEN", "Hydrogen Density", "1/cm^3", UC_NONE},
   /* 131 */ {"N2O2DEN", "Sum of Molecular Nitrogen and Oxygen Density",
              "1/cm^3", UC_NONE},
   /* 132 */ {"ITEMP", "Ion Temperature", "K", UC_NONE},
   /* 133 */ {"ETEMP", "Electron Temperature", "K", UC_NONE},
   /* 134 */ {"FOF2", "F2 Layer Critical Frequency", "MHz", UC_NONE},
   /* 135 */ {"HMF2", "F2 Layer Height", "Km", UC_NONE},
   /* 136 */ {"FOF1", "F1 Layer Critical Frequency", "MHz", UC_NONE},
   /* 137 */ {"HMF1", "F1 Layer Height", "Km", UC_NONE},
   /* 138 */ {"FOE", "E Layer Critical Frequency", "MHz", UC_NONE},
   /* 139 */ {"HME", "E Layer Height", "Km", UC_NONE},
   /* 140 */ {"TEC", "Total Electron Content", "TECU", UC_NONE},
   /* 141 */ {"MLT", "Magnetic Local Time", "hours", UC_NONE},
   /* 142 */ {"GMLAT", "Geomagnetic Latitude", "Deg", UC_NONE},
   /* 143 */ {"GMLON", "Geomagnetic Longitude", "Deg", UC_NONE},
   /* 144 */ {"ALTIONO", "Altitude", "Km", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* AFWA center = 57, subcenter = 10 */
/* Updated last on 7/30/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_afwa_010[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"DTEMP", "Standard Deviation of Temperature", "K", UC_NONE},
   /* 129 */ {"DDEW", "Standard Deviation of Dew Point", "K", UC_NONE},
   /* 130 */ {"DPREC", "Standard Deviation of Precipitation", "mm", UC_NONE},
   /* 131 */ {"DMXTP", "Standard Deviation of Max Temperature", "K", UC_NONE},
   /* 132 */ {"DMNTP", "Standard Deviation of Min Temperature", "K", UC_NONE},
   /* 133 */ {"DSNFL", "Standard Deviation of Snowfall", "m", UC_NONE},
   /* 134 */ {"DPALT", "Standard Deviation of Pressure Altitude", "m", UC_NONE},
   /* 135 */ {"DDALT", "Standard Deviation of Density Altitude", "m", UC_NONE},
   /* 136 */ {"MXDEW", "Max Dew Point", "K", UC_NONE},
   /* 137 */ {"MNDEW", "Min Dew Point", "K", UC_NONE},
   /* 138 */ {"ALSTG", "Altimeter Setting", "hPa", UC_NONE},
   /* 139 */ {"MXALST", "Max Altimeter Setting", "hPa", UC_NONE},
   /* 140 */ {"MNALST", "Min Altimeter Setting", "hPa", UC_NONE},
   /* 141 */ {"PFREQ", "Precipitation Frequency", "%", UC_NONE},
   /* 142 */ {"MXPREC", "Max Precipitation", "mm", UC_NONE},
   /* 143 */ {"SFREQ", "Snowfall Frequency", "%", UC_NONE},
   /* 144 */ {"MXSNO", "Max Snowfall", "m", UC_NONE},
   /* 145 */ {"MXWSP", "Max Wind Speed", "m/s", UC_NONE},
   /* 146 */ {"MNWSP", "Min Wind Speed", "m/s", UC_NONE},
   /* 147 */ {"MXABH", "Max Absolute Humidity", "g/m^3", UC_NONE},
   /* 148 */ {"MNABH", "Min Absolute Humidity", "g/m^3", UC_NONE},
   /* 149 */ {"MNPREC", "Min Precipitation", "mm", UC_NONE},
   /* TODO: Spelling. */
   /* 150 */ {"NEWND", "NE Wind Direction Occurrence", "%", UC_NONE},
   /* 151 */ {"EWND", "E Wind Direction Occurrence", "%", UC_NONE},
   /* 152 */ {"SEWND", "SE Wind Direction Occurrence", "%", UC_NONE},
   /* 153 */ {"SWND", "S Wind Direction Occurrence", "%", UC_NONE},
   /* 154 */ {"SWWND", "SW Wind Direction Occurrence", "%", UC_NONE},
   /* 155 */ {"WWND", "W Wind Direction Occurrence", "%", UC_NONE},
   /* 156 */ {"NWWND", "NW Wind Direction Occurrence", "%", UC_NONE},
   /* 157 */ {"NWND", "N Wind Direction Occurrence", "%", UC_NONE},
   /* 158 */ {"NEWSP", "NE Wind Speed", "m/s", UC_NONE},
   /* 159 */ {"EWSP", "E Wind Speed", "m/s", UC_NONE},
   /* 160 */ {"SEWSP", "SE Wind Speed", "m/s", UC_NONE},
   /* 161 */ {"SWSP", "S Wind Speed", "m/s", UC_NONE},
   /* 162 */ {"SWWSP", "SW Wind Speed", "m/s", UC_NONE},
   /* 163 */ {"WWSP", "W Wind Speed", "m/s", UC_NONE},
   /* 164 */ {"NWWSP", "NW Wind Speed", "m/s", UC_NONE},
   /* 165 */ {"NWSP", "N Wind Speed", "m/s", UC_NONE},
   /* 166 */ {"P01OC", "Precipitation Greater than .01 inch", "-", UC_NONE},
   /* 167 */ {"P4OC", "Precipitation Greater than .4 inch", "-", UC_NONE},
   /* 168 */ {"MNSNO", "Min Snowfall", "m", UC_NONE},
   /* 169 */ {"PALT", "Pressure Altitude", "m", UC_NONE},
   /* 170 */ {"DALT", "Density Altitude", "m", UC_NONE},
   /* 171 */ {"V7FREQ", "Frequency Visibility Less than 9999 meters", "%", UC_NONE},
   /* 172 */ {"V6FREQ", "Frequency Visibility Less than 9000 meters", "%", UC_NONE},
   /* 173 */ {"V5FREQ", "Frequency Visibility Less than 8000 meters", "%", UC_NONE},
   /* 174 */ {"V4FREQ", "Frequency Visibility Less than 6000 meters", "%", UC_NONE},
   /* 175 */ {"V3FREQ", "Frequency Visibility Less than 4800 meters", "%", UC_NONE},
   /* 176 */ {"V2FREQ", "Frequency Visibility Less than 3200 meters", "%", UC_NONE},
   /* 177 */ {"V1FREQ", "Frequency Visibility Less than 1600 meters", "%", UC_NONE},
   /* 178 */ {"V0FREQ", "Frequency Visibility Less than 800 meters", "%", UC_NONE},
   /* 179 */ {"OBFREQ", "Frequency Obstruction to Vision", "%", UC_NONE},
   /* 180 */ {"MXGST", "Max Wind Gust", "m/s", UC_NONE},
   /* 181 */ {"G25FRE", "Frequency Max Wind Gust Greater than 25kt", "%", UC_NONE},
   /* 182 */ {"G35FRE", "Frequency Max Wind Gust Greater than 35kt", "%", UC_NONE},
   /* 183 */ {"G45FRE", "Frequency Max Wind Gust Greater than 50kt", "%", UC_NONE},
   /* 184 */ {"TRANS", "Transmissivity (8-12 um)", "frac", UC_NONE},
   /* 185 */ {"TFREQ", "Frequency Thunderstorms", "%", UC_NONE},
   /* 186 */ {"TBFREQ", "Frequency Turbulence", "%", UC_NONE},
   /* 187 */ {"ICFREQ", "Frequency Icing", "%", UC_NONE},
   /* 188 */ {"IPFREQ", "Frequency Ice Pellets Precipitation", "%", UC_NONE},
   /* 189 */ {"ZRFREQ", "Frequency Freezing Rain Precipitation", "%", UC_NONE},
   /* 190 */ {"HZFREQ", "Frequency Haze", "%", UC_NONE},
   /* 191 */ {"FGFREQ", "Frequency Fog", "%", UC_NONE},
   /* 192 */ {"BDFREQ", "Frequency Blowing Dust", "%", UC_NONE},
   /* 193 */ {"BSFREQ", "Frequency Blowing Snow", "%", UC_NONE},
   /* 194 */ {"T90FRQ", "Frequency Temperature Above 90 F", "%", UC_NONE},
   /* 195 */ {"T32FRQ", "Frequency Temperature Above 32 F", "%", UC_NONE},
   /* 196 */ {"T0FRQ", "Frequency Temperature Above 0 F", "%", UC_NONE},
   /* 197 */ {"CLDBAS", "Cloud Base", "m", UC_NONE},
   /* 198 */ {"CLDCIG", "Cloud Ceiling", "m", UC_NONE},
   /* 199 */ {"CLDTOP", "Cloud Top", "m", UC_NONE},
   /* 200 */ {"CIGFRQ", "Frequency Ceiling", "%", UC_NONE},
   /* 201 */ {"CTPFRQ", "Frequency Cloud Tops", "%", UC_NONE},
   /* 202 */ {"CV107F", "Frequency Ceiling/Visibility Less than 10kft/7mi",
              "%", UC_NONE},
   /* 203 */ {"CV33F", "Frequency Ceiling/Visibility Less than 3kft/3mi", "%",
              UC_NONE},
   /* 204 */ {"CV153F", "Frequency Ceiling/Visibility Less than 1.5kft/3mi",
              "%", UC_NONE},
   /* 205 */ {"CV12F", "Frequency Ceiling/Visibility Less than 1kft/2mi",
              "%", UC_NONE},
   /* 206 */ {"CV55F", "Frequency Ceiling/Visibility Less than .5kft/.5mi",
              "%", UC_NONE},
   /* 207 */ {"CV1510F", "Frequency Ceiling/Visibility Less than 15kft/10mi",
              "%", UC_NONE},
   /* 208 */ {"CV105F", "Frequency Ceiling/Visibility Less than 10kft/5mi",
              "%", UC_NONE},
   /* 209 */ {"CV52F", "Frequency Ceiling/Visibility Less than .5kft/2mi",
              "%", UC_NONE},
   /* 210 */ {"CV15F", "Frequency Ceiling/Visibility Less than 1kft/.5mi",
              "%", UC_NONE},
   /* 211 */ {"CV2015F", "Frequency Ceiling/Visibility Less than 20kft/15mi",
              "%", UC_NONE},
   /* 212 */ {"ICCAT", "Icing Category", "cat", UC_NONE},
   /* 213 */ {"TBCAT", "Turbulence Category", "cat", UC_NONE},
   /* 214 */ {"SOLSAT", "Soil Moisture Saturation", "%", UC_NONE},
   /* 215 */ {"MAXRH", "Max Relative Humidity", "%", UC_NONE},
   /* 216 */ {"MINRH", "Min Relative Humidity", "%", UC_NONE},
   /* 217 */ {"MXSND", "Max Snow Depth", "m", UC_NONE},
   /* 218 */ {"MNSND", "Min Snow Depth", "m", UC_NONE},
   /* 219 */ {"MXSSAT", "Max Soil Moisture Saturation", "%", UC_NONE},
   /* 220 */ {"MNSSAT", "Min Soil Moisture Saturation", "%", UC_NONE},
   /* 221 */ {"ALCIG", "Frequency All Ceilings", "%", UC_NONE},
   /* 222 */ {"FQFZG", "Frequency Frozen Ground", "%", UC_NONE},
   /* 223 */ {"ABSHUM", "Absolute Humidity", "g*m^3", UC_NONE},
   /* 224 */ {"PRECIP", "Precipitation", "mm", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* AFWA center = 57, subcenter = 11 */
/* Updated last on 7/30/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_afwa_011[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"HSL", "Hours since land", "hours", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"TPERR", "Temperature Error Estimate", "K", UC_NONE},
   /* 201 */ {"MRERR", "Mixing Ratio Error Estimate", "kg/kg", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"LNDUSE", "Land-use",
              "1=urban,2=dryland,3=irrigated,4=mixed,5=crop/grassland,"
              "6=crop/woodland,7=grassland,8=shrubland,9=grass/shrubland,"
              "10=savanna,11=deciduous/broad,12=deciduous/needle", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* athens grid */
/* Updated last on 3/13/2006 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_athens[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"CLW", "Cloud water", "Kg/m^2", UC_NONE},
   /* 129 */ {"RNW", "Total precipitation", "Kg/m^2", UC_NONE},
   /* 130 */ {"RadTend", "Atmospheric radiative tendency", "K/day", UC_NONE},
   /* 131 */ {"PP", "Pressure perturbation", "Pa", UC_NONE},
   /* 132 */ {"PSTARCRS", "Surface Pressure minus PTOP", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"TERRAIN", "Terrain Elevation", "m", UC_NONE},
   /* 136 */ {"MAPFACCR", "Map Scale Factor", "-", UC_NONE},
   /* 137 */ {"MAPFACDT", "Map Scale Factor", "-", UC_NONE},
   /* 138 */ {"CORIOLIS", "Coriolis Parameter", "1/s", UC_NONE},
   /* 139 */ {"ResTemp", "Infinite Reservoir Slab Temperature", "K", UC_NONE},
   /* 140 */ {"LATITCRS", "Latitude cross points (south negative)", "Degrees", UC_NONE},
   /* 141 */ {"LONGICRS", "Longitude cross points (west negative)", "Degrees", UC_NONE},
   /* 142 */ {"LandUse", "Land use category", "-", UC_NONE},
   /* 143 */ {"Regime", "PBL Regime", "-", UC_NONE},
   /* 144 */ {"UST", "Frictional Velocity", "m/s", UC_NONE},
   /* 145 */ {"SWDOWN", "Surface Downward Shortwave Radiation", "W/m^2", UC_NONE},
   /* 146 */ {"LWDOWN", "Surface Downward Longwave Radiation", "W/m^2", UC_NONE},
   /* 147 */ {"SWOUT", "Top Outgoing Shortwave Radiation", "W/m^2", UC_NONE},
   /* 148 */ {"LWOUT", "Top Outgoing Longwave Radiation", "W/m^2", UC_NONE},
   /* 149 */ {"SOIL_T", "Soil Temperature in Layer N", "K", UC_NONE},
   /* 150 */ {"LATITDOT", "Latitude dot points", "Degrees", UC_NONE},
   /* 151 */ {"LONGIDOT", "Longitude dot points", "Degrees", UC_NONE},
   /* 152 */ {"PRESSURE", "Pressure", "-", UC_NONE},
   /* 153 */ {"SUMFB", "SUMFB", "-", UC_NONE},
   /* 154 */ {"SPSRC", "SPSRC", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"ICE", "Ice cloud mixing ratio", "kg/kg", UC_NONE},
   /* 161 */ {"SNOW", "Snow mixing ratio", "kg/kg", UC_NONE},
   /* 162 */ {"GRAUPEL", "Graupel", "kg/kg", UC_NONE},
   /* 163 */ {"NCI", "Number concentration of ice", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* norway grid */
/* Updated last on 10/24/2007 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_norway128[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"ps", "ps (Pressure?)", "hPa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"dpsdt", "dpsdt (Pressure tendency?)", "hPa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"fi", "fi (Geopotential?)", "m", UC_NONE},
   /* 7 */ {"z", "z (Geopotential height?)", "m", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"t", "t (Temperature?)", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"th", "th (Potential temperature?)", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"u", "u (u-component of wind?)", "m/s", UC_NONE},
   /* 34 */ {"v", "v (v-component of wind?)", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"om", "om (Vertical velocity (pressure)?)", "hPa/s", UC_NONE},
   /* 40 */ {"etadot", "etadot (Vertical velocity (geometric)?)", "1/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"q", "q (Specific humidity?)", "kg/kg", UC_NONE},
   /* 52 */ {"rh", "rh (Relative humidity?)", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"preta", "preta (Thunderstorm probability?)", "mm", UC_NONE},
   /* 61 */ {"prt", "prt (Total precipitation?)", "mm", UC_NONE},
   /* 62 */ {"ptl", "ptl (Large scale precipitation?)", "mm", UC_NONE},
   /* 63 */ {"prc", "prc (Convective precipitation?)", "mm", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"tsnow", "tsnow (Water equiv. of accum. snow depth?)", "mm", UC_NONE},
   /* 66 */ {"sn", "sn (Snow depth?)", "mm", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"totcov", "totcov (Total cloud cover?)", "%", UC_NONE},
   /* 72 */ {"cucov", "cucov (Convective cloud cover?)", "%", UC_NONE},
   /* 73 */ {"clow", "clow (Low cloud cover?)", "%", UC_NONE},
   /* 74 */ {"cmean", "cmean (Medium cloud cover?)", "%", UC_NONE},
   /* 75 */ {"chigh", "chigh (High cloud cover?)", "%", UC_NONE},
   /* 76 */ {"cwpath", "cwpath (Cloud water?)", "kg/m^2", UC_NONE},
/* 76: cw (kg/kg) vs cwpath (kg/m^2) same parm number */
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"csnow", "csnow (Convective snow?)", "mm", UC_NONE},
   /* 79 */ {"lsnow", "lsnow (Large scale snow?)", "mm", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"frl", "frl (Land cover?)", "%", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"rou", "rou (Surface roughness?)", "m", UC_NONE},
   /* 84 */ {"alb", "alb (Albedo?)", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"sw", "sw (Soil moisture content?)", "m", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"fri", "fri (Ice cover?)", "%", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"asswr", "asswr (Net short wave radiation flux?)",
              "kW*s/m^2", UC_NONE},
   /* 112 */ {"aslwr", "aslwr (Net long wave radiation flux?)",
              "kW*s/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"slhf", "slhf (Latent heat net flux?)", "W/m^2", UC_NONE},
/* 121: aslhf vs slhf have different units */
   /* 122 */ {"sshf", "sshf (Sensible heat flux?)", "W/m^2", UC_NONE},
/* 122: asshf vs sshf have different units */
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"smf", "smf (Momentum flux, u-component?)", "N/m^2", UC_NONE},
/* 124: asmf vs smf have different units */
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"smf", "smf", "N/m^2", UC_NONE},
/* 128: asmf vs smf have different units. */
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"t2land", "t2land", "K", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"frf", "frf", "%", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* Canada Met grid */
/* see:
 * http://weatheroffice.ec.gc.ca/grib/High-resolution_GRIB_e.html#convention
 */
/* Updated last on 11/13/2006 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_cmc[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat net flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"SOILW", "Volumetric Soil Moisture Content", "fraction", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"DSWRF", "Downward Short Wave Radiation Flux", "W/m^2", UC_NONE},
   /* 205 */ {"DLWRF", "Downward Long Wave Radiation Flux", "W/m^2", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"USWRF", "Upward Short Wave Radiation Flux", "W/m^2", UC_NONE},
   /* 212 */ {"ULWRF", "Upward Long Wave Radiation Flux", "W/m^2", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */

/* UNDEFINED GRID */
/* Updated last on 7/30/2004 */
/* *INDENT-OFF* */
const GRIB1ParmTable parm_table_undefined[256] = {
   /* 0 */ {"var0", "undefined", "-", UC_NONE},
   /* 1 */ {"PRES", "Pressure", "Pa", UC_NONE},
   /* 2 */ {"PRMSL", "Pressure reduced to MSL", "Pa", UC_NONE},
   /* 3 */ {"PTEND", "Pressure tendency", "Pa/s", UC_NONE},
   /* 4 */ {"PVORT", "Potential vorticity", "m^2K/kg/s", UC_NONE},
   /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height", "m",
            UC_NONE},
   /* 6 */ {"GP", "Geopotential", "m^2/s^2", UC_NONE},
   /* 7 */ {"HGT", "Geopotential height", "gpm", UC_NONE},
   /* 8 */ {"DIST", "Geometric height", "m", UC_NONE},
   /* 9 */ {"HSTDV", "Standard deviation of height", "m", UC_NONE},
   /* 10 */ {"TOZNE", "Total ozone", "Dobson", UC_NONE},
   /* 11 */ {"TMP", "Temperature", "K", UC_K2F},
   /* 12 */ {"VTMP", "Virtual temperature", "K", UC_K2F},
   /* 13 */ {"POT", "Potential temperature", "K", UC_K2F},
   /* 14 */ {"EPOT", "Pseudo-adiabatic potential temperature", "K", UC_K2F},
   /* 15 */ {"TMAX", "Maximum temperature", "K", UC_K2F},
   /* 16 */ {"TMIN", "Minimum temperature", "K", UC_K2F},
   /* 17 */ {"DPT", "Dew point temperature", "K", UC_K2F},
   /* 18 */ {"DEPR", "Dew point depression", "K", UC_NONE}, /* Delta temp */
   /* 19 */ {"LAPR", "Lapse rate", "K/m", UC_NONE},
   /* 20 */ {"VIS", "Visibility", "m", UC_NONE},
   /* 21 */ {"RDSP1", "Radar Spectra (1)", "-", UC_NONE},
   /* 22 */ {"RDSP2", "Radar Spectra (2)", "-", UC_NONE},
   /* 23 */ {"RDSP3", "Radar Spectra (3)", "-", UC_NONE},
   /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa)", "K", UC_NONE},
             /* delta temp. */
   /* 25 */ {"TMPA", "Temperature anomaly", "K", UC_NONE}, /* Delta temp */
   /* 26 */ {"PRESA", "Pressure anomaly", "Pa", UC_NONE},
   /* 27 */ {"GPA", "Geopotential height anomaly", "gpm", UC_NONE},
   /* 28 */ {"WVSP1", "Wave Spectra (1)", "-", UC_NONE},
   /* 29 */ {"WVSP2", "Wave Spectra (2)", "-", UC_NONE},
   /* 30 */ {"WVSP3", "Wave Spectra (3)", "-", UC_NONE},
   /* 31 */ {"WDIR", "Wind direction", "deg", UC_NONE},
   /* 32 */ {"WIND", "Wind speed", "m/s", UC_NONE},
   /* 33 */ {"UGRD", "u-component of wind", "m/s", UC_NONE},
   /* 34 */ {"VGRD", "v-component of wind", "m/s", UC_NONE},
   /* 35 */ {"STRM", "Stream function", "m^2/s", UC_NONE},
   /* 36 */ {"VPOT", "Velocity potential", "m^2/s", UC_NONE},
   /* 37 */ {"MNTSF", "Montgomery stream function", "m^2/s^2", UC_NONE},
   /* 38 */ {"SGCVV", "Sigma coordinate vertical velocity", "1/s", UC_NONE},
   /* 39 */ {"VVEL", "Vertical velocity (pressure)", "Pa/s", UC_NONE},
   /* 40 */ {"DZDT", "Vertical velocity (geometric)", "m/s", UC_NONE},
   /* 41 */ {"ABSV", "Absolute vorticity", "1/s", UC_NONE},
   /* 42 */ {"ABSD", "Absolute divergence", "1/s", UC_NONE},
   /* 43 */ {"RELV", "Relative vorticity", "1/s", UC_NONE},
   /* 44 */ {"RELD", "Relative divergence", "1/s", UC_NONE},
   /* 45 */ {"VUCSH", "Vertical u-component shear", "1/s", UC_NONE},
   /* 46 */ {"VVCSH", "Vertical v-component shear", "1/s", UC_NONE},
   /* 47 */ {"DIRC", "Direction of current", "deg", UC_NONE},
   /* 48 */ {"SPC", "Speed of current", "m/s", UC_NONE},
   /* 49 */ {"UOGRD", "u-component of current", "m/s", UC_NONE},
   /* 50 */ {"VOGRD", "v-component of current", "m/s", UC_NONE},
   /* 51 */ {"SPFH", "Specific humidity", "kg/kg", UC_NONE},
   /* 52 */ {"RH", "Relative humidity", "%", UC_NONE},
   /* 53 */ {"MIXR", "Humidity mixing ratio", "kg/kg", UC_NONE},
   /* 54 */ {"PWAT", "Precipitable water", "kg/m^2", UC_NONE},
   /* 55 */ {"VAPP", "Vapor pressure", "Pa", UC_NONE},
   /* 56 */ {"SATD", "Saturation deficit", "Pa", UC_NONE},
   /* 57 */ {"EVP", "Evaporation", "kg/m^2", UC_NONE},
   /* 58 */ {"CICE", "Cloud Ice", "kg/m^2", UC_NONE},
   /* 59 */ {"PRATE", "Precipitation rate", "kg/m^2/s", UC_NONE},
   /* 60 */ {"TSTM", "Thunderstorm probability", "%", UC_NONE},
   /* 61 */ {"APCP", "Total precipitation", "kg/m^2", UC_InchWater},
   /* 62 */ {"NCPCP", "Large scale precipitation", "kg/m^2", UC_NONE},
   /* 63 */ {"ACPCP", "Convective precipitation", "kg/m^2", UC_NONE},
   /* 64 */ {"SRWEQ", "Snowfall rate water equivalent", "kg/m^2/s", UC_NONE},
   /* 65 */ {"WEASD", "Water equiv. of accum. snow depth", "kg/m^2", UC_NONE},
   /* 66 */ {"SNOD", "Snow depth", "m", UC_NONE},
   /* 67 */ {"MIXHT", "Mixed layer depth", "m", UC_NONE},
   /* 68 */ {"TTHDP", "Transient thermocline depth", "m", UC_NONE},
   /* 69 */ {"MTHD", "Main thermocline depth", "m", UC_NONE},
   /* 70 */ {"MTHA", "Main thermocline anomaly", "m", UC_NONE},
   /* 71 */ {"TCDC", "Total cloud cover", "%", UC_NONE},
   /* 72 */ {"CDCON", "Convective cloud cover", "%", UC_NONE},
   /* 73 */ {"LCDC", "Low cloud cover", "%", UC_NONE},
   /* 74 */ {"MCDC", "Medium cloud cover", "%", UC_NONE},
   /* 75 */ {"HCDC", "High cloud cover", "%", UC_NONE},
   /* 76 */ {"CWAT", "Cloud water", "kg/m^2", UC_NONE},
   /* 77 */ {"BLI", "Best lifted index (to 500 hPa)", "K", UC_NONE},
             /* Delta Temp. */
   /* 78 */ {"SNOC", "Convective snow", "kg/m^2", UC_NONE},
   /* 79 */ {"SNOL", "Large scale snow", "kg/m^2", UC_NONE},
   /* 80 */ {"WTMP", "Water Temperature", "K", UC_K2F},
   /* 81 */ {"LAND", "Land cover (land=1, sea=0)", "proportion", UC_NONE},
   /* 82 */ {"DSLM", "Deviation of sea level from mean", "m", UC_NONE},
   /* 83 */ {"SFCR", "Surface roughness", "m", UC_NONE},
   /* 84 */ {"ALBDO", "Albedo", "%", UC_NONE},
   /* 85 */ {"TSOIL", "Soil temperature", "K", UC_K2F},
   /* 86 */ {"SOILM", "Soil moisture content", "kg/m^2", UC_NONE},
   /* 87 */ {"VEG", "Vegetation", "%", UC_NONE},
   /* 88 */ {"SALTY", "Salinity", "kg/kg", UC_NONE},
   /* 89 */ {"DEN", "Density", "kg/m^3", UC_NONE},
   /* 90 */ {"WATR", "Water runoff", "kg/m^2", UC_NONE},
   /* 91 */ {"ICEC", "Ice cover (ice=1;no ice=0)", "proportion", UC_NONE},
   /* 92 */ {"ICETK", "Ice thickness", "m", UC_NONE},
   /* 93 */ {"DICED", "Direction of ice drift", "deg", UC_NONE},
   /* 94 */ {"SICED", "Speed of ice drift", "m/s", UC_NONE},
   /* 95 */ {"UICE", "u-component of ice drift", "m/s", UC_NONE},
   /* 96 */ {"VICE", "v-component of ice drift", "m/s", UC_NONE},
   /* 97 */ {"ICEG", "Ice growth rate", "m/s", UC_NONE},
   /* 98 */ {"ICED", "Ice divergence", "1/s", UC_NONE},
   /* 99 */ {"SNOM", "Snow melt", "kg/m^2", UC_NONE},
   /* 100 */ {"HTSGW", "Significant height of combined wind waves and swell",
              "m", UC_NONE},
   /* 101 */ {"WVDIR", "Direction of wind waves (from which)", "deg", UC_NONE},
   /* 102 */ {"WVHGT", "Significant height of wind waves", "m", UC_NONE},
   /* 103 */ {"WVPER", "Mean period of wind waves", "s", UC_NONE},
   /* 104 */ {"SWDIR", "Direction of swell waves", "deg", UC_NONE},
   /* 105 */ {"SWELL", "Significant height of swell waves", "m", UC_NONE},
   /* 106 */ {"SWPER", "Mean period of swell waves", "s", UC_NONE},
   /* 107 */ {"DIRPW", "Primary wave direction", "deg", UC_NONE},
   /* 108 */ {"PERPW", "Primary wave mean period", "s", UC_NONE},
   /* 109 */ {"DIRSW", "Secondary wave direction", "deg", UC_NONE},
   /* 110 */ {"PERSW", "Secondary wave mean period", "s", UC_NONE},
   /* 111 */ {"NSWRS", "Net short wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 112 */ {"NLWRS", "Net long wave radiation flux (surface)",
              "W/m^2", UC_NONE},
   /* 113 */ {"NSWRT", "Net short wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 114 */ {"NLWRT", "Net long wave radiation flux (top of atmosphere)",
              "W/m^2", UC_NONE},
   /* 115 */ {"LWAVR", "Long wave radiation flux", "W/m^2", UC_NONE},
   /* 116 */ {"SWAVR", "Short wave radiation flux", "W/m^2", UC_NONE},
   /* 117 */ {"GRAD", "Global radiation flux", "W/m^2", UC_NONE},
   /* 118 */ {"BRTMP", "Brightness temperature", "K", UC_K2F},
   /* 119 */ {"LWRAD", "Radiance (with respect to wave number)", "W/m/sr",
              UC_NONE},
   /* 120 */ {"SWRAD", "Radiance (with respect to wave length)", "W/m^3/sr",
              UC_NONE},
   /* 121 */ {"LHTFL", "Latent heat net flux", "W/m^2", UC_NONE},
   /* 122 */ {"SHTFL", "Sensible heat flux", "W/m^2", UC_NONE},
   /* 123 */ {"BLYDP", "Boundary layer dissipation", "W/m^2", UC_NONE},
   /* 124 */ {"UFLX", "Momentum flux, u-component", "N/m^2", UC_NONE},
   /* 125 */ {"VFLX", "Momentum flux, v-component", "N/m^2", UC_NONE},
   /* 126 */ {"WMIXE", "Wind mixing energy", "J", UC_NONE},
   /* 127 */ {"IMGD", "Image data", "-", UC_NONE},

   /* 128 */ {"var128", "undefined", "-", UC_NONE},
   /* 129 */ {"var129", "undefined", "-", UC_NONE},
   /* 130 */ {"var130", "undefined", "-", UC_NONE},
   /* 131 */ {"var131", "undefined", "-", UC_NONE},
   /* 132 */ {"var132", "undefined", "-", UC_NONE},
   /* 133 */ {"var133", "undefined", "-", UC_NONE},
   /* 134 */ {"var134", "undefined", "-", UC_NONE},
   /* 135 */ {"var135", "undefined", "-", UC_NONE},
   /* 136 */ {"var136", "undefined", "-", UC_NONE},
   /* 137 */ {"var137", "undefined", "-", UC_NONE},
   /* 138 */ {"var138", "undefined", "-", UC_NONE},
   /* 139 */ {"var139", "undefined", "-", UC_NONE},
   /* 140 */ {"var140", "undefined", "-", UC_NONE},
   /* 141 */ {"var141", "undefined", "-", UC_NONE},
   /* 142 */ {"var142", "undefined", "-", UC_NONE},
   /* 143 */ {"var143", "undefined", "-", UC_NONE},
   /* 144 */ {"var144", "undefined", "-", UC_NONE},
   /* 145 */ {"var145", "undefined", "-", UC_NONE},
   /* 146 */ {"var146", "undefined", "-", UC_NONE},
   /* 147 */ {"var147", "undefined", "-", UC_NONE},
   /* 148 */ {"var148", "undefined", "-", UC_NONE},
   /* 149 */ {"var149", "undefined", "-", UC_NONE},
   /* 150 */ {"var150", "undefined", "-", UC_NONE},
   /* 151 */ {"var151", "undefined", "-", UC_NONE},
   /* 152 */ {"var152", "undefined", "-", UC_NONE},
   /* 153 */ {"var153", "undefined", "-", UC_NONE},
   /* 154 */ {"var154", "undefined", "-", UC_NONE},
   /* 155 */ {"var155", "undefined", "-", UC_NONE},
   /* 156 */ {"var156", "undefined", "-", UC_NONE},
   /* 157 */ {"var157", "undefined", "-", UC_NONE},
   /* 158 */ {"var158", "undefined", "-", UC_NONE},
   /* 159 */ {"var159", "undefined", "-", UC_NONE},
   /* 160 */ {"var160", "undefined", "-", UC_NONE},
   /* 161 */ {"var161", "undefined", "-", UC_NONE},
   /* 162 */ {"var162", "undefined", "-", UC_NONE},
   /* 163 */ {"var163", "undefined", "-", UC_NONE},
   /* 164 */ {"var164", "undefined", "-", UC_NONE},
   /* 165 */ {"var165", "undefined", "-", UC_NONE},
   /* 166 */ {"var166", "undefined", "-", UC_NONE},
   /* 167 */ {"var167", "undefined", "-", UC_NONE},
   /* 168 */ {"var168", "undefined", "-", UC_NONE},
   /* 169 */ {"var169", "undefined", "-", UC_NONE},
   /* 170 */ {"var170", "undefined", "-", UC_NONE},
   /* 171 */ {"var171", "undefined", "-", UC_NONE},
   /* 172 */ {"var172", "undefined", "-", UC_NONE},
   /* 173 */ {"var173", "undefined", "-", UC_NONE},
   /* 174 */ {"var174", "undefined", "-", UC_NONE},
   /* 175 */ {"var175", "undefined", "-", UC_NONE},
   /* 176 */ {"var176", "undefined", "-", UC_NONE},
   /* 177 */ {"var177", "undefined", "-", UC_NONE},
   /* 178 */ {"var178", "undefined", "-", UC_NONE},
   /* 179 */ {"var179", "undefined", "-", UC_NONE},
   /* 180 */ {"var180", "undefined", "-", UC_NONE},
   /* 181 */ {"var181", "undefined", "-", UC_NONE},
   /* 182 */ {"var182", "undefined", "-", UC_NONE},
   /* 183 */ {"var183", "undefined", "-", UC_NONE},
   /* 184 */ {"var184", "undefined", "-", UC_NONE},
   /* 185 */ {"var185", "undefined", "-", UC_NONE},
   /* 186 */ {"var186", "undefined", "-", UC_NONE},
   /* 187 */ {"var187", "undefined", "-", UC_NONE},
   /* 188 */ {"var188", "undefined", "-", UC_NONE},
   /* 189 */ {"var189", "undefined", "-", UC_NONE},
   /* 190 */ {"var190", "undefined", "-", UC_NONE},
   /* 191 */ {"var191", "undefined", "-", UC_NONE},
   /* 192 */ {"var192", "undefined", "-", UC_NONE},
   /* 193 */ {"var193", "undefined", "-", UC_NONE},
   /* 194 */ {"var194", "undefined", "-", UC_NONE},
   /* 195 */ {"var195", "undefined", "-", UC_NONE},
   /* 196 */ {"var196", "undefined", "-", UC_NONE},
   /* 197 */ {"var197", "undefined", "-", UC_NONE},
   /* 198 */ {"var198", "undefined", "-", UC_NONE},
   /* 199 */ {"var199", "undefined", "-", UC_NONE},
   /* 200 */ {"var200", "undefined", "-", UC_NONE},
   /* 201 */ {"var201", "undefined", "-", UC_NONE},
   /* 202 */ {"var202", "undefined", "-", UC_NONE},
   /* 203 */ {"var203", "undefined", "-", UC_NONE},
   /* 204 */ {"var204", "undefined", "-", UC_NONE},
   /* 205 */ {"var205", "undefined", "-", UC_NONE},
   /* 206 */ {"var206", "undefined", "-", UC_NONE},
   /* 207 */ {"var207", "undefined", "-", UC_NONE},
   /* 208 */ {"var208", "undefined", "-", UC_NONE},
   /* 209 */ {"var209", "undefined", "-", UC_NONE},
   /* 210 */ {"var210", "undefined", "-", UC_NONE},
   /* 211 */ {"var211", "undefined", "-", UC_NONE},
   /* 212 */ {"var212", "undefined", "-", UC_NONE},
   /* 213 */ {"var213", "undefined", "-", UC_NONE},
   /* 214 */ {"var214", "undefined", "-", UC_NONE},
   /* 215 */ {"var215", "undefined", "-", UC_NONE},
   /* 216 */ {"var216", "undefined", "-", UC_NONE},
   /* 217 */ {"var217", "undefined", "-", UC_NONE},
   /* 218 */ {"var218", "undefined", "-", UC_NONE},
   /* 219 */ {"var219", "undefined", "-", UC_NONE},
   /* 220 */ {"var220", "undefined", "-", UC_NONE},
   /* 221 */ {"var221", "undefined", "-", UC_NONE},
   /* 222 */ {"var222", "undefined", "-", UC_NONE},
   /* 223 */ {"var223", "undefined", "-", UC_NONE},
   /* 224 */ {"var224", "undefined", "-", UC_NONE},
   /* 225 */ {"var225", "undefined", "-", UC_NONE},
   /* 226 */ {"var226", "undefined", "-", UC_NONE},
   /* 227 */ {"var227", "undefined", "-", UC_NONE},
   /* 228 */ {"var228", "undefined", "-", UC_NONE},
   /* 229 */ {"var229", "undefined", "-", UC_NONE},
   /* 230 */ {"var230", "undefined", "-", UC_NONE},
   /* 231 */ {"var231", "undefined", "-", UC_NONE},
   /* 232 */ {"var232", "undefined", "-", UC_NONE},
   /* 233 */ {"var233", "undefined", "-", UC_NONE},
   /* 234 */ {"var234", "undefined", "-", UC_NONE},
   /* 235 */ {"var235", "undefined", "-", UC_NONE},
   /* 236 */ {"var236", "undefined", "-", UC_NONE},
   /* 237 */ {"var237", "undefined", "-", UC_NONE},
   /* 238 */ {"var238", "undefined", "-", UC_NONE},
   /* 239 */ {"var239", "undefined", "-", UC_NONE},
   /* 240 */ {"var240", "undefined", "-", UC_NONE},
   /* 241 */ {"var241", "undefined", "-", UC_NONE},
   /* 242 */ {"var242", "undefined", "-", UC_NONE},
   /* 243 */ {"var243", "undefined", "-", UC_NONE},
   /* 244 */ {"var244", "undefined", "-", UC_NONE},
   /* 245 */ {"var245", "undefined", "-", UC_NONE},
   /* 246 */ {"var246", "undefined", "-", UC_NONE},
   /* 247 */ {"var247", "undefined", "-", UC_NONE},
   /* 248 */ {"var248", "undefined", "-", UC_NONE},
   /* 249 */ {"var249", "undefined", "-", UC_NONE},
   /* 250 */ {"var250", "undefined", "-", UC_NONE},
   /* 251 */ {"var251", "undefined", "-", UC_NONE},
   /* 252 */ {"var252", "undefined", "-", UC_NONE},
   /* 253 */ {"var253", "undefined", "-", UC_NONE},
   /* 254 */ {"var254", "undefined", "-", UC_NONE},
   /* 255 */ {"var255", "undefined", "-", UC_NONE},
};
/* *INDENT-ON*  */
