/* dconf.c generated by valac 0.26.1, the Vala compiler
 * generated from dconf.vala, do not modify */

/*
 * Copyright © 2010, 2011 Codethink Limited
 * Copyright © 2011 Canonical Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dconf.h>
#include <gio/gio.h>
#include <locale.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

#define TYPE_COMMAND_MAPPING (command_mapping_get_type ())
typedef struct _CommandMapping CommandMapping;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef void (*Command) (gchar** args, int args_length1, void* user_data, GError** error);
struct _CommandMapping {
	Command func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	gchar* name;
};



void show_help (gboolean requested, const gchar* command);
void dconf_help (gchar** args, int args_length1, GError** error);
void dconf_read (gchar** args, int args_length1, GError** error);
void dconf_list (gchar** args, int args_length1, GError** error);
void dconf_write (gchar** args, int args_length1, GError** error);
void dconf_reset (gchar** args, int args_length1, GError** error);
void show_path (DConfClient* client, const gchar* path);
void watch_function (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag);
void dconf_watch (gchar** args, int args_length1, GError** error);
static void _watch_function_dconf_client_changed (DConfClient* _sender, const gchar* prefix, gchar** changes, const gchar* tag, gpointer self);
void dconf_blame (gchar** args, int args_length1, GError** error);
void dconf_complete (gchar** args, int args_length1, GError** error);
GType command_mapping_get_type (void) G_GNUC_CONST;
CommandMapping* command_mapping_dup (const CommandMapping* self);
void command_mapping_free (CommandMapping* self);
void command_mapping_copy (const CommandMapping* self, CommandMapping* dest);
void command_mapping_destroy (CommandMapping* self);
void command_mapping_init (CommandMapping *self, const gchar* name, Command func, void* func_target);
gint _vala_main (gchar** args, int args_length1);
static void _dconf_help_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_read_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_list_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_write_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_reset_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_compile (gchar** args, int args_length1, GError** error);
static void _dconf_compile_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_update (gchar** args, int args_length1, GError** error);
static void _dconf_update_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_watch_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_dump (gchar** args, int args_length1, GError** error);
static void _dconf_dump_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_load (gchar** args, int args_length1, GError** error);
static void _dconf_load_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_blame_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_complete_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _vala_CommandMapping_array_free (CommandMapping* array, gint array_length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void show_help (gboolean requested, const gchar* command) {
	GString* str = NULL;
	GString* _tmp0_ = NULL;
	gchar* description = NULL;
	gchar* synopsis = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	static GQuark _tmp3_label10 = 0;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp65_ = FALSE;
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	description = NULL;
	synopsis = NULL;
	_tmp1_ = command;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("help")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				_tmp5_ = g_strdup ("Print help");
				_g_free0 (description);
				description = _tmp5_;
				_tmp6_ = g_strdup (" COMMAND ");
				_g_free0 (synopsis);
				synopsis = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("read")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				_tmp7_ = g_strdup ("Read the value of a key");
				_g_free0 (description);
				description = _tmp7_;
				_tmp8_ = g_strdup (" KEY ");
				_g_free0 (synopsis);
				synopsis = _tmp8_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("list")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				_tmp9_ = g_strdup ("List the sub-keys and sub-dirs of a dir");
				_g_free0 (description);
				description = _tmp9_;
				_tmp10_ = g_strdup (" DIR ");
				_g_free0 (synopsis);
				synopsis = _tmp10_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("write")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp11_ = g_strdup ("Write a new value to a key");
				_g_free0 (description);
				description = _tmp11_;
				_tmp12_ = g_strdup (" KEY VALUE ");
				_g_free0 (synopsis);
				synopsis = _tmp12_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("reset")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				_tmp13_ = g_strdup ("Reset a key or dir.  -f is required for dirs.");
				_g_free0 (description);
				description = _tmp13_;
				_tmp14_ = g_strdup (" [-f] PATH ");
				_g_free0 (synopsis);
				synopsis = _tmp14_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("compile")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				_tmp15_ = g_strdup ("Compile a binary database from keyfiles");
				_g_free0 (description);
				description = _tmp15_;
				_tmp16_ = g_strdup (" OUTPUT KEYFILEDIR ");
				_g_free0 (synopsis);
				synopsis = _tmp16_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("update")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp17_ = g_strdup ("Update the system dconf databases");
				_g_free0 (description);
				description = _tmp17_;
				_tmp18_ = g_strdup ("");
				_g_free0 (synopsis);
				synopsis = _tmp18_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("watch")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp19_ = g_strdup ("Watch a path for key changes");
				_g_free0 (description);
				description = _tmp19_;
				_tmp20_ = g_strdup (" PATH ");
				_g_free0 (synopsis);
				synopsis = _tmp20_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("dump")))) {
		switch (0) {
			default:
			{
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp21_ = g_strdup ("Dump an entire subpath to stdout");
				_g_free0 (description);
				description = _tmp21_;
				_tmp22_ = g_strdup (" DIR ");
				_g_free0 (synopsis);
				synopsis = _tmp22_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label10) ? _tmp3_label10 : (_tmp3_label10 = g_quark_from_static_string ("load")))) {
		switch (0) {
			default:
			{
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				_tmp23_ = g_strdup ("Populate a subpath from stdin");
				_g_free0 (description);
				description = _tmp23_;
				_tmp24_ = g_strdup (" DIR ");
				_g_free0 (synopsis);
				synopsis = _tmp24_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GString* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				_tmp25_ = str;
				_tmp26_ = command;
				g_string_append_printf (_tmp25_, "Unknown command '%s'\n\n", _tmp26_);
				command = NULL;
				break;
			}
		}
	}
	_tmp27_ = command;
	if (_tmp27_ == NULL) {
		GString* _tmp28_ = NULL;
		_tmp28_ = str;
		g_string_append (_tmp28_, "Usage:\n" \
"  dconf COMMAND [ARGS...]\n" \
"\n" \
"Commands:\n" \
"  help              Show this information\n" \
"  read              Read the value of a key\n" \
"  list              List the contents of a dir\n" \
"  write             Change the value of a key\n" \
"  reset             Reset the value of a key or dir\n" \
"  compile           Compile a binary database from keyfiles\n" \
"  update            Update the system databases\n" \
"  watch             Watch a path for changes\n" \
"  dump              Dump an entire subpath to stdout\n" \
"  load              Populate a subpath from stdin\n" \
"\n" \
"Use 'dconf help COMMAND' to get detailed help.\n" \
"\n");
	} else {
		GString* _tmp29_ = NULL;
		GString* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GString* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		GString* _tmp64_ = NULL;
		_tmp29_ = str;
		g_string_append (_tmp29_, "Usage:\n");
		_tmp30_ = str;
		_tmp31_ = command;
		_tmp32_ = synopsis;
		g_string_append_printf (_tmp30_, "  dconf %s%s\n\n", _tmp31_, _tmp32_);
		_tmp33_ = str;
		_tmp34_ = description;
		g_string_append_printf (_tmp33_, "%s\n\n", _tmp34_);
		_tmp35_ = synopsis;
		if (g_strcmp0 (_tmp35_, "") != 0) {
			GString* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp43_ = FALSE;
			const gchar* _tmp44_ = NULL;
			gboolean _tmp45_ = FALSE;
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_ = NULL;
			gboolean _tmp51_ = FALSE;
			const gchar* _tmp55_ = NULL;
			gboolean _tmp56_ = FALSE;
			const gchar* _tmp58_ = NULL;
			gboolean _tmp59_ = FALSE;
			const gchar* _tmp61_ = NULL;
			gboolean _tmp62_ = FALSE;
			_tmp36_ = str;
			g_string_append (_tmp36_, "Arguments:\n");
			_tmp37_ = synopsis;
			_tmp38_ = string_contains (_tmp37_, " COMMAND ");
			if (_tmp38_) {
				GString* _tmp39_ = NULL;
				_tmp39_ = str;
				g_string_append (_tmp39_, "  COMMAND     The (optional) command to explain\n");
			}
			_tmp40_ = synopsis;
			_tmp41_ = string_contains (_tmp40_, " PATH ");
			if (_tmp41_) {
				GString* _tmp42_ = NULL;
				_tmp42_ = str;
				g_string_append (_tmp42_, "  PATH        Either a KEY or DIR\n");
			}
			_tmp44_ = synopsis;
			_tmp45_ = string_contains (_tmp44_, " PATH ");
			if (_tmp45_) {
				_tmp43_ = TRUE;
			} else {
				const gchar* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				_tmp46_ = synopsis;
				_tmp47_ = string_contains (_tmp46_, " KEY ");
				_tmp43_ = _tmp47_;
			}
			if (_tmp43_) {
				GString* _tmp48_ = NULL;
				_tmp48_ = str;
				g_string_append (_tmp48_, "  KEY         A key path (starting, but not ending with '/')\n");
			}
			_tmp50_ = synopsis;
			_tmp51_ = string_contains (_tmp50_, " PATH ");
			if (_tmp51_) {
				_tmp49_ = TRUE;
			} else {
				const gchar* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
				_tmp52_ = synopsis;
				_tmp53_ = string_contains (_tmp52_, " DIR ");
				_tmp49_ = _tmp53_;
			}
			if (_tmp49_) {
				GString* _tmp54_ = NULL;
				_tmp54_ = str;
				g_string_append (_tmp54_, "  DIR         A directory path (starting and ending with '/')\n");
			}
			_tmp55_ = synopsis;
			_tmp56_ = string_contains (_tmp55_, " VALUE ");
			if (_tmp56_) {
				GString* _tmp57_ = NULL;
				_tmp57_ = str;
				g_string_append (_tmp57_, "  VALUE       The value to write (in GVariant format)\n");
			}
			_tmp58_ = synopsis;
			_tmp59_ = string_contains (_tmp58_, " OUTPUT ");
			if (_tmp59_) {
				GString* _tmp60_ = NULL;
				_tmp60_ = str;
				g_string_append (_tmp60_, "  OUTPUT      The filename of the (binary) output\n");
			}
			_tmp61_ = synopsis;
			_tmp62_ = string_contains (_tmp61_, " KEYFILEDIR ");
			if (_tmp62_) {
				GString* _tmp63_ = NULL;
				_tmp63_ = str;
				g_string_append (_tmp63_, "  KEYFILEDIR  The path to the .d directory containing keyfiles\n");
			}
		}
		_tmp64_ = str;
		g_string_append (_tmp64_, "\n");
	}
	_tmp65_ = requested;
	if (_tmp65_) {
		GString* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		_tmp66_ = str;
		_tmp67_ = _tmp66_->str;
		g_print ("%s", _tmp67_);
	} else {
		GString* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		_tmp68_ = str;
		_tmp69_ = _tmp68_->str;
		g_printerr ("%s", _tmp69_);
	}
	_g_free0 (synopsis);
	_g_free0 (description);
	_g_string_free0 (str);
}


void dconf_help (gchar** args, int args_length1, GError** error) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = _tmp0_[2];
	show_help (TRUE, _tmp1_);
}


void dconf_read (gchar** args, int args_length1, GError** error) {
	DConfClient* client = NULL;
	DConfClient* _tmp0_ = NULL;
	gchar* key = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GVariant* _result_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	key = _tmp3_;
	dconf_is_key (key, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp4_ = dconf_client_read (client, key);
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	if (_tmp5_ != NULL) {
		GVariant* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = _result_;
		_tmp7_ = g_variant_print (_tmp6_, TRUE);
		_tmp8_ = _tmp7_;
		g_print ("%s\n", _tmp8_);
		_g_free0 (_tmp8_);
	}
	_g_variant_unref0 (_result_);
	_g_free0 (key);
	_g_object_unref0 (client);
}


void dconf_list (gchar** args, int args_length1, GError** error) {
	DConfClient* client = NULL;
	DConfClient* _tmp0_ = NULL;
	gchar* dir = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	dir = _tmp3_;
	dconf_is_dir (dir, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		_g_object_unref0 (client);
		return;
	}
	_tmp5_ = dconf_client_list (client, dir, &_tmp4_);
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp5_;
		item_collection_length1 = _tmp4_;
		for (item_it = 0; item_it < _tmp4_; item_it = item_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* item = NULL;
			_tmp6_ = g_strdup (item_collection[item_it]);
			item = _tmp6_;
			{
				const gchar* _tmp7_ = NULL;
				_tmp7_ = item;
				g_print ("%s\n", _tmp7_);
				_g_free0 (item);
			}
		}
		item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (dir);
	_g_object_unref0 (client);
}


void dconf_write (gchar** args, int args_length1, GError** error) {
	DConfClient* client = NULL;
	DConfClient* _tmp0_ = NULL;
	gchar* key = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* val = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	DConfClient* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	key = _tmp3_;
	_tmp4_ = args;
	_tmp4__length1 = args_length1;
	_tmp5_ = _tmp4_[3];
	_tmp6_ = g_strdup (_tmp5_);
	val = _tmp6_;
	_tmp7_ = key;
	dconf_is_key (_tmp7_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp9_ = val;
	_tmp10_ = g_variant_parse (NULL, _tmp9_, NULL, NULL, &_inner_error_);
	_tmp8_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp11_ = client;
	_tmp12_ = key;
	dconf_client_write_sync (_tmp11_, _tmp12_, _tmp8_, NULL, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_variant_unref0 (_tmp8_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_g_variant_unref0 (_tmp8_);
	_g_free0 (val);
	_g_free0 (key);
	_g_object_unref0 (client);
}


void dconf_reset (gchar** args, int args_length1, GError** error) {
	DConfClient* client = NULL;
	DConfClient* _tmp0_ = NULL;
	gboolean force = FALSE;
	gint index = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* path = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	DConfClient* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	force = FALSE;
	index = 2;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = index;
	_tmp3_ = _tmp1_[_tmp2_];
	if (g_strcmp0 (_tmp3_, "-f") == 0) {
		gint _tmp4_ = 0;
		force = TRUE;
		_tmp4_ = index;
		index = _tmp4_ + 1;
	}
	_tmp5_ = args;
	_tmp5__length1 = args_length1;
	_tmp6_ = index;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp8_ = g_strdup (_tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	dconf_is_path (_tmp9_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_tmp11_ = path;
	_tmp12_ = dconf_is_dir (_tmp11_, NULL);
	if (_tmp12_) {
		gboolean _tmp13_ = FALSE;
		_tmp13_ = force;
		_tmp10_ = !_tmp13_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GError* _tmp14_ = NULL;
		_tmp14_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "-f must be given to (recursively) reset entire dirs");
		_inner_error_ = _tmp14_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_tmp15_ = client;
	_tmp16_ = path;
	dconf_client_write_sync (_tmp15_, _tmp16_, NULL, NULL, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (path);
	_g_object_unref0 (client);
}


void show_path (DConfClient* client, const gchar* path) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (client != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = dconf_is_key (_tmp0_, NULL);
	if (_tmp1_) {
		GVariant* value = NULL;
		DConfClient* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GVariant* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GVariant* _tmp6_ = NULL;
		_tmp2_ = client;
		_tmp3_ = path;
		_tmp4_ = dconf_client_read (_tmp2_, _tmp3_);
		value = _tmp4_;
		_tmp6_ = value;
		if (_tmp6_ != NULL) {
			GVariant* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp7_ = value;
			_tmp8_ = g_variant_print (_tmp7_, TRUE);
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp8_;
		} else {
			gchar* _tmp9_ = NULL;
			_tmp9_ = g_strdup ("unset");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp9_;
		}
		g_print ("  %s\n", _tmp5_);
		_g_free0 (_tmp5_);
		_g_variant_unref0 (value);
	}
}


void watch_function (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (client != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = items;
	_tmp0__length1 = items_length1;
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* item = NULL;
			_tmp1_ = g_strdup (item_collection[item_it]);
			item = _tmp1_;
			{
				gchar* full = NULL;
				const gchar* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				DConfClient* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				_tmp2_ = path;
				_tmp3_ = item;
				_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
				full = _tmp4_;
				_tmp5_ = full;
				g_print ("%s\n", _tmp5_);
				_tmp6_ = client;
				_tmp7_ = full;
				show_path (_tmp6_, _tmp7_);
				_g_free0 (full);
				_g_free0 (item);
			}
		}
	}
	g_print ("\n");
}


static void _watch_function_dconf_client_changed (DConfClient* _sender, const gchar* prefix, gchar** changes, const gchar* tag, gpointer self) {
	watch_function (_sender, prefix, changes, _vala_array_length (changes), tag);
}


void dconf_watch (gchar** args, int args_length1, GError** error) {
	DConfClient* client = NULL;
	DConfClient* _tmp0_ = NULL;
	gchar* path = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GMainLoop* _tmp4_ = NULL;
	GMainLoop* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	dconf_is_path (path, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	g_signal_connect (client, "changed", (GCallback) _watch_function_dconf_client_changed, NULL);
	dconf_client_watch_sync (client, path);
	_tmp4_ = g_main_loop_new (NULL, FALSE);
	_tmp5_ = _tmp4_;
	g_main_loop_run (_tmp5_);
	_g_main_loop_unref0 (_tmp5_);
	_g_free0 (path);
	_g_object_unref0 (client);
}


void dconf_blame (gchar** args, int args_length1, GError** error) {
	GDBusConnection* connection = NULL;
	GDBusConnection* _tmp0_ = NULL;
	GVariant* reply = NULL;
	GDBusConnection* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	GVariantType* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	connection = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = connection;
	_tmp2_ = g_variant_type_new ("(s)");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_dbus_connection_call_sync (_tmp1_, "ca.desrt.dconf", "/ca/desrt/dconf", "ca.desrt.dconf.ServiceInfo", "Blame", NULL, _tmp3_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_variant_type_free0 (_tmp3_);
	reply = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp6_ = reply;
	_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_get_string (_tmp8_, NULL);
	g_print ("%s", _tmp9_);
	_g_variant_unref0 (_tmp8_);
	_g_variant_unref0 (reply);
	_g_object_unref0 (connection);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


void dconf_complete (gchar** args, int args_length1, GError** error) {
	gchar* suffix = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar _tmp8_ = '\0';
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = _tmp0_[2];
	_tmp2_ = g_strdup (_tmp1_);
	suffix = _tmp2_;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = _tmp3_[3];
	_tmp5_ = g_strdup (_tmp4_);
	path = _tmp5_;
	_tmp6_ = path;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		g_print ("/\n");
		_g_free0 (path);
		_g_free0 (suffix);
		return;
	}
	_tmp7_ = path;
	_tmp8_ = string_get (_tmp7_, (glong) 0);
	if (_tmp8_ == '/') {
		DConfClient* client = NULL;
		DConfClient* _tmp9_ = NULL;
		gint last = 0;
		gchar* dir = NULL;
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gchar* _tmp21_ = NULL;
		DConfClient* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gchar** _tmp25_ = NULL;
		_tmp9_ = dconf_client_new ();
		client = _tmp9_;
		last = 0;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar _tmp14_ = '\0';
					const gchar* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					gchar _tmp17_ = '\0';
					if (!_tmp10_) {
						gint _tmp11_ = 0;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = path;
					_tmp13_ = i;
					_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
					if (!(_tmp14_ != '\0')) {
						break;
					}
					_tmp15_ = path;
					_tmp16_ = i;
					_tmp17_ = string_get (_tmp15_, (glong) _tmp16_);
					if (_tmp17_ == '/') {
						gint _tmp18_ = 0;
						_tmp18_ = i;
						last = _tmp18_;
					}
				}
			}
		}
		_tmp19_ = path;
		_tmp20_ = last;
		_tmp21_ = string_substring (_tmp19_, (glong) 0, (glong) (_tmp20_ + 1));
		dir = _tmp21_;
		_tmp22_ = client;
		_tmp23_ = dir;
		_tmp25_ = dconf_client_list (_tmp22_, _tmp23_, &_tmp24_);
		{
			gchar** item_collection = NULL;
			gint item_collection_length1 = 0;
			gint _item_collection_size_ = 0;
			gint item_it = 0;
			item_collection = _tmp25_;
			item_collection_length1 = _tmp24_;
			for (item_it = 0; item_it < _tmp24_; item_it = item_it + 1) {
				gchar* _tmp26_ = NULL;
				gchar* item = NULL;
				_tmp26_ = g_strdup (item_collection[item_it]);
				item = _tmp26_;
				{
					gchar* full_item = NULL;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
					_tmp27_ = dir;
					_tmp28_ = item;
					_tmp29_ = g_strconcat (_tmp27_, _tmp28_, NULL);
					full_item = _tmp29_;
					_tmp31_ = full_item;
					_tmp32_ = path;
					_tmp33_ = g_str_has_prefix (_tmp31_, _tmp32_);
					if (_tmp33_) {
						const gchar* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						_tmp34_ = item;
						_tmp35_ = suffix;
						_tmp36_ = g_str_has_suffix (_tmp34_, _tmp35_);
						_tmp30_ = _tmp36_;
					} else {
						_tmp30_ = FALSE;
					}
					if (_tmp30_) {
						const gchar* _tmp37_ = NULL;
						const gchar* _tmp38_ = NULL;
						gboolean _tmp39_ = FALSE;
						const gchar* _tmp40_ = NULL;
						_tmp38_ = full_item;
						_tmp39_ = g_str_has_suffix (_tmp38_, "/");
						if (_tmp39_) {
							_tmp37_ = "";
						} else {
							_tmp37_ = " ";
						}
						_tmp40_ = full_item;
						g_print ("%s%s\n", _tmp40_, _tmp37_);
					}
					_g_free0 (full_item);
					_g_free0 (item);
				}
			}
			item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (dir);
		_g_object_unref0 (client);
	}
	_g_free0 (path);
	_g_free0 (suffix);
}


void command_mapping_init (CommandMapping *self, const gchar* name, Command func, void* func_target) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Command _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_if_fail (name != NULL);
	memset (self, 0, sizeof (CommandMapping));
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).name);
	(*self).name = _tmp1_;
	_tmp2_ = func;
	_tmp2__target = func_target;
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	(*self).func = _tmp2_;
	(*self).func_target = _tmp2__target;
	(*self).func_target_destroy_notify = NULL;
}


void command_mapping_copy (const CommandMapping* self, CommandMapping* dest) {
	Command _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = (*self).func;
	_tmp0__target = (*self).func_target;
	((*dest).func_target_destroy_notify == NULL) ? NULL : ((*dest).func_target_destroy_notify ((*dest).func_target), NULL);
	(*dest).func = NULL;
	(*dest).func_target = NULL;
	(*dest).func_target_destroy_notify = NULL;
	(*dest).func = _tmp0_;
	(*dest).func_target = _tmp0__target;
	(*dest).func_target_destroy_notify = NULL;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
}


void command_mapping_destroy (CommandMapping* self) {
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	_g_free0 ((*self).name);
}


CommandMapping* command_mapping_dup (const CommandMapping* self) {
	CommandMapping* dup;
	dup = g_new0 (CommandMapping, 1);
	command_mapping_copy (self, dup);
	return dup;
}


void command_mapping_free (CommandMapping* self) {
	command_mapping_destroy (self);
	g_free (self);
}


GType command_mapping_get_type (void) {
	static volatile gsize command_mapping_type_id__volatile = 0;
	if (g_once_init_enter (&command_mapping_type_id__volatile)) {
		GType command_mapping_type_id;
		command_mapping_type_id = g_boxed_type_register_static ("CommandMapping", (GBoxedCopyFunc) command_mapping_dup, (GBoxedFreeFunc) command_mapping_free);
		g_once_init_leave (&command_mapping_type_id__volatile, command_mapping_type_id);
	}
	return command_mapping_type_id__volatile;
}


static void _dconf_help_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_help (args, args_length1, error);
}


static void _dconf_read_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_read (args, args_length1, error);
}


static void _dconf_list_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_list (args, args_length1, error);
}


static void _dconf_write_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_write (args, args_length1, error);
}


static void _dconf_reset_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_reset (args, args_length1, error);
}


static void _dconf_compile_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_compile (args, args_length1, error);
}


static void _dconf_update_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_update (args, args_length1, error);
}


static void _dconf_watch_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_watch (args, args_length1, error);
}


static void _dconf_dump_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_dump (args, args_length1, error);
}


static void _dconf_load_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_load (args, args_length1, error);
}


static void _dconf_blame_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_blame (args, args_length1, error);
}


static void _dconf_complete_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_complete (args, args_length1, error);
}


static void _vala_CommandMapping_array_free (CommandMapping* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			command_mapping_destroy (&array[i]);
		}
	}
	g_free (array);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	CommandMapping* map = NULL;
	CommandMapping _tmp3_ = {0};
	CommandMapping _tmp4_ = {0};
	CommandMapping _tmp5_ = {0};
	CommandMapping _tmp6_ = {0};
	CommandMapping _tmp7_ = {0};
	CommandMapping _tmp8_ = {0};
	CommandMapping _tmp9_ = {0};
	CommandMapping _tmp10_ = {0};
	CommandMapping _tmp11_ = {0};
	CommandMapping _tmp12_ = {0};
	CommandMapping _tmp13_ = {0};
	CommandMapping _tmp14_ = {0};
	CommandMapping* _tmp15_ = NULL;
	gint map_length1 = 0;
	gint _map_size_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_vala_assert (_tmp0__length1 != 0, "args.length != 0");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	g_set_prgname (_tmp2_);
	setlocale (LC_ALL, "");
	command_mapping_init (&_tmp3_, "help", _dconf_help_command, NULL);
	command_mapping_init (&_tmp4_, "read", _dconf_read_command, NULL);
	command_mapping_init (&_tmp5_, "list", _dconf_list_command, NULL);
	command_mapping_init (&_tmp6_, "write", _dconf_write_command, NULL);
	command_mapping_init (&_tmp7_, "reset", _dconf_reset_command, NULL);
	command_mapping_init (&_tmp8_, "compile", _dconf_compile_command, NULL);
	command_mapping_init (&_tmp9_, "update", _dconf_update_command, NULL);
	command_mapping_init (&_tmp10_, "watch", _dconf_watch_command, NULL);
	command_mapping_init (&_tmp11_, "dump", _dconf_dump_command, NULL);
	command_mapping_init (&_tmp12_, "load", _dconf_load_command, NULL);
	command_mapping_init (&_tmp13_, "blame", _dconf_blame_command, NULL);
	command_mapping_init (&_tmp14_, "_complete", _dconf_complete_command, NULL);
	_tmp15_ = g_new0 (CommandMapping, 12);
	_tmp15_[0] = _tmp3_;
	_tmp15_[1] = _tmp4_;
	_tmp15_[2] = _tmp5_;
	_tmp15_[3] = _tmp6_;
	_tmp15_[4] = _tmp7_;
	_tmp15_[5] = _tmp8_;
	_tmp15_[6] = _tmp9_;
	_tmp15_[7] = _tmp10_;
	_tmp15_[8] = _tmp11_;
	_tmp15_[9] = _tmp12_;
	_tmp15_[10] = _tmp13_;
	_tmp15_[11] = _tmp14_;
	map = _tmp15_;
	map_length1 = 12;
	_map_size_ = map_length1;
	{
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		const gchar* _tmp17_ = NULL;
		CommandMapping* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
		_tmp16_ = args;
		_tmp16__length1 = args_length1;
		_tmp17_ = _tmp16_[1];
		if (_tmp17_ == NULL) {
			GError* _tmp18_ = NULL;
			_tmp18_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "no command specified");
			_inner_error_ = _tmp18_;
			goto __catch8_g_error;
		}
		_tmp19_ = map;
		_tmp19__length1 = map_length1;
		{
			CommandMapping* mapping_collection = NULL;
			gint mapping_collection_length1 = 0;
			gint _mapping_collection_size_ = 0;
			gint mapping_it = 0;
			mapping_collection = _tmp19_;
			mapping_collection_length1 = _tmp19__length1;
			for (mapping_it = 0; mapping_it < _tmp19__length1; mapping_it = mapping_it + 1) {
				CommandMapping _tmp20_ = {0};
				CommandMapping mapping = {0};
				command_mapping_copy (&mapping_collection[mapping_it], &_tmp20_);
				mapping = _tmp20_;
				{
					CommandMapping _tmp21_ = {0};
					const gchar* _tmp22_ = NULL;
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					const gchar* _tmp24_ = NULL;
					_tmp21_ = mapping;
					_tmp22_ = _tmp21_.name;
					_tmp23_ = args;
					_tmp23__length1 = args_length1;
					_tmp24_ = _tmp23_[1];
					if (g_strcmp0 (_tmp22_, _tmp24_) == 0) {
						CommandMapping _tmp25_ = {0};
						Command _tmp26_ = NULL;
						void* _tmp26__target = NULL;
						gchar** _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						_tmp25_ = mapping;
						_tmp26_ = _tmp25_.func;
						_tmp26__target = _tmp25_.func_target;
						_tmp27_ = args;
						_tmp27__length1 = args_length1;
						_tmp26_ (_tmp27_, _tmp27__length1, _tmp26__target, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							command_mapping_destroy (&mapping);
							goto __catch8_g_error;
						}
						result = 0;
						command_mapping_destroy (&mapping);
						map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
						return result;
					}
					command_mapping_destroy (&mapping);
				}
			}
		}
		_tmp28_ = args;
		_tmp28__length1 = args_length1;
		_tmp29_ = _tmp28_[1];
		_tmp30_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "unknown command %s", _tmp29_);
		_inner_error_ = _tmp30_;
		goto __catch8_g_error;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		FILE* _tmp31_ = NULL;
		GError* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		const gchar* _tmp35_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = stderr;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		fprintf (_tmp31_, "error: %s\n\n", _tmp33_);
		_tmp34_ = args;
		_tmp34__length1 = args_length1;
		_tmp35_ = _tmp34_[1];
		show_help (FALSE, _tmp35_);
		result = 1;
		_g_error_free0 (e);
		map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
		return result;
	}
	__finally8:
	map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



