/*
   This file gets auto-generated by the script tzmap-from-unicode.org via
   a Makefile rule.  To regenerate the file, just call 'make tzmap'.  It
   fetches the file

     https://raw.githubusercontent.com/unicode-org/cldr/master/common/supplemental/windowsZones.xml

   using wget and converts it into the tzmap table required by tzget.c.
   Regenerating might be necessary on a regular basis...

   This table maps Windows timezone keynames and countries per ISO 3166-1 to
   POSIX-compatible timezone IDs.

   The mapping from unicode.org is just a bit incomplete.  It doesn't contain
   a few timezones available on Windows 8.1:

    E. Europe Standard Time
    Mid-Atlantic Standard Time
    Kamchatka Standard Time

  as well as a few combinations which got a new Windows timezone name

    Eastern Standard Time/TC
    Egypt Standard Time/PS
    Greenwich Standard Time/EH
    Hawaiian Standard Time/TK
    Kaliningrad Standard Time/BY
    SA Pacific Standard Time/HT 
    South Africa Standard Time/LY

  It also doesn't contain deprecated country codes used in older
  OSes, namely:

    CS (Serbian and Montenegro, dissolved, now RS and ME) used in Vista
 
  While these are apparently old, they are required here to get a complete
  mapping on all supported OSes. */
struct
{
  PCWSTR win_tzkey;
  PCWSTR country;
  PCWSTR posix_tzid;
} const tzmap[] =
{
  { L"AUS Central Standard Time", L"", L"Australia/Darwin" },
  { L"AUS Central Standard Time", L"AU", L"Australia/Darwin" },
  { L"AUS Eastern Standard Time", L"", L"Australia/Sydney" },
  { L"AUS Eastern Standard Time", L"AU", L"Australia/Sydney Australia/Melbourne" },
  { L"Afghanistan Standard Time", L"", L"Asia/Kabul" },
  { L"Afghanistan Standard Time", L"AF", L"Asia/Kabul" },
  { L"Alaskan Standard Time", L"", L"America/Anchorage" },
  { L"Alaskan Standard Time", L"US", L"America/Anchorage America/Juneau America/Metlakatla America/Nome America/Sitka America/Yakutat" },
  { L"Aleutian Standard Time", L"", L"America/Adak" },
  { L"Aleutian Standard Time", L"US", L"America/Adak" },
  { L"Altai Standard Time", L"", L"Asia/Barnaul" },
  { L"Altai Standard Time", L"RU", L"Asia/Barnaul" },
  { L"Arab Standard Time", L"", L"Asia/Riyadh" },
  { L"Arab Standard Time", L"BH", L"Asia/Bahrain" },
  { L"Arab Standard Time", L"KW", L"Asia/Kuwait" },
  { L"Arab Standard Time", L"QA", L"Asia/Qatar" },
  { L"Arab Standard Time", L"SA", L"Asia/Riyadh" },
  { L"Arab Standard Time", L"YE", L"Asia/Aden" },
  { L"Arabian Standard Time", L"", L"Asia/Dubai" },
  { L"Arabian Standard Time", L"AE", L"Asia/Dubai" },
  { L"Arabian Standard Time", L"OM", L"Asia/Muscat" },
  { L"Arabian Standard Time", L"ZZ", L"Etc/GMT-4" },
  { L"Arabic Standard Time", L"", L"Asia/Baghdad" },
  { L"Arabic Standard Time", L"IQ", L"Asia/Baghdad" },
  { L"Argentina Standard Time", L"", L"America/Buenos_Aires" },
  { L"Argentina Standard Time", L"AR", L"America/Buenos_Aires America/Argentina/La_Rioja America/Argentina/Rio_Gallegos America/Argentina/Salta America/Argentina/San_Juan America/Argentina/San_Luis America/Argentina/Tucuman America/Argentina/Ushuaia America/Catamarca America/Cordoba America/Jujuy America/Mendoza" },
  { L"Astrakhan Standard Time", L"", L"Europe/Astrakhan" },
  { L"Astrakhan Standard Time", L"RU", L"Europe/Astrakhan Europe/Ulyanovsk" },
  { L"Atlantic Standard Time", L"", L"America/Halifax" },
  { L"Atlantic Standard Time", L"BM", L"Atlantic/Bermuda" },
  { L"Atlantic Standard Time", L"CA", L"America/Halifax America/Glace_Bay America/Goose_Bay America/Moncton" },
  { L"Atlantic Standard Time", L"GL", L"America/Thule" },
  { L"Aus Central W. Standard Time", L"", L"Australia/Eucla" },
  { L"Aus Central W. Standard Time", L"AU", L"Australia/Eucla" },
  { L"Azerbaijan Standard Time", L"", L"Asia/Baku" },
  { L"Azerbaijan Standard Time", L"AZ", L"Asia/Baku" },
  { L"Azores Standard Time", L"", L"Atlantic/Azores" },
  { L"Azores Standard Time", L"GL", L"America/Scoresbysund" },
  { L"Azores Standard Time", L"PT", L"Atlantic/Azores" },
  { L"Bahia Standard Time", L"", L"America/Bahia" },
  { L"Bahia Standard Time", L"BR", L"America/Bahia" },
  { L"Bangladesh Standard Time", L"", L"Asia/Dhaka" },
  { L"Bangladesh Standard Time", L"BD", L"Asia/Dhaka" },
  { L"Bangladesh Standard Time", L"BT", L"Asia/Thimphu" },
  { L"Belarus Standard Time", L"", L"Europe/Minsk" },
  { L"Belarus Standard Time", L"BY", L"Europe/Minsk" },
  { L"Bougainville Standard Time", L"", L"Pacific/Bougainville" },
  { L"Bougainville Standard Time", L"PG", L"Pacific/Bougainville" },
  { L"Canada Central Standard Time", L"", L"America/Regina" },
  { L"Canada Central Standard Time", L"CA", L"America/Regina America/Swift_Current" },
  { L"Cape Verde Standard Time", L"", L"Atlantic/Cape_Verde" },
  { L"Cape Verde Standard Time", L"CV", L"Atlantic/Cape_Verde" },
  { L"Cape Verde Standard Time", L"ZZ", L"Etc/GMT+1" },
  { L"Caucasus Standard Time", L"", L"Asia/Yerevan" },
  { L"Caucasus Standard Time", L"AM", L"Asia/Yerevan" },
  { L"Cen. Australia Standard Time", L"", L"Australia/Adelaide" },
  { L"Cen. Australia Standard Time", L"AU", L"Australia/Adelaide Australia/Broken_Hill" },
  { L"Central America Standard Time", L"", L"America/Guatemala" },
  { L"Central America Standard Time", L"BZ", L"America/Belize" },
  { L"Central America Standard Time", L"CR", L"America/Costa_Rica" },
  { L"Central America Standard Time", L"EC", L"Pacific/Galapagos" },
  { L"Central America Standard Time", L"GT", L"America/Guatemala" },
  { L"Central America Standard Time", L"HN", L"America/Tegucigalpa" },
  { L"Central America Standard Time", L"NI", L"America/Managua" },
  { L"Central America Standard Time", L"SV", L"America/El_Salvador" },
  { L"Central America Standard Time", L"ZZ", L"Etc/GMT+6" },
  { L"Central Asia Standard Time", L"", L"Asia/Almaty" },
  { L"Central Asia Standard Time", L"AQ", L"Antarctica/Vostok" },
  { L"Central Asia Standard Time", L"CN", L"Asia/Urumqi" },
  { L"Central Asia Standard Time", L"IO", L"Indian/Chagos" },
  { L"Central Asia Standard Time", L"KG", L"Asia/Bishkek" },
  { L"Central Asia Standard Time", L"KZ", L"Asia/Almaty Asia/Qostanay" },
  { L"Central Asia Standard Time", L"ZZ", L"Etc/GMT-6" },
  { L"Central Brazilian Standard Time", L"", L"America/Cuiaba" },
  { L"Central Brazilian Standard Time", L"BR", L"America/Cuiaba America/Campo_Grande" },
  { L"Central Europe Standard Time", L"", L"Europe/Budapest" },
  { L"Central Europe Standard Time", L"AL", L"Europe/Tirane" },
  { L"Central Europe Standard Time", L"CS", L"Europe/Belgrade" },
  { L"Central Europe Standard Time", L"CZ", L"Europe/Prague" },
  { L"Central Europe Standard Time", L"HU", L"Europe/Budapest" },
  { L"Central Europe Standard Time", L"ME", L"Europe/Podgorica" },
  { L"Central Europe Standard Time", L"RS", L"Europe/Belgrade" },
  { L"Central Europe Standard Time", L"SI", L"Europe/Ljubljana" },
  { L"Central Europe Standard Time", L"SK", L"Europe/Bratislava" },
  { L"Central European Standard Time", L"", L"Europe/Warsaw" },
  { L"Central European Standard Time", L"BA", L"Europe/Sarajevo" },
  { L"Central European Standard Time", L"HR", L"Europe/Zagreb" },
  { L"Central European Standard Time", L"MK", L"Europe/Skopje" },
  { L"Central European Standard Time", L"PL", L"Europe/Warsaw" },
  { L"Central Pacific Standard Time", L"", L"Pacific/Guadalcanal" },
  { L"Central Pacific Standard Time", L"AU", L"Antarctica/Macquarie" },
  { L"Central Pacific Standard Time", L"FM", L"Pacific/Ponape Pacific/Kosrae" },
  { L"Central Pacific Standard Time", L"NC", L"Pacific/Noumea" },
  { L"Central Pacific Standard Time", L"SB", L"Pacific/Guadalcanal" },
  { L"Central Pacific Standard Time", L"VU", L"Pacific/Efate" },
  { L"Central Pacific Standard Time", L"ZZ", L"Etc/GMT-11" },
  { L"Central Standard Time", L"", L"America/Chicago" },
  { L"Central Standard Time", L"CA", L"America/Winnipeg America/Rainy_River America/Rankin_Inlet America/Resolute" },
  { L"Central Standard Time", L"MX", L"America/Matamoros" },
  { L"Central Standard Time", L"US", L"America/Chicago America/Indiana/Knox America/Indiana/Tell_City America/Menominee America/North_Dakota/Beulah America/North_Dakota/Center America/North_Dakota/New_Salem" },
  { L"Central Standard Time", L"ZZ", L"CST6CDT" },
  { L"Central Standard Time (Mexico)", L"", L"America/Mexico_City" },
  { L"Central Standard Time (Mexico)", L"MX", L"America/Mexico_City America/Bahia_Banderas America/Merida America/Monterrey" },
  { L"Chatham Islands Standard Time", L"", L"Pacific/Chatham" },
  { L"Chatham Islands Standard Time", L"NZ", L"Pacific/Chatham" },
  { L"China Standard Time", L"", L"Asia/Shanghai" },
  { L"China Standard Time", L"CN", L"Asia/Shanghai" },
  { L"China Standard Time", L"HK", L"Asia/Hong_Kong" },
  { L"China Standard Time", L"MO", L"Asia/Macau" },
  { L"Cuba Standard Time", L"", L"America/Havana" },
  { L"Cuba Standard Time", L"CU", L"America/Havana" },
  { L"Dateline Standard Time", L"", L"Etc/GMT+12" },
  { L"Dateline Standard Time", L"ZZ", L"Etc/GMT+12" },
  { L"E. Africa Standard Time", L"", L"Africa/Nairobi" },
  { L"E. Africa Standard Time", L"AQ", L"Antarctica/Syowa" },
  { L"E. Africa Standard Time", L"DJ", L"Africa/Djibouti" },
  { L"E. Africa Standard Time", L"ER", L"Africa/Asmera" },
  { L"E. Africa Standard Time", L"ET", L"Africa/Addis_Ababa" },
  { L"E. Africa Standard Time", L"KE", L"Africa/Nairobi" },
  { L"E. Africa Standard Time", L"KM", L"Indian/Comoro" },
  { L"E. Africa Standard Time", L"MG", L"Indian/Antananarivo" },
  { L"E. Africa Standard Time", L"SO", L"Africa/Mogadishu" },
  { L"E. Africa Standard Time", L"SS", L"Africa/Juba" },
  { L"E. Africa Standard Time", L"TZ", L"Africa/Dar_es_Salaam" },
  { L"E. Africa Standard Time", L"UG", L"Africa/Kampala" },
  { L"E. Africa Standard Time", L"YT", L"Indian/Mayotte" },
  { L"E. Africa Standard Time", L"ZZ", L"Etc/GMT-3" },
  { L"E. Australia Standard Time", L"", L"Australia/Brisbane" },
  { L"E. Australia Standard Time", L"AU", L"Australia/Brisbane Australia/Lindeman" },
  { L"E. Europe Standard Time", L"", L"Asia/Nicosia" },
  { L"E. Europe Standard Time", L"", L"Europe/Chisinau" },
  { L"E. Europe Standard Time", L"CY", L"Asia/Nicosia" },
  { L"E. Europe Standard Time", L"MD", L"Europe/Chisinau" },
  { L"E. South America Standard Time", L"", L"America/Sao_Paulo" },
  { L"E. South America Standard Time", L"BR", L"America/Sao_Paulo" },
  { L"Easter Island Standard Time", L"", L"Pacific/Easter" },
  { L"Easter Island Standard Time", L"CL", L"Pacific/Easter" },
  { L"Eastern Standard Time", L"", L"America/New_York" },
  { L"Eastern Standard Time", L"BS", L"America/Nassau" },
  { L"Eastern Standard Time", L"CA", L"America/Toronto America/Iqaluit America/Montreal America/Nipigon America/Pangnirtung America/Thunder_Bay" },
  { L"Eastern Standard Time", L"TC", L"America/Grand_Turk" },
  { L"Eastern Standard Time", L"US", L"America/New_York America/Detroit America/Indiana/Petersburg America/Indiana/Vincennes America/Indiana/Winamac America/Kentucky/Monticello America/Louisville" },
  { L"Eastern Standard Time", L"ZZ", L"EST5EDT" },
  { L"Eastern Standard Time (Mexico)", L"", L"America/Cancun" },
  { L"Eastern Standard Time (Mexico)", L"MX", L"America/Cancun" },
  { L"Egypt Standard Time", L"", L"Africa/Cairo" },
  { L"Egypt Standard Time", L"EG", L"Africa/Cairo" },
  { L"Egypt Standard Time", L"PS", L"Asia/Gaza Asia/Hebron" },
  { L"Ekaterinburg Standard Time", L"", L"Asia/Yekaterinburg" },
  { L"Ekaterinburg Standard Time", L"RU", L"Asia/Yekaterinburg" },
  { L"FLE Standard Time", L"", L"Europe/Kiev" },
  { L"FLE Standard Time", L"AX", L"Europe/Mariehamn" },
  { L"FLE Standard Time", L"BG", L"Europe/Sofia" },
  { L"FLE Standard Time", L"EE", L"Europe/Tallinn" },
  { L"FLE Standard Time", L"FI", L"Europe/Helsinki" },
  { L"FLE Standard Time", L"LT", L"Europe/Vilnius" },
  { L"FLE Standard Time", L"LV", L"Europe/Riga" },
  { L"FLE Standard Time", L"UA", L"Europe/Kiev Europe/Uzhgorod Europe/Zaporozhye" },
  { L"Fiji Standard Time", L"", L"Pacific/Fiji" },
  { L"Fiji Standard Time", L"FJ", L"Pacific/Fiji" },
  { L"GMT Standard Time", L"", L"Europe/London" },
  { L"GMT Standard Time", L"ES", L"Atlantic/Canary" },
  { L"GMT Standard Time", L"FO", L"Atlantic/Faeroe" },
  { L"GMT Standard Time", L"GB", L"Europe/London" },
  { L"GMT Standard Time", L"GG", L"Europe/Guernsey" },
  { L"GMT Standard Time", L"IE", L"Europe/Dublin" },
  { L"GMT Standard Time", L"IM", L"Europe/Isle_of_Man" },
  { L"GMT Standard Time", L"JE", L"Europe/Jersey" },
  { L"GMT Standard Time", L"PT", L"Europe/Lisbon Atlantic/Madeira" },
  { L"GTB Standard Time", L"", L"Europe/Bucharest" },
  { L"GTB Standard Time", L"CY", L"Asia/Nicosia Asia/Famagusta" },
  { L"GTB Standard Time", L"GR", L"Europe/Athens" },
  { L"GTB Standard Time", L"RO", L"Europe/Bucharest" },
  { L"Georgian Standard Time", L"", L"Asia/Tbilisi" },
  { L"Georgian Standard Time", L"GE", L"Asia/Tbilisi" },
  { L"Greenland Standard Time", L"", L"America/Godthab" },
  { L"Greenland Standard Time", L"GL", L"America/Godthab" },
  { L"Greenwich Standard Time", L"", L"Atlantic/Reykjavik" },
  { L"Greenwich Standard Time", L"BF", L"Africa/Ouagadougou" },
  { L"Greenwich Standard Time", L"CI", L"Africa/Abidjan" },
  { L"Greenwich Standard Time", L"EH", L"Africa/El_Aaiun" },
  { L"Greenwich Standard Time", L"GH", L"Africa/Accra" },
  { L"Greenwich Standard Time", L"GM", L"Africa/Banjul" },
  { L"Greenwich Standard Time", L"GN", L"Africa/Conakry" },
  { L"Greenwich Standard Time", L"GW", L"Africa/Bissau" },
  { L"Greenwich Standard Time", L"IS", L"Atlantic/Reykjavik" },
  { L"Greenwich Standard Time", L"LR", L"Africa/Monrovia" },
  { L"Greenwich Standard Time", L"ML", L"Africa/Bamako" },
  { L"Greenwich Standard Time", L"MR", L"Africa/Nouakchott" },
  { L"Greenwich Standard Time", L"SH", L"Atlantic/St_Helena" },
  { L"Greenwich Standard Time", L"SL", L"Africa/Freetown" },
  { L"Greenwich Standard Time", L"SN", L"Africa/Dakar" },
  { L"Greenwich Standard Time", L"TG", L"Africa/Lome" },
  { L"Haiti Standard Time", L"", L"America/Port-au-Prince" },
  { L"Haiti Standard Time", L"HT", L"America/Port-au-Prince" },
  { L"Hawaiian Standard Time", L"", L"Pacific/Honolulu" },
  { L"Hawaiian Standard Time", L"CK", L"Pacific/Rarotonga" },
  { L"Hawaiian Standard Time", L"PF", L"Pacific/Tahiti" },
  { L"Hawaiian Standard Time", L"TK", L"Pacific/Fakaofo" },
  { L"Hawaiian Standard Time", L"UM", L"Pacific/Johnston" },
  { L"Hawaiian Standard Time", L"US", L"Pacific/Honolulu" },
  { L"Hawaiian Standard Time", L"ZZ", L"Etc/GMT+10" },
  { L"India Standard Time", L"", L"Asia/Kolkata" },
  { L"India Standard Time", L"IN", L"Asia/Kolkata" },
  { L"Iran Standard Time", L"", L"Asia/Tehran" },
  { L"Iran Standard Time", L"IR", L"Asia/Tehran" },
  { L"Israel Standard Time", L"", L"Asia/Jerusalem" },
  { L"Israel Standard Time", L"IL", L"Asia/Jerusalem" },
  { L"Jordan Standard Time", L"", L"Asia/Amman" },
  { L"Jordan Standard Time", L"JO", L"Asia/Amman" },
  { L"Kaliningrad Standard Time", L"", L"Europe/Kaliningrad" },
  { L"Kaliningrad Standard Time", L"BY", L"Europe/Minsk" },
  { L"Kaliningrad Standard Time", L"RU", L"Europe/Kaliningrad" },
  { L"Kamchatka Standard Time", L"", L"Asia/Kamchatka" },
  { L"Korea Standard Time", L"", L"Asia/Seoul" },
  { L"Korea Standard Time", L"KR", L"Asia/Seoul" },
  { L"Libya Standard Time", L"", L"Africa/Tripoli" },
  { L"Libya Standard Time", L"LY", L"Africa/Tripoli" },
  { L"Line Islands Standard Time", L"", L"Pacific/Kiritimati" },
  { L"Line Islands Standard Time", L"KI", L"Pacific/Kiritimati" },
  { L"Line Islands Standard Time", L"ZZ", L"Etc/GMT-14" },
  { L"Lord Howe Standard Time", L"", L"Australia/Lord_Howe" },
  { L"Lord Howe Standard Time", L"AU", L"Australia/Lord_Howe" },
  { L"Magadan Standard Time", L"", L"Asia/Magadan" },
  { L"Magadan Standard Time", L"RU", L"Asia/Magadan" },
  { L"Magallanes Standard Time", L"", L"America/Punta_Arenas" },
  { L"Magallanes Standard Time", L"CL", L"America/Punta_Arenas" },
  { L"Marquesas Standard Time", L"", L"Pacific/Marquesas" },
  { L"Marquesas Standard Time", L"PF", L"Pacific/Marquesas" },
  { L"Mauritius Standard Time", L"", L"Indian/Mauritius" },
  { L"Mauritius Standard Time", L"MU", L"Indian/Mauritius" },
  { L"Mauritius Standard Time", L"RE", L"Indian/Reunion" },
  { L"Mauritius Standard Time", L"SC", L"Indian/Mahe" },
  { L"Mid-Atlantic Standard Time", L"", L"Atlantic/South_Georgia" },
  { L"Middle East Standard Time", L"", L"Asia/Beirut" },
  { L"Middle East Standard Time", L"LB", L"Asia/Beirut" },
  { L"Montevideo Standard Time", L"", L"America/Montevideo" },
  { L"Montevideo Standard Time", L"UY", L"America/Montevideo" },
  { L"Morocco Standard Time", L"", L"Africa/Casablanca" },
  { L"Morocco Standard Time", L"EH", L"Africa/El_Aaiun" },
  { L"Morocco Standard Time", L"MA", L"Africa/Casablanca" },
  { L"Mountain Standard Time", L"", L"America/Denver" },
  { L"Mountain Standard Time", L"CA", L"America/Edmonton America/Cambridge_Bay America/Inuvik America/Yellowknife" },
  { L"Mountain Standard Time", L"MX", L"America/Ojinaga" },
  { L"Mountain Standard Time", L"US", L"America/Denver America/Boise" },
  { L"Mountain Standard Time", L"ZZ", L"MST7MDT" },
  { L"Mountain Standard Time (Mexico)", L"", L"America/Chihuahua" },
  { L"Mountain Standard Time (Mexico)", L"MX", L"America/Chihuahua America/Mazatlan" },
  { L"Myanmar Standard Time", L"", L"Asia/Rangoon" },
  { L"Myanmar Standard Time", L"CC", L"Indian/Cocos" },
  { L"Myanmar Standard Time", L"MM", L"Asia/Rangoon" },
  { L"N. Central Asia Standard Time", L"", L"Asia/Novosibirsk" },
  { L"N. Central Asia Standard Time", L"RU", L"Asia/Novosibirsk" },
  { L"Namibia Standard Time", L"", L"Africa/Windhoek" },
  { L"Namibia Standard Time", L"NA", L"Africa/Windhoek" },
  { L"Nepal Standard Time", L"", L"Asia/Katmandu" },
  { L"Nepal Standard Time", L"NP", L"Asia/Katmandu" },
  { L"New Zealand Standard Time", L"", L"Pacific/Auckland" },
  { L"New Zealand Standard Time", L"AQ", L"Antarctica/McMurdo" },
  { L"New Zealand Standard Time", L"NZ", L"Pacific/Auckland" },
  { L"Newfoundland Standard Time", L"", L"America/St_Johns" },
  { L"Newfoundland Standard Time", L"CA", L"America/St_Johns" },
  { L"Norfolk Standard Time", L"", L"Pacific/Norfolk" },
  { L"Norfolk Standard Time", L"NF", L"Pacific/Norfolk" },
  { L"North Asia East Standard Time", L"", L"Asia/Irkutsk" },
  { L"North Asia East Standard Time", L"RU", L"Asia/Irkutsk" },
  { L"North Asia Standard Time", L"", L"Asia/Krasnoyarsk" },
  { L"North Asia Standard Time", L"RU", L"Asia/Krasnoyarsk Asia/Novokuznetsk" },
  { L"North Korea Standard Time", L"", L"Asia/Pyongyang" },
  { L"North Korea Standard Time", L"KP", L"Asia/Pyongyang" },
  { L"Omsk Standard Time", L"", L"Asia/Omsk" },
  { L"Omsk Standard Time", L"RU", L"Asia/Omsk" },
  { L"Pacific SA Standard Time", L"", L"America/Santiago" },
  { L"Pacific SA Standard Time", L"CL", L"America/Santiago" },
  { L"Pacific Standard Time", L"", L"America/Los_Angeles" },
  { L"Pacific Standard Time", L"CA", L"America/Vancouver" },
  { L"Pacific Standard Time", L"US", L"America/Los_Angeles" },
  { L"Pacific Standard Time", L"ZZ", L"PST8PDT" },
  { L"Pacific Standard Time (Mexico)", L"", L"America/Tijuana" },
  { L"Pacific Standard Time (Mexico)", L"MX", L"America/Tijuana America/Santa_Isabel" },
  { L"Pakistan Standard Time", L"", L"Asia/Karachi" },
  { L"Pakistan Standard Time", L"PK", L"Asia/Karachi" },
  { L"Paraguay Standard Time", L"", L"America/Asuncion" },
  { L"Paraguay Standard Time", L"PY", L"America/Asuncion" },
  { L"Qyzylorda Standard Time", L"", L"Asia/Qyzylorda" },
  { L"Qyzylorda Standard Time", L"KZ", L"Asia/Qyzylorda" },
  { L"Romance Standard Time", L"", L"Europe/Paris" },
  { L"Romance Standard Time", L"BE", L"Europe/Brussels" },
  { L"Romance Standard Time", L"DK", L"Europe/Copenhagen" },
  { L"Romance Standard Time", L"ES", L"Europe/Madrid Africa/Ceuta" },
  { L"Romance Standard Time", L"FR", L"Europe/Paris" },
  { L"Russia Time Zone 10", L"", L"Asia/Srednekolymsk" },
  { L"Russia Time Zone 10", L"RU", L"Asia/Srednekolymsk" },
  { L"Russia Time Zone 11", L"", L"Asia/Kamchatka" },
  { L"Russia Time Zone 11", L"RU", L"Asia/Kamchatka Asia/Anadyr" },
  { L"Russia Time Zone 3", L"", L"Europe/Samara" },
  { L"Russia Time Zone 3", L"RU", L"Europe/Samara" },
  { L"Russian Standard Time", L"", L"Europe/Moscow" },
  { L"Russian Standard Time", L"RU", L"Europe/Moscow Europe/Kirov" },
  { L"Russian Standard Time", L"UA", L"Europe/Simferopol" },
  { L"SA Eastern Standard Time", L"", L"America/Cayenne" },
  { L"SA Eastern Standard Time", L"AQ", L"Antarctica/Rothera Antarctica/Palmer" },
  { L"SA Eastern Standard Time", L"BR", L"America/Fortaleza America/Belem America/Maceio America/Recife America/Santarem" },
  { L"SA Eastern Standard Time", L"FK", L"Atlantic/Stanley" },
  { L"SA Eastern Standard Time", L"GF", L"America/Cayenne" },
  { L"SA Eastern Standard Time", L"SR", L"America/Paramaribo" },
  { L"SA Eastern Standard Time", L"ZZ", L"Etc/GMT+3" },
  { L"SA Pacific Standard Time", L"", L"America/Bogota" },
  { L"SA Pacific Standard Time", L"BR", L"America/Rio_Branco America/Eirunepe" },
  { L"SA Pacific Standard Time", L"CA", L"America/Coral_Harbour" },
  { L"SA Pacific Standard Time", L"CO", L"America/Bogota" },
  { L"SA Pacific Standard Time", L"EC", L"America/Guayaquil" },
  { L"SA Pacific Standard Time", L"HT", L"America/Port-au-Prince" },
  { L"SA Pacific Standard Time", L"JM", L"America/Jamaica" },
  { L"SA Pacific Standard Time", L"KY", L"America/Cayman" },
  { L"SA Pacific Standard Time", L"PA", L"America/Panama" },
  { L"SA Pacific Standard Time", L"PE", L"America/Lima" },
  { L"SA Pacific Standard Time", L"ZZ", L"Etc/GMT+5" },
  { L"SA Western Standard Time", L"", L"America/La_Paz" },
  { L"SA Western Standard Time", L"AG", L"America/Antigua" },
  { L"SA Western Standard Time", L"AI", L"America/Anguilla" },
  { L"SA Western Standard Time", L"AW", L"America/Aruba" },
  { L"SA Western Standard Time", L"BB", L"America/Barbados" },
  { L"SA Western Standard Time", L"BL", L"America/St_Barthelemy" },
  { L"SA Western Standard Time", L"BO", L"America/La_Paz" },
  { L"SA Western Standard Time", L"BQ", L"America/Kralendijk" },
  { L"SA Western Standard Time", L"BR", L"America/Manaus America/Boa_Vista America/Porto_Velho" },
  { L"SA Western Standard Time", L"CA", L"America/Blanc-Sablon" },
  { L"SA Western Standard Time", L"CW", L"America/Curacao" },
  { L"SA Western Standard Time", L"DM", L"America/Dominica" },
  { L"SA Western Standard Time", L"DO", L"America/Santo_Domingo" },
  { L"SA Western Standard Time", L"GD", L"America/Grenada" },
  { L"SA Western Standard Time", L"GP", L"America/Guadeloupe" },
  { L"SA Western Standard Time", L"GY", L"America/Guyana" },
  { L"SA Western Standard Time", L"KN", L"America/St_Kitts" },
  { L"SA Western Standard Time", L"LC", L"America/St_Lucia" },
  { L"SA Western Standard Time", L"MF", L"America/Marigot" },
  { L"SA Western Standard Time", L"MQ", L"America/Martinique" },
  { L"SA Western Standard Time", L"MS", L"America/Montserrat" },
  { L"SA Western Standard Time", L"PR", L"America/Puerto_Rico" },
  { L"SA Western Standard Time", L"SX", L"America/Lower_Princes" },
  { L"SA Western Standard Time", L"TT", L"America/Port_of_Spain" },
  { L"SA Western Standard Time", L"VC", L"America/St_Vincent" },
  { L"SA Western Standard Time", L"VG", L"America/Tortola" },
  { L"SA Western Standard Time", L"VI", L"America/St_Thomas" },
  { L"SA Western Standard Time", L"ZZ", L"Etc/GMT+4" },
  { L"SE Asia Standard Time", L"", L"Asia/Bangkok" },
  { L"SE Asia Standard Time", L"AQ", L"Antarctica/Davis" },
  { L"SE Asia Standard Time", L"CX", L"Indian/Christmas" },
  { L"SE Asia Standard Time", L"ID", L"Asia/Jakarta Asia/Pontianak" },
  { L"SE Asia Standard Time", L"KH", L"Asia/Phnom_Penh" },
  { L"SE Asia Standard Time", L"LA", L"Asia/Vientiane" },
  { L"SE Asia Standard Time", L"TH", L"Asia/Bangkok" },
  { L"SE Asia Standard Time", L"VN", L"Asia/Saigon" },
  { L"SE Asia Standard Time", L"ZZ", L"Etc/GMT-7" },
  { L"Saint Pierre Standard Time", L"", L"America/Miquelon" },
  { L"Saint Pierre Standard Time", L"PM", L"America/Miquelon" },
  { L"Sakhalin Standard Time", L"", L"Asia/Sakhalin" },
  { L"Sakhalin Standard Time", L"RU", L"Asia/Sakhalin" },
  { L"Samoa Standard Time", L"", L"Pacific/Apia" },
  { L"Samoa Standard Time", L"WS", L"Pacific/Apia" },
  { L"Sao Tome Standard Time", L"", L"Africa/Sao_Tome" },
  { L"Sao Tome Standard Time", L"ST", L"Africa/Sao_Tome" },
  { L"Saratov Standard Time", L"", L"Europe/Saratov" },
  { L"Saratov Standard Time", L"RU", L"Europe/Saratov" },
  { L"Singapore Standard Time", L"", L"Asia/Singapore" },
  { L"Singapore Standard Time", L"AQ", L"Antarctica/Casey" },
  { L"Singapore Standard Time", L"BN", L"Asia/Brunei" },
  { L"Singapore Standard Time", L"ID", L"Asia/Makassar" },
  { L"Singapore Standard Time", L"MY", L"Asia/Kuala_Lumpur Asia/Kuching" },
  { L"Singapore Standard Time", L"PH", L"Asia/Manila" },
  { L"Singapore Standard Time", L"SG", L"Asia/Singapore" },
  { L"Singapore Standard Time", L"ZZ", L"Etc/GMT-8" },
  { L"South Africa Standard Time", L"", L"Africa/Johannesburg" },
  { L"South Africa Standard Time", L"BI", L"Africa/Bujumbura" },
  { L"South Africa Standard Time", L"BW", L"Africa/Gaborone" },
  { L"South Africa Standard Time", L"CD", L"Africa/Lubumbashi" },
  { L"South Africa Standard Time", L"LS", L"Africa/Maseru" },
  { L"South Africa Standard Time", L"LY", L"Africa/Tripoli" },
  { L"South Africa Standard Time", L"MW", L"Africa/Blantyre" },
  { L"South Africa Standard Time", L"MZ", L"Africa/Maputo" },
  { L"South Africa Standard Time", L"RW", L"Africa/Kigali" },
  { L"South Africa Standard Time", L"SZ", L"Africa/Mbabane" },
  { L"South Africa Standard Time", L"ZA", L"Africa/Johannesburg" },
  { L"South Africa Standard Time", L"ZM", L"Africa/Lusaka" },
  { L"South Africa Standard Time", L"ZW", L"Africa/Harare" },
  { L"South Africa Standard Time", L"ZZ", L"Etc/GMT-2" },
  { L"Sri Lanka Standard Time", L"", L"Asia/Colombo" },
  { L"Sri Lanka Standard Time", L"LK", L"Asia/Colombo" },
  { L"Sudan Standard Time", L"", L"Africa/Khartoum" },
  { L"Sudan Standard Time", L"SD", L"Africa/Khartoum" },
  { L"Syria Standard Time", L"", L"Asia/Damascus" },
  { L"Syria Standard Time", L"SY", L"Asia/Damascus" },
  { L"Taipei Standard Time", L"", L"Asia/Taipei" },
  { L"Taipei Standard Time", L"TW", L"Asia/Taipei" },
  { L"Tasmania Standard Time", L"", L"Australia/Hobart" },
  { L"Tasmania Standard Time", L"AU", L"Australia/Hobart Australia/Currie" },
  { L"Tocantins Standard Time", L"", L"America/Araguaina" },
  { L"Tocantins Standard Time", L"BR", L"America/Araguaina" },
  { L"Tokyo Standard Time", L"", L"Asia/Tokyo" },
  { L"Tokyo Standard Time", L"ID", L"Asia/Jayapura" },
  { L"Tokyo Standard Time", L"JP", L"Asia/Tokyo" },
  { L"Tokyo Standard Time", L"PW", L"Pacific/Palau" },
  { L"Tokyo Standard Time", L"TL", L"Asia/Dili" },
  { L"Tokyo Standard Time", L"ZZ", L"Etc/GMT-9" },
  { L"Tomsk Standard Time", L"", L"Asia/Tomsk" },
  { L"Tomsk Standard Time", L"RU", L"Asia/Tomsk" },
  { L"Tonga Standard Time", L"", L"Pacific/Tongatapu" },
  { L"Tonga Standard Time", L"TO", L"Pacific/Tongatapu" },
  { L"Transbaikal Standard Time", L"", L"Asia/Chita" },
  { L"Transbaikal Standard Time", L"RU", L"Asia/Chita" },
  { L"Turkey Standard Time", L"", L"Europe/Istanbul" },
  { L"Turkey Standard Time", L"TR", L"Europe/Istanbul" },
  { L"Turks And Caicos Standard Time", L"", L"America/Grand_Turk" },
  { L"Turks And Caicos Standard Time", L"TC", L"America/Grand_Turk" },
  { L"US Eastern Standard Time", L"", L"America/Indianapolis" },
  { L"US Eastern Standard Time", L"US", L"America/Indianapolis America/Indiana/Marengo America/Indiana/Vevay" },
  { L"US Mountain Standard Time", L"", L"America/Phoenix" },
  { L"US Mountain Standard Time", L"CA", L"America/Whitehorse America/Creston  America/Dawson  America/Dawson_Creek America/Fort_Nelson" },
  { L"US Mountain Standard Time", L"MX", L"America/Hermosillo" },
  { L"US Mountain Standard Time", L"US", L"America/Phoenix" },
  { L"US Mountain Standard Time", L"ZZ", L"Etc/GMT+7" },
  { L"UTC", L"", L"Etc/GMT" },
  { L"UTC", L"GL", L"America/Danmarkshavn" },
  { L"UTC", L"ZZ", L"Etc/GMT Etc/UTC" },
  { L"UTC-02", L"", L"Etc/GMT+2" },
  { L"UTC-02", L"BR", L"America/Noronha" },
  { L"UTC-02", L"GS", L"Atlantic/South_Georgia" },
  { L"UTC-02", L"ZZ", L"Etc/GMT+2" },
  { L"UTC-08", L"", L"Etc/GMT+8" },
  { L"UTC-08", L"PN", L"Pacific/Pitcairn" },
  { L"UTC-08", L"ZZ", L"Etc/GMT+8" },
  { L"UTC-09", L"", L"Etc/GMT+9" },
  { L"UTC-09", L"PF", L"Pacific/Gambier" },
  { L"UTC-09", L"ZZ", L"Etc/GMT+9" },
  { L"UTC-11", L"", L"Etc/GMT+11" },
  { L"UTC-11", L"AS", L"Pacific/Pago_Pago" },
  { L"UTC-11", L"NU", L"Pacific/Niue" },
  { L"UTC-11", L"UM", L"Pacific/Midway" },
  { L"UTC-11", L"ZZ", L"Etc/GMT+11" },
  { L"UTC+12", L"", L"Etc/GMT-12" },
  { L"UTC+12", L"KI", L"Pacific/Tarawa" },
  { L"UTC+12", L"MH", L"Pacific/Majuro Pacific/Kwajalein" },
  { L"UTC+12", L"NR", L"Pacific/Nauru" },
  { L"UTC+12", L"TV", L"Pacific/Funafuti" },
  { L"UTC+12", L"UM", L"Pacific/Wake" },
  { L"UTC+12", L"WF", L"Pacific/Wallis" },
  { L"UTC+12", L"ZZ", L"Etc/GMT-12" },
  { L"UTC+13", L"", L"Etc/GMT-13" },
  { L"UTC+13", L"KI", L"Pacific/Enderbury" },
  { L"UTC+13", L"TK", L"Pacific/Fakaofo" },
  { L"UTC+13", L"ZZ", L"Etc/GMT-13" },
  { L"Ulaanbaatar Standard Time", L"", L"Asia/Ulaanbaatar" },
  { L"Ulaanbaatar Standard Time", L"MN", L"Asia/Ulaanbaatar Asia/Choibalsan" },
  { L"Venezuela Standard Time", L"", L"America/Caracas" },
  { L"Venezuela Standard Time", L"VE", L"America/Caracas" },
  { L"Vladivostok Standard Time", L"", L"Asia/Vladivostok" },
  { L"Vladivostok Standard Time", L"RU", L"Asia/Vladivostok Asia/Ust-Nera" },
  { L"Volgograd Standard Time", L"", L"Europe/Volgograd" },
  { L"Volgograd Standard Time", L"RU", L"Europe/Volgograd" },
  { L"W. Australia Standard Time", L"", L"Australia/Perth" },
  { L"W. Australia Standard Time", L"AU", L"Australia/Perth" },
  { L"W. Central Africa Standard Time", L"", L"Africa/Lagos" },
  { L"W. Central Africa Standard Time", L"AO", L"Africa/Luanda" },
  { L"W. Central Africa Standard Time", L"BJ", L"Africa/Porto-Novo" },
  { L"W. Central Africa Standard Time", L"CD", L"Africa/Kinshasa" },
  { L"W. Central Africa Standard Time", L"CF", L"Africa/Bangui" },
  { L"W. Central Africa Standard Time", L"CG", L"Africa/Brazzaville" },
  { L"W. Central Africa Standard Time", L"CM", L"Africa/Douala" },
  { L"W. Central Africa Standard Time", L"DZ", L"Africa/Algiers" },
  { L"W. Central Africa Standard Time", L"GA", L"Africa/Libreville" },
  { L"W. Central Africa Standard Time", L"GQ", L"Africa/Malabo" },
  { L"W. Central Africa Standard Time", L"NE", L"Africa/Niamey" },
  { L"W. Central Africa Standard Time", L"NG", L"Africa/Lagos" },
  { L"W. Central Africa Standard Time", L"TD", L"Africa/Ndjamena" },
  { L"W. Central Africa Standard Time", L"TN", L"Africa/Tunis" },
  { L"W. Central Africa Standard Time", L"ZZ", L"Etc/GMT-1" },
  { L"W. Europe Standard Time", L"", L"Europe/Berlin" },
  { L"W. Europe Standard Time", L"AD", L"Europe/Andorra" },
  { L"W. Europe Standard Time", L"AT", L"Europe/Vienna" },
  { L"W. Europe Standard Time", L"CH", L"Europe/Zurich" },
  { L"W. Europe Standard Time", L"DE", L"Europe/Berlin Europe/Busingen" },
  { L"W. Europe Standard Time", L"GI", L"Europe/Gibraltar" },
  { L"W. Europe Standard Time", L"IT", L"Europe/Rome" },
  { L"W. Europe Standard Time", L"LI", L"Europe/Vaduz" },
  { L"W. Europe Standard Time", L"LU", L"Europe/Luxembourg" },
  { L"W. Europe Standard Time", L"MC", L"Europe/Monaco" },
  { L"W. Europe Standard Time", L"MT", L"Europe/Malta" },
  { L"W. Europe Standard Time", L"NL", L"Europe/Amsterdam" },
  { L"W. Europe Standard Time", L"NO", L"Europe/Oslo" },
  { L"W. Europe Standard Time", L"SE", L"Europe/Stockholm" },
  { L"W. Europe Standard Time", L"SJ", L"Arctic/Longyearbyen" },
  { L"W. Europe Standard Time", L"SM", L"Europe/San_Marino" },
  { L"W. Europe Standard Time", L"VA", L"Europe/Vatican" },
  { L"W. Mongolia Standard Time", L"", L"Asia/Hovd" },
  { L"W. Mongolia Standard Time", L"MN", L"Asia/Hovd" },
  { L"West Asia Standard Time", L"", L"Asia/Tashkent" },
  { L"West Asia Standard Time", L"AQ", L"Antarctica/Mawson" },
  { L"West Asia Standard Time", L"KZ", L"Asia/Oral Asia/Aqtau Asia/Aqtobe Asia/Atyrau" },
  { L"West Asia Standard Time", L"MV", L"Indian/Maldives" },
  { L"West Asia Standard Time", L"TF", L"Indian/Kerguelen" },
  { L"West Asia Standard Time", L"TJ", L"Asia/Dushanbe" },
  { L"West Asia Standard Time", L"TM", L"Asia/Ashgabat" },
  { L"West Asia Standard Time", L"UZ", L"Asia/Tashkent Asia/Samarkand" },
  { L"West Asia Standard Time", L"ZZ", L"Etc/GMT-5" },
  { L"West Bank Standard Time", L"", L"Asia/Hebron" },
  { L"West Bank Standard Time", L"PS", L"Asia/Hebron Asia/Gaza" },
  { L"West Pacific Standard Time", L"", L"Pacific/Port_Moresby" },
  { L"West Pacific Standard Time", L"AQ", L"Antarctica/DumontDUrville" },
  { L"West Pacific Standard Time", L"FM", L"Pacific/Truk" },
  { L"West Pacific Standard Time", L"GU", L"Pacific/Guam" },
  { L"West Pacific Standard Time", L"MP", L"Pacific/Saipan" },
  { L"West Pacific Standard Time", L"PG", L"Pacific/Port_Moresby" },
  { L"West Pacific Standard Time", L"ZZ", L"Etc/GMT-10" },
  { L"Yakutsk Standard Time", L"", L"Asia/Yakutsk" },
  { L"Yakutsk Standard Time", L"RU", L"Asia/Yakutsk Asia/Khandyga" },
};
