/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyorException;
import ch.qos.cal10n.MessageParameterObj;
import ch.qos.cal10n.util.AnnotationExtractorViaEnumClass;
import ch.qos.cal10n.util.CAL10NBundle;
import ch.qos.cal10n.util.CAL10NBundleFinderByClassloader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageConveyor
implements IMessageConveyor {
    final Locale locale;
    final Map<String, CAL10NBundle> cache = new ConcurrentHashMap<String, CAL10NBundle>();

    public MessageConveyor(Locale locale) {
        this.locale = locale;
    }

    @Override
    public <E extends Enum<?>> String getMessage(E key, Object ... args2) throws MessageConveyorException {
        String keyAsStr;
        String value2;
        Class<?> declaringClass = key.getDeclaringClass();
        String declaringClassName = declaringClass.getName();
        CAL10NBundle rb = this.cache.get(declaringClassName);
        if (rb == null || rb.hasChanged()) {
            rb = this.lookupResourceBundleByEnumClassAndLocale(declaringClass);
            this.cache.put(declaringClassName, rb);
        }
        if ((value2 = rb.getString(keyAsStr = key.toString())) == null) {
            return "No key found for " + keyAsStr;
        }
        if (args2 == null || args2.length == 0) {
            return value2;
        }
        return MessageFormat.format(value2, args2);
    }

    private <E extends Enum<?>> CAL10NBundle lookupResourceBundleByEnumClassAndLocale(Class<E> declaringClass) throws MessageConveyorException {
        AnnotationExtractorViaEnumClass annotationExtractor = new AnnotationExtractorViaEnumClass(declaringClass);
        String baseName = annotationExtractor.getBaseName();
        if (baseName == null) {
            throw new MessageConveyorException("Missing @BaseName annotation in enum type [" + declaringClass.getName() + "]. See also " + "http://cal10n.qos.ch/codes.html#missingBaseNameAnnotation");
        }
        String charset = annotationExtractor.extractCharset(this.locale);
        CAL10NBundleFinderByClassloader cal10NBundleFinderByClassloader = new CAL10NBundleFinderByClassloader(declaringClass.getClassLoader());
        CAL10NBundle rb = cal10NBundleFinderByClassloader.getBundle(baseName, this.locale, charset);
        if (rb == null) {
            throw new MessageConveyorException("Failed to locate resource bundle [" + baseName + "] for locale [" + this.locale + "] for enum type [" + declaringClass.getName() + "]");
        }
        return rb;
    }

    @Override
    public String getMessage(MessageParameterObj mpo) throws MessageConveyorException {
        if (mpo == null) {
            throw new IllegalArgumentException("MessageParameterObj argumument cannot be null");
        }
        return this.getMessage(mpo.getKey(), mpo.getArgs());
    }
}

