/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnData;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnDatabase;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnSty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class LoadRandomProblems
extends ControlSequence {
    private ProbSolnSty sty;

    public LoadRandomProblems(ProbSolnSty probSolnSty) {
        this("loadrandomproblems", probSolnSty);
    }

    public LoadRandomProblems(String string, ProbSolnSty probSolnSty) {
        super(string);
        this.sty = probSolnSty;
    }

    @Override
    public Object clone() {
        return new LoadRandomProblems(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Serializable serializable;
        Object object;
        TeXObject teXObject;
        TeXObject teXObject2 = teXObjectList == teXParser ? teXParser.popNextArg(91, 93) : teXObjectList.popArg(teXParser, 91, 93);
        String string = "default";
        if (teXObject2 != null) {
            if (teXObject2 instanceof Expandable) {
                teXObject = null;
                teXObject = teXObjectList == teXParser ? ((Expandable)((Object)teXObject2)).expandfully(teXParser) : ((Expandable)((Object)teXObject2)).expandfully(teXParser, teXObjectList);
                if (teXObject != null) {
                    teXObject2 = teXObject;
                }
            }
            string = teXObject2.toString(teXParser);
        }
        teXObject = teXObjectList == teXParser ? teXParser.popNumber() : teXObjectList.popNumber(teXParser);
        Object object2 = object = teXObjectList == teXParser ? teXParser.popNextArg() : teXObjectList.popArg(teXParser);
        if (object instanceof Expandable) {
            serializable = null;
            serializable = teXObjectList == teXParser ? ((Expandable)object).expandfully(teXParser) : ((Expandable)object).expandfully(teXParser, teXObjectList);
            if (serializable != null) {
                object = serializable;
            }
        }
        teXParser.startGroup();
        serializable = this.sty.getTmpDatabase();
        teXParser.putControlSequence(true, new GenericCommand(true, "prob@currentdb", null, teXParser.getListener().createString(((ProbSolnDatabase)serializable).getName())));
        CsvList csvList = CsvList.getList(teXParser, (TeXObject)object);
        int n = csvList.size();
        for (int i = 0; i < n; ++i) {
            teXParser.getListener().input(new TeXPath(teXParser, csvList.getValue(i).toString(teXParser)));
        }
        teXParser.putControlSequence(true, new GenericCommand(true, "prob@currentdb", null, teXParser.getListener().createString(string)));
        ProbSolnDatabase probSolnDatabase = this.sty.isDatabaseDefined(string) ? this.sty.getDatabase(string) : this.sty.addDatabase(string);
        if (probSolnDatabase.size() > 0) {
            Vector vector = new Vector(probSolnDatabase.size());
            Iterator iterator = ((ConcurrentHashMap.KeySetView)probSolnDatabase.keySet()).iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
            Collections.shuffle(vector, this.sty.getRandom());
            int n2 = Integer.min(probSolnDatabase.size(), teXObject.getValue());
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)vector.get(i);
                ProbSolnData probSolnData = (ProbSolnData)((ConcurrentHashMap)serializable).get(string2);
                if (probSolnData == null) continue;
                probSolnDatabase.put(probSolnData.getName(), probSolnData);
            }
        }
        this.sty.clearTmpDatabase();
        teXParser.endGroup();
    }
}

