/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class EnsureMath
extends ControlSequence {
    public EnsureMath() {
        this("ensuremath");
    }

    public EnsureMath(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new EnsureMath(this.getName());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        if (teXParser.isMathMode()) {
            teXObject.process(teXParser);
        } else {
            MathGroup mathGroup = teXParser.getListener().createMathGroup();
            mathGroup.setInLine(true);
            if (teXObject instanceof TeXObjectList) {
                mathGroup.addAll((TeXObjectList)teXObject);
            } else {
                mathGroup.add(teXObject);
            }
            mathGroup.process(teXParser);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        if (teXParser.isMathMode()) {
            teXObject.process(teXParser, teXObjectList);
        } else {
            MathGroup mathGroup = teXParser.getListener().createMathGroup();
            mathGroup.setInLine(true);
            if (teXObject instanceof TeXObjectList) {
                mathGroup.addAll((TeXObjectList)teXObject);
            } else {
                mathGroup.add(teXObject);
            }
            mathGroup.process(teXParser, teXObjectList);
        }
    }
}

