/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebDOMTestActiveDOMObject.h"

#include "KURL.h"
#include "Node.h"
#include "WebDOMNode.h"
#include "WebDOMString.h"
#include "WebExceptionHandler.h"
#include "wtf/text/AtomicString.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

struct WebDOMTestActiveDOMObject::WebDOMTestActiveDOMObjectPrivate {
    WebDOMTestActiveDOMObjectPrivate(WebCore::TestActiveDOMObject* object = 0)
        : impl(object)
    {
    }

    RefPtr<WebCore::TestActiveDOMObject> impl;
};

WebDOMTestActiveDOMObject::WebDOMTestActiveDOMObject()
    : WebDOMObject()
    , m_impl(0)
{
}

WebDOMTestActiveDOMObject::WebDOMTestActiveDOMObject(WebCore::TestActiveDOMObject* impl)
    : WebDOMObject()
    , m_impl(new WebDOMTestActiveDOMObjectPrivate(impl))
{
}

WebDOMTestActiveDOMObject::WebDOMTestActiveDOMObject(const WebDOMTestActiveDOMObject& copy)
    : WebDOMObject()
{
    m_impl = copy.impl() ? new WebDOMTestActiveDOMObjectPrivate(copy.impl()) : 0;
}

WebDOMTestActiveDOMObject& WebDOMTestActiveDOMObject::operator=(const WebDOMTestActiveDOMObject& copy)
{
    delete m_impl;
    m_impl = copy.impl() ? new WebDOMTestActiveDOMObjectPrivate(copy.impl()) : 0;
    return *this;
}

WebCore::TestActiveDOMObject* WebDOMTestActiveDOMObject::impl() const
{
    return m_impl ? WTF::getPtr(m_impl->impl) : 0;
}

WebDOMTestActiveDOMObject::~WebDOMTestActiveDOMObject()
{
    delete m_impl;
    m_impl = 0;
}

int WebDOMTestActiveDOMObject::excitingAttr() const
{
    if (!impl())
        return 0;

    return impl()->excitingAttr();
}

void WebDOMTestActiveDOMObject::excitingFunction(const WebDOMNode& nextChild)
{
    if (!impl())
        return;

    impl()->excitingFunction(toWebCore(nextChild));
}

void WebDOMTestActiveDOMObject::postMessage(const WebDOMString& message)
{
    if (!impl())
        return;

    impl()->postMessage(message);
}

WebCore::TestActiveDOMObject* toWebCore(const WebDOMTestActiveDOMObject& wrapper)
{
    return wrapper.impl();
}

WebDOMTestActiveDOMObject toWebKit(WebCore::TestActiveDOMObject* value)
{
    return WebDOMTestActiveDOMObject(value);
}
