/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef RBTOKEN_H_INCLUDED
#define RBTOKEN_H_INCLUDED

#include <boost/static_assert.hpp>

#include "EBOOKToken.h"

namespace libebook
{

namespace RBToken
{

enum
{
  INVALID_TOKEN = 0,
  FIRST_TOKEN = EBOOKToken<RBParser>::FIRST_TOKEN,

  // keys
  AUTHOR,
  BODY,
  COMMENT,
  COPYRIGHT,
  COPYTITLE,
  COPY_ID,
  GENERATOR,
  ISBN,
  MENUMARK,
  OUTPUT,
  PARSE,
  PUBSERVER_ID,
  PUB_NAME,
  REVISION,
  SuggestedRetailPrice,
  TITLE,
  TITLE_LANGUAGE,
  TYPE,
  URL,
  USERNAME,

  // values
  unknown,

  LAST_TOKEN
};

BOOST_STATIC_ASSERT(EBOOKToken<RBParser>::LAST_TOKEN >= LAST_TOKEN);

}

int getRBTokenId(const char *name, const char *ns = 0);
int getRBTokenId(const char *name, std::size_t nameLen, const char *ns, std::size_t nsLen);
int getRBTokenId(const char *name, std::size_t nameLen);

}

#endif // RBTOKEN_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
