(game-module "chess"
  (title "Xconq Chess")
  (blurb "Xconq's answer to chess")
  (instructions "This is more of an experiment than a real game."
    "Move your pieces to try to capture the other player's king.")
  )

(set use-side-priority true)

(unit-type w-pawn)
(unit-type w-rook)
(unit-type w-knight)
(unit-type w-bishop)
(unit-type w-queen)
(unit-type w-king)

(define w-types (w-pawn w-rook w-knight w-bishop w-queen w-king))

(add w-types possible-sides "white")

(unit-type b-pawn)
(unit-type b-rook)
(unit-type b-knight)
(unit-type b-bishop)
(unit-type b-queen)
(unit-type b-king)

(define b-types (b-pawn b-rook b-knight b-bishop b-queen b-king))

(add b-types possible-sides "black")

(define long-movers (w-rook w-bishop w-queen b-rook b-bishop b-queen))

(terrain-type edge (image-name "gray"))
(terrain-type row1 (image-name "dark-gray"))
(terrain-type row2 (image-name "light-gray"))
(terrain-type row3 (image-name "dark-gray"))
(terrain-type row4 (image-name "light-gray"))
(terrain-type row5 (image-name "dark-gray"))
(terrain-type row6 (image-name "light-gray"))
(terrain-type row7 (image-name "dark-gray"))
(terrain-type row8 (image-name "light-gray"))
(terrain-type row9 (image-name "dark-gray"))
(terrain-type row10 (image-name "light-gray"))
(terrain-type row11 (image-name "dark-gray"))

;;; Vision.

(set see-all true)

;;; Actions.

(add u* acp-per-turn 1)

(add (w-knight b-knight) acp-min -2)
(add long-movers acp-min -13)

;;; Movement.

(add (w-pawn b-pawn) speed 10.00)
(add (w-knight b-knight) speed 2.00)
(add long-movers speed 13.00)

(add (w-knight b-knight) move-range 2)
(add long-movers move-range 13)

(add (w-pawn b-pawn) free-mp 0)

(table mp-to-enter-terrain
  (u* t* 1)
  ;; Constrain pawns to only be able to move forward.
  (w-pawn t* (10 5 5 4 4 3 3 2 2 1 1 0))
  (b-pawn t* (10 0 1 1 2 2 3 3 4 4 5 5))
  )

(table mp-to-leave-terrain
  (u* t* 0)
  ;; Constrain pawns to only be able to move forward.
  (w-pawn t* (10  5  6 6 7 7 8 8 9 9 10 10))
  (b-pawn t* (10 10 10 9 9 8 8 7 7 6  6  5))
  )

;;; Combat.

(table acp-to-attack
  ((w-pawn b-pawn) u* 1)
  ((w-knight b-knight) u* 2)
  (long-movers u* 13)
  ((w-king b-king) u* 1)
  )

(table hit-chance (u* u* 100))

(table damage (u* u* 1))

(table counterattack (u* u* 0))

;;; Scoring.

(add u* point-value 0)
(add (w-king b-king) point-value 1)

(scorekeeper 1 (do last-side-wins))

;;; Setup.

(area 15 13)

(area (terrain
  (by-name
    (edge 0) (row1 1) (row2 2) (row3 3) (row4 4)
    (row5 5) (row6 6) (row7 7) (row8 8) (row9 9)
    (row10 10) (row11 11))
  "15a"
  "a8l6a"
  "a9k5a"
  "a10j4a"
  "a11i3a"
  "a12h2a"
  "a13ga"
  "2a12fa"
  "3a11ea"
  "4a10da"
  "5a9ca"
  "6a8ba"
  "15a"
))

(side 1 (name "White") (class "white") (emblem-name "none"))

(side 2 (name "Black") (class "black") (emblem-name "none"))

(w-pawn 5 2 1)
(w-pawn 6 2 1)
(w-pawn 7 2 1)
(w-pawn 8 2 1)
(w-pawn 9 2 1)
(w-pawn 10 2 1)
(w-pawn 11 2 1)
(w-pawn 12 2 1)
(w-pawn 13 2 1)
(w-rook 6 1 1)
(w-rook 13 1 1)
(w-knight 7 1 1)
(w-knight 12 1 1)
(w-bishop 8 1 1)
(w-bishop 11 1 1)
(w-queen 9 1 1)
(w-king 10 1 1)

(b-pawn 1 10 2)
(b-pawn 2 10 2)
(b-pawn 3 10 2)
(b-pawn 4 10 2)
(b-pawn 5 10 2)
(b-pawn 6 10 2)
(b-pawn 7 10 2)
(b-pawn 8 10 2)
(b-pawn 9 10 2)
(b-rook 1 11 2)
(b-rook 8 11 2)
(b-knight 2 11 2)
(b-knight 7 11 2)
(b-bishop 3 11 2)
(b-bishop 6 11 2)
(b-queen 4 11 2)
(b-king 5 11 2)

(game-module (design-notes (
  "Each side should only be able to do one move each turn, and each piece"
  "should have 1 acp, and get multiple moves with the one action."
  )))

(imf "b-bishop" ((32 32)
  (mono
   "00000000/00000000/000c1800/001e3c00/001e3c00/000c1800/000c1800/001e3c00"
   "001f7c00/003fbe00/007fdf00/007fef00/00ffef80/00fff780/00fff780/00fffb80"
   "00fffb80/007ffb00/007ffb00/003ff600/003ff600/001c1c00/0003e000/001f7c00"
   "001bec00/001ffc00/00fc1f80/01ffffc0/01fe3fc0/00800080/00000000/00000000")
  (mask
   "00000000/00000000/000c1800/001e3c00/001e3c00/000c1800/000c1800/001e3c00"
   "001f7c00/003ffe00/007fff00/007fff00/00ffff80/00ffff80/00ffff80/00ffff80"
   "00ffff80/007fff00/007fff00/003ffe00/003ffe00/001ffc00/0003e000/001ffc00"
   "001ffc00/001ffc00/00ffff80/01ffffc0/01fe3fc0/00800080/00000000/00000000")))
(imf "b-king" ((32 32)
  (mono
   "00000000/00000000/0007f000/0005d000/0006b000/00077000/0006b000/07c5d1f0"
   "0ff7f7f8/1ff80ffc/1e3c1e3c/3dde3dde/3bef7bee/3beffbee/3bf7f7ee/3df7f7de"
   "1dfbefdc/1efbefbc/0f7bef78/07a002f0/021ffc20/03ffffe0/01fe3fc0/019ffcc0"
   "01ffffc0/00f00780/008ff880/00ffff80/007fff00/000ff800/00000000/00000000")
  (mask
   "00000000/00000000/0007f000/0007f000/0007f000/0007f000/0007f000/07c7f1f0"
   "0ff7f7f8/1ffffffc/1ffffffc/3ffffffe/3ffffffe/3ffffffe/3ffffffe/3ffffffe"
   "1ffffffc/1ffffffc/0ffffff8/07fffff0/03ffffe0/03ffffe0/01ffffc0/01ffffc0"
   "01ffffc0/00ffff80/00ffff80/00ffff80/007fff00/000ff800/00000000/00000000")))
(imf "b-knight" ((32 32)
  (mono
   "00000000/00480000/006c0000/007e0000/00770000/007fc000/00fff000/00e7d800"
   "01ebfc00/01fff600/03fff700/07fff700/07fffd80/0feffd80/19ff7dc0/1ff6fdc0"
   "1fe1ff60/09c3ff60/0387ff60/030fff70/000fffd0/001fffb0/001fffb8/003fffb8"
   "003fffb8/003fffb8/007ffffc/007ffffc/007ffffc/007ffffc/00000000/00000000")
  (mask
   "00000000/00480000/006c0000/007e0000/007f0000/007fc000/00fff000/00fff800"
   "01fffc00/01fffe00/03ffff00/07ffff00/07ffff80/0fffff80/1fffffc0/1ff7ffc0"
   "1fe1ffe0/09c3ffe0/0387ffe0/030ffff0/000ffff0/001ffff0/001ffff8/003ffff8"
   "003ffff8/003ffff8/007ffffc/007ffffc/007ffffc/007ffffc/00000000/00000000")))
(imf "b-pawn" ((32 32)
  (mono
   "00000000/00000000/00000000/00000000/0001c000/0003e000/0003e000/0003e000"
   "0001c000/0007f000/000ff800/001ffc00/001ffc00/0001c000/0001c000/0001c000"
   "0003e000/0003e000/0003e000/0007f000/0007f000/0007f000/0003e000/0003e000"
   "001ffc00/007fff00/00ffff80/00ffff80/00ffff80/00000000/00000000/00000000")
  (mask
   "00000000/00000000/00000000/00000000/0001c000/0003e000/0003e000/0003e000"
   "0001c000/0007f000/000ff800/001ffc00/001ffc00/0001c000/0001c000/0001c000"
   "0003e000/0003e000/0003e000/0007f000/0007f000/0007f000/0003e000/0003e000"
   "001ffc00/007fff00/00ffff80/00ffff80/00ffff80/00000000/00000000/00000000")))
(imf "b-queen" ((32 32)
  (mono
   "00000000/00000000/00000000/00000000/00000000/001c1c00/003e3e00/0e3e3e38"
   "1f1c1c7c/1f08087c/0e1c1c38/041c1c10/063e3e30/073e3e70/07bf7ef0/07fffff0"
   "07fffff0/03e003e0/021ffc20/03fe3fe0/01ffffc0/019ffcc0/01ffffc0/00f00780"
   "008ff880/00ffff80/007fff00/000ff800/00000000/00000000/00000000/00000000")
  (mask
   "00000000/00000000/00000000/00000000/00000000/001c1c00/003e3e00/0e3e3e38"
   "1f1c1c7c/1f08087c/0e1c1c38/041c1c10/063e3e30/073e3e70/07bf7ef0/07fffff0"
   "07fffff0/03ffffe0/03ffffe0/03ffffe0/01ffffc0/01ffffc0/01ffffc0/00ffff80"
   "00ffff80/00ffff80/007fff00/000ff800/00000000/00000000/00000000/00000000")))
(imf "b-rook" ((32 32)
  (mono
   "00000000/00000000/00000000/00000000/03c3c3c0/03ffffc0/03ffffc0/03ffffc0"
   "01ffff80/00ffff00/00400200/007ffe00/007ffe00/007ffe00/007ffe00/007ffe00"
   "007ffe00/007ffe00/00400200/00ffff00/00ffff00/00ffff00/01ffff80/01ffff80"
   "01ffff80/03ffffc0/03ffffc0/03ffffc0/03ffffc0/00000000/00000000/00000000")
  (mask
   "00000000/00000000/00000000/00000000/03c3c3c0/03ffffc0/03ffffc0/03ffffc0"
   "01ffff80/00ffff00/007ffe00/007ffe00/007ffe00/007ffe00/007ffe00/007ffe00"
   "007ffe00/007ffe00/007ffe00/00ffff00/00ffff00/00ffff00/01ffff80/01ffff80"
   "01ffff80/03ffffc0/03ffffc0/03ffffc0/03ffffc0/00000000/00000000/00000000")))
(imf "w-bishop" ((32 32)
  (mono
   "00000000/00000000/000c1800/00122400/00122400/000c1800/000c1800/00122400"
   "00114400/00208200/00404100/00402100/00802080/00801080/00801080/00800880"
   "00800880/00400900/00400900/00201200/00201200/0013e400/000c1800/00108400"
   "00141400/00100400/00ffff80/01014040/017e3f40/00800080/00000000/00000000")
  (mask
   "00000000/00000000/000c1800/001e3c00/001e3c00/000c1800/000c1800/001e3c00"
   "001f7c00/003ffe00/007fff00/007fff00/00ffff80/00ffff80/00ffff80/00ffff80"
   "00ffff80/007fff00/007fff00/003ffe00/003ffe00/001ffc00/000ff800/001ffc00"
   "001ffc00/001ffc00/00ffff80/01ff7fc0/01fe3fc0/00800080/00000000/00000000")))
(imf "w-king" ((32 32)
  (mono
   "00000000/00000000/0007f000/00063000/00055000/00049000/00055000/07c631f0"
   "0837f608/10080804/10041004/20022002/20014002/20008002/20000002/20000002"
   "10000004/10000004/08000008/041ffc10/03e003e0/02000020/0101c040/01600340"
   "01000040/008ff880/00f00780/00800080/00700700/000ff800/00000000/00000000")
  (mask
   "00000000/00000000/0007f000/0007f000/0007f000/0007f000/0007f000/07c7f1f0"
   "0ff7f7f8/1ffffffc/1ffffffc/3ffffffe/3ffffffe/3ffffffe/3ffffffe/3ffffffe"
   "1ffffffc/1ffffffc/0ffffff8/07fffff0/03ffffe0/03ffffe0/01ffffc0/01ffffc0"
   "01ffffc0/00ffff80/00ffff80/00ffff80/007fff00/000ff800/00000000/00000000")))
(imf "w-knight" ((32 32)
  (mono
   "00000000/00480000/006c0000/007e0000/00490000/0048c000/00803000/009c2800"
   "011a0400/01000a00/02000900/04000900/04000280/08100280/10084240/10178240"
   "172100a0/094200a0/028400a0/03080090/00080030/00100050/00100048/00200048"
   "00200048/00200048/00400004/00400004/00400004/007ffffc/00000000/00000000")
  (mask
   "00000000/00480000/006c0000/007e0000/007f0000/007fc000/00fff000/00fff800"
   "01fffc00/01fffe00/03ffff00/07ffff00/07ffff80/0fffff80/1fffffc0/1ff7ffc0"
   "1fe1ffe0/09c3ffe0/0387ffe0/030ffff0/000ffff0/001ffff0/001ffff8/003ffff8"
   "003ffff8/003ffff8/007ffffc/007ffffc/007ffffc/007ffffc/00000000/00000000")))
(imf "w-pawn" ((32 32)
  (mono
   "00000000/00000000/00000000/00000000/0001c000/00022000/00022000/00022000"
   "00014000/00077000/00080800/00100400/001ffc00/00014000/00014000/00014000"
   "00022000/00022000/00022000/00041000/00041000/00041000/00022000/00022000"
   "001c1c00/00600300/00800080/00800080/00ffff80/00000000/00000000/00000000")
  (mask
   "00000000/00000000/00000000/00000000/0001c000/0003e000/0003e000/0003e000"
   "0001c000/0007f000/000ff800/001ffc00/001ffc00/0001c000/0001c000/0001c000"
   "0003e000/0003e000/0003e000/0007f000/0007f000/0007f000/0003e000/0003e000"
   "001ffc00/007fff00/00ffff80/00ffff80/00ffff80/00000000/00000000/00000000")))
(imf "w-queen" ((32 32)
  (mono
   "00000000/00000000/00000000/00000000/00000000/001c1c00/00222200/0e222238"
   "111c1c44/11080844/0e141438/04141410/06222230/05222250/04a14290/04408110"
   "04000010/021ffc20/03e003e0/02000020/0101c040/01600340/01000040/008ff880"
   "00f00780/00800080/00700700/000ff800/00000000/00000000/00000000/00000000")
  (mask
   "00000000/00000000/00000000/00000000/00000000/001c1c00/003e3e00/0e3e3e38"
   "1f1c1c7c/1f08087c/0e1c1c38/041c1c10/063e3e30/073e3e70/07bf7ef0/07fffff0"
   "07fffff0/03ffffe0/03ffffe0/03ffffe0/01ffffc0/01ffffc0/01ffffc0/00ffff80"
   "00ffff80/00ffff80/007fff00/000ff800/00000000/00000000/00000000/00000000")))
(imf "w-rook" ((32 32)
  (mono
   "00000000/00000000/00000000/00000000/03c3c3c0/023c3c40/02000040/02000040"
   "01000080/00800100/007ffe00/00400200/00400200/00400200/00400200/00400200"
   "00400200/00400200/007ffe00/00800100/00800100/00800100/01000080/01000080"
   "01000080/02000040/02000040/02000040/03ffffc0/00000000/00000000/00000000")
  (mask
   "00000000/00000000/00000000/00000000/03c3c3c0/03ffffc0/03ffffc0/03ffffc0"
   "01ffff80/00ffff00/007ffe00/007ffe00/007ffe00/007ffe00/007ffe00/007ffe00"
   "007ffe00/007ffe00/007ffe00/00ffff00/00ffff00/00ffff00/01ffff80/01ffff80"
   "01ffff80/03ffffc0/03ffffc0/03ffffc0/03ffffc0/00000000/00000000/00000000")))
