/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLFieldSetElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLFieldSetElementPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLFieldSetElement* kit(WebCore::HTMLFieldSetElement* obj)
{
    return WEBKIT_DOM_HTML_FIELD_SET_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLFieldSetElement* core(WebKitDOMHTMLFieldSetElement* request)
{
    return request ? static_cast<WebCore::HTMLFieldSetElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLFieldSetElement* wrapHTMLFieldSetElement(WebCore::HTMLFieldSetElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_FIELD_SET_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_FIELD_SET_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLFieldSetElement, webkit_dom_html_field_set_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_DISABLED,
    PROP_FORM,
    PROP_NAME,
    PROP_TYPE,
    PROP_ELEMENTS,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
};

static void webkit_dom_html_field_set_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFieldSetElement* self = WEBKIT_DOM_HTML_FIELD_SET_ELEMENT(object);
    WebCore::HTMLFieldSetElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_field_set_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFieldSetElement* self = WEBKIT_DOM_HTML_FIELD_SET_ELEMENT(object);
    WebCore::HTMLFieldSetElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_ELEMENTS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->elements();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_field_set_element_class_init(WebKitDOMHTMLFieldSetElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_field_set_element_set_property;
    gobjectClass->get_property = webkit_dom_html_field_set_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_field_set_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLFieldSetElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_field_set_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLFieldSetElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_field_set_element_name", /* short description */
                                                           "read-write  gchar* HTMLFieldSetElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_field_set_element_type", /* short description */
                                                           "read-only  gchar* HTMLFieldSetElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ELEMENTS,
                                    g_param_spec_object("elements", /* name */
                                                           "html_field_set_element_elements", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLFieldSetElement.elements", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_field_set_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLFieldSetElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_field_set_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLFieldSetElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_field_set_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLFieldSetElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_field_set_element_init(WebKitDOMHTMLFieldSetElement* request)
{
}

gboolean
webkit_dom_html_field_set_element_check_validity(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), FALSE);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_field_set_element_set_custom_validity(WebKitDOMHTMLFieldSetElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

gboolean
webkit_dom_html_field_set_element_get_disabled(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), FALSE);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_field_set_element_set_disabled(WebKitDOMHTMLFieldSetElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self));
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_field_set_element_get_form(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), 0);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_field_set_element_get_name(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), 0);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_field_set_element_set_name(WebKitDOMHTMLFieldSetElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

WebKitDOMHTMLCollection*
webkit_dom_html_field_set_element_get_elements(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), 0);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->elements());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_html_field_set_element_get_will_validate(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), FALSE);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_field_set_element_get_validity(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), 0);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_field_set_element_get_validation_message(WebKitDOMHTMLFieldSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FIELD_SET_ELEMENT(self), 0);
    WebCore::HTMLFieldSetElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

