
/* autogenerated from schroorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union { orc_int16 i; orc_int8 x2[2]; } orc_union16;
typedef union { orc_int32 i; float f; orc_int16 x2[2]; orc_int8 x4[4]; } orc_union32;
typedef union { orc_int64 i; double f; orc_int32 x2[2]; float x2f[2]; orc_int16 x4[4]; } orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void orc_add2_rshift_add_s16_22_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_add2_rshift_add_s32_22_vert (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_add2_rshift_add_s16_22 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_add2_rshift_add_s32_22 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_add2_rshift_sub_s16_22_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_add2_rshift_sub_s16_22 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_add2_rshift_add_s16_11_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int n);
void orc_add2_rshift_add_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_add2_rshift_sub_s16_11_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_add2_rshift_sub_s32_11_vert (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_add2_rshift_sub_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_add2_rshift_sub_s32_11 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_add_const_rshift_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_add_const_rshift_s16 (orc_int16 * ORC_RESTRICT d1, int p1, int p2, int n);
void orc_add_const_rshift_s32 (orc_int32 * ORC_RESTRICT d1, int p1, int p2, int n);
void orc_add_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_add_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void orc_addc_rshift_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int p1, int n);
void orc_lshift1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_lshift2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_lshift_s16_ip (orc_int16 * ORC_RESTRICT d1, int p1, int n);
void orc_lshift_s32_ip (orc_int32 * ORC_RESTRICT d1, int p1, int n);
void orc_mas2_add_s16_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int p1, int p2, int p3, int n);
void orc_mas2_add_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n);
void orc_mas2_sub_s16_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int p1, int p2, int p3, int n);
void orc_mas2_sub_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n);
void orc_mas4_vert_add_s16_1991 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, const orc_int16 * ORC_RESTRICT s4, int p1, int p2, int n);
void orc_mas4_vert_add_s32_1991 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, int p1, int p2, int n);
void orc_mas4_horiz_add_s16_1991_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n);
void orc_mas4_vert_sub_s16_1991 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, const orc_int16 * ORC_RESTRICT s4, int p1, int p2, int n);
void orc_mas4_horiz_sub_s16_1991_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n);
void orc_subtract_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_add_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n);
void orc_add_s16_u8_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void orc_convert_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n);
void orc_convert_s16_s32 (orc_int16 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_convert_u8_s16 (orc_uint8 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_convert_s32_s16 (orc_int32 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_offsetconvert_u8_s16 (orc_uint8 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_offsetconvert_u8_s32 (orc_uint8 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_offsetconvert_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n);
void orc_offsetconvert_s32_u8 (orc_int32 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n);
void orc_offsetconvert_s32_s16 (orc_int32 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_subtract_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n);
void orc_multiply_and_add_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n);
void orc_splat_s16_ns (orc_int16 * ORC_RESTRICT d1, int p1, int n);
void orc_splat_s32_ns (orc_int32 * ORC_RESTRICT d1, int p1, int n);
void orc_splat_s16_2d_4xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int m);
void orc_splat_s16_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int m);
void orc_splat_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m);
void orc_splat_u8_ns (orc_uint8 * ORC_RESTRICT d1, int p1, int n);
void orc_splat_u8_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m);
void orc_average_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n);
void orc_rrshift6_add_s16_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, const orc_int16 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void orc_rrshift6_add_s32_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_int32 * ORC_RESTRICT s1, int s1_stride, const orc_int16 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void orc_rrshift6_sub_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, orc_int16 * ORC_RESTRICT d2, int d2_stride, int n, int m);
void orc_rrshift6_s16_ip_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int n, int m);
void orc_rrshift6_s16_ip (orc_int16 * ORC_RESTRICT d1, int n);
void orc_unpack_yuyv_y (orc_uint8 * ORC_RESTRICT d1, const orc_uint16 * ORC_RESTRICT s1, int n);
void orc_unpack_yuyv_u (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n);
void orc_unpack_yuyv_v (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n);
void orc_packyuyv (orc_uint32 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, int n);
void orc_unpack_uyvy_y (orc_uint8 * ORC_RESTRICT d1, const orc_uint16 * ORC_RESTRICT s1, int n);
void orc_unpack_uyvy_u (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n);
void orc_unpack_uyvy_v (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n);
void orc_interleave2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_interleave2_rrshift1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_deinterleave2_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_deinterleave2_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_deinterleave2_lshift1_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_deinterleave2_lshift1_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_haar_deint_lshift1_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_haar_deint_lshift1_split_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_haar_deint_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_haar_deint_split_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_haar_split_s16_lo (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_split_s16_hi (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_split_s16_op (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_split_s32_op (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_haar_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int n);
void orc_haar_synth_s16_lo (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_synth_s16_hi (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_synth_s16_op (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_synth_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int n);
void orc_haar_synth_rrshift1_int_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_synth_int_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_haar_sub_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_haar_add_half_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_haar_add_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_haar_sub_half_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_sum_u8 (orc_int32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int n);
void orc_sum_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_sum_square_diff_u8 (orc_int32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n);
void orc_dequantise_s16_2d_4xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int m);
void orc_dequantise_s16_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int m);
void orc_dequantise_s16_ip_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int m);
void orc_dequantise_s16_ip_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int n, int m);
void orc_dequantise_s16_ip (orc_int16 * ORC_RESTRICT d1, int p1, int p2, int n);
void orc_dequantise_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n);
void orc_dequantise_var_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n);
void orc_quantise1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n);
void orc_quantise2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n);
void orc_quantdequant1_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int p5, int n);
void orc_quantdequant3_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int p5, int p6, int n);
void orc_quantdequant2_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int n);
void orc_downsample_vert_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, const orc_uint8 * ORC_RESTRICT s4, int n);
void orc_downsample_horiz_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n);
void orc_stats_moment_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_stats_above_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_accw (int * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n);
void orc_avg2_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m);
void orc_avg2_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m);
void orc_avg2_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m);
void orc_avg2_32xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m);
void orc_avg2_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void orc_combine4_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine4_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine4_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine4_24xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine4_32xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine4_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int n, int m);
void orc_combine2_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine2_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine2_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m);
void orc_combine2_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int n, int m);
void orc_sad_nxm_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void orc_sad_8x8_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride);
void orc_sad_12x12_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride);
void orc_sad_16xn_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m);
void orc_sad_32xn_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m);
void orc_add2_rshift_add_s32_22_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n);
void orc_mas4_vert_add_s32_1991_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, const orc_int32 * ORC_RESTRICT s5, int p1, int p2, int n);
void orc_add2_rshift_sub_s32_22_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n);
void orc_interleave2_rrshift1_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_mas4_vert_sub_s32_1991_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, const orc_int32 * ORC_RESTRICT s5, int p1, int p2, int n);
void orc_mas4_vert_sub_s32_1991 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, int p1, int p2, int n);
void orc_mas4_horiz_add_s32_1991_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int n);
void orc_add2_rshift_add_s32_11_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n);
void orc_mas4_horiz_sub_s32_1991_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int n);
void orc_haar_synth_s32_lo (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_haar_synth_int_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_haar_synth_rrshift1_int_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_interleave2_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n);
void orc_mas2_sub_s32_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int p3, int n);
void orc_mas2_add_s32_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int p3, int n);
void orc_mas2_add_s32_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int p1, int p2, int p3, int n);
void orc_mas2_sub_s32_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int p1, int p2, int p3, int n);
void orc_add2_rshift_sub_s32_22 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_add2_rshift_add_s32_11 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n);
void orc_haar_synth_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, int n);
void orc_splat_s32_2d (orc_int32 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m);
void orc_dequantise_s32_ip_2d (orc_int32 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int n, int m);

void schro_orc_init (void);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* orc_add2_rshift_add_s16_22_vert */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_22_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 3: loadpw */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: addw */
    var38.i = var33.i + var34.i;
    /* 4: addw */
    var39.i = var38.i + var35.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var36 = ptr0[i];
    /* 7: addw */
    var37.i = var36.i + var40.i;
    /* 8: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_22_vert (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 3: loadpw */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: addw */
    var38.i = var33.i + var34.i;
    /* 4: addw */
    var39.i = var38.i + var35.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var36 = ptr0[i];
    /* 7: addw */
    var37.i = var36.i + var40.i;
    /* 8: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s16_22_vert;
void
orc_add2_rshift_add_s16_22_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s16_22_vert;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s32_22_vert */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s32_22_vert (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 3: loadpl */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: loadl */
    var34 = ptr5[i];
    /* 2: addl */
    var38.i = var33.i + var34.i;
    /* 4: addl */
    var39.i = var38.i + var35.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var36 = ptr0[i];
    /* 7: addl */
    var37.i = var36.i + var40.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s32_22_vert (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 3: loadpl */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: loadl */
    var34 = ptr5[i];
    /* 2: addl */
    var38.i = var33.i + var34.i;
    /* 4: addl */
    var39.i = var38.i + var35.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var36 = ptr0[i];
    /* 7: addl */
    var37.i = var36.i + var40.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s32_22_vert;
void
orc_add2_rshift_add_s32_22_vert (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s32_22_vert;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s16_22 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_22 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpw */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var37 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var38.i = var33.i + var37.i;
    /* 4: addw */
    var39.i = var38.i + var34.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var35 = ptr0[i];
    /* 7: addw */
    var36.i = var35.i + var40.i;
    /* 8: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_22 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpw */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var37 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var38.i = var33.i + var37.i;
    /* 4: addw */
    var39.i = var38.i + var34.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var35 = ptr0[i];
    /* 7: addw */
    var36.i = var35.i + var40.i;
    /* 8: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s16_22;
void
orc_add2_rshift_add_s16_22 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s16_22;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s32_22 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s32_22 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var37 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addl */
    var38.i = var33.i + var37.i;
    /* 4: addl */
    var39.i = var38.i + var34.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var35 = ptr0[i];
    /* 7: addl */
    var36.i = var35.i + var40.i;
    /* 8: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s32_22 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var37 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addl */
    var38.i = var33.i + var37.i;
    /* 4: addl */
    var39.i = var38.i + var34.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var35 = ptr0[i];
    /* 7: addl */
    var36.i = var35.i + var40.i;
    /* 8: storel */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s32_22;
void
orc_add2_rshift_add_s32_22 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s32_22;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s16_22_vert */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_22_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 3: loadpw */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: addw */
    var38.i = var33.i + var34.i;
    /* 4: addw */
    var39.i = var38.i + var35.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var36 = ptr0[i];
    /* 7: subw */
    var37.i = var36.i - var40.i;
    /* 8: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_22_vert (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 3: loadpw */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: addw */
    var38.i = var33.i + var34.i;
    /* 4: addw */
    var39.i = var38.i + var35.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var36 = ptr0[i];
    /* 7: subw */
    var37.i = var36.i - var40.i;
    /* 8: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s16_22_vert;
void
orc_add2_rshift_sub_s16_22_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s16_22_vert;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s16_22 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_22 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpw */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var37 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var38.i = var33.i + var37.i;
    /* 4: addw */
    var39.i = var38.i + var34.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var35 = ptr0[i];
    /* 7: subw */
    var36.i = var35.i - var40.i;
    /* 8: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_22 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpw */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var37 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var38.i = var33.i + var37.i;
    /* 4: addw */
    var39.i = var38.i + var34.i;
    /* 5: shrsw */
    var40.i = var39.i >> 2;
    /* 6: loadw */
    var35 = ptr0[i];
    /* 7: subw */
    var36.i = var35.i - var40.i;
    /* 8: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s16_22;
void
orc_add2_rshift_sub_s16_22 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s16_22;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s16_11_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_11_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_union16 *)s3;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr5[i];
    /* 1: loadw */
    var34 = ptr6[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: addw */
    var36.i = var35.i + var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_11_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr5[i];
    /* 1: loadw */
    var34 = ptr6[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: addw */
    var36.i = var35.i + var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s16_11_op;
void
orc_add2_rshift_add_s16_11_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s16_11_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s16_11 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var36 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var36.i + 1)>>1;
    /* 3: loadw */
    var34 = ptr0[i];
    /* 4: addw */
    var35.i = var34.i + var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_11 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var36 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var36.i + 1)>>1;
    /* 3: loadw */
    var34 = ptr0[i];
    /* 4: addw */
    var35.i = var34.i + var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s16_11;
void
orc_add2_rshift_add_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s16_11;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s16_11_vert */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_11_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: subw */
    var36.i = var35.i - var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_11_vert (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: subw */
    var36.i = var35.i - var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s16_11_vert;
void
orc_add2_rshift_sub_s16_11_vert (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s16_11_vert;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s32_11_vert */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s32_11_vert (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: loadl */
    var34 = ptr5[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var34.i + 1)>>1;
    /* 3: loadl */
    var35 = ptr0[i];
    /* 4: subl */
    var36.i = var35.i - var37.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s32_11_vert (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: loadl */
    var34 = ptr5[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var34.i + 1)>>1;
    /* 3: loadl */
    var35 = ptr0[i];
    /* 4: subl */
    var36.i = var35.i - var37.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s32_11_vert;
void
orc_add2_rshift_sub_s32_11_vert (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s32_11_vert;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s16_11 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var36 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var36.i + 1)>>1;
    /* 3: loadw */
    var34 = ptr0[i];
    /* 4: subw */
    var35.i = var34.i - var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_11 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var36 = ptr4[i + 1];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var36.i + 1)>>1;
    /* 3: loadw */
    var34 = ptr0[i];
    /* 4: subw */
    var35.i = var34.i - var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s16_11;
void
orc_add2_rshift_sub_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s16_11;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s32_11 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s32_11 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var36 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var36.i + 1)>>1;
    /* 3: loadl */
    var34 = ptr0[i];
    /* 4: subl */
    var35.i = var34.i - var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s32_11 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var36 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var36.i + 1)>>1;
    /* 3: loadl */
    var34 = ptr0[i];
    /* 4: subl */
    var35.i = var34.i - var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s32_11;
void
orc_add2_rshift_sub_s32_11 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s32_11;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_const_rshift_s16_11 */
#ifdef DISABLE_ORC
void
orc_add_const_rshift_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var34.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> 1;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add_const_rshift_s16_11 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var34.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> 1;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add_const_rshift_s16_11;
void
orc_add_const_rshift_s16_11 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_const_rshift_s16_11;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_const_rshift_s16 */
#ifdef DISABLE_ORC
void
orc_add_const_rshift_s16 (orc_int16 * ORC_RESTRICT d1, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;

    /* 1: loadpw */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> p2;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add_const_rshift_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 1: loadpw */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> ex->params[25];
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add_const_rshift_s16;
void
orc_add_const_rshift_s16 (orc_int16 * ORC_RESTRICT d1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_const_rshift_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_const_rshift_s32 */
#ifdef DISABLE_ORC
void
orc_add_const_rshift_s32 (orc_int32 * ORC_RESTRICT d1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;

    /* 1: loadpl */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: addl */
    var36.i = var33.i + var34.i;
    /* 3: shrsl */
    var35.i = var36.i >> p2;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add_const_rshift_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];

    /* 1: loadpl */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: addl */
    var36.i = var33.i + var34.i;
    /* 3: shrsl */
    var35.i = var36.i >> ex->params[25];
    /* 4: storel */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add_const_rshift_s32;
void
orc_add_const_rshift_s32 (orc_int32 * ORC_RESTRICT d1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_const_rshift_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_s16 */
#ifdef DISABLE_ORC
void
orc_add_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: addw */
    var34.i = var32.i + var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_add_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: addw */
    var34.i = var32.i + var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_add_s16;
void
orc_add_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_s16_2d */
#ifdef DISABLE_ORC
void
orc_add_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var32 = ptr0[i];
      /* 1: loadw */
      var33 = ptr4[i];
      /* 2: addw */
      var34.i = var32.i + var33.i;
      /* 3: storew */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_orc_add_s16_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var32 = ptr0[i];
      /* 1: loadw */
      var33 = ptr4[i];
      /* 2: addw */
      var34.i = var32.i + var33.i;
      /* 3: storew */
      ptr0[i] = var34;
    }
  }

}

OrcCode *_orc_code_orc_add_s16_2d;
void
orc_add_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_s16_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_addc_rshift_s16 */
#ifdef DISABLE_ORC
void
orc_addc_rshift_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> p1;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_addc_rshift_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: loadw */
    var34 = ptr5[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> ex->params[24];
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_addc_rshift_s16;
void
orc_addc_rshift_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_addc_rshift_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_lshift1_s16 */
#ifdef DISABLE_ORC
void
orc_lshift1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shlw */
    var33.i = var32.i << 1;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_lshift1_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shlw */
    var33.i = var32.i << 1;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_lshift1_s16;
void
orc_lshift1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_lshift1_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_lshift2_s16 */
#ifdef DISABLE_ORC
void
orc_lshift2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shlw */
    var33.i = var32.i << 2;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_lshift2_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shlw */
    var33.i = var32.i << 2;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_lshift2_s16;
void
orc_lshift2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_lshift2_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_lshift_s16_ip */
#ifdef DISABLE_ORC
void
orc_lshift_s16_ip (orc_int16 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: shlw */
    var33.i = var32.i << p1;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_lshift_s16_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: shlw */
    var33.i = var32.i << ex->params[24];
    /* 2: storew */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_lshift_s16_ip;
void
orc_lshift_s16_ip (orc_int16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_lshift_s16_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_lshift_s32_ip */
#ifdef DISABLE_ORC
void
orc_lshift_s32_ip (orc_int32 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: shll */
    var33.i = var32.i << p1;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_lshift_s32_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 1: shll */
    var33.i = var32.i << ex->params[24];
    /* 2: storel */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_lshift_s32_ip;
void
orc_lshift_s32_ip (orc_int32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_lshift_s32_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_add_s16_op */
#ifdef DISABLE_ORC
void
orc_mas2_add_s16_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int p1, int p2, int p3, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_union16 *)s3;

    /* 3: loadpw */
    var36.i = p1;
    /* 5: loadpl */
    var37.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr6[i];
    /* 2: addw */
    var40.i = var34.i + var35.i;
    /* 4: mulswl */
    var41.i = var40.i * var36.i;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var38 = ptr4[i];
    /* 10: addw */
    var39.i = var38.i + var44.i;
    /* 11: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas2_add_s16_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];

    /* 3: loadpw */
    var36.i = ex->params[24];
    /* 5: loadpl */
    var37.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr6[i];
    /* 2: addw */
    var40.i = var34.i + var35.i;
    /* 4: mulswl */
    var41.i = var40.i * var36.i;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var38 = ptr4[i];
    /* 10: addw */
    var39.i = var38.i + var44.i;
    /* 11: storew */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas2_add_s16_op;
void
orc_mas2_add_s16_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_add_s16_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_add_s16_ip */
#ifdef DISABLE_ORC
void
orc_mas2_add_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpw */
    var35.i = p1;
    /* 5: loadpl */
    var36.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var39 = ptr4[i + 1];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: addw */
    var40.i = var34.i + var39.i;
    /* 4: mulswl */
    var41.i = var40.i * var35.i;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var37 = ptr0[i];
    /* 10: addw */
    var38.i = var37.i + var44.i;
    /* 11: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_mas2_add_s16_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpw */
    var35.i = ex->params[24];
    /* 5: loadpl */
    var36.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var39 = ptr4[i + 1];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: addw */
    var40.i = var34.i + var39.i;
    /* 4: mulswl */
    var41.i = var40.i * var35.i;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var37 = ptr0[i];
    /* 10: addw */
    var38.i = var37.i + var44.i;
    /* 11: storew */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_mas2_add_s16_ip;
void
orc_mas2_add_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_add_s16_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_sub_s16_op */
#ifdef DISABLE_ORC
void
orc_mas2_sub_s16_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int p1, int p2, int p3, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_union16 *)s3;

    /* 3: loadpw */
    var36.i = p1;
    /* 5: loadpl */
    var37.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr6[i];
    /* 2: addw */
    var40.i = var34.i + var35.i;
    /* 4: mulswl */
    var41.i = var40.i * var36.i;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var38 = ptr4[i];
    /* 10: subw */
    var39.i = var38.i - var44.i;
    /* 11: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas2_sub_s16_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];

    /* 3: loadpw */
    var36.i = ex->params[24];
    /* 5: loadpl */
    var37.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr6[i];
    /* 2: addw */
    var40.i = var34.i + var35.i;
    /* 4: mulswl */
    var41.i = var40.i * var36.i;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var38 = ptr4[i];
    /* 10: subw */
    var39.i = var38.i - var44.i;
    /* 11: storew */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas2_sub_s16_op;
void
orc_mas2_sub_s16_op (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_sub_s16_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_sub_s16_ip */
#ifdef DISABLE_ORC
void
orc_mas2_sub_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpw */
    var35.i = p1;
    /* 5: loadpl */
    var36.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var39 = ptr4[i + 1];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: addw */
    var40.i = var34.i + var39.i;
    /* 4: mulswl */
    var41.i = var40.i * var35.i;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var37 = ptr0[i];
    /* 10: subw */
    var38.i = var37.i - var44.i;
    /* 11: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_mas2_sub_s16_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpw */
    var35.i = ex->params[24];
    /* 5: loadpl */
    var36.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var39 = ptr4[i + 1];
    /* 1: loadw */
    var34 = ptr4[i];
    /* 2: addw */
    var40.i = var34.i + var39.i;
    /* 4: mulswl */
    var41.i = var40.i * var35.i;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: loadw */
    var37 = ptr0[i];
    /* 10: subw */
    var38.i = var37.i - var44.i;
    /* 11: storew */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_mas2_sub_s16_ip;
void
orc_mas2_sub_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_sub_s16_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_vert_add_s16_1991 */
#ifdef DISABLE_ORC
void
orc_mas4_vert_add_s16_1991 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, const orc_int16 * ORC_RESTRICT s4, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_union16 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_union16 *)s3;
  ptr7 = (orc_union16 *)s4;

    /* 3: loadpw */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var41.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var36 = ptr5[i];
    /* 1: loadw */
    var37 = ptr6[i];
    /* 2: addw */
    var44.i = var36.i + var37.i;
    /* 4: mulswl */
    var45.i = var44.i * var38.i;
    /* 5: loadw */
    var39 = ptr4[i];
    /* 6: loadw */
    var40 = ptr7[i];
    /* 7: addw */
    var46.i = var39.i + var40.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var45.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var41.i;
    /* 12: shrsl */
    var50.i = var49.i >> p2;
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var42 = ptr0[i];
    /* 15: addw */
    var43.i = var42.i + var51.i;
    /* 16: storew */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_orc_mas4_vert_add_s16_1991 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_union16 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];

    /* 3: loadpw */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var41.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var36 = ptr5[i];
    /* 1: loadw */
    var37 = ptr6[i];
    /* 2: addw */
    var44.i = var36.i + var37.i;
    /* 4: mulswl */
    var45.i = var44.i * var38.i;
    /* 5: loadw */
    var39 = ptr4[i];
    /* 6: loadw */
    var40 = ptr7[i];
    /* 7: addw */
    var46.i = var39.i + var40.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var45.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var41.i;
    /* 12: shrsl */
    var50.i = var49.i >> ex->params[25];
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var42 = ptr0[i];
    /* 15: addw */
    var43.i = var42.i + var51.i;
    /* 16: storew */
    ptr0[i] = var43;
  }

}

OrcCode *_orc_code_orc_mas4_vert_add_s16_1991;
void
orc_mas4_vert_add_s16_1991 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, const orc_int16 * ORC_RESTRICT s4, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_vert_add_s16_1991;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_vert_add_s32_1991 */
#ifdef DISABLE_ORC
void
orc_mas4_vert_add_s32_1991 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  orc_union32 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;
  ptr7 = (orc_union32 *)s4;

    /* 3: loadpl */
    var37.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var40.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr5[i];
    /* 1: loadl */
    var36 = ptr6[i];
    /* 2: addl */
    var43.i = var35.i + var36.i;
    /* 4: mulll */
    var44.i = (var43.i * var37.i) & 0xffffffff;
    /* 5: loadl */
    var38 = ptr4[i];
    /* 6: loadl */
    var39 = ptr7[i];
    /* 7: addl */
    var45.i = var38.i + var39.i;
    /* 8: subl */
    var46.i = var44.i - var45.i;
    /* 10: addl */
    var47.i = var46.i + var40.i;
    /* 11: shrsl */
    var48.i = var47.i >> p2;
    /* 12: loadl */
    var41 = ptr0[i];
    /* 13: addl */
    var42.i = var41.i + var48.i;
    /* 14: storel */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_orc_mas4_vert_add_s32_1991 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  orc_union32 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];
  ptr7 = (orc_union32 *)ex->arrays[7];

    /* 3: loadpl */
    var37.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var40.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr5[i];
    /* 1: loadl */
    var36 = ptr6[i];
    /* 2: addl */
    var43.i = var35.i + var36.i;
    /* 4: mulll */
    var44.i = (var43.i * var37.i) & 0xffffffff;
    /* 5: loadl */
    var38 = ptr4[i];
    /* 6: loadl */
    var39 = ptr7[i];
    /* 7: addl */
    var45.i = var38.i + var39.i;
    /* 8: subl */
    var46.i = var44.i - var45.i;
    /* 10: addl */
    var47.i = var46.i + var40.i;
    /* 11: shrsl */
    var48.i = var47.i >> ex->params[25];
    /* 12: loadl */
    var41 = ptr0[i];
    /* 13: addl */
    var42.i = var41.i + var48.i;
    /* 14: storel */
    ptr0[i] = var42;
  }

}

OrcCode *_orc_code_orc_mas4_vert_add_s32_1991;
void
orc_mas4_vert_add_s32_1991 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_vert_add_s32_1991;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_horiz_add_s16_1991_ip */
#ifdef DISABLE_ORC
void
orc_mas4_horiz_add_s16_1991_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpw */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var37.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var40 = ptr4[i + 1];
    /* 1: loadoffw */
    var41 = ptr4[i + 2];
    /* 2: addw */
    var42.i = var40.i + var41.i;
    /* 4: mulswl */
    var43.i = var42.i * var36.i;
    /* 5: loadw */
    var44 = ptr4[i];
    /* 6: loadoffw */
    var45 = ptr4[i + 3];
    /* 7: addw */
    var46.i = var44.i + var45.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var43.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var37.i;
    /* 12: shrsl */
    var50.i = var49.i >> p2;
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var38 = ptr0[i];
    /* 15: addw */
    var39.i = var38.i + var51.i;
    /* 16: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas4_horiz_add_s16_1991_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpw */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var37.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var40 = ptr4[i + 1];
    /* 1: loadoffw */
    var41 = ptr4[i + 2];
    /* 2: addw */
    var42.i = var40.i + var41.i;
    /* 4: mulswl */
    var43.i = var42.i * var36.i;
    /* 5: loadw */
    var44 = ptr4[i];
    /* 6: loadoffw */
    var45 = ptr4[i + 3];
    /* 7: addw */
    var46.i = var44.i + var45.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var43.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var37.i;
    /* 12: shrsl */
    var50.i = var49.i >> ex->params[25];
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var38 = ptr0[i];
    /* 15: addw */
    var39.i = var38.i + var51.i;
    /* 16: storew */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas4_horiz_add_s16_1991_ip;
void
orc_mas4_horiz_add_s16_1991_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_horiz_add_s16_1991_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_vert_sub_s16_1991 */
#ifdef DISABLE_ORC
void
orc_mas4_vert_sub_s16_1991 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, const orc_int16 * ORC_RESTRICT s4, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_union16 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_union16 *)s3;
  ptr7 = (orc_union16 *)s4;

    /* 3: loadpw */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var41.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var36 = ptr5[i];
    /* 1: loadw */
    var37 = ptr6[i];
    /* 2: addw */
    var44.i = var36.i + var37.i;
    /* 4: mulswl */
    var45.i = var44.i * var38.i;
    /* 5: loadw */
    var39 = ptr4[i];
    /* 6: loadw */
    var40 = ptr7[i];
    /* 7: addw */
    var46.i = var39.i + var40.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var45.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var41.i;
    /* 12: shrsl */
    var50.i = var49.i >> p2;
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var42 = ptr0[i];
    /* 15: subw */
    var43.i = var42.i - var51.i;
    /* 16: storew */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_orc_mas4_vert_sub_s16_1991 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_union16 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];

    /* 3: loadpw */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var41.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var36 = ptr5[i];
    /* 1: loadw */
    var37 = ptr6[i];
    /* 2: addw */
    var44.i = var36.i + var37.i;
    /* 4: mulswl */
    var45.i = var44.i * var38.i;
    /* 5: loadw */
    var39 = ptr4[i];
    /* 6: loadw */
    var40 = ptr7[i];
    /* 7: addw */
    var46.i = var39.i + var40.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var45.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var41.i;
    /* 12: shrsl */
    var50.i = var49.i >> ex->params[25];
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var42 = ptr0[i];
    /* 15: subw */
    var43.i = var42.i - var51.i;
    /* 16: storew */
    ptr0[i] = var43;
  }

}

OrcCode *_orc_code_orc_mas4_vert_sub_s16_1991;
void
orc_mas4_vert_sub_s16_1991 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, const orc_int16 * ORC_RESTRICT s3, const orc_int16 * ORC_RESTRICT s4, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_vert_sub_s16_1991;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_horiz_sub_s16_1991_ip */
#ifdef DISABLE_ORC
void
orc_mas4_horiz_sub_s16_1991_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 3: loadpw */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var37.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var40 = ptr4[i + 1];
    /* 1: loadoffw */
    var41 = ptr4[i + 2];
    /* 2: addw */
    var42.i = var40.i + var41.i;
    /* 4: mulswl */
    var43.i = var42.i * var36.i;
    /* 5: loadw */
    var44 = ptr4[i];
    /* 6: loadoffw */
    var45 = ptr4[i + 3];
    /* 7: addw */
    var46.i = var44.i + var45.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var43.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var37.i;
    /* 12: shrsl */
    var50.i = var49.i >> p2;
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var38 = ptr0[i];
    /* 15: subw */
    var39.i = var38.i - var51.i;
    /* 16: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas4_horiz_sub_s16_1991_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 3: loadpw */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 10: loadpl */
    var37.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var40 = ptr4[i + 1];
    /* 1: loadoffw */
    var41 = ptr4[i + 2];
    /* 2: addw */
    var42.i = var40.i + var41.i;
    /* 4: mulswl */
    var43.i = var42.i * var36.i;
    /* 5: loadw */
    var44 = ptr4[i];
    /* 6: loadoffw */
    var45 = ptr4[i + 3];
    /* 7: addw */
    var46.i = var44.i + var45.i;
    /* 8: convswl */
    var47.i = var46.i;
    /* 9: subl */
    var48.i = var43.i - var47.i;
    /* 11: addl */
    var49.i = var48.i + var37.i;
    /* 12: shrsl */
    var50.i = var49.i >> ex->params[25];
    /* 13: convlw */
    var51.i = var50.i;
    /* 14: loadw */
    var38 = ptr0[i];
    /* 15: subw */
    var39.i = var38.i - var51.i;
    /* 16: storew */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas4_horiz_sub_s16_1991_ip;
void
orc_mas4_horiz_sub_s16_1991_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_horiz_sub_s16_1991_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_subtract_s16 */
#ifdef DISABLE_ORC
void
orc_subtract_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_subtract_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_subtract_s16;
void
orc_subtract_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_subtract_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_s16_u8 */
#ifdef DISABLE_ORC
void
orc_add_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr5[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr4[i];
    /* 3: addw */
    var35.i = var36.i + var34.i;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add_s16_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr5[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr4[i];
    /* 3: addw */
    var35.i = var36.i + var34.i;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add_s16_u8;
void
orc_add_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_s16_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add_s16_u8_2d */
#ifdef DISABLE_ORC
void
orc_add_s16_u8_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: convubw */
      var36.i = (orc_uint8)var33;
      /* 2: loadw */
      var34 = ptr0[i];
      /* 3: addw */
      var35.i = var34.i + var36.i;
      /* 4: storew */
      ptr0[i] = var35;
    }
  }

}

#else
static void
_backup_orc_add_s16_u8_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: convubw */
      var36.i = (orc_uint8)var33;
      /* 2: loadw */
      var34 = ptr0[i];
      /* 3: addw */
      var35.i = var34.i + var36.i;
      /* 4: storew */
      ptr0[i] = var35;
    }
  }

}

OrcCode *_orc_code_orc_add_s16_u8_2d;
void
orc_add_s16_u8_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add_s16_u8_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_convert_s16_u8 */
#ifdef DISABLE_ORC
void
orc_convert_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: convubw */
    var33.i = (orc_uint8)var32;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_convert_s16_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: convubw */
    var33.i = (orc_uint8)var32;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_convert_s16_u8;
void
orc_convert_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_convert_s16_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_convert_s16_s32 */
#ifdef DISABLE_ORC
void
orc_convert_s16_s32 (orc_int16 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convlw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_convert_s16_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convlw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_convert_s16_s32;
void
orc_convert_s16_s32 (orc_int16 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_convert_s16_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_convert_u8_s16 */
#ifdef DISABLE_ORC
void
orc_convert_u8_s16 (orc_uint8 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convsuswb */
    var33 = ORC_CLAMP_UB(var32.i);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_convert_u8_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convsuswb */
    var33 = ORC_CLAMP_UB(var32.i);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_convert_u8_s16;
void
orc_convert_u8_s16 (orc_uint8 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_convert_u8_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_convert_s32_s16 */
#ifdef DISABLE_ORC
void
orc_convert_s32_s16 (orc_int32 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convswl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_convert_s32_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convswl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_convert_s32_s16;
void
orc_convert_s32_s16 (orc_int32 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_convert_s32_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_offsetconvert_u8_s16 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_u8_s16 (orc_uint8 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: convsuswb */
    var35 = ORC_CLAMP_UB(var36.i);
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_offsetconvert_u8_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: convsuswb */
    var35 = ORC_CLAMP_UB(var36.i);
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_offsetconvert_u8_s16;
void
orc_offsetconvert_u8_s16 (orc_uint8 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_offsetconvert_u8_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_offsetconvert_u8_s32 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_u8_s32 (orc_uint8 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_int8 var36;
  orc_union32 var37;
  orc_union16 var38;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var35.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var37.i = var34.i + var35.i;
    /* 3: convsuslw */
    var38.i = ORC_CLAMP_UW(var37.i);
    /* 4: convsuswb */
    var36 = ORC_CLAMP_UB(var38.i);
    /* 5: storeb */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_offsetconvert_u8_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_int8 var36;
  orc_union32 var37;
  orc_union16 var38;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var35.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var37.i = var34.i + var35.i;
    /* 3: convsuslw */
    var38.i = ORC_CLAMP_UW(var37.i);
    /* 4: convsuswb */
    var36 = ORC_CLAMP_UB(var38.i);
    /* 5: storeb */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_offsetconvert_u8_s32;
void
orc_offsetconvert_u8_s32 (orc_uint8 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_offsetconvert_u8_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_offsetconvert_s16_u8 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: subw */
    var35.i = var36.i - var34.i;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_offsetconvert_s16_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: subw */
    var35.i = var36.i - var34.i;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_offsetconvert_s16_u8;
void
orc_offsetconvert_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_offsetconvert_s16_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_offsetconvert_s32_u8 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_s32_u8 (orc_int32 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: subw */
    var37.i = var36.i - var34.i;
    /* 4: convswl */
    var35.i = var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_offsetconvert_s32_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: subw */
    var37.i = var36.i - var34.i;
    /* 4: convswl */
    var35.i = var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_offsetconvert_s32_u8;
void
orc_offsetconvert_s32_u8 (orc_int32 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_offsetconvert_s32_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_offsetconvert_s32_s16 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_s32_s16 (orc_int32 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union32 var35;
  orc_union16 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: subw */
    var36.i = var33.i - var34.i;
    /* 3: convswl */
    var35.i = var36.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_offsetconvert_s32_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union32 var35;
  orc_union16 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var34.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: subw */
    var36.i = var33.i - var34.i;
    /* 3: convswl */
    var35.i = var36.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_offsetconvert_s32_s16;
void
orc_offsetconvert_s32_s16 (orc_int32 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_offsetconvert_s32_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_subtract_s16_u8 */
#ifdef DISABLE_ORC
void
orc_subtract_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr5[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr4[i];
    /* 3: subw */
    var35.i = var34.i - var36.i;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_subtract_s16_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr5[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr4[i];
    /* 3: subw */
    var35.i = var34.i - var36.i;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_subtract_s16_u8;
void
orc_subtract_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_subtract_s16_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_multiply_and_add_s16_u8 */
#ifdef DISABLE_ORC
void
orc_multiply_and_add_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr5[i];
    /* 1: convubw */
    var37.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr4[i];
    /* 3: mullw */
    var38.i = (var37.i * var34.i) & 0xffff;
    /* 4: loadw */
    var35 = ptr0[i];
    /* 5: addw */
    var36.i = var35.i + var38.i;
    /* 6: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_multiply_and_add_s16_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr5[i];
    /* 1: convubw */
    var37.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr4[i];
    /* 3: mullw */
    var38.i = (var37.i * var34.i) & 0xffff;
    /* 4: loadw */
    var35 = ptr0[i];
    /* 5: addw */
    var36.i = var35.i + var38.i;
    /* 6: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_multiply_and_add_s16_u8;
void
orc_multiply_and_add_s16_u8 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_multiply_and_add_s16_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_s16_ns */
#ifdef DISABLE_ORC
void
orc_splat_s16_ns (orc_int16 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)d1;

    /* 0: loadpw */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_splat_s16_ns (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 0: loadpw */
    var32.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: copyw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_splat_s16_ns;
void
orc_splat_s16_ns (orc_int16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_s16_ns;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_s32_ns */
#ifdef DISABLE_ORC
void
orc_splat_s32_ns (orc_int32 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;

    /* 0: loadpl */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_splat_s32_ns (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];

    /* 0: loadpl */
    var32.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_splat_s32_ns;
void
orc_splat_s32_ns (orc_int32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_s32_ns;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_s16_2d_4xn */
#ifdef DISABLE_ORC
void
orc_splat_s16_2d_4xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int m){
  int i;
  int j;
  int n = 4;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 0: loadpw */
        var32.i = p1;

    for (i = 0; i < n; i++) {
      /* 1: copyw */
      var33.i = var32.i;
      /* 2: storew */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_orc_splat_s16_2d_4xn (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 4;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 0: loadpw */
        var32.i = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 1: copyw */
      var33.i = var32.i;
      /* 2: storew */
      ptr0[i] = var33;
    }
  }

}

OrcCode *_orc_code_orc_splat_s16_2d_4xn;
void
orc_splat_s16_2d_4xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_s16_2d_4xn;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 4;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_s16_2d_8xn */
#ifdef DISABLE_ORC
void
orc_splat_s16_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int m){
  int i;
  int j;
  int n = 8;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 0: loadpw */
        var32.i = p1;

    for (i = 0; i < n; i++) {
      /* 1: copyw */
      var33.i = var32.i;
      /* 2: storew */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_orc_splat_s16_2d_8xn (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 0: loadpw */
        var32.i = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 1: copyw */
      var33.i = var32.i;
      /* 2: storew */
      ptr0[i] = var33;
    }
  }

}

OrcCode *_orc_code_orc_splat_s16_2d_8xn;
void
orc_splat_s16_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_s16_2d_8xn;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_s16_2d */
#ifdef DISABLE_ORC
void
orc_splat_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 0: loadpw */
        var32.i = p1;

    for (i = 0; i < n; i++) {
      /* 1: copyw */
      var33.i = var32.i;
      /* 2: storew */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_orc_splat_s16_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;
  orc_union16 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 0: loadpw */
        var32.i = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 1: copyw */
      var33.i = var32.i;
      /* 2: storew */
      ptr0[i] = var33;
    }
  }

}

OrcCode *_orc_code_orc_splat_s16_2d;
void
orc_splat_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_s16_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_u8_ns */
#ifdef DISABLE_ORC
void
orc_splat_u8_ns (orc_uint8 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)d1;

    /* 0: loadpb */
    var32 = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyb */
    var33 = var32;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_splat_u8_ns (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->arrays[0];

    /* 0: loadpb */
    var32 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: copyb */
    var33 = var32;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_splat_u8_ns;
void
orc_splat_u8_ns (orc_uint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_u8_ns;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_u8_2d */
#ifdef DISABLE_ORC
void
orc_splat_u8_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 0: loadpb */
        var32 = p1;

    for (i = 0; i < n; i++) {
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_orc_splat_u8_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 0: loadpb */
        var32 = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

OrcCode *_orc_code_orc_splat_u8_2d;
void
orc_splat_u8_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_u8_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_average_u8 */
#ifdef DISABLE_ORC
void
orc_average_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_average_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_average_u8;
void
orc_average_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_average_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_rrshift6_add_s16_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_add_s16_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, const orc_int16 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

      /* 1: loadpw */
        var34.i = (int)0x00000020; /* 32 or 1.58101e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var33 = ptr5[i];
      /* 2: addw */
      var37.i = var33.i + var34.i;
      /* 3: shrsw */
      var38.i = var37.i >> 6;
      /* 4: loadw */
      var35 = ptr4[i];
      /* 5: addw */
      var39.i = var35.i + var38.i;
      /* 6: convsuswb */
      var36 = ORC_CLAMP_UB(var39.i);
      /* 7: storeb */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_orc_rrshift6_add_s16_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

      /* 1: loadpw */
        var34.i = (int)0x00000020; /* 32 or 1.58101e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var33 = ptr5[i];
      /* 2: addw */
      var37.i = var33.i + var34.i;
      /* 3: shrsw */
      var38.i = var37.i >> 6;
      /* 4: loadw */
      var35 = ptr4[i];
      /* 5: addw */
      var39.i = var35.i + var38.i;
      /* 6: convsuswb */
      var36 = ORC_CLAMP_UB(var39.i);
      /* 7: storeb */
      ptr0[i] = var36;
    }
  }

}

OrcCode *_orc_code_orc_rrshift6_add_s16_2d;
void
orc_rrshift6_add_s16_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, const orc_int16 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_rrshift6_add_s16_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_rrshift6_add_s32_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_add_s32_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_int32 * ORC_RESTRICT s1, int s1_stride, const orc_int16 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union32 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

      /* 1: loadpw */
        var35.i = (int)0x00000020; /* 32 or 1.58101e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr5[i];
      /* 2: addw */
      var38.i = var34.i + var35.i;
      /* 3: shrsw */
      var39.i = var38.i >> 6;
      /* 4: loadl */
      var36 = ptr4[i];
      /* 5: convlw */
      var40.i = var36.i;
      /* 6: addw */
      var41.i = var40.i + var39.i;
      /* 7: convsuswb */
      var37 = ORC_CLAMP_UB(var41.i);
      /* 8: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_rrshift6_add_s32_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union32 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

      /* 1: loadpw */
        var35.i = (int)0x00000020; /* 32 or 1.58101e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr5[i];
      /* 2: addw */
      var38.i = var34.i + var35.i;
      /* 3: shrsw */
      var39.i = var38.i >> 6;
      /* 4: loadl */
      var36 = ptr4[i];
      /* 5: convlw */
      var40.i = var36.i;
      /* 6: addw */
      var41.i = var40.i + var39.i;
      /* 7: convsuswb */
      var37 = ORC_CLAMP_UB(var41.i);
      /* 8: storeb */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_rrshift6_add_s32_2d;
void
orc_rrshift6_add_s32_2d (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_int32 * ORC_RESTRICT s1, int s1_stride, const orc_int16 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_rrshift6_add_s32_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_rrshift6_sub_s16_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_sub_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, orc_int16 * ORC_RESTRICT d2, int d2_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);

      /* 1: loadpw */
        var34.i = (int)0x00001fe0; /* 8160 or 4.03158e-320f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var33 = ptr1[i];
      /* 2: subw */
      var38.i = var33.i - var34.i;
      /* 3: shrsw */
      var39.i = var38.i >> 6;
      /* 4: copyw */
      var35.i = var39.i;
      /* 5: storew */
      ptr1[i] = var35;
      /* 6: loadw */
      var36 = ptr0[i];
      /* 7: subw */
      var37.i = var36.i - var39.i;
      /* 8: storew */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_rrshift6_sub_s16_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);

      /* 1: loadpw */
        var34.i = (int)0x00001fe0; /* 8160 or 4.03158e-320f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var33 = ptr1[i];
      /* 2: subw */
      var38.i = var33.i - var34.i;
      /* 3: shrsw */
      var39.i = var38.i >> 6;
      /* 4: copyw */
      var35.i = var39.i;
      /* 5: storew */
      ptr1[i] = var35;
      /* 6: loadw */
      var36 = ptr0[i];
      /* 7: subw */
      var37.i = var36.i - var39.i;
      /* 8: storew */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_rrshift6_sub_s16_2d;
void
orc_rrshift6_sub_s16_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, orc_int16 * ORC_RESTRICT d2, int d2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_rrshift6_sub_s16_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_rrshift6_s16_ip_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_s16_ip_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 1: loadpw */
        var34.i = (int)0x00001fe0; /* 8160 or 4.03158e-320f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var33 = ptr0[i];
      /* 2: subw */
      var36.i = var33.i - var34.i;
      /* 3: shrsw */
      var35.i = var36.i >> 6;
      /* 4: storew */
      ptr0[i] = var35;
    }
  }

}

#else
static void
_backup_orc_rrshift6_s16_ip_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 1: loadpw */
        var34.i = (int)0x00001fe0; /* 8160 or 4.03158e-320f */

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var33 = ptr0[i];
      /* 2: subw */
      var36.i = var33.i - var34.i;
      /* 3: shrsw */
      var35.i = var36.i >> 6;
      /* 4: storew */
      ptr0[i] = var35;
    }
  }

}

OrcCode *_orc_code_orc_rrshift6_s16_ip_2d;
void
orc_rrshift6_s16_ip_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_rrshift6_s16_ip_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_rrshift6_s16_ip */
#ifdef DISABLE_ORC
void
orc_rrshift6_s16_ip (orc_int16 * ORC_RESTRICT d1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;

    /* 1: loadpw */
    var34.i = (int)0x00001fe0; /* 8160 or 4.03158e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: subw */
    var36.i = var33.i - var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> 6;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_rrshift6_s16_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 1: loadpw */
    var34.i = (int)0x00001fe0; /* 8160 or 4.03158e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: subw */
    var36.i = var33.i - var34.i;
    /* 3: shrsw */
    var35.i = var36.i >> 6;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_rrshift6_s16_ip;
void
orc_rrshift6_s16_ip (orc_int16 * ORC_RESTRICT d1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_rrshift6_s16_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_unpack_yuyv_y */
#ifdef DISABLE_ORC
void
orc_unpack_yuyv_y (orc_uint8 * ORC_RESTRICT d1, const orc_uint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: select0wb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[0];
    }
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_unpack_yuyv_y (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: select0wb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[0];
    }
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_unpack_yuyv_y;
void
orc_unpack_yuyv_y (orc_uint8 * ORC_RESTRICT d1, const orc_uint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_unpack_yuyv_y;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_unpack_yuyv_u */
#ifdef DISABLE_ORC
void
orc_unpack_yuyv_u (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_unpack_yuyv_u (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_unpack_yuyv_u;
void
orc_unpack_yuyv_u (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_unpack_yuyv_u;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_unpack_yuyv_v */
#ifdef DISABLE_ORC
void
orc_unpack_yuyv_v (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select1lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[1];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_unpack_yuyv_v (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select1lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[1];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_unpack_yuyv_v;
void
orc_unpack_yuyv_v (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_unpack_yuyv_v;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_packyuyv */
#ifdef DISABLE_ORC
void
orc_packyuyv (orc_uint32 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_union16 var37;
  orc_int8 var38;
  orc_int8 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: copyw */
    var41.i = var37.i;
    /* 2: select0wb */
    {
       orc_union16 _src;
       _src.i = var41.i;
       var42 = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var41.i;
       var43 = _src.x2[1];
    }
    /* 4: loadb */
    var38 = ptr5[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var42;
       _dest.x2[1] = var38;
       var44.i = _dest.i;
    }
    /* 6: loadb */
    var39 = ptr6[i];
    /* 7: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var43;
       _dest.x2[1] = var39;
       var45.i = _dest.i;
    }
    /* 8: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var45.i;
       var40.i = _dest.i;
    }
    /* 9: storel */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_orc_packyuyv (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_union16 var37;
  orc_int8 var38;
  orc_int8 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: copyw */
    var41.i = var37.i;
    /* 2: select0wb */
    {
       orc_union16 _src;
       _src.i = var41.i;
       var42 = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var41.i;
       var43 = _src.x2[1];
    }
    /* 4: loadb */
    var38 = ptr5[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var42;
       _dest.x2[1] = var38;
       var44.i = _dest.i;
    }
    /* 6: loadb */
    var39 = ptr6[i];
    /* 7: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var43;
       _dest.x2[1] = var39;
       var45.i = _dest.i;
    }
    /* 8: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var45.i;
       var40.i = _dest.i;
    }
    /* 9: storel */
    ptr0[i] = var40;
  }

}

OrcCode *_orc_code_orc_packyuyv;
void
orc_packyuyv (orc_uint32 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_packyuyv;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_unpack_uyvy_y */
#ifdef DISABLE_ORC
void
orc_unpack_uyvy_y (orc_uint8 * ORC_RESTRICT d1, const orc_uint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: select1wb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[1];
    }
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_orc_unpack_uyvy_y (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: select1wb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[1];
    }
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

OrcCode *_orc_code_orc_unpack_uyvy_y;
void
orc_unpack_uyvy_y (orc_uint8 * ORC_RESTRICT d1, const orc_uint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_unpack_uyvy_y;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_unpack_uyvy_u */
#ifdef DISABLE_ORC
void
orc_unpack_uyvy_u (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select0wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[0];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_unpack_uyvy_u (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select0wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[0];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_unpack_uyvy_u;
void
orc_unpack_uyvy_u (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_unpack_uyvy_u;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_unpack_uyvy_v */
#ifdef DISABLE_ORC
void
orc_unpack_uyvy_v (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select1lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[1];
    }
    /* 2: select0wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[0];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_unpack_uyvy_v (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select1lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[1];
    }
    /* 2: select0wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[0];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_unpack_uyvy_v;
void
orc_unpack_uyvy_v (orc_uint8 * ORC_RESTRICT d1, const orc_uint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_unpack_uyvy_v;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_interleave2_s16 */
#ifdef DISABLE_ORC
void
orc_interleave2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var32.i;
       _dest.x2[1] = var33.i;
       var34.i = _dest.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_interleave2_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var32.i;
       _dest.x2[1] = var33.i;
       var34.i = _dest.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_interleave2_s16;
void
orc_interleave2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_interleave2_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_interleave2_rrshift1_s16 */
#ifdef DISABLE_ORC
void
orc_interleave2_rrshift1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 1: loadpw */
    var35.i = (int)0x00000001; /* 1 or 4.94066e-324f */
    /* 5: loadpw */
    var37.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 2: addw */
    var39.i = var34.i + var35.i;
    /* 3: shrsw */
    var40.i = var39.i >> 1;
    /* 4: loadw */
    var36 = ptr5[i];
    /* 6: addw */
    var41.i = var36.i + var37.i;
    /* 7: shrsw */
    var42.i = var41.i >> 1;
    /* 8: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var42.i;
       var38.i = _dest.i;
    }
    /* 9: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_interleave2_rrshift1_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 1: loadpw */
    var35.i = (int)0x00000001; /* 1 or 4.94066e-324f */
    /* 5: loadpw */
    var37.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 2: addw */
    var39.i = var34.i + var35.i;
    /* 3: shrsw */
    var40.i = var39.i >> 1;
    /* 4: loadw */
    var36 = ptr5[i];
    /* 6: addw */
    var41.i = var36.i + var37.i;
    /* 7: shrsw */
    var42.i = var41.i >> 1;
    /* 8: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var42.i;
       var38.i = _dest.i;
    }
    /* 9: storel */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_interleave2_rrshift1_s16;
void
orc_interleave2_rrshift1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_interleave2_rrshift1_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_deinterleave2_s16 */
#ifdef DISABLE_ORC
void
orc_deinterleave2_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
       var34.i = _src.x2[0];
    }
    /* 2: storew */
    ptr1[i] = var33;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_deinterleave2_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
       var34.i = _src.x2[0];
    }
    /* 2: storew */
    ptr1[i] = var33;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_deinterleave2_s16;
void
orc_deinterleave2_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_deinterleave2_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_deinterleave2_s32 */
#ifdef DISABLE_ORC
void
orc_deinterleave2_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
       var34.i = _src.x2[0];
    }
    /* 2: storel */
    ptr1[i] = var33;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_deinterleave2_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
       var34.i = _src.x2[0];
    }
    /* 2: storel */
    ptr1[i] = var33;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_deinterleave2_s32;
void
orc_deinterleave2_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_deinterleave2_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_deinterleave2_lshift1_s16 */
#ifdef DISABLE_ORC
void
orc_deinterleave2_lshift1_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shlw */
    var36.x2[0] = var33.x2[0] << 1;
    var36.x2[1] = var33.x2[1] << 1;
    /* 2: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.i;
       var34.i = _src.x2[1];
       var35.i = _src.x2[0];
    }
    /* 3: storew */
    ptr1[i] = var34;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_deinterleave2_lshift1_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: shlw */
    var36.x2[0] = var33.x2[0] << 1;
    var36.x2[1] = var33.x2[1] << 1;
    /* 2: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.i;
       var34.i = _src.x2[1];
       var35.i = _src.x2[0];
    }
    /* 3: storew */
    ptr1[i] = var34;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_deinterleave2_lshift1_s16;
void
orc_deinterleave2_lshift1_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_deinterleave2_lshift1_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_deinterleave2_lshift1_s32 */
#ifdef DISABLE_ORC
void
orc_deinterleave2_lshift1_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: shll */
    var36.x2[0] = var33.x2[0] << 1;
    var36.x2[1] = var33.x2[1] << 1;
    /* 2: splitql */
    {
       orc_union64 _src;
       _src.i = var36.i;
       var34.i = _src.x2[1];
       var35.i = _src.x2[0];
    }
    /* 3: storel */
    ptr1[i] = var34;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_deinterleave2_lshift1_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: shll */
    var36.x2[0] = var33.x2[0] << 1;
    var36.x2[1] = var33.x2[1] << 1;
    /* 2: splitql */
    {
       orc_union64 _src;
       _src.i = var36.i;
       var34.i = _src.x2[1];
       var35.i = _src.x2[0];
    }
    /* 3: storel */
    ptr1[i] = var34;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_deinterleave2_lshift1_s32;
void
orc_deinterleave2_lshift1_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_deinterleave2_lshift1_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_deint_lshift1_split_s16 */
#ifdef DISABLE_ORC
void
orc_haar_deint_lshift1_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union32 *)s1;

    /* 6: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: shlw */
    var39.x2[0] = var35.x2[0] << 1;
    var39.x2[1] = var35.x2[1] << 1;
    /* 2: splitlw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var40.i = _src.x2[1];
       var41.i = _src.x2[0];
    }
    /* 3: subw */
    var42.i = var40.i - var41.i;
    /* 4: copyw */
    var36.i = var42.i;
    /* 5: storew */
    ptr1[i] = var36;
    /* 7: avgsw */
    var43.i = (var42.i + var37.i + 1)>>1;
    /* 8: addw */
    var38.i = var41.i + var43.i;
    /* 9: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_haar_deint_lshift1_split_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 6: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: shlw */
    var39.x2[0] = var35.x2[0] << 1;
    var39.x2[1] = var35.x2[1] << 1;
    /* 2: splitlw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var40.i = _src.x2[1];
       var41.i = _src.x2[0];
    }
    /* 3: subw */
    var42.i = var40.i - var41.i;
    /* 4: copyw */
    var36.i = var42.i;
    /* 5: storew */
    ptr1[i] = var36;
    /* 7: avgsw */
    var43.i = (var42.i + var37.i + 1)>>1;
    /* 8: addw */
    var38.i = var41.i + var43.i;
    /* 9: storew */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_haar_deint_lshift1_split_s16;
void
orc_haar_deint_lshift1_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_deint_lshift1_split_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_deint_lshift1_split_s32 */
#ifdef DISABLE_ORC
void
orc_haar_deint_lshift1_split_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union64 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union64 *)s1;

    /* 6: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: shll */
    var39.x2[0] = var35.x2[0] << 1;
    var39.x2[1] = var35.x2[1] << 1;
    /* 2: splitql */
    {
       orc_union64 _src;
       _src.i = var39.i;
       var40.i = _src.x2[1];
       var41.i = _src.x2[0];
    }
    /* 3: subl */
    var42.i = var40.i - var41.i;
    /* 4: copyl */
    var36.i = var42.i;
    /* 5: storel */
    ptr1[i] = var36;
    /* 7: avgsl */
    var43.i = ((orc_int64)var42.i + (orc_int64)var37.i + 1)>>1;
    /* 8: addl */
    var38.i = var41.i + var43.i;
    /* 9: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_haar_deint_lshift1_split_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union64 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];

    /* 6: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: shll */
    var39.x2[0] = var35.x2[0] << 1;
    var39.x2[1] = var35.x2[1] << 1;
    /* 2: splitql */
    {
       orc_union64 _src;
       _src.i = var39.i;
       var40.i = _src.x2[1];
       var41.i = _src.x2[0];
    }
    /* 3: subl */
    var42.i = var40.i - var41.i;
    /* 4: copyl */
    var36.i = var42.i;
    /* 5: storel */
    ptr1[i] = var36;
    /* 7: avgsl */
    var43.i = ((orc_int64)var42.i + (orc_int64)var37.i + 1)>>1;
    /* 8: addl */
    var38.i = var41.i + var43.i;
    /* 9: storel */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_haar_deint_lshift1_split_s32;
void
orc_haar_deint_lshift1_split_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_deint_lshift1_split_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_deint_split_s16 */
#ifdef DISABLE_ORC
void
orc_haar_deint_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union32 *)s1;

    /* 5: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: subw */
    var40.i = var38.i - var39.i;
    /* 3: copyw */
    var35.i = var40.i;
    /* 4: storew */
    ptr1[i] = var35;
    /* 6: avgsw */
    var41.i = (var40.i + var36.i + 1)>>1;
    /* 7: addw */
    var37.i = var39.i + var41.i;
    /* 8: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_haar_deint_split_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 5: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: subw */
    var40.i = var38.i - var39.i;
    /* 3: copyw */
    var35.i = var40.i;
    /* 4: storew */
    ptr1[i] = var35;
    /* 6: avgsw */
    var41.i = (var40.i + var36.i + 1)>>1;
    /* 7: addw */
    var37.i = var39.i + var41.i;
    /* 8: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_haar_deint_split_s16;
void
orc_haar_deint_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_deint_split_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_deint_split_s32 */
#ifdef DISABLE_ORC
void
orc_haar_deint_split_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union32 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var36;
#else
  orc_union32 var36;
#endif
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union64 *)s1;

    /* 5: loadpl */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: subl */
    var40.i = var38.i - var39.i;
    /* 3: copyl */
    var35.i = var40.i;
    /* 4: storel */
    ptr1[i] = var35;
    /* 6: avgsl */
    var41.i = ((orc_int64)var40.i + (orc_int64)var36.i + 1)>>1;
    /* 7: addl */
    var37.i = var39.i + var41.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_haar_deint_split_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union32 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var36;
#else
  orc_union32 var36;
#endif
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];

    /* 5: loadpl */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: subl */
    var40.i = var38.i - var39.i;
    /* 3: copyl */
    var35.i = var40.i;
    /* 4: storel */
    ptr1[i] = var35;
    /* 6: avgsl */
    var41.i = ((orc_int64)var40.i + (orc_int64)var36.i + 1)>>1;
    /* 7: addl */
    var37.i = var39.i + var41.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_haar_deint_split_s32;
void
orc_haar_deint_split_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_deint_split_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_split_s16_lo */
#ifdef DISABLE_ORC
void
orc_haar_split_s16_lo (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 4: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: loadw */
    var35 = ptr5[i];
    /* 3: subw */
    var39.i = var35.i - var38.i;
    /* 5: avgsw */
    var40.i = (var39.i + var36.i + 1)>>1;
    /* 6: addw */
    var37.i = var38.i + var40.i;
    /* 7: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_haar_split_s16_lo (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 4: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: loadw */
    var35 = ptr5[i];
    /* 3: subw */
    var39.i = var35.i - var38.i;
    /* 5: avgsw */
    var40.i = (var39.i + var36.i + 1)>>1;
    /* 6: addw */
    var37.i = var38.i + var40.i;
    /* 7: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_haar_split_s16_lo;
void
orc_haar_split_s16_lo (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_split_s16_lo;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_split_s16_hi */
#ifdef DISABLE_ORC
void
orc_haar_split_s16_hi (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr5[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_haar_split_s16_hi (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr5[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_haar_split_s16_hi;
void
orc_haar_split_s16_hi (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_split_s16_hi;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_split_s16_op */
#ifdef DISABLE_ORC
void
orc_haar_split_s16_op (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 6: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var39.i = var34.i;
    /* 2: loadw */
    var35 = ptr5[i];
    /* 3: subw */
    var40.i = var35.i - var39.i;
    /* 4: copyw */
    var36.i = var40.i;
    /* 5: storew */
    ptr1[i] = var36;
    /* 7: avgsw */
    var41.i = (var40.i + var37.i + 1)>>1;
    /* 8: addw */
    var38.i = var39.i + var41.i;
    /* 9: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_haar_split_s16_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 6: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var39.i = var34.i;
    /* 2: loadw */
    var35 = ptr5[i];
    /* 3: subw */
    var40.i = var35.i - var39.i;
    /* 4: copyw */
    var36.i = var40.i;
    /* 5: storew */
    ptr1[i] = var36;
    /* 7: avgsw */
    var41.i = (var40.i + var37.i + 1)>>1;
    /* 8: addw */
    var38.i = var39.i + var41.i;
    /* 9: storew */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_haar_split_s16_op;
void
orc_haar_split_s16_op (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_split_s16_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_split_s32_op */
#ifdef DISABLE_ORC
void
orc_haar_split_s32_op (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 6: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: copyl */
    var39.i = var34.i;
    /* 2: loadl */
    var35 = ptr5[i];
    /* 3: subl */
    var40.i = var35.i - var39.i;
    /* 4: copyl */
    var36.i = var40.i;
    /* 5: storel */
    ptr1[i] = var36;
    /* 7: avgsl */
    var41.i = ((orc_int64)var40.i + (orc_int64)var37.i + 1)>>1;
    /* 8: addl */
    var38.i = var39.i + var41.i;
    /* 9: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_haar_split_s32_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 6: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: copyl */
    var39.i = var34.i;
    /* 2: loadl */
    var35 = ptr5[i];
    /* 3: subl */
    var40.i = var35.i - var39.i;
    /* 4: copyl */
    var36.i = var40.i;
    /* 5: storel */
    ptr1[i] = var36;
    /* 7: avgsl */
    var41.i = ((orc_int64)var40.i + (orc_int64)var37.i + 1)>>1;
    /* 8: addl */
    var38.i = var39.i + var41.i;
    /* 9: storel */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_haar_split_s32_op;
void
orc_haar_split_s32_op (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_split_s32_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_split_s16 */
#ifdef DISABLE_ORC
void
orc_haar_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;

    /* 7: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: copyw */
    var39.i = var34.i;
    /* 2: loadw */
    var35 = ptr1[i];
    /* 3: copyw */
    var40.i = var35.i;
    /* 4: subw */
    var41.i = var40.i - var39.i;
    /* 5: copyw */
    var36.i = var41.i;
    /* 6: storew */
    ptr1[i] = var36;
    /* 8: avgsw */
    var42.i = (var41.i + var37.i + 1)>>1;
    /* 9: addw */
    var38.i = var39.i + var42.i;
    /* 10: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_haar_split_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];

    /* 7: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: copyw */
    var39.i = var34.i;
    /* 2: loadw */
    var35 = ptr1[i];
    /* 3: copyw */
    var40.i = var35.i;
    /* 4: subw */
    var41.i = var40.i - var39.i;
    /* 5: copyw */
    var36.i = var41.i;
    /* 6: storew */
    ptr1[i] = var36;
    /* 8: avgsw */
    var42.i = (var41.i + var37.i + 1)>>1;
    /* 9: addw */
    var38.i = var39.i + var42.i;
    /* 10: storew */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_haar_split_s16;
void
orc_haar_split_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_split_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_s16_lo */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16_lo (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 1: loadpw */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr5[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: subw */
    var36.i = var35.i - var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_haar_synth_s16_lo (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 1: loadpw */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr5[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: subw */
    var36.i = var35.i - var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_haar_synth_s16_lo;
void
orc_haar_synth_s16_lo (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_s16_lo;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_s16_hi */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16_hi (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 2: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: copyw */
    var39.i = var35.i;
    /* 3: avgsw */
    var40.i = (var39.i + var36.i + 1)>>1;
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: subw */
    var41.i = var37.i - var40.i;
    /* 6: addw */
    var38.i = var39.i + var41.i;
    /* 7: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_haar_synth_s16_hi (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 2: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: copyw */
    var39.i = var35.i;
    /* 3: avgsw */
    var40.i = (var39.i + var36.i + 1)>>1;
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: subw */
    var41.i = var37.i - var40.i;
    /* 6: addw */
    var38.i = var39.i + var41.i;
    /* 7: storew */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_haar_synth_s16_hi;
void
orc_haar_synth_s16_hi (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_s16_hi;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_s16_op */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16_op (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 2: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: copyw */
    var40.i = var35.i;
    /* 3: avgsw */
    var41.i = (var40.i + var36.i + 1)>>1;
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: subw */
    var42.i = var37.i - var41.i;
    /* 6: copyw */
    var38.i = var42.i;
    /* 7: storew */
    ptr0[i] = var38;
    /* 8: addw */
    var39.i = var40.i + var42.i;
    /* 9: storew */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_orc_haar_synth_s16_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 2: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: copyw */
    var40.i = var35.i;
    /* 3: avgsw */
    var41.i = (var40.i + var36.i + 1)>>1;
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: subw */
    var42.i = var37.i - var41.i;
    /* 6: copyw */
    var38.i = var42.i;
    /* 7: storew */
    ptr0[i] = var38;
    /* 8: addw */
    var39.i = var40.i + var42.i;
    /* 9: storew */
    ptr1[i] = var39;
  }

}

OrcCode *_orc_code_orc_haar_synth_s16_op;
void
orc_haar_synth_s16_op (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_s16_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_s16 */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;

    /* 4: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr0[i];
    /* 1: copyw */
    var40.i = var35.i;
    /* 2: loadw */
    var36 = ptr1[i];
    /* 3: copyw */
    var41.i = var36.i;
    /* 5: avgsw */
    var42.i = (var41.i + var37.i + 1)>>1;
    /* 6: subw */
    var43.i = var40.i - var42.i;
    /* 7: copyw */
    var38.i = var43.i;
    /* 8: storew */
    ptr0[i] = var38;
    /* 9: addw */
    var39.i = var41.i + var43.i;
    /* 10: storew */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_orc_haar_synth_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var35;
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];

    /* 4: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr0[i];
    /* 1: copyw */
    var40.i = var35.i;
    /* 2: loadw */
    var36 = ptr1[i];
    /* 3: copyw */
    var41.i = var36.i;
    /* 5: avgsw */
    var42.i = (var41.i + var37.i + 1)>>1;
    /* 6: subw */
    var43.i = var40.i - var42.i;
    /* 7: copyw */
    var38.i = var43.i;
    /* 8: storew */
    ptr0[i] = var38;
    /* 9: addw */
    var39.i = var41.i + var43.i;
    /* 10: storew */
    ptr1[i] = var39;
  }

}

OrcCode *_orc_code_orc_haar_synth_s16;
void
orc_haar_synth_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_rrshift1_int_s16 */
#ifdef DISABLE_ORC
void
orc_haar_synth_rrshift1_int_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 2: loadpw */
    var35.i = (int)0x00000000; /* 0 or 0f */
    /* 7: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */
    /* 9: loadpw */
    var38.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: copyw */
    var40.i = var34.i;
    /* 3: avgsw */
    var41.i = (var40.i + var35.i + 1)>>1;
    /* 4: loadw */
    var36 = ptr4[i];
    /* 5: subw */
    var42.i = var36.i - var41.i;
    /* 6: addw */
    var43.i = var40.i + var42.i;
    /* 8: avgsw */
    var44.i = (var42.i + var37.i + 1)>>1;
    /* 10: avgsw */
    var45.i = (var43.i + var38.i + 1)>>1;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var45.i;
       var39.i = _dest.i;
    }
    /* 12: storel */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_haar_synth_rrshift1_int_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 2: loadpw */
    var35.i = (int)0x00000000; /* 0 or 0f */
    /* 7: loadpw */
    var37.i = (int)0x00000000; /* 0 or 0f */
    /* 9: loadpw */
    var38.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: copyw */
    var40.i = var34.i;
    /* 3: avgsw */
    var41.i = (var40.i + var35.i + 1)>>1;
    /* 4: loadw */
    var36 = ptr4[i];
    /* 5: subw */
    var42.i = var36.i - var41.i;
    /* 6: addw */
    var43.i = var40.i + var42.i;
    /* 8: avgsw */
    var44.i = (var42.i + var37.i + 1)>>1;
    /* 10: avgsw */
    var45.i = (var43.i + var38.i + 1)>>1;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var45.i;
       var39.i = _dest.i;
    }
    /* 12: storel */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_haar_synth_rrshift1_int_s16;
void
orc_haar_synth_rrshift1_int_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_rrshift1_int_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_int_s16 */
#ifdef DISABLE_ORC
void
orc_haar_synth_int_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 2: loadpw */
    var35.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 3: avgsw */
    var39.i = (var38.i + var35.i + 1)>>1;
    /* 4: loadw */
    var36 = ptr4[i];
    /* 5: subw */
    var40.i = var36.i - var39.i;
    /* 6: addw */
    var41.i = var38.i + var40.i;
    /* 7: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 8: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_haar_synth_int_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union16 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 2: loadpw */
    var35.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 3: avgsw */
    var39.i = (var38.i + var35.i + 1)>>1;
    /* 4: loadw */
    var36 = ptr4[i];
    /* 5: subw */
    var40.i = var36.i - var39.i;
    /* 6: addw */
    var41.i = var38.i + var40.i;
    /* 7: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 8: storel */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_haar_synth_int_s16;
void
orc_haar_synth_int_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_int_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_sub_s16 */
#ifdef DISABLE_ORC
void
orc_haar_sub_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_haar_sub_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_haar_sub_s16;
void
orc_haar_sub_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_sub_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_add_half_s16 */
#ifdef DISABLE_ORC
void
orc_haar_add_half_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: addw */
    var36.i = var35.i + var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_haar_add_half_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: addw */
    var36.i = var35.i + var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_haar_add_half_s16;
void
orc_haar_add_half_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_add_half_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_add_s16 */
#ifdef DISABLE_ORC
void
orc_haar_add_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var34.i = var32.i + var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_haar_add_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr0[i];
    /* 1: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var34.i = var32.i + var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_haar_add_s16;
void
orc_haar_add_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_add_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_sub_half_s16 */
#ifdef DISABLE_ORC
void
orc_haar_sub_half_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: subw */
    var36.i = var35.i - var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_haar_sub_half_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: avgsw */
    var37.i = (var33.i + var34.i + 1)>>1;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: subw */
    var36.i = var35.i - var37.i;
    /* 5: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_haar_sub_half_s16;
void
orc_haar_sub_half_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_sub_half_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_sum_u8 */
#ifdef DISABLE_ORC
void
orc_sum_u8 (orc_int32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int n){
  int i;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;

  ptr4 = (orc_int8 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var35.i = (orc_uint8)var34;
    /* 2: convuwl */
    var36.i = (orc_uint16)var35.i;
    /* 3: accl */
    var12.i = var12.i + var36.i;
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sum_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;

  ptr4 = (orc_int8 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var35.i = (orc_uint8)var34;
    /* 2: convuwl */
    var36.i = (orc_uint16)var35.i;
    /* 3: accl */
    var12.i = var12.i + var36.i;
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sum_u8;
void
orc_sum_u8 (orc_int32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sum_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sum_s16 */
#ifdef DISABLE_ORC
void
orc_sum_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union16 var33;
  orc_union32 var34;

  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convswl */
    var34.i = var33.i;
    /* 2: accl */
    var12.i = var12.i + var34.i;
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sum_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union16 var33;
  orc_union32 var34;

  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convswl */
    var34.i = var33.i;
    /* 2: accl */
    var12.i = var12.i + var34.i;
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sum_s16;
void
orc_sum_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sum_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sum_square_diff_u8 */
#ifdef DISABLE_ORC
void
orc_sum_square_diff_u8 (orc_int32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n){
  int i;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;

  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var37.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var38.i = (orc_uint8)var36;
    /* 4: subw */
    var39.i = var37.i - var38.i;
    /* 5: mullw */
    var40.i = (var39.i * var39.i) & 0xffff;
    /* 6: convuwl */
    var41.i = (orc_uint16)var40.i;
    /* 7: accl */
    var12.i = var12.i + var41.i;
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sum_square_diff_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;

  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var37.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var38.i = (orc_uint8)var36;
    /* 4: subw */
    var39.i = var37.i - var38.i;
    /* 5: mullw */
    var40.i = (var39.i * var39.i) & 0xffff;
    /* 6: convuwl */
    var41.i = (orc_uint16)var40.i;
    /* 7: accl */
    var12.i = var12.i + var41.i;
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sum_square_diff_u8;
void
orc_sum_square_diff_u8 (orc_int32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sum_square_diff_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_dequantise_s16_2d_4xn */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_2d_4xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int m){
  int i;
  int j;
  int n = 4;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 4: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var36.i = p2;

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_2d_4xn (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 4;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 4: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var36.i = ex->params[25];

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_dequantise_s16_2d_4xn;
void
orc_dequantise_s16_2d_4xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s16_2d_4xn;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 4;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_s16_2d_8xn */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int m){
  int i;
  int j;
  int n = 8;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 4: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var36.i = p2;

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_2d_8xn (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 4: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var36.i = ex->params[25];

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_dequantise_s16_2d_8xn;
void
orc_dequantise_s16_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, const orc_int16 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s16_2d_8xn;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_s16_ip_2d_8xn */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_ip_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int m){
  int i;
  int j;
  int n = 8;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 4: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var36.i = p2;

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr0[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_ip_2d_8xn (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 4: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var36.i = ex->params[25];

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr0[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_dequantise_s16_ip_2d_8xn;
void
orc_dequantise_s16_ip_2d_8xn (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s16_ip_2d_8xn;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_s16_ip_2d */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_ip_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 4: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var36.i = p2;

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr0[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_ip_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 4: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var36.i = ex->params[25];

    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr0[i];
      /* 1: copyw */
      var38.i = var34.i;
      /* 2: signw */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absw */
      var40.i = ORC_ABS(var38.i);
      /* 5: mullw */
      var41.i = (var40.i * var35.i) & 0xffff;
      /* 7: addw */
      var42.i = var41.i + var36.i;
      /* 8: shrsw */
      var43.i = var42.i >> 2;
      /* 9: mullw */
      var37.i = (var43.i * var39.i) & 0xffff;
      /* 10: storew */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_dequantise_s16_ip_2d;
void
orc_dequantise_s16_ip_2d (orc_int16 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s16_ip_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_s16_ip */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_ip (orc_int16 * ORC_RESTRICT d1, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;

    /* 4: loadpw */
    var35.i = p1;
    /* 6: loadpw */
    var36.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 5: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 7: addw */
    var42.i = var41.i + var36.i;
    /* 8: shrsw */
    var43.i = var42.i >> 2;
    /* 9: mullw */
    var37.i = (var43.i * var39.i) & 0xffff;
    /* 10: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_dequantise_s16_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 4: loadpw */
    var35.i = ex->params[24];
    /* 6: loadpw */
    var36.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 5: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 7: addw */
    var42.i = var41.i + var36.i;
    /* 8: shrsw */
    var43.i = var42.i >> 2;
    /* 9: mullw */
    var37.i = (var43.i * var39.i) & 0xffff;
    /* 10: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_dequantise_s16_ip;
void
orc_dequantise_s16_ip (orc_int16 * ORC_RESTRICT d1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s16_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_s16 */
#ifdef DISABLE_ORC
void
orc_dequantise_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 4: loadpw */
    var35.i = p1;
    /* 6: loadpw */
    var36.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 5: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 7: addw */
    var42.i = var41.i + var36.i;
    /* 8: shrsw */
    var43.i = var42.i >> 2;
    /* 9: mullw */
    var37.i = (var43.i * var39.i) & 0xffff;
    /* 10: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_dequantise_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 4: loadpw */
    var35.i = ex->params[24];
    /* 6: loadpw */
    var36.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 5: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 7: addw */
    var42.i = var41.i + var36.i;
    /* 8: shrsw */
    var43.i = var42.i >> 2;
    /* 9: mullw */
    var37.i = (var43.i * var39.i) & 0xffff;
    /* 10: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_dequantise_s16;
void
orc_dequantise_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_var_s16_ip */
#ifdef DISABLE_ORC
void
orc_dequantise_var_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 4: loadw */
    var35 = ptr4[i];
    /* 5: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 6: loadw */
    var36 = ptr5[i];
    /* 7: addw */
    var42.i = var41.i + var36.i;
    /* 8: shrsw */
    var43.i = var42.i >> 2;
    /* 9: mullw */
    var37.i = (var43.i * var39.i) & 0xffff;
    /* 10: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_dequantise_var_s16_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 4: loadw */
    var35 = ptr4[i];
    /* 5: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 6: loadw */
    var36 = ptr5[i];
    /* 7: addw */
    var42.i = var41.i + var36.i;
    /* 8: shrsw */
    var43.i = var42.i >> 2;
    /* 9: mullw */
    var37.i = (var43.i * var39.i) & 0xffff;
    /* 10: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_dequantise_var_s16_ip;
void
orc_dequantise_var_s16_ip (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, const orc_int16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_var_s16_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_quantise1_s16 */
#ifdef DISABLE_ORC
void
orc_quantise1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 5: loadpw */
    var35.i = p2;
    /* 7: loadpw */
    var36.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 4: shlw */
    var41.i = var40.i << 2;
    /* 6: subw */
    var42.i = var41.i - var35.i;
    /* 8: mulhuw */
    var43.i = ((orc_uint32)((orc_uint16)var42.i) * (orc_uint32)((orc_uint16)var36.i)) >> 16;
    /* 9: shruw */
    var44.i = ((orc_uint16)var43.i) >> p3;
    /* 10: mullw */
    var37.i = (var44.i * var39.i) & 0xffff;
    /* 11: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_quantise1_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 5: loadpw */
    var35.i = ex->params[25];
    /* 7: loadpw */
    var36.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var38.i = var34.i;
    /* 2: signw */
    var39.i = ORC_CLAMP(var38.i,-1,1);
    /* 3: absw */
    var40.i = ORC_ABS(var38.i);
    /* 4: shlw */
    var41.i = var40.i << 2;
    /* 6: subw */
    var42.i = var41.i - var35.i;
    /* 8: mulhuw */
    var43.i = ((orc_uint32)((orc_uint16)var42.i) * (orc_uint32)((orc_uint16)var36.i)) >> 16;
    /* 9: shruw */
    var44.i = ((orc_uint16)var43.i) >> ex->params[26];
    /* 10: mullw */
    var37.i = (var44.i * var39.i) & 0xffff;
    /* 11: storew */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_quantise1_s16;
void
orc_quantise1_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_quantise1_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_quantise2_s16 */
#ifdef DISABLE_ORC
void
orc_quantise2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 5: loadpw */
    var35.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var37.i = var34.i;
    /* 2: signw */
    var38.i = ORC_CLAMP(var37.i,-1,1);
    /* 3: absw */
    var39.i = ORC_ABS(var37.i);
    /* 4: shlw */
    var40.i = var39.i << 2;
    /* 6: subw */
    var41.i = var40.i - var35.i;
    /* 7: shruw */
    var42.i = ((orc_uint16)var41.i) >> p1;
    /* 8: mullw */
    var36.i = (var42.i * var38.i) & 0xffff;
    /* 9: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_quantise2_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 5: loadpw */
    var35.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: copyw */
    var37.i = var34.i;
    /* 2: signw */
    var38.i = ORC_CLAMP(var37.i,-1,1);
    /* 3: absw */
    var39.i = ORC_ABS(var37.i);
    /* 4: shlw */
    var40.i = var39.i << 2;
    /* 6: subw */
    var41.i = var40.i - var35.i;
    /* 7: shruw */
    var42.i = ((orc_uint16)var41.i) >> ex->params[24];
    /* 8: mullw */
    var36.i = (var42.i * var38.i) & 0xffff;
    /* 9: storew */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_quantise2_s16;
void
orc_quantise2_s16 (orc_int16 * ORC_RESTRICT d1, const orc_int16 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_quantise2_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_quantdequant1_s16 */
#ifdef DISABLE_ORC
void
orc_quantdequant1_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int p5, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;

    /* 5: loadpw */
    var35.i = p2;
    /* 7: loadpw */
    var36.i = p1;
    /* 14: loadpw */
    var38.i = p4;
    /* 16: loadpw */
    var39.i = p5;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr1[i];
    /* 1: copyw */
    var41.i = var34.i;
    /* 2: signw */
    var42.i = ORC_CLAMP(var41.i,-1,1);
    /* 3: absw */
    var43.i = ORC_ABS(var41.i);
    /* 4: shlw */
    var44.i = var43.i << 2;
    /* 6: subw */
    var45.i = var44.i - var35.i;
    /* 8: mulhuw */
    var46.i = ((orc_uint32)((orc_uint16)var45.i) * (orc_uint32)((orc_uint16)var36.i)) >> 16;
    /* 9: shruw */
    var47.i = ((orc_uint16)var46.i) >> p3;
    /* 10: mullw */
    var48.i = (var47.i * var42.i) & 0xffff;
    /* 11: copyw */
    var37.i = var48.i;
    /* 12: storew */
    ptr0[i] = var37;
    /* 13: signw */
    var49.i = ORC_CLAMP(var48.i,-1,1);
    /* 15: mullw */
    var50.i = (var47.i * var38.i) & 0xffff;
    /* 17: addw */
    var51.i = var50.i + var39.i;
    /* 18: shrsw */
    var52.i = var51.i >> 2;
    /* 19: mullw */
    var40.i = (var52.i * var49.i) & 0xffff;
    /* 20: storew */
    ptr1[i] = var40;
  }

}

#else
static void
_backup_orc_quantdequant1_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];

    /* 5: loadpw */
    var35.i = ex->params[25];
    /* 7: loadpw */
    var36.i = ex->params[24];
    /* 14: loadpw */
    var38.i = ex->params[27];
    /* 16: loadpw */
    var39.i = ex->params[28];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr1[i];
    /* 1: copyw */
    var41.i = var34.i;
    /* 2: signw */
    var42.i = ORC_CLAMP(var41.i,-1,1);
    /* 3: absw */
    var43.i = ORC_ABS(var41.i);
    /* 4: shlw */
    var44.i = var43.i << 2;
    /* 6: subw */
    var45.i = var44.i - var35.i;
    /* 8: mulhuw */
    var46.i = ((orc_uint32)((orc_uint16)var45.i) * (orc_uint32)((orc_uint16)var36.i)) >> 16;
    /* 9: shruw */
    var47.i = ((orc_uint16)var46.i) >> ex->params[26];
    /* 10: mullw */
    var48.i = (var47.i * var42.i) & 0xffff;
    /* 11: copyw */
    var37.i = var48.i;
    /* 12: storew */
    ptr0[i] = var37;
    /* 13: signw */
    var49.i = ORC_CLAMP(var48.i,-1,1);
    /* 15: mullw */
    var50.i = (var47.i * var38.i) & 0xffff;
    /* 17: addw */
    var51.i = var50.i + var39.i;
    /* 18: shrsw */
    var52.i = var51.i >> 2;
    /* 19: mullw */
    var40.i = (var52.i * var49.i) & 0xffff;
    /* 20: storew */
    ptr1[i] = var40;
  }

}

OrcCode *_orc_code_orc_quantdequant1_s16;
void
orc_quantdequant1_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int p5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_quantdequant1_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* orc_quantdequant3_s16 */
#ifdef DISABLE_ORC
void
orc_quantdequant3_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int p5, int p6, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;

    /* 5: loadpw */
    var36.i = p2;
    /* 7: loadpw */
    var37.i = p1;
    /* 9: loadpl */
    var38.i = p6;
    /* 17: loadpw */
    var40.i = p4;
    /* 19: loadpw */
    var41.i = p5;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr1[i];
    /* 1: copyw */
    var43.i = var35.i;
    /* 2: signw */
    var44.i = ORC_CLAMP(var43.i,-1,1);
    /* 3: absw */
    var45.i = ORC_ABS(var43.i);
    /* 4: shlw */
    var46.i = var45.i << 2;
    /* 6: subw */
    var47.i = var46.i - var36.i;
    /* 8: muluwl */
    var48.i = ((orc_uint16)var47.i) * ((orc_uint16)var37.i);
    /* 10: addl */
    var49.i = var48.i + var38.i;
    /* 11: shrul */
    var50.i = ((orc_uint32)var49.i) >> p3;
    /* 12: convlw */
    var51.i = var50.i;
    /* 13: mullw */
    var52.i = (var51.i * var44.i) & 0xffff;
    /* 14: copyw */
    var39.i = var52.i;
    /* 15: storew */
    ptr0[i] = var39;
    /* 16: signw */
    var53.i = ORC_CLAMP(var52.i,-1,1);
    /* 18: mullw */
    var54.i = (var51.i * var40.i) & 0xffff;
    /* 20: addw */
    var55.i = var54.i + var41.i;
    /* 21: shrsw */
    var56.i = var55.i >> 2;
    /* 22: mullw */
    var42.i = (var56.i * var53.i) & 0xffff;
    /* 23: storew */
    ptr1[i] = var42;
  }

}

#else
static void
_backup_orc_quantdequant3_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];

    /* 5: loadpw */
    var36.i = ex->params[25];
    /* 7: loadpw */
    var37.i = ex->params[24];
    /* 9: loadpl */
    var38.i = ex->params[29];
    /* 17: loadpw */
    var40.i = ex->params[27];
    /* 19: loadpw */
    var41.i = ex->params[28];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr1[i];
    /* 1: copyw */
    var43.i = var35.i;
    /* 2: signw */
    var44.i = ORC_CLAMP(var43.i,-1,1);
    /* 3: absw */
    var45.i = ORC_ABS(var43.i);
    /* 4: shlw */
    var46.i = var45.i << 2;
    /* 6: subw */
    var47.i = var46.i - var36.i;
    /* 8: muluwl */
    var48.i = ((orc_uint16)var47.i) * ((orc_uint16)var37.i);
    /* 10: addl */
    var49.i = var48.i + var38.i;
    /* 11: shrul */
    var50.i = ((orc_uint32)var49.i) >> ex->params[26];
    /* 12: convlw */
    var51.i = var50.i;
    /* 13: mullw */
    var52.i = (var51.i * var44.i) & 0xffff;
    /* 14: copyw */
    var39.i = var52.i;
    /* 15: storew */
    ptr0[i] = var39;
    /* 16: signw */
    var53.i = ORC_CLAMP(var52.i,-1,1);
    /* 18: mullw */
    var54.i = (var51.i * var40.i) & 0xffff;
    /* 20: addw */
    var55.i = var54.i + var41.i;
    /* 21: shrsw */
    var56.i = var55.i >> 2;
    /* 22: mullw */
    var42.i = (var56.i * var53.i) & 0xffff;
    /* 23: storew */
    ptr1[i] = var42;
  }

}

OrcCode *_orc_code_orc_quantdequant3_s16;
void
orc_quantdequant3_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int p5, int p6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_quantdequant3_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;
  ex->params[ORC_VAR_P6] = p6;

  func = c->exec;
  func (ex);
}
#endif


/* orc_quantdequant2_s16 */
#ifdef DISABLE_ORC
void
orc_quantdequant2_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;

    /* 5: loadpw */
    var35.i = p2;
    /* 12: loadpw */
    var37.i = p3;
    /* 14: loadpw */
    var38.i = p4;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr1[i];
    /* 1: copyw */
    var40.i = var34.i;
    /* 2: signw */
    var41.i = ORC_CLAMP(var40.i,-1,1);
    /* 3: absw */
    var42.i = ORC_ABS(var40.i);
    /* 4: shlw */
    var43.i = var42.i << 2;
    /* 6: subw */
    var44.i = var43.i - var35.i;
    /* 7: shruw */
    var45.i = ((orc_uint16)var44.i) >> p1;
    /* 8: mullw */
    var46.i = (var45.i * var41.i) & 0xffff;
    /* 9: copyw */
    var36.i = var46.i;
    /* 10: storew */
    ptr0[i] = var36;
    /* 11: signw */
    var47.i = ORC_CLAMP(var46.i,-1,1);
    /* 13: mullw */
    var48.i = (var45.i * var37.i) & 0xffff;
    /* 15: addw */
    var49.i = var48.i + var38.i;
    /* 16: shrsw */
    var50.i = var49.i >> 2;
    /* 17: mullw */
    var39.i = (var50.i * var47.i) & 0xffff;
    /* 18: storew */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_orc_quantdequant2_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];

    /* 5: loadpw */
    var35.i = ex->params[25];
    /* 12: loadpw */
    var37.i = ex->params[26];
    /* 14: loadpw */
    var38.i = ex->params[27];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr1[i];
    /* 1: copyw */
    var40.i = var34.i;
    /* 2: signw */
    var41.i = ORC_CLAMP(var40.i,-1,1);
    /* 3: absw */
    var42.i = ORC_ABS(var40.i);
    /* 4: shlw */
    var43.i = var42.i << 2;
    /* 6: subw */
    var44.i = var43.i - var35.i;
    /* 7: shruw */
    var45.i = ((orc_uint16)var44.i) >> ex->params[24];
    /* 8: mullw */
    var46.i = (var45.i * var41.i) & 0xffff;
    /* 9: copyw */
    var36.i = var46.i;
    /* 10: storew */
    ptr0[i] = var36;
    /* 11: signw */
    var47.i = ORC_CLAMP(var46.i,-1,1);
    /* 13: mullw */
    var48.i = (var45.i * var37.i) & 0xffff;
    /* 15: addw */
    var49.i = var48.i + var38.i;
    /* 16: shrsw */
    var50.i = var49.i >> 2;
    /* 17: mullw */
    var39.i = (var50.i * var47.i) & 0xffff;
    /* 18: storew */
    ptr1[i] = var39;
  }

}

OrcCode *_orc_code_orc_quantdequant2_s16;
void
orc_quantdequant2_s16 (orc_int16 * ORC_RESTRICT d1, orc_int16 * ORC_RESTRICT d2, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_quantdequant2_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_downsample_vert_u8 */
#ifdef DISABLE_ORC
void
orc_downsample_vert_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, const orc_uint8 * ORC_RESTRICT s4, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var35;
  orc_int8 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_int8 var38;
  orc_int8 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_int8 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 5: loadpw */
    var37.i = (int)0x00000006; /* 6 or 2.96439e-323f */
    /* 12: loadpw */
    var40.i = (int)0x0000001a; /* 26 or 1.28457e-322f */
    /* 15: loadpw */
    var41.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var43.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr7[i];
    /* 3: convubw */
    var44.i = (orc_uint8)var36;
    /* 4: addw */
    var45.i = var43.i + var44.i;
    /* 6: mullw */
    var46.i = (var45.i * var37.i) & 0xffff;
    /* 7: loadb */
    var38 = ptr5[i];
    /* 8: convubw */
    var47.i = (orc_uint8)var38;
    /* 9: loadb */
    var39 = ptr6[i];
    /* 10: convubw */
    var48.i = (orc_uint8)var39;
    /* 11: addw */
    var49.i = var47.i + var48.i;
    /* 13: mullw */
    var50.i = (var49.i * var40.i) & 0xffff;
    /* 14: addw */
    var51.i = var50.i + var46.i;
    /* 16: addw */
    var52.i = var51.i + var41.i;
    /* 17: shruw */
    var53.i = ((orc_uint16)var52.i) >> 6;
    /* 18: convwb */
    var42 = var53.i;
    /* 19: storeb */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_orc_downsample_vert_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var35;
  orc_int8 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_int8 var38;
  orc_int8 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_int8 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 5: loadpw */
    var37.i = (int)0x00000006; /* 6 or 2.96439e-323f */
    /* 12: loadpw */
    var40.i = (int)0x0000001a; /* 26 or 1.28457e-322f */
    /* 15: loadpw */
    var41.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var43.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr7[i];
    /* 3: convubw */
    var44.i = (orc_uint8)var36;
    /* 4: addw */
    var45.i = var43.i + var44.i;
    /* 6: mullw */
    var46.i = (var45.i * var37.i) & 0xffff;
    /* 7: loadb */
    var38 = ptr5[i];
    /* 8: convubw */
    var47.i = (orc_uint8)var38;
    /* 9: loadb */
    var39 = ptr6[i];
    /* 10: convubw */
    var48.i = (orc_uint8)var39;
    /* 11: addw */
    var49.i = var47.i + var48.i;
    /* 13: mullw */
    var50.i = (var49.i * var40.i) & 0xffff;
    /* 14: addw */
    var51.i = var50.i + var46.i;
    /* 16: addw */
    var52.i = var51.i + var41.i;
    /* 17: shruw */
    var53.i = ((orc_uint16)var52.i) >> 6;
    /* 18: convwb */
    var42 = var53.i;
    /* 19: storeb */
    ptr0[i] = var42;
  }

}

OrcCode *_orc_code_orc_downsample_vert_u8;
void
orc_downsample_vert_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, const orc_uint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_downsample_vert_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_downsample_horiz_u8 */
#ifdef DISABLE_ORC
void
orc_downsample_horiz_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
  orc_int8 var41;
  orc_union16 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_int8 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_int8 var51;
  orc_int8 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_union16 var58;
  orc_union16 var59;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 7: loadpw */
    var38.i = (int)0x00000006; /* 6 or 2.96439e-323f */
    /* 14: loadpw */
    var39.i = (int)0x0000001a; /* 26 or 1.28457e-322f */
    /* 17: loadpw */
    var40.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var42 = ptr4[i];
    /* 1: select1wb */
    {
       orc_union16 _src;
       _src.i = var42.i;
       var43 = _src.x2[1];
    }
    /* 2: convubw */
    var44.i = (orc_uint8)var43;
    /* 3: loadoffw */
    var45 = ptr4[i + 2];
    /* 4: select0wb */
    {
       orc_union16 _src;
       _src.i = var45.i;
       var46 = _src.x2[0];
    }
    /* 5: convubw */
    var47.i = (orc_uint8)var46;
    /* 6: addw */
    var48.i = var44.i + var47.i;
    /* 8: mullw */
    var49.i = (var48.i * var38.i) & 0xffff;
    /* 9: loadoffw */
    var50 = ptr4[i + 1];
    /* 10: splitwb */
    {
       orc_union16 _src;
       _src.i = var50.i;
       var51 = _src.x2[1];
       var52 = _src.x2[0];
    }
    /* 11: convubw */
    var53.i = (orc_uint8)var51;
    /* 12: convubw */
    var54.i = (orc_uint8)var52;
    /* 13: addw */
    var55.i = var53.i + var54.i;
    /* 15: mullw */
    var56.i = (var55.i * var39.i) & 0xffff;
    /* 16: addw */
    var57.i = var49.i + var56.i;
    /* 18: addw */
    var58.i = var57.i + var40.i;
    /* 19: shruw */
    var59.i = ((orc_uint16)var58.i) >> 6;
    /* 20: convwb */
    var41 = var59.i;
    /* 21: storeb */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_orc_downsample_horiz_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
  orc_int8 var41;
  orc_union16 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_int8 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_int8 var51;
  orc_int8 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_union16 var58;
  orc_union16 var59;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 7: loadpw */
    var38.i = (int)0x00000006; /* 6 or 2.96439e-323f */
    /* 14: loadpw */
    var39.i = (int)0x0000001a; /* 26 or 1.28457e-322f */
    /* 17: loadpw */
    var40.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var42 = ptr4[i];
    /* 1: select1wb */
    {
       orc_union16 _src;
       _src.i = var42.i;
       var43 = _src.x2[1];
    }
    /* 2: convubw */
    var44.i = (orc_uint8)var43;
    /* 3: loadoffw */
    var45 = ptr4[i + 2];
    /* 4: select0wb */
    {
       orc_union16 _src;
       _src.i = var45.i;
       var46 = _src.x2[0];
    }
    /* 5: convubw */
    var47.i = (orc_uint8)var46;
    /* 6: addw */
    var48.i = var44.i + var47.i;
    /* 8: mullw */
    var49.i = (var48.i * var38.i) & 0xffff;
    /* 9: loadoffw */
    var50 = ptr4[i + 1];
    /* 10: splitwb */
    {
       orc_union16 _src;
       _src.i = var50.i;
       var51 = _src.x2[1];
       var52 = _src.x2[0];
    }
    /* 11: convubw */
    var53.i = (orc_uint8)var51;
    /* 12: convubw */
    var54.i = (orc_uint8)var52;
    /* 13: addw */
    var55.i = var53.i + var54.i;
    /* 15: mullw */
    var56.i = (var55.i * var39.i) & 0xffff;
    /* 16: addw */
    var57.i = var49.i + var56.i;
    /* 18: addw */
    var58.i = var57.i + var40.i;
    /* 19: shruw */
    var59.i = ((orc_uint16)var58.i) >> 6;
    /* 20: convwb */
    var41 = var59.i;
    /* 21: storeb */
    ptr0[i] = var41;
  }

}

OrcCode *_orc_code_orc_downsample_horiz_u8;
void
orc_downsample_horiz_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_downsample_horiz_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_stats_moment_s16 */
#ifdef DISABLE_ORC
void
orc_stats_moment_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union32 var40;

  ptr4 = (orc_union16 *)s1;

    /* 2: loadpw */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */
    /* 4: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: absw */
    var37.i = ORC_ABS(var34.i);
    /* 3: subw */
    var38.i = var37.i - var35.i;
    /* 5: maxsw */
    var39.i = ORC_MAX(var38.i, var36.i);
    /* 6: convuwl */
    var40.i = (orc_uint16)var39.i;
    /* 7: accl */
    var12.i = var12.i + var40.i;
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_stats_moment_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union32 var40;

  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 2: loadpw */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */
    /* 4: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: absw */
    var37.i = ORC_ABS(var34.i);
    /* 3: subw */
    var38.i = var37.i - var35.i;
    /* 5: maxsw */
    var39.i = ORC_MAX(var38.i, var36.i);
    /* 6: convuwl */
    var40.i = (orc_uint16)var39.i;
    /* 7: accl */
    var12.i = var12.i + var40.i;
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_stats_moment_s16;
void
orc_stats_moment_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_stats_moment_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_stats_above_s16 */
#ifdef DISABLE_ORC
void
orc_stats_above_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;

  ptr4 = (orc_union16 *)s1;

    /* 2: loadpw */
    var35.i = (int)0x00000001; /* 1 or 4.94066e-324f */
    /* 4: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */
    /* 6: loadpw */
    var37.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: absw */
    var38.i = ORC_ABS(var34.i);
    /* 3: subw */
    var39.i = var38.i - var35.i;
    /* 5: maxsw */
    var40.i = ORC_MAX(var39.i, var36.i);
    /* 7: minsw */
    var41.i = ORC_MIN(var40.i, var37.i);
    /* 8: convuwl */
    var42.i = (orc_uint16)var41.i;
    /* 9: accl */
    var12.i = var12.i + var42.i;
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_stats_above_s16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union16 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;

  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 2: loadpw */
    var35.i = (int)0x00000001; /* 1 or 4.94066e-324f */
    /* 4: loadpw */
    var36.i = (int)0x00000000; /* 0 or 0f */
    /* 6: loadpw */
    var37.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: absw */
    var38.i = ORC_ABS(var34.i);
    /* 3: subw */
    var39.i = var38.i - var35.i;
    /* 5: maxsw */
    var40.i = ORC_MAX(var39.i, var36.i);
    /* 7: minsw */
    var41.i = ORC_MIN(var40.i, var37.i);
    /* 8: convuwl */
    var42.i = (orc_uint16)var41.i;
    /* 9: accl */
    var12.i = var12.i + var42.i;
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_stats_above_s16;
void
orc_stats_above_s16 (orc_int32 * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_stats_above_s16;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_accw */
#ifdef DISABLE_ORC
void
orc_accw (int * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n){
  int i;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var12 =  { 0 };
  orc_union16 var33;
  orc_union16 var34;

  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: absw */
    var34.i = ORC_ABS(var33.i);
    /* 2: accw */
    var12.i = var12.i + var34.i;
  }
  *a1 = (var12.i & 0xffff);

}

#else
static void
_backup_orc_accw (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var12 =  { 0 };
  orc_union16 var33;
  orc_union16 var34;

  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: absw */
    var34.i = ORC_ABS(var33.i);
    /* 2: accw */
    var12.i = var12.i + var34.i;
  }
  ex->accumulators[0] = (var12.i & 0xffff);

}

OrcCode *_orc_code_orc_accw;
void
orc_accw (int * ORC_RESTRICT a1, const orc_int16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_accw;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_avg2_8xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m){
  int i;
  int j;
  int n = 8;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_orc_avg2_8xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

OrcCode *_orc_code_orc_avg2_8xn_u8;
void
orc_avg2_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_avg2_8xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_avg2_12xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m){
  int i;
  int j;
  int n = 12;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_orc_avg2_12xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

OrcCode *_orc_code_orc_avg2_12xn_u8;
void
orc_avg2_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_avg2_12xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_avg2_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m){
  int i;
  int j;
  int n = 16;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_orc_avg2_16xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

OrcCode *_orc_code_orc_avg2_16xn_u8;
void
orc_avg2_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_avg2_16xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_avg2_32xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_32xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m){
  int i;
  int j;
  int n = 32;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_orc_avg2_32xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

OrcCode *_orc_code_orc_avg2_32xn_u8;
void
orc_avg2_32xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_avg2_32xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 32;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_avg2_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_orc_avg2_nxm_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

OrcCode *_orc_code_orc_avg2_nxm_u8;
void
orc_avg2_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_avg2_nxm_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine4_8xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 8;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

      /* 2: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 11: loadpw */
        var39.i = p3;
      /* 16: loadpw */
        var41.i = p4;
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

#else
static void
_backup_orc_combine4_8xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

      /* 2: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 11: loadpw */
        var39.i = ex->params[26];
      /* 16: loadpw */
        var41.i = ex->params[27];
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

OrcCode *_orc_code_orc_combine4_8xn_u8;
void
orc_combine4_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine4_8xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine4_12xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 12;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

      /* 2: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 11: loadpw */
        var39.i = p3;
      /* 16: loadpw */
        var41.i = p4;
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

#else
static void
_backup_orc_combine4_12xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

      /* 2: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 11: loadpw */
        var39.i = ex->params[26];
      /* 16: loadpw */
        var41.i = ex->params[27];
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

OrcCode *_orc_code_orc_combine4_12xn_u8;
void
orc_combine4_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine4_12xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine4_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 16;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

      /* 2: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 11: loadpw */
        var39.i = p3;
      /* 16: loadpw */
        var41.i = p4;
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

#else
static void
_backup_orc_combine4_16xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

      /* 2: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 11: loadpw */
        var39.i = ex->params[26];
      /* 16: loadpw */
        var41.i = ex->params[27];
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

OrcCode *_orc_code_orc_combine4_16xn_u8;
void
orc_combine4_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine4_16xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine4_24xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_24xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 24;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

      /* 2: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 11: loadpw */
        var39.i = p3;
      /* 16: loadpw */
        var41.i = p4;
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

#else
static void
_backup_orc_combine4_24xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 24;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

      /* 2: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 11: loadpw */
        var39.i = ex->params[26];
      /* 16: loadpw */
        var41.i = ex->params[27];
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

OrcCode *_orc_code_orc_combine4_24xn_u8;
void
orc_combine4_24xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine4_24xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 24;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine4_32xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_32xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 32;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

      /* 2: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 11: loadpw */
        var39.i = p3;
      /* 16: loadpw */
        var41.i = p4;
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

#else
static void
_backup_orc_combine4_32xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

      /* 2: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 11: loadpw */
        var39.i = ex->params[26];
      /* 16: loadpw */
        var41.i = ex->params[27];
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: convsuswb */
      var43 = ORC_CLAMP_UB(var55.i);
      /* 22: storeb */
      ptr0[i] = var43;
    }
  }

}

OrcCode *_orc_code_orc_combine4_32xn_u8;
void
orc_combine4_32xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine4_32xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 32;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine4_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

      /* 2: loadpw */
        var35.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 11: loadpw */
        var39.i = p3;
      /* 16: loadpw */
        var41.i = p4;
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: shrsw */
      var56.i = var55.i >> 4;
      /* 22: convsuswb */
      var43 = ORC_CLAMP_UB(var56.i);
      /* 23: storeb */
      ptr0[i] = var43;
    }
  }

}

#else
static void
_backup_orc_combine4_nxm_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

      /* 2: loadpw */
        var35.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 11: loadpw */
        var39.i = ex->params[26];
      /* 16: loadpw */
        var41.i = ex->params[27];
      /* 19: loadpw */
        var42.i = (int)0x00000008; /* 8 or 3.95253e-323f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var44.i = (orc_uint8)var34;
      /* 3: mullw */
      var45.i = (var44.i * var35.i) & 0xffff;
      /* 4: loadb */
      var36 = ptr5[i];
      /* 5: convubw */
      var46.i = (orc_uint8)var36;
      /* 7: mullw */
      var47.i = (var46.i * var37.i) & 0xffff;
      /* 8: addw */
      var48.i = var45.i + var47.i;
      /* 9: loadb */
      var38 = ptr6[i];
      /* 10: convubw */
      var49.i = (orc_uint8)var38;
      /* 12: mullw */
      var50.i = (var49.i * var39.i) & 0xffff;
      /* 13: addw */
      var51.i = var48.i + var50.i;
      /* 14: loadb */
      var40 = ptr7[i];
      /* 15: convubw */
      var52.i = (orc_uint8)var40;
      /* 17: mullw */
      var53.i = (var52.i * var41.i) & 0xffff;
      /* 18: addw */
      var54.i = var51.i + var53.i;
      /* 20: addw */
      var55.i = var54.i + var42.i;
      /* 21: shrsw */
      var56.i = var55.i >> 4;
      /* 22: convsuswb */
      var43 = ORC_CLAMP_UB(var56.i);
      /* 23: storeb */
      ptr0[i] = var43;
    }
  }

}

OrcCode *_orc_code_orc_combine4_nxm_u8;
void
orc_combine4_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, const orc_uint8 * ORC_RESTRICT s3, int s3_stride, const orc_uint8 * ORC_RESTRICT s4, int s4_stride, int p1, int p2, int p3, int p4, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine4_nxm_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine2_8xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 8;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

      /* 4: loadpw */
        var36.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 9: loadpw */
        var38.i = p3;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> p4;
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_orc_combine2_8xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

      /* 4: loadpw */
        var36.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 9: loadpw */
        var38.i = ex->params[26];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> ex->params[27];
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

OrcCode *_orc_code_orc_combine2_8xn_u8;
void
orc_combine2_8xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine2_8xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine2_12xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 12;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

      /* 4: loadpw */
        var36.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 9: loadpw */
        var38.i = p3;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> p4;
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_orc_combine2_12xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

      /* 4: loadpw */
        var36.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 9: loadpw */
        var38.i = ex->params[26];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> ex->params[27];
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

OrcCode *_orc_code_orc_combine2_12xn_u8;
void
orc_combine2_12xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine2_12xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine2_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 16;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

      /* 4: loadpw */
        var36.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 9: loadpw */
        var38.i = p3;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> p4;
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_orc_combine2_16xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

      /* 4: loadpw */
        var36.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 9: loadpw */
        var38.i = ex->params[26];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> ex->params[27];
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

OrcCode *_orc_code_orc_combine2_16xn_u8;
void
orc_combine2_16xn_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine2_16xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_combine2_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

      /* 4: loadpw */
        var36.i = p1;
      /* 6: loadpw */
        var37.i = p2;
      /* 9: loadpw */
        var38.i = p3;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> p4;
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_orc_combine2_nxm_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

      /* 4: loadpw */
        var36.i = ex->params[24];
      /* 6: loadpw */
        var37.i = ex->params[25];
      /* 9: loadpw */
        var38.i = ex->params[26];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var40.i = (orc_uint8)var34;
      /* 2: loadb */
      var35 = ptr5[i];
      /* 3: convubw */
      var41.i = (orc_uint8)var35;
      /* 5: mullw */
      var42.i = (var40.i * var36.i) & 0xffff;
      /* 7: mullw */
      var43.i = (var41.i * var37.i) & 0xffff;
      /* 8: addw */
      var44.i = var42.i + var43.i;
      /* 10: addw */
      var45.i = var44.i + var38.i;
      /* 11: shrsw */
      var46.i = var45.i >> ex->params[27];
      /* 12: convsuswb */
      var39 = ORC_CLAMP_UB(var46.i);
      /* 13: storeb */
      ptr0[i] = var39;
    }
  }

}

OrcCode *_orc_code_orc_combine2_nxm_u8;
void
orc_combine2_nxm_u8 (orc_uint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int p1, int p2, int p3, int p4, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_combine2_nxm_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* orc_sad_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_sad_nxm_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sad_nxm_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sad_nxm_u8;
void
orc_sad_nxm_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sad_nxm_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_8x8_u8 */
#ifdef DISABLE_ORC
void
orc_sad_8x8_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride){
  int i;
  int j;
  int n = 8;
  int m = 8;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sad_8x8_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 8;
  int m = 8;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sad_8x8_u8;
void
orc_sad_8x8_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sad_8x8_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = 8;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_12x12_u8 */
#ifdef DISABLE_ORC
void
orc_sad_12x12_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride){
  int i;
  int j;
  int n = 12;
  int m = 12;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sad_12x12_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 12;
  int m = 12;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sad_12x12_u8;
void
orc_sad_12x12_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sad_12x12_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = 12;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_sad_16xn_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m){
  int i;
  int j;
  int n = 16;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sad_16xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sad_16xn_u8;
void
orc_sad_16xn_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sad_16xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_32xn_u8 */
#ifdef DISABLE_ORC
void
orc_sad_32xn_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m){
  int i;
  int j;
  int n = 32;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_orc_sad_32xn_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

OrcCode *_orc_code_orc_sad_32xn_u8;
void
orc_sad_32xn_u8 (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_sad_32xn_u8;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = 32;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_add2_rshift_add_s32_22_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s32_22_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var33;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;

    /* 3: loadpl */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 1: loadl */
    var34 = ptr6[i];
    /* 2: addl */
    var38.i = var33.i + var34.i;
    /* 4: addl */
    var39.i = var38.i + var35.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var36 = ptr4[i];
    /* 7: addl */
    var37.i = var36.i + var40.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s32_22_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var33;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];

    /* 3: loadpl */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 1: loadl */
    var34 = ptr6[i];
    /* 2: addl */
    var38.i = var33.i + var34.i;
    /* 4: addl */
    var39.i = var38.i + var35.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var36 = ptr4[i];
    /* 7: addl */
    var37.i = var36.i + var40.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s32_22_op;
void
orc_add2_rshift_add_s32_22_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s32_22_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_vert_add_s32_1991_op */
#ifdef DISABLE_ORC
void
orc_mas4_vert_add_s32_1991_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, const orc_int32 * ORC_RESTRICT s5, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  const orc_union32 * ORC_RESTRICT ptr8;
  orc_union32 var36;
  orc_union32 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;
  ptr7 = (orc_union32 *)s4;
  ptr8 = (orc_union32 *)s5;

    /* 3: loadpl */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var41.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr6[i];
    /* 1: loadl */
    var37 = ptr7[i];
    /* 2: addl */
    var44.i = var36.i + var37.i;
    /* 4: mulll */
    var45.i = (var44.i * var38.i) & 0xffffffff;
    /* 5: loadl */
    var39 = ptr5[i];
    /* 6: loadl */
    var40 = ptr8[i];
    /* 7: addl */
    var46.i = var39.i + var40.i;
    /* 8: subl */
    var47.i = var45.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var41.i;
    /* 11: shrsl */
    var49.i = var48.i >> p2;
    /* 12: loadl */
    var42 = ptr4[i];
    /* 13: addl */
    var43.i = var42.i + var49.i;
    /* 14: storel */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_orc_mas4_vert_add_s32_1991_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  const orc_union32 * ORC_RESTRICT ptr8;
  orc_union32 var36;
  orc_union32 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];
  ptr7 = (orc_union32 *)ex->arrays[7];
  ptr8 = (orc_union32 *)ex->arrays[8];

    /* 3: loadpl */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var41.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr6[i];
    /* 1: loadl */
    var37 = ptr7[i];
    /* 2: addl */
    var44.i = var36.i + var37.i;
    /* 4: mulll */
    var45.i = (var44.i * var38.i) & 0xffffffff;
    /* 5: loadl */
    var39 = ptr5[i];
    /* 6: loadl */
    var40 = ptr8[i];
    /* 7: addl */
    var46.i = var39.i + var40.i;
    /* 8: subl */
    var47.i = var45.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var41.i;
    /* 11: shrsl */
    var49.i = var48.i >> ex->params[25];
    /* 12: loadl */
    var42 = ptr4[i];
    /* 13: addl */
    var43.i = var42.i + var49.i;
    /* 14: storel */
    ptr0[i] = var43;
  }

}

OrcCode *_orc_code_orc_mas4_vert_add_s32_1991_op;
void
orc_mas4_vert_add_s32_1991_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, const orc_int32 * ORC_RESTRICT s5, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_vert_add_s32_1991_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s32_22_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s32_22_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var33;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;

    /* 3: loadpl */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 1: loadl */
    var34 = ptr6[i];
    /* 2: addl */
    var38.i = var33.i + var34.i;
    /* 4: addl */
    var39.i = var38.i + var35.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var36 = ptr4[i];
    /* 7: subl */
    var37.i = var36.i - var40.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s32_22_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var33;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];

    /* 3: loadpl */
    var35.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 1: loadl */
    var34 = ptr6[i];
    /* 2: addl */
    var38.i = var33.i + var34.i;
    /* 4: addl */
    var39.i = var38.i + var35.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var36 = ptr4[i];
    /* 7: subl */
    var37.i = var36.i - var40.i;
    /* 8: storel */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s32_22_op;
void
orc_add2_rshift_sub_s32_22_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s32_22_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_interleave2_rrshift1_s32 */
#ifdef DISABLE_ORC
void
orc_interleave2_rrshift1_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 1: loadpl */
    var35.i = (int)0x00000001; /* 1 or 4.94066e-324f */
    /* 5: loadpl */
    var37.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var39.i = var34.i + var35.i;
    /* 3: shrsl */
    var40.i = var39.i >> 1;
    /* 4: loadl */
    var36 = ptr5[i];
    /* 6: addl */
    var41.i = var36.i + var37.i;
    /* 7: shrsl */
    var42.i = var41.i >> 1;
    /* 8: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var42.i;
       var38.i = _dest.i;
    }
    /* 9: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_interleave2_rrshift1_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 1: loadpl */
    var35.i = (int)0x00000001; /* 1 or 4.94066e-324f */
    /* 5: loadpl */
    var37.i = (int)0x00000001; /* 1 or 4.94066e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var39.i = var34.i + var35.i;
    /* 3: shrsl */
    var40.i = var39.i >> 1;
    /* 4: loadl */
    var36 = ptr5[i];
    /* 6: addl */
    var41.i = var36.i + var37.i;
    /* 7: shrsl */
    var42.i = var41.i >> 1;
    /* 8: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var42.i;
       var38.i = _dest.i;
    }
    /* 9: storeq */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_interleave2_rrshift1_s32;
void
orc_interleave2_rrshift1_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_interleave2_rrshift1_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_vert_sub_s32_1991_op */
#ifdef DISABLE_ORC
void
orc_mas4_vert_sub_s32_1991_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, const orc_int32 * ORC_RESTRICT s5, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  const orc_union32 * ORC_RESTRICT ptr8;
  orc_union32 var36;
  orc_union32 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;
  ptr7 = (orc_union32 *)s4;
  ptr8 = (orc_union32 *)s5;

    /* 3: loadpl */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var41.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr6[i];
    /* 1: loadl */
    var37 = ptr7[i];
    /* 2: addl */
    var44.i = var36.i + var37.i;
    /* 4: mulll */
    var45.i = (var44.i * var38.i) & 0xffffffff;
    /* 5: loadl */
    var39 = ptr5[i];
    /* 6: loadl */
    var40 = ptr8[i];
    /* 7: addl */
    var46.i = var39.i + var40.i;
    /* 8: subl */
    var47.i = var45.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var41.i;
    /* 11: shrsl */
    var49.i = var48.i >> p2;
    /* 12: loadl */
    var42 = ptr4[i];
    /* 13: subl */
    var43.i = var42.i - var49.i;
    /* 14: storel */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_orc_mas4_vert_sub_s32_1991_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  const orc_union32 * ORC_RESTRICT ptr8;
  orc_union32 var36;
  orc_union32 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];
  ptr7 = (orc_union32 *)ex->arrays[7];
  ptr8 = (orc_union32 *)ex->arrays[8];

    /* 3: loadpl */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var41.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr6[i];
    /* 1: loadl */
    var37 = ptr7[i];
    /* 2: addl */
    var44.i = var36.i + var37.i;
    /* 4: mulll */
    var45.i = (var44.i * var38.i) & 0xffffffff;
    /* 5: loadl */
    var39 = ptr5[i];
    /* 6: loadl */
    var40 = ptr8[i];
    /* 7: addl */
    var46.i = var39.i + var40.i;
    /* 8: subl */
    var47.i = var45.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var41.i;
    /* 11: shrsl */
    var49.i = var48.i >> ex->params[25];
    /* 12: loadl */
    var42 = ptr4[i];
    /* 13: subl */
    var43.i = var42.i - var49.i;
    /* 14: storel */
    ptr0[i] = var43;
  }

}

OrcCode *_orc_code_orc_mas4_vert_sub_s32_1991_op;
void
orc_mas4_vert_sub_s32_1991_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, const orc_int32 * ORC_RESTRICT s5, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_vert_sub_s32_1991_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_vert_sub_s32_1991 */
#ifdef DISABLE_ORC
void
orc_mas4_vert_sub_s32_1991 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  orc_union32 var36;
  orc_union32 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;
  ptr7 = (orc_union32 *)s4;

    /* 3: loadpl */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var41.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr5[i];
    /* 1: loadl */
    var37 = ptr6[i];
    /* 2: addl */
    var44.i = var36.i + var37.i;
    /* 4: mulll */
    var45.i = (var44.i * var38.i) & 0xffffffff;
    /* 5: loadl */
    var39 = ptr4[i];
    /* 6: loadl */
    var40 = ptr7[i];
    /* 7: addl */
    var46.i = var39.i + var40.i;
    /* 8: subl */
    var47.i = var45.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var41.i;
    /* 11: shrsl */
    var49.i = var48.i >> p2;
    /* 12: loadl */
    var42 = ptr0[i];
    /* 13: subl */
    var43.i = var42.i - var49.i;
    /* 14: storel */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_orc_mas4_vert_sub_s32_1991 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  orc_union32 var36;
  orc_union32 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];
  ptr7 = (orc_union32 *)ex->arrays[7];

    /* 3: loadpl */
    var38.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var41.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr5[i];
    /* 1: loadl */
    var37 = ptr6[i];
    /* 2: addl */
    var44.i = var36.i + var37.i;
    /* 4: mulll */
    var45.i = (var44.i * var38.i) & 0xffffffff;
    /* 5: loadl */
    var39 = ptr4[i];
    /* 6: loadl */
    var40 = ptr7[i];
    /* 7: addl */
    var46.i = var39.i + var40.i;
    /* 8: subl */
    var47.i = var45.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var41.i;
    /* 11: shrsl */
    var49.i = var48.i >> ex->params[25];
    /* 12: loadl */
    var42 = ptr0[i];
    /* 13: subl */
    var43.i = var42.i - var49.i;
    /* 14: storel */
    ptr0[i] = var43;
  }

}

OrcCode *_orc_code_orc_mas4_vert_sub_s32_1991;
void
orc_mas4_vert_sub_s32_1991 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, const orc_int32 * ORC_RESTRICT s4, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_vert_sub_s32_1991;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_horiz_add_s32_1991_ip */
#ifdef DISABLE_ORC
void
orc_mas4_horiz_add_s32_1991_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var36;
#else
  orc_union32 var36;
#endif
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var37.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var40 = ptr4[i + 1];
    /* 1: loadoffl */
    var41 = ptr4[i + 2];
    /* 2: addl */
    var42.i = var40.i + var41.i;
    /* 4: mulll */
    var43.i = (var42.i * var36.i) & 0xffffffff;
    /* 5: loadl */
    var44 = ptr4[i];
    /* 6: loadoffl */
    var45 = ptr4[i + 3];
    /* 7: addl */
    var46.i = var44.i + var45.i;
    /* 8: subl */
    var47.i = var43.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var37.i;
    /* 11: shrsl */
    var49.i = var48.i >> p2;
    /* 12: loadl */
    var38 = ptr0[i];
    /* 13: addl */
    var39.i = var38.i + var49.i;
    /* 14: storel */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas4_horiz_add_s32_1991_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var36;
#else
  orc_union32 var36;
#endif
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var37.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var40 = ptr4[i + 1];
    /* 1: loadoffl */
    var41 = ptr4[i + 2];
    /* 2: addl */
    var42.i = var40.i + var41.i;
    /* 4: mulll */
    var43.i = (var42.i * var36.i) & 0xffffffff;
    /* 5: loadl */
    var44 = ptr4[i];
    /* 6: loadoffl */
    var45 = ptr4[i + 3];
    /* 7: addl */
    var46.i = var44.i + var45.i;
    /* 8: subl */
    var47.i = var43.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var37.i;
    /* 11: shrsl */
    var49.i = var48.i >> ex->params[25];
    /* 12: loadl */
    var38 = ptr0[i];
    /* 13: addl */
    var39.i = var38.i + var49.i;
    /* 14: storel */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas4_horiz_add_s32_1991_ip;
void
orc_mas4_horiz_add_s32_1991_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_horiz_add_s32_1991_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s32_11_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s32_11_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 1: loadl */
    var34 = ptr6[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var34.i + 1)>>1;
    /* 3: loadl */
    var35 = ptr4[i];
    /* 4: addl */
    var36.i = var35.i + var37.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s32_11_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 1: loadl */
    var34 = ptr6[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var34.i + 1)>>1;
    /* 3: loadl */
    var35 = ptr4[i];
    /* 4: addl */
    var36.i = var35.i + var37.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s32_11_op;
void
orc_add2_rshift_add_s32_11_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s32_11_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas4_horiz_sub_s32_1991_ip */
#ifdef DISABLE_ORC
void
orc_mas4_horiz_sub_s32_1991_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var36;
#else
  orc_union32 var36;
#endif
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var37.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var40 = ptr4[i + 1];
    /* 1: loadoffl */
    var41 = ptr4[i + 2];
    /* 2: addl */
    var42.i = var40.i + var41.i;
    /* 4: mulll */
    var43.i = (var42.i * var36.i) & 0xffffffff;
    /* 5: loadl */
    var44 = ptr4[i];
    /* 6: loadoffl */
    var45 = ptr4[i + 3];
    /* 7: addl */
    var46.i = var44.i + var45.i;
    /* 8: subl */
    var47.i = var43.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var37.i;
    /* 11: shrsl */
    var49.i = var48.i >> p2;
    /* 12: loadl */
    var38 = ptr0[i];
    /* 13: subl */
    var39.i = var38.i - var49.i;
    /* 14: storel */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas4_horiz_sub_s32_1991_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var36;
#else
  orc_union32 var36;
#endif
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var36.i = (int)0x00000009; /* 9 or 4.44659e-323f */
    /* 9: loadpl */
    var37.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var40 = ptr4[i + 1];
    /* 1: loadoffl */
    var41 = ptr4[i + 2];
    /* 2: addl */
    var42.i = var40.i + var41.i;
    /* 4: mulll */
    var43.i = (var42.i * var36.i) & 0xffffffff;
    /* 5: loadl */
    var44 = ptr4[i];
    /* 6: loadoffl */
    var45 = ptr4[i + 3];
    /* 7: addl */
    var46.i = var44.i + var45.i;
    /* 8: subl */
    var47.i = var43.i - var46.i;
    /* 10: addl */
    var48.i = var47.i + var37.i;
    /* 11: shrsl */
    var49.i = var48.i >> ex->params[25];
    /* 12: loadl */
    var38 = ptr0[i];
    /* 13: subl */
    var39.i = var38.i - var49.i;
    /* 14: storel */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas4_horiz_sub_s32_1991_ip;
void
orc_mas4_horiz_sub_s32_1991_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas4_horiz_sub_s32_1991_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_s32_lo */
#ifdef DISABLE_ORC
void
orc_haar_synth_s32_lo (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 1: loadpl */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var34.i + 1)>>1;
    /* 3: loadl */
    var35 = ptr4[i];
    /* 4: subl */
    var36.i = var35.i - var37.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_haar_synth_s32_lo (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 1: loadpl */
    var34.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr5[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var34.i + 1)>>1;
    /* 3: loadl */
    var35 = ptr4[i];
    /* 4: subl */
    var36.i = var35.i - var37.i;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_haar_synth_s32_lo;
void
orc_haar_synth_s32_lo (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_s32_lo;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_int_s32 */
#ifdef DISABLE_ORC
void
orc_haar_synth_int_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 2: loadpl */
    var35.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: copyl */
    var38.i = var34.i;
    /* 3: avgsl */
    var39.i = ((orc_int64)var38.i + (orc_int64)var35.i + 1)>>1;
    /* 4: loadl */
    var36 = ptr4[i];
    /* 5: subl */
    var40.i = var36.i - var39.i;
    /* 6: addl */
    var41.i = var38.i + var40.i;
    /* 7: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_orc_haar_synth_int_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 2: loadpl */
    var35.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: copyl */
    var38.i = var34.i;
    /* 3: avgsl */
    var39.i = ((orc_int64)var38.i + (orc_int64)var35.i + 1)>>1;
    /* 4: loadl */
    var36 = ptr4[i];
    /* 5: subl */
    var40.i = var36.i - var39.i;
    /* 6: addl */
    var41.i = var38.i + var40.i;
    /* 7: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var37;
  }

}

OrcCode *_orc_code_orc_haar_synth_int_s32;
void
orc_haar_synth_int_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_int_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_rrshift1_int_s32 */
#ifdef DISABLE_ORC
void
orc_haar_synth_rrshift1_int_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union64 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 2: loadpl */
    var35.i = (int)0x00000000; /* 0 or 0f */
    /* 7: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */
    /* 9: loadpl */
    var38.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: copyl */
    var40.i = var34.i;
    /* 3: avgsl */
    var41.i = ((orc_int64)var40.i + (orc_int64)var35.i + 1)>>1;
    /* 4: loadl */
    var36 = ptr4[i];
    /* 5: subl */
    var42.i = var36.i - var41.i;
    /* 6: addl */
    var43.i = var40.i + var42.i;
    /* 8: avgsl */
    var44.i = ((orc_int64)var42.i + (orc_int64)var37.i + 1)>>1;
    /* 10: avgsl */
    var45.i = ((orc_int64)var43.i + (orc_int64)var38.i + 1)>>1;
    /* 11: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var45.i;
       var39.i = _dest.i;
    }
    /* 12: storeq */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_haar_synth_rrshift1_int_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union64 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 2: loadpl */
    var35.i = (int)0x00000000; /* 0 or 0f */
    /* 7: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */
    /* 9: loadpl */
    var38.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: copyl */
    var40.i = var34.i;
    /* 3: avgsl */
    var41.i = ((orc_int64)var40.i + (orc_int64)var35.i + 1)>>1;
    /* 4: loadl */
    var36 = ptr4[i];
    /* 5: subl */
    var42.i = var36.i - var41.i;
    /* 6: addl */
    var43.i = var40.i + var42.i;
    /* 8: avgsl */
    var44.i = ((orc_int64)var42.i + (orc_int64)var37.i + 1)>>1;
    /* 10: avgsl */
    var45.i = ((orc_int64)var43.i + (orc_int64)var38.i + 1)>>1;
    /* 11: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var45.i;
       var39.i = _dest.i;
    }
    /* 12: storeq */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_haar_synth_rrshift1_int_s32;
void
orc_haar_synth_rrshift1_int_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_rrshift1_int_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_interleave2_s32 */
#ifdef DISABLE_ORC
void
orc_interleave2_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var32.i;
       _dest.x2[1] = var33.i;
       var34.i = _dest.i;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_orc_interleave2_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var32.i;
       _dest.x2[1] = var33.i;
       var34.i = _dest.i;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

OrcCode *_orc_code_orc_interleave2_s32;
void
orc_interleave2_s32 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_interleave2_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_sub_s32_ip */
#ifdef DISABLE_ORC
void
orc_mas2_sub_s32_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int p3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var35.i = p1;
    /* 5: loadpl */
    var36.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var39 = ptr4[i + 1];
    /* 1: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var40.i = var34.i + var39.i;
    /* 4: mulll */
    var41.i = (var40.i * var35.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: loadl */
    var37 = ptr0[i];
    /* 9: subl */
    var38.i = var37.i - var43.i;
    /* 10: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_mas2_sub_s32_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var35.i = ex->params[24];
    /* 5: loadpl */
    var36.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var39 = ptr4[i + 1];
    /* 1: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var40.i = var34.i + var39.i;
    /* 4: mulll */
    var41.i = (var40.i * var35.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: loadl */
    var37 = ptr0[i];
    /* 9: subl */
    var38.i = var37.i - var43.i;
    /* 10: storel */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_mas2_sub_s32_ip;
void
orc_mas2_sub_s32_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_sub_s32_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_add_s32_ip */
#ifdef DISABLE_ORC
void
orc_mas2_add_s32_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int p3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var35.i = p1;
    /* 5: loadpl */
    var36.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var39 = ptr4[i + 1];
    /* 1: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var40.i = var34.i + var39.i;
    /* 4: mulll */
    var41.i = (var40.i * var35.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: loadl */
    var37 = ptr0[i];
    /* 9: addl */
    var38.i = var37.i + var43.i;
    /* 10: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_orc_mas2_add_s32_ip (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var35.i = ex->params[24];
    /* 5: loadpl */
    var36.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var39 = ptr4[i + 1];
    /* 1: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var40.i = var34.i + var39.i;
    /* 4: mulll */
    var41.i = (var40.i * var35.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var36.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: loadl */
    var37 = ptr0[i];
    /* 9: addl */
    var38.i = var37.i + var43.i;
    /* 10: storel */
    ptr0[i] = var38;
  }

}

OrcCode *_orc_code_orc_mas2_add_s32_ip;
void
orc_mas2_add_s32_ip (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_add_s32_ip;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_add_s32_op */
#ifdef DISABLE_ORC
void
orc_mas2_add_s32_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int p1, int p2, int p3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;

    /* 3: loadpl */
    var36.i = p1;
    /* 5: loadpl */
    var37.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: loadl */
    var35 = ptr6[i];
    /* 2: addl */
    var40.i = var34.i + var35.i;
    /* 4: mulll */
    var41.i = (var40.i * var36.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: loadl */
    var38 = ptr4[i];
    /* 9: addl */
    var39.i = var38.i + var43.i;
    /* 10: storel */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas2_add_s32_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];

    /* 3: loadpl */
    var36.i = ex->params[24];
    /* 5: loadpl */
    var37.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: loadl */
    var35 = ptr6[i];
    /* 2: addl */
    var40.i = var34.i + var35.i;
    /* 4: mulll */
    var41.i = (var40.i * var36.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: loadl */
    var38 = ptr4[i];
    /* 9: addl */
    var39.i = var38.i + var43.i;
    /* 10: storel */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas2_add_s32_op;
void
orc_mas2_add_s32_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_add_s32_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_mas2_sub_s32_op */
#ifdef DISABLE_ORC
void
orc_mas2_sub_s32_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int p1, int p2, int p3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;

    /* 3: loadpl */
    var36.i = p1;
    /* 5: loadpl */
    var37.i = p2;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: loadl */
    var35 = ptr6[i];
    /* 2: addl */
    var40.i = var34.i + var35.i;
    /* 4: mulll */
    var41.i = (var40.i * var36.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> p3;
    /* 8: loadl */
    var38 = ptr4[i];
    /* 9: subl */
    var39.i = var38.i - var43.i;
    /* 10: storel */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_orc_mas2_sub_s32_op (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];

    /* 3: loadpl */
    var36.i = ex->params[24];
    /* 5: loadpl */
    var37.i = ex->params[25];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr5[i];
    /* 1: loadl */
    var35 = ptr6[i];
    /* 2: addl */
    var40.i = var34.i + var35.i;
    /* 4: mulll */
    var41.i = (var40.i * var36.i) & 0xffffffff;
    /* 6: addl */
    var42.i = var41.i + var37.i;
    /* 7: shrsl */
    var43.i = var42.i >> ex->params[26];
    /* 8: loadl */
    var38 = ptr4[i];
    /* 9: subl */
    var39.i = var38.i - var43.i;
    /* 10: storel */
    ptr0[i] = var39;
  }

}

OrcCode *_orc_code_orc_mas2_sub_s32_op;
void
orc_mas2_sub_s32_op (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, const orc_int32 * ORC_RESTRICT s2, const orc_int32 * ORC_RESTRICT s3, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_mas2_sub_s32_op;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_sub_s32_22 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s32_22 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpl */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var37 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addl */
    var38.i = var33.i + var37.i;
    /* 4: addl */
    var39.i = var38.i + var34.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var35 = ptr0[i];
    /* 7: subl */
    var36.i = var35.i - var40.i;
    /* 8: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s32_22 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpl */
    var34.i = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var37 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: addl */
    var38.i = var33.i + var37.i;
    /* 4: addl */
    var39.i = var38.i + var34.i;
    /* 5: shrsl */
    var40.i = var39.i >> 2;
    /* 6: loadl */
    var35 = ptr0[i];
    /* 7: subl */
    var36.i = var35.i - var40.i;
    /* 8: storel */
    ptr0[i] = var36;
  }

}

OrcCode *_orc_code_orc_add2_rshift_sub_s32_22;
void
orc_add2_rshift_sub_s32_22 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_sub_s32_22;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_add2_rshift_add_s32_11 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s32_11 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var36 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var36.i + 1)>>1;
    /* 3: loadl */
    var34 = ptr0[i];
    /* 4: addl */
    var35.i = var34.i + var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s32_11 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var36 = ptr4[i + 1];
    /* 1: loadl */
    var33 = ptr4[i];
    /* 2: avgsl */
    var37.i = ((orc_int64)var33.i + (orc_int64)var36.i + 1)>>1;
    /* 3: loadl */
    var34 = ptr0[i];
    /* 4: addl */
    var35.i = var34.i + var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

OrcCode *_orc_code_orc_add2_rshift_add_s32_11;
void
orc_add2_rshift_add_s32_11 (orc_int32 * ORC_RESTRICT d1, const orc_int32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_add2_rshift_add_s32_11;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_haar_synth_s32 */
#ifdef DISABLE_ORC
void
orc_haar_synth_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  orc_union32 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;

    /* 4: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr0[i];
    /* 1: copyl */
    var40.i = var35.i;
    /* 2: loadl */
    var36 = ptr1[i];
    /* 3: copyl */
    var41.i = var36.i;
    /* 5: avgsl */
    var42.i = ((orc_int64)var41.i + (orc_int64)var37.i + 1)>>1;
    /* 6: subl */
    var43.i = var40.i - var42.i;
    /* 7: copyl */
    var38.i = var43.i;
    /* 8: storel */
    ptr0[i] = var38;
    /* 9: addl */
    var39.i = var41.i + var43.i;
    /* 10: storel */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_orc_haar_synth_s32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  orc_union32 var35;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];

    /* 4: loadpl */
    var37.i = (int)0x00000000; /* 0 or 0f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr0[i];
    /* 1: copyl */
    var40.i = var35.i;
    /* 2: loadl */
    var36 = ptr1[i];
    /* 3: copyl */
    var41.i = var36.i;
    /* 5: avgsl */
    var42.i = ((orc_int64)var41.i + (orc_int64)var37.i + 1)>>1;
    /* 6: subl */
    var43.i = var40.i - var42.i;
    /* 7: copyl */
    var38.i = var43.i;
    /* 8: storel */
    ptr0[i] = var38;
    /* 9: addl */
    var39.i = var41.i + var43.i;
    /* 10: storel */
    ptr1[i] = var39;
  }

}

OrcCode *_orc_code_orc_haar_synth_s32;
void
orc_haar_synth_s32 (orc_int32 * ORC_RESTRICT d1, orc_int32 * ORC_RESTRICT d2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_haar_synth_s32;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;

  func = c->exec;
  func (ex);
}
#endif


/* orc_splat_s32_2d */
#ifdef DISABLE_ORC
void
orc_splat_s32_2d (orc_int32 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 0: loadpl */
        var32.i = p1;

    for (i = 0; i < n; i++) {
      /* 1: copyl */
      var33.i = var32.i;
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_orc_splat_s32_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 0: loadpl */
        var32.i = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 1: copyl */
      var33.i = var32.i;
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

OrcCode *_orc_code_orc_splat_s32_2d;
void
orc_splat_s32_2d (orc_int32 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_splat_s32_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* orc_dequantise_s32_ip_2d */
#ifdef DISABLE_ORC
void
orc_dequantise_s32_ip_2d (orc_int32 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 4: loadpl */
        var35.i = p1;
      /* 6: loadpl */
        var36.i = p2;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr0[i];
      /* 1: copyl */
      var38.i = var34.i;
      /* 2: signl */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absl */
      var40.i = ORC_ABS(var38.i);
      /* 5: mulll */
      var41.i = (var40.i * var35.i) & 0xffffffff;
      /* 7: addl */
      var42.i = var41.i + var36.i;
      /* 8: shrsl */
      var43.i = var42.i >> 2;
      /* 9: mulll */
      var37.i = (var43.i * var39.i) & 0xffffffff;
      /* 10: storel */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_orc_dequantise_s32_ip_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 4: loadpl */
        var35.i = ex->params[24];
      /* 6: loadpl */
        var36.i = ex->params[25];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr0[i];
      /* 1: copyl */
      var38.i = var34.i;
      /* 2: signl */
      var39.i = ORC_CLAMP(var38.i,-1,1);
      /* 3: absl */
      var40.i = ORC_ABS(var38.i);
      /* 5: mulll */
      var41.i = (var40.i * var35.i) & 0xffffffff;
      /* 7: addl */
      var42.i = var41.i + var36.i;
      /* 8: shrsl */
      var43.i = var42.i >> 2;
      /* 9: mulll */
      var37.i = (var43.i * var39.i) & 0xffffffff;
      /* 10: storel */
      ptr0[i] = var37;
    }
  }

}

OrcCode *_orc_code_orc_dequantise_s32_ip_2d;
void
orc_dequantise_s32_ip_2d (orc_int32 * ORC_RESTRICT d1, int d1_stride, int p1, int p2, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  OrcCode *c = _orc_code_orc_dequantise_s32_ip_2d;
  void (*func) (OrcExecutor *);

  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


void
schro_orc_init (void)
{
#ifndef DISABLE_ORC
  {
    /* orc_add2_rshift_add_s16_22_vert */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 49, 54, 95, 50, 50, 95, 118, 101, 
      114, 116, 11, 2, 2, 12, 2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 
      0, 20, 2, 70, 32, 4, 5, 70, 32, 32, 16, 94, 32, 32, 16, 70, 
      0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22_vert);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_22_vert");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22_vert);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s16_22_vert = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s32_22_vert */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 51, 50, 95, 50, 50, 95, 118, 101, 
      114, 116, 11, 4, 4, 12, 4, 4, 12, 4, 4, 14, 4, 2, 0, 0, 
      0, 20, 4, 103, 32, 4, 5, 103, 32, 32, 16, 125, 32, 32, 16, 103, 
      0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_22_vert);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s32_22_vert");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_22_vert);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s32_22_vert = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s16_22 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 49, 54, 95, 50, 50, 11, 2, 2, 
      12, 2, 2, 14, 4, 1, 0, 0, 0, 14, 4, 2, 0, 0, 0, 20, 
      2, 83, 32, 4, 16, 70, 32, 4, 32, 70, 32, 32, 17, 94, 32, 32, 
      17, 70, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_22");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s16_22 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s32_22 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 51, 50, 95, 50, 50, 11, 4, 4, 
      12, 4, 4, 14, 4, 1, 0, 0, 0, 14, 4, 2, 0, 0, 0, 20, 
      4, 114, 32, 4, 16, 103, 32, 4, 32, 103, 32, 32, 17, 125, 32, 32, 
      17, 103, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_22);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s32_22");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_22);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s32_22 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s16_22_vert */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 49, 54, 95, 50, 50, 95, 118, 101, 
      114, 116, 11, 2, 2, 12, 2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 
      0, 20, 2, 70, 32, 4, 5, 70, 32, 32, 16, 94, 32, 32, 16, 98, 
      0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22_vert);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_22_vert");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22_vert);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s16_22_vert = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s16_22 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 49, 54, 95, 50, 50, 11, 2, 2, 
      12, 2, 2, 14, 4, 1, 0, 0, 0, 14, 4, 2, 0, 0, 0, 20, 
      2, 83, 32, 4, 16, 70, 32, 4, 32, 70, 32, 32, 17, 94, 32, 32, 
      17, 98, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_22");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s16_22 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s16_11_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 49, 54, 95, 49, 49, 95, 111, 112, 
      11, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 20, 2, 75, 32, 
      5, 6, 70, 0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_11_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s16_11_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s16_11 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 49, 54, 95, 49, 49, 11, 2, 2, 
      12, 2, 2, 14, 4, 1, 0, 0, 0, 20, 2, 83, 32, 4, 16, 75, 
      32, 4, 32, 70, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_11");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s16_11 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s16_11_vert */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 49, 54, 95, 49, 49, 95, 118, 101, 
      114, 116, 11, 2, 2, 12, 2, 2, 12, 2, 2, 20, 2, 75, 32, 4, 
      5, 98, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11_vert);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_11_vert");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11_vert);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s16_11_vert = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s32_11_vert */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 51, 50, 95, 49, 49, 95, 118, 101, 
      114, 116, 11, 4, 4, 12, 4, 4, 12, 4, 4, 20, 4, 108, 32, 4, 
      5, 129, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_11_vert);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s32_11_vert");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_11_vert);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s32_11_vert = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s16_11 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 49, 54, 95, 49, 49, 11, 2, 2, 
      12, 2, 2, 14, 4, 1, 0, 0, 0, 20, 2, 83, 32, 4, 16, 75, 
      32, 4, 32, 98, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_11");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s16_11 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s32_11 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 51, 50, 95, 49, 49, 11, 4, 4, 
      12, 4, 4, 14, 4, 1, 0, 0, 0, 20, 4, 114, 32, 4, 16, 108, 
      32, 4, 32, 129, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_11);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s32_11");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_11);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s32_11 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_const_rshift_s16_11 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 27, 111, 114, 99, 95, 97, 100, 100, 95, 99, 111, 110, 115, 116, 
      95, 114, 115, 104, 105, 102, 116, 95, 115, 49, 54, 95, 49, 49, 11, 2, 
      2, 12, 2, 2, 14, 4, 1, 0, 0, 0, 20, 2, 70, 32, 4, 16, 
      94, 0, 32, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16_11);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_const_rshift_s16_11");
      orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16_11);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_const_rshift_s16_11 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_const_rshift_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 97, 100, 100, 95, 99, 111, 110, 115, 116, 
      95, 114, 115, 104, 105, 102, 116, 95, 115, 49, 54, 11, 2, 2, 16, 2, 
      16, 2, 20, 2, 70, 32, 0, 24, 94, 0, 32, 25, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_const_rshift_s16");
      orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_const_rshift_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_const_rshift_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 97, 100, 100, 95, 99, 111, 110, 115, 116, 
      95, 114, 115, 104, 105, 102, 116, 95, 115, 51, 50, 11, 4, 4, 16, 4, 
      16, 4, 20, 4, 103, 32, 0, 24, 125, 0, 32, 25, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_const_rshift_s32");
      orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_const_rshift_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 11, 111, 114, 99, 95, 97, 100, 100, 95, 115, 49, 54, 11, 2, 
      2, 12, 2, 2, 12, 2, 2, 70, 0, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_s16");
      orc_program_set_backup_function (p, _backup_orc_add_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_s16_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 14, 111, 114, 99, 95, 97, 100, 100, 95, 115, 49, 54, 95, 
      50, 100, 11, 2, 2, 12, 2, 2, 70, 0, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_s16_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_add_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_add_s16_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_s16_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_addc_rshift_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 97, 100, 100, 99, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 12, 2, 2, 16, 
      2, 20, 2, 70, 32, 4, 5, 94, 0, 32, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_addc_rshift_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_addc_rshift_s16");
      orc_program_set_backup_function (p, _backup_orc_addc_rshift_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_addc_rshift_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_lshift1_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 15, 111, 114, 99, 95, 108, 115, 104, 105, 102, 116, 49, 95, 115, 
      49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 1, 0, 0, 0, 93, 0, 
      4, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_lshift1_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift1_s16");
      orc_program_set_backup_function (p, _backup_orc_lshift1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");

      orc_program_append_2 (p, "shlw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_lshift1_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_lshift2_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 15, 111, 114, 99, 95, 108, 115, 104, 105, 102, 116, 50, 95, 115, 
      49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 0, 93, 0, 
      4, 16, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_lshift2_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift2_s16");
      orc_program_set_backup_function (p, _backup_orc_lshift2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");

      orc_program_append_2 (p, "shlw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_lshift2_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_lshift_s16_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 108, 115, 104, 105, 102, 116, 95, 115, 49, 
      54, 95, 105, 112, 11, 2, 2, 16, 2, 93, 0, 0, 24, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_lshift_s16_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_lshift_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append_2 (p, "shlw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_lshift_s16_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_lshift_s32_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 108, 115, 104, 105, 102, 116, 95, 115, 51, 
      50, 95, 105, 112, 11, 4, 4, 16, 4, 124, 0, 0, 24, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_lshift_s32_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift_s32_ip");
      orc_program_set_backup_function (p, _backup_orc_lshift_s32_ip);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter (p, 4, "p1");

      orc_program_append_2 (p, "shll", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_lshift_s32_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_add_s16_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 97, 100, 100, 95, 
      115, 49, 54, 95, 111, 112, 11, 2, 2, 12, 2, 2, 12, 2, 2, 12, 
      2, 2, 16, 2, 16, 4, 16, 4, 20, 2, 20, 4, 70, 32, 5, 6, 
      176, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 163, 32, 33, 70, 
      0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_add_s16_op");
      orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_add_s16_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_add_s16_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 97, 100, 100, 95, 
      115, 49, 54, 95, 105, 112, 11, 2, 2, 12, 2, 2, 14, 4, 1, 0, 
      0, 0, 16, 2, 16, 4, 16, 4, 20, 2, 20, 4, 83, 32, 4, 16, 
      70, 32, 4, 32, 176, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 
      163, 32, 33, 70, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_add_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_add_s16_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_sub_s16_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 115, 117, 98, 95, 
      115, 49, 54, 95, 111, 112, 11, 2, 2, 12, 2, 2, 12, 2, 2, 12, 
      2, 2, 16, 2, 16, 4, 16, 4, 20, 2, 20, 4, 70, 32, 5, 6, 
      176, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 163, 32, 33, 98, 
      0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_sub_s16_op");
      orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_sub_s16_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_sub_s16_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 115, 117, 98, 95, 
      115, 49, 54, 95, 105, 112, 11, 2, 2, 12, 2, 2, 14, 4, 1, 0, 
      0, 0, 16, 2, 16, 4, 16, 4, 20, 2, 20, 4, 83, 32, 4, 16, 
      70, 32, 4, 32, 176, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 
      163, 32, 33, 98, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_sub_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_sub_s16_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_vert_add_s16_1991 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 109, 97, 115, 52, 95, 118, 101, 114, 116, 
      95, 97, 100, 100, 95, 115, 49, 54, 95, 49, 57, 57, 49, 11, 2, 2, 
      12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14, 4, 9, 0, 
      0, 0, 16, 4, 16, 4, 20, 2, 20, 2, 20, 4, 20, 4, 70, 32, 
      5, 6, 176, 34, 32, 16, 70, 33, 4, 7, 153, 35, 33, 129, 34, 34, 
      35, 103, 34, 34, 24, 125, 34, 34, 25, 163, 32, 34, 70, 0, 0, 32, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_vert_add_s16_1991);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_vert_add_s16_1991");
      orc_program_set_backup_function (p, _backup_orc_mas4_vert_add_s16_1991);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 4, 0x00000009, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_vert_add_s16_1991 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_vert_add_s32_1991 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 109, 97, 115, 52, 95, 118, 101, 114, 116, 
      95, 97, 100, 100, 95, 115, 51, 50, 95, 49, 57, 57, 49, 11, 4, 4, 
      12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 14, 4, 9, 0, 
      0, 0, 16, 4, 16, 4, 20, 4, 20, 4, 20, 4, 103, 32, 5, 6, 
      120, 34, 32, 16, 103, 33, 4, 7, 129, 34, 34, 33, 103, 34, 34, 24, 
      125, 34, 34, 25, 103, 0, 0, 34, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_vert_add_s32_1991);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_vert_add_s32_1991");
      orc_program_set_backup_function (p, _backup_orc_mas4_vert_add_s32_1991);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_source (p, 4, "s4");
      orc_program_add_constant (p, 4, 0x00000009, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_vert_add_s32_1991 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_horiz_add_s16_1991_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 30, 111, 114, 99, 95, 109, 97, 115, 52, 95, 104, 111, 114, 105, 
      122, 95, 97, 100, 100, 95, 115, 49, 54, 95, 49, 57, 57, 49, 95, 105, 
      112, 11, 2, 2, 12, 2, 2, 14, 4, 1, 0, 0, 0, 14, 4, 2, 
      0, 0, 0, 14, 4, 9, 0, 0, 0, 14, 4, 3, 0, 0, 0, 16, 
      4, 16, 4, 20, 2, 20, 2, 20, 4, 20, 4, 83, 32, 4, 16, 83, 
      33, 4, 17, 70, 32, 32, 33, 176, 34, 32, 18, 82, 32, 4, 83, 33, 
      4, 19, 70, 33, 32, 33, 153, 35, 33, 129, 34, 34, 35, 103, 34, 34, 
      24, 125, 34, 34, 25, 163, 32, 34, 70, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_horiz_add_s16_1991_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_horiz_add_s16_1991_ip");
      orc_program_set_backup_function (p, _backup_orc_mas4_horiz_add_s16_1991_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_constant (p, 4, 0x00000009, "c3");
      orc_program_add_constant (p, 4, 0x00000003, "c4");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_horiz_add_s16_1991_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_vert_sub_s16_1991 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 109, 97, 115, 52, 95, 118, 101, 114, 116, 
      95, 115, 117, 98, 95, 115, 49, 54, 95, 49, 57, 57, 49, 11, 2, 2, 
      12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14, 4, 9, 0, 
      0, 0, 16, 4, 16, 4, 20, 2, 20, 2, 20, 4, 20, 4, 70, 32, 
      5, 6, 176, 34, 32, 16, 70, 33, 4, 7, 153, 35, 33, 129, 34, 34, 
      35, 103, 34, 34, 24, 125, 34, 34, 25, 163, 32, 34, 98, 0, 0, 32, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_vert_sub_s16_1991);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_vert_sub_s16_1991");
      orc_program_set_backup_function (p, _backup_orc_mas4_vert_sub_s16_1991);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 4, 0x00000009, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_vert_sub_s16_1991 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_horiz_sub_s16_1991_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 30, 111, 114, 99, 95, 109, 97, 115, 52, 95, 104, 111, 114, 105, 
      122, 95, 115, 117, 98, 95, 115, 49, 54, 95, 49, 57, 57, 49, 95, 105, 
      112, 11, 2, 2, 12, 2, 2, 14, 4, 1, 0, 0, 0, 14, 4, 2, 
      0, 0, 0, 14, 4, 9, 0, 0, 0, 14, 4, 3, 0, 0, 0, 16, 
      4, 16, 4, 20, 2, 20, 2, 20, 4, 20, 4, 83, 32, 4, 16, 83, 
      33, 4, 17, 70, 32, 32, 33, 176, 34, 32, 18, 82, 32, 4, 83, 33, 
      4, 19, 70, 33, 32, 33, 153, 35, 33, 129, 34, 34, 35, 103, 34, 34, 
      24, 125, 34, 34, 25, 163, 32, 34, 98, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_horiz_sub_s16_1991_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_horiz_sub_s16_1991_ip");
      orc_program_set_backup_function (p, _backup_orc_mas4_horiz_sub_s16_1991_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_constant (p, 4, 0x00000009, "c3");
      orc_program_add_constant (p, 4, 0x00000003, "c4");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_horiz_sub_s16_1991_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_subtract_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 16, 111, 114, 99, 95, 115, 117, 98, 116, 114, 97, 99, 116, 95, 
      115, 49, 54, 11, 2, 2, 12, 2, 2, 12, 2, 2, 98, 0, 4, 5, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_subtract_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_subtract_s16");
      orc_program_set_backup_function (p, _backup_orc_subtract_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_subtract_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_s16_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 14, 111, 114, 99, 95, 97, 100, 100, 95, 115, 49, 54, 95, 117, 
      56, 11, 2, 2, 12, 2, 2, 12, 1, 1, 20, 2, 150, 32, 5, 70, 
      0, 32, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_s16_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_add_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_s16_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add_s16_u8_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 17, 111, 114, 99, 95, 97, 100, 100, 95, 115, 49, 54, 95, 
      117, 56, 95, 50, 100, 11, 2, 2, 12, 1, 1, 20, 2, 150, 32, 4, 
      70, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add_s16_u8_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_add_s16_u8_2d");
      orc_program_set_backup_function (p, _backup_orc_add_s16_u8_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add_s16_u8_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_convert_s16_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 115, 
      49, 54, 95, 117, 56, 11, 2, 2, 12, 1, 1, 150, 0, 4, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_convert_s16_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_convert_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_convert_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_convert_s16_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_convert_s16_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 115, 
      49, 54, 95, 115, 51, 50, 11, 2, 2, 12, 4, 4, 163, 0, 4, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_convert_s16_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_convert_s16_s32");
      orc_program_set_backup_function (p, _backup_orc_convert_s16_s32);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "convlw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_convert_s16_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_convert_u8_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 117, 
      56, 95, 115, 49, 54, 11, 1, 1, 12, 2, 2, 160, 0, 4, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_convert_u8_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_convert_u8_s16");
      orc_program_set_backup_function (p, _backup_orc_convert_u8_s16);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_convert_u8_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_convert_s32_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 99, 111, 110, 118, 101, 114, 116, 95, 115, 
      51, 50, 95, 115, 49, 54, 11, 4, 4, 12, 2, 2, 153, 0, 4, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_convert_s32_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_convert_s32_s16");
      orc_program_set_backup_function (p, _backup_orc_convert_s32_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "convswl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_convert_s32_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_offsetconvert_u8_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 111, 102, 102, 115, 101, 116, 99, 111, 110, 
      118, 101, 114, 116, 95, 117, 56, 95, 115, 49, 54, 11, 1, 1, 12, 2, 
      2, 14, 4, 128, 0, 0, 0, 20, 2, 70, 32, 4, 16, 160, 0, 32, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_u8_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_u8_s16");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_u8_s16);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_offsetconvert_u8_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_offsetconvert_u8_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 111, 102, 102, 115, 101, 116, 99, 111, 110, 
      118, 101, 114, 116, 95, 117, 56, 95, 115, 51, 50, 11, 1, 1, 12, 4, 
      4, 14, 4, 128, 0, 0, 0, 20, 4, 20, 2, 103, 32, 4, 16, 166, 
      33, 32, 160, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_u8_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_u8_s32");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_u8_s32);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_offsetconvert_u8_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_offsetconvert_s16_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 111, 102, 102, 115, 101, 116, 99, 111, 110, 
      118, 101, 114, 116, 95, 115, 49, 54, 95, 117, 56, 11, 2, 2, 12, 1, 
      1, 14, 4, 128, 0, 0, 0, 20, 2, 150, 32, 4, 98, 0, 32, 16, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_s16_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_offsetconvert_s16_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_offsetconvert_s32_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 111, 102, 102, 115, 101, 116, 99, 111, 110, 
      118, 101, 114, 116, 95, 115, 51, 50, 95, 117, 56, 11, 4, 4, 12, 1, 
      1, 14, 4, 128, 0, 0, 0, 20, 2, 150, 32, 4, 98, 32, 32, 16, 
      153, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_s32_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_s32_u8");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_s32_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_offsetconvert_s32_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_offsetconvert_s32_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 111, 114, 99, 95, 111, 102, 102, 115, 101, 116, 99, 111, 110, 
      118, 101, 114, 116, 95, 115, 51, 50, 95, 115, 49, 54, 11, 4, 4, 12, 
      2, 2, 14, 4, 128, 0, 0, 0, 20, 2, 98, 32, 4, 16, 153, 0, 
      32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_s32_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_s32_s16");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_s32_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_offsetconvert_s32_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_subtract_s16_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 115, 117, 98, 116, 114, 97, 99, 116, 95, 
      115, 49, 54, 95, 117, 56, 11, 2, 2, 12, 2, 2, 12, 1, 1, 20, 
      2, 150, 32, 5, 98, 0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_subtract_s16_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_subtract_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_subtract_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_subtract_s16_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_multiply_and_add_s16_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 27, 111, 114, 99, 95, 109, 117, 108, 116, 105, 112, 108, 121, 95, 
      97, 110, 100, 95, 97, 100, 100, 95, 115, 49, 54, 95, 117, 56, 11, 2, 
      2, 12, 2, 2, 12, 1, 1, 20, 2, 150, 32, 5, 89, 32, 32, 4, 
      70, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_multiply_and_add_s16_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_multiply_and_add_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_multiply_and_add_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_multiply_and_add_s16_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_s16_ns */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 16, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 115, 49, 54, 
      95, 110, 115, 11, 2, 2, 16, 2, 79, 0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_s16_ns);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_splat_s16_ns");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_ns);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_s16_ns = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_s32_ns */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 16, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 115, 51, 50, 
      95, 110, 115, 11, 4, 4, 16, 4, 112, 0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_s32_ns);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_splat_s32_ns");
      orc_program_set_backup_function (p, _backup_orc_splat_s32_ns);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter (p, 4, "p1");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_s32_ns = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_s16_2d_4xn */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 4, 7, 9, 20, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 
      115, 49, 54, 95, 50, 100, 95, 52, 120, 110, 11, 2, 2, 16, 2, 79, 
      0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_4xn);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 4);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s16_2d_4xn");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_4xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_s16_2d_4xn = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_s16_2d_8xn */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 9, 20, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 
      115, 49, 54, 95, 50, 100, 95, 56, 120, 110, 11, 2, 2, 16, 2, 79, 
      0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_8xn);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s16_2d_8xn");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_8xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_s16_2d_8xn = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_s16_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 16, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 115, 49, 
      54, 95, 50, 100, 11, 2, 2, 16, 2, 79, 0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_s16_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_s16_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_u8_ns */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 15, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 117, 56, 95, 
      110, 115, 11, 1, 1, 16, 1, 42, 0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_u8_ns);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_splat_u8_ns");
      orc_program_set_backup_function (p, _backup_orc_splat_u8_ns);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_parameter (p, 1, "p1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_u8_ns = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_u8_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 15, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 117, 56, 
      95, 50, 100, 11, 1, 1, 16, 1, 42, 0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_u8_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_u8_2d");
      orc_program_set_backup_function (p, _backup_orc_splat_u8_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_parameter (p, 1, "p1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_u8_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_average_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 14, 111, 114, 99, 95, 97, 118, 101, 114, 97, 103, 101, 95, 117, 
      56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 0, 4, 5, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_average_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_average_u8");
      orc_program_set_backup_function (p, _backup_orc_average_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_average_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_rrshift6_add_s16_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 23, 111, 114, 99, 95, 114, 114, 115, 104, 105, 102, 116, 54, 
      95, 97, 100, 100, 95, 115, 49, 54, 95, 50, 100, 11, 1, 1, 12, 2, 
      2, 12, 2, 2, 14, 4, 32, 0, 0, 0, 14, 4, 6, 0, 0, 0, 
      20, 2, 70, 32, 5, 16, 94, 32, 32, 17, 70, 32, 4, 32, 160, 0, 
      32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_rrshift6_add_s16_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_add_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_add_s16_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000020, "c1");
      orc_program_add_constant (p, 4, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_rrshift6_add_s16_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_rrshift6_add_s32_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 23, 111, 114, 99, 95, 114, 114, 115, 104, 105, 102, 116, 54, 
      95, 97, 100, 100, 95, 115, 51, 50, 95, 50, 100, 11, 1, 1, 12, 4, 
      4, 12, 2, 2, 14, 4, 32, 0, 0, 0, 14, 4, 6, 0, 0, 0, 
      20, 2, 20, 2, 70, 32, 5, 16, 94, 32, 32, 17, 163, 33, 4, 70, 
      32, 33, 32, 160, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_rrshift6_add_s32_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_add_s32_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_add_s32_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000020, "c1");
      orc_program_add_constant (p, 4, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_rrshift6_add_s32_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_rrshift6_sub_s16_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 23, 111, 114, 99, 95, 114, 114, 115, 104, 105, 102, 116, 54, 
      95, 115, 117, 98, 95, 115, 49, 54, 95, 50, 100, 11, 2, 2, 11, 2, 
      2, 14, 4, 224, 31, 0, 0, 14, 4, 6, 0, 0, 0, 20, 2, 98, 
      32, 1, 16, 94, 32, 32, 17, 79, 1, 32, 98, 0, 0, 32, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_rrshift6_sub_s16_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_sub_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_sub_s16_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 4, 0x00001fe0, "c1");
      orc_program_add_constant (p, 4, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_rrshift6_sub_s16_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_rrshift6_s16_ip_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 22, 111, 114, 99, 95, 114, 114, 115, 104, 105, 102, 116, 54, 
      95, 115, 49, 54, 95, 105, 112, 95, 50, 100, 11, 2, 2, 14, 4, 224, 
      31, 0, 0, 14, 4, 6, 0, 0, 0, 20, 2, 98, 32, 0, 16, 94, 
      0, 32, 17, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_s16_ip_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x00001fe0, "c1");
      orc_program_add_constant (p, 4, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_rrshift6_s16_ip_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_rrshift6_s16_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 114, 114, 115, 104, 105, 102, 116, 54, 95, 
      115, 49, 54, 95, 105, 112, 11, 2, 2, 14, 4, 224, 31, 0, 0, 14, 
      4, 6, 0, 0, 0, 20, 2, 98, 32, 0, 16, 94, 0, 32, 17, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_rrshift6_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x00001fe0, "c1");
      orc_program_add_constant (p, 4, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_rrshift6_s16_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_unpack_yuyv_y */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 117, 110, 112, 97, 99, 107, 95, 121, 117, 
      121, 118, 95, 121, 11, 1, 1, 12, 2, 2, 188, 0, 4, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_y);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_yuyv_y");
      orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_y);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_unpack_yuyv_y = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_unpack_yuyv_u */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 117, 110, 112, 97, 99, 107, 95, 121, 117, 
      121, 118, 95, 117, 11, 1, 1, 12, 4, 4, 20, 2, 190, 32, 4, 189, 
      0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_u);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_yuyv_u");
      orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_u);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_unpack_yuyv_u = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_unpack_yuyv_v */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 117, 110, 112, 97, 99, 107, 95, 121, 117, 
      121, 118, 95, 118, 11, 1, 1, 12, 4, 4, 20, 2, 191, 32, 4, 189, 
      0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_v);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_yuyv_v");
      orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_v);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_unpack_yuyv_v = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_packyuyv */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 12, 111, 114, 99, 95, 112, 97, 99, 107, 121, 117, 121, 118, 11, 
      4, 4, 12, 2, 2, 12, 1, 1, 12, 1, 1, 20, 1, 20, 1, 20, 
      2, 20, 2, 20, 2, 79, 36, 4, 188, 32, 36, 189, 33, 36, 196, 34, 
      32, 5, 196, 35, 33, 6, 195, 0, 34, 35, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_packyuyv);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_packyuyv");
      orc_program_set_backup_function (p, _backup_orc_packyuyv);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_packyuyv = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_unpack_uyvy_y */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 117, 110, 112, 97, 99, 107, 95, 117, 121, 
      118, 121, 95, 121, 11, 1, 1, 12, 2, 2, 189, 0, 4, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_y);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_uyvy_y");
      orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_y);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_unpack_uyvy_y = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_unpack_uyvy_u */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 117, 110, 112, 97, 99, 107, 95, 117, 121, 
      118, 121, 95, 117, 11, 1, 1, 12, 4, 4, 20, 2, 190, 32, 4, 188, 
      0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_u);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_uyvy_u");
      orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_u);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_unpack_uyvy_u = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_unpack_uyvy_v */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 117, 110, 112, 97, 99, 107, 95, 117, 121, 
      118, 121, 95, 118, 11, 1, 1, 12, 4, 4, 20, 2, 191, 32, 4, 188, 
      0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_v);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_uyvy_v");
      orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_v);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_unpack_uyvy_v = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_interleave2_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 105, 110, 116, 101, 114, 108, 101, 97, 118, 
      101, 50, 95, 115, 49, 54, 11, 4, 4, 12, 2, 2, 12, 2, 2, 195, 
      0, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_interleave2_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_interleave2_s16");
      orc_program_set_backup_function (p, _backup_orc_interleave2_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_interleave2_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_interleave2_rrshift1_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 28, 111, 114, 99, 95, 105, 110, 116, 101, 114, 108, 101, 97, 118, 
      101, 50, 95, 114, 114, 115, 104, 105, 102, 116, 49, 95, 115, 49, 54, 11, 
      4, 4, 12, 2, 2, 12, 2, 2, 14, 4, 1, 0, 0, 0, 20, 2, 
      20, 2, 70, 32, 4, 16, 94, 32, 32, 16, 70, 33, 5, 16, 94, 33, 
      33, 16, 195, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_interleave2_rrshift1_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_interleave2_rrshift1_s16");
      orc_program_set_backup_function (p, _backup_orc_interleave2_rrshift1_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_interleave2_rrshift1_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_deinterleave2_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 100, 101, 105, 110, 116, 101, 114, 108, 101, 
      97, 118, 101, 50, 95, 115, 49, 54, 11, 2, 2, 11, 2, 2, 12, 4, 
      4, 198, 1, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_deinterleave2_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_deinterleave2_s16");
      orc_program_set_backup_function (p, _backup_orc_deinterleave2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_deinterleave2_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_deinterleave2_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 100, 101, 105, 110, 116, 101, 114, 108, 101, 
      97, 118, 101, 50, 95, 115, 51, 50, 11, 4, 4, 11, 4, 4, 12, 8, 
      8, 197, 1, 0, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_deinterleave2_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_deinterleave2_s32");
      orc_program_set_backup_function (p, _backup_orc_deinterleave2_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "splitql", 0, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_deinterleave2_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_deinterleave2_lshift1_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 100, 101, 105, 110, 116, 101, 114, 108, 101, 
      97, 118, 101, 50, 95, 108, 115, 104, 105, 102, 116, 49, 95, 115, 49, 54, 
      11, 2, 2, 11, 2, 2, 12, 4, 4, 14, 4, 1, 0, 0, 0, 20, 
      4, 21, 1, 93, 32, 4, 16, 198, 1, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_deinterleave2_lshift1_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_deinterleave2_lshift1_s16");
      orc_program_set_backup_function (p, _backup_orc_deinterleave2_lshift1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "shlw", 1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_deinterleave2_lshift1_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_deinterleave2_lshift1_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 100, 101, 105, 110, 116, 101, 114, 108, 101, 
      97, 118, 101, 50, 95, 108, 115, 104, 105, 102, 116, 49, 95, 115, 51, 50, 
      11, 4, 4, 11, 4, 4, 12, 8, 8, 14, 4, 1, 0, 0, 0, 20, 
      8, 21, 1, 124, 32, 4, 16, 197, 1, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_deinterleave2_lshift1_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_deinterleave2_lshift1_s32");
      orc_program_set_backup_function (p, _backup_orc_deinterleave2_lshift1_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "shll", 1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitql", 0, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_deinterleave2_lshift1_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_deint_lshift1_split_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 32, 111, 114, 99, 95, 104, 97, 97, 114, 95, 100, 101, 105, 110, 
      116, 95, 108, 115, 104, 105, 102, 116, 49, 95, 115, 112, 108, 105, 116, 95, 
      115, 49, 54, 11, 2, 2, 11, 2, 2, 12, 4, 4, 14, 4, 1, 0, 
      0, 0, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 20, 4, 21, 1, 
      93, 34, 4, 16, 198, 33, 32, 34, 98, 33, 33, 32, 79, 1, 33, 75, 
      33, 33, 17, 70, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_deint_lshift1_split_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_deint_lshift1_split_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_deint_lshift1_split_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000000, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "shlw", 1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_deint_lshift1_split_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_deint_lshift1_split_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 32, 111, 114, 99, 95, 104, 97, 97, 114, 95, 100, 101, 105, 110, 
      116, 95, 108, 115, 104, 105, 102, 116, 49, 95, 115, 112, 108, 105, 116, 95, 
      115, 51, 50, 11, 4, 4, 11, 4, 4, 12, 8, 8, 14, 4, 1, 0, 
      0, 0, 14, 4, 0, 0, 0, 0, 20, 4, 20, 4, 20, 8, 21, 1, 
      124, 34, 4, 16, 197, 33, 32, 34, 129, 33, 33, 32, 112, 1, 33, 108, 
      33, 33, 17, 103, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_deint_lshift1_split_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_deint_lshift1_split_s32");
      orc_program_set_backup_function (p, _backup_orc_haar_deint_lshift1_split_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000000, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 8, "t3");

      orc_program_append_2 (p, "shll", 1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_deint_lshift1_split_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_deint_split_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 104, 97, 97, 114, 95, 100, 101, 105, 110, 
      116, 95, 115, 112, 108, 105, 116, 95, 115, 49, 54, 11, 2, 2, 11, 2, 
      2, 12, 4, 4, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 198, 33, 
      32, 4, 98, 33, 33, 32, 79, 1, 33, 75, 33, 33, 16, 70, 0, 32, 
      33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_deint_split_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_deint_split_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_deint_split_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_deint_split_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_deint_split_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 24, 111, 114, 99, 95, 104, 97, 97, 114, 95, 100, 101, 105, 110, 
      116, 95, 115, 112, 108, 105, 116, 95, 115, 51, 50, 11, 4, 4, 11, 4, 
      4, 12, 8, 8, 14, 4, 0, 0, 0, 0, 20, 4, 20, 4, 197, 33, 
      32, 4, 129, 33, 33, 32, 112, 1, 33, 108, 33, 33, 16, 103, 0, 32, 
      33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_deint_split_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_deint_split_s32");
      orc_program_set_backup_function (p, _backup_orc_haar_deint_split_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_deint_split_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_split_s16_lo */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 112, 108, 105, 
      116, 95, 115, 49, 54, 95, 108, 111, 11, 2, 2, 12, 2, 2, 12, 2, 
      2, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 79, 32, 4, 98, 33, 
      5, 32, 75, 33, 33, 16, 70, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16_lo);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16_lo");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16_lo);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_split_s16_lo = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_split_s16_hi */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 112, 108, 105, 
      116, 95, 115, 49, 54, 95, 104, 105, 11, 2, 2, 12, 2, 2, 12, 2, 
      2, 98, 0, 5, 4, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16_hi);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16_hi");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16_hi);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_S2, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_split_s16_hi = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_split_s16_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 112, 108, 105, 
      116, 95, 115, 49, 54, 95, 111, 112, 11, 2, 2, 11, 2, 2, 12, 2, 
      2, 12, 2, 2, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 79, 32, 
      4, 98, 33, 5, 32, 79, 1, 33, 75, 33, 33, 16, 70, 0, 32, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16_op");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_split_s16_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_split_s32_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 112, 108, 105, 
      116, 95, 115, 51, 50, 95, 111, 112, 11, 4, 4, 11, 4, 4, 12, 4, 
      4, 12, 4, 4, 14, 4, 0, 0, 0, 0, 20, 4, 20, 4, 112, 32, 
      4, 129, 33, 5, 32, 112, 1, 33, 108, 33, 33, 16, 103, 0, 32, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_split_s32_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s32_op");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s32_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_split_s32_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_split_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 112, 108, 105, 
      116, 95, 115, 49, 54, 11, 2, 2, 11, 2, 2, 14, 4, 0, 0, 0, 
      0, 20, 2, 20, 2, 79, 32, 0, 79, 33, 1, 98, 33, 33, 32, 79, 
      1, 33, 75, 33, 33, 16, 70, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_split_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_s16_lo */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 115, 49, 54, 95, 108, 111, 11, 2, 2, 12, 2, 2, 12, 2, 
      2, 14, 4, 0, 0, 0, 0, 20, 2, 75, 32, 5, 16, 98, 0, 4, 
      32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_lo);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16_lo");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_lo);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_s16_lo = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_s16_hi */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 115, 49, 54, 95, 104, 105, 11, 2, 2, 12, 2, 2, 12, 2, 
      2, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 20, 2, 79, 33, 5, 
      75, 34, 33, 16, 98, 32, 4, 34, 70, 0, 33, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_hi);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16_hi");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_hi);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_s16_hi = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_s16_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 115, 49, 54, 95, 111, 112, 11, 2, 2, 11, 2, 2, 12, 2, 
      2, 12, 2, 2, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 20, 2, 
      79, 33, 5, 75, 34, 33, 16, 98, 32, 4, 34, 79, 0, 32, 70, 1, 
      33, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16_op");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_s16_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 115, 49, 54, 11, 2, 2, 11, 2, 2, 14, 4, 0, 0, 0, 
      0, 20, 2, 20, 2, 20, 2, 79, 32, 0, 79, 33, 1, 75, 34, 33, 
      16, 98, 32, 32, 34, 79, 0, 32, 70, 1, 33, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_rrshift1_int_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 114, 114, 115, 104, 105, 102, 116, 49, 95, 105, 110, 116, 95, 115, 
      49, 54, 11, 4, 4, 12, 2, 2, 12, 2, 2, 14, 4, 0, 0, 0, 
      0, 20, 2, 20, 2, 79, 33, 5, 75, 32, 33, 16, 98, 32, 4, 32, 
      70, 33, 33, 32, 75, 32, 32, 16, 75, 33, 33, 16, 195, 0, 32, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_rrshift1_int_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_rrshift1_int_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_rrshift1_int_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_rrshift1_int_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_int_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 22, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 105, 110, 116, 95, 115, 49, 54, 11, 4, 4, 12, 2, 2, 12, 
      2, 2, 14, 4, 0, 0, 0, 0, 20, 2, 20, 2, 79, 33, 5, 75, 
      32, 33, 16, 98, 32, 4, 32, 70, 33, 33, 32, 195, 0, 32, 33, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_int_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_int_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_int_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_int_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_sub_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 16, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 117, 98, 95, 
      115, 49, 54, 11, 2, 2, 12, 2, 2, 98, 0, 0, 4, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_sub_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_sub_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_sub_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_sub_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_add_half_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 97, 100, 100, 95, 
      104, 97, 108, 102, 95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 
      0, 0, 0, 0, 20, 2, 75, 32, 4, 16, 70, 0, 0, 32, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_add_half_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_add_half_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_add_half_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_add_half_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_add_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 16, 111, 114, 99, 95, 104, 97, 97, 114, 95, 97, 100, 100, 95, 
      115, 49, 54, 11, 2, 2, 12, 2, 2, 70, 0, 0, 4, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_add_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_add_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_add_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_add_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_sub_half_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 117, 98, 95, 
      104, 97, 108, 102, 95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 
      0, 0, 0, 0, 20, 2, 75, 32, 4, 16, 98, 0, 0, 32, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_sub_half_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_sub_half_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_sub_half_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "avgsw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_sub_half_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sum_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 10, 111, 114, 99, 95, 115, 117, 109, 95, 117, 56, 12, 1, 1, 
      13, 4, 20, 2, 20, 4, 150, 32, 4, 154, 33, 32, 181, 12, 33, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sum_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_sum_u8");
      orc_program_set_backup_function (p, _backup_orc_sum_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accl", 0, ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sum_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sum_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 11, 111, 114, 99, 95, 115, 117, 109, 95, 115, 49, 54, 12, 2, 
      2, 13, 4, 20, 4, 153, 32, 4, 181, 12, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sum_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_sum_s16");
      orc_program_set_backup_function (p, _backup_orc_sum_s16);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accl", 0, ORC_VAR_A1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sum_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sum_square_diff_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 22, 111, 114, 99, 95, 115, 117, 109, 95, 115, 113, 117, 97, 114, 
      101, 95, 100, 105, 102, 102, 95, 117, 56, 12, 1, 1, 12, 1, 1, 13, 
      4, 20, 2, 20, 2, 20, 4, 150, 32, 4, 150, 33, 5, 98, 32, 32, 
      33, 89, 32, 32, 32, 154, 34, 32, 181, 12, 34, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sum_square_diff_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_sum_square_diff_u8");
      orc_program_set_backup_function (p, _backup_orc_sum_square_diff_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accl", 0, ORC_VAR_A1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sum_square_diff_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s16_2d_4xn */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 4, 7, 9, 25, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 
      116, 105, 115, 101, 95, 115, 49, 54, 95, 50, 100, 95, 52, 120, 110, 11, 
      2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 0, 16, 2, 16, 2, 20, 
      2, 20, 2, 79, 32, 4, 96, 33, 32, 69, 32, 32, 89, 32, 32, 24, 
      70, 32, 32, 25, 94, 32, 32, 16, 89, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_4xn);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 4);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_2d_4xn");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_4xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s16_2d_4xn = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s16_2d_8xn */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 9, 25, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 
      116, 105, 115, 101, 95, 115, 49, 54, 95, 50, 100, 95, 56, 120, 110, 11, 
      2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 0, 16, 2, 16, 2, 20, 
      2, 20, 2, 79, 32, 4, 96, 33, 32, 69, 32, 32, 89, 32, 32, 24, 
      70, 32, 32, 25, 94, 32, 32, 16, 89, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_8xn);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_2d_8xn");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_8xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s16_2d_8xn = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s16_ip_2d_8xn */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 9, 28, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 
      116, 105, 115, 101, 95, 115, 49, 54, 95, 105, 112, 95, 50, 100, 95, 56, 
      120, 110, 11, 2, 2, 14, 4, 2, 0, 0, 0, 16, 2, 16, 2, 20, 
      2, 20, 2, 79, 32, 0, 96, 33, 32, 69, 32, 32, 89, 32, 32, 24, 
      70, 32, 32, 25, 94, 32, 32, 16, 89, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d_8xn);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_ip_2d_8xn");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d_8xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s16_ip_2d_8xn = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s16_ip_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 24, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 116, 105, 
      115, 101, 95, 115, 49, 54, 95, 105, 112, 95, 50, 100, 11, 2, 2, 14, 
      4, 2, 0, 0, 0, 16, 2, 16, 2, 20, 2, 20, 2, 79, 32, 0, 
      96, 33, 32, 69, 32, 32, 89, 32, 32, 24, 70, 32, 32, 25, 94, 32, 
      32, 16, 89, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_ip_2d");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s16_ip_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s16_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 116, 105, 115, 
      101, 95, 115, 49, 54, 95, 105, 112, 11, 2, 2, 14, 4, 2, 0, 0, 
      0, 16, 2, 16, 2, 20, 2, 20, 2, 79, 32, 0, 96, 33, 32, 69, 
      32, 32, 89, 32, 32, 24, 70, 32, 32, 25, 94, 32, 32, 16, 89, 0, 
      32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_dequantise_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s16_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 116, 105, 115, 
      101, 95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 
      0, 16, 2, 16, 2, 20, 2, 20, 2, 79, 32, 4, 96, 33, 32, 69, 
      32, 32, 89, 32, 32, 24, 70, 32, 32, 25, 94, 32, 32, 16, 89, 0, 
      32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_dequantise_s16");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_var_s16_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 25, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 116, 105, 115, 
      101, 95, 118, 97, 114, 95, 115, 49, 54, 95, 105, 112, 11, 2, 2, 12, 
      2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 0, 20, 2, 20, 2, 79, 
      32, 0, 96, 33, 32, 69, 32, 32, 89, 32, 32, 4, 70, 32, 32, 5, 
      94, 32, 32, 16, 89, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_var_s16_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_dequantise_var_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_dequantise_var_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_var_s16_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_quantise1_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 113, 117, 97, 110, 116, 105, 115, 101, 49, 
      95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 0, 
      16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 79, 32, 4, 96, 33, 32, 
      69, 32, 32, 93, 32, 32, 16, 98, 32, 32, 25, 91, 32, 32, 24, 95, 
      32, 32, 26, 89, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_quantise1_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantise1_s16");
      orc_program_set_backup_function (p, _backup_orc_quantise1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhuw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_quantise1_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_quantise2_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 17, 111, 114, 99, 95, 113, 117, 97, 110, 116, 105, 115, 101, 50, 
      95, 115, 49, 54, 11, 2, 2, 12, 2, 2, 14, 4, 2, 0, 0, 0, 
      16, 2, 16, 2, 20, 2, 20, 2, 79, 32, 4, 96, 33, 32, 69, 32, 
      32, 93, 32, 32, 16, 98, 32, 32, 25, 95, 32, 32, 24, 89, 0, 32, 
      33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_quantise2_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantise2_s16");
      orc_program_set_backup_function (p, _backup_orc_quantise2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_quantise2_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_quantdequant1_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 113, 117, 97, 110, 116, 100, 101, 113, 117, 
      97, 110, 116, 49, 95, 115, 49, 54, 11, 2, 2, 11, 2, 2, 14, 4, 
      2, 0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 
      20, 2, 79, 32, 1, 96, 33, 32, 69, 32, 32, 93, 32, 32, 16, 98, 
      32, 32, 25, 91, 32, 32, 24, 95, 32, 32, 26, 89, 33, 32, 33, 79, 
      0, 33, 96, 33, 33, 89, 32, 32, 27, 70, 32, 32, 28, 94, 32, 32, 
      16, 89, 1, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_quantdequant1_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantdequant1_s16");
      orc_program_set_backup_function (p, _backup_orc_quantdequant1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhuw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_quantdequant1_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_quantdequant3_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 113, 117, 97, 110, 116, 100, 101, 113, 117, 
      97, 110, 116, 51, 95, 115, 49, 54, 11, 2, 2, 11, 2, 2, 14, 4, 
      2, 0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 4, 
      20, 2, 20, 2, 20, 4, 79, 32, 1, 96, 33, 32, 69, 32, 32, 93, 
      32, 32, 16, 98, 32, 32, 25, 177, 34, 32, 24, 103, 34, 34, 29, 126, 
      34, 34, 26, 163, 32, 34, 89, 33, 32, 33, 79, 0, 33, 96, 33, 33, 
      89, 32, 32, 27, 70, 32, 32, 28, 94, 32, 32, 16, 89, 1, 32, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_quantdequant3_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantdequant3_s16");
      orc_program_set_backup_function (p, _backup_orc_quantdequant3_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_parameter (p, 4, "p6");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "muluwl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P6, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_quantdequant3_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_quantdequant2_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 113, 117, 97, 110, 116, 100, 101, 113, 117, 
      97, 110, 116, 50, 95, 115, 49, 54, 11, 2, 2, 11, 2, 2, 14, 4, 
      2, 0, 0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 
      79, 32, 1, 96, 33, 32, 69, 32, 32, 93, 32, 32, 16, 98, 32, 32, 
      25, 95, 32, 32, 24, 89, 33, 32, 33, 79, 0, 33, 96, 33, 33, 89, 
      32, 32, 26, 70, 32, 32, 27, 94, 32, 32, 16, 89, 1, 32, 33, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_quantdequant2_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantdequant2_s16");
      orc_program_set_backup_function (p, _backup_orc_quantdequant2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_quantdequant2_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_downsample_vert_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 22, 111, 114, 99, 95, 100, 111, 119, 110, 115, 97, 109, 112, 108, 
      101, 95, 118, 101, 114, 116, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 
      1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 6, 0, 0, 0, 14, 4, 
      26, 0, 0, 0, 14, 4, 32, 0, 0, 0, 20, 2, 20, 2, 20, 2, 
      150, 32, 4, 150, 33, 7, 70, 32, 32, 33, 89, 32, 32, 16, 150, 33, 
      5, 150, 34, 6, 70, 33, 33, 34, 89, 33, 33, 17, 70, 33, 33, 32, 
      70, 33, 33, 18, 95, 33, 33, 16, 157, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_downsample_vert_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_downsample_vert_u8");
      orc_program_set_backup_function (p, _backup_orc_downsample_vert_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000006, "c1");
      orc_program_add_constant (p, 4, 0x0000001a, "c2");
      orc_program_add_constant (p, 4, 0x00000020, "c3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_downsample_vert_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_downsample_horiz_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 23, 111, 114, 99, 95, 100, 111, 119, 110, 115, 97, 109, 112, 108, 
      101, 95, 104, 111, 114, 105, 122, 95, 117, 56, 11, 1, 1, 12, 2, 2, 
      14, 4, 2, 0, 0, 0, 14, 4, 6, 0, 0, 0, 14, 4, 1, 0, 
      0, 0, 14, 4, 26, 0, 0, 0, 14, 4, 32, 0, 0, 0, 20, 2, 
      20, 2, 20, 2, 20, 1, 20, 1, 20, 2, 82, 34, 4, 189, 35, 34, 
      150, 32, 35, 83, 34, 4, 16, 188, 35, 34, 150, 33, 35, 70, 37, 32, 
      33, 89, 37, 37, 17, 83, 34, 4, 18, 199, 35, 36, 34, 150, 32, 35, 
      150, 33, 36, 70, 32, 32, 33, 89, 32, 32, 19, 70, 37, 37, 32, 70, 
      37, 37, 20, 95, 37, 37, 17, 157, 0, 37, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_downsample_horiz_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_downsample_horiz_u8");
      orc_program_set_backup_function (p, _backup_orc_downsample_horiz_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_constant (p, 4, 0x00000006, "c2");
      orc_program_add_constant (p, 4, 0x00000001, "c3");
      orc_program_add_constant (p, 4, 0x0000001a, "c4");
      orc_program_add_constant (p, 4, 0x00000020, "c5");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 2, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_D1, ORC_VAR_T6, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_downsample_horiz_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_stats_moment_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 20, 111, 114, 99, 95, 115, 116, 97, 116, 115, 95, 109, 111, 109, 
      101, 110, 116, 95, 115, 49, 54, 12, 2, 2, 13, 4, 14, 4, 2, 0, 
      0, 0, 14, 4, 0, 0, 0, 0, 20, 2, 20, 4, 69, 32, 4, 98, 
      32, 32, 16, 85, 32, 32, 17, 154, 33, 32, 181, 12, 33, 2, 0,     };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_stats_moment_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_stats_moment_s16");
      orc_program_set_backup_function (p, _backup_orc_stats_moment_s16);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_constant (p, 4, 0x00000000, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "maxsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accl", 0, ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_stats_moment_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_stats_above_s16 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 115, 116, 97, 116, 115, 95, 97, 98, 111, 
      118, 101, 95, 115, 49, 54, 12, 2, 2, 13, 4, 14, 4, 1, 0, 0, 
      0, 14, 4, 0, 0, 0, 0, 20, 2, 20, 4, 69, 32, 4, 98, 32, 
      32, 16, 85, 32, 32, 17, 87, 32, 32, 16, 154, 33, 32, 181, 12, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_stats_above_s16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_stats_above_s16");
      orc_program_set_backup_function (p, _backup_orc_stats_above_s16);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000000, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "maxsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "minsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accl", 0, ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_stats_above_s16 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_accw */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 8, 111, 114, 99, 95, 97, 99, 99, 119, 12, 2, 2, 13, 2, 
      20, 2, 69, 32, 4, 180, 12, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_accw);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_accw");
      orc_program_set_backup_function (p, _backup_orc_accw);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 2, "a1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "absw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accw", 0, ORC_VAR_A1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_accw = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_avg2_8xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 9, 15, 111, 114, 99, 95, 97, 118, 103, 50, 95, 56, 
      120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 0, 
      4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_avg2_8xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_8xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_8xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_avg2_8xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_avg2_12xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 12, 7, 9, 16, 111, 114, 99, 95, 97, 118, 103, 50, 95, 49, 
      50, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 
      0, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_avg2_12xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_12xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_12xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_avg2_12xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_avg2_16xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 16, 7, 9, 16, 111, 114, 99, 95, 97, 118, 103, 50, 95, 49, 
      54, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 
      0, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_avg2_16xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_16xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_avg2_16xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_avg2_32xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 32, 7, 9, 16, 111, 114, 99, 95, 97, 118, 103, 50, 95, 51, 
      50, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 
      0, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_avg2_32xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_32xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_32xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_avg2_32xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_avg2_nxm_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 15, 111, 114, 99, 95, 97, 118, 103, 50, 95, 110, 120, 109, 
      95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 0, 4, 5, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_avg2_nxm_u8);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_nxm_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_avg2_nxm_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine4_8xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 9, 19, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 52, 95, 56, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 
      1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 8, 0, 0, 0, 16, 2, 
      16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 33, 32, 
      24, 150, 32, 5, 89, 32, 32, 25, 70, 33, 33, 32, 150, 32, 6, 89, 
      32, 32, 26, 70, 33, 33, 32, 150, 32, 7, 89, 32, 32, 27, 70, 33, 
      33, 32, 70, 33, 33, 16, 160, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine4_8xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_8xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_8xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine4_8xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine4_12xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 12, 7, 9, 20, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 52, 95, 49, 50, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 
      12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 8, 0, 0, 0, 16, 
      2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 33, 
      32, 24, 150, 32, 5, 89, 32, 32, 25, 70, 33, 33, 32, 150, 32, 6, 
      89, 32, 32, 26, 70, 33, 33, 32, 150, 32, 7, 89, 32, 32, 27, 70, 
      33, 33, 32, 70, 33, 33, 16, 160, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine4_12xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_12xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_12xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine4_12xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine4_16xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 16, 7, 9, 20, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 52, 95, 49, 54, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 
      12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 8, 0, 0, 0, 16, 
      2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 33, 
      32, 24, 150, 32, 5, 89, 32, 32, 25, 70, 33, 33, 32, 150, 32, 6, 
      89, 32, 32, 26, 70, 33, 33, 32, 150, 32, 7, 89, 32, 32, 27, 70, 
      33, 33, 32, 70, 33, 33, 16, 160, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine4_16xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_16xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine4_16xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine4_24xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 24, 7, 9, 20, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 52, 95, 50, 52, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 
      12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 8, 0, 0, 0, 16, 
      2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 33, 
      32, 24, 150, 32, 5, 89, 32, 32, 25, 70, 33, 33, 32, 150, 32, 6, 
      89, 32, 32, 26, 70, 33, 33, 32, 150, 32, 7, 89, 32, 32, 27, 70, 
      33, 33, 32, 70, 33, 33, 16, 160, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine4_24xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 24);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_24xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_24xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine4_24xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine4_32xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 32, 7, 9, 20, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 52, 95, 51, 50, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 
      12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 8, 0, 0, 0, 16, 
      2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 33, 
      32, 24, 150, 32, 5, 89, 32, 32, 25, 70, 33, 33, 32, 150, 32, 6, 
      89, 32, 32, 26, 70, 33, 33, 32, 150, 32, 7, 89, 32, 32, 27, 70, 
      33, 33, 32, 70, 33, 33, 16, 160, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine4_32xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_32xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_32xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine4_32xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine4_nxm_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 19, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 101, 52, 
      95, 110, 120, 109, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 
      12, 1, 1, 12, 1, 1, 14, 4, 8, 0, 0, 0, 14, 4, 4, 0, 
      0, 0, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 
      4, 89, 33, 32, 24, 150, 32, 5, 89, 32, 32, 25, 70, 33, 33, 32, 
      150, 32, 6, 89, 32, 32, 26, 70, 33, 33, 32, 150, 32, 7, 89, 32, 
      32, 27, 70, 33, 33, 32, 70, 33, 33, 16, 94, 33, 33, 17, 160, 0, 
      33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine4_nxm_u8);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_nxm_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000004, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine4_nxm_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine2_8xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 9, 19, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 50, 95, 56, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 
      1, 1, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 
      4, 150, 33, 5, 89, 32, 32, 24, 89, 33, 33, 25, 70, 32, 32, 33, 
      70, 32, 32, 26, 94, 32, 32, 27, 160, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine2_8xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_8xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_8xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine2_8xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine2_12xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 12, 7, 9, 20, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 50, 95, 49, 50, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 
      12, 1, 1, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 
      32, 4, 150, 33, 5, 89, 32, 32, 24, 89, 33, 33, 25, 70, 32, 32, 
      33, 70, 32, 32, 26, 94, 32, 32, 27, 160, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine2_12xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_12xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_12xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine2_12xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine2_16xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 16, 7, 9, 20, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 
      101, 50, 95, 49, 54, 120, 110, 95, 117, 56, 11, 1, 1, 12, 1, 1, 
      12, 1, 1, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 
      32, 4, 150, 33, 5, 89, 32, 32, 24, 89, 33, 33, 25, 70, 32, 32, 
      33, 70, 32, 32, 26, 94, 32, 32, 27, 160, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine2_16xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_16xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine2_16xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_combine2_nxm_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 19, 111, 114, 99, 95, 99, 111, 109, 98, 105, 110, 101, 50, 
      95, 110, 120, 109, 95, 117, 56, 11, 1, 1, 12, 1, 1, 12, 1, 1, 
      16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 150, 
      33, 5, 89, 32, 32, 24, 89, 33, 33, 25, 70, 32, 32, 33, 70, 32, 
      32, 26, 94, 32, 32, 27, 160, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_combine2_nxm_u8);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_nxm_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_combine2_nxm_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sad_nxm_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 14, 111, 114, 99, 95, 115, 97, 100, 95, 110, 120, 109, 95, 
      117, 56, 12, 1, 1, 12, 1, 1, 13, 4, 182, 12, 4, 5, 2, 0, 

    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sad_nxm_u8);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_sad_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_nxm_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sad_nxm_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sad_8x8_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 8, 7, 8, 8, 9, 14, 111, 114, 99, 95, 115, 97, 100, 95, 
      56, 120, 56, 95, 117, 56, 12, 1, 1, 12, 1, 1, 13, 4, 182, 12, 
      4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sad_8x8_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_constant_m (p, 8);
      orc_program_set_name (p, "orc_sad_8x8_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_8x8_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sad_8x8_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sad_12x12_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 12, 7, 8, 12, 9, 16, 111, 114, 99, 95, 115, 97, 100, 95, 
      49, 50, 120, 49, 50, 95, 117, 56, 12, 1, 1, 12, 1, 1, 13, 4, 
      182, 12, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sad_12x12_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_constant_m (p, 12);
      orc_program_set_name (p, "orc_sad_12x12_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_12x12_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sad_12x12_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sad_16xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 16, 7, 9, 15, 111, 114, 99, 95, 115, 97, 100, 95, 49, 54, 
      120, 110, 95, 117, 56, 12, 1, 1, 12, 1, 1, 13, 4, 182, 12, 4, 
      5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sad_16xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_sad_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_16xn_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sad_16xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_sad_32xn_u8 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 3, 32, 7, 9, 15, 111, 114, 99, 95, 115, 97, 100, 95, 51, 50, 
      120, 110, 95, 117, 56, 12, 1, 1, 12, 1, 1, 13, 4, 182, 12, 4, 
      5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_sad_32xn_u8);
#else
      p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_sad_32xn_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_32xn_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_sad_32xn_u8 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s32_22_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 51, 50, 95, 50, 50, 95, 111, 112, 
      11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 14, 4, 2, 0, 
      0, 0, 20, 4, 103, 32, 5, 6, 103, 32, 32, 16, 125, 32, 32, 16, 
      103, 0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_22_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s32_22_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_22_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s32_22_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_vert_add_s32_1991_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 109, 97, 115, 52, 95, 118, 101, 114, 116, 
      95, 97, 100, 100, 95, 115, 51, 50, 95, 49, 57, 57, 49, 95, 111, 112, 
      11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 
      4, 4, 14, 4, 9, 0, 0, 0, 16, 4, 16, 4, 20, 4, 20, 4, 
      20, 4, 20, 4, 103, 32, 6, 7, 120, 34, 32, 16, 103, 33, 5, 8, 
      129, 34, 34, 33, 103, 34, 34, 24, 125, 34, 34, 25, 103, 0, 4, 34, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_vert_add_s32_1991_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_vert_add_s32_1991_op");
      orc_program_set_backup_function (p, _backup_orc_mas4_vert_add_s32_1991_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_source (p, 4, "s4");
      orc_program_add_source (p, 4, "s5");
      orc_program_add_constant (p, 4, 0x00000009, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S5, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T3, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_vert_add_s32_1991_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s32_22_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 51, 50, 95, 50, 50, 95, 111, 112, 
      11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 14, 4, 2, 0, 
      0, 0, 20, 4, 103, 32, 5, 6, 103, 32, 32, 16, 125, 32, 32, 16, 
      129, 0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_22_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s32_22_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_22_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s32_22_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_interleave2_rrshift1_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 28, 111, 114, 99, 95, 105, 110, 116, 101, 114, 108, 101, 97, 118, 
      101, 50, 95, 114, 114, 115, 104, 105, 102, 116, 49, 95, 115, 51, 50, 11, 
      8, 8, 12, 4, 4, 12, 4, 4, 14, 4, 1, 0, 0, 0, 20, 4, 
      20, 4, 103, 32, 4, 16, 125, 32, 32, 16, 103, 33, 5, 16, 125, 33, 
      33, 16, 194, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_interleave2_rrshift1_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_interleave2_rrshift1_s32");
      orc_program_set_backup_function (p, _backup_orc_interleave2_rrshift1_s32);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_interleave2_rrshift1_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_vert_sub_s32_1991_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 109, 97, 115, 52, 95, 118, 101, 114, 116, 
      95, 115, 117, 98, 95, 115, 51, 50, 95, 49, 57, 57, 49, 95, 111, 112, 
      11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 
      4, 4, 14, 4, 9, 0, 0, 0, 16, 4, 16, 4, 20, 4, 20, 4, 
      20, 4, 20, 4, 103, 32, 6, 7, 120, 34, 32, 16, 103, 33, 5, 8, 
      129, 34, 34, 33, 103, 34, 34, 24, 125, 34, 34, 25, 129, 0, 4, 34, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_vert_sub_s32_1991_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_vert_sub_s32_1991_op");
      orc_program_set_backup_function (p, _backup_orc_mas4_vert_sub_s32_1991_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_source (p, 4, "s4");
      orc_program_add_source (p, 4, "s5");
      orc_program_add_constant (p, 4, 0x00000009, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S5, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T3, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_vert_sub_s32_1991_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_vert_sub_s32_1991 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 109, 97, 115, 52, 95, 118, 101, 114, 116, 
      95, 115, 117, 98, 95, 115, 51, 50, 95, 49, 57, 57, 49, 11, 4, 4, 
      12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 14, 4, 9, 0, 
      0, 0, 16, 4, 16, 4, 20, 4, 20, 4, 20, 4, 20, 4, 103, 32, 
      5, 6, 120, 34, 32, 16, 103, 33, 4, 7, 129, 34, 34, 33, 103, 34, 
      34, 24, 125, 34, 34, 25, 129, 0, 0, 34, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_vert_sub_s32_1991);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_vert_sub_s32_1991");
      orc_program_set_backup_function (p, _backup_orc_mas4_vert_sub_s32_1991);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_source (p, 4, "s4");
      orc_program_add_constant (p, 4, 0x00000009, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_vert_sub_s32_1991 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_horiz_add_s32_1991_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 30, 111, 114, 99, 95, 109, 97, 115, 52, 95, 104, 111, 114, 105, 
      122, 95, 97, 100, 100, 95, 115, 51, 50, 95, 49, 57, 57, 49, 95, 105, 
      112, 11, 4, 4, 12, 4, 4, 14, 4, 1, 0, 0, 0, 14, 4, 2, 
      0, 0, 0, 14, 4, 9, 0, 0, 0, 14, 4, 3, 0, 0, 0, 16, 
      4, 16, 4, 20, 4, 20, 4, 20, 4, 20, 4, 114, 32, 4, 16, 114, 
      33, 4, 17, 103, 32, 32, 33, 120, 34, 32, 18, 113, 32, 4, 114, 33, 
      4, 19, 103, 33, 32, 33, 129, 34, 34, 33, 103, 34, 34, 24, 125, 34, 
      34, 25, 103, 0, 0, 34, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_horiz_add_s32_1991_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_horiz_add_s32_1991_ip");
      orc_program_set_backup_function (p, _backup_orc_mas4_horiz_add_s32_1991_ip);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_constant (p, 4, 0x00000009, "c3");
      orc_program_add_constant (p, 4, 0x00000003, "c4");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_horiz_add_s32_1991_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s32_11_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 29, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 51, 50, 95, 49, 49, 95, 111, 112, 
      11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 20, 4, 108, 32, 
      5, 6, 103, 0, 4, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_11_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s32_11_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_11_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s32_11_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas4_horiz_sub_s32_1991_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 30, 111, 114, 99, 95, 109, 97, 115, 52, 95, 104, 111, 114, 105, 
      122, 95, 115, 117, 98, 95, 115, 51, 50, 95, 49, 57, 57, 49, 95, 105, 
      112, 11, 4, 4, 12, 4, 4, 14, 4, 1, 0, 0, 0, 14, 4, 2, 
      0, 0, 0, 14, 4, 9, 0, 0, 0, 14, 4, 3, 0, 0, 0, 16, 
      4, 16, 4, 20, 4, 20, 4, 20, 4, 20, 4, 114, 32, 4, 16, 114, 
      33, 4, 17, 103, 32, 32, 33, 120, 34, 32, 18, 113, 32, 4, 114, 33, 
      4, 19, 103, 33, 32, 33, 129, 34, 34, 33, 103, 34, 34, 24, 125, 34, 
      34, 25, 129, 0, 0, 34, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas4_horiz_sub_s32_1991_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_horiz_sub_s32_1991_ip");
      orc_program_set_backup_function (p, _backup_orc_mas4_horiz_sub_s32_1991_ip);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_constant (p, 4, 0x00000009, "c3");
      orc_program_add_constant (p, 4, 0x00000003, "c4");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas4_horiz_sub_s32_1991_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_s32_lo */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 21, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 115, 51, 50, 95, 108, 111, 11, 4, 4, 12, 4, 4, 12, 4, 
      4, 14, 4, 0, 0, 0, 0, 20, 4, 108, 32, 5, 16, 129, 0, 4, 
      32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s32_lo);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s32_lo");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s32_lo);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_s32_lo = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_int_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 22, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 105, 110, 116, 95, 115, 51, 50, 11, 8, 8, 12, 4, 4, 12, 
      4, 4, 14, 4, 0, 0, 0, 0, 20, 4, 20, 4, 112, 33, 5, 108, 
      32, 33, 16, 129, 32, 4, 32, 103, 33, 33, 32, 194, 0, 32, 33, 2, 
      0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_int_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_int_s32");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_int_s32);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_int_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_rrshift1_int_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 31, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 114, 114, 115, 104, 105, 102, 116, 49, 95, 105, 110, 116, 95, 115, 
      51, 50, 11, 8, 8, 12, 4, 4, 12, 4, 4, 14, 4, 0, 0, 0, 
      0, 20, 4, 20, 4, 112, 33, 5, 108, 32, 33, 16, 129, 32, 4, 32, 
      103, 33, 33, 32, 108, 32, 32, 16, 108, 33, 33, 16, 194, 0, 32, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_rrshift1_int_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_rrshift1_int_s32");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_rrshift1_int_s32);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_rrshift1_int_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_interleave2_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 105, 110, 116, 101, 114, 108, 101, 97, 118, 
      101, 50, 95, 115, 51, 50, 11, 8, 8, 12, 4, 4, 12, 4, 4, 194, 
      0, 4, 5, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_interleave2_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_interleave2_s32");
      orc_program_set_backup_function (p, _backup_orc_interleave2_s32);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");

      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_interleave2_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_sub_s32_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 115, 117, 98, 95, 
      115, 51, 50, 95, 105, 112, 11, 4, 4, 12, 4, 4, 14, 4, 1, 0, 
      0, 0, 16, 4, 16, 4, 16, 4, 20, 4, 20, 4, 114, 32, 4, 16, 
      103, 32, 4, 32, 120, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 
      129, 0, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_sub_s32_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_sub_s32_ip");
      orc_program_set_backup_function (p, _backup_orc_mas2_sub_s32_ip);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_sub_s32_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_add_s32_ip */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 97, 100, 100, 95, 
      115, 51, 50, 95, 105, 112, 11, 4, 4, 12, 4, 4, 14, 4, 1, 0, 
      0, 0, 16, 4, 16, 4, 16, 4, 20, 4, 20, 4, 114, 32, 4, 16, 
      103, 32, 4, 32, 120, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 
      103, 0, 0, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_add_s32_ip);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_add_s32_ip");
      orc_program_set_backup_function (p, _backup_orc_mas2_add_s32_ip);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_add_s32_ip = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_add_s32_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 97, 100, 100, 95, 
      115, 51, 50, 95, 111, 112, 11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 
      4, 4, 16, 4, 16, 4, 16, 4, 20, 4, 20, 4, 103, 32, 5, 6, 
      120, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 103, 0, 4, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_add_s32_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_add_s32_op");
      orc_program_set_backup_function (p, _backup_orc_mas2_add_s32_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_add_s32_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_mas2_sub_s32_op */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 19, 111, 114, 99, 95, 109, 97, 115, 50, 95, 115, 117, 98, 95, 
      115, 51, 50, 95, 111, 112, 11, 4, 4, 12, 4, 4, 12, 4, 4, 12, 
      4, 4, 16, 4, 16, 4, 16, 4, 20, 4, 20, 4, 103, 32, 5, 6, 
      120, 33, 32, 24, 103, 33, 33, 25, 125, 33, 33, 26, 129, 0, 4, 33, 
      2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_mas2_sub_s32_op);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_sub_s32_op");
      orc_program_set_backup_function (p, _backup_orc_mas2_sub_s32_op);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_mas2_sub_s32_op = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_sub_s32_22 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 115, 117, 98, 95, 115, 51, 50, 95, 50, 50, 11, 4, 4, 
      12, 4, 4, 14, 4, 1, 0, 0, 0, 14, 4, 2, 0, 0, 0, 20, 
      4, 114, 32, 4, 16, 103, 32, 4, 32, 103, 32, 32, 17, 125, 32, 32, 
      17, 129, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_22);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s32_22");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s32_22);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_sub_s32_22 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_add2_rshift_add_s32_11 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 26, 111, 114, 99, 95, 97, 100, 100, 50, 95, 114, 115, 104, 105, 
      102, 116, 95, 97, 100, 100, 95, 115, 51, 50, 95, 49, 49, 11, 4, 4, 
      12, 4, 4, 14, 4, 1, 0, 0, 0, 20, 4, 114, 32, 4, 16, 108, 
      32, 4, 32, 103, 0, 0, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_11);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s32_11");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s32_11);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "loadoffl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_add2_rshift_add_s32_11 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_haar_synth_s32 */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 9, 18, 111, 114, 99, 95, 104, 97, 97, 114, 95, 115, 121, 110, 116, 
      104, 95, 115, 51, 50, 11, 4, 4, 11, 4, 4, 14, 4, 0, 0, 0, 
      0, 20, 4, 20, 4, 20, 4, 112, 32, 0, 112, 33, 1, 108, 34, 33, 
      16, 129, 32, 32, 34, 112, 0, 32, 103, 1, 33, 32, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s32");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_constant (p, 4, 0x00000000, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyl", 0, ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgsl", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_haar_synth_s32 = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_splat_s32_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 16, 111, 114, 99, 95, 115, 112, 108, 97, 116, 95, 115, 51, 
      50, 95, 50, 100, 11, 4, 4, 16, 4, 112, 0, 24, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_splat_s32_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s32_2d");
      orc_program_set_backup_function (p, _backup_orc_splat_s32_2d);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter (p, 4, "p1");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_splat_s32_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
  {
    /* orc_dequantise_s32_ip_2d */
    OrcProgram *p;

#if 1
    static const orc_uint8 bc[] = {
      1, 7, 9, 24, 111, 114, 99, 95, 100, 101, 113, 117, 97, 110, 116, 105, 
      115, 101, 95, 115, 51, 50, 95, 105, 112, 95, 50, 100, 11, 4, 4, 14, 
      4, 2, 0, 0, 0, 16, 4, 16, 4, 20, 4, 20, 4, 112, 32, 0, 
      127, 33, 32, 102, 32, 32, 120, 32, 32, 24, 103, 32, 32, 25, 125, 32, 
      32, 16, 120, 0, 32, 33, 2, 0, 
    };
    p = orc_program_new_from_static_bytecode (bc);
    orc_program_set_backup_function (p, _backup_orc_dequantise_s32_ip_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s32_ip_2d");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s32_ip_2d);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_constant (p, 4, 0x00000002, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "copyl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "signl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "absl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

    orc_program_compile (p);

    _orc_code_orc_dequantise_s32_ip_2d = orc_program_take_code (p);
    orc_program_free (p);
  }
#endif
}


