// GENERATED FILE - DO NOT EDIT.
// Generated by gen_load_functions_table.py using data from load_functions_data.json
//
// Copyright 2015 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// load_functions_table:
//   Contains the GetLoadFunctionsMap for texture_format_util.h
//

#include "libANGLE/renderer/d3d/d3d11/load_functions_table.h"
#include "libANGLE/renderer/d3d/d3d11/formatutils11.h"
#include "libANGLE/renderer/d3d/d3d11/texture_format_table.h"
#include "libANGLE/renderer/d3d/loadimage.h"
#include "libANGLE/renderer/d3d/loadimage_etc.h"

namespace rx
{

namespace d3d11
{

namespace
{

// ES3 image loading functions vary based on:
//    - the GL internal format (supplied to glTex*Image*D)
//    - the GL data type given (supplied to glTex*Image*D)
//    - the target DXGI_FORMAT that the image will be loaded into (which is chosen based on the D3D
//    device's capabilities)
// This map type determines which loading function to use, based on these three parameters.
// Source formats and types are taken from Tables 3.2 and 3.3 of the ES 3 spec.
void UnimplementedLoadFunction(size_t width,
                               size_t height,
                               size_t depth,
                               const uint8_t *input,
                               size_t inputRowPitch,
                               size_t inputDepthPitch,
                               uint8_t *output,
                               size_t outputRowPitch,
                               size_t outputDepthPitch)
{
    UNIMPLEMENTED();
}

void UnreachableLoadFunction(size_t width,
                             size_t height,
                             size_t depth,
                             const uint8_t *input,
                             size_t inputRowPitch,
                             size_t inputDepthPitch,
                             uint8_t *output,
                             size_t outputRowPitch,
                             size_t outputDepthPitch)
{
    UNREACHABLE();
}

}  // namespace

// TODO we can replace these maps with more generated code
const std::map<GLenum, LoadImageFunctionInfo> &GetLoadFunctionsMap(GLenum internalFormat,
                                                                   DXGI_FORMAT dxgiFormat)
{
    // clang-format off
    switch (internalFormat)
    {
        case GL_ALPHA:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R32G32B32A32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadA32FToRGBA32F, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_ALPHA16F_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_ALPHA32F_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadA32FToRGBA32F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadA32FToRGBA32F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_ALPHA8_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadA8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_BGR5_A1_ANGLEX:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT] = LoadImageFunctionInfo(LoadRGB5A1ToRGBA8, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, true);
                        loadMap[GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT] = LoadImageFunctionInfo(LoadRGB5A1ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_BGRA4_ANGLEX:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT] = LoadImageFunctionInfo(LoadRGBA4ToRGBA8, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, true);
                        loadMap[GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT] = LoadImageFunctionInfo(LoadRGBA4ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_BGRA8_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_BGRA_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_COMPRESSED_R11_EAC:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadEACR11ToR8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_RG11_EAC:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadEACRG11ToRG8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_RGB8_ETC2:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC2RGB8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC2RGB8A1ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_RGBA8_ETC2_EAC:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC2RGBA8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT1_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,8>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,8>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,16>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,16>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,16>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,16>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_COMPRESSED_RGB_S3TC_DXT1_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,8>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadCompressedToNative<4,4,8>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_COMPRESSED_SIGNED_R11_EAC:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8_SNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadEACR11SToR8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_SIGNED_RG11_EAC:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8_SNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadEACRG11SToRG8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM_SRGB:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC2SRGBA8ToSRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_SRGB8_ETC2:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM_SRGB:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC2SRGB8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM_SRGB:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC2SRGB8A1ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_DEPTH24_STENCIL8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_D24_UNORM_S8_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT_24_8] = LoadImageFunctionInfo(LoadR32ToR24G8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R24G8_TYPELESS:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT_24_8] = LoadImageFunctionInfo(LoadR32ToR24G8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_DEPTH32F_STENCIL8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G8X24_TYPELESS:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT_32_UNSIGNED_INT_24_8_REV] = LoadImageFunctionInfo(LoadToNative<GLuint,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT_32_UNSIGNED_INT_24_8_REV] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT_32_UNSIGNED_INT_24_8_REV] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_DEPTH_COMPONENT16:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_D16_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT] = LoadImageFunctionInfo(LoadToNative<GLushort,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R16_TYPELESS:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadR32ToR16, true);
                        loadMap[GL_UNSIGNED_SHORT] = LoadImageFunctionInfo(LoadToNative<GLushort,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_DEPTH_COMPONENT24:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_D24_UNORM_S8_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadR32ToR24G8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R24G8_TYPELESS:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadR32ToR24G8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_DEPTH_COMPONENT32F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32_TYPELESS:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLfloat,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_DEPTH_COMPONENT32_OES:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadR32ToR24G8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadR32ToR24G8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_ETC1_RGB8_LOSSY_DECODE_ANGLE:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_BC1_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC1RGB8ToBC1, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_ETC1_RGB8_OES:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadETC1RGB8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_LUMINANCE:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R32G32B32A32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadL32FToRGBA32F, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE16F_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE32F_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadL32FToRGBA32F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadL32FToRGBA32F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE8_ALPHA8_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadLA8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadLA8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE8_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadL8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadL8ToRGBA8, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE_ALPHA:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R32G32B32A32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadLA32FToRGBA32F, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE_ALPHA16F_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_LUMINANCE_ALPHA32F_EXT:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadLA32FToRGBA32F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadLA32FToRGBA32F, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_R11F_G11F_B10F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R11G11B10_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadRGB16FToRG11B10F, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadRGB16FToRG11B10F, true);
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadRGB32FToRG11B10F, true);
                        loadMap[GL_UNSIGNED_INT_10F_11F_11F_REV] = LoadImageFunctionInfo(LoadToNative<GLuint,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R16F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(Load32FTo16F<1>, true);
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLhalf,1>, false);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadToNative<GLhalf,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R16I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_SHORT] = LoadImageFunctionInfo(LoadToNative<GLshort,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R16UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT] = LoadImageFunctionInfo(LoadToNative<GLushort,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R32F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLfloat,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R32I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_INT] = LoadImageFunctionInfo(LoadToNative<GLint,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R32UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadToNative<GLuint,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R8I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative<GLbyte,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R8UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_R8_SNORM:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8_SNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative<GLbyte,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG16F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(Load32FTo16F<2>, true);
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLhalf,2>, false);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadToNative<GLhalf,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG16I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_SHORT] = LoadImageFunctionInfo(LoadToNative<GLshort,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG16UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT] = LoadImageFunctionInfo(LoadToNative<GLushort,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG32F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLfloat,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG32I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_INT] = LoadImageFunctionInfo(LoadToNative<GLint,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG32UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadToNative<GLuint,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG8I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative<GLbyte,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG8UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RG8_SNORM:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8_SNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative<GLbyte,2>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        loadMap[GL_UNSIGNED_SHORT_5_6_5] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        loadMap[GL_UNSIGNED_SHORT_5_6_5] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_RGB10_A2:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R10G10B10A2_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT_2_10_10_10_REV] = LoadImageFunctionInfo(LoadToNative<GLuint,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB10_A2UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R10G10B10A2_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT_2_10_10_10_REV] = LoadImageFunctionInfo(LoadToNative<GLuint,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB16F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadRGB32FToRGBA16F, true);
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadToNative3To4<GLhalf,gl::Float16One>, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadToNative3To4<GLhalf,gl::Float16One>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB16I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_SHORT] = LoadImageFunctionInfo(LoadToNative3To4<GLshort,0x0001>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB16UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT] = LoadImageFunctionInfo(LoadToNative3To4<GLushort,0x0001>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB32F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32B32A32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadToNative3To4<GLfloat,gl::Float32One>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB32I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32B32A32_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_INT] = LoadImageFunctionInfo(LoadToNative3To4<GLint,0x00000001>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB32UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32B32A32_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadToNative3To4<GLuint,0x00000001>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB565:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_B5G6R5_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_5_6_5] = LoadImageFunctionInfo(LoadToNative<GLushort,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_5_6_5] = LoadImageFunctionInfo(LoadR5G6B5ToRGBA8, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative3To4<GLubyte,0xFF>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB5_A1:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_B5G5R5A1_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_5_5_5_1] = LoadImageFunctionInfo(LoadRGB5A1ToA1RGB5, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT_2_10_10_10_REV] = LoadImageFunctionInfo(LoadRGB10A2ToRGBA8, true);
                        loadMap[GL_UNSIGNED_SHORT_5_5_5_1] = LoadImageFunctionInfo(LoadRGB5A1ToRGBA8, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative3To4<GLubyte,0xFF>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB8I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative3To4<GLbyte,0x01>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB8UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative3To4<GLubyte,0x01>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB8_SNORM:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_SNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative3To4<GLbyte,0x7F>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGB9_E5:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R9G9B9E5_SHAREDEXP:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadRGB16FToRGB9E5, true);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadRGB16FToRGB9E5, true);
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadRGB32FToRGB9E5, true);
                        loadMap[GL_UNSIGNED_INT_5_9_9_9_REV] = LoadImageFunctionInfo(LoadToNative<GLuint,1>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        loadMap[GL_UNSIGNED_SHORT_4_4_4_4] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        loadMap[GL_UNSIGNED_SHORT_5_5_5_1] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        loadMap[GL_UNSIGNED_SHORT_4_4_4_4] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        loadMap[GL_UNSIGNED_SHORT_5_5_5_1] = LoadImageFunctionInfo(UnreachableLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }
        case GL_RGBA16F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(Load32FTo16F<4>, true);
                        loadMap[GL_HALF_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLhalf,4>, false);
                        loadMap[GL_HALF_FLOAT_OES] = LoadImageFunctionInfo(LoadToNative<GLhalf,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA16I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_SHORT] = LoadImageFunctionInfo(LoadToNative<GLshort,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA16UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R16G16B16A16_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT] = LoadImageFunctionInfo(LoadToNative<GLushort,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA32F:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32B32A32_FLOAT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_FLOAT] = LoadImageFunctionInfo(LoadToNative<GLfloat,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA32I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32B32A32_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_INT] = LoadImageFunctionInfo(LoadToNative<GLint,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA32UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R32G32B32A32_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_INT] = LoadImageFunctionInfo(LoadToNative<GLuint,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA4:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_B4G4R4A4_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_4_4_4_4] = LoadImageFunctionInfo(LoadRGBA4ToARGB4, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_SHORT_4_4_4_4] = LoadImageFunctionInfo(LoadRGBA4ToRGBA8, true);
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA8I:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_SINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative<GLbyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA8UI:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UINT:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_RGBA8_SNORM:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_SNORM:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_BYTE] = LoadImageFunctionInfo(LoadToNative<GLbyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_SRGB8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM_SRGB:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative3To4<GLubyte,0xFF>, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_SRGB8_ALPHA8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_R8G8B8A8_UNORM_SRGB:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[GL_UNSIGNED_BYTE] = LoadImageFunctionInfo(LoadToNative<GLubyte,4>, false);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                    break;
            }
        }
        case GL_STENCIL_INDEX8:
        {
            switch (dxgiFormat)
            {
                case DXGI_FORMAT_UNKNOWN:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[DXGI_FORMAT_D24_UNORM_S8_UINT] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        loadMap[DXGI_FORMAT_R24G8_TYPELESS] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
                default:
                {
                    static const std::map<GLenum, LoadImageFunctionInfo> loadFunctionsMap = []() {
                        std::map<GLenum, LoadImageFunctionInfo> loadMap;
                        loadMap[DXGI_FORMAT_D24_UNORM_S8_UINT] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        loadMap[DXGI_FORMAT_R24G8_TYPELESS] = LoadImageFunctionInfo(UnimplementedLoadFunction, true);
                        return loadMap;
                    }();

                    return loadFunctionsMap;
                }
            }
        }

        default:
        {
            static std::map<GLenum, LoadImageFunctionInfo> emptyLoadFunctionsMap;
            return emptyLoadFunctionsMap;
        }
    }
    // clang-format on

}  // GetLoadFunctionsMap

}  // namespace d3d11

}  // namespace rx
