/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(XSLT)

#include "JSXSLTProcessor.h"

#include "Document.h"
#include "DocumentFragment.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "NodeFilter.h"
#include "XSLTProcessor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXSLTProcessorTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXSLTProcessorConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXSLTProcessorTable = { 2, 1, JSXSLTProcessorTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXSLTProcessorConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXSLTProcessorConstructorTable = { 1, 0, JSXSLTProcessorConstructorTableValues, 0 };
const ClassInfo JSXSLTProcessorConstructor::s_info = { "XSLTProcessorConstructor", &Base::s_info, &JSXSLTProcessorConstructorTable, 0, CREATE_METHOD_TABLE(JSXSLTProcessorConstructor) };

JSXSLTProcessorConstructor::JSXSLTProcessorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXSLTProcessorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSXSLTProcessorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSXSLTProcessorConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXSLTProcessorConstructor, JSDOMWrapper>(exec, &JSXSLTProcessorConstructorTable, jsCast<JSXSLTProcessorConstructor*>(cell), propertyName, slot);
}

bool JSXSLTProcessorConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXSLTProcessorConstructor, JSDOMWrapper>(exec, &JSXSLTProcessorConstructorTable, jsCast<JSXSLTProcessorConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSXSLTProcessorConstructor::constructJSXSLTProcessor(ExecState* exec)
{
    JSXSLTProcessorConstructor* castedThis = jsCast<JSXSLTProcessorConstructor*>(exec->callee());
    RefPtr<XSLTProcessor> object = XSLTProcessor::create();
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

ConstructType JSXSLTProcessorConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSXSLTProcessor;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSXSLTProcessorPrototypeTableValues[] =
{
    { "importStylesheet", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionImportStylesheet), (intptr_t)1, NoIntrinsic },
    { "transformToFragment", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionTransformToFragment), (intptr_t)2, NoIntrinsic },
    { "transformToDocument", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionTransformToDocument), (intptr_t)1, NoIntrinsic },
    { "setParameter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionSetParameter), (intptr_t)3, NoIntrinsic },
    { "getParameter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionGetParameter), (intptr_t)2, NoIntrinsic },
    { "removeParameter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionRemoveParameter), (intptr_t)2, NoIntrinsic },
    { "clearParameters", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionClearParameters), (intptr_t)0, NoIntrinsic },
    { "reset", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionReset), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXSLTProcessorPrototypeTable = { 17, 15, JSXSLTProcessorPrototypeTableValues, 0 };
const ClassInfo JSXSLTProcessorPrototype::s_info = { "XSLTProcessorPrototype", &Base::s_info, &JSXSLTProcessorPrototypeTable, 0, CREATE_METHOD_TABLE(JSXSLTProcessorPrototype) };

JSObject* JSXSLTProcessorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXSLTProcessor>(exec, globalObject);
}

bool JSXSLTProcessorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXSLTProcessorPrototype* thisObject = jsCast<JSXSLTProcessorPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSXSLTProcessorPrototypeTable, thisObject, propertyName, slot);
}

bool JSXSLTProcessorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXSLTProcessorPrototype* thisObject = jsCast<JSXSLTProcessorPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSXSLTProcessorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSXSLTProcessor::s_info = { "XSLTProcessor", &Base::s_info, &JSXSLTProcessorTable, 0 , CREATE_METHOD_TABLE(JSXSLTProcessor) };

JSXSLTProcessor::JSXSLTProcessor(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XSLTProcessor> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXSLTProcessor::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSXSLTProcessor::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXSLTProcessorPrototype::create(exec->globalData(), globalObject, JSXSLTProcessorPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSXSLTProcessor::destroy(JSC::JSCell* cell)
{
    JSXSLTProcessor* thisObject = static_cast<JSXSLTProcessor*>(cell);
    thisObject->JSXSLTProcessor::~JSXSLTProcessor();
}

JSXSLTProcessor::~JSXSLTProcessor()
{
    releaseImplIfNotNull();
}

bool JSXSLTProcessor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXSLTProcessor* thisObject = jsCast<JSXSLTProcessor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXSLTProcessor, Base>(exec, &JSXSLTProcessorTable, thisObject, propertyName, slot);
}

bool JSXSLTProcessor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXSLTProcessor* thisObject = jsCast<JSXSLTProcessor*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXSLTProcessor, Base>(exec, &JSXSLTProcessorTable, thisObject, propertyName, descriptor);
}

JSValue jsXSLTProcessorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXSLTProcessor* domObject = jsCast<JSXSLTProcessor*>(asObject(slotBase));
    return JSXSLTProcessor::getConstructor(exec, domObject->globalObject());
}

JSValue JSXSLTProcessor::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXSLTProcessorConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionImportStylesheet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    XSLTProcessor* impl = static_cast<XSLTProcessor*>(castedThis->impl());
    Node* stylesheet(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->importStylesheet(stylesheet);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToFragment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    XSLTProcessor* impl = static_cast<XSLTProcessor*>(castedThis->impl());
    Node* source(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* docVal(toDocument(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->transformToFragment(source, docVal)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToDocument(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    XSLTProcessor* impl = static_cast<XSLTProcessor*>(castedThis->impl());
    Node* source(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->transformToDocument(source)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionSetParameter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    return JSValue::encode(castedThis->setParameter(exec));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionGetParameter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    return JSValue::encode(castedThis->getParameter(exec));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionRemoveParameter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    return JSValue::encode(castedThis->removeParameter(exec));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionClearParameters(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    XSLTProcessor* impl = static_cast<XSLTProcessor*>(castedThis->impl());
    impl->clearParameters();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionReset(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXSLTProcessor::s_info))
        return throwVMTypeError(exec);
    JSXSLTProcessor* castedThis = jsCast<JSXSLTProcessor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXSLTProcessor::s_info);
    XSLTProcessor* impl = static_cast<XSLTProcessor*>(castedThis->impl());
    impl->reset();
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSXSLTProcessor* jsXSLTProcessor)
{
    if (jsXSLTProcessor->hasCustomProperties())
        return true;
    return false;
}

bool JSXSLTProcessorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXSLTProcessor* jsXSLTProcessor = jsCast<JSXSLTProcessor*>(handle.get().asCell());
    if (!isObservable(jsXSLTProcessor))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXSLTProcessorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXSLTProcessor* jsXSLTProcessor = jsCast<JSXSLTProcessor*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXSLTProcessor->impl(), jsXSLTProcessor);
    jsXSLTProcessor->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XSLTProcessor* impl)
{
    return wrap<JSXSLTProcessor>(exec, globalObject, impl);
}

XSLTProcessor* toXSLTProcessor(JSC::JSValue value)
{
    return value.inherits(&JSXSLTProcessor::s_info) ? jsCast<JSXSLTProcessor*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(XSLT)
