#ifndef PERMUTE_EVENT_FCN_H
#define PERMUTE_EVENT_FCN_H

#include <cmath>
#include "Permute_fcn.h"

class Permute_event_fcn : public Permute_fcn
{
public:
  Permute_event_fcn (Matrix *input)
  {
    this->series = input;
  }

//! First and last index of series are never changed
//! n2 is not used
void permute (octave_idx_type &n1, octave_idx_type &n2)
{
  n1 = std::min (rand() % this->series->rows () + 1, this->series->rows () - 2);
}

void exch (octave_idx_type n1, octave_idx_type n2)
{
  double *series_ptr = this->series->fortran_vec ();
  series_ptr[n1] = series_ptr[n1-1] + series_ptr[n1+1] - series_ptr[n1];
}

void scramble ()
{
  octave_idx_type rows = this->series->rows ();
  for (octave_idx_type i = 0; i < rows * log (rows); i++)
    {
      octave_idx_type nn1, nn2;
      this->permute (nn1, nn2);
      this->exch (nn1, nn2);
    }
}

};

#endif

