; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -global-isel -stop-after=irtranslator -verify-machineinstrs < %s | FileCheck  -check-prefixes=RV32 %s
; RUN: llc -mtriple=riscv64 -mattr=+v -global-isel -stop-after=irtranslator -verify-machineinstrs < %s | FileCheck  -check-prefixes=RV64 %s

define <vscale x 1 x i8>  @vload_nx1i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx1i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx1i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 1 x i8>, ptr %pa
  ret <vscale x 1 x i8> %va
}

define <vscale x 2 x i8>  @vload_nx2i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i8>, ptr %pa
  ret <vscale x 2 x i8> %va
}

define <vscale x 4 x i8>  @vload_nx4i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i8>, ptr %pa
  ret <vscale x 4 x i8> %va
}

define <vscale x 8 x i8>  @vload_nx8i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx8i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 8 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx8i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 8 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 8 x i8>, ptr %pa
  ret <vscale x 8 x i8> %va
}

define <vscale x 16 x i8>  @vload_nx16i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx16i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 16 x i8>, ptr %pa
  ret <vscale x 16 x i8> %va
}

define <vscale x 32 x i8>  @vload_nx32i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx32i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 32 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 32 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 32 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m4
  ;
  ; RV64-LABEL: name: vload_nx32i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 32 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 32 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 32 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m4
  %va = load <vscale x 32 x i8>, ptr %pa
  ret <vscale x 32 x i8> %va
}

define <vscale x 64 x i8>  @vload_nx64i8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx64i8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 64 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 64 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 64 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m8
  ;
  ; RV64-LABEL: name: vload_nx64i8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 64 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 64 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 64 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m8
  %va = load <vscale x 64 x i8>, ptr %pa
  ret <vscale x 64 x i8> %va
}

define <vscale x 1 x i16>  @vload_nx1i16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx1i16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx1i16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 1 x i16>, ptr %pa
  ret <vscale x 1 x i16> %va
}

define <vscale x 2 x i16>  @vload_nx2i16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i16>, ptr %pa
  ret <vscale x 2 x i16> %va
}

define <vscale x 4 x i16>  @vload_nx4i16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i16>, ptr %pa
  ret <vscale x 4 x i16> %va
}

define <vscale x 8 x i16>  @vload_nx8i16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx8i16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 8 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx8i16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 8 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 8 x i16>, ptr %pa
  ret <vscale x 8 x i16> %va
}

define <vscale x 16 x i16>  @vload_nx16i16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 16 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8m4
  ;
  ; RV64-LABEL: name: vload_nx16i16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 16 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8m4
  %va = load <vscale x 16 x i16>, ptr %pa
  ret <vscale x 16 x i16> %va
}

define <vscale x 32 x i16>  @vload_nx32i16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx32i16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 32 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 32 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 32 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8m8
  ;
  ; RV64-LABEL: name: vload_nx32i16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 32 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 32 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 32 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8m8
  %va = load <vscale x 32 x i16>, ptr %pa
  ret <vscale x 32 x i16> %va
}

define <vscale x 1 x i32>  @vload_nx1i32(ptr %pa) {
  ; RV32-LABEL: name: vload_nx1i32
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s32>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx1i32
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s32>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 1 x i32>, ptr %pa
  ret <vscale x 1 x i32> %va
}

define <vscale x 2 x i32>  @vload_nx2i32(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i32
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i32
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i32>, ptr %pa
  ret <vscale x 2 x i32> %va
}

define <vscale x 4 x i32>  @vload_nx4i32(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i32
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s32>) from %ir.pa)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 4 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx4i32
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s32>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 4 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 4 x i32>, ptr %pa
  ret <vscale x 4 x i32> %va
}

define <vscale x 8 x i32>  @vload_nx8i32(ptr %pa) {
  ; RV32-LABEL: name: vload_nx8i32
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s32>) from %ir.pa)
  ; RV32-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 8 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8m4
  ;
  ; RV64-LABEL: name: vload_nx8i32
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s32>) from %ir.pa)
  ; RV64-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 8 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8m4
  %va = load <vscale x 8 x i32>, ptr %pa
  ret <vscale x 8 x i32> %va
}

define <vscale x 16 x i32>  @vload_nx16i32(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i32
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s32>) from %ir.pa)
  ; RV32-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 16 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8m8
  ;
  ; RV64-LABEL: name: vload_nx16i32
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s32>) from %ir.pa)
  ; RV64-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 16 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8m8
  %va = load <vscale x 16 x i32>, ptr %pa
  ret <vscale x 16 x i32> %va
}

define <vscale x 1 x i64>  @vload_nx1i64(ptr %pa) {
  ; RV32-LABEL: name: vload_nx1i64
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s64>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx1i64
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x s64>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 1 x i64>, ptr %pa
  ret <vscale x 1 x i64> %va
}

define <vscale x 2 x i64>  @vload_nx2i64(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i64
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx2i64
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 2 x i64>, ptr %pa
  ret <vscale x 2 x i64> %va
}

define <vscale x 4 x i64>  @vload_nx4i64(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i64
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s64>) from %ir.pa)
  ; RV32-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 4 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m4
  ;
  ; RV64-LABEL: name: vload_nx4i64
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s64>) from %ir.pa)
  ; RV64-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 4 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m4
  %va = load <vscale x 4 x i64>, ptr %pa
  ret <vscale x 4 x i64> %va
}

define <vscale x 8 x i64>  @vload_nx8i64(ptr %pa) {
  ; RV32-LABEL: name: vload_nx8i64
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s64>) from %ir.pa)
  ; RV32-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 8 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m8
  ;
  ; RV64-LABEL: name: vload_nx8i64
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x s64>) from %ir.pa)
  ; RV64-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 8 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m8
  %va = load <vscale x 8 x i64>, ptr %pa
  ret <vscale x 8 x i64> %va
}

define <vscale x 16 x i8>  @vload_nx16i8_align1(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i8_align1
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa, align 1)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx16i8_align1
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa, align 1)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 16 x i8>, ptr %pa, align 1
  ret <vscale x 16 x i8> %va
}

define <vscale x 16 x i8>  @vload_nx16i8_align2(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i8_align2
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa, align 2)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx16i8_align2
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa, align 2)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 16 x i8>, ptr %pa, align 2
  ret <vscale x 16 x i8> %va
}

define <vscale x 16 x i8>  @vload_nx16i8_align16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i8_align16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx16i8_align16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 16 x i8>, ptr %pa, align 16
  ret <vscale x 16 x i8> %va
}

define <vscale x 16 x i8>  @vload_nx16i8_align64(ptr %pa) {
  ; RV32-LABEL: name: vload_nx16i8_align64
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa, align 64)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx16i8_align64
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 16 x s8>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 16 x s8>) from %ir.pa, align 64)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 16 x s8>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 16 x i8>, ptr %pa, align 64
  ret <vscale x 16 x i8> %va
}

define <vscale x 4 x i16>  @vload_nx4i16_align1(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i16_align1
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 1)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i16_align1
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 1)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i16>, ptr %pa, align 1
  ret <vscale x 4 x i16> %va
}

define <vscale x 4 x i16>  @vload_nx4i16_align2(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i16_align2
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 2)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i16_align2
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 2)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i16>, ptr %pa, align 2
  ret <vscale x 4 x i16> %va
}

define <vscale x 4 x i16>  @vload_nx4i16_align4(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i16_align4
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 4)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i16_align4
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 4)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i16>, ptr %pa, align 4
  ret <vscale x 4 x i16> %va
}
define <vscale x 4 x i16>  @vload_nx4i16_align8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i16_align8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i16_align8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i16>, ptr %pa, align 8
  ret <vscale x 4 x i16> %va
}

define <vscale x 4 x i16>  @vload_nx4i16_align16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx4i16_align16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 16)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx4i16_align16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 4 x s16>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 4 x s16>) from %ir.pa, align 16)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 4 x s16>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 4 x i16>, ptr %pa, align 16
  ret <vscale x 4 x i16> %va
}

define <vscale x 2 x i32>  @vload_nx2i32_align2(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i32_align2
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 2)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i32_align2
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 2)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i32>, ptr %pa, align 2
  ret <vscale x 2 x i32> %va
}

define <vscale x 2 x i32>  @vload_nx2i32_align4(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i32_align4
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 4)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i32_align4
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 4)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i32>, ptr %pa, align 4
  ret <vscale x 2 x i32> %va
}

define <vscale x 2 x i32>  @vload_nx2i32_align8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i32_align8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i32_align8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i32>, ptr %pa, align 8
  ret <vscale x 2 x i32> %va
}

define <vscale x 2 x i32>  @vload_nx2i32_align16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i32_align16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 16)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i32_align16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 16)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i32>, ptr %pa, align 16
  ret <vscale x 2 x i32> %va
}

define <vscale x 2 x i32>  @vload_nx2i32_align256(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i32_align256
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 256)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2i32_align256
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s32>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s32>) from %ir.pa, align 256)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x s32>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 2 x i32>, ptr %pa, align 256
  ret <vscale x 2 x i32> %va
}
define <vscale x 2 x i64>  @vload_nx2i64_align4(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i64_align4
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa, align 4)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx2i64_align4
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa, align 4)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 2 x i64>, ptr %pa, align 4
  ret <vscale x 2 x i64> %va
}

define <vscale x 2 x i64>  @vload_nx2i64_align8(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i64_align8
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa, align 8)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx2i64_align8
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa, align 8)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 2 x i64>, ptr %pa, align 8
  ret <vscale x 2 x i64> %va
}

define <vscale x 2 x i64>  @vload_nx2i64_align16(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i64_align16
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx2i64_align16
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 2 x i64>, ptr %pa, align 16
  ret <vscale x 2 x i64> %va
}

define <vscale x 2 x i64>  @vload_nx2i64_align32(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2i64_align32
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa, align 32)
  ; RV32-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV32-NEXT:   PseudoRET implicit $v8m2
  ;
  ; RV64-LABEL: name: vload_nx2i64_align32
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x s64>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x s64>) from %ir.pa, align 32)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x s64>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 2 x i64>, ptr %pa, align 32
  ret <vscale x 2 x i64> %va
}

define <vscale x 1 x ptr>  @vload_nx1ptr(ptr %pa) {
  ; RV32-LABEL: name: vload_nx1ptr
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x p0>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x p0>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x p0>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx1ptr
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 1 x p0>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 1 x p0>) from %ir.pa)
  ; RV64-NEXT:   $v8 = COPY [[LOAD]](<vscale x 1 x p0>)
  ; RV64-NEXT:   PseudoRET implicit $v8
  %va = load <vscale x 1 x ptr>, ptr %pa
  ret <vscale x 1 x ptr> %va
}

define <vscale x 2 x ptr>  @vload_nx2ptr(ptr %pa) {
  ; RV32-LABEL: name: vload_nx2ptr
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x p0>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x p0>) from %ir.pa)
  ; RV32-NEXT:   $v8 = COPY [[LOAD]](<vscale x 2 x p0>)
  ; RV32-NEXT:   PseudoRET implicit $v8
  ;
  ; RV64-LABEL: name: vload_nx2ptr
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 2 x p0>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 2 x p0>) from %ir.pa)
  ; RV64-NEXT:   $v8m2 = COPY [[LOAD]](<vscale x 2 x p0>)
  ; RV64-NEXT:   PseudoRET implicit $v8m2
  %va = load <vscale x 2x ptr>, ptr %pa
  ret <vscale x 2 x ptr> %va
}

define <vscale x 8 x ptr>  @vload_nx8ptr(ptr %pa) {
  ; RV32-LABEL: name: vload_nx8ptr
  ; RV32: bb.1 (%ir-block.0):
  ; RV32-NEXT:   liveins: $x10
  ; RV32-NEXT: {{  $}}
  ; RV32-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV32-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x p0>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x p0>) from %ir.pa)
  ; RV32-NEXT:   $v8m4 = COPY [[LOAD]](<vscale x 8 x p0>)
  ; RV32-NEXT:   PseudoRET implicit $v8m4
  ;
  ; RV64-LABEL: name: vload_nx8ptr
  ; RV64: bb.1 (%ir-block.0):
  ; RV64-NEXT:   liveins: $x10
  ; RV64-NEXT: {{  $}}
  ; RV64-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x10
  ; RV64-NEXT:   [[LOAD:%[0-9]+]]:_(<vscale x 8 x p0>) = G_LOAD [[COPY]](p0) :: (load (<vscale x 8 x p0>) from %ir.pa)
  ; RV64-NEXT:   $v8m8 = COPY [[LOAD]](<vscale x 8 x p0>)
  ; RV64-NEXT:   PseudoRET implicit $v8m8
  %va = load <vscale x 8 x ptr>, ptr %pa
  ret <vscale x 8 x ptr> %va
}

