; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;RUN: opt -S -passes=instcombine < %s | FileCheck %s
target triple = "aarch64-unknown-linux-gnu"


define <16 x i8> @addqv_i8(<vscale x 16 x i8> %a) {
; CHECK-LABEL: define <16 x i8> @addqv_i8(
; CHECK-SAME: <vscale x 16 x i8> [[A:%.*]]) {
; CHECK-NEXT:    ret <16 x i8> zeroinitializer
;
  %res = call <16 x i8> @llvm.aarch64.sve.addqv.v16i8.nxv16i8(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i8> %a);
  ret <16 x i8> %res
}

define <vscale x 4 x i1> @and_4(<vscale x 4 x i1> %Pn, <vscale x 4 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 4 x i1> @and_4(
; CHECK-SAME: <vscale x 4 x i1> [[PN:%.*]], <vscale x 4 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 4 x i1> zeroinitializer
;
  %res = call <vscale x 4 x i1> @llvm.aarch64.sve.and.z.nxv4i1(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i1> %Pn, <vscale x 4 x i1> %Pd)
  ret <vscale x 4 x i1> %res;
}

define <vscale x 16 x i1> @bic_16(<vscale x 16 x i1> %Pn, <vscale x 16 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 16 x i1> @bic_16(
; CHECK-SAME: <vscale x 16 x i1> [[PN:%.*]], <vscale x 16 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %res = call <vscale x 16 x i1> @llvm.aarch64.sve.bic.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %Pn, <vscale x 16 x i1> %Pd)
  ret <vscale x 16 x i1> %res;
}

define <vscale x 16 x i1> @brka_z_b8(<vscale x 16 x i1> %a) {
; CHECK-LABEL: define <vscale x 16 x i1> @brka_z_b8(
; CHECK-SAME: <vscale x 16 x i1> [[A:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %out = call <vscale x 16 x i1> @llvm.aarch64.sve.brka.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %a)
  ret <vscale x 16 x i1> %out
}

define <vscale x 16 x i1> @brkb_z_b8(<vscale x 16 x i1> %a) {
; CHECK-LABEL: define <vscale x 16 x i1> @brkb_z_b8(
; CHECK-SAME: <vscale x 16 x i1> [[A:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %out = call <vscale x 16 x i1> @llvm.aarch64.sve.brkb.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %a)
  ret <vscale x 16 x i1> %out
}

define <vscale x 16 x i1> @brkn_b8(<vscale x 16 x i1> %a, <vscale x 16 x i1> %b) {
; CHECK-LABEL: define <vscale x 16 x i1> @brkn_b8(
; CHECK-SAME: <vscale x 16 x i1> [[A:%.*]], <vscale x 16 x i1> [[B:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %out = call <vscale x 16 x i1> @llvm.aarch64.sve.brkn.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %a, <vscale x 16 x i1> %b)
  ret <vscale x 16 x i1> %out
}

define <vscale x 16 x i1> @brkpa_b8(<vscale x 16 x i1> %a, <vscale x 16 x i1> %b) {
; CHECK-LABEL: define <vscale x 16 x i1> @brkpa_b8(
; CHECK-SAME: <vscale x 16 x i1> [[A:%.*]], <vscale x 16 x i1> [[B:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %out = call <vscale x 16 x i1> @llvm.aarch64.sve.brkpa.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %a, <vscale x 16 x i1> %b)
  ret <vscale x 16 x i1> %out
}

define <vscale x 16 x i1> @brkpb_b8(<vscale x 16 x i1> %a, <vscale x 16 x i1> %b) {
; CHECK-LABEL: define <vscale x 16 x i1> @brkpb_b8(
; CHECK-SAME: <vscale x 16 x i1> [[A:%.*]], <vscale x 16 x i1> [[B:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %out = call <vscale x 16 x i1> @llvm.aarch64.sve.brkpb.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %a, <vscale x 16 x i1> %b)
  ret <vscale x 16 x i1> %out
}

define i64 @cntp_b64(<vscale x 2 x i1> %a) {
; CHECK-LABEL: define i64 @cntp_b64(
; CHECK-SAME: <vscale x 2 x i1> [[A:%.*]]) {
; CHECK-NEXT:    ret i64 0
;
; USE_SCALAR_INC-LABEL: cntp_b64:
; USE_SCALAR_INC:       // %bb.0:
; USE_SCALAR_INC-NEXT:    cntp x0, p0, p1.d
; USE_SCALAR_INC-NEXT:    ret
  %out = call i64 @llvm.aarch64.sve.cntp.nxv2i1(<vscale x 2 x i1> zeroinitializer, <vscale x 2 x i1> %a)
  ret i64 %out
}

define <vscale x 4 x i32> @compact_i32(<vscale x 4 x i32> %a) {
; CHECK-LABEL: define <vscale x 4 x i32> @compact_i32(
; CHECK-SAME: <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
  %out = call <vscale x 4 x i32> @llvm.aarch64.sve.compact.nxv4i32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %out
}

define <vscale x 16 x i1> @eor_16(<vscale x 16 x i1> %Pn, <vscale x 16 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 16 x i1> @eor_16(
; CHECK-SAME: <vscale x 16 x i1> [[PN:%.*]], <vscale x 16 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %res = call <vscale x 16 x i1> @llvm.aarch64.sve.eor.z.nxv16i1(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i1> %Pn, <vscale x 16 x i1> %Pd)
  ret <vscale x 16 x i1> %res;
}

define i32 @eorv_i32(<vscale x 4 x i32> %a) {
; CHECK-LABEL: define i32 @eorv_i32(
; CHECK-SAME: <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:    ret i32 0
;
  %out = call i32 @llvm.aarch64.sve.eorv.nxv4i32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %a)
  ret i32 %out
}

define <4 x i32> @eorqv_i32(<vscale x 4 x i32> %a) {
; CHECK-LABEL: define <4 x i32> @eorqv_i32(
; CHECK-SAME: <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:    ret <4 x i32> zeroinitializer
;
  %res = call <4 x i32> @llvm.aarch64.sve.eorqv.v4i32.nxv4i32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %a);
  ret <4 x i32> %res
}

define <vscale x 8 x i1> @nand_8(<vscale x 8 x i1> %Pn, <vscale x 8 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 8 x i1> @nand_8(
; CHECK-SAME: <vscale x 8 x i1> [[PN:%.*]], <vscale x 8 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 8 x i1> zeroinitializer
;
  %res = call <vscale x 8 x i1> @llvm.aarch64.sve.nand.z.nxv8i1(<vscale x 8 x i1> zeroinitializer, <vscale x 8 x i1> %Pn, <vscale x 8 x i1> %Pd)
  ret <vscale x 8 x i1> %res;
}

define <vscale x 4 x i1> @nor_4(<vscale x 4 x i1> %Pn, <vscale x 4 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 4 x i1> @nor_4(
; CHECK-SAME: <vscale x 4 x i1> [[PN:%.*]], <vscale x 4 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 4 x i1> zeroinitializer
;
  %res = call <vscale x 4 x i1> @llvm.aarch64.sve.nor.z.nxv4i1(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i1> %Pn, <vscale x 4 x i1> %Pd)
  ret <vscale x 4 x i1> %res;
}

define <vscale x 4 x i1> @orn_4(<vscale x 4 x i1> %Pn, <vscale x 4 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 4 x i1> @orn_4(
; CHECK-SAME: <vscale x 4 x i1> [[PN:%.*]], <vscale x 4 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 4 x i1> zeroinitializer
;
  %res = call <vscale x 4 x i1> @llvm.aarch64.sve.orn.z.nxv4i1(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i1> %Pn, <vscale x 4 x i1> %Pd)
  ret <vscale x 4 x i1> %res;
}

define <vscale x 2 x i1> @orr_2(<vscale x 2 x i1> %Pn, <vscale x 2 x i1> %Pd) {
; CHECK-LABEL: define <vscale x 2 x i1> @orr_2(
; CHECK-SAME: <vscale x 2 x i1> [[PN:%.*]], <vscale x 2 x i1> [[PD:%.*]]) {
; CHECK-NEXT:    ret <vscale x 2 x i1> zeroinitializer
;
  %res = call <vscale x 2 x i1> @llvm.aarch64.sve.orr.z.nxv2i1(<vscale x 2 x i1> zeroinitializer, <vscale x 2 x i1> %Pn, <vscale x 2 x i1> %Pd)
  ret <vscale x 2 x i1> %res;
}

define i8 @orv_i8(<vscale x 16 x i8> %a) {
; CHECK-LABEL: define i8 @orv_i8(
; CHECK-SAME: <vscale x 16 x i8> [[A:%.*]]) {
; CHECK-NEXT:    ret i8 0
;
  %out = call i8 @llvm.aarch64.sve.orv.nxv16i8(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i8> %a)
  ret i8 %out
}

define <8 x i16> @orqv_i16(<vscale x 8 x i16> %a) {
; CHECK-LABEL: define <8 x i16> @orqv_i16(
; CHECK-SAME: <vscale x 8 x i16> [[A:%.*]]) {
; CHECK-NEXT:    ret <8 x i16> zeroinitializer
;
  %res = call <8 x i16> @llvm.aarch64.sve.orqv.v8i16.nxv8i16(<vscale x 8 x i1> zeroinitializer, <vscale x 8 x i16> %a);
  ret <8 x i16> %res
}

define <vscale x 4 x i1> @pnext_b32(<vscale x 4 x i1> %a) {
; CHECK-LABEL: define <vscale x 4 x i1> @pnext_b32(
; CHECK-SAME: <vscale x 4 x i1> [[A:%.*]]) {
; CHECK-NEXT:    ret <vscale x 4 x i1> zeroinitializer
;
  %out = call <vscale x 4 x i1> @llvm.aarch64.sve.pnext.nxv4i1(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i1> %a)
  ret <vscale x 4 x i1> %out
}

define <vscale x 16 x i1> @rdffr_z() {
; CHECK-LABEL: define <vscale x 16 x i1> @rdffr_z() {
; CHECK-NEXT:    ret <vscale x 16 x i1> zeroinitializer
;
  %out = call <vscale x 16 x i1> @llvm.aarch64.sve.rdffr.z(<vscale x 16 x i1> zeroinitializer)
  ret <vscale x 16 x i1> %out
}

define i64 @saddv_i64(<vscale x 2 x i64> %a) {
; CHECK-LABEL: define i64 @saddv_i64(
; CHECK-SAME: <vscale x 2 x i64> [[A:%.*]]) {
; CHECK-NEXT:    ret i64 0
;
  %out = call i64 @llvm.aarch64.sve.saddv.nxv2i64(<vscale x 2 x i1> zeroinitializer, <vscale x 2 x i64> %a)
  ret i64 %out
}

define i64 @uaddv_i8(<vscale x 16 x i8> %a) {
; CHECK-LABEL: define i64 @uaddv_i8(
; CHECK-SAME: <vscale x 16 x i8> [[A:%.*]]) {
; CHECK-NEXT:    ret i64 0
;
  %out = call i64 @llvm.aarch64.sve.uaddv.nxv16i8(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i8> %a)
  ret i64 %out
}

define i8 @umaxv_i8(<vscale x 16 x i8> %a) {
; CHECK-LABEL: define i8 @umaxv_i8(
; CHECK-SAME: <vscale x 16 x i8> [[A:%.*]]) {
; CHECK-NEXT:    ret i8 0
;
  %out = call i8 @llvm.aarch64.sve.umaxv.nxv16i8(<vscale x 16 x i1> zeroinitializer, <vscale x 16 x i8> %a)
  ret i8 %out
}

define <8 x i16> @umaxqv_i16(<vscale x 8 x i16> %a) {
; CHECK-LABEL: define <8 x i16> @umaxqv_i16(
; CHECK-SAME: <vscale x 8 x i16> [[A:%.*]]) {
; CHECK-NEXT:    ret <8 x i16> zeroinitializer
;
  %res = call <8 x i16> @llvm.aarch64.sve.umaxqv.v8i16.nxv8i16(<vscale x 8 x i1> zeroinitializer, <vscale x 8 x i16> %a);
  ret <8 x i16> %res
}
