.\" Copyright (C) 1989-95 GROUPE BULL
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
.\" GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
.\" AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of GROUPE BULL shall not be
.\" used in advertising or otherwise to promote the sale, use or other dealings
.\" in this Software without prior written authorization from GROUPE BULL.
.\"
.hw XImage
.TH XpmCreateBuffer __libmansuffix__ __xorgversion__ "libXpm functions"
.SH NAME
XpmCreateBuffer  \- create an Xpm-Buffer

.SH SYNOPSIS
.HP
int XpmCreateBufferFromImage(Display *display, char **buffer_return, XImage *image, XImage *shapeimage, XpmAttributes *attributes);
.HP
int XpmCreateBufferFromPixmap(Display *display, char **buffer_return, Pixmap pixmap, Pixmap shapemask, XpmAttributes *attributes);
.HP
int XpmCreateBufferFromXpmImage(char **buffer_return, XpmImage *image, XpmInfo *info);

.SH ARGUMENTS

.IP \fIdisplay\fP li
Specifies the connection to the X server.
.IP \fIbuffer_return\fP li
Returns the buffer which is created.
.IP \fIimage\fP li
Specifies the image.
.IP \fIshapeimage\fP li
Specifies the shape mask image.
.IP \fIattributes\fP li
Specifies the location of a structure containing information (or NULL).
.IP \fIinfo\fP li
Specifies the location of a structure to get possible information (or NULL).

.SH DESCRIPTION

.SS XpmCreateBufferFromPixmap
XpmCreateBufferFromPixmap creates an XPM buffer from a Pixmap.
The XpmCreateBufferFromPixmap function works as XpmWriteFileFromPixmap(), it just calls
XpmCreateBufferFromImage instead of XpmWriteFileFromImage. Once again, the caller should free the buffer using
XpmFree when finished.

As a convenience, the XpmReadFileToBuffer and XpmWriteFileFromBuffer functions
are provided to copy a file to a buffer
and to write a file from a buffer. Thus for instance one may decide to use XpmReadFileToBuffer,
XpmCreatePixmapFromBuffer, and XpmFree instead of XpmReadFileToPixmap. On some systems this may lead to a
performance improvement, since the parsing will be performed in memory, but it uses more memory.

.SS XpmCreateBufferFromImage
The XpmCreateBufferFromImage function works as XpmWriteFileFromImage(), it just writes to a malloc’ed buffer instead of to a file.
The caller should free the buffer using XpmFree when finished.

.SS XpmCreateBufferFromXpmImage.
To create an XPM buffer from an XpmImage, use XpmCreateBufferFromXpmImage.
The XpmCreateBufferFromXpmImage function writes out the givenimage to a single block malloc’ed buffer inXPM format.
If insufficient working storage is allocated, it returns XpmNoMemory, and returns XpmSuccess on success.
If the passed XpmInfo structure pointer is not NULL, XpmCreateBufferFromXpmImage looks for the following
attributes: XpmComments, XpmExtensions, and XpmHotspot, and writes the related information out as well.
The caller should free the buffer using XpmFree when finished.

.SH "SEE ALSO"
.BR XpmCreateBufferFromImage(__libmansuffix__) ,
.BR XpmCreateBufferFromPixmap(__libmansuffix__) ,
.BR XpmCreateBufferFromXpmImage(__libmansuffix__)
