/*
    Copyright (C) 2010 Henry de Valence <hdevalence@gmail.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#ifndef ORTHOGRAPHICPROJECTOR_H
#define ORTHOGRAPHICPROJECTOR_H

#include "projector.h"

/**
 * @class OrthographicProjector
 *
 * Implememntation of <a href="http://en.wikipedia.org/wiki/Orthographic_projection">Orthographic projection</a>
 *
 */
class OrthographicProjector : public Projector
{
  public:
    explicit OrthographicProjector(const ViewParams &p);
    Projection type() const Q_DECL_OVERRIDE;
    double radius() const Q_DECL_OVERRIDE;
    double projectionK(double x) const Q_DECL_OVERRIDE;
    double projectionL(double x) const Q_DECL_OVERRIDE;
};

#endif // ORTHOGRAPHICPROJECTOR_H
