//Original:/testcases/core/c_dsp32shiftim_lhalf_rp/c_dsp32shiftim_lhalf_rp.dsp
// Spec Reference: dspshiftimm dreg_lo(hi) = lshift (dreg_lo(hi) by imm5)
# mach: bfin

.include "testutils.inc"
	start



// lshift : positive data, count (+)=left (half reg)
// d_lo = lshift (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000000;
R0.L = -1;
imm32 r1, 0x90000001;
imm32 r2, 0x90000002;
imm32 r3, 0x90000003;
imm32 r4, 0x90000004;
imm32 r5, 0x90000005;
imm32 r6, 0x90000006;
imm32 r7, 0x90000007;
R0.L = R0.L << 0;
R1.L = R1.L >> 1;
R2.L = R2.L >> 2;
R3.L = R3.L >> 3;
R4.L = R4.L >> 4;
R5.L = R5.L >> 5;
R6.L = R6.L >> 6;
R7.L = R7.L >> 7;
CHECKREG r0, 0x0000FFFF;
CHECKREG r1, 0x90000000;
CHECKREG r2, 0x90000000;
CHECKREG r3, 0x90000000;
CHECKREG r4, 0x90000000;
CHECKREG r5, 0x90000000;
CHECKREG r6, 0x90000000;
CHECKREG r7, 0x90000000;

imm32 r0, 0x00001001;
R1.L = -1;
imm32 r2, 0xa0002002;
imm32 r3, 0xa0003003;
imm32 r4, 0xa0004004;
imm32 r5, 0xa0005005;
imm32 r6, 0xa0006006;
imm32 r7, 0xa0007007;
R0.L = R0.L >> 1;
R1.L = R1.L >> 1;
R2.L = R2.L >> 1;
R3.L = R3.L >> 1;
R4.L = R4.L >> 1;
R5.L = R5.L >> 1;
R6.L = R6.L >> 1;
R7.L = R7.L >> 1;
CHECKREG r0, 0x00000800;
CHECKREG r1, 0x90007FFF;
CHECKREG r2, 0xA0001001;
CHECKREG r3, 0xA0001801;
CHECKREG r4, 0xA0002002;
CHECKREG r5, 0xA0002802;
CHECKREG r6, 0xA0003003;
CHECKREG r7, 0xA0003803;


imm32 r0, 0xb0001001;
imm32 r1, 0xb0001001;
R2.L = -15;
imm32 r3, 0xb0003003;
imm32 r4, 0xb0004004;
imm32 r5, 0xb0005005;
imm32 r6, 0xb0006006;
imm32 r7, 0xb0007007;
R0.L = R0.L >> 15;
R1.L = R1.L >> 15;
R2.L = LSHIFT R2.L BY R2.L;
R3.L = R3.L >> 15;
R4.L = R4.L >> 15;
R5.L = R5.L >> 15;
R6.L = R6.L >> 15;
R7.L = R7.L >> 15;
CHECKREG r0, 0xb0000000;
CHECKREG r1, 0xb0000000;
CHECKREG r2, 0xA0000001;
CHECKREG r3, 0xB0000000;
CHECKREG r4, 0xb0000000;
CHECKREG r5, 0xb0000000;
CHECKREG r6, 0xb0000000;
CHECKREG r7, 0xB0000000;

imm32 r0, 0xc0001001;
imm32 r1, 0xc0001001;
imm32 r2, 0xc0002002;
R3.L = -16;
imm32 r4, 0xc0004004;
imm32 r5, 0xc0005005;
imm32 r6, 0xc0006006;
imm32 r7, 0xc0007007;
R0.L = R0.L >> 13;
R1.L = R1.L >> 13;
R2.L = R2.L >> 13;
R3.L = R3.L >> 13;
R4.L = R4.L >> 13;
R5.L = R5.L >> 13;
R6.L = R6.L >> 13;
R7.L = R7.L >> 13;
CHECKREG r0, 0xc0000000;
CHECKREG r1, 0xc0000000;
CHECKREG r2, 0xC0000001;
CHECKREG r3, 0xB0000007;
CHECKREG r4, 0xC0000002;
CHECKREG r5, 0xC0000002;
CHECKREG r6, 0xC0000003;
CHECKREG r7, 0xC0000003;

// RHx by RLx
imm32 r0, 0x0000c000;
imm32 r1, 0x0001c000;
imm32 r2, 0x0002c000;
imm32 r3, 0x0003c000;
imm32 r4, 0x0004c000;
imm32 r5, 0x0005c000;
imm32 r6, 0x0006c000;
imm32 r7, 0x0007c000;
R0.L = R0.H << 0;
R1.L = R1.H << 0;
R2.L = R2.H << 0;
R3.L = R3.H << 0;
R4.L = R4.H << 0;
R5.L = R5.H << 0;
R6.L = R6.H << 0;
R7.L = R7.H << 0;
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00010001;
CHECKREG r2, 0x00020002;
CHECKREG r3, 0x00030003;
CHECKREG r4, 0x00040004;
CHECKREG r5, 0x00050005;
CHECKREG r6, 0x00060006;
CHECKREG r7, 0x00070007;

imm32 r0, 0x10010000;
R1.L = -1;
imm32 r2, 0x20020000;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
imm32 r6, 0x60060000;
imm32 r7, 0x70070000;
R0.L = R0.H >> 1;
R1.L = R1.H >> 1;
R2.L = R2.H >> 1;
R3.L = R3.H >> 1;
R4.L = R4.H >> 1;
R5.L = R5.H >> 1;
R6.L = R6.H >> 1;
R7.L = R7.H >> 1;
CHECKREG r0, 0x10010800;
CHECKREG r1, 0x00010000;
CHECKREG r2, 0x20021001;
CHECKREG r3, 0x30031801;
CHECKREG r4, 0x40042002;
CHECKREG r5, 0x50052802;
CHECKREG r6, 0x60063003;
CHECKREG r7, 0x70073803;


imm32 r0, 0x1001e000;
imm32 r1, 0x1001e000;
R2.L = -15;
imm32 r3, 0x3003e000;
imm32 r4, 0x4004e000;
imm32 r5, 0x5005e000;
imm32 r6, 0x6006e000;
imm32 r7, 0x7007e000;
R0.L = R0.H >> 15;
R1.L = R1.H >> 15;
R2.L = R2.H >> 15;
R3.L = R3.H >> 15;
R4.L = R4.H >> 15;
R5.L = R5.H >> 15;
R6.L = R6.H >> 15;
R7.L = R7.H >> 15;
CHECKREG r0, 0x10010000;
CHECKREG r1, 0x10010000;
CHECKREG r2, 0x20020000;
CHECKREG r3, 0x30030000;
CHECKREG r4, 0x40040000;
CHECKREG r5, 0x50050000;
CHECKREG r6, 0x60060000;
CHECKREG r7, 0x70070000;

imm32 r0, 0x1001f001;
imm32 r1, 0x1001f001;
imm32 r2, 0x2002f002;
R3.L = -16;
imm32 r4, 0x4004f004;
imm32 r5, 0x5005f005;
imm32 r6, 0x6006f006;
imm32 r7, 0x7007f007;
R0.L = R0.H >> 13;
R1.L = R1.H >> 13;
R2.L = R2.H >> 13;
R3.L = R3.H >> 13;
R4.L = R4.H >> 13;
R5.L = R5.H >> 13;
R6.L = R6.H >> 13;
R7.L = R7.H >> 13;
CHECKREG r0, 0x10010000;
CHECKREG r1, 0x10010000;
CHECKREG r2, 0x20020001;
CHECKREG r3, 0x30030001;
CHECKREG r4, 0x40040002;
CHECKREG r5, 0x50050002;
CHECKREG r6, 0x60060003;
CHECKREG r7, 0x70070003;

// RLx by RLx
imm32 r0, 0x00001001;
imm32 r1, 0x00001001;
imm32 r2, 0x00001002;
imm32 r3, 0x00001003;
imm32 r4, 0x00001000;
imm32 r5, 0x00001005;
imm32 r6, 0x00001006;
imm32 r7, 0x00001007;
R0.H = R0.L >> 14;
R1.H = R1.L >> 14;
R2.H = R2.L >> 14;
R3.H = R3.L >> 14;
R4.H = R4.L >> 14;
R5.H = R5.L >> 14;
R6.H = R6.L >> 14;
R7.H = R7.L >> 14;
CHECKREG r0, 0x00001001;
CHECKREG r1, 0x00001001;
CHECKREG r2, 0x00001002;
CHECKREG r3, 0x00001003;
CHECKREG r4, 0x00001000;
CHECKREG r5, 0x00001005;
CHECKREG r6, 0x00001006;
CHECKREG r7, 0x00001007;

imm32 r0, 0x00002001;
imm32 r1, 0x00002001;
imm32 r2, 0x00002002;
imm32 r3, 0x00002003;
imm32 r4, 0x00002004;
R5.L = -1;
imm32 r6, 0x00000006;
imm32 r7, 0x00000007;
R0.H = R0.L >> 5;
R1.H = R1.L >> 5;
R2.H = R2.L >> 5;
R3.H = R3.L >> 5;
R4.H = R4.L >> 5;
R5.H = R5.L >> 5;
R6.H = R6.L >> 5;
R7.H = R7.L >> 5;
CHECKREG r0, 0x01002001;
CHECKREG r1, 0x01002001;
CHECKREG r2, 0x01002002;
CHECKREG r3, 0x01002003;
CHECKREG r4, 0x01002004;
CHECKREG r5, 0x07FFFFFF;
CHECKREG r6, 0x00000006;
CHECKREG r7, 0x00000007;


imm32 r0, 0x30001001;
imm32 r1, 0x30001001;
imm32 r1, 0x30002002;
imm32 r3, 0x30003003;
imm32 r4, 0x30004004;
imm32 r5, 0x30005005;
R6.L = -15;
imm32 r7, 0x00007007;
R0.H = R0.L >> 15;
R1.H = R1.L >> 15;
R2.H = R2.L >> 15;
R3.H = R3.L >> 15;
R4.H = R4.L >> 15;
R5.H = R5.L >> 15;
R6.H = R6.L >> 15;
R7.H = R7.L >> 15;
CHECKREG r0, 0x00001001;
CHECKREG r1, 0x00002002;
CHECKREG r2, 0x00002002;
CHECKREG r3, 0x00003003;
CHECKREG r4, 0x00004004;
CHECKREG r5, 0x00005005;
CHECKREG r6, 0x0001FFF1;
CHECKREG r7, 0x00007007;

imm32 r0, 0x40001001;
imm32 r1, 0x40002001;
imm32 r2, 0x40002002;
imm32 r3, 0x40003003;
imm32 r4, 0x40004004;
imm32 r5, 0x40005005;
imm32 r6, 0x40006006;
R7.L = -16;
R0.H = R0.L >> 7;
R1.H = R1.L >> 7;
R2.H = R2.L >> 7;
R3.H = R3.L >> 7;
R4.H = R4.L >> 7;
R5.H = R5.L >> 7;
R6.H = R6.L >> 7;
R7.H = R7.L >> 7;
CHECKREG r0, 0x00201001;
CHECKREG r1, 0x00402001;
CHECKREG r2, 0x00402002;
CHECKREG r3, 0x00603003;
CHECKREG r4, 0x00804004;
CHECKREG r5, 0x00A05005;
CHECKREG r6, 0x00C06006;
CHECKREG r7, 0x01FFFFF0;

// RHx by RLx
imm32 r0, 0x50010000;
imm32 r1, 0x50010000;
imm32 r2, 0x50020000;
imm32 r3, 0x50030000;
R4.L = -1;
imm32 r5, 0x50050000;
imm32 r6, 0x50060000;
imm32 r7, 0x50070000;
R0.H = R0.H >> 1;
R1.H = R1.H >> 1;
R2.H = R2.H >> 1;
R3.H = R3.H >> 1;
R4.H = R4.H >> 1;
R5.H = R5.H >> 1;
R6.H = R6.H >> 1;
R7.H = R7.H >> 1;
CHECKREG r0, 0x28000000;
CHECKREG r1, 0x28000000;
CHECKREG r2, 0x28010000;
CHECKREG r3, 0x28010000;
CHECKREG r4, 0x0040FFFF;
CHECKREG r5, 0x28020000;
CHECKREG r6, 0x28030000;
CHECKREG r7, 0x28030000;

imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
imm32 r2, 0x20020000;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
R5.L = -1;
imm32 r6, 0x60060000;
imm32 r7, 0x70070000;
R0.H = R0.H >> 5;
R1.H = R1.H >> 5;
R2.H = R2.H >> 5;
R3.H = R3.H >> 5;
R4.H = R4.H >> 5;
R5.H = R5.H >> 5;
R6.H = R6.H >> 5;
R7.H = R7.H >> 5;
CHECKREG r0, 0x00800000;
CHECKREG r1, 0x00800000;
CHECKREG r2, 0x01000000;
CHECKREG r3, 0x01800000;
CHECKREG r4, 0x02000000;
CHECKREG r5, 0x0140FFFF;
CHECKREG r6, 0x03000000;
CHECKREG r7, 0x03800000;


imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
imm32 r2, 0x20020000;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
R6.L = -15;
imm32 r7, 0x70070000;
R0.L = R0.H >> 6;
R1.L = R1.H >> 6;
R2.L = R2.H >> 6;
R3.L = R3.H >> 6;
R4.L = R4.H >> 6;
R5.L = R5.H >> 6;
R6.L = R6.H >> 6;
R7.L = R7.H >> 6;
CHECKREG r0, 0x10010040;
CHECKREG r1, 0x10010040;
CHECKREG r2, 0x20020080;
CHECKREG r3, 0x300300C0;
CHECKREG r4, 0x40040100;
CHECKREG r5, 0x50050140;
CHECKREG r6, 0x0300000C;
CHECKREG r7, 0x700701C0;

imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
imm32 r2, 0x20020000;
imm32 r2, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
imm32 r6, 0x60060000;
R7.L = -16;
R0.H = R0.H >> 15;
R1.H = R1.H >> 15;
R2.H = R2.H >> 15;
R3.H = R3.H >> 15;
R4.H = R4.H >> 15;
R5.H = R5.H >> 15;
R6.H = R6.H >> 15;
R7.H = R7.H >> 15;
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00000000;
CHECKREG r3, 0x000000C0;
CHECKREG r4, 0x00000000;
CHECKREG r5, 0x00000000;
CHECKREG r6, 0x00000000;
CHECKREG r7, 0x0000FFF0;

pass
