/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMPerformanceNavigation.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPerformanceNavigationPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_PERFORMANCE_NAVIGATION_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_PERFORMANCE_NAVIGATION, WebKitDOMPerformanceNavigationPrivate)

typedef struct _WebKitDOMPerformanceNavigationPrivate {
#if ENABLE(WEB_TIMING)
    RefPtr<WebCore::PerformanceNavigation> coreObject;
#endif // ENABLE(WEB_TIMING)
} WebKitDOMPerformanceNavigationPrivate;

#if ENABLE(WEB_TIMING)

namespace WebKit {

WebKitDOMPerformanceNavigation* kit(WebCore::PerformanceNavigation* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_PERFORMANCE_NAVIGATION(ret);

    return wrapPerformanceNavigation(obj);
}

WebCore::PerformanceNavigation* core(WebKitDOMPerformanceNavigation* request)
{
    return request ? static_cast<WebCore::PerformanceNavigation*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMPerformanceNavigation* wrapPerformanceNavigation(WebCore::PerformanceNavigation* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PERFORMANCE_NAVIGATION(g_object_new(WEBKIT_TYPE_DOM_PERFORMANCE_NAVIGATION, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(WEB_TIMING)

G_DEFINE_TYPE(WebKitDOMPerformanceNavigation, webkit_dom_performance_navigation, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TYPE,
    PROP_REDIRECT_COUNT,
};

static void webkit_dom_performance_navigation_finalize(GObject* object)
{
    WebKitDOMPerformanceNavigationPrivate* priv = WEBKIT_DOM_PERFORMANCE_NAVIGATION_GET_PRIVATE(object);
#if ENABLE(WEB_TIMING)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(WEB_TIMING)
    priv->~WebKitDOMPerformanceNavigationPrivate();
    G_OBJECT_CLASS(webkit_dom_performance_navigation_parent_class)->finalize(object);
}

static void webkit_dom_performance_navigation_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(WEB_TIMING)
    WebKitDOMPerformanceNavigation* self = WEBKIT_DOM_PERFORMANCE_NAVIGATION(object);
    WebCore::PerformanceNavigation* coreSelf = WebKit::core(self);
#endif // ENABLE(WEB_TIMING)
    switch (propertyId) {
    case PROP_TYPE: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint(value, coreSelf->type());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_REDIRECT_COUNT: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint(value, coreSelf->redirectCount());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_performance_navigation_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_performance_navigation_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(WEB_TIMING)
    WebKitDOMPerformanceNavigationPrivate* priv = WEBKIT_DOM_PERFORMANCE_NAVIGATION_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::PerformanceNavigation*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(WEB_TIMING)
    return object;
}

static void webkit_dom_performance_navigation_class_init(WebKitDOMPerformanceNavigationClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMPerformanceNavigationPrivate));
    gobjectClass->constructor = webkit_dom_performance_navigation_constructor;
    gobjectClass->finalize = webkit_dom_performance_navigation_finalize;
    gobjectClass->get_property = webkit_dom_performance_navigation_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_uint("type", /* name */
                                                           "performance_navigation_type", /* short description */
                                                           "read-only  gushort PerformanceNavigation.type", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REDIRECT_COUNT,
                                    g_param_spec_uint("redirect-count", /* name */
                                                           "performance_navigation_redirect-count", /* short description */
                                                           "read-only  gushort PerformanceNavigation.redirect-count", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_performance_navigation_init(WebKitDOMPerformanceNavigation* request)
{
    WebKitDOMPerformanceNavigationPrivate* priv = WEBKIT_DOM_PERFORMANCE_NAVIGATION_GET_PRIVATE(request);
    new (priv) WebKitDOMPerformanceNavigationPrivate();
}

gushort
webkit_dom_performance_navigation_get_redirect_count(WebKitDOMPerformanceNavigation* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_NAVIGATION(self), 0);
    WebCore::PerformanceNavigation* item = WebKit::core(self);
    gushort result = item->redirectCount();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<gushort>(0);
#endif /* ENABLE(WEB_TIMING) */
}

