/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xb3, 0x2a, 0xc3, 0xfb, 0x95, 0x8e, 0x18, 0x0b, 0x24, 0xd6, 0x08, 0xf1,
        0xb1, 0x70, 0xfd, 0xaf, 0x72, 0x3d, 0x2a, 0x7a, 0xa2, 0xb9, 0x62, 0xbe,
        0x6f, 0x58, 0xde, 0x0d, 0x7f, 0x69, 0x41, 0xf8, 0xcc, 0x51, 0x38, 0x57,
        0x87, 0xca, 0xa5, 0x74, 0x2a, 0x84, 0xf1, 0x9a, 0xfa, 0x49, 0xe5, 0x1c,
        0xd4, 0x5c, 0x9b, 0xa2, 0x23, 0xca, 0xb1, 0x36, 0x6d, 0xa6, 0x9a, 0x4c,
        0xa3, 0x03, 0x9b, 0x92, 0xea, 0x84, 0x71, 0x0a, 0xdd, 0x41, 0x6c, 0x9e,
        0x56, 0x65, 0x31, 0x5d, 0x4a, 0x71, 0x74, 0x13, 0xb3, 0x07, 0x6b, 0xc6,
        0xc5, 0x64, 0x73, 0x1d, 0x22, 0xc1, 0xc9, 0x2f, 0x5d, 0xb3, 0x61, 0xc6,
        0xb8, 0xc3, 0x29, 0x2c, 0xd9, 0x35, 0x20, 0x5e, 0xa8, 0x7c, 0x63, 0xc0,
        0x07, 0xa8, 0x8e, 0x5a, 0x96, 0x33, 0x49, 0xb3, 0xfe, 0xaa, 0x05, 0xfe,
        0xc1, 0xeb, 0x8b, 0x34, 0x8b, 0x15, 0xf5, 0xc9, 0xe9, 0xbd, 0xd5, 0xca,
        0x47, 0x12, 0xb8, 0x4f, 0xfb, 0x5c, 0x76, 0xa5, 0x72, 0x17, 0xd8, 0xa1,
        0xbe, 0xbd, 0x4e, 0xa2, 0x86, 0x0f, 0x80, 0xb7, 0x98, 0x61, 0x4f, 0x3d,
        0x5f, 0x03, 0x54, 0x7c, 0xf4, 0x3d, 0x41, 0x5e, 0xd2, 0xf1, 0xa9, 0xbb,
        0xb5, 0x1a, 0x49, 0x48, 0x6f, 0xf6, 0x9c, 0x44, 0x99, 0xff, 0x73, 0x01,
        0x29, 0x52, 0xb7, 0xc3, 0xe1, 0x43, 0x51, 0xce, 0xef, 0xd5, 0x77, 0xf5,
        0x0b, 0x50, 0x20, 0x70, 0xee, 0x11, 0xe1, 0x88, 0x83, 0x4e, 0x89, 0x69,
        0xcd, 0x13, 0x22, 0x00, 0x68, 0x93, 0x53, 0xdb, 0x97, 0xc3, 0xb2, 0x38,
        0x82, 0x41, 0x7f, 0x4a, 0x53, 0xc5, 0x11, 0xdb, 0xed, 0x4c, 0xa8, 0x04,
        0x8a, 0x5e, 0x2d, 0x9a, 0x7f, 0xb7, 0x14, 0x44, 0x91, 0x75, 0x73, 0xc6,
        0x9c, 0xd4, 0x24, 0xea, 0xd5, 0x41, 0xc7, 0x81, 0x7c, 0x41, 0x88, 0x48,
        0x1a, 0x7f, 0x80, 0xff
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.66 */
